# Alergia - Paciente Nacional - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alergia - Paciente Nacional**

## Example AllergyIntolerance: Alergia - Paciente Nacional

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**clinicalStatus**: Activa

**verificationStatus**: Confirmada

**type**: Allergy

**category**: Medication

**criticality**: Low Risk

**code**: agente perfluoroquímico

**patient**: [MARIA JOSE ARRIETA GUZMAN](Patient-98015.md)

**onset**: 2025-01-12 19:30:45+0000

**recorder**: [Practitioner MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)

### Reactions

| | | |
| :--- | :--- | :--- |
| - | **Manifestation** | **Severity** |
| * | angioedema | Moderate |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "4070",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Activa"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmada"
  },
  "type" : "allergy",
  "category" : ["medication"],
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/substances-code",
        "code" : "294851004",
        "display" : "agente perfluoroquímico"
      }
    ],
    "text" : "agente perfluoroquímico"
  },
  "patient" : {
    "reference" : "Patient/98015",
    "display" : "MARIA JOSE ARRIETA GUZMAN"
  },
  "onsetDateTime" : "2025-01-12T19:30:45Z",
  "recorder" : {
    "reference" : "Practitioner/3092"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/manifestations-code",
              "code" : "41291007",
              "display" : "angioedema"
            }
          ],
          "text" : "angioedema"
        }
      ],
      "severity" : "moderate"
    }
  ]
}

```
