# Bundle - Prescripción Antimicrobianos - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle - Prescripción Antimicrobianos**

## Example Bundle: Bundle - Prescripción Antimicrobianos

Profile: [Paquete de Recursos](StructureDefinition-bundle.md)

Bundle BundleRD03 of type transaction

-------

Entry 1 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Practitioner/3092

Rec}:

> **identifier**: Cédula Física/112110419 (use: official, )**name**: MARIA JOSE ARRIETA GUZMAN**telecom**: ph: 8665-1234,[dra.arrieta@nuevamentecr.com](mailto:dra.arrieta@nuevamentecr.com)**gender**: Female**birthDate**: 1984-07-14**address**: Lourdes, Montes de Oca

Request:

```
POST Practitioner

```

-------

Entry 2 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Patient/98015

Rec}:

> JEFFREY ALEJANDRO ARRIETA GUZMAN Male, DoB: 1985-01-12 ( Cédula Física: 112300555 (use: official, ))
-------

Request:

```
POST Patient

```

-------

Entry 3 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationRequest/2377815

Rec}:

> **Tipo de receta**: ATM**groupIdentifier**: 35DF488B05**status**: Completed**intent**: Order**category**:Empírica**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**encounter**:[Encounter](Encounter-111766.md)**supportingInformation**:
* [AllergyIntolerance](AllergyIntolerance-4070.md)
* [Observation(Cultivo)](Observation-271.md)
* [Observation(Panel Gram(-))](Observation-125.md)
* [Observation(Panel Gram(+))](Observation-521.md)
**authoredOn**: 2025-05-27 21:53:25+0000**requester**:[MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)**note**:
> 

.


> **dosageInstruction****text**: .**timing**: Duration 7days , Once per 7 days**route**:Oral

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 5 mL |


> **dispenseRequest****validityPeriod**: 2025-05-28 21:17:03+0000 --> 2025-06-04 21:17:03+0000**numberOfRepeatsAllowed**: 1**quantity**: 70 .

### ExpectedSupplyDurations

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Unit** |
| * | 7 | days |



Request:

```
POST MedicationRequest

```

-------

Entry 4 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationStatement/108729

Rec}:

> **status**: active**status**: recorded**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-29 09:17:03+0000

Request:

```
POST MedicationStatement

```

-------

Entry 5 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/AllergyIntolerance/4070

Rec}:

> **clinicalStatus**:Activa**verificationStatus**:Confirmada**type**:Allergy**category**: Medication**criticality**: Low Risk**code**:agente perfluoroquímico**patient**:[MARIA JOSE ARRIETA GUZMAN](Patient-98015.md)**onset**: 2025-01-12 19:30:45+0000

### Reactions

| | | |
| :--- | :--- | :--- |
| - | **Manifestation** | **Severity** |
| * | No display for AllergyIntolerance.reaction.manifestation (concept: angioedema) | Moderate |


Request:

```
POST AllergyIntolerance

```

-------

Entry 6 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Encounter/111766

Rec}:

> **status**: completed**class**:Ambulatory**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**serviceProvider**:[Consultorio Particular de MARIA JOSE ARRIETA](Organization-3092.md)
> **participant**

Request:

```
POST Encounter

```

-------

Entry 7 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/2722

Rec}:

> **status**: Final**category**:Taking patient vital signs (procedure)**code**:Peso**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-12 19:25:59+0000**value**: 80 kg

Request:

```
POST Observation

```

-------

Entry 8 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/268

Rec}:

> **status**: Final**category**:hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)**code**:Frotis**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-31 18:05:17+0000**value**:Cocos Gram Positivos

Request:

```
POST Observation

```

-------

Entry 9 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/271

Rec}:

> **status**: Final**category**:hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)**code**:Cultivo**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-12 19:25:59+0000

### Components

| | |
| :--- | :--- |
| - | **Code** |
| * | Escherichia coli |


Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/125

Rec}:

> **status**: Final**category**:hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)**code**:negativo Panel Gram(-)**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-14 18:31:44+0000

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Ceftriaxona | sensitive |


Request:

```
POST Observation

```

-------

Entry 11 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/521

Rec}:

> **status**: Final**category**:hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)**code**:positivo Panel Gram(+)**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-14 18:31:44+0000

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Ampicilina (Enterococcus spp, S. agalactiae) | medium |


Request:

```
POST Observation

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "BundleRD03",
  "meta" : {
    "profile" : [
      "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
    ]
  },
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Practitioner/3092",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "3092",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_3092\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 3092</b></p><a name=\"3092\"> </a><a name=\"hc3092\"> </a><p><b>identifier</b>: Cédula Física/112110419 (use: official, )</p><p><b>name</b>: MARIA JOSE ARRIETA GUZMAN</p><p><b>telecom</b>: ph: 8665-1234, <a href=\"mailto:dra.arrieta@nuevamentecr.com\">dra.arrieta@nuevamentecr.com</a></p><p><b>address</b>: Lourdes, Montes de Oca</p><p><b>gender</b>: Female</p><p><b>birthDate</b>: 1984-07-14</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
                  "code" : "1",
                  "display" : "Cédula Física"
                }
              ],
              "text" : "Cédula Física"
            },
            "value" : "112110419"
          }
        ],
        "name" : [
          {
            "text" : "MARIA JOSE ARRIETA GUZMAN",
            "family" : "ARRIETA GUZMAN",
            "given" : ["MARIA JOSE"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "8665-1234"
          },
          {
            "system" : "email",
            "value" : "dra.arrieta@nuevamentecr.com"
          }
        ],
        "address" : [
          {
            "text" : "Lourdes, Montes de Oca",
            "city" : "MONTES DE OCA",
            "district" : "LOURDES",
            "state" : "SAN JOSÉ",
            "country" : "Costa Rica"
          }
        ],
        "gender" : "female",
        "birthDate" : "1984-07-14"
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Patient/98015",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "98015",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_98015\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 98015</b></p><a name=\"98015\"> </a><a name=\"hc98015\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">JEFFREY ALEJANDRO ARRIETA GUZMAN Male, DoB: 1985-01-12 ( Cédula Física: 112300555 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 87077072</li><li><a href=\"mailto:jeff.esquivel@gmail.com\">jeff.esquivel@gmail.com</a></li><li>Sabanilla</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Practitioner-3092.html\">MARIA JOSE ARRIETA GUZMAN</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
                  "code" : "1",
                  "display" : "Cédula Física"
                }
              ],
              "text" : "Cédula Física"
            },
            "value" : "112300555"
          }
        ],
        "name" : [
          {
            "text" : "JEFFREY ALEJANDRO ARRIETA GUZMAN",
            "family" : "ESQUIVEL SIBAJA",
            "given" : ["JEFFREY ALEJANDRO"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "87077072"
          },
          {
            "system" : "email",
            "value" : "jeff.esquivel@gmail.com"
          }
        ],
        "gender" : "male",
        "birthDate" : "1985-01-12",
        "address" : [
          {
            "text" : "Sabanilla",
            "city" : "MONTES DE OCA",
            "district" : "SABANILLA",
            "state" : "SAN JOSÉ",
            "country" : "Costa Rica"
          }
        ],
        "generalPractitioner" : [
          {
            "reference" : "Practitioner/3092",
            "display" : "MARIA JOSE ARRIETA GUZMAN"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationRequest/2377815",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "2377815",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_2377815\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 2377815</b></p><a name=\"2377815\"> </a><a name=\"hc2377815\"> </a><p><b>Tipo de receta</b>: ATM</p><p><b>status</b>: Completed</p><p><b>intent</b>: Order</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/prescription-categories-code empirica}\">Empírica</span></p><p><b>medication</b>: <a href=\"Medication-1053.html\">AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)</a></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>encounter</b>: <a href=\"Encounter-111766.html\">Encounter</a></p><p><b>supportingInformation</b>: </p><ul><li><a href=\"AllergyIntolerance-4070.html\">AllergyIntolerance</a></li><li><a href=\"Observation-271.html\">Observation(Cultivo)</a></li><li><a href=\"Observation-125.html\">Observation(Panel Gram(-))</a></li><li><a href=\"Observation-521.html\">Observation(Panel Gram(+))</a></li></ul><p><b>authoredOn</b>: 2025-05-27 21:53:25+0000</p><p><b>requester</b>: <a href=\"Practitioner-3092.html\">MARIA JOSE ARRIETA GUZMAN</a></p><p><b>reasonReference</b>: <a href=\"Condition-6283.html\">J03 Amigdalitis agud</a></p><p><b>groupIdentifier</b>: 35DF488B05</p><p><b>note</b>: </p><blockquote><div><p>.</p>\n</div></blockquote><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: .</p><p><b>timing</b>: Duration 7days , Once per 7 days</p><p><b>route</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code PO}\">Oral</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>5 mL</td></tr></table></blockquote><blockquote><p><b>dispenseRequest</b></p><p><b>validityPeriod</b>: 2025-05-28 21:17:03+0000 --&gt; 2025-06-04 21:17:03+0000</p><p><b>numberOfRepeatsAllowed</b>: 1</p><p><b>quantity</b>: 70 .</p><h3>ExpectedSupplyDurations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Unit</b></td></tr><tr><td style=\"display: none\">*</td><td>7</td><td>days</td></tr></table></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type",
            "valueString" : "ATM"
          }
        ],
        "status" : "completed",
        "intent" : "order",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/prescription-categories-code",
                "code" : "empirica",
                "display" : "Empírica"
              }
            ],
            "text" : "Empírica"
          }
        ],
        "medicationReference" : {
          "reference" : "Medication/1053",
          "display" : "AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "encounter" : {
          "reference" : "Encounter/111766",
          "display" : "Encounter"
        },
        "supportingInformation" : [
          {
            "reference" : "AllergyIntolerance/4070",
            "display" : "AllergyIntolerance"
          },
          {
            "reference" : "Observation/271",
            "display" : "Observation(Cultivo)"
          },
          {
            "reference" : "Observation/125",
            "display" : "Observation(Panel Gram(-))"
          },
          {
            "reference" : "Observation/521",
            "display" : "Observation(Panel Gram(+))"
          }
        ],
        "authoredOn" : "2025-05-27T21:53:25.000Z",
        "requester" : {
          "reference" : "Practitioner/3092",
          "display" : "MARIA JOSE ARRIETA GUZMAN"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/6283",
            "display" : "J03 Amigdalitis agud"
          }
        ],
        "groupIdentifier" : {
          "value" : "35DF488B05"
        },
        "note" : [
          {
            "text" : "."
          }
        ],
        "dosageInstruction" : [
          {
            "text" : ".",
            "timing" : {
              "repeat" : {
                "duration" : 7,
                "durationUnit" : "d",
                "frequency" : 1,
                "period" : 7,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code",
                  "code" : "PO",
                  "display" : "Oral"
                }
              ],
              "text" : "Oral"
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 5,
                  "unit" : "mL"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2025-05-28T21:17:03.000Z",
            "end" : "2025-06-04T21:17:03.000Z"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 70,
            "unit" : "."
          },
          "expectedSupplyDuration" : {
            "value" : 7,
            "unit" : "days"
          }
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationRequest"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationStatement/108729",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "108729",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_108729\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 108729</b></p><a name=\"108729\"> </a><a name=\"hc108729\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Medication-1053.html\">AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)</a></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>context</b>: <a href=\"Encounter-111766.html\">Encounter</a></p><p><b>effective</b>: 2025-05-29 09:17:03+0000</p></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/1053",
          "display" : "AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "context" : {
          "reference" : "Encounter/111766",
          "display" : "Encounter"
        },
        "effectiveDateTime" : "2025-05-29T09:17:03Z"
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationStatement"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/AllergyIntolerance/4070",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "4070",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_4070\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 4070</b></p><a name=\"4070\"> </a><a name=\"hc4070\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Activa</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmada</span></p><p><b>type</b>: Allergy</p><p><b>category</b>: Medication</p><p><b>criticality</b>: Low Risk</p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/substances-code 294851004}\">agente perfluoroquímico</span></p><p><b>patient</b>: <a href=\"Patient-98015.html\">MARIA JOSE ARRIETA GUZMAN</a></p><p><b>onset</b>: 2025-01-12 19:30:45+0000</p><p><b>recorder</b>: <a href=\"Practitioner-3092.html\">Practitioner MARIA JOSE ARRIETA GUZMAN</a></p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td><td><b>Severity</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/manifestations-code 41291007}\">angioedema</span></td><td>Moderate</td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Activa"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmada"
        },
        "type" : "allergy",
        "category" : ["medication"],
        "criticality" : "low",
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/substances-code",
              "code" : "294851004",
              "display" : "agente perfluoroquímico"
            }
          ],
          "text" : "agente perfluoroquímico"
        },
        "patient" : {
          "reference" : "Patient/98015",
          "display" : "MARIA JOSE ARRIETA GUZMAN"
        },
        "onsetDateTime" : "2025-01-12T19:30:45Z",
        "recorder" : {
          "reference" : "Practitioner/3092"
        },
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/manifestations-code",
                    "code" : "41291007",
                    "display" : "angioedema"
                  }
                ],
                "text" : "angioedema"
              }
            ],
            "severity" : "moderate"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "AllergyIntolerance"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Encounter/111766",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "111766",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_111766\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter 111766</b></p><a name=\"111766\"> </a><a name=\"hc111766\"> </a><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode AMB</a>: Ambulatory</p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-3092.html\">MARIA JOSE ARRIETA GUZMAN</a></td></tr></table><p><b>period</b>: 2025-05-27 09:53:25+0000 --&gt; (ongoing)</p><p><b>serviceProvider</b>: <a href=\"Organization-3092.html\">Consultorio Particular de MARIA JOSE ARRIETA</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "Ambulatory"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/3092",
              "display" : "MARIA JOSE ARRIETA GUZMAN"
            }
          }
        ],
        "period" : {
          "start" : "2025-05-27T09:53:25Z"
        },
        "serviceProvider" : {
          "reference" : "Organization/3092",
          "display" : "Consultorio Particular de MARIA JOSE ARRIETA"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Encounter"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/2722",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "2722",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_2722\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 2722</b></p><a name=\"2722\"> </a><a name=\"hc2722\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 61746007}\">Taking patient vital signs (procedure)</span></p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 27113001}\">Peso</span></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>effective</b>: 2025-05-12 19:25:59+0000</p><p><b>value</b>: 80 kg</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
                "code" : "61746007",
                "display" : "Taking patient vital signs (procedure)"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
              "code" : "27113001",
              "display" : "Body Weight"
            }
          ],
          "text" : "Peso"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "effectiveDateTime" : "2025-05-12T19:25:59Z",
        "valueQuantity" : {
          "value" : 80,
          "unit" : "kg"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/268",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "268",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_268\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 268</b></p><a name=\"268\"> </a><a name=\"hc268\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 104177005}\">hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)</span></p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code frotis}\">Frotis</span></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>effective</b>: 2025-05-31 18:05:17+0000</p><p><b>value</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-family-code CGP}\">Cocos Gram Positivos</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
                "code" : "104177005",
                "display" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
              }
            ],
            "text" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code",
              "code" : "frotis",
              "display" : "Frotis"
            }
          ],
          "text" : "Frotis"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "effectiveDateTime" : "2025-05-31T18:05:17Z",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-family-code",
              "code" : "CGP",
              "display" : "Cocos Gram Positivos"
            }
          ],
          "text" : "Cocos Gram Positivos"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/271",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "271",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_271\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 271</b></p><a name=\"271\"> </a><a name=\"hc271\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 104177005}\">hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)</span></p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code cultivo}\">Cultivo</span></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>effective</b>: 2025-05-12 19:25:59+0000</p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/microorganism-code 487}\">Escherichia coli</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
                "code" : "104177005",
                "display" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
              }
            ],
            "text" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code",
              "code" : "cultivo",
              "display" : "Cultivo"
            }
          ],
          "text" : "Cultivo"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "effectiveDateTime" : "2025-05-12T19:25:59Z",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/microorganism-code",
                  "code" : "487",
                  "display" : "Escherichia coli"
                }
              ],
              "text" : "Escherichia coli"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/125",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "125",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_125\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 125</b></p><a name=\"125\"> </a><a name=\"hc125\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 104177005}\">hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)</span></p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code gram_negativo}\">negativo Panel Gram(-)</span></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>effective</b>: 2025-05-14 18:31:44+0000</p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-negatives-code CEFTRIAXONA}\">Ceftriaxona</span></td><td>sensitive</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
                "code" : "104177005",
                "display" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
              }
            ],
            "text" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code",
              "code" : "gram_negativo",
              "display" : "negativo Panel Gram(-)"
            }
          ],
          "text" : "negativo Panel Gram(-)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "effectiveDateTime" : "2025-05-14T18:31:44Z",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-negatives-code",
                  "code" : "CEFTRIAXONA",
                  "display" : "Ceftriaxona"
                }
              ],
              "text" : "Ceftriaxona"
            },
            "valueString" : "sensitive"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Observation/521",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "521",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_521\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 521</b></p><a name=\"521\"> </a><a name=\"hc521\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code 104177005}\">hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)</span></p><p><b>code</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code gram_positivo}\">positivo Panel Gram(+)</span></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>effective</b>: 2025-05-14 18:31:44+0000</p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-positives-code AMPICILINA}\">Ampicilina (Enterococcus spp, S. agalactiae)</span></td><td>medium</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/snomed-code",
                "code" : "104177005",
                "display" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
              }
            ],
            "text" : "hemocultivo para detección de bacterias y organismos anaerobios (procedimiento)"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/analysis-types-code",
              "code" : "gram_positivo",
              "display" : "positivo Panel Gram(+)"
            }
          ],
          "text" : "positivo Panel Gram(+)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "effectiveDateTime" : "2025-05-14T18:31:44Z",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-positives-code",
                  "code" : "AMPICILINA",
                  "display" : "Ampicilina (Enterococcus spp, S. agalactiae)"
                }
              ],
              "text" : "Ampicilina (Enterococcus spp, S. agalactiae)"
            },
            "valueString" : "medium"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    }
  ]
}

```
