# Cátalogo nacional de distritos - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cátalogo nacional de distritos**

## CodeSystem: Cátalogo nacional de distritos 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/districts-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:DistrictsCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Cátalogo nacional de distritos en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [District](ValueSet-District.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "districts-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/districts-code",
  "version" : "1.1.0-ballot",
  "name" : "DistrictsCode",
  "title" : "Cátalogo nacional de distritos",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Cátalogo nacional de distritos en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 733,
  "concept" : [
    {
      "code" : "10205",
      "display" : "GUACHIPELIN"
    },
    {
      "code" : "10206",
      "display" : "CARMEN"
    },
    {
      "code" : "10208",
      "display" : "HLE. MAGDALA"
    },
    {
      "code" : "20610",
      "display" : "BARRANCA"
    },
    {
      "code" : "20214",
      "display" : "SAN LORENZO"
    },
    {
      "code" : "11912",
      "display" : "LA AMISTAD"
    },
    {
      "code" : "20401",
      "display" : "SAN MATEO"
    },
    {
      "code" : "20201",
      "display" : "SAN RAMÓN"
    },
    {
      "code" : "20202",
      "display" : "SANTIAGO"
    },
    {
      "code" : "20205",
      "display" : "PIEDADES SUR"
    },
    {
      "code" : "20208",
      "display" : "ÁNGELES"
    },
    {
      "code" : "20211",
      "display" : "CONCEPCIÓN"
    },
    {
      "code" : "21301",
      "display" : "UPALA"
    },
    {
      "code" : "21304",
      "display" : "BIJAGUA"
    },
    {
      "code" : "21306",
      "display" : "DOS RIOS"
    },
    {
      "code" : "21202",
      "display" : "SARCHI SUR"
    },
    {
      "code" : "21205",
      "display" : "RODRIGUEZ"
    },
    {
      "code" : "30603",
      "display" : "CAPELLADES"
    },
    {
      "code" : "30103",
      "display" : "CARMEN"
    },
    {
      "code" : "30105",
      "display" : "AGUACALIENTE (SAN FRANCISCO)"
    },
    {
      "code" : "30108",
      "display" : "TIERRA BLANCA"
    },
    {
      "code" : "30111",
      "display" : "QUEBRADILLA"
    },
    {
      "code" : "30801",
      "display" : "TEJAR"
    },
    {
      "code" : "30804",
      "display" : "PATIO DE AGUA"
    },
    {
      "code" : "30403",
      "display" : "PEJIBAYE"
    },
    {
      "code" : "30303",
      "display" : "SAN JUAN"
    },
    {
      "code" : "30306",
      "display" : "DULCE NOMBRE"
    },
    {
      "code" : "70103",
      "display" : "RIO BLANCO"
    },
    {
      "code" : "70502",
      "display" : "BATAN"
    },
    {
      "code" : "70202",
      "display" : "JIMENEZ"
    },
    {
      "code" : "70204",
      "display" : "ROXANA"
    },
    {
      "code" : "70301",
      "display" : "SIQUIRRES"
    },
    {
      "code" : "70304",
      "display" : "GERMANIA"
    },
    {
      "code" : "70402",
      "display" : "SIXAOLA"
    },
    {
      "code" : "60601",
      "display" : "QUEPOS"
    },
    {
      "code" : "60301",
      "display" : "BUENOS AIRES"
    },
    {
      "code" : "60304",
      "display" : "BORUCA"
    },
    {
      "code" : "60307",
      "display" : "CHANGUENA"
    },
    {
      "code" : "61001",
      "display" : "CORREDOR"
    },
    {
      "code" : "61004",
      "display" : "LAUREL"
    },
    {
      "code" : "21504",
      "display" : "KATIRA"
    },
    {
      "code" : "30703",
      "display" : "POTRERO CERRADO"
    },
    {
      "code" : "30202",
      "display" : "SANTIAGO"
    },
    {
      "code" : "30502",
      "display" : "LA SUIZA"
    },
    {
      "code" : "30506",
      "display" : "PAVONES"
    },
    {
      "code" : "30511",
      "display" : "LA ISABEL"
    },
    {
      "code" : "50702",
      "display" : "LA SIERRA"
    },
    {
      "code" : "50403",
      "display" : "MOGOTE"
    },
    {
      "code" : "50503",
      "display" : "SARDINAL"
    },
    {
      "code" : "50604",
      "display" : "BEBEDERO"
    },
    {
      "code" : "51104",
      "display" : "HUACAS"
    },
    {
      "code" : "50101",
      "display" : "LIBERIA"
    },
    {
      "code" : "50105",
      "display" : "CURUBANDE"
    },
    {
      "code" : "50905",
      "display" : "PORVENIR"
    },
    {
      "code" : "50204",
      "display" : "QUEBRADA HONDA"
    },
    {
      "code" : "50302",
      "display" : "BOLSON"
    },
    {
      "code" : "50305",
      "display" : "CARTAGENA"
    },
    {
      "code" : "50308",
      "display" : "CABO VELAS"
    },
    {
      "code" : "50804",
      "display" : "SANTA ROSA"
    },
    {
      "code" : "40201",
      "display" : "BARVA"
    },
    {
      "code" : "40206",
      "display" : "SAN JOSE DE LA MONTAÑA"
    },
    {
      "code" : "40801",
      "display" : "SAN JOAQUÍN"
    },
    {
      "code" : "40103",
      "display" : "SAN FRANCISCO"
    },
    {
      "code" : "40602",
      "display" : "SAN JOSE"
    },
    {
      "code" : "40501",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "40505",
      "display" : "CONCEPCION"
    },
    {
      "code" : "40404",
      "display" : "JESUS"
    },
    {
      "code" : "40406",
      "display" : "PURABA"
    },
    {
      "code" : "40304",
      "display" : "PARACITO"
    },
    {
      "code" : "41001",
      "display" : "PUERTO VIEJO"
    },
    {
      "code" : "410012",
      "display" : "PUEBLO NUEVO"
    },
    {
      "code" : "410016",
      "display" : "FINCA DIEZ"
    },
    {
      "code" : "410020",
      "display" : "CERRO NEGRO(PARTE SUR)"
    },
    {
      "code" : "410021",
      "display" : "ZAPOTE"
    },
    {
      "code" : "410025",
      "display" : "LAS MARÍAS"
    },
    {
      "code" : "410030",
      "display" : "LA CHAVES"
    },
    {
      "code" : "410034",
      "display" : "GUARIA"
    },
    {
      "code" : "410037",
      "display" : "LA ALDEA"
    },
    {
      "code" : "410041",
      "display" : "NARANJAL"
    },
    {
      "code" : "410042",
      "display" : "SANTA DELIA"
    },
    {
      "code" : "70602",
      "display" : "MERCEDES"
    },
    {
      "code" : "20102",
      "display" : "SAN JOSÉ"
    },
    {
      "code" : "20106",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "20111",
      "display" : "TURRÚCARES"
    },
    {
      "code" : "20114",
      "display" : "SARAPIQUÍ"
    },
    {
      "code" : "21101",
      "display" : "ZARCERO"
    },
    {
      "code" : "21103",
      "display" : "TAPEZCO"
    },
    {
      "code" : "21105",
      "display" : "PALMIRA"
    },
    {
      "code" : "21107",
      "display" : "BRISAS"
    },
    {
      "code" : "20502",
      "display" : "JESÚS"
    },
    {
      "code" : "20504",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "20506",
      "display" : "SAN JOSÉ"
    },
    {
      "code" : "20507",
      "display" : "SANTA EULALIA"
    },
    {
      "code" : "20301",
      "display" : "GRECIA"
    },
    {
      "code" : "20303",
      "display" : "SAN JOSE"
    },
    {
      "code" : "20305",
      "display" : "TACARES"
    },
    {
      "code" : "20307",
      "display" : "PUENTE DE PIEDRA"
    },
    {
      "code" : "21501",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "21503",
      "display" : "COTE"
    },
    {
      "code" : "21402",
      "display" : "CAÑO NEGRO"
    },
    {
      "code" : "21404",
      "display" : "SAN JORGE"
    },
    {
      "code" : "20601",
      "display" : "NARANJO"
    },
    {
      "code" : "20603",
      "display" : "SAN ANTONIO DE LA CUEVA"
    },
    {
      "code" : "20605",
      "display" : "SAN MIGUEL"
    },
    {
      "code" : "20607",
      "display" : "CONCEPCION ESTE"
    },
    {
      "code" : "20902",
      "display" : "MASTATE"
    },
    {
      "code" : "20904",
      "display" : "COYOLAR"
    },
    {
      "code" : "20701",
      "display" : "PALMARES"
    },
    {
      "code" : "20703",
      "display" : "BUENOS AIRES"
    },
    {
      "code" : "20705",
      "display" : "CANDELARIA"
    },
    {
      "code" : "20707",
      "display" : "GRANJA"
    },
    {
      "code" : "20802",
      "display" : "SAN JUAN"
    },
    {
      "code" : "20803",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "20805",
      "display" : "SABANA REDONDA"
    },
    {
      "code" : "21003",
      "display" : "BUENAVISTA"
    },
    {
      "code" : "21006",
      "display" : "PITAL"
    },
    {
      "code" : "21009",
      "display" : "PALMERA"
    },
    {
      "code" : "21012",
      "display" : "MONTERREY"
    },
    {
      "code" : "21602",
      "display" : "SANTA ISABEL"
    },
    {
      "code" : "60801",
      "display" : "SAN VITO"
    },
    {
      "code" : "60804",
      "display" : "LIMONCITO"
    },
    {
      "code" : "60201",
      "display" : "ESPIRITU SANTO"
    },
    {
      "code" : "60203",
      "display" : "MACACONA"
    },
    {
      "code" : "60206",
      "display" : "CALDERA"
    },
    {
      "code" : "61102",
      "display" : "TÁRCOLES"
    },
    {
      "code" : "60704",
      "display" : "PAVON"
    },
    {
      "code" : "60403",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "60503",
      "display" : "SIERPE"
    },
    {
      "code" : "60901",
      "display" : "PARRITA"
    },
    {
      "code" : "60101",
      "display" : "PUNTARENAS"
    },
    {
      "code" : "60104",
      "display" : "LEPANTO"
    },
    {
      "code" : "60107",
      "display" : "GUACIMAL"
    },
    {
      "code" : "60110",
      "display" : "ISLA DEL COCO"
    },
    {
      "code" : "60114",
      "display" : "ACAPULCO"
    },
    {
      "code" : "11201",
      "display" : "SAN IGNACIO DE ACOSTA"
    },
    {
      "code" : "11204",
      "display" : "CANGREJAL"
    },
    {
      "code" : "11002",
      "display" : "SAN JOSECITO"
    },
    {
      "code" : "11005",
      "display" : "SAN FELIPE"
    },
    {
      "code" : "10601",
      "display" : "ASERRÍ"
    },
    {
      "code" : "10604",
      "display" : "SAN GABRIEL"
    },
    {
      "code" : "10607",
      "display" : "SALITRILLOS"
    },
    {
      "code" : "11803",
      "display" : "SÁNCHEZ"
    },
    {
      "code" : "10302",
      "display" : "SAN MIGUEL"
    },
    {
      "code" : "10305",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "10307",
      "display" : "PATARRA"
    },
    {
      "code" : "10310",
      "display" : "DAMAS"
    },
    {
      "code" : "10313",
      "display" : "LOS GUIDO"
    },
    {
      "code" : "11703",
      "display" : "COPEY"
    },
    {
      "code" : "10201",
      "display" : "ESCAZÚ"
    },
    {
      "code" : "10801",
      "display" : "GUADALUPE"
    },
    {
      "code" : "10804",
      "display" : "MATA DE PLÁTANO"
    },
    {
      "code" : "10807",
      "display" : "PURRAL"
    },
    {
      "code" : "12003",
      "display" : "LLANO BONITO"
    },
    {
      "code" : "12006",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "11502",
      "display" : "SABANILLA"
    },
    {
      "code" : "10701",
      "display" : "COLÓN"
    },
    {
      "code" : "10704",
      "display" : "PIEDRAS NEGRAS"
    },
    {
      "code" : "11402",
      "display" : "SAN JERÓNIMO"
    },
    {
      "code" : "11902",
      "display" : "GENERAL"
    },
    {
      "code" : "11904",
      "display" : "RIVAS"
    },
    {
      "code" : "11907",
      "display" : "PEJIBAYE"
    },
    {
      "code" : "11910",
      "display" : "RÍO NUEVO"
    },
    {
      "code" : "10402",
      "display" : "MERCEDES SUR"
    },
    {
      "code" : "10405",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "10408",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "10101",
      "display" : "CARMEN"
    },
    {
      "code" : "10104",
      "display" : "CATEDRAL"
    },
    {
      "code" : "10107",
      "display" : "URUCA"
    },
    {
      "code" : "10109",
      "display" : "PAVAS"
    },
    {
      "code" : "10901",
      "display" : "SANTA ANA"
    },
    {
      "code" : "10904",
      "display" : "URUCA"
    },
    {
      "code" : "10501",
      "display" : "SAN MARCOS"
    },
    {
      "code" : "11301",
      "display" : "SAN JUAN"
    },
    {
      "code" : "11304",
      "display" : "LEON XIII"
    },
    {
      "code" : "11305",
      "display" : "COLIMA"
    },
    {
      "code" : "11603",
      "display" : "SAN JUAN DE MATA"
    },
    {
      "code" : "11101",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "11104",
      "display" : "PATALILLO"
    },
    {
      "code" : "50301",
      "display" : "SANTA CRUZ"
    },
    {
      "code" : "50306",
      "display" : "CUAJINIQUIL"
    },
    {
      "code" : "50802",
      "display" : "QUEBRADA GRANDE"
    },
    {
      "code" : "50807",
      "display" : "ARENAL"
    },
    {
      "code" : "40204",
      "display" : "SAN ROQUE"
    },
    {
      "code" : "40703",
      "display" : "LA ASUNCIÓN"
    },
    {
      "code" : "40101",
      "display" : "HEREDIA"
    },
    {
      "code" : "40601",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "40901",
      "display" : "SAN PABLO"
    },
    {
      "code" : "40503",
      "display" : "SANTIAGO"
    },
    {
      "code" : "40403",
      "display" : "SAN JUAN"
    },
    {
      "code" : "40301",
      "display" : "SANTO DOMINGO"
    },
    {
      "code" : "40306",
      "display" : "SANTA ROSA"
    },
    {
      "code" : "41004",
      "display" : "LLANURAS GASPAR"
    },
    {
      "code" : "410015",
      "display" : "LA RAMBLA"
    },
    {
      "code" : "410019",
      "display" : "COLONIA CUBUJUQUI"
    },
    {
      "code" : "410024",
      "display" : "EL PALMAR"
    },
    {
      "code" : "410028",
      "display" : "SAN BERNARDINO"
    },
    {
      "code" : "410033",
      "display" : "LA CONQUISTA"
    },
    {
      "code" : "410038",
      "display" : "ÁNGELES DE RIO SARAPIQUÍ"
    },
    {
      "code" : "410043",
      "display" : "FINCA AGUA"
    },
    {
      "code" : "70605",
      "display" : "DUACARI"
    },
    {
      "code" : "20103",
      "display" : "CARRIZAL"
    },
    {
      "code" : "20108",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "20112",
      "display" : "TAMBOR"
    },
    {
      "code" : "21002",
      "display" : "FLORENCIA"
    },
    {
      "code" : "21005",
      "display" : "VENECIA"
    },
    {
      "code" : "21008",
      "display" : "TIGRA"
    },
    {
      "code" : "21010",
      "display" : "VENADO"
    },
    {
      "code" : "21013",
      "display" : "POCOSOL"
    },
    {
      "code" : "21603",
      "display" : "SANTA RITA"
    },
    {
      "code" : "60802",
      "display" : "SABALITO"
    },
    {
      "code" : "60202",
      "display" : "SAN JUAN GRANDE"
    },
    {
      "code" : "60205",
      "display" : "SAN JERONIMO"
    },
    {
      "code" : "60703",
      "display" : "GUAYCARA"
    },
    {
      "code" : "60502",
      "display" : "PALMAR"
    },
    {
      "code" : "60505",
      "display" : "PIEDRAS BLANCAS"
    },
    {
      "code" : "60105",
      "display" : "PAQUERA"
    },
    {
      "code" : "60111",
      "display" : "COBANO"
    },
    {
      "code" : "60113",
      "display" : "CHIRA"
    },
    {
      "code" : "11203",
      "display" : "PALMICHAL"
    },
    {
      "code" : "11004",
      "display" : "CONCEPCIÓN"
    },
    {
      "code" : "10602",
      "display" : "TARBACA"
    },
    {
      "code" : "11801",
      "display" : "CURRIDABAT"
    },
    {
      "code" : "11804",
      "display" : "TIRRASES"
    },
    {
      "code" : "10306",
      "display" : "FRAILES"
    },
    {
      "code" : "10312",
      "display" : "GRAVILIAS"
    },
    {
      "code" : "11702",
      "display" : "JARDÍN"
    },
    {
      "code" : "10802",
      "display" : "SAN FRANCISCO"
    },
    {
      "code" : "10805",
      "display" : "IPÍS"
    },
    {
      "code" : "12004",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "11504",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "10703",
      "display" : "TABARCIA"
    },
    {
      "code" : "11901",
      "display" : "SAN ISIDRO DEL GENERAL"
    },
    {
      "code" : "11909",
      "display" : "BARÚ"
    },
    {
      "code" : "11911",
      "display" : "PÁRAMO"
    },
    {
      "code" : "10406",
      "display" : "CANDELARIA"
    },
    {
      "code" : "10409",
      "display" : "CHIRES"
    },
    {
      "code" : "10106",
      "display" : "SAN FRANCISCO DE DOS RÍOS"
    },
    {
      "code" : "10903",
      "display" : "POZOS"
    },
    {
      "code" : "10906",
      "display" : "BRASIL"
    },
    {
      "code" : "11303",
      "display" : "ANSELMO LLORENTE"
    },
    {
      "code" : "11601",
      "display" : "SAN PABLO"
    },
    {
      "code" : "11102",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "10707",
      "display" : "QUITIRRISI"
    },
    {
      "code" : "10207",
      "display" : "BELO HORIZONTE NORTE"
    },
    {
      "code" : "20609",
      "display" : "SAN JOSE"
    },
    {
      "code" : "20612",
      "display" : "CIRRI SUR"
    },
    {
      "code" : "20404",
      "display" : "LABRADOR"
    },
    {
      "code" : "21308",
      "display" : "CANALETE"
    },
    {
      "code" : "20402",
      "display" : "DESMONTE"
    },
    {
      "code" : "20204",
      "display" : "PIEDADES NORTE"
    },
    {
      "code" : "20207",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "20210",
      "display" : "VOLIO"
    },
    {
      "code" : "20213",
      "display" : "PEÑAS BLANCAS"
    },
    {
      "code" : "21303",
      "display" : "SAN JOSE (PIZOTE)"
    },
    {
      "code" : "21307",
      "display" : "YOLIYLLAL"
    },
    {
      "code" : "21203",
      "display" : "TORO AMARILLO"
    },
    {
      "code" : "30601",
      "display" : "PACAYAS"
    },
    {
      "code" : "30101",
      "display" : "ORIENTAL"
    },
    {
      "code" : "30104",
      "display" : "SAN NICOLAS"
    },
    {
      "code" : "30107",
      "display" : "CORRALILLO"
    },
    {
      "code" : "30109",
      "display" : "DULCE NOMBRE"
    },
    {
      "code" : "30803",
      "display" : "TOBOSI"
    },
    {
      "code" : "30402",
      "display" : "TUCURRIQUE"
    },
    {
      "code" : "30302",
      "display" : "SAN DIEGO"
    },
    {
      "code" : "30305",
      "display" : "CONCEPCION"
    },
    {
      "code" : "70102",
      "display" : "VALLE LA ESTRELLA"
    },
    {
      "code" : "70501",
      "display" : "MATINA"
    },
    {
      "code" : "70201",
      "display" : "GUAPILES"
    },
    {
      "code" : "70206",
      "display" : "COLORADO"
    },
    {
      "code" : "70303",
      "display" : "FLORIDA"
    },
    {
      "code" : "70306",
      "display" : "ALEGRIA"
    },
    {
      "code" : "70403",
      "display" : "CAHUITA"
    },
    {
      "code" : "60602",
      "display" : "SAVEGRE"
    },
    {
      "code" : "60302",
      "display" : "VOLCAN"
    },
    {
      "code" : "60305",
      "display" : "PILAS"
    },
    {
      "code" : "60308",
      "display" : "BIOLLEY"
    },
    {
      "code" : "61002",
      "display" : "LA CUESTA"
    },
    {
      "code" : "30307",
      "display" : "SAN RAMON"
    },
    {
      "code" : "30702",
      "display" : "COTE"
    },
    {
      "code" : "30704",
      "display" : "CIPRESES"
    },
    {
      "code" : "30501",
      "display" : "TURRIALBA"
    },
    {
      "code" : "30505",
      "display" : "SANTA TERESITA"
    },
    {
      "code" : "30509",
      "display" : "SANTA ROSA"
    },
    {
      "code" : "50401",
      "display" : "BAGACES"
    },
    {
      "code" : "50502",
      "display" : "PALMIRA"
    },
    {
      "code" : "50601",
      "display" : "CAÑAS"
    },
    {
      "code" : "51101",
      "display" : "HOJANCHA"
    },
    {
      "code" : "51002",
      "display" : "SANTA CECILIA"
    },
    {
      "code" : "50102",
      "display" : "CAÑAS DULCES"
    },
    {
      "code" : "50902",
      "display" : "SANTA RITA"
    },
    {
      "code" : "50201",
      "display" : "NICOYA"
    },
    {
      "code" : "50206",
      "display" : "NOSARA"
    },
    {
      "code" : "50303",
      "display" : "27 DE ABRIL"
    },
    {
      "code" : "50801",
      "display" : "TILARAN"
    },
    {
      "code" : "50805",
      "display" : "LIBANO"
    },
    {
      "code" : "40203",
      "display" : "SAN PABLO"
    },
    {
      "code" : "40701",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "40803",
      "display" : "LLORENTE"
    },
    {
      "code" : "40104",
      "display" : "ULLOA"
    },
    {
      "code" : "40604",
      "display" : "SAN FRANCISCO"
    },
    {
      "code" : "40502",
      "display" : "SAN JOSECITO"
    },
    {
      "code" : "40401",
      "display" : "SANTA BARBARA"
    },
    {
      "code" : "40303",
      "display" : "SAN MIGUEL"
    },
    {
      "code" : "40307",
      "display" : "TURES"
    },
    {
      "code" : "41003",
      "display" : "HORQUETAS"
    },
    {
      "code" : "410013",
      "display" : "CHILAMATE ESTE ALTOS"
    },
    {
      "code" : "410018",
      "display" : "FINCA DOS"
    },
    {
      "code" : "410023",
      "display" : "COLONIA VICTORIA"
    },
    {
      "code" : "410027",
      "display" : "COLONIA VILLALOBOS"
    },
    {
      "code" : "410031",
      "display" : "EL ROBLE"
    },
    {
      "code" : "410036",
      "display" : "HUETARES"
    },
    {
      "code" : "410039",
      "display" : "EL MORTERO"
    },
    {
      "code" : "70601",
      "display" : "GUACIMO"
    },
    {
      "code" : "70604",
      "display" : "RIO JIMENEZ"
    },
    {
      "code" : "20105",
      "display" : "GUÁCIMA"
    },
    {
      "code" : "20109",
      "display" : "RÍO SEGUNDO"
    },
    {
      "code" : "20113",
      "display" : "GARITA"
    },
    {
      "code" : "61201",
      "display" : "MONTEVERDE"
    },
    {
      "code" : "21102",
      "display" : "LAGUNA"
    },
    {
      "code" : "21104",
      "display" : "GUADALUPE"
    },
    {
      "code" : "21106",
      "display" : "ZAPOTE"
    },
    {
      "code" : "20501",
      "display" : "ATENAS"
    },
    {
      "code" : "20503",
      "display" : "MERCEDES"
    },
    {
      "code" : "20505",
      "display" : "CONCEPCIÓN"
    },
    {
      "code" : "20508",
      "display" : "ESCOBAL"
    },
    {
      "code" : "20302",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "30705",
      "display" : "SANTA ROSA"
    },
    {
      "code" : "30203",
      "display" : "OROSI"
    },
    {
      "code" : "30205",
      "display" : "LLANOS DE SANTA LUCIA"
    },
    {
      "code" : "30504",
      "display" : "SANTA CRUZ"
    },
    {
      "code" : "30507",
      "display" : "TUIS"
    },
    {
      "code" : "30510",
      "display" : "TRES EQUIS"
    },
    {
      "code" : "50701",
      "display" : "LAS JUNTAS"
    },
    {
      "code" : "50704",
      "display" : "COLORADO"
    },
    {
      "code" : "50501",
      "display" : "FILADELFIA"
    },
    {
      "code" : "50504",
      "display" : "BELEN"
    },
    {
      "code" : "50605",
      "display" : "POROZAL"
    },
    {
      "code" : "51001",
      "display" : "LA CRUZ"
    },
    {
      "code" : "51004",
      "display" : "SANTA ELENA"
    },
    {
      "code" : "50901",
      "display" : "CARMONA"
    },
    {
      "code" : "50906",
      "display" : "BEJUCO"
    },
    {
      "code" : "50202",
      "display" : "MANSION"
    },
    {
      "code" : "50207",
      "display" : "BELEN DE NOSARITA"
    },
    {
      "code" : "50307",
      "display" : "DIRIA"
    },
    {
      "code" : "50309",
      "display" : "TAMARINDO"
    },
    {
      "code" : "50806",
      "display" : "TIERRAS MORENAS"
    },
    {
      "code" : "40205",
      "display" : "SANTA LUCIA"
    },
    {
      "code" : "40702",
      "display" : "LA RIBERA"
    },
    {
      "code" : "40102",
      "display" : "MERCEDES"
    },
    {
      "code" : "40105",
      "display" : "VARABLANCA"
    },
    {
      "code" : "40902",
      "display" : "RINCON DE SABANILLA"
    },
    {
      "code" : "40402",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "40405",
      "display" : "SANTO DOMINGO"
    },
    {
      "code" : "40305",
      "display" : "SANTO TOMAS"
    },
    {
      "code" : "41002",
      "display" : "LA VIRGEN"
    },
    {
      "code" : "41005",
      "display" : "CUREÑA"
    },
    {
      "code" : "410017",
      "display" : "LOS ARBOLITOS (PARTE ESTE)"
    },
    {
      "code" : "410022",
      "display" : "COLONIA SAN JOSE"
    },
    {
      "code" : "410029",
      "display" : "ESTERO GRANDE"
    },
    {
      "code" : "410035",
      "display" : "FINCA CINCO (CHIRRIPÓ)"
    },
    {
      "code" : "410040",
      "display" : "COLONIA LA GATA"
    },
    {
      "code" : "70603",
      "display" : "POCORA"
    },
    {
      "code" : "20101",
      "display" : "ALAJUELA"
    },
    {
      "code" : "20107",
      "display" : "SABANILLA"
    },
    {
      "code" : "10706",
      "display" : "JARIS"
    },
    {
      "code" : "10204",
      "display" : "BEBEDERO O SAN FRANCISCO"
    },
    {
      "code" : "20611",
      "display" : "SAN ANTONIO DE BARRANCA"
    },
    {
      "code" : "20403",
      "display" : "JESÚS MARÍA"
    },
    {
      "code" : "20203",
      "display" : "SAN JUAN"
    },
    {
      "code" : "20209",
      "display" : "ALFARO"
    },
    {
      "code" : "20212",
      "display" : "ZAPOTAL"
    },
    {
      "code" : "21305",
      "display" : "DELICIAS"
    },
    {
      "code" : "21201",
      "display" : "SARCHI NORTE"
    },
    {
      "code" : "30602",
      "display" : "CERVANTES"
    },
    {
      "code" : "30106",
      "display" : "GUADALUPE (ARENILLA)"
    },
    {
      "code" : "30110",
      "display" : "LLANO GRANDE"
    },
    {
      "code" : "30401",
      "display" : "JUAN VIÑAS"
    },
    {
      "code" : "30304",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "70101",
      "display" : "LIMON"
    },
    {
      "code" : "70503",
      "display" : "CARRANDI"
    },
    {
      "code" : "70205",
      "display" : "CARIARI"
    },
    {
      "code" : "70302",
      "display" : "PACUARITO"
    },
    {
      "code" : "70401",
      "display" : "BRATSI"
    },
    {
      "code" : "60603",
      "display" : "NARANJITO"
    },
    {
      "code" : "60303",
      "display" : "POTRERO GRANDE"
    },
    {
      "code" : "60309",
      "display" : "BRUNKA"
    },
    {
      "code" : "30308",
      "display" : "RIO AZUL"
    },
    {
      "code" : "30701",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "30204",
      "display" : "CACHI"
    },
    {
      "code" : "30508",
      "display" : "TAYUTIC"
    },
    {
      "code" : "30512",
      "display" : "CHIRRIPO"
    },
    {
      "code" : "50404",
      "display" : "RIO NARANJO"
    },
    {
      "code" : "51103",
      "display" : "PUERTO CARRILLO"
    },
    {
      "code" : "51003",
      "display" : "LA GARITA"
    },
    {
      "code" : "50904",
      "display" : "SAN PABLO"
    },
    {
      "code" : "50203",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "20304",
      "display" : "SAN ROQUE"
    },
    {
      "code" : "20306",
      "display" : "RÍO CUARTO"
    },
    {
      "code" : "20308",
      "display" : "BOLIVAR"
    },
    {
      "code" : "21502",
      "display" : "BUENAVISTA"
    },
    {
      "code" : "21401",
      "display" : "LOS CHILES"
    },
    {
      "code" : "21403",
      "display" : "EL AMPARO"
    },
    {
      "code" : "20602",
      "display" : "CANDELARIA"
    },
    {
      "code" : "20604",
      "display" : "SAN JUAN"
    },
    {
      "code" : "20606",
      "display" : "PALMITOS"
    },
    {
      "code" : "20901",
      "display" : "OROTINA"
    },
    {
      "code" : "20903",
      "display" : "HACIENDA VIEJA"
    },
    {
      "code" : "20905",
      "display" : "CEIBA"
    },
    {
      "code" : "20702",
      "display" : "ZARAGOZA"
    },
    {
      "code" : "20704",
      "display" : "SANTIAGO"
    },
    {
      "code" : "20706",
      "display" : "ESQUIPULAS"
    },
    {
      "code" : "20801",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "20804",
      "display" : "CARRILLOS"
    },
    {
      "code" : "21001",
      "display" : "QUESADA"
    },
    {
      "code" : "21004",
      "display" : "AGUAS ZARCAS"
    },
    {
      "code" : "21007",
      "display" : "FORTUNA"
    },
    {
      "code" : "21011",
      "display" : "CUTRIS"
    },
    {
      "code" : "21601",
      "display" : "RIO CUARTO"
    },
    {
      "code" : "60506",
      "display" : "BAHIA DRAKE"
    },
    {
      "code" : "60803",
      "display" : "AGUABUENA"
    },
    {
      "code" : "60806",
      "display" : "GUTIERREZ BROWN"
    },
    {
      "code" : "60204",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "61101",
      "display" : "JACÓ"
    },
    {
      "code" : "60702",
      "display" : "PUERTO JIMENEZ"
    },
    {
      "code" : "60401",
      "display" : "MIRAMAR"
    },
    {
      "code" : "60501",
      "display" : "PUERTO CORTES"
    },
    {
      "code" : "60504",
      "display" : "BAHIA BALLENA"
    },
    {
      "code" : "60103",
      "display" : "CHOMES"
    },
    {
      "code" : "60106",
      "display" : "MANZANILLO"
    },
    {
      "code" : "60109",
      "display" : "MONTEVERDE"
    },
    {
      "code" : "60112",
      "display" : "CHACARITA"
    },
    {
      "code" : "60115",
      "display" : "EL ROBLE"
    },
    {
      "code" : "11202",
      "display" : "GUAITIL"
    },
    {
      "code" : "11205",
      "display" : "SABANILLAS"
    },
    {
      "code" : "11003",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "10603",
      "display" : "VUELTA DE JORCO"
    },
    {
      "code" : "10606",
      "display" : "MONTERREY"
    },
    {
      "code" : "11802",
      "display" : "GRANADILLA"
    },
    {
      "code" : "10301",
      "display" : "DESAMPARADOS"
    },
    {
      "code" : "10304",
      "display" : "SAN RAFAEL ARRIBA"
    },
    {
      "code" : "10308",
      "display" : "SAN CRISTOBAL"
    },
    {
      "code" : "10311",
      "display" : "SAN RAFAEL ABAJO"
    },
    {
      "code" : "11701",
      "display" : "SANTA MARÍA"
    },
    {
      "code" : "10203",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "10803",
      "display" : "CALLE BLANCOS"
    },
    {
      "code" : "10806",
      "display" : "RANCHO REDONDO"
    },
    {
      "code" : "12002",
      "display" : "SAN ANDRÉS"
    },
    {
      "code" : "12005",
      "display" : "SANTA CRUZ"
    },
    {
      "code" : "11503",
      "display" : "MERCEDES"
    },
    {
      "code" : "10702",
      "display" : "GUAYABO"
    },
    {
      "code" : "10705",
      "display" : "PICAGRES"
    },
    {
      "code" : "11403",
      "display" : "TRINIDAD"
    },
    {
      "code" : "11903",
      "display" : "DANIEL FLORES"
    },
    {
      "code" : "11905",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "11908",
      "display" : "CAJÓN"
    },
    {
      "code" : "10401",
      "display" : "SANTIAGO"
    },
    {
      "code" : "10404",
      "display" : "GRIFO ALTO"
    },
    {
      "code" : "10407",
      "display" : "DESAMPARADITOS"
    },
    {
      "code" : "10102",
      "display" : "MERCED"
    },
    {
      "code" : "10105",
      "display" : "ZAPOTE"
    },
    {
      "code" : "10108",
      "display" : "MATA REDONDA"
    },
    {
      "code" : "10110",
      "display" : "HATILLO"
    },
    {
      "code" : "10902",
      "display" : "SALITRAL"
    },
    {
      "code" : "10905",
      "display" : "PIEDADES"
    },
    {
      "code" : "10503",
      "display" : "SAN CARLOS"
    },
    {
      "code" : "11302",
      "display" : "CINCO ESQUINAS"
    },
    {
      "code" : "11602",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "11605",
      "display" : "CARARA"
    },
    {
      "code" : "11103",
      "display" : "DULCE NOMBRE DE JESÚS"
    },
    {
      "code" : "70207",
      "display" : "LA COLONIA"
    },
    {
      "code" : "60805",
      "display" : "PITTIER"
    },
    {
      "code" : "60701",
      "display" : "GOLFITO"
    },
    {
      "code" : "60402",
      "display" : "UNION"
    },
    {
      "code" : "60102",
      "display" : "PITAHAYA"
    },
    {
      "code" : "60108",
      "display" : "BARRANCA"
    },
    {
      "code" : "60116",
      "display" : "ARANCIBIA"
    },
    {
      "code" : "11001",
      "display" : "ALAJUELITA"
    },
    {
      "code" : "10605",
      "display" : "LEGUA"
    },
    {
      "code" : "10303",
      "display" : "SAN JUAN DE DIOS"
    },
    {
      "code" : "10309",
      "display" : "ROSARIO"
    },
    {
      "code" : "10202",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "12001",
      "display" : "SAN PABLO"
    },
    {
      "code" : "11501",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "11401",
      "display" : "SAN VICENTE"
    },
    {
      "code" : "11906",
      "display" : "PLATANARES"
    },
    {
      "code" : "10403",
      "display" : "BARBACOAS"
    },
    {
      "code" : "10103",
      "display" : "HOSPITAL"
    },
    {
      "code" : "10111",
      "display" : "SAN SEBASTIÁN"
    },
    {
      "code" : "10502",
      "display" : "SAN LORENZO"
    },
    {
      "code" : "11604",
      "display" : "SAN LUIS"
    },
    {
      "code" : "11105",
      "display" : "CASCAJAL"
    },
    {
      "code" : "50402",
      "display" : "FORTUNA"
    },
    {
      "code" : "50602",
      "display" : "PALMIRA"
    },
    {
      "code" : "51102",
      "display" : "MONTE ROMO"
    },
    {
      "code" : "50103",
      "display" : "MAYORGA"
    },
    {
      "code" : "50903",
      "display" : "ZAPOTAL"
    },
    {
      "code" : "50205",
      "display" : "SAMARA"
    },
    {
      "code" : "50304",
      "display" : "TEMPATE"
    },
    {
      "code" : "50803",
      "display" : "TRONADORA"
    },
    {
      "code" : "40202",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "40802",
      "display" : "BARRANTES"
    },
    {
      "code" : "40603",
      "display" : "CONCEPCION"
    },
    {
      "code" : "40504",
      "display" : "ANGELES"
    },
    {
      "code" : "40302",
      "display" : "SAN VICENTE"
    },
    {
      "code" : "40308",
      "display" : "PARA"
    },
    {
      "code" : "410014",
      "display" : "SAN JULIÁN"
    },
    {
      "code" : "410026",
      "display" : "GOLFITO"
    },
    {
      "code" : "410032",
      "display" : "TIRIMBINA"
    },
    {
      "code" : "410044",
      "display" : "RANCHO CHILAMATE"
    },
    {
      "code" : "20104",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "20110",
      "display" : "DESAMPARADOS"
    },
    {
      "code" : "20608",
      "display" : "ROSARIO"
    },
    {
      "code" : "61301",
      "display" : "PUERTO JIMENEZ"
    },
    {
      "code" : "20206",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "21302",
      "display" : "AGUAS CLARAS"
    },
    {
      "code" : "21204",
      "display" : "SAN PEDRO"
    },
    {
      "code" : "30102",
      "display" : "OCCIDENTAL"
    },
    {
      "code" : "30802",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "30301",
      "display" : "TRES RIOS"
    },
    {
      "code" : "70104",
      "display" : "MATAMA"
    },
    {
      "code" : "70203",
      "display" : "RITA"
    },
    {
      "code" : "70305",
      "display" : "CAIRO"
    },
    {
      "code" : "70404",
      "display" : "TELIRE"
    },
    {
      "code" : "60306",
      "display" : "COLINAS"
    },
    {
      "code" : "61003",
      "display" : "CANOAS"
    },
    {
      "code" : "30201",
      "display" : "PARAISO"
    },
    {
      "code" : "30503",
      "display" : "PERALTA"
    },
    {
      "code" : "50703",
      "display" : "SAN JUAN"
    },
    {
      "code" : "50603",
      "display" : "SAN MIGUEL"
    },
    {
      "code" : "50104",
      "display" : "NACASCOLO"
    },
    {
      "code" : "10112",
      "display" : "ARANJUEZ"
    },
    {
      "code" : "10113",
      "display" : "BARRIO LUJAN"
    },
    {
      "code" : "10114",
      "display" : "BARRIO MÉXICO"
    },
    {
      "code" : "10115",
      "display" : "COLONIA KENNEDY"
    },
    {
      "code" : "10116",
      "display" : "CÓRDOBA"
    },
    {
      "code" : "10117",
      "display" : "GONZÁLEZ VÍQUEZ"
    },
    {
      "code" : "10118",
      "display" : "NACIONES UNIDAS"
    },
    {
      "code" : "10119",
      "display" : "PASO ANCHO NORTE"
    },
    {
      "code" : "10120",
      "display" : "PASO ANCHO SUR"
    },
    {
      "code" : "10121",
      "display" : "PITAHAYA"
    },
    {
      "code" : "10122",
      "display" : "SAN BOSCO"
    },
    {
      "code" : "10123",
      "display" : "SANTA MARTA"
    },
    {
      "code" : "10209",
      "display" : "GUACHIPELIN (SAN GABRIEL)"
    },
    {
      "code" : "10314",
      "display" : "CALLE FALLAS"
    },
    {
      "code" : "10315",
      "display" : "CHIROGRES"
    },
    {
      "code" : "10316",
      "display" : "C.P. SAN RAFAEL ARRIBA"
    },
    {
      "code" : "10317",
      "display" : "EL PORVENIR"
    },
    {
      "code" : "10318",
      "display" : "FÁTIMA DE DAMAS"
    },
    {
      "code" : "10319",
      "display" : "GUATUSO"
    },
    {
      "code" : "10320",
      "display" : "HIGUITO"
    },
    {
      "code" : "10321",
      "display" : "SAN CRISTÓBAL NORTE"
    },
    {
      "code" : "10322",
      "display" : "SAN CRISTÓBAL SUR"
    },
    {
      "code" : "10323",
      "display" : "SAN LORENZO"
    },
    {
      "code" : "10410",
      "display" : "BARBACOAS (SAN ISIDRO)"
    },
    {
      "code" : "10411",
      "display" : "CANDELARITA"
    },
    {
      "code" : "10412",
      "display" : "CARIT"
    },
    {
      "code" : "10413",
      "display" : "CHARCÓN (RIO VIEJO)"
    },
    {
      "code" : "10414",
      "display" : "CRISTO REY"
    },
    {
      "code" : "10415",
      "display" : "LA GLORIA"
    },
    {
      "code" : "10416",
      "display" : "SAN RAFAEL ARRIBA"
    },
    {
      "code" : "10608",
      "display" : "EL TIGRE"
    },
    {
      "code" : "10609",
      "display" : "POAS"
    },
    {
      "code" : "10610",
      "display" : "SANTA TERESITA"
    },
    {
      "code" : "10611",
      "display" : "TARBACA O PRAGA"
    },
    {
      "code" : "10708",
      "display" : "BRASIL"
    },
    {
      "code" : "10709",
      "display" : "SAN BOSCO"
    },
    {
      "code" : "10808",
      "display" : "CALLE BLANCOS Y SAN GABRIEL"
    },
    {
      "code" : "10809",
      "display" : "FACIO Y LA MORA"
    },
    {
      "code" : "10810",
      "display" : "IPIS ABAJO"
    },
    {
      "code" : "10811",
      "display" : "LOS ÁNGELES"
    },
    {
      "code" : "10812",
      "display" : "MATA DE PLÁTANO O CARMEN"
    },
    {
      "code" : "10907",
      "display" : "LAGOS DE LINDORA"
    },
    {
      "code" : "10908",
      "display" : "RIO ORO"
    },
    {
      "code" : "10909",
      "display" : "SAN RAFAEL"
    },
    {
      "code" : "11006",
      "display" : "AURORA"
    },
    {
      "code" : "11007",
      "display" : "CONCEPCIÓN ABAJO"
    },
    {
      "code" : "11008",
      "display" : "CONCEPCIÓN ARRIBA"
    },
    {
      "code" : "11106",
      "display" : "CASCAJAL"
    },
    {
      "code" : "11107",
      "display" : "CORAZÓN DE JESÚS"
    },
    {
      "code" : "11108",
      "display" : "JESÚS O DULCE NOMBRE"
    },
    {
      "code" : "11109",
      "display" : "LAS NUBES"
    },
    {
      "code" : "11110",
      "display" : "Patalillo"
    },
    {
      "code" : "11111",
      "display" : "SAN ANTONIO"
    },
    {
      "code" : "11112",
      "display" : "SAN ISIDRO"
    },
    {
      "code" : "11113",
      "display" : "San Isidro"
    },
    {
      "code" : "11114",
      "display" : "San Pablo"
    },
    {
      "code" : "11115",
      "display" : "Santa Cruz"
    },
    {
      "code" : "11209",
      "display" : "BAJO CACAO O CERDAS"
    },
    {
      "code" : "11210",
      "display" : "CHIRRACA (PARTE ESTE)"
    },
    {
      "code" : "11211",
      "display" : "SAN IGNACIO"
    },
    {
      "code" : "11212",
      "display" : "San Ignacio"
    },
    {
      "code" : "11306",
      "display" : "CUATRO REINAS"
    },
    {
      "code" : "11307",
      "display" : "FLORIDA (INVU)"
    },
    {
      "code" : "11404",
      "display" : "LA ISLA"
    },
    {
      "code" : "11405",
      "display" : "LA TRINIDAD (GUAYABAL)"
    },
    {
      "code" : "11406",
      "display" : "LOS SITIOS"
    },
    {
      "code" : "11407",
      "display" : "PLATANARES"
    },
    {
      "code" : "11505",
      "display" : "BETANIA"
    },
    {
      "code" : "11506",
      "display" : "CEDROS"
    },
    {
      "code" : "11507",
      "display" : "LOURDES"
    },
    {
      "code" : "11805",
      "display" : "CIPRESES"
    },
    {
      "code" : "11806",
      "display" : "GRANADILLA NORTE"
    },
    {
      "code" : "11807",
      "display" : "GRANADILLA SUR"
    },
    {
      "code" : "11808",
      "display" : "JOSÉ MARÍA ZELEDÓN"
    },
    {
      "code" : "11809",
      "display" : "LA LIA O INMACULADA"
    },
    {
      "code" : "11913",
      "display" : "CALIFORNIA DE RIO NUEVO"
    },
    {
      "code" : "11914",
      "display" : "CARMEN O CAJÓN"
    },
    {
      "code" : "11915",
      "display" : "COOPERATIVA"
    },
    {
      "code" : "11916",
      "display" : "EL HOYON"
    },
    {
      "code" : "11917",
      "display" : "GENERAL VIEJO"
    },
    {
      "code" : "11918",
      "display" : "LOS ÁNGELES DE PARAMO"
    },
    {
      "code" : "11919",
      "display" : "MIRAVALLES"
    },
    {
      "code" : "11920",
      "display" : "MORAZÁN"
    },
    {
      "code" : "11921",
      "display" : "PALMARES"
    },
    {
      "code" : "11922",
      "display" : "PEDREGOSO"
    },
    {
      "code" : "11923",
      "display" : "QUEBRADAS"
    },
    {
      "code" : "11924",
      "display" : "SAN ANDRÉS"
    },
    {
      "code" : "11925",
      "display" : "San Isidro de El General"
    },
    {
      "code" : "11926",
      "display" : "SAN RAFAEL DE PLATANARES"
    },
    {
      "code" : "12007",
      "display" : "HIGUERÓN"
    },
    {
      "code" : "12008",
      "display" : "LLANO BONITO (SAN RAFAEL ARRIBA)"
    },
    {
      "code" : "20115",
      "display" : "BARRIO CORAZÓN DE JESÚS"
    },
    {
      "code" : "20116",
      "display" : "CACAO"
    },
    {
      "code" : "20117",
      "display" : "CANOAS"
    },
    {
      "code" : "20118",
      "display" : "CIRUELAS"
    },
    {
      "code" : "20119",
      "display" : "C.P. ADULTO JOVEN"
    },
    {
      "code" : "20120",
      "display" : "C.P. SAN RAFAEL"
    },
    {
      "code" : "20121",
      "display" : "C.P. TALLERES INDUSTRIALES"
    },
    {
      "code" : "20122",
      "display" : "DULCE NOMBRE O LAS ANIMAS"
    },
    {
      "code" : "20123",
      "display" : "EL COYOL"
    },
    {
      "code" : "20124",
      "display" : "EL ROBLE"
    },
    {
      "code" : "20125",
      "display" : "GUÁCIMA"
    },
    {
      "code" : "20126",
      "display" : "GUÁCIMA (SANTIAGO OESTE)"
    },
    {
      "code" : "20127",
      "display" : "LAS VUELTAS"
    },
    {
      "code" : "20128",
      "display" : "MONTECILLOS (PARTE NORTE)"
    },
    {
      "code" : "20129",
      "display" : "NUESTRO AMO"
    },
    {
      "code" : "20130",
      "display" : "PACTO DEL JOCOTE"
    },
    {
      "code" : "20131",
      "display" : "QUEBRADAS"
    },
    {
      "code" : "20132",
      "display" : "RINCÓN DE HERRERA"
    },
    {
      "code" : "20133",
      "display" : "RIO SEGUNDO (SANTIAGO ESTE)"
    },
    {
      "code" : "20134",
      "display" : "SAN ANTONIO DEL TEJAR"
    },
    {
      "code" : "20135",
      "display" : "SAN MARTÍN"
    },
    {
      "code" : "20136",
      "display" : "SAN MIGUEL DE SARAPIQUÍ"
    },
    {
      "code" : "20137",
      "display" : "SAN RAFAEL ESTE"
    },
    {
      "code" : "20138",
      "display" : "SAN RAFAEL OESTE"
    },
    {
      "code" : "20139",
      "display" : "TAMBOR (SANTA ANA)"
    },
    {
      "code" : "20140",
      "display" : "TUETAL NORTE (PARTE)"
    },
    {
      "code" : "20141",
      "display" : "ALAJUELA"
    },
    {
      "code" : "20142",
      "display" : "TURRÚCARES"
    },
    {
      "code" : "20215",
      "display" : "CALLE ZAMORA"
    },
    {
      "code" : "20216",
      "display" : "COLONIA TRINIDAD"
    },
    {
      "code" : "20217",
      "display" : "C.P. SAN RAMÓN"
    },
    {
      "code" : "20218",
      "display" : "H.A. SAN RAMÓN"
    },
    {
      "code" : "20219",
      "display" : "LOS ÁNGELES SUR"
    },
    {
      "code" : "20220",
      "display" : "LOS CRIQUES"
    },
    {
      "code" : "20221",
      "display" : "SAN ISIDRO DE PEÑAS BLANCAS"
    },
    {
      "code" : "20222",
      "display" : "SECTOR LOS ÁNGELES"
    },
    {
      "code" : "20309",
      "display" : "ALTOS DE PERALTA"
    },
    {
      "code" : "20310",
      "display" : "BAJO ROSALES"
    },
    {
      "code" : "20311",
      "display" : "BARRIO LATINO (AGUALOTE)"
    },
    {
      "code" : "20312",
      "display" : "CAJÓN (BARRIO SAN JOSÉ)"
    },
    {
      "code" : "20313",
      "display" : "CALLE SAN JOSÉ"
    },
    {
      "code" : "20314",
      "display" : "CATALUÑA"
    },
    {
      "code" : "20315",
      "display" : "CEDRO"
    },
    {
      "code" : "20316",
      "display" : "LOS ÁNGELES DE BOLÍVAR"
    },
    {
      "code" : "20317",
      "display" : "PORO"
    },
    {
      "code" : "20318",
      "display" : "RINCÓN DE ARIAS"
    },
    {
      "code" : "20319",
      "display" : "SAN JOSÉ Y SANTA GERTRUDIS NORTE"
    },
    {
      "code" : "20320",
      "display" : "SAN JUAN"
    },
    {
      "code" : "20321",
      "display" : "SAN MIGUEL"
    },
    {
      "code" : "20322",
      "display" : "SAN RAFAEL D RIO CUARTO(CUCARACHO)"
    },
    {
      "code" : "20405",
      "display" : "HIGUITO"
    },
    {
      "code" : "20509",
      "display" : "BALSA"
    },
    {
      "code" : "20510",
      "display" : "LOS ÁNGELES"
    },
    {
      "code" : "20511",
      "display" : "MORAZÁN"
    },
    {
      "code" : "20512",
      "display" : "SAN JOSÉ SUR"
    },
    {
      "code" : "20613",
      "display" : "CANDELARIA (BAJO CORRALES)"
    },
    {
      "code" : "20614",
      "display" : "ROSARIO (EL HOYO)"
    },
    {
      "code" : "20615",
      "display" : "SAN JERÓNIMO"
    },
    {
      "code" : "20616",
      "display" : "SAN JOSÉ (SAN JUANILLO)"
    },
    {
      "code" : "20617",
      "display" : "SAN JUAN (ACEQUIA GRANDE)"
    },
    {
      "code" : "20708",
      "display" : "COCALECA (PARTE OESTE)"
    },
    {
      "code" : "20709",
      "display" : "H.A. PALMARES"
    },
    {
      "code" : "20710",
      "display" : "LA GRANJA"
    },
    {
      "code" : "20711",
      "display" : "RINCÓN DE ZARAGOZA"
    },
    {
      "code" : "20806",
      "display" : "CARRILLOS ALTO"
    },
    {
      "code" : "20807",
      "display" : "CARRILLOS BAJO"
    },
    {
      "code" : "20808",
      "display" : "CHILAMATE"
    },
    {
      "code" : "20809",
      "display" : "SAN JUAN NORTE"
    },
    {
      "code" : "20810",
      "display" : "SAN JUAN SUR"
    },
    {
      "code" : "20906",
      "display" : "EL MASTATE"
    },
    {
      "code" : "20907",
      "display" : "LA CEIBA"
    },
    {
      "code" : "21014",
      "display" : "BOCA DE ARENAL"
    },
    {
      "code" : "21015",
      "display" : "CHAMBACU DE MONTERREY"
    },
    {
      "code" : "21016",
      "display" : "C.P. PALMERA (LA MARINA)"
    },
    {
      "code" : "21017",
      "display" : "DULCE NOMBRE"
    },
    {
      "code" : "21018",
      "display" : "GUARIA DE POCOSOL"
    },
    {
      "code" : "21019",
      "display" : "LA FORTUNA"
    },
    {
      "code" : "21020",
      "display" : "La Fortuna"
    },
    {
      "code" : "21021",
      "display" : "LA PALMERA"
    },
    {
      "code" : "21022",
      "display" : "LA TIGRA"
    },
    {
      "code" : "21023",
      "display" : "LOS ÁNGELES"
    },
    {
      "code" : "21024",
      "display" : "SAN GERARDO DE POCOSOL"
    },
    {
      "code" : "21025",
      "display" : "SAN JORGE DE CUTRIS"
    },
    {
      "code" : "21026",
      "display" : "SANTA ROSA DE POCOSOL"
    },
    {
      "code" : "21027",
      "display" : "SANTO DOMINGO"
    },
    {
      "code" : "21108",
      "display" : "SANTA ROSA"
    },
    {
      "code" : "21109",
      "display" : "TAPESCO"
    },
    {
      "code" : "21206",
      "display" : "SABANILLA"
    },
    {
      "code" : "21207",
      "display" : "SAN JUAN"
    },
    {
      "code" : "21208",
      "display" : "SARCHI"
    },
    {
      "code" : "21309",
      "display" : "PROGRESO"
    },
    {
      "code" : "21405",
      "display" : "SAN JOSÉ DEL AMPARO"
    },
    {
      "code" : "21505",
      "display" : "CABANGA DE COTE (PUEBLO NUEVO)"
    },
    {
      "code" : "21506",
      "display" : "EL VALLE"
    },
    {
      "code" : "30112",
      "display" : "AGUACALIENTE"
    },
    {
      "code" : "30113",
      "display" : "ALTO DE OCHOMOGO"
    },
    {
      "code" : "30114",
      "display" : "AZAHAR (PENJAMO)"
    },
    {
      "code" : "30115",
      "display" : "BERMEJO"
    },
    {
      "code" : "30116",
      "display" : "CABALLO BLANCO (SUR CARRETERA)"
    },
    {
      "code" : "30117",
      "display" : "C.P. SAN FRANCISCO"
    },
    {
      "code" : "30118",
      "display" : "EL CARMEN"
    },
    {
      "code" : "30119",
      "display" : "GUADALUPE"
    },
    {
      "code" : "30120",
      "display" : "GUADALUPE (ARENILLA)"
    },
    {
      "code" : "30121",
      "display" : "GUADALUPE O ARENILLA"
    },
    {
      "code" : "30122",
      "display" : "LA LIMA"
    },
    {
      "code" : "30123",
      "display" : "LLANO DE LOS ÁNGELES"
    },
    {
      "code" : "30124",
      "display" : "OCCIDENTAL"
    },
    {
      "code" : "30125",
      "display" : "ORIENTAL"
    },
    {
      "code" : "30126",
      "display" : "PITAHAYA"
    },
    {
      "code" : "61401",
      "display" : "QUEPOS"
    },
    {
      "code" : "61402",
      "display" : "NARANJITO"
    },
    {
      "code" : "61403",
      "display" : "SAVEGRE"
    }
  ]
}

```
