# Catálogo de ingredientes de un medicamento - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de ingredientes de un medicamento**

## CodeSystem: Catálogo de ingredientes de un medicamento 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/drugs-compound-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:DrugsCompoundCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de ingredientes de un medicamento en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationIngredient](ValueSet-MedicationIngredient.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "drugs-compound-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/drugs-compound-code",
  "version" : "1.1.0-ballot",
  "name" : "DrugsCompoundCode",
  "title" : "Catálogo de ingredientes de un medicamento",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de ingredientes de un medicamento en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 217,
  "concept" : [
    {
      "code" : "34",
      "display" : "Codeina"
    },
    {
      "code" : "2",
      "display" : "Metilfenidato"
    },
    {
      "code" : "372687004",
      "display" : "AMOXICILINA"
    },
    {
      "code" : "7",
      "display" : "Alprazolam"
    },
    {
      "code" : "33",
      "display" : "Esketamina"
    },
    {
      "code" : "31",
      "display" : "Eszoplicona"
    },
    {
      "code" : "32",
      "display" : "Buprenorfina"
    },
    {
      "code" : "28",
      "display" : "Petidina"
    },
    {
      "code" : "29",
      "display" : "Tapentadol"
    },
    {
      "code" : "30",
      "display" : "Clordiazepoxido"
    },
    {
      "code" : "1",
      "display" : "Metadona"
    },
    {
      "code" : "3",
      "display" : "Morfina"
    },
    {
      "code" : "4",
      "display" : "Fentanilo"
    },
    {
      "code" : "6",
      "display" : "Oxicodona"
    },
    {
      "code" : "8",
      "display" : "Lorazepam"
    },
    {
      "code" : "9",
      "display" : "Bromazepam"
    },
    {
      "code" : "10",
      "display" : "Clobazam"
    },
    {
      "code" : "11",
      "display" : "Clonazepam"
    },
    {
      "code" : "12",
      "display" : "Diazepam"
    },
    {
      "code" : "13",
      "display" : "Midazolam"
    },
    {
      "code" : "14",
      "display" : "Fentermina"
    },
    {
      "code" : "15",
      "display" : "Fenobarbital"
    },
    {
      "code" : "16",
      "display" : "Triazolam"
    },
    {
      "code" : "17",
      "display" : "Anfepramona"
    },
    {
      "code" : "18",
      "display" : "Mazindol"
    },
    {
      "code" : "19",
      "display" : "Loflazepato"
    },
    {
      "code" : "21",
      "display" : "Zolpidem"
    },
    {
      "code" : "24",
      "display" : "Mexazolam"
    },
    {
      "code" : "25",
      "display" : "Clobenzorex"
    },
    {
      "code" : "26",
      "display" : "Ketamina"
    },
    {
      "code" : "27",
      "display" : "Zopiclona"
    },
    {
      "code" : "129474002",
      "display" : "CASPOFUNGINA ACETATO"
    },
    {
      "code" : "372651006",
      "display" : "CEFADROXILO"
    },
    {
      "code" : "387304003",
      "display" : "CEFALEXINA"
    },
    {
      "code" : "412343003",
      "display" : "CEFALEXINA MONOHIDRATO"
    },
    {
      "code" : "59937009",
      "display" : "CEFALOTINA SODICA"
    },
    {
      "code" : "387536009",
      "display" : "CEFIXIMA"
    },
    {
      "code" : "372704003",
      "display" : "CEFOTAXIMA"
    },
    {
      "code" : "41722006",
      "display" : "CEFOTAXIMA SODICA"
    },
    {
      "code" : "387200005",
      "display" : "CEFTAZIDIMA"
    },
    {
      "code" : "725671004",
      "display" : "CEFTAZIDIMA PENTAHIDRATADA"
    },
    {
      "code" : "372670001",
      "display" : "CEFTRIAXONA"
    },
    {
      "code" : "33440000",
      "display" : "CEFTRIAXONA DISODICA"
    },
    {
      "code" : "89678001",
      "display" : "CEFUROXIMA AXETIL"
    },
    {
      "code" : "387487009",
      "display" : "CLARITROMICINA"
    },
    {
      "code" : "372786004",
      "display" : "CLINDAMICINA"
    },
    {
      "code" : "63084001",
      "display" : "CLINDAMICINA CLORHIDRATO"
    },
    {
      "code" : "37648000",
      "display" : "CLINDAMICINA FOSFATO"
    },
    {
      "code" : "85737002",
      "display" : "CLORFENIRAMINA MALEATO"
    },
    {
      "code" : "53136009",
      "display" : "CLOROQUINA FOSFATO"
    },
    {
      "code" : "387096002",
      "display" : "DAPSONA"
    },
    {
      "code" : "423888002",
      "display" : "DARUNAVIR"
    },
    {
      "code" : "735011001",
      "display" : "DELAFLOXACINO"
    },
    {
      "code" : "412074007",
      "display" : "ABACAVIR SULFATO"
    },
    {
      "code" : "372729009",
      "display" : "ACICLOVIR"
    },
    {
      "code" : "200",
      "display" : "AMIKACINA SULFATO"
    },
    {
      "code" : "96068000",
      "display" : "AMOXICILINA TRIHIDRATO"
    },
    {
      "code" : "387170002",
      "display" : "AMPICILINA"
    },
    {
      "code" : "96070009",
      "display" : "Ampicilina Sódica"
    },
    {
      "code" : "422157006",
      "display" : "ANIDULAFUNGINA"
    },
    {
      "code" : "387531004",
      "display" : "AZITROMICINA"
    },
    {
      "code" : "391805000",
      "display" : "AZITROMICINA DIHIDRATO"
    },
    {
      "code" : "387386004",
      "display" : "AZTREONAM"
    },
    {
      "code" : "75247008",
      "display" : "BENZATINA BENCILPENICILINA"
    },
    {
      "code" : "698049003",
      "display" : "BRIVUDINA"
    },
    {
      "code" : "387076005",
      "display" : "PIRAZINAMIDA"
    },
    {
      "code" : "373769001",
      "display" : "PIRIMETAMINA"
    },
    {
      "code" : "372824005",
      "display" : "POLIMIXINA B SULFATO"
    },
    {
      "code" : "387159009",
      "display" : "RIFAMPICINA"
    },
    {
      "code" : "412553001",
      "display" : "RIFAXIMINA ALFA"
    },
    {
      "code" : "713462001",
      "display" : "SECNIDAZOL"
    },
    {
      "code" : "387112002",
      "display" : "SULFADIAZINA DE PLATA"
    },
    {
      "code" : "70961008",
      "display" : "NEOMICINA SULFATO"
    },
    {
      "code" : "373450007",
      "display" : "TERBINAFINA"
    },
    {
      "code" : "16355005",
      "display" : "TETRACICLINA CLORHIDRATO"
    },
    {
      "code" : "418313005",
      "display" : "TIGECICLINA"
    },
    {
      "code" : "713465004",
      "display" : "DOLUTEGRAVIR"
    },
    {
      "code" : "781493004",
      "display" : "DORAVIRINA"
    },
    {
      "code" : "372478003",
      "display" : "DOXICICLINA"
    },
    {
      "code" : "71417000",
      "display" : "DOXICICLINA HICLATO"
    },
    {
      "code" : "416644000",
      "display" : "Entecavir"
    },
    {
      "code" : "372694001",
      "display" : "ERITROMICINA"
    },
    {
      "code" : "396346003",
      "display" : "ERTAPENEM"
    },
    {
      "code" : "387163002",
      "display" : "ESPIRAMICINA"
    },
    {
      "code" : "32800009",
      "display" : "ETIONAMIDA"
    },
    {
      "code" : "6394006",
      "display" : "FENTERMINA CLORHIDRATO"
    },
    {
      "code" : "387174006",
      "display" : "FLUCONAZOL"
    },
    {
      "code" : "372534005",
      "display" : "FOSFOMICINA TROMETAMOL"
    },
    {
      "code" : "734",
      "display" : "GENTAMICINA"
    },
    {
      "code" : "736",
      "display" : "GENTAMICINA SULFATO"
    },
    {
      "code" : "13502005",
      "display" : "HIDROXICLOROQUINA SULFATO"
    },
    {
      "code" : "387559003",
      "display" : "IVERMECTINA"
    },
    {
      "code" : "860",
      "display" : "KETOCONAZOL"
    },
    {
      "code" : "386897000",
      "display" : "LAMIVUDINA"
    },
    {
      "code" : "725662008",
      "display" : "LEVOFLOXACINA HEMIHIDRATO"
    },
    {
      "code" : "387552007",
      "display" : "LEVOFLOXACINO BASE"
    },
    {
      "code" : "387548007",
      "display" : "LIMECICLINA"
    },
    {
      "code" : "910",
      "display" : "LINCOMICINA"
    },
    {
      "code" : "387106007",
      "display" : "LORAZEPAM"
    },
    {
      "code" : "429603001",
      "display" : "MARAVIROC"
    },
    {
      "code" : "1269143002",
      "display" : "MEROPENEM ANHIDRO"
    },
    {
      "code" : "395749001",
      "display" : "METISOPRINOL"
    },
    {
      "code" : "372602008",
      "display" : "METRONIDAZOL"
    },
    {
      "code" : "52886009",
      "display" : "MINOCICLINA CLORHIDRATO"
    },
    {
      "code" : "412439003",
      "display" : "MOXIFLOXACINO"
    },
    {
      "code" : "387048002",
      "display" : "NISTATINA"
    },
    {
      "code" : "407148001",
      "display" : "NITAZOXANIDA"
    },
    {
      "code" : "85724000",
      "display" : "OXACILINA SODICA"
    },
    {
      "code" : "785687007",
      "display" : "AZITROMICINA ANHIDRA"
    },
    {
      "code" : "89055006",
      "display" : "BENCILPENICILINA SODICA"
    },
    {
      "code" : "429663004",
      "display" : "PRIMAQUINA"
    },
    {
      "code" : "429707008",
      "display" : "Raltegravir"
    },
    {
      "code" : "396031000",
      "display" : "DIMETICONA"
    },
    {
      "code" : "81508005",
      "display" : "DOXICICLINA MONOHIDRATO"
    },
    {
      "code" : "387001004",
      "display" : "EFAVIRENZ"
    },
    {
      "code" : "26346008",
      "display" : "ETAMBUTOL CLORHIDRATO"
    },
    {
      "code" : "372848001",
      "display" : "GANCICLOVIR"
    },
    {
      "code" : "387188005",
      "display" : "RIBAVIRINA"
    },
    {
      "code" : "108713004",
      "display" : "RIMANTADINA CLORHIDRATO"
    },
    {
      "code" : "386896009",
      "display" : "RITONAVIR"
    },
    {
      "code" : "74523009",
      "display" : "SULFADIAZINA"
    },
    {
      "code" : "108927002",
      "display" : "TERBINAFINA CLORHIDRATO"
    },
    {
      "code" : "395907001",
      "display" : "TINIDAZOL"
    },
    {
      "code" : "395909003",
      "display" : "TIOCONAZOL"
    },
    {
      "code" : "373548001",
      "display" : "TOBRAMICINA"
    },
    {
      "code" : "1326",
      "display" : "TOLNAFTATO"
    },
    {
      "code" : "96098007",
      "display" : "Valaciclovir"
    },
    {
      "code" : "412325002",
      "display" : "VALACICLOVIR CLORHIDRATO"
    },
    {
      "code" : "412326001",
      "display" : "VALGANCICLOVIR CLORHIDRATO"
    },
    {
      "code" : "66509009",
      "display" : "VANCOMICINA CLORHIDRATO"
    },
    {
      "code" : "355",
      "display" : "CASPOFUNGINA"
    },
    {
      "code" : "360",
      "display" : "Cefadroxilo Monohidrato"
    },
    {
      "code" : "785690001",
      "display" : "CEFALEXINA ANHIDRA"
    },
    {
      "code" : "387470007",
      "display" : "CEFAZOLINA"
    },
    {
      "code" : "370370003",
      "display" : "Cefepima Clorhidrato"
    },
    {
      "code" : "372840008",
      "display" : "CIPROFLOXACINO"
    },
    {
      "code" : "387383007",
      "display" : "CLONAZEPAM"
    },
    {
      "code" : "72387009",
      "display" : "ACICLOVIR SODICO"
    },
    {
      "code" : "387558006",
      "display" : "ALBENDAZOL"
    },
    {
      "code" : "77703004",
      "display" : "ANFOTERICINA B"
    },
    {
      "code" : "387472004",
      "display" : "ISONIAZIDA"
    },
    {
      "code" : "387532006",
      "display" : "ITRACONAZOL"
    },
    {
      "code" : "763033005",
      "display" : "Letermovir"
    },
    {
      "code" : "896",
      "display" : "LEVOFLOXACINO"
    },
    {
      "code" : "387480006",
      "display" : "LIDOCAÍNA"
    },
    {
      "code" : "912",
      "display" : "LINEZOLID"
    },
    {
      "code" : "387311004",
      "display" : "MEBENDAZOL"
    },
    {
      "code" : "714533009",
      "display" : "MEGLUMINA ANTIMONIATO"
    },
    {
      "code" : "387540000",
      "display" : "MEROPENEM"
    },
    {
      "code" : "725669004",
      "display" : "MEROPENEM TRIHIDRATO"
    },
    {
      "code" : "116347002",
      "display" : "MOXIFLOXACINO CLORHIDRATO"
    },
    {
      "code" : "373543005",
      "display" : "NITROFURANTOINA"
    },
    {
      "code" : "387271008",
      "display" : "NORFLOXACINO"
    },
    {
      "code" : "387551000",
      "display" : "OFLOXACINA"
    },
    {
      "code" : "116113006",
      "display" : "OSELTAMIVIR FOSFATO"
    },
    {
      "code" : "410457007",
      "display" : "PERMETRINA"
    },
    {
      "code" : "777212006",
      "display" : "PIPERACILINA, TAZOBACTAM"
    },
    {
      "code" : "372836004",
      "display" : "PIPERACILINA"
    },
    {
      "code" : "421613006",
      "display" : "CLINDAMICINA FOSFATO, PEROXIDO DE BENZOILO"
    },
    {
      "code" : "714769003",
      "display" : "DOLUTEGRAVIR, LAMIVUDINA, TENOFOVIR"
    },
    {
      "code" : "422091007",
      "display" : "TENOFOVIR"
    },
    {
      "code" : "779099001",
      "display" : "EFAVIRENZ, EMTRICITABINA, TENOFOVIR"
    },
    {
      "code" : "134573001",
      "display" : "LOPINAVIR, RITONAVIR"
    },
    {
      "code" : "714086004",
      "display" : "BEDAQUILINA"
    },
    {
      "code" : "387410004",
      "display" : "CLOFAZIMINA"
    },
    {
      "code" : "387282000",
      "display" : "CICLOSERINA"
    },
    {
      "code" : "789316005",
      "display" : "PRETOMANID"
    },
    {
      "code" : "714395003",
      "display" : "RIFAMPICINA, ISONIAZIDA, PIRAZINAMIDA, ETAMBUTOL CLORHIDRATO"
    },
    {
      "code" : "346670008",
      "display" : "RIFAMPICINA, ISONIAZIDA"
    },
    {
      "code" : "346671007",
      "display" : "RIFAMPICINA, ISONIAZIDA, PIRAZINAMIDA"
    },
    {
      "code" : "1010553003",
      "display" : "BEDAQUILINA FUMARATO"
    },
    {
      "code" : "395268004",
      "display" : "ARTEMETERO, LUMEFANTRINA"
    },
    {
      "code" : "432410005",
      "display" : "ARTESUNATO"
    },
    {
      "code" : "420307001",
      "display" : "LUMEFANTRINA"
    },
    {
      "code" : "713642004",
      "display" : "MILTEFOSINA"
    },
    {
      "code" : "24869004",
      "display" : "NIFURTIMOX"
    },
    {
      "code" : "420578008",
      "display" : "ARTEMETERO"
    },
    {
      "code" : "414090006",
      "display" : "EMTRICITABINA, TENOFOVIR"
    },
    {
      "code" : "413381000",
      "display" : "ABACAVIR Y LAMIVUDINA"
    },
    {
      "code" : "734844004",
      "display" : "AMOXICILINA Y CLAVULÁNICO"
    },
    {
      "code" : "395939008",
      "display" : "ÁCIDO CLAVULÁNICO"
    },
    {
      "code" : "398786001",
      "display" : "AMPICILINA Y SULBACTAM"
    },
    {
      "code" : "96008003",
      "display" : "SULBACTAM"
    },
    {
      "code" : "781299002",
      "display" : "CEFTAZIDIMA Y AVIBACTAM"
    },
    {
      "code" : "715180004",
      "display" : "AVIBACTAM"
    },
    {
      "code" : "714688004",
      "display" : "CEFTOLOZANO Y TAZOBACTAM"
    },
    {
      "code" : "708792003",
      "display" : "CEFTOLOZANO"
    },
    {
      "code" : "11644000",
      "display" : "TAZOBACTAM"
    },
    {
      "code" : "432121008",
      "display" : "ETRAVIRINA"
    },
    {
      "code" : "323964004",
      "display" : "IMIPENEM Y CILASTATINA"
    },
    {
      "code" : "46558003",
      "display" : "IMIPENEM"
    },
    {
      "code" : "96058005",
      "display" : "CILASTATINA"
    },
    {
      "code" : "1269150003",
      "display" : "NITROFURANTOÍNA ANHIDRO"
    },
    {
      "code" : "427332002",
      "display" : "NITROFURANTOÍNA MACROCRISTALINA"
    },
    {
      "code" : "703123005",
      "display" : "RILPIVIRINA"
    },
    {
      "code" : "363528007",
      "display" : "SULFAMETOXAZOL"
    },
    {
      "code" : "398731002",
      "display" : "SULFAMETOXAZOL Y TRIMETOPRIMA"
    },
    {
      "code" : "387151007",
      "display" : "ZIDOVUDINA"
    },
    {
      "code" : "385469007",
      "display" : "VORICONAZOL"
    },
    {
      "code" : "387010007",
      "display" : "ZANAMIVIR"
    },
    {
      "code" : "404856006",
      "display" : "EMTRICITABINA"
    },
    {
      "code" : "772093001",
      "display" : "EMTRICITABINA, TENOFOVIR ALAFENAMIDA Y BICTEGRAVIR"
    },
    {
      "code" : "715220007",
      "display" : "TENOFOVIR ALAFENAMIDA"
    },
    {
      "code" : "734148003",
      "display" : "EMTRICITABINA, TENOFOVIR ALAFENAMIDA, ELVITEGRAVIR Y COBICISTAT"
    },
    {
      "code" : "781506003",
      "display" : "LAMIVUDINA, TENOFOVIR DISOPROXIL Y DORAVIRINA"
    },
    {
      "code" : "324859007",
      "display" : "ZIDOVUDINA Y LAMIVUDINA"
    },
    {
      "code" : "385556006",
      "display" : "TENOFOVIR DISOPROXIL FUMARATO"
    },
    {
      "code" : "772193003",
      "display" : "BICTEGRAVIR"
    },
    {
      "code" : "717096002",
      "display" : "QUINFAMIDA"
    },
    {
      "code" : "387240004",
      "display" : "MAGALDRATO"
    },
    {
      "code" : "64507008",
      "display" : "AMANTADINA CLORHIDRATO"
    },
    {
      "code" : "68680008",
      "display" : "PARACETAMOL"
    },
    {
      "code" : "73946006",
      "display" : "FENILEFRINA CLORHIDRATO"
    },
    {
      "code" : "387517004",
      "display" : "CAFEÍNA ANHIDRA"
    },
    {
      "code" : "398808006",
      "display" : "METRONIDAZOL Y NISTATINA"
    },
    {
      "code" : "398693009",
      "display" : "NISTATINA, TOLNAFTATO Y YODOCLORHIDROXIQUINOLEÍNA"
    },
    {
      "code" : "387216007",
      "display" : "KETOCONAZOL"
    }
  ]
}

```
