# Dominio de Identificación - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Dominio de Identificación**

## CodeSystem: Dominio de Identificación 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:IdTypesDomain |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Dominio de identificación posibles y existentes en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [IdTypes](ValueSet-idTypes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "id-types-domain",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
  "version" : "1.1.0-ballot",
  "name" : "IdTypesDomain",
  "title" : "Dominio de Identificación",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Dominio de identificación posibles y existentes en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 8,
  "concept" : [
    {
      "code" : "1",
      "display" : "Cédula Física"
    },
    {
      "code" : "2",
      "display" : "Tarjeta Identificación Menores (TIM)"
    },
    {
      "code" : "3",
      "display" : "Cédula Residente"
    },
    {
      "code" : "4",
      "display" : "Pasaporte"
    },
    {
      "code" : "5",
      "display" : "Indocumentado"
    },
    {
      "code" : "6",
      "display" : "Expediente IAFA"
    },
    {
      "code" : "7",
      "display" : "Asegurado"
    },
    {
      "code" : "8",
      "display" : "Número Interno"
    }
  ]
}

```
