# Catálogo de manifestación de alergias - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de manifestación de alergias**

## CodeSystem: Catálogo de manifestación de alergias 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/manifestations-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:ManifestationsCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de manifestación de alergias en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Manifestation](ValueSet-Manifestation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "manifestations-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/manifestations-code",
  "version" : "1.1.0-ballot",
  "name" : "ManifestationsCode",
  "title" : "Catálogo de manifestación de alergias",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de manifestación de alergias en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 88,
  "concept" : [
    {
      "code" : "399153001",
      "display" : "vértigo"
    },
    {
      "code" : "422400008",
      "display" : "vómitos"
    },
    {
      "code" : "414285001",
      "display" : "alergia alimentaria"
    },
    {
      "code" : "39579001",
      "display" : "anafilaxia"
    },
    {
      "code" : "91941002",
      "display" : "anafilaxia alimentaria"
    },
    {
      "code" : "41291007",
      "display" : "angioedema"
    },
    {
      "code" : "48694002",
      "display" : "ansiedad"
    },
    {
      "code" : "195967001",
      "display" : "asma"
    },
    {
      "code" : "389145006",
      "display" : "asma alérgica"
    },
    {
      "code" : "84387000",
      "display" : "ausencia de síntomas"
    },
    {
      "code" : "4386001",
      "display" : "broncoespasmo"
    },
    {
      "code" : "735173007",
      "display" : "choque anafiláctico"
    },
    {
      "code" : "30304000",
      "display" : "colitis alérgica"
    },
    {
      "code" : "68235000",
      "display" : "congestión nasal"
    },
    {
      "code" : "9826008",
      "display" : "conjuntivitis"
    },
    {
      "code" : "473460002",
      "display" : "conjuntivitis alérgica"
    },
    {
      "code" : "71186008",
      "display" : "crup"
    },
    {
      "code" : "40275004",
      "display" : "dermatitis por contacto"
    },
    {
      "code" : "64411000122108",
      "display" : "diagnósticos alergológicos"
    },
    {
      "code" : "409966000",
      "display" : "diarrea aguda"
    },
    {
      "code" : "49237006",
      "display" : "diarrea alérgica"
    },
    {
      "code" : "236071009",
      "display" : "diarrea crónica"
    },
    {
      "code" : "286378009",
      "display" : "dificultad para conversar"
    },
    {
      "code" : "40739000",
      "display" : "disfagia"
    },
    {
      "code" : "47004009",
      "display" : "disfonía"
    },
    {
      "code" : "34871000122109",
      "display" : "disnea faríngea"
    },
    {
      "code" : "25209001",
      "display" : "disnea laríngea"
    },
    {
      "code" : "34881000122107",
      "display" : "disnea torácica"
    },
    {
      "code" : "21522001",
      "display" : "dolor abdominal"
    },
    {
      "code" : "43116000",
      "display" : "eccema"
    },
    {
      "code" : "51599000",
      "display" : "edema de laringe"
    },
    {
      "code" : "34861000122104",
      "display" : "edemas distales de extremidades"
    },
    {
      "code" : "248283007",
      "display" : "enfermedad - no logra describir los síntomas"
    },
    {
      "code" : "79922009",
      "display" : "epigastralgia"
    },
    {
      "code" : "247441003",
      "display" : "eritema"
    },
    {
      "code" : "23481000122109",
      "display" : "eritema generalizado"
    },
    {
      "code" : "271807003",
      "display" : "erupción cutánea"
    },
    {
      "code" : "406444002",
      "display" : "espasmo laríngeo"
    },
    {
      "code" : "76067001",
      "display" : "estornudo"
    },
    {
      "code" : "11451000122107",
      "display" : "estornudo en salvas"
    },
    {
      "code" : "195663004",
      "display" : "faringitis alérgica"
    },
    {
      "code" : "45007003",
      "display" : "hipotensión arterial"
    },
    {
      "code" : "64511000122109",
      "display" : "inflamación local"
    },
    {
      "code" : "75705005",
      "display" : "irritación ocular"
    },
    {
      "code" : "162467007",
      "display" : "libre de síntomas"
    },
    {
      "code" : "367391008",
      "display" : "malestar general"
    },
    {
      "code" : "404640003",
      "display" : "mareo"
    },
    {
      "code" : "16932000",
      "display" : "náuseas y vómitos"
    },
    {
      "code" : "703630003",
      "display" : "ojo rojo"
    },
    {
      "code" : "80313002",
      "display" : "palpitaciones"
    },
    {
      "code" : "419045004",
      "display" : "pérdida de conocimiento"
    },
    {
      "code" : "418290006",
      "display" : "prurito"
    },
    {
      "code" : "418363000",
      "display" : "prurito cutáneo"
    },
    {
      "code" : "1137376007",
      "display" : "prurito oral"
    },
    {
      "code" : "64431000122104",
      "display" : "reacción a alérgeno de pruebas alérgicas"
    },
    {
      "code" : "418484009",
      "display" : "reacción alérgica a mordedura y/o picadura"
    },
    {
      "code" : "871927008",
      "display" : "reacción alérgica causada por mordedura y/o picadura de insecto"
    },
    {
      "code" : "64441000122107",
      "display" : "reacción local inmediata"
    },
    {
      "code" : "64461000122106",
      "display" : "reacción local sublingual"
    },
    {
      "code" : "64451000122109",
      "display" : "reacción local tardía"
    },
    {
      "code" : "83442007",
      "display" : "reacción sistémica desfavorable a la prueba cutánea"
    },
    {
      "code" : "64471000122101",
      "display" : "reacción sistémica inmediata"
    },
    {
      "code" : "64481000122103",
      "display" : "reacción sistémica tardía"
    },
    {
      "code" : "64491000122100",
      "display" : "reacciones sistémicas que no amenazan la vida"
    },
    {
      "code" : "70076002",
      "display" : "rinitis"
    },
    {
      "code" : "61582004",
      "display" : "rinitis alérgica"
    },
    {
      "code" : "64421000122102",
      "display" : "rinitis y asma"
    },
    {
      "code" : "878820003",
      "display" : "rinoconjuntivitis"
    },
    {
      "code" : "247472004",
      "display" : "roncha"
    },
    {
      "code" : "238810007",
      "display" : "rubor"
    },
    {
      "code" : "247342009",
      "display" : "sensación de cuerpo extrańo"
    },
    {
      "code" : "23924001",
      "display" : "sensación de opresión en el pecho"
    },
    {
      "code" : "56018004",
      "display" : "sibilancias"
    },
    {
      "code" : "271594007",
      "display" : "síncope"
    },
    {
      "code" : "308925008",
      "display" : "síntoma digestivo"
    },
    {
      "code" : "10181000122100",
      "display" : "sinusitis alérgica"
    },
    {
      "code" : "3424008",
      "display" : "taquicardia"
    },
    {
      "code" : "300959008",
      "display" : "tos alérgica"
    },
    {
      "code" : "65124004",
      "display" : "tumefacción"
    },
    {
      "code" : "126485001",
      "display" : "urticaria"
    },
    {
      "code" : "40178009",
      "display" : "urticaria alérgica"
    },
    {
      "code" : "402304007",
      "display" : "urticaria alérgica de contacto"
    },
    {
      "code" : "402386006",
      "display" : "urticaria alérgica por alérgeno inhalado"
    },
    {
      "code" : "402385005",
      "display" : "urticaria alérgica por picadura y/o mordedura"
    },
    {
      "code" : "373674001",
      "display" : "urticaria anafiláctica"
    },
    {
      "code" : "89322006",
      "display" : "urticaria medicamentosa"
    },
    {
      "code" : "10347006",
      "display" : "urticaria solar"
    },
    {
      "code" : "271789005",
      "display" : "vértigo y mareos"
    }
  ]
}

```
