# Catálogo de especialidades médicas - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de especialidades médicas**

## CodeSystem: Catálogo de especialidades médicas 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/medical-specialities-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicalSpecialitiesCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de especialidades médicas en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicalSpecialities](ValueSet-medicalSpecialities.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medical-specialities-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/medical-specialities-code",
  "version" : "1.1.0-ballot",
  "name" : "MedicalSpecialitiesCode",
  "title" : "Catálogo de especialidades médicas",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de especialidades médicas en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 182,
  "concept" : [
    {
      "code" : "MV",
      "display" : "MÉDICO VETERINARIO"
    },
    {
      "code" : "ODO11",
      "display" : "ODONTOLOGIA GENERAL AVANZADA"
    },
    {
      "code" : "ODO12",
      "display" : "AD.SERV.SALUD"
    },
    {
      "code" : "MED04",
      "display" : "ANALISIS CLINICOS"
    },
    {
      "code" : "MED05",
      "display" : "ANATOMIA PATOLOGICA"
    },
    {
      "code" : "MED06",
      "display" : "ANESTESIOLOGIA Y REANIMACION"
    },
    {
      "code" : "MED09",
      "display" : "CARDIOLOGIA"
    },
    {
      "code" : "MED10",
      "display" : "CIRUGIA CARDIOVASCULAR"
    },
    {
      "code" : "MED12",
      "display" : "CIRUGIA MAXILOFACIAL"
    },
    {
      "code" : "MED14",
      "display" : "CIRUGIA PLASTICA Y REPARADORA"
    },
    {
      "code" : "MED15",
      "display" : "CIRUGIA TORACICA"
    },
    {
      "code" : "MED17",
      "display" : "RADIODIAGNOSTICO"
    },
    {
      "code" : "MED19",
      "display" : "ESTOMATOLOGIA"
    },
    {
      "code" : "MED20",
      "display" : "GERIATRIA"
    },
    {
      "code" : "MED22",
      "display" : "INMUNOLOGIA"
    },
    {
      "code" : "MED23",
      "display" : "MEDICINA INTENSIVA"
    },
    {
      "code" : "MED24",
      "display" : "MEDICINA INTERNA"
    },
    {
      "code" : "MED26",
      "display" : "NEFROLOGIA"
    },
    {
      "code" : "MED28",
      "display" : "NEUROCIRUGIA"
    },
    {
      "code" : "MED30",
      "display" : "NEUROLOGIA"
    },
    {
      "code" : "MED32",
      "display" : "OFTALMOLOGIA"
    },
    {
      "code" : "MED33",
      "display" : "ONCOLOGIA MEDICA"
    },
    {
      "code" : "MED35",
      "display" : "OTORRINOLARINGOLOGIA"
    },
    {
      "code" : "MED37",
      "display" : "REHABILITACION"
    },
    {
      "code" : "MED39",
      "display" : "TRATAMIENTO DEL DOLOR"
    },
    {
      "code" : "MED40",
      "display" : "TRAUMATOLOGIA Y CIRUGIA ORTOPEDICA"
    },
    {
      "code" : "MED42",
      "display" : "MEDICINA FAMILIAR Y COMUNITARIA"
    },
    {
      "code" : "MED44",
      "display" : "ADMINISTRACION EN SERVICIOS DE SALUD"
    },
    {
      "code" : "MED46",
      "display" : "MEDICINA DEL TRABAJO"
    },
    {
      "code" : "MED48",
      "display" : "MEDICINA MATERNO FETAL"
    },
    {
      "code" : "MED49",
      "display" : "GERENCIA DE LA SALUD"
    },
    {
      "code" : "MED51",
      "display" : "NEUMOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED53",
      "display" : "GASTROENTEROLOGIA"
    },
    {
      "code" : "MED54",
      "display" : "ANESTESIOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED57",
      "display" : "CARDIOLOGIA INTERVENCIONISTA Y HEMODINAMIA"
    },
    {
      "code" : "MED58",
      "display" : "CARDIOLOGIA INFANTIL"
    },
    {
      "code" : "MED59",
      "display" : "SALUD PUBLICA"
    },
    {
      "code" : "MED62",
      "display" : "MEDICINA CRITICA PEDIATRICA"
    },
    {
      "code" : "MED63",
      "display" : "SEXOLOGIA"
    },
    {
      "code" : "MED64",
      "display" : "NUTRIOLOGIA CLINICA"
    },
    {
      "code" : "MED67",
      "display" : "NEONATOLOGIA"
    },
    {
      "code" : "MED68",
      "display" : "MEDICINA CRITICA Y CUIDADOS INTENSIVOS"
    },
    {
      "code" : "MED70",
      "display" : "CIRUGIA ONCOLOGICA"
    },
    {
      "code" : "MED72",
      "display" : "CIRUGIA ORTOPEDICA PEDIATRICA"
    },
    {
      "code" : "MED73",
      "display" : "PERINATOLOGIA"
    },
    {
      "code" : "MED75",
      "display" : "CIRUGIA GASTROENTEROLOGICA"
    },
    {
      "code" : "MED77",
      "display" : "NEFROLOGIA PEDIATRICA"
    },
    {
      "code" : "MED79",
      "display" : "CITOPATOLOGIA"
    },
    {
      "code" : "MED80",
      "display" : "ONCOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED82",
      "display" : "PSIQUIATRIA INFANTIL"
    },
    {
      "code" : "MED84",
      "display" : "NEUROLOGIA PEDIATRICA"
    },
    {
      "code" : "MED85",
      "display" : "COLOPROCTOLOGIA"
    },
    {
      "code" : "MED88",
      "display" : "PSICOLOGIA CLINICA"
    },
    {
      "code" : "MED89",
      "display" : "ULTRASONIDO"
    },
    {
      "code" : "MED90",
      "display" : "GENETICA"
    },
    {
      "code" : "MED91",
      "display" : "PATOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED92",
      "display" : "ECONOMIA DE LA SALUD"
    },
    {
      "code" : "MED93",
      "display" : "NEUROCIRUGIA PEDIATRICA"
    },
    {
      "code" : "MED94",
      "display" : "MEDICINA PALIATIVA EN NIÑOS"
    },
    {
      "code" : "MED95",
      "display" : "INFORMATICA MEDICA"
    },
    {
      "code" : "MED96",
      "display" : "RETINA Y VITREO"
    },
    {
      "code" : "MED97",
      "display" : "PSICOANALIS CLINICO"
    },
    {
      "code" : "MED98",
      "display" : "ELECTROFISIOLOGIA"
    },
    {
      "code" : "MED99",
      "display" : "ADMINISTRACION DE HOSPITALES"
    },
    {
      "code" : "MED100",
      "display" : "PROCTOLOGIA"
    },
    {
      "code" : "MED101",
      "display" : "OFTALMOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED102",
      "display" : "ADMINISTRACION DE SISTEMAS DE INFORMACION EN SALUD"
    },
    {
      "code" : "MED103",
      "display" : "NEURO-ONCOLOGIA"
    },
    {
      "code" : "MED104",
      "display" : "GASTROENTEROLOGIA PEDIATRICA  Y NUTRICION"
    },
    {
      "code" : "MED105",
      "display" : "ORTOPEDIA"
    },
    {
      "code" : "MED106",
      "display" : "ACUPUNTURA"
    },
    {
      "code" : "MED107",
      "display" : "ULTRASONIDO GINECOBS"
    },
    {
      "code" : "MED108",
      "display" : "NEURORADIOLOGIA QUIRURGICA ENDOVASCULAR"
    },
    {
      "code" : "MED110",
      "display" : "CIRUGIA OCULOPLASTICA VIA LAGRIMAL Y ORBITA"
    },
    {
      "code" : "MED111",
      "display" : "HEMATOLOGIA Y HEMOTERAPIA PEDIATRICA"
    },
    {
      "code" : "MED112",
      "display" : "GINECOLOGIA ENDOCRINOLOGICA"
    },
    {
      "code" : "MED114",
      "display" : "GLAUCOMA"
    },
    {
      "code" : "MED115",
      "display" : "MEDICINA HIPERBARICA"
    },
    {
      "code" : "MED117",
      "display" : "CIRUGIA DE MANO"
    },
    {
      "code" : "MED118",
      "display" : "CUIDADOS INTENSIVOS PEDIATRICOS"
    },
    {
      "code" : "MED120",
      "display" : "ESTIMULACION TEMPRANA"
    },
    {
      "code" : "MED121",
      "display" : "PATOLOGIA"
    },
    {
      "code" : "MED122",
      "display" : "HEMAPATOLOGIA"
    },
    {
      "code" : "MED123",
      "display" : "PSIQUIATRIA DE INTERCONSULTA Y ENLACE"
    },
    {
      "code" : "MED124",
      "display" : "FARMACOLOGIA Y GERENCIA DE MEDICAMENTOS"
    },
    {
      "code" : "MED126",
      "display" : "DERMATOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED127",
      "display" : "EMERGENCIAS MEDICAS"
    },
    {
      "code" : "MED128",
      "display" : "MEDICINA DEL SUEÑO"
    },
    {
      "code" : "MED130",
      "display" : "CIRUGIA DERMATOLOGICA"
    },
    {
      "code" : "MED131",
      "display" : "BIOQUIMICA CLINICA"
    },
    {
      "code" : "MED133",
      "display" : "PSICOGERIATRIA"
    },
    {
      "code" : "MED134",
      "display" : "GENETICA CLINICA"
    },
    {
      "code" : "MED135",
      "display" : "GENETICA BIOQUIMICA MEDICA"
    },
    {
      "code" : "MED137",
      "display" : "NEUROSIQUIATRIA"
    },
    {
      "code" : "MED138",
      "display" : "FISIOLOGIA"
    },
    {
      "code" : "MED139",
      "display" : "GERONTOLOGIA"
    },
    {
      "code" : "MED141",
      "display" : "NEUROLOGIA VASCULAR"
    },
    {
      "code" : "MED142",
      "display" : "MEDICINA CRITICA"
    },
    {
      "code" : "MED144",
      "display" : "MEDICINA  PSICOSOMATICA"
    },
    {
      "code" : "MED145",
      "display" : "MEDICINA TROPICAL"
    },
    {
      "code" : "MED146",
      "display" : "RADIOISOTOPOS"
    },
    {
      "code" : "MED148",
      "display" : "FISIOTERAPIA"
    },
    {
      "code" : "MED149",
      "display" : "ENFERMEDADES BRONCOPULMONARES"
    },
    {
      "code" : "MED151",
      "display" : "CIT.EXFOLIATIVA.GINE"
    },
    {
      "code" : "MED152",
      "display" : "ENFERMEDADES INFECCIOSAS"
    },
    {
      "code" : "MED176",
      "display" : "PSIQUIATRÍA Y PSIQUIATRÍA DE INTERCONSULTA Y ENLACE"
    },
    {
      "code" : "MED132",
      "display" : "MEDICINA DEPORTIVA ORTOPEDICA"
    },
    {
      "code" : "MED136",
      "display" : "SALUD OCUPACIONAL"
    },
    {
      "code" : "MED140",
      "display" : "EMERGENCIAS PEDIATRICAS"
    },
    {
      "code" : "MED143",
      "display" : "GASTROENTEROLOGIA QUIRURGICA"
    },
    {
      "code" : "MED147",
      "display" : "TOXICOLOGIA"
    },
    {
      "code" : "MED150",
      "display" : "TISIOLOGIA"
    },
    {
      "code" : "MED153",
      "display" : "MEDICINA AEROESPACIAL"
    },
    {
      "code" : "59",
      "display" : "FARMACÉUTICO"
    },
    {
      "code" : "MED08",
      "display" : "APARATO DIGESTIVO"
    },
    {
      "code" : "MED13",
      "display" : "CIRUGIA PEDIATRICA"
    },
    {
      "code" : "MED18",
      "display" : "ENDOCRINOLOGIA Y NUTRICION"
    },
    {
      "code" : "MED02",
      "display" : "PEDIATRIA"
    },
    {
      "code" : "MED27",
      "display" : "NEUMOLOGIA"
    },
    {
      "code" : "MED31",
      "display" : "OBSTETRICIA Y GINECOLOGIA"
    },
    {
      "code" : "MED36",
      "display" : "PSIQUIATRIA"
    },
    {
      "code" : "MED41",
      "display" : "UROLOGIA"
    },
    {
      "code" : "MED45",
      "display" : "MEDICINA LEGAL"
    },
    {
      "code" : "MED50",
      "display" : "MEDICINA DE EMERGENCIAS"
    },
    {
      "code" : "MED55",
      "display" : "ANESTESIOLOGIA CARDIOVASCULAR Y TORACICA"
    },
    {
      "code" : "MED61",
      "display" : "MICROBIOLOGIA"
    },
    {
      "code" : "MED65",
      "display" : "FONIATRIA Y AUDIOLOGIA"
    },
    {
      "code" : "MED71",
      "display" : "GINECOLOGIA ONCOLOGICA"
    },
    {
      "code" : "MED76",
      "display" : "MEDICINA DEL DEPORTE"
    },
    {
      "code" : "MED81",
      "display" : "DESARROLLO REHABILITACION DEL NIÑO"
    },
    {
      "code" : "MED86",
      "display" : "OTORRINOLARINGOLOGIA PEDIATRICA"
    },
    {
      "code" : "ODO0",
      "display" : "ODONTÓLOGO"
    },
    {
      "code" : "MED03",
      "display" : "ALERGOLOGIA"
    },
    {
      "code" : "MED07",
      "display" : "ANGIOLOGIA Y CIRUGIA VASCULAR"
    },
    {
      "code" : "MED11",
      "display" : "CIRUGIA GENERAL Y DEL APARATO DIGESTIVO"
    },
    {
      "code" : "MED16",
      "display" : "DERMATOLOGIA MEDICO-QUIRURGICA Y VENEREOLOGIA"
    },
    {
      "code" : "MED21",
      "display" : "HEMATOLOGIA Y HEMOTERAPIA"
    },
    {
      "code" : "MED25",
      "display" : "MEDICINA NUCLEAR"
    },
    {
      "code" : "MED29",
      "display" : "NEUROFISIOLOGIA CLINICA"
    },
    {
      "code" : "MED34",
      "display" : "ONCOLOGIA RADIOTERAPICA"
    },
    {
      "code" : "MED38",
      "display" : "REUMATOLOGIA"
    },
    {
      "code" : "MED43",
      "display" : "RADIOLOGIA E IMAGENES MEDICAS"
    },
    {
      "code" : "MED47",
      "display" : "MEDICINA PALIATIVA EN ADULTOS"
    },
    {
      "code" : "MED52",
      "display" : "INFECTOLOGIA"
    },
    {
      "code" : "MED56",
      "display" : "EPIDEMIOLOGIA"
    },
    {
      "code" : "MED60",
      "display" : "DOCTORADO ACADEMICO EN CIENCIAS MEDICAS"
    },
    {
      "code" : "MED66",
      "display" : "INFECTOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED69",
      "display" : "FARMACOLOGIA CLINICA"
    },
    {
      "code" : "MED74",
      "display" : "TERAPIA INTENSIVA"
    },
    {
      "code" : "MED78",
      "display" : "ENDOCRINOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED83",
      "display" : "MEDICINA REPRODUCTIVA"
    },
    {
      "code" : "MED87",
      "display" : "HOMEOPATIA"
    },
    {
      "code" : "MED109",
      "display" : "PATOLOGIA FORENSE"
    },
    {
      "code" : "MED113",
      "display" : "MEDICINA EXTRACORPOREA"
    },
    {
      "code" : "MED116",
      "display" : "BIOETICA"
    },
    {
      "code" : "MED119",
      "display" : "ONCOLOGIA RADIOTERAPICA PEDIATRICA"
    },
    {
      "code" : "MED01",
      "display" : "MEDICO Y CIRUJANO"
    },
    {
      "code" : "MED125",
      "display" : "ANGIOLOGIA"
    },
    {
      "code" : "MED129",
      "display" : "ELECTROFISIOLOGIA CARDIACA"
    },
    {
      "code" : "MED154",
      "display" : "GINECOLOGIA Y OBSTETRICIA"
    },
    {
      "code" : "MED155",
      "display" : "ORTOPEDIA Y TRAUMATOLOGIA"
    },
    {
      "code" : "MED156",
      "display" : "CIRUGIA GENERAL"
    },
    {
      "code" : "MED157",
      "display" : "RADIOLOGIA"
    },
    {
      "code" : "MED158",
      "display" : "CIRUGIA PLASTICA Y RECONSTRUCTIVA"
    },
    {
      "code" : "MED159",
      "display" : "VASCULAR PERIFERICO"
    },
    {
      "code" : "MED160",
      "display" : "MEDICINA FISICA Y REHABILITACION"
    },
    {
      "code" : "MED161",
      "display" : "ADMINISTRACION DE SERVICIOS DE SALUD"
    },
    {
      "code" : "MED162",
      "display" : "DERMATOLOGIA"
    },
    {
      "code" : "MED163",
      "display" : "ANESTESIOLOGIA"
    },
    {
      "code" : "MED164",
      "display" : "HEMATOLOGIA"
    },
    {
      "code" : "MED165",
      "display" : "ORTOPEDIA Y REHABILITACION"
    },
    {
      "code" : "MED166",
      "display" : "ENDOCRINOLOGIA"
    },
    {
      "code" : "MED167",
      "display" : "ONCOLOGIA PEDIATRICA QUIRURGICA"
    },
    {
      "code" : "MED168",
      "display" : "GINECOLOGIA"
    },
    {
      "code" : "MED169",
      "display" : "OBSTETRICIA"
    },
    {
      "code" : "MED170",
      "display" : "GERIATRIA Y GERONTOLOGIA"
    },
    {
      "code" : "MED171",
      "display" : "NUTRICION"
    },
    {
      "code" : "MED172",
      "display" : "INMUNOLOGIA CLINICA"
    },
    {
      "code" : "MED173",
      "display" : "ONCOLOGIA MEDICA PEDIATRICA"
    },
    {
      "code" : "MED174",
      "display" : "HEMATOLOGIA PEDIATRICA"
    },
    {
      "code" : "MED175",
      "display" : "MEDICINA FAMILIAR"
    },
    {
      "code" : "ENF",
      "display" : "ENFERMERO"
    }
  ]
}

```
