# Catálogo de microorganismos - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de microorganismos**

## CodeSystem: Catálogo de microorganismos 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/microorganism-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MicroorganismCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de microorganismos en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Microorganism](ValueSet-Microorganism.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "microorganism-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/microorganism-code",
  "version" : "1.1.0-ballot",
  "name" : "MicroorganismCode",
  "title" : "Catálogo de microorganismos",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de microorganismos en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 1508,
  "concept" : [
    {
      "code" : "533",
      "display" : "Geotrichum candidum/Geo. penicillatum"
    },
    {
      "code" : "487",
      "display" : "Escherichia coli"
    },
    {
      "code" : "534",
      "display" : "Geotrichum capitatum"
    },
    {
      "code" : "535",
      "display" : "Geotrichum fermentans"
    },
    {
      "code" : "536",
      "display" : "Geotrichum penicillatum"
    },
    {
      "code" : "537",
      "display" : "Geotrichum spp. if true hyphae, arthrospores present"
    },
    {
      "code" : "538",
      "display" : "Giardia intestinalis (Giardia lamblia)"
    },
    {
      "code" : "539",
      "display" : "Globicatella sanguinis"
    },
    {
      "code" : "540",
      "display" : "Globicatella sulfidifaciens"
    },
    {
      "code" : "541",
      "display" : "Granulicatella adiacens"
    },
    {
      "code" : "542",
      "display" : "Granulicatella elegans"
    },
    {
      "code" : "543",
      "display" : "Grimontra hollisae"
    },
    {
      "code" : "544",
      "display" : "Haemophilus aegyptius"
    },
    {
      "code" : "545",
      "display" : "Haemophilus aphrophilus"
    },
    {
      "code" : "546",
      "display" : "Haemophilus ducreyi"
    },
    {
      "code" : "547",
      "display" : "Haemophilus haemoglobinophilus"
    },
    {
      "code" : "548",
      "display" : "Haemophilus haemolyticus"
    },
    {
      "code" : "549",
      "display" : "Haemophilus influenzae"
    },
    {
      "code" : "550",
      "display" : "Haemophilus influenzae I"
    },
    {
      "code" : "551",
      "display" : "Haemophilus influenzae II"
    },
    {
      "code" : "552",
      "display" : "Haemophilus influenzae III"
    },
    {
      "code" : "553",
      "display" : "Haemophilus influenzae IV"
    },
    {
      "code" : "554",
      "display" : "Haemophilus influenzae V"
    },
    {
      "code" : "555",
      "display" : "Haemophilus influenzae VI"
    },
    {
      "code" : "556",
      "display" : "Haemophilus influenzae VII"
    },
    {
      "code" : "557",
      "display" : "Haemophilus influenzae VIII"
    },
    {
      "code" : "559",
      "display" : "Haemophilus parahaemolyticus"
    },
    {
      "code" : "561",
      "display" : "Haemophilus parainfluenzae I"
    },
    {
      "code" : "563",
      "display" : "Haemophilus parainfluenzae III"
    },
    {
      "code" : "564",
      "display" : "Haemophilus parainfluenzae IV SEGNIS"
    },
    {
      "code" : "566",
      "display" : "Haemophilus parainfluenzae VI"
    },
    {
      "code" : "568",
      "display" : "Haemophilus parainfluenzae VIII"
    },
    {
      "code" : "570",
      "display" : "Haemophilus paraphrophilus"
    },
    {
      "code" : "572",
      "display" : "Haemophilus segnis"
    },
    {
      "code" : "574",
      "display" : "Haemophilus spp"
    },
    {
      "code" : "576",
      "display" : "Hansenula anomala"
    },
    {
      "code" : "578",
      "display" : "Hansenula polymorpha(Pichia angusta)"
    },
    {
      "code" : "580",
      "display" : "Helcococcus kunzii"
    },
    {
      "code" : "581",
      "display" : "Helicobacter cinaedi (Campylobacter cinaedi)"
    },
    {
      "code" : "583",
      "display" : "Helicobacter pylori (Campylobacter pylori)"
    },
    {
      "code" : "585",
      "display" : "Hymenolepsis nana"
    },
    {
      "code" : "587",
      "display" : "Isospora belli"
    },
    {
      "code" : "589",
      "display" : "Kingella kingae"
    },
    {
      "code" : "591",
      "display" : "Klebsiella oxytoca"
    },
    {
      "code" : "593",
      "display" : "Klebsiella ozaenae"
    },
    {
      "code" : "594",
      "display" : "Klebsiella pneumoniae"
    },
    {
      "code" : "596",
      "display" : "Klebsiella pneumoniae / Klebsiella oxytoca"
    },
    {
      "code" : "598",
      "display" : "Klebsiella rhinoscleromatis"
    },
    {
      "code" : "599",
      "display" : "Klebsiella spp"
    },
    {
      "code" : "602",
      "display" : "Kloeckera apis"
    },
    {
      "code" : "603",
      "display" : "Kloeckera apis/apiculata"
    },
    {
      "code" : "605",
      "display" : "Kloeckera japonica"
    },
    {
      "code" : "607",
      "display" : "Kloeckera spp"
    },
    {
      "code" : "608",
      "display" : "Kloeckera spp"
    },
    {
      "code" : "610",
      "display" : "Kluyvera ascorbata/cryocrescens"
    },
    {
      "code" : "612",
      "display" : "Kluyvera species"
    },
    {
      "code" : "614",
      "display" : "Kocuria kristinae (Micrococcus)"
    },
    {
      "code" : "617",
      "display" : "Kytococcus sedentarius"
    },
    {
      "code" : "619",
      "display" : "Lactobacillus acidophilus"
    },
    {
      "code" : "620",
      "display" : "Lactobacillus brevis"
    },
    {
      "code" : "622",
      "display" : "Lactobacillus casei"
    },
    {
      "code" : "624",
      "display" : "Lactobacillus cellobiosus"
    },
    {
      "code" : "626",
      "display" : "Lactobacillus coprophilus"
    },
    {
      "code" : "628",
      "display" : "Lactobacillus curvatus"
    },
    {
      "code" : "630",
      "display" : "Lactobacillus delbrueckii ssp delbrueckii"
    },
    {
      "code" : "632",
      "display" : "Lactobacillus delbrueckii ssp lactis (L.leichmannii)"
    },
    {
      "code" : "633",
      "display" : "Lactobacillus fermentum"
    },
    {
      "code" : "635",
      "display" : "Lactobacillus helveticus"
    },
    {
      "code" : "637",
      "display" : "Lactobacillus jensenii"
    },
    {
      "code" : "639",
      "display" : "Lactobacillus minutus"
    },
    {
      "code" : "641",
      "display" : "Lactobacillus paracasei ssp paracasei (L.casei lactosus)"
    },
    {
      "code" : "642",
      "display" : "Lactobacillus paracasei ssp paracasei (Lacto.casei pseudop.)"
    },
    {
      "code" : "644",
      "display" : "Lactobacillus plantarum"
    },
    {
      "code" : "646",
      "display" : "Lactobacillus salivarius"
    },
    {
      "code" : "647",
      "display" : "Lactobacillus salivarius var salicinius"
    },
    {
      "code" : "649",
      "display" : "Lactococcus garvieae"
    },
    {
      "code" : "651",
      "display" : "Lactococcus lactis ssp cremoris"
    },
    {
      "code" : "653",
      "display" : "Lactococcus lactis ssp diacitilactis"
    },
    {
      "code" : "655",
      "display" : "Lactococcus lactis ssp lactis"
    },
    {
      "code" : "656",
      "display" : "Lactococcus plantarum"
    },
    {
      "code" : "657",
      "display" : "Lactococcus raffinolactis (Str.raffinolactis)"
    },
    {
      "code" : "659",
      "display" : "Legionella pneumophila"
    },
    {
      "code" : "662",
      "display" : "Leptospira spp."
    },
    {
      "code" : "664",
      "display" : "Leuconostoc carnosum"
    },
    {
      "code" : "666",
      "display" : "Leuconostoc gelidum"
    },
    {
      "code" : "668",
      "display" : "Leuconostoc lactis"
    },
    {
      "code" : "670",
      "display" : "Leuconostoc mesenteroides ssp cremoris"
    },
    {
      "code" : "672",
      "display" : "Leuconostoc mesenteroides ssp dextranicum"
    },
    {
      "code" : "673",
      "display" : "Leuconostoc mesenteroides ssp mesenteroides"
    },
    {
      "code" : "675",
      "display" : "Leuconostoc pseudomesenteroides"
    },
    {
      "code" : "677",
      "display" : "Listeria grayi"
    },
    {
      "code" : "679",
      "display" : "Listeria grayi (Listeria murrayi)"
    },
    {
      "code" : "681",
      "display" : "Listeria innocua"
    },
    {
      "code" : "684",
      "display" : "Listeria ivanovii ssp londoniensis"
    },
    {
      "code" : "686",
      "display" : "Listeria seeligeri"
    },
    {
      "code" : "687",
      "display" : "Listeria seeligeri"
    },
    {
      "code" : "688",
      "display" : "Listeria species"
    },
    {
      "code" : "689",
      "display" : "Listeria welshimeri"
    },
    {
      "code" : "690",
      "display" : "Listeria welshimeri"
    },
    {
      "code" : "691",
      "display" : "Loa loa"
    },
    {
      "code" : "692",
      "display" : "Malassezia furfur"
    },
    {
      "code" : "693",
      "display" : "Malassezia furfur/Malassezia pachydermatis"
    },
    {
      "code" : "694",
      "display" : "Malassezia pachydermatis"
    },
    {
      "code" : "695",
      "display" : "Mannheimia haemolytica"
    },
    {
      "code" : "696",
      "display" : "Methylobacterium mesophilicum (Ps.mesophilica)"
    },
    {
      "code" : "697",
      "display" : "Methylobacterium spp"
    },
    {
      "code" : "698",
      "display" : "Microbacterium spp"
    },
    {
      "code" : "699",
      "display" : "Micrococcus luteus"
    },
    {
      "code" : "700",
      "display" : "Micrococcus lylae"
    },
    {
      "code" : "701",
      "display" : "Micrococcus lylae"
    },
    {
      "code" : "702",
      "display" : "Micrococcus species"
    },
    {
      "code" : "703",
      "display" : "Microsporum canis"
    },
    {
      "code" : "704",
      "display" : "Microsporum gypseum"
    },
    {
      "code" : "705",
      "display" : "Mobiluncus curtisii"
    },
    {
      "code" : "706",
      "display" : "Mobiluncus mulieris"
    },
    {
      "code" : "707",
      "display" : "Mobiluncus spp."
    },
    {
      "code" : "708",
      "display" : "Moellerella wisconsensis"
    },
    {
      "code" : "709",
      "display" : "Moraxella atlantae"
    },
    {
      "code" : "710",
      "display" : "Moraxella bovis"
    },
    {
      "code" : "711",
      "display" : "Moraxella group"
    },
    {
      "code" : "712",
      "display" : "Moraxella lacunata"
    },
    {
      "code" : "714",
      "display" : "Moraxella nonliquefaciens"
    },
    {
      "code" : "716",
      "display" : "Moraxella osloensis"
    },
    {
      "code" : "718",
      "display" : "Moraxella spp (Branhamella spp)"
    },
    {
      "code" : "720",
      "display" : "Morganella morganii ssp morganii"
    },
    {
      "code" : "722",
      "display" : "Morganella morganii ssp sibonii"
    },
    {
      "code" : "724",
      "display" : "Mycobacterium africanum"
    },
    {
      "code" : "726",
      "display" : "Mycobacterium avium"
    },
    {
      "code" : "728",
      "display" : "Mycobacterium bovis"
    },
    {
      "code" : "729",
      "display" : "Mycobacterium chelonae"
    },
    {
      "code" : "731",
      "display" : "Mycobacterium fortuitum"
    },
    {
      "code" : "734",
      "display" : "Mycobacterium haemophilum"
    },
    {
      "code" : "736",
      "display" : "Mycobacterium kansasii"
    },
    {
      "code" : "737",
      "display" : "Mycobacterium malmoense"
    },
    {
      "code" : "739",
      "display" : "Mycobacterium nonchromogenicum"
    },
    {
      "code" : "742",
      "display" : "Mycobacterium simiae"
    },
    {
      "code" : "744",
      "display" : "Mycobacterium spp"
    },
    {
      "code" : "746",
      "display" : "Mycobacterium terrae"
    },
    {
      "code" : "748",
      "display" : "Mycobacterium tuberculosis"
    },
    {
      "code" : "750",
      "display" : "Mycobacterium vaccae"
    },
    {
      "code" : "752",
      "display" : "Mycoplasma fermentans"
    },
    {
      "code" : "754",
      "display" : "Mycoplasma orale"
    },
    {
      "code" : "756",
      "display" : "Mycoplasma spp."
    },
    {
      "code" : "758",
      "display" : "Neisseria animaloris"
    },
    {
      "code" : "760",
      "display" : "Neisseria elongata"
    },
    {
      "code" : "762",
      "display" : "Neisseria elongata ssp elongata"
    },
    {
      "code" : "764",
      "display" : "Neisseria flavescens"
    },
    {
      "code" : "766",
      "display" : "Neisseria lactamica"
    },
    {
      "code" : "769",
      "display" : "Neisseria perflava"
    },
    {
      "code" : "771",
      "display" : "Neisseria sicca"
    },
    {
      "code" : "773",
      "display" : "Neisseria subflava"
    },
    {
      "code" : "775",
      "display" : "Neisseria zoodegmatis"
    },
    {
      "code" : "777",
      "display" : "Nonfermenting Gram-Negative Bacillus (saccharolytic)"
    },
    {
      "code" : "778",
      "display" : "Ochrobactrum anthropi"
    },
    {
      "code" : "780",
      "display" : "Oligella spp"
    },
    {
      "code" : "782",
      "display" : "Oligella urethralis"
    },
    {
      "code" : "784",
      "display" : "Paenibacillus (Bacillus) thiaminolitycus"
    },
    {
      "code" : "786",
      "display" : "Paenibacillus durus"
    },
    {
      "code" : "788",
      "display" : "Paenibacillus glucanolyticus (bacillus circulans)"
    },
    {
      "code" : "790",
      "display" : "Paenibacillus pabuli (paenibacillus polimyxa)"
    },
    {
      "code" : "792",
      "display" : "Paenibacillus polymyxa"
    },
    {
      "code" : "794",
      "display" : "Pantoea agglomerans"
    },
    {
      "code" : "796",
      "display" : "Pantoea ananas (Erwinia uredovora)"
    },
    {
      "code" : "798",
      "display" : "Pantoea spp (Enterobacter agglomerans)"
    },
    {
      "code" : "800",
      "display" : "Paracoccidioides brasiliensis"
    },
    {
      "code" : "803",
      "display" : "Pasteurella aerogenes"
    },
    {
      "code" : "805",
      "display" : "Pasteurella gallinarum"
    },
    {
      "code" : "806",
      "display" : "Pasteurella haemolytica"
    },
    {
      "code" : "808",
      "display" : "Pasteurella multocida ssp multocida"
    },
    {
      "code" : "810",
      "display" : "Pasteurella pneumotropica"
    },
    {
      "code" : "812",
      "display" : "Peanibacillus pabuli"
    },
    {
      "code" : "814",
      "display" : "Pediococcus acidilactici"
    },
    {
      "code" : "816",
      "display" : "Pediococcus pentosaceus"
    },
    {
      "code" : "819",
      "display" : "Peptococcus niger"
    },
    {
      "code" : "821",
      "display" : "Peptostreptococcus anaerobius"
    },
    {
      "code" : "823",
      "display" : "Peptostreptococcus indolicus"
    },
    {
      "code" : "825",
      "display" : "Peptostreptococcus micros"
    },
    {
      "code" : "827",
      "display" : "Peptostreptococcus spp"
    },
    {
      "code" : "828",
      "display" : "Peptostreptococcus tetradius"
    },
    {
      "code" : "830",
      "display" : "Pichia carsonii (Pichia vini)"
    },
    {
      "code" : "833",
      "display" : "Pichia ohmeri"
    },
    {
      "code" : "835",
      "display" : "Pichia spp"
    },
    {
      "code" : "837",
      "display" : "Plasmodium malariae"
    },
    {
      "code" : "839",
      "display" : "Plasmodium spp."
    },
    {
      "code" : "842",
      "display" : "Pneumocystis carinii"
    },
    {
      "code" : "844",
      "display" : "Porphyromonas asaccharolytica (Bac.asaccharolyticus)"
    },
    {
      "code" : "845",
      "display" : "Porphyromonas endodontalis (Bacteroides endodontalis)"
    },
    {
      "code" : "847",
      "display" : "Porphyromonas levii"
    },
    {
      "code" : "850",
      "display" : "Prevotella buccalis (Bacteroides buccalis)"
    },
    {
      "code" : "852",
      "display" : "Prevotella denticola"
    },
    {
      "code" : "854",
      "display" : "Prevotella intermedia"
    },
    {
      "code" : "855",
      "display" : "Prevotella loescheii"
    },
    {
      "code" : "856",
      "display" : "Prevotella loescheii/denticola"
    },
    {
      "code" : "857",
      "display" : "Prevotella melaninogenica"
    },
    {
      "code" : "858",
      "display" : "Prevotella oralis"
    },
    {
      "code" : "859",
      "display" : "Prevotella oris"
    },
    {
      "code" : "860",
      "display" : "Prevotella oris/buccae (Prev.rum.ssp brevis)"
    },
    {
      "code" : "861",
      "display" : "Prevotella ruminicola"
    },
    {
      "code" : "862",
      "display" : "Propionibacterium acnes"
    },
    {
      "code" : "863",
      "display" : "Propionibacterium avidum"
    },
    {
      "code" : "864",
      "display" : "Propionibacterium granulosum"
    },
    {
      "code" : "865",
      "display" : "Propionibacterium propionicum"
    },
    {
      "code" : "866",
      "display" : "Propionibacterium propionicus"
    },
    {
      "code" : "867",
      "display" : "Propionibacterium spp"
    },
    {
      "code" : "868",
      "display" : "Proteus mirabilis"
    },
    {
      "code" : "869",
      "display" : "Proteus penneri"
    },
    {
      "code" : "870",
      "display" : "Proteus species"
    },
    {
      "code" : "871",
      "display" : "Proteus vulgaris"
    },
    {
      "code" : "872",
      "display" : "Proteus vulgaris group/(Proteus penneri)"
    },
    {
      "code" : "873",
      "display" : "Prototheca wickerhamii"
    },
    {
      "code" : "874",
      "display" : "Prototheca zopfii"
    },
    {
      "code" : "875",
      "display" : "Providencia alcalifaciens"
    },
    {
      "code" : "876",
      "display" : "Providencia heimbachae"
    },
    {
      "code" : "877",
      "display" : "Providencia rettgeri"
    },
    {
      "code" : "878",
      "display" : "Providencia rustigianii"
    },
    {
      "code" : "879",
      "display" : "Providencia species"
    },
    {
      "code" : "2",
      "display" : "Abiotrophia defectiva"
    },
    {
      "code" : "4",
      "display" : "Achromobacter spp"
    },
    {
      "code" : "5",
      "display" : "Achromobacter xylosoxidans ssp. denitrificans"
    },
    {
      "code" : "7",
      "display" : "Acinetobacter alcaligenes"
    },
    {
      "code" : "8",
      "display" : "Acinetobacter anitratus"
    },
    {
      "code" : "10",
      "display" : "Acinetobacter baumannii complex"
    },
    {
      "code" : "12",
      "display" : "Acinetobacter calcoaceticus"
    },
    {
      "code" : "13",
      "display" : "Acinetobacter calcoaceticus-baumannii complex"
    },
    {
      "code" : "15",
      "display" : "Acinetobacter genospecies 3"
    },
    {
      "code" : "17",
      "display" : "Acinetobacter johnsonii"
    },
    {
      "code" : "19",
      "display" : "Acinetobacter lwoffii"
    },
    {
      "code" : "21",
      "display" : "Acinetobacter radioresistens"
    },
    {
      "code" : "24",
      "display" : "Acinetobactergenospecies 3"
    },
    {
      "code" : "26",
      "display" : "Actinobacillus capsulatus"
    },
    {
      "code" : "27",
      "display" : "Actinobacillus equuli"
    },
    {
      "code" : "29",
      "display" : "Actinobacillus lignieresii"
    },
    {
      "code" : "31",
      "display" : "Actinobacillus spp"
    },
    {
      "code" : "32",
      "display" : "Actinobacillus suis"
    },
    {
      "code" : "35",
      "display" : "Actinomyces israelii"
    },
    {
      "code" : "37",
      "display" : "Actinomyces meyeri"
    },
    {
      "code" : "39",
      "display" : "Actinomyces neuii ssp anitratus"
    },
    {
      "code" : "41",
      "display" : "Actinomyces odontolyticus"
    },
    {
      "code" : "43",
      "display" : "Actinomyces radingae"
    },
    {
      "code" : "46",
      "display" : "Actinomyces viscosus"
    },
    {
      "code" : "48",
      "display" : "Aerococcus"
    },
    {
      "code" : "50",
      "display" : "Aerococcus viridans"
    },
    {
      "code" : "53",
      "display" : "Aeromonas hydrophila/caviae"
    },
    {
      "code" : "55",
      "display" : "Aeromonas salmonicida"
    },
    {
      "code" : "57",
      "display" : "Aeromonas salmonicida ssp masoucida"
    },
    {
      "code" : "59",
      "display" : "Aeromonas schubertii"
    },
    {
      "code" : "60",
      "display" : "Aeromonas sobria"
    },
    {
      "code" : "63",
      "display" : "Agrobacterium radiobacter"
    },
    {
      "code" : "64",
      "display" : "Agrobacterium spp"
    },
    {
      "code" : "66",
      "display" : "Agrobacterium tumefaciens (Agrobacterium radiobacter)"
    },
    {
      "code" : "69",
      "display" : "Alcaligenes odorans(Alcaligenes faecalis)"
    },
    {
      "code" : "70",
      "display" : "Alcaligenes spp"
    },
    {
      "code" : "72",
      "display" : "Alloiococcus otitis"
    },
    {
      "code" : "74",
      "display" : "Anaerovibrio lipolytica"
    },
    {
      "code" : "76",
      "display" : "aneuribacillus aneurillyticus"
    },
    {
      "code" : "78",
      "display" : "Arcanobacterium haemolyticum"
    },
    {
      "code" : "79",
      "display" : "Arcanobacterium pyogenes (Actinomyces pyogenes)"
    },
    {
      "code" : "81",
      "display" : "Arthrobacter globiformis"
    },
    {
      "code" : "82",
      "display" : "Arthrobacter spp"
    },
    {
      "code" : "84",
      "display" : "Aspergillus flavus"
    },
    {
      "code" : "86",
      "display" : "Aspergillus niger"
    },
    {
      "code" : "88",
      "display" : "Aureobacterium spp"
    },
    {
      "code" : "91",
      "display" : "Bacillus amyloliquefaciens"
    },
    {
      "code" : "93",
      "display" : "Bacillus anthracis"
    },
    {
      "code" : "95",
      "display" : "Bacillus atrophacus"
    },
    {
      "code" : "97",
      "display" : "Bacillus badius"
    },
    {
      "code" : "100",
      "display" : "Bacillus circulans"
    },
    {
      "code" : "102",
      "display" : "Bacillus firmus"
    },
    {
      "code" : "104",
      "display" : "Bacillus laterosporus"
    },
    {
      "code" : "107",
      "display" : "Bacillus macerans"
    },
    {
      "code" : "109",
      "display" : "Bacillus mycoides"
    },
    {
      "code" : "111",
      "display" : "Bacillus polymyxa"
    },
    {
      "code" : "113",
      "display" : "Bacillus simplex"
    },
    {
      "code" : "115",
      "display" : "Bacillus species"
    },
    {
      "code" : "117",
      "display" : "Bacillus sporothermo durans"
    },
    {
      "code" : "119",
      "display" : "Bacillus subtilis"
    },
    {
      "code" : "121",
      "display" : "Bacillus subtilis var. atterimus"
    },
    {
      "code" : "123",
      "display" : "Bacillus thermoliticus"
    },
    {
      "code" : "125",
      "display" : "Bacillus vallismatis"
    },
    {
      "code" : "127",
      "display" : "Bacteroides capillosus"
    },
    {
      "code" : "129",
      "display" : "Bacteroides eggerthii"
    },
    {
      "code" : "131",
      "display" : "Bacteroides merdae"
    },
    {
      "code" : "133",
      "display" : "Bacteroides splanchnicus"
    },
    {
      "code" : "136",
      "display" : "Bacteroides thetaiotaomicron"
    },
    {
      "code" : "138",
      "display" : "Bacteroides ureolyticus"
    },
    {
      "code" : "140",
      "display" : "Balantidium coli"
    },
    {
      "code" : "142",
      "display" : "Bifidobacterium adolescentis"
    },
    {
      "code" : "144",
      "display" : "Bifidobacterium breve"
    },
    {
      "code" : "146",
      "display" : "Bifidobacterium infantis"
    },
    {
      "code" : "147",
      "display" : "Bifidobacterium species"
    },
    {
      "code" : "148",
      "display" : "Blastocystis hominis"
    },
    {
      "code" : "149",
      "display" : "Blastomyces dermatitidis"
    },
    {
      "code" : "150",
      "display" : "Blastoschizomyces capitatus"
    },
    {
      "code" : "151",
      "display" : "Blastoschizomyces capitatus/Prototheca zopfii"
    },
    {
      "code" : "152",
      "display" : "Bordetella avium"
    },
    {
      "code" : "153",
      "display" : "Bordetella bronchiseptica"
    },
    {
      "code" : "154",
      "display" : "Bordetella parapertussis"
    },
    {
      "code" : "155",
      "display" : "Bordetella pertussis"
    },
    {
      "code" : "156",
      "display" : "Bordetella spp"
    },
    {
      "code" : "157",
      "display" : "Bordetella trematum"
    },
    {
      "code" : "158",
      "display" : "Borrelia spp"
    },
    {
      "code" : "159",
      "display" : "Branhamella catarrhalis"
    },
    {
      "code" : "160",
      "display" : "Brevibacillus (Bacillus) borstelensis"
    },
    {
      "code" : "161",
      "display" : "Brevibacillus (Bacillus) brevis"
    },
    {
      "code" : "162",
      "display" : "Brevibacillus (Bacillus) parabrevis"
    },
    {
      "code" : "163",
      "display" : "Brevibacillus agri"
    },
    {
      "code" : "164",
      "display" : "Brevibacillus borstelensis"
    },
    {
      "code" : "165",
      "display" : "Brevibacillus choshinensis"
    },
    {
      "code" : "166",
      "display" : "Brevibacillus invocatus"
    },
    {
      "code" : "167",
      "display" : "Brevibacillus laterosporus"
    },
    {
      "code" : "168",
      "display" : "Brevibacillus laterosporus"
    },
    {
      "code" : "169",
      "display" : "Brevibacillus parabrevis"
    },
    {
      "code" : "170",
      "display" : "Brevibacilus centrosporum"
    },
    {
      "code" : "171",
      "display" : "Brevibacterium casei"
    },
    {
      "code" : "173",
      "display" : "Brevibacterium linens"
    },
    {
      "code" : "175",
      "display" : "Brevundimonas diminuta"
    },
    {
      "code" : "177",
      "display" : "Brochothrix thermosphacta"
    },
    {
      "code" : "179",
      "display" : "Brucella melitensis biovar abortus"
    },
    {
      "code" : "181",
      "display" : "Brucella melitensis biovar melitensis"
    },
    {
      "code" : "183",
      "display" : "Brucella melitensis biovar suis"
    },
    {
      "code" : "185",
      "display" : "Brucella spp"
    },
    {
      "code" : "187",
      "display" : "Burkholderia cepacia"
    },
    {
      "code" : "189",
      "display" : "Burkholderia gladioli"
    },
    {
      "code" : "191",
      "display" : "Burkholderia mallei"
    },
    {
      "code" : "193",
      "display" : "Burkholderia pickettii (thomasii) (Ps. pickettii - thomasii)"
    },
    {
      "code" : "195",
      "display" : "Burkholderia pickettii bio.2 (Pseudomonas pickettii bio.2)"
    },
    {
      "code" : "196",
      "display" : "Burkholderia pseudomallei"
    },
    {
      "code" : "198",
      "display" : "Burkholderia thomasii"
    },
    {
      "code" : "200",
      "display" : "Buttiauxella agrestis"
    },
    {
      "code" : "202",
      "display" : "Campylobacter coli"
    },
    {
      "code" : "204",
      "display" : "Campylobacter concisus EF22"
    },
    {
      "code" : "206",
      "display" : "Campylobacter fetus ssp fetus"
    },
    {
      "code" : "208",
      "display" : "Campylobacter fetus ssp venerealis"
    },
    {
      "code" : "210",
      "display" : "Campylobacter jejuni"
    },
    {
      "code" : "212",
      "display" : "Campylobacter jejuni ssp jejuni"
    },
    {
      "code" : "214",
      "display" : "Campylobacter lari"
    },
    {
      "code" : "215",
      "display" : "Campylobacter lari ssp UPTC"
    },
    {
      "code" : "217",
      "display" : "Campylobacter mucosalis"
    },
    {
      "code" : "220",
      "display" : "Campylobacter sputorum ssp bubulus"
    },
    {
      "code" : "222",
      "display" : "Campylobacter sputorum ssp sputorum"
    },
    {
      "code" : "223",
      "display" : "Campylobacter upsaliensis"
    },
    {
      "code" : "225",
      "display" : "Candida boidinii"
    },
    {
      "code" : "228",
      "display" : "Candida ciferrii"
    },
    {
      "code" : "230",
      "display" : "Candida conglobata"
    },
    {
      "code" : "232",
      "display" : "Candida dattila/Kluyveromyces thermotolerans"
    },
    {
      "code" : "233",
      "display" : "Candida dubliniensis"
    },
    {
      "code" : "236",
      "display" : "Candida freyschussii"
    },
    {
      "code" : "237",
      "display" : "Candida glabrata"
    },
    {
      "code" : "239",
      "display" : "Candida guilliermondii"
    },
    {
      "code" : "241",
      "display" : "Candida hellenica/Zygoascus hellenicus"
    },
    {
      "code" : "242",
      "display" : "Candida holmii"
    },
    {
      "code" : "244",
      "display" : "Candida inconspicua/norvegensis"
    },
    {
      "code" : "247",
      "display" : "Candida krusei"
    },
    {
      "code" : "249",
      "display" : "Candida lipolytica"
    },
    {
      "code" : "251",
      "display" : "Candida magnoliae"
    },
    {
      "code" : "254",
      "display" : "Candida membranaefaciens"
    },
    {
      "code" : "256",
      "display" : "Candida norvegica"
    },
    {
      "code" : "258",
      "display" : "Candida paratropicalis"
    },
    {
      "code" : "260",
      "display" : "Candida pulcherrima"
    },
    {
      "code" : "262",
      "display" : "Candida sake"
    },
    {
      "code" : "264",
      "display" : "Candida species,not albicans"
    },
    {
      "code" : "266",
      "display" : "Candida sphaerica/Kluyveromyces lactis"
    },
    {
      "code" : "269",
      "display" : "Candida tropicalis"
    },
    {
      "code" : "271",
      "display" : "Candida utilis"
    },
    {
      "code" : "272",
      "display" : "Candida valida"
    },
    {
      "code" : "274",
      "display" : "Capnocytophaga gingivalis"
    },
    {
      "code" : "276",
      "display" : "Capnocytophaga species"
    },
    {
      "code" : "278",
      "display" : "Cardiobacterium hominis"
    },
    {
      "code" : "280",
      "display" : "Carnobacterium piscicola"
    },
    {
      "code" : "282",
      "display" : "Cedecea lapagei"
    },
    {
      "code" : "285",
      "display" : "Cellulomonas spp"
    },
    {
      "code" : "287",
      "display" : "Cephalosporium acremonium"
    },
    {
      "code" : "288",
      "display" : "Chilomatix mesnili"
    },
    {
      "code" : "291",
      "display" : "Chlamydia trachomatis"
    },
    {
      "code" : "293",
      "display" : "Chromobacterium violaceum"
    },
    {
      "code" : "295",
      "display" : "Chryseobacterium (Flavobacterium) meningosepticum"
    },
    {
      "code" : "296",
      "display" : "Chryseobacterium gleum"
    },
    {
      "code" : "298",
      "display" : "Chryseobacterium indologenes"
    },
    {
      "code" : "300",
      "display" : "Chryseomonas luteola/Flavimonas oryzihabitans"
    },
    {
      "code" : "302",
      "display" : "Citrobacter amalonaticus/farmeri"
    },
    {
      "code" : "304",
      "display" : "Citrobacter farmeri"
    },
    {
      "code" : "306",
      "display" : "Citrobacter freundii complex"
    },
    {
      "code" : "308",
      "display" : "Citrobacter sedlakii"
    },
    {
      "code" : "309",
      "display" : "Citrobacter sedlakii"
    },
    {
      "code" : "310",
      "display" : "Citrobacter species (cdc enteric group 17)"
    },
    {
      "code" : "311",
      "display" : "Citrobacter species (cdc enteric group 17) / E. cloacae"
    },
    {
      "code" : "312",
      "display" : "Citrobacter youngae"
    },
    {
      "code" : "313",
      "display" : "Cladosporium spp."
    },
    {
      "code" : "314",
      "display" : "Clostridium acetobutylicum"
    },
    {
      "code" : "315",
      "display" : "Clostridium barati"
    },
    {
      "code" : "316",
      "display" : "Clostridium beijerinckii"
    },
    {
      "code" : "317",
      "display" : "Clostridium bifermentans"
    },
    {
      "code" : "318",
      "display" : "Clostridium botulinum"
    },
    {
      "code" : "319",
      "display" : "Clostridium botulinum(NP) BF"
    },
    {
      "code" : "320",
      "display" : "Clostridium botulinum(NP) E"
    },
    {
      "code" : "321",
      "display" : "Clostridium botulinum(P) AB"
    },
    {
      "code" : "322",
      "display" : "Clostridium botulinum(P) F"
    },
    {
      "code" : "323",
      "display" : "Clostridium butyricum"
    },
    {
      "code" : "324",
      "display" : "Clostridium cadaveris"
    },
    {
      "code" : "325",
      "display" : "Clostridium chauvoei"
    },
    {
      "code" : "326",
      "display" : "Clostridium clostridiiforme"
    },
    {
      "code" : "327",
      "display" : "Clostridium clostridiiforme"
    },
    {
      "code" : "328",
      "display" : "Clostridium difficile"
    },
    {
      "code" : "329",
      "display" : "Clostridium fallax"
    },
    {
      "code" : "330",
      "display" : "Clostridium glycolicum"
    },
    {
      "code" : "331",
      "display" : "Clostridium hastiforme"
    },
    {
      "code" : "332",
      "display" : "Clostridium histolyticum"
    },
    {
      "code" : "333",
      "display" : "Clostridium innocuum"
    },
    {
      "code" : "334",
      "display" : "Clostridium limosum"
    },
    {
      "code" : "336",
      "display" : "Clostridium paraputrificum"
    },
    {
      "code" : "338",
      "display" : "Clostridium putrificum"
    },
    {
      "code" : "341",
      "display" : "Clostridium sordellii"
    },
    {
      "code" : "343",
      "display" : "Clostridium sporogenes"
    },
    {
      "code" : "345",
      "display" : "Clostridium subterminale"
    },
    {
      "code" : "347",
      "display" : "Clostridium tetani"
    },
    {
      "code" : "349",
      "display" : "Coccidioides immitis"
    },
    {
      "code" : "351",
      "display" : "Comamonas testosteroni"
    },
    {
      "code" : "353",
      "display" : "Corynebacterium afermentans"
    },
    {
      "code" : "355",
      "display" : "Corynebacterium amycolatum"
    },
    {
      "code" : "357",
      "display" : "Corynebacterium argentoratense"
    },
    {
      "code" : "359",
      "display" : "Corynebacterium bovis"
    },
    {
      "code" : "361",
      "display" : "Corynebacterium cystitidis"
    },
    {
      "code" : "363",
      "display" : "Corynebacterium diphtheriae biotype belfanti"
    },
    {
      "code" : "365",
      "display" : "Corynebacterium diphtheriae biotype intermedius"
    },
    {
      "code" : "366",
      "display" : "Corynebacterium diphtheriae biotype mitis"
    },
    {
      "code" : "368",
      "display" : "Corynebacterium glucuronolyticum"
    },
    {
      "code" : "370",
      "display" : "Corynebacterium group A_4"
    },
    {
      "code" : "372",
      "display" : "Corynebacterium group ANF"
    },
    {
      "code" : "374",
      "display" : "Corynebacterium group B_3"
    },
    {
      "code" : "376",
      "display" : "Corynebacterium group F_1"
    },
    {
      "code" : "378",
      "display" : "Corynebacterium group G"
    },
    {
      "code" : "380",
      "display" : "Corynebacterium group G_2"
    },
    {
      "code" : "382",
      "display" : "Corynebacterium group I_2"
    },
    {
      "code" : "384",
      "display" : "Corynebacterium kutscheri (Corynebacterium murium)"
    },
    {
      "code" : "386",
      "display" : "Corynebacterium minutissimum"
    },
    {
      "code" : "388",
      "display" : "Corynebacterium pilosum"
    },
    {
      "code" : "390",
      "display" : "Corynebacterium pseudodiphthericum"
    },
    {
      "code" : "391",
      "display" : "Corynebacterium pseudodiphtheriticum"
    },
    {
      "code" : "393",
      "display" : "Corynebacterium renale"
    },
    {
      "code" : "395",
      "display" : "Corynebacterium seminale"
    },
    {
      "code" : "397",
      "display" : "Corynebacterium striatum"
    },
    {
      "code" : "399",
      "display" : "Corynebacterium ulcerans"
    },
    {
      "code" : "400",
      "display" : "Corynebacterium ulcerans"
    },
    {
      "code" : "402",
      "display" : "Corynebacterium urealyticum (Coryne.group D2)"
    },
    {
      "code" : "404",
      "display" : "Cryptococcus albidus"
    },
    {
      "code" : "406",
      "display" : "Cryptococcus laurentii"
    },
    {
      "code" : "408",
      "display" : "Cryptococcus neoformans"
    },
    {
      "code" : "410",
      "display" : "Cryptococcus terreus"
    },
    {
      "code" : "411",
      "display" : "Cryptococcus uniguttulatus"
    },
    {
      "code" : "414",
      "display" : "Cyclospora spp."
    },
    {
      "code" : "416",
      "display" : "Debaryomyces polymorphus (Debaryo.phaffii)"
    },
    {
      "code" : "418",
      "display" : "Delftia acidovorans"
    },
    {
      "code" : "420",
      "display" : "Dermacoccus nishinomiyaensis"
    },
    {
      "code" : "422",
      "display" : "Dientamoeba fragilis"
    },
    {
      "code" : "424",
      "display" : "Diphyllobothrium latum"
    },
    {
      "code" : "426",
      "display" : "Echinococcus spp."
    },
    {
      "code" : "428",
      "display" : "Edwardsiella ictaluri"
    },
    {
      "code" : "430",
      "display" : "Edwardsiella tarda"
    },
    {
      "code" : "432",
      "display" : "Empedobacter brevis"
    },
    {
      "code" : "435",
      "display" : "Entamoeba gingivalis"
    },
    {
      "code" : "437",
      "display" : "Entamoeba histolitica/dispar"
    },
    {
      "code" : "439",
      "display" : "Enterobacter aerogenes"
    },
    {
      "code" : "441",
      "display" : "Enterobacter amnigenus biogroup 1"
    },
    {
      "code" : "443",
      "display" : "Enterobacter asburiae"
    },
    {
      "code" : "445",
      "display" : "Enterobacter cloacae"
    },
    {
      "code" : "447",
      "display" : "Enterobacter gergoviae"
    },
    {
      "code" : "449",
      "display" : "Enterobacter intermedius"
    },
    {
      "code" : "451",
      "display" : "Enterobacter species"
    },
    {
      "code" : "453",
      "display" : "Enterococcus avium"
    },
    {
      "code" : "455",
      "display" : "Enterococcus casseliflavus/Enterococcus gallinarum"
    },
    {
      "code" : "457",
      "display" : "Enterococcus durans"
    },
    {
      "code" : "458",
      "display" : "Enterococcus faecalis"
    },
    {
      "code" : "460",
      "display" : "Enterococcus gallinarum"
    },
    {
      "code" : "462",
      "display" : "Enterococcus malodoratus"
    },
    {
      "code" : "464",
      "display" : "Enterococcus raffinosus"
    },
    {
      "code" : "466",
      "display" : "Enterococcus saccharolyticus (Str.saccharolyticus)"
    },
    {
      "code" : "468",
      "display" : "Enterococcus species (Motility +)"
    },
    {
      "code" : "469",
      "display" : "Enterococcus spp"
    },
    {
      "code" : "470",
      "display" : "Epidermophyton floccosum"
    },
    {
      "code" : "471",
      "display" : "Erwinia amylovora"
    },
    {
      "code" : "472",
      "display" : "Erwinia carotovora"
    },
    {
      "code" : "473",
      "display" : "Erwinia carotovora ssp atroseptica"
    },
    {
      "code" : "474",
      "display" : "Erwinia carotovora ssp betavasculorum"
    },
    {
      "code" : "475",
      "display" : "Erwinia carotovora ssp carotovora"
    },
    {
      "code" : "476",
      "display" : "Erwinia chrysanthemi"
    },
    {
      "code" : "477",
      "display" : "Erwinia cypripedii"
    },
    {
      "code" : "478",
      "display" : "Erwinia mallotivora"
    },
    {
      "code" : "479",
      "display" : "Erwinia nigrifluens"
    },
    {
      "code" : "480",
      "display" : "Erwinia quercina"
    },
    {
      "code" : "481",
      "display" : "Erwinia rhapontici"
    },
    {
      "code" : "482",
      "display" : "Erwinia rubrifaciens"
    },
    {
      "code" : "483",
      "display" : "Erwinia salicis"
    },
    {
      "code" : "484",
      "display" : "Erwinia spp"
    },
    {
      "code" : "485",
      "display" : "Erysipelothrix rhusiopathiae"
    },
    {
      "code" : "486",
      "display" : "Escherichia blattae"
    },
    {
      "code" : "488",
      "display" : "Escherichia coli / Hafnia alvei"
    },
    {
      "code" : "489",
      "display" : "Escherichia coli O157"
    },
    {
      "code" : "490",
      "display" : "Escherichia coli, inactive"
    },
    {
      "code" : "491",
      "display" : "Escherichia fergusonii"
    },
    {
      "code" : "492",
      "display" : "Escherichia hermannii"
    },
    {
      "code" : "493",
      "display" : "Escherichia spp"
    },
    {
      "code" : "494",
      "display" : "Escherichia vulneris"
    },
    {
      "code" : "496",
      "display" : "Eubacterium lentum"
    },
    {
      "code" : "498",
      "display" : "Eubacterium moniliforme"
    },
    {
      "code" : "501",
      "display" : "Ewingella americana"
    },
    {
      "code" : "503",
      "display" : "Fasciola hepatica"
    },
    {
      "code" : "505",
      "display" : "Flavimonas oryzihabitans"
    },
    {
      "code" : "507",
      "display" : "Flavobacterium odoratum"
    },
    {
      "code" : "509",
      "display" : "Francisella spp"
    },
    {
      "code" : "511",
      "display" : "Fusarium oxysporum"
    },
    {
      "code" : "513",
      "display" : "Fusobacterium necrogenes"
    },
    {
      "code" : "515",
      "display" : "Fusobacterium nucleatum"
    },
    {
      "code" : "517",
      "display" : "Fusobacterium spp"
    },
    {
      "code" : "519",
      "display" : "Gardnerella vaginalis"
    },
    {
      "code" : "522",
      "display" : "Gemella morbillorum"
    },
    {
      "code" : "524",
      "display" : "Gemella morbillorum/S. agalactiae(Group B)/S. acidominimus"
    },
    {
      "code" : "526",
      "display" : "Gemella spp"
    },
    {
      "code" : "528",
      "display" : "Geobacillus (Bacillus) thermodenitrificans"
    },
    {
      "code" : "529",
      "display" : "Geobacillus (Bacillus) thermoglucosidans"
    },
    {
      "code" : "531",
      "display" : "Geotrichum (Trichosporon) capitatum/Dipodascus capitatus"
    },
    {
      "code" : "880",
      "display" : "Providencia stuartii"
    },
    {
      "code" : "882",
      "display" : "Pseudomonas aeruginosa"
    },
    {
      "code" : "884",
      "display" : "Pseudomonas chlororaphis"
    },
    {
      "code" : "886",
      "display" : "Pseudomonas fluorescens"
    },
    {
      "code" : "887",
      "display" : "Pseudomonas fluorescens / putida / mendocina"
    },
    {
      "code" : "889",
      "display" : "Pseudomonas luteola"
    },
    {
      "code" : "891",
      "display" : "Pseudomonas mendocina"
    },
    {
      "code" : "893",
      "display" : "Pseudomonas oryzihabitans"
    },
    {
      "code" : "895",
      "display" : "Pseudomonas putida"
    },
    {
      "code" : "897",
      "display" : "Pseudomonas stutzeri"
    },
    {
      "code" : "899",
      "display" : "Pseudoramibacter alactolyticus (Eubacterium)"
    },
    {
      "code" : "901",
      "display" : "Rahnella aquatilis"
    },
    {
      "code" : "903",
      "display" : "Ralstonia paucula"
    },
    {
      "code" : "905",
      "display" : "Raoultella ornithinolytica"
    },
    {
      "code" : "907",
      "display" : "Raoultella terrigena"
    },
    {
      "code" : "910",
      "display" : "Rhodococcus spp"
    },
    {
      "code" : "911",
      "display" : "Rhodotorula glutinis"
    },
    {
      "code" : "913",
      "display" : "Rhodotorula glutinis/Rhodotorula mucilaginosa"
    },
    {
      "code" : "914",
      "display" : "Rhodotorula minuta"
    },
    {
      "code" : "916",
      "display" : "Rhodotorula mucilaginosa (Rhodotorula rubra)"
    },
    {
      "code" : "918",
      "display" : "Rhodotorula spp"
    },
    {
      "code" : "921",
      "display" : "Rothia dentocariosa"
    },
    {
      "code" : "923",
      "display" : "Saccharomyces cerevisiae"
    },
    {
      "code" : "925",
      "display" : "Saccharomyces spp"
    },
    {
      "code" : "927",
      "display" : "Salmonella choleraesuis ssp. choleraesuis"
    },
    {
      "code" : "929",
      "display" : "Salmonella gallinarum"
    },
    {
      "code" : "931",
      "display" : "Salmonella group a"
    },
    {
      "code" : "933",
      "display" : "Salmonella group c1"
    },
    {
      "code" : "935",
      "display" : "Salmonella group d"
    },
    {
      "code" : "938",
      "display" : "Salmonella ser. paratyphi A"
    },
    {
      "code" : "940",
      "display" : "Salmonella ser. paratyphi C"
    },
    {
      "code" : "942",
      "display" : "Salmonella typhi"
    },
    {
      "code" : "944",
      "display" : "Salmonella typhisuis"
    },
    {
      "code" : "946",
      "display" : "Schistosoma haematobium"
    },
    {
      "code" : "948",
      "display" : "Schistosoma mansoni"
    },
    {
      "code" : "950",
      "display" : "Serratia ficaria"
    },
    {
      "code" : "952",
      "display" : "Serratia grimesii"
    },
    {
      "code" : "954",
      "display" : "Serratia liquefaciens group"
    },
    {
      "code" : "956",
      "display" : "Serratia odorifera"
    },
    {
      "code" : "958",
      "display" : "Serratia proteamaculans"
    },
    {
      "code" : "960",
      "display" : "Serratia proteamaculans ssp quinovora"
    },
    {
      "code" : "962",
      "display" : "Serratia species"
    },
    {
      "code" : "964",
      "display" : "Shewanella algae"
    },
    {
      "code" : "966",
      "display" : "Shewanella putrefaciens group"
    },
    {
      "code" : "969",
      "display" : "Shigella dysenteriae"
    },
    {
      "code" : "971",
      "display" : "Shigella group"
    },
    {
      "code" : "973",
      "display" : "Shigella spp"
    },
    {
      "code" : "975",
      "display" : "Sphingobacterium spiritivorum"
    },
    {
      "code" : "977",
      "display" : "Sphingomonas paucimobilis"
    },
    {
      "code" : "979",
      "display" : "Sporobolomyces salmonicolor"
    },
    {
      "code" : "981",
      "display" : "Sporothrix schenckii"
    },
    {
      "code" : "983",
      "display" : "Staphylococcus arlettae"
    },
    {
      "code" : "985",
      "display" : "Staphylococcus aureus"
    },
    {
      "code" : "986",
      "display" : "Staphylococcus aureus / S. intermedius"
    },
    {
      "code" : "987",
      "display" : "Staphylococcus auricularis"
    },
    {
      "code" : "988",
      "display" : "Staphylococcus capitis"
    },
    {
      "code" : "989",
      "display" : "Staphylococcus caprae"
    },
    {
      "code" : "990",
      "display" : "Staphylococcus caprae"
    },
    {
      "code" : "991",
      "display" : "Staphylococcus carnosus"
    },
    {
      "code" : "992",
      "display" : "Staphylococcus carnosus ssp carnosus"
    },
    {
      "code" : "993",
      "display" : "Staphylococcus chromogenes"
    },
    {
      "code" : "994",
      "display" : "Staphylococcus cohnii"
    },
    {
      "code" : "995",
      "display" : "Staphylococcus cohnii ssp cohnii"
    },
    {
      "code" : "996",
      "display" : "Staphylococcus cohnii ssp urealyticum"
    },
    {
      "code" : "997",
      "display" : "Staphylococcus epidermidis"
    },
    {
      "code" : "998",
      "display" : "Staphylococcus equorum"
    },
    {
      "code" : "999",
      "display" : "Staphylococcus equorum"
    },
    {
      "code" : "1000",
      "display" : "Staphylococcus gallinarum"
    },
    {
      "code" : "1001",
      "display" : "Staphylococcus gallinarum"
    },
    {
      "code" : "1002",
      "display" : "Staphylococcus haemolyticus"
    },
    {
      "code" : "1003",
      "display" : "Staphylococcus hominis"
    },
    {
      "code" : "1004",
      "display" : "Staphylococcus hominis ssp hominis"
    },
    {
      "code" : "1005",
      "display" : "Staphylococcus hominis ssp novobiosepticus"
    },
    {
      "code" : "1006",
      "display" : "Staphylococcus hyicus"
    },
    {
      "code" : "1007",
      "display" : "Staphylococcus intermedius"
    },
    {
      "code" : "1008",
      "display" : "Staphylococcus kloosii"
    },
    {
      "code" : "1009",
      "display" : "Staphylococcus kloosii"
    },
    {
      "code" : "1011",
      "display" : "Staphylococcus lentus"
    },
    {
      "code" : "1013",
      "display" : "Staphylococcus saccharolyticus"
    },
    {
      "code" : "1014",
      "display" : "Staphylococcus saccharolyticus (Peptococcus)"
    },
    {
      "code" : "1016",
      "display" : "Staphylococcus saprophyticus / S. hominis"
    },
    {
      "code" : "1018",
      "display" : "Staphylococcus sciuri"
    },
    {
      "code" : "1020",
      "display" : "Staphylococcus species"
    },
    {
      "code" : "1022",
      "display" : "Staphylococcus warneri"
    },
    {
      "code" : "1024",
      "display" : "Stenotrophomonas maltophilia"
    },
    {
      "code" : "1026",
      "display" : "Streptococcus acidominimus"
    },
    {
      "code" : "1028",
      "display" : "Streptococcus acidominimus/(Streptococcus pneumoniae)"
    },
    {
      "code" : "1029",
      "display" : "Streptococcus agalactiae"
    },
    {
      "code" : "1031",
      "display" : "Streptococcus alactolyticus"
    },
    {
      "code" : "1033",
      "display" : "Streptococcus anginosus (Strep. milleri)"
    },
    {
      "code" : "1035",
      "display" : "Streptococcus bovis"
    },
    {
      "code" : "1036",
      "display" : "Streptococcus bovis"
    },
    {
      "code" : "1038",
      "display" : "Streptococcus canis"
    },
    {
      "code" : "1039",
      "display" : "Streptococcus canis"
    },
    {
      "code" : "1041",
      "display" : "Streptococcus constellatus (viridans strep)"
    },
    {
      "code" : "1043",
      "display" : "Streptococcus constellatus ssp pharyngis"
    },
    {
      "code" : "1044",
      "display" : "Streptococcus cristatus"
    },
    {
      "code" : "1046",
      "display" : "Streptococcus downei"
    },
    {
      "code" : "1048",
      "display" : "Streptococcus dysgalactiae ssp equisimilis"
    },
    {
      "code" : "1050",
      "display" : "Streptococcus equi ssp zooepidemicus"
    },
    {
      "code" : "1052",
      "display" : "Streptococcus equinus"
    },
    {
      "code" : "1170",
      "display" : "virus sprint"
    },
    {
      "code" : "1054",
      "display" : "Streptococcus equisimilis(Group C)/Group G Strep"
    },
    {
      "code" : "1055",
      "display" : "Streptococcus gallolyticus"
    },
    {
      "code" : "1057",
      "display" : "Streptococcus gordonii"
    },
    {
      "code" : "1059",
      "display" : "Streptococcus group c"
    },
    {
      "code" : "1061",
      "display" : "Streptococcus group G"
    },
    {
      "code" : "1063",
      "display" : "Streptococcus group U"
    },
    {
      "code" : "1065",
      "display" : "Streptococcus infantarius"
    },
    {
      "code" : "1067",
      "display" : "Streptococcus intermedius"
    },
    {
      "code" : "1068",
      "display" : "Streptococcus intermedius (viridans strep)"
    },
    {
      "code" : "1070",
      "display" : "Streptococcus mitis"
    },
    {
      "code" : "1071",
      "display" : "Streptococcus mitis/oralis/(Streptococcus pneumoniae)"
    },
    {
      "code" : "1074",
      "display" : "Streptococcus oralis"
    },
    {
      "code" : "1076",
      "display" : "Streptococcus parasanguinis"
    },
    {
      "code" : "1078",
      "display" : "Streptococcus pneumoniae"
    },
    {
      "code" : "1080",
      "display" : "Streptococcus porcinus"
    },
    {
      "code" : "1082",
      "display" : "Streptococcus salivarius"
    },
    {
      "code" : "1084",
      "display" : "Streptococcus salivarius ssp salivarius"
    },
    {
      "code" : "1085",
      "display" : "Streptococcus salivarius ssp thermophilus"
    },
    {
      "code" : "1087",
      "display" : "Streptococcus sanguis"
    },
    {
      "code" : "1089",
      "display" : "Streptococcus sobrinus"
    },
    {
      "code" : "1091",
      "display" : "Streptococcus suis I"
    },
    {
      "code" : "1093",
      "display" : "Streptococcus uberis"
    },
    {
      "code" : "1095",
      "display" : "Streptococcus vestibularis"
    },
    {
      "code" : "1097",
      "display" : "Streptococcus viridans group"
    },
    {
      "code" : "1099",
      "display" : "Streptomyces spp"
    },
    {
      "code" : "1101",
      "display" : "Suttonella indologenes (Kingella indologenes)"
    },
    {
      "code" : "1103",
      "display" : "Taenia solium"
    },
    {
      "code" : "1106",
      "display" : "Tetragenococcus halophilus (Pediococcus)"
    },
    {
      "code" : "1108",
      "display" : "Torulopsis glabrata"
    },
    {
      "code" : "1110",
      "display" : "Toxoplasma gondii"
    },
    {
      "code" : "1113",
      "display" : "Trichophyton rubrum"
    },
    {
      "code" : "1114",
      "display" : "Trichophyton schoenleini"
    },
    {
      "code" : "1116",
      "display" : "Trichophyton tonsurans"
    },
    {
      "code" : "1118",
      "display" : "Trichophyton violaceum"
    },
    {
      "code" : "1121",
      "display" : "Trichosporon beigelii"
    },
    {
      "code" : "1123",
      "display" : "Trichosporon capitatum if true hyphae, arthrospores present"
    },
    {
      "code" : "1124",
      "display" : "Trichosporon inkin"
    },
    {
      "code" : "1125",
      "display" : "Trichosporon mucoides"
    },
    {
      "code" : "1128",
      "display" : "Trichosporon spp"
    },
    {
      "code" : "1130",
      "display" : "Turicella otitidis"
    },
    {
      "code" : "1132",
      "display" : "Vagococcus fluvialis"
    },
    {
      "code" : "1134",
      "display" : "Veillonella parvula (Veillonella alcalescens)"
    },
    {
      "code" : "1136",
      "display" : "Vibrio alginolyticus"
    },
    {
      "code" : "1138",
      "display" : "Vibrio fluvialis"
    },
    {
      "code" : "1139",
      "display" : "Vibrio harveyi"
    },
    {
      "code" : "1140",
      "display" : "Vibrio hollisae"
    },
    {
      "code" : "1141",
      "display" : "Vibrio metschnikovii"
    },
    {
      "code" : "1142",
      "display" : "Vibrio mimicus"
    },
    {
      "code" : "1143",
      "display" : "Vibrio parahaemolyticus"
    },
    {
      "code" : "1144",
      "display" : "Vibrio spp"
    },
    {
      "code" : "1145",
      "display" : "Vibrio vulnificus"
    },
    {
      "code" : "1146",
      "display" : "Virgibacillus (Bacillus) pantothenticus"
    },
    {
      "code" : "1147",
      "display" : "Weeksella spp"
    },
    {
      "code" : "1148",
      "display" : "Weeksella virosa"
    },
    {
      "code" : "1149",
      "display" : "Weissella paramesenteroides (Leuconostoc)"
    },
    {
      "code" : "1150",
      "display" : "Weissella viridescens (Lactobacillus)"
    },
    {
      "code" : "1151",
      "display" : "Wuchereria bancrofti"
    },
    {
      "code" : "1152",
      "display" : "Xanthomonas campestris"
    },
    {
      "code" : "1153",
      "display" : "Xanthomonas spp"
    },
    {
      "code" : "1154",
      "display" : "Yeast"
    },
    {
      "code" : "1155",
      "display" : "Yersinia aldovae"
    },
    {
      "code" : "1156",
      "display" : "Yersinia enterocolitica"
    },
    {
      "code" : "1157",
      "display" : "Yersinia enterocolitica group"
    },
    {
      "code" : "1158",
      "display" : "Yersinia enterocolitica/frederiksenii/intermedia"
    },
    {
      "code" : "1159",
      "display" : "Yersinia frederiksenii"
    },
    {
      "code" : "1160",
      "display" : "Yersinia intermedia"
    },
    {
      "code" : "1161",
      "display" : "Yersinia kristensenii"
    },
    {
      "code" : "1162",
      "display" : "Yersinia pestis"
    },
    {
      "code" : "1163",
      "display" : "Yersinia pseudotuberculosis"
    },
    {
      "code" : "1164",
      "display" : "Yersinia ruckeri"
    },
    {
      "code" : "1165",
      "display" : "Yersinia species"
    },
    {
      "code" : "1166",
      "display" : "Yokenella regensburgei (Koserella trabulsii)"
    },
    {
      "code" : "1167",
      "display" : "Zygosaccharomyces spp."
    },
    {
      "code" : "1169",
      "display" : "new microorganism"
    },
    {
      "code" : "1168",
      "display" : "humanioide spec"
    },
    {
      "code" : "415236004",
      "display" : "Ralstonia mannitolilytica"
    },
    {
      "code" : "113710007",
      "display" : "Roseomonas gilardii"
    },
    {
      "code" : "113700003",
      "display" : "Shewanella putrefaciens"
    },
    {
      "code" : "113954009",
      "display" : "Sphingobacterium thalpophilum"
    },
    {
      "code" : "45749000",
      "display" : "Vibrio alginolyticus"
    },
    {
      "code" : "243230001",
      "display" : "Aerococcus urinae"
    },
    {
      "code" : "113776005",
      "display" : "Dermacoccus nishinomiyaensis"
    },
    {
      "code" : "702936000",
      "display" : "Dermacoccus nishinomiyaensis o Kytococcus sedentarius"
    },
    {
      "code" : "113723000",
      "display" : "Enterococcus columbae"
    },
    {
      "code" : "78065002",
      "display" : "Enterococcus faecalis"
    },
    {
      "code" : "73852008",
      "display" : "Enterococcus hirae"
    },
    {
      "code" : "103438005",
      "display" : "Enterococcus saccharolyticus"
    },
    {
      "code" : "64071004",
      "display" : "Gardnerella vaginalis"
    },
    {
      "code" : "113765006",
      "display" : "Gemella morbillorum"
    },
    {
      "code" : "414345009",
      "display" : "Globicatella sanguinis"
    },
    {
      "code" : "115944008",
      "display" : "Granulicatella elegans"
    },
    {
      "code" : "113772007",
      "display" : "Kocuria kristinae"
    },
    {
      "code" : "113774008",
      "display" : "Kocuria varians"
    },
    {
      "code" : "81454004",
      "display" : "Lactococcus lactis subspecies cremoris"
    },
    {
      "code" : "113821008",
      "display" : "Leuconostoc citreum"
    },
    {
      "code" : "86938009",
      "display" : "Leuconostoc mesenteroides subspecies dextranicum"
    },
    {
      "code" : "67816007",
      "display" : "Listeria grayi"
    },
    {
      "code" : "55032007",
      "display" : "Listeria ivanovii"
    },
    {
      "code" : "80757000",
      "display" : "Listeria welshimeri"
    },
    {
      "code" : "61376003",
      "display" : "Micrococcus lylae"
    },
    {
      "code" : "243242006",
      "display" : "Pediococcus pentosaceus"
    },
    {
      "code" : "72465001",
      "display" : "Staphylococcus arlettae"
    },
    {
      "code" : "40347003",
      "display" : "Staphylococcus capitis"
    },
    {
      "code" : "438905007",
      "display" : "Staphylococcus carnosus subspecies carnosus"
    },
    {
      "code" : "103493004",
      "display" : "Staphylococcus ureilyticus"
    },
    {
      "code" : "8056006",
      "display" : "Staphylococcus gallinarum"
    },
    {
      "code" : "438202004",
      "display" : "Staphylococcus hominis subspecies novobiosepticus"
    },
    {
      "code" : "719237009",
      "display" : "Grupo Staphylococcus intermedius"
    },
    {
      "code" : "103494005",
      "display" : "Staphylococcus lugdunensis"
    },
    {
      "code" : "19870004",
      "display" : "Streptococcus oralis"
    },
    {
      "code" : "438035003",
      "display" : "Streptococcus ovis"
    },
    {
      "code" : "438187002",
      "display" : "Streptococcus pluranimalium"
    },
    {
      "code" : "429189003",
      "display" : "Streptococcus pseudoporcinus"
    },
    {
      "code" : "23310006",
      "display" : "Streptococcus salivarius subspecies thermophilus"
    },
    {
      "code" : "115127008",
      "display" : "Género Myroides"
    },
    {
      "code" : "442202005",
      "display" : "Neisseria animaloris"
    },
    {
      "code" : "449121005",
      "display" : "Neisseria zoodegmatis"
    },
    {
      "code" : "716260000",
      "display" : "Neisseria animaloris o Neisseria zoodegmatis"
    },
    {
      "code" : "116490002",
      "display" : "Ochrobactrum anthropi"
    },
    {
      "code" : "11309009",
      "display" : "Oligella ureolytica"
    },
    {
      "code" : "415033004",
      "display" : "Paracoccus yeei"
    },
    {
      "code" : "87075007",
      "display" : "Pasteurella aerogenes"
    },
    {
      "code" : "7784009",
      "display" : "Pasteurella canis"
    },
    {
      "code" : "80948000",
      "display" : "Pasteurella dagmatis"
    },
    {
      "code" : "10879005",
      "display" : "Pasteurella multocida"
    },
    {
      "code" : "32562008",
      "display" : "Rodentibacter pneumotropicus"
    },
    {
      "code" : "3388005",
      "display" : "Pasteurella testudinis"
    },
    {
      "code" : "387798006",
      "display" : "Photobacterium damselae"
    },
    {
      "code" : "52499004",
      "display" : "Pseudomonas aeruginosa"
    },
    {
      "code" : "415187007",
      "display" : "Grupo Pseudomonas aeruginosa"
    },
    {
      "code" : "46247008",
      "display" : "Pseudomonas alcaligenes"
    },
    {
      "code" : "39289003",
      "display" : "Pseudomonas fluorescens"
    },
    {
      "code" : "415197003",
      "display" : "Grupo Pseudomonas fluorescens"
    },
    {
      "code" : "33919008",
      "display" : "Pseudomonas luteola"
    },
    {
      "code" : "59419001",
      "display" : "Pseudomonas mendocina"
    },
    {
      "code" : "53053000",
      "display" : "Pseudomonas oleovorans"
    },
    {
      "code" : "113931000",
      "display" : "Pseudomonas oryzihabitans"
    },
    {
      "code" : "68608003",
      "display" : "Pseudomonas putida"
    },
    {
      "code" : "717669004",
      "display" : "Grupo Pseudomonas putida"
    },
    {
      "code" : "58024003",
      "display" : "Pseudomonas stutzeri"
    },
    {
      "code" : "415208009",
      "display" : "Grupo Pseudomonas stutzeri"
    },
    {
      "code" : "114053008",
      "display" : "Ralstonia pickettii"
    },
    {
      "code" : "438107000",
      "display" : "Rhizobium radiobacter"
    },
    {
      "code" : "113702006",
      "display" : "Shewanella algae"
    },
    {
      "code" : "51595006",
      "display" : "Sphingobacterium multivorum"
    },
    {
      "code" : "61675006",
      "display" : "Sphingobacterium spiritivorum"
    },
    {
      "code" : "243350004",
      "display" : "Sphingomonas paucimobilis"
    },
    {
      "code" : "113697002",
      "display" : "Stenotrophomonas maltophilia"
    },
    {
      "code" : "113714003",
      "display" : "Abiotrophia defectiva"
    },
    {
      "code" : "78803006",
      "display" : "Aerococcus viridans"
    },
    {
      "code" : "396454000",
      "display" : "Alloiococcus otitis"
    },
    {
      "code" : "113775009",
      "display" : "Kytococcus sedentarius"
    },
    {
      "code" : "87875008",
      "display" : "Enterococcus avium"
    },
    {
      "code" : "30949009",
      "display" : "Enterococcus casseliflavus"
    },
    {
      "code" : "113722005",
      "display" : "Enterococcus cecorum"
    },
    {
      "code" : "46464008",
      "display" : "Enterococcus durans"
    },
    {
      "code" : "90272000",
      "display" : "Enterococcus faecium"
    },
    {
      "code" : "53233007",
      "display" : "Enterococcus gallinarum"
    },
    {
      "code" : "103437000",
      "display" : "Enterococcus raffinosus"
    },
    {
      "code" : "48666005",
      "display" : "Erysipelothrix rhusiopathiae"
    },
    {
      "code" : "414181002",
      "display" : "Facklamia hominis"
    },
    {
      "code" : "131310006",
      "display" : "Gemella bergeri"
    },
    {
      "code" : "37511002",
      "display" : "Gemella haemolysans"
    },
    {
      "code" : "125038007",
      "display" : "Gemella sanguinis"
    },
    {
      "code" : "414347001",
      "display" : "Globicatella sulfidifaciens"
    },
    {
      "code" : "113713009",
      "display" : "Granulicatella adiacens"
    },
    {
      "code" : "127527002",
      "display" : "Helcococcus kunzii"
    },
    {
      "code" : "432451007",
      "display" : "Kocuria rhizophila"
    },
    {
      "code" : "113773002",
      "display" : "Kocuria rosea"
    },
    {
      "code" : "27716002",
      "display" : "Lactococcus garvieae"
    },
    {
      "code" : "38518005",
      "display" : "Lactococcus lactis subspecies lactis"
    },
    {
      "code" : "113805003",
      "display" : "Lactococcus raffinolactis"
    },
    {
      "code" : "70285009",
      "display" : "Leuconostoc lactis"
    },
    {
      "code" : "35041008",
      "display" : "Leuconostoc mesenteroides subspecies cremoris"
    },
    {
      "code" : "67140002",
      "display" : "Leuconostoc mesenteroides subspecies mesenteroides"
    },
    {
      "code" : "243235006",
      "display" : "Leuconostoc pseudomesenteroides"
    },
    {
      "code" : "48331004",
      "display" : "Listeria innocua"
    },
    {
      "code" : "36094007",
      "display" : "Listeria monocytogenes"
    },
    {
      "code" : "43091008",
      "display" : "Listeria seeligeri"
    },
    {
      "code" : "48299003",
      "display" : "Micrococcus luteus"
    },
    {
      "code" : "243237003",
      "display" : "Pediococcus acidilactici"
    },
    {
      "code" : "35379007",
      "display" : "Rothia dentocariosa"
    },
    {
      "code" : "416544005",
      "display" : "Rothia mucilaginosa"
    },
    {
      "code" : "3092008",
      "display" : "Staphylococcus aureus"
    },
    {
      "code" : "45654003",
      "display" : "Staphylococcus auricularis"
    },
    {
      "code" : "76969000",
      "display" : "Staphylococcus caprae"
    },
    {
      "code" : "56629004",
      "display" : "Staphylococcus chromogenes"
    },
    {
      "code" : "113963006",
      "display" : "Staphylococcus cohnii ss cohnii"
    },
    {
      "code" : "60875001",
      "display" : "Staphylococcus epidermidis"
    },
    {
      "code" : "28217008",
      "display" : "Staphylococcus equorum"
    },
    {
      "code" : "83452006",
      "display" : "Staphylococcus haemolyticus"
    },
    {
      "code" : "432505008",
      "display" : "Staphylococcus hominis subspecies hominis"
    },
    {
      "code" : "19683001",
      "display" : "Staphylococcus hyicus"
    },
    {
      "code" : "34605002",
      "display" : "Staphylococcus intermedius"
    },
    {
      "code" : "53227003",
      "display" : "Staphylococcus kloosii"
    },
    {
      "code" : "40253001",
      "display" : "Mammaliicoccus lentus"
    },
    {
      "code" : "427316000",
      "display" : "Staphylococcus pseudintermedius"
    },
    {
      "code" : "19743000",
      "display" : "Staphylococcus saprophyticus"
    },
    {
      "code" : "131360000",
      "display" : "Staphylococcus schleiferi"
    },
    {
      "code" : "243446007",
      "display" : "Sporobolomyces salmonicolor"
    },
    {
      "code" : "415966003",
      "display" : "Trichomonascus ciferrii"
    },
    {
      "code" : "243475001",
      "display" : "Trichosporon asahii"
    },
    {
      "code" : "243547001",
      "display" : "Trichosporon inkin"
    },
    {
      "code" : "243478004",
      "display" : "Cutaneotrichosporon mucoides"
    },
    {
      "code" : "558",
      "display" : "Haemophilus paragallinarum"
    },
    {
      "code" : "560",
      "display" : "Haemophilus parainfluenzae"
    },
    {
      "code" : "562",
      "display" : "Haemophilus parainfluenzae II"
    },
    {
      "code" : "565",
      "display" : "Haemophilus parainfluenzae V"
    },
    {
      "code" : "567",
      "display" : "Haemophilus parainfluenzae VII"
    },
    {
      "code" : "569",
      "display" : "Haemophilus paraphrohaemolyticus"
    },
    {
      "code" : "571",
      "display" : "Haemophilus segnis"
    },
    {
      "code" : "573",
      "display" : "Haemophilus somnus"
    },
    {
      "code" : "575",
      "display" : "Hafnia alvei"
    },
    {
      "code" : "577",
      "display" : "Hansenula petersonii(Pichia petersonii)"
    },
    {
      "code" : "579",
      "display" : "Hansenula saturnus (Williopsis saturnus)"
    },
    {
      "code" : "582",
      "display" : "Helicobacter fennelliae (Campylobacter fennelliae)"
    },
    {
      "code" : "584",
      "display" : "Histoplasma capsulatum"
    },
    {
      "code" : "586",
      "display" : "Iodamoeba butschlii"
    },
    {
      "code" : "588",
      "display" : "Kingella denitrificans"
    },
    {
      "code" : "590",
      "display" : "Kingella species"
    },
    {
      "code" : "592",
      "display" : "Klebsiella oxytoca/(Raoultella planticola/terrigena)"
    },
    {
      "code" : "595",
      "display" : "Klebsiella pneumoniae"
    },
    {
      "code" : "597",
      "display" : "Klebsiella pneumoniae/(K.planticola/terrig.)"
    },
    {
      "code" : "600",
      "display" : "Kloeckera apiculata"
    },
    {
      "code" : "601",
      "display" : "Kloeckera apiculata/Hanseniaspora uvarum"
    },
    {
      "code" : "604",
      "display" : "Kloeckera apis/Hanseniaspora guilliermondii"
    },
    {
      "code" : "606",
      "display" : "Kloeckera japonica/Hanseniaspora valbyensis"
    },
    {
      "code" : "609",
      "display" : "Kluyvera ascorbata"
    },
    {
      "code" : "611",
      "display" : "Kluyvera cryocrescens"
    },
    {
      "code" : "613",
      "display" : "Kocuria kristinae"
    },
    {
      "code" : "615",
      "display" : "Kocuria rosea"
    },
    {
      "code" : "616",
      "display" : "Kocuria varians"
    },
    {
      "code" : "618",
      "display" : "Kytococcus sedentarius (Micrococcus)"
    },
    {
      "code" : "621",
      "display" : "Lactobacillus buchneri"
    },
    {
      "code" : "623",
      "display" : "Lactobacillus catenaforme"
    },
    {
      "code" : "625",
      "display" : "Lactobacillus collinoides"
    },
    {
      "code" : "627",
      "display" : "Lactobacillus crispatus"
    },
    {
      "code" : "629",
      "display" : "Lactobacillus delbrueckii ssp bulgaricus"
    },
    {
      "code" : "631",
      "display" : "Lactobacillus delbrueckii ssp lactis"
    },
    {
      "code" : "634",
      "display" : "Lactobacillus fructivorans"
    },
    {
      "code" : "636",
      "display" : "Lactobacillus helveticus ssp jugurti"
    },
    {
      "code" : "638",
      "display" : "Lactobacillus lindneri"
    },
    {
      "code" : "640",
      "display" : "Lactobacillus paracasei ssp paracasei (L.casei casei)"
    },
    {
      "code" : "643",
      "display" : "Lactobacillus pentosus"
    },
    {
      "code" : "645",
      "display" : "Lactobacillus rhamnosus (Lactobacillus casei ssp rhamnosus)"
    },
    {
      "code" : "648",
      "display" : "Lactobacillus spp"
    },
    {
      "code" : "650",
      "display" : "Lactococcus gasseri"
    },
    {
      "code" : "652",
      "display" : "Lactococcus lactis ssp cremoris (Str.cremoris)"
    },
    {
      "code" : "654",
      "display" : "Lactococcus lactis ssp hordniae (Lactobacillus hordniae)"
    },
    {
      "code" : "658",
      "display" : "Leclercia adecarboxylata"
    },
    {
      "code" : "660",
      "display" : "Legionella spp."
    },
    {
      "code" : "661",
      "display" : "Leishmania spp."
    },
    {
      "code" : "663",
      "display" : "Leptotrichia buccalis"
    },
    {
      "code" : "665",
      "display" : "Leuconostoc citreum"
    },
    {
      "code" : "667",
      "display" : "Leuconostoc lactis"
    },
    {
      "code" : "669",
      "display" : "Leuconostoc mesenteroides ssp cremoris"
    },
    {
      "code" : "671",
      "display" : "Leuconostoc mesenteroides ssp dextranicum"
    },
    {
      "code" : "674",
      "display" : "Leuconostoc mesenteroides ssp mesenteroides"
    },
    {
      "code" : "676",
      "display" : "Leuconostoc spp."
    },
    {
      "code" : "678",
      "display" : "Listeria grayi"
    },
    {
      "code" : "680",
      "display" : "Listeria innocua"
    },
    {
      "code" : "682",
      "display" : "Listeria ivanovii"
    },
    {
      "code" : "683",
      "display" : "Listeria ivanovii"
    },
    {
      "code" : "685",
      "display" : "Listeria monocytogenes"
    },
    {
      "code" : "713",
      "display" : "Moraxella lacunata"
    },
    {
      "code" : "715",
      "display" : "Moraxella osloensis"
    },
    {
      "code" : "717",
      "display" : "Moraxella species (probably atlantae)"
    },
    {
      "code" : "719",
      "display" : "Morganella morganii"
    },
    {
      "code" : "721",
      "display" : "Morganella morganii ssp morganii"
    },
    {
      "code" : "723",
      "display" : "Morganella morganii ssp sibonii"
    },
    {
      "code" : "725",
      "display" : "Mycobacterium asiaticum"
    },
    {
      "code" : "727",
      "display" : "Mycobacterium avium complex"
    },
    {
      "code" : "730",
      "display" : "Mycobacterium flavescens"
    },
    {
      "code" : "732",
      "display" : "Mycobacterium gastri"
    },
    {
      "code" : "733",
      "display" : "Mycobacterium gordonae"
    },
    {
      "code" : "735",
      "display" : "Mycobacterium intracellulare"
    },
    {
      "code" : "738",
      "display" : "Mycobacterium marinum"
    },
    {
      "code" : "740",
      "display" : "Mycobacterium phlei"
    },
    {
      "code" : "741",
      "display" : "Mycobacterium scrofulceum"
    },
    {
      "code" : "743",
      "display" : "Mycobacterium smegmatis"
    },
    {
      "code" : "745",
      "display" : "Mycobacterium szulgai"
    },
    {
      "code" : "747",
      "display" : "Mycobacterium triviale"
    },
    {
      "code" : "749",
      "display" : "Mycobacterium ulcerans"
    },
    {
      "code" : "751",
      "display" : "Mycobacterium xenopi"
    },
    {
      "code" : "753",
      "display" : "Mycoplasma hominis"
    },
    {
      "code" : "755",
      "display" : "Mycoplasma pneumoniae"
    },
    {
      "code" : "757",
      "display" : "Necator americanus"
    },
    {
      "code" : "759",
      "display" : "Neisseria cinerea"
    },
    {
      "code" : "761",
      "display" : "Neisseria elongata (CDC M-6)"
    },
    {
      "code" : "763",
      "display" : "Neisseria flava"
    },
    {
      "code" : "765",
      "display" : "Neisseria gonorrhoeae"
    },
    {
      "code" : "767",
      "display" : "Neisseria meningitidis"
    },
    {
      "code" : "768",
      "display" : "Neisseria mucosa"
    },
    {
      "code" : "770",
      "display" : "Neisseria polysaccharea"
    },
    {
      "code" : "772",
      "display" : "Neisseria spp"
    },
    {
      "code" : "774",
      "display" : "Neisseria weaveri (CDC M-5)"
    },
    {
      "code" : "776",
      "display" : "Nonfermenting Gram-Negative Bacillus (asaccharolytic)"
    },
    {
      "code" : "779",
      "display" : "Oerskovia xanthineolytica"
    },
    {
      "code" : "781",
      "display" : "Oligella ureolytica"
    },
    {
      "code" : "783",
      "display" : "Paenibacillus (Bacillus) amylolyticus"
    },
    {
      "code" : "785",
      "display" : "Paenibacillus alvei"
    },
    {
      "code" : "787",
      "display" : "Paenibacillus glucanolyticus"
    },
    {
      "code" : "789",
      "display" : "Paenibacillus macerans"
    },
    {
      "code" : "791",
      "display" : "Paenibacillus peoriae"
    },
    {
      "code" : "793",
      "display" : "Paenibacillus vallidus"
    },
    {
      "code" : "795",
      "display" : "Pantoea ananas"
    },
    {
      "code" : "797",
      "display" : "Pantoea dispersa"
    },
    {
      "code" : "799",
      "display" : "Pantoea stewartii"
    },
    {
      "code" : "801",
      "display" : "Paracoccus yeeii"
    },
    {
      "code" : "802",
      "display" : "Pasterella canis"
    },
    {
      "code" : "804",
      "display" : "Pasteurella avium (Haemophilus avium)"
    },
    {
      "code" : "807",
      "display" : "Pasteurella multocida"
    },
    {
      "code" : "809",
      "display" : "Pasteurella multocida ssp septica"
    },
    {
      "code" : "811",
      "display" : "Pasteurella spp"
    },
    {
      "code" : "813",
      "display" : "Pediococcus acidilactici"
    },
    {
      "code" : "815",
      "display" : "Pediococcus damnosus"
    },
    {
      "code" : "817",
      "display" : "Pediococcus spp."
    },
    {
      "code" : "818",
      "display" : "Peptococcus anaerobius"
    },
    {
      "code" : "820",
      "display" : "Peptococcus spp"
    },
    {
      "code" : "822",
      "display" : "Peptostreptococcus asaccharolyticus"
    },
    {
      "code" : "824",
      "display" : "Peptostreptococcus magnus"
    },
    {
      "code" : "826",
      "display" : "Peptostreptococcus prevotii"
    },
    {
      "code" : "829",
      "display" : "Photobacterium damsela"
    },
    {
      "code" : "831",
      "display" : "Pichia etchellsii"
    },
    {
      "code" : "832",
      "display" : "Pichia farinosa"
    },
    {
      "code" : "834",
      "display" : "Pichia spartinae"
    },
    {
      "code" : "836",
      "display" : "Plasmodium falciparum"
    },
    {
      "code" : "838",
      "display" : "Plasmodium ovale"
    },
    {
      "code" : "840",
      "display" : "Plasmodium vivax"
    },
    {
      "code" : "841",
      "display" : "Plesiomonas shigelloides"
    },
    {
      "code" : "843",
      "display" : "Porphyromonas asaccharolytica"
    },
    {
      "code" : "846",
      "display" : "Porphyromonas gingivalis"
    },
    {
      "code" : "848",
      "display" : "Prevotella bivia"
    },
    {
      "code" : "70806002",
      "display" : "Mammaliicoccus sciuri"
    },
    {
      "code" : "52122005",
      "display" : "Staphylococcus simulans"
    },
    {
      "code" : "440569005",
      "display" : "Mammaliicoccus vitulinus"
    },
    {
      "code" : "63550006",
      "display" : "Staphylococcus warneri"
    },
    {
      "code" : "32737005",
      "display" : "Staphylococcus xylosus"
    },
    {
      "code" : "43492007",
      "display" : "Streptococcus agalactiae"
    },
    {
      "code" : "34228005",
      "display" : "Streptococcus alactolyticus"
    },
    {
      "code" : "44304009",
      "display" : "Streptococcus anginosus"
    },
    {
      "code" : "88231003",
      "display" : "Streptococcus canis"
    },
    {
      "code" : "415601009",
      "display" : "Streptococcus constellatus subspecies constellatus"
    },
    {
      "code" : "415602002",
      "display" : "Streptococcus constellatus subspecies pharyngis"
    },
    {
      "code" : "113980005",
      "display" : "Streptococcus cristatus"
    },
    {
      "code" : "12704003",
      "display" : "Streptococcus downei"
    },
    {
      "code" : "113982002",
      "display" : "Streptococcus dysgalactiae subspecies dysgalactiae"
    },
    {
      "code" : "128338004",
      "display" : "Streptococcus dysgalactiae subspecies equisimilis"
    },
    {
      "code" : "113984001",
      "display" : "Streptococcus equi subspecies equi"
    },
    {
      "code" : "33708000",
      "display" : "Streptococcus equi subspecies zooepidemicus"
    },
    {
      "code" : "72646003",
      "display" : "Streptococcus equinus"
    },
    {
      "code" : "421544007",
      "display" : "Streptococcus gallolyticus subspecies gallolyticus"
    },
    {
      "code" : "421253004",
      "display" : "Streptococcus gallolyticus subspecies pasteurianus"
    },
    {
      "code" : "113986004",
      "display" : "Streptococcus gordonii"
    },
    {
      "code" : "113987008",
      "display" : "Streptococcus hyointestinalis"
    },
    {
      "code" : "437915004",
      "display" : "Streptococcus infantarius subspecies coli (anteriormente Streptococcus lutetiensis)"
    },
    {
      "code" : "415605000",
      "display" : "Streptococcus lutetiensis"
    },
    {
      "code" : "432506009",
      "display" : "Streptococcus infantarius subspecies infantarius"
    },
    {
      "code" : "62170002",
      "display" : "Streptococcus intermedius"
    },
    {
      "code" : "57997003",
      "display" : "Streptococcus mitis"
    },
    {
      "code" : "214001",
      "display" : "Streptococcus mutans"
    },
    {
      "code" : "127536003",
      "display" : "Grupo Streptococcus mutans group"
    },
    {
      "code" : "113990002",
      "display" : "Streptococcus parasanguinis"
    },
    {
      "code" : "9861002",
      "display" : "Streptococcus pneumoniae"
    },
    {
      "code" : "59512008",
      "display" : "Streptococcus porcinus"
    },
    {
      "code" : "80166006",
      "display" : "Streptococcus pyogenes"
    },
    {
      "code" : "84684000",
      "display" : "Streptococcus salivarius subspecies salivarius"
    },
    {
      "code" : "113993000",
      "display" : "Streptococcus sanguinis"
    },
    {
      "code" : "115658008",
      "display" : "Grupo Streptococcus sanguis"
    },
    {
      "code" : "302591009",
      "display" : "Streptococcus suis serotipo 1"
    },
    {
      "code" : "302592002",
      "display" : "Streptococcus suis serotipo 2"
    },
    {
      "code" : "13250005",
      "display" : "Streptococcus uberis"
    },
    {
      "code" : "116418005",
      "display" : "Vagococcus fluvialis"
    },
    {
      "code" : "53326005",
      "display" : "Candida albicans"
    },
    {
      "code" : "446238001",
      "display" : "Candida colliculosa"
    },
    {
      "code" : "243428001",
      "display" : "Debaryomyces hansenii"
    },
    {
      "code" : "444877006",
      "display" : "Nakaseomyces glabratus"
    },
    {
      "code" : "29812000",
      "display" : "Meyerozyma guilliermondii"
    },
    {
      "code" : "283871001",
      "display" : "Candida inconspicua"
    },
    {
      "code" : "712765008",
      "display" : "Candida inconspicua o Candida lambica"
    },
    {
      "code" : "816147003",
      "display" : "Atelosaccharomyces pseudotropicalis"
    },
    {
      "code" : "16452009",
      "display" : "Pichia kudriavzevii"
    },
    {
      "code" : "703153003",
      "display" : "Candida lipolytica"
    },
    {
      "code" : "446239009",
      "display" : "Starmerella magnoliae"
    },
    {
      "code" : "8451000146107",
      "display" : "Pichia norvegensis"
    },
    {
      "code" : "61302002",
      "display" : "Candida parapsilosis"
    },
    {
      "code" : "427041001",
      "display" : "Wickerhamomyces anomalus"
    },
    {
      "code" : "23773004",
      "display" : "Diutina rugosa"
    },
    {
      "code" : "446283000",
      "display" : "Candida sake"
    },
    {
      "code" : "47885008",
      "display" : "Candida tropicalis"
    },
    {
      "code" : "4281000146108",
      "display" : "Cyberlindnera jadinii"
    },
    {
      "code" : "243466003",
      "display" : "Candida zeylanoides"
    },
    {
      "code" : "67168003",
      "display" : "Cryptococcus neoformans"
    },
    {
      "code" : "446493009",
      "display" : "Geotrichum klebahnii"
    },
    {
      "code" : "420980009",
      "display" : "Genus Hanseniaspora"
    },
    {
      "code" : "447491002",
      "display" : "Kodamaea ohmeri"
    },
    {
      "code" : "29619007",
      "display" : "Malassezia furfur"
    },
    {
      "code" : "243433002",
      "display" : "Millerozyma farinosa (conocida anteriormente como Pichia farinosa)"
    },
    {
      "code" : "32768009",
      "display" : "Prototheca zopfii"
    },
    {
      "code" : "69250004",
      "display" : "Rhodotorula glutinis"
    },
    {
      "code" : "703262009",
      "display" : "Rhodotorula glutinis o Rhodotorula mucilaginosa"
    },
    {
      "code" : "58296003",
      "display" : "Saccharomyces cerevisiae"
    },
    {
      "code" : "55744003",
      "display" : "Citrobacter amalonaticus"
    },
    {
      "code" : "114262000",
      "display" : "Citrobacter braakii"
    },
    {
      "code" : "114263005",
      "display" : "Citrobacter farmeri"
    },
    {
      "code" : "6265002",
      "display" : "Citrobacter freundii"
    },
    {
      "code" : "114264004",
      "display" : "Citrobacter koseri"
    },
    {
      "code" : "114265003",
      "display" : "Citrobacter sedlakii"
    },
    {
      "code" : "114443001",
      "display" : "Citrobacter youngae"
    },
    {
      "code" : "445562004",
      "display" : "Cronobacter sakazakii"
    },
    {
      "code" : "4280005",
      "display" : "Edwardsiella hoshinae"
    },
    {
      "code" : "74672006",
      "display" : "Edwardsiella tarda"
    },
    {
      "code" : "62592009",
      "display" : "Klebsiella aerogenes"
    },
    {
      "code" : "114452005",
      "display" : "Enterobacter amnigenus biogroup I"
    },
    {
      "code" : "114453000",
      "display" : "Enterobacter amnigenus biogroup II"
    },
    {
      "code" : "33115003",
      "display" : "Enterobacter asburiae"
    },
    {
      "code" : "114451003",
      "display" : "Enterobacter cancerogenus"
    },
    {
      "code" : "414102007",
      "display" : "Enterobacter cloacae (complejo)"
    },
    {
      "code" : "112283007",
      "display" : "Escherichia coli"
    },
    {
      "code" : "407166006",
      "display" : "Escherichia coli serogrupo O157"
    },
    {
      "code" : "72461005",
      "display" : "Escherichia fergusonii"
    },
    {
      "code" : "716346000",
      "display" : "Pluralibacter gergoviae"
    },
    {
      "code" : "85786000",
      "display" : "Escherichia hermannii"
    },
    {
      "code" : "53013003",
      "display" : "Pseudescherichia vulneris"
    },
    {
      "code" : "19027003",
      "display" : "Ewingella americana"
    },
    {
      "code" : "76694001",
      "display" : "Hafnia alvei"
    },
    {
      "code" : "40886007",
      "display" : "Klebsiella oxytoca"
    },
    {
      "code" : "65186004",
      "display" : "Klebsiella pneumoniae subspecies ozaenae"
    },
    {
      "code" : "18400002",
      "display" : "Klebsiella pneumoniae ss. Pneumoniae"
    },
    {
      "code" : "58493008",
      "display" : "Kluyvera ascorbata"
    },
    {
      "code" : "32547006",
      "display" : "Kluyvera cryocrescens"
    },
    {
      "code" : "57459006",
      "display" : "Leclercia adecarboxylata"
    },
    {
      "code" : "37107002",
      "display" : "Moellerella wisconsensis"
    },
    {
      "code" : "243302003",
      "display" : "Morganella morganii subspecies morganii"
    },
    {
      "code" : "115015008",
      "display" : "Pantoea agglomerans"
    },
    {
      "code" : "115013001",
      "display" : "Género Pantoea"
    },
    {
      "code" : "417592004",
      "display" : "Proteus hauseri"
    },
    {
      "code" : "45298005",
      "display" : "Proteus penneri"
    },
    {
      "code" : "45834001",
      "display" : "Proteus vulgaris"
    },
    {
      "code" : "14196002",
      "display" : "Providencia rettgeri"
    },
    {
      "code" : "1445008",
      "display" : "Providencia stuartii"
    },
    {
      "code" : "10021006",
      "display" : "Rahnella aquatilis"
    },
    {
      "code" : "416264004",
      "display" : "Raoultella planticola"
    },
    {
      "code" : "397502001",
      "display" : "Salmonella enterica subsp. Arizonae"
    },
    {
      "code" : "27268008",
      "display" : "Género Salmonella"
    },
    {
      "code" : "370576005",
      "display" : "Salmonella Gallinarum"
    },
    {
      "code" : "5595000",
      "display" : "Salmonella enterica subspecies enterica serovar Typhi"
    },
    {
      "code" : "112329006",
      "display" : "Serratia fonticola"
    },
    {
      "code" : "23787004",
      "display" : "Serratia liquefaciens"
    },
    {
      "code" : "10413007",
      "display" : "Serratia odorifera"
    },
    {
      "code" : "55825002",
      "display" : "Serratia rubidaea"
    },
    {
      "code" : "4298009",
      "display" : "Shigella sonnei"
    },
    {
      "code" : "91246002",
      "display" : "Yersinia aldovae"
    },
    {
      "code" : "85159008",
      "display" : "Yersinia frederiksenii"
    },
    {
      "code" : "10334001",
      "display" : "Yersinia intermedia"
    },
    {
      "code" : "91042006",
      "display" : "Yersinia kristensenii"
    },
    {
      "code" : "54365000",
      "display" : "Yersinia pestis"
    },
    {
      "code" : "64125009",
      "display" : "Yersinia ruckeri"
    },
    {
      "code" : "89477001",
      "display" : "Yokenella regensburgei"
    },
    {
      "code" : "413424009",
      "display" : "Achromobacter xylosoxidans"
    },
    {
      "code" : "113376007",
      "display" : "Acinetobacter calcoaceticus -  Complejo Acinetobacter baumannii"
    },
    {
      "code" : "77045006",
      "display" : "Acinetobacter haemolyticus"
    },
    {
      "code" : "83088009",
      "display" : "Acinetobacter lwoffii"
    },
    {
      "code" : "424791004",
      "display" : "Acinetobacter ursingii"
    },
    {
      "code" : "1839009",
      "display" : "Actinobacillus ureae"
    },
    {
      "code" : "85823000",
      "display" : "Aeromonas hydrophila"
    },
    {
      "code" : "115036005",
      "display" : "Aeromonas caviae"
    },
    {
      "code" : "816086002",
      "display" : "Complejo Aeromonas hydrophila"
    },
    {
      "code" : "30334005",
      "display" : "Aeromonas salmonicida"
    },
    {
      "code" : "9281006",
      "display" : "Aeromonas veronii"
    },
    {
      "code" : "10620008",
      "display" : "Bordetella bronchiseptica"
    },
    {
      "code" : "113495004",
      "display" : "Bordetella hinzii"
    },
    {
      "code" : "113496003",
      "display" : "Bordetella trematum"
    },
    {
      "code" : "113690000",
      "display" : "Brevundimonas vesicularis"
    },
    {
      "code" : "72829003",
      "display" : "Brucella melitensis"
    },
    {
      "code" : "113669008",
      "display" : "Burkholderia cepacia"
    },
    {
      "code" : "131281002",
      "display" : "Complejo Burkholderia cepacia"
    },
    {
      "code" : "113674000",
      "display" : "Burkholderia mallei"
    },
    {
      "code" : "11042002",
      "display" : "Chromobacterium violaceum"
    },
    {
      "code" : "113548000",
      "display" : "Chryseobacterium gleum"
    },
    {
      "code" : "43721005",
      "display" : "Comamonas testosteroni"
    },
    {
      "code" : "429465001",
      "display" : "Cupriavidus pauculus"
    },
    {
      "code" : "425774009",
      "display" : "Elizabethkingia meningoseptica"
    },
    {
      "code" : "433669003",
      "display" : "Grimontia hollisae"
    },
    {
      "code" : "128385005",
      "display" : "Mannheimia haemolytica"
    },
    {
      "code" : "36361003",
      "display" : "Género Moraxella"
    },
    {
      "code" : "461",
      "display" : "Enterococcus hirae"
    },
    {
      "code" : "463",
      "display" : "Enterococcus mundtii"
    },
    {
      "code" : "465",
      "display" : "Enterococcus saccharolyticus"
    },
    {
      "code" : "467",
      "display" : "Enterococcus species (Motility -)"
    },
    {
      "code" : "495",
      "display" : "Eubacterium aerofaciens"
    },
    {
      "code" : "497",
      "display" : "Eubacterium limosum"
    },
    {
      "code" : "499",
      "display" : "Eubacterium multiforme"
    },
    {
      "code" : "500",
      "display" : "Eubacterium spp"
    },
    {
      "code" : "502",
      "display" : "Facklamia hominis"
    },
    {
      "code" : "504",
      "display" : "Finegoldia magna"
    },
    {
      "code" : "506",
      "display" : "Flavobacterium gleum"
    },
    {
      "code" : "508",
      "display" : "Flavobacterium species"
    },
    {
      "code" : "510",
      "display" : "Francisella tularensis"
    },
    {
      "code" : "512",
      "display" : "Fusobacterium mortiferum"
    },
    {
      "code" : "514",
      "display" : "Fusobacterium necrophorum"
    },
    {
      "code" : "516",
      "display" : "Fusobacterium periodonticum"
    },
    {
      "code" : "518",
      "display" : "Fusobacterium varium"
    },
    {
      "code" : "520",
      "display" : "Gemella bergeri"
    },
    {
      "code" : "521",
      "display" : "Gemella haemolysans"
    },
    {
      "code" : "523",
      "display" : "Gemella morbillorum"
    },
    {
      "code" : "525",
      "display" : "Gemella sanguinis"
    },
    {
      "code" : "527",
      "display" : "Gemella spp/(Streptococcus pneumoniae)"
    },
    {
      "code" : "530",
      "display" : "Geobacillus stearothermophilus"
    },
    {
      "code" : "532",
      "display" : "Geotrichum candidum"
    },
    {
      "code" : "881",
      "display" : "Providencia stuartii urea +"
    },
    {
      "code" : "883",
      "display" : "Pseudomonas alcaligenes"
    },
    {
      "code" : "885",
      "display" : "Pseudomonas chlororaphis (Pseudomonas aureofaciens)"
    },
    {
      "code" : "888",
      "display" : "Pseudomonas fluorescent group"
    },
    {
      "code" : "890",
      "display" : "Pseudomonas luteola"
    },
    {
      "code" : "892",
      "display" : "Pseudomonas oryzihabitans"
    },
    {
      "code" : "894",
      "display" : "Pseudomonas pseudoalcaligenes"
    },
    {
      "code" : "896",
      "display" : "Pseudomonas spp"
    },
    {
      "code" : "898",
      "display" : "Pseudomonas testosteroni"
    },
    {
      "code" : "900",
      "display" : "Psychrobacter phenylpyruvicus"
    },
    {
      "code" : "902",
      "display" : "Ralstonia mannitolilytica"
    },
    {
      "code" : "904",
      "display" : "Ralstonia pickettii"
    },
    {
      "code" : "906",
      "display" : "Raoultella planticola"
    },
    {
      "code" : "908",
      "display" : "Rhizobium spp"
    },
    {
      "code" : "909",
      "display" : "Rhodococcus equi (Corynebacterium equi)"
    },
    {
      "code" : "912",
      "display" : "Rhodotorula glutinis/Rhodosporidium toruloides"
    },
    {
      "code" : "915",
      "display" : "Rhodotorula mucilaginosa"
    },
    {
      "code" : "917",
      "display" : "Rhodotorula pilimanae"
    },
    {
      "code" : "919",
      "display" : "Rickettsia spp"
    },
    {
      "code" : "920",
      "display" : "Rotavirus"
    },
    {
      "code" : "922",
      "display" : "Rothia mucilaginosa"
    },
    {
      "code" : "924",
      "display" : "Saccharomyces kluyverii"
    },
    {
      "code" : "926",
      "display" : "Salmonella choleraesuis ssp. arizonae"
    },
    {
      "code" : "928",
      "display" : "Salmonella enteritidis"
    },
    {
      "code" : "930",
      "display" : "Salmonella group"
    },
    {
      "code" : "932",
      "display" : "Salmonella group b"
    },
    {
      "code" : "934",
      "display" : "Salmonella group c2"
    },
    {
      "code" : "936",
      "display" : "Salmonella group e"
    },
    {
      "code" : "937",
      "display" : "Salmonella pullorum"
    },
    {
      "code" : "939",
      "display" : "Salmonella ser. paratyphi B"
    },
    {
      "code" : "941",
      "display" : "Salmonella spp"
    },
    {
      "code" : "943",
      "display" : "Salmonella typhimurium"
    },
    {
      "code" : "945",
      "display" : "Sarcocystis hominis"
    },
    {
      "code" : "947",
      "display" : "Schistosoma japonicum"
    },
    {
      "code" : "949",
      "display" : "Scopulariopsis brevicaulis"
    },
    {
      "code" : "951",
      "display" : "Serratia fonticola"
    },
    {
      "code" : "953",
      "display" : "Serratia liquefaciens"
    },
    {
      "code" : "955",
      "display" : "Serratia marcescens"
    },
    {
      "code" : "957",
      "display" : "Serratia plymuthica"
    },
    {
      "code" : "959",
      "display" : "Serratia proteamaculans ssp proteamaculans"
    },
    {
      "code" : "961",
      "display" : "Serratia rubidaea"
    },
    {
      "code" : "963",
      "display" : "Serratia spp"
    },
    {
      "code" : "965",
      "display" : "Shewanella putrefaciens"
    },
    {
      "code" : "967",
      "display" : "Shigella boydii"
    },
    {
      "code" : "968",
      "display" : "Shigella boydii"
    },
    {
      "code" : "970",
      "display" : "Shigella flexneri"
    },
    {
      "code" : "1137",
      "display" : "Vibrio cholerae"
    },
    {
      "code" : "43777007",
      "display" : "Streptococcus sobrinus"
    },
    {
      "code" : "113997004",
      "display" : "Streptococcus thoraltensis"
    },
    {
      "code" : "113998009",
      "display" : "Streptococcus vestibularis"
    },
    {
      "code" : "283868009",
      "display" : "Diutina catenulata"
    },
    {
      "code" : "115952006",
      "display" : "Candida dubliniensis"
    },
    {
      "code" : "446236002",
      "display" : "Candida freyschussii"
    },
    {
      "code" : "243452008",
      "display" : "Candida haemulonii"
    },
    {
      "code" : "8461000146105",
      "display" : "Pichia fermentans"
    },
    {
      "code" : "243455005",
      "display" : "Candida intermedia"
    },
    {
      "code" : "50164000",
      "display" : "Clavispora lusitaniae"
    },
    {
      "code" : "717979000",
      "display" : "Complejo Candida parapsilosis"
    },
    {
      "code" : "8211000146109",
      "display" : "Metschnikowia pulcherrima"
    },
    {
      "code" : "446284006",
      "display" : "Candida sphaerica"
    },
    {
      "code" : "74062009",
      "display" : "Naganishia albida"
    },
    {
      "code" : "7299008",
      "display" : "Papiliotrema laurentii"
    },
    {
      "code" : "41637000",
      "display" : "Solicoccozyma terrea"
    },
    {
      "code" : "112402002",
      "display" : "Cryptococcus uniguttulatus"
    },
    {
      "code" : "51257000",
      "display" : "Malassezia pachydermatis"
    },
    {
      "code" : "70523003",
      "display" : "Prototheca wickerhamii"
    },
    {
      "code" : "86724009",
      "display" : "Rhodotorula mucilaginosa"
    },
    {
      "code" : "416777007",
      "display" : "Cystobasidium minutum"
    },
    {
      "code" : "67999003",
      "display" : "Magnusiomyces capitatus  (anteriormente Geotrichum capitatum)"
    },
    {
      "code" : "17688001",
      "display" : "Klebsiella pneumoniae subspecies rhinoscleromatis"
    },
    {
      "code" : "431977008",
      "display" : "Kluyvera intermedia (anteriormente Enterobacter intermedius)"
    },
    {
      "code" : "243303008",
      "display" : "Morganella morganii subsp sibonii"
    },
    {
      "code" : "38643006",
      "display" : "Plesiomonas shigelloides"
    },
    {
      "code" : "73457008",
      "display" : "Proteus mirabilis"
    },
    {
      "code" : "46349009",
      "display" : "Providencia alcalifaciens"
    },
    {
      "code" : "19196004",
      "display" : "Providencia rustigianii"
    },
    {
      "code" : "416832000",
      "display" : "Raoultella ornithinolytica"
    },
    {
      "code" : "398428002",
      "display" : "Salmonella enterica subsp. Diarizonae"
    },
    {
      "code" : "79128009",
      "display" : "Salmonella Paratyphi A"
    },
    {
      "code" : "802004",
      "display" : "Serratia ficaria"
    },
    {
      "code" : "33522002",
      "display" : "Serratia marcescens"
    },
    {
      "code" : "28955009",
      "display" : "Serratia plymuthica"
    },
    {
      "code" : "77352002",
      "display" : "Genus Shigella"
    },
    {
      "code" : "65255000",
      "display" : "Yersinia enterocolitica"
    },
    {
      "code" : "55281000087101",
      "display" : "Yersinia enterocolitica o Yersinia frederiksenii"
    },
    {
      "code" : "90530002",
      "display" : "Yersinia pseudotuberculosis"
    },
    {
      "code" : "413414001",
      "display" : "Achromobacter denitrificans"
    },
    {
      "code" : "1003795002",
      "display" : "Grupo Acinetobacter baumannii"
    },
    {
      "code" : "13879009",
      "display" : "Acinetobacter junii"
    },
    {
      "code" : "113381003",
      "display" : "Acinetobacter radioresistens"
    },
    {
      "code" : "717197009",
      "display" : "Aeromonas caviae ó Aeromonas hydrophila"
    },
    {
      "code" : "816087006",
      "display" : "Complejo Aeromonas caviae"
    },
    {
      "code" : "43731003",
      "display" : "Aeromonas sobria"
    },
    {
      "code" : "424719003",
      "display" : "Alcaligenes faecalis subspecies faecalis"
    },
    {
      "code" : "113689009",
      "display" : "Brevundimonas diminuta"
    },
    {
      "code" : "703038009",
      "display" : "Brevundimonas diminuta o Brevundimonas vesicularis"
    },
    {
      "code" : "113671008",
      "display" : "Burkholderia gladioli"
    },
    {
      "code" : "116399000",
      "display" : "Burkholderia pseudomallei"
    },
    {
      "code" : "113549008",
      "display" : "Chryseobacterium indologenes"
    },
    {
      "code" : "20432002",
      "display" : "Delftia acidovorans"
    },
    {
      "code" : "51526001",
      "display" : "Francisella tularensis"
    },
    {
      "code" : "38395008",
      "display" : "Género Methylobacterium"
    },
    {
      "code" : "427057001",
      "display" : "Subgénero Moraxella"
    },
    {
      "code" : "972",
      "display" : "Shigella sonnei"
    },
    {
      "code" : "974",
      "display" : "Sphingobacterium multivorum"
    },
    {
      "code" : "976",
      "display" : "Sphingobacterium thalpophilum"
    },
    {
      "code" : "978",
      "display" : "Sporobolomyces roseus"
    },
    {
      "code" : "980",
      "display" : "Sporobolomyces spp"
    },
    {
      "code" : "982",
      "display" : "Staphylococcus"
    },
    {
      "code" : "984",
      "display" : "Staphylococcus arlettae"
    },
    {
      "code" : "1010",
      "display" : "Staphylococcus kloosii"
    },
    {
      "code" : "1012",
      "display" : "Staphylococcus lugdunensis"
    },
    {
      "code" : "1015",
      "display" : "Staphylococcus saprophyticus"
    },
    {
      "code" : "1017",
      "display" : "Staphylococcus schleiferi"
    },
    {
      "code" : "1019",
      "display" : "Staphylococcus simulans"
    },
    {
      "code" : "1021",
      "display" : "Staphylococcus vitulinus"
    },
    {
      "code" : "1023",
      "display" : "Staphylococcus xylosus"
    },
    {
      "code" : "1025",
      "display" : "Stomatococcus mucilaginosus"
    },
    {
      "code" : "1027",
      "display" : "Streptococcus acidominimus / S. pneumoniae / G. morbillorum"
    },
    {
      "code" : "1030",
      "display" : "Streptococcus alactolyticus"
    },
    {
      "code" : "1032",
      "display" : "Streptococcus anginosus"
    },
    {
      "code" : "1034",
      "display" : "Streptococcus anginosus / S. equisimilis (Group C)"
    },
    {
      "code" : "1037",
      "display" : "Streptococcus bovis (var.) - (Group D, nonenterococci)"
    },
    {
      "code" : "1040",
      "display" : "Streptococcus constellatus"
    },
    {
      "code" : "1042",
      "display" : "Streptococcus constellatus ssp constellatus"
    },
    {
      "code" : "1045",
      "display" : "Streptococcus downei"
    },
    {
      "code" : "1047",
      "display" : "Streptococcus dysgalactiae ssp dysgalactiae"
    },
    {
      "code" : "1049",
      "display" : "Streptococcus equi ssp equi"
    },
    {
      "code" : "1051",
      "display" : "Streptococcus equi(Group C)/Group G Strep"
    },
    {
      "code" : "1053",
      "display" : "Streptococcus equinus - (Group D, nonenterococci)"
    },
    {
      "code" : "1056",
      "display" : "Streptococcus gallolyticus ssp pasteurianus"
    },
    {
      "code" : "1058",
      "display" : "Streptococcus gr.L"
    },
    {
      "code" : "1060",
      "display" : "Streptococcus group E"
    },
    {
      "code" : "1062",
      "display" : "Streptococcus group P"
    },
    {
      "code" : "1064",
      "display" : "Streptococcus hyointestinalis"
    },
    {
      "code" : "1066",
      "display" : "Streptococcus infantarius ssp coli"
    },
    {
      "code" : "1069",
      "display" : "Streptococcus milleri (Str.inter./Str.angin./Str.cons.)"
    },
    {
      "code" : "1072",
      "display" : "Streptococcus mutans"
    },
    {
      "code" : "1073",
      "display" : "Streptococcus oralis"
    },
    {
      "code" : "1075",
      "display" : "Streptococcus ovis"
    },
    {
      "code" : "1077",
      "display" : "Streptococcus pluranimalium"
    },
    {
      "code" : "1079",
      "display" : "Streptococcus porcinus"
    },
    {
      "code" : "1081",
      "display" : "Streptococcus pyogenes"
    },
    {
      "code" : "1083",
      "display" : "Streptococcus salivarius (viridans strep)"
    },
    {
      "code" : "1086",
      "display" : "Streptococcus sanguinis"
    },
    {
      "code" : "1088",
      "display" : "Streptococcus sobrinus"
    },
    {
      "code" : "1090",
      "display" : "Streptococcus spp"
    },
    {
      "code" : "1092",
      "display" : "Streptococcus suis II"
    },
    {
      "code" : "1094",
      "display" : "Streptococcus vestibularis"
    },
    {
      "code" : "1096",
      "display" : "Streptococcus vestibularis"
    },
    {
      "code" : "1098",
      "display" : "Streptomyces somaliensis"
    },
    {
      "code" : "1100",
      "display" : "Strongyloides stercoralis"
    },
    {
      "code" : "1102",
      "display" : "Taenia saginata"
    },
    {
      "code" : "1104",
      "display" : "Taenia spp."
    },
    {
      "code" : "1105",
      "display" : "Tatumella ptyseos"
    },
    {
      "code" : "1107",
      "display" : "Torulopsis candida"
    },
    {
      "code" : "1109",
      "display" : "Toxocara canis"
    },
    {
      "code" : "1111",
      "display" : "Trichomonas vaginalis"
    },
    {
      "code" : "1112",
      "display" : "Trichophyton mentagrophytes"
    },
    {
      "code" : "1115",
      "display" : "Trichophyton soudanense"
    },
    {
      "code" : "1117",
      "display" : "Trichophyton verrucosum"
    },
    {
      "code" : "1119",
      "display" : "Trichosporon asahii"
    },
    {
      "code" : "1120",
      "display" : "Trichosporon asteroides"
    },
    {
      "code" : "1122",
      "display" : "Trichosporon beigelii if true hyphae, arthrospores present"
    },
    {
      "code" : "1126",
      "display" : "Trichosporon ovoides"
    },
    {
      "code" : "1127",
      "display" : "Trichosporon pullulans"
    },
    {
      "code" : "1129",
      "display" : "Trichuris trichiura"
    },
    {
      "code" : "1131",
      "display" : "Ureaplasma urealyticum"
    },
    {
      "code" : "1133",
      "display" : "Veillonella parvula"
    },
    {
      "code" : "1135",
      "display" : "Veillonella spp"
    },
    {
      "code" : "849",
      "display" : "Prevotella buccae"
    },
    {
      "code" : "851",
      "display" : "Prevotella corporis"
    },
    {
      "code" : "853",
      "display" : "Prevotella disiens"
    },
    {
      "code" : "1",
      "display" : "Abiotrophia adiacens (Streptococcus adjacens)"
    },
    {
      "code" : "3",
      "display" : "Abiotrophia defectiva (Streptococcus defectivus)"
    },
    {
      "code" : "6",
      "display" : "Achromobacter xylosoxidans ssp.xylosoxidans"
    },
    {
      "code" : "9",
      "display" : "Acinetobacter baumannii"
    },
    {
      "code" : "11",
      "display" : "Acinetobacter baumannii/(Acn. calcoaceticus/genospecies 3)"
    },
    {
      "code" : "14",
      "display" : "Acinetobacter genospecies 3"
    },
    {
      "code" : "16",
      "display" : "Acinetobacter haemolyticus"
    },
    {
      "code" : "18",
      "display" : "Acinetobacter junii"
    },
    {
      "code" : "20",
      "display" : "Acinetobacter radioresistens"
    },
    {
      "code" : "22",
      "display" : "Acinetobacter spp"
    },
    {
      "code" : "23",
      "display" : "Acinetobacter ursingii"
    },
    {
      "code" : "25",
      "display" : "Actinobacillus actinomycetemcomitans"
    },
    {
      "code" : "28",
      "display" : "Actinobacillus hominis"
    },
    {
      "code" : "30",
      "display" : "Actinobacillus pleuropneumoniae (Haem.pleuropneumoniae)"
    },
    {
      "code" : "33",
      "display" : "Actinobacillus ureae"
    },
    {
      "code" : "34",
      "display" : "Actinomyces bovis"
    },
    {
      "code" : "36",
      "display" : "Actinomyces meyeri"
    },
    {
      "code" : "38",
      "display" : "Actinomyces naeslundii"
    },
    {
      "code" : "40",
      "display" : "Actinomyces neuii ssp neuii"
    },
    {
      "code" : "42",
      "display" : "Actinomyces pyogenes"
    },
    {
      "code" : "44",
      "display" : "Actinomyces spp"
    },
    {
      "code" : "45",
      "display" : "Actinomyces turicensis"
    },
    {
      "code" : "47",
      "display" : "Adenovirus"
    },
    {
      "code" : "49",
      "display" : "Aerococcus urinae"
    },
    {
      "code" : "51",
      "display" : "Aeromonas caviae"
    },
    {
      "code" : "52",
      "display" : "Aeromonas hydrophila"
    },
    {
      "code" : "54",
      "display" : "Aeromonas salmonicida"
    },
    {
      "code" : "56",
      "display" : "Aeromonas salmonicida ssp achromogenes"
    },
    {
      "code" : "58",
      "display" : "Aeromonas salmonicida ssp salmonicida"
    },
    {
      "code" : "61",
      "display" : "Aeromonas spp"
    },
    {
      "code" : "62",
      "display" : "Aeromonas veronii biovar veronii"
    },
    {
      "code" : "65",
      "display" : "Agrobacterium tumefaciens"
    },
    {
      "code" : "67",
      "display" : "Alcaligenes faecalis"
    },
    {
      "code" : "68",
      "display" : "Alcaligenes faecalis ssp.faecalis"
    },
    {
      "code" : "71",
      "display" : "alcylobacillus acidoterrestres"
    },
    {
      "code" : "73",
      "display" : "Anaerobiospirillum succiniciproducens"
    },
    {
      "code" : "75",
      "display" : "Ancylostoma duodenale"
    },
    {
      "code" : "77",
      "display" : "Arcanobacterium bernardiae (Actinomyces bernardiae)"
    },
    {
      "code" : "80",
      "display" : "Arcobacter cryaerophilus(Campylobacter cryaerophila)"
    },
    {
      "code" : "83",
      "display" : "Ascaris lumbricoides"
    },
    {
      "code" : "85",
      "display" : "Aspergillus fumigatus"
    },
    {
      "code" : "87",
      "display" : "Atopobium minutum (Lactobacillus)"
    },
    {
      "code" : "89",
      "display" : "Babesia spp."
    },
    {
      "code" : "90",
      "display" : "Bacillus alvei"
    },
    {
      "code" : "92",
      "display" : "Bacillus amyloliquefaciens"
    },
    {
      "code" : "94",
      "display" : "Bacillus anthracis"
    },
    {
      "code" : "96",
      "display" : "Bacillus badius"
    },
    {
      "code" : "98",
      "display" : "Bacillus brevis"
    },
    {
      "code" : "99",
      "display" : "Bacillus cereus"
    },
    {
      "code" : "101",
      "display" : "Bacillus coagulans"
    },
    {
      "code" : "103",
      "display" : "Bacillus fusiformis"
    },
    {
      "code" : "105",
      "display" : "Bacillus lentus"
    },
    {
      "code" : "106",
      "display" : "Bacillus licheniformis"
    },
    {
      "code" : "108",
      "display" : "Bacillus megaterium"
    },
    {
      "code" : "110",
      "display" : "Bacillus pantothenticus"
    },
    {
      "code" : "112",
      "display" : "Bacillus pumilus"
    },
    {
      "code" : "114",
      "display" : "Bacillus smithii"
    },
    {
      "code" : "116",
      "display" : "Bacillus sphaericus"
    },
    {
      "code" : "118",
      "display" : "Bacillus stearothermophilus"
    },
    {
      "code" : "120",
      "display" : "Bacillus subtilis (globigii)"
    },
    {
      "code" : "122",
      "display" : "Bacillus subtilis var. niger"
    },
    {
      "code" : "124",
      "display" : "Bacillus thuringiensis"
    },
    {
      "code" : "126",
      "display" : "Bacteroides caccae"
    },
    {
      "code" : "128",
      "display" : "Bacteroides distasonis"
    },
    {
      "code" : "130",
      "display" : "Bacteroides fragilis"
    },
    {
      "code" : "132",
      "display" : "Bacteroides ovatus"
    },
    {
      "code" : "134",
      "display" : "Bacteroides spp"
    },
    {
      "code" : "135",
      "display" : "Bacteroides stercoris"
    },
    {
      "code" : "137",
      "display" : "Bacteroides uniformis"
    },
    {
      "code" : "139",
      "display" : "Bacteroides vulgatus"
    },
    {
      "code" : "141",
      "display" : "Bergeyella zoohelcum"
    },
    {
      "code" : "143",
      "display" : "Bifidobacterium bifidum"
    },
    {
      "code" : "145",
      "display" : "Bifidobacterium dentium"
    },
    {
      "code" : "172",
      "display" : "Brevibacterium epidermidis"
    },
    {
      "code" : "174",
      "display" : "Brevibacterium spp"
    },
    {
      "code" : "176",
      "display" : "Brevundimonas vesicularis"
    },
    {
      "code" : "178",
      "display" : "Brucella melitensis"
    },
    {
      "code" : "180",
      "display" : "Brucella melitensis biovar canis"
    },
    {
      "code" : "182",
      "display" : "Brucella melitensis biovar ovis"
    },
    {
      "code" : "184",
      "display" : "Brucella mellitensis"
    },
    {
      "code" : "186",
      "display" : "Budvicia aquatica"
    },
    {
      "code" : "188",
      "display" : "Burkholderia cepacia group"
    },
    {
      "code" : "190",
      "display" : "Burkholderia gladioli"
    },
    {
      "code" : "192",
      "display" : "Burkholderia multivorans"
    },
    {
      "code" : "194",
      "display" : "Burkholderia pickettii bio.1 (Pseudomonas pickettii bio.1)"
    },
    {
      "code" : "197",
      "display" : "Burkholderia stabilis"
    },
    {
      "code" : "199",
      "display" : "Burkholderia vietnamiensis"
    },
    {
      "code" : "201",
      "display" : "Campylobacter coli"
    },
    {
      "code" : "203",
      "display" : "Campylobacter concisus"
    },
    {
      "code" : "205",
      "display" : "Campylobacter fetus"
    },
    {
      "code" : "207",
      "display" : "Campylobacter fetus ssp fetus"
    },
    {
      "code" : "209",
      "display" : "Campylobacter hyointestinalis"
    },
    {
      "code" : "211",
      "display" : "Campylobacter jejuni ssp doylei"
    },
    {
      "code" : "213",
      "display" : "Campylobacter jejuni ssp jejuni"
    },
    {
      "code" : "216",
      "display" : "Campylobacter laridis"
    },
    {
      "code" : "218",
      "display" : "Campylobacter spp."
    },
    {
      "code" : "219",
      "display" : "Campylobacter sputorum"
    },
    {
      "code" : "221",
      "display" : "Campylobacter sputorum ssp fecalis"
    },
    {
      "code" : "224",
      "display" : "Candida albicans"
    },
    {
      "code" : "226",
      "display" : "Candida boidinii"
    },
    {
      "code" : "227",
      "display" : "Candida catenulata"
    },
    {
      "code" : "229",
      "display" : "Candida colliculosa"
    },
    {
      "code" : "231",
      "display" : "Candida curvata (Cryptococcus curvatus)"
    },
    {
      "code" : "234",
      "display" : "Candida famata"
    },
    {
      "code" : "235",
      "display" : "Candida famata/(Candida valida)"
    },
    {
      "code" : "238",
      "display" : "Candida globosa/Citeromyces matritensis"
    },
    {
      "code" : "240",
      "display" : "Candida guilliermondii if pseudohyphae present"
    },
    {
      "code" : "243",
      "display" : "Candida inconspicua"
    },
    {
      "code" : "245",
      "display" : "Candida intermedia"
    },
    {
      "code" : "246",
      "display" : "Candida kefyr"
    },
    {
      "code" : "248",
      "display" : "Candida lambica"
    },
    {
      "code" : "250",
      "display" : "Candida lusitaniae"
    },
    {
      "code" : "252",
      "display" : "Candida maris"
    },
    {
      "code" : "253",
      "display" : "Candida melibiosica"
    },
    {
      "code" : "255",
      "display" : "Candida norvegensis"
    },
    {
      "code" : "257",
      "display" : "Candida parapsilosis"
    },
    {
      "code" : "259",
      "display" : "Candida pelliculosa"
    },
    {
      "code" : "261",
      "display" : "Candida rugosa"
    },
    {
      "code" : "263",
      "display" : "Candida silvicola/Hansenula holstii"
    },
    {
      "code" : "265",
      "display" : "Candida sphaerica"
    },
    {
      "code" : "267",
      "display" : "Candida spp"
    },
    {
      "code" : "268",
      "display" : "Candida stellatoidea"
    },
    {
      "code" : "270",
      "display" : "Candida tropicalis (Candida paratropicalis)"
    },
    {
      "code" : "273",
      "display" : "Candida zeylanoides"
    },
    {
      "code" : "275",
      "display" : "Capnocytophaga ochracea"
    },
    {
      "code" : "277",
      "display" : "Capnocytophaga sputigena"
    },
    {
      "code" : "279",
      "display" : "Carnobacterium divergens"
    },
    {
      "code" : "281",
      "display" : "Cedecea davisae"
    },
    {
      "code" : "283",
      "display" : "Cedecea neteri"
    },
    {
      "code" : "284",
      "display" : "Cedecea spp"
    },
    {
      "code" : "286",
      "display" : "Cellulomonas turbata (Oerskovia turbata)"
    },
    {
      "code" : "289",
      "display" : "Chlamydia pneumoniae"
    },
    {
      "code" : "290",
      "display" : "Chlamydia spp"
    },
    {
      "code" : "292",
      "display" : "Chromobacterium species"
    },
    {
      "code" : "294",
      "display" : "Chryseobacterium (Flavobacterium) indologenes"
    },
    {
      "code" : "297",
      "display" : "Chryseobacterium indologenes"
    },
    {
      "code" : "299",
      "display" : "Chryseobacterium meningosepticum"
    },
    {
      "code" : "301",
      "display" : "Citrobacter amalonaticus"
    },
    {
      "code" : "303",
      "display" : "Citrobacter braakii"
    },
    {
      "code" : "305",
      "display" : "Citrobacter freundii"
    },
    {
      "code" : "307",
      "display" : "Citrobacter koseri"
    },
    {
      "code" : "335",
      "display" : "Clostridium novyi"
    },
    {
      "code" : "337",
      "display" : "Clostridium perfringens"
    },
    {
      "code" : "339",
      "display" : "Clostridium ramosum"
    },
    {
      "code" : "340",
      "display" : "Clostridium septicum"
    },
    {
      "code" : "342",
      "display" : "Clostridium sphenoides"
    },
    {
      "code" : "344",
      "display" : "Clostridium spp"
    },
    {
      "code" : "346",
      "display" : "Clostridium tertium"
    },
    {
      "code" : "348",
      "display" : "Clostridium tyrobutyricum"
    },
    {
      "code" : "350",
      "display" : "Comamonas spp"
    },
    {
      "code" : "352",
      "display" : "Corynebacterium accolens"
    },
    {
      "code" : "354",
      "display" : "Corynebacterium amycolatum"
    },
    {
      "code" : "356",
      "display" : "Corynebacterium aquaticum"
    },
    {
      "code" : "358",
      "display" : "Corynebacterium auris"
    },
    {
      "code" : "360",
      "display" : "Corynebacterium coyleae"
    },
    {
      "code" : "362",
      "display" : "Corynebacterium diphtheriae"
    },
    {
      "code" : "364",
      "display" : "Corynebacterium diphtheriae biotype gravis"
    },
    {
      "code" : "367",
      "display" : "Corynebacterium flavescens"
    },
    {
      "code" : "369",
      "display" : "Corynebacterium group A"
    },
    {
      "code" : "371",
      "display" : "Corynebacterium group A_5"
    },
    {
      "code" : "373",
      "display" : "Corynebacterium group B"
    },
    {
      "code" : "375",
      "display" : "Corynebacterium group F"
    },
    {
      "code" : "377",
      "display" : "Corynebacterium group F_2"
    },
    {
      "code" : "379",
      "display" : "Corynebacterium group G_1"
    },
    {
      "code" : "381",
      "display" : "Corynebacterium group I"
    },
    {
      "code" : "383",
      "display" : "Corynebacterium jeikeium (group JK)"
    },
    {
      "code" : "385",
      "display" : "Corynebacterium macginleyi"
    },
    {
      "code" : "387",
      "display" : "Corynebacterium minutissimum"
    },
    {
      "code" : "389",
      "display" : "Corynebacterium propinquum"
    },
    {
      "code" : "392",
      "display" : "Corynebacterium pseudotuberculosis"
    },
    {
      "code" : "394",
      "display" : "Corynebacterium renale group"
    },
    {
      "code" : "396",
      "display" : "Corynebacterium species"
    },
    {
      "code" : "398",
      "display" : "Corynebacterium striatum (Corynebacterium flavidum)"
    },
    {
      "code" : "401",
      "display" : "Corynebacterium urealiticum"
    },
    {
      "code" : "403",
      "display" : "Corynebacterium xerosis"
    },
    {
      "code" : "405",
      "display" : "Cryptococcus humicolus"
    },
    {
      "code" : "407",
      "display" : "Cryptococcus luteolus"
    },
    {
      "code" : "409",
      "display" : "Cryptococcus species, not neoformans yeast"
    },
    {
      "code" : "412",
      "display" : "Cryptosporidium spp."
    },
    {
      "code" : "413",
      "display" : "Cupriavidus pauculus"
    },
    {
      "code" : "415",
      "display" : "Debaryomyces marama"
    },
    {
      "code" : "417",
      "display" : "Debaryomyces spp"
    },
    {
      "code" : "419",
      "display" : "Dermabacter hominis"
    },
    {
      "code" : "421",
      "display" : "Dermacoccus nishinomiyaensis(Micrococcus)"
    },
    {
      "code" : "423",
      "display" : "Dietzia spp"
    },
    {
      "code" : "425",
      "display" : "Echinococcus granulosus"
    },
    {
      "code" : "427",
      "display" : "Edwardsiella hoshinae"
    },
    {
      "code" : "429",
      "display" : "Edwardsiella spp"
    },
    {
      "code" : "431",
      "display" : "Eikenella corrodens"
    },
    {
      "code" : "433",
      "display" : "Endolimax nana"
    },
    {
      "code" : "434",
      "display" : "Entamoeba coli"
    },
    {
      "code" : "436",
      "display" : "Entamoeba hartmanni"
    },
    {
      "code" : "438",
      "display" : "Entamoeba spp."
    },
    {
      "code" : "440",
      "display" : "Enterobacter amnigenus"
    },
    {
      "code" : "442",
      "display" : "Enterobacter amnigenus biogroup 2"
    },
    {
      "code" : "444",
      "display" : "Enterobacter cancerogenus"
    },
    {
      "code" : "446",
      "display" : "Enterobacter cloacae / asburiae"
    },
    {
      "code" : "448",
      "display" : "Enterobacter hormaechei"
    },
    {
      "code" : "450",
      "display" : "Enterobacter sakazakii"
    },
    {
      "code" : "452",
      "display" : "Enterobius vermicularis"
    },
    {
      "code" : "454",
      "display" : "Enterococcus casseliflavus"
    },
    {
      "code" : "456",
      "display" : "Enterococcus cecorum (Streptococcus cecorum)"
    },
    {
      "code" : "459",
      "display" : "Enterococcus faecium"
    }
  ]
}

```
