# Despacho - Alprazolam - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Despacho - Alprazolam**

## Example MedicationDispense: Despacho - Alprazolam

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

> **Información del lote del medicamento**
* lotNumber: R0664R01
* quantity: 2

**status**: Completed

**medication**: [ANSIOLIT 0,5 mg tabletas (Gutis Ltda.)](Medication-539.md)

**subject**: [JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)

> **performer****actor**:[MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)

> **performer****actor**:[Consultorio Particular de MARIA JOSE ARRIETA](Organization-12102.md)

> **performer****actor**:[ANGELA MARIA RAMIREZ VILLALOBOS](RelatedPerson-65198.md)

**authorizingPrescription**: [Prescripción medica](MedicationRequest-2360448.md)

**quantity**: 30 comprimido(s)

**daysSupply**: 30 days

**whenHandedOver**: 2025-05-27 22:20:25+0000

> **dosageInstruction****text**: .**timing**: Duration 30days , Once per 30 days**route**:Oral

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tableta(s) |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "2360448",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "lotNumber",
          "valueString" : "R0664R01"
        },
        {
          "url" : "quantity",
          "valueInteger" : 2
        }
      ],
      "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/lot-number"
    }
  ],
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/539",
    "display" : "ANSIOLIT 0,5 mg tabletas (Gutis Ltda.)"
  },
  "subject" : {
    "reference" : "Patient/98015",
    "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/3092",
        "display" : "MARIA JOSE ARRIETA GUZMAN"
      }
    },
    {
      "actor" : {
        "reference" : "Organization/12102",
        "display" : "Consultorio Particular de MARIA JOSE ARRIETA"
      }
    },
    {
      "actor" : {
        "reference" : "RelatedPerson/65198",
        "display" : "ANGELA MARIA RAMIREZ VILLALOBOS"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/2360448",
      "display" : "Prescripción medica"
    }
  ],
  "quantity" : {
    "value" : 30,
    "unit" : "comprimido(s)"
  },
  "daysSupply" : {
    "value" : 30,
    "unit" : "days"
  },
  "whenHandedOver" : "2025-05-27T22:20:25.000Z",
  "dosageInstruction" : [
    {
      "text" : ".",
      "timing" : {
        "repeat" : {
          "duration" : 30,
          "durationUnit" : "d",
          "frequency" : 1,
          "period" : 30,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code",
            "code" : "PO",
            "display" : "Oral"
          }
        ],
        "text" : "Oral"
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tableta(s)"
          }
        }
      ]
    }
  ]
}

```
