# Prescripción - Metilfenidato - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prescripción - Metilfenidato**

## Example MedicationRequest: Prescripción - Metilfenidato

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Tipo de receta**: r-a

**status**: Completed

**intent**: Order

**medication**: [CONCERTA 54 mg comprimidos de liberación prolongada (Janssen-Cilag Manufacturing LLC, Gurabo)](Medication-513.md)

**subject**: [JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)

**encounter**: [Encounter](Encounter-111766.md)

**supportingInformation**: [AllergyIntolerance](AllergyIntolerance-4070.md)

**authoredOn**: 2025-05-27 21:53:25+0000

**requester**: [MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)

**groupIdentifier**: B862AF23FE

**note**: 

> 

.


> **dosageInstruction****text**: .**timing**: Duration 30days , Once per 30 days**route**:Oral

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 comprimido(s) |


> **dispenseRequest****validityPeriod**: 2025-05-27 21:53:25+0000 --> 2025-06-26 21:53:25+0000**numberOfRepeatsAllowed**: 1**quantity**: 30 Comprimidos

### ExpectedSupplyDurations

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Unit** |
| * | 30 | days |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "2369982",
  "extension" : [
    {
      "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type",
      "valueString" : "r-a"
    }
  ],
  "status" : "completed",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "Medication/513",
    "display" : "CONCERTA 54 mg comprimidos de liberación prolongada (Janssen-Cilag Manufacturing LLC, Gurabo)"
  },
  "subject" : {
    "reference" : "Patient/98015",
    "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
  },
  "encounter" : {
    "reference" : "Encounter/111766",
    "display" : "Encounter"
  },
  "supportingInformation" : [
    {
      "reference" : "AllergyIntolerance/4070",
      "display" : "AllergyIntolerance"
    }
  ],
  "authoredOn" : "2025-05-27T21:53:25.000Z",
  "requester" : {
    "reference" : "Practitioner/3092",
    "display" : "MARIA JOSE ARRIETA GUZMAN"
  },
  "groupIdentifier" : {
    "value" : "B862AF23FE"
  },
  "note" : [
    {
      "text" : "."
    }
  ],
  "dosageInstruction" : [
    {
      "text" : ".",
      "timing" : {
        "repeat" : {
          "duration" : 30,
          "durationUnit" : "d",
          "frequency" : 1,
          "period" : 30,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code",
            "code" : "PO",
            "display" : "Oral"
          }
        ],
        "text" : "Oral"
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "comprimido(s)"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2025-05-27T21:53:25.000Z",
      "end" : "2025-06-26T21:53:25.000Z"
    },
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 30,
      "unit" : "Comprimidos"
    },
    "expectedSupplyDuration" : {
      "value" : 30,
      "unit" : "days"
    }
  }
}

```
