# Prescripción - Amoxicilina - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prescripción - Amoxicilina**

## Example MedicationRequest: Prescripción - Amoxicilina

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Tipo de receta**: ATM

**status**: Completed

**intent**: Order

**category**: Empírica

**medication**: [AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)](Medication-1053.md)

**subject**: [JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)

**encounter**: [Encounter](Encounter-111766.md)

**supportingInformation**: 

* [AllergyIntolerance](AllergyIntolerance-4070.md)
* [Observation(Cultivo)](Observation-271.md)
* [Observation(Panel Gram(-))](Observation-125.md)
* [Observation(Panel Gram(+))](Observation-521.md)

**authoredOn**: 2025-05-27 21:53:25+0000

**requester**: [MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)

**reasonReference**: [J03 Amigdalitis agud](Condition-6283.md)

**groupIdentifier**: 35DF488B05

**note**: 

> 

.


> **dosageInstruction****text**: .**timing**: Duration 7days , Once per 7 days**route**:Oral

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 5 mL |


> **dispenseRequest****validityPeriod**: 2025-05-28 21:17:03+0000 --> 2025-06-04 21:17:03+0000**numberOfRepeatsAllowed**: 1**quantity**: 70 .

### ExpectedSupplyDurations

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Unit** |
| * | 7 | days |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "2377815",
  "extension" : [
    {
      "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type",
      "valueString" : "ATM"
    }
  ],
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/prescription-categories-code",
          "code" : "empirica",
          "display" : "Empírica"
        }
      ],
      "text" : "Empírica"
    }
  ],
  "medicationReference" : {
    "reference" : "Medication/1053",
    "display" : "AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)"
  },
  "subject" : {
    "reference" : "Patient/98015",
    "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
  },
  "encounter" : {
    "reference" : "Encounter/111766",
    "display" : "Encounter"
  },
  "supportingInformation" : [
    {
      "reference" : "AllergyIntolerance/4070",
      "display" : "AllergyIntolerance"
    },
    {
      "reference" : "Observation/271",
      "display" : "Observation(Cultivo)"
    },
    {
      "reference" : "Observation/125",
      "display" : "Observation(Panel Gram(-))"
    },
    {
      "reference" : "Observation/521",
      "display" : "Observation(Panel Gram(+))"
    }
  ],
  "authoredOn" : "2025-05-27T21:53:25.000Z",
  "requester" : {
    "reference" : "Practitioner/3092",
    "display" : "MARIA JOSE ARRIETA GUZMAN"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/6283",
      "display" : "J03 Amigdalitis agud"
    }
  ],
  "groupIdentifier" : {
    "value" : "35DF488B05"
  },
  "note" : [
    {
      "text" : "."
    }
  ],
  "dosageInstruction" : [
    {
      "text" : ".",
      "timing" : {
        "repeat" : {
          "duration" : 7,
          "durationUnit" : "d",
          "frequency" : 1,
          "period" : 7,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code",
            "code" : "PO",
            "display" : "Oral"
          }
        ],
        "text" : "Oral"
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 5,
            "unit" : "mL"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2025-05-28T21:17:03.000Z",
      "end" : "2025-06-04T21:17:03.000Z"
    },
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 70,
      "unit" : "."
    },
    "expectedSupplyDuration" : {
      "value" : 7,
      "unit" : "days"
    }
  }
}

```
