# Dirección para Receta Digital Costa Rica - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Dirección para Receta Digital Costa Rica**

## Data Type Profile: Dirección para Receta Digital Costa Rica 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:AddressRD |
| **Copyright/Legal**: Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons | | |

 
Perfil de Dirección utilizado en el contexto de la Receta Digital en Costa Rica. 

**Usages:**

* Use this DataType Profile: [Organization](StructureDefinition-organization.md), [Patient](StructureDefinition-patient.md), [Practitioner](StructureDefinition-practitioner.md) and [RelatedPerson](StructureDefinition-related-person.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/address-rd)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-address-rd.csv), [Excel](StructureDefinition-address-rd.xlsx), [Schematron](StructureDefinition-address-rd.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "address-rd",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd",
  "version" : "1.1.0-ballot",
  "name" : "AddressRD",
  "title" : "Dirección para Receta Digital Costa Rica",
  "status" : "draft",
  "date" : "2025-10-22T15:53:28-06:00",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil de Dirección utilizado en el contexto de la Receta Digital en Costa Rica.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Address",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address"
      },
      {
        "id" : "Address.use",
        "path" : "Address.use",
        "max" : "0"
      },
      {
        "id" : "Address.text",
        "path" : "Address.text",
        "short" : "Texto completo de la dirección.",
        "definition" : "Texto que representa la dirección completa de forma legible por humanos.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Address.city",
        "path" : "Address.city",
        "short" : "Nombre del cantón.",
        "definition" : "Nombre del cantón donde se encuentra ubicada la organización.",
        "min" : 1
      },
      {
        "id" : "Address.district",
        "path" : "Address.district",
        "short" : "Nombre del distrito.",
        "definition" : "Nombre del distrito donde se ubica la organización.",
        "min" : 1
      },
      {
        "id" : "Address.state",
        "path" : "Address.state",
        "short" : "Nombre de la provincia.",
        "definition" : "Nombre de la provincia donde se encuentra ubicada la organización.",
        "min" : 1
      },
      {
        "id" : "Address.country",
        "path" : "Address.country",
        "short" : "Nombre del país.",
        "definition" : "Nombre del país donde se encuentra ubicada la organización.",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
