# AllergyIntolerance - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance**

## Resource Profile: AllergyIntolerance 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/allergy-intolerance | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:AllergyIntoleranceRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Alergias e Intolerancias (AllergyIntolerance) 

**Usages:**

* Refer to this Profile: [MedicationRequest](StructureDefinition-medicationRequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/allergy-intolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-allergy-intolerance.csv), [Excel](StructureDefinition-allergy-intolerance.xlsx), [Schematron](StructureDefinition-allergy-intolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "allergy-intolerance",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/allergy-intolerance",
  "version" : "1.1.0-ballot",
  "name" : "AllergyIntoleranceRD",
  "title" : "AllergyIntolerance",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Alergias e Intolerancias (AllergyIntolerance)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.id",
        "path" : "AllergyIntolerance.id",
        "short" : "Identificador único de la Alergia dentro del sistema.",
        "definition" : "Identificador único de la Alergia dentro del sistema.",
        "comment" : "Este es el identificador único de la Alergia dentro del sistema. Se espera que la Alergia tenga un identificador único dentro del sistema."
      },
      {
        "id" : "AllergyIntolerance.meta",
        "path" : "AllergyIntolerance.meta",
        "max" : "0"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "path" : "AllergyIntolerance.clinicalStatus",
        "short" : "El estado clínico actual de la alergia: active | inactive | resolved",
        "definition" : "El estado clínico actual de la alergia de un paciente",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que describen el estado clínico de la alergia",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/AllergyStatus"
        }
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus.coding",
        "path" : "AllergyIntolerance.clinicalStatus.coding",
        "short" : "Codificación del estado clínico",
        "definition" : "Codificación que describe el estado clínico de la alergia",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus.coding.system",
        "path" : "AllergyIntolerance.clinicalStatus.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar el estado clínico de la alergia"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus.coding.code",
        "path" : "AllergyIntolerance.clinicalStatus.coding.code",
        "short" : "Código del estado clínico",
        "definition" : "Código que representa el estado clínico de la alergia",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus.coding.display",
        "path" : "AllergyIntolerance.clinicalStatus.coding.display",
        "short" : "Descripción del estado clínico",
        "definition" : "Descripción textual del estado clínico de la alergia"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus.text",
        "path" : "AllergyIntolerance.clinicalStatus.text",
        "short" : "Texto del estado clínico",
        "definition" : "Representación textual del estado clínico de la alergia"
      },
      {
        "id" : "AllergyIntolerance.verificationStatus",
        "path" : "AllergyIntolerance.verificationStatus",
        "short" : "Estado de verificación de la alergia: unconfirmed | presumed | confirmed | refuted | entered-in-error",
        "definition" : "El estado de verificación representa la certeza sobre la validez de la alergia o intolerancia documentada.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que indican el estado de verificación de la alergia o intolerancia.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/AllergyVerification"
        }
      },
      {
        "id" : "AllergyIntolerance.verificationStatus.coding",
        "path" : "AllergyIntolerance.verificationStatus.coding",
        "short" : "Codificación del estado de verificación",
        "definition" : "Codificación que representa el estado de verificación de la alergia o intolerancia.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.verificationStatus.coding.system",
        "path" : "AllergyIntolerance.verificationStatus.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar el estado de verificación de la alergia o intolerancia."
      },
      {
        "id" : "AllergyIntolerance.verificationStatus.coding.code",
        "path" : "AllergyIntolerance.verificationStatus.coding.code",
        "short" : "Código del estado de verificación",
        "definition" : "Código que indica el estado de verificación de la alergia o intolerancia.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.verificationStatus.coding.display",
        "path" : "AllergyIntolerance.verificationStatus.coding.display",
        "short" : "Descripción del estado de verificación",
        "definition" : "Descripción textual asociada al código del estado de verificación."
      },
      {
        "id" : "AllergyIntolerance.verificationStatus.text",
        "path" : "AllergyIntolerance.verificationStatus.text",
        "short" : "Texto del estado de verificación",
        "definition" : "Representación textual del estado de verificación cuando no se puede codificar o como información adicional para el usuario."
      },
      {
        "id" : "AllergyIntolerance.type",
        "path" : "AllergyIntolerance.type",
        "short" : "Tipo de alergia o intolerancia",
        "definition" : "Define si la condición corresponde a una alergia (respuesta inmunológica), a una intolerancia (respuesta no inmunológica), etc.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "short" : "Categoría del agente causal: food | medication | environment | biologic",
        "definition" : "Categoría de la sustancia responsable de la alergia o intolerancia, como alimentos, medicamentos, ambiente o agentes biológicos.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/allergyCategory"
        }
      },
      {
        "id" : "AllergyIntolerance.criticality",
        "path" : "AllergyIntolerance.criticality",
        "short" : "Nivel de gravedad potencial: low | high | unknown",
        "definition" : "Nivel de riesgo asociado a la exposición al alérgeno, como bajo, alto o no evaluable.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "short" : "Sustancia que causa la alergia o intolerancia",
        "definition" : "Identificación de la sustancia o agente responsable de provocar la alergia o intolerancia.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que representan sustancias o agentes causantes de alergias o intolerancias.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/Substances"
        }
      },
      {
        "id" : "AllergyIntolerance.code.coding",
        "path" : "AllergyIntolerance.code.coding",
        "short" : "Codificación de la sustancia",
        "definition" : "Codificación de la sustancia que causa la alergia o intolerancia.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.code.coding.system",
        "path" : "AllergyIntolerance.code.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar la sustancia causante."
      },
      {
        "id" : "AllergyIntolerance.code.coding.code",
        "path" : "AllergyIntolerance.code.coding.code",
        "short" : "Código de la sustancia",
        "definition" : "Código que representa la sustancia que provoca la alergia o intolerancia.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.code.coding.display",
        "path" : "AllergyIntolerance.code.coding.display",
        "short" : "Descripción de la sustancia",
        "definition" : "Descripción textual del agente causante de la alergia o intolerancia."
      },
      {
        "id" : "AllergyIntolerance.code.text",
        "path" : "AllergyIntolerance.code.text",
        "short" : "Texto de la sustancia",
        "definition" : "Nombre libre de la sustancia cuando no se puede codificar o se desea presentar información adicional."
      },
      {
        "id" : "AllergyIntolerance.patient",
        "path" : "AllergyIntolerance.patient",
        "short" : "Paciente al que corresponde la alergia.",
        "definition" : "Referencia al paciente al que corresponde la alergia.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.patient.reference",
        "path" : "AllergyIntolerance.patient.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente relacionado con la alergia.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.patient.display",
        "path" : "AllergyIntolerance.patient.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente relacionado con la alergia."
      },
      {
        "id" : "AllergyIntolerance.onset[x]",
        "path" : "AllergyIntolerance.onset[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.onset[x]:onsetDateTime",
        "path" : "AllergyIntolerance.onset[x]",
        "sliceName" : "onsetDateTime",
        "short" : "Fecha en que se registró la alergia.",
        "definition" : "Fecha y hora en que se documentó la alergia en el sistema.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.recorder",
        "path" : "AllergyIntolerance.recorder",
        "short" : "Profesional que registró la alergia",
        "definition" : "Referencia al profesional de salud que documentó la alergia o intolerancia en el sistema.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.recorder.reference",
        "path" : "AllergyIntolerance.recorder.reference",
        "short" : "Referencia al profesional",
        "definition" : "Referencia al recurso que representa al profesional que registró la alergia.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.recorder.display",
        "path" : "AllergyIntolerance.recorder.display",
        "short" : "Nombre del profesional",
        "definition" : "Nombre del profesional que documentó la alergia o intolerancia."
      },
      {
        "id" : "AllergyIntolerance.reaction",
        "path" : "AllergyIntolerance.reaction",
        "short" : "Reacción observada ante la sustancia causal",
        "definition" : "Detalle de los signos o síntomas presentados por el paciente como respuesta a la exposición al agente causal.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "short" : "Síntomas o signos clínicos",
        "definition" : "Síntomas o signos clínicos observados como parte de la reacción alérgica.",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/Manifestation"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.coding",
        "path" : "AllergyIntolerance.reaction.manifestation.coding",
        "short" : "Codificación del síntoma",
        "definition" : "Codificación estandarizada que representa el síntoma o signo observado en la reacción.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.coding.system",
        "path" : "AllergyIntolerance.reaction.manifestation.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar el síntoma o signo clínico, por ejemplo, SNOMED CT."
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.coding.code",
        "path" : "AllergyIntolerance.reaction.manifestation.coding.code",
        "short" : "Código del síntoma",
        "definition" : "Código que identifica el síntoma observado en la reacción alérgica.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.coding.display",
        "path" : "AllergyIntolerance.reaction.manifestation.coding.display",
        "short" : "Nombre del síntoma",
        "definition" : "Nombre o descripción del síntoma representado por el código."
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.text",
        "path" : "AllergyIntolerance.reaction.manifestation.text",
        "short" : "Descripción textual del síntoma",
        "definition" : "Descripción textual del síntoma cuando no se utiliza codificación o para mayor claridad."
      },
      {
        "id" : "AllergyIntolerance.reaction.severity",
        "path" : "AllergyIntolerance.reaction.severity",
        "short" : "Gravedad de la reacción",
        "definition" : "Nivel de gravedad de la reacción alérgica observada: leve, moderada o severa.",
        "min" : 1
      }
    ]
  }
}

```
