# Condition - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition**

## Resource Profile: Condition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/condition | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:ConditionRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Condiciones o Diagnósticos (Condition) 

**Usages:**

* Refer to this Profile: [MedicationRequest](StructureDefinition-medicationRequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/condition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-condition.csv), [Excel](StructureDefinition-condition.xlsx), [Schematron](StructureDefinition-condition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "condition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/condition",
  "version" : "1.1.0-ballot",
  "name" : "ConditionRD",
  "title" : "Condition",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Condiciones o Diagnósticos (Condition)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.id",
        "path" : "Condition.id",
        "short" : "Identificador único de la Condición dentro del sistema.",
        "definition" : "Identificador único de la Condición dentro del sistema.",
        "comment" : "Este es el identificador único de la Condición dentro del sistema. Se espera que la Condición tenga un identificador único dentro del sistema."
      },
      {
        "id" : "Condition.meta",
        "path" : "Condition.meta",
        "max" : "0"
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "short" : "El estado clínico actual de la condición: active | recurrence | relapse | inactive | remission | resolved",
        "definition" : "El estado clínico actual de la condición de un paciente",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que describen el estado clínico de la condición",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/conditionStatus"
        }
      },
      {
        "id" : "Condition.clinicalStatus.coding",
        "path" : "Condition.clinicalStatus.coding",
        "short" : "Codificación del estado clínico",
        "definition" : "Codificación que describe el estado clínico de la condición",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.clinicalStatus.coding.system",
        "path" : "Condition.clinicalStatus.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar el estado clínico de la condición"
      },
      {
        "id" : "Condition.clinicalStatus.coding.code",
        "path" : "Condition.clinicalStatus.coding.code",
        "short" : "Código del estado clínico",
        "definition" : "Código que representa el estado clínico de la condición",
        "min" : 1
      },
      {
        "id" : "Condition.clinicalStatus.coding.display",
        "path" : "Condition.clinicalStatus.coding.display",
        "short" : "Descripción del estado clínico",
        "definition" : "Descripción textual del estado clínico de la condición"
      },
      {
        "id" : "Condition.clinicalStatus.text",
        "path" : "Condition.clinicalStatus.text",
        "short" : "Texto del estado clínico",
        "definition" : "Representación textual del estado clínico de la condición"
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "max" : "0"
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "short" : "Clasificación de la condición o diagnóstico: unconfirmed | provisional | differential | confirmed | refuted | entered-in-error",
        "definition" : "Clasificación de la condición o diagnóstico según su estado de verificación",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar definidos para clasificar la condición",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/conditionCategory"
        }
      },
      {
        "id" : "Condition.category.coding",
        "path" : "Condition.category.coding",
        "short" : "Codificación de la categoría",
        "definition" : "Codificación que describe la categoría de la condición",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.category.coding.system",
        "path" : "Condition.category.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar la categoría de la condición"
      },
      {
        "id" : "Condition.category.coding.code",
        "path" : "Condition.category.coding.code",
        "short" : "Código de la categoría",
        "definition" : "Código que representa la categoría de la condición",
        "min" : 1
      },
      {
        "id" : "Condition.category.coding.display",
        "path" : "Condition.category.coding.display",
        "short" : "Descripción de la categoría",
        "definition" : "Descripción textual de la categoría de la condición"
      },
      {
        "id" : "Condition.category.text",
        "path" : "Condition.category.text",
        "short" : "Texto de la categoría",
        "definition" : "Representación textual de la categoría de la condición"
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "short" : "Códigos de SNOMED-CT y adicionales de ausente o desconocido",
        "definition" : "Identificación de la condición, el problema o el diagnóstico o registro del \"problema ausente\" o de los \"problemas desconocidos\".",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Diagnósticos en SNOMED-CT. El ValueSet trae toda la terminología + Problema Ausente o Desconocido",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/conditionDiagnostic"
        }
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "short" : "Codificación del código",
        "definition" : "Codificación que describe el código de la condición",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.code.coding.system",
        "path" : "Condition.code.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar el código de la condición"
      },
      {
        "id" : "Condition.code.coding.code",
        "path" : "Condition.code.coding.code",
        "short" : "Código de la condición",
        "definition" : "Código que representa la condición",
        "min" : 1
      },
      {
        "id" : "Condition.code.coding.display",
        "path" : "Condition.code.coding.display",
        "short" : "Descripción del código",
        "definition" : "Descripción textual del código de la condición"
      },
      {
        "id" : "Condition.code.text",
        "path" : "Condition.code.text",
        "short" : "Texto del código",
        "definition" : "Representación textual del código de la condición"
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "short" : "Paciente al que corresponde la condición.",
        "definition" : "Referencia al paciente al que corresponde la condición.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.subject.reference",
        "path" : "Condition.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente relacionado con la condición.",
        "min" : 1
      },
      {
        "id" : "Condition.subject.display",
        "path" : "Condition.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente relacionado con la condición."
      },
      {
        "id" : "Condition.encounter",
        "path" : "Condition.encounter",
        "short" : "Encuentro relacionado con la condición.",
        "definition" : "Referencia al encuentro relacionado con la condición.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.encounter.reference",
        "path" : "Condition.encounter.reference",
        "short" : "Referencia al encuentro",
        "definition" : "Referencia al recurso del encuentro relacionado con la condición.",
        "min" : 1
      },
      {
        "id" : "Condition.encounter.display",
        "path" : "Condition.encounter.display",
        "short" : "Descripción del encuentro",
        "definition" : "Descripción del encuentro relacionado con la condición."
      },
      {
        "id" : "Condition.recordedDate",
        "path" : "Condition.recordedDate",
        "short" : "Fecha en que se registró la condición.",
        "definition" : "Fecha y hora en que se documentó la condición en el sistema.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "short" : "Persona que registró la condición.",
        "definition" : "Referencia a la persona que registró la condición.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.recorder.reference",
        "path" : "Condition.recorder.reference",
        "short" : "Referencia al registrador",
        "definition" : "Referencia al recurso de la persona que registró la condición.",
        "min" : 1
      },
      {
        "id" : "Condition.recorder.display",
        "path" : "Condition.recorder.display",
        "short" : "Nombre del registrador",
        "definition" : "Nombre de la persona que registró la condición."
      }
    ]
  }
}

```
