# MedicationStatement - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatement**

## Resource Profile: MedicationStatement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication-statement | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicationStatementRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Declaración de Medicación (MedicationStatement) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/medication-statement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication-statement.csv), [Excel](StructureDefinition-medication-statement.xlsx), [Schematron](StructureDefinition-medication-statement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication-statement",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication-statement",
  "version" : "1.1.0-ballot",
  "name" : "MedicationStatementRD",
  "title" : "MedicationStatement",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Declaración de Medicación (MedicationStatement)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement"
      },
      {
        "id" : "MedicationStatement.id",
        "path" : "MedicationStatement.id",
        "short" : "Identificador único de la Declaración de Medicación dentro del sistema.",
        "definition" : "Identificador único de la Declaración de Medicación dentro del sistema.",
        "comment" : "Este es el identificador único de la Declaración de Medicación dentro del sistema. Se espera que la Declaración de Medicación tenga un identificador único dentro del sistema."
      },
      {
        "id" : "MedicationStatement.meta",
        "path" : "MedicationStatement.meta",
        "max" : "0"
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "short" : "Estado de la declaración de medicación",
        "definition" : "Código que representa el estado de la declaración de medicación, como activo, completado, etc.",
        "fixedCode" : "active",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationStatementStatus"
            }
          ],
          "strength" : "required",
          "description" : "Estado estándar que identifica el estado de la declaración de medicación",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-statement-status|4.0.1"
        }
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "short" : "Referencia a la medicación asociada",
        "definition" : "La referencia a la medicación que está asociada con la declaración de medicación.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.medication[x].reference",
        "path" : "MedicationStatement.medication[x].reference",
        "short" : "Referencia a la medicación",
        "definition" : "Referencia al recurso de la medicación asociada con la declaración de medicación.",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.medication[x].display",
        "path" : "MedicationStatement.medication[x].display",
        "short" : "Nombre de la medicación",
        "definition" : "Nombre de la medicación asociada con la declaración de medicación."
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "short" : "Referencia al paciente asociado",
        "definition" : "La referencia al paciente que está asociado con la declaración de medicación.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.subject.reference",
        "path" : "MedicationStatement.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente asociado con la declaración de medicación.",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.subject.display",
        "path" : "MedicationStatement.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente asociado con la declaración de medicación."
      },
      {
        "id" : "MedicationStatement.context",
        "path" : "MedicationStatement.context",
        "short" : "Referencia al encuentro asociado",
        "definition" : "La referencia al encuentro que está asociado con la declaración de medicación.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.context.reference",
        "path" : "MedicationStatement.context.reference",
        "short" : "Referencia al encuentro",
        "definition" : "Referencia al recurso del encuentro asociado con la declaración de medicación.",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.context.display",
        "path" : "MedicationStatement.context.display",
        "short" : "Nombre del encuentro",
        "definition" : "Nombre del encuentro asociado con la declaración de medicación."
      },
      {
        "id" : "MedicationStatement.effective[x]",
        "path" : "MedicationStatement.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MedicationStatement.effective[x]:effectiveDateTime",
        "path" : "MedicationStatement.effective[x]",
        "sliceName" : "effectiveDateTime",
        "short" : "Fecha y hora de efectividad",
        "definition" : "Fecha y hora que representa cuándo la declaración de medicación es efectiva",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
