# Organization - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization**

## Resource Profile: Organization 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:OrganizationRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Organizaciones (Organization) 

**Usages:**

* Refer to this Profile: [Encounter](StructureDefinition-encounter.md) and [MedicationDispense](StructureDefinition-medicationDispense.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization.csv), [Excel](StructureDefinition-organization.xlsx), [Schematron](StructureDefinition-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization",
  "version" : "1.1.0-ballot",
  "name" : "OrganizationRD",
  "title" : "Organization",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Organizaciones (Organization)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.id",
        "path" : "Organization.id",
        "short" : "Identificador único de la Declaración de Medicación dentro del sistema.",
        "definition" : "Identificador único de la Declaración de Medicación dentro del sistema.",
        "comment" : "Este es el identificador único de la Declaración de Medicación dentro del sistema. Se espera que la Declaración de Medicación tenga un identificador único dentro del sistema.",
        "min" : 1
      },
      {
        "id" : "Organization.meta",
        "path" : "Organization.meta",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "Lista de identificadores de la Organización.",
        "definition" : "Listado de identificadores que permiten identificar a una organización en distintos sistemas.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier.use",
        "path" : "Organization.identifier.use",
        "min" : 1,
        "fixedCode" : "official"
      },
      {
        "id" : "Organization.identifier.type",
        "path" : "Organization.identifier.type",
        "short" : "Tipo de documento de identificación (obligatorio).",
        "definition" : "Tipo de documento utilizado para identificar a la organización, según un sistema predefinido.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/InstitutionIdType"
        }
      },
      {
        "id" : "Organization.identifier.type.coding",
        "path" : "Organization.identifier.type.coding",
        "short" : "Codificación del tipo de documento de identificación.",
        "definition" : "Código del tipo de documento de identificación de la organización, basado en un sistema estandarizado.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier.type.coding.system",
        "path" : "Organization.identifier.type.coding.system",
        "short" : "Sistema que define el tipo de documento de identificación.",
        "definition" : "URI del sistema que clasifica los tipos de documento de identificación válidos para organizaciones.",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.type.coding.code",
        "path" : "Organization.identifier.type.coding.code",
        "short" : "Código del tipo de documento de identificación.",
        "definition" : "Valor codificado del tipo de identificación según el sistema definido.",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.type.coding.display",
        "path" : "Organization.identifier.type.coding.display",
        "short" : "Nombre legible del tipo de documento de identificación.",
        "definition" : "Descripción legible asociada al código del tipo de identificación.",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.type.text",
        "path" : "Organization.identifier.type.text",
        "short" : "Nombre del tipo de identificación.",
        "definition" : "Nombre del tipo de identificación de la organización.",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "short" : "Sistema que asigna el identificador.",
        "definition" : "Sistema o autoridad que asignó el identificador a la organización."
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "short" : "Número de identificación de la organización.",
        "definition" : "Valor del identificador asignado a la organización.",
        "min" : 1
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "max" : "0"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "Tipo de Organización.",
        "definition" : "Categoría o clasificación de la Organización según su función o naturaleza institucional.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/InstitutionType"
        }
      },
      {
        "id" : "Organization.type.coding",
        "path" : "Organization.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.type.coding.system",
        "path" : "Organization.type.coding.system",
        "short" : "Sistema de codificación del tipo de organización.",
        "definition" : "URI del sistema que define los tipos válidos de organización.",
        "min" : 1
      },
      {
        "id" : "Organization.type.coding.code",
        "path" : "Organization.type.coding.code",
        "short" : "Código del tipo de organización.",
        "definition" : "Valor codificado que representa el tipo de organización.",
        "min" : 1
      },
      {
        "id" : "Organization.type.coding.display",
        "path" : "Organization.type.coding.display",
        "short" : "Nombre legible del tipo de organización.",
        "definition" : "Nombre o descripción legible asociada al código del tipo de organización.",
        "min" : 1
      },
      {
        "id" : "Organization.type.text",
        "path" : "Organization.type.text",
        "short" : "Nombre del tipo de organización.",
        "definition" : "Nombre o descripción textual del tipo de organización, utilizada cuando no se puede codificar o para proporcionar información adicional.",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "Nombre de la Organización.",
        "definition" : "Nombre oficial o reconocido de la organización.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "short" : "Teléfono o correo electrónico de la Organización.",
        "definition" : "Teléfono o correo electrónico de la Organización.",
        "min" : 1,
        "max" : "2",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "short" : "Dirección de la Organización.",
        "definition" : "Dirección física en la que se encuentra ubicada la Organización.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
