# Patient - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient**

## Resource Profile: Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PatientRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Paciente (Patient) 

**Usages:**

* Refer to this Profile: [AllergyIntolerance](StructureDefinition-allergy-intolerance.md), [Condition](StructureDefinition-condition.md), [Encounter](StructureDefinition-encounter.md), [MedicationStatement](StructureDefinition-medication-statement.md)...Show 9 more,[MedicationDispense](StructureDefinition-medicationDispense.md),[MedicationRequest](StructureDefinition-medicationRequest.md),[Observation (Análisis microbiológico de tipo cultivo)](StructureDefinition-observation-cultive.md),[Observation (Análisis microbiológico de tipo frotis)](StructureDefinition-observation-frotis.md),[Observation (Análisis microbiológico de tipo gram negativo)](StructureDefinition-observation-gram-negative.md),[Observation (Análisis microbiológico de tipo gram positivo)](StructureDefinition-observation-gram-positive.md),[Observation (Talla)](StructureDefinition-observation-height.md),[Observation (Peso)](StructureDefinition-observation-weight.md)and[RelatedPerson](StructureDefinition-related-person.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient.csv), [Excel](StructureDefinition-patient.xlsx), [Schematron](StructureDefinition-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient",
  "version" : "1.1.0-ballot",
  "name" : "PatientRD",
  "title" : "Patient",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Paciente (Patient)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.id",
        "path" : "Patient.id",
        "short" : "Identificador único del Paciente dentro del sistema.",
        "definition" : "Identificador único del Paciente dentro del sistema.",
        "comment" : "Este es el identificador único del Paciente dentro del sistema. Se espera que el Paciente tenga un identificador único dentro del sistema."
      },
      {
        "id" : "Patient.meta",
        "path" : "Patient.meta",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "short" : "Lista de los identificadores del Paciente.",
        "definition" : "Este es el listado de Identificaciones de un paciente.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier.use",
        "path" : "Patient.identifier.use",
        "fixedCode" : "official"
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "short" : "Tipo de documento de identificación (Extensible)",
        "definition" : "Se define como tipo de documento de identificación, referente a los tipos de identificación de los profesionales de salud, aquel definido en el sistema.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "ValueSet de tipos de identificación permitidos para el paciente en Costa Rica.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/idTypes"
        }
      },
      {
        "id" : "Patient.identifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "short" : "Código de tipo de identificación del Paciente.",
        "definition" : "Código de tipo de identificación del Paciente.",
        "comment" : "Código de tipo de identificación del Paciente.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "short" : "Sistema de identificación del Paciente.",
        "definition" : "Sistema de identificación del Paciente.",
        "comment" : "Sistema de identificación del Paciente."
      },
      {
        "id" : "Patient.identifier.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "short" : "Código del tipo de identificación del Paciente.",
        "definition" : "Código del tipo de identificación del Paciente.",
        "comment" : "Código del tipo de identificación del Paciente.",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.type.coding.display",
        "path" : "Patient.identifier.type.coding.display",
        "short" : "Descripción del código de tipos de identificación para el paciente.",
        "definition" : "Descripción del código de tipos de identificación para el paciente.",
        "comment" : "Descripción del código de tipos de identificación para el paciente."
      },
      {
        "id" : "Patient.identifier.type.text",
        "path" : "Patient.identifier.type.text",
        "short" : "Nombre del valor de tipo de identificación del Paciente.",
        "definition" : "Nombre del valor de tipo de identificación del Paciente.",
        "comment" : "Nombre del valor de tipo de identificación del Paciente."
      },
      {
        "id" : "Patient.identifier.system",
        "path" : "Patient.identifier.system",
        "short" : "Sistema de identificación del Paciente.",
        "definition" : "Sistema de identificación del Paciente.",
        "comment" : "Sistema de identificación del Paciente."
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "short" : "Número de identificación del Paciente o número de documento.",
        "definition" : "Número de identificación del Paciente o número de documento.",
        "comment" : "Número de identificación del Paciente o número de documento.",
        "min" : 1
      },
      {
        "id" : "Patient.active",
        "path" : "Patient.active",
        "max" : "0"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "short" : "Nombre del paciente.",
        "definition" : "Nombre del Paciente.",
        "comment" : "Es un elemento clave para la identificación inicial. En Costa Rica, los nombres tienen alta especificidad (dos apellidos), lo que aumenta la precisión del matching.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.use",
        "path" : "Patient.name.use",
        "max" : "0"
      },
      {
        "id" : "Patient.name.text",
        "path" : "Patient.name.text",
        "short" : "Nombre completo del paciente.",
        "definition" : "Nombre completo del paciente.",
        "comment" : "Nombre completo del paciente. Se espera que el paciente tenga al menos un nombre y un apellido.",
        "min" : 1
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "short" : "Apellidos del paciente.",
        "definition" : "Apellidos del paciente.",
        "min" : 1
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "short" : "Nombres del paciente.",
        "definition" : "Nombres del paciente.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "Medios de contacto del paciente (teléfono, email, etc.).",
        "definition" : "Detalles de contacto del paciente, como teléfono o correo electrónico.",
        "min" : 1,
        "max" : "2",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "Género con el que el paciente se identifica. (male | female)",
        "definition" : "Género del paciente para fines administrativos, puede ser distinto al sexo biológico.",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "Fecha de nacimiento del paciente.",
        "definition" : "Fecha de nacimiento del Paciente.",
        "comment" : "Proporciona un dato altamente discriminativo. Combinado con el nombre, permite resolver duplicados y colisiones, especialmente en poblaciones pequeñas como Costa Rica.",
        "min" : 1
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "max" : "0"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "short" : "Dirección física del paciente.",
        "definition" : "Dirección física donde se encuentra ubicado el paciente.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "Profesional de salud asignado al paciente.",
        "definition" : "Referencia al profesional de salud que está asignado al paciente.",
        "comment" : "Esta referencia debe apuntar únicamente a un recurso Practitioner.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner.reference",
        "path" : "Patient.generalPractitioner.reference",
        "short" : "Referencia al profesional de salud",
        "definition" : "Referencia al recurso Practitioner.",
        "min" : 1
      },
      {
        "id" : "Patient.generalPractitioner.display",
        "path" : "Patient.generalPractitioner.display",
        "short" : "Nombre del profesional de salud",
        "definition" : "Nombre del profesional de salud asignado al paciente."
      },
      {
        "id" : "Patient.link",
        "path" : "Patient.link",
        "max" : "0"
      }
    ]
  }
}

```
