# RelatedPerson - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RelatedPerson**

## Resource Profile: RelatedPerson 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/related-person | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:RelatedPersonRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Persona Relacionada (RelatedPerson) 

**Usages:**

* Refer to this Profile: [MedicationDispense](StructureDefinition-medicationDispense.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/related-person)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-related-person.csv), [Excel](StructureDefinition-related-person.xlsx), [Schematron](StructureDefinition-related-person.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "related-person",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/related-person",
  "version" : "1.1.0-ballot",
  "name" : "RelatedPersonRD",
  "title" : "RelatedPerson",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Persona Relacionada (RelatedPerson)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson"
      },
      {
        "id" : "RelatedPerson.id",
        "path" : "RelatedPerson.id",
        "short" : "Identificador único de la persona relacionada dentro del sistema.",
        "definition" : "Identificador único de la persona relacionada dentro del sistema.",
        "comment" : "Este es el identificador único de la persona relacionada dentro del sistema."
      },
      {
        "id" : "RelatedPerson.meta",
        "path" : "RelatedPerson.meta",
        "max" : "0"
      },
      {
        "id" : "RelatedPerson.identifier",
        "path" : "RelatedPerson.identifier",
        "short" : "Lista de los identificadores de la persona relacionada.",
        "definition" : "Este es el listado de identificaciones de una persona relacionada con el paciente.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.identifier.use",
        "path" : "RelatedPerson.identifier.use",
        "fixedCode" : "official"
      },
      {
        "id" : "RelatedPerson.identifier.type",
        "path" : "RelatedPerson.identifier.type",
        "short" : "Tipo de documento de identificación (Extensible)",
        "definition" : "Se define como tipo de documento de identificación, referente a los tipos definidos en el sistema para personas relacionadas.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "ValueSet de tipos de identificación permitidos para personas relacionadas en Costa Rica.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/idTypes"
        }
      },
      {
        "id" : "RelatedPerson.identifier.type.coding",
        "path" : "RelatedPerson.identifier.type.coding",
        "short" : "Código de tipo de identificación de la persona relacionada.",
        "definition" : "Código de tipo de identificación de la persona relacionada.",
        "comment" : "Código de tipo de identificación de la persona relacionada.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "RelatedPerson.identifier.type.coding.system",
        "path" : "RelatedPerson.identifier.type.coding.system",
        "short" : "Sistema de identificación de la persona relacionada.",
        "definition" : "Sistema de identificación de la persona relacionada.",
        "comment" : "Sistema de identificación de la persona relacionada."
      },
      {
        "id" : "RelatedPerson.identifier.type.coding.code",
        "path" : "RelatedPerson.identifier.type.coding.code",
        "short" : "Código del tipo de identificación de la persona relacionada.",
        "definition" : "Código del tipo de identificación de la persona relacionada.",
        "comment" : "Código del tipo de identificación de la persona relacionada.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.identifier.type.coding.display",
        "path" : "RelatedPerson.identifier.type.coding.display",
        "short" : "Descripción del código de tipos de identificación para la persona relacionada.",
        "definition" : "Descripción del código de tipos de identificación para la persona relacionada.",
        "comment" : "Descripción del código de tipos de identificación para la persona relacionada."
      },
      {
        "id" : "RelatedPerson.identifier.type.text",
        "path" : "RelatedPerson.identifier.type.text",
        "short" : "Nombre del valor de tipo de identificación de la persona relacionada.",
        "definition" : "Nombre del valor de tipo de identificación de la persona relacionada.",
        "comment" : "Nombre del valor de tipo de identificación de la persona relacionada."
      },
      {
        "id" : "RelatedPerson.identifier.system",
        "path" : "RelatedPerson.identifier.system",
        "short" : "Sistema de identificación de la persona relacionada.",
        "definition" : "Sistema de identificación de la persona relacionada.",
        "comment" : "Sistema de identificación de la persona relacionada."
      },
      {
        "id" : "RelatedPerson.identifier.value",
        "path" : "RelatedPerson.identifier.value",
        "short" : "Número de identificación o documento de la persona relacionada.",
        "definition" : "Número de identificación o documento de la persona relacionada.",
        "comment" : "Número de identificación o documento de la persona relacionada.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.patient",
        "path" : "RelatedPerson.patient",
        "short" : "Paciente vinculado a la persona relacionada.",
        "definition" : "Referencia al recurso Patient al que está asociada esta persona relacionada (por ejemplo, un familiar o cuidador).",
        "comment" : "Esta referencia debe apuntar únicamente a un recurso Patient.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.patient.reference",
        "path" : "RelatedPerson.patient.reference",
        "short" : "Referencia al paciente",
        "definition" : "Identificador del recurso Patient vinculado a esta persona relacionada.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.patient.display",
        "path" : "RelatedPerson.patient.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente con quien está relacionada esta persona."
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "short" : "Nombre de la persona relacionada.",
        "definition" : "Nombre completo de la persona relacionada con el paciente.",
        "comment" : "Es un elemento clave para la identificación inicial. En Costa Rica, los nombres tienen alta especificidad (dos apellidos), lo que aumenta la precisión del matching.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.name.use",
        "path" : "RelatedPerson.name.use",
        "max" : "0"
      },
      {
        "id" : "RelatedPerson.name.text",
        "path" : "RelatedPerson.name.text",
        "short" : "Nombre completo de la persona relacionada.",
        "definition" : "Nombre completo de la persona relacionada.",
        "comment" : "Se espera que la persona relacionada tenga al menos un nombre y un apellido.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.name.family",
        "path" : "RelatedPerson.name.family",
        "short" : "Apellidos de la persona relacionada.",
        "definition" : "Apellidos de la persona relacionada.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.name.given",
        "path" : "RelatedPerson.name.given",
        "short" : "Nombres de la persona relacionada.",
        "definition" : "Nombres de la persona relacionada.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "RelatedPerson.telecom",
        "path" : "RelatedPerson.telecom",
        "short" : "Medios de contacto de la persona relacionada (teléfono, email, etc.).",
        "definition" : "Detalles de contacto de la persona relacionada con el paciente.",
        "min" : 1,
        "max" : "2",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.gender",
        "path" : "RelatedPerson.gender",
        "short" : "Género con el que se identifica la persona relacionada. (male | female)",
        "definition" : "Género de la persona relacionada para fines administrativos, puede ser distinto al sexo biológico.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.birthDate",
        "path" : "RelatedPerson.birthDate",
        "short" : "Fecha de nacimiento de la persona relacionada.",
        "definition" : "Fecha de nacimiento de la persona relacionada.",
        "comment" : "Proporciona un dato altamente discriminativo. Combinado con el nombre, permite resolver duplicados y colisiones.",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.address",
        "path" : "RelatedPerson.address",
        "short" : "Dirección física de la persona relacionada.",
        "definition" : "Dirección donde reside o puede ser ubicada la persona relacionada.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
