# Artifacts Summary - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AllergyIntolerance](StructureDefinition-allergy-intolerance.md) | Perfil Receta Digital de Alergias e Intolerancias (AllergyIntolerance) |
| [Condition](StructureDefinition-condition.md) | Perfil Receta Digital de Condiciones o Diagnósticos (Condition) |
| [Encounter](StructureDefinition-encounter.md) | Perfil Receta Digital de Encuentro Clínico (Encounter) |
| [Medication](StructureDefinition-medication.md) | Perfil Receta Digital de Medicamentos (Medication) |
| [MedicationDispense](StructureDefinition-medicationDispense.md) | Perfil Receta Digital de Despacho para un Medicamento (MedicationDispense) |
| [MedicationRequest](StructureDefinition-medicationRequest.md) | Perfil Receta Digital de Prescripción para un Medicamento (MedicationRequest) |
| [MedicationStatement](StructureDefinition-medication-statement.md) | Perfil Receta Digital de Declaración de Medicación (MedicationStatement) |
| [Observation (Análisis microbiológico de tipo cultivo)](StructureDefinition-observation-cultive.md) | Perfil Receta Digital de Observaciones de análisis microbiológico tipo cultivo (Observation) |
| [Observation (Análisis microbiológico de tipo frotis)](StructureDefinition-observation-frotis.md) | Perfil Receta Digital de Observaciones de análisis microbiológico tipo frotis (Observation) |
| [Observation (Análisis microbiológico de tipo gram negativo)](StructureDefinition-observation-gram-negative.md) | Perfil Receta Digital de Observaciones de análisis microbiológico tipo gram negativo (Observation) |
| [Observation (Análisis microbiológico de tipo gram positivo)](StructureDefinition-observation-gram-positive.md) | Perfil Receta Digital de Observaciones de análisis microbiológico tipo gram positivo (Observation) |
| [Observation (Peso)](StructureDefinition-observation-weight.md) | Perfil Receta Digital de Observaciones de Peso (Observation) |
| [Observation (Talla)](StructureDefinition-observation-height.md) | Perfil Receta Digital de Observaciones de Talla (Observation) |
| [Organization](StructureDefinition-organization.md) | Perfil Receta Digital de Organizaciones (Organization) |
| [Paquete de Recursos](StructureDefinition-bundle.md) | Perfil Receta Digital de Paquete de Recursos (Bundle) |
| [Patient](StructureDefinition-patient.md) | Perfil Receta Digital de Paciente (Patient) |
| [Practitioner](StructureDefinition-practitioner.md) | Perfil Receta Digital de Profesional de Salud (Practitioner) |
| [RelatedPerson](StructureDefinition-related-person.md) | Perfil Receta Digital de Persona Relacionada (RelatedPerson) |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Contacto para Receta Digital Costa Rica](StructureDefinition-contact-rd.md) | Perfil de contacto (teléfono o email) utilizado en el contexto de la Receta Digital en Costa Rica. |
| [Dirección para Receta Digital Costa Rica](StructureDefinition-address-rd.md) | Perfil de Dirección utilizado en el contexto de la Receta Digital en Costa Rica. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Información del lote del medicamento](StructureDefinition-lot-number.md) | Extensión compuesta que incluye número de lote y cantidad. |
| [Tipo de receta](StructureDefinition-prescription-type.md) | Clasificación de la receta según el régimen correspondiente (por ejemplo, r-a, r-v, r-b, r-am, ATM) |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Listado de cantones](ValueSet-City.md) | Listado de cantones en Receta Digital |
| [Listado de categorias de alergias](ValueSet-allergyCategory.md) | Listado de categorias de alergias en Receta Digital |
| [Listado de categorias de condiciones](ValueSet-conditionCategory.md) | Listado de categorias de condiciones en Receta Digital |
| [Listado de categorías de receta](ValueSet-PrescriptionCategory.md) | Listado de categorías de receta en Receta Digital |
| [Listado de clases de encuentros](ValueSet-encounterClass.md) | Listado de clases de encuentros en Receta Digital |
| [Listado de codigos snomed](ValueSet-snomed.md) | Listado de codigos snomed |
| [Listado de criticidades de alergias](ValueSet-AllergyCriticality.md) | Listado de criticidades de alergias en Receta Digital |
| [Listado de diagnósticos de condiciones](ValueSet-conditionDiagnostic.md) | Listado de diagnósticos de condiciones en Receta Digital |
| [Listado de distritos](ValueSet-District.md) | Listado de distritos en Receta Digital |
| [Listado de duración de las frecuencias](ValueSet-FrequencyDuration.md) | Listado de duración de las frecuencias en Receta Digital |
| [Listado de especialidades médicas](ValueSet-medicalSpecialities.md) | Listado de especialidades médicas en Receta Digital |
| [Listado de estados de alergias](ValueSet-AllergyStatus.md) | Listado de estados de alergias en Receta Digital |
| [Listado de estados de condiciones](ValueSet-conditionStatus.md) | Listado de estados de condiciones en Receta Digital |
| [Listado de estados de dispensación](ValueSet-DispenseStatus.md) | Listado de estados de dispensación en Receta Digital |
| [Listado de estados de encuentros](ValueSet-encounterStatus.md) | Listado de estados de encuentros en Receta Digital |
| [Listado de estados de las prescripciones](ValueSet-prescriptionStatuses.md) | Listado de estados de las prescripciones en Receta Digital |
| [Listado de familias de análisis microbiológico](ValueSet-MicrobiologyAnalysisFamily.md) | Listado de familias de análisis microbiológico en Receta Digital |
| [Listado de formas farmacéuticas de medicamento](ValueSet-MedicationPharmaceuticalForm.md) | Listado de formas farmacéuticas de medicamento en Receta Digital |
| [Listado de frecuencias](ValueSet-Frequency.md) | Listado de frecuencias en Receta Digital |
| [Listado de ingredientes de un medicamento](ValueSet-MedicationIngredient.md) | Listado de ingredientes de un medicamento en Receta Digital |
| [Listado de manifestaciones de alergias](ValueSet-Manifestation.md) | Listado de manifestaciones de alergias en Receta Digital |
| [Listado de microorganismos](ValueSet-Microorganism.md) | Listado de microorganismos en Receta Digital |
| [Listado de provincias](ValueSet-Province.md) | Listado de provincias en Receta Digital |
| [Listado de sensibilidades a los antibióticos gram negativas](ValueSet-AntibioticSensitivityGramNegative.md) | Listado de sensibilidades a los antibióticos gram negativas en Receta Digital |
| [Listado de sensibilidades a los antibióticos gram positivos](ValueSet-AntibioticSensitivityGramPositive.md) | Listado de sensibilidades a los antibióticos gram positivos en Receta Digital |
| [Listado de severidades de manifestación de alergias](ValueSet-ManifestationSeverity.md) | Listado de severidades de manifestación de alergias en Receta Digital |
| [Listado de substancias](ValueSet-Substances.md) | Listado de substancias en Receta Digital |
| [Listado de sugerencias de una dosis](ValueSet-DoseSuggestion.md) | Listado de sugerencias de una dosis en Receta Digital |
| [Listado de tipos de alergias](ValueSet-AllergyType.md) | Listado de tipos de alergias en Receta Digital |
| [Listado de tipos de análisis microbiológico](ValueSet-microbiologyAnalysisType.md) | Listado de tipos de análisis microbiológico en Receta Digital |
| [Listado de tipos de frecuencias](ValueSet-FrequencyType.md) | Listado de tipos de frecuencias en Receta Digital |
| [Listado de tipos de identificación para instituciones](ValueSet-InstitutionIdType.md) | Listado de tipos de identificación para instituciones en Receta Digital |
| [Listado de tipos de instituciones](ValueSet-InstitutionType.md) | Listado de tipos de instituciones en Receta Digital |
| [Listado de tipos de profesional](ValueSet-ProfessionalType.md) | Listado de tipos de profesional en Receta Digital |
| [Listado de tipos de recetas](ValueSet-PrescriptionType.md) | Listado de tipos de recetas en Receta Digital |
| [Listado de unidades de administración de despacho](ValueSet-DespatchAdministrationUnit.md) | Listado de unidades de administración de despacho en Receta Digital |
| [Listado de unidades de medida de un medicamento](ValueSet-MedicationUnitsOfMeasure.md) | Listado de unidades de medida de un medicamento en Receta Digital |
| [Listado de verificaciones de alergias](ValueSet-AllergyVerification.md) | Listado de verificaciones de alergias en Receta Digital |
| [Listado de vías de administración](ValueSet-MedicationAdministrationLine.md) | Listado de vías de administración en Receta Digital |
| [Tipo de identificación](ValueSet-idTypes.md) | Tipo de identificación posibles y existentes en Receta Digital |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Catálogo de categorias de alergias](CodeSystem-allergy-categories-code.md) | Catálogo de categorias de alergias en Receta Digital |
| [Catálogo de categorias de condiciones](CodeSystem-condition-categories-code.md) | Catálogo de categorias de condiciones en Receta Digital |
| [Catálogo de categorías de receta](CodeSystem-prescription-categories-code.md) | Catálogo de categorías de receta en Receta Digital |
| [Catálogo de clases de encuentros](CodeSystem-encounter-class-code.md) | Catálogo de clases de encuentros en Receta Digital |
| [Catálogo de codigos snomed](CodeSystem-snomed-code.md) | Catálogo de codigos snomed |
| [Catálogo de criticidades de alergias](CodeSystem-allergy-criticalities-code.md) | Catálogo de criticidades de alergias en Receta Digital |
| [Catálogo de diagnósticos de condiciones](CodeSystem-condition-diagnostics-code.md) | Catálogo de diagnósticos de condiciones en Receta Digital |
| [Catálogo de duración de las frecuencias](CodeSystem-frequency-duration-code.md) | Catálogo de duración de las frecuencias en Receta Digital |
| [Catálogo de especialidades médicas](CodeSystem-medical-specialities-code.md) | Catálogo de especialidades médicas en Receta Digital |
| [Catálogo de estados de alergias](CodeSystem-allergy-statuses-code.md) | Catálogo de estados de alergias en Receta Digital |
| [Catálogo de estados de condiciones](CodeSystem-condition-statuses-code.md) | Catálogo de estados de condiciones en Receta Digital |
| [Catálogo de estados de dispensación](CodeSystem-dispense-status-code.md) | Catálogo de estados de dispensación en Receta Digital |
| [Catálogo de estados de encuentros](CodeSystem-encounter-status-code.md) | Catálogo de estados de encuentros en Receta Digital |
| [Catálogo de estados de las prescripciones](CodeSystem-prescription-statuses-code.md) | Catálogo de estados de las prescripciones en Receta Digital |
| [Catálogo de familias de análisis microbiológico](CodeSystem-analysis-family-code.md) | Catálogo de familias de análisis microbiológico en Receta Digital |
| [Catálogo de formas farmacéuticas de medicamento](CodeSystem-drugs-presentation-code.md) | Catálogo de formas farmacéuticas de medicamento en Receta Digital |
| [Catálogo de frecuencias](CodeSystem-frequency-code.md) | Catálogo de frecuencias en Receta Digital |
| [Catálogo de ingredientes de un medicamento](CodeSystem-drugs-compound-code.md) | Catálogo de ingredientes de un medicamento en Receta Digital |
| [Catálogo de manifestación de alergias](CodeSystem-manifestations-code.md) | Catálogo de manifestación de alergias en Receta Digital |
| [Catálogo de microorganismos](CodeSystem-microorganism-code.md) | Catálogo de microorganismos en Receta Digital |
| [Catálogo de sensibilidades a los antibióticos gram negativas](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md) | Catálogo de sensibilidades a los antibióticos gram negativas en Receta Digital |
| [Catálogo de sensibilidades a los antibióticos gram positivos](CodeSystem-antibiotic-sensitivity-gram-positives-code.md) | Catálogo de sensibilidades a los antibióticos gram positivos en Receta Digital |
| [Catálogo de severidad de manifestación de alergias](CodeSystem-manifestation-severities-code.md) | Catálogo de severidad de manifestación de alergias en Receta Digital |
| [Catálogo de substancias](CodeSystem-substances-code.md) | Catálogo de substancias en Receta Digital |
| [Catálogo de sugerencias de una dosis](CodeSystem-dose-suggestions-code.md) | Catálogo de sugerencias de una dosis en Receta Digital |
| [Catálogo de tipos de alergias](CodeSystem-allergy-types-code.md) | Catálogo de tipos de alergias en Receta Digital |
| [Catálogo de tipos de análisis microbiológico](CodeSystem-analysis-types-code.md) | Catálogo de tipos de análisis microbiológico en Receta Digital |
| [Catálogo de tipos de frecuencias](CodeSystem-frequency-type-code.md) | Catálogo de tipos de frecuencias en Receta Digital |
| [Catálogo de tipos de identificación para instituciones](CodeSystem-institution-id-type-code.md) | Catálogo de tipos de identificación para instituciones en Receta Digital |
| [Catálogo de tipos de instituciones](CodeSystem-institution-type-code.md) | Catálogo de tipos de instituciones en Receta Digital |
| [Catálogo de tipos de profesional](CodeSystem-professional-type-code.md) | Catálogo de tipos de profesional en Receta Digital |
| [Catálogo de tipos de recetas](CodeSystem-prescription-type-code.md) | Catálogo de tipos de recetas en Receta Digital |
| [Catálogo de unidades de administración de despacho](CodeSystem-despatch-administration-unit-code.md) | Catálogo de unidades de administración de despacho en Receta Digital |
| [Catálogo de unidades de medida de un medicamento](CodeSystem-medication-units-of-measure-code.md) | Catálogo de unidades de medida de un medicamento en Receta Digital |
| [Catálogo de verificación de alergias](CodeSystem-allergy-verifications-code.md) | Catálogo de verificación de alergias en Receta Digital |
| [Catálogo de vías de administración](CodeSystem-administration-lines-code.md) | Catálogo de vías de administración en Receta Digital |
| [Cátalogo nacional de cantones](CodeSystem-cities-code.md) | Cátalogo nacional de cantones en Receta Digital |
| [Cátalogo nacional de distritos](CodeSystem-districts-code.md) | Cátalogo nacional de distritos en Receta Digital |
| [Cátalogo nacional de provincias](CodeSystem-provinces-code.md) | Cátalogo nacional de provincias en Receta Digital |
| [Dominio de Identificación](CodeSystem-id-types-domain.md) | Dominio de identificación posibles y existentes en Receta Digital |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Alergia - Paciente Nacional](AllergyIntolerance-4070.md) | Alergia de Paciente Nacional |
| [Bundle - Despacho Antimicrobianos](Bundle-BundleRD06.md) | Bundle de Despacho de Tipo Antimicrobianos |
| [Bundle - Despacho Estupefacientes](Bundle-BundleRD04.md) | Bundle de Despacho de Tipo Estupefacientes |
| [Bundle - Despacho Psicotrópicos](Bundle-BundleRD05.md) | Bundle de Despacho de Tipo Psicotrópicos |
| [Bundle - Prescripción Antimicrobianos](Bundle-BundleRD03.md) | Bundle de Prescripción de Tipo Antimicrobianos |
| [Bundle - Prescripción Estupefacientes](Bundle-BundleRD01.md) | Bundle de Prescripción de Tipo Estupefacientes |
| [Bundle - Prescripción Psicotrópicos](Bundle-BundleRD02.md) | Bundle de Prescripción de Tipo Psicotrópicos |
| [Condición - Paciente Nacional](Condition-6283.md) | Condición de Paciente Nacional |
| [Declaración - Alprazolam](MedicationStatement-104221.md) | Declaración de Toma de Medicamento con Alprazolam |
| [Declaración - Amoxicilina](MedicationStatement-108729.md) | Declaración de Toma de Medicamento con Amoxicilina |
| [Declaración - Metilfenidato](MedicationStatement-106740.md) | Declaración de Toma de Medicamento con Metilfenidato |
| [Despacho - Alprazolam](MedicationDispense-2360448.md) | Despacho con Alprazolam |
| [Despacho - Amoxicilina](MedicationDispense-2377940.md) | Despacho con Amoxicilina |
| [Despacho - Metilfenidato](MedicationDispense-2377917.md) | Despacho con Metilfenidato |
| [Encuentro - Paciente Nacional](Encounter-111766.md) | Encuentro de Paciente Nacional |
| [Medicamento - Alprazolam](Medication-539.md) | Medicamento con Alprazolam |
| [Medicamento - Amoxicilina](Medication-1053.md) | Medicamento con Amoxicilina |
| [Medicamento - Metilfenidato](Medication-513.md) | Medicamento con Metilfenidato |
| [Observación - Análisis Microbiológico Cultivo](Observation-271.md) | Observación de Análisis Microbiológico Tipo Cultivo |
| [Observación - Análisis Microbiológico Frotis](Observation-268.md) | Observación de Análisis Microbiológico Tipo Frotis |
| [Observación - Análisis Microbiológico Gram Negativo](Observation-125.md) | Observación de Análisis Microbiológico Tipo Gram Negativo |
| [Observación - Análisis Microbiológico Gram Positivo](Observation-521.md) | Observación de Análisis Microbiológico Tipo Gram Positivo |
| [Observación - Peso Paciente Nacional](Observation-2722.md) | Observación del Peso de Paciente Nacional |
| [Observación - Talla Paciente Nacional](Observation-2721.md) | Observación de la Talla de Paciente Nacional |
| [Organización - CENTRO MEDICO CCSS](Organization-12102.md) | CENTRO MEDICO CCSS |
| [Organización - Consultorio Particular](Organization-3092.md) | Consultorio Particular |
| [Paciente - Nacional](Patient-98015.md) | Paciente Nacional |
| [Personal Relacionada - Nacional](RelatedPerson-65198.md) | Personal Relacionada Nacional |
| [Prescripción - Alprazolam](MedicationRequest-2360448.md) | Prescripción con Alprazolam |
| [Prescripción - Amoxicilina](MedicationRequest-2377815.md) | Prescripción con Amoxicilina |
| [Prescripción - Metilfenidato](MedicationRequest-2369982.md) | Prescripción con Metilfenidato |
| [Profesional - Consultorio Particular](Practitioner-3092.md) | Profesional con Consultorio Particular |

