# Generalidades - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* **Generalidades**

## Generalidades

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Aspectos a Considerar

Esta sección describe definiciones, interpretaciones y requisitos importantes comunes a todos los actores de Receta Digital , utilizados en esta guía. Los verbos de conformidad - SHALL (Debe), SHOULD (Debería Si Condición), MAY (Podría) - utilizados en esta guía se definen en las reglas de conformidad de FHIR.

### Definiciones para comprender la Guía.

Los perfiles contienen ciertos elementos que son importantes de comprender a la hora de usarlos para implementación.

#### Vistas de los perfiles

Al revisar un perfil nos encontramos con la posibilidad de ver múltiples vistas de este.

##### Resumen de Texto

Esta vista permite ver un resumen del Perfil como de que recurso proviene elementos mandatorios, eliminados y que deben ser soportados. Además, resume las extensiones y slices generados en el diseño. 

Visión Resumen de un Perfil

##### Vista Diferencial

Esta vista permite observar todos aquellos elmentos de un recurso que han sido modificadas o adecuadas para la realidad local. Esto incluye cambios como cardinalidad, explicaciones, MS o cualquier otro. Los elementos que se han mantenido tal cual en el recurso madre no figuran en esta vista. 

Vista Diferencial de un Perfil

Por razon de lenguaje, toda traducción de la descripción de un elemento se considera un cambio y figura en esta vista.

##### Vista Snapshot

En la vista de la **Snapshot Table**, todos los elementos obligatorios definidos para el perfil, y cualquier elemento obligatorio o que deba ser apoyado heredado de un perfil base, están marcados con una **S**. 

Vista Snapshot Table de un perfil

##### Vista Snapshot (Must Support)

En la vista **Snapshot Table (Must Support)**, todos los elementos presentados en la vista son obligatorios o deben ser compatibles con el perfil. 

Vista Snapshot (Must Support) de un perfil

### Definición del Conjunto Mínimo de Datos

El CMD definido para cada recurso se deja caracterizado por la bandera **MS** que significa Must Support. Este indicador determina que el sistema que recibe ese elemento de un recurso **DEBE** soportar el poder procesarlo y almacenarlo.

La existencia de un elemento o ruta con **MS** no determina la obligatoriedad de que un recurso generado contenga el dato. Esto se define mediante la obligatoriedad del dato lo cual **DEBE** estar especificado en la cardinalidad.

Definición de elementos Must Support

### Cardinalidad

La cardinalidad define dos aspectos de un elemento dentro de un perfil

* Cantidad de veces que un elemento se Puede repetir.
* La minima cantidad de veces que un elemento Debe ser decrito al generar un recurso

De esta forma nos encontramos con varias situaciones

```
{0..1} : El elemento se Puede no ser descrito en el recurso (valor 0 inicial), pero de usarse Debe ser desarrollado solo una vez (1 final)
{1..1} : El elemento es obligatorio pero solo se puede desplegar 1 sola vez
{0..3} : Elemento no obligatorio que se puede repetir hasta 3 veces
{1..3} : Elemento obligatorio que puede repetirse hasta 3 veces
{1..*} : Elemento obligatorio que se puede repetir infintas veces

```

### Bindings

La vinculación obligatoria a una definición de conjunto de valores significa que **SE DEBE** utilizar uno de los códigos del conjunto de valores especificado. En el caso de +CodeableConcept+, no es válido utilizar sólo texto, pero se permiten múltiples codificaciones (traducciones).

La vinculación extensible a una definición de conjunto de valores significa que uno de los códigos del conjunto de valores especificado **SE DEBE USAR** si existe un concepto aplicable, pero si no existe un código adecuado en el conjunto de valores, se **PUEDE** proporcionar un código o códigos alternativos en su lugar. Para CodeableConcept se permiten múltiples codificaciones y esta regla se aplica a una de ellas. También en el caso de CodeableConcept, si sólo se dispone de texto, se puede utilizar sólo el texto.

Definición de Vinculaciones en Códigos

