# Inicio - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* **Inicio**

## Inicio

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard | *Version*:1.1.0-ballot | |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:RecetaDigitalCR |
| **Copyright/Legal**: Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons | | |

### Descargo de Responsabilidad

Las guías de implementación que se presentan a continuación **son un diseño inicial y no constituyen una versión definitiva**. Se han elaborado con la mayor diligencia posible, pero es posible que contengan errores o inexactitudes. Se advierte a los usuarios que no deben basarse únicamente en estas guías para tomar decisiones. Es importante consultar con un profesional calificado para obtener asesoramiento específico sobre la implementación de las guías. Los autores de las guías no asume ninguna responsabilidad por cualquier pérdida o daño que pueda surgir del uso de las guías.

Estas guías de implementación siguen el formato indicado para la **versión FHIR R4** y se presenta en varias secciones que proporciona información general y la explicación técnica de los **Artefactos**.

### Como leer estas Guías

Algunos perfiles podrían ser la fundación para futuras guías de implementación nacionales (registro de pacientes, establecimientos y profesionales), y fueron producidos en colaboración entre el Ministerio de Salud de Costa Rica y RACSA. 

### Perfiles de la Guía

* [Alergias e Intolerancias](StructureDefinition-allergy-intolerance.md)
* [Condiciones o Diagnósticos](StructureDefinition-condition.md)
* [Encuentro Clínico](StructureDefinition-encounter.md)
* [Medicamentos](StructureDefinition-medication.md)
* [Despacho para un Medicamento](StructureDefinition-medicationDispense.md)
* [Prescripción para un Medicamento](StructureDefinition-medicationRequest.md)
* [Declaración de Medicación](StructureDefinition-medication-statement.md)
* [Observaciones de análisis microbiológico tipo cultivo](StructureDefinition-observation-cultive.md)
* [Observaciones de análisis microbiológico tipo frotis](StructureDefinition-observation-frotis.md)
* [Observaciones de análisis microbiológico tipo gram negativo](StructureDefinition-observation-gram-negative.md)
* [Observaciones de análisis microbiológico tipo gram positivo](StructureDefinition-observation-gram-positive.md)
* [Observaciones de Peso](StructureDefinition-observation-weight.md)
* [Observaciones de Talla](StructureDefinition-observation-height.md)
* [Organizaciones](StructureDefinition-organization.md)
* [Paquete de Recursos](StructureDefinition-bundle.md)
* [Paciente](StructureDefinition-patient.md)
* [Profesional de Salud](StructureDefinition-practitioner.md)
* [Persona Relacionada](StructureDefinition-related-person.md)

### Requerimientos de Conformidad

Los requerimientos de conformidad describen las expectativas sobre la funcionalidad de las aplicaciones servidor/cliente, identificando los perfiles específicos y las interacciones que deben implementar. Los perfiles individuales identifican los requerimientos estructurales y terminológicos. Las definiciones de parámetros de búsqueda y operaciones especifican cómo son implementados por los servidores.

### Análisis de Versiones Cruzadas

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cr.minsa.sard.r4)](package.r4.tgz) and [R4B (hl7.fhir.cr.minsa.sard.r4b)](package.r4b.tgz) are available.

### Tabla de Dependencia



### Tabla de Globales

*There are no Global profiles defined*

### Declaraciones de Propiedad Intelectual

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AddressRD](StructureDefinition-address-rd.md), [AdministrationLinesCode](CodeSystem-administration-lines-code.md)...Show 101 more,[AllergyCategoriesCode](CodeSystem-allergy-categories-code.md),[AllergyCategory](ValueSet-allergyCategory.md),[AllergyCriticalitiesCode](CodeSystem-allergy-criticalities-code.md),[AllergyCriticality](ValueSet-AllergyCriticality.md),[AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md),[AllergyStatus](ValueSet-AllergyStatus.md),[AllergyStatusesCode](CodeSystem-allergy-statuses-code.md),[AllergyType](ValueSet-AllergyType.md),[AllergyTypesCode](CodeSystem-allergy-types-code.md),[AllergyVerification](ValueSet-AllergyVerification.md),[AllergyVerificationsCode](CodeSystem-allergy-verifications-code.md),[AnalysisFamilyCode](CodeSystem-analysis-family-code.md),[AnalysisTypesCode](CodeSystem-analysis-types-code.md),[AntibioticSensitivityGramNegative](ValueSet-AntibioticSensitivityGramNegative.md),[AntibioticSensitivityGramNegativesCode](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md),[AntibioticSensitivityGramPositive](ValueSet-AntibioticSensitivityGramPositive.md),[AntibioticSensitivityGramPositivesCode](CodeSystem-antibiotic-sensitivity-gram-positives-code.md),[BundleRD](StructureDefinition-bundle.md),[CitiesCode](CodeSystem-cities-code.md),[City](ValueSet-City.md),[ConditionCategoriesCode](CodeSystem-condition-categories-code.md),[ConditionCategory](ValueSet-conditionCategory.md),[ConditionDiagnostic](ValueSet-conditionDiagnostic.md),[ConditionDiagnosticsCode](CodeSystem-condition-diagnostics-code.md),[ConditionRD](StructureDefinition-condition.md),[ConditionStatus](ValueSet-conditionStatus.md),[ConditionStatusesCode](CodeSystem-condition-statuses-code.md),[ContactRD](StructureDefinition-contact-rd.md),[DespatchAdministrationUnit](ValueSet-DespatchAdministrationUnit.md),[DespatchAdministrationUnitCode](CodeSystem-despatch-administration-unit-code.md),[DispenseStatus](ValueSet-DispenseStatus.md),[DispenseStatusCode](CodeSystem-dispense-status-code.md),[District](ValueSet-District.md),[DistrictsCode](CodeSystem-districts-code.md),[DoseSuggestion](ValueSet-DoseSuggestion.md),[DoseSuggestionsCode](CodeSystem-dose-suggestions-code.md),[DrugsCompoundCode](CodeSystem-drugs-compound-code.md),[DrugsPresentationCode](CodeSystem-drugs-presentation-code.md),[EncounterClass](ValueSet-encounterClass.md),[EncounterClassCode](CodeSystem-encounter-class-code.md),[EncounterRD](StructureDefinition-encounter.md),[EncounterStatus](ValueSet-encounterStatus.md),[EncounterStatusCode](CodeSystem-encounter-status-code.md),[Frequency](ValueSet-Frequency.md),[FrequencyCode](CodeSystem-frequency-code.md),[FrequencyDuration](ValueSet-FrequencyDuration.md),[FrequencyDurationCode](CodeSystem-frequency-duration-code.md),[FrequencyType](ValueSet-FrequencyType.md),[FrequencyTypeCode](CodeSystem-frequency-type-code.md),[IdTypes](ValueSet-idTypes.md),[IdTypesDomain](CodeSystem-id-types-domain.md),[InstitutionIdType](ValueSet-InstitutionIdType.md),[InstitutionIdTypeCode](CodeSystem-institution-id-type-code.md),[InstitutionType](ValueSet-InstitutionType.md),[InstitutionTypeCode](CodeSystem-institution-type-code.md),[LotNumber](StructureDefinition-lot-number.md),[Manifestation](ValueSet-Manifestation.md),[ManifestationSeverities](ValueSet-ManifestationSeverity.md),[ManifestationSeveritiesCode](CodeSystem-manifestation-severities-code.md),[ManifestationsCode](CodeSystem-manifestations-code.md),[MedicalSpecialities](ValueSet-medicalSpecialities.md),[MedicalSpecialitiesCode](CodeSystem-medical-specialities-code.md),[MedicationAdministrationLine](ValueSet-MedicationAdministrationLine.md),[MedicationDispenseRD](StructureDefinition-medicationDispense.md),[MedicationIngredient](ValueSet-MedicationIngredient.md),[MedicationPharmaceuticalForm](ValueSet-MedicationPharmaceuticalForm.md),[MedicationRD](StructureDefinition-medication.md),[MedicationRequestRD](StructureDefinition-medicationRequest.md),[MedicationStatementRD](StructureDefinition-medication-statement.md),[MedicationUnitsOfMeasure](ValueSet-MedicationUnitsOfMeasure.md),[MedicationUnitsOfMeasureCode](CodeSystem-medication-units-of-measure-code.md),[MicrobiologyAnalysisFamily](ValueSet-MicrobiologyAnalysisFamily.md),[MicrobiologyAnalysisType](ValueSet-microbiologyAnalysisType.md),[Microorganism](ValueSet-Microorganism.md),[MicroorganismCode](CodeSystem-microorganism-code.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md),[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md),[ObservationHeightRD](StructureDefinition-observation-height.md),[ObservationWeightRD](StructureDefinition-observation-weight.md),[OrganizationRD](StructureDefinition-organization.md),[PatientRD](StructureDefinition-patient.md),[PractitionerRD](StructureDefinition-practitioner.md),[PrescriptionCategoriesCode](CodeSystem-prescription-categories-code.md),[PrescriptionCategory](ValueSet-PrescriptionCategory.md),[PrescriptionStatuses](ValueSet-prescriptionStatuses.md),[PrescriptionStatusesCode](CodeSystem-prescription-statuses-code.md),[PrescriptionType](ValueSet-PrescriptionType.md),[PrescriptionTypeCode](CodeSystem-prescription-type-code.md),[PrescriptionTypeExtension](StructureDefinition-prescription-type.md),[ProfessionalType](ValueSet-ProfessionalType.md),[ProfessionalTypeCode](CodeSystem-professional-type-code.md),[Province](ValueSet-Province.md),[ProvincesCode](CodeSystem-provinces-code.md),[RecetaDigitalCR](index.md),[RelatedPersonRD](StructureDefinition-related-person.md),[Snomed](ValueSet-snomed.md),[SnomedCode](CodeSystem-snomed-code.md),[Substances](ValueSet-Substances.md)and[SubstancesCode](CodeSystem-substances-code.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [MedicationRD](StructureDefinition-medication.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[AllergyStatus](ValueSet-AllergyStatus.md),[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md)and[Bundle/BundleRD03](Bundle-BundleRD03.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[AllergyVerification](ValueSet-AllergyVerification.md),[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md)and[Bundle/BundleRD03](Bundle-BundleRD03.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Condition/6283](Condition-6283.md), [ConditionRD](StructureDefinition-condition.md) and [ConditionStatus](ValueSet-conditionStatus.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 4 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Encounter/111766](Encounter-111766.md),[EncounterClass](ValueSet-encounterClass.md)and[EncounterRD](StructureDefinition-encounter.md)


* Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.

* [Catálogo de vías de administración](CodeSystem-administration-lines-code.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 13 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Bundle/BundleRD04](Bundle-BundleRD04.md),[Bundle/BundleRD05](Bundle-BundleRD05.md),[Bundle/BundleRD06](Bundle-BundleRD06.md),[MedicationAdministrationLine](ValueSet-MedicationAdministrationLine.md),[MedicationDispense/2360448](MedicationDispense-2360448.md),[MedicationDispense/2377917](MedicationDispense-2377917.md),[MedicationDispense/2377940](MedicationDispense-2377940.md),[MedicationDispenseRD](StructureDefinition-medicationDispense.md),[MedicationRequest/2360448](MedicationRequest-2360448.md),[MedicationRequest/2369982](MedicationRequest-2369982.md),[MedicationRequest/2377815](MedicationRequest-2377815.md)and[MedicationRequestRD](StructureDefinition-medicationRequest.md)
* [Catálogo de criticidades de alergias](CodeSystem-allergy-criticalities-code.md): [AllergyCriticality](ValueSet-AllergyCriticality.md)
* [Catálogo de tipos de alergias](CodeSystem-allergy-types-code.md): [AllergyType](ValueSet-AllergyType.md)
* [Catálogo de familias de análisis microbiológico](CodeSystem-analysis-family-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MicrobiologyAnalysisFamily](ValueSet-MicrobiologyAnalysisFamily.md), [Observation/268](Observation-268.md) and [ObservationFrotisRD](StructureDefinition-observation-frotis.md)
* [Catálogo de tipos de análisis microbiológico](CodeSystem-analysis-types-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MicrobiologyAnalysisType](ValueSet-microbiologyAnalysisType.md)...Show 8 more,[Observation/125](Observation-125.md),[Observation/268](Observation-268.md),[Observation/271](Observation-271.md),[Observation/521](Observation-521.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md)and[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md)
* [Catálogo de sensibilidades a los antibióticos gram negativas](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md): [AntibioticSensitivityGramNegative](ValueSet-AntibioticSensitivityGramNegative.md), [Bundle/BundleRD03](Bundle-BundleRD03.md), [Observation/125](Observation-125.md) and [ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md)
* [Catálogo de sensibilidades a los antibióticos gram positivos](CodeSystem-antibiotic-sensitivity-gram-positives-code.md): [AntibioticSensitivityGramPositive](ValueSet-AntibioticSensitivityGramPositive.md), [Bundle/BundleRD03](Bundle-BundleRD03.md), [Observation/521](Observation-521.md) and [ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md)
* [Cátalogo nacional de cantones](CodeSystem-cities-code.md): [City](ValueSet-City.md)
* [Catálogo de categorias de condiciones](CodeSystem-condition-categories-code.md): [ConditionCategory](ValueSet-conditionCategory.md) and [ConditionRD](StructureDefinition-condition.md)
* [Catálogo de diagnósticos de condiciones](CodeSystem-condition-diagnostics-code.md): [Condition/6283](Condition-6283.md), [ConditionDiagnostic](ValueSet-conditionDiagnostic.md) and [ConditionRD](StructureDefinition-condition.md)
* [Catálogo de unidades de administración de despacho](CodeSystem-despatch-administration-unit-code.md): [DespatchAdministrationUnit](ValueSet-DespatchAdministrationUnit.md)
* [Catálogo de estados de dispensación](CodeSystem-dispense-status-code.md): [DispenseStatus](ValueSet-DispenseStatus.md)
* [Cátalogo nacional de distritos](CodeSystem-districts-code.md): [District](ValueSet-District.md)
* [Catálogo de sugerencias de una dosis](CodeSystem-dose-suggestions-code.md): [DoseSuggestion](ValueSet-DoseSuggestion.md)
* [Catálogo de ingredientes de un medicamento](CodeSystem-drugs-compound-code.md): [MedicationIngredient](ValueSet-MedicationIngredient.md) and [MedicationRD](StructureDefinition-medication.md)
* [Catálogo de formas farmacéuticas de medicamento](CodeSystem-drugs-presentation-code.md): [MedicationPharmaceuticalForm](ValueSet-MedicationPharmaceuticalForm.md) and [MedicationRD](StructureDefinition-medication.md)
* [Catálogo de frecuencias](CodeSystem-frequency-code.md): [Frequency](ValueSet-Frequency.md)
* [Catálogo de duración de las frecuencias](CodeSystem-frequency-duration-code.md): [FrequencyDuration](ValueSet-FrequencyDuration.md)
* [Catálogo de tipos de frecuencias](CodeSystem-frequency-type-code.md): [FrequencyType](ValueSet-FrequencyType.md)
* [Dominio de Identificación](CodeSystem-id-types-domain.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 11 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Bundle/BundleRD04](Bundle-BundleRD04.md),[Bundle/BundleRD05](Bundle-BundleRD05.md),[Bundle/BundleRD06](Bundle-BundleRD06.md),[IdTypes](ValueSet-idTypes.md),[Patient/98015](Patient-98015.md),[PatientRD](StructureDefinition-patient.md),[Practitioner/3092](Practitioner-3092.md),[PractitionerRD](StructureDefinition-practitioner.md),[RelatedPerson/65198](RelatedPerson-65198.md)and[RelatedPersonRD](StructureDefinition-related-person.md)
* [Catálogo de tipos de identificación para instituciones](CodeSystem-institution-id-type-code.md): [CENTRO MEDICO CCSS](Organization-12102.md), [Consultorio Particular de MARIA JOSE ARRIETA](Organization-3092.md), [InstitutionIdType](ValueSet-InstitutionIdType.md) and [OrganizationRD](StructureDefinition-organization.md)
* [Catálogo de tipos de instituciones](CodeSystem-institution-type-code.md): [CENTRO MEDICO CCSS](Organization-12102.md), [Consultorio Particular de MARIA JOSE ARRIETA](Organization-3092.md), [InstitutionType](ValueSet-InstitutionType.md) and [OrganizationRD](StructureDefinition-organization.md)
* [Catálogo de severidad de manifestación de alergias](CodeSystem-manifestation-severities-code.md): [ManifestationSeverities](ValueSet-ManifestationSeverity.md)
* [Catálogo de manifestación de alergias](CodeSystem-manifestations-code.md): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md),[Bundle/BundleRD03](Bundle-BundleRD03.md)and[Manifestation](ValueSet-Manifestation.md)
* [Catálogo de especialidades médicas](CodeSystem-medical-specialities-code.md): [MedicalSpecialities](ValueSet-medicalSpecialities.md)
* [Catálogo de unidades de medida de un medicamento](CodeSystem-medication-units-of-measure-code.md): [MedicationUnitsOfMeasure](ValueSet-MedicationUnitsOfMeasure.md)
* [Catálogo de microorganismos](CodeSystem-microorganism-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [Microorganism](ValueSet-Microorganism.md), [Observation/271](Observation-271.md) and [ObservationCultiveRD](StructureDefinition-observation-cultive.md)
* [Catálogo de categorías de receta](CodeSystem-prescription-categories-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MedicationRequest/2377815](MedicationRequest-2377815.md), [MedicationRequestRD](StructureDefinition-medicationRequest.md) and [PrescriptionCategory](ValueSet-PrescriptionCategory.md)
* [Catálogo de estados de las prescripciones](CodeSystem-prescription-statuses-code.md): [PrescriptionStatuses](ValueSet-prescriptionStatuses.md)
* [Catálogo de tipos de recetas](CodeSystem-prescription-type-code.md): [PrescriptionType](ValueSet-PrescriptionType.md) and [PrescriptionTypeExtension](StructureDefinition-prescription-type.md)
* [Catálogo de tipos de profesional](CodeSystem-professional-type-code.md): [ProfessionalType](ValueSet-ProfessionalType.md)
* [Cátalogo nacional de provincias](CodeSystem-provinces-code.md): [Province](ValueSet-Province.md)
* [Catálogo de codigos snomed](CodeSystem-snomed-code.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 14 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Observation/125](Observation-125.md),[Observation/268](Observation-268.md),[Observation/271](Observation-271.md),[Observation/2721](Observation-2721.md),[Observation/2722](Observation-2722.md),[Observation/521](Observation-521.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md),[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md),[ObservationHeightRD](StructureDefinition-observation-height.md),[ObservationWeightRD](StructureDefinition-observation-weight.md)and[Snomed](ValueSet-snomed.md)
* [Catálogo de substancias](CodeSystem-substances-code.md): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md),[Bundle/BundleRD03](Bundle-BundleRD03.md)and[Substances](ValueSet-Substances.md)


### Consideraciones sobre Propiedad Intelectual

 Si bien esta guía de implementación y el FHIR subyacente tienen licencia de dominio público, esta guía puede incluir ejemplos que utilicen terminologías como LOINC, SNOMED CT y otras que tienen requisitos de licencia más restrictivos. Los implementadores deben familiarizarse con las licencias y cualquier otra restricción de las terminologías, cuestionarios y otros componentes utilizados como parte de su proceso de implementación. En algunos casos, los requisitos de licencia pueden limitar los sistemas con los que se pueden compartir los datos capturados mediante ciertos cuestionarios. 

-------

### Autores:

* [Ministerio de Salud Costa Rica](https://www.ministeriodesalud.go.cr/)
* [RACSA](https://www.racsa.go.cr/)

