# hl7.fhir.cr.minsa.sard#1.1.0-ballot: Guías de Implementación FHIR Receta Digital | Ministerio de Salud

## Pages

* [Inicio](index.md)
* [Artifacts Summary](artifacts.md)
* [Descargas](descargas.md)
* [Generalidades](generalidades.md)
* [Objetivos](objetivos.md)

## Resources

### CodeSystems

* [Catálogo de vías de administración](CodeSystem-administration-lines-code.md)
* [Catálogo de categorias de alergias](CodeSystem-allergy-categories-code.md)
* [Catálogo de criticidades de alergias](CodeSystem-allergy-criticalities-code.md)
* [Catálogo de estados de alergias](CodeSystem-allergy-statuses-code.md)
* [Catálogo de tipos de alergias](CodeSystem-allergy-types-code.md)
* [Catálogo de verificación de alergias](CodeSystem-allergy-verifications-code.md)
* [Catálogo de familias de análisis microbiológico](CodeSystem-analysis-family-code.md)
* [Catálogo de tipos de análisis microbiológico](CodeSystem-analysis-types-code.md)
* [Catálogo de sensibilidades a los antibióticos gram negativas](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md)
* [Catálogo de sensibilidades a los antibióticos gram positivos](CodeSystem-antibiotic-sensitivity-gram-positives-code.md)
* [Cátalogo nacional de cantones](CodeSystem-cities-code.md)
* [Catálogo de categorias de condiciones](CodeSystem-condition-categories-code.md)
* [Catálogo de diagnósticos de condiciones](CodeSystem-condition-diagnostics-code.md)
* [Catálogo de estados de condiciones](CodeSystem-condition-statuses-code.md)
* [Catálogo de unidades de administración de despacho](CodeSystem-despatch-administration-unit-code.md)
* [Catálogo de estados de dispensación](CodeSystem-dispense-status-code.md)
* [Cátalogo nacional de distritos](CodeSystem-districts-code.md)
* [Catálogo de sugerencias de una dosis](CodeSystem-dose-suggestions-code.md)
* [Catálogo de ingredientes de un medicamento](CodeSystem-drugs-compound-code.md)
* [Catálogo de formas farmacéuticas de medicamento](CodeSystem-drugs-presentation-code.md)
* [Catálogo de clases de encuentros](CodeSystem-encounter-class-code.md)
* [Catálogo de estados de encuentros](CodeSystem-encounter-status-code.md)
* [Catálogo de frecuencias](CodeSystem-frequency-code.md)
* [Catálogo de duración de las frecuencias](CodeSystem-frequency-duration-code.md)
* [Catálogo de tipos de frecuencias](CodeSystem-frequency-type-code.md)
* [Dominio de Identificación](CodeSystem-id-types-domain.md)
* [Catálogo de tipos de identificación para instituciones](CodeSystem-institution-id-type-code.md)
* [Catálogo de tipos de instituciones](CodeSystem-institution-type-code.md)
* [Catálogo de severidad de manifestación de alergias](CodeSystem-manifestation-severities-code.md)
* [Catálogo de manifestación de alergias](CodeSystem-manifestations-code.md)
* [Catálogo de especialidades médicas](CodeSystem-medical-specialities-code.md)
* [Catálogo de unidades de medida de un medicamento](CodeSystem-medication-units-of-measure-code.md)
* [Catálogo de microorganismos](CodeSystem-microorganism-code.md)
* [Catálogo de categorías de receta](CodeSystem-prescription-categories-code.md)
* [Catálogo de estados de las prescripciones](CodeSystem-prescription-statuses-code.md)
* [Catálogo de tipos de recetas](CodeSystem-prescription-type-code.md)
* [Catálogo de tipos de profesional](CodeSystem-professional-type-code.md)
* [Cátalogo nacional de provincias](CodeSystem-provinces-code.md)
* [Catálogo de codigos snomed](CodeSystem-snomed-code.md)
* [Catálogo de substancias](CodeSystem-substances-code.md)

### ValueSets

* [Listado de criticidades de alergias](ValueSet-AllergyCriticality.md)
* [Listado de estados de alergias](ValueSet-AllergyStatus.md)
* [Listado de tipos de alergias](ValueSet-AllergyType.md)
* [Listado de verificaciones de alergias](ValueSet-AllergyVerification.md)
* [Listado de sensibilidades a los antibióticos gram negativas](ValueSet-AntibioticSensitivityGramNegative.md)
* [Listado de sensibilidades a los antibióticos gram positivos](ValueSet-AntibioticSensitivityGramPositive.md)
* [Listado de cantones](ValueSet-City.md)
* [Listado de unidades de administración de despacho](ValueSet-DespatchAdministrationUnit.md)
* [Listado de estados de dispensación](ValueSet-DispenseStatus.md)
* [Listado de distritos](ValueSet-District.md)
* [Listado de sugerencias de una dosis](ValueSet-DoseSuggestion.md)
* [Listado de frecuencias](ValueSet-Frequency.md)
* [Listado de duración de las frecuencias](ValueSet-FrequencyDuration.md)
* [Listado de tipos de frecuencias](ValueSet-FrequencyType.md)
* [Listado de tipos de identificación para instituciones](ValueSet-InstitutionIdType.md)
* [Listado de tipos de instituciones](ValueSet-InstitutionType.md)
* [Listado de manifestaciones de alergias](ValueSet-Manifestation.md)
* [Listado de severidades de manifestación de alergias](ValueSet-ManifestationSeverity.md)
* [Listado de vías de administración](ValueSet-MedicationAdministrationLine.md)
* [Listado de ingredientes de un medicamento](ValueSet-MedicationIngredient.md)
* [Listado de formas farmacéuticas de medicamento](ValueSet-MedicationPharmaceuticalForm.md)
* [Listado de unidades de medida de un medicamento](ValueSet-MedicationUnitsOfMeasure.md)
* [Listado de familias de análisis microbiológico](ValueSet-MicrobiologyAnalysisFamily.md)
* [Listado de microorganismos](ValueSet-Microorganism.md)
* [Listado de categorías de receta](ValueSet-PrescriptionCategory.md)
* [Listado de tipos de recetas](ValueSet-PrescriptionType.md)
* [Listado de tipos de profesional](ValueSet-ProfessionalType.md)
* [Listado de provincias](ValueSet-Province.md)
* [Listado de substancias](ValueSet-Substances.md)
* [Listado de categorias de alergias](ValueSet-allergyCategory.md)
* [Listado de categorias de condiciones](ValueSet-conditionCategory.md)
* [Listado de diagnósticos de condiciones](ValueSet-conditionDiagnostic.md)
* [Listado de estados de condiciones](ValueSet-conditionStatus.md)
* [Listado de clases de encuentros](ValueSet-encounterClass.md)
* [Listado de estados de encuentros](ValueSet-encounterStatus.md)
* [Tipo de identificación](ValueSet-idTypes.md)
* [Listado de especialidades médicas](ValueSet-medicalSpecialities.md)
* [Listado de tipos de análisis microbiológico](ValueSet-microbiologyAnalysisType.md)
* [Listado de estados de las prescripciones](ValueSet-prescriptionStatuses.md)
* [Listado de codigos snomed](ValueSet-snomed.md)

### Complex-type Profiles

* [Dirección para Receta Digital Costa Rica](StructureDefinition-address-rd.md)
* [Contacto para Receta Digital Costa Rica](StructureDefinition-contact-rd.md)

### Resource Profiles

* [AllergyIntolerance](StructureDefinition-allergy-intolerance.md)
* [Paquete de Recursos](StructureDefinition-bundle.md)
* [Condition](StructureDefinition-condition.md)
* [Encounter](StructureDefinition-encounter.md)
* [MedicationStatement](StructureDefinition-medication-statement.md)
* [Medication](StructureDefinition-medication.md)
* [MedicationDispense](StructureDefinition-medicationDispense.md)
* [MedicationRequest](StructureDefinition-medicationRequest.md)
* [Observation (Análisis microbiológico de tipo cultivo)](StructureDefinition-observation-cultive.md)
* [Observation (Análisis microbiológico de tipo frotis)](StructureDefinition-observation-frotis.md)
* [Observation (Análisis microbiológico de tipo gram negativo)](StructureDefinition-observation-gram-negative.md)
* [Observation (Análisis microbiológico de tipo gram positivo)](StructureDefinition-observation-gram-positive.md)
* [Observation (Talla)](StructureDefinition-observation-height.md)
* [Observation (Peso)](StructureDefinition-observation-weight.md)
* [Organization](StructureDefinition-organization.md)
* [Patient](StructureDefinition-patient.md)
* [Practitioner](StructureDefinition-practitioner.md)
* [RelatedPerson](StructureDefinition-related-person.md)

### Extensions

* [Información del lote del medicamento](StructureDefinition-lot-number.md)
* [Tipo de receta](StructureDefinition-prescription-type.md)

### ImplementationGuides

* [Guías de Implementación FHIR Receta Digital | Ministerio de Salud](index.md)

### Examples

* [4070 (AllergyIntolerance)](AllergyIntolerance-4070.md)
* [BundleRD01 (Bundle)](Bundle-BundleRD01.md)
* [BundleRD02 (Bundle)](Bundle-BundleRD02.md)
* [BundleRD03 (Bundle)](Bundle-BundleRD03.md)
* [BundleRD04 (Bundle)](Bundle-BundleRD04.md)
* [BundleRD05 (Bundle)](Bundle-BundleRD05.md)
* [BundleRD06 (Bundle)](Bundle-BundleRD06.md)
* [6283 (Condition)](Condition-6283.md)
* [111766 (Encounter)](Encounter-111766.md)
* [1053 (Medication)](Medication-1053.md)
* [513 (Medication)](Medication-513.md)
* [539 (Medication)](Medication-539.md)
* [2360448 (MedicationDispense)](MedicationDispense-2360448.md)
* [2377917 (MedicationDispense)](MedicationDispense-2377917.md)
* [2377940 (MedicationDispense)](MedicationDispense-2377940.md)
* [2360448 (MedicationRequest)](MedicationRequest-2360448.md)
* [2369982 (MedicationRequest)](MedicationRequest-2369982.md)
* [2377815 (MedicationRequest)](MedicationRequest-2377815.md)
* [104221 (MedicationStatement)](MedicationStatement-104221.md)
* [106740 (MedicationStatement)](MedicationStatement-106740.md)
* [108729 (MedicationStatement)](MedicationStatement-108729.md)
* [125 (Observation)](Observation-125.md)
* [268 (Observation)](Observation-268.md)
* [271 (Observation)](Observation-271.md)
* [2721 (Observation)](Observation-2721.md)
* [2722 (Observation)](Observation-2722.md)
* [521 (Observation)](Observation-521.md)
* [CENTRO MEDICO CCSS (Organization)](Organization-12102.md)
* [Consultorio Particular de MARIA JOSE ARRIETA (Organization)](Organization-3092.md)
* [98015 (Patient)](Patient-98015.md)
* [3092 (Practitioner)](Practitioner-3092.md)
* [65198 (RelatedPerson)](RelatedPerson-65198.md)
