# Bundle - Despacho Psicotrópicos - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle - Despacho Psicotrópicos**

## Example Bundle: Bundle - Despacho Psicotrópicos

Profile: [Paquete de Recursos](StructureDefinition-bundle.md)

Bundle BundleRD05 of type transaction

-------

Entry 1 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationDispense/2377940

Rec}:

> **status**: completed**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)
> **performer****actor**:[MARIA JOSE ARRIETA GUZMAN](Practitioner-3092.md)

> **performer****actor**:[Consultorio Particular de MARIA JOSE ARRIETA](Organization-12102.md)

> **performer****actor**:[ANGELA MARIA RAMIREZ VILLALOBOS](RelatedPerson-65198.md)
**authorizingPrescription**:[Prescripción medica](MedicationRequest-2377815.md)**quantity**: 1 frasco(s) 70mL**daysSupply**: 7 days**whenHandedOver**: 2025-05-27 22:05:25+0000
> **dosageInstruction****text**: .**timing**: Duration 7days , Once per 7 days**route**:Oral

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 5 mL |



Request:

```
POST MedicationDispense

```

-------

Entry 2 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationStatement/108729

Rec}:

> **status**: active**status**: recorded**subject**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**effective**: 2025-05-29 09:17:03+0000

Request:

```
POST MedicationStatement

```

-------

Entry 3 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Practitioner/3092

Rec}:

> **identifier**: Cédula Física/112110419 (use: official, )**name**: MARIA JOSE ARRIETA GUZMAN**telecom**: ph: 8665-1234,[dra.arrieta@nuevamentecr.com](mailto:dra.arrieta@nuevamentecr.com)**gender**: Female**birthDate**: 1984-07-14**address**: Lourdes, Montes de Oca

Request:

```
POST Practitioner

```

-------

Entry 4 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/Patient/98015

Rec}:

> JEFFREY ALEJANDRO ARRIETA GUZMAN Male, DoB: 1985-01-12 ( Cédula Física: 112300555 (use: official, ))
-------

Request:

```
POST Patient

```

-------

Entry 5 - fullUrl = https://integrations-api.recetadigital.go.cr/fhir/R4/RelatedPerson/65198

Rec}:

> **identifier**: Cédula Física/401001389 (use: official, )**patient**:[JEFFREY ALEJANDRO ARRIETA GUZMAN](Patient-98015.md)**name**: ANGELA MARIA RAMIREZ VILLALOBOS**telecom**: ph: 88135566,[clinicavalverde@hotmail.com](mailto:clinicavalverde@hotmail.com)**gender**: Female**birthDate**: 1985-06-04**address**: URB CIRUELAS DEL PARQUE 125 MTS SUR

Request:

```
POST RelatedPerson

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "BundleRD05",
  "meta" : {
    "profile" : [
      "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
    ]
  },
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationDispense/2377940",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "2377940",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationDispense_2377940\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationDispense 2377940</b></p><a name=\"2377940\"> </a><a name=\"hc2377940\"> </a><p><b>status</b>: Completed</p><p><b>medication</b>: <a href=\"Medication-1053.html\">AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)</a></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><blockquote><p><b>performer</b></p><p><b>actor</b>: <a href=\"Practitioner-3092.html\">MARIA JOSE ARRIETA GUZMAN</a></p></blockquote><blockquote><p><b>performer</b></p><p><b>actor</b>: <a href=\"Organization-12102.html\">Consultorio Particular de MARIA JOSE ARRIETA</a></p></blockquote><blockquote><p><b>performer</b></p><p><b>actor</b>: <a href=\"RelatedPerson-65198.html\">ANGELA MARIA RAMIREZ VILLALOBOS</a></p></blockquote><p><b>authorizingPrescription</b>: <a href=\"MedicationRequest-2377815.html\">Prescripción medica</a></p><p><b>quantity</b>: 1 frasco(s) 70mL</p><p><b>daysSupply</b>: 7 days</p><p><b>whenHandedOver</b>: 2025-05-27 22:05:25+0000</p><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: .</p><p><b>timing</b>: Duration 7days , Once per 7 days</p><p><b>route</b>: <span title=\"Codes:{https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code PO}\">Oral</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>5 mL</td></tr></table></blockquote></div>"
        },
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/1053",
          "display" : "AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Practitioner/3092",
              "display" : "MARIA JOSE ARRIETA GUZMAN"
            }
          },
          {
            "actor" : {
              "reference" : "Organization/12102",
              "display" : "Consultorio Particular de MARIA JOSE ARRIETA"
            }
          },
          {
            "actor" : {
              "reference" : "RelatedPerson/65198",
              "display" : "ANGELA MARIA RAMIREZ VILLALOBOS"
            }
          }
        ],
        "authorizingPrescription" : [
          {
            "reference" : "MedicationRequest/2377815",
            "display" : "Prescripción medica"
          }
        ],
        "quantity" : {
          "value" : 1,
          "unit" : "frasco(s) 70mL"
        },
        "daysSupply" : {
          "value" : 7,
          "unit" : "days"
        },
        "whenHandedOver" : "2025-05-27T22:05:25.000Z",
        "dosageInstruction" : [
          {
            "text" : ".",
            "timing" : {
              "repeat" : {
                "duration" : 7,
                "durationUnit" : "d",
                "frequency" : 1,
                "period" : 7,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/administration-lines-code",
                  "code" : "PO",
                  "display" : "Oral"
                }
              ],
              "text" : "Oral"
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 5,
                  "unit" : "mL"
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationDispense"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/MedicationStatement/108729",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "108729",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_108729\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 108729</b></p><a name=\"108729\"> </a><a name=\"hc108729\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Medication-1053.html\">AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)</a></p><p><b>subject</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>context</b>: <a href=\"Encounter-111766.html\">Encounter</a></p><p><b>effective</b>: 2025-05-29 09:17:03+0000</p></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/1053",
          "display" : "AUGMENTIN BID 400mg-57mg/5mL (Glaxo Wellcome Production)"
        },
        "subject" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "context" : {
          "reference" : "Encounter/111766",
          "display" : "Encounter"
        },
        "effectiveDateTime" : "2025-05-29T09:17:03Z"
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationStatement"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Practitioner/3092",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "3092",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_3092\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 3092</b></p><a name=\"3092\"> </a><a name=\"hc3092\"> </a><p><b>identifier</b>: Cédula Física/112110419 (use: official, )</p><p><b>name</b>: MARIA JOSE ARRIETA GUZMAN</p><p><b>telecom</b>: ph: 8665-1234, <a href=\"mailto:dra.arrieta@nuevamentecr.com\">dra.arrieta@nuevamentecr.com</a></p><p><b>address</b>: Lourdes, Montes de Oca</p><p><b>gender</b>: Female</p><p><b>birthDate</b>: 1984-07-14</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
                  "code" : "1",
                  "display" : "Cédula Física"
                }
              ],
              "text" : "Cédula Física"
            },
            "value" : "112110419"
          }
        ],
        "name" : [
          {
            "text" : "MARIA JOSE ARRIETA GUZMAN",
            "family" : "ARRIETA GUZMAN",
            "given" : ["MARIA JOSE"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "8665-1234"
          },
          {
            "system" : "email",
            "value" : "dra.arrieta@nuevamentecr.com"
          }
        ],
        "address" : [
          {
            "text" : "Lourdes, Montes de Oca",
            "city" : "MONTES DE OCA",
            "district" : "LOURDES",
            "state" : "SAN JOSÉ",
            "country" : "Costa Rica"
          }
        ],
        "gender" : "female",
        "birthDate" : "1984-07-14"
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/Patient/98015",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "98015",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_98015\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 98015</b></p><a name=\"98015\"> </a><a name=\"hc98015\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">JEFFREY ALEJANDRO ARRIETA GUZMAN Male, DoB: 1985-01-12 ( Cédula Física: 112300555 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 87077072</li><li><a href=\"mailto:jeff.esquivel@gmail.com\">jeff.esquivel@gmail.com</a></li><li>Sabanilla</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Practitioner-3092.html\">MARIA JOSE ARRIETA GUZMAN</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
                  "code" : "1",
                  "display" : "Cédula Física"
                }
              ],
              "text" : "Cédula Física"
            },
            "value" : "112300555"
          }
        ],
        "name" : [
          {
            "text" : "JEFFREY ALEJANDRO ARRIETA GUZMAN",
            "family" : "ESQUIVEL SIBAJA",
            "given" : ["JEFFREY ALEJANDRO"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "87077072"
          },
          {
            "system" : "email",
            "value" : "jeff.esquivel@gmail.com"
          }
        ],
        "gender" : "male",
        "birthDate" : "1985-01-12",
        "address" : [
          {
            "text" : "Sabanilla",
            "city" : "MONTES DE OCA",
            "district" : "SABANILLA",
            "state" : "SAN JOSÉ",
            "country" : "Costa Rica"
          }
        ],
        "generalPractitioner" : [
          {
            "reference" : "Practitioner/3092",
            "display" : "MARIA JOSE ARRIETA GUZMAN"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "https://integrations-api.recetadigital.go.cr/fhir/R4/RelatedPerson/65198",
      "resource" : {
        "resourceType" : "RelatedPerson",
        "id" : "65198",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RelatedPerson_65198\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RelatedPerson 65198</b></p><a name=\"65198\"> </a><a name=\"hc65198\"> </a><p><b>identifier</b>: Cédula Física/401001389 (use: official, )</p><p><b>patient</b>: <a href=\"Patient-98015.html\">JEFFREY ALEJANDRO ARRIETA GUZMAN</a></p><p><b>name</b>: ANGELA MARIA RAMIREZ VILLALOBOS</p><p><b>telecom</b>: ph: 88135566, <a href=\"mailto:clinicavalverde@hotmail.com\">clinicavalverde@hotmail.com</a></p><p><b>gender</b>: Female</p><p><b>birthDate</b>: 1985-06-04</p><p><b>address</b>: URB CIRUELAS DEL PARQUE 125 MTS SUR</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/id-types-domain",
                  "code" : "1",
                  "display" : "Cédula Física"
                }
              ],
              "text" : "Cédula Física"
            },
            "value" : "401001389"
          }
        ],
        "patient" : {
          "reference" : "Patient/98015",
          "display" : "JEFFREY ALEJANDRO ARRIETA GUZMAN"
        },
        "name" : [
          {
            "text" : "ANGELA MARIA RAMIREZ VILLALOBOS",
            "family" : "RAMIREZ VILLALOBOS",
            "given" : ["JEFFREY ALEJANDRO"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "88135566"
          },
          {
            "system" : "email",
            "value" : "clinicavalverde@hotmail.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "1985-06-04",
        "address" : [
          {
            "text" : "URB CIRUELAS DEL PARQUE 125 MTS SUR",
            "city" : "ALAJUELA",
            "district" : "CONCEPCIÓN O EL LLANO",
            "state" : "ALAJUELA",
            "country" : "Costa Rica"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "RelatedPerson"
      }
    }
  ]
}

```
