# Catálogo de sensibilidades a los antibióticos gram positivos - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de sensibilidades a los antibióticos gram positivos**

## CodeSystem: Catálogo de sensibilidades a los antibióticos gram positivos 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-positives-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:AntibioticSensitivityGramPositivesCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de sensibilidades a los antibióticos gram positivos en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AntibioticSensitivityGramPositive](ValueSet-AntibioticSensitivityGramPositive.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "antibiotic-sensitivity-gram-positives-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/antibiotic-sensitivity-gram-positives-code",
  "version" : "1.1.0-ballot",
  "name" : "AntibioticSensitivityGramPositivesCode",
  "title" : "Catálogo de sensibilidades a los antibióticos gram positivos",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de sensibilidades a los antibióticos gram positivos en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 24,
  "concept" : [
    {
      "code" : "AMPICILINA",
      "display" : "Ampicilina (Enterococcus spp, S. agalactiae)"
    },
    {
      "code" : "BENZILPENICILINA",
      "display" : "Benzilpenicilia (Staphylococcus spp, Enterococcus spp, S. agalactiae)"
    },
    {
      "code" : "DETECCION_DE_CEFOXITINA",
      "display" : "Detección de Cefoxitina"
    },
    {
      "code" : "CEFTAROLINA",
      "display" : "Ceftarolina"
    },
    {
      "code" : "CEFOTAXIMA",
      "display" : "Cefotaxima"
    },
    {
      "code" : "CEFTRIAXONA",
      "display" : "Ceftriaxona"
    },
    {
      "code" : "CIPROFLOXACINA",
      "display" : "Ciprofloxacina"
    },
    {
      "code" : "CLINDAMICINA",
      "display" : "Clindamicina"
    },
    {
      "code" : "CLORANFENICOL",
      "display" : "Cloranfenicol"
    },
    {
      "code" : "DAPTOMICINA",
      "display" : "Daptomicina"
    },
    {
      "code" : "ERITROMICINA",
      "display" : "Eritromicina"
    },
    {
      "code" : "GENTAMICINA",
      "display" : "Gentamicina"
    },
    {
      "code" : "GENTAMICINA_DE_ALTO_NIVEL",
      "display" : "Gentamicina de alto nivel (Sinergia)"
    },
    {
      "code" : "RESISTENCIA_INDUCIBLE_CLINDA",
      "display" : "Resistencia inducible a clindamicina"
    },
    {
      "code" : "LEVOFLOXACINA",
      "display" : "Levofloxacina"
    },
    {
      "code" : "LINEZOLID",
      "display" : "Linezolid"
    },
    {
      "code" : "NITROFURANTOINA",
      "display" : "Nitrofurantoína"
    },
    {
      "code" : "OXACILINA",
      "display" : "Oxacilina"
    },
    {
      "code" : "RIFAMPICINA",
      "display" : "Rifampicina"
    },
    {
      "code" : "ESTREPTOMICINA_DE_ALTO_NIVEL",
      "display" : "Estreptomicina de alto nivel (Sinergia)"
    },
    {
      "code" : "TETRACICLINA",
      "display" : "Tetraciclina"
    },
    {
      "code" : "TIGECICLINA",
      "display" : "Tigeciclina"
    },
    {
      "code" : "TRIMETOPRIM_SULFAMETOXAZOL",
      "display" : "Trimetoprim/Sulfametoxazol"
    },
    {
      "code" : "VANCOMICINA",
      "display" : "Vancomicina"
    }
  ]
}

```
