# Catálogo de diagnósticos de condiciones - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de diagnósticos de condiciones**

## CodeSystem: Catálogo de diagnósticos de condiciones 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/condition-diagnostics-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:ConditionDiagnosticsCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de diagnósticos de condiciones en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConditionDiagnostic](ValueSet-conditionDiagnostic.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "condition-diagnostics-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/condition-diagnostics-code",
  "version" : "1.1.0-ballot",
  "name" : "ConditionDiagnosticsCode",
  "title" : "Catálogo de diagnósticos de condiciones",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de diagnósticos de condiciones en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 101243,
  "concept" : [
    {
      "code" : "T438X1A",
      "display" : "T438X1A Envenenamiento por otros fármacos psicótropos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T458X5S",
      "display" : "T458X5S Efecto adverso de otros agentes principalmente sistémicos y hematológicos secuela"
    },
    {
      "code" : "T4591",
      "display" : "T4591 Envenenamiento por agente principalmente sistémico y hematológico no especificado accidental (no intencionado)"
    },
    {
      "code" : "T4592X",
      "display" : "T4592X Envenenamiento por agente principalmente sistémico y hematológico no especificado autolesión intencionada"
    },
    {
      "code" : "T48992",
      "display" : "T48992 Envenenamiento por otros agentes que actúan principalmente sobre el aparato respiratorio autolesión intencionada"
    },
    {
      "code" : "T48993S",
      "display" : "T48993S Envenenamiento por otros agentes que actúan principalmente sobre el aparato respiratorio agresión secuela"
    },
    {
      "code" : "T4141",
      "display" : "T4141 Envenenamiento por anestésico no especificado accidental (no intencionado)"
    },
    {
      "code" : "T4142",
      "display" : "T4142 Envenenamiento por anestésico no especificado autolesión intencionada"
    },
    {
      "code" : "T4143",
      "display" : "T4143 Envenenamiento por anestésico no especificado agresión"
    },
    {
      "code" : "T4144",
      "display" : "T4144 Envenenamiento por anestésico no especificado intencionalidad sin determinar"
    },
    {
      "code" : "T4144XS",
      "display" : "T4144XS Envenenamiento por anestésico no especificado intencionalidad sin determinar secuela"
    },
    {
      "code" : "T4146",
      "display" : "T4146 Infradosificación de anestésicos no especificados"
    },
    {
      "code" : "T4392X",
      "display" : "T4392X Envenenamiento por fármacos psicótropos no especificados autolesión intencionada"
    },
    {
      "code" : "T4393X",
      "display" : "T4393X Envenenamiento por fármacos psicótropos no especificados agresión"
    },
    {
      "code" : "T4394X",
      "display" : "T4394X Envenenamiento por fármacos psicótropos no especificados intencionalidad sin determinar"
    },
    {
      "code" : "T4395X",
      "display" : "T4395X Efecto adverso de fármaco psicótropo no especificado"
    },
    {
      "code" : "T4396X",
      "display" : "T4396X Infradosificación de fármacos psicótropos no especificado"
    },
    {
      "code" : "T460X2",
      "display" : "T460X2 Envenenamiento por glucósidos y fármacos cardioestimulantes de acción similar autolesión intencionada"
    },
    {
      "code" : "T460X3A",
      "display" : "T460X3A Envenenamiento por glucósidos y fármacos cardioestimulantes de acción similar agresión contacto inicial"
    },
    {
      "code" : "T490X3S",
      "display" : "T490X3S Envenenamiento por fármacos antifúngicos antiinfecciosos y antiinflamatorios locales agresión secuela"
    },
    {
      "code" : "T490X5",
      "display" : "T490X5 Efecto adverso de antifúngicos antiinfecciosos y antiinflamatorios locales"
    },
    {
      "code" : "T490X6A",
      "display" : "T490X6A Infradosificación de antifúngicos antiinfecciosos y antiinflamatorios locales contacto inicial"
    },
    {
      "code" : "T415X5D",
      "display" : "T415X5D Efecto adverso de gases medicinales contacto sucesivo"
    },
    {
      "code" : "T415X6D",
      "display" : "T415X6D Infradosificación de gases medicinales contacto sucesivo"
    },
    {
      "code" : "T420X1",
      "display" : "T420X1 Envenenamiento por derivados de hidantoína accidental (no intencionado)"
    },
    {
      "code" : "T420X2A",
      "display" : "T420X2A Envenenamiento por derivados de hidantoína autolesión intencionada contacto inicial"
    },
    {
      "code" : "T420X3D",
      "display" : "T420X3D Envenenamiento por derivados de hidantoína agresión contacto sucesivo"
    },
    {
      "code" : "T420X4S",
      "display" : "T420X4S Envenenamiento por derivados de hidantoína intencionalidad sin determinar secuela"
    },
    {
      "code" : "T440X6D",
      "display" : "T440X6D Infradosificación de agentes anticolinesterásicos contacto sucesivo"
    },
    {
      "code" : "T441X1",
      "display" : "T441X1 Envenenamiento por otros parasimpaticomiméticos [colinérgicos] accidental (no intencionado)"
    },
    {
      "code" : "T441X2D",
      "display" : "T441X2D Envenenamiento por otros parasimpaticomiméticos [colinérgicos] autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T441X4",
      "display" : "T441X4 Envenenamiento por otros parasimpaticomiméticos [colinérgicos] intencionalidad sin determinar"
    },
    {
      "code" : "T461X5",
      "display" : "T461X5 Efecto adverso de antagonistas de canales del calcio"
    },
    {
      "code" : "T461X6A",
      "display" : "T461X6A Infradosificación de bloqueantes de canales del calcio contacto inicial"
    },
    {
      "code" : "T40603",
      "display" : "T40603 Envenenamiento por narcóticos no especificados agresión"
    },
    {
      "code" : "T40604A",
      "display" : "T40604A Envenenamiento por narcóticos no especificados intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T40605D",
      "display" : "T40605D Efecto adverso de narcóticos no especificados contacto sucesivo"
    },
    {
      "code" : "T25312A",
      "display" : "T25312A Quemadura de tercer grado de tobillo izquierdo contacto inicial"
    },
    {
      "code" : "T25319D",
      "display" : "T25319D Quemadura de tercer grado de tobillo no especificado contacto sucesivo"
    },
    {
      "code" : "T25321D",
      "display" : "T25321D Quemadura de tercer grado del pie derecho contacto sucesivo"
    },
    {
      "code" : "T25322S",
      "display" : "T25322S Quemadura de tercer grado del pie izquierdo secuela"
    },
    {
      "code" : "T25329S",
      "display" : "T25329S Quemadura de tercer grado de pie no especificado secuela"
    },
    {
      "code" : "T25331D",
      "display" : "T25331D Quemadura de tercer grado de dedo(s) del pie derecho (uña) contacto sucesivo"
    },
    {
      "code" : "T25332S",
      "display" : "T25332S Quemadura de tercer grado de dedo(s) del pie izquierdo (uña) secuela"
    },
    {
      "code" : "T33821D",
      "display" : "T33821D Congelación superficial del pie derecho contacto sucesivo"
    },
    {
      "code" : "T33822D",
      "display" : "T33822D Congelación superficial del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "T33829S",
      "display" : "T33829S Congelación superficial de pie no especificado secuela"
    },
    {
      "code" : "T33831D",
      "display" : "T33831D Congelación superficial de dedo(s) del pie derecho contacto sucesivo"
    },
    {
      "code" : "T33832S",
      "display" : "T33832S Congelación superficial de dedo(s) del pie izquierdo secuela"
    },
    {
      "code" : "T339",
      "display" : "T339 Congelación superficial de otras localizaciones y las no especificadas"
    },
    {
      "code" : "T3390XS",
      "display" : "T3390XS Congelación superficial de localizaciones no especificadas secuela"
    },
    {
      "code" : "T381X6",
      "display" : "T381X6 Infradosificación de hormonas tiroideas y sustitutos"
    },
    {
      "code" : "T382",
      "display" : "T382 Envenenamiento efecto adverso e infradosificación por antitiroideos"
    },
    {
      "code" : "T382X1S",
      "display" : "T382X1S Envenenamiento por antitiroideos accidental (no intencionado) secuela"
    },
    {
      "code" : "T382X3",
      "display" : "T382X3 Envenenamiento por antitiroideos agresión"
    },
    {
      "code" : "T382X4",
      "display" : "T382X4 Envenenamiento por antitiroideos intencionalidad sin determinar"
    },
    {
      "code" : "T382X5",
      "display" : "T382X5 Efecto adverso de fármacos antitiroideos"
    },
    {
      "code" : "T40696S",
      "display" : "T40696S Infradosificación de otros narcóticos secuela"
    },
    {
      "code" : "T40711A",
      "display" : "T40711A Envenenamiento por cannabis accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T40712D",
      "display" : "T40712D Envenenamiento por cannabis autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T40713D",
      "display" : "T40713D Envenenamiento por cannabis agresión contacto sucesivo"
    },
    {
      "code" : "T40714D",
      "display" : "T40714D Envenenamiento por cannabis intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T40715S",
      "display" : "T40715S Efecto adverso de cannabis secuela"
    },
    {
      "code" : "T40716S",
      "display" : "T40716S Infradosificación de cannabis secuela"
    },
    {
      "code" : "T25419A",
      "display" : "T25419A Corrosión de grado no especificado de tobillo no especificado contacto inicial"
    },
    {
      "code" : "T25421A",
      "display" : "T25421A Corrosión de grado no especificado del pie derecho contacto inicial"
    },
    {
      "code" : "T25422D",
      "display" : "T25422D Corrosión de grado no especificado del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "T25429S",
      "display" : "T25429S Corrosión de grado no especificado de pie no especificado secuela"
    },
    {
      "code" : "T25431S",
      "display" : "T25431S Corrosión de grado no especificado de dedo(s) del pie derecho (uña) secuela"
    },
    {
      "code" : "T3402XS",
      "display" : "T3402XS Congelación con necrosis de tejidos de nariz secuela"
    },
    {
      "code" : "T3409XD",
      "display" : "T3409XD Congelación con necrosis de tejidos de otra parte de la cabeza contacto sucesivo"
    },
    {
      "code" : "T341XXD",
      "display" : "T341XXD Congelación con necrosis de tejidos del cuello contacto sucesivo"
    },
    {
      "code" : "T342XX",
      "display" : "T342XX Congelación con necrosis de tejidos del tórax"
    },
    {
      "code" : "T343",
      "display" : "T343 Congelación con necrosis de tejidos de pared abdominal parte inferior de espalda y pelvis"
    },
    {
      "code" : "T344",
      "display" : "T344 Congelación con necrosis de tejidos del brazo"
    },
    {
      "code" : "T3440XD",
      "display" : "T3440XD Congelación con necrosis de tejidos de brazo no especificado contacto sucesivo"
    },
    {
      "code" : "T383X6",
      "display" : "T383X6 Infradosificación de insulina e hipoglucemiantes orales [antidiabéticos orales]"
    },
    {
      "code" : "T384X",
      "display" : "T384X Envenenamiento efecto adverso e infradosificación por anticonceptivos orales"
    },
    {
      "code" : "T384X2",
      "display" : "T384X2 Envenenamiento por anticonceptivos orales autolesión intencionada"
    },
    {
      "code" : "T384X3A",
      "display" : "T384X3A Envenenamiento por anticonceptivos orales agresión contacto inicial"
    },
    {
      "code" : "T24029",
      "display" : "T24029 Quemadura de grado no especificada de rodilla no especificada"
    },
    {
      "code" : "T24031",
      "display" : "T24031 Quemadura de grado no especificado de parte inferior de la pierna derecha"
    },
    {
      "code" : "T24032A",
      "display" : "T24032A Quemadura de grado no especificado de parte inferior de la pierna izquierda contacto inicial"
    },
    {
      "code" : "T24039D",
      "display" : "T24039D Quemadura de grado no especificada de parte inferior de pierna no especificada contacto sucesivo"
    },
    {
      "code" : "T24091S",
      "display" : "T24091S Quemadura de grado no especificado de localizaciones múltiples de extremidad inferior derecha excepto tobillo y pie secuela"
    },
    {
      "code" : "T25512",
      "display" : "T25512 Corrosión de primer grado de tobillo izquierdo"
    },
    {
      "code" : "T25519",
      "display" : "T25519 Corrosión de primer grado de tobillo no especificado"
    },
    {
      "code" : "T2552",
      "display" : "T2552 Corrosión de primer grado de pie"
    },
    {
      "code" : "T25521S",
      "display" : "T25521S Corrosión de primer grado del pie derecho secuela"
    },
    {
      "code" : "T25522S",
      "display" : "T25522S Corrosión de primer grado del pie izquierdo secuela"
    },
    {
      "code" : "T25529S",
      "display" : "T25529S Corrosión de primer grado de pie no especificado secuela"
    },
    {
      "code" : "T34522",
      "display" : "T34522 Congelación con necrosis de tejidos de mano izquierda"
    },
    {
      "code" : "T34529A",
      "display" : "T34529A Congelación con necrosis de tejidos de mano no especificada contacto inicial"
    },
    {
      "code" : "T34531A",
      "display" : "T34531A Congelación con necrosis de tejidos de dedo(s) de mano derecha contacto inicial"
    },
    {
      "code" : "T34532D",
      "display" : "T34532D Congelación con necrosis de tejidos de dedo(s) de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "T34539S",
      "display" : "T34539S Congelación con necrosis de tejidos de dedo(s) de mano no especificados secuela"
    },
    {
      "code" : "T385X4A",
      "display" : "T385X4A Envenenamiento por otros estrógenos y progestágenos intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T385X5S",
      "display" : "T385X5S Efecto adverso de otros estrógenos y progestágenos secuela"
    },
    {
      "code" : "T386",
      "display" : "T386 Envenenamiento efecto adverso e infradosificación por antigonadotrópicos antiestrógenos y antiandrógenos no clasificados bajo otro concepto"
    },
    {
      "code" : "T386X2A",
      "display" : "T386X2A Envenenamiento por antigonadotropinas antiestrógenos y antiandrógenos no clasificados bajo otro concepto autolesión intencionada contacto inicial"
    },
    {
      "code" : "T24112A",
      "display" : "T24112A Quemadura de primer grado de muslo izquierdo contacto inicial"
    },
    {
      "code" : "T24119D",
      "display" : "T24119D Quemadura de primer grado de muslo no especificado contacto sucesivo"
    },
    {
      "code" : "T24121D",
      "display" : "T24121D Quemadura de primer grado de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "T24122D",
      "display" : "T24122D Quemadura de primer grado de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "T25611S",
      "display" : "T25611S Corrosión de segundo grado de tobillo derecho secuela"
    },
    {
      "code" : "T25612S",
      "display" : "T25612S Corrosión de segundo grado de tobillo izquierdo secuela"
    },
    {
      "code" : "T2562",
      "display" : "T2562 Corrosión de segundo grado de pie"
    },
    {
      "code" : "T25621D",
      "display" : "T25621D Corrosión de segundo grado del pie derecho contacto sucesivo"
    },
    {
      "code" : "T25622S",
      "display" : "T25622S Corrosión de segundo grado del pie izquierdo secuela"
    },
    {
      "code" : "T25629S",
      "display" : "T25629S Corrosión de segundo grado de pie no especificado secuela"
    },
    {
      "code" : "T3472XD",
      "display" : "T3472XD Congelación con necrosis de tejidos de rodilla y parte inferior de la pierna izquierdas contacto sucesivo"
    },
    {
      "code" : "T34811D",
      "display" : "T34811D Congelación con necrosis de tejidos de tobillo derecho contacto sucesivo"
    },
    {
      "code" : "T34812S",
      "display" : "T34812S Congelación con necrosis de tejidos de tobillo izquierdo secuela"
    },
    {
      "code" : "T3482",
      "display" : "T3482 Congelación con necrosis de tejidos de pie"
    },
    {
      "code" : "T34821S",
      "display" : "T34821S Congelación con necrosis de tejidos del pie derecho secuela"
    },
    {
      "code" : "T387X2",
      "display" : "T387X2 Envenenamiento por andrógenos y anabolizantes análogos autolesión intencionada"
    },
    {
      "code" : "T387X3A",
      "display" : "T387X3A Envenenamiento por andrógenos y anabolizantes análogos agresión contacto inicial"
    },
    {
      "code" : "T387X4S",
      "display" : "T387X4S Envenenamiento por andrógenos y anabolizantes análogos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T387X6",
      "display" : "T387X6 Infradosificación de andrógenos y anabolizantes relacionados"
    },
    {
      "code" : "T24199S",
      "display" : "T24199S Quemadura de primer grado de localizaciones múltiples de extremidad inferior no especificada excepto tobillo y pie secuela"
    },
    {
      "code" : "T24202",
      "display" : "T24202 Quemadura de segundo grado de localización no especificada de extremidad inferior izquierda excepto tobillo y pie"
    },
    {
      "code" : "T24209D",
      "display" : "T24209D Quemadura de segundo grado de localización no especificada de extremidad inferior no especificada excepto tobillo y pie contacto sucesivo"
    },
    {
      "code" : "T25711",
      "display" : "T25711 Corrosión de tercer grado de tobillo derecho"
    },
    {
      "code" : "T25712",
      "display" : "T25712 Corrosión de tercer grado de tobillo izquierdo"
    },
    {
      "code" : "T25719",
      "display" : "T25719 Corrosión de tercer grado de tobillo no especificado"
    },
    {
      "code" : "T2572",
      "display" : "T2572 Corrosión de tercer grado de pie"
    },
    {
      "code" : "T25721S",
      "display" : "T25721S Corrosión de tercer grado del pie derecho secuela"
    },
    {
      "code" : "T25722S",
      "display" : "T25722S Corrosión de tercer grado del pie izquierdo secuela"
    },
    {
      "code" : "T25729S",
      "display" : "T25729S Corrosión de tercer grado de pie no especificado secuela"
    },
    {
      "code" : "T25731S",
      "display" : "T25731S Corrosión de tercer grado de dedo(s) del pie derecho (uña) secuela"
    },
    {
      "code" : "T3499X",
      "display" : "T3499X Congelación con necrosis de tejidos de otras localizaciones"
    },
    {
      "code" : "T360",
      "display" : "T360 Envenenamiento efecto adverso e infradosificación de penicilinas"
    },
    {
      "code" : "T360X1D",
      "display" : "T360X1D Envenenamiento por penicilinas accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T360X2S",
      "display" : "T360X2S Envenenamiento por penicilinas autolesión intencionada secuela"
    },
    {
      "code" : "T360X4",
      "display" : "T360X4 Envenenamiento por penicilinas intencionalidad sin determinar"
    },
    {
      "code" : "T360X5A",
      "display" : "T360X5A Efecto adverso de penicilinas contacto inicial"
    },
    {
      "code" : "T38806A",
      "display" : "T38806A Infradosificación de hormonas y sustitutos sintéticos no especificados contacto inicial"
    },
    {
      "code" : "T38811A",
      "display" : "T38811A Envenenamiento por hormonas de hipófisis anterior [adenohipometafisarias] accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T38812S",
      "display" : "T38812S Envenenamiento por hormonas de hipófisis anterior [adenohipometafisarias] autolesión intencionada secuela"
    },
    {
      "code" : "T38814A",
      "display" : "T38814A Envenenamiento por hormonas de hipófisis anterior [adenohipometafisarias] intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T24231S",
      "display" : "T24231S Quemadura de segundo grado de parte inferior de la pierna derecha secuela"
    },
    {
      "code" : "T24239",
      "display" : "T24239 Quemadura de segundo grado de parte inferior de pierna no especificada"
    },
    {
      "code" : "T24291",
      "display" : "T24291 Quemadura de segundo grado de localizaciones múltiples de extremidad inferior derecha excepto tobillo y pie"
    },
    {
      "code" : "T24292D",
      "display" : "T24292D Quemadura de segundo grado de localizaciones múltiples de extremidad inferior izquierda excepto tobillo y pie contacto sucesivo"
    },
    {
      "code" : "T2600X",
      "display" : "T2600X Quemadura de párpado y área periocular no especificados"
    },
    {
      "code" : "T2601X",
      "display" : "T2601X Quemadura de párpado y área periocular derechos"
    },
    {
      "code" : "T2602",
      "display" : "T2602 Quemadura de párpado y área periocular izquierdos"
    },
    {
      "code" : "T2602XS",
      "display" : "T2602XS Quemadura de párpado y área periocular izquierdos secuela"
    },
    {
      "code" : "T2610XD",
      "display" : "T2610XD Quemadura de córnea y saco conjuntival ojo no especificado contacto sucesivo"
    },
    {
      "code" : "T2611XD",
      "display" : "T2611XD Quemadura de córnea y saco conjuntival del ojo derecho contacto sucesivo"
    },
    {
      "code" : "T361X5S",
      "display" : "T361X5S Efecto adverso de cefalosporinas y otros antibióticos beta-lactámicos secuela"
    },
    {
      "code" : "T362",
      "display" : "T362 Envenenamiento efecto adverso e infradosificación de grupo del cloranfenicol"
    },
    {
      "code" : "T362X1S",
      "display" : "T362X1S Envenenamiento por grupo del cloranfenicol accidental (no intencionado) secuela"
    },
    {
      "code" : "T360X5D",
      "display" : "T360X5D Efecto adverso de penicilinas contacto sucesivo"
    },
    {
      "code" : "T362X4",
      "display" : "T362X4 Envenenamiento por grupo del cloranfenicol intencionalidad sin determinar"
    },
    {
      "code" : "T38895",
      "display" : "T38895 Efecto adverso de otras hormonas y sustitutivos sintéticos"
    },
    {
      "code" : "T38896",
      "display" : "T38896 Infradosificación de otras hormonas y sustitutivos sintéticos"
    },
    {
      "code" : "T3890",
      "display" : "T3890 Envenenamiento efecto adverso e infradosificación por antagonistas hormonales no especificados"
    },
    {
      "code" : "T38902",
      "display" : "T38902 Envenenamiento por antagonistas hormonales no especificados autolesión intencionada"
    },
    {
      "code" : "T24319A",
      "display" : "T24319A Quemadura de tercer grado de muslo no especificado contacto inicial"
    },
    {
      "code" : "T24321A",
      "display" : "T24321A Quemadura de tercer grado de rodilla derecha contacto inicial"
    },
    {
      "code" : "T24322A",
      "display" : "T24322A Quemadura de tercer grado de rodilla izquierda contacto inicial"
    },
    {
      "code" : "T24299D",
      "display" : "T24299D Quemadura de segundo grado de localizaciones múltiples de extremidad inferior no especificada excepto tobillo y pie contacto sucesivo"
    },
    {
      "code" : "T24331S",
      "display" : "T24331S Quemadura de tercer grado de parte inferior de la pierna derecha secuela"
    },
    {
      "code" : "T2631",
      "display" : "T2631 Quemaduras de otras partes especificadas del ojo y anexos oculares derechos"
    },
    {
      "code" : "T2632",
      "display" : "T2632 Quemaduras de otras partes especificadas del ojo y anexos oculares izquierdos"
    },
    {
      "code" : "T264",
      "display" : "T264 Quemadura del ojo y sus anexos parte no especificada"
    },
    {
      "code" : "T2640XD",
      "display" : "T2640XD Quemadura del ojo y sus anexos no especificados parte no especificada contacto sucesivo"
    },
    {
      "code" : "T2641XS",
      "display" : "T2641XS Quemadura del ojo derecho y sus anexos parte no especificada secuela"
    },
    {
      "code" : "T2642XS",
      "display" : "T2642XS Quemadura del ojo izquierdo y sus anexos parte no especificada secuela"
    },
    {
      "code" : "T363X4",
      "display" : "T363X4 Envenenamiento por macrólidos intencionalidad sin determinar"
    },
    {
      "code" : "T363X5A",
      "display" : "T363X5A Efecto adverso de macrólidos contacto inicial"
    },
    {
      "code" : "T363X6A",
      "display" : "T363X6A Infradosificación de macrólidos contacto inicial"
    },
    {
      "code" : "T364X",
      "display" : "T364X Envenenamiento efecto adverso e infradosificación de tetraciclinas"
    },
    {
      "code" : "T364X1S",
      "display" : "T364X1S Envenenamiento por tetraciclinas accidental (no intencionado) secuela"
    },
    {
      "code" : "T364X3",
      "display" : "T364X3 Envenenamiento por tetraciclinas agresión"
    },
    {
      "code" : "T364X4",
      "display" : "T364X4 Envenenamiento por tetraciclinas intencionalidad sin determinar"
    },
    {
      "code" : "T364X5",
      "display" : "T364X5 Efecto adverso de tetraciclinas"
    },
    {
      "code" : "T38993",
      "display" : "T38993 Envenenamiento por otros antagonistas hormonales agresión"
    },
    {
      "code" : "T38994",
      "display" : "T38994 Envenenamiento por otros antagonistas hormonales intencionalidad sin determinar"
    },
    {
      "code" : "T38995D",
      "display" : "T38995D Efecto adverso de otros antagonistas hormonales contacto sucesivo"
    },
    {
      "code" : "T38996D",
      "display" : "T38996D Infradosificación de otros antagonistas hormonales contacto sucesivo"
    },
    {
      "code" : "T39011",
      "display" : "T39011 Envenenamiento por aspirina accidental (no intencionado)"
    },
    {
      "code" : "T39012A",
      "display" : "T39012A Envenenamiento por aspirina autolesión intencionada contacto inicial"
    },
    {
      "code" : "T24402D",
      "display" : "T24402D Corrosión de grado no especificado de localización no especificado de extremidad inferior izquierda excepto tobillo y pie contacto sucesivo"
    },
    {
      "code" : "T24411",
      "display" : "T24411 Corrosión de grado no especificado de muslo derecho"
    },
    {
      "code" : "T24412A",
      "display" : "T24412A Corrosión de grado no especificado de muslo izquierdo contacto inicial"
    },
    {
      "code" : "T2661XS",
      "display" : "T2661XS Corrosión de córnea y saco conjuntival del ojo derecho secuela"
    },
    {
      "code" : "T2662XS",
      "display" : "T2662XS Corrosión de córnea y saco conjuntival del ojo izquierdo secuela"
    },
    {
      "code" : "T2670XA",
      "display" : "T2670XA Corrosión que da como resultado la ruptura y destrucción del globo ocular no especificado contacto inicial"
    },
    {
      "code" : "T2671XD",
      "display" : "T2671XD Corrosión que da como resultado la ruptura y destrucción del globo ocular derecho contacto sucesivo"
    },
    {
      "code" : "T2672XS",
      "display" : "T2672XS Corrosión que da como resultado la ruptura y destrucción del globo ocular izquierdo secuela"
    },
    {
      "code" : "T365X5S",
      "display" : "T365X5S Efecto adverso de aminoglucósidos secuela"
    },
    {
      "code" : "T365X6S",
      "display" : "T365X6S Infradosificación de aminoglucósidos secuela"
    },
    {
      "code" : "T364X5A",
      "display" : "T364X5A Efecto adverso de tetraciclinas contacto inicial"
    },
    {
      "code" : "T366X2",
      "display" : "T366X2 Envenenamiento por rifampicinas autolesión intencionada"
    },
    {
      "code" : "T366X3A",
      "display" : "T366X3A Envenenamiento por rifampicinas agresión contacto inicial"
    },
    {
      "code" : "T366X4A",
      "display" : "T366X4A Envenenamiento por rifampicinas intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T366X5D",
      "display" : "T366X5D Efecto adverso de rifampicinas contacto sucesivo"
    },
    {
      "code" : "T39093",
      "display" : "T39093 Envenenamiento por salicilatos agresión"
    },
    {
      "code" : "T39094",
      "display" : "T39094 Envenenamiento por salicilatos intencionalidad sin determinar"
    },
    {
      "code" : "T39095",
      "display" : "T39095 Efecto adverso de salicilatos"
    },
    {
      "code" : "T39096",
      "display" : "T39096 Infradosificación de salicilatos"
    },
    {
      "code" : "T39012D",
      "display" : "T39012D Envenenamiento por aspirina autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T391X1A",
      "display" : "T391X1A Envenenamiento por derivados de 4-aminofenol accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T391X2S",
      "display" : "T391X2S Envenenamiento por derivados de 4-aminofenol autolesión intencionada secuela"
    },
    {
      "code" : "T24439",
      "display" : "T24439 Corrosión de grado no especificada de parte inferior de pierna no especificada"
    },
    {
      "code" : "T24491",
      "display" : "T24491 Corrosión de grado no especificado de localizaciones múltiples de extremidad inferior derecha excepto tobillo y pie"
    },
    {
      "code" : "T24492D",
      "display" : "T24492D Corrosión de grado no especificado de localizaciones múltiples de extremidad inferior izquierda excepto tobillo y pie contacto sucesivo"
    },
    {
      "code" : "T2692XD",
      "display" : "T2692XD Corrosión del ojo izquierdo y sus anexos parte no especificada contacto sucesivo"
    },
    {
      "code" : "T270XX",
      "display" : "T270XX Quemadura de laringe y tráquea"
    },
    {
      "code" : "T271",
      "display" : "T271 Quemadura con afectación de laringe y tráquea con pulmón"
    },
    {
      "code" : "T271XXD",
      "display" : "T271XXD Quemadura con afectación de laringe y tráquea con pulmón contacto sucesivo"
    },
    {
      "code" : "T272XXA",
      "display" : "T272XXA Quemadura de otras partes de vías respiratorias contacto inicial"
    },
    {
      "code" : "T273XX",
      "display" : "T273XX Quemadura de vías respiratorias parte no especificada"
    },
    {
      "code" : "T367X6S",
      "display" : "T367X6S Infradosificación de antibióticos antifúngicos utilizados por vía sistémica secuela"
    },
    {
      "code" : "T368X1S",
      "display" : "T368X1S Envenenamiento por otros antibióticos sistémicos accidental (no intencionado) secuela"
    },
    {
      "code" : "T368X3",
      "display" : "T368X3 Envenenamiento por otros antibióticos sistémicos agresión"
    },
    {
      "code" : "T392X3D",
      "display" : "T392X3D Envenenamiento por derivados de pirazolonas agresión contacto sucesivo"
    },
    {
      "code" : "T392X4S",
      "display" : "T392X4S Envenenamiento por derivados de pirazolonas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T392X6",
      "display" : "T392X6 Infradosificación de derivados de pirazolonas"
    },
    {
      "code" : "T393",
      "display" : "T393 Envenenamiento efecto adverso e infradosificación por otros medicamentos anti-inflamatorios no esteroideos [AINE]"
    },
    {
      "code" : "T39312",
      "display" : "T39312 Envenenamiento por derivados de ácido propiónico autolesión intencionada"
    },
    {
      "code" : "T39313A",
      "display" : "T39313A Envenenamiento por derivados de ácido propiónico agresión contacto inicial"
    },
    {
      "code" : "T2452",
      "display" : "T2452 Corrosión de primer grado de rodilla"
    },
    {
      "code" : "T24521S",
      "display" : "T24521S Corrosión de primer grado de rodilla derecha secuela"
    },
    {
      "code" : "T24522S",
      "display" : "T24522S Corrosión de primer grado de rodilla izquierda secuela"
    },
    {
      "code" : "T2453",
      "display" : "T2453 Corrosión de primer grado de parte inferior de pierna"
    },
    {
      "code" : "T24531S",
      "display" : "T24531S Corrosión de primer grado de parte inferior de la pierna derecha secuela"
    },
    {
      "code" : "T24539",
      "display" : "T24539 Corrosión de primer grado de parte inferior de pierna no especificada"
    },
    {
      "code" : "T280XX",
      "display" : "T280XX Quemadura de boca y faringe"
    },
    {
      "code" : "T280XXS",
      "display" : "T280XXS Quemadura de boca y faringe secuela"
    },
    {
      "code" : "T273XXS",
      "display" : "T273XXS Quemadura de vías respiratorias parte no especificada secuela"
    },
    {
      "code" : "T282X",
      "display" : "T282X Quemadura de otras partes de tubo digestivo"
    },
    {
      "code" : "T282XXS",
      "display" : "T282XXS Quemadura de otras partes de tubo digestivo secuela"
    },
    {
      "code" : "T283XXA",
      "display" : "T283XXA Quemadura de órganos genitourinarios internos contacto inicial"
    },
    {
      "code" : "T2840X",
      "display" : "T2840X Quemadura de órgano interno no especificado"
    },
    {
      "code" : "T2841",
      "display" : "T2841 Quemadura de tímpano"
    },
    {
      "code" : "T28411D",
      "display" : "T28411D Quemadura de tímpano derecho contacto sucesivo"
    },
    {
      "code" : "T3693XD",
      "display" : "T3693XD Envenenamiento por antibióticos sistémicos no especificados agresión contacto sucesivo"
    },
    {
      "code" : "T3694XD",
      "display" : "T3694XD Envenenamiento por antibióticos sistémicos no especificados intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T3695XS",
      "display" : "T3695XS Efecto adverso de antibióticos por vía sistémica no especificados secuela"
    },
    {
      "code" : "T3696XS",
      "display" : "T3696XS Infradosificación de antibióticos por vía sistémica no especificados secuela"
    },
    {
      "code" : "T370X1D",
      "display" : "T370X1D Envenenamiento por sulfamidas accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T39393D",
      "display" : "T39393D Envenenamiento por otros antiinflamatorios no esteroideos [AINE] agresión contacto sucesivo"
    },
    {
      "code" : "T39395",
      "display" : "T39395 Efecto adverso de otros antiinflamatorios no esteroideos [AINE]"
    },
    {
      "code" : "T39396",
      "display" : "T39396 Infradosificación de otros antiinflamatorios no esteroideos [AINE]"
    },
    {
      "code" : "T394X",
      "display" : "T394X Envenenamiento efecto adverso e infradosificación por antirreumáticos no clasificados bajo otro concepto"
    },
    {
      "code" : "T24609",
      "display" : "T24609 Corrosión de segundo grado de localización no especificada de extremidad inferior no especificada excepto tobillo y pie"
    },
    {
      "code" : "T24611A",
      "display" : "T24611A Corrosión de segundo grado de muslo derecho contacto inicial"
    },
    {
      "code" : "T24612D",
      "display" : "T24612D Corrosión de segundo grado de muslo izquierdo contacto sucesivo"
    },
    {
      "code" : "T24619D",
      "display" : "T24619D Corrosión de segundo grado de muslo no especificado contacto sucesivo"
    },
    {
      "code" : "T287XXA",
      "display" : "T287XXA Corrosión de otras partes de tubo digestivo contacto inicial"
    },
    {
      "code" : "T288XX",
      "display" : "T288XX Corrosión de órganos genitourinarios internos"
    },
    {
      "code" : "T289",
      "display" : "T289 Corrosiones de otros órganos internos y los no especificados"
    },
    {
      "code" : "T2890XD",
      "display" : "T2890XD Corrosiones de órganos internos no especificados contacto sucesivo"
    },
    {
      "code" : "T28911D",
      "display" : "T28911D Corrosiones de tímpano derecho contacto sucesivo"
    },
    {
      "code" : "T28912D",
      "display" : "T28912D Corrosiones de tímpano izquierdo contacto sucesivo"
    },
    {
      "code" : "T28919D",
      "display" : "T28919D Corrosiones de tímpano no especificado contacto sucesivo"
    },
    {
      "code" : "T2899XD",
      "display" : "T2899XD Corrosiones de otros órganos internos contacto sucesivo"
    },
    {
      "code" : "T304",
      "display" : "T304 Corrosión de región anatómica no especificado de grado no especificado"
    },
    {
      "code" : "T371X1S",
      "display" : "T371X1S Envenenamiento por medicamentos antimicobacterianos accidental (no intencionado) secuela"
    },
    {
      "code" : "T371X3A",
      "display" : "T371X3A Envenenamiento por medicamentos antimicobacterianos agresión contacto inicial"
    },
    {
      "code" : "T371X4D",
      "display" : "T371X4D Envenenamiento por medicamentos antimicobacterianos intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T371X6",
      "display" : "T371X6 Infradosificación de medicamentos antimicobacterianos"
    },
    {
      "code" : "T372",
      "display" : "T372 Envenenamiento efecto adverso e infradosificación de antipalúdicos y fármacos que actúan sobre otros protozoos de la sangre"
    },
    {
      "code" : "T398X2D",
      "display" : "T398X2D Envenenamiento por otros analgésicos no opiáceos y antipiréticos no clasificados bajo otro concepto autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T398X4A",
      "display" : "T398X4A Envenenamiento por otros analgésicos no opiáceos y antipiréticos no clasificados bajo otro concepto intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T24691S",
      "display" : "T24691S Corrosión de segundo grado de localizaciones múltiples de extremidad inferior derecha excepto tobillo y pie secuela"
    },
    {
      "code" : "T24699A",
      "display" : "T24699A Corrosión de segundo grado de localizaciones múltiples de extremidad inferior no especificada excepto tobillo y pie contacto inicial"
    },
    {
      "code" : "T24701A",
      "display" : "T24701A Corrosión de tercer grado de localización no especificada de extremidad inferior derecha excepto tobillo y pie contacto inicial"
    },
    {
      "code" : "T3155",
      "display" : "T3155 Quemaduras con afectación de 50-59% de superficie corporal con 50-59% de quemaduras de tercer grado"
    },
    {
      "code" : "T3164",
      "display" : "T3164 Quemaduras con afectación de 60-69% de superficie corporal con 40-49% de quemaduras de tercer grado"
    },
    {
      "code" : "T3172",
      "display" : "T3172 Quemaduras con afectación de 70-79% de superficie corporal con 20-29% de quemaduras de tercer grado"
    },
    {
      "code" : "T3177",
      "display" : "T3177 Quemaduras con afectación de 70-79% de superficie corporal con 70-79% de quemaduras de tercer grado"
    },
    {
      "code" : "T373X1A",
      "display" : "T373X1A Envenenamiento por otros fármacos antiprotozoarios accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T373X2S",
      "display" : "T373X2S Envenenamiento por otros fármacos antiprotozoarios autolesión intencionada secuela"
    },
    {
      "code" : "T373X4",
      "display" : "T373X4 Envenenamiento por otros fármacos antiprotozoarios intencionalidad sin determinar"
    },
    {
      "code" : "T373X5A",
      "display" : "T373X5A Efecto adverso de otros fármacos antiprotozoarios contacto inicial"
    },
    {
      "code" : "T3994XS",
      "display" : "T3994XS Envenenamiento por analgésicos no opiáceos antipiréticos y antirreumáticos no especificados intencionalidad sin determinar secuela"
    },
    {
      "code" : "T3996X",
      "display" : "T3996X Infradosificación de analgésico no opiáceo antipirético y antirreumático no especificados"
    },
    {
      "code" : "T400",
      "display" : "T400 Envenenamiento efecto adverso e infradosificación por opiáceos"
    },
    {
      "code" : "T24721S",
      "display" : "T24721S Corrosión de tercer grado de rodilla derecha secuela"
    },
    {
      "code" : "T24722S",
      "display" : "T24722S Corrosión de tercer grado de rodilla izquierda secuela"
    },
    {
      "code" : "T24729S",
      "display" : "T24729S Corrosión de tercer grado de rodilla no especificada secuela"
    },
    {
      "code" : "T24731S",
      "display" : "T24731S Corrosión de tercer grado de parte inferior de la pierna derecha secuela"
    },
    {
      "code" : "T24739",
      "display" : "T24739 Corrosión de tercer grado de parte inferior de pierna no especificada"
    },
    {
      "code" : "T24791",
      "display" : "T24791 Corrosión de tercer grado de localizaciones múltiples de extremidad inferior derecha excepto tobillo y pie"
    },
    {
      "code" : "T3222",
      "display" : "T3222 Corrosiones con afectación de 20-29% de superficie corporal con 20-29% de corrosión de tercer grado"
    },
    {
      "code" : "T3233",
      "display" : "T3233 Corrosiones con afectación de 30-39% de superficie corporal con 30-39% de corrosión de tercer grado"
    },
    {
      "code" : "T3244",
      "display" : "T3244 Corrosiones con afectación de 40-49% de superficie corporal con 40-49% de corrosión de tercer grado"
    },
    {
      "code" : "T3254",
      "display" : "T3254 Corrosiones con afectación de 50-59% de superficie corporal con 40-49% de corrosión de tercer grado"
    },
    {
      "code" : "T374X5S",
      "display" : "T374X5S Efecto adverso de antihelmínticos secuela"
    },
    {
      "code" : "T374X6S",
      "display" : "T374X6S Infradosificación de antihelmínticos secuela"
    },
    {
      "code" : "T375X1A",
      "display" : "T375X1A Envenenamiento por fármacos antivirales accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T375X2S",
      "display" : "T375X2S Envenenamiento por fármacos antivirales autolesión intencionada secuela"
    },
    {
      "code" : "T375X4",
      "display" : "T375X4 Envenenamiento por fármacos antivirales intencionalidad sin determinar"
    },
    {
      "code" : "T375X5A",
      "display" : "T375X5A Efecto adverso de medicamentos antivirales contacto inicial"
    },
    {
      "code" : "T401X",
      "display" : "T401X Envenenamiento por y efecto adverso de heroína"
    },
    {
      "code" : "T401X2",
      "display" : "T401X2 Envenenamiento por heroína autolesión intencionada"
    },
    {
      "code" : "T401X3",
      "display" : "T401X3 Envenenamiento por heroína agresión"
    },
    {
      "code" : "T401X4",
      "display" : "T401X4 Envenenamiento por heroína intencionalidad sin determinar"
    },
    {
      "code" : "T402",
      "display" : "T402 Envenenamiento efecto adverso e infradosificación por otros opiáceos"
    },
    {
      "code" : "T402X1S",
      "display" : "T402X1S Envenenamiento por otros opiáceos accidental (no intencionado) secuela"
    },
    {
      "code" : "T402X3",
      "display" : "T402X3 Envenenamiento por otros opiáceos agresión"
    },
    {
      "code" : "T25021",
      "display" : "T25021 Quemadura de grado no especificado del pie derecho"
    },
    {
      "code" : "T25022",
      "display" : "T25022 Quemadura de grado no especificado del pie izquierdo"
    },
    {
      "code" : "T25029",
      "display" : "T25029 Quemadura de grado no especificado de pie no especificado"
    },
    {
      "code" : "T25031",
      "display" : "T25031 Quemadura de grado no especificado de dedo(s) del pie derecho (uña)"
    },
    {
      "code" : "T25032",
      "display" : "T25032 Quemadura de grado no especificado de dedo(s) del pie izquierdo (uña)"
    },
    {
      "code" : "T25039A",
      "display" : "T25039A Quemadura de grado no especificados de dedo(s) (uñas) de pie no especificados contacto inicial"
    },
    {
      "code" : "T3285",
      "display" : "T3285 Corrosiones con afectación de 80-89% de superficie corporal con 50-59% de corrosión de tercer grado"
    },
    {
      "code" : "T3291",
      "display" : "T3291 Corrosiones con afectación de 90% o más de superficie corporal con 10-19% de corrosión de tercer grado"
    },
    {
      "code" : "T3297",
      "display" : "T3297 Corrosiones con afectación de 90% o más de superficie corporal con 70-79% de corrosión de tercer grado"
    },
    {
      "code" : "T33011",
      "display" : "T33011 Congelación superficial del oído derecho"
    },
    {
      "code" : "T33012",
      "display" : "T33012 Congelación superficial del oído izquierdo"
    },
    {
      "code" : "T378X5S",
      "display" : "T378X5S Efecto adverso de otros anti-infecciosos y antiparasitarios sistémicos especificados secuela"
    },
    {
      "code" : "T379",
      "display" : "T379 Envenenamiento efecto adverso e infradosificación por antiinfecciosos y antiparasitarios sistémicos no especificados"
    },
    {
      "code" : "T3792",
      "display" : "T3792 Envenenamiento por anti-infecciosos y antiparasitarios sistémicos no especificados autolesión intencionada"
    },
    {
      "code" : "T403X4D",
      "display" : "T403X4D Envenenamiento por metadona intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T403X5S",
      "display" : "T403X5S Efecto adverso de metadona secuela"
    },
    {
      "code" : "T403X6S",
      "display" : "T403X6S Infradosificación de metadona secuela"
    },
    {
      "code" : "T40411A",
      "display" : "T40411A Envenenamiento por fentanilo o análogos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T40412D",
      "display" : "T40412D Envenenamiento por fentanilo o análogos autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T40413S",
      "display" : "T40413S Envenenamiento por fentanilo o análogos agresión secuela"
    },
    {
      "code" : "T25119",
      "display" : "T25119 Quemadura de primer grado de tobillo no especificado"
    },
    {
      "code" : "T25121",
      "display" : "T25121 Quemadura de primer grado del pie derecho"
    },
    {
      "code" : "T25122",
      "display" : "T25122 Quemadura de primer grado del pie izquierdo"
    },
    {
      "code" : "T25129",
      "display" : "T25129 Quemadura de primer grado de pie no especificado"
    },
    {
      "code" : "T2513",
      "display" : "T2513 Quemadura de primer grado de dedo(s) de pie (uña)"
    },
    {
      "code" : "T25131S",
      "display" : "T25131S Quemadura de primer grado de dedo(s) del pie derecho (uña) secuela"
    },
    {
      "code" : "T25139",
      "display" : "T25139 Quemadura de primer grado de dedo(s) (uñas) de pie no especificados"
    },
    {
      "code" : "T332XXA",
      "display" : "T332XXA Congelación superficial del tórax contacto inicial"
    },
    {
      "code" : "T333X",
      "display" : "T333X Congelación superficial de pared abdominal parte inferior de espalda y pelvis"
    },
    {
      "code" : "T334",
      "display" : "T334 Congelación superficial del brazo"
    },
    {
      "code" : "T3340XD",
      "display" : "T3340XD Congelación superficial de brazo no especificado contacto sucesivo"
    },
    {
      "code" : "T3341XD",
      "display" : "T3341XD Congelación superficial del brazo derecho contacto sucesivo"
    },
    {
      "code" : "T3342XA",
      "display" : "T3342XA Congelación superficial del brazo izquierdo contacto inicial"
    },
    {
      "code" : "T33511",
      "display" : "T33511 Congelación superficial de muñeca derecha"
    },
    {
      "code" : "T33512",
      "display" : "T33512 Congelación superficial de muñeca izquierda"
    },
    {
      "code" : "T45511S",
      "display" : "T45511S Envenenamiento por anticoagulantes accidental (no intencionado) secuela"
    },
    {
      "code" : "T45512S",
      "display" : "T45512S Envenenamiento por anticoagulantes autolesión intencionada secuela"
    },
    {
      "code" : "T45514",
      "display" : "T45514 Envenenamiento por anticoagulantes intencionalidad sin determinar"
    },
    {
      "code" : "T45515A",
      "display" : "T45515A Efecto adverso de anticoagulantes contacto inicial"
    },
    {
      "code" : "T45516A",
      "display" : "T45516A Infradosificación de anticoagulantes contacto inicial"
    },
    {
      "code" : "T45521A",
      "display" : "T45521A Envenenamiento por fármacos antitrombóticos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T474X2S",
      "display" : "T474X2S Envenenamiento por otros laxantes autolesión intencionada secuela"
    },
    {
      "code" : "T474X4",
      "display" : "T474X4 Envenenamiento por otros laxantes intencionalidad sin determinar"
    },
    {
      "code" : "T474X5A",
      "display" : "T474X5A Efecto adverso de otros laxantes contacto inicial"
    },
    {
      "code" : "T474X6A",
      "display" : "T474X6A Infradosificación de otros laxantes contacto inicial"
    },
    {
      "code" : "T475X",
      "display" : "T475X Envenenamiento efecto adverso e infradosificación por agentes digestivos"
    },
    {
      "code" : "T475X2",
      "display" : "T475X2 Envenenamiento por digestivos autolesión intencionada"
    },
    {
      "code" : "T475X3",
      "display" : "T475X3 Envenenamiento por digestivos agresión"
    },
    {
      "code" : "T505X5",
      "display" : "T505X5 Efecto adverso de depresores del apetito"
    },
    {
      "code" : "T505X6",
      "display" : "T505X6 Infradosificación de depresores del apetito"
    },
    {
      "code" : "T506",
      "display" : "T506 Envenenamiento efecto adverso e infradosificación por antídotos y agentes quelantes"
    },
    {
      "code" : "T506X1S",
      "display" : "T506X1S Envenenamiento por antídotos y agentes quelantes accidental (no intencionado) secuela"
    },
    {
      "code" : "T506X3",
      "display" : "T506X3 Envenenamiento por antídotos y agentes quelantes agresión"
    },
    {
      "code" : "T433X1A",
      "display" : "T433X1A Envenenamiento por antipsicóticos y neurolépticos a base de fenotiazinas accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T433X2S",
      "display" : "T433X2S Envenenamiento por antipsicóticos y neurolépticos a base de fenotiazinas autolesión intencionada secuela"
    },
    {
      "code" : "T433X4A",
      "display" : "T433X4A Envenenamiento por antipsicóticos y neurolépticos a base de fenotiazinas intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T433X5S",
      "display" : "T433X5S Efecto adverso de antipsicóticos y neurolépticos a base de fenotiacinas secuela"
    },
    {
      "code" : "T476X3",
      "display" : "T476X3 Envenenamiento por fármacos antidiarreicos agresión"
    },
    {
      "code" : "T476X4",
      "display" : "T476X4 Envenenamiento por fármacos antidiarreicos intencionalidad sin determinar"
    },
    {
      "code" : "T476X5A",
      "display" : "T476X5A Efecto adverso de fármacos antidiarreicos contacto inicial"
    },
    {
      "code" : "T476X6D",
      "display" : "T476X6D Infradosificación de fármacos antidiarreicos contacto sucesivo"
    },
    {
      "code" : "T477X1",
      "display" : "T477X1 Envenenamiento por eméticos accidental (no intencionado)"
    },
    {
      "code" : "T477X2A",
      "display" : "T477X2A Envenenamiento por eméticos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T477X3D",
      "display" : "T477X3D Envenenamiento por eméticos agresión contacto sucesivo"
    },
    {
      "code" : "T48",
      "display" : "T48 Envenenamiento efecto adverso e infradosificación por agentes que actúan principalmente sobre los músculos liso y estriado y el aparato respiratorio"
    },
    {
      "code" : "T480X2",
      "display" : "T480X2 Envenenamiento por oxitócicos autolesión intencionada"
    },
    {
      "code" : "T480X3",
      "display" : "T480X3 Envenenamiento por oxitócicos agresión"
    },
    {
      "code" : "T480X4",
      "display" : "T480X4 Envenenamiento por oxitócicos intencionalidad sin determinar"
    },
    {
      "code" : "T480X5",
      "display" : "T480X5 Efecto adverso de oxitócicos"
    },
    {
      "code" : "T507X3S",
      "display" : "T507X3S Envenenamiento por analépticos y antagonistas de receptores de opiáceos agresión secuela"
    },
    {
      "code" : "T507X5",
      "display" : "T507X5 Efecto adverso de analépticos y antagonistas de receptores de opiáceos"
    },
    {
      "code" : "T507X6A",
      "display" : "T507X6A Infradosificación de analépticos y antagonistas de receptores de opiáceos contacto inicial"
    },
    {
      "code" : "T508X1",
      "display" : "T508X1 Envenenamiento por agentes de diagnóstico accidental (no intencionado)"
    },
    {
      "code" : "T434X6S",
      "display" : "T434X6S Infradosificación de neurolépticos a base de butirofenonas y tiotixeno secuela"
    },
    {
      "code" : "T43501D",
      "display" : "T43501D Envenenamiento por antipsicóticos y neurolépticos no especificados accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T43503A",
      "display" : "T43503A Envenenamiento por antipsicóticos y neurolépticos no especificados agresión contacto inicial"
    },
    {
      "code" : "T478X4",
      "display" : "T478X4 Envenenamiento por otros agentes que afectan principalmente al aparato digestivo intencionalidad sin determinar"
    },
    {
      "code" : "T478X5D",
      "display" : "T478X5D Efecto adverso de otros agentes que afectan principalmente al aparato digestivo contacto sucesivo"
    },
    {
      "code" : "T479",
      "display" : "T479 Envenenamiento efecto adverso e infradosificación por agentes no especificados que afectan principalmente al aparato digestivo"
    },
    {
      "code" : "T481X5A",
      "display" : "T481X5A Efecto adverso de relajantes del músculo esquelético [agentes bloqueantes neuromusculares] contacto inicial"
    },
    {
      "code" : "T481X6S",
      "display" : "T481X6S Infradosificación de relajantes del músculo esquelético [agentes bloqueantes neuromusculares] secuela"
    },
    {
      "code" : "T48201S",
      "display" : "T48201S Envenenamiento por fármacos no especificados que actúan sobre los músculos accidental (no intencionado) secuela"
    },
    {
      "code" : "T408X1",
      "display" : "T408X1 Envenenamiento por lisergida [LSD] accidental (no intencionado)"
    },
    {
      "code" : "T408X2A",
      "display" : "T408X2A Envenenamiento por lisergida [LSD] autolesión intencionada contacto inicial"
    },
    {
      "code" : "T408X3D",
      "display" : "T408X3D Envenenamiento por lisergida [LSD] agresión contacto sucesivo"
    },
    {
      "code" : "T408X4S",
      "display" : "T408X4S Envenenamiento por lisergida [LSD] intencionalidad sin determinar secuela"
    },
    {
      "code" : "T40901D",
      "display" : "T40901D Envenenamiento por psicodislépticos [alucinógenos] no especificados accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T43595",
      "display" : "T43595 Efecto adverso de otros antipsicóticos y neurolépticos"
    },
    {
      "code" : "T43596",
      "display" : "T43596 Infradosificación de otros antipsicóticos y neurolépticos"
    },
    {
      "code" : "T4360",
      "display" : "T4360 Envenenamiento efecto adverso e infradosificación por psicoestimulante no especificados"
    },
    {
      "code" : "T43602",
      "display" : "T43602 Envenenamiento por psicoestimulantes no especificados autolesión intencionada"
    },
    {
      "code" : "T45602",
      "display" : "T45602 Envenenamiento por fármacos no especificados que afectan a la fibrinolisis autolesión intencionada"
    },
    {
      "code" : "T45603D",
      "display" : "T45603D Envenenamiento por fármacos no especificados que afectan a la fibrinolisis agresión contacto sucesivo"
    },
    {
      "code" : "T45604S",
      "display" : "T45604S Envenenamiento por fármacos no especificados que afectan a la fibrinolisis intencionalidad sin determinar secuela"
    },
    {
      "code" : "T45606D",
      "display" : "T45606D Infradosificación de fármacos que afectan a la fibrinolisis no especificados contacto sucesivo"
    },
    {
      "code" : "T48292D",
      "display" : "T48292D Envenenamiento por otros fármacos que actúan sobre los músculos autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T48294",
      "display" : "T48294 Envenenamiento por otros fármacos que actúan sobre los músculos intencionalidad sin determinar"
    },
    {
      "code" : "T48295A",
      "display" : "T48295A Efecto adverso de otros fármacos que actúan sobre los músculos contacto inicial"
    },
    {
      "code" : "T48296S",
      "display" : "T48296S Infradosificación de otros fármacos que actúan sobre los músculos secuela"
    },
    {
      "code" : "T40993S",
      "display" : "T40993S Envenenamiento por otros psicodislépticos [alucinógenos] agresión secuela"
    },
    {
      "code" : "T40995",
      "display" : "T40995 Efecto adverso de otros psicodislépticos [alucinógenos]"
    },
    {
      "code" : "T40996",
      "display" : "T40996 Infradosificación de otros psicodislépticos [alucinógenos]"
    },
    {
      "code" : "T410",
      "display" : "T410 Envenenamiento efecto adverso e infradosificación por anestésicos inhalados"
    },
    {
      "code" : "T43613A",
      "display" : "T43613A Envenenamiento por cafeína agresión contacto inicial"
    },
    {
      "code" : "T43614A",
      "display" : "T43614A Envenenamiento por cafeína intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T43615D",
      "display" : "T43615D Efecto adverso de cafeína contacto sucesivo"
    },
    {
      "code" : "T43616D",
      "display" : "T43616D Infradosificación de cafeína contacto sucesivo"
    },
    {
      "code" : "T43621D",
      "display" : "T43621D Envenenamiento por anfetaminas accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T43622S",
      "display" : "T43622S Envenenamiento por anfetaminas autolesión intencionada secuela"
    },
    {
      "code" : "T43623S",
      "display" : "T43623S Envenenamiento por anfetaminas agresión secuela"
    },
    {
      "code" : "T4562",
      "display" : "T4562 Envenenamiento efecto adverso e infradosificación por fármacos hemostáticos"
    },
    {
      "code" : "T45622",
      "display" : "T45622 Envenenamiento por fármacos hemostáticos autolesión intencionada"
    },
    {
      "code" : "T45623A",
      "display" : "T45623A Envenenamiento por fármacos hemostáticos agresión contacto inicial"
    },
    {
      "code" : "T45624D",
      "display" : "T45624D Envenenamiento por fármacos hemostáticos intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T45625S",
      "display" : "T45625S Efecto adverso de fármacos hemostáticos secuela"
    },
    {
      "code" : "T45626S",
      "display" : "T45626S Infradosificación de fármacos hemostáticos secuela"
    },
    {
      "code" : "T484",
      "display" : "T484 Envenenamiento efecto adverso e infradosificación por expectorantes"
    },
    {
      "code" : "T484X1S",
      "display" : "T484X1S Envenenamiento por expectorantes accidental (no intencionado) secuela"
    },
    {
      "code" : "T484X3",
      "display" : "T484X3 Envenenamiento por expectorantes agresión"
    },
    {
      "code" : "T484X4",
      "display" : "T484X4 Envenenamiento por expectorantes intencionalidad sin determinar"
    },
    {
      "code" : "T484X5",
      "display" : "T484X5 Efecto adverso de expectorantes"
    },
    {
      "code" : "T484X6",
      "display" : "T484X6 Infradosificación de expectorantes"
    },
    {
      "code" : "T485",
      "display" : "T485 Envenenamiento efecto adverso e infradosificación por otros medicamentos contra el resfriado común"
    },
    {
      "code" : "T411X2A",
      "display" : "T411X2A Envenenamiento por anestésicos intravenosos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T411X3S",
      "display" : "T411X3S Envenenamiento por anestésicos intravenosos agresión secuela"
    },
    {
      "code" : "T411X4S",
      "display" : "T411X4S Envenenamiento por anestésicos intravenosos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T411X6",
      "display" : "T411X6 Infradosificación de anestésicos intravenosos"
    },
    {
      "code" : "T412",
      "display" : "T412 Envenenamiento efecto adverso e infradosificación por otros anestésicos generales y los no especificadas"
    },
    {
      "code" : "T43634",
      "display" : "T43634 Envenenamiento por metilfenidato intencionalidad sin determinar"
    },
    {
      "code" : "T43635A",
      "display" : "T43635A Efecto adverso de metilfenidato contacto inicial"
    },
    {
      "code" : "T43636A",
      "display" : "T43636A Infradosificación de metilfenidato contacto inicial"
    },
    {
      "code" : "T43641",
      "display" : "T43641 Envenenamiento por éxtasis accidental (no intencionado)"
    },
    {
      "code" : "T43642A",
      "display" : "T43642A Envenenamiento por éxtasis autolesión intencionada contacto incial"
    },
    {
      "code" : "T43643A",
      "display" : "T43643A Envenenamiento por éxtasis agresión contacto inicial"
    },
    {
      "code" : "T43644D",
      "display" : "T43644D Envenenamiento por éxtasis intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T43651D",
      "display" : "T43651D Envenenamiento por metanfetaminas accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T457X1",
      "display" : "T457X1 Envenenamiento por antagonistas de anticoagulantes vitamina K y otros coagulantes accidental (no intencionado)"
    },
    {
      "code" : "T457X2D",
      "display" : "T457X2D Envenenamiento por antagonistas de anticoagulantes vitamina K y otros coagulantes autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T457X4A",
      "display" : "T457X4A Envenenamiento por antagonistas de anticoagulantes vitamina K y otros coagulantes intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T486X1D",
      "display" : "T486X1D Envenenamiento por antiasmáticos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T486X2S",
      "display" : "T486X2S Envenenamiento por antiasmáticos autolesión intencionada secuela"
    },
    {
      "code" : "T486X4",
      "display" : "T486X4 Envenenamiento por antiasmáticos intencionalidad sin determinar"
    },
    {
      "code" : "T485X1D",
      "display" : "T485X1D Envenenamiento por otros fármacos contra el resfriado común accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T486X6A",
      "display" : "T486X6A Infradosificación de antiasmáticos contacto inicial"
    },
    {
      "code" : "T41291",
      "display" : "T41291 Envenenamiento por otros anestésicos generales accidental (no intencionado)"
    },
    {
      "code" : "T41292A",
      "display" : "T41292A Envenenamiento por otros anestésicos generales autolesión intencionada contacto inicial"
    },
    {
      "code" : "T41293S",
      "display" : "T41293S Envenenamiento por otros anestésicos generales agresión secuela"
    },
    {
      "code" : "T41294S",
      "display" : "T41294S Envenenamiento por otros anestésicos generales intencionalidad sin determinar secuela"
    },
    {
      "code" : "T41296A",
      "display" : "T41296A Infradosificación de otros anestésicos generales contacto inicial"
    },
    {
      "code" : "T43692D",
      "display" : "T43692D Envenenamiento por otros psicoestimulantes autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T43693S",
      "display" : "T43693S Envenenamiento por otros psicoestimulantes agresión secuela"
    },
    {
      "code" : "T43695",
      "display" : "T43695 Efecto adverso de otros psicoestimulantes"
    },
    {
      "code" : "T43695S",
      "display" : "T43695S Efecto adverso de otros psicoestimulantes secuela"
    },
    {
      "code" : "T43696S",
      "display" : "T43696S Infradosificación de otros psicoestimulantes secuela"
    },
    {
      "code" : "S42112G",
      "display" : "S42112G Fractura desplazada de cuerpo de escápula del hombro izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42113B",
      "display" : "S42113B Fractura desplazada de cuerpo de escápula de hombro no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S32455D",
      "display" : "S32455D Fractura transversa sin desplazamiento de acetábulo izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32456B",
      "display" : "S32456B Fractura transversa sin desplazamiento de acetábulo no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S32461",
      "display" : "S32461 Fractura combinada transversa-posterior desplazada de acetábulo derecho"
    },
    {
      "code" : "S37529S",
      "display" : "S37529S Contusión de trompa de Falopio no especificada secuela"
    },
    {
      "code" : "S37531D",
      "display" : "S37531D Desgarro de trompa de Falopio unilateral contacto sucesivo"
    },
    {
      "code" : "S37532D",
      "display" : "S37532D Desgarro de trompa de Falopio bilateral contacto sucesivo"
    },
    {
      "code" : "S37539D",
      "display" : "S37539D Desgarro de trompa de Falopio no especificada contacto sucesivo"
    },
    {
      "code" : "S37591D",
      "display" : "S37591D Otro traumatismo de trompa de Falopio unilateral contacto sucesivo"
    },
    {
      "code" : "S37592S",
      "display" : "S37592S Otro traumatismo de trompas de Falopio bilateral secuela"
    },
    {
      "code" : "S37599S",
      "display" : "S37599S Otro traumatismo de trompa de Falopio no especificado secuela"
    },
    {
      "code" : "S3799XS",
      "display" : "S3799XS Otro traumatismo de órgano urinario y pélvico no especificado secuela"
    },
    {
      "code" : "S38001A",
      "display" : "S38001A Lesión por aplastamiento de órganos genitales externos masculinos no especificados contacto inicial"
    },
    {
      "code" : "S38002S",
      "display" : "S38002S Lesión por aplastamiento de órganos genitales externos femeninos no especificados secuela"
    },
    {
      "code" : "S3802",
      "display" : "S3802 Lesión por aplastamiento de escroto y testículos"
    },
    {
      "code" : "S3802XS",
      "display" : "S3802XS Lesión por aplastamiento de escroto y testículos secuela"
    },
    {
      "code" : "S3803XD",
      "display" : "S3803XD Lesión por aplastamiento de vulva contacto sucesivo"
    },
    {
      "code" : "S31835",
      "display" : "S31835 Mordedura abierta de ano"
    },
    {
      "code" : "S31835S",
      "display" : "S31835S Mordedura abierta de ano secuela"
    },
    {
      "code" : "S31839S",
      "display" : "S31839S Herida abierta no especificada de ano secuela"
    },
    {
      "code" : "S32000",
      "display" : "S32000 Fractura en cuña por compresión de vértebra lumbar no especificada"
    },
    {
      "code" : "S32000K",
      "display" : "S32000K Fractura en cuña por compresión de vértebra lumbar no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32001G",
      "display" : "S32001G Fractura por estallido estable de vértebra lumbar no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32465D",
      "display" : "S32465D Fractura combinada transversa-posterior sin desplazamiento de acetábulo izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32466D",
      "display" : "S32466D Fractura combinada transversa-posterior sin desplazamiento de acetábulo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S35412D",
      "display" : "S35412D Desgarro de arteria renal izquierda contacto sucesivo"
    },
    {
      "code" : "S35413D",
      "display" : "S35413D Desgarro de arteria renal no especificada contacto sucesivo"
    },
    {
      "code" : "S35414S",
      "display" : "S35414S Desgarro de vena renal derecha secuela"
    },
    {
      "code" : "S35415S",
      "display" : "S35415S Desgarro de vena renal izquierda secuela"
    },
    {
      "code" : "S35416S",
      "display" : "S35416S Desgarro de vena renal no especificada secuela"
    },
    {
      "code" : "S35491D",
      "display" : "S35491D Otro traumatismo especificado de arteria renal derecha contacto sucesivo"
    },
    {
      "code" : "S35492S",
      "display" : "S35492S Otro traumatismo especificado de arteria renal izquierda secuela"
    },
    {
      "code" : "S38231A",
      "display" : "S38231A Amputación traumática completa de escroto y testículos contacto inicial"
    },
    {
      "code" : "S38232D",
      "display" : "S38232D Amputación traumática parcial de escroto y testículos contacto sucesivo"
    },
    {
      "code" : "S383XXA",
      "display" : "S383XXA Sección transversal (parcial) del abdomen contacto inicial"
    },
    {
      "code" : "S3900",
      "display" : "S3900 Traumatismo no especificado de músculo fascia y tendón de abdomen parte inferior de espalda y pelvis"
    },
    {
      "code" : "S39002A",
      "display" : "S39002A Traumatismo no especificado de músculo fascia y tendón de parte inferior de la espalda contacto inicial"
    },
    {
      "code" : "S32010K",
      "display" : "S32010K Fractura en cuña por compresión de primera vértebra lumbar contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32011K",
      "display" : "S32011K Fractura por estallido estable de primera vértebra lumbar contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32012G",
      "display" : "S32012G Fractura por estallido inestable de primera vértebra lumbar contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32475",
      "display" : "S32475 Fractura sin desplazamiento de pared medial de acetábulo izquierdo"
    },
    {
      "code" : "S32475G",
      "display" : "S32475G Fractura sin desplazamiento de pared medial de acetábulo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32476G",
      "display" : "S32476G Fractura sin desplazamiento de pared medial de acetábulo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S35512A",
      "display" : "S35512A Traumatismo de arteria ilíaca izquierda contacto inicial"
    },
    {
      "code" : "S35513A",
      "display" : "S35513A Traumatismo de arteria ilíaca no especificada contacto inicial"
    },
    {
      "code" : "S35514D",
      "display" : "S35514D Traumatismo de vena iliaca derecha contacto sucesivo"
    },
    {
      "code" : "S35515D",
      "display" : "S35515D Traumatismo de vena iliaca izquierda contacto sucesivo"
    },
    {
      "code" : "S35516S",
      "display" : "S35516S Traumatismo de vena iliaca no especificada secuela"
    },
    {
      "code" : "S35531D",
      "display" : "S35531D Traumatismo de arteria uterina derecha contacto sucesivo"
    },
    {
      "code" : "S35532D",
      "display" : "S35532D Traumatismo de arteria uterina izquierda contacto sucesivo"
    },
    {
      "code" : "S35533S",
      "display" : "S35533S Traumatismo de arteria uterina no especificada secuela"
    },
    {
      "code" : "S39023A",
      "display" : "S39023A Desgarro de músculo fascia y tendón de la pelvis contacto inicial"
    },
    {
      "code" : "S39003D",
      "display" : "S39003D Traumatismo no especificado de músculo fascia y tendón de la pelvis contacto sucesivo"
    },
    {
      "code" : "S39092D",
      "display" : "S39092D Otro traumatismo de músculo fascia y tendón de parte inferior de la espalda contacto sucesivo"
    },
    {
      "code" : "S39093S",
      "display" : "S39093S Otro traumatismo de músculo fascia y tendón de la pelvis secuela"
    },
    {
      "code" : "S3981XD",
      "display" : "S3981XD Otros traumatismos especificados del abdomen contacto sucesivo"
    },
    {
      "code" : "S3982XD",
      "display" : "S3982XD Otros traumatismos especificados de parte inferior de la espalda contacto sucesivo"
    },
    {
      "code" : "S32021D",
      "display" : "S32021D Fractura por estallido estable de segunda vértebra lumbar contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32022B",
      "display" : "S32022B Fractura por estallido inestable de segunda vértebra lumbar contacto inicial por fractura abierta"
    },
    {
      "code" : "S32028A",
      "display" : "S32028A Otra fractura de segunda vértebra lumbar contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32028S",
      "display" : "S32028S Otra fractura de segunda vértebra lumbar secuela"
    },
    {
      "code" : "S32484",
      "display" : "S32484 Fractura sin desplazamiento de cúpula de acetábulo derecho"
    },
    {
      "code" : "S32484K",
      "display" : "S32484K Fractura sin desplazamiento de cúpula de acetábulo derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32485G",
      "display" : "S32485G Fractura sin desplazamiento de cúpula de acetábulo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32486G",
      "display" : "S32486G Fractura sin desplazamiento de cúpula de acetábulo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S358X9S",
      "display" : "S358X9S Traumatismo no especificado de otros vasos sanguíneos a nivel de abdomen parte inferior de espalda y pelvis secuela"
    },
    {
      "code" : "S3590XS",
      "display" : "S3590XS Traumatismo no especificado de vaso sanguíneo no especificado a nivel de abdomen parte inferior de espalda y pelvis secuela"
    },
    {
      "code" : "S3599",
      "display" : "S3599 Otro traumatismo especificado de vaso sanguíneo no especificado a nivel de abdomen parte inferior de espalda y pelvis"
    },
    {
      "code" : "S35291D",
      "display" : "S35291D Desgarro leve de ramas de arterias celiaca y mesentéricas contacto sucesivo"
    },
    {
      "code" : "S35298",
      "display" : "S35298 Otro traumatismo de ramas de arterias celiaca y mesentéricas"
    },
    {
      "code" : "S35299",
      "display" : "S35299 Traumatismo no especificado de ramas de arterias celiaca y mesentéricas"
    },
    {
      "code" : "S46992D",
      "display" : "S46992D Otro traumatismo de músculo fascia y tendón no especificados a nivel del hombro y brazo lado izquierdo contacto sucesivo"
    },
    {
      "code" : "S47",
      "display" : "S47 Traumatismo por aplastamiento del hombro y brazo"
    },
    {
      "code" : "S471XXA",
      "display" : "S471XXA Lesión por aplastamiento de hombro y brazo derechos contacto inicial"
    },
    {
      "code" : "S472XX",
      "display" : "S472XX Lesión por aplastamiento de hombro y brazo izquierdos"
    },
    {
      "code" : "S42293",
      "display" : "S42293 Otro tipo de fractura desplazada de extremo superior de húmero no especificado"
    },
    {
      "code" : "S42293K",
      "display" : "S42293K Otro tipo de fractura desplazada de extremo superior de húmero no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42453A",
      "display" : "S42453A Fractura desplazada de cóndilo lateral de húmero no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42453S",
      "display" : "S42453S Fractura desplazada de cóndilo lateral de húmero no especificado secuela"
    },
    {
      "code" : "S42454G",
      "display" : "S42454G Fractura sin desplazamiento de cóndilo lateral de húmero derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S4400X",
      "display" : "S4400X Traumatismo de nervio cubital a nivel de brazo no especificado"
    },
    {
      "code" : "S4401X",
      "display" : "S4401X Traumatismo de nervio cubital a nivel de brazo lado derecho"
    },
    {
      "code" : "S4401XS",
      "display" : "S4401XS Traumatismo de nervio cubital a nivel de brazo lado derecho secuela"
    },
    {
      "code" : "S4402XS",
      "display" : "S4402XS Traumatismo de nervio cubital a nivel de brazo lado izquierdo secuela"
    },
    {
      "code" : "S4410XD",
      "display" : "S4410XD Traumatismo de nervio mediano a nivel de brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S48021",
      "display" : "S48021 Amputación traumática parcial a nivel de articulación del hombro derecho"
    },
    {
      "code" : "S48022",
      "display" : "S48022 Amputación traumática parcial a nivel de articulación del hombro izquierdo"
    },
    {
      "code" : "S48029D",
      "display" : "S48029D Amputación traumática parcial a nivel de articulación de hombro no especificado contacto sucesivo"
    },
    {
      "code" : "S48111A",
      "display" : "S48111A Amputación traumática completa a un nivel entre hombro y codo derechos contacto inicial"
    },
    {
      "code" : "S48112S",
      "display" : "S48112S Amputación traumática completa a un nivel entre hombro y codo izquierdos secuela"
    },
    {
      "code" : "S42301D",
      "display" : "S42301D Fractura no especificada de diáfisis de húmero del brazo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42302A",
      "display" : "S42302A Fractura no especificada de diáfisis de húmero del brazo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42302S",
      "display" : "S42302S Fractura no especificada de diáfisis de húmero del brazo izquierdo secuela"
    },
    {
      "code" : "S42462B",
      "display" : "S42462B Fractura desplazada de cóndilo medial de húmero izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S42463",
      "display" : "S42463 Fractura desplazada de cóndilo medial de húmero no especificado"
    },
    {
      "code" : "S42463K",
      "display" : "S42463K Fractura desplazada de cóndilo medial de húmero no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S4430XS",
      "display" : "S4430XS Traumatismo de nervio axilar brazo no especificado secuela"
    },
    {
      "code" : "S4431XD",
      "display" : "S4431XD Traumatismo de nervio axilar brazo derecho contacto sucesivo"
    },
    {
      "code" : "S4432XA",
      "display" : "S4432XA Traumatismo de nervio axilar brazo izquierdo contacto inicial"
    },
    {
      "code" : "S4440X",
      "display" : "S4440X Traumatismo de nervio musculocutáneo brazo no especificado"
    },
    {
      "code" : "S4441",
      "display" : "S4441 Traumatismo de nervio musculocutáneo brazo derecho"
    },
    {
      "code" : "S3993XD",
      "display" : "S3993XD Traumatismo no especificado de la pelvis contacto sucesivo"
    },
    {
      "code" : "S3983",
      "display" : "S3983 Otros traumatismos especificados de la pelvis"
    },
    {
      "code" : "S400",
      "display" : "S400 Contusión del hombro y brazo"
    },
    {
      "code" : "S40011A",
      "display" : "S40011A Contusión del hombro derecho contacto inicial"
    },
    {
      "code" : "S40012D",
      "display" : "S40012D Contusión del hombro izquierdo contacto sucesivo"
    },
    {
      "code" : "S40019D",
      "display" : "S40019D Contusión de hombro no especificado contacto sucesivo"
    },
    {
      "code" : "S40021A",
      "display" : "S40021A Contusión de brazo derecho contacto inicial"
    },
    {
      "code" : "S40022A",
      "display" : "S40022A Contusión de brazo izquierdo contacto inicial"
    },
    {
      "code" : "S40029A",
      "display" : "S40029A Contusión de brazo no especificado contacto inicial"
    },
    {
      "code" : "S32038B",
      "display" : "S32038B Otra fractura de tercera vértebra lumbar contacto inicial por fractura abierta"
    },
    {
      "code" : "S32039A",
      "display" : "S32039A Fractura no especificada de tercera vértebra lumbar contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32039S",
      "display" : "S32039S Fractura no especificada de tercera vértebra lumbar secuela"
    },
    {
      "code" : "S32040D",
      "display" : "S32040D Fractura en cuña por compresión de cuarta vértebra lumbar contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32501D",
      "display" : "S32501D Fractura de pubis derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32502A",
      "display" : "S32502A Fractura de pubis izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32502S",
      "display" : "S32502S Fractura de pubis izquierda secuela"
    },
    {
      "code" : "S32509D",
      "display" : "S32509D Fractura de pubis no especificada contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32511",
      "display" : "S32511 Fractura de reborde superior pubis derecho"
    },
    {
      "code" : "S32511G",
      "display" : "S32511G Fractura de reborde superior pubis derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S36030S",
      "display" : "S36030S Desgarro superficial (capsular) de bazo secuela"
    },
    {
      "code" : "S36031S",
      "display" : "S36031S Desgarro moderado de bazo secuela"
    },
    {
      "code" : "S36032S",
      "display" : "S36032S Desgarro grave de bazo secuela"
    },
    {
      "code" : "S36039D",
      "display" : "S36039D Desgarro no especificado de bazo contacto sucesivo"
    },
    {
      "code" : "S3609XD",
      "display" : "S3609XD Otro traumatismo de bazo contacto sucesivo"
    },
    {
      "code" : "S36112",
      "display" : "S36112 Contusión de hígado"
    },
    {
      "code" : "S36112S",
      "display" : "S36112S Contusión de hígado secuela"
    },
    {
      "code" : "S36113S",
      "display" : "S36113S Desgarro de hígado de grado no especificado secuela"
    },
    {
      "code" : "S36114S",
      "display" : "S36114S Desgarro leve de hígado secuela"
    },
    {
      "code" : "S36115S",
      "display" : "S36115S Desgarro moderado de hígado secuela"
    },
    {
      "code" : "S36116S",
      "display" : "S36116S Desgarro grave de hígado secuela"
    },
    {
      "code" : "S40229D",
      "display" : "S40229D Ampolla (no térmica) de hombro no especificado contacto sucesivo"
    },
    {
      "code" : "S40241D",
      "display" : "S40241D Constricción externa del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S40242D",
      "display" : "S40242D Constricción externa del hombro izquierdo contacto sucesivo"
    },
    {
      "code" : "S40249S",
      "display" : "S40249S Constricción externa de hombro no especificado secuela"
    },
    {
      "code" : "S40251D",
      "display" : "S40251D Cuerpo extraño superficial del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S40252S",
      "display" : "S40252S Cuerpo extraño superficial del hombro izquierdo secuela"
    },
    {
      "code" : "S40259S",
      "display" : "S40259S Cuerpo extraño superficial de hombro no especificado secuela"
    },
    {
      "code" : "S40261S",
      "display" : "S40261S Picadura de insecto (no venenoso) en hombro derecho secuela"
    },
    {
      "code" : "S32049G",
      "display" : "S32049G Fractura no especificada de cuarta vértebra lumbar contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32050B",
      "display" : "S32050B Fractura en cuña por compresión de quinta vértebra lumbar contacto inicial por fractura abierta"
    },
    {
      "code" : "S32051A",
      "display" : "S32051A Fractura por estallido estable de quinta vértebra lumbar contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32592",
      "display" : "S32592 Otra fractura especificada de pubis izquierdo"
    },
    {
      "code" : "S32592K",
      "display" : "S32592K Otra fractura especificada de pubis izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32599D",
      "display" : "S32599D Otra fractura especificada de pubis no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32601",
      "display" : "S32601 Fractura no especificada de isquion derecho"
    },
    {
      "code" : "S32601G",
      "display" : "S32601G Fractura no especificada de isquion derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S36129S",
      "display" : "S36129S Traumatismo no especificado de vesícula biliar secuela"
    },
    {
      "code" : "S3613XS",
      "display" : "S3613XS Traumatismo de conducto biliar secuela"
    },
    {
      "code" : "S36200",
      "display" : "S36200 Traumatismo no especificado de cabeza del páncreas"
    },
    {
      "code" : "S36201A",
      "display" : "S36201A Traumatismo no especificado de cuerpo del páncreas contacto inicial"
    },
    {
      "code" : "S36202A",
      "display" : "S36202A Traumatismo no especificado de cola del páncreas contacto inicial"
    },
    {
      "code" : "S36209D",
      "display" : "S36209D Traumatismo no especificad de parte no especificada del páncreas contacto sucesivo"
    },
    {
      "code" : "S36220S",
      "display" : "S36220S Contusión de cabeza del páncreas secuela"
    },
    {
      "code" : "S36221S",
      "display" : "S36221S Contusión de cuerpo del páncreas secuela"
    },
    {
      "code" : "S36222S",
      "display" : "S36222S Contusión de cola del páncreas secuela"
    },
    {
      "code" : "S40811S",
      "display" : "S40811S Abrasión de brazo derecho secuela"
    },
    {
      "code" : "S40812S",
      "display" : "S40812S Abrasión de brazo izquierdo secuela"
    },
    {
      "code" : "S40819S",
      "display" : "S40819S Abrasión de brazo no especificado secuela"
    },
    {
      "code" : "S40821D",
      "display" : "S40821D Ampolla (no térmica) de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S40822S",
      "display" : "S40822S Ampolla (no térmica) de brazo izquierdo secuela"
    },
    {
      "code" : "S40829S",
      "display" : "S40829S Ampolla (no térmica) de brazo no especificado secuela"
    },
    {
      "code" : "S40841D",
      "display" : "S40841D Constricción externa de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S40842S",
      "display" : "S40842S Constricción externa de brazo izquierdo secuela"
    },
    {
      "code" : "S3210XK",
      "display" : "S3210XK Fractura no especificada de sacro contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32110D",
      "display" : "S32110D Fractura de zona I sin desplazamiento de sacro contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32111B",
      "display" : "S32111B Fractura de zona I con mínimo desplazamiento de sacro contacto inicial por fractura abierta"
    },
    {
      "code" : "S32112",
      "display" : "S32112 Fractura muy desplazada de zona I de sacro"
    },
    {
      "code" : "S32613",
      "display" : "S32613 Fractura por avulsión desplazada de isquion no especificado"
    },
    {
      "code" : "S32602B",
      "display" : "S32602B Fractura no especificada de isquion izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S32614A",
      "display" : "S32614A Fractura por avulsión sin desplazamiento de isquion derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32615",
      "display" : "S32615 Fractura por avulsión sin desplazamiento de isquion izquierdo"
    },
    {
      "code" : "S36241D",
      "display" : "S36241D Desgarro leve de cuerpo del páncreas contacto sucesivo"
    },
    {
      "code" : "S36242S",
      "display" : "S36242S Desgarro leve de cola del páncreas secuela"
    },
    {
      "code" : "S36249S",
      "display" : "S36249S Desgarro leve de parte no especificada del páncreas secuela"
    },
    {
      "code" : "S36250D",
      "display" : "S36250D Desgarro moderado de cabeza del páncreas contacto sucesivo"
    },
    {
      "code" : "S36251S",
      "display" : "S36251S Desgarro moderado de cuerpo del páncreas secuela"
    },
    {
      "code" : "S36252S",
      "display" : "S36252S Desgarro moderado de cola del páncreas secuela"
    },
    {
      "code" : "S36259S",
      "display" : "S36259S Desgarro moderado de parte no especificada del páncreas secuela"
    },
    {
      "code" : "S40869D",
      "display" : "S40869D Picadura de insecto (no venenoso) en brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S40871D",
      "display" : "S40871D Otra mordedura superficial de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S40872S",
      "display" : "S40872S Otra mordedura superficial de brazo izquierdo secuela"
    },
    {
      "code" : "S40879S",
      "display" : "S40879S Otra mordedura superficial de brazo no especificado secuela"
    },
    {
      "code" : "S40911D",
      "display" : "S40911D Traumatismo superficial no especificado del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S40912S",
      "display" : "S40912S Traumatismo superficial no especificado del hombro izquierdo secuela"
    },
    {
      "code" : "S4092",
      "display" : "S4092 Traumatismo superficial no especificado de brazo"
    },
    {
      "code" : "S32121S",
      "display" : "S32121S Fractura de zona II con mínimo desplazamiento de sacro secuela"
    },
    {
      "code" : "S32122G",
      "display" : "S32122G Fractura muy desplazada de zona II de sacro contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32129D",
      "display" : "S32129D Fractura no especificada de zona II de sacro contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32130",
      "display" : "S32130 Fractura de zona III sin desplazamiento de sacro"
    },
    {
      "code" : "S32130G",
      "display" : "S32130G Fractura de zona III sin desplazamiento de sacro contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S32699K",
      "display" : "S32699K Otra fractura de isquion no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S32810A",
      "display" : "S32810A Fracturas múltiples de la pelvis con disrupción estable de la cintura pélvica contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32811A",
      "display" : "S32811A Fracturas múltiples de la pelvis con disrupción inestable de la cintura pélvica contacto inicial por fractura cerrada"
    },
    {
      "code" : "S36292S",
      "display" : "S36292S Otro traumatismo de cola del páncreas secuela"
    },
    {
      "code" : "S36299S",
      "display" : "S36299S Otro traumatismo de parte no especificada del páncreas secuela"
    },
    {
      "code" : "S3630XD",
      "display" : "S3630XD Traumatismo no especificado de estómago contacto sucesivo"
    },
    {
      "code" : "S3632XA",
      "display" : "S3632XA Contusión de estómago contacto inicial"
    },
    {
      "code" : "S3633X",
      "display" : "S3633X Desgarro de estómago"
    },
    {
      "code" : "S3633XS",
      "display" : "S3633XS Desgarro de estómago secuela"
    },
    {
      "code" : "S3639XD",
      "display" : "S3639XD Otro traumatismo del estómago contacto sucesivo"
    },
    {
      "code" : "S36400",
      "display" : "S36400 Traumatismo no especificado de duodeno"
    },
    {
      "code" : "S36408",
      "display" : "S36408 Traumatismo no especificado de otra parte de intestino delgado"
    },
    {
      "code" : "S41009D",
      "display" : "S41009D Herida abierta no especificada de hombro no especificado contacto sucesivo"
    },
    {
      "code" : "S41011D",
      "display" : "S41011D Desgarro sin cuerpo extraño del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S41012S",
      "display" : "S41012S Desgarro sin cuerpo extraño del hombro izquierdo secuela"
    },
    {
      "code" : "S4102",
      "display" : "S4102 Desgarro con cuerpo extraño del hombro"
    },
    {
      "code" : "S41021D",
      "display" : "S41021D Desgarro con cuerpo extraño del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S41022S",
      "display" : "S41022S Desgarro con cuerpo extraño del hombro izquierdo secuela"
    },
    {
      "code" : "S4103",
      "display" : "S4103 Herida punzante sin cuerpo extraño del hombro"
    },
    {
      "code" : "S3214XG",
      "display" : "S3214XG Fractura tipo 1 de sacro contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S3215XA",
      "display" : "S3215XA Fractura tipo 2 de sacro contacto inicial por fractura cerrada"
    },
    {
      "code" : "S3215XS",
      "display" : "S3215XS Fractura tipo 2 de sacro secuela"
    },
    {
      "code" : "S3216X",
      "display" : "S3216X Fractura tipo 3 de sacro"
    },
    {
      "code" : "S3216XG",
      "display" : "S3216XG Fractura tipo 3 de sacro contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S3217XA",
      "display" : "S3217XA Fractura tipo 4 de sacro contacto inicial por fractura cerrada"
    },
    {
      "code" : "S3217XS",
      "display" : "S3217XS Fractura tipo 4 de sacro secuela"
    },
    {
      "code" : "S329XXD",
      "display" : "S329XXD Fractura de partes no especificadas de columna lumbosacra y pelvis contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S330XX",
      "display" : "S330XX Rotura traumática de disco intervertebral lumbar"
    },
    {
      "code" : "S331",
      "display" : "S331 Subluxación y luxación de vértebra lumbar"
    },
    {
      "code" : "S33100D",
      "display" : "S33100D Subluxación de vértebra lumbar no especificada contacto sucesivo"
    },
    {
      "code" : "S33101S",
      "display" : "S33101S Luxación de vértebra lumbar no especificada secuela"
    },
    {
      "code" : "S33110D",
      "display" : "S33110D Subluxación de vértebra lumbar L1/L2 contacto sucesivo"
    },
    {
      "code" : "S36428S",
      "display" : "S36428S Contusión de otra parte de intestino delgado secuela"
    },
    {
      "code" : "S36429S",
      "display" : "S36429S Contusión de parte no especificada de intestino delgado secuela"
    },
    {
      "code" : "S36430S",
      "display" : "S36430S Desgarro de duodeno secuela"
    },
    {
      "code" : "S36438S",
      "display" : "S36438S Desgarro de otra parte de intestino delgado secuela"
    },
    {
      "code" : "S36439S",
      "display" : "S36439S Desgarro de parte no especificada de intestino delgado secuela"
    },
    {
      "code" : "S36490D",
      "display" : "S36490D Otro traumatismo de duodeno contacto sucesivo"
    },
    {
      "code" : "S36498S",
      "display" : "S36498S Otro traumatismo de otra parte de intestino delgado secuela"
    },
    {
      "code" : "S36499S",
      "display" : "S36499S Otro traumatismo de parte no especificada de intestino delgado secuela"
    },
    {
      "code" : "S41051D",
      "display" : "S41051D Mordedura abierta del hombro derecho contacto sucesivo"
    },
    {
      "code" : "S41052D",
      "display" : "S41052D Mordedura abierta del hombro izquierdo contacto sucesivo"
    },
    {
      "code" : "S41059S",
      "display" : "S41059S Mordedura abierta de hombro no especificado secuela"
    },
    {
      "code" : "S41101A",
      "display" : "S41101A Herida abierta no especificada de brazo derecho contacto inicial"
    },
    {
      "code" : "S41102D",
      "display" : "S41102D Herida abierta no especificada de brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S41109D",
      "display" : "S41109D Herida abierta no especificada de brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S41111D",
      "display" : "S41111D Desgarro sin cuerpo extraño de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S32302A",
      "display" : "S32302A Fractura no especificada de ilion izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32302S",
      "display" : "S32302S Fractura no especificada de ilion izquierdo secuela"
    },
    {
      "code" : "S32309D",
      "display" : "S32309D Fractura no especificada de ilion no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32311A",
      "display" : "S32311A Fractura por avulsión desplazada de ilion derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32311S",
      "display" : "S32311S Fractura por avulsión desplazada de ilion derecho secuela"
    },
    {
      "code" : "S33140D",
      "display" : "S33140D Subluxación de vértebra lumbar L4/L5 contacto sucesivo"
    },
    {
      "code" : "S33141D",
      "display" : "S33141D Luxación de vértebra lumbar L4/L5 contacto sucesivo"
    },
    {
      "code" : "S332XX",
      "display" : "S332XX Luxación de articulaciones sacroiliaca y sacrococcígea"
    },
    {
      "code" : "S3330",
      "display" : "S3330 Luxación de partes no especificadas de columna lumbar y pelvis"
    },
    {
      "code" : "S3330XS",
      "display" : "S3330XS Luxación de partes no especificadas de columna lumbar y pelvis secuela"
    },
    {
      "code" : "S3339XS",
      "display" : "S3339XS Luxación de otras partes de columna lumbar y pelvis secuela"
    },
    {
      "code" : "S334XXD",
      "display" : "S334XXD Rotura traumática de sínfisis del pubis contacto sucesivo"
    },
    {
      "code" : "S335XX",
      "display" : "S335XX Esguince de ligamentos de columna lumbar"
    },
    {
      "code" : "S3651",
      "display" : "S3651 Lesión primaria por onda expansiva de colon"
    },
    {
      "code" : "S36510S",
      "display" : "S36510S Lesión primaria por onda expansiva de colon ascendente [derecho] secuela"
    },
    {
      "code" : "S36512",
      "display" : "S36512 Lesión primaria por onda expansiva de colon descendente [izquierdo]"
    },
    {
      "code" : "S36513A",
      "display" : "S36513A Lesión primaria por onda expansiva de colon sigmoide contacto inicial"
    },
    {
      "code" : "S36518A",
      "display" : "S36518A Lesión primaria por onda expansiva de otra parte de colon contacto inicial"
    },
    {
      "code" : "S36519D",
      "display" : "S36519D Lesión primaria por onda expansiva de parte no especificada de colon contacto sucesivo"
    },
    {
      "code" : "S41132D",
      "display" : "S41132D Herida punzante sin cuerpo extraño de brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S41139S",
      "display" : "S41139S Herida punzante sin cuerpo extraño de brazo no especificado secuela"
    },
    {
      "code" : "S41141D",
      "display" : "S41141D Herida punzante con cuerpo extraño de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S41142S",
      "display" : "S41142S Herida punzante con cuerpo extraño de brazo izquierdo secuela"
    },
    {
      "code" : "S4115",
      "display" : "S4115 Mordedura abierta de brazo"
    },
    {
      "code" : "S41151D",
      "display" : "S41151D Mordedura abierta de brazo derecho contacto sucesivo"
    },
    {
      "code" : "S41152D",
      "display" : "S41152D Mordedura abierta de brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S41159S",
      "display" : "S41159S Mordedura abierta de brazo no especificado secuela"
    },
    {
      "code" : "S32316D",
      "display" : "S32316D Fractura por avulsión sin desplazamiento de ilion no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32391A",
      "display" : "S32391A Otra fractura de ilion derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32391S",
      "display" : "S32391S Otra fractura de ilion derecho secuela"
    },
    {
      "code" : "S32392D",
      "display" : "S32392D Otra fractura de ilion izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S3402XD",
      "display" : "S3402XD Conmoción y edema de médula espinal sacra contacto sucesivo"
    },
    {
      "code" : "S34101",
      "display" : "S34101 Traumatismo no especificado a nivel L1 de médula espinal lumbar"
    },
    {
      "code" : "S34102",
      "display" : "S34102 Traumatismo no especificado a nivel L2 de médula espinal lumbar"
    },
    {
      "code" : "S34103A",
      "display" : "S34103A Traumatismo no especificado a nivel L3 de médula espinal lumbar contacto inicial"
    },
    {
      "code" : "S34104D",
      "display" : "S34104D Traumatismo no especificado a nivel L4 de médula espinal lumbar contacto sucesivo"
    },
    {
      "code" : "S34105S",
      "display" : "S34105S Traumatismo no especificado a nivel L5 de médula espinal lumbar secuela"
    },
    {
      "code" : "S36530D",
      "display" : "S36530D Desgarro de colon ascendente [derecho] contacto sucesivo"
    },
    {
      "code" : "S36531D",
      "display" : "S36531D Desgarro de colon transverso contacto sucesivo"
    },
    {
      "code" : "S36532S",
      "display" : "S36532S Desgarro de colon descendente [izquierdo] secuela"
    },
    {
      "code" : "S36533S",
      "display" : "S36533S Desgarro de colon sigmoide secuela"
    },
    {
      "code" : "S36538S",
      "display" : "S36538S Desgarro de otra parte de colon secuela"
    },
    {
      "code" : "S36539S",
      "display" : "S36539S Desgarro de parte no especificada de colon secuela"
    },
    {
      "code" : "S36590D",
      "display" : "S36590D Otro traumatismo de colon ascendente [derecho] contacto sucesivo"
    },
    {
      "code" : "S36591S",
      "display" : "S36591S Otro traumatismo de colon transverso secuela"
    },
    {
      "code" : "S36592S",
      "display" : "S36592S Otro traumatismo de colon descendente [izquierdo] secuela"
    },
    {
      "code" : "S36593S",
      "display" : "S36593S Otro traumatismo de colon sigmoide secuela"
    },
    {
      "code" : "S42009P",
      "display" : "S42009P Fractura de parte no especificada de clavícula no especificada contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42011D",
      "display" : "S42011D Fractura con desplazamiento anterior de extremo esternal de clavícula derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42012B",
      "display" : "S42012B Fractura con desplazamiento anterior de extremo esternal de clavícula izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S32409D",
      "display" : "S32409D Fractura no especificada de acetábulo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32411A",
      "display" : "S32411A Fractura desplazada de pared anterior de acetábulo derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32412",
      "display" : "S32412 Fractura desplazada de pared anterior de acetábulo izquierdo"
    },
    {
      "code" : "S32412G",
      "display" : "S32412G Fractura desplazada de pared anterior de acetábulo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S34121",
      "display" : "S34121 Lesión incompleta a nivel L1 de médula espinal lumbar"
    },
    {
      "code" : "S34122",
      "display" : "S34122 Lesión incompleta a nivel L2 de médula espinal lumbar"
    },
    {
      "code" : "S34122S",
      "display" : "S34122S Lesión incompleta a nivel L2 de médula espinal lumbar secuela"
    },
    {
      "code" : "S34124",
      "display" : "S34124 Lesión incompleta a nivel L4 de médula espinal lumbar"
    },
    {
      "code" : "S34125",
      "display" : "S34125 Lesión incompleta a nivel L5 de médula espinal lumbar"
    },
    {
      "code" : "S34129A",
      "display" : "S34129A Lesión incompleta a nivel no especificado de médula espinal lumbar contacto inicial"
    },
    {
      "code" : "S3663XD",
      "display" : "S3663XD Desgarro de recto contacto sucesivo"
    },
    {
      "code" : "S3669XA",
      "display" : "S3669XA Otro traumatismo de recto contacto inicial"
    },
    {
      "code" : "S368",
      "display" : "S368 Traumatismo de otros órganos intraabdominales"
    },
    {
      "code" : "S3681XD",
      "display" : "S3681XD Traumatismo de peritoneo contacto sucesivo"
    },
    {
      "code" : "S36892A",
      "display" : "S36892A Contusión de otros órganos intraabdominales contacto inicial"
    },
    {
      "code" : "S36893A",
      "display" : "S36893A Desgarro de otros órganos intraabdominales contacto inicial"
    },
    {
      "code" : "S36898D",
      "display" : "S36898D Otro traumatismo de otros órganos intraabdominales contacto sucesivo"
    },
    {
      "code" : "S36899S",
      "display" : "S36899S Traumatismo no especificado de otros órganos intraabdominales secuela"
    },
    {
      "code" : "S3690XD",
      "display" : "S3690XD Traumatismo no especificado de órgano intraabdominal no especificado contacto sucesivo"
    },
    {
      "code" : "S42016B",
      "display" : "S42016B Fractura con desplazamiento posterior de extremo esternal de clavícula no especificada contacto inicial por fractura abierta"
    },
    {
      "code" : "S42017",
      "display" : "S42017 Fractura sin desplazamiento de extremo esternal de clavícula derecha"
    },
    {
      "code" : "S3242",
      "display" : "S3242 Fractura de pared posterior de acetábulo"
    },
    {
      "code" : "S32421D",
      "display" : "S32421D Fractura desplazada de pared posterior de acetábulo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32422B",
      "display" : "S32422B Fractura desplazada de pared posterior de acetábulo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S343XXA",
      "display" : "S343XXA Traumatismo de cola de caballo contacto inicial"
    },
    {
      "code" : "S344X",
      "display" : "S344X Traumatismo de plexo lumbosacro"
    },
    {
      "code" : "S344XXD",
      "display" : "S344XXD Traumatismo de plexo lumbosacro contacto sucesivo"
    },
    {
      "code" : "S345XX",
      "display" : "S345XX Traumatismo de nervios simpáticos lumbares sacros y pélvicos"
    },
    {
      "code" : "S346X",
      "display" : "S346X Traumatismo de nervio(s) periférico(s) a nivel de abdomen parte inferior de espalda y pelvis"
    },
    {
      "code" : "S348",
      "display" : "S348 Traumatismo de otros nervios a nivel de abdomen parte inferior de espalda y pelvis"
    },
    {
      "code" : "S348XXS",
      "display" : "S348XXS Traumatismo de otros nervios a nivel de abdomen parte inferior de espalda y pelvis secuela"
    },
    {
      "code" : "S37009",
      "display" : "S37009 Traumatismo no especificado de riñón no especificado"
    },
    {
      "code" : "S3701",
      "display" : "S3701 Contusión leve de riñón"
    },
    {
      "code" : "S37011D",
      "display" : "S37011D Contusión leve de riñón derecho contacto sucesivo"
    },
    {
      "code" : "S37012S",
      "display" : "S37012S Contusión leve de riñón izquierdo secuela"
    },
    {
      "code" : "S37019S",
      "display" : "S37019S Contusión leve de riñón no especificado secuela"
    },
    {
      "code" : "S37021D",
      "display" : "S37021D Contusión grave de riñón derecho contacto sucesivo"
    },
    {
      "code" : "S37022S",
      "display" : "S37022S Contusión grave de riñón izquierdo secuela"
    },
    {
      "code" : "S37029S",
      "display" : "S37029S Contusión grave de riñón no especificado secuela"
    },
    {
      "code" : "S42021P",
      "display" : "S42021P Fractura desplazada de diáfisis de clavícula derecha contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42022G",
      "display" : "S42022G Fractura desplazada de diáfisis de clavícula izquierda contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42023B",
      "display" : "S42023B Fractura desplazada de diáfisis de clavícula no especificada contacto inicial por fractura abierta"
    },
    {
      "code" : "S32431B",
      "display" : "S32431B Fractura desplazada de rama anterior [iliopubiana] de acetábulo derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S32432A",
      "display" : "S32432A Fractura desplazada de rama anterior [iliopubiana] de acetábulo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S351",
      "display" : "S351 Traumatismo de vena cava inferior"
    },
    {
      "code" : "S3510XD",
      "display" : "S3510XD Traumatismo no especificado de vena cava inferior contacto sucesivo"
    },
    {
      "code" : "S3511XD",
      "display" : "S3511XD Desgarro leve de vena cava inferior contacto sucesivo"
    },
    {
      "code" : "S3512XA",
      "display" : "S3512XA Desgarro grave de vena cava inferior contacto inicial"
    },
    {
      "code" : "S3519X",
      "display" : "S3519X Otro traumatismo de vena cava inferior"
    },
    {
      "code" : "S352",
      "display" : "S352 Traumatismo de arterias mesentérica o celiaca y sus ramas"
    },
    {
      "code" : "S35211D",
      "display" : "S35211D Desgarro leve de arteria celiaca contacto sucesivo"
    },
    {
      "code" : "S35212S",
      "display" : "S35212S Desgarro grave de arteria celiaca secuela"
    },
    {
      "code" : "S35218S",
      "display" : "S35218S Otro traumatismo de arteria celiaca secuela"
    },
    {
      "code" : "S37051A",
      "display" : "S37051A Desgarro moderado de riñón derecho contacto inicial"
    },
    {
      "code" : "S37052A",
      "display" : "S37052A Desgarro moderado de riñón izquierdo contacto inicial"
    },
    {
      "code" : "S37059A",
      "display" : "S37059A Desgarro moderado de riñón no especificado contacto inicial"
    },
    {
      "code" : "S37061",
      "display" : "S37061 Desgarro grave de riñón derecho"
    },
    {
      "code" : "S37062",
      "display" : "S37062 Desgarro grave de riñón izquierdo"
    },
    {
      "code" : "S37069",
      "display" : "S37069 Desgarro grave de riñón no especificado"
    },
    {
      "code" : "S3709",
      "display" : "S3709 Otro traumatismo de riñón"
    },
    {
      "code" : "S37091D",
      "display" : "S37091D Otro traumatismo de riñón derecho contacto sucesivo"
    },
    {
      "code" : "S37092S",
      "display" : "S37092S Otro traumatismo de riñón izquierdo secuela"
    },
    {
      "code" : "S42031",
      "display" : "S42031 Fractura desplazada de extremo lateral de clavícula derecha"
    },
    {
      "code" : "S42031K",
      "display" : "S42031K Fractura desplazada de extremo lateral de clavícula derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42032D",
      "display" : "S42032D Fractura desplazada de extremo lateral de clavícula izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32436D",
      "display" : "S32436D Fractura sin desplazamiento de rama anterior [iliopubiana] de acetábulo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S32441B",
      "display" : "S32441B Fractura desplazada de rama posterior [ilioisquiática] de acetábulo derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S35232S",
      "display" : "S35232S Desgarro grave de arteria mesentérica inferior secuela"
    },
    {
      "code" : "S35219",
      "display" : "S35219 Traumatismo no especificado de arteria celiaca"
    },
    {
      "code" : "S35239D",
      "display" : "S35239D Traumatismo no especificado de arteria mesentérica inferior contacto sucesivo"
    },
    {
      "code" : "S2242XK",
      "display" : "S2242XK Fracturas múltiples de costillas de lado izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S2243XD",
      "display" : "S2243XD Fracturas múltiples de costillas bilateral contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S2249X",
      "display" : "S2249X Fracturas múltiples de costillas lado no especificado"
    },
    {
      "code" : "S2249XG",
      "display" : "S2249XG Fracturas múltiples de costillas lado no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S27491A",
      "display" : "S27491A Otro traumatismo de bronquio unilateral contacto inicial"
    },
    {
      "code" : "S27492A",
      "display" : "S27492A Otro traumatismo de bronquio bilateral contacto inicial"
    },
    {
      "code" : "S27499D",
      "display" : "S27499D Otro traumatismo de bronquio no especificado contacto sucesivo"
    },
    {
      "code" : "S2750X",
      "display" : "S2750X Traumatismo no especificado de tráquea torácica"
    },
    {
      "code" : "S2751",
      "display" : "S2751 Lesión primaria por onda expansiva de tráquea torácica"
    },
    {
      "code" : "S2752",
      "display" : "S2752 Contusión de tráquea torácica"
    },
    {
      "code" : "S2752XD",
      "display" : "S2752XD Contusión de tráquea torácica contacto sucesivo"
    },
    {
      "code" : "S2753XD",
      "display" : "S2753XD Desgarro de tráquea torácica contacto sucesivo"
    },
    {
      "code" : "S2759XA",
      "display" : "S2759XA Otro traumatismo de tráquea torácica contacto inicial"
    },
    {
      "code" : "S3121XS",
      "display" : "S3121XS Desgarro sin cuerpo extraño de pene secuela"
    },
    {
      "code" : "S3122XD",
      "display" : "S3122XD Desgarro con cuerpo extraño de pene contacto sucesivo"
    },
    {
      "code" : "S3123XD",
      "display" : "S3123XD Herida punzante sin cuerpo extraño de pene contacto sucesivo"
    },
    {
      "code" : "S3124XA",
      "display" : "S3124XA Herida punzante con cuerpo extraño de pene contacto inicial"
    },
    {
      "code" : "S3125XA",
      "display" : "S3125XA Mordedura abierta de pene contacto inicial"
    },
    {
      "code" : "S3130",
      "display" : "S3130 Herida abierta no especificada de escroto y testículos"
    },
    {
      "code" : "S3130XS",
      "display" : "S3130XS Herida abierta no especificada de escroto y testículos secuela"
    },
    {
      "code" : "S21209A",
      "display" : "S21209A Herida abierta no especificada de pared posterior no especificada del tórax sin penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S21211D",
      "display" : "S21211D Desgarro sin cuerpo extraño de pared posterior derecha del tórax sin penetración en cavidad torácica contacto sucesivo"
    },
    {
      "code" : "S21219A",
      "display" : "S21219A Desgarro sin cuerpo extraño de pared posterior no especificada del tórax sin penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S23100",
      "display" : "S23100 Subluxación de vértebra dorsal no especificada"
    },
    {
      "code" : "S23101",
      "display" : "S23101 Luxación de vértebra dorsal no especificada"
    },
    {
      "code" : "S2311",
      "display" : "S2311 Subluxación y luxación de vértebra dorsal D1/D2"
    },
    {
      "code" : "S225",
      "display" : "S225 Volet torácico"
    },
    {
      "code" : "S23111A",
      "display" : "S23111A Luxación de vértebra dorsal D1/D2 contacto inicial"
    },
    {
      "code" : "S23120",
      "display" : "S23120 Subluxación de vértebras dorsales D2-D3"
    },
    {
      "code" : "S23121",
      "display" : "S23121 Luxación de vértebras dorsales D2-D3"
    },
    {
      "code" : "S23122",
      "display" : "S23122 Subluxación de vértebra dorsal D3/D4"
    },
    {
      "code" : "S23123",
      "display" : "S23123 Luxación de vértebra dorsal D3/D4"
    },
    {
      "code" : "S27803S",
      "display" : "S27803S Desgarro de diafragma secuela"
    },
    {
      "code" : "S27808S",
      "display" : "S27808S Otro traumatismo de diafragma secuela"
    },
    {
      "code" : "S27809S",
      "display" : "S27809S Traumatismo no especificado de diafragma secuela"
    },
    {
      "code" : "S27812D",
      "display" : "S27812D Contusión de esófago (parte torácica) contacto sucesivo"
    },
    {
      "code" : "S27813S",
      "display" : "S27813S Desgarro de esófago (parte torácica) secuela"
    },
    {
      "code" : "S27818S",
      "display" : "S27818S Otro traumatismo de esófago (parte torácica) secuela"
    },
    {
      "code" : "S27819S",
      "display" : "S27819S Traumatismo no especificado de esófago (parte torácica) secuela"
    },
    {
      "code" : "S27892S",
      "display" : "S27892S Contusión de otros órganos intratorácicos especificados secuela"
    },
    {
      "code" : "S27898",
      "display" : "S27898 Otro traumatismo de otros órganos intratorácicos especificados"
    },
    {
      "code" : "S3140",
      "display" : "S3140 Herida abierta no especificada de vagina y vulva"
    },
    {
      "code" : "S3140XS",
      "display" : "S3140XS Herida abierta no especificada de vagina y vulva secuela"
    },
    {
      "code" : "S3141XS",
      "display" : "S3141XS Desgarro sin cuerpo extraño de vagina y vulva secuela"
    },
    {
      "code" : "S3142XD",
      "display" : "S3142XD Desgarro con cuerpo extraño de vagina y vulva contacto sucesivo"
    },
    {
      "code" : "S3143XD",
      "display" : "S3143XD Herida punzante sin cuerpo extraño de vagina y vulva contacto sucesivo"
    },
    {
      "code" : "S3144XD",
      "display" : "S3144XD Herida punzante con cuerpo extraño de vagina y vulva contacto sucesivo"
    },
    {
      "code" : "S3145XD",
      "display" : "S3145XD Mordedura abierta de vagina y vulva contacto sucesivo"
    },
    {
      "code" : "S31501",
      "display" : "S31501 Herida abierta no especificada de órganos genitales externos masculinos no especificados"
    },
    {
      "code" : "S21239S",
      "display" : "S21239S Herida punzante sin cuerpo extraño de pared posterior no especificada del tórax sin penetración en cavidad torácica secuela"
    },
    {
      "code" : "S21242A",
      "display" : "S21242A Herida punzante con cuerpo extraño de pared posterior izquierda del tórax sin penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S23141S",
      "display" : "S23141S Luxación de vértebra dorsal D6-D7 secuela"
    },
    {
      "code" : "S23142S",
      "display" : "S23142S Subluxación de vértebras dorsales D7-D8 secuela"
    },
    {
      "code" : "S2315",
      "display" : "S2315 Subluxación y luxación de vértebra dorsal D8/D9-D9/D10"
    },
    {
      "code" : "S23150S",
      "display" : "S23150S Subluxación de vértebra dorsal D8/D9 secuela"
    },
    {
      "code" : "S23151S",
      "display" : "S23151S Luxación de vértebra dorsal D8/D9 secuela"
    },
    {
      "code" : "S23152S",
      "display" : "S23152S Subluxación de vértebra dorsal D9/D10 secuela"
    },
    {
      "code" : "S23153S",
      "display" : "S23153S Luxación de vértebra dorsal D9/D10 secuela"
    },
    {
      "code" : "S23160S",
      "display" : "S23160S Subluxación de vértebra dorsal D10/D11 secuela"
    },
    {
      "code" : "S2821",
      "display" : "S2821 Amputación traumática completa de la mama"
    },
    {
      "code" : "S28211S",
      "display" : "S28211S Amputación traumática completa de la mama derecha secuela"
    },
    {
      "code" : "S28212S",
      "display" : "S28212S Amputación traumática completa de la mama izquierda secuela"
    },
    {
      "code" : "S2822",
      "display" : "S2822 Amputación traumática parcial de la mama"
    },
    {
      "code" : "S28221S",
      "display" : "S28221S Amputación traumática parcial de la mama derecha secuela"
    },
    {
      "code" : "S28222S",
      "display" : "S28222S Amputación traumática parcial de la mama izquierda secuela"
    },
    {
      "code" : "S29",
      "display" : "S29 Otros traumatismos y los no especificados del tórax"
    },
    {
      "code" : "S29001A",
      "display" : "S29001A Traumatismo no especificado de músculo y tendón de pared anterior del tórax contacto inicial"
    },
    {
      "code" : "S31531",
      "display" : "S31531 Herida punzante sin cuerpo extraño de órganos genitales externos masculinos no especificados"
    },
    {
      "code" : "S31532A",
      "display" : "S31532A Herida punzante sin cuerpo extraño de órganos genitales externos femeninos no especificados contacto inicial"
    },
    {
      "code" : "S31541D",
      "display" : "S31541D Herida punzante con cuerpo extraño de órganos genitales externos masculinos no especificados contacto sucesivo"
    },
    {
      "code" : "S21309",
      "display" : "S21309 Herida abierta no especificada de pared anterior no especificada del tórax con penetración en cavidad torácica"
    },
    {
      "code" : "S21311A",
      "display" : "S21311A Desgarro sin cuerpo extraño de pared anterior derecha del tórax con penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S21312S",
      "display" : "S21312S Desgarro sin cuerpo extraño de pared anterior izquierda del tórax con penetración en cavidad torácica secuela"
    },
    {
      "code" : "S2329XA",
      "display" : "S2329XA Luxación de otras partes del tórax contacto inicial"
    },
    {
      "code" : "S233XX",
      "display" : "S233XX Esguince de ligamentos de columna dorsal"
    },
    {
      "code" : "S234",
      "display" : "S234 Esguince de costillas y esternón"
    },
    {
      "code" : "S2341XA",
      "display" : "S2341XA Esguince de costillas contacto inicial"
    },
    {
      "code" : "S23420",
      "display" : "S23420 Esguince esternoclavicular (articulación) (ligamento)"
    },
    {
      "code" : "S23421",
      "display" : "S23421 Esguince de articulación condroesternal"
    },
    {
      "code" : "S23428",
      "display" : "S23428 Otro tipo de esguince de esternón"
    },
    {
      "code" : "S23429",
      "display" : "S23429 Esguince no especificado de esternón"
    },
    {
      "code" : "S238",
      "display" : "S238 Esguince de otras partes especificadas del tórax"
    },
    {
      "code" : "S29021S",
      "display" : "S29021S Desgarro de músculo y tendón de pared anterior del tórax secuela"
    },
    {
      "code" : "S29029",
      "display" : "S29029 Desgarro de músculo y tendón de pared no especificada del tórax"
    },
    {
      "code" : "S2909",
      "display" : "S2909 Otro traumatismo de músculo y tendón del tórax"
    },
    {
      "code" : "S29091S",
      "display" : "S29091S Otro traumatismo de músculo y tendón de pared anterior del tórax secuela"
    },
    {
      "code" : "S29099",
      "display" : "S29099 Otro traumatismo de músculo y tendón de pared no especificada del tórax"
    },
    {
      "code" : "S31603S",
      "display" : "S31603S Herida abierta no especificada de pared abdominal cuadrante inferior derecho con penetración en cavidad peritoneal secuela"
    },
    {
      "code" : "S31605A",
      "display" : "S31605A Herida abierta no especificada de pared abdominal región periumbilical con penetración en cavidad peritoneal contacto inicial"
    },
    {
      "code" : "S3161",
      "display" : "S3161 Desgarro sin cuerpo extraño de pared abdominal con penetración en cavidad peritoneal"
    },
    {
      "code" : "S21339S",
      "display" : "S21339S Herida punzante sin cuerpo extraño de pared anterior no especificada del tórax con penetración en cavidad torácica secuela"
    },
    {
      "code" : "S21342A",
      "display" : "S21342A Herida punzante con cuerpo extraño de pared anterior izquierda del tórax con penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S24103D",
      "display" : "S24103D Traumatismo no especificado a nivel D7-D10 de médula espinal dorsal contacto sucesivo"
    },
    {
      "code" : "S24104S",
      "display" : "S24104S Traumatismo no especificado a nivel D11-D12 de médula espinal dorsal secuela"
    },
    {
      "code" : "S2411",
      "display" : "S2411 Lesión completa de médula espinal dorsal"
    },
    {
      "code" : "S24111S",
      "display" : "S24111S Lesión completa a nivel D1 de médula espinal dorsal secuela"
    },
    {
      "code" : "S24113",
      "display" : "S24113 Lesión completa a nivel D7-D10 de médula espinal dorsal"
    },
    {
      "code" : "S24114",
      "display" : "S24114 Lesión completa a nivel D11-D12 de médula espinal dorsal"
    },
    {
      "code" : "S302",
      "display" : "S302 Contusión de órganos genitales externos"
    },
    {
      "code" : "S30201D",
      "display" : "S30201D Contusión de órgano genital externo masculino no especificado contacto sucesivo"
    },
    {
      "code" : "S30202S",
      "display" : "S30202S Contusión de órgano genital externo femenino no especificado secuela"
    },
    {
      "code" : "S3021XS",
      "display" : "S3021XS Contusión de pene secuela"
    },
    {
      "code" : "S3022XA",
      "display" : "S3022XA Contusión de escroto y testículos contacto inicial"
    },
    {
      "code" : "S3023X",
      "display" : "S3023X Contusión de vagina y vulva"
    },
    {
      "code" : "S3023XS",
      "display" : "S3023XS Contusión de vagina y vulva secuela"
    },
    {
      "code" : "S303XXA",
      "display" : "S303XXA Contusión de ano contacto inicial"
    },
    {
      "code" : "S3081",
      "display" : "S3081 Abrasión de abdomen parte inferior de la espalda pelvis y genitales externos"
    },
    {
      "code" : "S30811",
      "display" : "S30811 Abrasión de pared abdominal"
    },
    {
      "code" : "S31619",
      "display" : "S31619 Desgarro sin cuerpo extraño de pared abdominal cuadrante no especificado con penetración en cavidad peritoneal"
    },
    {
      "code" : "S31620D",
      "display" : "S31620D Desgarro con cuerpo extraño de pared abdominal cuadrante superior derecho con penetración en cavidad peritoneal contacto sucesivo"
    },
    {
      "code" : "S31622",
      "display" : "S31622 Desgarro con cuerpo extraño de pared abdominal región epigástrica con penetración en cavidad peritoneal"
    },
    {
      "code" : "S21402D",
      "display" : "S21402D Herida abierta no especificada de pared posterior izquierda del tórax con penetración en cavidad torácica contacto sucesivo"
    },
    {
      "code" : "S21411",
      "display" : "S21411 Desgarro sin cuerpo extraño de pared posterior derecha del tórax con penetración en cavidad torácica"
    },
    {
      "code" : "S21412D",
      "display" : "S21412D Desgarro sin cuerpo extraño de pared posterior izquierda del tórax con penetración en cavidad torácica contacto sucesivo"
    },
    {
      "code" : "S24141D",
      "display" : "S24141D Síndrome de Brown-Séquard a nivel D1 de médula espinal dorsal contacto sucesivo"
    },
    {
      "code" : "S24142D",
      "display" : "S24142D Síndrome de Brown-Séquard a nivel D2-D6 de médula espinal dorsal contacto sucesivo"
    },
    {
      "code" : "S24144",
      "display" : "S24144 Síndrome de Brown-Séquard a nivel D11-D12 de médula espinal dorsal"
    },
    {
      "code" : "S24149",
      "display" : "S24149 Síndrome de Brown-Séquard a nivel no especificado de médula espinal dorsal"
    },
    {
      "code" : "S24151",
      "display" : "S24151 Otros tipo de lesión incompleta a nivel D1 de médula espinal dorsal"
    },
    {
      "code" : "S30817A",
      "display" : "S30817A Abrasión de ano contacto inicial"
    },
    {
      "code" : "S30820",
      "display" : "S30820 Ampolla (no térmica) de parte inferior de espalda y pelvis"
    },
    {
      "code" : "S30821A",
      "display" : "S30821A Ampolla (no térmica) de pared abdominal contacto inicial"
    },
    {
      "code" : "S30822A",
      "display" : "S30822A Ampolla (no térmica) de pene contacto inicial"
    },
    {
      "code" : "S30823A",
      "display" : "S30823A Ampolla (no térmica) de escroto y testículos contacto inicial"
    },
    {
      "code" : "S30824D",
      "display" : "S30824D Ampolla (no térmica) de vagina y vulva contacto sucesivo"
    },
    {
      "code" : "S30825D",
      "display" : "S30825D Ampolla (no térmica) de órganos genitales externos masculinos no especificados contacto sucesivo"
    },
    {
      "code" : "S30827",
      "display" : "S30827 Ampolla (no térmica) de ano"
    },
    {
      "code" : "S31631S",
      "display" : "S31631S Herida punzante sin cuerpo extraño de pared abdominal cuadrante superior izquierdo con penetración en cavidad peritoneal secuela"
    },
    {
      "code" : "S31633A",
      "display" : "S31633A Herida punzante sin cuerpo extraño de pared abdominal cuadrante inferior derecho con penetración en cavidad peritoneal contacto inicial"
    },
    {
      "code" : "S21439A",
      "display" : "S21439A Herida punzante sin cuerpo extraño de pared posterior no especificada del tórax con penetración en cavidad torácica contacto inicial"
    },
    {
      "code" : "S21441S",
      "display" : "S21441S Herida punzante con cuerpo extraño de pared posterior derecha del tórax con penetración en cavidad torácica secuela"
    },
    {
      "code" : "S243XX",
      "display" : "S243XX Traumatismo de nervios periféricos del tórax"
    },
    {
      "code" : "S244",
      "display" : "S244 Traumatismo del sistema nervioso simpático torácico"
    },
    {
      "code" : "S244XXA",
      "display" : "S244XXA Traumatismo de sistema nervioso simpático torácico contacto inicial"
    },
    {
      "code" : "S248XX",
      "display" : "S248XX Traumatismo de otros nervios especificados del tórax"
    },
    {
      "code" : "S249",
      "display" : "S249 Traumatismo de nervio no especificado del tórax"
    },
    {
      "code" : "S249XXD",
      "display" : "S249XXD Traumatismo de nervio no especificado del tórax contacto sucesivo"
    },
    {
      "code" : "S2500X",
      "display" : "S2500X Traumatismo no especificado de aorta torácica"
    },
    {
      "code" : "S35329",
      "display" : "S35329 Traumatismo no especificado de vena esplénica"
    },
    {
      "code" : "S35331",
      "display" : "S35331 Desgarro de vena mesentérica superior"
    },
    {
      "code" : "S35331S",
      "display" : "S35331S Desgarro de vena mesentérica superior secuela"
    },
    {
      "code" : "S35339",
      "display" : "S35339 Traumatismo no especificado de vena mesentérica superior"
    },
    {
      "code" : "S3534",
      "display" : "S3534 Traumatismo de vena mesentérica inferior"
    },
    {
      "code" : "S35341S",
      "display" : "S35341S Desgarro de vena mesentérica inferior secuela"
    },
    {
      "code" : "S35348S",
      "display" : "S35348S Otro traumatismo especificado de vena mesentérica inferior secuela"
    },
    {
      "code" : "S354",
      "display" : "S354 Traumatismo de vasos sanguíneos renales"
    },
    {
      "code" : "S35401D",
      "display" : "S35401D Traumatismo no especificado de arteria renal derecha contacto sucesivo"
    },
    {
      "code" : "S3720X",
      "display" : "S3720X Traumatismo no especificado de vejiga"
    },
    {
      "code" : "S3722",
      "display" : "S3722 Contusión de vejiga"
    },
    {
      "code" : "S3722XD",
      "display" : "S3722XD Contusión de vejiga contacto sucesivo"
    },
    {
      "code" : "S3723XA",
      "display" : "S3723XA Desgarro de vejiga contacto inicial"
    },
    {
      "code" : "S3729X",
      "display" : "S3729X Otro traumatismo de vejiga"
    },
    {
      "code" : "S373",
      "display" : "S373 Traumatismo de uretra"
    },
    {
      "code" : "S3730XA",
      "display" : "S3730XA Traumatismo no especificado de uretra contacto inicial"
    },
    {
      "code" : "S3732X",
      "display" : "S3732X Contusión de uretra"
    },
    {
      "code" : "S3733",
      "display" : "S3733 Desgarro de uretra"
    },
    {
      "code" : "S3733XD",
      "display" : "S3733XD Desgarro de uretra contacto sucesivo"
    },
    {
      "code" : "S3739XA",
      "display" : "S3739XA Otro traumatismo de uretra contacto inicial"
    },
    {
      "code" : "S3740",
      "display" : "S3740 Traumatismo no especificado de ovario"
    },
    {
      "code" : "S37401D",
      "display" : "S37401D Traumatismo no especificado de ovario unilateral contacto sucesivo"
    },
    {
      "code" : "S42036G",
      "display" : "S42036G Fractura sin desplazamiento de extremo lateral de clavícula no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42101A",
      "display" : "S42101A Fractura de parte no especificada de escápula del hombro derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S32446B",
      "display" : "S32446B Fractura sin desplazamiento de rama posterior [ilioisquiática] de acetábulo no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S32451",
      "display" : "S32451 Fractura transversa desplazada de acetábulo derecho"
    },
    {
      "code" : "S37431A",
      "display" : "S37431A Desgarro de ovario unilateral contacto inicial"
    },
    {
      "code" : "S37432A",
      "display" : "S37432A Desgarro de ovario bilateral contacto inicial"
    },
    {
      "code" : "S37439D",
      "display" : "S37439D Desgarro de ovario no especificado contacto sucesivo"
    },
    {
      "code" : "S37491A",
      "display" : "S37491A Otro traumatismo de ovario unilateral contacto inicial"
    },
    {
      "code" : "S37492A",
      "display" : "S37492A Otro traumatismo de ovario bilateral contacto inicial"
    },
    {
      "code" : "S37499D",
      "display" : "S37499D Otro traumatismo de ovario no especificado contacto sucesivo"
    },
    {
      "code" : "S37501",
      "display" : "S37501 Traumatismo no especificado de trompa de Falopio unilateral"
    },
    {
      "code" : "S37502A",
      "display" : "S37502A Traumatismo no especificado de trompas de Falopio bilateral contacto inicial"
    },
    {
      "code" : "S37509D",
      "display" : "S37509D Traumatismo no especificado de trompa de Falopio no especificada contacto sucesivo"
    },
    {
      "code" : "S37818",
      "display" : "S37818 Otro traumatismo de glándula suprarrenal"
    },
    {
      "code" : "S37819",
      "display" : "S37819 Traumatismo no especificado de glándula suprarrenal"
    },
    {
      "code" : "S3782",
      "display" : "S3782 Traumatismo de próstata"
    },
    {
      "code" : "S37822D",
      "display" : "S37822D Contusión de próstata contacto sucesivo"
    },
    {
      "code" : "S37823D",
      "display" : "S37823D Desgarro de próstata contacto sucesivo"
    },
    {
      "code" : "S37828D",
      "display" : "S37828D Otro traumatismo de próstata contacto sucesivo"
    },
    {
      "code" : "S37829S",
      "display" : "S37829S Traumatismo no especificado de próstata secuela"
    },
    {
      "code" : "S37892D",
      "display" : "S37892D Contusión de otro órgano urinario o pélvico contacto sucesivo"
    },
    {
      "code" : "S37893S",
      "display" : "S37893S Desgarro de otro órgano urinario o pélvico secuela"
    },
    {
      "code" : "S42111K",
      "display" : "S42111K Fractura desplazada de cuerpo de escápula del hombro derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "T82529S",
      "display" : "T82529S Desplazamiento de dispositivos e implantes cardiacos y vasculares no especificados secuela"
    },
    {
      "code" : "T82530S",
      "display" : "T82530S Fuga de fístula arteriovenosa creada quirúrgicamente secuela"
    },
    {
      "code" : "T82532",
      "display" : "T82532 Fuga de corazón artificial"
    },
    {
      "code" : "T82532S",
      "display" : "T82532S Fuga de corazón artificial secuela"
    },
    {
      "code" : "T82533S",
      "display" : "T82533S Fuga de balón de contrapulsación secuela"
    },
    {
      "code" : "T82534S",
      "display" : "T82534S Fuga de catéter de infusión secuela"
    },
    {
      "code" : "T84126D",
      "display" : "T84126D Desplazamiento de dispositivo de fijación interna de hueso de parte inferior de la pierna derecha contacto sucesivo"
    },
    {
      "code" : "T84127D",
      "display" : "T84127D Desplazamiento de dispositivo de fijación interna de hueso de parte inferior de la pierna izquierda contacto sucesivo"
    },
    {
      "code" : "T84190",
      "display" : "T84190 Otra complicación mecánica de dispositivo de fijación interna de húmero derecho"
    },
    {
      "code" : "T84191A",
      "display" : "T84191A Otra complicación mecánica de dispositivo de fijación interna de húmero izquierdo contacto inicial"
    },
    {
      "code" : "T874",
      "display" : "T874 Infección de muñón de amputación"
    },
    {
      "code" : "T8743",
      "display" : "T8743 Infección de muñón de amputación de extremidad inferior derecha"
    },
    {
      "code" : "T8752",
      "display" : "T8752 Necrosis de muñón de amputación de extremidad superior izquierda"
    },
    {
      "code" : "T8781",
      "display" : "T8781 Dehiscencia de muñón de amputación"
    },
    {
      "code" : "T880",
      "display" : "T880 Infección después de inmunización"
    },
    {
      "code" : "T880XXD",
      "display" : "T880XXD Infección después de inmunización contacto sucesivo"
    },
    {
      "code" : "T881XX",
      "display" : "T881XX Otras complicaciones después de inmunización no clasificadas bajo otro concepto"
    },
    {
      "code" : "T882X",
      "display" : "T882X Shock por (debido a) anestesia"
    },
    {
      "code" : "T8069",
      "display" : "T8069 Otras reacciones a suero por otro suero"
    },
    {
      "code" : "T8069XS",
      "display" : "T8069XS Otras reacciones a suero por otro suero secuela"
    },
    {
      "code" : "T80810A",
      "display" : "T80810A Extravasación de quimioterapia antineoplásica vesicante contacto inicial"
    },
    {
      "code" : "T80818D",
      "display" : "T80818D Extravasación de otro tipo de agente vesicante contacto sucesivo"
    },
    {
      "code" : "T8082XD",
      "display" : "T8082XD Complicación de terapia celular inmune efectora contacto sucesivo"
    },
    {
      "code" : "T8089XD",
      "display" : "T8089XD Otras complicaciones después de infusión transfusión e inyección terapéutica contacto sucesivo"
    },
    {
      "code" : "T82593S",
      "display" : "T82593S Otra complicación mecánica de balón de contrapulsación secuela"
    },
    {
      "code" : "T82594S",
      "display" : "T82594S Otra complicación mecánica de catéter de infusión secuela"
    },
    {
      "code" : "T82595S",
      "display" : "T82595S Otra complicación mecánica de dispositivo paraguas secuela"
    },
    {
      "code" : "T82599",
      "display" : "T82599 Otra complicación mecánica de dispositivos e implantes cardiacos y vasculares no especificados"
    },
    {
      "code" : "T826XX",
      "display" : "T826XX Infección y reacción inflamatoria por (debida a) prótesis valvular cardiaca"
    },
    {
      "code" : "T84199S",
      "display" : "T84199S Otra complicación mecánica de dispositivo de fijación interna de hueso de extremidad no especificada secuela"
    },
    {
      "code" : "T84210S",
      "display" : "T84210S Fallo mecánico de dispositivo de fijación interna de huesos de mano y dedos de la mano secuela"
    },
    {
      "code" : "T84216A",
      "display" : "T84216A Fallo mecánico de dispositivo de fijación interna de vértebras contacto inicial"
    },
    {
      "code" : "T8853X",
      "display" : "T8853X Despertar bajo anestesia general durante un procedimiento"
    },
    {
      "code" : "T8859X",
      "display" : "T8859X Otras complicaciones de anestesia"
    },
    {
      "code" : "T886",
      "display" : "T886 Reacción anafiláctica por (debida a) efecto adverso de fármaco o medicamento correcto adecuadamente administrado"
    },
    {
      "code" : "T887",
      "display" : "T887 Efecto adverso no especificado de fármaco o medicamento"
    },
    {
      "code" : "T887XXD",
      "display" : "T887XXD Efecto adverso no especificado de fármaco o medicamento contacto sucesivo"
    },
    {
      "code" : "T888XXA",
      "display" : "T888XXA Otras complicaciones especificadas de atención quirúrgica y médica no clasificadas bajo otro concepto contacto inicial"
    },
    {
      "code" : "T8111",
      "display" : "T8111 Shock cardiogénico después de un procedimiento"
    },
    {
      "code" : "T8090XD",
      "display" : "T8090XD Complicación no especificada después de infusión e inyección terapéutica contacto sucesivo"
    },
    {
      "code" : "T8112XS",
      "display" : "T8112XS Shock séptico después de un procedimiento secuela"
    },
    {
      "code" : "T8119XD",
      "display" : "T8119XD Otro shock después de un procedimiento contacto sucesivo"
    },
    {
      "code" : "T8130X",
      "display" : "T8130X Ruptura de herida no especificada"
    },
    {
      "code" : "T8131",
      "display" : "T8131 Ruptura de herida operatoria (quirúrgica) externa no clasificada bajo otro concepto"
    },
    {
      "code" : "T82837",
      "display" : "T82837 Hemorragia debida a prótesis implantes e injertos cardiacos"
    },
    {
      "code" : "T82838",
      "display" : "T82838 Hemorragia debida a prótesis implantes e injertos vasculares"
    },
    {
      "code" : "T8284",
      "display" : "T8284 Dolor debido a prótesis implantes e injertos cardiacos y vasculares"
    },
    {
      "code" : "T82847S",
      "display" : "T82847S Dolor debido a prótesis implantes e injertos cardiacos secuela"
    },
    {
      "code" : "T8285",
      "display" : "T8285 Estenosis debida a prótesis implantes e injertos cardiacos y vasculares"
    },
    {
      "code" : "T82856",
      "display" : "T82856 Estenosis debida a stent vascular periférico"
    },
    {
      "code" : "T84290D",
      "display" : "T84290D Otra complicación mecánica de dispositivo de fijación interna de huesos de mano y dedos de la mano contacto sucesivo"
    },
    {
      "code" : "T84296",
      "display" : "T84296 Otra complicación mecánica de dispositivo de fijación interna de vértebras"
    },
    {
      "code" : "T84298D",
      "display" : "T84298D Otra complicación mecánica de dispositivo de fijación interna de otros huesos contacto sucesivo"
    },
    {
      "code" : "T84310A",
      "display" : "T84310A Fallo mecánico de estimulador electrónico óseo contacto inicial"
    },
    {
      "code" : "T84318D",
      "display" : "T84318D Fallo mecánico de otros dispositivos implantes e injertos óseos contacto sucesivo"
    },
    {
      "code" : "V0009",
      "display" : "V0009 Peatón transeúnte lesionado por colisión con otro tipo de transporte peatonal"
    },
    {
      "code" : "V001",
      "display" : "V001 Accidentes de transporte peatonal de ruedas"
    },
    {
      "code" : "T889X",
      "display" : "T889X Complicación de atención quirúrgica y médica no especificada"
    },
    {
      "code" : "V00112A",
      "display" : "V00112A Colisión en patín de ruedas en línea y objeto fijo contacto inicial"
    },
    {
      "code" : "V00118D",
      "display" : "V00118D Otro accidente en patín de ruedas en línea contacto sucesivo"
    },
    {
      "code" : "V00121D",
      "display" : "V00121D Caída desde patín de ruedas no en línea contacto sucesivo"
    },
    {
      "code" : "T8142XS",
      "display" : "T8142XS Infección después de un procedimiento zona de incisión quirúrgica profunda secuela"
    },
    {
      "code" : "T8143XS",
      "display" : "T8143XS Infección después de un procedimiento zona quirúrgica de órgano y espacio secuela"
    },
    {
      "code" : "T8149",
      "display" : "T8149 Infección después de un procedimiento otra zona quirúrgica"
    },
    {
      "code" : "T8149XS",
      "display" : "T8149XS Infección después de un procedimiento otra zona quirúrgica secuela"
    },
    {
      "code" : "T81500D",
      "display" : "T81500D Complicación no especificada de cuerpo extraño dejado accidentalmente en el interior del cuerpo después de intervención quirúrgica contacto sucesivo"
    },
    {
      "code" : "T829X",
      "display" : "T829X Complicación no especificada de prótesis implantes e injertos cardiacos y vasculares"
    },
    {
      "code" : "T83",
      "display" : "T83 Complicaciones de prótesis implantes e injertos genitourinarios"
    },
    {
      "code" : "T83010A",
      "display" : "T83010A Fallo (mecánico) de catéter de cistostomía contacto inicial"
    },
    {
      "code" : "T83011D",
      "display" : "T83011D Fallo (mecánico) de sonda uretral permanente contacto sucesivo"
    },
    {
      "code" : "T83012D",
      "display" : "T83012D Fallo (mecánico) de catéter de nefrostomia contacto sucesivo"
    },
    {
      "code" : "T84418D",
      "display" : "T84418D Fallo mecánico de otros dispositivos implantes e injertos ortopédicos internos contacto sucesivo"
    },
    {
      "code" : "V3910",
      "display" : "V3910 Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con vehículos motorizados no especificados en un accidente no de tráfico"
    },
    {
      "code" : "V473XX",
      "display" : "V473XX Ocupante no especificado de coche lesionado por colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "V474XXA",
      "display" : "V474XXA Persona que sube o baja de coche lesionada en colisión con objeto fijo o estacionado contacto inicial"
    },
    {
      "code" : "V475XXA",
      "display" : "V475XXA Conductor de coche lesionado por colisión con objeto fijo o estacionado en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V569",
      "display" : "V569 Ocupante no especificado de camioneta o furgoneta lesionado en colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V57",
      "display" : "V57 Ocupante de camioneta o furgoneta lesionado en colisión con objeto fijo o estacionado"
    },
    {
      "code" : "V677XX",
      "display" : "V677XX Persona en el exterior de vehículo de transporte pesado lesionada en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V3940XD",
      "display" : "V3940XD Conductor de vehículo motorizado de tres ruedas lesionado en colisión con vehículos motorizados no especificados en accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V481XX",
      "display" : "V481XX Pasajero de coche lesionado en un accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V482XX",
      "display" : "V482XX Persona en el exterior de coche lesionada en un accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V575X",
      "display" : "V575X Conductor de camioneta o furgoneta lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V576X",
      "display" : "V576X Pasajero de camioneta o furgoneta lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V683XXS",
      "display" : "V683XXS Ocupante no especificado de vehículo de transporte pesado lesionado en un accidente de transporte sin colisión en un accidente no de tráfico secuela"
    },
    {
      "code" : "V685",
      "display" : "V685 Conductor de vehículo de transporte pesado lesionado en un accidente de transporte sin colisión en un accidente de tráfico"
    },
    {
      "code" : "V3989X",
      "display" : "V3989X Ocupante (conductor) (pasajero) de vehículo motorizado de tres ruedas lesionado en otros accidentes de transporte especificados"
    },
    {
      "code" : "V487XXD",
      "display" : "V487XXD Persona en el exterior de coche lesionada en un accidente de transporte sin colisión en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V489XXD",
      "display" : "V489XXD Ocupante no especificado de coche lesionado en un accidente de transporte sin colisión en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V582X",
      "display" : "V582X Persona en el exterior de camioneta o furgoneta lesionada en un accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V583XX",
      "display" : "V583XX Ocupante no especificado de camioneta o furgoneta lesionado en un accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V6909",
      "display" : "V6909 Conductor de vehículo de transporte pesado lesionado en colisión con otros vehículos motorizados en un accidente no de tráfico"
    },
    {
      "code" : "V402XXS",
      "display" : "V402XXS Persona en el exterior de coche lesionada en colisión con peatón o animal en un accidente no de tráfico secuela"
    },
    {
      "code" : "V403XXS",
      "display" : "V403XXS Ocupante no especificado de coche lesionado en colisión con peatón o animal en un accidente no de tráfico secuela"
    },
    {
      "code" : "V404XXS",
      "display" : "V404XXS Persona que entra o sale de coche lesionada en colisión con peatón o animal secuela"
    },
    {
      "code" : "V4929XA",
      "display" : "V4929XA Ocupante no especificado de coche lesionado en colisión con otros vehículos motorizados en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V493XXA",
      "display" : "V493XXA Ocupante de coche (conductor) (pasajero) lesionado en un accidente no especificado no de tráfico contacto inicial"
    },
    {
      "code" : "V587XXS",
      "display" : "V587XXS Persona en el exterior de camioneta o furgoneta lesionada en un accidente de transporte sin colisión en un accidente de tráfico secuela"
    },
    {
      "code" : "V59",
      "display" : "V59 Ocupante de camioneta o furgoneta lesionado en otros accidentes de transporte y los no especificados"
    },
    {
      "code" : "T84420S",
      "display" : "T84420S Desplazamiento de injerto de músculo y tendón secuela"
    },
    {
      "code" : "T84428S",
      "display" : "T84428S Desplazamiento de otros dispositivos implantes e injertos ortopédicos internos secuela"
    },
    {
      "code" : "T84498",
      "display" : "T84498 Otra complicación mecánica de otros dispositivos implantes e injertos ortopédicos internos"
    },
    {
      "code" : "T8450",
      "display" : "T8450 Infección y reacción inflamatoria por (debida a) prótesis interna de articulación no especificada"
    },
    {
      "code" : "V00142S",
      "display" : "V00142S Colisión en patinete (no motorizado) y objeto fijo secuela"
    },
    {
      "code" : "V00148S",
      "display" : "V00148S Otro accidente en patinete (no motorizado) secuela"
    },
    {
      "code" : "V00151D",
      "display" : "V00151D Caída desde zapatilla de ruedas contacto sucesivo"
    },
    {
      "code" : "V00152S",
      "display" : "V00152S Colisión entre zapatilla de ruedas y objeto fijo secuela"
    },
    {
      "code" : "V00158S",
      "display" : "V00158S Otro accidente sobre zapatilla de ruedas secuela"
    },
    {
      "code" : "V00181D",
      "display" : "V00181D Caída desde otro medio de transporte peatonal de ruedas contacto sucesivo"
    },
    {
      "code" : "V00182S",
      "display" : "V00182S Peatón en otro medio de transporte peatonal de ruedas que colisiona con objeto fijo secuela"
    },
    {
      "code" : "T81507D",
      "display" : "T81507D Complicación no especificada de cuerpo extraño dejado accidentalmente en el interior del cuerpo después de retirada de catéter o packing (taponamiento) contacto sucesivo"
    },
    {
      "code" : "T83031D",
      "display" : "T83031D Fuga de sonda uretral permanente contacto sucesivo"
    },
    {
      "code" : "T83032D",
      "display" : "T83032D Fuga de catéter de nefrostomía contacto sucesivo"
    },
    {
      "code" : "T83038D",
      "display" : "T83038D Fuga de otro catéter urinario contacto sucesivo"
    },
    {
      "code" : "T83090A",
      "display" : "T83090A Otra complicación mecánica de catéter de cistostomía contacto inicial"
    },
    {
      "code" : "T83091D",
      "display" : "T83091D Otra complicación mecánica de sonda uretral permanente contacto sucesivo"
    },
    {
      "code" : "T83092S",
      "display" : "T83092S Otra complicación mecánica de catéter de nefrostomía secuela"
    },
    {
      "code" : "T83098S",
      "display" : "T83098S Otra complicación mecánica de otro catéter urinario secuela"
    },
    {
      "code" : "T83110D",
      "display" : "T83110D Fallo (mecánico) de dispositivo estimulador electrónico urinario contacto sucesivo"
    },
    {
      "code" : "V336X",
      "display" : "V336X Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con coche camioneta o furgoneta en un accidente de tráfico"
    },
    {
      "code" : "V0602",
      "display" : "V0602 Peatón en monopatín lesionado en colisión con otro vehículo no motorizado en un accidente no de tráfico"
    },
    {
      "code" : "V06031",
      "display" : "V06031 Peatón en patinete eléctrico de pie lesionado por colisión con otro vehículo no motorizado en un accidente no de tráfico"
    },
    {
      "code" : "V2001",
      "display" : "V2001 Conductor de bicicleta eléctrica (asistida) lesionado por colisión con peatón o animal en un accidente no de tráfico"
    },
    {
      "code" : "V2009X",
      "display" : "V2009X Conductor de otro tipo de motocicleta lesionado por colisión con peatón o animal en un accidente no de tráfico"
    },
    {
      "code" : "V2011XA",
      "display" : "V2011XA Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con peatón o animal en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V2691XD",
      "display" : "V2691XD Ciclista no especificado de bicicleta eléctrica (asistida) lesionado por colisión con otro vehículo no motorizado en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V342XXD",
      "display" : "V342XXD Persona en el exterior de vehículo motorizado de tres ruedas lesionada en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V0613",
      "display" : "V0613 Peatón en medio de transporte peatonal de micromovilidad de pie lesionado por colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V06138D",
      "display" : "V06138D Peatón en otro medio de transporte peatonal de micromovilidad de pie lesionado por colisión con otro vehículo no motorizado en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V204",
      "display" : "V204 Conductor de motocicleta lesionado en colisión con peatón o animal en un accidente de tráfico"
    },
    {
      "code" : "V2041XS",
      "display" : "V2041XS Conductor de bicicleta eléctrica (asistida) lesionado por colisión con peatón o animal en un accidente de tráfico secuela"
    },
    {
      "code" : "V272",
      "display" : "V272 Motociclista no especificado lesionado en colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "V2729",
      "display" : "V2729 Motociclista no especificado de otro tipo de motocicleta lesionado por colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "V347XXS",
      "display" : "V347XXS Persona en el exterior de vehículo motorizado de tres ruedas lesionada en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico secuela"
    },
    {
      "code" : "V06938S",
      "display" : "V06938S Peatón en otro medio de transporte peatonal de micromovilidad de pie lesionado por colisión con otro vehículo no motorizado no especificado si el accidente fue o no de tráfico secuela"
    },
    {
      "code" : "V2109X",
      "display" : "V2109X Conductor de otro tipo de motocicleta lesionado por colisión con vehículo de pedal en un accidente no de tráfico"
    },
    {
      "code" : "V2111X",
      "display" : "V2111X Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con vehículo de pedal en un accidente no de tráfico"
    },
    {
      "code" : "V2751XD",
      "display" : "V2751XD Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con objeto fijo o estacionado en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V279",
      "display" : "V279 Motociclista no especificado lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V00898S",
      "display" : "V00898S Otro accidente en otro medio de transporte peatonal secuela"
    },
    {
      "code" : "V0100X",
      "display" : "V0100X Peatón a pie lesionado en colisión con vehículo a pedales en un accidente no de tráfico"
    },
    {
      "code" : "V0101XA",
      "display" : "V0101XA Peatón sobre patines lesionado en colisión con vehículo a pedales en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V0102XA",
      "display" : "V0102XA Peatón en monopatín lesionado en colisión con vehículo a pedales en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V091XXS",
      "display" : "V091XXS Peatón lesionado en accidente no de tráfico no especificado secuela"
    },
    {
      "code" : "V0920XD",
      "display" : "V0920XD Peatón lesionado en accidente de tráfico con vehículos motorizados no especificados contacto sucesivo"
    },
    {
      "code" : "V0921XS",
      "display" : "V0921XS Peatón lesionado en accidente de tráfico con vehículos militares secuela"
    },
    {
      "code" : "V0929XS",
      "display" : "V0929XS Peatón lesionado en accidente de tráfico con otros vehículos motorizados secuela"
    },
    {
      "code" : "V093XXD",
      "display" : "V093XXD Peatón lesionado en accidente de tráfico no especificado contacto sucesivo"
    },
    {
      "code" : "V2139XD",
      "display" : "V2139XD Persona que sube o baja de otro tipo de motocicleta lesionada por colisión con vehículo de pedal contacto sucesivo"
    },
    {
      "code" : "V2141XS",
      "display" : "V2141XS Conductor de bicicleta eléctrica (asistida) lesionado por colisión con vehículo de pedal en un accidente de tráfico secuela"
    },
    {
      "code" : "V282",
      "display" : "V282 Motociclista no especificado lesionado en un accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V0112XA",
      "display" : "V0112XA Peatón en monopatín lesionado en colisión con vehículo a pedales en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V01131S",
      "display" : "V01131S Peatón en patinete eléctrico de pie lesionado por colisión con vehículo a pedales en un accidente de tráfico secuela"
    },
    {
      "code" : "V102XXS",
      "display" : "V102XXS Ciclista no especificado lesionado en colisión con peatón o animal en un accidente no de tráfico secuela"
    },
    {
      "code" : "V103XXS",
      "display" : "V103XXS Persona que sube o baja de un vehículo a pedales lesionada en colisión con peatón o animal secuela"
    },
    {
      "code" : "V104XXS",
      "display" : "V104XXS Conductor de vehículo a pedales lesionado en colisión con peatón o animal en un accidente de tráfico secuela"
    },
    {
      "code" : "V22",
      "display" : "V22 Motociclista lesionado en colisión con vehículo motorizado de dos o tres ruedas"
    },
    {
      "code" : "V2201XD",
      "display" : "V2201XD Conductor de bicicleta eléctrica (asistida) lesionado por colisión con vehículo motorizado de dos o tres ruedas en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V2849XS",
      "display" : "V2849XS Conductor de otro tipo de motocicleta lesionado en un accidente de transporte sin colisión en un accidente de tráfico secuela"
    },
    {
      "code" : "V2851XS",
      "display" : "V2851XS Pasajero de bicicleta eléctrica (asistida) lesionado en un accidente de transporte sin colisión en un accidente de tráfico secuela"
    },
    {
      "code" : "V0119X",
      "display" : "V0119X Peatón en otro medio de transporte lesionado en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V0199XS",
      "display" : "V0199XS Peatón en otro medio de transporte lesionado en colisión con vehículo a pedales no especificado si el accidente fue o no de tráfico secuela"
    },
    {
      "code" : "V112XXS",
      "display" : "V112XXS Ciclista no especificado lesionado en colisión con otro vehículo a pedales en un accidente no de tráfico secuela"
    },
    {
      "code" : "V114",
      "display" : "V114 Conductor de vehículo a pedales lesionado en colisión con otro vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V115",
      "display" : "V115 Pasajero de vehículo a pedales lesionado en colisión con otro vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V2231XA",
      "display" : "V2231XA Persona que sube o baja de bicicleta eléctrica (asistida) lesionada por colisión con vehículo motorizado de dos o tres ruedas contacto inicial"
    },
    {
      "code" : "V29091",
      "display" : "V29091 Conductor de bicicleta eléctrica (asistida) lesionado por colisión con otros vehículos motorizados en un accidente no de tráfico"
    },
    {
      "code" : "V29098S",
      "display" : "V29098S Conductor de otro tipo de motocicleta lesionado por colisión con otros vehículos motorizados en un accidente no de tráfico secuela"
    },
    {
      "code" : "V0209X",
      "display" : "V0209X Peatón en otro medio de transporte lesionado en colisión con vehículo motorizado de dos o tres ruedas en un accidente no de tráfico"
    },
    {
      "code" : "V0210XA",
      "display" : "V0210XA Peatón a pie lesionado en colisión con vehículo motorizado de dos o tres ruedas en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V122XXA",
      "display" : "V122XXA Ciclista no especificado lesionado en colisión con vehículo motorizado de dos o tres ruedas en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V123XXD",
      "display" : "V123XXD Persona que sube o baja de un vehículo a pedales lesionada en colisión con vehículo motorizado de dos o tres ruedas contacto sucesivo"
    },
    {
      "code" : "V2291XD",
      "display" : "V2291XD Ciclista no especificado de bicicleta eléctrica (asistida) lesionado por colisión con vehículo motorizado de dos o tres ruedas en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V2929",
      "display" : "V2929 Motociclista no especificado lesionado por colisión con otros vehículos motorizados en un accidente no de tráfico"
    },
    {
      "code" : "V29298A",
      "display" : "V29298A Motociclista no especificado de otro tipo de motocicleta lesionado por colisión con otros vehículos motorizados en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V0290X",
      "display" : "V0290X Peatón a pie lesionado en colisión con vehículo motorizado de dos o tres ruedas no especificado si el accidente fue o no de tráfico"
    },
    {
      "code" : "V132",
      "display" : "V132 Ciclista no especificado lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V133",
      "display" : "V133 Persona que sube o baja de un vehículo a pedales lesionada en colisión con coche camioneta o furgoneta"
    },
    {
      "code" : "V2321",
      "display" : "V2321 Ciclista no especificado de bicicleta eléctrica (asistida) lesionado por colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V2329XA",
      "display" : "V2329XA Motociclista no especificado de otro tipo de motocicleta lesionado por colisión con coche camioneta o furgoneta en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V29498A",
      "display" : "V29498A Conductor de otro tipo de motocicleta lesionado por colisión con otros vehículos motorizados en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V0301X",
      "display" : "V0301X Peatón sobre patines lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V141",
      "display" : "V141 Pasajero de vehículo a pedales lesionado en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico"
    },
    {
      "code" : "V142X",
      "display" : "V142X Ciclista no especificado lesionado en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico"
    },
    {
      "code" : "V2351XA",
      "display" : "V2351XA Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con coche camioneta o furgoneta en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V2359XS",
      "display" : "V2359XS Pasajero de otro tipo de motocicleta lesionado por colisión con coche camioneta o furgoneta en un accidente de tráfico secuela"
    },
    {
      "code" : "V29691S",
      "display" : "V29691S Ciclista no especificado de bicicleta eléctrica (asistida) lesionado por colisión con otros vehículos motorizados en un accidente de tráfico secuela"
    },
    {
      "code" : "V0311XD",
      "display" : "V0311XD Peatón sobre patines lesionado en colisión con coche camioneta o furgoneta en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V0313",
      "display" : "V0313 Peatón en medio de transporte peatonal de micromovilidad de pie lesionado por colisión con coche camioneta o furgoneta en un accidente de tráfico"
    },
    {
      "code" : "V149XXA",
      "display" : "V149XXA Ciclista no especificado lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V150XXA",
      "display" : "V150XXA Conductor de vehículo a pedales lesionado en colisión con tren o vehículo ferroviario en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V2419XS",
      "display" : "V2419XS Pasajero de otro tipo de motocicleta lesionado por colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico secuela"
    },
    {
      "code" : "V2999",
      "display" : "V2999 Motociclista (conductor) (pasajero) de otro tipo de motocicleta lesionado en accidente de tráfico no especificado"
    },
    {
      "code" : "V300",
      "display" : "V300 Conductor de vehículo motorizado de tres ruedas lesionado en colisión con peatón o animal en un accidente no de tráfico"
    },
    {
      "code" : "V0393",
      "display" : "V0393 Peatón en medio de transporte peatonal de micromovilidad de pie lesionado por colisión con coche camioneta o furgoneta no especificado si el accidente fue o no de tráfico"
    },
    {
      "code" : "V155XXA",
      "display" : "V155XXA Pasajero de vehículo a pedales lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V159XXA",
      "display" : "V159XXA Ciclista no especificado lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V160XXA",
      "display" : "V160XXA Conductor de vehículo a pedales lesionado en colisión con otro vehículo motorizado en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V2441XD",
      "display" : "V2441XD Conductor de bicicleta eléctrica (asistida) lesionado por colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V2451",
      "display" : "V2451 Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con vehículo de transporte pesado o autobús en un accidente de tráfico"
    },
    {
      "code" : "V305X",
      "display" : "V305X Conductor de vehículo motorizado de tres ruedas lesionado en colisión con peatón o animal en un accidente de tráfico"
    },
    {
      "code" : "V306X",
      "display" : "V306X Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con peatón o animal en un accidente de tráfico"
    },
    {
      "code" : "V0403",
      "display" : "V0403 Peatón en medio de transporte peatonal de micromovilidad de pie lesionado por colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico"
    },
    {
      "code" : "V04038S",
      "display" : "V04038S Peatón en otro medio de transporte peatonal de micromovilidad de pie lesionado por colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico secuela"
    },
    {
      "code" : "V165",
      "display" : "V165 Pasajero de vehículo a pedales lesionado en colisión con otro vehículo motorizado en un accidente de tráfico"
    },
    {
      "code" : "V169",
      "display" : "V169 Ciclista no especificado lesionado en colisión con otro vehículo motorizado en un accidente de tráfico"
    },
    {
      "code" : "V169XXS",
      "display" : "V169XXS Ciclista no especificado lesionado en colisión con otro vehículo motorizado en un accidente de tráfico secuela"
    },
    {
      "code" : "V2509X",
      "display" : "V2509X Conductor de otro tipo de motocicleta lesionado por colisión con tren o vehículo ferroviario en un accidente no de tráfico"
    },
    {
      "code" : "V2511X",
      "display" : "V2511X Pasajero de bicicleta eléctrica (asistida) lesionado por colisión con tren o vehículo ferroviario en un accidente no de tráfico"
    },
    {
      "code" : "V312",
      "display" : "V312 Persona en el exterior de vehículo motorizado de tres ruedas lesionada en colisión con vehículo a pedales en un accidente no de tráfico"
    },
    {
      "code" : "V313X",
      "display" : "V313X Ocupante no especificado de vehículo motorizado de tres ruedas lesionado en colisión con vehículo a pedales en un accidente no de tráfico"
    },
    {
      "code" : "V04131S",
      "display" : "V04131S Peatón en patinete eléctrico de pie lesionado por colisión con vehículo de transporte pesado o autobús en un accidente de tráfico secuela"
    },
    {
      "code" : "V0419XA",
      "display" : "V0419XA Peatón en otro medio de transporte lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V174XX",
      "display" : "V174XX Conductor de vehículo a pedales lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V175XXA",
      "display" : "V175XXA Pasajero de vehículo a pedales lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V2539XS",
      "display" : "V2539XS Persona que sube o baja de otro tipo de motocicleta lesionada por colisión con tren o vehículo ferroviario secuela"
    },
    {
      "code" : "V319X",
      "display" : "V319X Ocupante no especificado de vehículo motorizado de tres ruedas lesionado en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V0499X",
      "display" : "V0499X Peatón en otro medio de transporte lesionado en colisión con vehículo de transporte pesado o autobús no especificado si el accidente fue o no de tráfico"
    },
    {
      "code" : "V183XXA",
      "display" : "V183XXA Persona que sube o baja de un vehículo a pedales lesionada en un accidente de transporte sin colisión contacto inicial"
    },
    {
      "code" : "V184XXD",
      "display" : "V184XXD Conductor de vehículo a pedales lesionado en un accidente de transporte sin colisión en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V260",
      "display" : "V260 Conductor de motocicleta lesionado en colisión con otro vehículo no motorizado en un accidente no de tráfico"
    },
    {
      "code" : "V324XX",
      "display" : "V324XX Persona que entra o sale de un vehículo motorizado de tres ruedas lesionada en colisión con vehículo motorizado de dos o tres ruedas"
    },
    {
      "code" : "V051",
      "display" : "V051 Peatón lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico"
    },
    {
      "code" : "V0511",
      "display" : "V0511 Peatón sobre patines lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico"
    },
    {
      "code" : "V1919XD",
      "display" : "V1919XD Pasajero de vehículo a pedales lesionado en colisión con otro vehículo de motor en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V1920XD",
      "display" : "V1920XD Ciclista no especificado lesionado en colisión con vehículo de motor no especificado en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V2631X",
      "display" : "V2631X Persona que sube o baja de bicicleta eléctrica (asistida) lesionada por colisión con otro vehículo no motorizado"
    },
    {
      "code" : "V330X",
      "display" : "V330X Conductor de vehículo motorizado de tres ruedas lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V331XX",
      "display" : "V331XX Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V0590XA",
      "display" : "V0590XA Peatón a pie lesionado en colisión con tren o vehículo ferroviario no especificado si el accidente fue o no de tráfico contacto inicial"
    },
    {
      "code" : "V0591XS",
      "display" : "V0591XS Peatón sobre patines lesionado en colisión con tren o vehículo ferroviario no especificado si el accidente fue o no de tráfico secuela"
    },
    {
      "code" : "V1950XD",
      "display" : "V1950XD Pasajero de vehículo a pedales lesionado en colisión con vehículos motorizados no especificados en accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V196",
      "display" : "V196 Ciclista no especificado lesionado en colisión con otros vehículos motorizados y los no especificados en accidente de tráfico"
    },
    {
      "code" : "V524XX",
      "display" : "V524XX Persona que entra o sale de camioneta o furgoneta lesionada en colisión con vehículo motorizado de dos o tres ruedas"
    },
    {
      "code" : "V609",
      "display" : "V609 Ocupante no especificado de vehículo de transporte pesado lesionado en colisión con peatón o animal en un accidente de tráfico"
    },
    {
      "code" : "V61",
      "display" : "V61 Ocupante de vehículo de transporte pesado lesionado en colisión con vehículo a pedales"
    },
    {
      "code" : "V716XX",
      "display" : "V716XX Pasajero de autobús lesionado en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V717XX",
      "display" : "V717XX Persona en el exterior de autobús lesionada en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V719XX",
      "display" : "V719XX Ocupante no especificado de autobús lesionado en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V4323X",
      "display" : "V4323X Persona en exterior de coche lesionada en colisión con camioneta en un accidente no de tráfico"
    },
    {
      "code" : "V4324X",
      "display" : "V4324X Persona en exterior de coche lesionada en colisión con furgoneta en accidente no de tráfico"
    },
    {
      "code" : "V4331X",
      "display" : "V4331X Ocupante no especificado de coche lesionado en colisión con vehículo utilitario deportivo en un accidente no de tráfico"
    },
    {
      "code" : "V615XX",
      "display" : "V615XX Conductor de vehículo de transporte pesado lesionado en colisión con vehículo a pedales en un accidente de tráfico"
    },
    {
      "code" : "V627XXA",
      "display" : "V627XXA Persona en exterior del vehículo de transporte pesado lesionada en colisión con vehículo motorizado de dos o tres ruedas en accidente de tráfico contacto inicial"
    },
    {
      "code" : "V724",
      "display" : "V724 Persona embarcando o desembarcando de autobús lesionada en colisión vehículo motorizado de dos o tres ruedas"
    },
    {
      "code" : "V725",
      "display" : "V725 Conductor de autobús lesionado en colisión con vehículo motorizado de dos o tres ruedas en accidente de tráfico"
    },
    {
      "code" : "V726",
      "display" : "V726 Pasajero de autobús lesionado en colisión con vehículo motorizado de dos o tres ruedas en un accidente de tráfico"
    },
    {
      "code" : "V4343XA",
      "display" : "V4343XA Persona que sube o baja de coche lesionada en colisión con camioneta contacto inicial"
    },
    {
      "code" : "V4344XA",
      "display" : "V4344XA Persona que sube o baja de coche lesionada en colisión con furgoneta contacto inicial"
    },
    {
      "code" : "V4351X",
      "display" : "V4351X Conductor de coche lesionado en colisión con vehículo utilitario deportivo en un accidente de tráfico"
    },
    {
      "code" : "V621XXA",
      "display" : "V621XXA Pasajero de vehículo de transporte pesado lesionado en colisión con vehículo motorizado de dos o tres ruedas en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V622XXD",
      "display" : "V622XXD Persona en exterior del vehículo de transporte pesado lesionada en colisión con vehículo motorizado de dos o tres ruedas en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V633XXA",
      "display" : "V633XXA Ocupante no especificado de vehículo de transporte pesado lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V634XXD",
      "display" : "V634XXD Persona que entra o sale de vehículo de transporte pesado lesionada en colisión con coche camioneta o furgoneta contacto sucesivo"
    },
    {
      "code" : "V354X",
      "display" : "V354X Persona que entra o sale de un vehículo motorizado de tres ruedas lesionada en colisión con tren o vehículo ferroviario"
    },
    {
      "code" : "V355X",
      "display" : "V355X Conductor de vehículo motorizado de tres ruedas lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico"
    },
    {
      "code" : "V4363XA",
      "display" : "V4363XA Pasajero de coche lesionado en colisión con camioneta en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V4364XD",
      "display" : "V4364XD Pasajero de coche lesionado en colisión con furgoneta en accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V4371XA",
      "display" : "V4371XA Persona en exterior de coche lesionada en colisión con vehículo utilitario deportivo en accidente de tráfico contacto inicial"
    },
    {
      "code" : "V530XX",
      "display" : "V530XX Conductor de camioneta o furgoneta lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V531XX",
      "display" : "V531XX Pasajero de camioneta o furgoneta lesionado en colisión con coche camioneta o furgoneta en un accidente no de tráfico"
    },
    {
      "code" : "V640XXD",
      "display" : "V640XXD Conductor de vehículo de transporte pesado lesionado en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V360XXA",
      "display" : "V360XXA Conductor de vehículo motorizado de tres ruedas lesionado en colisión con otro vehículo no motorizado en un accidente no de tráfico contacto inicial"
    },
    {
      "code" : "V361XXD",
      "display" : "V361XXD Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con otro vehículo no motorizado en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V4393XS",
      "display" : "V4393XS Ocupante no especificado de coche lesionado en colisión con camioneta en un accidente de tráfico secuela"
    },
    {
      "code" : "V44",
      "display" : "V44 Ocupante de coche lesionado por colisión con vehículo de transporte pesado o autobús"
    },
    {
      "code" : "V440XXD",
      "display" : "V440XXD Conductor de coche lesionado en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V536XXD",
      "display" : "V536XXD Pasajero de camioneta o furgoneta lesionado en colisión con coche camioneta o furgoneta en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V645XXS",
      "display" : "V645XXS Conductor de vehículo de transporte pesado lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico secuela"
    },
    {
      "code" : "V647",
      "display" : "V647 Persona en el exterior de vehículo de transporte pesado lesionada en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico"
    },
    {
      "code" : "V366X",
      "display" : "V366X Pasajero de vehículo motorizado de tres ruedas lesionado en colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V367XX",
      "display" : "V367XX Persona en el exterior de vehículo motorizado de tres ruedas lesionada en colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V445XXA",
      "display" : "V445XXA Conductor de coche lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V446XXD",
      "display" : "V446XXD Pasajero de coche lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V543X",
      "display" : "V543X Ocupante no especificado de camioneta o furgoneta lesionado en colisión con vehículo de transporte pesado o autobús en un accidente no de tráfico"
    },
    {
      "code" : "V652XXS",
      "display" : "V652XXS Persona en el exterior de vehículo de transporte pesado lesionada en colisión con tren o vehículo ferroviario en un accidente no de tráfico secuela"
    },
    {
      "code" : "V373X",
      "display" : "V373X Ocupante no especificado de vehículo motorizado de tres ruedas lesionado en colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "V452X",
      "display" : "V452X Persona en el exterior de coche lesionada en colisión con tren o vehículo ferroviario en un accidente no de tráfico"
    },
    {
      "code" : "V453X",
      "display" : "V453X Ocupante no especificado de coche lesionado en colisión con tren o vehículo ferroviario en un accidente no de tráfico"
    },
    {
      "code" : "V549XXA",
      "display" : "V549XXA Ocupante no especificado de camioneta o furgoneta lesionado en colisión con vehículo de transporte pesado o autobús en un accidente de tráfico contacto inicial"
    },
    {
      "code" : "V550XXD",
      "display" : "V550XXD Conductor de camioneta o furgoneta lesionado en colisión con tren o vehículo ferroviario en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V659",
      "display" : "V659 Ocupante no especificado de vehículo de transporte pesado lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico"
    },
    {
      "code" : "V66",
      "display" : "V66 Ocupante de vehículo de transporte pesado lesionado en colisión con otro vehículo motorizado"
    },
    {
      "code" : "V379X",
      "display" : "V379X Ocupante no especificado de vehículo motorizado de tres ruedas lesionado en colisión con objeto fijo o estacionado en un accidente de tráfico"
    },
    {
      "code" : "V380X",
      "display" : "V380X Conductor de vehículo motorizado de tres ruedas lesionado en accidente de transporte sin colisión en un accidente no de tráfico"
    },
    {
      "code" : "V459XXD",
      "display" : "V459XXD Ocupante no especificado de coche lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico contacto sucesivo"
    },
    {
      "code" : "V460XXD",
      "display" : "V460XXD Conductor de coche lesionado por colisión con otro vehículo no motorizado en un accidente no de tráfico contacto sucesivo"
    },
    {
      "code" : "V556",
      "display" : "V556 Pasajero de camioneta o furgoneta lesionado en colisión con tren o vehículo ferroviario en un accidente de tráfico"
    },
    {
      "code" : "V664XX",
      "display" : "V664XX Persona que entra o sale de vehículo de transporte pesado lesionada en colisión con otro vehículo no motorizado"
    },
    {
      "code" : "V665XX",
      "display" : "V665XX Conductor de vehículo de transporte pesado lesionado en colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V384XXD",
      "display" : "V384XXD Persona que entra o sale de un vehículo motorizado de tres ruedas lesionada en accidente de transporte sin colisión contacto sucesivo"
    },
    {
      "code" : "V385XXS",
      "display" : "V385XXS Conductor de vehículo motorizado de tres ruedas lesionado en accidente de transporte sin colisión en un accidente de tráfico secuela"
    },
    {
      "code" : "V466X",
      "display" : "V466X Pasajero de coche lesionado por colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V467X",
      "display" : "V467X Persona en el exterior de coche lesionada por colisión con otro vehículo no motorizado en un accidente de tráfico"
    },
    {
      "code" : "V562XXS",
      "display" : "V562XXS Persona en el exterior de camioneta o furgoneta lesionada en colisión con otro vehículo no motorizado en un accidente no de tráfico secuela"
    },
    {
      "code" : "V671X",
      "display" : "V671X Pasajero de vehículo de transporte pesado lesionado en colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "V672X",
      "display" : "V672X Persona en el exterior de vehículo de transporte pesado lesionada en colisión con objeto fijo o estacionado en un accidente no de tráfico"
    },
    {
      "code" : "T462X1",
      "display" : "T462X1 Envenenamiento por otros fármacos antiarrítmicos accidental (no intencionado)"
    },
    {
      "code" : "T83491S",
      "display" : "T83491S Otra complicación mecánica de prótesis testicular implantada secuela"
    },
    {
      "code" : "T835",
      "display" : "T835 Infección y reacción inflamatoria debidas a prótesis implantes e injertos en aparato urinario"
    },
    {
      "code" : "T83510S",
      "display" : "T83510S Infección y reacción inflamatoria debidas a catéter de cistostomía secuela"
    },
    {
      "code" : "T83512",
      "display" : "T83512 Infección y reacción inflamatoria debidas a catéter de nefrostomía"
    },
    {
      "code" : "T85311A",
      "display" : "T85311A Fallo mecánico de prótesis de órbita del ojo izquierdo contacto inicial"
    },
    {
      "code" : "T85398S",
      "display" : "T85398S Otra complicación mecánica de otras prótesis implantes e injertos oculares secuela"
    },
    {
      "code" : "T8541XD",
      "display" : "T8541XD Fallo mecánico de prótesis e implante de la mama contacto sucesivo"
    },
    {
      "code" : "T8542XD",
      "display" : "T8542XD Desplazamiento de prótesis e implante de la mama contacto sucesivo"
    },
    {
      "code" : "T8543XD",
      "display" : "T8543XD Fuga de prótesis e implante de la mama contacto sucesivo"
    },
    {
      "code" : "T8544XA",
      "display" : "T8544XA Contractura capsular de implante mamario contacto inicial"
    },
    {
      "code" : "T7522XD",
      "display" : "T7522XD Síndrome vasoespástico traumático contacto sucesivo"
    },
    {
      "code" : "T7523XA",
      "display" : "T7523XA Vértigo por infrasonidos contacto inicial"
    },
    {
      "code" : "T7529X",
      "display" : "T7529X Otros efectos de vibración"
    },
    {
      "code" : "T7529XS",
      "display" : "T7529XS Otros efectos de vibración secuela"
    },
    {
      "code" : "T753XXA",
      "display" : "T753XXA Mareo por movimiento contacto inicial"
    },
    {
      "code" : "T754X",
      "display" : "T754X Electrocución"
    },
    {
      "code" : "T754XXD",
      "display" : "T754XXD Electrocución contacto sucesivo"
    },
    {
      "code" : "T7581X",
      "display" : "T7581X Efectos de fuerzas gravitatorias [G] anormales"
    },
    {
      "code" : "T7582",
      "display" : "T7582 Efectos de ingravidez"
    },
    {
      "code" : "T7582XD",
      "display" : "T7582XD Efectos de ingravidez contacto sucesivo"
    },
    {
      "code" : "T7589XA",
      "display" : "T7589XA Otros efectos especificados de causas externas contacto inicial"
    },
    {
      "code" : "T81599",
      "display" : "T81599 Otras complicaciones de cuerpo extraño dejado accidentalmente en el interior del cuerpo después de procedimiento no especificado"
    },
    {
      "code" : "T8160XA",
      "display" : "T8160XA Reacción aguda no especificada a sustancia ajena dejada accidentalmente durante un procedimiento contacto inicial"
    },
    {
      "code" : "T83598S",
      "display" : "T83598S Infección y reacción inflamatoria debidas a otras prótesis implantes e injertos en aparato urinario secuela"
    },
    {
      "code" : "T8362",
      "display" : "T8362 Infección y reacción inflamatoria debidas a prótesis testicular implantada"
    },
    {
      "code" : "T8369",
      "display" : "T8369 Infección y reacción inflamatoria debidas a otro tipo de prótesis implante e injerto en tracto genital"
    },
    {
      "code" : "T837",
      "display" : "T837 Complicaciones debidas a malla implantada y a otros materiales protésicos"
    },
    {
      "code" : "T85520S",
      "display" : "T85520S Desplazamiento de endoprótesis de conducto biliar secuela"
    },
    {
      "code" : "T85528",
      "display" : "T85528 Desplazamiento de otras prótesis implantes e injertos gastrointestinales"
    },
    {
      "code" : "T85590",
      "display" : "T85590 Otra complicación mecánica de endoprótesis de conducto biliar"
    },
    {
      "code" : "T85591",
      "display" : "T85591 Otra complicación mecánica de dispositivo anti-reflujo esofágico"
    },
    {
      "code" : "T85598A",
      "display" : "T85598A Otra complicación mecánica de otras prótesis implantes e injertos gastrointestinales contacto inicial"
    },
    {
      "code" : "T85610A",
      "display" : "T85610A Fallo (mecánico) de catéter de infusión craneal o espinal contacto inicial"
    },
    {
      "code" : "T7601",
      "display" : "T7601 Negligencia o abandono de adultos sospecha"
    },
    {
      "code" : "T7622XS",
      "display" : "T7622XS Abuso sexual infantil sospecha secuela"
    },
    {
      "code" : "S4441XS",
      "display" : "S4441XS Traumatismo de nervio musculocutáneo brazo derecho secuela"
    },
    {
      "code" : "T7631XA",
      "display" : "T7631XA Abuso psicológico de adultos sospecha contacto inicial"
    },
    {
      "code" : "T7632X",
      "display" : "T7632X Maltrato psicológico infantil sospecha"
    },
    {
      "code" : "T765",
      "display" : "T765 Explotación sexual forzada sospecha"
    },
    {
      "code" : "T7651XD",
      "display" : "T7651XD Explotación sexual de adulto forzada sospecha contacto sucesivo"
    },
    {
      "code" : "T7652XD",
      "display" : "T7652XD Explotación sexual infantil forzada sospecha contacto sucesivo"
    },
    {
      "code" : "T7661X",
      "display" : "T7661X Explotación laboral de adulto forzada sospecha"
    },
    {
      "code" : "T7662X",
      "display" : "T7662X Explotación laboral infantil forzada sospecha"
    },
    {
      "code" : "T81718D",
      "display" : "T81718D Complicación de otra arteria después de un procedimiento no clasificado bajo otro concepto contacto sucesivo"
    },
    {
      "code" : "T8172",
      "display" : "T8172 Complicación venosa después de un procedimiento no clasificado bajo otro concepto"
    },
    {
      "code" : "T818",
      "display" : "T818 Otras complicaciones de procedimientos no clasificados bajo otro concepto"
    },
    {
      "code" : "T8181XS",
      "display" : "T8181XS Complicación de terapia de inhalación secuela"
    },
    {
      "code" : "T8182XD",
      "display" : "T8182XD Enfisema (subcutáneo) como resultado de un procedimiento contacto sucesivo"
    },
    {
      "code" : "T83721D",
      "display" : "T83721D Exposición de malla vaginal implantada dentro de la vagina contacto sucesivo"
    },
    {
      "code" : "T83722S",
      "display" : "T83722S Exposición de malla uretral implantada dentro de la uretra secuela"
    },
    {
      "code" : "T83724",
      "display" : "T83724 Exposición de material de relleno ureteral implantado dentro del uréter"
    },
    {
      "code" : "T83728A",
      "display" : "T83728A Exposición de otro tipo de malla implantada en órgano o tejido contacto inicial"
    },
    {
      "code" : "T83729D",
      "display" : "T83729D Exposición de otros materiales protésicos en órgano o tejido circundante contacto sucesivo"
    },
    {
      "code" : "T8562",
      "display" : "T8562 Desplazamiento de otras prótesis implantes e injertos internos especificados"
    },
    {
      "code" : "T85621",
      "display" : "T85621 Desplazamiento de catéter de diálisis peritoneal"
    },
    {
      "code" : "T85622",
      "display" : "T85622 Desplazamiento de suturas permanentes"
    },
    {
      "code" : "T85623",
      "display" : "T85623 Desplazamiento de injerto de piel artificial y alodermis descelularizada"
    },
    {
      "code" : "T85624A",
      "display" : "T85624A Desplazamiento de bomba de insulina contacto inicial"
    },
    {
      "code" : "T85625A",
      "display" : "T85625A Desplazamiento de otro tipo de dispositivo implante o injerto del sistema nervioso contacto inicial"
    },
    {
      "code" : "T7802XA",
      "display" : "T7802XA Reacción anafiláctica por (debida a) mariscos (crustáceos) contacto inicial"
    },
    {
      "code" : "T7803X",
      "display" : "T7803X Shock anafiláctico por (debido a) otros peces"
    },
    {
      "code" : "T7804",
      "display" : "T7804 Reacción anafiláctica por (debida a) frutas y verduras"
    },
    {
      "code" : "T7804XS",
      "display" : "T7804XS Reacción anafiláctica por (debida a) frutas y verduras secuela"
    },
    {
      "code" : "T7805XS",
      "display" : "T7805XS Reacción anafiláctica por (debida a) frutos secos y semillas secuela"
    },
    {
      "code" : "T7806XS",
      "display" : "T7806XS Reacción anafiláctica por (debida a) aditivos alimentarios secuela"
    },
    {
      "code" : "T7807XS",
      "display" : "T7807XS Reacción anafiláctica por (debida a) leche y productos lácteos secuela"
    },
    {
      "code" : "T8202XD",
      "display" : "T8202XD Desplazamiento de prótesis valvular cardiaca contacto sucesivo"
    },
    {
      "code" : "T8203XD",
      "display" : "T8203XD Fuga de prótesis valvular cardiaca contacto sucesivo"
    },
    {
      "code" : "T8209XA",
      "display" : "T8209XA Otra complicación mecánica de prótesis valvular cardiaca contacto inicial"
    },
    {
      "code" : "T82110",
      "display" : "T82110 Fallo mecánico de electrodo cardiaco"
    },
    {
      "code" : "T82111",
      "display" : "T82111 Fallo mecánico de generador de impulsos cardiacos (batería)"
    },
    {
      "code" : "T82118A",
      "display" : "T82118A Fallo mecánico de otro dispositivo electrónico cardiaco contacto inicial"
    },
    {
      "code" : "T82119D",
      "display" : "T82119D Fallo mecánico de dispositivo electrónico cardiaco no especificado contacto sucesivo"
    },
    {
      "code" : "T8385X",
      "display" : "T8385X Estenosis debida a prótesis implantes e injertos genitourinarios"
    },
    {
      "code" : "T8386X",
      "display" : "T8386X Trombosis debida a prótesis implantes e injertos genitourinarios"
    },
    {
      "code" : "T8389",
      "display" : "T8389 Otra complicación especificada de prótesis implantes e injertos genitourinarios"
    },
    {
      "code" : "T839",
      "display" : "T839 Complicación no especificada de prótesis implantes e injertos genitourinarios"
    },
    {
      "code" : "T839XXS",
      "display" : "T839XXS Complicación no especificada de prótesis implantes e injertos genitourinarios secuela"
    },
    {
      "code" : "T85691",
      "display" : "T85691 Otra complicación mecánica de catéter de diálisis peritoneal"
    },
    {
      "code" : "T85692A",
      "display" : "T85692A Otra complicación mecánica de suturas permanentes contacto inicial"
    },
    {
      "code" : "T85693D",
      "display" : "T85693D Otra complicación mecánica de injerto de piel artificial y alodermis descelularizada contacto sucesivo"
    },
    {
      "code" : "T85695",
      "display" : "T85695 Otra complicación mecánica de otro tipo de dispositivo implante o injerto del sistema nervioso"
    },
    {
      "code" : "T85698A",
      "display" : "T85698A Otra complicación mecánica de otras prótesis implantes e injertos internos especificados contacto inicial"
    },
    {
      "code" : "T783XXS",
      "display" : "T783XXS Edema angioneurótico secuela"
    },
    {
      "code" : "T7840XA",
      "display" : "T7840XA Alergia no especificada contacto inicial"
    },
    {
      "code" : "T7841X",
      "display" : "T7841X Fenómeno de Arthus"
    },
    {
      "code" : "T7841XD",
      "display" : "T7841XD Fenómeno de Arthus contacto sucesivo"
    },
    {
      "code" : "T7849XA",
      "display" : "T7849XA Otros tipos de alergia contacto inicial"
    },
    {
      "code" : "T788X",
      "display" : "T788X Otros efectos adversos no clasificados bajo otro concepto"
    },
    {
      "code" : "T79",
      "display" : "T79 Ciertas complicaciones precoces de traumatismos no clasificados bajo otro concepto"
    },
    {
      "code" : "T790XXD",
      "display" : "T790XXD Embolia gaseosa (traumática) contacto sucesivo"
    },
    {
      "code" : "T791XX",
      "display" : "T791XX Embolia grasa (traumática)"
    },
    {
      "code" : "T791XXS",
      "display" : "T791XXS Embolia grasa (traumática) secuela"
    },
    {
      "code" : "T82198A",
      "display" : "T82198A Otra complicación mecánica de otro dispositivo electrónico cardiaco contacto inicial"
    },
    {
      "code" : "T82199D",
      "display" : "T82199D Otra complicación mecánica de dispositivo cardiaco no especificado contacto sucesivo"
    },
    {
      "code" : "T82211D",
      "display" : "T82211D Fallo mecánico de injerto de derivación de arteria coronaria contacto sucesivo"
    },
    {
      "code" : "T82212S",
      "display" : "T82212S Desplazamiento de injerto de derivación de arteria coronaria secuela"
    },
    {
      "code" : "T82218",
      "display" : "T82218 Otra complicación mecánica de injerto de derivación de arteria coronaria"
    },
    {
      "code" : "T84020A",
      "display" : "T84020A Luxación de prótesis interna de cadera derecha contacto inicial"
    },
    {
      "code" : "T84010",
      "display" : "T84010 Rotura de prótesis interna de cadera derecha"
    },
    {
      "code" : "T84022A",
      "display" : "T84022A Inestabilidad de prótesis interna de rodilla derecha contacto inicial"
    },
    {
      "code" : "T84023D",
      "display" : "T84023D Inestabilidad de prótesis interna de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "T84028S",
      "display" : "T84028S Luxación de otro tipo de prótesis interna de articulación secuela"
    },
    {
      "code" : "T8403",
      "display" : "T8403 Aflojamiento mecánico de prótesis interna de articulación"
    },
    {
      "code" : "T85733A",
      "display" : "T85733A Infección y reacción inflamatoria debidas a neuroestimulador electrónico implantado de médula espinal electrodo (cable) episodio inicial"
    },
    {
      "code" : "T85735",
      "display" : "T85735 Infección y reacción inflamatoria debidas a catéter de infusión craneal o espinal"
    },
    {
      "code" : "T85738A",
      "display" : "T85738A Infección y reacción inflamatoria debidas a otro dispositivo implante e injerto del sistema nervioso contacto inicial"
    },
    {
      "code" : "T797X",
      "display" : "T797X Enfisema subcutáneo traumático"
    },
    {
      "code" : "T797XXS",
      "display" : "T797XXS Enfisema subcutáneo traumático secuela"
    },
    {
      "code" : "T79A0XA",
      "display" : "T79A0XA Síndrome compartimental no especificado contacto inicial"
    },
    {
      "code" : "T79A11",
      "display" : "T79A11 Síndrome compartimental traumático de extremidad superior derecha"
    },
    {
      "code" : "T79A12A",
      "display" : "T79A12A Síndrome compartimental traumático de extremidad superior izquierda contacto inicial"
    },
    {
      "code" : "T79A19D",
      "display" : "T79A19D Síndrome compartimental traumático de extremidad superior no especificada contacto sucesivo"
    },
    {
      "code" : "T79A21D",
      "display" : "T79A21D Síndrome compartimental traumático de extremidad inferior derecha contacto sucesivo"
    },
    {
      "code" : "T79A22S",
      "display" : "T79A22S Síndrome compartimental traumático de extremidad inferior izquierda secuela"
    },
    {
      "code" : "T82311S",
      "display" : "T82311S Fallo mecánico de injerto de arteria carótida (derivación) secuela"
    },
    {
      "code" : "T82312S",
      "display" : "T82312S Fallo mecánico de injerto de arteria femoral (derivación) secuela"
    },
    {
      "code" : "T82318S",
      "display" : "T82318S Fallo mecánico de otros injertos vasculares secuela"
    },
    {
      "code" : "T8232",
      "display" : "T8232 Desplazamiento de otros injertos vasculares"
    },
    {
      "code" : "T82320S",
      "display" : "T82320S Desplazamiento de injerto (de sustitución) aórtico (de bifurcación) secuela"
    },
    {
      "code" : "T82322",
      "display" : "T82322 Desplazamiento de injerto de arteria femoral (derivación)"
    },
    {
      "code" : "T84051",
      "display" : "T84051 Osteolisis periprotésica de prótesis interna de articulación de cadera izquierda"
    },
    {
      "code" : "T84052",
      "display" : "T84052 Osteolisis periprotésica de prótesis interna de articulación de rodilla derecha"
    },
    {
      "code" : "T84053A",
      "display" : "T84053A Osteolisis periprotésica de prótesis interna de articulación de rodilla izquierda contacto inicial"
    },
    {
      "code" : "T84058S",
      "display" : "T84058S Osteolisis periprotésica de otras prótesis internas de articulación secuela"
    },
    {
      "code" : "T85830",
      "display" : "T85830 Hemorragia debida a prótesis implantes e injertos del sistema nervioso"
    },
    {
      "code" : "T85838",
      "display" : "T85838 Hemorragia debida a otras prótesis implantes e injertos internos"
    },
    {
      "code" : "T85840",
      "display" : "T85840 Dolor debido a prótesis implantes e injertos del sistema nervioso"
    },
    {
      "code" : "T85848",
      "display" : "T85848 Dolor debido a otras prótesis implantes e injertos internos"
    },
    {
      "code" : "T85850",
      "display" : "T85850 Estenosis debida a prótesis implantes e injertos del sistema nervioso"
    },
    {
      "code" : "T800",
      "display" : "T800 Embolia gaseosa después de infusión transfusión e inyección terapéutica"
    },
    {
      "code" : "T800XXD",
      "display" : "T800XXD Embolia gaseosa después de infusión transfusión e inyección terapéutica contacto sucesivo"
    },
    {
      "code" : "T801XXD",
      "display" : "T801XXD Complicaciones vasculares después de infusión transfusión e inyección terapéutica contacto sucesivo"
    },
    {
      "code" : "T80211D",
      "display" : "T80211D Infección del torrente sanguíneo por (debida a) catéter venoso central contacto sucesivo"
    },
    {
      "code" : "T80218",
      "display" : "T80218 Otra infección por (debida a) catéter venoso central"
    },
    {
      "code" : "T82339A",
      "display" : "T82339A Fuga de injerto vascular no especificado contacto inicial"
    },
    {
      "code" : "T82390",
      "display" : "T82390 Otra complicación mecánica de injerto (de sustitución) aórtico (de bifurcación)"
    },
    {
      "code" : "T82391",
      "display" : "T82391 Otra complicación mecánica de injerto de arteria carótida (derivación)"
    },
    {
      "code" : "T82392A",
      "display" : "T82392A Otra complicación mecánica de injerto de arteria femoral (derivación) contacto inicial"
    },
    {
      "code" : "T82398S",
      "display" : "T82398S Otra complicación mecánica de otros injertos vasculares secuela"
    },
    {
      "code" : "T82399S",
      "display" : "T82399S Otra complicación mecánica de injertos vasculares no especificados secuela"
    },
    {
      "code" : "T8409",
      "display" : "T8409 Otra complicación mecánica de prótesis interna de articulación"
    },
    {
      "code" : "T84091",
      "display" : "T84091 Otra complicación mecánica de prótesis interna de articulación de cadera izquierda"
    },
    {
      "code" : "T84092A",
      "display" : "T84092A Otra complicación mecánica de prótesis interna de rodilla derecha contacto inicial"
    },
    {
      "code" : "T84093D",
      "display" : "T84093D Otra complicación mecánica de prótesis interna de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "T859XX",
      "display" : "T859XX Complicación no especificada de prótesis implante e injerto internos"
    },
    {
      "code" : "T860",
      "display" : "T860 Complicaciones de trasplante de médula ósea"
    },
    {
      "code" : "T8603",
      "display" : "T8603 Infección de trasplante de médula ósea"
    },
    {
      "code" : "T8611",
      "display" : "T8611 Rechazo de trasplante renal"
    },
    {
      "code" : "T8619",
      "display" : "T8619 Otra complicación de trasplante de riñón"
    },
    {
      "code" : "T8622",
      "display" : "T8622 Fracaso de trasplante cardiaco"
    },
    {
      "code" : "T86298",
      "display" : "T86298 Otras complicaciones de trasplante de corazón"
    },
    {
      "code" : "T8632",
      "display" : "T8632 Fracaso de trasplante corazón-pulmón"
    },
    {
      "code" : "T80311D",
      "display" : "T80311D Reacción de incompatibilidad ABO con reacción hemolítica postransfusional retardada contacto sucesivo"
    },
    {
      "code" : "T80319D",
      "display" : "T80319D Reacción de incompatibilidad ABO con reacción hemolítica trasfusional no especificada contacto sucesivo"
    },
    {
      "code" : "T8039XS",
      "display" : "T8039XS Otra reacción de incompatibilidad ABO debida a transfusión de sangre o de hemoderivados secuela"
    },
    {
      "code" : "T8040XS",
      "display" : "T8040XS Reacción de incompatibilidad Rh debida a transfusión de sangre o de hemoderivados no especificada secuela"
    },
    {
      "code" : "T82511D",
      "display" : "T82511D Fallo mecánico de derivación arteriovenosa creada quirúrgicamente contacto sucesivo"
    },
    {
      "code" : "T82512S",
      "display" : "T82512S Fallo mecánico de corazón artificial secuela"
    },
    {
      "code" : "T82514",
      "display" : "T82514 Fallo mecánico de catéter de infusión"
    },
    {
      "code" : "T82514S",
      "display" : "T82514S Fallo mecánico de catéter de infusión secuela"
    },
    {
      "code" : "T82518",
      "display" : "T82518 Fallo mecánico de otros dispositivos e implantes cardiacos y vasculares"
    },
    {
      "code" : "T82519A",
      "display" : "T82519A Fallo mecánico de dispositivos e implantes cardiacos y vasculares no especificados contacto inicial"
    },
    {
      "code" : "T84114D",
      "display" : "T84114D Fallo mecánico de dispositivo de fijación interna de fémur derecho contacto sucesivo"
    },
    {
      "code" : "T84115S",
      "display" : "T84115S Fallo mecánico de dispositivo de fijación interna de fémur izquierdo secuela"
    },
    {
      "code" : "T84117",
      "display" : "T84117 Fallo mecánico de dispositivo de fijación interna de hueso de parte inferior de la pierna izquierda"
    },
    {
      "code" : "T84119D",
      "display" : "T84119D Fallo mecánico de dispositivo de fijación interna de hueso de extremidad no especificada contacto sucesivo"
    },
    {
      "code" : "T868401",
      "display" : "T868401 Rechazo de trasplante de córnea ojo derecho"
    },
    {
      "code" : "T86841",
      "display" : "T86841 Fracaso de trasplante de córnea"
    },
    {
      "code" : "T868419",
      "display" : "T868419 Fracaso de trasplante de córnea ojo no especificado"
    },
    {
      "code" : "T868423",
      "display" : "T868423 Infección de trasplante de córnea bilateral"
    },
    {
      "code" : "T868482",
      "display" : "T868482 Otras complicaciones de trasplante de córnea ojo izquierdo"
    },
    {
      "code" : "T868492",
      "display" : "T868492 Complicación no especificada de trasplante de córnea ojo izquierdo"
    },
    {
      "code" : "T86850",
      "display" : "T86850 Rechazo de trasplante intestinal"
    },
    {
      "code" : "T86859",
      "display" : "T86859 Complicación no especificada de trasplante intestinal"
    },
    {
      "code" : "T86892",
      "display" : "T86892 Infección de otro tipo de tejido trasplantado"
    },
    {
      "code" : "T80A10S",
      "display" : "T80A10S Reacción de incompatibilidad No-ABO con reacción hemolítica postransfusional aguda secuela"
    },
    {
      "code" : "T80A19",
      "display" : "T80A19 Reacción de incompatibilidad No-ABO con reacción hemolítica trasfusional no especificada"
    },
    {
      "code" : "T80A9XA",
      "display" : "T80A9XA Otra reacción de incompatibilidad No-ABO debida a transfusión de sangre o de hemoderivados contacto inicial"
    },
    {
      "code" : "T82528A",
      "display" : "T82528A Desplazamiento de otros dispositivos e implantes cardiacos y vasculares contacto inicial"
    },
    {
      "code" : "V6940X",
      "display" : "V6940X Conductor de vehículo de transporte pesado lesionado en colisión con vehículos motorizados no especificados en accidente de tráfico"
    },
    {
      "code" : "S4343",
      "display" : "S4343 Lesión de rodete (labrum) glenoideo"
    },
    {
      "code" : "S43431S",
      "display" : "S43431S Lesión de rodete (labrum) glenoideo del hombro derecho secuela"
    },
    {
      "code" : "S43432S",
      "display" : "S43432S Lesión de rodete (labrum) glenoideo del hombro izquierdo secuela"
    },
    {
      "code" : "S46811S",
      "display" : "S46811S Distensión de otros músculos fascias y tendones a nivel del hombro y brazo lado derecho secuela"
    },
    {
      "code" : "S46819A",
      "display" : "S46819A Distensión de otros músculos fascias y tendones a nivel del hombro y brazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S46821D",
      "display" : "S46821D Desgarro de otros músculos fascias y tendones a nivel del hombro y brazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S42261A",
      "display" : "S42261A Fractura desplazada de tuberosidad menor de húmero derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42261P",
      "display" : "S42261P Fractura desplazada de tuberosidad menor de húmero derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42262G",
      "display" : "S42262G Fractura desplazada de tuberosidad menor de húmero izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42443A",
      "display" : "S42443A Fractura desplazada (avulsión) de epitróclea de húmero no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42444",
      "display" : "S42444 Fractura sin desplazamiento (por avulsión) de epicóndilo medial (epitróclea) de húmero derecho"
    },
    {
      "code" : "S4351XA",
      "display" : "S4351XA Esguince de articulación acromioclavicular derecha contacto inicial"
    },
    {
      "code" : "S4352XA",
      "display" : "S4352XA Esguince de articulación acromioclavicular izquierda contacto inicial"
    },
    {
      "code" : "S4360X",
      "display" : "S4360X Esguince de articulación esternoclavicular no especificada"
    },
    {
      "code" : "S4361",
      "display" : "S4361 Esguince de articulación esternoclavicular derecha"
    },
    {
      "code" : "S4362",
      "display" : "S4362 Esguince de articulación esternoclavicular izquierda"
    },
    {
      "code" : "S4362XS",
      "display" : "S4362XS Esguince de articulación esternoclavicular izquierda secuela"
    },
    {
      "code" : "S4380XA",
      "display" : "S4380XA Esguince de otras partes especificadas de cintura escapular no especificada contacto inicial"
    },
    {
      "code" : "S46902",
      "display" : "S46902 Traumatismo no especificado de músculo fascia y tendón no especificados a nivel de hombro y brazo brazo izquierdo"
    },
    {
      "code" : "S46909S",
      "display" : "S46909S Traumatismo no especificado de músculo fascia y tendón no especificados a nivel de hombro y brazo brazo no especificado secuela"
    },
    {
      "code" : "S46912",
      "display" : "S46912 Distensión de músculo fascia y tendón no especificados a nivel del hombro y brazo lado izquierdo"
    },
    {
      "code" : "S42266K",
      "display" : "S42266K Fractura sin desplazamiento de tuberosidad menor de húmero no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42271G",
      "display" : "S42271G Fractura en rodete de extremo superior de húmero derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42448A",
      "display" : "S42448A Fractura incarcerada (avulsión) de epicóndilo medial (epitróclea) de húmero izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42448S",
      "display" : "S42448S Fractura incarcerada (avulsión) de epicóndilo medial (epitróclea) de húmero izquierdo secuela"
    },
    {
      "code" : "S52124E",
      "display" : "S52124E Fractura sin desplazamiento de la cabeza de radio derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S52124N",
      "display" : "S52124N Fractura sin desplazamiento de la cabeza de radio derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52125B",
      "display" : "S52125B Fractura sin desplazamiento de la cabeza de radio izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52243F",
      "display" : "S52243F Fractura espiroidea desplazada de diáfisis de cúbito extremidad superior no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52333B",
      "display" : "S52333B Fractura oblicua desplazada de diáfisis de radio no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52333H",
      "display" : "S52333H Fractura oblicua desplazada de diáfisis de radio no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S51859D",
      "display" : "S51859D Mordedura abierta de antebrazo no especificado contacto sucesivo"
    },
    {
      "code" : "S5200",
      "display" : "S5200 Fractura no especificada de extremo superior de cúbito"
    },
    {
      "code" : "S52001D",
      "display" : "S52001D Fractura no especificada de extremo superior de cúbito derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52001K",
      "display" : "S52001K Fractura no especificada de extremo superior de cúbito derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S52245H",
      "display" : "S52245H Fractura espiroidea sin desplazamiento de diáfisis de cúbito extremidad superior izquierda contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52253C",
      "display" : "S52253C Fractura conminuta desplazada de diáfisis de cúbito extremidad superior no especificada contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52335F",
      "display" : "S52335F Fractura oblicua sin desplazamiento de diáfisis de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52335Q",
      "display" : "S52335Q Fractura oblicua sin desplazamiento de diáfisis de radio izquierdo contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S52009E",
      "display" : "S52009E Fractura no especificada de extremo superior de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S52009N",
      "display" : "S52009N Fractura no especificada de extremo superior de cúbito no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52251H",
      "display" : "S52251H Fractura conminuta desplazada de diáfisis de cúbito extremidad superior derecha contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52255C",
      "display" : "S52255C Fractura conminuta sin desplazamiento de diáfisis de cúbito extremidad superior izquierda contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S49011G",
      "display" : "S49011G Fractura fisaria tipo I de Salter-Harris de extremo superior de húmero extremidad superior derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S49001",
      "display" : "S49001 Fractura fisaria no especificada de extremo superior de húmero extremidad superior derecha"
    },
    {
      "code" : "S52021F",
      "display" : "S52021F Fractura desplazada de olécranon sin extensión intraarticular de cúbito derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52126N",
      "display" : "S52126N Fractura sin desplazamiento de la cabeza de radio no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52131A",
      "display" : "S52131A Fractura desplazada del cuello de radio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S5226",
      "display" : "S5226 Fractura segmentaria de diáfisis de cúbito"
    },
    {
      "code" : "S49029D",
      "display" : "S49029D Fractura fisaria tipo II de Salter-Harris de extremo superior de húmero extremidad superior no especificada contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S49031D",
      "display" : "S49031D Fractura fisaria tipo III de Salter-Harris de extremo superior de húmero extremidad superior derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S52023F",
      "display" : "S52023F Fractura desplazada de olécranon sin extensión intraarticular de cúbito no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52132R",
      "display" : "S52132R Fractura desplazada del cuello de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S52133D",
      "display" : "S52133D Fractura desplazada del cuello de radio no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52262P",
      "display" : "S52262P Fractura segmentaria desplazada de diáfisis de cúbito extremidad superior izquierda contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S49042S",
      "display" : "S49042S Fractura fisaria tipo IV de Salter-Harris de extremo superior de húmero extremidad superior izquierda secuela"
    },
    {
      "code" : "S52025H",
      "display" : "S52025H Fractura sin desplazamiento de olécranon sin extensión intraarticular de cúbito izquierdo contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52135B",
      "display" : "S52135B Fractura sin desplazamiento del cuello de radio izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52135J",
      "display" : "S52135J Fractura sin desplazamiento del cuello de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S56299",
      "display" : "S56299 Otro traumatismo de otro músculo fascia y tendón flexor a nivel de antebrazo brazo no especificado"
    },
    {
      "code" : "S5630",
      "display" : "S5630 Traumatismo no especificado de músculos fascias y tendones extensores o abductores de pulgar a nivel de antebrazo"
    },
    {
      "code" : "S52363",
      "display" : "S52363 Fractura segmentaria desplazada de diáfisis de radio extremidad superior no especificada"
    },
    {
      "code" : "S52569M",
      "display" : "S52569M Fractura de Barton de radio no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S5257",
      "display" : "S5257 Otro tipo de fractura intraarticular de extremo inferior de radio"
    },
    {
      "code" : "S52571D",
      "display" : "S52571D Otro tipo de fractura intraarticular de extremo inferior de radio derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S5321XS",
      "display" : "S5321XS Rotura traumática de ligamento colateral radial derecho secuela"
    },
    {
      "code" : "S5322XS",
      "display" : "S5322XS Rotura traumática de ligamento colateral radial izquierdo secuela"
    },
    {
      "code" : "S5330XA",
      "display" : "S5330XA Rotura traumática de ligamento colateral cubital no especificado contacto inicial"
    },
    {
      "code" : "S5331XD",
      "display" : "S5331XD Rotura traumática de ligamento colateral cubital derecho contacto sucesivo"
    },
    {
      "code" : "S5332XD",
      "display" : "S5332XD Rotura traumática de ligamento colateral cubital izquierdo contacto sucesivo"
    },
    {
      "code" : "S53401A",
      "display" : "S53401A Esguince no especificado de codo derecho contacto inicial"
    },
    {
      "code" : "S56321",
      "display" : "S56321 Desgarro de músculos fascias y tendones extensores o abductores de pulgar derecho a nivel de antebrazo"
    },
    {
      "code" : "S56322D",
      "display" : "S56322D Desgarro de músculos fascias y tendones extensores o abductores de pulgar izquierdo a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S56391",
      "display" : "S56391 Otro traumatismo de músculos fascias y tendones extensores o abductores de pulgar derecho a nivel de antebrazo"
    },
    {
      "code" : "S52365",
      "display" : "S52365 Fractura segmentaria sin desplazamiento de diáfisis de radio extremidad superior izquierda"
    },
    {
      "code" : "S52579B",
      "display" : "S52579B Otro tipo de fractura intraarticular de extremo inferior de radio no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S53422A",
      "display" : "S53422A Esguince (de articulación) humerocubital de codo izquierdo contacto inicial"
    },
    {
      "code" : "S53401S",
      "display" : "S53401S Esguince no especificado de codo derecho secuela"
    },
    {
      "code" : "S53431",
      "display" : "S53431 Esguince del ligamento colateral radial de codo derecho"
    },
    {
      "code" : "S53432A",
      "display" : "S53432A Esguince del ligamento colateral radial de codo izquierdo contacto inicial"
    },
    {
      "code" : "S53439D",
      "display" : "S53439D Esguince del ligamento colateral radial de codo no especificado contacto sucesivo"
    },
    {
      "code" : "S53441D",
      "display" : "S53441D Esguince de ligamento colateral cubital de codo derecho contacto sucesivo"
    },
    {
      "code" : "S56405",
      "display" : "S56405 Traumatismo no especificado de músculo fascia y tendón extensor de dedo anular derecho a nivel de antebrazo"
    },
    {
      "code" : "S56406D",
      "display" : "S56406D Traumatismo no especificado de músculo fascia y tendón extensor de dedo anular izquierdo a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S52366M",
      "display" : "S52366M Fractura segmentaria sin desplazamiento de diáfisis de radio extremidad superior no especificada contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S52591S",
      "display" : "S52591S Otras fracturas de extremo inferior de radio derecho secuela"
    },
    {
      "code" : "S52592D",
      "display" : "S52592D Otras fracturas de extremo inferior de radio izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S5401",
      "display" : "S5401 Traumatismo de nervio cubital a nivel de antebrazo lado derecho"
    },
    {
      "code" : "S5401XS",
      "display" : "S5401XS Traumatismo de nervio cubital a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S5402XS",
      "display" : "S5402XS Traumatismo de nervio cubital a nivel de antebrazo lado izquierdo secuela"
    },
    {
      "code" : "S52264K",
      "display" : "S52264K Fractura segmentaria sin desplazamiento de diáfisis de cúbito extremidad superior derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S491",
      "display" : "S491 Fractura fisaria de extremo inferior de húmero"
    },
    {
      "code" : "S49101D",
      "display" : "S49101D Fractura fisaria no especificada de extremo inferior de húmero extremidad superior derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S49102D",
      "display" : "S49102D Fractura fisaria no especificada de extremo inferior de húmero extremidad superior izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S52031F",
      "display" : "S52031F Fractura desplazada de olécranon con extensión intraarticular de cúbito derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52181G",
      "display" : "S52181G Otra fractura de extremo superior de radio derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52181P",
      "display" : "S52181P Otra fractura de extremo superior de radio derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S52266N",
      "display" : "S52266N Fractura segmentaria sin desplazamiento de diáfisis de cúbito extremidad superior no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S49119D",
      "display" : "S49119D Fractura fisaria tipo I de Salter-Harris de extremo inferior de húmero extremidad superior no especificada contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S52033A",
      "display" : "S52033A Fractura desplazada de olécranon con extensión intraarticular de cúbito no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52189N",
      "display" : "S52189N Otra fractura de extremo superior de radio no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52201A",
      "display" : "S52201A Fractura no especificada de diáfisis de cúbito derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52272G",
      "display" : "S52272G Fractura de Monteggia de cúbito izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52272Q",
      "display" : "S52272Q Fractura de Monteggia de cúbito izquierdo contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S49132",
      "display" : "S49132 Fractura fisaria tipo III de Salter-Harris de extremo inferior de húmero extremidad superior izquierda"
    },
    {
      "code" : "S49132P",
      "display" : "S49132P Fractura fisaria tipo III de Salter-Harris de extremo inferior de húmero extremidad superior izquierda contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S52035B",
      "display" : "S52035B Fractura sin desplazamiento de olécranon con extensión intraarticular de cúbito izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52202S",
      "display" : "S52202S Fractura no especificada de diáfisis de cúbito izquierdo secuela"
    },
    {
      "code" : "S52209D",
      "display" : "S52209D Fractura no especificada de diáfisis de cúbito no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52281Q",
      "display" : "S52281Q Arqueamiento óseo de cúbito derecho contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S52282C",
      "display" : "S52282C Arqueamiento óseo de cúbito izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S49149S",
      "display" : "S49149S Fractura fisaria tipo IV de Salter-Harris de extremo inferior de húmero extremidad superior no especificada secuela"
    },
    {
      "code" : "S52036S",
      "display" : "S52036S Fractura sin desplazamiento de olécranon con extensión intraarticular de cúbito no especificado secuela"
    },
    {
      "code" : "S52219K",
      "display" : "S52219K Fractura en tallo verde de diáfisis de cúbito no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S52221B",
      "display" : "S52221B Fractura transversa desplazada de diáfisis de cúbito derecho contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S5229",
      "display" : "S5229 Otra fractura de diáfisis de cúbito"
    },
    {
      "code" : "S52291C",
      "display" : "S52291C Otra fractura de diáfisis de cúbito derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52291H",
      "display" : "S52291H Otra fractura de diáfisis de cúbito derecho contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S4981XA",
      "display" : "S4981XA Otros traumatismos especificados del hombro y brazo derechos contacto inicial"
    },
    {
      "code" : "S4982XA",
      "display" : "S4982XA Otros traumatismos especificados de hombro y brazo izquierdos contacto inicial"
    },
    {
      "code" : "S4990X",
      "display" : "S4990X Traumatismo no especificado del hombro y brazo brazo no especificado"
    },
    {
      "code" : "S4991X",
      "display" : "S4991X Traumatismo no especificado del hombro y brazo derechos"
    },
    {
      "code" : "S4992",
      "display" : "S4992 Traumatismo no especificado del hombro y brazo izquierdos"
    },
    {
      "code" : "S52042R",
      "display" : "S52042R Fractura desplazada de apófisis coronoides de cúbito izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S52223A",
      "display" : "S52223A Fractura transversa desplazada de diáfisis de cúbito no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52223G",
      "display" : "S52223G Fractura transversa desplazada de diáfisis de cúbito no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52299G",
      "display" : "S52299G Otra fractura de diáfisis de cúbito no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52299P",
      "display" : "S52299P Otra fractura de diáfisis de cúbito no especificado contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S52301A",
      "display" : "S52301A Fractura no especificada de diáfisis de radio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S5011X",
      "display" : "S5011X Contusión de antebrazo derecho"
    },
    {
      "code" : "S5012",
      "display" : "S5012 Contusión de antebrazo izquierdo"
    },
    {
      "code" : "S5012XD",
      "display" : "S5012XD Contusión de antebrazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S50311A",
      "display" : "S50311A Abrasión de codo derecho contacto inicial"
    },
    {
      "code" : "S50312A",
      "display" : "S50312A Abrasión de codo izquierdo contacto inicial"
    },
    {
      "code" : "S50319A",
      "display" : "S50319A Abrasión de codo no especificado contacto inicial"
    },
    {
      "code" : "S50321",
      "display" : "S50321 Ampolla (no térmica) de codo derecho"
    },
    {
      "code" : "S50322",
      "display" : "S50322 Ampolla (no térmica) de codo izquierdo"
    },
    {
      "code" : "S50329",
      "display" : "S50329 Ampolla (no térmica) de codo no especificado"
    },
    {
      "code" : "S5034",
      "display" : "S5034 Constricción externa de codo"
    },
    {
      "code" : "S52044S",
      "display" : "S52044S Fractura sin desplazamiento de apófisis coronoides de cúbito derecho secuela"
    },
    {
      "code" : "S52045D",
      "display" : "S52045D Fractura sin desplazamiento de apófisis coronoides de cúbito izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52225D",
      "display" : "S52225D Fractura transversa sin desplazamiento de diáfisis de cúbito izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52302N",
      "display" : "S52302N Fractura no especificada de diáfisis de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52309B",
      "display" : "S52309B Fractura no especificada de diáfisis de radio no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S50361D",
      "display" : "S50361D Picadura de insecto (no venenoso) en codo derecho contacto sucesivo"
    },
    {
      "code" : "S50362D",
      "display" : "S50362D Picadura de insecto (no venenoso) en codo izquierdo contacto sucesivo"
    },
    {
      "code" : "S50341A",
      "display" : "S50341A Constricción externa de codo derecho contacto inicial"
    },
    {
      "code" : "S50371D",
      "display" : "S50371D Otra mordedura superficial de codo derecho contacto sucesivo"
    },
    {
      "code" : "S50372D",
      "display" : "S50372D Otra mordedura superficial de codo izquierdo contacto sucesivo"
    },
    {
      "code" : "S50379S",
      "display" : "S50379S Otra mordedura superficial de codo no especificado secuela"
    },
    {
      "code" : "S50811A",
      "display" : "S50811A Abrasión de antebrazo derecho contacto inicial"
    },
    {
      "code" : "S50812D",
      "display" : "S50812D Abrasión de antebrazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S52091",
      "display" : "S52091 Otra fractura de extremo superior de cúbito derecho"
    },
    {
      "code" : "S52091D",
      "display" : "S52091D Otra fractura de extremo superior de cúbito derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52231A",
      "display" : "S52231A Fractura oblicua desplazada de diáfisis de cúbito derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52231G",
      "display" : "S52231G Fractura oblicua desplazada de diáfisis de cúbito derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52319P",
      "display" : "S52319P Fractura en tallo verde de diáfisis de radio extremidad superior no especificada contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S52321D",
      "display" : "S52321D Fractura transversa desplazada de diáfisis de radio derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S50842S",
      "display" : "S50842S Constricción externa de antebrazo izquierdo secuela"
    },
    {
      "code" : "S50849S",
      "display" : "S50849S Constricción externa de antebrazo no especificado secuela"
    },
    {
      "code" : "S50851D",
      "display" : "S50851D Cuerpo extraño superficial de antebrazo derecho contacto sucesivo"
    },
    {
      "code" : "S50852S",
      "display" : "S50852S Cuerpo extraño superficial de antebrazo izquierdo secuela"
    },
    {
      "code" : "S5086",
      "display" : "S5086 Picadura de insecto (no venenoso) en antebrazo"
    },
    {
      "code" : "S50861S",
      "display" : "S50861S Picadura de insecto (no venenoso) en antebrazo derecho secuela"
    },
    {
      "code" : "S50862S",
      "display" : "S50862S Picadura de insecto (no venenoso) en antebrazo izquierdo secuela"
    },
    {
      "code" : "S52092R",
      "display" : "S52092R Otra fractura de extremo superior de cúbito izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S52099E",
      "display" : "S52099E Otra fractura de extremo superior de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S52233H",
      "display" : "S52233H Fractura oblicua desplazada de diáfisis de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52322P",
      "display" : "S52322P Fractura transversa desplazada de diáfisis de radio izquierdo contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S52323B",
      "display" : "S52323B Fractura transversa desplazada de diáfisis de radio no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S50909S",
      "display" : "S50909S Traumatismo superficial no especificado de codo no especificado secuela"
    },
    {
      "code" : "S50911S",
      "display" : "S50911S Traumatismo superficial no especificado de antebrazo derecho secuela"
    },
    {
      "code" : "S50919",
      "display" : "S50919 Traumatismo superficial no especificado de antebrazo no especificado"
    },
    {
      "code" : "S51",
      "display" : "S51 Herida abierta de codo y antebrazo"
    },
    {
      "code" : "S51001",
      "display" : "S51001 Herida abierta no especificada de codo derecho"
    },
    {
      "code" : "S51002",
      "display" : "S51002 Herida abierta no especificada de codo izquierdo"
    },
    {
      "code" : "S51009",
      "display" : "S51009 Herida abierta no especificada de codo no especificado"
    },
    {
      "code" : "S52101R",
      "display" : "S52101R Fractura no especificada de extremo superior de radio derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S52102E",
      "display" : "S52102E Fractura no especificada de extremo superior de radio izquierdo contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S52235D",
      "display" : "S52235D Fractura oblicua sin desplazamiento de diáfisis de cúbito izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52235M",
      "display" : "S52235M Fractura oblicua sin desplazamiento de diáfisis de cúbito izquierdo contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S52325D",
      "display" : "S52325D Fractura transversa sin desplazamiento de diáfisis de radio izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S5103",
      "display" : "S5103 Herida punzante sin cuerpo extraño de codo"
    },
    {
      "code" : "S51031S",
      "display" : "S51031S Herida punzante sin cuerpo extraño de codo derecho secuela"
    },
    {
      "code" : "S51039",
      "display" : "S51039 Herida punzante sin cuerpo extraño de codo no especificado"
    },
    {
      "code" : "S51039S",
      "display" : "S51039S Herida punzante sin cuerpo extraño de codo no especificado secuela"
    },
    {
      "code" : "S51041S",
      "display" : "S51041S Herida punzante con cuerpo extraño de codo derecho secuela"
    },
    {
      "code" : "S51042S",
      "display" : "S51042S Herida punzante con cuerpo extraño de codo izquierdo secuela"
    },
    {
      "code" : "S5105",
      "display" : "S5105 Mordedura abierta de codo"
    },
    {
      "code" : "S51051D",
      "display" : "S51051D Mordedura abierta de codo derecho contacto sucesivo"
    },
    {
      "code" : "S52111A",
      "display" : "S52111A Fractura en rodete de extremo superior de radio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52112",
      "display" : "S52112 Fractura en rodete de extremo superior de radio izquierdo"
    },
    {
      "code" : "S52112K",
      "display" : "S52112K Fractura en rodete de extremo superior de radio izquierdo contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S52241N",
      "display" : "S52241N Fractura espiroidea desplazada de diáfisis de cúbito extremidad superior derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S52331",
      "display" : "S52331 Fractura oblicua desplazada de diáfisis de radio derecho"
    },
    {
      "code" : "S52331D",
      "display" : "S52331D Fractura oblicua desplazada de diáfisis de radio derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S51812",
      "display" : "S51812 Desgarro sin cuerpo extraño de antebrazo izquierdo"
    },
    {
      "code" : "S51819",
      "display" : "S51819 Desgarro sin cuerpo extraño de antebrazo no especificado"
    },
    {
      "code" : "S51821",
      "display" : "S51821 Desgarro con cuerpo extraño de antebrazo derecho"
    },
    {
      "code" : "S51821S",
      "display" : "S51821S Desgarro con cuerpo extraño de antebrazo derecho secuela"
    },
    {
      "code" : "S51822S",
      "display" : "S51822S Desgarro con cuerpo extraño de antebrazo izquierdo secuela"
    },
    {
      "code" : "S5183",
      "display" : "S5183 Herida punzante sin cuerpo extraño de antebrazo"
    },
    {
      "code" : "S51831S",
      "display" : "S51831S Herida punzante sin cuerpo extraño de antebrazo derecho secuela"
    },
    {
      "code" : "S52122F",
      "display" : "S52122F Fractura desplazada de la cabeza de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52122P",
      "display" : "S52122P Fractura desplazada de la cabeza de radio izquierdo contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S5652",
      "display" : "S5652 Desgarro de otro músculo fascia y tendón extensor a nivel de antebrazo"
    },
    {
      "code" : "S56521S",
      "display" : "S56521S Desgarro de otro músculo fascia y tendón extensor a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S56529A",
      "display" : "S56529A Desgarro de otro músculo fascia y tendón extensor a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S52399Q",
      "display" : "S52399Q Otra fractura de diáfisis de radio brazo no especificado contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S52501A",
      "display" : "S52501A Fractura no especificada de extremo inferior de radio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52392D",
      "display" : "S52392D Otra fractura de diáfisis de radio brazo izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52614H",
      "display" : "S52614H Fractura sin desplazamiento de apófisis estiloides del cúbito derecho contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S55112D",
      "display" : "S55112D Desgarro de arteria radial a nivel de antebrazo lado izquierdo contacto sucesivo"
    },
    {
      "code" : "S55119S",
      "display" : "S55119S Desgarro de arteria radial a nivel de antebrazo brazo no especificado secuela"
    },
    {
      "code" : "S55191S",
      "display" : "S55191S Otro traumatismo especificado de arteria radial a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S55199A",
      "display" : "S55199A Otro traumatismo especificado de arteria radial a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S56809S",
      "display" : "S56809S Traumatismo no especificado de otros músculos fascias y tendones a nivel de antebrazo brazo no especificado secuela"
    },
    {
      "code" : "S56812",
      "display" : "S56812 Distensión de otros músculos fascias y tendones a nivel de antebrazo lado izquierdo"
    },
    {
      "code" : "S56819A",
      "display" : "S56819A Distensión de otros músculos fascias y tendones a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S52509B",
      "display" : "S52509B Fractura no especificada de extremo inferior de radio no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52509H",
      "display" : "S52509H Fractura no especificada de extremo inferior de radio no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52616M",
      "display" : "S52616M Fractura sin desplazamiento de apófisis estiloides de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S55291S",
      "display" : "S55291S Otro traumatismo especificado de vena a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S55299",
      "display" : "S55299 Otro traumatismo especificado de vena a nivel de antebrazo brazo no especificado"
    },
    {
      "code" : "S5580",
      "display" : "S5580 Traumatismo no especificado de otros vasos sanguíneos a nivel de antebrazo"
    },
    {
      "code" : "S55801S",
      "display" : "S55801S Traumatismo no especificado de otros vasos sanguíneos a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S56901D",
      "display" : "S56901D Traumatismo no especificado de músculos fascias y tendones no especificados a nivel de antebrazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S56909A",
      "display" : "S56909A Traumatismo no especificado de músculos fascias y tendones no especificados a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S52512",
      "display" : "S52512 Fractura desplazada de apófisis estiloides del radio izquierdo"
    },
    {
      "code" : "S52512D",
      "display" : "S52512D Fractura desplazada de apófisis estiloides del radio izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S5269",
      "display" : "S5269 Otra fractura de extremo inferior de cúbito"
    },
    {
      "code" : "S52691C",
      "display" : "S52691C Otra fractura de extremo inferior de cúbito derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52691J",
      "display" : "S52691J Otra fractura de extremo inferior de cúbito derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S55899D",
      "display" : "S55899D Otro traumatismo especificado de otros vasos sanguíneos a nivel de antebrazo brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S55901D",
      "display" : "S55901D Traumatismo no especificado de vaso sanguíneo no especificado a nivel de antebrazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S55909",
      "display" : "S55909 Traumatismo no especificado de vaso sanguíneo no especificado a nivel de antebrazo brazo no especificado"
    },
    {
      "code" : "S52341F",
      "display" : "S52341F Fractura espiroidea desplazada de diáfisis de radio extremidad superior derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52341Q",
      "display" : "S52341Q Fractura espiroidea desplazada de diáfisis de radio extremidad superior derecha contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S52514H",
      "display" : "S52514H Fractura sin desplazamiento de apófisis estiloides del radio derecho contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52699G",
      "display" : "S52699G Otra fractura de extremo inferior de cúbito no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S52699Q",
      "display" : "S52699Q Otra fractura de extremo inferior de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S5290XA",
      "display" : "S5290XA Fractura no especificada de antebrazo no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S55999S",
      "display" : "S55999S Otro traumatismo especificado de vaso sanguíneo no especificado a nivel de antebrazo brazo no especificado secuela"
    },
    {
      "code" : "S56001D",
      "display" : "S56001D Traumatismo no especificado de músculo fascia y tendón flexor de pulgar derecho a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S56009",
      "display" : "S56009 Traumatismo no especificado de músculo fascia y tendón flexor de pulgar no especificado a nivel de antebrazo"
    },
    {
      "code" : "S52343H",
      "display" : "S52343H Fractura espiroidea desplazada de diáfisis de radio extremidad superior no especificada contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52516C",
      "display" : "S52516C Fractura sin desplazamiento de apófisis estiloides de radio no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52516K",
      "display" : "S52516K Fractura sin desplazamiento de apófisis estiloides de radio no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S5291XP",
      "display" : "S5291XP Fractura no especificada de antebrazo derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S5292XA",
      "display" : "S5292XA Fractura no especificada de antebrazo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S56091D",
      "display" : "S56091D Otro traumatismo de músculo fascia y tendón flexor de pulgar derecho a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S56099",
      "display" : "S56099 Otro traumatismo de músculo fascia y tendón flexor de pulgar no especificado a nivel de antebrazo"
    },
    {
      "code" : "S56101",
      "display" : "S56101 Traumatismo no especificado de músculo fascia y tendón flexor de dedo índice derecho a nivel de antebrazo"
    },
    {
      "code" : "S52345K",
      "display" : "S52345K Fractura espiroidea sin desplazamiento de diáfisis de radio extremidad superior izquierda contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S52531A",
      "display" : "S52531A Fractura de Colles de radio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52531F",
      "display" : "S52531F Fractura de Colles de radio derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52516P",
      "display" : "S52516P Fractura sin desplazamiento de apófisis estiloides de radio no especificado contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S53004A",
      "display" : "S53004A Luxación no especificada de cabeza de radio derecho contacto inicial"
    },
    {
      "code" : "S53005D",
      "display" : "S53005D Luxación no especificada de cabeza de radio izquierdo contacto sucesivo"
    },
    {
      "code" : "S53006S",
      "display" : "S53006S Luxación no especificada de cabeza de radio no especificado secuela"
    },
    {
      "code" : "S53011S",
      "display" : "S53011S Subluxación anterior de cabeza de radio derecho secuela"
    },
    {
      "code" : "S53012S",
      "display" : "S53012S Subluxación anterior de cabeza de radio izquierdo secuela"
    },
    {
      "code" : "S56108",
      "display" : "S56108 Traumatismo no especificado de músculo fascia y tendón flexor de dedo meñique izquierdo a nivel de antebrazo"
    },
    {
      "code" : "S56109D",
      "display" : "S56109D Traumatismo no especificado de músculo fascia y tendón flexor de dedo de mano no especificado a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S52351C",
      "display" : "S52351C Fractura conminuta desplazada de diáfisis de radio extremidad superior derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52539H",
      "display" : "S52539H Fractura de Colles de radio no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S52539R",
      "display" : "S52539R Fractura de Colles de radio no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S52541C",
      "display" : "S52541C Fractura de Smith de radio derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S53024D",
      "display" : "S53024D Luxación posterior de cabeza de radio derecho contacto sucesivo"
    },
    {
      "code" : "S53025S",
      "display" : "S53025S Luxación posterior de cabeza de radio izquierdo secuela"
    },
    {
      "code" : "S53026S",
      "display" : "S53026S Luxación posterior de cabeza de radio no especificado secuela"
    },
    {
      "code" : "S53031S",
      "display" : "S53031S Codo de niñera en codo derecho secuela"
    },
    {
      "code" : "S53032S",
      "display" : "S53032S Codo de niñera en codo izquierdo secuela"
    },
    {
      "code" : "S53033S",
      "display" : "S53033S Codo de niñera de lado no especificado secuela"
    },
    {
      "code" : "S53091D",
      "display" : "S53091D Otro tipo de subluxación de cabeza del radio derecho contacto sucesivo"
    },
    {
      "code" : "S56118S",
      "display" : "S56118S Distensión de músculo fascia y tendón flexor de dedo meñique izquierdo a nivel de antebrazo secuela"
    },
    {
      "code" : "S56121",
      "display" : "S56121 Desgarro de músculo fascia y tendón flexor de dedo índice derecho a nivel de antebrazo"
    },
    {
      "code" : "S52353F",
      "display" : "S52353F Fractura conminuta desplazada de diáfisis de radio extremidad superior no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52549A",
      "display" : "S52549A Fractura de Smith de radio no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52549F",
      "display" : "S52549F Fractura de Smith de radio no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S53102D",
      "display" : "S53102D Subluxación no especificada de articulación humerocubital izquierda contacto sucesivo"
    },
    {
      "code" : "S53103S",
      "display" : "S53103S Subluxación no especificada de articulación humerocubital no especificada secuela"
    },
    {
      "code" : "S53105",
      "display" : "S53105 Luxación no especificada de articulación humerocubital izquierda"
    },
    {
      "code" : "S53106A",
      "display" : "S53106A Luxación no especificada de articulación humerocubital no especificada contacto inicial"
    },
    {
      "code" : "S53111A",
      "display" : "S53111A Subluxación anterior de articulación humerocubital derecha contacto inicial"
    },
    {
      "code" : "S56128D",
      "display" : "S56128D Desgarro de músculo fascia y tendón flexor de dedo meñique izquierdo a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S56191",
      "display" : "S56191 Otro traumatismo de músculo fascia y tendón flexor de dedo índice derecho a nivel de antebrazo"
    },
    {
      "code" : "S56192A",
      "display" : "S56192A Otro traumatismo de músculo fascia y tendón flexor de dedo índice izquierdo a nivel de antebrazo contacto inicial"
    },
    {
      "code" : "S52354S",
      "display" : "S52354S Fractura conminuta sin desplazamiento de diáfisis de radio extremidad superior derecha secuela"
    },
    {
      "code" : "S52355E",
      "display" : "S52355E Fractura conminuta sin desplazamiento de diáfisis de radio extremidad superior izquierda contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S52552C",
      "display" : "S52552C Otro tipo de fractura extraarticular de extremo inferior de radio izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52552K",
      "display" : "S52552K Otro tipo de fractura extraarticular de extremo inferior de radio izquierdo contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S53122D",
      "display" : "S53122D Subluxación posterior de articulación humerocubital izquierda contacto sucesivo"
    },
    {
      "code" : "S53124",
      "display" : "S53124 Luxación posterior de articulación humerocubital derecha"
    },
    {
      "code" : "S53125",
      "display" : "S53125 Luxación posterior de articulación humerocubital izquierda"
    },
    {
      "code" : "S53126A",
      "display" : "S53126A Luxación posterior de articulación humerocubital no especificada contacto inicial"
    },
    {
      "code" : "S53131A",
      "display" : "S53131A Subluxación medial de articulación humerocubital derecha contacto inicial"
    },
    {
      "code" : "S53132D",
      "display" : "S53132D Subluxación medial de articulación humerocubital izquierda contacto sucesivo"
    },
    {
      "code" : "S56201A",
      "display" : "S56201A Traumatismo no especificado de otro músculo fascia y tendón flexor a nivel de antebrazo lado derecho contacto inicial"
    },
    {
      "code" : "S56209",
      "display" : "S56209 Traumatismo no especificado de otro músculo fascia y tendón flexor a nivel de antebrazo brazo no especificado"
    },
    {
      "code" : "S52356S",
      "display" : "S52356S Fractura conminuta sin desplazamiento de diáfisis de radio extremidad superior no especificada secuela"
    },
    {
      "code" : "S52361D",
      "display" : "S52361D Fractura segmentaria desplazada de diáfisis de radio extremidad superior derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S52561F",
      "display" : "S52561F Fractura de Barton de radio derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S52561N",
      "display" : "S52561N Fractura de Barton de radio derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S53143A",
      "display" : "S53143A Subluxación lateral de articulación humerocubital no especificada contacto inicial"
    },
    {
      "code" : "S53144D",
      "display" : "S53144D Luxación lateral de articulación humerocubital derecha contacto sucesivo"
    },
    {
      "code" : "S53145S",
      "display" : "S53145S Luxación lateral de articulación humerocubital izquierda secuela"
    },
    {
      "code" : "S5319",
      "display" : "S5319 Otros tipos de subluxación y luxación de articulación humerocubital"
    },
    {
      "code" : "S53192",
      "display" : "S53192 Otro tipo de subluxación de articulación humerocubital izquierda"
    },
    {
      "code" : "S56291D",
      "display" : "S56291D Otro traumatismo de otro músculo fascia y tendón flexor a nivel de antebrazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S48919",
      "display" : "S48919 Amputación traumática completa de hombro y brazo no especificados nivel no especificado"
    },
    {
      "code" : "S48921",
      "display" : "S48921 Amputación traumática parcial del hombro y brazo derechos nivel no especificado"
    },
    {
      "code" : "S48922A",
      "display" : "S48922A Amputación traumática parcial del hombro y brazo izquierdos nivel no especificado contacto inicial"
    },
    {
      "code" : "S48929S",
      "display" : "S48929S Amputación traumática parcial de hombro y brazo no especificados nivel no especificado secuela"
    },
    {
      "code" : "S42319K",
      "display" : "S42319K Fractura en tallo verde de diáfisis de húmero de brazo no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42321D",
      "display" : "S42321D Fractura transversal desplazada de diáfisis de húmero del brazo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42322B",
      "display" : "S42322B Fractura transversal desplazada de diáfisis de húmero del brazo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S42471K",
      "display" : "S42471K Fractura transcondílea desplazada de húmero derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42472D",
      "display" : "S42472D Fractura transcondílea desplazada de húmero izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42473A",
      "display" : "S42473A Fractura transcondílea desplazada de húmero no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S448X2S",
      "display" : "S448X2S Traumatismo de otros nervios a nivel de hombro y brazo brazo izquierdo secuela"
    },
    {
      "code" : "S449",
      "display" : "S449 Traumatismo de nervio no especificado a nivel de hombro y brazo"
    },
    {
      "code" : "S4490XS",
      "display" : "S4490XS Traumatismo de nervio no especificado a nivel de hombro y brazo brazo no especificado secuela"
    },
    {
      "code" : "S4491XS",
      "display" : "S4491XS Traumatismo de nervio no especificado a nivel de hombro y brazo brazo derecho secuela"
    },
    {
      "code" : "S4492XS",
      "display" : "S4492XS Traumatismo de nervio no especificado a nivel de hombro y brazo brazo izquierdo secuela"
    },
    {
      "code" : "S42121",
      "display" : "S42121 Fractura desplazada de acromion del hombro derecho"
    },
    {
      "code" : "S42121G",
      "display" : "S42121G Fractura desplazada de acromion del hombro derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42122A",
      "display" : "S42122A Fractura desplazada de acromion del hombro izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42122S",
      "display" : "S42122S Fractura desplazada de acromion del hombro izquierdo secuela"
    },
    {
      "code" : "S42325K",
      "display" : "S42325K Fractura transversal sin desplazamiento de diáfisis de húmero del brazo izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42326G",
      "display" : "S42326G Fractura transversal sin desplazamiento de diáfisis de húmero de brazo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42476P",
      "display" : "S42476P Fractura transcondílea sin desplazamiento de húmero no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42481G",
      "display" : "S42481G Fractura en rodete de extremo inferior de húmero derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42482G",
      "display" : "S42482G Fractura en rodete de extremo inferior de húmero izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S4509",
      "display" : "S4509 Otro traumatismo especificado de arteria axilar"
    },
    {
      "code" : "S45091S",
      "display" : "S45091S Otro traumatismo especificado de arteria axilar de lado derecho secuela"
    },
    {
      "code" : "S45099",
      "display" : "S45099 Otro traumatismo especificado de arteria axilar lado no especificado"
    },
    {
      "code" : "S4510",
      "display" : "S4510 Traumatismo no especificado de arteria braquial"
    },
    {
      "code" : "S45101S",
      "display" : "S45101S Traumatismo no especificado de arteria braquial de lado derecho secuela"
    },
    {
      "code" : "S45109",
      "display" : "S45109 Traumatismo no especificado de arteria braquial lado no especificado"
    },
    {
      "code" : "S42126D",
      "display" : "S42126D Fractura sin desplazamiento de acromion de hombro no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42131",
      "display" : "S42131 Fractura desplazada de apófisis coracoides del hombro derecho"
    },
    {
      "code" : "S42131K",
      "display" : "S42131K Fractura desplazada de apófisis coracoides del hombro derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42334D",
      "display" : "S42334D Fractura oblicua sin desplazamiento de diáfisis de húmero del brazo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42335B",
      "display" : "S42335B Fractura oblicua sin desplazamiento de diáfisis de húmero del brazo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S42493A",
      "display" : "S42493A Otro tipo de fractura desplazada de extremo inferior de húmero no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42493S",
      "display" : "S42493S Otro tipo de fractura desplazada de extremo inferior de húmero no especificado secuela"
    },
    {
      "code" : "S42494G",
      "display" : "S42494G Otro tipo de fractura sin desplazamiento de extremo inferior de húmero derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S45199D",
      "display" : "S45199D Otro traumatismo especificado de arteria braquial lado no especificado contacto sucesivo"
    },
    {
      "code" : "S45201A",
      "display" : "S45201A Traumatismo no especificado de vena axilar o braquial lado derecho contacto inicial"
    },
    {
      "code" : "S45202S",
      "display" : "S45202S Traumatismo no especificado de vena axilar o braquial lado izquierdo secuela"
    },
    {
      "code" : "S4521",
      "display" : "S4521 Desgarro de vena axilar o braquial"
    },
    {
      "code" : "S45211D",
      "display" : "S45211D Desgarro de vena axilar o braquial de lado derecho contacto sucesivo"
    },
    {
      "code" : "S45212S",
      "display" : "S45212S Desgarro de vena axilar o braquial de lado izquierdo secuela"
    },
    {
      "code" : "S42136",
      "display" : "S42136 Fractura sin desplazamiento de apófisis coracoides de hombro no especificado"
    },
    {
      "code" : "S42136K",
      "display" : "S42136K Fractura sin desplazamiento de apófisis coracoides de hombro no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42343B",
      "display" : "S42343B Fractura espiroidea desplazada de diáfisis de húmero de brazo no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S42344",
      "display" : "S42344 Fractura espiroidea sin desplazamiento de diáfisis de húmero del brazo derecho"
    },
    {
      "code" : "S4290XG",
      "display" : "S4290XG Fractura de cintura escapular no especificada parte no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S4291XA",
      "display" : "S4291XA Fractura de cintura escapular lado derecho parte no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S4291XS",
      "display" : "S4291XS Fractura de cintura escapular lado derecho parte no especificada secuela"
    },
    {
      "code" : "S45309S",
      "display" : "S45309S Traumatismo no especificado de vena superficial a nivel del hombro y brazo brazo no especificado secuela"
    },
    {
      "code" : "S45311S",
      "display" : "S45311S Desgarro de vena superficial a nivel del hombro y brazo brazo derecho secuela"
    },
    {
      "code" : "S45319A",
      "display" : "S45319A Desgarro de vena superficial a nivel del hombro y brazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S45391A",
      "display" : "S45391A Otro traumatismo especificado de vena superficial a nivel del hombro y brazo brazo derecho contacto inicial"
    },
    {
      "code" : "S42144B",
      "display" : "S42144B Fractura sin desplazamiento de cavidad glenoidea de escápula del hombro derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S42145",
      "display" : "S42145 Fractura sin desplazamiento de cavidad glenoidea de escápula del hombro izquierdo"
    },
    {
      "code" : "S42145P",
      "display" : "S42145P Fractura sin desplazamiento de cavidad glenoidea de escápula del hombro izquierdo contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42351S",
      "display" : "S42351S Fractura conminuta desplazada de diáfisis de húmero del brazo derecho secuela"
    },
    {
      "code" : "S42352G",
      "display" : "S42352G Fractura conminuta desplazada de diáfisis de húmero del brazo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S43005",
      "display" : "S43005 Luxación no especificada de articulación del hombro izquierdo"
    },
    {
      "code" : "S43006",
      "display" : "S43006 Luxación no especificada de articulación de hombro no especificado"
    },
    {
      "code" : "S43011",
      "display" : "S43011 Subluxación anterior de húmero derecho"
    },
    {
      "code" : "S43012",
      "display" : "S43012 Subluxación anterior de húmero izquierdo"
    },
    {
      "code" : "S43013",
      "display" : "S43013 Subluxación anterior de húmero no especificado"
    },
    {
      "code" : "S43014",
      "display" : "S43014 Luxación anterior de húmero derecho"
    },
    {
      "code" : "S43015",
      "display" : "S43015 Luxación anterior de húmero izquierdo"
    },
    {
      "code" : "S45812A",
      "display" : "S45812A Desgarro de otros vasos sanguíneos especificados a nivel del hombro y brazo lado izquierdo contacto inicial"
    },
    {
      "code" : "S45819S",
      "display" : "S45819S Desgarro de otros vasos sanguíneos especificados a nivel del hombro y brazo lado no especificado secuela"
    },
    {
      "code" : "S42153A",
      "display" : "S42153A Fractura desplazada del cuello de escápula de hombro no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42153S",
      "display" : "S42153S Fractura desplazada del cuello de escápula de hombro no especificado secuela"
    },
    {
      "code" : "S42154G",
      "display" : "S42154G Fractura sin desplazamiento del cuello de escápula del hombro derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42356G",
      "display" : "S42356G Fractura conminuta sin desplazamiento de diáfisis de húmero de brazo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42361B",
      "display" : "S42361B Fractura segmentaria desplazada de diáfisis de húmero del brazo derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S42362",
      "display" : "S42362 Fractura segmentaria desplazada de diáfisis de húmero del brazo izquierdo"
    },
    {
      "code" : "S43025D",
      "display" : "S43025D Luxación posterior de húmero izquierdo contacto sucesivo"
    },
    {
      "code" : "S43026S",
      "display" : "S43026S Luxación posterior de húmero no especificado secuela"
    },
    {
      "code" : "S43031D",
      "display" : "S43031D Subluxación inferior de húmero derecho contacto sucesivo"
    },
    {
      "code" : "S43032S",
      "display" : "S43032S Subluxación inferior de húmero izquierdo secuela"
    },
    {
      "code" : "S43033S",
      "display" : "S43033S Subluxación inferior de húmero no especificado secuela"
    },
    {
      "code" : "S43034S",
      "display" : "S43034S Luxación inferior de húmero derecho secuela"
    },
    {
      "code" : "S43035S",
      "display" : "S43035S Luxación inferior de húmero izquierdo secuela"
    },
    {
      "code" : "S4308",
      "display" : "S4308 Otros tipos de subluxación y luxación de articulación del hombro"
    },
    {
      "code" : "S45912",
      "display" : "S45912 Desgarro de vaso sanguíneo no especificado a nivel del hombro y brazo brazo izquierdo"
    },
    {
      "code" : "S45919A",
      "display" : "S45919A Desgarro de vaso sanguíneo no especificado a nivel del hombro y brazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S45991D",
      "display" : "S45991D Otro traumatismo especificado de vaso sanguíneo no especificado a nivel del hombro y brazo brazo derecho contacto sucesivo"
    },
    {
      "code" : "S42192B",
      "display" : "S42192B Fractura de otra parte de escápula del hombro izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S42192S",
      "display" : "S42192S Fractura de otra parte de escápula del hombro izquierdo secuela"
    },
    {
      "code" : "S42199G",
      "display" : "S42199G Fractura de otra parte de escápula de hombro no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42365S",
      "display" : "S42365S Fractura segmentaria sin desplazamiento de diáfisis de húmero del brazo izquierdo secuela"
    },
    {
      "code" : "S42366G",
      "display" : "S42366G Fractura segmentaria sin desplazamiento de diáfisis de húmero de brazo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S43101A",
      "display" : "S43101A Luxación no especificada de articulación acromioclavicular derecha contacto inicial"
    },
    {
      "code" : "S43102D",
      "display" : "S43102D Luxación no especificada de articulación acromioclavicular izquierda contacto sucesivo"
    },
    {
      "code" : "S43109S",
      "display" : "S43109S Luxación no especificada de articulación acromioclavicular no especificada secuela"
    },
    {
      "code" : "S43112",
      "display" : "S43112 Subluxación de articulación acromioclavicular izquierda"
    },
    {
      "code" : "S43119",
      "display" : "S43119 Subluxación de articulación acromioclavicular no especificada"
    },
    {
      "code" : "S43121",
      "display" : "S43121 Luxación de articulación acromioclavicular derecha desplazamiento 100%-200%"
    },
    {
      "code" : "S46011A",
      "display" : "S46011A Distensión de músculo(s) y tendón(es) de manguito de los rotadores del hombro derecho contacto inicial"
    },
    {
      "code" : "S46012D",
      "display" : "S46012D Distensión de músculo(s) y tendón(es) de manguito de los rotadores del hombro izquierdo contacto sucesivo"
    },
    {
      "code" : "S4602",
      "display" : "S4602 Desgarro de músculo(s) y tendón(es) de manguito de los rotadores del hombro"
    },
    {
      "code" : "S42211G",
      "display" : "S42211G Fractura no especificada desplazada del cuello quirúrgico de húmero derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42212D",
      "display" : "S42212D Fractura no especificada desplazada del cuello quirúrgico de húmero izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42399S",
      "display" : "S42399S Otra fractura de diáfisis de húmero no especificado secuela"
    },
    {
      "code" : "S42401A",
      "display" : "S42401A Fractura no especificada de extremo inferior de húmero derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42401S",
      "display" : "S42401S Fractura no especificada de extremo inferior de húmero derecho secuela"
    },
    {
      "code" : "S42402G",
      "display" : "S42402G Fractura no especificada de extremo inferior de húmero izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S43141S",
      "display" : "S43141S Luxación inferior de articulación acromioclavicular derecha secuela"
    },
    {
      "code" : "S43142S",
      "display" : "S43142S Luxación inferior de articulación acromioclavicular izquierda secuela"
    },
    {
      "code" : "S4315",
      "display" : "S4315 Luxación posterior de articulación acromioclavicular"
    },
    {
      "code" : "S43152",
      "display" : "S43152 Luxación posterior de articulación acromioclavicular izquierda"
    },
    {
      "code" : "S43159",
      "display" : "S43159 Luxación posterior de articulación acromioclavicular no especificada"
    },
    {
      "code" : "S46101D",
      "display" : "S46101D Traumatismo no especificado de músculo fascia y tendón de la porción larga del bíceps del brazo derecho contacto sucesivo"
    },
    {
      "code" : "S46109A",
      "display" : "S46109A Traumatismo no especificado de músculo fascia y tendón de la porción larga del bíceps de brazo no especificado contacto inicial"
    },
    {
      "code" : "S46111S",
      "display" : "S46111S Distensión de músculo fascia y tendón de la porción larga del bíceps del brazo derecho secuela"
    },
    {
      "code" : "S42216K",
      "display" : "S42216K Fractura no especificada sin desplazamiento del cuello quirúrgico de húmero no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S42221D",
      "display" : "S42221D Fractura en 2 fragmentos desplazada del cuello quirúrgico de húmero derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42413D",
      "display" : "S42413D Fractura supracondílea simple desplazada sin fractura intercondílea de húmero no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42414B",
      "display" : "S42414B Fractura supracondílea simple sin desplazamiento sin fractura intercondílea de húmero derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S4321",
      "display" : "S4321 Subluxación y luxación anterior de articulación esternoclavicular"
    },
    {
      "code" : "S43211S",
      "display" : "S43211S Subluxación anterior de articulación esternoclavicular derecha secuela"
    },
    {
      "code" : "S43213",
      "display" : "S43213 Subluxación anterior de articulación esternoclavicular no especificada"
    },
    {
      "code" : "S43214A",
      "display" : "S43214A Luxación anterior de articulación esternoclavicular derecha contacto inicial"
    },
    {
      "code" : "S46191S",
      "display" : "S46191S Otro traumatismo de músculo fascia y tendón de la porción larga del bíceps del brazo derecho secuela"
    },
    {
      "code" : "S46112",
      "display" : "S46112 Distensión de músculo fascia y tendón de la porción larga del bíceps del brazo izquierdo"
    },
    {
      "code" : "S46201",
      "display" : "S46201 Traumatismo no especificado de músculo fascia y tendón de otras partes del bíceps del brazo derecho"
    },
    {
      "code" : "S42225A",
      "display" : "S42225A Fractura en 2 fragmentos sin desplazamiento del cuello quirúrgico de húmero izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S42226",
      "display" : "S42226 Fractura en 2 fragmentos sin desplazamiento del cuello quirúrgico de húmero no especificado"
    },
    {
      "code" : "S42421P",
      "display" : "S42421P Fractura supracondílea conminuta desplazada sin fractura intercondílea de húmero derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S42422K",
      "display" : "S42422K Fractura supracondílea conminuta desplazada sin fractura intercondílea de húmero izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S43226",
      "display" : "S43226 Luxación posterior de articulación esternoclavicular no especificada"
    },
    {
      "code" : "S4330",
      "display" : "S4330 Subluxación y luxación de partes no especificadas de cintura escapular"
    },
    {
      "code" : "S43302",
      "display" : "S43302 Subluxación de partes no especificadas de cintura escapular lado izquierdo"
    },
    {
      "code" : "S43303A",
      "display" : "S43303A Subluxación de partes no especificadas de cintura escapular lado no especificado contacto inicial"
    },
    {
      "code" : "S46229A",
      "display" : "S46229A Desgarro de músculo fascia y tendón de otras partes del bíceps de brazo no especificado contacto inicial"
    },
    {
      "code" : "S46291D",
      "display" : "S46291D Otro traumatismo de músculo fascia y tendón de otras partes del bíceps del brazo derecho contacto sucesivo"
    },
    {
      "code" : "S46299",
      "display" : "S46299 Otro traumatismo de músculo fascia y tendón de otras partes del bíceps de brazo no especificado"
    },
    {
      "code" : "S42239B",
      "display" : "S42239B Fractura en 3 fragmentos del cuello quirúrgico de húmero no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S4224",
      "display" : "S4224 Fractura en 4 fragmentos del cuello quirúrgico de húmero"
    },
    {
      "code" : "S42241D",
      "display" : "S42241D Fractura en 4 fragmentos del cuello quirúrgico de húmero derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42425S",
      "display" : "S42425S Fractura supracondílea conminuta sin desplazamiento sin fractura intercondílea de húmero izquierdo secuela"
    },
    {
      "code" : "S42426K",
      "display" : "S42426K Fractura supracondílea conminuta sin desplazamiento sin fractura intercondílea de húmero no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S43315A",
      "display" : "S43315A Luxación de escápula izquierda contacto inicial"
    },
    {
      "code" : "S43316A",
      "display" : "S43316A Luxación de escápula no especificada contacto inicial"
    },
    {
      "code" : "S43391",
      "display" : "S43391 Subluxación de otras partes de cintura escapular lado derecho"
    },
    {
      "code" : "S43392A",
      "display" : "S43392A Subluxación de otras partes de cintura escapular lado izquierdo contacto inicial"
    },
    {
      "code" : "S43393D",
      "display" : "S43393D Subluxación de otras partes de cintura escapular no especificada contacto sucesivo"
    },
    {
      "code" : "S43394S",
      "display" : "S43394S Luxación de otras partes de cintura escapular lado derecho secuela"
    },
    {
      "code" : "S46312S",
      "display" : "S46312S Distensión de músculo fascia y tendón del tríceps del brazo izquierdo secuela"
    },
    {
      "code" : "S4632",
      "display" : "S4632 Desgarro de músculo fascia y tendón del tríceps"
    },
    {
      "code" : "S46321S",
      "display" : "S46321S Desgarro de músculo fascia y tendón del tríceps lado derecho secuela"
    },
    {
      "code" : "S46329",
      "display" : "S46329 Desgarro de músculo fascia y tendón del tríceps de brazo no especificado"
    },
    {
      "code" : "S46391",
      "display" : "S46391 Otro traumatismo de músculo fascia y tendón del tríceps lado derecho"
    },
    {
      "code" : "S42252",
      "display" : "S42252 Fractura desplazada de tuberosidad mayor de húmero izquierdo"
    },
    {
      "code" : "S42252G",
      "display" : "S42252G Fractura desplazada de tuberosidad mayor de húmero izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S42253D",
      "display" : "S42253D Fractura desplazada de tuberosidad mayor de húmero no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S42434B",
      "display" : "S42434B Fractura sin desplazamiento (por avulsión) de epicóndilo lateral de húmero derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S42435A",
      "display" : "S42435A Fractura sin desplazamiento (por avulsión) de epicóndilo lateral de húmero izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S43412D",
      "display" : "S43412D Esguince de ligamento coracohumeral izquierdo contacto sucesivo"
    },
    {
      "code" : "S43419S",
      "display" : "S43419S Esguince de ligamento coracohumeral no especificado secuela"
    },
    {
      "code" : "S43421D",
      "display" : "S43421D Esguince de cápsula del manguito de los rotadores derecho contacto sucesivo"
    },
    {
      "code" : "S43422S",
      "display" : "S43422S Esguince de cápsula del manguito de los rotadores izquierdo secuela"
    },
    {
      "code" : "S5410XD",
      "display" : "S5410XD Traumatismo de nervio mediano a nivel de antebrazo brazo no especificado contacto sucesivo"
    },
    {
      "code" : "T5493XS",
      "display" : "T5493XS Efecto tóxico de sustancia corrosiva no especificada agresión secuela"
    },
    {
      "code" : "T6094X",
      "display" : "T6094X Efecto tóxico de plaguicidas (pesticida) no especificados intencionalidad sin determinar"
    },
    {
      "code" : "T610",
      "display" : "T610 Intoxicación por Ciguatera (pescado)"
    },
    {
      "code" : "T6101XD",
      "display" : "T6101XD Intoxicación por Ciguatera (pescado) accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T6102XD",
      "display" : "T6102XD Intoxicación por Ciguatera (pescado) autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T6103XD",
      "display" : "T6103XD Intoxicación por Ciguatera (pescado) agresión contacto sucesivo"
    },
    {
      "code" : "T63691D",
      "display" : "T63691D Efecto tóxico de contacto con otros animales marinos venenosos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63692S",
      "display" : "T63692S Efecto tóxico de contacto con otros animales marinos venenosos autolesión intencionada secuela"
    },
    {
      "code" : "T63694",
      "display" : "T63694 Efecto tóxico de contacto con otros animales marinos venenosos intencionalidad sin determinar"
    },
    {
      "code" : "T63711",
      "display" : "T63711 Efecto tóxico de contacto con planta marina venenosa accidental (no intencionado)"
    },
    {
      "code" : "T50A12D",
      "display" : "T50A12D Envenenamiento por vacuna contra la tos ferina incluyendo combinaciones con componente pertussis autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T50A14A",
      "display" : "T50A14A Envenenamiento por vacuna contra la tos ferina incluyendo combinaciones con componente pertussis intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T50A16A",
      "display" : "T50A16A Infradosificación de vacuna contra tos ferina incluyendo combinaciones con componente pertussis contacto inicial"
    },
    {
      "code" : "T551X1A",
      "display" : "T551X1A Efecto tóxico de detergentes accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T551X2D",
      "display" : "T551X2D Efecto tóxico de detergentes autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T551X3S",
      "display" : "T551X3S Efecto tóxico de detergentes agresión secuela"
    },
    {
      "code" : "T551X4S",
      "display" : "T551X4S Efecto tóxico de detergentes intencionalidad sin determinar secuela"
    },
    {
      "code" : "T560X1A",
      "display" : "T560X1A Efecto tóxico de plomo y sus compuestos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T560X2S",
      "display" : "T560X2S Efecto tóxico de plomo y sus compuestos autolesión intencionada secuela"
    },
    {
      "code" : "T560X3S",
      "display" : "T560X3S Efecto tóxico de plomo y sus compuestos agresión secuela"
    },
    {
      "code" : "T61771D",
      "display" : "T61771D Otro tipo de intoxicación/envenenamiento por pescado accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T61772S",
      "display" : "T61772S Otro tipo de intoxicación/envenenamiento por pescado autolesión intencionada secuela"
    },
    {
      "code" : "T6104X",
      "display" : "T6104X Intoxicación por Ciguatera (pescado) intencionalidad sin determinar"
    },
    {
      "code" : "T61781",
      "display" : "T61781 Otro tipo de intoxicación/envenenamiento por mariscos accidental (no intencionado)"
    },
    {
      "code" : "T61782A",
      "display" : "T61782A Otro tipo de intoxicación/envenenamiento por mariscos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T63793D",
      "display" : "T63793D Efecto tóxico de contacto con otras plantas venenosas agresión contacto sucesivo"
    },
    {
      "code" : "T63794S",
      "display" : "T63794S Efecto tóxico de contacto con otras plantas venenosas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T63711D",
      "display" : "T63711D Efecto tóxico de contacto con planta marina venenosa accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63813",
      "display" : "T63813 Efecto tóxico de contacto con rana venenosa agresión"
    },
    {
      "code" : "T63814",
      "display" : "T63814 Efecto tóxico de contacto con rana venenosa intencionalidad sin determinar"
    },
    {
      "code" : "T50A26S",
      "display" : "T50A26S Infradosificación de vacunas bacterianas mixtas sin componente pertussis secuela"
    },
    {
      "code" : "T50A91S",
      "display" : "T50A91S Envenenamiento por otras vacunas bacterianas accidental (no intencionado) secuela"
    },
    {
      "code" : "T50A93A",
      "display" : "T50A93A Envenenamiento por otras vacunas bacterianas agresión contacto inicial"
    },
    {
      "code" : "T50A94A",
      "display" : "T50A94A Envenenamiento por otras vacunas bacterianas intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T562X2A",
      "display" : "T562X2A Efecto tóxico de cromo y sus compuestos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T562X3D",
      "display" : "T562X3D Efecto tóxico de cromo y sus compuestos agresión contacto sucesivo"
    },
    {
      "code" : "T562X4S",
      "display" : "T562X4S Efecto tóxico de cromo y sus compuestos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T563X1D",
      "display" : "T563X1D Efecto tóxico de cadmio y sus compuestos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T563X3",
      "display" : "T563X3 Efecto tóxico de cadmio y sus compuestos agresión"
    },
    {
      "code" : "T618X4S",
      "display" : "T618X4S Efecto tóxico de otros mariscos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T6191XD",
      "display" : "T6191XD Efecto tóxico de marisco no especificado accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T6192XD",
      "display" : "T6192XD Efecto tóxico de marisco no especificado autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T6193XD",
      "display" : "T6193XD Efecto tóxico de marisco no especificado agresión contacto sucesivo"
    },
    {
      "code" : "T6194XD",
      "display" : "T6194XD Efecto tóxico de marisco no especificado intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T63833A",
      "display" : "T63833A Efecto tóxico de contacto con otros anfibios venenosos agresión contacto inicial"
    },
    {
      "code" : "T63834D",
      "display" : "T63834D Efecto tóxico de contacto con otros anfibios venenosos intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T63891S",
      "display" : "T63891S Efecto tóxico de contacto con otros animales venenosos accidental (no intencionado) secuela"
    },
    {
      "code" : "T63893A",
      "display" : "T63893A Efecto tóxico de contacto con otros animales venenosos agresión contacto inicial"
    },
    {
      "code" : "T50B15A",
      "display" : "T50B15A Efecto adverso de vacunas contra la viruela contacto inicial"
    },
    {
      "code" : "T50B16D",
      "display" : "T50B16D Infradosificación de vacunas contra la viruela contacto sucesivo"
    },
    {
      "code" : "T50B91A",
      "display" : "T50B91A Envenenamiento por otras vacunas virales accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T50B92S",
      "display" : "T50B92S Envenenamiento por otras vacunas virales autolesión intencionada secuela"
    },
    {
      "code" : "T50B94",
      "display" : "T50B94 Envenenamiento por otras vacunas virales intencionalidad sin determinar"
    },
    {
      "code" : "T50B95A",
      "display" : "T50B95A Efecto adverso de otras vacunas virales contacto inicial"
    },
    {
      "code" : "T565X",
      "display" : "T565X Efecto tóxico de zinc y sus compuestos"
    },
    {
      "code" : "T565X1S",
      "display" : "T565X1S Efecto tóxico de zinc y sus compuestos accidental (no intencionado) secuela"
    },
    {
      "code" : "T565X3",
      "display" : "T565X3 Efecto tóxico de zinc y sus compuestos agresión"
    },
    {
      "code" : "T565X4",
      "display" : "T565X4 Efecto tóxico de zinc y sus compuestos intencionalidad sin determinar"
    },
    {
      "code" : "T566X",
      "display" : "T566X Efecto tóxico de estaño y sus compuestos"
    },
    {
      "code" : "T566X1S",
      "display" : "T566X1S Efecto tóxico de estaño y sus compuestos accidental (no intencionado) secuela"
    },
    {
      "code" : "T566X3",
      "display" : "T566X3 Efecto tóxico de estaño y sus compuestos agresión"
    },
    {
      "code" : "T621X3A",
      "display" : "T621X3A Efecto tóxico de bayas ingeridas agresión contacto inicial"
    },
    {
      "code" : "T621X4D",
      "display" : "T621X4D Efecto tóxico de bayas ingeridas intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T622X1A",
      "display" : "T622X1A Efecto tóxico de otra(s) planta(s) (partes) ingerida(s) accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T622X2D",
      "display" : "T622X2D Efecto tóxico de otra(s) planta(s) (partes) ingerida(s) autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T622X4",
      "display" : "T622X4 Efecto tóxico de otra(s) planta(s) (partes) ingerida(s) intencionalidad sin determinar"
    },
    {
      "code" : "T6401X",
      "display" : "T6401X Efecto tóxico de aflatoxina accidental (no intencionado)"
    },
    {
      "code" : "T6402",
      "display" : "T6402 Efecto tóxico de aflatoxina autolesión intencionada"
    },
    {
      "code" : "T6402XS",
      "display" : "T6402XS Efecto tóxico de aflatoxina autolesión intencionada secuela"
    },
    {
      "code" : "T85120A",
      "display" : "T85120A Desplazamiento de electrodo (cable) de neuroestimulador electrónico implantado de cerebro contacto inicial"
    },
    {
      "code" : "T85121D",
      "display" : "T85121D Desplazamiento de electrodo (cable) de neuroestimulador electrónico implantado de nervio periférico contacto sucesivo"
    },
    {
      "code" : "T85123",
      "display" : "T85123 Desplazamiento de neuroestimulador electrónico implantado generador"
    },
    {
      "code" : "T739X",
      "display" : "T739X Efecto de deprivación no especificado"
    },
    {
      "code" : "T731",
      "display" : "T731 Deprivación de agua"
    },
    {
      "code" : "T74",
      "display" : "T74 Abuso negligencia y otros malos tratos infantiles y de adultos confirmados"
    },
    {
      "code" : "T7401XD",
      "display" : "T7401XD Negligencia o abandono de adultos confirmados contacto sucesivo"
    },
    {
      "code" : "T7402XD",
      "display" : "T7402XD Negligencia o abandono infantil confirmados contacto sucesivo"
    },
    {
      "code" : "T7411X",
      "display" : "T7411X Abuso físico de adultos confirmado"
    },
    {
      "code" : "T7412",
      "display" : "T7412 Abuso físico infantil confirmado"
    },
    {
      "code" : "T7412XS",
      "display" : "T7412XS Abuso físico infantil confirmado secuela"
    },
    {
      "code" : "T7421XA",
      "display" : "T7421XA Abuso sexual de adultos confirmado contacto inicial"
    },
    {
      "code" : "T7422X",
      "display" : "T7422X Abuso sexual infantil confirmado"
    },
    {
      "code" : "T743",
      "display" : "T743 Abuso psicológico confirmado"
    },
    {
      "code" : "T81533A",
      "display" : "T81533A Perforación por (debida a) cuerpo extraño dejado accidentalmente en el interior del cuerpo después de inyección o inmunización contacto inicial"
    },
    {
      "code" : "T8324XD",
      "display" : "T8324XD Erosión de injerto de órgano urinario contacto sucesivo"
    },
    {
      "code" : "T8325XD",
      "display" : "T8325XD Exposición de injerto de órgano urinario contacto sucesivo"
    },
    {
      "code" : "T8329XA",
      "display" : "T8329XA Otra complicación mecánica de injerto de órgano urinario contacto inicial"
    },
    {
      "code" : "T8331X",
      "display" : "T8331X Fallo mecánico de dispositivo anticonceptivo intrauterino"
    },
    {
      "code" : "T8332X",
      "display" : "T8332X Desplazamiento de dispositivo anticonceptivo intrauterino"
    },
    {
      "code" : "T8339",
      "display" : "T8339 Otra complicación mecánica de dispositivo anticonceptivo intrauterino"
    },
    {
      "code" : "T834",
      "display" : "T834 Complicación mecánica de otras prótesis implantes e injertos de tracto genital"
    },
    {
      "code" : "T8521",
      "display" : "T8521 Fallo mecánico de lente intraocular"
    },
    {
      "code" : "T8521XS",
      "display" : "T8521XS Fallo mecánico de lente intraocular secuela"
    },
    {
      "code" : "T8522XD",
      "display" : "T8522XD Desplazamiento de lente intraocular contacto sucesivo"
    },
    {
      "code" : "T8529XD",
      "display" : "T8529XD Otra complicación mecánica de lente intraocular contacto sucesivo"
    },
    {
      "code" : "T85310",
      "display" : "T85310 Fallo mecánico de prótesis de órbita del ojo derecho"
    },
    {
      "code" : "T746",
      "display" : "T746 Explotación laboral forzada confirmada"
    },
    {
      "code" : "T7461X",
      "display" : "T7461X Explotación laboral de adulto forzada confirmada"
    },
    {
      "code" : "T7462X",
      "display" : "T7462X Explotación laboral infantil forzada confirmada"
    },
    {
      "code" : "T749",
      "display" : "T749 Malos tratos no especificados confirmados"
    },
    {
      "code" : "T7491XD",
      "display" : "T7491XD Malos tratos de adultos no especificado confirmados contacto sucesivo"
    },
    {
      "code" : "T7492XA",
      "display" : "T7492XA Maltrato infantil no especificado confirmado contacto inicial"
    },
    {
      "code" : "T7500",
      "display" : "T7500 Efectos no especificados de rayo"
    },
    {
      "code" : "T7500XS",
      "display" : "T7500XS Efectos no especificados de rayo secuela"
    },
    {
      "code" : "T7501XD",
      "display" : "T7501XD Shock por (debido a) ser alcanzado por un rayo contacto sucesivo"
    },
    {
      "code" : "T81590A",
      "display" : "T81590A Otras complicaciones de cuerpo extraño dejado accidentalmente en el interior del cuerpo después de intervención quirúrgica contacto inicial"
    },
    {
      "code" : "T6403XS",
      "display" : "T6403XS Efecto tóxico de aflatoxina agresión secuela"
    },
    {
      "code" : "T6404XD",
      "display" : "T6404XD Efecto tóxico de aflatoxina intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T50Z16",
      "display" : "T50Z16 Infradosificación de inmunoglobulina"
    },
    {
      "code" : "T50Z9",
      "display" : "T50Z9 Envenenamiento efecto adverso e infradosificación por otras vacunas y sustancias biológicas"
    },
    {
      "code" : "T50Z92",
      "display" : "T50Z92 Envenenamiento por otras vacunas y sustancias biológicas autolesión intencionada"
    },
    {
      "code" : "T50Z93A",
      "display" : "T50Z93A Envenenamiento por otras vacunas y sustancias biológicas agresión contacto inicial"
    },
    {
      "code" : "T50Z94S",
      "display" : "T50Z94S Envenenamiento por otras vacunas y sustancias biológicas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T5681",
      "display" : "T5681 Efecto tóxico de talio"
    },
    {
      "code" : "T56811D",
      "display" : "T56811D Efecto tóxico de talio accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T56812S",
      "display" : "T56812S Efecto tóxico de talio autolesión intencionada secuela"
    },
    {
      "code" : "T56814",
      "display" : "T56814 Efecto tóxico de talio intencionalidad sin determinar"
    },
    {
      "code" : "T5689",
      "display" : "T5689 Efecto tóxico de otros metales"
    },
    {
      "code" : "T56891S",
      "display" : "T56891S Efecto tóxico de otros metales accidental (no intencionado) secuela"
    },
    {
      "code" : "T56892S",
      "display" : "T56892S Efecto tóxico de otros metales autolesión intencionada secuela"
    },
    {
      "code" : "T6292X",
      "display" : "T6292X Efecto tóxico de sustancias nocivas no especificadas ingeridas como alimento autolesión intencionada"
    },
    {
      "code" : "T6293XA",
      "display" : "T6293XA Efecto tóxico de sustancias nocivas no especificadas ingeridas como alimento agresión contacto inicial"
    },
    {
      "code" : "T6294XD",
      "display" : "T6294XD Efecto tóxico de sustancias nocivas no especificadas ingeridas como alimento intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T650X1A",
      "display" : "T650X1A Efecto tóxico de cianuros accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T650X2D",
      "display" : "T650X2D Efecto tóxico de cianuros autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T650X3S",
      "display" : "T650X3S Efecto tóxico de cianuros agresión secuela"
    },
    {
      "code" : "T650X4S",
      "display" : "T650X4S Efecto tóxico de cianuros intencionalidad sin determinar secuela"
    },
    {
      "code" : "T651X1D",
      "display" : "T651X1D Efecto tóxico de estricnina y sus sales accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T651X2S",
      "display" : "T651X2S Efecto tóxico de estricnina y sus sales autolesión intencionada secuela"
    },
    {
      "code" : "T50906",
      "display" : "T50906 Infradosificación de fármacos medicamentos y sustancias biológicas no especificados"
    },
    {
      "code" : "T50911A",
      "display" : "T50911A Envenenamiento por múltiples fármacos medicamentos y sustancias biológicas no especificados accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T5694XD",
      "display" : "T5694XD Efecto tóxico de metal no especificado intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T570X1A",
      "display" : "T570X1A Efecto tóxico de arsénico y sus compuestos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T570X2D",
      "display" : "T570X2D Efecto tóxico de arsénico y sus compuestos autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T570X4",
      "display" : "T570X4 Efecto tóxico de arsénico y sus compuestos intencionalidad sin determinar"
    },
    {
      "code" : "T571X",
      "display" : "T571X Efecto tóxico de fósforo y sus compuestos"
    },
    {
      "code" : "T571X1S",
      "display" : "T571X1S Efecto tóxico de fósforo y sus compuestos accidental (no intencionado) secuela"
    },
    {
      "code" : "T63012A",
      "display" : "T63012A Efecto tóxico de veneno de serpiente de cascabel autolesión intencionada contacto inicial"
    },
    {
      "code" : "T63013S",
      "display" : "T63013S Efecto tóxico de veneno de serpiente de cascabel agresión secuela"
    },
    {
      "code" : "T63014S",
      "display" : "T63014S Efecto tóxico de veneno de serpiente de cascabel intencionalidad sin determinar secuela"
    },
    {
      "code" : "T63022",
      "display" : "T63022 Efecto tóxico de veneno de serpiente coral autolesión intencionada"
    },
    {
      "code" : "T63023A",
      "display" : "T63023A Efecto tóxico de veneno de serpiente coral agresión contacto inicial"
    },
    {
      "code" : "T65221D",
      "display" : "T65221D Efecto tóxico de cigarrillos de tabaco accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T65222S",
      "display" : "T65222S Efecto tóxico de cigarrillos de tabaco autolesión intencionada secuela"
    },
    {
      "code" : "T65223S",
      "display" : "T65223S Efecto tóxico de cigarrillos de tabaco agresión secuela"
    },
    {
      "code" : "T6529",
      "display" : "T6529 Efecto tóxico de otros productos del tabaco y nicotina"
    },
    {
      "code" : "T65291S",
      "display" : "T65291S Efecto tóxico de otros productos del tabaco y nicotina accidental (no intencionado) secuela"
    },
    {
      "code" : "T50993",
      "display" : "T50993 Envenenamiento por otros fármacos medicamentos y sustancias biológicas agresión"
    },
    {
      "code" : "T50994A",
      "display" : "T50994A Envenenamiento por otros fármacos medicamentos y sustancias biológicas intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T50995S",
      "display" : "T50995S Efecto adverso de otros fármacos medicamentos y sustancias biológicas secuela"
    },
    {
      "code" : "T572X4A",
      "display" : "T572X4A Efecto tóxico de manganeso y sus compuestos intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T573X1",
      "display" : "T573X1 Efecto tóxico de cianuro de hidrógeno accidental (no intencionado)"
    },
    {
      "code" : "T571X2",
      "display" : "T571X2 Efecto tóxico de fósforo y sus compuestos autolesión intencionada"
    },
    {
      "code" : "T573X3A",
      "display" : "T573X3A Efecto tóxico de cianuro de hidrógeno agresión contacto inicial"
    },
    {
      "code" : "T573X4A",
      "display" : "T573X4A Efecto tóxico de cianuro de hidrógeno intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T63042D",
      "display" : "T63042D Efecto tóxico de veneno de cobra autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T63043S",
      "display" : "T63043S Efecto tóxico de veneno de cobra agresión secuela"
    },
    {
      "code" : "T63044S",
      "display" : "T63044S Efecto tóxico de veneno de cobra intencionalidad sin determinar secuela"
    },
    {
      "code" : "T63061S",
      "display" : "T63061S Efecto tóxico de veneno de otras serpientes de Norteamérica y Sudamérica accidental (no intencionado) secuela"
    },
    {
      "code" : "T654X1",
      "display" : "T654X1 Efecto tóxico de disulfuro de carbono accidental (no intencionado)"
    },
    {
      "code" : "T654X2",
      "display" : "T654X2 Efecto tóxico de disulfuro de carbono autolesión intencionada"
    },
    {
      "code" : "T654X3",
      "display" : "T654X3 Efecto tóxico de disulfuro de carbono agresión"
    },
    {
      "code" : "T654X4",
      "display" : "T654X4 Efecto tóxico de disulfuro de carbono intencionalidad sin determinar"
    },
    {
      "code" : "T655X",
      "display" : "T655X Efecto tóxico de nitroglicerina y otros ácidos y ésteres de ácido nítrico"
    },
    {
      "code" : "T511X2A",
      "display" : "T511X2A Efecto tóxico de metanol autolesión intencionada contacto inicial"
    },
    {
      "code" : "T511X3D",
      "display" : "T511X3D Efecto tóxico de metanol agresión contacto sucesivo"
    },
    {
      "code" : "T511X4D",
      "display" : "T511X4D Efecto tóxico de metanol intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T512X1A",
      "display" : "T512X1A Efecto tóxico de 2-propanol accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T512X2D",
      "display" : "T512X2D Efecto tóxico de 2-propanol autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T512X3S",
      "display" : "T512X3S Efecto tóxico de 2-propanol agresión secuela"
    },
    {
      "code" : "T512X4S",
      "display" : "T512X4S Efecto tóxico de 2-propanol intencionalidad sin determinar secuela"
    },
    {
      "code" : "T5793XA",
      "display" : "T5793XA Efecto tóxico de sustancia inorgánica no especificada agresión contacto inicial"
    },
    {
      "code" : "T5794XA",
      "display" : "T5794XA Efecto tóxico de sustancia inorgánica no especificada intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T5801X",
      "display" : "T5801X Efecto tóxico de monóxido de carbono de escape de vehículo de motor accidental (no intencionado)"
    },
    {
      "code" : "T5802X",
      "display" : "T5802X Efecto tóxico de monóxido de carbono de escape de vehículo de motor autolesión intencionada"
    },
    {
      "code" : "T63082",
      "display" : "T63082 Efecto tóxico de veneno de otra serpiente de África y Asia autolesión intencionada"
    },
    {
      "code" : "T63063D",
      "display" : "T63063D Efecto tóxico de veneno de otras serpientes de Norteamérica y Sudamérica agresión contacto sucesivo"
    },
    {
      "code" : "T63084D",
      "display" : "T63084D Efecto tóxico de veneno de otra serpiente de África y Asia intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T63091S",
      "display" : "T63091S Efecto tóxico de veneno de otra serpiente accidental (no intencionado) secuela"
    },
    {
      "code" : "T656X3A",
      "display" : "T656X3A Efecto tóxico de pinturas y tintes no clasificados bajo otro concepto agresión contacto inicial"
    },
    {
      "code" : "T656X4D",
      "display" : "T656X4D Efecto tóxico de pinturas y tintes no clasificados bajo otro concepto intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T65811D",
      "display" : "T65811D Efecto tóxico de látex accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T65812D",
      "display" : "T65812D Efecto tóxico de látex autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T518X3A",
      "display" : "T518X3A Efecto tóxico de otros alcoholes agresión contacto inicial"
    },
    {
      "code" : "T518X4D",
      "display" : "T518X4D Efecto tóxico de otros alcoholes intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T5191XA",
      "display" : "T5191XA Efecto tóxico de alcohol no especificado accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T5192X",
      "display" : "T5192X Efecto tóxico de alcohol no especificado autolesión intencionada"
    },
    {
      "code" : "T5193X",
      "display" : "T5193X Efecto tóxico de alcohol no especificado agresión"
    },
    {
      "code" : "T5194",
      "display" : "T5194 Efecto tóxico de alcohol no especificado intencionalidad sin determinar"
    },
    {
      "code" : "T5813XD",
      "display" : "T5813XD Efecto tóxico de monóxido de carbono de gas de suministro agresión contacto sucesivo"
    },
    {
      "code" : "T5814XD",
      "display" : "T5814XD Efecto tóxico de monóxido de carbono de gas de suministro intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T582X1S",
      "display" : "T582X1S Efecto tóxico de monóxido de carbono originado en combustión incompleta de otros combustibles domésticos accidental (no intencionado) secuela"
    },
    {
      "code" : "T63114D",
      "display" : "T63114D Efecto tóxico de veneno de monstruo de Gila intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T63121D",
      "display" : "T63121D Efecto tóxico de veneno de otros lagartos venenosos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63123",
      "display" : "T63123 Efecto tóxico de veneno de otros lagartos venenosos agresión"
    },
    {
      "code" : "T63124",
      "display" : "T63124 Efecto tóxico de veneno de otros lagartos venenosos intencionalidad sin determinar"
    },
    {
      "code" : "T65831D",
      "display" : "T65831D Efecto tóxico de fibra de vidrio accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T65832S",
      "display" : "T65832S Efecto tóxico de fibra de vidrio autolesión intencionada secuela"
    },
    {
      "code" : "T65833S",
      "display" : "T65833S Efecto tóxico de fibra de vidrio agresión secuela"
    },
    {
      "code" : "T65834S",
      "display" : "T65834S Efecto tóxico de fibra de vidrio intencionalidad sin determinar secuela"
    },
    {
      "code" : "T65891S",
      "display" : "T65891S Efecto tóxico de otras sustancias especificadas accidental (no intencionado) secuela"
    },
    {
      "code" : "T65893",
      "display" : "T65893 Efecto tóxico de otras sustancias especificadas agresión"
    },
    {
      "code" : "T521X1D",
      "display" : "T521X1D Efecto tóxico de benceno accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T521X2S",
      "display" : "T521X2S Efecto tóxico de benceno autolesión intencionada secuela"
    },
    {
      "code" : "T521X3S",
      "display" : "T521X3S Efecto tóxico de benceno agresión secuela"
    },
    {
      "code" : "T521X4S",
      "display" : "T521X4S Efecto tóxico de benceno intencionalidad sin determinar secuela"
    },
    {
      "code" : "T522X1D",
      "display" : "T522X1D Efecto tóxico de homólogos de benceno accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T522X2S",
      "display" : "T522X2S Efecto tóxico de homólogos de benceno autolesión intencionada secuela"
    },
    {
      "code" : "T589",
      "display" : "T589 Efecto tóxico de monóxido de carbono de fuente no especificada"
    },
    {
      "code" : "T5891XS",
      "display" : "T5891XS Efecto tóxico de monóxido de carbono de fuente no especificada accidental (no intencionado) secuela"
    },
    {
      "code" : "T5892XS",
      "display" : "T5892XS Efecto tóxico de monóxido de carbono de fuente no especificada autolesión intencionada secuela"
    },
    {
      "code" : "T632X3D",
      "display" : "T632X3D Efecto tóxico de veneno de escorpión agresión contacto sucesivo"
    },
    {
      "code" : "T632X4S",
      "display" : "T632X4S Efecto tóxico de veneno de escorpión intencionalidad sin determinar secuela"
    },
    {
      "code" : "T63301D",
      "display" : "T63301D Efecto tóxico de veneno de araña no especificada accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63302S",
      "display" : "T63302S Efecto tóxico de veneno de araña no especificada autolesión intencionada secuela"
    },
    {
      "code" : "T63304A",
      "display" : "T63304A Efecto tóxico de veneno de araña no especificada intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T6594XD",
      "display" : "T6594XD Efecto tóxico de sustancia no especificada intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T66XXXA",
      "display" : "T66XXXA Síndrome de irradiación no especificado contacto inicial"
    },
    {
      "code" : "T670",
      "display" : "T670 Golpe de calor e insolación"
    },
    {
      "code" : "T6701XD",
      "display" : "T6701XD Golpe de calor e insolación contacto sucesivo"
    },
    {
      "code" : "T6702XA",
      "display" : "T6702XA Golpe de calor por esfuerzo contacto inicial"
    },
    {
      "code" : "T6709X",
      "display" : "T6709X Otro tipo de golpe de calor e insolación"
    },
    {
      "code" : "T671",
      "display" : "T671 Síncope por calor"
    },
    {
      "code" : "T671XXA",
      "display" : "T671XXA Síncope por calor contacto inicial"
    },
    {
      "code" : "T672X",
      "display" : "T672X Calambres por calor"
    },
    {
      "code" : "T524X1A",
      "display" : "T524X1A Efecto tóxico de cetonas accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T524X2D",
      "display" : "T524X2D Efecto tóxico de cetonas autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T524X3S",
      "display" : "T524X3S Efecto tóxico de cetonas agresión secuela"
    },
    {
      "code" : "T524X4S",
      "display" : "T524X4S Efecto tóxico de cetonas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T528X1D",
      "display" : "T528X1D Efecto tóxico de otros disolventes orgánicos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T528X3",
      "display" : "T528X3 Efecto tóxico de otros disolventes orgánicos agresión"
    },
    {
      "code" : "T528X4",
      "display" : "T528X4 Efecto tóxico de otros disolventes orgánicos intencionalidad sin determinar"
    },
    {
      "code" : "T590X4S",
      "display" : "T590X4S Efecto tóxico de óxidos de nitrógeno intencionalidad sin determinar secuela"
    },
    {
      "code" : "T591X1D",
      "display" : "T591X1D Efecto tóxico de dióxido de azufre accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T591X2D",
      "display" : "T591X2D Efecto tóxico de dióxido de azufre autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T591X4",
      "display" : "T591X4 Efecto tóxico de dióxido de azufre intencionalidad sin determinar"
    },
    {
      "code" : "T592",
      "display" : "T592 Efecto tóxico de formaldehído"
    },
    {
      "code" : "T592X1D",
      "display" : "T592X1D Efecto tóxico de formaldehído accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63323A",
      "display" : "T63323A Efecto tóxico de veneno de tarántula agresión contacto inicial"
    },
    {
      "code" : "T63324D",
      "display" : "T63324D Efecto tóxico de veneno de tarántula intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T63331D",
      "display" : "T63331D Efecto tóxico de veneno de araña reclusa parda accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63333",
      "display" : "T63333 Efecto tóxico de veneno de araña reclusa parda agresión"
    },
    {
      "code" : "T63334",
      "display" : "T63334 Efecto tóxico de veneno de araña reclusa parda intencionalidad sin determinar"
    },
    {
      "code" : "T677",
      "display" : "T677 Edema por calor"
    },
    {
      "code" : "T677XXA",
      "display" : "T677XXA Edema por calor contacto inicial"
    },
    {
      "code" : "T678",
      "display" : "T678 Otros efectos de calor y luz"
    },
    {
      "code" : "T678XXD",
      "display" : "T678XXD Otros efectos de calor y luz contacto sucesivo"
    },
    {
      "code" : "T679X",
      "display" : "T679X Efecto de calor y luz no especificado"
    },
    {
      "code" : "T679XXS",
      "display" : "T679XXS Efecto de calor y luz no especificado secuela"
    },
    {
      "code" : "T68XXX",
      "display" : "T68XXX Hipotermia"
    },
    {
      "code" : "T68XXXS",
      "display" : "T68XXXS Hipotermia secuela"
    },
    {
      "code" : "T6901",
      "display" : "T6901 Mano de inmersión"
    },
    {
      "code" : "T69011D",
      "display" : "T69011D Mano de inmersión lado derecho contacto sucesivo"
    },
    {
      "code" : "T69012D",
      "display" : "T69012D Mano de inmersión lado izquierdo contacto sucesivo"
    },
    {
      "code" : "T69019S",
      "display" : "T69019S Mano de inmersión mano no especificada secuela"
    },
    {
      "code" : "T530X",
      "display" : "T530X Efecto tóxico de tetracloruro de carbono"
    },
    {
      "code" : "T530X1D",
      "display" : "T530X1D Efecto tóxico de tetracloruro de carbono accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T530X3",
      "display" : "T530X3 Efecto tóxico de tetracloruro de carbono agresión"
    },
    {
      "code" : "T530X4",
      "display" : "T530X4 Efecto tóxico de tetracloruro de carbono intencionalidad sin determinar"
    },
    {
      "code" : "T531X",
      "display" : "T531X Efecto tóxico de cloroformo"
    },
    {
      "code" : "T531X1D",
      "display" : "T531X1D Efecto tóxico de cloroformo accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T593X4A",
      "display" : "T593X4A Efecto tóxico de gas lacrimógeno intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T594X1",
      "display" : "T594X1 Efecto tóxico de gas de cloro accidental (no intencionado)"
    },
    {
      "code" : "T594X2",
      "display" : "T594X2 Efecto tóxico de gas de cloro autolesión intencionada"
    },
    {
      "code" : "T594X3",
      "display" : "T594X3 Efecto tóxico de gas de cloro agresión"
    },
    {
      "code" : "T594X4",
      "display" : "T594X4 Efecto tóxico de gas de cloro intencionalidad sin determinar"
    },
    {
      "code" : "T595",
      "display" : "T595 Efecto tóxico de gas de flúor y fluoruro de hidrógeno"
    },
    {
      "code" : "T595X1S",
      "display" : "T595X1S Efecto tóxico de gas de flúor y fluoruro de hidrógeno accidental (no intencionado) secuela"
    },
    {
      "code" : "T63412D",
      "display" : "T63412D Efecto tóxico de veneno de ciempiés y milpiés venenosos autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T63413S",
      "display" : "T63413S Efecto tóxico de veneno de ciempiés y milpiés venenosos agresión secuela"
    },
    {
      "code" : "T6342",
      "display" : "T6342 Efecto tóxico de veneno de hormigas"
    },
    {
      "code" : "T63421S",
      "display" : "T63421S Efecto tóxico de veneno de hormigas accidental (no intencionado) secuela"
    },
    {
      "code" : "T63423",
      "display" : "T63423 Efecto tóxico de veneno de hormigas agresión"
    },
    {
      "code" : "T699XXA",
      "display" : "T699XXA Efecto de baja temperatura no especificada contacto inicial"
    },
    {
      "code" : "T700X",
      "display" : "T700X Barotrauma ótico"
    },
    {
      "code" : "T700XXD",
      "display" : "T700XXD Barotrauma ótico contacto sucesivo"
    },
    {
      "code" : "T701XX",
      "display" : "T701XX Barotrauma sinusal"
    },
    {
      "code" : "T701XXS",
      "display" : "T701XXS Barotrauma sinusal secuela"
    },
    {
      "code" : "T7020XA",
      "display" : "T7020XA Efectos no especificados de gran altitud contacto inicial"
    },
    {
      "code" : "T7029X",
      "display" : "T7029X Otros efectos de gran altitud"
    },
    {
      "code" : "T703",
      "display" : "T703 Enfermedad de los cajones [síndrome de descompresión]"
    },
    {
      "code" : "T703XXD",
      "display" : "T703XXD Enfermedad de los cajones [síndrome de descompresión] contacto sucesivo"
    },
    {
      "code" : "T704XXA",
      "display" : "T704XXA Efectos de fluidos a alta presión contacto inicial"
    },
    {
      "code" : "T532X4A",
      "display" : "T532X4A Efecto tóxico de tricloroetileno intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T533X1",
      "display" : "T533X1 Efecto tóxico de tetracloroetileno accidental (no intencionado)"
    },
    {
      "code" : "T533X2",
      "display" : "T533X2 Efecto tóxico de tetracloroetileno autolesión intencionada"
    },
    {
      "code" : "T533X3A",
      "display" : "T533X3A Efecto tóxico de tetracloroetileno agresión contacto inicial"
    },
    {
      "code" : "T533X4A",
      "display" : "T533X4A Efecto tóxico de tetracloroetileno intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T534X1",
      "display" : "T534X1 Efecto tóxico de diclorometano accidental (no intencionado)"
    },
    {
      "code" : "T534X2",
      "display" : "T534X2 Efecto tóxico de diclorometano autolesión intencionada"
    },
    {
      "code" : "T596X4S",
      "display" : "T596X4S Efecto tóxico de sulfuro de hidrógeno intencionalidad sin determinar secuela"
    },
    {
      "code" : "T597X1D",
      "display" : "T597X1D Efecto tóxico de dióxido de carbono accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T597X2S",
      "display" : "T597X2S Efecto tóxico de dióxido de carbono autolesión intencionada secuela"
    },
    {
      "code" : "T597X4",
      "display" : "T597X4 Efecto tóxico de dióxido de carbono intencionalidad sin determinar"
    },
    {
      "code" : "T5981",
      "display" : "T5981 Efecto tóxico de humo"
    },
    {
      "code" : "T63441S",
      "display" : "T63441S Efecto tóxico de veneno de abejas accidental (no intencionado) secuela"
    },
    {
      "code" : "T63443",
      "display" : "T63443 Efecto tóxico de veneno de abejas agresión"
    },
    {
      "code" : "T63444",
      "display" : "T63444 Efecto tóxico de veneno de abejas intencionalidad sin determinar"
    },
    {
      "code" : "T6345",
      "display" : "T6345 Efecto tóxico de veneno de avispones"
    },
    {
      "code" : "T63451S",
      "display" : "T63451S Efecto tóxico de veneno de avispones accidental (no intencionado) secuela"
    },
    {
      "code" : "T63453",
      "display" : "T63453 Efecto tóxico de veneno de avispones agresión"
    },
    {
      "code" : "T63454",
      "display" : "T63454 Efecto tóxico de veneno de avispones intencionalidad sin determinar"
    },
    {
      "code" : "T71114",
      "display" : "T71114 Asfixia por (debida a) sofocación bajo una almohada intencionalidad sin determinar"
    },
    {
      "code" : "T71121",
      "display" : "T71121 Asfixia por (debida a) bolsa de plástico accidental"
    },
    {
      "code" : "T71122",
      "display" : "T71122 Asfixia por (debida a) bolsa de plástico autolesión intencionada"
    },
    {
      "code" : "T71123A",
      "display" : "T71123A Asfixia por (debida a) bolsa de plástico agresión contacto inicial"
    },
    {
      "code" : "T71124A",
      "display" : "T71124A Asfixia por (debida a) bolsa de plástico intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T71131A",
      "display" : "T71131A Asfixia por (debida a) quedar atrapado en ropa de cama accidental contacto inicial"
    },
    {
      "code" : "T536",
      "display" : "T536 Efecto tóxico de otros derivados halogenados de hidrocarburos alifáticos"
    },
    {
      "code" : "T536X1S",
      "display" : "T536X1S Efecto tóxico de otros derivados halogenados de hidrocarburos alifáticos accidental (no intencionado) secuela"
    },
    {
      "code" : "T536X3A",
      "display" : "T536X3A Efecto tóxico de otros derivados halogenados de hidrocarburos alifáticos agresión contacto inicial"
    },
    {
      "code" : "T536X4A",
      "display" : "T536X4A Efecto tóxico de otros derivados halogenados de hidrocarburos alifáticos intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T59893S",
      "display" : "T59893S Efecto tóxico de otros gases humos y vapores especificados agresión secuela"
    },
    {
      "code" : "T599",
      "display" : "T599 Efecto tóxico de gases humos y vapores no especificados"
    },
    {
      "code" : "T5991XD",
      "display" : "T5991XD Efecto tóxico de gases humos y vapores no especificados accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T5992XS",
      "display" : "T5992XS Efecto tóxico de gases humos y vapores no especificados autolesión intencionada secuela"
    },
    {
      "code" : "T5993XS",
      "display" : "T5993XS Efecto tóxico de gases humos y vapores no especificados agresión secuela"
    },
    {
      "code" : "T83122S",
      "display" : "T83122S Desplazamiento de endoprótesis ureteral permanente secuela"
    },
    {
      "code" : "T83128",
      "display" : "T83128 Desplazamiento de otros dispositivos e implantes urinarios"
    },
    {
      "code" : "T8319",
      "display" : "T8319 Otra complicación mecánica de otros dispositivos e implantes urinarios"
    },
    {
      "code" : "T83191",
      "display" : "T83191 Otra complicación mecánica de esfínter urinario implantado"
    },
    {
      "code" : "T83192A",
      "display" : "T83192A Otra complicación mecánica de endoprótesis ureteral permanente contacto inicial"
    },
    {
      "code" : "T83193D",
      "display" : "T83193D Otra complicación mecánica de otra endoprótesis urinaria contacto sucesivo"
    },
    {
      "code" : "T8459XS",
      "display" : "T8459XS Infección y reacción inflamatoria por (debida a) otro tipo de prótesis interna de articulación secuela"
    },
    {
      "code" : "T8460XS",
      "display" : "T8460XS Infección y reacción inflamatoria por (debida a) dispositivo de fijación interna de localización no especificada secuela"
    },
    {
      "code" : "T84611",
      "display" : "T84611 Infección y reacción inflamatoria por (debida a) dispositivo de fijación interna de húmero izquierdo"
    },
    {
      "code" : "V00281",
      "display" : "V00281 Caída desde otro tipo de transporte peatonal de tipo deslizante"
    },
    {
      "code" : "V00282A",
      "display" : "V00282A Colisión entre otro tipo de transporte peatonal de tipo deslizante con objeto físico contacto inicial"
    },
    {
      "code" : "V00288S",
      "display" : "V00288S Otro accidente en otro tipo de transporte peatonal de tipo deslizante secuela"
    },
    {
      "code" : "V00311D",
      "display" : "V00311D Caída desde snowboard contacto sucesivo"
    },
    {
      "code" : "V00312D",
      "display" : "V00312D Peatón en snowboard que colisiona con objeto fijo contacto sucesivo"
    },
    {
      "code" : "V00318D",
      "display" : "V00318D Otros accidentes en snowboard contacto sucesivo"
    },
    {
      "code" : "V00321D",
      "display" : "V00321D Caída desde esquí de nieve contacto sucesivo"
    },
    {
      "code" : "T81515S",
      "display" : "T81515S Adherencias por (debidas a) cuerpo extraño dejado accidentalmente en el interior del cuerpo después de cateterismo cardiaco secuela"
    },
    {
      "code" : "T81517D",
      "display" : "T81517D Adherencias por (debidas a) cuerpo extraño dejado accidentalmente en el interior del cuerpo después de retirada de catéter o packing contacto sucesivo"
    },
    {
      "code" : "T84621",
      "display" : "T84621 Infección y reacción inflamatoria por (debida a) dispositivo de fijación interna de fémur izquierdo"
    },
    {
      "code" : "T84622A",
      "display" : "T84622A Infección y reacción inflamatoria por (debida a) dispositivo de fijación interna de tibia derecha contacto inicial"
    },
    {
      "code" : "T849XX",
      "display" : "T849XX Complicación no especificada de prótesis implante e injerto ortopédico interno"
    },
    {
      "code" : "T850",
      "display" : "T850 Complicación mecánica de derivación ventricular intracraneal (comunicante)"
    },
    {
      "code" : "T8501XD",
      "display" : "T8501XD Avería mecánica de derivación ventricular intracraneal (comunicante) contacto sucesivo"
    },
    {
      "code" : "T8502XS",
      "display" : "T8502XS Desplazamiento de derivación ventricular intracraneal (comunicante) secuela"
    },
    {
      "code" : "T8503XS",
      "display" : "T8503XS Fuga de derivación ventricular intracraneal (comunicante) secuela"
    },
    {
      "code" : "V00811S",
      "display" : "V00811S Caída desde silla de ruedas (eléctrica) secuela"
    },
    {
      "code" : "V00812S",
      "display" : "V00812S Colisión entre sillas de ruedas (eléctrica) con objeto fijo secuela"
    },
    {
      "code" : "V00818S",
      "display" : "V00818S Otros accidentes en silla de ruedas (eléctrica) secuela"
    },
    {
      "code" : "V00821S",
      "display" : "V00821S Caída desde coche de niño secuela"
    },
    {
      "code" : "V00822D",
      "display" : "V00822D Coche de niño que colisiona con objeto fijo contacto sucesivo"
    },
    {
      "code" : "V00828S",
      "display" : "V00828S Otros accidentes con coche de niño secuela"
    },
    {
      "code" : "V00831D",
      "display" : "V00831D Caída desde patinete motorizado móvil contacto sucesivo"
    },
    {
      "code" : "V00832S",
      "display" : "V00832S Patinete motorizado móvil que colisiona con objeto estacionado secuela"
    },
    {
      "code" : "T81524S",
      "display" : "T81524S Obstrucción por (debida a) cuerpo extraño dejado accidentalmente en el interior del cuerpo después de exploración endoscópica secuela"
    },
    {
      "code" : "T847XXD",
      "display" : "T847XXD Infección y reacción inflamatoria por (debida a) otras prótesis implantes e injertos ortopédicos internos contacto sucesivo"
    },
    {
      "code" : "T8481XD",
      "display" : "T8481XD Embolia por (debida a) prótesis implantes e injertos ortopédicos internos contacto sucesivo"
    },
    {
      "code" : "T8482XS",
      "display" : "T8482XS Fibrosis por (debida a) prótesis implantes e injertos ortopédicos internos secuela"
    },
    {
      "code" : "T462X2A",
      "display" : "T462X2A Envenenamiento por otros fármacos antiarrítmicos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T492X",
      "display" : "T492X Envenenamiento efecto adverso e infradosificación por astringentes y detergentes locales"
    },
    {
      "code" : "T492X2A",
      "display" : "T492X2A Envenenamiento por astringentes y detergentes locales autolesión intencionada contacto inicial"
    },
    {
      "code" : "T492X3D",
      "display" : "T492X3D Envenenamiento por astringentes y detergentes locales agresión contacto sucesivo"
    },
    {
      "code" : "T492X5",
      "display" : "T492X5 Efecto adverso de astringentes locales y detergentes locales"
    },
    {
      "code" : "T492X6",
      "display" : "T492X6 Infradosificación de astringentes y detergentes locales"
    },
    {
      "code" : "T421X5D",
      "display" : "T421X5D Efecto adverso de iminostilbenos contacto sucesivo"
    },
    {
      "code" : "T421X6S",
      "display" : "T421X6S Infradosificación de iminostilbenos secuela"
    },
    {
      "code" : "T422X1A",
      "display" : "T422X1A Envenenamiento por succinimidas y oxazolidindionas accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T422X2D",
      "display" : "T422X2D Envenenamiento por succinimidas y oxazolidindionas autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T422X4",
      "display" : "T422X4 Envenenamiento por succinimidas y oxazolidindionas intencionalidad sin determinar"
    },
    {
      "code" : "T422X5A",
      "display" : "T422X5A Efecto adverso de succinimidas y oxazolidindionas contacto inicial"
    },
    {
      "code" : "T442X5A",
      "display" : "T442X5A Efecto adverso de fármacos bloqueantes ganglionares contacto inicial"
    },
    {
      "code" : "T442X6D",
      "display" : "T442X6D Infradosificación de fármacos bloqueantes ganglionares contacto sucesivo"
    },
    {
      "code" : "T443X1A",
      "display" : "T443X1A Envenenamiento por otros parasimpaticolíticos [anticolinérgicos y antimuscarínicos] y espasmolíticos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T443X3",
      "display" : "T443X3 Envenenamiento por otros parasimpaticolíticos [anticolinérgicos y antimuscarínicos] y espasmolíticos agresión"
    },
    {
      "code" : "T463X3A",
      "display" : "T463X3A Envenenamiento por vasodilatadores coronarios agresión contacto inicial"
    },
    {
      "code" : "T463X4D",
      "display" : "T463X4D Envenenamiento por vasodilatadores coronarios intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T463X5S",
      "display" : "T463X5S Efecto adverso de vasodilatadores coronarios secuela"
    },
    {
      "code" : "T464",
      "display" : "T464 Envenenamiento efecto adverso e infradosificación por inhibidores de enzima convertidora de angiotensina"
    },
    {
      "code" : "T464X1S",
      "display" : "T464X1S Envenenamiento por inhibidores de la enzima convertidora de angiotensina accidental (no intencionado) secuela"
    },
    {
      "code" : "T494X",
      "display" : "T494X Envenenamiento efecto adverso e infradosificación por queratolíticos queratoplásticos y otros fármacos y preparados para el tratamiento del cabello"
    },
    {
      "code" : "T494X2D",
      "display" : "T494X2D Envenenamiento por queratolíticos queratoplásticos y otros fármacos y preparados para el tratamiento del cabello autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T424",
      "display" : "T424 Envenenamiento efecto adverso e infradosificación por benzodiacepinas"
    },
    {
      "code" : "T424X1S",
      "display" : "T424X1S Envenenamiento por benzodiacepinas accidental (no intencionado) secuela"
    },
    {
      "code" : "T424X3",
      "display" : "T424X3 Envenenamiento por benzodiacepinas agresión"
    },
    {
      "code" : "T424X3S",
      "display" : "T424X3S Envenenamiento por benzodiacepinas agresión secuela"
    },
    {
      "code" : "T424X4S",
      "display" : "T424X4S Envenenamiento por benzodiacepinas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T424X6",
      "display" : "T424X6 Infradosificación de benzodiacepinas"
    },
    {
      "code" : "T444X3D",
      "display" : "T444X3D Envenenamiento por agonistas predominantemente de receptores alfa-adrenérgicos agresión contacto sucesivo"
    },
    {
      "code" : "T444X5",
      "display" : "T444X5 Efecto adverso de agonistas predominantemente de receptores alfa-adrenérgicos"
    },
    {
      "code" : "T444X6A",
      "display" : "T444X6A Infradosificación de agonistas predominantemente de receptores alfa-adrenérgicos contacto inicial"
    },
    {
      "code" : "T465X2A",
      "display" : "T465X2A Envenenamiento por otros fármacos antihipertensivos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T465X3S",
      "display" : "T465X3S Envenenamiento por otros fármacos antihipertensivos agresión secuela"
    },
    {
      "code" : "T465X5",
      "display" : "T465X5 Efecto adverso de otros fármacos antihipertensivos"
    },
    {
      "code" : "T465X6",
      "display" : "T465X6 Infradosificación de otros fármacos antihipertensivos"
    },
    {
      "code" : "T495X4S",
      "display" : "T495X4S Envenenamiento por fármacos y preparados oftalmológicos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T495X6",
      "display" : "T495X6 Infradosificación de medicamentos y preparados oftalmológicos"
    },
    {
      "code" : "T496X",
      "display" : "T496X Envenenamiento efecto adverso e infradosificación de fármacos y preparados otorrinolaringológicos"
    },
    {
      "code" : "T426X1",
      "display" : "T426X1 Envenenamiento por otros fármacos antiepilépticos e hipnótico-sedantes accidental (no intencionado)"
    },
    {
      "code" : "T426X2D",
      "display" : "T426X2D Envenenamiento por otros fármacos antiepilépticos e hipnótico-sedantes autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T426X4",
      "display" : "T426X4 Envenenamiento por otros fármacos antiepilépticos e hipnótico-sedantes intencionalidad sin determinar"
    },
    {
      "code" : "T445X6D",
      "display" : "T445X6D Infradosificación de agonistas predominantemente de receptores beta-adrenérgicos contacto sucesivo"
    },
    {
      "code" : "T446X1D",
      "display" : "T446X1D Envenenamiento por antagonistas de receptores alfa-adrenérgicos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T446X3",
      "display" : "T446X3 Envenenamiento por antagonistas de receptores alfa-adrenérgicos agresión"
    },
    {
      "code" : "T466X6S",
      "display" : "T466X6S Infradosificación de fármacos antihiperlipémicos y antiarterioscleróticos secuela"
    },
    {
      "code" : "T467X1D",
      "display" : "T467X1D Envenenamiento por vasodilatadores periféricos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T467X2S",
      "display" : "T467X2S Envenenamiento por vasodilatadores periféricos autolesión intencionada secuela"
    },
    {
      "code" : "T467X4A",
      "display" : "T467X4A Envenenamiento por vasodilatadores periféricos intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T497X1S",
      "display" : "T497X1S Envenenamiento por fármacos de uso dental aplicación tópica accidental (no intencionado) secuela"
    },
    {
      "code" : "T497X3A",
      "display" : "T497X3A Envenenamiento por fármacos de uso dental aplicación tópica agresión contacto inicial"
    },
    {
      "code" : "T497X4D",
      "display" : "T497X4D Envenenamiento por fármacos de uso dental aplicación tópica intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T497X6",
      "display" : "T497X6 Infradosificación de fármacos de uso dental en aplicación tópica"
    },
    {
      "code" : "T4275XA",
      "display" : "T4275XA Efecto adverso de fármacos antiepilépticos e hipnótico-sedantes no especificados contacto inicial"
    },
    {
      "code" : "T4276XD",
      "display" : "T4276XD Infradosificación de fármacos antiepilépticos e hipnótico-sedantes no especificados contacto sucesivo"
    },
    {
      "code" : "T428X1A",
      "display" : "T428X1A Envenenamiento por fármacos antiparkinsonianos y otros depresores del tono muscular accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T447X4S",
      "display" : "T447X4S Envenenamiento por antagonistas beta-adrenérgicos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T447X6A",
      "display" : "T447X6A Infradosificación de antagonistas de receptores beta-adrenérgicos contacto inicial"
    },
    {
      "code" : "T448X",
      "display" : "T448X Envenenamiento efecto adverso e infradosificación por agentes bloqueantes neuronales de acción central y adrenérgicos"
    },
    {
      "code" : "T468X5D",
      "display" : "T468X5D Efecto adverso de fármacos antivaricosos incluidos agentes esclerosantes contacto sucesivo"
    },
    {
      "code" : "T468X6S",
      "display" : "T468X6S Infradosificación de fármacos antivaricosos incluidos agentes esclerosantes secuela"
    },
    {
      "code" : "T46901S",
      "display" : "T46901S Envenenamiento por agentes no especificados que afectan principalmente al aparato cardiovascular accidental (no intencionado) secuela"
    },
    {
      "code" : "T498X6A",
      "display" : "T498X6A Infradosificación de otros agentes tópicos contacto inicial"
    },
    {
      "code" : "T4991",
      "display" : "T4991 Envenenamiento por agente tópico no especificado accidental (no intencionado)"
    },
    {
      "code" : "T4992",
      "display" : "T4992 Envenenamiento por agente tópico no especificado autolesión intencionada"
    },
    {
      "code" : "T4993",
      "display" : "T4993 Envenenamiento por agente tópico no especificado agresión"
    },
    {
      "code" : "T4994",
      "display" : "T4994 Envenenamiento por agente tópico no especificado intencionalidad sin determinar"
    },
    {
      "code" : "T4995",
      "display" : "T4995 Efecto adverso de agente tópico no especificado"
    },
    {
      "code" : "T43011",
      "display" : "T43011 Envenenamiento por antidepresivos tricíclicos accidental (no intencionado)"
    },
    {
      "code" : "T43012A",
      "display" : "T43012A Envenenamiento por antidepresivos tricíclicos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T43013S",
      "display" : "T43013S Envenenamiento por antidepresivos tricíclicos agresión secuela"
    },
    {
      "code" : "T43014S",
      "display" : "T43014S Envenenamiento por antidepresivos tricíclicos intencionalidad sin determinar secuela"
    },
    {
      "code" : "T44902S",
      "display" : "T44902S Envenenamiento por fármacos no especificados que afectan principalmente al sistema nervioso autónomo autolesión intencionada secuela"
    },
    {
      "code" : "T44904D",
      "display" : "T44904D Envenenamiento por fármacos no especificados que afectan principalmente al sistema nervioso autónomo intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T46993",
      "display" : "T46993 Envenenamiento por otros agentes que afectan principalmente al aparato cardiovascular agresión"
    },
    {
      "code" : "T46994A",
      "display" : "T46994A Envenenamiento por otros agentes que afectan principalmente al aparato cardiovascular intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T46996",
      "display" : "T46996 Infradosificación de otros agentes que afectan principalmente al aparato cardiovascular"
    },
    {
      "code" : "T500X4S",
      "display" : "T500X4S Envenenamiento por mineralcorticoides y sus antagonistas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T500X6A",
      "display" : "T500X6A Infradosificación de mineralcorticoides y sus antagonistas contacto inicial"
    },
    {
      "code" : "T501X",
      "display" : "T501X Envenenamiento efecto adverso e infradosificación de diuréticos de asa [de techo alto]"
    },
    {
      "code" : "T501X2",
      "display" : "T501X2 Envenenamiento por diuréticos de asa [de techo alto] autolesión intencionada"
    },
    {
      "code" : "T501X3A",
      "display" : "T501X3A Envenenamiento por diuréticos de asa [de techo alto] agresión contacto inicial"
    },
    {
      "code" : "T43025D",
      "display" : "T43025D Efecto adverso de antidepresivos tetracíclicos contacto sucesivo"
    },
    {
      "code" : "T43026D",
      "display" : "T43026D Infradosificación de antidepresivos tetracíclicos contacto sucesivo"
    },
    {
      "code" : "T431X1A",
      "display" : "T431X1A Envenenamiento por antidepresivos inhibidores de monoamino-oxidasa accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T431X2S",
      "display" : "T431X2S Envenenamiento por antidepresivos inhibidores de monoamino-oxidasa autolesión intencionada secuela"
    },
    {
      "code" : "T431X4A",
      "display" : "T431X4A Envenenamiento por antidepresivos inhibidores de monoamino-oxidasa intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T44995D",
      "display" : "T44995D Efecto adverso de otros fármacos que afectan principalmente al sistema nervioso autónomo contacto sucesivo"
    },
    {
      "code" : "T45",
      "display" : "T45 Envenenamiento efecto adverso e infradosificación por agentes principalmente sistémicos y hematológicos no clasificados bajo otro concepto"
    },
    {
      "code" : "T44905",
      "display" : "T44905 Efecto adverso de medicamentos no especificados que afectan principalmente al sistema nervioso autónomo"
    },
    {
      "code" : "T470X6D",
      "display" : "T470X6D Infradosificación de bloqueantes de receptores histamínicos H2 contacto sucesivo"
    },
    {
      "code" : "T471X1A",
      "display" : "T471X1A Envenenamiento por otros antiácidos y fármacos anti-secreción gástrica accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T471X3",
      "display" : "T471X3 Envenenamiento por otros antiácidos y fármacos anti-secreción gástrica agresión"
    },
    {
      "code" : "T502X3S",
      "display" : "T502X3S Envenenamiento por inhibidores de la anhidrasa carbónica benzotiadiacidas y otros diuréticos agresión secuela"
    },
    {
      "code" : "T502X5A",
      "display" : "T502X5A Efecto adverso de inhibidores de la anhidrasa carbónica benzotiadiacidas y otros diuréticos contacto inicial"
    },
    {
      "code" : "T502X6S",
      "display" : "T502X6S Infradosificación de inhibidores de la anhidrasa carbónica benzotiadiacidas y otros diuréticos secuela"
    },
    {
      "code" : "T43205D",
      "display" : "T43205D Efecto adverso de antidepresivos no especificados contacto sucesivo"
    },
    {
      "code" : "T43206S",
      "display" : "T43206S Infradosificación de antidepresivos no especificados secuela"
    },
    {
      "code" : "T43211D",
      "display" : "T43211D Envenenamiento por inhibidores selectivos de la recaptación de serotonina y noradrenalina accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T451X1D",
      "display" : "T451X1D Envenenamiento por fármacos antineoplásicos e inmunosupresores accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T451X3",
      "display" : "T451X3 Envenenamiento por fármacos antineoplásicos e inmunosupresores agresión"
    },
    {
      "code" : "T451X4A",
      "display" : "T451X4A Envenenamiento por fármacos antineoplásicos e inmunosupresores intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T451X5S",
      "display" : "T451X5S Efecto adverso de fármacos antineoplásicos e inmunosupresores secuela"
    },
    {
      "code" : "T472X4",
      "display" : "T472X4 Envenenamiento por laxantes estimulantes intencionalidad sin determinar"
    },
    {
      "code" : "T472X5A",
      "display" : "T472X5A Efecto adverso de laxantes estimulantes contacto inicial"
    },
    {
      "code" : "T472X6D",
      "display" : "T472X6D Infradosificación de laxantes estimulantes contacto sucesivo"
    },
    {
      "code" : "T473X1",
      "display" : "T473X1 Envenenamiento por laxantes salinos y osmóticos accidental (no intencionado)"
    },
    {
      "code" : "T473X2A",
      "display" : "T473X2A Envenenamiento por laxantes salinos y osmóticos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T504X1A",
      "display" : "T504X1A Envenenamiento por fármacos que afectan al metabolismo del ácido úrico accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T504X3",
      "display" : "T504X3 Envenenamiento por fármacos que afectan al metabolismo del ácido úrico agresión"
    },
    {
      "code" : "T504X4A",
      "display" : "T504X4A Envenenamiento por fármacos que afectan al metabolismo del ácido úrico intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T43223",
      "display" : "T43223 Envenenamiento por inhibidores selectivos de la recaptación de serotonina agresión"
    },
    {
      "code" : "T43224D",
      "display" : "T43224D Envenenamiento por inhibidores selectivos de la recaptación de serotonina intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T43226",
      "display" : "T43226 Infradosificación de inhibidores selectivos de la recaptación de serotonina"
    },
    {
      "code" : "T43291",
      "display" : "T43291 Envenenamiento por otros antidepresivos accidental (no intencionado)"
    },
    {
      "code" : "T453X1",
      "display" : "T453X1 Envenenamiento por enzimas accidental (no intencionado)"
    },
    {
      "code" : "T453X2",
      "display" : "T453X2 Envenenamiento por enzimas autolesión intencionada"
    },
    {
      "code" : "T453X3A",
      "display" : "T453X3A Envenenamiento por enzimas agresión contacto inicial"
    },
    {
      "code" : "T453X4",
      "display" : "T453X4 Envenenamiento por enzimas intencionalidad sin determinar"
    },
    {
      "code" : "T453X5",
      "display" : "T453X5 Efecto adverso de enzimas"
    },
    {
      "code" : "T453X6",
      "display" : "T453X6 Infradosificación de enzimas"
    },
    {
      "code" : "T453X6S",
      "display" : "T453X6S Infradosificación de enzimas secuela"
    },
    {
      "code" : "T454X1A",
      "display" : "T454X1A Envenenamiento por hierro y sus compuestos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T71151D",
      "display" : "T71151D Asfixia por (debida a) sofocación dentro de muebles accidental contacto sucesivo"
    },
    {
      "code" : "T71152S",
      "display" : "T71152S Asfixia por (debida a) sofocación dentro de muebles autolesión intencionada secuela"
    },
    {
      "code" : "T71153S",
      "display" : "T71153S Asfixia por (debida a) sofocación dentro de muebles agresión secuela"
    },
    {
      "code" : "T7116",
      "display" : "T7116 Asfixia por (debida a) ahorcamiento"
    },
    {
      "code" : "T5392XS",
      "display" : "T5392XS Efecto tóxico de derivados halogenados no especificados de hidrocarburos alifáticos y aromáticos autolesión intencionada secuela"
    },
    {
      "code" : "T5394",
      "display" : "T5394 Efecto tóxico de derivados halogenados no especificados de hidrocarburos alifáticos y aromáticos intencionalidad sin determinar"
    },
    {
      "code" : "T601X1A",
      "display" : "T601X1A Efecto tóxico de insecticidas halogenados accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T601X2S",
      "display" : "T601X2S Efecto tóxico de insecticidas halogenados autolesión intencionada secuela"
    },
    {
      "code" : "T601X4",
      "display" : "T601X4 Efecto tóxico de insecticidas halogenados intencionalidad sin determinar"
    },
    {
      "code" : "T602",
      "display" : "T602 Efecto tóxico de otros insecticidas"
    },
    {
      "code" : "T602X1D",
      "display" : "T602X1D Efecto tóxico de otros insecticidas accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63482D",
      "display" : "T63482D Efecto tóxico de veneno de otro artrópodo autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T63483S",
      "display" : "T63483S Efecto tóxico de veneno de otro artrópodo agresión secuela"
    },
    {
      "code" : "T63484S",
      "display" : "T63484S Efecto tóxico de veneno de otro artrópodo intencionalidad sin determinar secuela"
    },
    {
      "code" : "T63511D",
      "display" : "T63511D Efecto tóxico de contacto con raya accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63512S",
      "display" : "T63512S Efecto tóxico de contacto con raya autolesión intencionada secuela"
    },
    {
      "code" : "T63514",
      "display" : "T63514 Efecto tóxico de contacto con raya intencionalidad sin determinar"
    },
    {
      "code" : "T71193S",
      "display" : "T71193S Asfixia por (debida a) obstrucción mecánica de la respiración por (debido a) otras causas agresión secuela"
    },
    {
      "code" : "T71161D",
      "display" : "T71161D Asfixia por (debida a) ahorcamiento accidental contacto sucesivo"
    },
    {
      "code" : "T7120XS",
      "display" : "T7120XS Asfixia por (debida a) déficit sistémico de oxígeno por bajo contenido de oxígeno en aire ambiente por causa no especificada secuela"
    },
    {
      "code" : "T71221",
      "display" : "T71221 Asfixia por (debida a) quedar atrapado en maletero de coche accidentalmente"
    },
    {
      "code" : "T541X3D",
      "display" : "T541X3D Efecto tóxico de otros compuestos orgánicos corrosivos agresión contacto sucesivo"
    },
    {
      "code" : "T542",
      "display" : "T542 Efecto tóxico de ácidos corrosivos y sustancias similares a ácidos"
    },
    {
      "code" : "T542X1A",
      "display" : "T542X1A Efecto tóxico de ácidos corrosivos y sustancias similares a ácidos accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T542X3",
      "display" : "T542X3 Efecto tóxico de ácidos corrosivos y sustancias similares a ácidos agresión"
    },
    {
      "code" : "T604",
      "display" : "T604 Efecto tóxico de raticidas"
    },
    {
      "code" : "T604X1A",
      "display" : "T604X1A Efecto tóxico de raticidas accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T604X2D",
      "display" : "T604X2D Efecto tóxico de raticidas autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T604X3S",
      "display" : "T604X3S Efecto tóxico de raticidas agresión secuela"
    },
    {
      "code" : "T604X4S",
      "display" : "T604X4S Efecto tóxico de raticidas intencionalidad sin determinar secuela"
    },
    {
      "code" : "T608X1D",
      "display" : "T608X1D Efecto tóxico de otros plaguicidas (pesticidas) accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63611D",
      "display" : "T63611D Efecto tóxico de contacto con Physalia physalis o carabela portuguesa accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T63613",
      "display" : "T63613 Efecto tóxico de contacto con Physalia physalis o carabela portuguesa agresión"
    },
    {
      "code" : "T63614A",
      "display" : "T63614A Efecto tóxico de contacto con Physalia physalis o carabela portuguesa intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T63621S",
      "display" : "T63621S Efecto tóxico de contacto con otras medusas accidental (no intencionado) secuela"
    },
    {
      "code" : "T71233",
      "display" : "T71233 Asfixia por (debida a) quedar atrapado en un frigorífico (abandonado) agresión"
    },
    {
      "code" : "T71234A",
      "display" : "T71234A Asfixia por (debida a) quedar atrapado en un frigorífico (abandonado) intencionalidad sin determinar contacto inicial"
    },
    {
      "code" : "T7129XD",
      "display" : "T7129XD Asfixia por (debida a) quedar atrapado en otro ambiente con poco oxígeno contacto sucesivo"
    },
    {
      "code" : "T719XXD",
      "display" : "T719XXD Asfixia por (debida a) causa no especificada contacto sucesivo"
    },
    {
      "code" : "T730XX",
      "display" : "T730XX Hambre (ayuno)"
    },
    {
      "code" : "T5491XA",
      "display" : "T5491XA Efecto tóxico de sustancia corrosiva no especificada accidental (no intencionado) contacto inicial"
    },
    {
      "code" : "T5492XD",
      "display" : "T5492XD Efecto tóxico de sustancia corrosiva no especificada autolesión intencionada contacto sucesivo"
    },
    {
      "code" : "T83490D",
      "display" : "T83490D Otra complicación mecánica de prótesis peneana implantada contacto sucesivo"
    },
    {
      "code" : "T23751A",
      "display" : "T23751A Corrosión de tercer grado de palma de la mano derecha contacto inicial"
    },
    {
      "code" : "T23752D",
      "display" : "T23752D Corrosión de tercer grado de palma de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "T23759S",
      "display" : "T23759S Corrosión de tercer grado de palma de mano no especificada secuela"
    },
    {
      "code" : "T23761S",
      "display" : "T23761S Corrosión de tercer grado de dorso de mano derecha secuela"
    },
    {
      "code" : "T2013X",
      "display" : "T2013X Quemadura de primer grado de mentón"
    },
    {
      "code" : "T2014",
      "display" : "T2014 Quemadura de primer grado de nariz (tabique)"
    },
    {
      "code" : "T2014XS",
      "display" : "T2014XS Quemadura de primer grado de nariz (tabique) secuela"
    },
    {
      "code" : "T2015XD",
      "display" : "T2015XD Quemadura de primer grado de cuero cabelludo [cualquier parte] contacto sucesivo"
    },
    {
      "code" : "T2016XA",
      "display" : "T2016XA Quemadura de primer grado de frente y mejilla contacto inicial"
    },
    {
      "code" : "T2017XA",
      "display" : "T2017XA Quemadura de primer grado del cuello contacto inicial"
    },
    {
      "code" : "T2019X",
      "display" : "T2019X Quemadura de primer grado de localizaciones múltiples de cabeza cara y cuello"
    },
    {
      "code" : "T23061A",
      "display" : "T23061A Quemadura de grado no especificado de dorso de la mano derecha contacto inicial"
    },
    {
      "code" : "T23062D",
      "display" : "T23062D Quemadura de grado no especificado de dorso de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "T2307",
      "display" : "T2307 Quemadura de grado no especificado de muñeca"
    },
    {
      "code" : "T23071S",
      "display" : "T23071S Quemadura de grado no especificado de muñeca derecha secuela"
    },
    {
      "code" : "T23072S",
      "display" : "T23072S Quemadura de grado no especificado de muñeca izquierda secuela"
    },
    {
      "code" : "T2309",
      "display" : "T2309 Quemadura de grado no especificado de localizaciones múltiples de muñeca y mano"
    },
    {
      "code" : "T23142A",
      "display" : "T23142A Quemadura de primer grado de múltiples dedos de la mano izquierda (uñas) incluido el pulgar contacto inicial"
    },
    {
      "code" : "T23149S",
      "display" : "T23149S Quemadura de primer grado de múltiples dedos (uñas) de mano incluido el pulgar no especificado secuela"
    },
    {
      "code" : "T23152",
      "display" : "T23152 Quemadura de primer grado de palma de la mano izquierda"
    },
    {
      "code" : "T23159A",
      "display" : "T23159A Quemadura de primer grado de palma de mano no especificada contacto inicial"
    },
    {
      "code" : "T23792S",
      "display" : "T23792S Corrosión de tercer grado de localizaciones múltiples de muñeca y mano izquierdas secuela"
    },
    {
      "code" : "T240",
      "display" : "T240 Quemadura de grado no especificado de extremidad inferior excepto tobillo y pie"
    },
    {
      "code" : "T24001S",
      "display" : "T24001S Quemadura de grado no especificado de localización no especificado de extremidad inferior derecha excepto tobillo y pie secuela"
    },
    {
      "code" : "T2022XA",
      "display" : "T2022XA Quemadura de segundo grado de labio(s) contacto inicial"
    },
    {
      "code" : "T2023XA",
      "display" : "T2023XA Quemadura de segundo grado de mentón contacto inicial"
    },
    {
      "code" : "T2024X",
      "display" : "T2024X Quemadura de segundo grado de nariz (tabique)"
    },
    {
      "code" : "T2025",
      "display" : "T2025 Quemadura de segundo grado de cuero cabelludo [cualquier parte]"
    },
    {
      "code" : "T2026",
      "display" : "T2026 Quemadura de segundo grado de frente y mejilla"
    },
    {
      "code" : "T2026XS",
      "display" : "T2026XS Quemadura de segundo grado de frente y mejilla secuela"
    },
    {
      "code" : "T2027XD",
      "display" : "T2027XD Quemadura de segundo grado del cuello contacto sucesivo"
    },
    {
      "code" : "T23111",
      "display" : "T23111 Quemadura de primer grado de pulgar derecho (uña)"
    },
    {
      "code" : "T23112",
      "display" : "T23112 Quemadura de primer grado de pulgar izquierdo (uña)"
    },
    {
      "code" : "T23119",
      "display" : "T23119 Quemadura de primer grado de pulgar (uña) no especificado"
    },
    {
      "code" : "T23121",
      "display" : "T23121 Quemadura de primer grado de un solo dedo (uña) de mano derecha excepto el pulgar"
    },
    {
      "code" : "T23122A",
      "display" : "T23122A Quemadura de primer grado de un solo dedo (uña) de mano izquierda excepto el pulgar contacto inicial"
    },
    {
      "code" : "S60512A",
      "display" : "S60512A Abrasión de mano izquierda contacto inicial"
    },
    {
      "code" : "S61321D",
      "display" : "S61321D Desgarro con cuerpo extraño de dedo índice izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61322D",
      "display" : "S61322D Desgarro con cuerpo extraño de dedo medio derecho con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61324",
      "display" : "S61324 Desgarro con cuerpo extraño de dedo anular derecho con daños en la uña"
    },
    {
      "code" : "S61325A",
      "display" : "S61325A Desgarro con cuerpo extraño de dedo anular izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S62161K",
      "display" : "S62161K Fractura desplazada de pisiforme de muñeca derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62162D",
      "display" : "S62162D Fractura desplazada de pisiforme de muñeca izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62163A",
      "display" : "S62163A Fractura desplazada de pisiforme de muñeca no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S59131D",
      "display" : "S59131D Fractura fisaria tipo III de Salter-Harris de extremo superior de radio del brazo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S59132D",
      "display" : "S59132D Fractura fisaria tipo III de Salter-Harris de extremo superior de radio del brazo izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S60549A",
      "display" : "S60549A Constricción externa de mano no especificada contacto inicial"
    },
    {
      "code" : "S60551A",
      "display" : "S60551A Cuerpo extraño superficial de mano derecha contacto inicial"
    },
    {
      "code" : "S60552A",
      "display" : "S60552A Cuerpo extraño superficial de mano izquierda contacto inicial"
    },
    {
      "code" : "S60559D",
      "display" : "S60559D Cuerpo extraño superficial de mano no especificada contacto sucesivo"
    },
    {
      "code" : "S60561D",
      "display" : "S60561D Picadura de insecto (no venenoso) en mano derecha contacto sucesivo"
    },
    {
      "code" : "S60562S",
      "display" : "S60562S Picadura de insecto (no venenoso) en mano izquierda secuela"
    },
    {
      "code" : "S60569S",
      "display" : "S60569S Picadura de insecto (no venenoso) en mano no especificada secuela"
    },
    {
      "code" : "S61332A",
      "display" : "S61332A Herida punzante sin cuerpo extraño de dedo medio derecho con daños en la uña contacto inicial"
    },
    {
      "code" : "S61333D",
      "display" : "S61333D Herida punzante sin cuerpo extraño de dedo medio izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61335",
      "display" : "S61335 Herida punzante sin cuerpo extraño de dedo anular izquierdo con daños en la uña"
    },
    {
      "code" : "S61336A",
      "display" : "S61336A Herida punzante sin cuerpo extraño de dedo meñique derecho con daños en la uña contacto inicial"
    },
    {
      "code" : "S62166K",
      "display" : "S62166K Fractura sin desplazamiento de pisiforme de muñeca no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62171B",
      "display" : "S62171B Fractura desplazada de trapecio [multiangular mayor] de muñeca derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62172",
      "display" : "S62172 Fractura desplazada de trapecio [multiangular mayor] de muñeca izquierda"
    },
    {
      "code" : "S59149D",
      "display" : "S59149D Fractura fisaria tipo IV de Salter-Harris de extremo superior de radio de brazo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S59191A",
      "display" : "S59191A Otra fractura fisaria de extremo superior de radio del brazo derecho contacto inicial por fractura"
    },
    {
      "code" : "S60821D",
      "display" : "S60821D Ampolla (no térmica) de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S60822S",
      "display" : "S60822S Ampolla (no térmica) de muñeca izquierda secuela"
    },
    {
      "code" : "S60829S",
      "display" : "S60829S Ampolla (no térmica) de muñeca no especificada secuela"
    },
    {
      "code" : "S60841S",
      "display" : "S60841S Constricción externa de muñeca derecha secuela"
    },
    {
      "code" : "S60842S",
      "display" : "S60842S Constricción externa de muñeca izquierda secuela"
    },
    {
      "code" : "S60849S",
      "display" : "S60849S Constricción externa de muñeca no especificada secuela"
    },
    {
      "code" : "S60851S",
      "display" : "S60851S Cuerpo extraño superficial de muñeca derecha secuela"
    },
    {
      "code" : "S70312D",
      "display" : "S70312D Abrasión de muslo izquierdo contacto sucesivo"
    },
    {
      "code" : "S72061P",
      "display" : "S72061P Fractura articular desplazada de cabeza de fémur derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S72062C",
      "display" : "S72062C Fractura articular desplazada de cabeza de fémur izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S65999S",
      "display" : "S65999S Otro traumatismo especificado de vaso sanguíneo no especificado a nivel de muñeca y mano brazo no especificado secuela"
    },
    {
      "code" : "S66001S",
      "display" : "S66001S Traumatismo no especificado de músculo fascia y tendón de flexor largo de pulgar derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S66591A",
      "display" : "S66591A Otro traumatismo de músculo fascia y tendón intrínseco de dedo índice izquierdo a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66592S",
      "display" : "S66592S Otro traumatismo de músculo fascia y tendón intrínseco de dedo medio derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S70349",
      "display" : "S70349 Constricción externa de muslo no especificado"
    },
    {
      "code" : "S7035",
      "display" : "S7035 Cuerpo extraño superficial de muslo"
    },
    {
      "code" : "S70351D",
      "display" : "S70351D Cuerpo extraño superficial de muslo derecho contacto sucesivo"
    },
    {
      "code" : "S70352S",
      "display" : "S70352S Cuerpo extraño superficial de muslo izquierdo secuela"
    },
    {
      "code" : "S70359S",
      "display" : "S70359S Cuerpo extraño superficial de muslo no especificado secuela"
    },
    {
      "code" : "S70361S",
      "display" : "S70361S Picadura de insecto (no venenoso) en muslo derecho secuela"
    },
    {
      "code" : "S70362S",
      "display" : "S70362S Picadura de insecto (no venenoso) en muslo izquierdo secuela"
    },
    {
      "code" : "S7037",
      "display" : "S7037 Otra mordedura superficial de muslo"
    },
    {
      "code" : "S72064D",
      "display" : "S72064D Fractura articular sin desplazamiento de cabeza de fémur derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72064K",
      "display" : "S72064K Fractura articular sin desplazamiento de cabeza de fémur derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S66029D",
      "display" : "S66029D Desgarro de músculo fascia y tendón de flexor largo de pulgar no especificado a nivel de muñeca y mano contacto sucesivo"
    },
    {
      "code" : "S66091S",
      "display" : "S66091S Otro traumatismo de músculo fascia y tendón de flexor largo de pulgar derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S66801A",
      "display" : "S66801A Traumatismo no especificado de otros músculos fascias y tendones especificados a nivel de muñeca y mano derechas contacto inicial"
    },
    {
      "code" : "S66809",
      "display" : "S66809 Traumatismo no especificado de otros músculos fascias y tendones especificados a nivel de muñeca y mano no especificadas"
    },
    {
      "code" : "S73042A",
      "display" : "S73042A Subluxación central de cadera izquierda contacto inicial"
    },
    {
      "code" : "S73043A",
      "display" : "S73043A Subluxación central de cadera no especificada contacto inicial"
    },
    {
      "code" : "S73044D",
      "display" : "S73044D Luxación central de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S73045D",
      "display" : "S73045D Luxación central de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S73046S",
      "display" : "S73046S Luxación central de cadera no especificada secuela"
    },
    {
      "code" : "S73101A",
      "display" : "S73101A Esguince no especificado de cadera derecha contacto inicial"
    },
    {
      "code" : "S73102D",
      "display" : "S73102D Esguince no especificado de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S73109D",
      "display" : "S73109D Esguince no especificado de cadera no especificada contacto sucesivo"
    },
    {
      "code" : "S7222XK",
      "display" : "S7222XK Fractura subtrocantérea desplazada de fémur izquierdo contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S7223",
      "display" : "S7223 Fractura subtrocantérea desplazada de fémur no especificado"
    },
    {
      "code" : "S7223XC",
      "display" : "S7223XC Fractura subtrocantérea desplazada de fémur no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72363D",
      "display" : "S72363D Fractura segmentaria desplazada de diáfisis de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82292D",
      "display" : "S82292D Otra fractura de diáfisis de tibia izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82292K",
      "display" : "S82292K Otra fractura de diáfisis de tibia izquierda contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82292S",
      "display" : "S82292S Otra fractura de diáfisis de tibia izquierda secuela"
    },
    {
      "code" : "S82455J",
      "display" : "S82455J Fractura conminuta sin desplazamiento de diáfisis de peroné izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82846N",
      "display" : "S82846N Fractura bimaleolar sin desplazamiento de pierna no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82851B",
      "display" : "S82851B Fractura trimaleolar desplazada de pierna derecha contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S83192S",
      "display" : "S83192S Otro tipo de subluxación de rodilla izquierda secuela"
    },
    {
      "code" : "S83194",
      "display" : "S83194 Otro tipo de luxación de rodilla derecha"
    },
    {
      "code" : "S83195",
      "display" : "S83195 Otro tipo de luxación de rodilla izquierda"
    },
    {
      "code" : "S83195S",
      "display" : "S83195S Otro tipo de luxación de rodilla izquierda secuela"
    },
    {
      "code" : "S83196S",
      "display" : "S83196S Otro tipo de luxación de rodilla no especificada secuela"
    },
    {
      "code" : "S83200D",
      "display" : "S83200D Desgarro en asa de cubo de menisco no especificado lesión actual de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S82301H",
      "display" : "S82301H Fractura no especificada de extremo inferior de tibia derecha contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82301R",
      "display" : "S82301R Fractura no especificada de extremo inferior de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82461E",
      "display" : "S82461E Fractura segmentaria desplazada de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82461N",
      "display" : "S82461N Fractura segmentaria desplazada de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82853B",
      "display" : "S82853B Fractura trimaleolar desplazada de pierna no especificada contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82853J",
      "display" : "S82853J Fractura trimaleolar desplazada de pierna no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S83207D",
      "display" : "S83207D Desgarro no especificado de menisco no especificado lesión actual de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "S8321",
      "display" : "S8321 Desgarro en asa de cubo de menisco interno lesión actual"
    },
    {
      "code" : "S83211S",
      "display" : "S83211S Desgarro en asa de cubo de menisco interno lesión actual de rodilla derecha secuela"
    },
    {
      "code" : "S83219A",
      "display" : "S83219A Desgarro en asa de cubo de menisco interno lesión actual de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S82309R",
      "display" : "S82309R Fractura no especificada de extremo inferior de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82311K",
      "display" : "S82311K Fractura en rodete de extremo inferior de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82463N",
      "display" : "S82463N Fractura segmentaria desplazada de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S8930",
      "display" : "S8930 Fractura fisaria no especificada de extremo inferior de peroné"
    },
    {
      "code" : "S89301K",
      "display" : "S89301K Fractura fisaria no especificada de extremo inferior de peroné derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S89302K",
      "display" : "S89302K Fractura fisaria no especificada de extremo inferior de peroné izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S91123S",
      "display" : "S91123S Desgarro con cuerpo extraño de dedo gordo de pie no especificado sin daños en la uña secuela"
    },
    {
      "code" : "S91125A",
      "display" : "S91125A Desgarro con cuerpo extraño de dedo(s) menor(es) del pie izquierdo sin daños en la uña contacto inicial"
    },
    {
      "code" : "T23191A",
      "display" : "T23191A Quemadura de primer grado de localizaciones múltiples de muñeca y mano derechas contacto inicial"
    },
    {
      "code" : "T23192S",
      "display" : "T23192S Quemadura de primer grado de localizaciones múltiples de muñeca y mano izquierdas secuela"
    },
    {
      "code" : "T23161A",
      "display" : "T23161A Quemadura de primer grado de dorso de la mano derecha contacto inicial"
    },
    {
      "code" : "T23201D",
      "display" : "T23201D Quemadura de segundo grado de la mano derecha de localización no especificada contacto sucesivo"
    },
    {
      "code" : "T23209",
      "display" : "T23209 Quemadura de segundo grado de mano no especificada de localización no especificada"
    },
    {
      "code" : "S99212G",
      "display" : "S99212G Fractura fisaria tipo I de Salter-Harris de falange de dedo del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S99202",
      "display" : "S99202 Fractura fisaria no especificada de falange de dedo del pie izquierdo"
    },
    {
      "code" : "T2032XD",
      "display" : "T2032XD Quemadura de tercer grado de labio(s) contacto sucesivo"
    },
    {
      "code" : "T2033XA",
      "display" : "T2033XA Quemadura de tercer grado de mentón contacto inicial"
    },
    {
      "code" : "T2034X",
      "display" : "T2034X Quemadura de tercer grado de nariz (tabique)"
    },
    {
      "code" : "T2035",
      "display" : "T2035 Quemadura de tercer grado de cuero cabelludo [cualquier parte]"
    },
    {
      "code" : "T2036",
      "display" : "T2036 Quemadura de tercer grado de frente y mejilla"
    },
    {
      "code" : "T2036XS",
      "display" : "T2036XS Quemadura de tercer grado de frente y mejilla secuela"
    },
    {
      "code" : "T2037XD",
      "display" : "T2037XD Quemadura de tercer grado del cuello contacto sucesivo"
    },
    {
      "code" : "T22162D",
      "display" : "T22162D Quemadura de primer grado de región escapular izquierda contacto sucesivo"
    },
    {
      "code" : "T22169S",
      "display" : "T22169S Quemadura de primer grado de región escapular no especificada secuela"
    },
    {
      "code" : "T22191S",
      "display" : "T22191S Quemadura de primer grado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano secuela"
    },
    {
      "code" : "T22199A",
      "display" : "T22199A Quemadura de primer grado de localizaciones múltiples de hombro y extremidad superior no especificados excepto muñeca y mano contacto inicial"
    },
    {
      "code" : "T23231",
      "display" : "T23231 Quemadura de segundo grado de múltiples dedos de la mano derecha (uñas) sin incluir el pulgar"
    },
    {
      "code" : "T23232D",
      "display" : "T23232D Quemadura de segundo grado de múltiples dedos de la mano izquierda (uñas) sin incluir el pulgar contacto sucesivo"
    },
    {
      "code" : "T2324",
      "display" : "T2324 Quemadura de segundo grado de múltiples dedos de mano (uñas) incluido el pulgar"
    },
    {
      "code" : "S99231",
      "display" : "S99231 Fractura fisaria tipo III de Salter-Harris de falange de dedo del pie derecho"
    },
    {
      "code" : "S99231K",
      "display" : "S99231K Fractura fisaria tipo III de Salter-Harris de falange de dedo del pie derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "T2042X",
      "display" : "T2042X Corrosión de grado no especificado de labio(s)"
    },
    {
      "code" : "T2043",
      "display" : "T2043 Corrosión de grado no especificado de mentón"
    },
    {
      "code" : "T2043XS",
      "display" : "T2043XS Corrosión de grado no especificado de mentón secuela"
    },
    {
      "code" : "T2044XS",
      "display" : "T2044XS Corrosión de grado no especificado de nariz (tabique) secuela"
    },
    {
      "code" : "T2045XD",
      "display" : "T2045XD Corrosión de grado no especificado de cuero cabelludo [cualquier parte] contacto sucesivo"
    },
    {
      "code" : "T2046XS",
      "display" : "T2046XS Corrosión de grado no especificado de frente y mejilla secuela"
    },
    {
      "code" : "T22229",
      "display" : "T22229 Quemadura de segundo grado de codo no especificado"
    },
    {
      "code" : "T2223",
      "display" : "T2223 Quemadura de segundo grado de parte superior del brazo"
    },
    {
      "code" : "T22231S",
      "display" : "T22231S Quemadura de segundo grado de parte superior del brazo derecho secuela"
    },
    {
      "code" : "T22239",
      "display" : "T22239 Quemadura de segundo grado de parte superior de brazo no especificado"
    },
    {
      "code" : "T22241",
      "display" : "T22241 Quemadura de segundo grado de axila derecha"
    },
    {
      "code" : "T22242",
      "display" : "T22242 Quemadura de segundo grado de axila izquierda"
    },
    {
      "code" : "S60852S",
      "display" : "S60852S Cuerpo extraño superficial de muñeca izquierda secuela"
    },
    {
      "code" : "S61343D",
      "display" : "S61343D Herida punzante con cuerpo extraño de dedo medio izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61345",
      "display" : "S61345 Herida punzante con cuerpo extraño de dedo anular izquierdo con daños en la uña"
    },
    {
      "code" : "S61346A",
      "display" : "S61346A Herida punzante con cuerpo extraño de dedo meñique derecho con daños en la uña contacto inicial"
    },
    {
      "code" : "S62175S",
      "display" : "S62175S Fractura sin desplazamiento de trapecio [multiangular mayor] de muñeca izquierda secuela"
    },
    {
      "code" : "S62176K",
      "display" : "S62176K Fractura sin desplazamiento de trapecio [multiangular mayor] de muñeca no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S59202G",
      "display" : "S59202G Fractura fisaria no especificada de extremo inferior de radio del brazo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S59209G",
      "display" : "S59209G Fractura fisaria no especificada de extremo inferior de radio de brazo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S60879A",
      "display" : "S60879A Otra mordedura superficial de muñeca no especificada contacto inicial"
    },
    {
      "code" : "S60911",
      "display" : "S60911 Traumatismo superficial no especificado de muñeca derecha"
    },
    {
      "code" : "S60912A",
      "display" : "S60912A Traumatismo superficial no especificado de muñeca izquierda contacto inicial"
    },
    {
      "code" : "S60919D",
      "display" : "S60919D Traumatismo superficial no especificado de muñeca no especificada contacto sucesivo"
    },
    {
      "code" : "S60921D",
      "display" : "S60921D Traumatismo superficial no especificado de mano derecha contacto sucesivo"
    },
    {
      "code" : "S60922S",
      "display" : "S60922S Traumatismo superficial no especificado de mano izquierda secuela"
    },
    {
      "code" : "S61353A",
      "display" : "S61353A Mordedura abierta de dedo medio izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S61354D",
      "display" : "S61354D Mordedura abierta de dedo anular derecho con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61356",
      "display" : "S61356 Mordedura abierta de dedo meñique derecho con daños en la uña"
    },
    {
      "code" : "S61357",
      "display" : "S61357 Mordedura abierta de dedo meñique izquierdo con daños en la uña"
    },
    {
      "code" : "S61358A",
      "display" : "S61358A Mordedura abierta de otro dedo de mano con daños en la uña contacto inicial"
    },
    {
      "code" : "S62184K",
      "display" : "S62184K Fractura sin desplazamiento de trapezoides [multiangular menor] de muñeca derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62185D",
      "display" : "S62185D Fractura sin desplazamiento de trapezoides [multiangular menor] de muñeca izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S59221K",
      "display" : "S59221K Fractura fisaria tipo II de Salter-Harris de extremo inferior de radio del brazo derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S59222K",
      "display" : "S59222K Fractura fisaria tipo II de Salter-Harris de extremo inferior de radio del brazo izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S60943",
      "display" : "S60943 Traumatismo superficial no especificado de dedo medio izquierdo"
    },
    {
      "code" : "S60944A",
      "display" : "S60944A Traumatismo superficial no especificado de dedo anular derecho contacto inicial"
    },
    {
      "code" : "S60929S",
      "display" : "S60929S Traumatismo superficial no especificado de mano no especificada secuela"
    },
    {
      "code" : "S60946D",
      "display" : "S60946D Traumatismo superficial no especificado de dedo meñique derecho contacto sucesivo"
    },
    {
      "code" : "S60947S",
      "display" : "S60947S Traumatismo superficial no especificado de dedo meñique izquierdo secuela"
    },
    {
      "code" : "S61419A",
      "display" : "S61419A Desgarro sin cuerpo extraño de mano no especificada contacto inicial"
    },
    {
      "code" : "S61421A",
      "display" : "S61421A Desgarro con cuerpo extraño de mano derecha contacto inicial"
    },
    {
      "code" : "S61422A",
      "display" : "S61422A Desgarro con cuerpo extraño de mano izquierda contacto inicial"
    },
    {
      "code" : "S61429D",
      "display" : "S61429D Desgarro con cuerpo extraño de mano no especificada contacto sucesivo"
    },
    {
      "code" : "S72363M",
      "display" : "S72363M Fractura segmentaria desplazada de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S72444C",
      "display" : "S72444C Fractura sin desplazamiento de epífisis inferior (separación) de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72444K",
      "display" : "S72444K Fractura sin desplazamiento de epífisis inferior (separación) de fémur derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S7319",
      "display" : "S7319 Otro tipo de esguince de cadera"
    },
    {
      "code" : "S73109S",
      "display" : "S73109S Esguince no especificado de cadera no especificada secuela"
    },
    {
      "code" : "S73192D",
      "display" : "S73192D Otro tipo de esguince de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S73199S",
      "display" : "S73199S Otro tipo de esguince de cadera no especificada secuela"
    },
    {
      "code" : "S7400X",
      "display" : "S7400X Traumatismo de nervio ciático a nivel de cadera y muslo pierna no especificada"
    },
    {
      "code" : "S7401X",
      "display" : "S7401X Traumatismo de nervio ciático a nivel de cadera y muslo lado derecho"
    },
    {
      "code" : "S7402X",
      "display" : "S7402X Traumatismo de nervio ciático a nivel de cadera y muslo lado izquierdo"
    },
    {
      "code" : "S7224XK",
      "display" : "S7224XK Fractura subtrocantérea sin desplazamiento de fémur derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S7225",
      "display" : "S7225 Fractura subtrocantérea sin desplazamiento de fémur izquierdo"
    },
    {
      "code" : "S7225XD",
      "display" : "S7225XD Fractura subtrocantérea sin desplazamiento de fémur izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72365H",
      "display" : "S72365H Fractura segmentaria sin desplazamiento de diáfisis de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S72446E",
      "display" : "S72446E Fractura sin desplazamiento de epífisis inferior (separación) de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S7421",
      "display" : "S7421 Traumatismo de nervio sensitivo cutáneo a nivel de cadera y muslo pierna derecha"
    },
    {
      "code" : "S7422X",
      "display" : "S7422X Traumatismo de nervio sensitivo cutáneo a nivel de cadera y muslo lado izquierdo"
    },
    {
      "code" : "S748",
      "display" : "S748 Traumatismo de otros nervios a nivel de cadera y muslo"
    },
    {
      "code" : "S748X1D",
      "display" : "S748X1D Traumatismo de otros nervios a nivel de cadera y muslo lado derecho contacto sucesivo"
    },
    {
      "code" : "S748X2S",
      "display" : "S748X2S Traumatismo de otros nervios a nivel de cadera y muslo lado izquierdo secuela"
    },
    {
      "code" : "S7226XN",
      "display" : "S7226XN Fractura subtrocantérea sin desplazamiento de fémur no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S72301A",
      "display" : "S72301A Fractura no especificada de diáfisis de fémur derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72301F",
      "display" : "S72301F Fractura no especificada de diáfisis de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S72391G",
      "display" : "S72391G Otra fractura de diáfisis de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72391P",
      "display" : "S72391P Otra fractura de diáfisis de fémur derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S72452F",
      "display" : "S72452F Fractura supracondílea desplazada sin extensión intracondílea de extremo inferior de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S72101D",
      "display" : "S72101D Fractura de trocánter no especificado de fémur derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72101M",
      "display" : "S72101M Fractura de trocánter no especificado de fémur derecho contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S72102",
      "display" : "S72102 Fractura de trocánter no especificado de fémur izquierdo"
    },
    {
      "code" : "S72309B",
      "display" : "S72309B Fractura no especificada de diáfisis de fémur no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S91126S",
      "display" : "S91126S Desgarro con cuerpo extraño de dedo(s) menor(es) de pie no especificados sin daños en la uña secuela"
    },
    {
      "code" : "S92123K",
      "display" : "S92123K Fractura desplazada de cuerpo de astrágalo no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92124G",
      "display" : "S92124G Fractura sin desplazamiento de cuerpo de astrágalo derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92125B",
      "display" : "S92125B Fractura sin desplazamiento de cuerpo de astrágalo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S86221",
      "display" : "S86221 Desgarro de músculo(s) y tendón(es) del grupo muscular anterior a nivel de pierna derecha"
    },
    {
      "code" : "S86222A",
      "display" : "S86222A Desgarro de músculo(s) y tendón(es) del grupo muscular anterior a nivel de pierna izquierda contacto inicial"
    },
    {
      "code" : "S91139A",
      "display" : "S91139A Herida punzante sin cuerpo extraño de dedo(s) de pie no especificados sin daños en la uña contacto inicial"
    },
    {
      "code" : "S91141D",
      "display" : "S91141D Herida punzante con cuerpo extraño de dedo gordo del pie derecho sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S91143",
      "display" : "S91143 Herida punzante con cuerpo extraño de dedo gordo de pie no especificado sin daños en la uña"
    },
    {
      "code" : "S91206D",
      "display" : "S91206D Herida abierta no especificada de dedo(s) menor(es) de pie no especificado con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S91211",
      "display" : "S91211 Desgarro sin cuerpo extraño de dedo gordo del pie derecho con daños en la uña"
    },
    {
      "code" : "S91212A",
      "display" : "S91212A Desgarro sin cuerpo extraño de dedo gordo del pie izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S91213D",
      "display" : "S91213D Desgarro sin cuerpo extraño de dedo gordo de pie no especificado con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S92133B",
      "display" : "S92133B Fractura desplazada de apófisis posterior de astrágalo no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S92134",
      "display" : "S92134 Fractura sin desplazamiento de apófisis posterior de astrágalo derecho"
    },
    {
      "code" : "S92134K",
      "display" : "S92134K Fractura sin desplazamiento de apófisis posterior de astrágalo derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S86302D",
      "display" : "S86302D Traumatismo no especificado de músculo(s) y tendón(es) del grupo de músculos peroneos a nivel de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S86311",
      "display" : "S86311 Distensión de músculo(s) y tendón(es) del grupo de músculos peroneos a nivel de pierna derecha"
    },
    {
      "code" : "S86312D",
      "display" : "S86312D Distensión de músculo(s) y tendón(es) del grupo de músculos peroneos a nivel de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S91153S",
      "display" : "S91153S Mordedura abierta en dedo gordo de pie no especificado sin daños en la uña secuela"
    },
    {
      "code" : "S91155",
      "display" : "S91155 Mordedura abierta en dedo(s) menor(es) del pie izquierdo sin daños en la uña"
    },
    {
      "code" : "S91156",
      "display" : "S91156 Mordedura abierta en dedo(s) menor(es) de pie no especificado sin daños en la uña"
    },
    {
      "code" : "S91159A",
      "display" : "S91159A Mordedura abierta en dedo(s) de pie no especificados sin daños en la uña contacto inicial"
    },
    {
      "code" : "S91223D",
      "display" : "S91223D Desgarro con cuerpo extraño de dedo gordo de pie no especificado con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S91225",
      "display" : "S91225 Desgarro con cuerpo extraño de dedo(s) menor(es) del pie izquierdo con daños en la uña"
    },
    {
      "code" : "S91226A",
      "display" : "S91226A Desgarro con cuerpo extraño de dedo(s) menor(es) de pie no especificados con daños en la uña contacto inicial"
    },
    {
      "code" : "S83519D",
      "display" : "S83519D Esguince de ligamento cruzado anterior de rodilla no especificada contacto sucesivo"
    },
    {
      "code" : "S83521S",
      "display" : "S83521S Esguince de ligamento cruzado posterior de rodilla derecha secuela"
    },
    {
      "code" : "S83522S",
      "display" : "S83522S Esguince de ligamento cruzado posterior de rodilla izquierda secuela"
    },
    {
      "code" : "S836",
      "display" : "S836 Esguince de articulación y ligamentos tibio-peroneos superiores"
    },
    {
      "code" : "S8360XS",
      "display" : "S8360XS Esguince de articulación y ligamentos tibio-peroneos superiores de rodilla no especificada secuela"
    },
    {
      "code" : "T23262A",
      "display" : "T23262A Quemadura de segundo grado de dorso de la mano izquierda contacto inicial"
    },
    {
      "code" : "T23269D",
      "display" : "T23269D Quemadura de segundo grado de dorso de mano no especificada contacto sucesivo"
    },
    {
      "code" : "T23271D",
      "display" : "T23271D Quemadura de segundo grado de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "T23272S",
      "display" : "T23272S Quemadura de segundo grado de muñeca izquierda secuela"
    },
    {
      "code" : "T23279S",
      "display" : "T23279S Quemadura de segundo grado de muñeca no especificada secuela"
    },
    {
      "code" : "S99242B",
      "display" : "S99242B Fractura fisaria tipo IV de Salter-Harris de falange de dedo del pie izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S99249",
      "display" : "S99249 Fractura fisaria tipo IV de Salter-Harris de falange de dedo de pie no especificado"
    },
    {
      "code" : "S99249P",
      "display" : "S99249P Fractura fisaria tipo IV de Salter-Harris de falange de dedo de pie no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "T20519A",
      "display" : "T20519A Corrosión de primer grado de oído [cualquier parte excepto tímpano] no especificado contacto inicial"
    },
    {
      "code" : "T2052XD",
      "display" : "T2052XD Corrosión de primer grado de labio(s) contacto sucesivo"
    },
    {
      "code" : "T2053XA",
      "display" : "T2053XA Corrosión de primer grado de mentón contacto inicial"
    },
    {
      "code" : "T2054X",
      "display" : "T2054X Corrosión de primer grado de nariz (tabique)"
    },
    {
      "code" : "T2055",
      "display" : "T2055 Corrosión de primer grado de cuero cabelludo [cualquier parte]"
    },
    {
      "code" : "T2055XS",
      "display" : "T2055XS Corrosión de primer grado de cuero cabelludo [cualquier parte] secuela"
    },
    {
      "code" : "T22262S",
      "display" : "T22262S Quemadura de segundo grado de región escapular izquierda secuela"
    },
    {
      "code" : "T22269S",
      "display" : "T22269S Quemadura de segundo grado de región escapular no especificada secuela"
    },
    {
      "code" : "T22291S",
      "display" : "T22291S Quemadura de segundo grado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano secuela"
    },
    {
      "code" : "T22299D",
      "display" : "T22299D Quemadura de segundo grado de localizaciones múltiples de hombro y extremidad superior no especificados excepto muñeca y mano contacto sucesivo"
    },
    {
      "code" : "T23312A",
      "display" : "T23312A Quemadura de tercer grado de pulgar izquierdo (uña) contacto inicial"
    },
    {
      "code" : "T23319D",
      "display" : "T23319D Quemadura de tercer grado de pulgar (uña) no especificado contacto sucesivo"
    },
    {
      "code" : "T23321D",
      "display" : "T23321D Quemadura de tercer grado de un solo dedo (uña) de mano derecha excepto el pulgar contacto sucesivo"
    },
    {
      "code" : "T23329",
      "display" : "T23329 Quemadura de tercer grado de un solo dedo (uña) no especificado de mano excepto el pulgar"
    },
    {
      "code" : "S9981",
      "display" : "S9981 Otros traumatismos especificados de tobillo"
    },
    {
      "code" : "S99811S",
      "display" : "S99811S Otros traumatismos especificados de tobillo derecho secuela"
    },
    {
      "code" : "S99812S",
      "display" : "S99812S Otros traumatismos especificados de tobillo izquierdo secuela"
    },
    {
      "code" : "S9982",
      "display" : "S9982 Otros traumatismos especificados de pie"
    },
    {
      "code" : "S99821S",
      "display" : "S99821S Otros traumatismos especificados del pie derecho secuela"
    },
    {
      "code" : "S99822S",
      "display" : "S99822S Otros traumatismos especificados del pie izquierdo secuela"
    },
    {
      "code" : "T20612S",
      "display" : "T20612S Corrosión de segundo grado del oído izquierdo [cualquier parte excepto tímpano] secuela"
    },
    {
      "code" : "T2062",
      "display" : "T2062 Corrosión de segundo grado de labio(s)"
    },
    {
      "code" : "T2062XS",
      "display" : "T2062XS Corrosión de segundo grado de labio(s) secuela"
    },
    {
      "code" : "T2063XD",
      "display" : "T2063XD Corrosión de segundo grado de mentón contacto sucesivo"
    },
    {
      "code" : "T2064XD",
      "display" : "T2064XD Corrosión de segundo grado de nariz (tabique) contacto sucesivo"
    },
    {
      "code" : "T2065XD",
      "display" : "T2065XD Corrosión de segundo grado de cuero cabelludo [cualquier parte] contacto sucesivo"
    },
    {
      "code" : "T22329S",
      "display" : "T22329S Quemadura de tercer grado de codo no especificado secuela"
    },
    {
      "code" : "S61431D",
      "display" : "S61431D Herida punzante sin cuerpo extraño de mano derecha contacto sucesivo"
    },
    {
      "code" : "S61432S",
      "display" : "S61432S Herida punzante sin cuerpo extraño de mano izquierda secuela"
    },
    {
      "code" : "S61439S",
      "display" : "S61439S Herida punzante sin cuerpo extraño de mano no especificada secuela"
    },
    {
      "code" : "S62209",
      "display" : "S62209 Fractura no especificada de primer metacarpiano de mano no especificada"
    },
    {
      "code" : "S62209G",
      "display" : "S62209G Fractura no especificada de primer metacarpiano de mano no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62211B",
      "display" : "S62211B Fractura de Bennett de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S59239S",
      "display" : "S59239S Fractura fisaria tipo III de Salter-Harris de extremo inferior de radio de brazo no especificado secuela"
    },
    {
      "code" : "S59241K",
      "display" : "S59241K Fractura fisaria tipo IV de Salter-Harris de extremo inferior de radio del brazo derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S61012",
      "display" : "S61012 Desgarro sin cuerpo extraño de pulgar izquierdo sin daños en la uña"
    },
    {
      "code" : "S61019A",
      "display" : "S61019A Desgarro sin cuerpo extraño de pulgar no especificado sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61021A",
      "display" : "S61021A Desgarro con cuerpo extraño de pulgar derecho sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61022S",
      "display" : "S61022S Desgarro con cuerpo extraño de pulgar izquierdo sin daños en la uña secuela"
    },
    {
      "code" : "S6103",
      "display" : "S6103 Herida punzante sin cuerpo extraño de pulgar sin daños en la uña"
    },
    {
      "code" : "S61459D",
      "display" : "S61459D Mordedura abierta de mano no especificada contacto sucesivo"
    },
    {
      "code" : "S61501A",
      "display" : "S61501A Herida abierta no especificada de muñeca derecha contacto inicial"
    },
    {
      "code" : "S61502D",
      "display" : "S61502D Herida abierta no especificada de muñeca izquierda contacto sucesivo"
    },
    {
      "code" : "S61509D",
      "display" : "S61509D Herida abierta no especificada de muñeca no especificada contacto sucesivo"
    },
    {
      "code" : "S61511D",
      "display" : "S61511D Desgarro sin cuerpo extraño de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S61512S",
      "display" : "S61512S Desgarro sin cuerpo extraño de muñeca izquierda secuela"
    },
    {
      "code" : "S6152",
      "display" : "S6152 Desgarro con cuerpo extraño de muñeca"
    },
    {
      "code" : "S61521S",
      "display" : "S61521S Desgarro con cuerpo extraño de muñeca derecha secuela"
    },
    {
      "code" : "S62222B",
      "display" : "S62222B Fractura de Rolando desplazada de mano izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S62222P",
      "display" : "S62222P Fractura de Rolando desplazada de mano izquierda contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62223G",
      "display" : "S62223G Fractura de Rolando desplazada de mano no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62224B",
      "display" : "S62224B Fractura de Rolando sin desplazamiento de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S59292S",
      "display" : "S59292S Otra fractura fisaria de extremo inferior de radio del brazo izquierdo secuela"
    },
    {
      "code" : "S59299K",
      "display" : "S59299K Otra fractura fisaria de extremo inferior de radio de brazo no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S59801D",
      "display" : "S59801D Otros traumatismos especificados de codo derecho contacto sucesivo"
    },
    {
      "code" : "S61052A",
      "display" : "S61052A Mordedura abierta de pulgar izquierdo sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61059A",
      "display" : "S61059A Mordedura abierta de pulgar no especificado sin daño en la uña contacto inicial"
    },
    {
      "code" : "S61101",
      "display" : "S61101 Herida abierta no especificada de pulgar derecho con daños en la uña"
    },
    {
      "code" : "S61102A",
      "display" : "S61102A Herida abierta no especificada de pulgar izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S61109D",
      "display" : "S61109D Herida abierta no especificada de pulgar no especificado con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S63617A",
      "display" : "S63617A Esguince no especificado de dedo meñique izquierdo contacto inicial"
    },
    {
      "code" : "S72309H",
      "display" : "S72309H Fractura no especificada de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S72399M",
      "display" : "S72399M Otra fractura de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S7240",
      "display" : "S7240 Fractura no especificada de extremo inferior de fémur"
    },
    {
      "code" : "S72401C",
      "display" : "S72401C Fractura no especificada de extremo inferior de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72453S",
      "display" : "S72453S Fractura supracondílea desplazada sin extensión intracondílea de extremo inferior de fémur no especificado secuela"
    },
    {
      "code" : "S72109K",
      "display" : "S72109K Fractura de trocánter no especificado de fémur no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S7211",
      "display" : "S7211 Fractura de trocánter mayor de fémur"
    },
    {
      "code" : "S72111C",
      "display" : "S72111C Fractura desplazada de trocánter mayor de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72322B",
      "display" : "S72322B Fractura transversal desplazada de diáfisis de fémur izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72322H",
      "display" : "S72322H Fractura transversal desplazada de diáfisis de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S72402S",
      "display" : "S72402S Fractura no especificada de extremo inferior de fémur izquierdo secuela"
    },
    {
      "code" : "S72409D",
      "display" : "S72409D Fractura no especificada de extremo inferior de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72455N",
      "display" : "S72455N Fractura supracondílea sin desplazamiento sin extensión intracondílea de extremo inferior de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S72112S",
      "display" : "S72112S Fractura desplazada de trocánter mayor de fémur izquierdo secuela"
    },
    {
      "code" : "S72113D",
      "display" : "S72113D Fractura desplazada de trocánter mayor de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72324G",
      "display" : "S72324G Fractura transversal sin desplazamiento de diáfisis de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72411S",
      "display" : "S72411S Fractura no especificada desplazada de cóndilo de extremo inferior de fémur derecho secuela"
    },
    {
      "code" : "S72412E",
      "display" : "S72412E Fractura no especificada desplazada de cóndilo de extremo inferior de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72461F",
      "display" : "S72461F Fractura supracondílea desplazada con extensión intracondílea de extremo inferior de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S72115B",
      "display" : "S72115B Fractura sin desplazamiento de trocánter mayor de fémur izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72115H",
      "display" : "S72115H Fractura sin desplazamiento de trocánter mayor de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S72326D",
      "display" : "S72326D Fractura transversal sin desplazamiento de diáfisis de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72326M",
      "display" : "S72326M Fractura transversal sin desplazamiento de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S72413S",
      "display" : "S72413S Fractura no especificada desplazada de cóndilo de extremo inferior de fémur no especificado secuela"
    },
    {
      "code" : "S72121E",
      "display" : "S72121E Fractura desplazada de trocánter menor de fémur derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72332D",
      "display" : "S72332D Fractura oblicua desplazada de diáfisis de fémur izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72332K",
      "display" : "S72332K Fractura oblicua desplazada de diáfisis de fémur izquierdo contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72416",
      "display" : "S72416 Fractura no especificada sin desplazamiento de cóndilo de extremo inferior de fémur no especificado"
    },
    {
      "code" : "S86399",
      "display" : "S86399 Otro traumatismo de músculo(s) y tendón(es) del grupo de músculos peroneos a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S86801A",
      "display" : "S86801A Traumatismo no especificado de otro(s) músculo(s) y tendón(es) a nivel de pierna lado derecho contacto inicial"
    },
    {
      "code" : "S86802S",
      "display" : "S86802S Traumatismo no especificado de otro(s) músculo(s) y tendón(es) a nivel de pierna lado izquierdo secuela"
    },
    {
      "code" : "S89319G",
      "display" : "S89319G Fractura fisaria de extremo inferior tipo I de Salter-Harris de peroné no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S89321D",
      "display" : "S89321D Fractura fisaria de extremo inferior tipo II de Salter-Harris de peroné derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S89322D",
      "display" : "S89322D Fractura fisaria de extremo inferior tipo II de Salter-Harris de peroné izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S91239",
      "display" : "S91239 Herida punzante sin cuerpo extraño de dedo(s) de pie no especificado con daños en la uña"
    },
    {
      "code" : "S91241",
      "display" : "S91241 Herida punzante con cuerpo extraño de dedo gordo del pie derecho con daños en la uña"
    },
    {
      "code" : "S91242D",
      "display" : "S91242D Herida punzante con cuerpo extraño de dedo gordo del pie izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S8390XS",
      "display" : "S8390XS Esguince de localización no especificada de rodilla no especificada secuela"
    },
    {
      "code" : "S8391XS",
      "display" : "S8391XS Esguince de localización no especificada de rodilla derecha secuela"
    },
    {
      "code" : "S8392XS",
      "display" : "S8392XS Esguince de localización no especificada de rodilla izquierda secuela"
    },
    {
      "code" : "S8400X",
      "display" : "S8400X Traumatismo de nervio tibial a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S8401X",
      "display" : "S8401X Traumatismo de nervio tibial a nivel de pierna pierna derecha"
    },
    {
      "code" : "S86829D",
      "display" : "S86829D Desgarro de otro(s) músculo(s) y tendón(es) a nivel de pierna pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S86891S",
      "display" : "S86891S Otro traumatismo de otro(s) músculo(s) y tendón(es) a nivel de pierna lado derecho secuela"
    },
    {
      "code" : "S86899",
      "display" : "S86899 Otro traumatismo de otro(s) músculo(s) y tendón(es) a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S89399D",
      "display" : "S89399D Otra fractura fisaria de extremo inferior de peroné no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S8980",
      "display" : "S8980 Otros traumatismos especificados de pierna no especificada"
    },
    {
      "code" : "S8981",
      "display" : "S8981 Otros traumatismos especificados de pierna derecha"
    },
    {
      "code" : "S91252D",
      "display" : "S91252D Mordedura abierta en dedo gordo del pie izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S91254",
      "display" : "S91254 Mordedura abierta en dedo(s) menor(es) del pie derecho con daños en la uña"
    },
    {
      "code" : "S91255A",
      "display" : "S91255A Mordedura abierta en dedo(s) menor(es) del pie izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S91256D",
      "display" : "S91256D Mordedura abierta en dedo(s) menor(es) de pie no especificado con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S8421X",
      "display" : "S8421X Traumatismo de nervio sensitivo cutáneo a nivel de pierna pierna derecha"
    },
    {
      "code" : "S8422X",
      "display" : "S8422X Traumatismo de nervio sensitivo cutáneo a nivel de pierna pierna izquierda"
    },
    {
      "code" : "S848",
      "display" : "S848 Traumatismo de otros nervios a nivel de pierna"
    },
    {
      "code" : "S84801D",
      "display" : "S84801D Traumatismo de otros nervios a nivel de pierna pierna derecha contacto sucesivo"
    },
    {
      "code" : "S84802S",
      "display" : "S84802S Traumatismo de otros nervios a nivel de pierna pierna izquierda secuela"
    },
    {
      "code" : "S86919S",
      "display" : "S86919S Distensión de músculo(s) y tendón(es) no especificados a nivel de pierna pierna no especificada secuela"
    },
    {
      "code" : "S86922",
      "display" : "S86922 Desgarro de músculo(s) y tendón(es) no especificados a nivel de pierna lado izquierdo"
    },
    {
      "code" : "S86929A",
      "display" : "S86929A Desgarro de músculo(s) y tendón(es) no especificados a nivel de pierna pierna no especificada contacto inicial"
    },
    {
      "code" : "T22331D",
      "display" : "T22331D Quemadura de tercer grado de parte superior del brazo derecho contacto sucesivo"
    },
    {
      "code" : "T22332S",
      "display" : "T22332S Quemadura de tercer grado de parte superior del brazo izquierdo secuela"
    },
    {
      "code" : "T2234",
      "display" : "T2234 Quemadura de tercer grado de axila"
    },
    {
      "code" : "T22341S",
      "display" : "T22341S Quemadura de tercer grado de axila derecha secuela"
    },
    {
      "code" : "T22342S",
      "display" : "T22342S Quemadura de tercer grado de axila izquierda secuela"
    },
    {
      "code" : "T22349S",
      "display" : "T22349S Quemadura de tercer grado de axila no especificada secuela"
    },
    {
      "code" : "T23349D",
      "display" : "T23349D Quemadura de tercer grado de múltiples dedos (uñas) no especificados de mano incluido el pulgar contacto sucesivo"
    },
    {
      "code" : "T23351S",
      "display" : "T23351S Quemadura de tercer grado de palma de la mano derecha secuela"
    },
    {
      "code" : "T23359",
      "display" : "T23359 Quemadura de tercer grado de palma de mano no especificada"
    },
    {
      "code" : "T2336",
      "display" : "T2336 Quemadura de tercer grado de dorso de mano"
    },
    {
      "code" : "T23361S",
      "display" : "T23361S Quemadura de tercer grado de dorso de mano derecha secuela"
    },
    {
      "code" : "S99929D",
      "display" : "S99929D Traumatismo no especificado de pie no especificado contacto sucesivo"
    },
    {
      "code" : "T07XXX",
      "display" : "T07XXX Traumatismos múltiples no especificados"
    },
    {
      "code" : "T14",
      "display" : "T14 Traumatismo de región corporal no especificada"
    },
    {
      "code" : "T148XXA",
      "display" : "T148XXA Otro traumatismo de región corporal no especificada contacto inicial"
    },
    {
      "code" : "T1490",
      "display" : "T1490 Traumatismo no especificado"
    },
    {
      "code" : "T1490XD",
      "display" : "T1490XD Traumatismo no especificado contacto sucesivo"
    },
    {
      "code" : "T1491XA",
      "display" : "T1491XA Intento de suicidio contacto inicial"
    },
    {
      "code" : "T150",
      "display" : "T150 Cuerpo extraño en córnea"
    },
    {
      "code" : "T1500XD",
      "display" : "T1500XD Cuerpo extraño en córnea ojo no especificado contacto sucesivo"
    },
    {
      "code" : "T20712D",
      "display" : "T20712D Corrosión de tercer grado del oído izquierdo [cualquier parte excepto tímpano] contacto sucesivo"
    },
    {
      "code" : "T2072",
      "display" : "T2072 Corrosión de tercer grado de labio(s)"
    },
    {
      "code" : "T2072XD",
      "display" : "T2072XD Corrosión de tercer grado de labio(s) contacto sucesivo"
    },
    {
      "code" : "T2073XD",
      "display" : "T2073XD Corrosión de tercer grado de mentón contacto sucesivo"
    },
    {
      "code" : "T2074XA",
      "display" : "T2074XA Corrosión de tercer grado de nariz (tabique) contacto inicial"
    },
    {
      "code" : "T2075XA",
      "display" : "T2075XA Corrosión de tercer grado de cuero cabelludo [cualquier parte] contacto inicial"
    },
    {
      "code" : "T22391A",
      "display" : "T22391A Quemadura de tercer grado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano contacto inicial"
    },
    {
      "code" : "T22399",
      "display" : "T22399 Quemadura de tercer grado de localizaciones múltiples del hombro y extremidad superior no especificada excepto muñeca y mano"
    },
    {
      "code" : "T2240XA",
      "display" : "T2240XA Corrosión de grado no especificada del hombro y extremidad superior excepto muñeca y mano de localización no especificada contacto inicial"
    },
    {
      "code" : "T23392A",
      "display" : "T23392A Quemadura de tercer grado de localizaciones múltiples de muñeca y mano izquierdas contacto inicial"
    },
    {
      "code" : "T23399D",
      "display" : "T23399D Quemadura de tercer grado de localizaciones múltiples de muñeca y mano no especificadas contacto sucesivo"
    },
    {
      "code" : "T23401D",
      "display" : "T23401D Corrosión de grado no especificada de mano derecha de localización no especificada contacto sucesivo"
    },
    {
      "code" : "T23409",
      "display" : "T23409 Corrosión de grado no especificada de mano no especificada localización no especificada"
    },
    {
      "code" : "T1580X",
      "display" : "T1580X Cuerpo extraño en otras partes y zonas múltiples de la parte externa del ojo ojo no especificado"
    },
    {
      "code" : "T1581XA",
      "display" : "T1581XA Cuerpo extraño en otras partes y zonas múltiples de la parte externa del ojo ojo derecho contacto inicial"
    },
    {
      "code" : "S63618",
      "display" : "S63618 Esguince no especificado de otro dedo de mano"
    },
    {
      "code" : "S63619A",
      "display" : "S63619A Esguince no especificado de dedo de mano no especificado contacto inicial"
    },
    {
      "code" : "S63621A",
      "display" : "S63621A Esguince de articulación interfalángica de pulgar derecho contacto inicial"
    },
    {
      "code" : "S63622D",
      "display" : "S63622D Esguince de articulación interfalángica de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S63629S",
      "display" : "S63629S Esguince de articulación interfalángica de pulgar no especificado secuela"
    },
    {
      "code" : "S62354D",
      "display" : "S62354D Fractura sin desplazamiento de diáfisis de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62355B",
      "display" : "S62355B Fractura sin desplazamiento de diáfisis de cuarto metacarpiano de mano izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S62641G",
      "display" : "S62641G Fractura sin desplazamiento de falange proximal de dedo índice izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62642D",
      "display" : "S62642D Fractura sin desplazamiento de falange proximal de dedo medio derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62643B",
      "display" : "S62643B Fractura sin desplazamiento de falange proximal de dedo medio izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S63231",
      "display" : "S63231 Subluxación de articulación interfalángica proximal de dedo índice izquierdo"
    },
    {
      "code" : "S63232A",
      "display" : "S63232A Subluxación de articulación interfalángica proximal de dedo medio derecho contacto inicial"
    },
    {
      "code" : "S63233S",
      "display" : "S63233S Subluxación de articulación interfalángica proximal de dedo medio izquierdo secuela"
    },
    {
      "code" : "S63235",
      "display" : "S63235 Subluxación de articulación interfalángica proximal de dedo anular izquierdo"
    },
    {
      "code" : "S63636S",
      "display" : "S63636S Esguince de articulación interfalángica de dedo meñique derecho secuela"
    },
    {
      "code" : "S63638",
      "display" : "S63638 Esguince de articulación interfalángica de otro dedo de la mano"
    },
    {
      "code" : "S63639A",
      "display" : "S63639A Esguince de articulación interfalángica de dedo de mano no especificado contacto inicial"
    },
    {
      "code" : "S63641A",
      "display" : "S63641A Esguince de articulación metacarpofalángica de pulgar derecho contacto inicial"
    },
    {
      "code" : "S63642D",
      "display" : "S63642D Esguince de articulación metacarpofalángica de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S62358P",
      "display" : "S62358P Fractura sin desplazamiento de diáfisis de otro metacarpiano contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62359G",
      "display" : "S62359G Fractura sin desplazamiento de diáfisis de metacarpiano no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62360B",
      "display" : "S62360B Fractura sin desplazamiento del cuello de segundo metacarpiano de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62646S",
      "display" : "S62646S Fractura sin desplazamiento de falange proximal de dedo meñique derecho secuela"
    },
    {
      "code" : "S62647G",
      "display" : "S62647G Fractura sin desplazamiento de falange proximal de dedo meñique izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62648D",
      "display" : "S62648D Fractura sin desplazamiento de falange proximal de otro dedo de la mano contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S63242A",
      "display" : "S63242A Subluxación de articulación interfalángica distal de dedo medio derecho contacto inicial"
    },
    {
      "code" : "S63243D",
      "display" : "S63243D Subluxación de articulación interfalángica distal de dedo medio izquierdo contacto sucesivo"
    },
    {
      "code" : "S63245",
      "display" : "S63245 Subluxación de articulación interfalángica distal de dedo anular izquierdo"
    },
    {
      "code" : "S63246A",
      "display" : "S63246A Subluxación de articulación interfalángica distal de dedo meñique derecho contacto inicial"
    },
    {
      "code" : "S63655",
      "display" : "S63655 Esguince de articulación metacarpofalángica de dedo anular izquierdo"
    },
    {
      "code" : "S63656A",
      "display" : "S63656A Esguince de articulación metacarpofalángica de dedo meñique derecho contacto inicial"
    },
    {
      "code" : "S63657A",
      "display" : "S63657A Esguince de articulación metacarpofalángica de dedo meñique izquierdo contacto inicial"
    },
    {
      "code" : "S72123D",
      "display" : "S72123D Fractura desplazada de trocánter menor de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72123K",
      "display" : "S72123K Fractura desplazada de trocánter menor de fémur no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72334G",
      "display" : "S72334G Fractura oblicua sin desplazamiento de diáfisis de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72334Q",
      "display" : "S72334Q Fractura oblicua sin desplazamiento de diáfisis de fémur derecho contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S72421G",
      "display" : "S72421G Fractura desplazada de cóndilo lateral de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72421Q",
      "display" : "S72421Q Fractura desplazada de cóndilo lateral de fémur derecho contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S72125E",
      "display" : "S72125E Fractura sin desplazamiento de trocánter menor de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72125N",
      "display" : "S72125N Fractura sin desplazamiento de trocánter menor de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S72336N",
      "display" : "S72336N Fractura oblicua sin desplazamiento de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S72341B",
      "display" : "S72341B Fractura espiroidea desplazada de diáfisis de fémur derecho contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72423K",
      "display" : "S72423K Fractura desplazada de cóndilo lateral de fémur no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72424",
      "display" : "S72424 Fractura sin desplazamiento de cóndilo lateral de fémur derecho"
    },
    {
      "code" : "S72491A",
      "display" : "S72491A Otra fractura de extremo inferior de fémur derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72491G",
      "display" : "S72491G Otra fractura de extremo inferior de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72131J",
      "display" : "S72131J Fractura de apófisis desplazada de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S72131S",
      "display" : "S72131S Fractura de apófisis desplazada de fémur derecho secuela"
    },
    {
      "code" : "S72343",
      "display" : "S72343 Fractura espiroidea desplazada de diáfisis de fémur no especificado"
    },
    {
      "code" : "S72343E",
      "display" : "S72343E Fractura espiroidea desplazada de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72425P",
      "display" : "S72425P Fractura sin desplazamiento de cóndilo lateral de fémur izquierdo contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S72426B",
      "display" : "S72426B Fractura sin desplazamiento de cóndilo lateral de fémur no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72499C",
      "display" : "S72499C Otra fractura de extremo inferior de fémur no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72499K",
      "display" : "S72499K Otra fractura de extremo inferior de fémur no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72133Q",
      "display" : "S72133Q Fractura de apófisis desplazada de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S72134C",
      "display" : "S72134C Fractura de apófisis sin desplazamiento de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72345A",
      "display" : "S72345A Fractura espiroidea sin desplazamiento de diáfisis de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72431S",
      "display" : "S72431S Fractura desplazada de cóndilo medial de fémur derecho secuela"
    },
    {
      "code" : "S72432D",
      "display" : "S72432D Fractura desplazada de cóndilo medial de fémur izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S728X2D",
      "display" : "S728X2D Otra fractura de fémur izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S9000XD",
      "display" : "S9000XD Contusión de tobillo no especificado contacto sucesivo"
    },
    {
      "code" : "S9001XD",
      "display" : "S9001XD Contusión de tobillo derecho contacto sucesivo"
    },
    {
      "code" : "S9002XA",
      "display" : "S9002XA Contusión de tobillo izquierdo contacto inicial"
    },
    {
      "code" : "S9011",
      "display" : "S9011 Contusión de dedo gordo del pie sin daños en la uña"
    },
    {
      "code" : "S90112",
      "display" : "S90112 Contusión de dedo gordo del pie izquierdo sin daños en la uña"
    },
    {
      "code" : "S90119",
      "display" : "S90119 Contusión de dedo gordo del pie lado no especificado sin daños en la uña"
    },
    {
      "code" : "S90121",
      "display" : "S90121 Contusión de dedo(s) menor(es) del pie derecho sin daños en la uña"
    },
    {
      "code" : "S91319",
      "display" : "S91319 Desgarro sin cuerpo extraño de pie no especificado"
    },
    {
      "code" : "S9132",
      "display" : "S9132 Desgarro con cuerpo extraño de pie"
    },
    {
      "code" : "S91321S",
      "display" : "S91321S Desgarro con cuerpo extraño del pie derecho secuela"
    },
    {
      "code" : "S91322S",
      "display" : "S91322S Desgarro con cuerpo extraño del pie izquierdo secuela"
    },
    {
      "code" : "S9133",
      "display" : "S9133 Herida punzante sin cuerpo extraño de pie"
    },
    {
      "code" : "S91331S",
      "display" : "S91331S Herida punzante sin cuerpo extraño del pie derecho secuela"
    },
    {
      "code" : "S91332S",
      "display" : "S91332S Herida punzante sin cuerpo extraño del pie izquierdo secuela"
    },
    {
      "code" : "S85009",
      "display" : "S85009 Traumatismo no especificado de arteria poplítea de pierna no especificada"
    },
    {
      "code" : "S85011",
      "display" : "S85011 Desgarro de arteria poplítea de pierna derecha"
    },
    {
      "code" : "S85012",
      "display" : "S85012 Desgarro de arteria poplítea de pierna izquierda"
    },
    {
      "code" : "S85019",
      "display" : "S85019 Desgarro de arteria poplítea de pierna no especificada"
    },
    {
      "code" : "S85091",
      "display" : "S85091 Otro traumatismo especificado de arteria poplítea de pierna derecha"
    },
    {
      "code" : "S85092",
      "display" : "S85092 Otro traumatismo especificado de arteria poplítea de pierna izquierda"
    },
    {
      "code" : "S8702XD",
      "display" : "S8702XD Lesión por aplastamiento de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "S8780XA",
      "display" : "S8780XA Lesión por aplastamiento de pierna no especificada contacto inicial"
    },
    {
      "code" : "S8781XA",
      "display" : "S8781XA Lesión por aplastamiento de pierna derecha contacto inicial"
    },
    {
      "code" : "S8782X",
      "display" : "S8782X Lesión por aplastamiento de pierna izquierda"
    },
    {
      "code" : "S88",
      "display" : "S88 Amputación traumática de pierna"
    },
    {
      "code" : "S88011A",
      "display" : "S88011A Amputación traumática completa a nivel de rodilla extremidad inferior derecha contacto inicial"
    },
    {
      "code" : "S90221D",
      "display" : "S90221D Contusión de dedo(s) menor(es) del pie derecho con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S90229",
      "display" : "S90229 Contusión de dedo(s) menor(es) del pie lado no especificado con daños en la uña"
    },
    {
      "code" : "S9030",
      "display" : "S9030 Contusión de pie no especificado"
    },
    {
      "code" : "S9030XD",
      "display" : "S9030XD Contusión de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S9031XA",
      "display" : "S9031XA Contusión del pie derecho contacto inicial"
    },
    {
      "code" : "S9032X",
      "display" : "S9032X Contusión del pie izquierdo"
    },
    {
      "code" : "S9032XS",
      "display" : "S9032XS Contusión del pie izquierdo secuela"
    },
    {
      "code" : "S91359D",
      "display" : "S91359D Mordedura abierta de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S9200",
      "display" : "S9200 Fractura no especificada de calcáneo"
    },
    {
      "code" : "S92001D",
      "display" : "S92001D Fractura no especificada de calcáneo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92002A",
      "display" : "S92002A Fractura no especificada de calcáneo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92002P",
      "display" : "S92002P Fractura no especificada de calcáneo izquierdo contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "T1582XA",
      "display" : "T1582XA Cuerpo extraño en otras partes y zonas múltiples de la parte externa del ojo ojo izquierdo contacto inicial"
    },
    {
      "code" : "T17510S",
      "display" : "T17510S Contenido gástrico en bronquio que produce asfixia secuela"
    },
    {
      "code" : "T17518S",
      "display" : "T17518S Contenido gástrico en bronquio que produce otra lesión secuela"
    },
    {
      "code" : "T2137",
      "display" : "T2137 Quemadura de tercer grado de región genital femenina"
    },
    {
      "code" : "T2137XS",
      "display" : "T2137XS Quemadura de tercer grado de región genital femenina secuela"
    },
    {
      "code" : "T2139XS",
      "display" : "T2139XS Quemadura de tercer grado de otra localización de tronco secuela"
    },
    {
      "code" : "T2140XA",
      "display" : "T2140XA Corrosión de grado no especificada de tronco de localización no especificada contacto inicial"
    },
    {
      "code" : "T2141XD",
      "display" : "T2141XD Corrosión de grado no especificado de pared torácica contacto sucesivo"
    },
    {
      "code" : "T2142XD",
      "display" : "T2142XD Corrosión de grado no especificado de pared abdominal contacto sucesivo"
    },
    {
      "code" : "T22591S",
      "display" : "T22591S Corrosión de primer grado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano secuela"
    },
    {
      "code" : "T22599D",
      "display" : "T22599D Corrosión de primer grado de localizaciones múltiples del hombro y extremidad superior no especificada excepto muñeca y mano contacto sucesivo"
    },
    {
      "code" : "T2260XS",
      "display" : "T2260XS Corrosión de segundo grado del hombro y extremidad superior excepto muñeca y mano de localización no especificada secuela"
    },
    {
      "code" : "T23549A",
      "display" : "T23549A Corrosión de primer grado de múltiples dedos (uñas) de mano incluido el pulgar no especificado contacto inicial"
    },
    {
      "code" : "T23551D",
      "display" : "T23551D Corrosión de primer grado de palma de la mano derecha contacto sucesivo"
    },
    {
      "code" : "T23552S",
      "display" : "T23552S Corrosión de primer grado de palma de la mano izquierda secuela"
    },
    {
      "code" : "T2356",
      "display" : "T2356 Corrosión de primer grado de dorso de mano"
    },
    {
      "code" : "T17810",
      "display" : "T17810 Contenido gástrico en otras partes de vías respiratorias que produce asfixia"
    },
    {
      "code" : "T17818A",
      "display" : "T17818A Contenido gástrico en otras partes de vías respiratorias que produce otra lesión contacto inicial"
    },
    {
      "code" : "T17820A",
      "display" : "T17820A Alimento en otras partes de vías respiratorias que produce asfixia contacto inicial"
    },
    {
      "code" : "T17828S",
      "display" : "T17828S Alimento en otras partes de vías respiratorias que produce otra lesión secuela"
    },
    {
      "code" : "T17890S",
      "display" : "T17890S Otro cuerpo extraño en otras partes de vías respiratorias que produce asfixia secuela"
    },
    {
      "code" : "T2149XD",
      "display" : "T2149XD Corrosión de grado no especificado de otra localización de tronco contacto sucesivo"
    },
    {
      "code" : "T2150XA",
      "display" : "T2150XA Corrosión de primer grado de tronco de localización no especificada contacto inicial"
    },
    {
      "code" : "T2151XA",
      "display" : "T2151XA Corrosión de primer grado de pared torácica contacto inicial"
    },
    {
      "code" : "T2152XA",
      "display" : "T2152XA Corrosión de primer grado de pared abdominal contacto inicial"
    },
    {
      "code" : "T2153XA",
      "display" : "T2153XA Corrosión de primer grado de parte superior de la espalda contacto inicial"
    },
    {
      "code" : "T2154XA",
      "display" : "T2154XA Corrosión de primer grado de parte inferior de la espalda contacto inicial"
    },
    {
      "code" : "T22631D",
      "display" : "T22631D Corrosión de segundo grado de parte superior del brazo derecho contacto sucesivo"
    },
    {
      "code" : "T22632S",
      "display" : "T22632S Corrosión de segundo grado de parte superior del brazo izquierdo secuela"
    },
    {
      "code" : "T2264",
      "display" : "T2264 Corrosión de segundo grado de axila"
    },
    {
      "code" : "T22641S",
      "display" : "T22641S Corrosión de segundo grado de axila derecha secuela"
    },
    {
      "code" : "T22642S",
      "display" : "T22642S Corrosión de segundo grado de axila izquierda secuela"
    },
    {
      "code" : "T22649S",
      "display" : "T22649S Corrosión de segundo grado de axila no especificada secuela"
    },
    {
      "code" : "T22651S",
      "display" : "T22651S Corrosión de segundo grado del hombro derecho secuela"
    },
    {
      "code" : "S63658D",
      "display" : "S63658D Esguince de articulación metacarpofalángica de otro dedo de la mano contacto sucesivo"
    },
    {
      "code" : "S6368",
      "display" : "S6368 Otro tipo de esguince de pulgar"
    },
    {
      "code" : "S62363G",
      "display" : "S62363G Fractura sin desplazamiento del cuello de tercer metacarpiano de mano izquierda contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62364D",
      "display" : "S62364D Fractura sin desplazamiento del cuello de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62365B",
      "display" : "S62365B Fractura sin desplazamiento del cuello de cuarto metacarpiano de mano izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S62652B",
      "display" : "S62652B Fractura sin desplazamiento de falange media de dedo medio derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S62653",
      "display" : "S62653 Fractura sin desplazamiento de falange media de dedo medio izquierdo"
    },
    {
      "code" : "S63254A",
      "display" : "S63254A Luxación no especificada de dedo anular derecho contacto inicial"
    },
    {
      "code" : "S63255D",
      "display" : "S63255D Luxación no especificada de dedo anular izquierdo contacto sucesivo"
    },
    {
      "code" : "S63256D",
      "display" : "S63256D Luxación no especificada de dedo meñique derecho contacto sucesivo"
    },
    {
      "code" : "S63257D",
      "display" : "S63257D Luxación no especificada de dedo meñique izquierdo contacto sucesivo"
    },
    {
      "code" : "S63258S",
      "display" : "S63258S Luxación no especificada de otro dedo de mano secuela"
    },
    {
      "code" : "S6326",
      "display" : "S6326 Luxación de articulación metacarpofalángica de dedo de mano"
    },
    {
      "code" : "S62241S",
      "display" : "S62241S Fractura desplazada de diáfisis de primer metacarpiano de mano derecha secuela"
    },
    {
      "code" : "S62246B",
      "display" : "S62246B Fractura sin desplazamiento de diáfisis de primer metacarpiano de mano no especificada contacto inicial por fractura abierta"
    },
    {
      "code" : "S62368D",
      "display" : "S62368D Fractura sin desplazamiento del cuello de otro metacarpiano contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62369A",
      "display" : "S62369A Fractura sin desplazamiento del cuello de metacarpiano no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62369S",
      "display" : "S62369S Fractura sin desplazamiento del cuello de metacarpiano no especificado secuela"
    },
    {
      "code" : "S62657A",
      "display" : "S62657A Fractura sin desplazamiento de falange media de dedo meñique izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62658",
      "display" : "S62658 Fractura sin desplazamiento de falange media de otro dedo de la mano"
    },
    {
      "code" : "S63266S",
      "display" : "S63266S Luxación de articulación metacarpofalángica de dedo meñique derecho secuela"
    },
    {
      "code" : "S63268A",
      "display" : "S63268A Luxación de articulación metacarpofalángica de otro dedo de la mano contacto inicial"
    },
    {
      "code" : "S63269D",
      "display" : "S63269D Luxación de articulación metacarpofalángica de dedo de mano no especificado contacto sucesivo"
    },
    {
      "code" : "S63270S",
      "display" : "S63270S Luxación de articulación interfalángica no especificada de dedo índice derecho secuela"
    },
    {
      "code" : "S62253K",
      "display" : "S62253K Fractura desplazada del cuello de primer metacarpiano de mano no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62254G",
      "display" : "S62254G Fractura sin desplazamiento del cuello de primer metacarpiano de mano derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62255D",
      "display" : "S62255D Fractura sin desplazamiento del cuello de primer metacarpiano de mano izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62393P",
      "display" : "S62393P Otra fractura de tercer metacarpiano de mano izquierda contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62394G",
      "display" : "S62394G Otra fractura de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62395B",
      "display" : "S62395B Otra fractura de cuarto metacarpiano de mano izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S62662A",
      "display" : "S62662A Fractura sin desplazamiento de falange distal de dedo medio derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62662S",
      "display" : "S62662S Fractura sin desplazamiento de falange distal de dedo medio derecho secuela"
    },
    {
      "code" : "S728X2J",
      "display" : "S728X2J Otra fractura de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S728X2S",
      "display" : "S728X2S Otra fractura de fémur izquierdo secuela"
    },
    {
      "code" : "S728X9C",
      "display" : "S728X9C Otra fractura de fémur no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72135S",
      "display" : "S72135S Fractura de apófisis sin desplazamiento de fémur izquierdo secuela"
    },
    {
      "code" : "S72136D",
      "display" : "S72136D Fractura de apófisis sin desplazamiento de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S72136K",
      "display" : "S72136K Fractura de apófisis sin desplazamiento de fémur no especificado contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72346Q",
      "display" : "S72346Q Fractura espiroidea sin desplazamiento de diáfisis de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S72351C",
      "display" : "S72351C Fractura conminuta desplazada de diáfisis de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72434D",
      "display" : "S72434D Fractura sin desplazamiento de cóndilo medial de fémur derecho contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S7290XS",
      "display" : "S7290XS Fractura no especificada de fémur no especificado secuela"
    },
    {
      "code" : "S7291XC",
      "display" : "S7291XC Fractura no especificada de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S7291XJ",
      "display" : "S7291XJ Fractura no especificada de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S72142B",
      "display" : "S72142B Fractura intertrocantérea desplazada de fémur izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72142J",
      "display" : "S72142J Fractura intertrocantérea desplazada de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S72353C",
      "display" : "S72353C Fractura conminuta desplazada de diáfisis de fémur no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S72436A",
      "display" : "S72436A Fractura sin desplazamiento de cóndilo medial de fémur no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72436G",
      "display" : "S72436G Fractura sin desplazamiento de cóndilo medial de fémur no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S73001",
      "display" : "S73001 Subluxación no especificada de cadera derecha"
    },
    {
      "code" : "S73002",
      "display" : "S73002 Subluxación no especificada de cadera izquierda"
    },
    {
      "code" : "S73003",
      "display" : "S73003 Subluxación no especificada de cadera no especificada"
    },
    {
      "code" : "S73004",
      "display" : "S73004 Luxación no especificada de cadera derecha"
    },
    {
      "code" : "S73005",
      "display" : "S73005 Luxación no especificada de cadera izquierda"
    },
    {
      "code" : "S73006",
      "display" : "S73006 Luxación no especificada de cadera no especificada"
    },
    {
      "code" : "S72144F",
      "display" : "S72144F Fractura intertrocantérea sin desplazamiento de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S72144P",
      "display" : "S72144P Fractura intertrocantérea sin desplazamiento de fémur derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S72355F",
      "display" : "S72355F Fractura conminuta sin desplazamiento de diáfisis de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S72442E",
      "display" : "S72442E Fractura desplazada de epífisis inferior (separación) de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S73016D",
      "display" : "S73016D Luxación posterior de cadera no especificada contacto sucesivo"
    },
    {
      "code" : "S73021D",
      "display" : "S73021D Subluxación de obturador de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S73022D",
      "display" : "S73022D Subluxación de obturador de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S73023S",
      "display" : "S73023S Subluxación de obturador de cadera lado no especificada secuela"
    },
    {
      "code" : "S92009G",
      "display" : "S92009G Fractura no especificada de calcáneo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S85111D",
      "display" : "S85111D Desgarro de arteria tibial no especificada de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S85112S",
      "display" : "S85112S Desgarro de arteria tibial no especificada de pierna izquierda secuela"
    },
    {
      "code" : "S8512",
      "display" : "S8512 Otro traumatismo especificado de arteria tibial no especificada"
    },
    {
      "code" : "S85122",
      "display" : "S85122 Otro traumatismo especificado de arteria tibial no especificada de pierna izquierda"
    },
    {
      "code" : "S85129A",
      "display" : "S85129A Otro traumatismo especificado de arteria tibial no especificada de pierna no especificada contacto inicial"
    },
    {
      "code" : "S88112S",
      "display" : "S88112S Amputación traumática completa a un nivel entre rodilla y tobillo extremidad inferior izquierda secuela"
    },
    {
      "code" : "S88121",
      "display" : "S88121 Amputación traumática parcial a un nivel entre rodilla y tobillo extremidad inferior derecha"
    },
    {
      "code" : "S88122D",
      "display" : "S88122D Amputación traumática parcial a un nivel entre rodilla y tobillo extremidad inferior izquierda contacto sucesivo"
    },
    {
      "code" : "S90421",
      "display" : "S90421 Ampolla (no térmica) de dedo gordo del pie derecho"
    },
    {
      "code" : "S90422",
      "display" : "S90422 Ampolla (no térmica) de dedo gordo del pie izquierdo"
    },
    {
      "code" : "S90423",
      "display" : "S90423 Ampolla (no térmica) de dedo gordo de pie no especificado"
    },
    {
      "code" : "S90424A",
      "display" : "S90424A Ampolla (no térmica) dedo(s) menor(es) del pie derecho contacto inicial"
    },
    {
      "code" : "S90425D",
      "display" : "S90425D Ampolla (no térmica) dedo(s) menor(es) del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S90426S",
      "display" : "S90426S Ampolla (no térmica) de dedo(s) menor(es) de pie no especificado secuela"
    },
    {
      "code" : "S90441S",
      "display" : "S90441S Constricción externa de dedo gordo del pie derecho secuela"
    },
    {
      "code" : "S92013P",
      "display" : "S92013P Fractura desplazada de cuerpo de calcáneo no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92014G",
      "display" : "S92014G Fractura sin desplazamiento de cuerpo de calcáneo derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92015D",
      "display" : "S92015D Fractura sin desplazamiento de cuerpo de calcáneo izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92016A",
      "display" : "S92016A Fractura sin desplazamiento de cuerpo de calcáneo no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S85151S",
      "display" : "S85151S Otro traumatismo especificado de arteria tibial anterior de pierna derecha secuela"
    },
    {
      "code" : "S85159",
      "display" : "S85159 Otro traumatismo especificado de arteria tibial anterior de pierna no especificada"
    },
    {
      "code" : "S85161",
      "display" : "S85161 Traumatismo no especificado de arteria tibial posterior de pierna derecha"
    },
    {
      "code" : "S85162A",
      "display" : "S85162A Traumatismo no especificado de arteria tibial posterior de pierna izquierda contacto inicial"
    },
    {
      "code" : "S88929S",
      "display" : "S88929S Amputación traumática parcial de pierna no especificada nivel no especificado secuela"
    },
    {
      "code" : "S89001A",
      "display" : "S89001A Fractura fisaria no especificada de extremo superior de tibia derecha contacto inicial por fractura"
    },
    {
      "code" : "S89002",
      "display" : "S89002 Fractura fisaria no especificada de extremo superior de tibia izquierda"
    },
    {
      "code" : "S89002P",
      "display" : "S89002P Fractura fisaria no especificada de extremo superior de tibia izquierda contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S90453A",
      "display" : "S90453A Cuerpo extraño superficial de dedo gordo de pie no especificado contacto inicial"
    },
    {
      "code" : "S90454D",
      "display" : "S90454D Cuerpo extraño superficial dedo(s) menor(es) del pie derecho contacto sucesivo"
    },
    {
      "code" : "S90455S",
      "display" : "S90455S Cuerpo extraño superficial dedo(s) menor(es) del pie izquierdo secuela"
    },
    {
      "code" : "S9046",
      "display" : "S9046 Picadura de insecto (no venenoso) en dedo del pie"
    },
    {
      "code" : "S90461S",
      "display" : "S90461S Picadura de insecto (no venenoso) en dedo gordo del pie derecho secuela"
    },
    {
      "code" : "T2176X",
      "display" : "T2176X Corrosión de tercer grado de región genital masculina"
    },
    {
      "code" : "T2177X",
      "display" : "T2177X Corrosión de tercer grado de región genital femenina"
    },
    {
      "code" : "T2179",
      "display" : "T2179 Corrosión de tercer grado de otra localización de tronco"
    },
    {
      "code" : "T22731S",
      "display" : "T22731S Corrosión de tercer grado de parte superior del brazo derecho secuela"
    },
    {
      "code" : "T22739",
      "display" : "T22739 Corrosión de tercer grado de parte superior de brazo no especificado"
    },
    {
      "code" : "T22741",
      "display" : "T22741 Corrosión de tercer grado de axila derecha"
    },
    {
      "code" : "T22742",
      "display" : "T22742 Corrosión de tercer grado de axila izquierda"
    },
    {
      "code" : "T22749",
      "display" : "T22749 Corrosión de tercer grado de axila no especificada"
    },
    {
      "code" : "T2275",
      "display" : "T2275 Corrosión de tercer grado del hombro"
    },
    {
      "code" : "T22751S",
      "display" : "T22751S Corrosión de tercer grado del hombro derecho secuela"
    },
    {
      "code" : "T22752S",
      "display" : "T22752S Corrosión de tercer grado del hombro izquierdo secuela"
    },
    {
      "code" : "T23662A",
      "display" : "T23662A Corrosión de segundo grado de dorso de mano izquierda contacto inicial"
    },
    {
      "code" : "T23669A",
      "display" : "T23669A Corrosión de segundo grado de dorso de mano no especificada contacto inicial"
    },
    {
      "code" : "T23671D",
      "display" : "T23671D Corrosión de segundo grado de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "T23672D",
      "display" : "T23672D Corrosión de segundo grado de muñeca izquierda contacto sucesivo"
    },
    {
      "code" : "T23679S",
      "display" : "T23679S Corrosión de segundo grado de muñeca no especificada secuela"
    },
    {
      "code" : "T191XXD",
      "display" : "T191XXD Cuerpo extraño en vejiga contacto sucesivo"
    },
    {
      "code" : "T192XX",
      "display" : "T192XX Cuerpo extraño en vulva y vagina"
    },
    {
      "code" : "T193",
      "display" : "T193 Cuerpo extraño en útero"
    },
    {
      "code" : "T193XX",
      "display" : "T193XX Cuerpo extraño en útero"
    },
    {
      "code" : "T194",
      "display" : "T194 Cuerpo extraño en pene"
    },
    {
      "code" : "T194XXA",
      "display" : "T194XXA Cuerpo extraño en pene contacto inicial"
    },
    {
      "code" : "T198X",
      "display" : "T198X Cuerpo extraño en otras partes de tracto genitourinario"
    },
    {
      "code" : "T198XXS",
      "display" : "T198XXS Cuerpo extraño en otras partes de tracto genitourinario secuela"
    },
    {
      "code" : "T199XXD",
      "display" : "T199XXD Cuerpo extraño en tracto genitourinario parte no especificada contacto sucesivo"
    },
    {
      "code" : "T22022",
      "display" : "T22022 Quemadura de grado no especificado de codo izquierdo"
    },
    {
      "code" : "T22029",
      "display" : "T22029 Quemadura de grado no especificado de codo no especificado"
    },
    {
      "code" : "T22031",
      "display" : "T22031 Quemadura de grado no especificado de parte superior del brazo derecho"
    },
    {
      "code" : "T22032A",
      "display" : "T22032A Quemadura de grado no especificado de parte superior del brazo izquierdo contacto inicial"
    },
    {
      "code" : "T22039D",
      "display" : "T22039D Quemadura de grado no especificada de parte superior del brazo no especificada contacto sucesivo"
    },
    {
      "code" : "T22792D",
      "display" : "T22792D Corrosión de tercer grado de localizaciones múltiples del hombro y extremidad superior izquierdos excepto muñeca y mano contacto sucesivo"
    },
    {
      "code" : "T230",
      "display" : "T230 Quemadura de grado no especificado de muñeca y mano"
    },
    {
      "code" : "T23001D",
      "display" : "T23001D Quemadura de grado no especificado de mano derecha de localización no especificada contacto sucesivo"
    },
    {
      "code" : "T23009",
      "display" : "T23009 Quemadura de grado no especificado de mano no especificada de localización no especificada"
    },
    {
      "code" : "T23712",
      "display" : "T23712 Corrosión de tercer grado de pulgar (uña) izquierdo"
    },
    {
      "code" : "T23719",
      "display" : "T23719 Corrosión de tercer grado de pulgar (uña) no especificado"
    },
    {
      "code" : "T2175XA",
      "display" : "T2175XA Corrosión de tercer grado de nalga contacto inicial"
    },
    {
      "code" : "S63278",
      "display" : "S63278 Luxación de articulación interfalángica no especificada de otro dedo de la mano"
    },
    {
      "code" : "S63279D",
      "display" : "S63279D Luxación de articulación interfalángica no especificada de dedo de mano no especificado contacto sucesivo"
    },
    {
      "code" : "S63280S",
      "display" : "S63280S Luxación de articulación interfalángica proximal de dedo índice derecho secuela"
    },
    {
      "code" : "S63282",
      "display" : "S63282 Luxación de articulación interfalángica proximal de dedo medio derecho"
    },
    {
      "code" : "S62292K",
      "display" : "S62292K Otra fractura de primer metacarpiano de mano izquierda contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62299D",
      "display" : "S62299D Otra fractura de primer metacarpiano de mano no especificada contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S623",
      "display" : "S623 Fractura de otros metacarpianos y los no especificados"
    },
    {
      "code" : "S62300B",
      "display" : "S62300B Fractura no especificada de segundo metacarpiano de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62399A",
      "display" : "S62399A Otra fractura de hueso metacarpiano no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62399P",
      "display" : "S62399P Otra fractura de hueso metacarpiano no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62501B",
      "display" : "S62501B Fractura de falange no especificada de pulgar derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S62501S",
      "display" : "S62501S Fractura de falange no especificada de pulgar derecho secuela"
    },
    {
      "code" : "S62666S",
      "display" : "S62666S Fractura sin desplazamiento de falange distal de dedo meñique derecho secuela"
    },
    {
      "code" : "S62667G",
      "display" : "S62667G Fractura sin desplazamiento de falange distal de dedo meñique izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S63289A",
      "display" : "S63289A Luxación de articulación interfalángica proximal de dedo de mano no especificado contacto inicial"
    },
    {
      "code" : "S63290",
      "display" : "S63290 Luxación de articulación interfalángica distal de dedo índice derecho"
    },
    {
      "code" : "S63291A",
      "display" : "S63291A Luxación de articulación interfalángica distal de dedo índice izquierdo contacto inicial"
    },
    {
      "code" : "S63292S",
      "display" : "S63292S Luxación de articulación interfalángica distal de dedo medio derecho secuela"
    },
    {
      "code" : "S63294",
      "display" : "S63294 Luxación de articulación interfalángica distal de dedo anular derecho"
    },
    {
      "code" : "S62304A",
      "display" : "S62304A Fractura no especificada de cuarto metacarpiano de mano derecha contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62304S",
      "display" : "S62304S Fractura no especificada de cuarto metacarpiano de mano derecha secuela"
    },
    {
      "code" : "S62305G",
      "display" : "S62305G Fractura no especificada de cuarto metacarpiano de mano izquierda contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62512G",
      "display" : "S62512G Fractura desplazada de falange proximal de pulgar izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62513B",
      "display" : "S62513B Fractura desplazada de falange proximal de pulgar no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S62514",
      "display" : "S62514 Fractura sin desplazamiento de falange proximal de pulgar derecho"
    },
    {
      "code" : "S62514K",
      "display" : "S62514K Fractura sin desplazamiento de falange proximal de pulgar derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S6291X",
      "display" : "S6291X Fractura no especificada de muñeca y mano derecha"
    },
    {
      "code" : "S6291XG",
      "display" : "S6291XG Fractura no especificada de muñeca y mano derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S6292XB",
      "display" : "S6292XB Fractura no especificada de muñeca y mano izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S6292XS",
      "display" : "S6292XS Fractura no especificada de muñeca y mano izquierda secuela"
    },
    {
      "code" : "S63301S",
      "display" : "S63301S Rotura traumática de ligamento no especificado de muñeca derecha secuela"
    },
    {
      "code" : "S63309",
      "display" : "S63309 Rotura traumática de ligamento no especificada de muñeca no especificada"
    },
    {
      "code" : "S73025",
      "display" : "S73025 Luxación de obturador de cadera izquierda"
    },
    {
      "code" : "S73026",
      "display" : "S73026 Luxación de obturador de cadera no especificada"
    },
    {
      "code" : "S7303",
      "display" : "S7303 Otro tipo de subluxación y luxación anterior de cadera"
    },
    {
      "code" : "S73031S",
      "display" : "S73031S Otro tipo de subluxación anterior de cadera derecha secuela"
    },
    {
      "code" : "S72146M",
      "display" : "S72146M Fractura intertrocantérea sin desplazamiento de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S7221",
      "display" : "S7221 Fractura subtrocantérea desplazada de fémur derecho"
    },
    {
      "code" : "S72361A",
      "display" : "S72361A Fractura segmentaria desplazada de diáfisis de fémur derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72361G",
      "display" : "S72361G Fractura segmentaria desplazada de diáfisis de fémur derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82014B",
      "display" : "S82014B Fractura osteocondral sin desplazamiento de rótula derecha contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82014J",
      "display" : "S82014J Fractura osteocondral sin desplazamiento de rótula derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82115D",
      "display" : "S82115D Fractura sin desplazamiento de espina tibial izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82115J",
      "display" : "S82115J Fractura sin desplazamiento de espina tibial izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82231A",
      "display" : "S82231A Fractura oblicua desplazada de diáfisis de tibia derecha contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82231G",
      "display" : "S82231G Fractura oblicua desplazada de diáfisis de tibia derecha contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S78119D",
      "display" : "S78119D Amputación traumática completa a un nivel entre cadera y rodilla no especificadas contacto sucesivo"
    },
    {
      "code" : "S78121D",
      "display" : "S78121D Amputación traumática parcial a un nivel entre cadera y rodilla derechas contacto sucesivo"
    },
    {
      "code" : "S78129",
      "display" : "S78129 Amputación traumática parcial a un nivel entre cadera y rodilla no especificadas"
    },
    {
      "code" : "S7891",
      "display" : "S7891 Amputación traumática completa de cadera y muslo nivel no especificado"
    },
    {
      "code" : "S82121D",
      "display" : "S82121D Fractura desplazada de cóndilo lateral de tibia derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82121K",
      "display" : "S82121K Fractura desplazada de cóndilo lateral de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82125Q",
      "display" : "S82125Q Fractura sin desplazamiento de cóndilo lateral de tibia izquierda contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S82126C",
      "display" : "S82126C Fractura sin desplazamiento de cóndilo lateral de tibia no especificada contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82233D",
      "display" : "S82233D Fractura oblicua desplazada de diáfisis de tibia no especificada contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82233J",
      "display" : "S82233J Fractura oblicua desplazada de diáfisis de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S79001A",
      "display" : "S79001A Fractura fisaria no especificada de extremo superior de fémur derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S79002A",
      "display" : "S79002A Fractura fisaria no especificada de extremo superior de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S79009",
      "display" : "S79009 Fractura fisaria no especificada de extremo superior de fémur no especificado"
    },
    {
      "code" : "S82123F",
      "display" : "S82123F Fractura desplazada de cóndilo lateral de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82123P",
      "display" : "S82123P Fractura desplazada de cóndilo lateral de tibia no especificada contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S82131R",
      "display" : "S82131R Fractura desplazada de cóndilo medial de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S92023S",
      "display" : "S92023S Fractura desplazada de apófisis anterior de calcáneo no especificado secuela"
    },
    {
      "code" : "S92024G",
      "display" : "S92024G Fractura sin desplazamiento de apófisis anterior de calcáneo derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92025B",
      "display" : "S92025B Fractura sin desplazamiento de apófisis anterior de calcáneo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S85189A",
      "display" : "S85189A Otro traumatismo especificado de arteria tibial posterior de pierna no especificada contacto inicial"
    },
    {
      "code" : "S85201A",
      "display" : "S85201A Traumatismo no especificado de arteria peronea de pierna derecha contacto inicial"
    },
    {
      "code" : "S85202D",
      "display" : "S85202D Traumatismo no especificado de arteria peronea de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S85209S",
      "display" : "S85209S Traumatismo no especificado de arteria peronea de pierna no especificada secuela"
    },
    {
      "code" : "S85211S",
      "display" : "S85211S Desgarro de arteria peronea de pierna derecha secuela"
    },
    {
      "code" : "S89019S",
      "display" : "S89019S Fractura fisaria de extremo superior tipo I de Salter-Harris de tibia no especificada secuela"
    },
    {
      "code" : "S89021K",
      "display" : "S89021K Fractura fisaria de extremo superior tipo II de Salter-Harris de tibia derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S90473A",
      "display" : "S90473A Otra mordedura superficial en dedo gordo de pie no especificado contacto inicial"
    },
    {
      "code" : "S90474D",
      "display" : "S90474D Otra mordedura superficial en dedo(s) menor(es) del pie derecho contacto sucesivo"
    },
    {
      "code" : "S90475S",
      "display" : "S90475S Otra mordedura superficial en dedo(s) menor(es) del pie izquierdo secuela"
    },
    {
      "code" : "S905",
      "display" : "S905 Otros traumatismos superficiales de tobillo"
    },
    {
      "code" : "S90511D",
      "display" : "S90511D Abrasión de tobillo derecho contacto sucesivo"
    },
    {
      "code" : "S90512D",
      "display" : "S90512D Abrasión de tobillo izquierdo contacto sucesivo"
    },
    {
      "code" : "S92032S",
      "display" : "S92032S Fractura por arrancamiento (avulsión) desplazada de tuberosidad de calcáneo izquierdo secuela"
    },
    {
      "code" : "S92033G",
      "display" : "S92033G Fractura por arrancamiento (avulsión) desplazada de tuberosidad de calcáneo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S85309D",
      "display" : "S85309D Traumatismo no especificado de vena safena interna a nivel de pierna pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S85311S",
      "display" : "S85311S Desgarro de vena safena interna a nivel de pierna lado derecho secuela"
    },
    {
      "code" : "S85312S",
      "display" : "S85312S Desgarro de vena safena interna a nivel de pierna lado izquierdo secuela"
    },
    {
      "code" : "S8539",
      "display" : "S8539 Otro traumatismo especificado de vena safena interna a nivel de pierna"
    },
    {
      "code" : "S89039A",
      "display" : "S89039A Fractura fisaria de extremo superior tipo III de Salter-Harris de tibia no especificada contacto inicial por fractura"
    },
    {
      "code" : "S8904",
      "display" : "S8904 Fractura fisaria de extremo superior tipo IV de Salter-Harris de tibia"
    },
    {
      "code" : "S90549",
      "display" : "S90549 Constricción externa de tobillo no especificado"
    },
    {
      "code" : "S90551",
      "display" : "S90551 Cuerpo extraño superficial de tobillo derecho"
    },
    {
      "code" : "S90551S",
      "display" : "S90551S Cuerpo extraño superficial de tobillo derecho secuela"
    },
    {
      "code" : "S90552S",
      "display" : "S90552S Cuerpo extraño superficial de tobillo izquierdo secuela"
    },
    {
      "code" : "S9056",
      "display" : "S9056 Picadura de insecto (no venenoso) en tobillo"
    },
    {
      "code" : "S90561D",
      "display" : "S90561D Picadura de insecto (no venenoso) en tobillo derecho contacto sucesivo"
    },
    {
      "code" : "S90562S",
      "display" : "S90562S Picadura de insecto (no venenoso) en tobillo izquierdo secuela"
    },
    {
      "code" : "S9057",
      "display" : "S9057 Otra mordedura superficial en tobillo"
    },
    {
      "code" : "S92041D",
      "display" : "S92041D Otros tipos de fractura desplazada de tuberosidad de calcáneo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92042A",
      "display" : "S92042A Otros tipos de fractura desplazada de tuberosidad de calcáneo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "T1590XA",
      "display" : "T1590XA Cuerpo extraño en parte externa del ojo parte no especificada de ojo no especificado contacto inicial"
    },
    {
      "code" : "T2101XA",
      "display" : "T2101XA Quemadura de grado no especificado de pared torácica contacto inicial"
    },
    {
      "code" : "T2102XA",
      "display" : "T2102XA Quemadura de grado no especificado de pared abdominal contacto inicial"
    },
    {
      "code" : "T2103XA",
      "display" : "T2103XA Quemadura de grado no especificado de parte superior de la espalda contacto inicial"
    },
    {
      "code" : "T2104XA",
      "display" : "T2104XA Quemadura de grado no especificado de parte inferior de la espalda contacto inicial"
    },
    {
      "code" : "T2105XA",
      "display" : "T2105XA Quemadura de grado no especificado de nalga contacto inicial"
    },
    {
      "code" : "T2106XA",
      "display" : "T2106XA Quemadura de grado no especificado de región genital masculina contacto inicial"
    },
    {
      "code" : "T22431A",
      "display" : "T22431A Corrosión de grado no especificado de parte superior del brazo derecho contacto inicial"
    },
    {
      "code" : "T22432D",
      "display" : "T22432D Corrosión de grado no especificado de parte superior del brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "T2244",
      "display" : "T2244 Corrosión de grado no especificado de axila"
    },
    {
      "code" : "T22441D",
      "display" : "T22441D Corrosión de grado no especificado de axila derecha contacto sucesivo"
    },
    {
      "code" : "T22442S",
      "display" : "T22442S Corrosión de grado no especificado de axila izquierda secuela"
    },
    {
      "code" : "T22449S",
      "display" : "T22449S Corrosión de grado no especificada de axila no especificada secuela"
    },
    {
      "code" : "T2343",
      "display" : "T2343 Corrosión de grado no especificado de múltiples dedos de la mano (uñas) sin incluir el pulgar"
    },
    {
      "code" : "T23432",
      "display" : "T23432 Corrosión de grado no especificado de múltiples dedos de la mano izquierda (uñas) sin incluir el pulgar"
    },
    {
      "code" : "T23439D",
      "display" : "T23439D Corrosión de grado no especificado de múltiples dedos (uñas) de mano no especificado sin incluir el pulgar contacto sucesivo"
    },
    {
      "code" : "T169XXD",
      "display" : "T169XXD Cuerpo extraño en oído oído no especificado contacto sucesivo"
    },
    {
      "code" : "T170XX",
      "display" : "T170XX Cuerpo extraño en seno nasal"
    },
    {
      "code" : "T170XXS",
      "display" : "T170XXS Cuerpo extraño en seno nasal secuela"
    },
    {
      "code" : "T171XXA",
      "display" : "T171XXA Cuerpo extraño en orificio nasal contacto inicial"
    },
    {
      "code" : "T1720",
      "display" : "T1720 Cuerpo extraño no especificado en faringe"
    },
    {
      "code" : "T17200S",
      "display" : "T17200S Cuerpo extraño no especificado en faringe que produce asfixia secuela"
    },
    {
      "code" : "T1721",
      "display" : "T1721 Contenido gástrico en faringe"
    },
    {
      "code" : "T17210S",
      "display" : "T17210S Contenido gástrico en faringe que produce asfixia secuela"
    },
    {
      "code" : "T17218S",
      "display" : "T17218S Contenido gástrico en faringe que produce otra lesión secuela"
    },
    {
      "code" : "T2113XD",
      "display" : "T2113XD Quemadura de primer grado de parte superior de la espalda contacto sucesivo"
    },
    {
      "code" : "T2114XD",
      "display" : "T2114XD Quemadura de primer grado de parte inferior de la espalda contacto sucesivo"
    },
    {
      "code" : "T2115XD",
      "display" : "T2115XD Quemadura de primer grado de nalga contacto sucesivo"
    },
    {
      "code" : "T2107X",
      "display" : "T2107X Quemadura de grado no especificado de región genital femenina"
    },
    {
      "code" : "T2117X",
      "display" : "T2117X Quemadura de primer grado de región genital femenina"
    },
    {
      "code" : "T2119",
      "display" : "T2119 Quemadura de primer grado de otra localización de tronco"
    },
    {
      "code" : "T2119XS",
      "display" : "T2119XS Quemadura de primer grado de otra localización de tronco secuela"
    },
    {
      "code" : "T22491D",
      "display" : "T22491D Corrosión de grado no especificado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano contacto sucesivo"
    },
    {
      "code" : "T22499A",
      "display" : "T22499A Corrosión de grado no especificado de localizaciones múltiples del hombro y extremidad superior no especificados excepto muñeca y mano contacto inicial"
    },
    {
      "code" : "T2250XD",
      "display" : "T2250XD Corrosión de primer grado del hombro y extremidad superior excepto muñeca y mano localización no especificada contacto sucesivo"
    },
    {
      "code" : "S63311",
      "display" : "S63311 Rotura traumática de ligamento colateral de muñeca derecha"
    },
    {
      "code" : "S63312A",
      "display" : "S63312A Rotura traumática de ligamento colateral de muñeca izquierda contacto inicial"
    },
    {
      "code" : "S62308S",
      "display" : "S62308S Fractura no especificada de otro metacarpiano secuela"
    },
    {
      "code" : "S62309D",
      "display" : "S62309D Fractura no especificada de hueso metacarpiano no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S6231",
      "display" : "S6231 Fractura desplazada de base de otro metacarpiano"
    },
    {
      "code" : "S62310D",
      "display" : "S62310D Fractura desplazada de base de segundo metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62522A",
      "display" : "S62522A Fractura desplazada de falange distal de pulgar izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62522P",
      "display" : "S62522P Fractura desplazada de falange distal de pulgar izquierdo contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62523G",
      "display" : "S62523G Fractura desplazada de falange distal de pulgar no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S63012",
      "display" : "S63012 Subluxación de articulación radio-cubital distal de muñeca izquierda"
    },
    {
      "code" : "S63013A",
      "display" : "S63013A Subluxación de articulación radio-cubital distal de muñeca no especificada contacto inicial"
    },
    {
      "code" : "S63014D",
      "display" : "S63014D Luxación de articulación radio-cubital distal de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S63016",
      "display" : "S63016 Luxación de articulación radio-cubital distal de muñeca no especificada"
    },
    {
      "code" : "S63021",
      "display" : "S63021 Subluxación de articulación radiocarpiana de muñeca derecha"
    },
    {
      "code" : "S6339",
      "display" : "S6339 Rotura traumática de otro ligamento de muñeca"
    },
    {
      "code" : "S63391S",
      "display" : "S63391S Rotura traumática de otro ligamento de muñeca derecha secuela"
    },
    {
      "code" : "S63399",
      "display" : "S63399 Rotura traumática de otro ligamento de muñeca no especificada"
    },
    {
      "code" : "S6340",
      "display" : "S6340 Rotura traumática de ligamento no especificado de dedo de mano a nivel de articulaciones metacarpofalángica e interfalángica"
    },
    {
      "code" : "S62314B",
      "display" : "S62314B Fractura desplazada de base de cuarto metacarpiano de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62315",
      "display" : "S62315 Fractura desplazada de base de cuarto metacarpiano de mano izquierda"
    },
    {
      "code" : "S62315G",
      "display" : "S62315G Fractura desplazada de base de cuarto metacarpiano de mano izquierda contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62526S",
      "display" : "S62526S Fractura sin desplazamiento de falange distal de pulgar no especificado secuela"
    },
    {
      "code" : "S62600B",
      "display" : "S62600B Fractura de falange no especificada de dedo índice derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S62601",
      "display" : "S62601 Fractura de falange no especificada de dedo índice izquierdo"
    },
    {
      "code" : "S62601G",
      "display" : "S62601G Fractura de falange no especificada de dedo índice izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S63032",
      "display" : "S63032 Subluxación de articulación mediocarpiana de muñeca izquierda"
    },
    {
      "code" : "S63033",
      "display" : "S63033 Subluxación de articulación mediocarpiana de muñeca no especificada"
    },
    {
      "code" : "S63034A",
      "display" : "S63034A Luxación de articulación mediocarpiana de muñeca derecha contacto inicial"
    },
    {
      "code" : "S63035D",
      "display" : "S63035D Luxación de articulación mediocarpiana de muñeca izquierda contacto sucesivo"
    },
    {
      "code" : "S63036S",
      "display" : "S63036S Luxación de articulación mediocarpiana de muñeca no especificada secuela"
    },
    {
      "code" : "S63408A",
      "display" : "S63408A Rotura traumática de ligamento no especificado de otro dedo de la mano a nivel de articulaciones metacarpofalángica e interfalángica contacto inicial"
    },
    {
      "code" : "S62319K",
      "display" : "S62319K Fractura desplazada de base de metacarpiano no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62320D",
      "display" : "S62320D Fractura desplazada de diáfisis de segundo metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S82132E",
      "display" : "S82132E Fractura desplazada de cóndilo medial de tibia izquierda contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S75002S",
      "display" : "S75002S Traumatismo no especificado de arteria femoral de pierna izquierda secuela"
    },
    {
      "code" : "S7501",
      "display" : "S7501 Desgarro menor de arteria femoral"
    },
    {
      "code" : "S75011D",
      "display" : "S75011D Desgarro menor de arteria femoral de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S75012S",
      "display" : "S75012S Desgarro menor de arteria femoral de pierna izquierda secuela"
    },
    {
      "code" : "S7502",
      "display" : "S7502 Desgarro mayor de arteria femoral"
    },
    {
      "code" : "S75021D",
      "display" : "S75021D Desgarro mayor de arteria femoral de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S79019P",
      "display" : "S79019P Fractura fisaria tipo I de Salter-Harris de extremo superior de fémur no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S79091K",
      "display" : "S79091K Otra fractura fisaria de extremo superior de fémur derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S79092G",
      "display" : "S79092G Otra fractura fisaria de extremo superior de fémur izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S82016F",
      "display" : "S82016F Fractura osteocondral sin desplazamiento de rótula no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82133Q",
      "display" : "S82133Q Fractura desplazada de cóndilo medial de tibia no especificada contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S82134D",
      "display" : "S82134D Fractura sin desplazamiento de cóndilo medial de tibia derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S75102A",
      "display" : "S75102A Traumatismo no especificado de vena femoral a nivel de cadera y muslo lado izquierdo contacto inicial"
    },
    {
      "code" : "S75109S",
      "display" : "S75109S Traumatismo no especificado de vena femoral a nivel de cadera y muslo pierna no especificada secuela"
    },
    {
      "code" : "S75111S",
      "display" : "S75111S Desgarro menor de vena femoral a nivel de cadera y muslo lado derecho secuela"
    },
    {
      "code" : "S75119",
      "display" : "S75119 Desgarro menor de vena femoral a nivel de cadera y muslo pierna no especificada"
    },
    {
      "code" : "S79109A",
      "display" : "S79109A Fractura fisaria no especificada de extremo inferior de fémur no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S79111",
      "display" : "S79111 Fractura fisaria tipo I de Salter-Harris de extremo inferior de fémur derecho"
    },
    {
      "code" : "S79111P",
      "display" : "S79111P Fractura fisaria tipo I de Salter-Harris de extremo inferior de fémur derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S82022B",
      "display" : "S82022B Fractura longitudinal desplazada de rótula izquierda contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82022H",
      "display" : "S82022H Fractura longitudinal desplazada de rótula izquierda contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82022Q",
      "display" : "S82022Q Fractura longitudinal desplazada de rótula izquierda contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S82136A",
      "display" : "S82136A Fractura sin desplazamiento de cóndilo medial de tibia no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82136G",
      "display" : "S82136G Fractura sin desplazamiento de cóndilo medial de tibia no especificada contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S752",
      "display" : "S752 Traumatismo de vena safena interna a nivel de cadera y muslo"
    },
    {
      "code" : "S75201D",
      "display" : "S75201D Traumatismo no especificado de vena safena interna a nivel de cadera y muslo lado derecho contacto sucesivo"
    },
    {
      "code" : "S75209",
      "display" : "S75209 Traumatismo no especificado de vena safena interna a nivel de cadera y muslo pierna no especificada"
    },
    {
      "code" : "S75211A",
      "display" : "S75211A Desgarro menor de vena safena interna a nivel de cadera y muslo lado derecho contacto inicial"
    },
    {
      "code" : "S79129",
      "display" : "S79129 Fractura fisaria tipo II de Salter-Harris de extremo inferior de fémur no especificado"
    },
    {
      "code" : "S79129P",
      "display" : "S79129P Fractura fisaria tipo II de Salter-Harris de extremo inferior de fémur no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S85411",
      "display" : "S85411 Desgarro de vena safena externa a nivel de pierna lado derecho"
    },
    {
      "code" : "S85412A",
      "display" : "S85412A Desgarro de vena safena externa a nivel de pierna lado izquierdo contacto inicial"
    },
    {
      "code" : "S85419D",
      "display" : "S85419D Desgarro de vena safena externa a nivel de pierna pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S85491S",
      "display" : "S85491S Otro traumatismo especificado de vena safena externa a nivel de pierna lado derecho secuela"
    },
    {
      "code" : "S89092A",
      "display" : "S89092A Otra fractura fisaria de extremo superior de tibia izquierda contacto inicial por fractura"
    },
    {
      "code" : "S89092S",
      "display" : "S89092S Otra fractura fisaria de extremo superior de tibia izquierda secuela"
    },
    {
      "code" : "S89099K",
      "display" : "S89099K Otra fractura fisaria de extremo superior de tibia no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S90821D",
      "display" : "S90821D Ampolla (no térmica) del pie derecho contacto sucesivo"
    },
    {
      "code" : "S90822D",
      "display" : "S90822D Ampolla (no térmica) del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S90829D",
      "display" : "S90829D Ampolla (no térmica) de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S90841A",
      "display" : "S90841A Constricción externa del pie derecho contacto inicial"
    },
    {
      "code" : "S90842D",
      "display" : "S90842D Constricción externa del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S90849D",
      "display" : "S90849D Constricción externa de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S90851D",
      "display" : "S90851D Cuerpo extraño superficial del pie derecho contacto sucesivo"
    },
    {
      "code" : "S90852S",
      "display" : "S90852S Cuerpo extraño superficial del pie izquierdo secuela"
    },
    {
      "code" : "S92045G",
      "display" : "S92045G Otros tipos de fractura sin desplazamiento de tuberosidad de calcáneo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92046D",
      "display" : "S92046D Otros tipos de fractura sin desplazamiento de tuberosidad de calcáneo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S85512S",
      "display" : "S85512S Desgarro de vena poplítea de pierna izquierda secuela"
    },
    {
      "code" : "S8559",
      "display" : "S8559 Otro traumatismo especificado de vena poplítea"
    },
    {
      "code" : "S85499",
      "display" : "S85499 Otro traumatismo especificado de vena safena externa a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S85592S",
      "display" : "S85592S Otro traumatismo especificado de vena poplítea de pierna izquierda secuela"
    },
    {
      "code" : "S858",
      "display" : "S858 Traumatismo de otros vasos sanguíneos a nivel de pierna"
    },
    {
      "code" : "S85801S",
      "display" : "S85801S Traumatismo no especificado de otros vasos sanguíneos a nivel de pierna lado derecho secuela"
    },
    {
      "code" : "S89111D",
      "display" : "S89111D Fractura fisaria de extremo inferior tipo I de Salter-Harris de tibia derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S89112A",
      "display" : "S89112A Fractura fisaria de extremo inferior tipo I de Salter-Harris de tibia izquierda contacto inicial por fractura"
    },
    {
      "code" : "S89099S",
      "display" : "S89099S Otra fractura fisaria de extremo superior de tibia no especificada secuela"
    },
    {
      "code" : "S90872S",
      "display" : "S90872S Otra mordedura superficial en pie izquierdo secuela"
    },
    {
      "code" : "S909",
      "display" : "S909 Traumatismo superficial no especificado de tobillo pie y dedo del pie"
    },
    {
      "code" : "S90911D",
      "display" : "S90911D Traumatismo superficial no especificado de tobillo derecho contacto sucesivo"
    },
    {
      "code" : "S90912S",
      "display" : "S90912S Traumatismo superficial no especificado de tobillo izquierdo secuela"
    },
    {
      "code" : "S9092",
      "display" : "S9092 Traumatismo superficial no especificado de pie"
    },
    {
      "code" : "S90921S",
      "display" : "S90921S Traumatismo superficial no especificado del pie derecho secuela"
    },
    {
      "code" : "S90929",
      "display" : "S90929 Traumatismo superficial no especificado de pie no especificado"
    },
    {
      "code" : "S92054B",
      "display" : "S92054B Otros tipos de fractura extraarticular sin desplazamiento de calcáneo derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "T23591",
      "display" : "T23591 Corrosión de primer grado de localizaciones múltiples de muñeca y mano derechas"
    },
    {
      "code" : "T23592A",
      "display" : "T23592A Corrosión de primer grado de localizaciones múltiples de muñeca y mano izquierdas contacto inicial"
    },
    {
      "code" : "T23599S",
      "display" : "T23599S Corrosión de primer grado de localizaciones múltiples de muñeca y mano no especificadas secuela"
    },
    {
      "code" : "T23601D",
      "display" : "T23601D Corrosión de segundo grado de mano derecha de localización no especificada contacto sucesivo"
    },
    {
      "code" : "T23609",
      "display" : "T23609 Corrosión de segundo grado de mano no especificada de localización no especificada"
    },
    {
      "code" : "T17920S",
      "display" : "T17920S Alimento en vías respiratorias parte no especificada que produce asfixia secuela"
    },
    {
      "code" : "T1799",
      "display" : "T1799 Otro cuerpo extraño en vías respiratorias parte no especificada"
    },
    {
      "code" : "T17998",
      "display" : "T17998 Otro cuerpo extraño en vías respiratorias parte no especificada que produce otras lesiones"
    },
    {
      "code" : "T180",
      "display" : "T180 Cuerpo extraño en boca"
    },
    {
      "code" : "T180XXA",
      "display" : "T180XXA Cuerpo extraño en boca contacto inicial"
    },
    {
      "code" : "T2161",
      "display" : "T2161 Corrosión de segundo grado de pared torácica"
    },
    {
      "code" : "T2161XS",
      "display" : "T2161XS Corrosión de segundo grado de pared torácica secuela"
    },
    {
      "code" : "T2162XS",
      "display" : "T2162XS Corrosión de segundo grado de pared abdominal secuela"
    },
    {
      "code" : "T2163XD",
      "display" : "T2163XD Corrosión de segundo grado de parte superior de la espalda contacto sucesivo"
    },
    {
      "code" : "T2164XD",
      "display" : "T2164XD Corrosión de segundo grado de parte inferior de la espalda contacto sucesivo"
    },
    {
      "code" : "T2165XD",
      "display" : "T2165XD Corrosión de segundo grado de nalga contacto sucesivo"
    },
    {
      "code" : "T2166XD",
      "display" : "T2166XD Corrosión de segundo grado de región genital masculina contacto sucesivo"
    },
    {
      "code" : "T22692D",
      "display" : "T22692D Corrosión de segundo grado de localizaciones múltiples del hombro y extremidad superior izquierdos excepto muñeca y mano contacto sucesivo"
    },
    {
      "code" : "T2270",
      "display" : "T2270 Corrosión de tercer grado del hombro y extremidad superior excepto muñeca y mano de localización no especificada"
    },
    {
      "code" : "T22711",
      "display" : "T22711 Corrosión de tercer grado de antebrazo derecho"
    },
    {
      "code" : "T22711S",
      "display" : "T22711S Corrosión de tercer grado de antebrazo derecho secuela"
    },
    {
      "code" : "T2363",
      "display" : "T2363 Corrosión de segundo grado de múltiples dedos de la mano (uñas) sin incluir el pulgar"
    },
    {
      "code" : "T23632",
      "display" : "T23632 Corrosión de segundo grado de múltiples dedos de la mano izquierda (uñas) sin incluir el pulgar"
    },
    {
      "code" : "T23639D",
      "display" : "T23639D Corrosión de segundo grado de múltiples dedos (uñas) de mano sin incluir el pulgar no especificado contacto sucesivo"
    },
    {
      "code" : "T23641S",
      "display" : "T23641S Corrosión de segundo grado de múltiples dedos de la mano derecha (uñas) incluido el pulgar secuela"
    },
    {
      "code" : "T18128A",
      "display" : "T18128A Alimento en esófago que produce otra lesión contacto inicial"
    },
    {
      "code" : "T18190A",
      "display" : "T18190A Otro cuerpo extraño en esófago que produce compresión de tráquea contacto inicial"
    },
    {
      "code" : "T18198D",
      "display" : "T18198D Otro cuerpo extraño en esófago que produce otra lesión contacto sucesivo"
    },
    {
      "code" : "T180XXD",
      "display" : "T180XXD Cuerpo extraño en boca contacto sucesivo"
    },
    {
      "code" : "T183",
      "display" : "T183 Cuerpo extraño en intestino delgado"
    },
    {
      "code" : "T183XXD",
      "display" : "T183XXD Cuerpo extraño en intestino delgado contacto sucesivo"
    },
    {
      "code" : "T184XX",
      "display" : "T184XX Cuerpo extraño en colon"
    },
    {
      "code" : "T185",
      "display" : "T185 Cuerpo extraño en ano y recto"
    },
    {
      "code" : "T2173XA",
      "display" : "T2173XA Corrosión de tercer grado de parte superior de la espalda contacto inicial"
    },
    {
      "code" : "T2174XA",
      "display" : "T2174XA Corrosión de tercer grado de parte inferior de la espalda contacto inicial"
    },
    {
      "code" : "S62605D",
      "display" : "S62605D Fractura de falange no especificada de dedo anular izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62606B",
      "display" : "S62606B Fractura de falange no especificada de dedo meñique derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S62606S",
      "display" : "S62606S Fractura de falange no especificada de dedo meñique derecho secuela"
    },
    {
      "code" : "S63051A",
      "display" : "S63051A Subluxación de otra articulación carpometacarpiana de mano derecha contacto inicial"
    },
    {
      "code" : "S63052D",
      "display" : "S63052D Subluxación de otra articulación carpometacarpiana de mano izquierda contacto sucesivo"
    },
    {
      "code" : "S63054",
      "display" : "S63054 Luxación de otra articulación carpometacarpiana de mano derecha"
    },
    {
      "code" : "S63055",
      "display" : "S63055 Luxación de otra articulación carpometacarpiana de mano izquierda"
    },
    {
      "code" : "S63056A",
      "display" : "S63056A Luxación de otra articulación carpometacarpiana de mano no especificada contacto inicial"
    },
    {
      "code" : "S63416A",
      "display" : "S63416A Rotura traumática de ligamento colateral de dedo meñique derecho a nivel de articulaciones metacarpofalángica e interfalángica contacto inicial"
    },
    {
      "code" : "S62324D",
      "display" : "S62324D Fractura desplazada de diáfisis de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62325A",
      "display" : "S62325A Fractura desplazada de diáfisis de cuarto metacarpiano de mano izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62325S",
      "display" : "S62325S Fractura desplazada de diáfisis de cuarto metacarpiano de mano izquierda secuela"
    },
    {
      "code" : "S62610K",
      "display" : "S62610K Fractura desplazada de falange proximal de dedo índice derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62611G",
      "display" : "S62611G Fractura desplazada de falange proximal de dedo índice izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62612B",
      "display" : "S62612B Fractura desplazada de falange proximal de dedo medio derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S63071D",
      "display" : "S63071D Subluxación de extremo distal de cúbito derecho contacto sucesivo"
    },
    {
      "code" : "S63072S",
      "display" : "S63072S Subluxación de extremo distal de cúbito izquierdo secuela"
    },
    {
      "code" : "S63074",
      "display" : "S63074 Luxación de extremo distal de cúbito derecho"
    },
    {
      "code" : "S63074S",
      "display" : "S63074S Luxación de extremo distal de cúbito derecho secuela"
    },
    {
      "code" : "S63075S",
      "display" : "S63075S Luxación de extremo distal de cúbito izquierdo secuela"
    },
    {
      "code" : "S6309",
      "display" : "S6309 Otros tipos de subluxación y luxación de muñeca y mano"
    },
    {
      "code" : "S63423S",
      "display" : "S63423S Rotura traumática de ligamento palmar de dedo medio izquierdo a nivel de articulaciones metacarpofalángica e interfalángica secuela"
    },
    {
      "code" : "S63425D",
      "display" : "S63425D Rotura traumática de ligamento palmar de dedo anular izquierdo a nivel de articulaciones metacarpofalángica e interfalángica contacto sucesivo"
    },
    {
      "code" : "S62329S",
      "display" : "S62329S Fractura desplazada de diáfisis de metacarpiano no especificado secuela"
    },
    {
      "code" : "S62330B",
      "display" : "S62330B Fractura desplazada del cuello de segundo metacarpiano de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62331",
      "display" : "S62331 Fractura desplazada del cuello de segundo metacarpiano de mano izquierda"
    },
    {
      "code" : "S62615G",
      "display" : "S62615G Fractura desplazada de falange proximal de dedo anular izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62616D",
      "display" : "S62616D Fractura desplazada de falange proximal de dedo meñique derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62617A",
      "display" : "S62617A Fractura desplazada de falange proximal de dedo meñique izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S63101D",
      "display" : "S63101D Subluxación no especificada de pulgar derecho contacto sucesivo"
    },
    {
      "code" : "S63102D",
      "display" : "S63102D Subluxación no especificada de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S63103S",
      "display" : "S63103S Subluxación no especificada de pulgar no especificado secuela"
    },
    {
      "code" : "S82024K",
      "display" : "S82024K Fractura longitudinal sin desplazamiento de rótula derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82025",
      "display" : "S82025 Fractura longitudinal sin desplazamiento de rótula izquierda"
    },
    {
      "code" : "S82142B",
      "display" : "S82142B Fractura bicondílea desplazada de tibia izquierda contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82142H",
      "display" : "S82142H Fractura bicondílea desplazada de tibia izquierda contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S75299",
      "display" : "S75299 Otro traumatismo especificado de vena safena interna a nivel de cadera y muslo pierna no especificada"
    },
    {
      "code" : "S7580",
      "display" : "S7580 Traumatismo no especificado de otros vasos sanguíneos a nivel de cadera y muslo"
    },
    {
      "code" : "S75802",
      "display" : "S75802 Traumatismo no especificado de otros vasos sanguíneos a nivel de cadera y muslo pierna izquierda"
    },
    {
      "code" : "S79141P",
      "display" : "S79141P Fractura fisaria tipo IV de Salter-Harris de extremo inferior de fémur derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S79142K",
      "display" : "S79142K Fractura fisaria tipo IV de Salter-Harris de extremo inferior de fémur izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S82026R",
      "display" : "S82026R Fractura longitudinal sin desplazamiento de rótula no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82031D",
      "display" : "S82031D Fractura transversal desplazada de rótula derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82144F",
      "display" : "S82144F Fractura bicondílea sin desplazamiento de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82144P",
      "display" : "S82144P Fractura bicondílea sin desplazamiento de tibia derecha contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S75899D",
      "display" : "S75899D Otro traumatismo especificado de otros vasos sanguíneos a nivel de cadera y muslo pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S75901A",
      "display" : "S75901A Traumatismo no especificado de vaso sanguíneo no especificado a nivel de cadera y muslo lado derecho contacto inicial"
    },
    {
      "code" : "S75902S",
      "display" : "S75902S Traumatismo no especificado de vaso sanguíneo no especificado a nivel de cadera y muslo lado izquierdo secuela"
    },
    {
      "code" : "S79199S",
      "display" : "S79199S Otra fractura fisaria de extremo inferior de fémur no especificado secuela"
    },
    {
      "code" : "S79811D",
      "display" : "S79811D Otros traumatismos especificados de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S79812S",
      "display" : "S79812S Otros traumatismos especificados de cadera izquierda secuela"
    },
    {
      "code" : "S7982",
      "display" : "S7982 Otros traumatismos especificados de muslo"
    },
    {
      "code" : "S79821S",
      "display" : "S79821S Otros traumatismos especificados de muslo derecho secuela"
    },
    {
      "code" : "S79822S",
      "display" : "S79822S Otros traumatismos especificados de muslo izquierdo secuela"
    },
    {
      "code" : "S82033",
      "display" : "S82033 Fractura transversal desplazada de rótula no especificada"
    },
    {
      "code" : "S82033D",
      "display" : "S82033D Fractura transversal desplazada de rótula no especificada contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82146N",
      "display" : "S82146N Fractura bicondílea sin desplazamiento de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82151A",
      "display" : "S82151A Fractura desplazada de tuberosidad tibial derecha contacto inicial por fractura cerrada"
    },
    {
      "code" : "S75999S",
      "display" : "S75999S Otro traumatismo especificado de vaso sanguíneo no especificado a nivel de cadera y muslo pierna no especificada secuela"
    },
    {
      "code" : "S76001D",
      "display" : "S76001D Traumatismo no especificado de músculo fascia y tendón de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S76009",
      "display" : "S76009 Traumatismo no especificado de músculo fascia y tendón de cadera no especificada"
    },
    {
      "code" : "S79922S",
      "display" : "S79922S Traumatismo no especificado de muslo izquierdo secuela"
    },
    {
      "code" : "S80",
      "display" : "S80 Traumatismo superficial de rodilla y pierna"
    },
    {
      "code" : "S8000X",
      "display" : "S8000X Contusión de rodilla no especificada"
    },
    {
      "code" : "S92055A",
      "display" : "S92055A Otros tipos de fractura extraarticular sin desplazamiento de calcáneo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92055S",
      "display" : "S92055S Otros tipos de fractura extraarticular sin desplazamiento de calcáneo izquierdo secuela"
    },
    {
      "code" : "S85892D",
      "display" : "S85892D Otro traumatismo especificado de otros vasos sanguíneos a nivel de pierna lado izquierdo contacto sucesivo"
    },
    {
      "code" : "S859",
      "display" : "S859 Traumatismo de vaso sanguíneo no especificado a nivel de pierna"
    },
    {
      "code" : "S85901S",
      "display" : "S85901S Traumatismo no especificado de vaso sanguíneo no especificado a nivel de pierna lado derecho secuela"
    },
    {
      "code" : "S89131D",
      "display" : "S89131D Fractura fisaria de extremo inferior tipo III de Salter-Harris de tibia derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S89132A",
      "display" : "S89132A Fractura fisaria de extremo inferior tipo III de Salter-Harris de tibia izquierda contacto inicial por fractura"
    },
    {
      "code" : "S91",
      "display" : "S91 Herida abierta de tobillo pie y dedos de los pies"
    },
    {
      "code" : "S91001A",
      "display" : "S91001A Herida abierta no especificada de tobillo derecho contacto inicial"
    },
    {
      "code" : "S91002D",
      "display" : "S91002D Herida abierta no especificada de tobillo izquierdo contacto sucesivo"
    },
    {
      "code" : "S91009S",
      "display" : "S91009S Herida abierta no especificada de tobillo no especificado secuela"
    },
    {
      "code" : "S91011S",
      "display" : "S91011S Desgarro sin cuerpo extraño de tobillo derecho secuela"
    },
    {
      "code" : "S91012S",
      "display" : "S91012S Desgarro sin cuerpo extraño de tobillo izquierdo secuela"
    },
    {
      "code" : "S92063D",
      "display" : "S92063D Fractura intraarticular desplazada de calcáneo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92064A",
      "display" : "S92064A Fractura intraarticular sin desplazamiento de calcáneo derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92064P",
      "display" : "S92064P Fractura intraarticular sin desplazamiento de calcáneo derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S85999",
      "display" : "S85999 Otro traumatismo especificado de vaso sanguíneo no especificado a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S8600",
      "display" : "S8600 Traumatismo no especificado de tendón de Aquiles"
    },
    {
      "code" : "S86001S",
      "display" : "S86001S Traumatismo no especificado de tendón de Aquiles derecho secuela"
    },
    {
      "code" : "S86009",
      "display" : "S86009 Traumatismo no especificado de tendón de Aquiles no especificado"
    },
    {
      "code" : "S86011",
      "display" : "S86011 Distensión de tendón de Aquiles derecho"
    },
    {
      "code" : "S89149",
      "display" : "S89149 Fractura fisaria de extremo inferior tipo IV de Salter-Harris de tibia no especificada"
    },
    {
      "code" : "S89149P",
      "display" : "S89149P Fractura fisaria de extremo inferior tipo IV de Salter-Harris de tibia no especificada contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S89191K",
      "display" : "S89191K Otra fractura fisaria de extremo inferior de tibia derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S91039",
      "display" : "S91039 Herida punzante sin cuerpo extraño de tobillo no especificado"
    },
    {
      "code" : "S9104",
      "display" : "S9104 Herida punzante con cuerpo extraño de tobillo"
    },
    {
      "code" : "S91019",
      "display" : "S91019 Desgarro sin cuerpo extraño de tobillo no especificado"
    },
    {
      "code" : "S91042S",
      "display" : "S91042S Herida punzante con cuerpo extraño de tobillo izquierdo secuela"
    },
    {
      "code" : "S91049S",
      "display" : "S91049S Herida punzante con cuerpo extraño de tobillo no especificado secuela"
    },
    {
      "code" : "S91051S",
      "display" : "S91051S Mordedura abierta en tobillo derecho secuela"
    },
    {
      "code" : "S91052S",
      "display" : "S91052S Mordedura abierta en tobillo izquierdo secuela"
    },
    {
      "code" : "S92102A",
      "display" : "S92102A Fractura no especificada de astrágalo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92102S",
      "display" : "S92102S Fractura no especificada de astrágalo izquierdo secuela"
    },
    {
      "code" : "S92109D",
      "display" : "S92109D Fractura no especificada de astrágalo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "T23721",
      "display" : "T23721 Corrosión de tercer grado de un solo dedo (uña) de mano derecha excepto el pulgar"
    },
    {
      "code" : "T23722A",
      "display" : "T23722A Corrosión de tercer grado de un solo dedo (uña) de mano izquierda excepto el pulgar contacto inicial"
    },
    {
      "code" : "T2003XD",
      "display" : "T2003XD Quemadura de grado no especificado de mentón contacto sucesivo"
    },
    {
      "code" : "T2004XD",
      "display" : "T2004XD Quemadura de grado no especificado de nariz (tabique) contacto sucesivo"
    },
    {
      "code" : "T2005XD",
      "display" : "T2005XD Quemadura de grado no especificado de cuero cabelludo [cualquier parte] contacto sucesivo"
    },
    {
      "code" : "T2006XD",
      "display" : "T2006XD Quemadura de grado no especificado de frente y mejilla contacto sucesivo"
    },
    {
      "code" : "T2007XD",
      "display" : "T2007XD Quemadura de grado no especificado del cuello contacto sucesivo"
    },
    {
      "code" : "T22062D",
      "display" : "T22062D Quemadura de grado no especificado de región escapular izquierda contacto sucesivo"
    },
    {
      "code" : "T22069S",
      "display" : "T22069S Quemadura de grado no especificada de región escapular no especificada secuela"
    },
    {
      "code" : "T22091S",
      "display" : "T22091S Quemadura de grado no especificado de localizaciones múltiples del hombro y extremidad superior derechos excepto muñeca y mano secuela"
    },
    {
      "code" : "T40424D",
      "display" : "T40424D Envenenamiento por tramadol intencionalidad sin determinar contacto sucesivo"
    },
    {
      "code" : "T40425S",
      "display" : "T40425S Efecto adverso de tramadol secuela"
    },
    {
      "code" : "T40426S",
      "display" : "T40426S Infradosificación de tramadol secuela"
    },
    {
      "code" : "T40491D",
      "display" : "T40491D Envenenamiento por otros narcóticos sintéticos accidental (no intencionado) contacto sucesivo"
    },
    {
      "code" : "T40493",
      "display" : "T40493 Envenenamiento por otros narcóticos sintéticos agresión"
    },
    {
      "code" : "T40494",
      "display" : "T40494 Envenenamiento por otros narcóticos sintéticos intención sin determinar"
    },
    {
      "code" : "T40495A",
      "display" : "T40495A Efecto adverso de otros narcóticos sintéticos contacto inicial"
    },
    {
      "code" : "T25219D",
      "display" : "T25219D Quemadura de segundo grado de tobillo no especificado contacto sucesivo"
    },
    {
      "code" : "T25221D",
      "display" : "T25221D Quemadura de segundo grado del pie derecho contacto sucesivo"
    },
    {
      "code" : "T25222D",
      "display" : "T25222D Quemadura de segundo grado del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "T25229S",
      "display" : "T25229S Quemadura de segundo grado de pie no especificado secuela"
    },
    {
      "code" : "T25231S",
      "display" : "T25231S Quemadura de segundo grado de dedo(s) del pie derecho (uña) secuela"
    },
    {
      "code" : "T25232S",
      "display" : "T25232S Quemadura de segundo grado de dedo(s) del pie izquierdo (uña) secuela"
    },
    {
      "code" : "T33532D",
      "display" : "T33532D Congelación superficial de dedo(s) de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "T33539S",
      "display" : "T33539S Congelación superficial de dedo(s) de mano no especificados secuela"
    },
    {
      "code" : "T3360XD",
      "display" : "T3360XD Congelación superficial de cadera y muslo no especificado contacto sucesivo"
    },
    {
      "code" : "T3361XD",
      "display" : "T3361XD Congelación superficial de cadera y muslo derechos contacto sucesivo"
    },
    {
      "code" : "T3362XA",
      "display" : "T3362XA Congelación superficial de cadera y muslo izquierdos contacto inicial"
    },
    {
      "code" : "T3370X",
      "display" : "T3370X Congelación superficial de rodilla y parte inferior de pierna no especificada"
    },
    {
      "code" : "T380X1",
      "display" : "T380X1 Envenenamiento por glucocorticoides y análogos sintéticos accidental (no intencionado)"
    },
    {
      "code" : "T380X2A",
      "display" : "T380X2A Envenenamiento por glucocorticoides y análogos sintéticos autolesión intencionada contacto inicial"
    },
    {
      "code" : "T380X3S",
      "display" : "T380X3S Envenenamiento por glucocorticoides y análogos sintéticos agresión secuela"
    },
    {
      "code" : "T380X5",
      "display" : "T380X5 Efecto adverso de glucocorticoides y análogos sintéticos"
    },
    {
      "code" : "T405X6",
      "display" : "T405X6 Infradosificación de cocaína"
    },
    {
      "code" : "T406",
      "display" : "T406 Envenenamiento efecto adverso e infradosificación por otros narcóticos y los no especificados"
    },
    {
      "code" : "S63105",
      "display" : "S63105 Luxación no especificada de pulgar izquierdo"
    },
    {
      "code" : "S63106",
      "display" : "S63106 Luxación no especificada de pulgar no especificado"
    },
    {
      "code" : "S6311",
      "display" : "S6311 Subluxación y luxación de articulación metacarpofalángica de pulgar"
    },
    {
      "code" : "S63112",
      "display" : "S63112 Subluxación de articulación metacarpofalángica de pulgar izquierdo"
    },
    {
      "code" : "S63432S",
      "display" : "S63432S Rotura traumática de placa palmar de dedo medio derecho a nivel de articulaciones metacarpofalángica e interfalángica secuela"
    },
    {
      "code" : "S63434D",
      "display" : "S63434D Rotura traumática de placa palmar de dedo anular derecho a nivel de articulaciones metacarpofalángica e interfalángica contacto sucesivo"
    },
    {
      "code" : "S62334K",
      "display" : "S62334K Fractura desplazada del cuello de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62335D",
      "display" : "S62335D Fractura desplazada del cuello de cuarto metacarpiano de mano izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62621",
      "display" : "S62621 Fractura desplazada de falange media de dedo índice izquierdo"
    },
    {
      "code" : "S62621K",
      "display" : "S62621K Fractura desplazada de falange media de dedo índice izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62622D",
      "display" : "S62622D Fractura desplazada de falange media de dedo medio derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S63123A",
      "display" : "S63123A Subluxación de articulación interfalángica de pulgar no especificado contacto inicial"
    },
    {
      "code" : "S63124S",
      "display" : "S63124S Luxación de articulación interfalángica de pulgar derecho secuela"
    },
    {
      "code" : "S63126",
      "display" : "S63126 Luxación de articulación interfalángica de pulgar no especificado"
    },
    {
      "code" : "S632",
      "display" : "S632 Subluxación y luxación de otro(s) dedo(s) de mano"
    },
    {
      "code" : "S63200S",
      "display" : "S63200S Subluxación no especificada de dedo índice derecho secuela"
    },
    {
      "code" : "S63492",
      "display" : "S63492 Rotura traumática de otro ligamento de dedo medio derecho a nivel de articulaciones metacarpofalángica e interfalángica"
    },
    {
      "code" : "S62339P",
      "display" : "S62339P Fractura desplazada del cuello de metacarpiano no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62340G",
      "display" : "S62340G Fractura sin desplazamiento de base de segundo metacarpiano de mano derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62626D",
      "display" : "S62626D Fractura desplazada de falange media de dedo meñique derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62626S",
      "display" : "S62626S Fractura desplazada de falange media de dedo meñique derecho secuela"
    },
    {
      "code" : "S62627G",
      "display" : "S62627G Fractura desplazada de falange media de dedo meñique izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S63207S",
      "display" : "S63207S Subluxación no especificada de dedo meñique izquierdo secuela"
    },
    {
      "code" : "S63209",
      "display" : "S63209 Subluxación no especificada de dedo de mano no especificado"
    },
    {
      "code" : "S6321",
      "display" : "S6321 Subluxación de articulación metacarpofalángica de dedo de mano"
    },
    {
      "code" : "S63211",
      "display" : "S63211 Subluxación de articulación metacarpofalángica de dedo índice izquierdo"
    },
    {
      "code" : "S63212A",
      "display" : "S63212A Subluxación de articulación metacarpofalángica de dedo medio derecho contacto inicial"
    },
    {
      "code" : "S63213D",
      "display" : "S63213D Subluxación de articulación metacarpofalángica de dedo medio izquierdo contacto sucesivo"
    },
    {
      "code" : "S635",
      "display" : "S635 Otro tipo de esguince y el no especificado de muñeca"
    },
    {
      "code" : "S63501D",
      "display" : "S63501D Esguince no especificado de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S63502S",
      "display" : "S63502S Esguince no especificado de muñeca izquierda secuela"
    },
    {
      "code" : "S62344D",
      "display" : "S62344D Fractura sin desplazamiento de base de cuarto metacarpiano de mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62345A",
      "display" : "S62345A Fractura sin desplazamiento de base de cuarto metacarpiano de mano izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S8000XS",
      "display" : "S8000XS Contusión de rodilla no especificada secuela"
    },
    {
      "code" : "S8001XD",
      "display" : "S8001XD Contusión de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S8002XA",
      "display" : "S8002XA Contusión de rodilla izquierda contacto inicial"
    },
    {
      "code" : "S8010X",
      "display" : "S8010X Contusión de pierna no especificada"
    },
    {
      "code" : "S8010XS",
      "display" : "S8010XS Contusión de pierna no especificada secuela"
    },
    {
      "code" : "S8011XS",
      "display" : "S8011XS Contusión de pierna derecha secuela"
    },
    {
      "code" : "S8012XA",
      "display" : "S8012XA Contusión de pierna izquierda contacto inicial"
    },
    {
      "code" : "S82035C",
      "display" : "S82035C Fractura transversal sin desplazamiento de rótula izquierda contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82035J",
      "display" : "S82035J Fractura transversal sin desplazamiento de rótula izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82153A",
      "display" : "S82153A Fractura desplazada de tuberosidad tibial no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82153G",
      "display" : "S82153G Fractura desplazada de tuberosidad tibial no especificada contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S76091",
      "display" : "S76091 Otro traumatismo especificado de músculo fascia y tendón de cadera derecha"
    },
    {
      "code" : "S76092A",
      "display" : "S76092A Otro traumatismo especificado de músculo fascia y tendón de cadera izquierda contacto inicial"
    },
    {
      "code" : "S76099S",
      "display" : "S76099S Otro traumatismo especificado de músculo fascia y tendón de cadera no especificada secuela"
    },
    {
      "code" : "S76101S",
      "display" : "S76101S Traumatismo no especificado de músculo tendón y fascia de cuádriceps derecho secuela"
    },
    {
      "code" : "S80229A",
      "display" : "S80229A Ampolla (no térmica) de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S80241A",
      "display" : "S80241A Constricción externa de rodilla derecha contacto inicial"
    },
    {
      "code" : "S80242D",
      "display" : "S80242D Constricción externa de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "S80249D",
      "display" : "S80249D Constricción externa de rodilla no especificada contacto sucesivo"
    },
    {
      "code" : "S80251D",
      "display" : "S80251D Cuerpo extraño superficial de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S80252S",
      "display" : "S80252S Cuerpo extraño superficial de rodilla izquierda secuela"
    },
    {
      "code" : "S80259S",
      "display" : "S80259S Cuerpo extraño superficial de rodilla no especificada secuela"
    },
    {
      "code" : "S80261S",
      "display" : "S80261S Picadura de insecto (no venenoso) en rodilla derecha secuela"
    },
    {
      "code" : "S82041C",
      "display" : "S82041C Fractura conminuta desplazada de rótula derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82041J",
      "display" : "S82041J Fractura conminuta desplazada de rótula derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82155E",
      "display" : "S82155E Fractura sin desplazamiento de tuberosidad tibial izquierda contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82155N",
      "display" : "S82155N Fractura sin desplazamiento de tuberosidad tibial izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S76122D",
      "display" : "S76122D Desgarro de músculo tendón y fascia de cuádriceps izquierdo contacto sucesivo"
    },
    {
      "code" : "S76129S",
      "display" : "S76129S Desgarro de músculo tendón y fascia de cuádriceps no especificado secuela"
    },
    {
      "code" : "S76191S",
      "display" : "S76191S Otro traumatismo de músculo tendón y fascia del cuádriceps derecho secuela"
    },
    {
      "code" : "S76199A",
      "display" : "S76199A Otro traumatismo de músculo tendón y fascia de cuádriceps lado no especificado contacto inicial"
    },
    {
      "code" : "S76201",
      "display" : "S76201 Traumatismo no especificado de músculo fascia y tendón aductores de muslo derecho"
    },
    {
      "code" : "S80811S",
      "display" : "S80811S Abrasión de pierna derecha secuela"
    },
    {
      "code" : "S80812S",
      "display" : "S80812S Abrasión de pierna izquierda secuela"
    },
    {
      "code" : "S86091S",
      "display" : "S86091S Otro traumatismo especificado de tendón de Aquiles derecho secuela"
    },
    {
      "code" : "S86099",
      "display" : "S86099 Otro traumatismo especificado de tendón de Aquiles no especificado"
    },
    {
      "code" : "S86099S",
      "display" : "S86099S Otro traumatismo especificado de tendón de Aquiles no especificado secuela"
    },
    {
      "code" : "S86101D",
      "display" : "S86101D Traumatismo no especificado de otro(s) músculo(s) y tendón(es) del grupo muscular posterior a nivel de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S86109A",
      "display" : "S86109A Traumatismo no especificado de otro(s) músculo(s) y tendón(es) del grupo muscular posterior a nivel de pierna pierna no especificada contacto inicial"
    },
    {
      "code" : "S89202A",
      "display" : "S89202A Fractura fisaria no especificada de extremo superior de peroné izquierdo contacto inicial por fractura"
    },
    {
      "code" : "S89202S",
      "display" : "S89202S Fractura fisaria no especificada de extremo superior de peroné izquierdo secuela"
    },
    {
      "code" : "S89209P",
      "display" : "S89209P Fractura fisaria no especificada de extremo superior de peroné no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S91109A",
      "display" : "S91109A Herida abierta no especificada de dedo(s) de pie no especificados sin daños en la uña contacto inicial"
    },
    {
      "code" : "S91111D",
      "display" : "S91111D Desgarro sin cuerpo extraño de dedo gordo del pie derecho sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S91112S",
      "display" : "S91112S Desgarro sin cuerpo extraño de dedo gordo del pie izquierdo sin daños en la uña secuela"
    },
    {
      "code" : "S91114",
      "display" : "S91114 Desgarro sin cuerpo extraño de dedo(s) menor(es) del pie derecho sin daños en la uña"
    },
    {
      "code" : "S92115A",
      "display" : "S92115A Fractura sin desplazamiento del cuello de astrágalo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92115S",
      "display" : "S92115S Fractura sin desplazamiento del cuello de astrágalo izquierdo secuela"
    },
    {
      "code" : "S92116G",
      "display" : "S92116G Fractura sin desplazamiento del cuello de astrágalo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S86191A",
      "display" : "S86191A Otro traumatismo de otro(s) músculo(s) y tendón(es) del grupo muscular posterior a nivel de pierna derecha contacto inicial"
    },
    {
      "code" : "S86199",
      "display" : "S86199 Otro traumatismo de otro(s) músculo(s) y tendón(es) del grupo muscular posterior a nivel de pierna pierna no especificada"
    },
    {
      "code" : "S89221S",
      "display" : "S89221S Fractura fisaria de extremo superior tipo II de Salter-Harris de peroné derecho secuela"
    },
    {
      "code" : "S89222K",
      "display" : "S89222K Fractura fisaria de extremo superior tipo II de Salter-Harris de peroné izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S99121K",
      "display" : "S99121K Fractura fisaria tipo II de Salter-Harris de metatarso derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S99122D",
      "display" : "S99122D Fractura fisaria tipo II de Salter-Harris de metatarso izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S99129A",
      "display" : "S99129A Fractura fisaria tipo II de Salter-Harris de metatarso no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92335A",
      "display" : "S92335A Fractura sin desplazamiento de tercer metatarsiano del pie izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92335S",
      "display" : "S92335S Fractura sin desplazamiento de tercer metatarsiano del pie izquierdo secuela"
    },
    {
      "code" : "S92336G",
      "display" : "S92336G Fractura sin desplazamiento de tercer metatarsiano de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S93119A",
      "display" : "S93119A Luxación de articulación interfalángica de dedo(s) de pie no especificado contacto inicial"
    },
    {
      "code" : "S93121A",
      "display" : "S93121A Luxación de articulación metatarsofalángica de dedo gordo del pie derecho contacto inicial"
    },
    {
      "code" : "S93122S",
      "display" : "S93122S Luxación de articulación metatarsofalángica de dedo gordo del pie izquierdo secuela"
    },
    {
      "code" : "S93124",
      "display" : "S93124 Luxación de articulación metatarsofalángica de dedo(s) menor(es) del pie derecho"
    },
    {
      "code" : "S92111",
      "display" : "S92111 Fractura desplazada del cuello de astrágalo derecho"
    },
    {
      "code" : "T23461S",
      "display" : "T23461S Corrosión de grado no especificado de dorso de mano derecha secuela"
    },
    {
      "code" : "T23469",
      "display" : "T23469 Corrosión de grado no especificada de dorso de mano no especificada"
    },
    {
      "code" : "T23471",
      "display" : "T23471 Corrosión de grado no especificado de muñeca derecha"
    },
    {
      "code" : "T23472",
      "display" : "T23472 Corrosión de grado no especificado de muñeca izquierda"
    },
    {
      "code" : "T23479",
      "display" : "T23479 Corrosión de grado no especificada de muñeca no especificada"
    },
    {
      "code" : "T23491",
      "display" : "T23491 Corrosión de grado no especificado de localizaciones múltiples de muñeca y mano derechas"
    },
    {
      "code" : "T17308",
      "display" : "T17308 Cuerpo extraño no especificado en laringe que produce otra lesión"
    },
    {
      "code" : "T17310",
      "display" : "T17310 Contenido gástrico en laringe que produce asfixia"
    },
    {
      "code" : "T17318",
      "display" : "T17318 Contenido gástrico en laringe que produce otra lesión"
    },
    {
      "code" : "T1732",
      "display" : "T1732 Alimento en laringe"
    },
    {
      "code" : "T17320S",
      "display" : "T17320S Alimento en laringe que produce asfixia secuela"
    },
    {
      "code" : "T17328S",
      "display" : "T17328S Alimento en laringe que produce otra lesión secuela"
    },
    {
      "code" : "T17390D",
      "display" : "T17390D Otro cuerpo extraño en laringe que produce asfixia contacto sucesivo"
    },
    {
      "code" : "T17398S",
      "display" : "T17398S Otro cuerpo extraño en laringe que produce otra lesión secuela"
    },
    {
      "code" : "T2124XS",
      "display" : "T2124XS Quemadura de segundo grado de parte inferior de la espalda secuela"
    },
    {
      "code" : "T2125XS",
      "display" : "T2125XS Quemadura de segundo grado de nalga secuela"
    },
    {
      "code" : "T2126XD",
      "display" : "T2126XD Quemadura de segundo grado de región genital masculina contacto sucesivo"
    },
    {
      "code" : "T212",
      "display" : "T212 Quemadura de segundo grado de tronco"
    },
    {
      "code" : "T2129X",
      "display" : "T2129X Quemadura de segundo grado de otra localización de tronco"
    },
    {
      "code" : "T213",
      "display" : "T213 Quemadura de tercer grado de tronco"
    },
    {
      "code" : "T2130XD",
      "display" : "T2130XD Quemadura de tercer grado de tronco de localización no especificada contacto sucesivo"
    },
    {
      "code" : "T2131XD",
      "display" : "T2131XD Quemadura de tercer grado de pared torácica contacto sucesivo"
    },
    {
      "code" : "T22531",
      "display" : "T22531 Corrosión de primer grado de parte superior del brazo derecho"
    },
    {
      "code" : "T22532",
      "display" : "T22532 Corrosión de primer grado de parte superior del brazo izquierdo"
    },
    {
      "code" : "T22539A",
      "display" : "T22539A Corrosión de primer grado de parte superior de brazo no especificado contacto inicial"
    },
    {
      "code" : "T22541A",
      "display" : "T22541A Corrosión de primer grado de axila derecha contacto inicial"
    },
    {
      "code" : "T22542D",
      "display" : "T22542D Corrosión de primer grado de axila izquierda contacto sucesivo"
    },
    {
      "code" : "T22549S",
      "display" : "T22549S Corrosión de primer grado de axila no especificada secuela"
    },
    {
      "code" : "T23511",
      "display" : "T23511 Corrosión de primer grado de pulgar derecho (uña)"
    },
    {
      "code" : "T23512",
      "display" : "T23512 Corrosión de primer grado de pulgar izquierdo (uña)"
    },
    {
      "code" : "T23519A",
      "display" : "T23519A Corrosión de primer grado de pulgar (uña) no especificado contacto inicial"
    },
    {
      "code" : "T23521A",
      "display" : "T23521A Corrosión de primer grado de un solo dedo (uña) de mano derecha excepto el pulgar contacto inicial"
    },
    {
      "code" : "T23522A",
      "display" : "T23522A Corrosión de primer grado de un solo dedo (uña) de mano izquierda excepto el pulgar contacto inicial"
    },
    {
      "code" : "T17490D",
      "display" : "T17490D Otro cuerpo extraño en tráquea que produce asfixia contacto sucesivo"
    },
    {
      "code" : "T17498S",
      "display" : "T17498S Otro cuerpo extraño en tráquea que produce otra lesión secuela"
    },
    {
      "code" : "T17500A",
      "display" : "T17500A Cuerpo extraño no especificado en bronquio que produce asfixia contacto inicial"
    },
    {
      "code" : "T17508D",
      "display" : "T17508D Cuerpo extraño no especificado en bronquio que produce otra lesión contacto sucesivo"
    },
    {
      "code" : "S62628B",
      "display" : "S62628B Fractura desplazada de falange media de otro dedo de la mano contacto inicial por fractura abierta"
    },
    {
      "code" : "S62632D",
      "display" : "S62632D Fractura desplazada de falange distal de dedo medio derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62633B",
      "display" : "S62633B Fractura desplazada de falange distal de dedo medio izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S63220S",
      "display" : "S63220S Subluxación de articulación interfalángica no especificada de dedo índice derecho secuela"
    },
    {
      "code" : "S63222A",
      "display" : "S63222A Subluxación de articulación interfalángica no especificada de dedo medio derecho contacto inicial"
    },
    {
      "code" : "S63223S",
      "display" : "S63223S Subluxación de articulación interfalángica no especificada de dedo medio izquierdo secuela"
    },
    {
      "code" : "S63225",
      "display" : "S63225 Subluxación de articulación interfalángica no especificada de dedo anular izquierdo"
    },
    {
      "code" : "S63591",
      "display" : "S63591 Otro tipo de esguince especificado de muñeca derecha"
    },
    {
      "code" : "S63592",
      "display" : "S63592 Otro tipo de esguince especificado de muñeca izquierda"
    },
    {
      "code" : "S63599",
      "display" : "S63599 Otro tipo de esguince especificado de muñeca lado no especificado"
    },
    {
      "code" : "S6360",
      "display" : "S6360 Esguince no especificado de pulgar"
    },
    {
      "code" : "S63601D",
      "display" : "S63601D Esguince no especificado de pulgar derecho contacto sucesivo"
    },
    {
      "code" : "S63602S",
      "display" : "S63602S Esguince no especificado de pulgar izquierdo secuela"
    },
    {
      "code" : "S63609S",
      "display" : "S63609S Esguince no especificado de pulgar no especificado secuela"
    },
    {
      "code" : "S62349G",
      "display" : "S62349G Fractura sin desplazamiento de base de metacarpiano no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62350B",
      "display" : "S62350B Fractura sin desplazamiento de diáfisis de segundo metacarpiano de mano derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62636S",
      "display" : "S62636S Fractura desplazada de falange distal de dedo meñique derecho secuela"
    },
    {
      "code" : "S62637D",
      "display" : "S62637D Fractura desplazada de falange distal de dedo meñique izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62638A",
      "display" : "S62638A Fractura desplazada de falange distal de otro dedo de la mano contacto inicial por fractura cerrada"
    },
    {
      "code" : "S66891A",
      "display" : "S66891A Otro traumatismo de otros músculos fascias y tendones especificados a nivel de muñeca y mano derechas contacto inicial"
    },
    {
      "code" : "S66892S",
      "display" : "S66892S Otro traumatismo de otros músculos fascias y tendones especificados a nivel de muñeca y mano izquierdas secuela"
    },
    {
      "code" : "S6690",
      "display" : "S6690 Traumatismo no especificado de músculo fascia y tendón no especificado a nivel de muñeca y mano"
    },
    {
      "code" : "S70921S",
      "display" : "S70921S Traumatismo superficial no especificado de muslo derecho secuela"
    },
    {
      "code" : "S70922S",
      "display" : "S70922S Traumatismo superficial no especificado de muslo izquierdo secuela"
    },
    {
      "code" : "S70929S",
      "display" : "S70929S Traumatismo superficial no especificado de muslo no especificado secuela"
    },
    {
      "code" : "S71001A",
      "display" : "S71001A Herida abierta no especificada de cadera derecha contacto inicial"
    },
    {
      "code" : "S71002D",
      "display" : "S71002D Herida abierta no especificada de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S71009S",
      "display" : "S71009S Herida abierta no especificada de cadera no especificada secuela"
    },
    {
      "code" : "S72066G",
      "display" : "S72066G Fractura articular sin desplazamiento de cabeza de fémur no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S66105D",
      "display" : "S66105D Traumatismo no especificado de músculo fascia y tendón flexor de dedo anular izquierdo a nivel de muñeca y mano contacto sucesivo"
    },
    {
      "code" : "S66106S",
      "display" : "S66106S Traumatismo no especificado de músculo fascia y tendón flexor de dedo meñique derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S71031A",
      "display" : "S71031A Herida punzante sin cuerpo extraño de cadera derecha contacto inicial"
    },
    {
      "code" : "S71032D",
      "display" : "S71032D Herida punzante sin cuerpo extraño de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S80819A",
      "display" : "S80819A Abrasión de pierna no especificada contacto inicial"
    },
    {
      "code" : "S80821A",
      "display" : "S80821A Ampolla (no térmica) de pierna derecha contacto inicial"
    },
    {
      "code" : "S80822A",
      "display" : "S80822A Ampolla (no térmica) de pierna izquierda contacto inicial"
    },
    {
      "code" : "S80829D",
      "display" : "S80829D Ampolla (no térmica) de pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S80841D",
      "display" : "S80841D Constricción externa de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S80842D",
      "display" : "S80842D Constricción externa de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S82043K",
      "display" : "S82043K Fractura conminuta desplazada de rótula no especificada contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82043S",
      "display" : "S82043S Fractura conminuta desplazada de rótula no especificada secuela"
    },
    {
      "code" : "S82162D",
      "display" : "S82162D Fractura en rodete de extremo superior de tibia izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82169",
      "display" : "S82169 Fractura en rodete de extremo superior de tibia no especificada"
    },
    {
      "code" : "S76222A",
      "display" : "S76222A Desgarro de músculo fascia y tendón aductores de muslo izquierdo contacto inicial"
    },
    {
      "code" : "S76229S",
      "display" : "S76229S Desgarro de músculo fascia y tendón aductores de muslo no especificado secuela"
    },
    {
      "code" : "S76291S",
      "display" : "S76291S Otro traumatismo de músculo fascia y tendón aductores de muslo derecho secuela"
    },
    {
      "code" : "S76299",
      "display" : "S76299 Otro traumatismo de músculo fascia y tendón aductores de muslo no especificado"
    },
    {
      "code" : "S8087",
      "display" : "S8087 Otra mordedura superficial en pierna"
    },
    {
      "code" : "S80871S",
      "display" : "S80871S Otra mordedura superficial en pierna derecha secuela"
    },
    {
      "code" : "S80872S",
      "display" : "S80872S Otra mordedura superficial en pierna izquierda secuela"
    },
    {
      "code" : "S809",
      "display" : "S809 Traumatismo superficial no especificado de rodilla y pierna"
    },
    {
      "code" : "S80911D",
      "display" : "S80911D Traumatismo superficial no especificado de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S80912S",
      "display" : "S80912S Traumatismo superficial no especificado de rodilla izquierda secuela"
    },
    {
      "code" : "S8092",
      "display" : "S8092 Traumatismo superficial no especificado de pierna"
    },
    {
      "code" : "S82045S",
      "display" : "S82045S Fractura conminuta sin desplazamiento de rótula izquierda secuela"
    },
    {
      "code" : "S82046D",
      "display" : "S82046D Fractura conminuta sin desplazamiento de rótula no especificada contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82192C",
      "display" : "S82192C Otra fractura de extremo superior de tibia izquierda contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82192K",
      "display" : "S82192K Otra fractura de extremo superior de tibia izquierda contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82192S",
      "display" : "S82192S Otra fractura de extremo superior de tibia izquierda secuela"
    },
    {
      "code" : "S7632",
      "display" : "S7632 Desgarro de músculo fascia y tendón del grupo muscular posterior a nivel de muslo"
    },
    {
      "code" : "S76322",
      "display" : "S76322 Desgarro de músculo fascia y tendón del grupo muscular posterior a nivel de muslo izquierdo"
    },
    {
      "code" : "S76329D",
      "display" : "S76329D Desgarro de músculo fascia y tendón del grupo muscular posterior a nivel de muslo no especificado contacto sucesivo"
    },
    {
      "code" : "S81009A",
      "display" : "S81009A Herida abierta no especificada de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S81011A",
      "display" : "S81011A Desgarro sin cuerpo extraño de rodilla derecha contacto inicial"
    },
    {
      "code" : "S81012D",
      "display" : "S81012D Desgarro sin cuerpo extraño de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "S81019S",
      "display" : "S81019S Desgarro sin cuerpo extraño de rodilla no especificada secuela"
    },
    {
      "code" : "S81021D",
      "display" : "S81021D Desgarro con cuerpo extraño de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S81022S",
      "display" : "S81022S Desgarro con cuerpo extraño de rodilla izquierda secuela"
    },
    {
      "code" : "S96092S",
      "display" : "S96092S Otro traumatismo de músculo y tendón flexor largo de dedo del pie a nivel de tobillo y pie pie izquierdo secuela"
    },
    {
      "code" : "S9610",
      "display" : "S9610 Traumatismo no especificado de músculo y tendón extensor largo de dedo del pie a nivel de tobillo y pie"
    },
    {
      "code" : "S99139S",
      "display" : "S99139S Fractura fisaria tipo III de Salter-Harris de metatarso no especificado secuela"
    },
    {
      "code" : "S99141G",
      "display" : "S99141G Fractura fisaria tipo IV de Salter-Harris de metatarso derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S99142B",
      "display" : "S99142B Fractura fisaria tipo IV de Salter-Harris de metatarso izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S92344",
      "display" : "S92344 Fractura sin desplazamiento de cuarto metatarsiano del pie derecho"
    },
    {
      "code" : "S92344K",
      "display" : "S92344K Fractura sin desplazamiento de cuarto metatarsiano del pie derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92345D",
      "display" : "S92345D Fractura sin desplazamiento de cuarto metatarsiano del pie izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S93134A",
      "display" : "S93134A Subluxación de articulación interfalángica de dedo(s) menor(es) del pie derecho contacto inicial"
    },
    {
      "code" : "S93135S",
      "display" : "S93135S Subluxación de articulación interfalángica de dedo(s) menor(es) del pie izquierdo secuela"
    },
    {
      "code" : "S93139",
      "display" : "S93139 Subluxación de articulación interfalángica de dedo(s) de pie no especificado"
    },
    {
      "code" : "S93141",
      "display" : "S93141 Subluxación de articulación metatarsofalángica de dedo gordo del pie derecho"
    },
    {
      "code" : "S96122D",
      "display" : "S96122D Desgarro de músculo y tendón extensor largo de dedo del pie a nivel de tobillo y pie pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S9619",
      "display" : "S9619 Otro traumatismo especificado de músculo y tendón extensor largo de dedo del pie a nivel de tobillo y pie"
    },
    {
      "code" : "S99199",
      "display" : "S99199 Otra fractura fisaria de metatarso no especificado"
    },
    {
      "code" : "S99199G",
      "display" : "S99199G Otra fractura fisaria de metatarso no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S99201",
      "display" : "S99201 Fractura fisaria no especificada de falange de dedo del pie derecho"
    },
    {
      "code" : "S99201K",
      "display" : "S99201K Fractura fisaria no especificada de falange de dedo del pie derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92353B",
      "display" : "S92353B Fractura desplazada de quinto metatarsiano de pie no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S92353S",
      "display" : "S92353S Fractura desplazada de quinto metatarsiano de pie no especificado secuela"
    },
    {
      "code" : "S92354G",
      "display" : "S92354G Fractura sin desplazamiento de quinto metatarsiano del pie derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S93149D",
      "display" : "S93149D Subluxación de articulación metatarsofalángica de dedo(s) de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S93301D",
      "display" : "S93301D Subluxación no especificada del pie derecho contacto sucesivo"
    },
    {
      "code" : "S93302S",
      "display" : "S93302S Subluxación no especificada del pie izquierdo secuela"
    },
    {
      "code" : "S93303S",
      "display" : "S93303S Subluxación no especificada de pie no especificado secuela"
    },
    {
      "code" : "S93305",
      "display" : "S93305 Luxación no especificada del pie izquierdo"
    },
    {
      "code" : "S93306",
      "display" : "S93306 Luxación no especificada de pie no especificado"
    },
    {
      "code" : "S96209S",
      "display" : "S96209S Traumatismo no especificado de músculo y tendón intrínseco a nivel de tobillo y pie pie no especificado secuela"
    },
    {
      "code" : "S96212",
      "display" : "S96212 Distensión de músculo y tendón intrínseco a nivel de tobillo y pie pie izquierdo"
    },
    {
      "code" : "S96219D",
      "display" : "S96219D Distensión de músculo y tendón intrínseco a nivel de tobillo y pie pie no especificado contacto sucesivo"
    },
    {
      "code" : "S92142G",
      "display" : "S92142G Fractura desplazada de cúpula de astrágalo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92143B",
      "display" : "S92143B Fractura desplazada de cúpula de astrágalo no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S5411XS",
      "display" : "S5411XS Traumatismo de nervio mediano a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S5412XS",
      "display" : "S5412XS Traumatismo de nervio mediano a nivel de antebrazo lado izquierdo secuela"
    },
    {
      "code" : "S56414A",
      "display" : "S56414A Distensión de músculo fascia y tendón extensor de dedo medio izquierdo a nivel de antebrazo contacto inicial"
    },
    {
      "code" : "S56415S",
      "display" : "S56415S Distensión de músculo fascia y tendón extensor de dedo anular derecho a nivel de antebrazo secuela"
    },
    {
      "code" : "S56417A",
      "display" : "S56417A Distensión de músculo fascia y tendón extensor de dedo meñique derecho a nivel de antebrazo contacto inicial"
    },
    {
      "code" : "S52372M",
      "display" : "S52372M Fractura de Galeazzi de radio izquierdo contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S52379A",
      "display" : "S52379A Fractura de Galeazzi de radio no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52379E",
      "display" : "S52379E Fractura de Galeazzi de radio no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S526",
      "display" : "S526 Fractura de extremo inferior de cúbito"
    },
    {
      "code" : "S52601B",
      "display" : "S52601B Fractura no especificada de extremo inferior de cúbito derecho contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52601J",
      "display" : "S52601J Fractura no especificada de extremo inferior de cúbito derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S5431XD",
      "display" : "S5431XD Traumatismo de nervio sensitivo cutáneo a nivel de antebrazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S5432XS",
      "display" : "S5432XS Traumatismo de nervio sensitivo cutáneo a nivel de antebrazo lado izquierdo secuela"
    },
    {
      "code" : "S548X1A",
      "display" : "S548X1A Traumatismo de otros nervios a nivel de antebrazo lado derecho contacto inicial"
    },
    {
      "code" : "S548X2D",
      "display" : "S548X2D Traumatismo de otros nervios a nivel de antebrazo lado izquierdo contacto sucesivo"
    },
    {
      "code" : "S548X9S",
      "display" : "S548X9S Traumatismo de otros nervios a nivel de antebrazo brazo no especificado secuela"
    },
    {
      "code" : "S56425S",
      "display" : "S56425S Desgarro de músculo fascia y tendón extensor de dedo anular derecho a nivel de antebrazo secuela"
    },
    {
      "code" : "S56427A",
      "display" : "S56427A Desgarro de músculo fascia y tendón extensor de dedo meñique derecho a nivel de antebrazo contacto inicial"
    },
    {
      "code" : "S52381S",
      "display" : "S52381S Arqueamiento óseo de radio derecho secuela"
    },
    {
      "code" : "S52382C",
      "display" : "S52382C Arqueamiento óseo de radio izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52382J",
      "display" : "S52382J Arqueamiento óseo de radio izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S52609B",
      "display" : "S52609B Fractura no especificada de extremo inferior de cúbito no especificado contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S52609H",
      "display" : "S52609H Fractura no especificada de extremo inferior de cúbito no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S55009A",
      "display" : "S55009A Traumatismo no especificado de arteria cubital a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S55011D",
      "display" : "S55011D Desgarro de arteria cubital a nivel de antebrazo lado derecho contacto sucesivo"
    },
    {
      "code" : "S55012S",
      "display" : "S55012S Desgarro de arteria cubital a nivel de antebrazo lado izquierdo secuela"
    },
    {
      "code" : "S5509",
      "display" : "S5509 Otro traumatismo especificado de arteria cubital a nivel de antebrazo"
    },
    {
      "code" : "S55092",
      "display" : "S55092 Otro traumatismo especificado de arteria cubital a nivel de antebrazo lado izquierdo"
    },
    {
      "code" : "S56496",
      "display" : "S56496 Otro traumatismo de músculo fascia y tendón extensor de dedo anular izquierdo a nivel de antebrazo"
    },
    {
      "code" : "S56497D",
      "display" : "S56497D Otro traumatismo de músculo fascia y tendón extensor de dedo meñique derecho a nivel de antebrazo contacto sucesivo"
    },
    {
      "code" : "S56499",
      "display" : "S56499 Otro traumatismo de músculo fascia y tendón extensor de dedo de mano no especificado a nivel de antebrazo"
    },
    {
      "code" : "S71039S",
      "display" : "S71039S Herida punzante sin cuerpo extraño de cadera no especificada secuela"
    },
    {
      "code" : "S71041S",
      "display" : "S71041S Herida punzante con cuerpo extraño de cadera derecha secuela"
    },
    {
      "code" : "S71049",
      "display" : "S71049 Herida punzante con cuerpo extraño de cadera no especificada"
    },
    {
      "code" : "S7105",
      "display" : "S7105 Mordedura abierta de cadera"
    },
    {
      "code" : "S71051S",
      "display" : "S71051S Mordedura abierta de cadera derecha secuela"
    },
    {
      "code" : "S71159",
      "display" : "S71159 Mordedura abierta de muslo no especificado"
    },
    {
      "code" : "S72",
      "display" : "S72 Fractura de fémur"
    },
    {
      "code" : "S72001",
      "display" : "S72001 Fractura de parte no especificada del cuello de fémur derecho"
    },
    {
      "code" : "S72001E",
      "display" : "S72001E Fractura de parte no especificada del cuello de fémur derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72001N",
      "display" : "S72001N Fractura de parte no especificada del cuello de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S72092A",
      "display" : "S72092A Otra fractura de cabeza y cuello de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72092G",
      "display" : "S72092G Otra fractura de cabeza y cuello de fémur izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72092P",
      "display" : "S72092P Otra fractura de cabeza y cuello de fémur izquierdo contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S66115",
      "display" : "S66115 Distensión de músculo fascia y tendón flexor de dedo anular izquierdo a nivel de muñeca y mano"
    },
    {
      "code" : "S66116A",
      "display" : "S66116A Distensión de músculo fascia y tendón flexor de dedo meñique derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S71112D",
      "display" : "S71112D Desgarro sin cuerpo extraño de muslo izquierdo contacto sucesivo"
    },
    {
      "code" : "S71119S",
      "display" : "S71119S Desgarro sin cuerpo extraño de muslo no especificado secuela"
    },
    {
      "code" : "S71121A",
      "display" : "S71121A Desgarro con cuerpo extraño de muslo derecho contacto inicial"
    },
    {
      "code" : "S71122D",
      "display" : "S71122D Desgarro con cuerpo extraño de muslo izquierdo contacto sucesivo"
    },
    {
      "code" : "S71129S",
      "display" : "S71129S Desgarro con cuerpo extraño de muslo no especificado secuela"
    },
    {
      "code" : "S71131D",
      "display" : "S71131D Herida punzante sin cuerpo extraño de muslo derecho contacto sucesivo"
    },
    {
      "code" : "S71132S",
      "display" : "S71132S Herida punzante sin cuerpo extraño de muslo izquierdo secuela"
    },
    {
      "code" : "S72009J",
      "display" : "S72009J Fractura de parte no especificado del cuello de fémur no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S7201",
      "display" : "S7201 Fractura intracapsular no especificada de fémur"
    },
    {
      "code" : "S72002A",
      "display" : "S72002A Fractura de parte no especificada del cuello de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S63693S",
      "display" : "S63693S Otro tipo de esguince de dedo medio izquierdo secuela"
    },
    {
      "code" : "S63694S",
      "display" : "S63694S Otro tipo de esguince de dedo anular derecho secuela"
    },
    {
      "code" : "S63695D",
      "display" : "S63695D Otro tipo de esguince de dedo anular izquierdo contacto sucesivo"
    },
    {
      "code" : "S63696S",
      "display" : "S63696S Otro tipo de esguince de dedo meñique derecho secuela"
    },
    {
      "code" : "S63698",
      "display" : "S63698 Otro tipo de esguince de otro dedo de mano"
    },
    {
      "code" : "S63698S",
      "display" : "S63698S Otro tipo de esguince de otro dedo de mano secuela"
    },
    {
      "code" : "S638",
      "display" : "S638 Esguince de otra parte de muñeca y mano"
    },
    {
      "code" : "S638X1D",
      "display" : "S638X1D Esguince de otra parte de muñeca y mano derechas contacto sucesivo"
    },
    {
      "code" : "S66123A",
      "display" : "S66123A Desgarro de músculo fascia y tendón flexor de dedo medio izquierdo a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66124S",
      "display" : "S66124S Desgarro de músculo fascia y tendón flexor de dedo anular derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S8103",
      "display" : "S8103 Herida punzante sin cuerpo extraño de rodilla"
    },
    {
      "code" : "S82091S",
      "display" : "S82091S Otra fractura de rótula derecha secuela"
    },
    {
      "code" : "S82092B",
      "display" : "S82092B Otra fractura de rótula izquierda contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82092H",
      "display" : "S82092H Otra fractura de rótula izquierda contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82201K",
      "display" : "S82201K Fractura no especificada de diáfisis de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82201S",
      "display" : "S82201S Fractura no especificada de diáfisis de tibia derecha secuela"
    },
    {
      "code" : "S76809A",
      "display" : "S76809A Traumatismo no especificado de otros músculos fascias y tendones especificados a nivel de muslo no especificado contacto inicial"
    },
    {
      "code" : "S76811S",
      "display" : "S76811S Distensión de otros músculos fascias y tendones especificados a nivel de muslo derecho secuela"
    },
    {
      "code" : "S76819",
      "display" : "S76819 Distensión de otros músculos fascias y tendones especificados a nivel de muslo no especificado"
    },
    {
      "code" : "S81052",
      "display" : "S81052 Mordedura abierta en rodilla izquierda"
    },
    {
      "code" : "S81052S",
      "display" : "S81052S Mordedura abierta en rodilla izquierda secuela"
    },
    {
      "code" : "S818",
      "display" : "S818 Herida abierta de pierna"
    },
    {
      "code" : "S81801A",
      "display" : "S81801A Herida abierta no especificada de pierna derecha contacto inicial"
    },
    {
      "code" : "S81802D",
      "display" : "S81802D Herida abierta no especificada de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S81809D",
      "display" : "S81809D Herida abierta no especificada de pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S81811D",
      "display" : "S81811D Desgarro sin cuerpo extraño de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S82101E",
      "display" : "S82101E Fractura no especificada de extremo superior de tibia derecha contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82101K",
      "display" : "S82101K Fractura no especificada de extremo superior de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82209N",
      "display" : "S82209N Fractura no especificada de diáfisis de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82221A",
      "display" : "S82221A Fractura transversal desplazada de diáfisis de tibia derecha contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82221F",
      "display" : "S82221F Fractura transversal desplazada de diáfisis de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S769",
      "display" : "S769 Traumatismo de músculos fascias y tendones no especificados a nivel de muslo"
    },
    {
      "code" : "S76901S",
      "display" : "S76901S Traumatismo no especificado de músculos fascias y tendones no especificados a nivel de muslo derecho secuela"
    },
    {
      "code" : "S76909",
      "display" : "S76909 Traumatismo no especificado de músculos fascias y tendones no especificados a nivel de muslo no especificado"
    },
    {
      "code" : "S81832D",
      "display" : "S81832D Herida punzante sin cuerpo extraño de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S81812A",
      "display" : "S81812A Desgarro sin cuerpo extraño de pierna izquierda contacto inicial"
    },
    {
      "code" : "S81841D",
      "display" : "S81841D Herida punzante con cuerpo extraño de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S81842S",
      "display" : "S81842S Herida punzante con cuerpo extraño de pierna izquierda secuela"
    },
    {
      "code" : "S81849S",
      "display" : "S81849S Herida punzante con cuerpo extraño de pierna no especificada secuela"
    },
    {
      "code" : "S81851S",
      "display" : "S81851S Mordedura abierta en pierna derecha secuela"
    },
    {
      "code" : "S81852S",
      "display" : "S81852S Mordedura abierta en pierna izquierda secuela"
    },
    {
      "code" : "S82109G",
      "display" : "S82109G Fractura no especificada de extremo superior de tibia no especificada contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82109P",
      "display" : "S82109P Fractura no especificada de extremo superior de tibia no especificada contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S92143S",
      "display" : "S92143S Fractura desplazada de cúpula de astrágalo no especificado secuela"
    },
    {
      "code" : "S92402B",
      "display" : "S92402B Fractura no especificada desplazada de dedo gordo del pie izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S92403",
      "display" : "S92403 Fractura no especificada desplazada de dedo gordo de pie no especificado"
    },
    {
      "code" : "S92403G",
      "display" : "S92403G Fractura no especificada desplazada de dedo gordo de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S93316D",
      "display" : "S93316D Luxación de articulación del tarso de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S93321D",
      "display" : "S93321D Subluxación de articulación tarsometatarsiana del pie derecho contacto sucesivo"
    },
    {
      "code" : "S93322S",
      "display" : "S93322S Subluxación de articulación tarsometatarsiana del pie izquierdo secuela"
    },
    {
      "code" : "S93324",
      "display" : "S93324 Luxación de articulación tarsometatarsiana del pie derecho"
    },
    {
      "code" : "S93325A",
      "display" : "S93325A Luxación de articulación tarsometatarsiana del pie izquierdo contacto inicial"
    },
    {
      "code" : "S93326D",
      "display" : "S93326D Luxación de articulación tarsometatarsiana de pie no especificado contacto sucesivo"
    },
    {
      "code" : "S9680",
      "display" : "S9680 Traumatismo no especificado de otros músculos y tendones especificados a nivel de tobillo y pie"
    },
    {
      "code" : "S96802A",
      "display" : "S96802A Traumatismo no especificado de otros músculos y tendones especificados a nivel de tobillo y pie pie izquierdo contacto inicial"
    },
    {
      "code" : "S9681",
      "display" : "S9681 Distensión de otros músculos y tendones especificados a nivel de tobillo y pie"
    },
    {
      "code" : "S92151D",
      "display" : "S92151D Fractura por arrancamiento (avulsión) desplazada (fractura en astilla) de astrágalo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92152B",
      "display" : "S92152B Fractura por arrancamiento (avulsión) desplazada (fractura en astilla) de astrágalo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S92411",
      "display" : "S92411 Fractura desplazada de falange proximal de dedo gordo del pie derecho"
    },
    {
      "code" : "S92411K",
      "display" : "S92411K Fractura desplazada de falange proximal de dedo gordo del pie derecho contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92412G",
      "display" : "S92412G Fractura desplazada de falange proximal de dedo gordo del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S93401",
      "display" : "S93401 Esguince de ligamento no especificado de tobillo derecho"
    },
    {
      "code" : "S93402",
      "display" : "S93402 Esguince de ligamento no especificado de tobillo izquierdo"
    },
    {
      "code" : "S93409A",
      "display" : "S93409A Esguince de ligamento no especificado de tobillo no especificado contacto inicial"
    },
    {
      "code" : "S93411A",
      "display" : "S93411A Esguince de ligamento calcaneoperoneo de tobillo derecho contacto inicial"
    },
    {
      "code" : "S93412D",
      "display" : "S93412D Esguince de ligamento calcaneoperoneo de tobillo izquierdo contacto sucesivo"
    },
    {
      "code" : "S93419S",
      "display" : "S93419S Esguince de ligamento calcaneoperoneo de tobillo no especificado secuela"
    },
    {
      "code" : "S96892A",
      "display" : "S96892A Otro traumatismo de otros músculos y tendones especificados a nivel de tobillo y pie pie izquierdo contacto inicial"
    },
    {
      "code" : "S96899S",
      "display" : "S96899S Otro traumatismo de otros músculos y tendones especificados a nivel de tobillo y pie pie no especificado secuela"
    },
    {
      "code" : "S96901S",
      "display" : "S96901S Traumatismo no especificado de músculo y tendón no especificados a nivel de tobillo y pie pie derecho secuela"
    },
    {
      "code" : "S92156D",
      "display" : "S92156D Fractura por arrancamiento (avulsión) sin desplazamiento (fractura en astilla) de astrágalo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92416B",
      "display" : "S92416B Fractura sin desplazamiento de falange proximal de dedo gordo de pie no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S92421",
      "display" : "S92421 Fractura desplazada de falange distal de dedo gordo del pie derecho"
    },
    {
      "code" : "S93492A",
      "display" : "S93492A Esguince de otro ligamento de tobillo izquierdo contacto inicial"
    },
    {
      "code" : "S93499D",
      "display" : "S93499D Esguince de otro ligamento de tobillo no especificado contacto sucesivo"
    },
    {
      "code" : "S52391J",
      "display" : "S52391J Otra fractura de diáfisis de radio brazo derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S52391S",
      "display" : "S52391S Otra fractura de diáfisis de radio brazo derecho secuela"
    },
    {
      "code" : "S52392C",
      "display" : "S52392C Otra fractura de diáfisis de radio brazo izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S52612A",
      "display" : "S52612A Fractura desplazada de apófisis estiloides del cúbito izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S52612G",
      "display" : "S52612G Fractura desplazada de apófisis estiloides del cúbito izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S61131A",
      "display" : "S61131A Herida punzante sin cuerpo extraño de pulgar derecho con daños en la uña contacto inicial"
    },
    {
      "code" : "S61132D",
      "display" : "S61132D Herida punzante sin cuerpo extraño de pulgar izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61139S",
      "display" : "S61139S Herida punzante sin cuerpo extraño de pulgar no especificado con daños en la uña secuela"
    },
    {
      "code" : "S61142",
      "display" : "S61142 Herida punzante con cuerpo extraño de pulgar izquierdo con daños en la uña"
    },
    {
      "code" : "S61549",
      "display" : "S61549 Herida punzante con cuerpo extraño de muñeca no especificada"
    },
    {
      "code" : "S6155",
      "display" : "S6155 Mordedura abierta de muñeca"
    },
    {
      "code" : "S61551D",
      "display" : "S61551D Mordedura abierta de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S61552D",
      "display" : "S61552D Mordedura abierta de muñeca izquierda contacto sucesivo"
    },
    {
      "code" : "S61559S",
      "display" : "S61559S Mordedura abierta de muñeca no especificada secuela"
    },
    {
      "code" : "S62001",
      "display" : "S62001 Fractura no especificada de escafoides [navicular] de muñeca derecha"
    },
    {
      "code" : "S62231D",
      "display" : "S62231D Otro tipo de fractura desplazada de base de primer metacarpiano de la mano derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62232A",
      "display" : "S62232A Otro tipo de fractura desplazada de base de primer metacarpiano de la mano izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62233",
      "display" : "S62233 Otro tipo de fractura desplazada de base de primer metacarpiano de mano no especificada"
    },
    {
      "code" : "S59902A",
      "display" : "S59902A Traumatismo no especificado de codo izquierdo contacto inicial"
    },
    {
      "code" : "S59909D",
      "display" : "S59909D Traumatismo no especificado de codo no especificado contacto sucesivo"
    },
    {
      "code" : "S59911D",
      "display" : "S59911D Traumatismo no especificado de antebrazo derecho contacto sucesivo"
    },
    {
      "code" : "S59802S",
      "display" : "S59802S Otros traumatismos especificados de codo izquierdo secuela"
    },
    {
      "code" : "S59919D",
      "display" : "S59919D Traumatismo no especificado de antebrazo no especificado contacto sucesivo"
    },
    {
      "code" : "S6000X",
      "display" : "S6000X Contusión de dedo de mano no especificado sin daños en la uña"
    },
    {
      "code" : "S60011",
      "display" : "S60011 Contusión de pulgar derecho sin daños en la uña"
    },
    {
      "code" : "S62011G",
      "display" : "S62011G Fractura desplazada de polo distal de hueso escafoides [navicular] de muñeca derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62012D",
      "display" : "S62012D Fractura desplazada de polo distal de hueso escafoides [navicular] de muñeca izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62013A",
      "display" : "S62013A Fractura desplazada de polo distal de hueso escafoides [navicular] de muñeca no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62024S",
      "display" : "S62024S Fractura sin desplazamiento de tercio medio de hueso escafoides [navicular] de muñeca derecha secuela"
    },
    {
      "code" : "S62025K",
      "display" : "S62025K Fractura sin desplazamiento de tercio medio de hueso escafoides [navicular] de muñeca izquierda contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S62236P",
      "display" : "S62236P Otro tipo de fractura sin desplazamiento de base de primer metacarpiano de mano no especificada contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S62241G",
      "display" : "S62241G Fractura desplazada de diáfisis de primer metacarpiano de mano derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S66126A",
      "display" : "S66126A Desgarro de músculo fascia y tendón flexor de dedo meñique derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66921S",
      "display" : "S66921S Desgarro de músculo fascia y tendón no especificado a nivel de muñeca y mano derechas secuela"
    },
    {
      "code" : "S66929A",
      "display" : "S66929A Desgarro de músculo fascia y tendón no especificados a nivel de muñeca y mano mano no especificada contacto inicial"
    },
    {
      "code" : "S72012S",
      "display" : "S72012S Fractura intracapsular no especificada de fémur izquierdo secuela"
    },
    {
      "code" : "S72019D",
      "display" : "S72019D Fractura intracapsular no especificada de fémur no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S640",
      "display" : "S640 Traumatismo de nervio cubital a nivel de muñeca y mano"
    },
    {
      "code" : "S6400XS",
      "display" : "S6400XS Traumatismo de nervio cubital a nivel de muñeca y mano brazo no especificado secuela"
    },
    {
      "code" : "S6401XS",
      "display" : "S6401XS Traumatismo de nervio cubital a nivel de muñeca y mano brazo derecho secuela"
    },
    {
      "code" : "S6402XS",
      "display" : "S6402XS Traumatismo de nervio cubital a nivel de muñeca y mano brazo izquierdo secuela"
    },
    {
      "code" : "S6410XD",
      "display" : "S6410XD Traumatismo de nervio mediano a nivel de muñeca y mano brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S6411XS",
      "display" : "S6411XS Traumatismo de nervio mediano a nivel de muñeca y mano brazo derecho secuela"
    },
    {
      "code" : "S66193A",
      "display" : "S66193A Otro traumatismo de músculo fascia y tendón flexor de dedo medio izquierdo a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66194S",
      "display" : "S66194S Otro traumatismo de músculo fascia y tendón flexor de dedo anular derecho a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S66196A",
      "display" : "S66196A Otro traumatismo de músculo fascia y tendón flexor de dedo meñique derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S6702XS",
      "display" : "S6702XS Lesión por aplastamiento de pulgar izquierdo secuela"
    },
    {
      "code" : "S66991A",
      "display" : "S66991A Otro traumatismo de músculo fascia y tendón no especificado a nivel de muñeca y mano derechas contacto inicial"
    },
    {
      "code" : "S67190A",
      "display" : "S67190A Lesión por aplastamiento de dedo índice derecho contacto inicial"
    },
    {
      "code" : "S67191D",
      "display" : "S67191D Lesión por aplastamiento de dedo índice izquierdo contacto sucesivo"
    },
    {
      "code" : "S67192S",
      "display" : "S67192S Lesión por aplastamiento de dedo medio derecho secuela"
    },
    {
      "code" : "S67193S",
      "display" : "S67193S Lesión por aplastamiento de dedo medio izquierdo secuela"
    },
    {
      "code" : "S72022A",
      "display" : "S72022A Fractura desplazada de epífisis (separación) (superior) de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S6430XD",
      "display" : "S6430XD Traumatismo de nervio digital de pulgar no especificado contacto sucesivo"
    },
    {
      "code" : "S6431XD",
      "display" : "S6431XD Traumatismo de nervio digital de pulgar derecho contacto sucesivo"
    },
    {
      "code" : "S6432XD",
      "display" : "S6432XD Traumatismo de nervio digital de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S6440XA",
      "display" : "S6440XA Traumatismo de nervio digital de dedo de mano no especificado contacto inicial"
    },
    {
      "code" : "S64490A",
      "display" : "S64490A Traumatismo de nervio digital de dedo índice derecho contacto inicial"
    },
    {
      "code" : "S64491D",
      "display" : "S64491D Traumatismo de nervio digital de dedo índice izquierdo contacto sucesivo"
    },
    {
      "code" : "S66211A",
      "display" : "S66211A Distensión de músculo fascia y tendón extensor de pulgar derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66212S",
      "display" : "S66212S Distensión de músculo fascia y tendón extensor de pulgar izquierdo a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S6721",
      "display" : "S6721 Lesión por aplastamiento de mano derecha"
    },
    {
      "code" : "S6721XD",
      "display" : "S6721XD Lesión por aplastamiento de mano derecha contacto sucesivo"
    },
    {
      "code" : "S6722XD",
      "display" : "S6722XD Lesión por aplastamiento de mano izquierda contacto sucesivo"
    },
    {
      "code" : "S6730XA",
      "display" : "S6730XA Lesión por aplastamiento de muñeca no especificada contacto inicial"
    },
    {
      "code" : "S6731X",
      "display" : "S6731X Lesión por aplastamiento de muñeca derecha"
    },
    {
      "code" : "S82223B",
      "display" : "S82223B Fractura transversal desplazada de diáfisis de tibia no especificada contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82223H",
      "display" : "S82223H Fractura transversal desplazada de diáfisis de tibia no especificada contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S76991S",
      "display" : "S76991S Otro traumatismo no especificado de músculos fascias y tendones no especificados a nivel de muslo derecho secuela"
    },
    {
      "code" : "S76999A",
      "display" : "S76999A Otro traumatismo no especificado de músculos fascias y tendones no especificados a nivel de muslo no especificado contacto inicial"
    },
    {
      "code" : "S7700XA",
      "display" : "S7700XA Lesión por aplastamiento de cadera no especificada contacto inicial"
    },
    {
      "code" : "S82002E",
      "display" : "S82002E Fractura no especificada de rótula izquierda contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82002N",
      "display" : "S82002N Fractura no especificada de rótula izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82009B",
      "display" : "S82009B Fractura no especificada de rótula no especificada contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82112M",
      "display" : "S82112M Fractura desplazada de espina tibial izquierda contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S82113A",
      "display" : "S82113A Fractura desplazada de espina tibial no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82113F",
      "display" : "S82113F Fractura desplazada de espina tibial no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82225D",
      "display" : "S82225D Fractura transversal sin desplazamiento de diáfisis de tibia izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S772",
      "display" : "S772 Lesión por aplastamiento de cadera con muslo"
    },
    {
      "code" : "S7720XD",
      "display" : "S7720XD Lesión por aplastamiento de cadera no especificada con muslo contacto sucesivo"
    },
    {
      "code" : "S7721XD",
      "display" : "S7721XD Lesión por aplastamiento de cadera derecha con muslo contacto sucesivo"
    },
    {
      "code" : "S7722XD",
      "display" : "S7722XD Lesión por aplastamiento de cadera izquierda con muslo contacto sucesivo"
    },
    {
      "code" : "S78011",
      "display" : "S78011 Amputación traumática completa a nivel de articulación de la cadera derecha"
    },
    {
      "code" : "S78012A",
      "display" : "S78012A Amputación traumática completa a nivel de articulación de la cadera izquierda contacto inicial"
    },
    {
      "code" : "S82011Q",
      "display" : "S82011Q Fractura osteocondral desplazada de rótula derecha contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S82012C",
      "display" : "S82012C Fractura osteocondral desplazada de rótula izquierda contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S83241A",
      "display" : "S83241A Otro tipo de desgarro de menisco interno lesión actual de rodilla derecha contacto inicial"
    },
    {
      "code" : "S83242A",
      "display" : "S83242A Otro tipo de desgarro de menisco interno lesión actual de rodilla izquierda contacto inicial"
    },
    {
      "code" : "S83249S",
      "display" : "S83249S Otro tipo de desgarro de menisco interno lesión actual de rodilla no especificada secuela"
    },
    {
      "code" : "S83251S",
      "display" : "S83251S Desgarro en asa de cubo de menisco externo lesión actual de rodilla derecha secuela"
    },
    {
      "code" : "S82391K",
      "display" : "S82391K Otra fractura de extremo inferior de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82391S",
      "display" : "S82391S Otra fractura de extremo inferior de tibia derecha secuela"
    },
    {
      "code" : "S82392C",
      "display" : "S82392C Otra fractura de extremo inferior de tibia izquierda contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82465M",
      "display" : "S82465M Fractura segmentaria sin desplazamiento de diáfisis de peroné izquierdo contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S82855G",
      "display" : "S82855G Fractura trimaleolar sin desplazamiento de pierna izquierda contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82853M",
      "display" : "S82853M Fractura trimaleolar desplazada de pierna no especificada contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S93501A",
      "display" : "S93501A Esguince no especificado de dedo gordo del pie derecho contacto inicial"
    },
    {
      "code" : "S93502D",
      "display" : "S93502D Esguince no especificado de dedo gordo del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S93503S",
      "display" : "S93503S Esguince no especificado de dedo gordo de pie no especificado secuela"
    },
    {
      "code" : "S93505",
      "display" : "S93505 Esguince no especificado de dedo(s) menor(es) del pie izquierdo"
    },
    {
      "code" : "S96922S",
      "display" : "S96922S Desgarro de músculo y tendón no especificados a nivel de tobillo y pie pie izquierdo secuela"
    },
    {
      "code" : "S96991",
      "display" : "S96991 Otro traumatismo especificado de músculo y tendón no especificados a nivel de tobillo y pie pie derecho"
    },
    {
      "code" : "S92201P",
      "display" : "S92201P Fractura de hueso(s) del tarso no especificado del pie derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92202G",
      "display" : "S92202G Fractura de hueso(s) del tarso no especificado del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92209B",
      "display" : "S92209B Fractura de hueso(s) del tarso no especificado de pie no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S92425A",
      "display" : "S92425A Fractura sin desplazamiento de falange distal de dedo gordo del pie izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92426",
      "display" : "S92426 Fractura sin desplazamiento de falange distal de dedo gordo de pie no especificado"
    },
    {
      "code" : "S93514S",
      "display" : "S93514S Esguince de articulación interfalángica de dedo(s) menor(es) del pie derecho secuela"
    },
    {
      "code" : "S93516A",
      "display" : "S93516A Esguince de articulación interfalángica de dedo(s) menor(es) de pie no especificado contacto inicial"
    },
    {
      "code" : "S93519S",
      "display" : "S93519S Esguince de articulación interfalángica de dedo(s) de pie no especificado secuela"
    },
    {
      "code" : "S93521S",
      "display" : "S93521S Esguince de articulación metatarsofalángica de dedo gordo del pie derecho secuela"
    },
    {
      "code" : "S97101A",
      "display" : "S97101A Lesión por aplastamiento de dedo(s) del pie derecho no especificado contacto inicial"
    },
    {
      "code" : "S97102D",
      "display" : "S97102D Lesión por aplastamiento de dedo(s) del pie izquierdo no especificado contacto sucesivo"
    },
    {
      "code" : "S9711",
      "display" : "S9711 Lesión por aplastamiento de dedo gordo de pie"
    },
    {
      "code" : "S97111S",
      "display" : "S97111S Lesión por aplastamiento de dedo gordo del pie derecho secuela"
    },
    {
      "code" : "S97112S",
      "display" : "S97112S Lesión por aplastamiento de dedo gordo del pie izquierdo secuela"
    },
    {
      "code" : "S9712",
      "display" : "S9712 Lesión por aplastamiento de dedo(s) menor(es) del pie"
    },
    {
      "code" : "S92213P",
      "display" : "S92213P Fractura desplazada de hueso cuboides de pie no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92214G",
      "display" : "S92214G Fractura sin desplazamiento de hueso cuboides del pie derecho contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92215D",
      "display" : "S92215D Fractura sin desplazamiento de hueso cuboides del pie izquierdo contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92499K",
      "display" : "S92499K Otra fractura de dedo gordo de pie no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92501A",
      "display" : "S92501A Fractura no especificada desplazada de dedo(s) menor(es) del pie derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92502",
      "display" : "S92502 Fractura no especificada desplazada de dedo(s) menor(es) del pie izquierdo"
    },
    {
      "code" : "S93601",
      "display" : "S93601 Esguince no especificado del pie derecho"
    },
    {
      "code" : "S93602",
      "display" : "S93602 Esguince no especificado del pie izquierdo"
    },
    {
      "code" : "S93609",
      "display" : "S93609 Esguince no especificado de pie no especificado"
    },
    {
      "code" : "S9361",
      "display" : "S9361 Esguince de ligamento del tarso de pie"
    },
    {
      "code" : "S93611S",
      "display" : "S93611S Esguince de ligamento del tarso del pie derecho secuela"
    },
    {
      "code" : "S93612S",
      "display" : "S93612S Esguince de ligamento del tarso del pie izquierdo secuela"
    },
    {
      "code" : "S9362",
      "display" : "S9362 Esguince de ligamento tarsometatarsiano de pie"
    },
    {
      "code" : "S60032A",
      "display" : "S60032A Contusión de dedo medio izquierdo sin daños en la uña contacto inicial"
    },
    {
      "code" : "S60039D",
      "display" : "S60039D Contusión de dedo medio no especificado sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S60041D",
      "display" : "S60041D Contusión de dedo anular derecho sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S60042D",
      "display" : "S60042D Contusión de dedo anular izquierdo sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S60049S",
      "display" : "S60049S Contusión de dedo anular no especificado sin daños en la uña secuela"
    },
    {
      "code" : "S60051S",
      "display" : "S60051S Contusión de dedo meñique derecho sin daños en la uña secuela"
    },
    {
      "code" : "S62016D",
      "display" : "S62016D Fractura sin desplazamiento de polo distal de hueso escafoides [navicular] de muñeca no especificada contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62021B",
      "display" : "S62021B Fractura desplazada de tercio medio de hueso escafoides [navicular] de muñeca derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S62033",
      "display" : "S62033 Fractura desplazada de tercio proximal de hueso escafoides [navicular] de muñeca no especificada"
    },
    {
      "code" : "S62033P",
      "display" : "S62033P Fractura desplazada de tercio proximal de hueso escafoides [navicular] de muñeca no especificada contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S56991S",
      "display" : "S56991S Otro traumatismo de músculos fascias y tendones no especificados a nivel de antebrazo lado derecho secuela"
    },
    {
      "code" : "S56999A",
      "display" : "S56999A Otro traumatismo de músculos fascias y tendones no especificados a nivel de antebrazo brazo no especificado contacto inicial"
    },
    {
      "code" : "S5700X",
      "display" : "S5700X Traumatismo por aplastamiento de codo no especificado"
    },
    {
      "code" : "S6012",
      "display" : "S6012 Contusión de dedo índice con daños en la uña"
    },
    {
      "code" : "S60121S",
      "display" : "S60121S Contusión de dedo índice derecho con daños en la uña secuela"
    },
    {
      "code" : "S60129",
      "display" : "S60129 Contusión de dedo índice no especificado con daños en la uña"
    },
    {
      "code" : "S60131",
      "display" : "S60131 Contusión de dedo medio derecho con daños en la uña"
    },
    {
      "code" : "S60131S",
      "display" : "S60131S Contusión de dedo medio derecho con daños en la uña secuela"
    },
    {
      "code" : "S60139",
      "display" : "S60139 Contusión de dedo medio no especificado con daños en la uña"
    },
    {
      "code" : "S61201A",
      "display" : "S61201A Herida abierta no especificada de dedo índice izquierdo sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61202S",
      "display" : "S61202S Herida abierta no especificada de dedo medio derecho sin daños en la uña secuela"
    },
    {
      "code" : "S61204",
      "display" : "S61204 Herida abierta no especificada de dedo anular derecho sin daños en la uña"
    },
    {
      "code" : "S61205",
      "display" : "S61205 Herida abierta no especificada de dedo anular izquierdo sin daños en la uña"
    },
    {
      "code" : "S61206A",
      "display" : "S61206A Herida abierta no especificada de dedo meñique derecho sin daños en la uña contacto inicial"
    },
    {
      "code" : "S62101G",
      "display" : "S62101G Fractura de hueso del carpo no especificado de muñeca derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62102D",
      "display" : "S62102D Fractura de hueso del carpo no especificado de muñeca izquierda contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S580",
      "display" : "S580 Amputación traumática a nivel de codo"
    },
    {
      "code" : "S58011A",
      "display" : "S58011A Amputación traumática completa a nivel de codo del brazo derecho contacto inicial"
    },
    {
      "code" : "S58012D",
      "display" : "S58012D Amputación traumática completa a nivel de codo del brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S58019S",
      "display" : "S58019S Amputación traumática completa a nivel de codo brazo no especificado secuela"
    },
    {
      "code" : "S58021S",
      "display" : "S58021S Amputación traumática parcial a nivel de codo derecho secuela"
    },
    {
      "code" : "S58029",
      "display" : "S58029 Amputación traumática parcial a nivel de codo brazo no especificado"
    },
    {
      "code" : "S602",
      "display" : "S602 Contusión de muñeca y mano"
    },
    {
      "code" : "S60211D",
      "display" : "S60211D Contusión de muñeca derecha contacto sucesivo"
    },
    {
      "code" : "S6732",
      "display" : "S6732 Lesión por aplastamiento de muñeca izquierda"
    },
    {
      "code" : "S674",
      "display" : "S674 Lesión por aplastamiento de muñeca y mano"
    },
    {
      "code" : "S6740XA",
      "display" : "S6740XA Lesión por aplastamiento de muñeca y mano no especificadas contacto inicial"
    },
    {
      "code" : "S72024C",
      "display" : "S72024C Fractura sin desplazamiento de epífisis (separación) (superior) de fémur derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S648",
      "display" : "S648 Traumatismo de otros nervios a nivel de muñeca y mano"
    },
    {
      "code" : "S648X1D",
      "display" : "S648X1D Traumatismo de otros nervios a nivel de muñeca y mano brazo derecho contacto sucesivo"
    },
    {
      "code" : "S648X2D",
      "display" : "S648X2D Traumatismo de otros nervios a nivel de muñeca y mano brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S649",
      "display" : "S649 Traumatismo de nervio no especificado a nivel de muñeca y mano"
    },
    {
      "code" : "S6490XD",
      "display" : "S6490XD Traumatismo de nervio no especificado a nivel de muñeca y mano brazo no especificado contacto sucesivo"
    },
    {
      "code" : "S66300",
      "display" : "S66300 Traumatismo no especificado de músculo fascia y tendón extensor de dedo índice derecho a nivel de muñeca y mano"
    },
    {
      "code" : "S66301D",
      "display" : "S66301D Traumatismo no especificado de músculo fascia y tendón extensor de dedo índice izquierdo a nivel de muñeca y mano contacto sucesivo"
    },
    {
      "code" : "S680",
      "display" : "S680 Amputación traumática metacarpofalángica de pulgar"
    },
    {
      "code" : "S6741X",
      "display" : "S6741X Lesión por aplastamiento de muñeca y mano derecha"
    },
    {
      "code" : "S68012D",
      "display" : "S68012D Amputación traumática metacarpofalángica completa de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S68019S",
      "display" : "S68019S Amputación traumática metacarpofalángica completa de pulgar no especificado secuela"
    },
    {
      "code" : "S68021S",
      "display" : "S68021S Amputación traumática metacarpofalángica parcial de pulgar derecho secuela"
    },
    {
      "code" : "S72025Q",
      "display" : "S72025Q Fractura sin desplazamiento de epífisis (separación) (superior) de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S65012S",
      "display" : "S65012S Desgarro de arteria cubital a nivel de muñeca y mano brazo izquierdo secuela"
    },
    {
      "code" : "S6509",
      "display" : "S6509 Otro traumatismo especificado de arteria cubital a nivel de muñeca y mano"
    },
    {
      "code" : "S65092",
      "display" : "S65092 Otro traumatismo especificado de arteria cubital a nivel de muñeca y mano brazo izquierdo"
    },
    {
      "code" : "S65099A",
      "display" : "S65099A Otro traumatismo especificado de arteria cubital a nivel de muñeca y mano brazo no especificado contacto inicial"
    },
    {
      "code" : "S6631",
      "display" : "S6631 Distensión de músculo fascia y tendón extensor de otros dedos de la mano y los no especificados a nivel de muñeca y mano"
    },
    {
      "code" : "S66311",
      "display" : "S66311 Distensión de músculo fascia y tendón extensor de dedo índice izquierdo a nivel de muñeca y mano"
    },
    {
      "code" : "S68114D",
      "display" : "S68114D Amputación traumática metacarpofalángica completa de dedo anular derecho contacto sucesivo"
    },
    {
      "code" : "S68116",
      "display" : "S68116 Amputación traumática metacarpofalángica completa de dedo meñique derecho"
    },
    {
      "code" : "S68117A",
      "display" : "S68117A Amputación traumática metacarpofalángica completa de dedo meñique izquierdo contacto inicial"
    },
    {
      "code" : "S68118D",
      "display" : "S68118D Amputación traumática metacarpofalángica completa de otro dedo de mano contacto sucesivo"
    },
    {
      "code" : "S72031K",
      "display" : "S72031K Fractura mediocervical desplazada de fémur derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S72032",
      "display" : "S72032 Fractura mediocervical desplazada de fémur izquierdo"
    },
    {
      "code" : "S72032D",
      "display" : "S72032D Fractura mediocervical desplazada de fémur izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S65119",
      "display" : "S65119 Desgarro de arteria radial a nivel de muñeca y mano brazo no especificado"
    },
    {
      "code" : "S65191",
      "display" : "S65191 Otro traumatismo especificado de arteria radial a nivel de muñeca y mano brazo derecho"
    },
    {
      "code" : "S65192A",
      "display" : "S65192A Otro traumatismo especificado de arteria radial a nivel de muñeca y mano brazo izquierdo contacto inicial"
    },
    {
      "code" : "S83279A",
      "display" : "S83279A Desgarro complejo de menisco externo lesión actual de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S83281A",
      "display" : "S83281A Otro tipo de desgarro de menisco externo lesión actual de rodilla derecha contacto inicial"
    },
    {
      "code" : "S83282S",
      "display" : "S83282S Otro tipo de desgarro de menisco externo lesión actual de rodilla izquierda secuela"
    },
    {
      "code" : "S833",
      "display" : "S833 Desgarro de cartílago articular de rodilla actual"
    },
    {
      "code" : "S824",
      "display" : "S824 Fractura de diáfisis de peroné"
    },
    {
      "code" : "S82401A",
      "display" : "S82401A Fractura no especificada de diáfisis de peroné derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82401G",
      "display" : "S82401G Fractura no especificada de diáfisis de peroné derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82491K",
      "display" : "S82491K Otra fractura de diáfisis de peroné derecho contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82492",
      "display" : "S82492 Otra fractura de diáfisis de peroné izquierdo"
    },
    {
      "code" : "S82492D",
      "display" : "S82492D Otra fractura de diáfisis de peroné izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82861C",
      "display" : "S82861C Fractura de Maisonneuve desplazada de pierna derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82861J",
      "display" : "S82861J Fractura de Maisonneuve desplazada de pierna derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82861S",
      "display" : "S82861S Fractura de Maisonneuve desplazada de pierna derecha secuela"
    },
    {
      "code" : "S83411",
      "display" : "S83411 Esguince de ligamento colateral interno de rodilla derecha"
    },
    {
      "code" : "S83412",
      "display" : "S83412 Esguince de ligamento colateral interno de rodilla izquierda"
    },
    {
      "code" : "S83419A",
      "display" : "S83419A Esguince de ligamento colateral interno de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S83421A",
      "display" : "S83421A Esguince de ligamento colateral externo de rodilla derecha contacto inicial"
    },
    {
      "code" : "S83422D",
      "display" : "S83422D Esguince de ligamento colateral externo de rodilla izquierda contacto sucesivo"
    },
    {
      "code" : "S82409E",
      "display" : "S82409E Fractura no especificada de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82409N",
      "display" : "S82409N Fractura no especificada de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S8251",
      "display" : "S8251 Fractura desplazada de maléolo medial de tibia derecha"
    },
    {
      "code" : "S8251XC",
      "display" : "S8251XC Fractura desplazada de maléolo medial de tibia derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82863K",
      "display" : "S82863K Fractura de Maisonneuve desplazada de pierna no especificada contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82864",
      "display" : "S82864 Fractura de Maisonneuve sin desplazamiento de pierna derecha"
    },
    {
      "code" : "S82864D",
      "display" : "S82864D Fractura de Maisonneuve sin desplazamiento de pierna derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82235G",
      "display" : "S82235G Fractura oblicua sin desplazamiento de diáfisis de tibia izquierda contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82235Q",
      "display" : "S82235Q Fractura oblicua sin desplazamiento de diáfisis de tibia izquierda contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S82422G",
      "display" : "S82422G Fractura transversal desplazada de diáfisis de peroné izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82422Q",
      "display" : "S82422Q Fractura transversal desplazada de diáfisis de peroné izquierdo contacto sucesivo por fractura abierta tipo I o II con unión defectuosa"
    },
    {
      "code" : "S8253",
      "display" : "S8253 Fractura desplazada de maléolo medial de tibia no especificada"
    },
    {
      "code" : "S8253XC",
      "display" : "S8253XC Fractura desplazada de maléolo medial de tibia no especificada contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S9782XD",
      "display" : "S9782XD Lesión por aplastamiento del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S9801",
      "display" : "S9801 Amputación traumática completa de pie a nivel de tobillo"
    },
    {
      "code" : "S98012",
      "display" : "S98012 Amputación traumática completa del pie izquierdo a nivel de tobillo"
    },
    {
      "code" : "S98019",
      "display" : "S98019 Amputación traumática completa de pie no especificado a nivel de tobillo"
    },
    {
      "code" : "S98021",
      "display" : "S98021 Amputación traumática parcial del pie derecho a nivel de tobillo"
    },
    {
      "code" : "S98022A",
      "display" : "S98022A Amputación traumática parcial del pie izquierdo a nivel de tobillo contacto inicial"
    },
    {
      "code" : "S92222K",
      "display" : "S92222K Fractura desplazada de cuneiforme lateral del pie izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92223G",
      "display" : "S92223G Fractura desplazada de cuneiforme lateral de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92224B",
      "display" : "S92224B Fractura sin desplazamiento de cuneiforme lateral del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S92506A",
      "display" : "S92506A Fractura no especificada sin desplazamiento de dedo(s) menor(es) de pie no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92506S",
      "display" : "S92506S Fractura no especificada sin desplazamiento de dedo(s) menor(es) de pie no especificado secuela"
    },
    {
      "code" : "S9400XD",
      "display" : "S9400XD Traumatismo de nervio plantar lateral de pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S9401XD",
      "display" : "S9401XD Traumatismo de nervio plantar lateral de pierna derecha contacto sucesivo"
    },
    {
      "code" : "S9402XD",
      "display" : "S9402XD Traumatismo de nervio plantar lateral de pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S9410XA",
      "display" : "S9410XA Traumatismo de nervio plantar medial de pierna no especificada contacto inicial"
    },
    {
      "code" : "S9411XA",
      "display" : "S9411XA Traumatismo de nervio plantar medial de pierna derecha contacto inicial"
    },
    {
      "code" : "S9412XA",
      "display" : "S9412XA Traumatismo de nervio plantar medial de pierna izquierda contacto inicial"
    },
    {
      "code" : "S98129D",
      "display" : "S98129D Amputación traumática parcial de dedo gordo del pie no especificado contacto sucesivo"
    },
    {
      "code" : "S98131S",
      "display" : "S98131S Amputación traumática completa de un dedo menor del pie derecho secuela"
    },
    {
      "code" : "S98139",
      "display" : "S98139 Amputación traumática completa de un dedo menor de pie no especificado"
    },
    {
      "code" : "S98141",
      "display" : "S98141 Amputación traumática parcial de un dedo menor del pie derecho"
    },
    {
      "code" : "S98142",
      "display" : "S98142 Amputación traumática parcial de un dedo menor del pie izquierdo"
    },
    {
      "code" : "S92232B",
      "display" : "S92232B Fractura desplazada de cuneiforme intermedio del pie izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S92233",
      "display" : "S92233 Fractura desplazada de cuneiforme intermedio de pie no especificado"
    },
    {
      "code" : "S92233K",
      "display" : "S92233K Fractura desplazada de cuneiforme intermedio de pie no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S92514S",
      "display" : "S92514S Fractura sin desplazamiento de falange proximal de dedo(s) menor(es) del pie derecho secuela"
    },
    {
      "code" : "S92515G",
      "display" : "S92515G Fractura sin desplazamiento de falange proximal de dedo(s) menor(es) del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S9431XA",
      "display" : "S9431XA Traumatismo de nervio sensitivo cutáneo a nivel de tobillo y pie pierna derecha contacto inicial"
    },
    {
      "code" : "S9432XD",
      "display" : "S9432XD Traumatismo de nervio sensitivo cutáneo a nivel de tobillo y pie pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S948X1D",
      "display" : "S948X1D Traumatismo de otros nervios a nivel de tobillo y pie pierna derecha contacto sucesivo"
    },
    {
      "code" : "S948X2S",
      "display" : "S948X2S Traumatismo de otros nervios a nivel de tobillo y pie pierna izquierda secuela"
    },
    {
      "code" : "S98222S",
      "display" : "S98222S Amputación traumática parcial de dos o más dedos menores del pie izquierdo secuela"
    },
    {
      "code" : "S983",
      "display" : "S983 Amputación traumática de parte media del pie"
    },
    {
      "code" : "S60212D",
      "display" : "S60212D Contusión de muñeca izquierda contacto sucesivo"
    },
    {
      "code" : "S60219D",
      "display" : "S60219D Contusión de muñeca no especificada contacto sucesivo"
    },
    {
      "code" : "S60221D",
      "display" : "S60221D Contusión de mano derecha contacto sucesivo"
    },
    {
      "code" : "S60222D",
      "display" : "S60222D Contusión de mano izquierda contacto sucesivo"
    },
    {
      "code" : "S60229D",
      "display" : "S60229D Contusión de mano no especificada contacto sucesivo"
    },
    {
      "code" : "S60311",
      "display" : "S60311 Abrasión de pulgar derecho"
    },
    {
      "code" : "S60312",
      "display" : "S60312 Abrasión de pulgar izquierdo"
    },
    {
      "code" : "S61213D",
      "display" : "S61213D Desgarro sin cuerpo extraño de dedo medio izquierdo sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61215",
      "display" : "S61215 Desgarro sin cuerpo extraño de dedo anular izquierdo sin daños en la uña"
    },
    {
      "code" : "S61216A",
      "display" : "S61216A Desgarro sin cuerpo extraño de dedo meñique derecho sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61217D",
      "display" : "S61217D Desgarro sin cuerpo extraño de dedo meñique izquierdo sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S62113A",
      "display" : "S62113A Fractura desplazada de hueso piramidal [cuneiforme] de muñeca no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62113S",
      "display" : "S62113S Fractura desplazada de hueso piramidal [cuneiforme] de muñeca no especificada secuela"
    },
    {
      "code" : "S62114G",
      "display" : "S62114G Fractura sin desplazamiento de hueso piramidal [cuneiforme] de muñeca derecha contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S589",
      "display" : "S589 Amputación traumática de antebrazo nivel no especificado"
    },
    {
      "code" : "S58911D",
      "display" : "S58911D Amputación traumática completa de antebrazo derecho nivel no especificado contacto sucesivo"
    },
    {
      "code" : "S58912S",
      "display" : "S58912S Amputación traumática completa de antebrazo izquierdo nivel no especificado secuela"
    },
    {
      "code" : "S58921",
      "display" : "S58921 Amputación traumática parcial de antebrazo derecho nivel no especificado"
    },
    {
      "code" : "S60342S",
      "display" : "S60342S Constricción externa de pulgar izquierdo secuela"
    },
    {
      "code" : "S60349S",
      "display" : "S60349S Constricción externa de pulgar no especificado secuela"
    },
    {
      "code" : "S60351D",
      "display" : "S60351D Cuerpo extraño superficial de pulgar derecho contacto sucesivo"
    },
    {
      "code" : "S60352S",
      "display" : "S60352S Cuerpo extraño superficial de pulgar izquierdo secuela"
    },
    {
      "code" : "S6036",
      "display" : "S6036 Picadura de insecto (no venenoso) en pulgar"
    },
    {
      "code" : "S60361S",
      "display" : "S60361S Picadura de insecto (no venenoso) en pulgar derecho secuela"
    },
    {
      "code" : "S60362S",
      "display" : "S60362S Picadura de insecto (no venenoso) en pulgar izquierdo secuela"
    },
    {
      "code" : "S61223S",
      "display" : "S61223S Desgarro con cuerpo extraño de dedo medio izquierdo sin daños en la uña secuela"
    },
    {
      "code" : "S61225",
      "display" : "S61225 Desgarro con cuerpo extraño de dedo anular izquierdo sin daños en la uña"
    },
    {
      "code" : "S61226A",
      "display" : "S61226A Desgarro con cuerpo extraño de dedo meñique derecho sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61227S",
      "display" : "S61227S Desgarro con cuerpo extraño de dedo meñique izquierdo sin daños en la uña secuela"
    },
    {
      "code" : "S61229",
      "display" : "S61229 Desgarro con cuerpo extraño de dedo de mano no especificado sin daños en la uña"
    },
    {
      "code" : "S62122B",
      "display" : "S62122B Fractura desplazada de semilunar [lunatum] de muñeca izquierda contacto inicial por fractura abierta"
    },
    {
      "code" : "S62123",
      "display" : "S62123 Fractura desplazada de semilunar [lunatum] de muñeca no especificada"
    },
    {
      "code" : "S62123K",
      "display" : "S62123K Fractura desplazada de semilunar [lunatum] de muñeca no especificada contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S59009D",
      "display" : "S59009D Fractura fisaria no especificada de extremo inferior de cúbito de brazo no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S59011A",
      "display" : "S59011A Fractura fisaria tipo I de Salter-Harris de extremo inferior de cúbito del brazo derecho contacto inicial por fractura"
    },
    {
      "code" : "S65199S",
      "display" : "S65199S Otro traumatismo especificado de arteria radial a nivel de muñeca y mano brazo no especificado secuela"
    },
    {
      "code" : "S66318A",
      "display" : "S66318A Distensión de músculo fascia y tendón extensor de otro dedo de la mano a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S6632",
      "display" : "S6632 Desgarro de músculo fascia y tendón extensor de otros dedos de la mano y los no especificados a nivel de muñeca y mano"
    },
    {
      "code" : "S66321A",
      "display" : "S66321A Desgarro de músculo fascia y tendón extensor de dedo índice izquierdo a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S68125A",
      "display" : "S68125A Amputación traumática metacarpofalángica parcial de dedo anular izquierdo contacto inicial"
    },
    {
      "code" : "S68126S",
      "display" : "S68126S Amputación traumática metacarpofalángica parcial de dedo meñique derecho secuela"
    },
    {
      "code" : "S68128",
      "display" : "S68128 Amputación traumática metacarpofalángica parcial de otro dedo de mano"
    },
    {
      "code" : "S68129A",
      "display" : "S68129A Amputación traumática metacarpofalángica parcial de dedo de mano no especificado contacto inicial"
    },
    {
      "code" : "S68411A",
      "display" : "S68411A Amputación traumática completa de mano derecha a nivel de muñeca contacto inicial"
    },
    {
      "code" : "S72034B",
      "display" : "S72034B Fractura mediocervical sin desplazamiento de fémur derecho contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S72034H",
      "display" : "S72034H Fractura mediocervical sin desplazamiento de fémur derecho contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S65291",
      "display" : "S65291 Otro traumatismo especificado de arco palmar superficial de mano derecha"
    },
    {
      "code" : "S65292A",
      "display" : "S65292A Otro traumatismo especificado de arco palmar superficial de mano izquierda contacto inicial"
    },
    {
      "code" : "S65299S",
      "display" : "S65299S Otro traumatismo especificado de arco palmar superficial de mano no especificada secuela"
    },
    {
      "code" : "S65301D",
      "display" : "S65301D Traumatismo no especificado de arco palmar profundo de mano derecha contacto sucesivo"
    },
    {
      "code" : "S65309",
      "display" : "S65309 Traumatismo no especificado de arco palmar profundo de mano no especificada"
    },
    {
      "code" : "S66328D",
      "display" : "S66328D Desgarro de músculo fascia y tendón extensor de otro dedo de la mano a nivel de muñeca y mano contacto sucesivo"
    },
    {
      "code" : "S6639",
      "display" : "S6639 Otro traumatismo de músculo fascia y tendón extensor de otros dedos de la mano y los no especificados a nivel de muñeca y mano"
    },
    {
      "code" : "S68511A",
      "display" : "S68511A Amputación traumática transfalángica completa de pulgar derecho contacto inicial"
    },
    {
      "code" : "S68512D",
      "display" : "S68512D Amputación traumática transfalángica completa de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S6852",
      "display" : "S6852 Amputación traumática transfalángica parcial de pulgar"
    },
    {
      "code" : "S68521S",
      "display" : "S68521S Amputación traumática transfalángica parcial de pulgar derecho secuela"
    },
    {
      "code" : "S68529",
      "display" : "S68529 Amputación traumática transfalángica parcial de pulgar no especificado"
    },
    {
      "code" : "S72036E",
      "display" : "S72036E Fractura mediocervical sin desplazamiento de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S654",
      "display" : "S654 Traumatismo de vaso sanguíneo de pulgar"
    },
    {
      "code" : "S65401A",
      "display" : "S65401A Traumatismo no especificado de vaso sanguíneo de pulgar derecho contacto inicial"
    },
    {
      "code" : "S65402D",
      "display" : "S65402D Traumatismo no especificado de vaso sanguíneo de pulgar izquierdo contacto sucesivo"
    },
    {
      "code" : "S65409S",
      "display" : "S65409S Traumatismo no especificado de vaso sanguíneo de pulgar no especificado secuela"
    },
    {
      "code" : "S65411S",
      "display" : "S65411S Desgarro de vaso sanguíneo de pulgar derecho secuela"
    },
    {
      "code" : "S65419",
      "display" : "S65419 Desgarro de vaso sanguíneo de pulgar no especificado"
    },
    {
      "code" : "S66397S",
      "display" : "S66397S Otro traumatismo de músculo fascia y tendón extensor de dedo meñique izquierdo a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S66399A",
      "display" : "S66399A Otro traumatismo de músculo fascia y tendón extensor de dedo de mano no especificado a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S82865N",
      "display" : "S82865N Fractura de Maisonneuve sin desplazamiento de pierna izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82866B",
      "display" : "S82866B Fractura de Maisonneuve sin desplazamiento de pierna no especificada contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82241J",
      "display" : "S82241J Fractura espiroidea desplazada de diáfisis de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82241S",
      "display" : "S82241S Fractura espiroidea desplazada de diáfisis de tibia derecha secuela"
    },
    {
      "code" : "S82424H",
      "display" : "S82424H Fractura transversal sin desplazamiento de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82424S",
      "display" : "S82424S Fractura transversal sin desplazamiento de diáfisis de peroné derecho secuela"
    },
    {
      "code" : "S8255XB",
      "display" : "S8255XB Fractura sin desplazamiento de maléolo medial de tibia izquierda contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S8255XH",
      "display" : "S8255XH Fractura sin desplazamiento de maléolo medial de tibia izquierda contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82872",
      "display" : "S82872 Fractura desplazada de pilón tibial de tibia izquierda"
    },
    {
      "code" : "S82872D",
      "display" : "S82872D Fractura desplazada de pilón tibial de tibia izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82872K",
      "display" : "S82872K Fractura desplazada de pilón tibial de tibia izquierda contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82243P",
      "display" : "S82243P Fractura espiroidea desplazada de diáfisis de tibia no especificada contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S82426N",
      "display" : "S82426N Fractura transversal sin desplazamiento de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82425B",
      "display" : "S82425B Fractura transversal sin desplazamiento de diáfisis de peroné izquierdo contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S8261XC",
      "display" : "S8261XC Fractura desplazada de maléolo lateral de peroné derecho contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S8261XJ",
      "display" : "S8261XJ Fractura desplazada de maléolo lateral de peroné derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82874C",
      "display" : "S82874C Fractura del pilón tibial sin desplazamiento de tibia derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82874K",
      "display" : "S82874K Fractura del pilón tibial sin desplazamiento de tibia derecha contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82245R",
      "display" : "S82245R Fractura espiroidea sin desplazamiento de diáfisis de tibia izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82432N",
      "display" : "S82432N Fractura oblicua desplazada de diáfisis de peroné izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S82433C",
      "display" : "S82433C Fractura oblicua desplazada de diáfisis de peroné no especificado contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S8263XE",
      "display" : "S8263XE Fractura desplazada de maléolo lateral de peroné no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S8263XM",
      "display" : "S8263XM Fractura desplazada de maléolo lateral de peroné no especificado contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S82876F",
      "display" : "S82876F Fractura del pilón tibial sin desplazamiento de tibia no especificada contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82876P",
      "display" : "S82876P Fractura del pilón tibial sin desplazamiento de tibia no especificada contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S82251M",
      "display" : "S82251M Fractura conminuta desplazada de diáfisis de tibia derecha contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S82252A",
      "display" : "S82252A Fractura conminuta desplazada de diáfisis de tibia izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S98311D",
      "display" : "S98311D Amputación traumática completa de parte media del pie derecho contacto sucesivo"
    },
    {
      "code" : "S98319",
      "display" : "S98319 Amputación traumática completa de parte media de pie no especificado"
    },
    {
      "code" : "S9832",
      "display" : "S9832 Amputación traumática parcial de parte media del pie"
    },
    {
      "code" : "S92241B",
      "display" : "S92241B Fractura desplazada de cuneiforme medial del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S92241S",
      "display" : "S92241S Fractura desplazada de cuneiforme medial del pie derecho secuela"
    },
    {
      "code" : "S92242G",
      "display" : "S92242G Fractura desplazada de cuneiforme medial del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92522P",
      "display" : "S92522P Fractura desplazada de falange media de dedo(s) menor(es) del pie izquierdo contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92523G",
      "display" : "S92523G Fractura desplazada de falange media de dedo(s) menor(es) de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92524D",
      "display" : "S92524D Fractura sin desplazamiento de falange media de dedo(s) menor(es) del pie derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S95009A",
      "display" : "S95009A Traumatismo no especificado de arteria dorsal de pie no especificado contacto inicial"
    },
    {
      "code" : "S95011A",
      "display" : "S95011A Desgarro de arteria dorsal del pie derecho contacto inicial"
    },
    {
      "code" : "S95012D",
      "display" : "S95012D Desgarro de arteria dorsal del pie izquierdo contacto sucesivo"
    },
    {
      "code" : "S95019D",
      "display" : "S95019D Desgarro de arteria dorsal del pie pierna no especificada contacto sucesivo"
    },
    {
      "code" : "S95091D",
      "display" : "S95091D Otro traumatismo especificado de arteria dorsal del pie derecho contacto sucesivo"
    },
    {
      "code" : "S9892",
      "display" : "S9892 Amputación traumática parcial de pie nivel no especificado"
    },
    {
      "code" : "S98921S",
      "display" : "S98921S Amputación traumática parcial del pie derecho nivel no especificado secuela"
    },
    {
      "code" : "S98929",
      "display" : "S98929 Amputación traumática parcial de pie no especificado nivel no especificado"
    },
    {
      "code" : "S990",
      "display" : "S990 Fractura fisaria de calcáneo"
    },
    {
      "code" : "S99001B",
      "display" : "S99001B Fractura fisaria no especificada de calcáneo derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S99001S",
      "display" : "S99001S Fractura fisaria no especificada de calcáneo derecho secuela"
    },
    {
      "code" : "S92246G",
      "display" : "S92246G Fractura sin desplazamiento de cuneiforme medial de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92251B",
      "display" : "S92251B Fractura desplazada de escafoides [navicular] del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S92251S",
      "display" : "S92251S Fractura desplazada de escafoides [navicular] del pie derecho secuela"
    },
    {
      "code" : "S92532",
      "display" : "S92532 Fractura desplazada de falange distal de dedo(s) menor(es) del pie izquierdo"
    },
    {
      "code" : "S92532K",
      "display" : "S92532K Fractura desplazada de falange distal de dedo(s) menor(es) del pie izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S95112",
      "display" : "S95112 Desgarro de arteria plantar del pie izquierdo"
    },
    {
      "code" : "S95119",
      "display" : "S95119 Desgarro de arteria plantar de pie no especificado"
    },
    {
      "code" : "S9519",
      "display" : "S9519 Otro traumatismo especificado de arteria plantar de pie"
    },
    {
      "code" : "S95192",
      "display" : "S95192 Otro traumatismo especificado de arteria plantar del pie izquierdo"
    },
    {
      "code" : "S95199",
      "display" : "S95199 Otro traumatismo especificado de arteria plantar de pie no especificado"
    },
    {
      "code" : "S9520",
      "display" : "S9520 Traumatismo no especificado de vena dorsal de pie"
    },
    {
      "code" : "S95201S",
      "display" : "S95201S Traumatismo no especificado de vena dorsal del pie derecho secuela"
    },
    {
      "code" : "S99012B",
      "display" : "S99012B Fractura fisaria tipo I de Salter-Harris de calcáneo izquierdo contacto inicial por fractura abierta"
    },
    {
      "code" : "S99019",
      "display" : "S99019 Fractura fisaria tipo I de Salter-Harris de calcáneo no especificado"
    },
    {
      "code" : "S60399S",
      "display" : "S60399S Otros traumatismos superficiales de pulgar no especificado secuela"
    },
    {
      "code" : "S60410D",
      "display" : "S60410D Abrasión de dedo índice derecho contacto sucesivo"
    },
    {
      "code" : "S60411D",
      "display" : "S60411D Abrasión de dedo índice izquierdo contacto sucesivo"
    },
    {
      "code" : "S60412S",
      "display" : "S60412S Abrasión de dedo medio derecho secuela"
    },
    {
      "code" : "S60413S",
      "display" : "S60413S Abrasión de dedo medio izquierdo secuela"
    },
    {
      "code" : "S60414S",
      "display" : "S60414S Abrasión de dedo anular derecho secuela"
    },
    {
      "code" : "S60415S",
      "display" : "S60415S Abrasión de dedo anular izquierdo secuela"
    },
    {
      "code" : "S60416S",
      "display" : "S60416S Abrasión de dedo meñique derecho secuela"
    },
    {
      "code" : "S61235D",
      "display" : "S61235D Herida punzante sin cuerpo extraño de dedo anular izquierdo sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61237",
      "display" : "S61237 Herida punzante sin cuerpo extraño de dedo meñique izquierdo sin daños en la uña"
    },
    {
      "code" : "S61238A",
      "display" : "S61238A Herida punzante sin cuerpo extraño de otro dedo de la mano sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61239S",
      "display" : "S61239S Herida punzante sin cuerpo extraño de dedo de mano no especificado sin daños en la uña secuela"
    },
    {
      "code" : "S62126S",
      "display" : "S62126S Fractura sin desplazamiento de semilunar [lunatum] de muñeca no especificada secuela"
    },
    {
      "code" : "S62131D",
      "display" : "S62131D Fractura desplazada de hueso grande [capitatum] de muñeca derecha contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S62132A",
      "display" : "S62132A Fractura desplazada de hueso grande [capitatum] de muñeca izquierda contacto inicial por fractura cerrada"
    },
    {
      "code" : "S59022P",
      "display" : "S59022P Fractura fisaria tipo II de Salter-Harris de extremo inferior de cúbito del brazo izquierdo contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S59011P",
      "display" : "S59011P Fractura fisaria tipo I de Salter-Harris de extremo inferior de cúbito del brazo derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S60424A",
      "display" : "S60424A Ampolla (no térmica) de dedo anular derecho contacto inicial"
    },
    {
      "code" : "S60425D",
      "display" : "S60425D Ampolla (no térmica) de dedo anular izquierdo contacto sucesivo"
    },
    {
      "code" : "S60426S",
      "display" : "S60426S Ampolla (no térmica) de dedo meñique derecho secuela"
    },
    {
      "code" : "S60427S",
      "display" : "S60427S Ampolla (no térmica) de dedo meñique izquierdo secuela"
    },
    {
      "code" : "S60429",
      "display" : "S60429 Ampolla (no térmica) de dedo de mano no especificado"
    },
    {
      "code" : "S6044",
      "display" : "S6044 Constricción externa de dedos de la mano"
    },
    {
      "code" : "S60440S",
      "display" : "S60440S Constricción externa de dedo índice derecho secuela"
    },
    {
      "code" : "S61247",
      "display" : "S61247 Herida punzante con cuerpo extraño de dedo meñique izquierdo sin daños en la uña"
    },
    {
      "code" : "S61248D",
      "display" : "S61248D Herida punzante con cuerpo extraño de otro dedo de la mano sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61249S",
      "display" : "S61249S Herida punzante con cuerpo extraño de dedo de mano no especificado sin daños en la uña secuela"
    },
    {
      "code" : "S61251",
      "display" : "S61251 Mordedura abierta de dedo índice izquierdo sin daños en la uña"
    },
    {
      "code" : "S62136G",
      "display" : "S62136G Fractura sin desplazamiento de hueso grande [capitatum] de muñeca no especificada contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S62141B",
      "display" : "S62141B Fractura desplazada de cuerpo de hueso ganchoso [unciforme] de muñeca derecha contacto inicial por fractura abierta"
    },
    {
      "code" : "S59041P",
      "display" : "S59041P Fractura fisaria tipo IV de Salter-Harris de extremo inferior de cúbito del brazo derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S60447S",
      "display" : "S60447S Constricción externa de dedo meñique izquierdo secuela"
    },
    {
      "code" : "S60449",
      "display" : "S60449 Constricción externa de dedo de mano no especificado"
    },
    {
      "code" : "S6045",
      "display" : "S6045 Cuerpo extraño superficial de dedos de la mano"
    },
    {
      "code" : "S68616",
      "display" : "S68616 Amputación traumática transfalángica completa de dedo meñique derecho"
    },
    {
      "code" : "S68617A",
      "display" : "S68617A Amputación traumática transfalángica completa de dedo meñique izquierdo contacto inicial"
    },
    {
      "code" : "S68618D",
      "display" : "S68618D Amputación traumática transfalángica completa de otro dedo de mano contacto sucesivo"
    },
    {
      "code" : "S6862",
      "display" : "S6862 Amputación traumática transfalángica parcial de otro(s) dedo(s) de mano y los no especificados"
    },
    {
      "code" : "S72042A",
      "display" : "S72042A Fractura desplazada de base del cuello de fémur izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S72042G",
      "display" : "S72042G Fractura desplazada de base del cuello de fémur izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S72042P",
      "display" : "S72042P Fractura desplazada de base del cuello de fémur izquierdo contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S65503",
      "display" : "S65503 Traumatismo no especificado de vaso sanguíneo de dedo medio izquierdo"
    },
    {
      "code" : "S65504A",
      "display" : "S65504A Traumatismo no especificado de vaso sanguíneo de dedo anular derecho contacto inicial"
    },
    {
      "code" : "S65505D",
      "display" : "S65505D Traumatismo no especificado de vaso sanguíneo de dedo anular izquierdo contacto sucesivo"
    },
    {
      "code" : "S65507",
      "display" : "S65507 Traumatismo no especificado de vaso sanguíneo de dedo meñique izquierdo"
    },
    {
      "code" : "S66422A",
      "display" : "S66422A Desgarro de músculo fascia y tendón intrínseco de pulgar izquierdo a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66429S",
      "display" : "S66429S Desgarro de músculo fascia y tendón intrínseco de pulgar a nivel de muñeca y mano no especificadas secuela"
    },
    {
      "code" : "S68627D",
      "display" : "S68627D Amputación traumática transfalángica parcial de dedo meñique izquierdo contacto sucesivo"
    },
    {
      "code" : "S68629",
      "display" : "S68629 Amputación traumática transfalángica parcial de dedo de mano no especificado"
    },
    {
      "code" : "S6871",
      "display" : "S6871 Amputación traumática transmetacarpiana completa de mano"
    },
    {
      "code" : "S68711S",
      "display" : "S68711S Amputación traumática transmetacarpiana completa de mano derecha secuela"
    },
    {
      "code" : "S68719",
      "display" : "S68719 Amputación traumática transmetacarpiana completa de mano no especificada"
    },
    {
      "code" : "S72044E",
      "display" : "S72044E Fractura sin desplazamiento de base del cuello de fémur derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S72044N",
      "display" : "S72044N Fractura sin desplazamiento de base del cuello de fémur derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con fracaso de consolidación"
    },
    {
      "code" : "S65514",
      "display" : "S65514 Desgarro de vaso sanguíneo de dedo anular derecho"
    },
    {
      "code" : "S65515",
      "display" : "S65515 Desgarro de vaso sanguíneo de dedo anular izquierdo"
    },
    {
      "code" : "S65516A",
      "display" : "S65516A Desgarro de vaso sanguíneo de dedo meñique derecho contacto inicial"
    },
    {
      "code" : "S65517A",
      "display" : "S65517A Desgarro de vaso sanguíneo de dedo meñique izquierdo contacto inicial"
    },
    {
      "code" : "S65518D",
      "display" : "S65518D Desgarro de vaso sanguíneo de otro dedo de la mano contacto sucesivo"
    },
    {
      "code" : "S65519S",
      "display" : "S65519S Desgarro de vaso sanguíneo de dedo de mano no especificado secuela"
    },
    {
      "code" : "S66504",
      "display" : "S66504 Traumatismo no especificado de músculo fascia y tendón intrínseco de dedo anular derecho a nivel de muñeca y mano"
    },
    {
      "code" : "S66505D",
      "display" : "S66505D Traumatismo no especificado de músculo fascia y tendón intrínseco de dedo anular izquierdo a nivel de muñeca y mano contacto sucesivo"
    },
    {
      "code" : "S6981XA",
      "display" : "S6981XA Otros traumatismos especificados de muñeca mano y dedo(s) de la mano derecha contacto inicial"
    },
    {
      "code" : "S6982XD",
      "display" : "S6982XD Otros traumatismos especificados de muñeca mano y dedo(s) de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "S6990XA",
      "display" : "S6990XA Traumatismo no especificado de muñeca mano y dedo(s) de mano no especificada contacto inicial"
    },
    {
      "code" : "S6991XD",
      "display" : "S6991XD Traumatismo no especificado de muñeca mano y dedo(s) de la mano derecha contacto sucesivo"
    },
    {
      "code" : "S82434P",
      "display" : "S82434P Fractura oblicua sin desplazamiento de diáfisis de peroné derecho contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S82435C",
      "display" : "S82435C Fractura oblicua sin desplazamiento de diáfisis de peroné izquierdo contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S8265XG",
      "display" : "S8265XG Fractura sin desplazamiento de maléolo lateral de peroné izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82892J",
      "display" : "S82892J Otra fractura de pierna izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82892R",
      "display" : "S82892R Otra fractura de pierna izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82899E",
      "display" : "S82899E Otra fractura de pierna no especificada contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82253S",
      "display" : "S82253S Fractura conminuta desplazada de diáfisis de tibia no especificada secuela"
    },
    {
      "code" : "S82254D",
      "display" : "S82254D Fractura conminuta sin desplazamiento de diáfisis de tibia derecha contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82436R",
      "display" : "S82436R Fractura oblicua sin desplazamiento de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82441E",
      "display" : "S82441E Fractura espiroidea desplazada de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S8281",
      "display" : "S8281 Fractura en rodete de extremo superior de peroné"
    },
    {
      "code" : "S82811G",
      "display" : "S82811G Fractura en rodete de extremo superior de peroné derecho contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82812G",
      "display" : "S82812G Fractura en rodete de extremo superior de peroné izquierdo contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S8291",
      "display" : "S8291 Fractura no especificada de pierna derecha"
    },
    {
      "code" : "S8291XC",
      "display" : "S8291XC Fractura no especificada de pierna derecha contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S8291XJ",
      "display" : "S8291XJ Fractura no especificada de pierna derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con retardo de consolidación"
    },
    {
      "code" : "S82256B",
      "display" : "S82256B Fractura conminuta sin desplazamiento de diáfisis de tibia no especificada contacto inicial por fractura abierta tipo I II o NEOM"
    },
    {
      "code" : "S82443A",
      "display" : "S82443A Fractura espiroidea desplazada de diáfisis de peroné no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82443G",
      "display" : "S82443G Fractura espiroidea desplazada de diáfisis de peroné no especificado contacto sucesivo por fractura cerrada con retardo de consolidación"
    },
    {
      "code" : "S82829D",
      "display" : "S82829D Fractura en rodete de extremo inferior de peroné no especificado contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82831A",
      "display" : "S82831A Otra fractura de extremos superior e inferior de peroné derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S82831F",
      "display" : "S82831F Otra fractura de extremos superior e inferior de peroné derecho contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S83001D",
      "display" : "S83001D Subluxación no especificada de rótula derecha contacto sucesivo"
    },
    {
      "code" : "S83002D",
      "display" : "S83002D Subluxación no especificada de rótula izquierda contacto sucesivo"
    },
    {
      "code" : "S83003S",
      "display" : "S83003S Subluxación no especificada de rótula no especificada secuela"
    },
    {
      "code" : "S83005",
      "display" : "S83005 Luxación no especificada de rótula izquierda"
    },
    {
      "code" : "S83006",
      "display" : "S83006 Luxación no especificada de rótula no especificada"
    },
    {
      "code" : "S82261R",
      "display" : "S82261R Fractura segmentaria desplazada de diáfisis de tibia derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S82262F",
      "display" : "S82262F Fractura segmentaria desplazada de diáfisis de tibia izquierda contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82445D",
      "display" : "S82445D Fractura espiroidea sin desplazamiento de diáfisis de peroné izquierdo contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S99019G",
      "display" : "S99019G Fractura fisaria tipo I de Salter-Harris de calcáneo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92255S",
      "display" : "S92255S Fractura sin desplazamiento de escafoides [navicular] del pie izquierdo secuela"
    },
    {
      "code" : "S92256G",
      "display" : "S92256G Fractura sin desplazamiento de escafoides [navicular] de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92301A",
      "display" : "S92301A Fractura de metatarsiano(s) no especificado del pie derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92536A",
      "display" : "S92536A Fractura sin desplazamiento de falange distal de dedo(s) menor(es) de pie no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S9259",
      "display" : "S9259 Otra fractura de dedo(s) menor(es) de pie"
    },
    {
      "code" : "S92591D",
      "display" : "S92591D Otra fractura de dedo(s) menor(es) del pie derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S95292",
      "display" : "S95292 Otro traumatismo especificado de vena dorsal del pie izquierdo"
    },
    {
      "code" : "S95299A",
      "display" : "S95299A Otro traumatismo especificado de vena dorsal de pie no especificado contacto inicial"
    },
    {
      "code" : "S95801",
      "display" : "S95801 Traumatismo no especificado de otros vasos sanguíneos a nivel de tobillo y pie pierna derecha"
    },
    {
      "code" : "S95802D",
      "display" : "S95802D Traumatismo no especificado de otros vasos sanguíneos a nivel de tobillo y pie pierna izquierda contacto sucesivo"
    },
    {
      "code" : "S9581",
      "display" : "S9581 Desgarro de otros vasos sanguíneos a nivel de tobillo y pie"
    },
    {
      "code" : "S99031A",
      "display" : "S99031A Fractura fisaria tipo III de Salter-Harris de calcáneo derecho contacto inicial por fractura cerrada"
    },
    {
      "code" : "S99031S",
      "display" : "S99031S Fractura fisaria tipo III de Salter-Harris de calcáneo derecho secuela"
    },
    {
      "code" : "S99032G",
      "display" : "S99032G Fractura fisaria tipo III de Salter-Harris de calcáneo izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92311B",
      "display" : "S92311B Fractura desplazada de primer metatarsiano del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S92312",
      "display" : "S92312 Fractura desplazada de primer metatarsiano del pie izquierdo"
    },
    {
      "code" : "S92312G",
      "display" : "S92312G Fractura desplazada de primer metatarsiano del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92313D",
      "display" : "S92313D Fractura desplazada de primer metatarsiano de pie no especificado contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92811P",
      "display" : "S92811P Otra fractura del pie derecho contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92812G",
      "display" : "S92812G Otra fractura del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92819A",
      "display" : "S92819A Otra fractura de pie no especificado contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92819P",
      "display" : "S92819P Otra fractura de pie no especificado contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S92901B",
      "display" : "S92901B Fractura no especificada del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S95901A",
      "display" : "S95901A Traumatismo no especificado de vaso sanguíneo no especificado a nivel de tobillo y pie pierna derecha contacto inicial"
    },
    {
      "code" : "S95909",
      "display" : "S95909 Traumatismo no especificado de vaso sanguíneo no especificado a nivel de tobillo y pie pierna no especificada"
    },
    {
      "code" : "S95911A",
      "display" : "S95911A Desgarro de vaso sanguíneo no especificado a nivel de tobillo y pie pierna derecha contacto inicial"
    },
    {
      "code" : "S99049K",
      "display" : "S99049K Fractura fisaria tipo IV de Salter-Harris de calcáneo no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S99091D",
      "display" : "S99091D Otra fractura fisaria de calcáneo derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S99092A",
      "display" : "S99092A Otra fractura fisaria de calcáneo izquierdo contacto inicial por fractura cerrada"
    },
    {
      "code" : "S92316G",
      "display" : "S92316G Fractura sin desplazamiento de primer metatarsiano de pie no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S60450S",
      "display" : "S60450S Cuerpo extraño superficial de dedo índice derecho secuela"
    },
    {
      "code" : "S60451S",
      "display" : "S60451S Cuerpo extraño superficial de dedo índice izquierdo secuela"
    },
    {
      "code" : "S60453",
      "display" : "S60453 Cuerpo extraño superficial de dedo medio izquierdo"
    },
    {
      "code" : "S60454",
      "display" : "S60454 Cuerpo extraño superficial de dedo anular derecho"
    },
    {
      "code" : "S60455",
      "display" : "S60455 Cuerpo extraño superficial de dedo anular izquierdo"
    },
    {
      "code" : "S61258A",
      "display" : "S61258A Mordedura abierta de otro dedo de mano sin daños en la uña contacto inicial"
    },
    {
      "code" : "S61259D",
      "display" : "S61259D Mordedura abierta de dedo de mano no especificado sin daños en la uña contacto sucesivo"
    },
    {
      "code" : "S61300",
      "display" : "S61300 Herida abierta no especificada de dedo índice derecho con daños en la uña"
    },
    {
      "code" : "S61301A",
      "display" : "S61301A Herida abierta no especificada de dedo índice izquierdo con daños en la uña contacto inicial"
    },
    {
      "code" : "S61302S",
      "display" : "S61302S Herida abierta no especificada de dedo medio derecho con daños en la uña secuela"
    },
    {
      "code" : "S62145",
      "display" : "S62145 Fractura sin desplazamiento de cuerpo de hueso ganchoso [unciforme] de muñeca izquierda"
    },
    {
      "code" : "S62145P",
      "display" : "S62145P Fractura sin desplazamiento de cuerpo de hueso ganchoso [unciforme] de muñeca izquierda contacto sucesivo por fractura con unión defectuosa"
    },
    {
      "code" : "S59099G",
      "display" : "S59099G Otra fractura fisaria de extremo inferior de cúbito de brazo no especificado contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S59101A",
      "display" : "S59101A Fractura fisaria no especificada de extremo superior de radio del brazo derecho contacto inicial por fractura"
    },
    {
      "code" : "S60462A",
      "display" : "S60462A Picadura de insecto (no venenoso) en dedo medio derecho contacto inicial"
    },
    {
      "code" : "S60463D",
      "display" : "S60463D Picadura de insecto (no venenoso) en dedo medio izquierdo contacto sucesivo"
    },
    {
      "code" : "S60464S",
      "display" : "S60464S Picadura de insecto (no venenoso) en dedo anular derecho secuela"
    },
    {
      "code" : "S60466",
      "display" : "S60466 Picadura de insecto (no venenoso) en dedo meñique derecho"
    },
    {
      "code" : "S60467",
      "display" : "S60467 Picadura de insecto (no venenoso) en dedo meñique izquierdo"
    },
    {
      "code" : "S60468A",
      "display" : "S60468A Picadura de insecto (no venenoso) en otro dedo de mano contacto inicial"
    },
    {
      "code" : "S6131",
      "display" : "S6131 Desgarro sin cuerpo extraño de dedo de mano con daños en la uña"
    },
    {
      "code" : "S61311",
      "display" : "S61311 Desgarro sin cuerpo extraño de dedo índice izquierdo con daños en la uña"
    },
    {
      "code" : "S61312A",
      "display" : "S61312A Desgarro sin cuerpo extraño de dedo medio derecho con daños en la uña contacto inicial"
    },
    {
      "code" : "S61313D",
      "display" : "S61313D Desgarro sin cuerpo extraño de dedo medio izquierdo con daños en la uña contacto sucesivo"
    },
    {
      "code" : "S62153A",
      "display" : "S62153A Fractura desplazada de apófisis unciforme de hueso ganchoso [unciforme] de muñeca no especificada contacto inicial por fractura cerrada"
    },
    {
      "code" : "S62154",
      "display" : "S62154 Fractura sin desplazamiento de apófisis unciforme de hueso ganchoso [unciforme] de muñeca derecha"
    },
    {
      "code" : "S59112K",
      "display" : "S59112K Fractura fisaria tipo I de Salter-Harris de extremo superior de radio del brazo izquierdo contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S59119K",
      "display" : "S59119K Fractura fisaria tipo I de Salter-Harris de extremo superior de radio de brazo no especificado contacto sucesivo por fractura con fracaso de consolidación"
    },
    {
      "code" : "S60475A",
      "display" : "S60475A Otra mordedura superficial de dedo anular izquierdo contacto inicial"
    },
    {
      "code" : "S60476A",
      "display" : "S60476A Otra mordedura superficial de dedo meñique derecho contacto inicial"
    },
    {
      "code" : "S60477D",
      "display" : "S60477D Otra mordedura superficial de dedo meñique izquierdo contacto sucesivo"
    },
    {
      "code" : "S60478S",
      "display" : "S60478S Otra mordedura superficial de otro dedo de mano secuela"
    },
    {
      "code" : "S605",
      "display" : "S605 Otros traumatismos superficiales de mano"
    },
    {
      "code" : "S60511A",
      "display" : "S60511A Abrasión de mano derecha contacto inicial"
    },
    {
      "code" : "S6992XD",
      "display" : "S6992XD Traumatismo no especificado de muñeca mano y dedo(s) de la mano izquierda contacto sucesivo"
    },
    {
      "code" : "S72046P",
      "display" : "S72046P Fractura sin desplazamiento de base del cuello de fémur no especificado contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S72045",
      "display" : "S72045 Fractura sin desplazamiento de base del cuello de fémur izquierdo"
    },
    {
      "code" : "S65597D",
      "display" : "S65597D Otro traumatismo especificado de vaso sanguíneo de dedo meñique izquierdo contacto sucesivo"
    },
    {
      "code" : "S65599",
      "display" : "S65599 Otro traumatismo especificada de vaso sanguíneo de dedo de mano no especificado"
    },
    {
      "code" : "S6580",
      "display" : "S6580 Traumatismo no especificado de otros vasos sanguíneos a nivel de muñeca y mano"
    },
    {
      "code" : "S65802",
      "display" : "S65802 Traumatismo no especificado de otros vasos sanguíneos a nivel de muñeca y mano brazo izquierdo"
    },
    {
      "code" : "S66512A",
      "display" : "S66512A Distensión de músculo fascia y tendón intrínseco de dedo medio derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66513S",
      "display" : "S66513S Distensión de músculo fascia y tendón intrínseco de dedo medio izquierdo a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S7011XD",
      "display" : "S7011XD Contusión de muslo derecho contacto sucesivo"
    },
    {
      "code" : "S7012XA",
      "display" : "S7012XA Contusión de muslo izquierdo contacto inicial"
    },
    {
      "code" : "S7021",
      "display" : "S7021 Abrasión de cadera"
    },
    {
      "code" : "S70211D",
      "display" : "S70211D Abrasión de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S70212D",
      "display" : "S70212D Abrasión de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S70219S",
      "display" : "S70219S Abrasión de cadera no especificada secuela"
    },
    {
      "code" : "S70221D",
      "display" : "S70221D Ampolla (no térmica) de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S70222D",
      "display" : "S70222D Ampolla (no térmica) de cadera izquierda contacto sucesivo"
    },
    {
      "code" : "S70229S",
      "display" : "S70229S Ampolla (no térmica) de cadera no especificada secuela"
    },
    {
      "code" : "S70241D",
      "display" : "S70241D Constricción externa de cadera derecha contacto sucesivo"
    },
    {
      "code" : "S72052H",
      "display" : "S72052H Fractura no especificada de cabeza de fémur izquierdo contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S72052R",
      "display" : "S72052R Fractura no especificada de cabeza de fémur izquierdo contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S72059E",
      "display" : "S72059E Fractura no especificada de cabeza de fémur no especificado contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S65899",
      "display" : "S65899 Otro traumatismo especificado de otros vasos sanguíneos a nivel de muñeca y mano brazo no especificado"
    },
    {
      "code" : "S65901",
      "display" : "S65901 Traumatismo no especificado de vaso sanguíneo no especificado a nivel de muñeca y mano brazo derecho"
    },
    {
      "code" : "S65902D",
      "display" : "S65902D Traumatismo no especificado de vaso sanguíneo no especificado a nivel de muñeca y mano brazo izquierdo contacto sucesivo"
    },
    {
      "code" : "S66522A",
      "display" : "S66522A Desgarro de músculo fascia y tendón intrínseco de dedo medio derecho a nivel de muñeca y mano contacto inicial"
    },
    {
      "code" : "S66523S",
      "display" : "S66523S Desgarro de músculo fascia y tendón intrínseco de dedo medio izquierdo a nivel de muñeca y mano secuela"
    },
    {
      "code" : "S70261S",
      "display" : "S70261S Picadura de insecto (no venenoso) en cadera derecha secuela"
    },
    {
      "code" : "S70241S",
      "display" : "S70241S Constricción externa de cadera derecha secuela"
    },
    {
      "code" : "S70269S",
      "display" : "S70269S Picadura de insecto (no venenoso) en cadera no especificada secuela"
    },
    {
      "code" : "S70271S",
      "display" : "S70271S Otra mordedura superficial de cadera de cadera derecha secuela"
    },
    {
      "code" : "S70279",
      "display" : "S70279 Otra mordedura superficial de cadera no especificada"
    },
    {
      "code" : "S703",
      "display" : "S703 Otros traumatismos superficiales de muslo"
    },
    {
      "code" : "S70311D",
      "display" : "S70311D Abrasión de muslo derecho contacto sucesivo"
    },
    {
      "code" : "S82839H",
      "display" : "S82839H Otra fractura de extremos superior e inferior de peroné no especificado contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S83016S",
      "display" : "S83016S Luxación lateral de rótula no especificada secuela"
    },
    {
      "code" : "S83091D",
      "display" : "S83091D Otro tipo de subluxación de rótula derecha contacto sucesivo"
    },
    {
      "code" : "S83092S",
      "display" : "S83092S Otro tipo de subluxación de rótula izquierda secuela"
    },
    {
      "code" : "S83093S",
      "display" : "S83093S Otro tipo de subluxación de rótula no especificada secuela"
    },
    {
      "code" : "S83094S",
      "display" : "S83094S Otro tipo de luxación de rótula derecha secuela"
    },
    {
      "code" : "S83095S",
      "display" : "S83095S Otro tipo de luxación de rótula izquierda secuela"
    },
    {
      "code" : "S83096S",
      "display" : "S83096S Otro tipo de luxación de rótula no especificada secuela"
    },
    {
      "code" : "S83101D",
      "display" : "S83101D Subluxación no especificada de rodilla derecha contacto sucesivo"
    },
    {
      "code" : "S82264H",
      "display" : "S82264H Fractura segmentaria sin desplazamiento de diáfisis de tibia derecha contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82451",
      "display" : "S82451 Fractura conminuta desplazada de diáfisis de peroné derecho"
    },
    {
      "code" : "S82451E",
      "display" : "S82451E Fractura conminuta desplazada de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo I o II con curas rutinarias"
    },
    {
      "code" : "S82451M",
      "display" : "S82451M Fractura conminuta desplazada de diáfisis de peroné derecho contacto sucesivo por fractura abierta tipo I o II con fracaso de consolidación"
    },
    {
      "code" : "S82842D",
      "display" : "S82842D Fractura bimaleolar desplazada de pierna izquierda contacto sucesivo por fractura cerrada con curas rutinarias"
    },
    {
      "code" : "S82842K",
      "display" : "S82842K Fractura bimaleolar desplazada de pierna izquierda contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S83112A",
      "display" : "S83112A Subluxación anterior de extremo proximal de tibia de rodilla izquierda contacto inicial"
    },
    {
      "code" : "S83113D",
      "display" : "S83113D Subluxación anterior de extremo proximal de tibia de rodilla no especificada contacto sucesivo"
    },
    {
      "code" : "S83115",
      "display" : "S83115 Luxación anterior de extremo proximal de tibia de rodilla izquierda"
    },
    {
      "code" : "S83116A",
      "display" : "S83116A Luxación anterior de extremo proximal de tibia de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S83121A",
      "display" : "S83121A Subluxación posterior de extremo proximal de tibia de rodilla derecha contacto inicial"
    },
    {
      "code" : "S82266C",
      "display" : "S82266C Fractura segmentaria sin desplazamiento de diáfisis de tibia no especificada contacto inicial por fractura abierta tipo IIIA IIIB o IIIC"
    },
    {
      "code" : "S82266K",
      "display" : "S82266K Fractura segmentaria sin desplazamiento de diáfisis de tibia no especificada contacto sucesivo por fractura cerrada con fracaso de consolidación"
    },
    {
      "code" : "S82453F",
      "display" : "S82453F Fractura conminuta desplazada de diáfisis de peroné no especificado contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con curas rutinarias"
    },
    {
      "code" : "S82453P",
      "display" : "S82453P Fractura conminuta desplazada de diáfisis de peroné no especificado contacto sucesivo por fractura cerrada con unión defectuosa"
    },
    {
      "code" : "S82844H",
      "display" : "S82844H Fractura bimaleolar sin desplazamiento de pierna derecha contacto sucesivo por fractura abierta tipo I o II con retardo de consolidación"
    },
    {
      "code" : "S82844R",
      "display" : "S82844R Fractura bimaleolar sin desplazamiento de pierna derecha contacto sucesivo por fractura abierta tipo IIIA IIIB o IIIC con unión defectuosa"
    },
    {
      "code" : "S83133A",
      "display" : "S83133A Subluxación medial de extremo proximal de tibia de rodilla no especificada contacto inicial"
    },
    {
      "code" : "S83134S",
      "display" : "S83134S Luxación medial de extremo proximal de tibia de rodilla derecha secuela"
    },
    {
      "code" : "S83136",
      "display" : "S83136 Luxación medial de extremo proximal de tibia de rodilla no especificada"
    },
    {
      "code" : "S8314",
      "display" : "S8314 Subluxación y luxación lateral de extremo proximal de tibia"
    },
    {
      "code" : "S83141S",
      "display" : "S83141S Subluxación lateral de extremo proximal de tibia de rodilla derecha secuela"
    },
    {
      "code" : "S92321B",
      "display" : "S92321B Fractura desplazada de segundo metatarsiano del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S92322",
      "display" : "S92322 Fractura desplazada de segundo metatarsiano del pie izquierdo"
    },
    {
      "code" : "S92322G",
      "display" : "S92322G Fractura desplazada de segundo metatarsiano del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92911S",
      "display" : "S92911S Fractura no especificada de dedo(s) del pie derecho secuela"
    },
    {
      "code" : "S92912G",
      "display" : "S92912G Fractura no especificada de dedo(s) del pie izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S92919B",
      "display" : "S92919B Fractura no especificada de dedo(s) de pie no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S93",
      "display" : "S93 Luxación y esguince de articulaciones y ligamentos a nivel de tobillo pie y dedo(s) del pie"
    },
    {
      "code" : "S96001",
      "display" : "S96001 Traumatismo no especificado de músculo y tendón flexor largo de dedo del pie a nivel de tobillo y pie pie derecho"
    },
    {
      "code" : "S96002S",
      "display" : "S96002S Traumatismo no especificado de músculo y tendón flexor largo de dedo del pie a nivel de tobillo y pie pie izquierdo secuela"
    },
    {
      "code" : "S96011",
      "display" : "S96011 Distensión de músculo y tendón flexor largo de dedo del pie a nivel de tobillo y pie pie derecho"
    },
    {
      "code" : "S99102G",
      "display" : "S99102G Fractura fisaria no especificada de metatarso izquierdo contacto sucesivo por fractura con retardo de consolidación"
    },
    {
      "code" : "S99109B",
      "display" : "S99109B Fractura fisaria no especificada de metatarso no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S9911",
      "display" : "S9911 Fractura fisaria tipo I de Salter-Harris de metatarso"
    },
    {
      "code" : "S99111D",
      "display" : "S99111D Fractura fisaria tipo I de Salter-Harris de metatarso derecho contacto sucesivo por fractura con curas rutinarias"
    },
    {
      "code" : "S92326B",
      "display" : "S92326B Fractura sin desplazamiento de segundo metatarsiano de pie no especificado contacto inicial por fractura abierta"
    },
    {
      "code" : "S9233",
      "display" : "S9233 Fractura de tercer metatarsiano"
    },
    {
      "code" : "S92331B",
      "display" : "S92331B Fractura desplazada de tercer metatarsiano del pie derecho contacto inicial por fractura abierta"
    },
    {
      "code" : "S9306X",
      "display" : "S9306X Luxación de articulación de tobillo no especificado"
    },
    {
      "code" : "S9310",
      "display" : "S9310 Subluxación y luxación no especificada de dedo de pie"
    },
    {
      "code" : "S93101S",
      "display" : "S93101S Subluxación no especificada de dedo(s) del pie derecho secuela"
    },
    {
      "code" : "S93103",
      "display" : "S93103 Subluxación no especificada de dedo(s) de pie no especificado"
    },
    {
      "code" : "S93104",
      "display" : "S93104 Luxación no especificada de dedo(s) del pie derecho"
    },
    {
      "code" : "S93105A",
      "display" : "S93105A Luxación no especificada de dedo(s) del pie izquierdo contacto inicial"
    },
    {
      "code" : "S93106D",
      "display" : "S93106D Luxación no especificada de dedo(s) de pie no especificado contacto sucesivo"
    },
    {
      "code" : "T22122",
      "display" : "T22122 Quemadura de primer grado de codo izquierdo"
    },
    {
      "code" : "T22129",
      "display" : "T22129 Quemadura de primer grado de codo no especificado"
    },
    {
      "code" : "T2213",
      "display" : "T2213 Quemadura de primer grado de parte superior del brazo"
    },
    {
      "code" : "T22131S",
      "display" : "T22131S Quemadura de primer grado de parte superior del brazo derecho secuela"
    },
    {
      "code" : "T22139",
      "display" : "T22139 Quemadura de primer grado de parte superior de brazo no especificado"
    },
    {
      "code" : "T22141",
      "display" : "T22141 Quemadura de primer grado de axila derecha"
    },
    {
      "code" : "T23031D",
      "display" : "T23031D Quemadura de grado no especificado de múltiples dedos de la mano derecha (uñas) sin incluir el pulgar contacto sucesivo"
    },
    {
      "code" : "T23039",
      "display" : "T23039 Quemadura de grado no especificado de múltiples dedos (uñas) de mano sin incluir el pulgar no especificado"
    },
    {
      "code" : "T23041",
      "display" : "T23041 Quemadura de grado no especificado de múltiples dedos de la mano derecha (uñas) incluido el pulgar"
    },
    {
      "code" : "T23749",
      "display" : "T23749 Corrosión de tercer grado de múltiples dedos (uñas) no especificados de mano incluido el pulgar"
    },
    {
      "code" : "D818",
      "display" : "D818 Otras inmunodeficiencias combinadas"
    },
    {
      "code" : "D8181",
      "display" : "D8181 Déficit de carboxilasa biotina-dependiente"
    },
    {
      "code" : "D81810",
      "display" : "D81810 Déficit de biotinidasa"
    },
    {
      "code" : "D81818",
      "display" : "D81818 Otros déficits de carboxilasa biotina-dependiente"
    },
    {
      "code" : "D81819",
      "display" : "D81819 Déficit de carboxilasa biotina-dependiente no especificado"
    },
    {
      "code" : "D8182",
      "display" : "D8182 Síndrome de delta 3-quinasa fosfoinositida activada [APDS]"
    },
    {
      "code" : "D8189",
      "display" : "D8189 Otras inmunodeficiencias combinadas"
    },
    {
      "code" : "D819",
      "display" : "D819 Inmunodeficiencia combinada no especificada"
    },
    {
      "code" : "D82",
      "display" : "D82 Inmunodeficiencia asociada con otros defectos importantes"
    },
    {
      "code" : "D820",
      "display" : "D820 Síndrome de Wiskott-Aldrich"
    },
    {
      "code" : "D821",
      "display" : "D821 Síndrome de Di George"
    },
    {
      "code" : "D822",
      "display" : "D822 Inmunodeficiencia con enanismo micromélico [miembros cortos]"
    },
    {
      "code" : "D823",
      "display" : "D823 Inmunodeficiencia secundaria a respuesta defectuosa hereditaria contra el virus de Epstein y Barr"
    },
    {
      "code" : "D824",
      "display" : "D824 Síndrome de hiperinmunoglobulinemia E [IgE]"
    },
    {
      "code" : "D828",
      "display" : "D828 Inmunodeficiencia asociada con otros defectos mayores especificados"
    },
    {
      "code" : "D829",
      "display" : "D829 Inmunodeficiencia asociada con un defecto mayor no especificada"
    },
    {
      "code" : "D83",
      "display" : "D83 Inmunodeficiencia variable común"
    },
    {
      "code" : "D830",
      "display" : "D830 Inmunodeficiencia variable común con predominio de anomalías de recuento y función de células B"
    },
    {
      "code" : "D831",
      "display" : "D831 Inmunodeficiencia variable común con predominio de trastornos de las células T inmunomoduladoras"
    },
    {
      "code" : "D832",
      "display" : "D832 Inmunodeficiencia variable común con autoanticuerpos contra células B o T"
    },
    {
      "code" : "D838",
      "display" : "D838 Otros tipos de inmunodeficiencia variable común"
    },
    {
      "code" : "D839",
      "display" : "D839 Inmunodeficiencia variable común no especificada"
    },
    {
      "code" : "D84",
      "display" : "D84 Otras inmunodeficiencias"
    },
    {
      "code" : "D840",
      "display" : "D840 Defecto funcional del antígeno-1 linfocitario [LFA-1]"
    },
    {
      "code" : "D841",
      "display" : "D841 Defectos en el sistema del complemento"
    },
    {
      "code" : "D848",
      "display" : "D848 Otras inmunodeficiencias especificadas"
    },
    {
      "code" : "D8482",
      "display" : "D8482 Inmunodeficiencia debida a fármacos y causas externas"
    },
    {
      "code" : "D84821",
      "display" : "D84821 Inmunodeficiencia debida a fármacos"
    },
    {
      "code" : "D84822",
      "display" : "D84822 Inmunodeficiencia debida a causas externas"
    },
    {
      "code" : "D849",
      "display" : "D849 Inmunodeficiencia no especificada"
    },
    {
      "code" : "D86",
      "display" : "D86 Sarcoidosis"
    },
    {
      "code" : "D860",
      "display" : "D860 Sarcoidosis pulmonar"
    },
    {
      "code" : "D862",
      "display" : "D862 Sarcoidosis pulmonar con sarcoidosis de los ganglios linfáticos"
    },
    {
      "code" : "D863",
      "display" : "D863 Sarcoidosis de piel"
    },
    {
      "code" : "D8681",
      "display" : "D8681 Meningitis sarcoidea"
    },
    {
      "code" : "D8682",
      "display" : "D8682 Parálisis de múltiples pares craneales en sarcoidosis"
    },
    {
      "code" : "D8683",
      "display" : "D8683 Iridociclitis sarcoidea"
    },
    {
      "code" : "D8685",
      "display" : "D8685 Miocarditis sarcoidea"
    },
    {
      "code" : "D8686",
      "display" : "D8686 Artropatía sarcoidea"
    },
    {
      "code" : "D8689",
      "display" : "D8689 Sarcoidosis de otras localizaciones"
    },
    {
      "code" : "D869",
      "display" : "D869 Sarcoidosis no especificada"
    },
    {
      "code" : "D89",
      "display" : "D89 Otros trastornos que afectan al mecanismo inmunológico no clasificados bajo otro concepto"
    },
    {
      "code" : "D891",
      "display" : "D891 Crioglobulinemia"
    },
    {
      "code" : "D892",
      "display" : "D892 Hipergammaglobulinemia no especificada"
    },
    {
      "code" : "D894",
      "display" : "D894 Síndrome de activación de los mastocitos y trastornos relacionados"
    },
    {
      "code" : "D8940",
      "display" : "D8940 Activación de los mastocitos no especificada"
    },
    {
      "code" : "D8941",
      "display" : "D8941 Síndrome de activación mastocitaria monoclonal"
    },
    {
      "code" : "D8943",
      "display" : "D8943 Activación mastocitaria secundaria"
    },
    {
      "code" : "D8944",
      "display" : "D8944 Alfa triptasemia hereditaria"
    },
    {
      "code" : "D8949",
      "display" : "D8949 Otro tipo de trastorno de activación de los mastocitos"
    },
    {
      "code" : "D8981",
      "display" : "D8981 Enfermedad de injerto contra huésped"
    },
    {
      "code" : "D89810",
      "display" : "D89810 Enfermedad de injerto contra huésped aguda"
    },
    {
      "code" : "D89811",
      "display" : "D89811 Enfermedad de injerto contra huésped crónica"
    },
    {
      "code" : "D89812",
      "display" : "D89812 Enfermedad de injerto contra huésped aguda sobre crónica"
    },
    {
      "code" : "D89813",
      "display" : "D89813 Enfermedad de injerto contra huésped no especificada"
    },
    {
      "code" : "B383",
      "display" : "B383 Coccidioidomicosis cutánea"
    },
    {
      "code" : "B384",
      "display" : "B384 Coccidioidomicosis meningitis"
    },
    {
      "code" : "B387",
      "display" : "B387 Coccidioidomicosis diseminada"
    },
    {
      "code" : "B388",
      "display" : "B388 Otras formas de coccidioidomicosis"
    },
    {
      "code" : "B3881",
      "display" : "B3881 Coccidioidomicosis prostática"
    },
    {
      "code" : "B3889",
      "display" : "B3889 Otras formas de coccidioidomicosis"
    },
    {
      "code" : "B389",
      "display" : "B389 Coccidioidomicosis no especificada"
    },
    {
      "code" : "B39",
      "display" : "B39 Histoplasmosis"
    },
    {
      "code" : "B390",
      "display" : "B390 Infección pulmonar aguda debida a Histoplasma capsulatum"
    },
    {
      "code" : "B391",
      "display" : "B391 Infección pulmonar crónica debida a Histoplasma capsulatum"
    },
    {
      "code" : "B392",
      "display" : "B392 Infección pulmonar debida a Histoplasma capsulatum no especificada"
    },
    {
      "code" : "B393",
      "display" : "B393 Infección diseminada debida a Histoplasma capsulatum"
    },
    {
      "code" : "B394",
      "display" : "B394 Histoplasmosis debida a Histoplasma capsulatum no especificada"
    },
    {
      "code" : "B395",
      "display" : "B395 Infección debida a Histoplasma duboisii"
    },
    {
      "code" : "B399",
      "display" : "B399 Histoplasmosis no especificada"
    },
    {
      "code" : "B40",
      "display" : "B40 Blastomicosis"
    },
    {
      "code" : "B400",
      "display" : "B400 Blastomicosis pulmonar aguda"
    },
    {
      "code" : "B401",
      "display" : "B401 Blastomicosis pulmonar crónica"
    },
    {
      "code" : "B402",
      "display" : "B402 Blastomicosis pulmonar no especificada"
    },
    {
      "code" : "B403",
      "display" : "B403 Blastomicosis cutánea"
    },
    {
      "code" : "B407",
      "display" : "B407 Blastomicosis diseminada"
    },
    {
      "code" : "B408",
      "display" : "B408 Otras formas de blastomicosis"
    },
    {
      "code" : "B4081",
      "display" : "B4081 Meningoencefalitis blastomicótica"
    },
    {
      "code" : "B4089",
      "display" : "B4089 Otras formas de blastomicosis"
    },
    {
      "code" : "B409",
      "display" : "B409 Blastomicosis no especificada"
    },
    {
      "code" : "B41",
      "display" : "B41 Paracoccidioidomicosis"
    },
    {
      "code" : "B417",
      "display" : "B417 Paracoccidioidomicosis diseminada"
    },
    {
      "code" : "B418",
      "display" : "B418 Otras formas de paracoccidioidomicosis"
    },
    {
      "code" : "B42",
      "display" : "B42 Esporotricosis"
    },
    {
      "code" : "B420",
      "display" : "B420 Esporotricosis pulmonar"
    },
    {
      "code" : "B421",
      "display" : "B421 Esporotricosis linfocutánea"
    },
    {
      "code" : "B428",
      "display" : "B428 Otras formas de esporotricosis"
    },
    {
      "code" : "B4281",
      "display" : "B4281 Esporotricosis cerebral"
    },
    {
      "code" : "B4289",
      "display" : "B4289 Otras formas de esporotricosis"
    },
    {
      "code" : "B429",
      "display" : "B429 Esporotricosis no especificada"
    },
    {
      "code" : "B43",
      "display" : "B43 Cromomicosis y absceso feomicótico"
    },
    {
      "code" : "B431",
      "display" : "B431 Absceso cerebral feomicótico"
    },
    {
      "code" : "B432",
      "display" : "B432 Absceso y quiste subcutáneo feomicótico"
    },
    {
      "code" : "B439",
      "display" : "B439 Cromomicosis no especificada"
    },
    {
      "code" : "B44",
      "display" : "B44 Aspergilosis"
    },
    {
      "code" : "B441",
      "display" : "B441 Otras aspergilosis pulmonares"
    },
    {
      "code" : "B442",
      "display" : "B442 Aspergilosis amigdalina"
    },
    {
      "code" : "B447",
      "display" : "B447 Aspergilosis diseminada"
    },
    {
      "code" : "B4481",
      "display" : "B4481 Aspergilosis alérgica broncopulmonar"
    },
    {
      "code" : "B4489",
      "display" : "B4489 Otras formas de aspergilosis"
    },
    {
      "code" : "B45",
      "display" : "B45 Criptococosis"
    },
    {
      "code" : "B450",
      "display" : "B450 Criptococosis pulmonar"
    },
    {
      "code" : "B452",
      "display" : "B452 Criptococosis cutánea"
    },
    {
      "code" : "B453",
      "display" : "B453 Criptococosis ósea"
    },
    {
      "code" : "B457",
      "display" : "B457 Criptococosis diseminada"
    },
    {
      "code" : "B459",
      "display" : "B459 Criptococosis no especificada"
    },
    {
      "code" : "B46",
      "display" : "B46 Cigomicosis"
    },
    {
      "code" : "B461",
      "display" : "B461 Mucormicosis rinocerebral"
    },
    {
      "code" : "B462",
      "display" : "B462 Mucormicosis gastrointestinal"
    },
    {
      "code" : "B464",
      "display" : "B464 Mucormicosis diseminada"
    },
    {
      "code" : "B465",
      "display" : "B465 Mucormicosis no especificada"
    },
    {
      "code" : "B468",
      "display" : "B468 Otras cigomicosis"
    },
    {
      "code" : "B47",
      "display" : "B47 Micetoma"
    },
    {
      "code" : "B470",
      "display" : "B470 Eumicetoma"
    },
    {
      "code" : "B479",
      "display" : "B479 Micetoma no especificado"
    },
    {
      "code" : "B48",
      "display" : "B48 Otras micosis no clasificadas bajo otro concepto"
    },
    {
      "code" : "B481",
      "display" : "B481 Rinosporidiosis"
    },
    {
      "code" : "B482",
      "display" : "B482 Alesqueriasis"
    },
    {
      "code" : "C5711",
      "display" : "C5711 Neoplasia maligna de ligamento ancho derecho"
    },
    {
      "code" : "C5712",
      "display" : "C5712 Neoplasia maligna de ligamento ancho izquierdo"
    },
    {
      "code" : "C572",
      "display" : "C572 Neoplasia maligna de ligamento redondo"
    },
    {
      "code" : "C5720",
      "display" : "C5720 Neoplasia maligna de ligamento redondo no especificado"
    },
    {
      "code" : "C5721",
      "display" : "C5721 Neoplasia maligna de ligamento redondo derecho"
    },
    {
      "code" : "C5722",
      "display" : "C5722 Neoplasia maligna de ligamento redondo izquierdo"
    },
    {
      "code" : "C573",
      "display" : "C573 Neoplasia maligna de parametrio"
    },
    {
      "code" : "C574",
      "display" : "C574 Neoplasia maligna de anexos uterinos no especificados"
    },
    {
      "code" : "C577",
      "display" : "C577 Neoplasia maligna de otros órganos genitales femeninos especificados"
    },
    {
      "code" : "C578",
      "display" : "C578 Neoplasia maligna de localizaciones contiguas de órganos genitales femeninos"
    },
    {
      "code" : "C579",
      "display" : "C579 Neoplasia maligna de órgano genital femenino no especificada"
    },
    {
      "code" : "C58",
      "display" : "C58 Neoplasia maligna de placenta"
    },
    {
      "code" : "C60",
      "display" : "C60 Neoplasia maligna de pene"
    },
    {
      "code" : "C600",
      "display" : "C600 Neoplasia maligna de prepucio"
    },
    {
      "code" : "C601",
      "display" : "C601 Neoplasia maligna de glande"
    },
    {
      "code" : "C602",
      "display" : "C602 Neoplasia maligna de cuerpo de pene"
    },
    {
      "code" : "C608",
      "display" : "C608 Neoplasia maligna de localizaciones contiguas de pene"
    },
    {
      "code" : "C609",
      "display" : "C609 Neoplasia maligna de pene no especificada"
    },
    {
      "code" : "C61",
      "display" : "C61 Neoplasia maligna de próstata"
    },
    {
      "code" : "C62",
      "display" : "C62 Neoplasia maligna de testículo"
    },
    {
      "code" : "C620",
      "display" : "C620 Neoplasia maligna de testículo no descendido"
    },
    {
      "code" : "C6200",
      "display" : "C6200 Neoplasia maligna de testículo no descendido no especificado"
    },
    {
      "code" : "C6201",
      "display" : "C6201 Neoplasia maligna de testículo no descendido derecho"
    },
    {
      "code" : "C6202",
      "display" : "C6202 Neoplasia maligna de testículo no descendido izquierdo"
    },
    {
      "code" : "C621",
      "display" : "C621 Neoplasia maligna de testículo descendido"
    },
    {
      "code" : "C6210",
      "display" : "C6210 Neoplasia maligna de testículo descendido no especificado"
    },
    {
      "code" : "C6211",
      "display" : "C6211 Neoplasia maligna de testículo descendido derecho"
    },
    {
      "code" : "C629",
      "display" : "C629 Neoplasia maligna de testículo no especificado"
    },
    {
      "code" : "C6290",
      "display" : "C6290 Neoplasia maligna de testículo no especificado sin especificar si descendido o no descendido"
    },
    {
      "code" : "C6291",
      "display" : "C6291 Neoplasia maligna de testículo derecho no especificado como descendido o no descendido"
    },
    {
      "code" : "C63",
      "display" : "C63 Neoplasia maligna de otros órganos genitales masculinos y los no especificados"
    },
    {
      "code" : "C630",
      "display" : "C630 Neoplasia maligna de epidídimo"
    },
    {
      "code" : "C6300",
      "display" : "C6300 Neoplasia maligna de epidídimo no especificado"
    },
    {
      "code" : "C6301",
      "display" : "C6301 Neoplasia maligna de epidídimo derecho"
    },
    {
      "code" : "C631",
      "display" : "C631 Neoplasia maligna de cordón espermático"
    },
    {
      "code" : "C6310",
      "display" : "C6310 Neoplasia maligna de cordón espermático no especificado"
    },
    {
      "code" : "C6311",
      "display" : "C6311 Neoplasia maligna de cordón espermático derecho"
    },
    {
      "code" : "C632",
      "display" : "C632 Neoplasia maligna de escroto"
    },
    {
      "code" : "C637",
      "display" : "C637 Neoplasia maligna de otros órganos genitales masculinos especificados"
    },
    {
      "code" : "C638",
      "display" : "C638 Neoplasia maligna de localizaciones contiguas de órganos genitales masculinos"
    },
    {
      "code" : "C64",
      "display" : "C64 Neoplasia maligna de riñón excepto pelvis renal"
    },
    {
      "code" : "C641",
      "display" : "C641 Neoplasia maligna de riñón derecho excepto pelvis renal"
    },
    {
      "code" : "C642",
      "display" : "C642 Neoplasia maligna de riñón izquierdo excepto pelvis renal"
    },
    {
      "code" : "C649",
      "display" : "C649 Neoplasia maligna de riñón no especificado excepto pelvis renal"
    },
    {
      "code" : "C651",
      "display" : "C651 Neoplasia maligna de pelvis renal derecha"
    },
    {
      "code" : "C652",
      "display" : "C652 Neoplasia maligna de pelvis renal izquierda"
    },
    {
      "code" : "C66",
      "display" : "C66 Neoplasia maligna de uréter"
    },
    {
      "code" : "C661",
      "display" : "C661 Neoplasia maligna de uréter derecho"
    },
    {
      "code" : "C662",
      "display" : "C662 Neoplasia maligna de uréter izquierdo"
    },
    {
      "code" : "C669",
      "display" : "C669 Neoplasia maligna de uréter no especificado"
    },
    {
      "code" : "C670",
      "display" : "C670 Neoplasia maligna de trígono de vejiga"
    },
    {
      "code" : "C671",
      "display" : "C671 Neoplasia maligna de cúpula de vejiga"
    },
    {
      "code" : "C673",
      "display" : "C673 Neoplasia maligna de pared anterior de vejiga"
    },
    {
      "code" : "C674",
      "display" : "C674 Neoplasia maligna de pared posterior de vejiga"
    },
    {
      "code" : "C675",
      "display" : "C675 Neoplasia maligna de cuello de vejiga"
    },
    {
      "code" : "D0007",
      "display" : "D0007 Carcinoma in situ de la lengua"
    },
    {
      "code" : "D0008",
      "display" : "D0008 Carcinoma in situ de faringe"
    },
    {
      "code" : "D001",
      "display" : "D001 Carcinoma in situ de esófago"
    },
    {
      "code" : "D002",
      "display" : "D002 Carcinoma in situ de estómago"
    },
    {
      "code" : "D01",
      "display" : "D01 Carcinoma in situ de otros órganos digestivos y de los no especificados"
    },
    {
      "code" : "D010",
      "display" : "D010 Carcinoma in situ de colon"
    },
    {
      "code" : "D011",
      "display" : "D011 Carcinoma in situ de unión rectosigmoidea"
    },
    {
      "code" : "D012",
      "display" : "D012 Carcinoma in situ de recto"
    },
    {
      "code" : "D013",
      "display" : "D013 Carcinoma in situ de ano y canal anal"
    },
    {
      "code" : "D014",
      "display" : "D014 Carcinoma in situ de otras partes de intestino y las no especificadas"
    },
    {
      "code" : "D0140",
      "display" : "D0140 Carcinoma in situ de parte no especificada de intestino"
    },
    {
      "code" : "D0149",
      "display" : "D0149 Carcinoma in situ de otras partes de intestino"
    },
    {
      "code" : "D015",
      "display" : "D015 Carcinoma in situ de hígado vesícula biliar y conductos biliares"
    },
    {
      "code" : "D017",
      "display" : "D017 Carcinoma in situ de otros órganos digestivos especificados"
    },
    {
      "code" : "D019",
      "display" : "D019 Carcinoma in situ de órganos digestivos localización no especificada"
    },
    {
      "code" : "D02",
      "display" : "D02 Carcinoma in situ de oído medio y aparato respiratorio"
    },
    {
      "code" : "D020",
      "display" : "D020 Carcinoma in situ de laringe"
    },
    {
      "code" : "D021",
      "display" : "D021 Carcinoma in situ de tráquea"
    },
    {
      "code" : "D022",
      "display" : "D022 Carcinoma in situ de bronquio y pulmón"
    },
    {
      "code" : "D0220",
      "display" : "D0220 Carcinoma in situ de bronquio y pulmón no especificado"
    },
    {
      "code" : "D0221",
      "display" : "D0221 Carcinoma in situ de bronquio y pulmón derecho"
    },
    {
      "code" : "D0222",
      "display" : "D0222 Carcinoma in situ de bronquio y pulmón izquierdo"
    },
    {
      "code" : "D023",
      "display" : "D023 Carcinoma in situ de otras partes de sistema respiratorio"
    },
    {
      "code" : "D024",
      "display" : "D024 Carcinoma in situ de aparato respiratorio no especificado"
    },
    {
      "code" : "D03",
      "display" : "D03 Melanoma in situ"
    },
    {
      "code" : "D031",
      "display" : "D031 Melanoma in situ de párpado incluyendo canto"
    },
    {
      "code" : "D0310",
      "display" : "D0310 Melanoma in situ de párpado no especificado incluyendo canto"
    },
    {
      "code" : "D0311",
      "display" : "D0311 Melanoma in situ de párpado derecho incluyendo canto"
    },
    {
      "code" : "D03112",
      "display" : "D03112 Melanoma in situ de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "D0312",
      "display" : "D0312 Melanoma in situ de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "D03121",
      "display" : "D03121 Melanoma in situ de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "D032",
      "display" : "D032 Melanoma in situ de oído y conducto auditivo externo"
    },
    {
      "code" : "D0320",
      "display" : "D0320 Melanoma in situ de oído y conducto auditivo externo no especificado"
    },
    {
      "code" : "D0321",
      "display" : "D0321 Melanoma in situ de oído y conducto auditivo externo derecho"
    },
    {
      "code" : "D0322",
      "display" : "D0322 Melanoma in situ de oído y conducto auditivo externo izquierdo"
    },
    {
      "code" : "D0330",
      "display" : "D0330 Melanoma in situ de parte no especificada de la cara"
    },
    {
      "code" : "D0339",
      "display" : "D0339 Melanoma in situ de otras partes de la cara"
    },
    {
      "code" : "D034",
      "display" : "D034 Melanoma in situ de cuero cabelludo y de cuello"
    },
    {
      "code" : "D035",
      "display" : "D035 Melanoma in situ de tronco"
    },
    {
      "code" : "D0352",
      "display" : "D0352 Melanoma in situ de mama (piel) (tejidos blandos)"
    },
    {
      "code" : "D0359",
      "display" : "D0359 Melanoma in situ de otra parte de tronco"
    },
    {
      "code" : "D0360",
      "display" : "D0360 Melanoma in situ de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "D0006",
      "display" : "D0006 Carcinoma in situ de suelo de boca"
    },
    {
      "code" : "D0361",
      "display" : "D0361 Melanoma in situ de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "D037",
      "display" : "D037 Melanoma in situ de extremidad inferior incluida cadera"
    },
    {
      "code" : "D0370",
      "display" : "D0370 Melanoma in situ de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "D0371",
      "display" : "D0371 Melanoma in situ de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "D0372",
      "display" : "D0372 Melanoma in situ de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "D039",
      "display" : "D039 Melanoma in situ localización no especificada"
    },
    {
      "code" : "D04",
      "display" : "D04 Carcinoma in situ de piel"
    },
    {
      "code" : "D040",
      "display" : "D040 Carcinoma in situ de piel de labio"
    },
    {
      "code" : "D0410",
      "display" : "D0410 Carcinoma in situ de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "D0411",
      "display" : "D0411 Carcinoma in situ de piel de párpado derecho incluyendo canto"
    },
    {
      "code" : "D04111",
      "display" : "D04111 Carcinoma in situ de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "D89831",
      "display" : "D89831 Síndrome de liberación de citoquinas grado 1"
    },
    {
      "code" : "D89832",
      "display" : "D89832 Síndrome de liberación de citoquinas grado 2"
    },
    {
      "code" : "D89833",
      "display" : "D89833 Síndrome de liberación de citoquinas grado 3"
    },
    {
      "code" : "D89834",
      "display" : "D89834 Síndrome de liberación de citoquinas grado 4"
    },
    {
      "code" : "D89835",
      "display" : "D89835 Síndrome de liberación de citoquinas grado 5"
    },
    {
      "code" : "D89839",
      "display" : "D89839 Síndrome de liberación de citoquinas grado no especificado"
    },
    {
      "code" : "D8989",
      "display" : "D8989 Otros trastornos especificados que afectan al mecanismo inmunológico no clasificados bajo otro concepto"
    },
    {
      "code" : "D899",
      "display" : "D899 Trastorno que afecta al mecanismo inmunológico no especificado"
    },
    {
      "code" : "E00",
      "display" : "E00 Síndrome congénito por carencia de yodo"
    },
    {
      "code" : "E000",
      "display" : "E000 Síndrome congénito de carencia de yodo tipo neurológico"
    },
    {
      "code" : "E001",
      "display" : "E001 Síndrome congénito de carencia de yodo tipo mixedematoso"
    },
    {
      "code" : "E002",
      "display" : "E002 Síndrome congénito de carencia de yodo tipo mixto"
    },
    {
      "code" : "E009",
      "display" : "E009 Síndrome congénito de carencia de yodo no especificado"
    },
    {
      "code" : "E01",
      "display" : "E01 Trastornos tiroideos relacionados con carencia de yodo y afecciones afines"
    },
    {
      "code" : "E010",
      "display" : "E010 Bocio (endémico) difuso relacionado con carencia de yodo"
    },
    {
      "code" : "E011",
      "display" : "E011 Bocio (endémico) multinodular relacionado con carencia de yodo"
    },
    {
      "code" : "E012",
      "display" : "E012 Bocio (endémico) relacionado con carencia de yodo no especificado"
    },
    {
      "code" : "E018",
      "display" : "E018 Otros tipos de trastornos tiroideos relacionados con carencia de yodo y afecciones afines"
    },
    {
      "code" : "E02",
      "display" : "E02 Hipotiroidismo subclínico por carencia de yodo"
    },
    {
      "code" : "E03",
      "display" : "E03 Otros tipos de hipotiroidismo"
    },
    {
      "code" : "E030",
      "display" : "E030 Hipotiroidismo congénito con bocio difuso"
    },
    {
      "code" : "E031",
      "display" : "E031 Hipotiroidismo congénito sin bocio"
    },
    {
      "code" : "E032",
      "display" : "E032 Hipotiroidismo debido a medicamentos y otras sustancias exógenas"
    },
    {
      "code" : "E033",
      "display" : "E033 Hipotiroidismo postinfeccioso"
    },
    {
      "code" : "E034",
      "display" : "E034 Atrofia de tiroides (adquirida)"
    },
    {
      "code" : "E038",
      "display" : "E038 Otros tipos de hipotiroidismo especificados"
    },
    {
      "code" : "E039",
      "display" : "E039 Hipotiroidismo no especificado"
    },
    {
      "code" : "E040",
      "display" : "E040 Bocio difuso no tóxico"
    },
    {
      "code" : "E041",
      "display" : "E041 Nódulo tiroideo único no tóxico"
    },
    {
      "code" : "E042",
      "display" : "E042 Bocio multinodular no tóxico"
    },
    {
      "code" : "E049",
      "display" : "E049 Bocio no tóxico no especificado"
    },
    {
      "code" : "E05",
      "display" : "E05 Tirotoxicosis [hipertiroidismo]"
    },
    {
      "code" : "E050",
      "display" : "E050 Tirotoxicosis con bocio difuso"
    },
    {
      "code" : "E0501",
      "display" : "E0501 Tirotoxicosis con bocio difuso con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E051",
      "display" : "E051 Tirotoxicosis con nódulo tiroideo tóxico único"
    },
    {
      "code" : "E0510",
      "display" : "E0510 Tirotoxicosis con nódulo tiroideo tóxico único sin crisis tirotóxica ni tormenta tiroidea"
    },
    {
      "code" : "E0511",
      "display" : "E0511 Tirotoxicosis con nódulo tiroideo tóxico único con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E0520",
      "display" : "E0520 Tirotoxicosis con bocio multinodular tóxico sin crisis tirotóxica ni tormenta tiroidea"
    },
    {
      "code" : "E0521",
      "display" : "E0521 Tirotoxicosis con bocio multinodular tóxico con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E053",
      "display" : "E053 Tirotoxicosis por tejido tiroideo ectópico"
    },
    {
      "code" : "D8983",
      "display" : "D8983 Síndrome de liberación de citoquinas"
    },
    {
      "code" : "E0531",
      "display" : "E0531 Tirotoxicosis por tejido tiroideo ectópico con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E054",
      "display" : "E054 Tirotoxicosis facticia"
    },
    {
      "code" : "E0540",
      "display" : "E0540 Tirotoxicosis facticia sin crisis tirotóxica ni tormenta tiroidea"
    },
    {
      "code" : "E058",
      "display" : "E058 Otras tirotoxicosis"
    },
    {
      "code" : "E0580",
      "display" : "E0580 Otros tipos de tirotoxicosis sin crisis tirotóxica ni tormenta tiroidea"
    },
    {
      "code" : "E0581",
      "display" : "E0581 Otros tipos de tirotoxicosis con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E0590",
      "display" : "E0590 Tirotoxicosis no especificada sin crisis tirotóxica ni tormenta tiroidea"
    },
    {
      "code" : "E0591",
      "display" : "E0591 Tirotoxicosis no especificada con crisis tirotóxica o tormenta tiroidea"
    },
    {
      "code" : "E06",
      "display" : "E06 Tiroiditis"
    },
    {
      "code" : "E061",
      "display" : "E061 Tiroiditis subaguda"
    },
    {
      "code" : "E062",
      "display" : "E062 Tiroiditis crónica con tirotoxicosis transitoria"
    },
    {
      "code" : "E064",
      "display" : "E064 Tiroiditis inducida por fármacos"
    },
    {
      "code" : "B484",
      "display" : "B484 Penicilosis"
    },
    {
      "code" : "B488",
      "display" : "B488 Otras micosis especificadas"
    },
    {
      "code" : "B49",
      "display" : "B49 Micosis no especificadas"
    },
    {
      "code" : "B50",
      "display" : "B50 Paludismo [malaria] debido a Plasmodium falciparum"
    },
    {
      "code" : "B500",
      "display" : "B500 Paludismo debido a Plasmodium falciparum con complicaciones cerebrales"
    },
    {
      "code" : "B508",
      "display" : "B508 Otro paludismo grave y complicado debido a Plasmodium falciparum"
    },
    {
      "code" : "B509",
      "display" : "B509 Paludismo debido a Plasmodium falciparum no especificado"
    },
    {
      "code" : "B51",
      "display" : "B51 Paludismo [malaria] debido a Plasmodium vivax"
    },
    {
      "code" : "B510",
      "display" : "B510 Paludismo debido a Plasmodium vivax con ruptura esplénica"
    },
    {
      "code" : "B518",
      "display" : "B518 Paludismo debido a Plasmodium vivax con otras complicaciones"
    },
    {
      "code" : "B519",
      "display" : "B519 Paludismo debido a Plasmodium vivax sin complicaciones"
    },
    {
      "code" : "B52",
      "display" : "B52 Paludismo [malaria] debido a Plasmodium malariae"
    },
    {
      "code" : "B520",
      "display" : "B520 Paludismo debido a Plasmodium malariae con nefropatía"
    },
    {
      "code" : "B528",
      "display" : "B528 Paludismo debido a Plasmodium malariae con otras complicaciones"
    },
    {
      "code" : "B529",
      "display" : "B529 Paludismo debido a Plasmodium malariae sin complicaciones"
    },
    {
      "code" : "B53",
      "display" : "B53 Otras formas de malaria especificadas"
    },
    {
      "code" : "B530",
      "display" : "B530 Paludismo debido a Plasmodium ovale"
    },
    {
      "code" : "B531",
      "display" : "B531 Paludismo debido a plasmodios de los simios"
    },
    {
      "code" : "B538",
      "display" : "B538 Otra malaria no clasificada bajo otro concepto"
    },
    {
      "code" : "B54",
      "display" : "B54 Paludismo [malaria] no especificado"
    },
    {
      "code" : "B55",
      "display" : "B55 Leishmaniasis"
    },
    {
      "code" : "B550",
      "display" : "B550 Leishmaniasis visceral"
    },
    {
      "code" : "B551",
      "display" : "B551 Leishmaniasis cutánea"
    },
    {
      "code" : "B552",
      "display" : "B552 Leishmaniasis mucocutánea"
    },
    {
      "code" : "B559",
      "display" : "B559 Leishmaniasis no especificada"
    },
    {
      "code" : "B560",
      "display" : "B560 Tripanosomiasis gambiense"
    },
    {
      "code" : "B561",
      "display" : "B561 Tripanosomiasis rhodesiense"
    },
    {
      "code" : "B57",
      "display" : "B57 Enfermedad de Chagas"
    },
    {
      "code" : "B570",
      "display" : "B570 Enfermedad de Chagas aguda con compromiso cardiaco"
    },
    {
      "code" : "B571",
      "display" : "B571 Enfermedad de Chagas aguda que no afecta al corazón"
    },
    {
      "code" : "B573",
      "display" : "B573 Enfermedad de Chagas (crónica) que afecta al aparato digestivo"
    },
    {
      "code" : "B5730",
      "display" : "B5730 Enfermedad de Chagas con afectación del aparato digestivo no especificada"
    },
    {
      "code" : "B5731",
      "display" : "B5731 Megaesófago en enfermedad de Chagas"
    },
    {
      "code" : "B5739",
      "display" : "B5739 Otros tipos de afectación del aparato digestivo en la enfermedad de Chagas"
    },
    {
      "code" : "B574",
      "display" : "B574 Enfermedad de Chagas (crónica) que afecta al sistema nervioso"
    },
    {
      "code" : "B5740",
      "display" : "B5740 Enfermedad de Chagas con afectación del sistema nervioso no especificada"
    },
    {
      "code" : "B5742",
      "display" : "B5742 Meningoencefalitis en enfermedad de Chagas"
    },
    {
      "code" : "B5749",
      "display" : "B5749 Otros tipos de afectación del sistema nervioso en la enfermedad de Chagas"
    },
    {
      "code" : "B575",
      "display" : "B575 Enfermedad de Chagas (crónica) que afecta otros órganos"
    },
    {
      "code" : "B483",
      "display" : "B483 Geotricosis"
    },
    {
      "code" : "B580",
      "display" : "B580 Oculopatía debida a toxoplasma"
    },
    {
      "code" : "B5801",
      "display" : "B5801 Coriorretinitis por toxoplasma"
    },
    {
      "code" : "B5809",
      "display" : "B5809 Otros tipos de oculopatía por toxoplasma"
    },
    {
      "code" : "B581",
      "display" : "B581 Hepatitis por toxoplasma"
    },
    {
      "code" : "B583",
      "display" : "B583 Toxoplasmosis pulmonar"
    },
    {
      "code" : "B588",
      "display" : "B588 Toxoplasmosis con afectación de otros órganos"
    },
    {
      "code" : "B5882",
      "display" : "B5882 Miositis por toxoplasma"
    },
    {
      "code" : "B5883",
      "display" : "B5883 Nefropatía túbulointersticial por toxoplasma"
    },
    {
      "code" : "B5889",
      "display" : "B5889 Toxoplasmosis con afectación de otros órganos"
    },
    {
      "code" : "B59",
      "display" : "B59 Neumocistosis"
    },
    {
      "code" : "B60",
      "display" : "B60 Otras enfermedades debidas a protozoos no clasificadas bajo otro concepto"
    },
    {
      "code" : "B6000",
      "display" : "B6000 Babesiosis no especificada"
    },
    {
      "code" : "B6001",
      "display" : "B6001 Babesiosis debida a Babesia microti"
    },
    {
      "code" : "B6003",
      "display" : "B6003 Babesiosis debida a Babesia divergens"
    },
    {
      "code" : "B6009",
      "display" : "B6009 Otra babesiosis"
    },
    {
      "code" : "B601",
      "display" : "B601 Acantamebiasis"
    },
    {
      "code" : "B6011",
      "display" : "B6011 Meningoencefalitis por Acantoameba (de Culbertson)"
    },
    {
      "code" : "C676",
      "display" : "C676 Neoplasia maligna de orificio ureteral"
    },
    {
      "code" : "C677",
      "display" : "C677 Neoplasia maligna de uraco"
    },
    {
      "code" : "C678",
      "display" : "C678 Neoplasia maligna de localizaciones contiguas de vejiga"
    },
    {
      "code" : "C679",
      "display" : "C679 Neoplasia maligna de vejiga no especificada"
    },
    {
      "code" : "C68",
      "display" : "C68 Neoplasia maligna de otros órganos urinarios y los no especificados"
    },
    {
      "code" : "C680",
      "display" : "C680 Neoplasia maligna de uretra"
    },
    {
      "code" : "C681",
      "display" : "C681 Neoplasia maligna de glándulas parauretrales"
    },
    {
      "code" : "C688",
      "display" : "C688 Neoplasia maligna de localizaciones contiguas de órganos urinarios"
    },
    {
      "code" : "C689",
      "display" : "C689 Neoplasia maligna de órgano urinario no especificado"
    },
    {
      "code" : "C69",
      "display" : "C69 Neoplasia maligna de ojo y sus anexos"
    },
    {
      "code" : "C690",
      "display" : "C690 Neoplasia maligna de conjuntiva"
    },
    {
      "code" : "C6900",
      "display" : "C6900 Neoplasia maligna de conjuntiva no especificada"
    },
    {
      "code" : "C6901",
      "display" : "C6901 Neoplasia maligna de conjuntiva derecha"
    },
    {
      "code" : "C6902",
      "display" : "C6902 Neoplasia maligna de conjuntiva izquierda"
    },
    {
      "code" : "C691",
      "display" : "C691 Neoplasia maligna de córnea"
    },
    {
      "code" : "C6910",
      "display" : "C6910 Neoplasia maligna de córnea no especificada"
    },
    {
      "code" : "C6911",
      "display" : "C6911 Neoplasia maligna de córnea derecha"
    },
    {
      "code" : "C6912",
      "display" : "C6912 Neoplasia maligna de córnea izquierda"
    },
    {
      "code" : "C692",
      "display" : "C692 Neoplasia maligna de retina"
    },
    {
      "code" : "C6920",
      "display" : "C6920 Neoplasia maligna de retina no especificada"
    },
    {
      "code" : "C6921",
      "display" : "C6921 Neoplasia maligna de retina derecha"
    },
    {
      "code" : "C6922",
      "display" : "C6922 Neoplasia maligna de retina izquierda"
    },
    {
      "code" : "C693",
      "display" : "C693 Neoplasia maligna de coroides"
    },
    {
      "code" : "C6930",
      "display" : "C6930 Neoplasia maligna de coroides no especificada"
    },
    {
      "code" : "C6932",
      "display" : "C6932 Neoplasia maligna de coroides izquierda"
    },
    {
      "code" : "C694",
      "display" : "C694 Neoplasia maligna de cuerpo ciliar"
    },
    {
      "code" : "C6940",
      "display" : "C6940 Neoplasia maligna de cuerpo ciliar no especificado"
    },
    {
      "code" : "C6942",
      "display" : "C6942 Neoplasia maligna de cuerpo ciliar izquierdo"
    },
    {
      "code" : "C695",
      "display" : "C695 Neoplasia maligna de glándula y conducto lacrimal"
    },
    {
      "code" : "C6950",
      "display" : "C6950 Neoplasia maligna de glándula y conducto lacrimal no especificado"
    },
    {
      "code" : "C6952",
      "display" : "C6952 Neoplasia maligna de glándula y conducto lacrimal izquierdo"
    },
    {
      "code" : "C696",
      "display" : "C696 Neoplasia maligna de órbita"
    },
    {
      "code" : "C6960",
      "display" : "C6960 Neoplasia maligna de órbita no especificada"
    },
    {
      "code" : "C6962",
      "display" : "C6962 Neoplasia maligna de órbita izquierda"
    },
    {
      "code" : "C698",
      "display" : "C698 Neoplasia maligna de localizaciones contiguas de ojo y sus anexos"
    },
    {
      "code" : "C6980",
      "display" : "C6980 Neoplasia maligna de localizaciones contiguas de ojo y sus anexos no especificados"
    },
    {
      "code" : "C6982",
      "display" : "C6982 Neoplasia maligna de localizaciones contiguas de ojo izquierdo y sus anexos"
    },
    {
      "code" : "C699",
      "display" : "C699 Neoplasia maligna de localización no especificada del ojo"
    },
    {
      "code" : "C6990",
      "display" : "C6990 Neoplasia maligna de ojo de localización no especificada de ojo no especificado"
    },
    {
      "code" : "C6991",
      "display" : "C6991 Neoplasia maligna de localización no especificada de ojo derecho"
    },
    {
      "code" : "C70",
      "display" : "C70 Neoplasia maligna de meninges"
    },
    {
      "code" : "C700",
      "display" : "C700 Neoplasia maligna de meninges cerebrales"
    },
    {
      "code" : "C701",
      "display" : "C701 Neoplasia maligna de meninges espinales"
    },
    {
      "code" : "C709",
      "display" : "C709 Neoplasia maligna de meninges no especificada"
    },
    {
      "code" : "C710",
      "display" : "C710 Neoplasia maligna de cerebro excepto lóbulos y ventrículos"
    },
    {
      "code" : "C711",
      "display" : "C711 Neoplasia maligna de lóbulo frontal"
    },
    {
      "code" : "C713",
      "display" : "C713 Neoplasia maligna de lóbulo parietal"
    },
    {
      "code" : "C714",
      "display" : "C714 Neoplasia maligna de lóbulo occipital"
    },
    {
      "code" : "C715",
      "display" : "C715 Neoplasia maligna de ventrículo cerebral"
    },
    {
      "code" : "C717",
      "display" : "C717 Neoplasia maligna de tronco cerebral"
    },
    {
      "code" : "C718",
      "display" : "C718 Neoplasia maligna de localizaciones contiguas de cerebro"
    },
    {
      "code" : "C72",
      "display" : "C72 Neoplasia maligna de médula espinal nervios craneales y otras partes de sistema nervioso central"
    },
    {
      "code" : "C720",
      "display" : "C720 Neoplasia maligna de médula espinal"
    },
    {
      "code" : "C721",
      "display" : "C721 Neoplasia maligna de cola de caballo"
    },
    {
      "code" : "C7220",
      "display" : "C7220 Neoplasia maligna de nervio olfatorio no especificado"
    },
    {
      "code" : "D04112",
      "display" : "D04112 Carcinoma in situ de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "D0412",
      "display" : "D0412 Carcinoma in situ de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "D04121",
      "display" : "D04121 Carcinoma in situ de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "D04122",
      "display" : "D04122 Carcinoma in situ de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "D042",
      "display" : "D042 Carcinoma in situ de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "D0420",
      "display" : "D0420 Carcinoma in situ de piel de oído y conducto auditivo externo no especificados lado no especificado"
    },
    {
      "code" : "D0421",
      "display" : "D0421 Carcinoma in situ de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "D0422",
      "display" : "D0422 Carcinoma in situ de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "D043",
      "display" : "D043 Carcinoma in situ de piel de otras partes de la cara y las no especificadas"
    },
    {
      "code" : "D0430",
      "display" : "D0430 Carcinoma in situ de piel de parte no especificada de la cara"
    },
    {
      "code" : "D0439",
      "display" : "D0439 Carcinoma in situ de piel de otras partes de la cara"
    },
    {
      "code" : "D044",
      "display" : "D044 Carcinoma in situ de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "D045",
      "display" : "D045 Carcinoma in situ de piel de tronco"
    },
    {
      "code" : "D046",
      "display" : "D046 Carcinoma in situ de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "D0460",
      "display" : "D0460 Carcinoma in situ de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "D0461",
      "display" : "D0461 Carcinoma in situ de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "D0462",
      "display" : "D0462 Carcinoma in situ de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "D047",
      "display" : "D047 Carcinoma in situ de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "D0470",
      "display" : "D0470 Carcinoma in situ de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "D0471",
      "display" : "D0471 Carcinoma in situ de piel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "D0472",
      "display" : "D0472 Carcinoma in situ de piel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "D048",
      "display" : "D048 Carcinoma in situ de piel de otras localizaciones"
    },
    {
      "code" : "D049",
      "display" : "D049 Carcinoma in situ de piel no especificado"
    },
    {
      "code" : "D05",
      "display" : "D05 Carcinoma in situ de mama"
    },
    {
      "code" : "D050",
      "display" : "D050 Carcinoma lobular in situ de mama"
    },
    {
      "code" : "D0500",
      "display" : "D0500 Carcinoma lobular in situ de mama no especificada"
    },
    {
      "code" : "D0501",
      "display" : "D0501 Carcinoma lobular in situ de mama derecha"
    },
    {
      "code" : "D051",
      "display" : "D051 Carcinoma intraductal in situ de mama"
    },
    {
      "code" : "D0510",
      "display" : "D0510 Carcinoma intraductal in situ de mama no especificada"
    },
    {
      "code" : "D0511",
      "display" : "D0511 Carcinoma intraductal in situ de mama derecha"
    },
    {
      "code" : "D058",
      "display" : "D058 Otro tipo especificado de carcinoma in situ de mama"
    },
    {
      "code" : "D0580",
      "display" : "D0580 Otro tipo especificado de carcinoma in situ de mama no especificada"
    },
    {
      "code" : "D0581",
      "display" : "D0581 Otro tipo especificado de carcinoma in situ de mama derecha"
    },
    {
      "code" : "D059",
      "display" : "D059 Carcinoma in situ de mama tipo no especificado"
    },
    {
      "code" : "D0590",
      "display" : "D0590 Carcinoma in situ de tipo no especificado de mama no especificada"
    },
    {
      "code" : "D0591",
      "display" : "D0591 Carcinoma in situ de mama derecha tipo no especificado"
    },
    {
      "code" : "D0592",
      "display" : "D0592 Carcinoma in situ de mama izquierda tipo no especificado"
    },
    {
      "code" : "D060",
      "display" : "D060 Carcinoma in situ de endocérvix"
    },
    {
      "code" : "D061",
      "display" : "D061 Carcinoma in situ de exocérvix"
    },
    {
      "code" : "D069",
      "display" : "D069 Carcinoma in situ de cuello uterinono especificado"
    },
    {
      "code" : "D07",
      "display" : "D07 Carcinoma in situ de otros órganos genitales y los no especificados"
    },
    {
      "code" : "D070",
      "display" : "D070 Carcinoma in situ de endometrio"
    },
    {
      "code" : "D071",
      "display" : "D071 Carcinoma in situ de vulva"
    },
    {
      "code" : "D073",
      "display" : "D073 Carcinoma in situ de otros órganos genitales femeninos y los no especificados"
    },
    {
      "code" : "D0730",
      "display" : "D0730 Carcinoma in situ de órganos genitales femeninos no especificados"
    },
    {
      "code" : "D074",
      "display" : "D074 Carcinoma in situ de pene"
    },
    {
      "code" : "D075",
      "display" : "D075 Carcinoma in situ de próstata"
    },
    {
      "code" : "D076",
      "display" : "D076 Carcinoma in situ de otros órganos genitales masculinos y los no especificados"
    },
    {
      "code" : "D0761",
      "display" : "D0761 Carcinoma in situ de escroto"
    },
    {
      "code" : "D0769",
      "display" : "D0769 Carcinoma in situ de otros órganos genitales masculinos"
    },
    {
      "code" : "D09",
      "display" : "D09 Carcinoma in situ de otras localizaciones y las no especificadas"
    },
    {
      "code" : "D090",
      "display" : "D090 Carcinoma in situ de vejiga"
    },
    {
      "code" : "E069",
      "display" : "E069 Tiroiditis no especificada"
    },
    {
      "code" : "E07",
      "display" : "E07 Otros trastornos tiroideos"
    },
    {
      "code" : "E070",
      "display" : "E070 Hipersecreción de calcitonina"
    },
    {
      "code" : "E071",
      "display" : "E071 Bocio dishormonogénico"
    },
    {
      "code" : "E078",
      "display" : "E078 Otros trastornos específicos de tiroides"
    },
    {
      "code" : "E0781",
      "display" : "E0781 Síndrome del enfermo eutiroideo"
    },
    {
      "code" : "E0789",
      "display" : "E0789 Otros trastornos específicos de tiroides"
    },
    {
      "code" : "E079",
      "display" : "E079 Trastorno de tiroides no especificado"
    },
    {
      "code" : "E08",
      "display" : "E08 Diabetes mellitus debida a afección subyacente"
    },
    {
      "code" : "E080",
      "display" : "E080 Diabetes mellitus debida a afección subyacente con hiperosmolaridad"
    },
    {
      "code" : "E0800",
      "display" : "E0800 Diabetes mellitus debida a afección subyacente con hiperosmolaridad sin coma hIperglucémico hiperosmolar no cetósico (CHHNC)"
    },
    {
      "code" : "E0801",
      "display" : "E0801 Diabetes mellitus debida a afección subyacente con hiperosmolaridad con coma"
    },
    {
      "code" : "E081",
      "display" : "E081 Diabetes mellitus debida a afección subyacente con cetoacidosis"
    },
    {
      "code" : "E0810",
      "display" : "E0810 Diabetes mellitus debida a afección subyacente con cetoacidosis sin coma"
    },
    {
      "code" : "E0811",
      "display" : "E0811 Diabetes mellitus debida a afección subyacente con cetoacidosis con coma"
    },
    {
      "code" : "E082",
      "display" : "E082 Diabetes mellitus debida a afección subyacente con complicaciones renales"
    },
    {
      "code" : "E0821",
      "display" : "E0821 Diabetes mellitus debida a afección subyacente con nefropatía diabética"
    },
    {
      "code" : "E0822",
      "display" : "E0822 Diabetes mellitus debida a afección subyacente con nefropatía diabética crónica"
    },
    {
      "code" : "E0829",
      "display" : "E0829 Diabetes mellitus debida a afección subyacente con otra complicación renal diabética"
    },
    {
      "code" : "E083",
      "display" : "E083 Diabetes mellitus debida a afección subyacente con complicaciones oftálmicas"
    },
    {
      "code" : "E0831",
      "display" : "E0831 Diabetes mellitus debida a afección subyacente con retinopatía diabética no especificada"
    },
    {
      "code" : "E08311",
      "display" : "E08311 Diabetes mellitus debida a afección subyacente con retinopatía diabética no especificada con edema macular"
    },
    {
      "code" : "E08319",
      "display" : "E08319 Diabetes mellitus debida a afección subyacente con retinopatía diabética no especificada sin edema macular"
    },
    {
      "code" : "E0832",
      "display" : "E0832 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve"
    },
    {
      "code" : "E08321",
      "display" : "E08321 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve con edema macular"
    },
    {
      "code" : "E083211",
      "display" : "E083211 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve con edema macular ojo derecho"
    },
    {
      "code" : "E083212",
      "display" : "E083212 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve con edema macular ojo izquierdo"
    },
    {
      "code" : "E083213",
      "display" : "E083213 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve con edema macular bilateral"
    },
    {
      "code" : "E08329",
      "display" : "E08329 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve sin edema macular"
    },
    {
      "code" : "E083291",
      "display" : "E083291 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve sin edema macular ojo derecho"
    },
    {
      "code" : "E083292",
      "display" : "E083292 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve sin edema macular ojo izquierdo"
    },
    {
      "code" : "E083293",
      "display" : "E083293 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve sin edema macular bilateral"
    },
    {
      "code" : "E083299",
      "display" : "E083299 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa leve sin edema macular ojo no especificado"
    },
    {
      "code" : "E0833",
      "display" : "E0833 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada"
    },
    {
      "code" : "E083311",
      "display" : "E083311 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada con edema macular ojo derecho"
    },
    {
      "code" : "E083312",
      "display" : "E083312 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada con edema macular ojo izquierdo"
    },
    {
      "code" : "E083313",
      "display" : "E083313 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada con edema macular bilateral"
    },
    {
      "code" : "E083319",
      "display" : "E083319 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada con edema macular ojo no especificado"
    },
    {
      "code" : "E08339",
      "display" : "E08339 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada sin edema macular"
    },
    {
      "code" : "E083392",
      "display" : "E083392 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada sin edema macular ojo izquierdo"
    },
    {
      "code" : "E083393",
      "display" : "E083393 Diabetes mellitus debida a afección subyacente con retinopatía diabética no proliferativa moderada sin edema macular bilateral"
    },
    {
      "code" : "E065",
      "display" : "E065 Otras tiroiditis crónicas"
    },
    {
      "code" : "B6012",
      "display" : "B6012 Conjuntivitis por acantoameba"
    },
    {
      "code" : "B6013",
      "display" : "B6013 Queratoconjuntivitis por acantoameba"
    },
    {
      "code" : "B6019",
      "display" : "B6019 Otras enfermedades por acantoameba"
    },
    {
      "code" : "B602",
      "display" : "B602 Naegleriasis"
    },
    {
      "code" : "B608",
      "display" : "B608 Otras enfermedades especificadas debidas a protozoos"
    },
    {
      "code" : "B64",
      "display" : "B64 Enfermedad debida a protozoos no especificada"
    },
    {
      "code" : "B65",
      "display" : "B65 Esquistosomiasis [bilharziasis]"
    },
    {
      "code" : "B650",
      "display" : "B650 Esquistosomiasis debida a Schistosoma haematobium [esquistosomiasis urinaria]"
    },
    {
      "code" : "B651",
      "display" : "B651 Esquistosomiasis debida a Schistosoma mansoni [esquistosomiasis intestinal]"
    },
    {
      "code" : "B652",
      "display" : "B652 Esquistosomiasis debida a Schistosoma japonicum"
    },
    {
      "code" : "B653",
      "display" : "B653 Dermatitis por cercarias"
    },
    {
      "code" : "B658",
      "display" : "B658 Otras esquistosomiasis"
    },
    {
      "code" : "B659",
      "display" : "B659 Esquistosomiasis no especificada"
    },
    {
      "code" : "B66",
      "display" : "B66 Otras infecciones debidas a trematodos"
    },
    {
      "code" : "B660",
      "display" : "B660 Opistorquiasis"
    },
    {
      "code" : "B661",
      "display" : "B661 Clonorquiasis"
    },
    {
      "code" : "B662",
      "display" : "B662 Dicrocoeliasis"
    },
    {
      "code" : "B663",
      "display" : "B663 Fascioliasis"
    },
    {
      "code" : "B664",
      "display" : "B664 Paragonimiasis"
    },
    {
      "code" : "B665",
      "display" : "B665 Fasciolopsiasis"
    },
    {
      "code" : "B668",
      "display" : "B668 Otras infecciones especificadas debidas a trematodos"
    },
    {
      "code" : "B669",
      "display" : "B669 Infección debida a trematodos no especificada"
    },
    {
      "code" : "B67",
      "display" : "B67 Equinococosis"
    },
    {
      "code" : "B670",
      "display" : "B670 Infección del hígado debida a Echinococcus granulosus"
    },
    {
      "code" : "B671",
      "display" : "B671 Infección del pulmón debida a Echinococcus granulosus"
    },
    {
      "code" : "B672",
      "display" : "B672 Infección de hueso debida a Echinococcus granulosus"
    },
    {
      "code" : "B6731",
      "display" : "B6731 Infección por Echinococcus granulosus glándula tiroides"
    },
    {
      "code" : "B6732",
      "display" : "B6732 Infección por Echinococcus granulosus localizaciones múltiples"
    },
    {
      "code" : "B6739",
      "display" : "B6739 Infección por Echinococcus granulosus otros sitios"
    },
    {
      "code" : "B674",
      "display" : "B674 Infección debida a Echinococcus granulosus no especificada"
    },
    {
      "code" : "B676",
      "display" : "B676 Infección de otro órgano y de sitios múltiples debida a Echinococcus multilocularis"
    },
    {
      "code" : "B6761",
      "display" : "B6761 Infección por Echinococcus multilocularis localizaciones múltiples"
    },
    {
      "code" : "B6769",
      "display" : "B6769 Infección por Echinococcus multilocularis otros sitios"
    },
    {
      "code" : "B678",
      "display" : "B678 Equinococosis del hígado no especificada"
    },
    {
      "code" : "B679",
      "display" : "B679 Otra equinococosis y la no especificada"
    },
    {
      "code" : "B6790",
      "display" : "B6790 Equinococosis no especificada"
    },
    {
      "code" : "B68",
      "display" : "B68 Teniasis"
    },
    {
      "code" : "B680",
      "display" : "B680 Teniasis debida a Taenia solium"
    },
    {
      "code" : "B681",
      "display" : "B681 Infección debida a Taenia saginata"
    },
    {
      "code" : "B69",
      "display" : "B69 Cisticercosis"
    },
    {
      "code" : "B690",
      "display" : "B690 Cisticercosis del sistema nervioso central"
    },
    {
      "code" : "B698",
      "display" : "B698 Cisticercosis de otras localizaciones"
    },
    {
      "code" : "B6981",
      "display" : "B6981 Miositis en cisticercosis"
    },
    {
      "code" : "B699",
      "display" : "B699 Cisticercosis no especificada"
    },
    {
      "code" : "B70",
      "display" : "B70 Difilobotriasis y esparganosis"
    },
    {
      "code" : "B700",
      "display" : "B700 Difilobotriasis"
    },
    {
      "code" : "B71",
      "display" : "B71 Otras infecciones debidas a cestodos"
    },
    {
      "code" : "B710",
      "display" : "B710 Himenolepiasis"
    },
    {
      "code" : "B718",
      "display" : "B718 Otras infecciones debidas a cestodos especificadas"
    },
    {
      "code" : "B719",
      "display" : "B719 Infección debida a cestodos no especificada"
    },
    {
      "code" : "B73",
      "display" : "B73 Oncocercosis"
    },
    {
      "code" : "B730",
      "display" : "B730 Oncocercosis con enfermedad ocular"
    },
    {
      "code" : "B7301",
      "display" : "B7301 Oncocercosis con endoftalmitis"
    },
    {
      "code" : "B7302",
      "display" : "B7302 Oncocercosis con glaucoma"
    },
    {
      "code" : "B7309",
      "display" : "B7309 Oncocercosis con otro tipo de afectación ocular"
    },
    {
      "code" : "B74",
      "display" : "B74 Filariasis"
    },
    {
      "code" : "B740",
      "display" : "B740 Filariasis debida a Wuchereria bancrofti"
    },
    {
      "code" : "B741",
      "display" : "B741 Filariasis debida a Brugia malayi"
    },
    {
      "code" : "B743",
      "display" : "B743 Loasis"
    },
    {
      "code" : "B744",
      "display" : "B744 Mansoneliasis"
    },
    {
      "code" : "C7222",
      "display" : "C7222 Neoplasia maligna de nervio olfatorio izquierdo"
    },
    {
      "code" : "C723",
      "display" : "C723 Neoplasia maligna de nervio óptico"
    },
    {
      "code" : "C7230",
      "display" : "C7230 Neoplasia maligna de nervio óptico no especificado"
    },
    {
      "code" : "C7231",
      "display" : "C7231 Neoplasia maligna de nervio óptico derecho"
    },
    {
      "code" : "C7232",
      "display" : "C7232 Neoplasia maligna de nervio óptico izquierdo"
    },
    {
      "code" : "C724",
      "display" : "C724 Neoplasia maligna de nervio acústico"
    },
    {
      "code" : "C7240",
      "display" : "C7240 Neoplasia maligna de nervio acústico no especificado"
    },
    {
      "code" : "C7241",
      "display" : "C7241 Neoplasia maligna de nervio acústico derecho"
    },
    {
      "code" : "C7242",
      "display" : "C7242 Neoplasia maligna de nervio acústico izquierdo"
    },
    {
      "code" : "C725",
      "display" : "C725 Neoplasia maligna de otros nervios craneales y los no especificados"
    },
    {
      "code" : "C7250",
      "display" : "C7250 Neoplasia maligna de nervios craneales no especificados"
    },
    {
      "code" : "C7259",
      "display" : "C7259 Neoplasia maligna de otros nervios craneales"
    },
    {
      "code" : "C729",
      "display" : "C729 Neoplasia maligna de sistema nervioso central no especificado"
    },
    {
      "code" : "C73",
      "display" : "C73 Neoplasia maligna de glándula tiroides"
    },
    {
      "code" : "C74",
      "display" : "C74 Neoplasia maligna de glándula suprarrenal"
    },
    {
      "code" : "C740",
      "display" : "C740 Neoplasia maligna de corteza de glándula suprarrenal"
    },
    {
      "code" : "C7400",
      "display" : "C7400 Neoplasia maligna de corteza de glándula suprarrenal no especificada"
    },
    {
      "code" : "C7401",
      "display" : "C7401 Neoplasia maligna de corteza de glándula suprarrenal derecha"
    },
    {
      "code" : "C7402",
      "display" : "C7402 Neoplasia maligna de corteza de glándula suprarrenal izquierda"
    },
    {
      "code" : "C741",
      "display" : "C741 Neoplasia maligna de médula de glándula suprarrenal"
    },
    {
      "code" : "C7410",
      "display" : "C7410 Neoplasia maligna de médula de glándula suprarrenal no especificada"
    },
    {
      "code" : "C7411",
      "display" : "C7411 Neoplasia maligna de médula de glándula suprarrenal derecha"
    },
    {
      "code" : "C7412",
      "display" : "C7412 Neoplasia maligna de médula de glándula suprarrenal izquierda"
    },
    {
      "code" : "C749",
      "display" : "C749 Neoplasia maligna de parte de glándula suprarrenal no especificada"
    },
    {
      "code" : "C7490",
      "display" : "C7490 Neoplasia maligna de parte no especificada de glándula suprarrenal no especificada"
    },
    {
      "code" : "C7491",
      "display" : "C7491 Neoplasia maligna de parte no especificada de glándula suprarrenal derecha"
    },
    {
      "code" : "C7492",
      "display" : "C7492 Neoplasia maligna de parte no especificada glándula suprarrenal izquierda"
    },
    {
      "code" : "C750",
      "display" : "C750 Neoplasia maligna de glándula paratiroides"
    },
    {
      "code" : "C751",
      "display" : "C751 Neoplasia maligna de hipófisis"
    },
    {
      "code" : "C752",
      "display" : "C752 Neoplasia maligna de conducto craneofaríngeo"
    },
    {
      "code" : "C754",
      "display" : "C754 Neoplasia maligna de cuerpo carotídeo"
    },
    {
      "code" : "C755",
      "display" : "C755 Neoplasia maligna de cuerpo aórtico y otros paraganglios"
    },
    {
      "code" : "C758",
      "display" : "C758 Neoplasia maligna con afectación pluriglandular no especificada"
    },
    {
      "code" : "C7A",
      "display" : "C7A Tumores malignos neuroendocrinos"
    },
    {
      "code" : "C7A0",
      "display" : "C7A0 Tumores carcinoides malignos"
    },
    {
      "code" : "C7A00",
      "display" : "C7A00 Tumor carcinoide maligno de localización no especificada"
    },
    {
      "code" : "C7A010",
      "display" : "C7A010 Tumor carcinoide maligno de duodeno"
    },
    {
      "code" : "C7A011",
      "display" : "C7A011 Tumor carcinoide maligno de yeyuno"
    },
    {
      "code" : "C7A012",
      "display" : "C7A012 Tumor carcinoide maligno de íleon"
    },
    {
      "code" : "C7A019",
      "display" : "C7A019 Tumor carcinoide maligno de intestino delgado segmento no especificado"
    },
    {
      "code" : "C7A02",
      "display" : "C7A02 Tumores carcinoides malignos de apéndice intestino grueso y recto"
    },
    {
      "code" : "C7A020",
      "display" : "C7A020 Tumor carcinoide maligno de apéndice"
    },
    {
      "code" : "C7A022",
      "display" : "C7A022 Tumor carcinoide maligno de colon ascendente"
    },
    {
      "code" : "C7A023",
      "display" : "C7A023 Tumor carcinoide maligno de colon transverso"
    },
    {
      "code" : "C7A024",
      "display" : "C7A024 Tumor carcinoide maligno de colon descendente"
    },
    {
      "code" : "C7A026",
      "display" : "C7A026 Tumor carcinoide maligno de recto"
    },
    {
      "code" : "C7A029",
      "display" : "C7A029 Tumor carcinoide maligno de intestino grueso segmento no especificado"
    },
    {
      "code" : "C7A09",
      "display" : "C7A09 Tumores carcinoides malignos de otras localizaciones"
    },
    {
      "code" : "C7A091",
      "display" : "C7A091 Tumor carcinoide maligno de timo"
    },
    {
      "code" : "C7A092",
      "display" : "C7A092 Tumor carcinoide maligno de estómago"
    },
    {
      "code" : "C7A093",
      "display" : "C7A093 Tumor carcinoide maligno de riñón"
    },
    {
      "code" : "C7A095",
      "display" : "C7A095 Tumor carcinoide maligno de intestino medio no especificado"
    },
    {
      "code" : "C7A096",
      "display" : "C7A096 Tumor carcinoide maligno de intestino posterior no especificado"
    },
    {
      "code" : "D091",
      "display" : "D091 Carcinoma in situ de otros órganos urinarios y los no especificados"
    },
    {
      "code" : "D0910",
      "display" : "D0910 Carcinoma in situ de órgano urinario no especificado"
    },
    {
      "code" : "D0919",
      "display" : "D0919 Carcinoma in situ de otros órganos urinarios"
    },
    {
      "code" : "D092",
      "display" : "D092 Carcinoma in situ de ojo"
    },
    {
      "code" : "D0920",
      "display" : "D0920 Carcinoma in situ de ojo no especificado"
    },
    {
      "code" : "D0921",
      "display" : "D0921 Carcinoma in situ de ojo derecho"
    },
    {
      "code" : "D0922",
      "display" : "D0922 Carcinoma in situ de ojo izquierdo"
    },
    {
      "code" : "D093",
      "display" : "D093 Carcinoma in situ de tiroides y otras glándulas endocrinas"
    },
    {
      "code" : "D098",
      "display" : "D098 Carcinoma in situ de otras localizaciones especificadas"
    },
    {
      "code" : "D099",
      "display" : "D099 Carcinoma in situ localización no especificada"
    },
    {
      "code" : "D10",
      "display" : "D10 Neoplasia benigna de boca y faringe"
    },
    {
      "code" : "D100",
      "display" : "D100 Neoplasia benigna de labio"
    },
    {
      "code" : "D101",
      "display" : "D101 Neoplasia benigna de la lengua"
    },
    {
      "code" : "D102",
      "display" : "D102 Neoplasia benigna de suelo de la boca"
    },
    {
      "code" : "D103",
      "display" : "D103 Neoplasia benigna de otras partes de la boca y las no especificadas"
    },
    {
      "code" : "D1030",
      "display" : "D1030 Neoplasia benigna de parte no especificada de la boca"
    },
    {
      "code" : "D1039",
      "display" : "D1039 Neoplasia benigna de otras partes de la boca"
    },
    {
      "code" : "D104",
      "display" : "D104 Neoplasia benigna de amígdala"
    },
    {
      "code" : "D105",
      "display" : "D105 Neoplasia benigna de otras partes de orofaringe"
    },
    {
      "code" : "D106",
      "display" : "D106 Neoplasia benigna de nasofaringe"
    },
    {
      "code" : "D107",
      "display" : "D107 Neoplasia benigna de hipofaringe"
    },
    {
      "code" : "D109",
      "display" : "D109 Neoplasia benigna de faringe no especificada"
    },
    {
      "code" : "D11",
      "display" : "D11 Neoplasia benigna de glándulas salivales mayores"
    },
    {
      "code" : "D110",
      "display" : "D110 Neoplasia benigna de glándula parótida"
    },
    {
      "code" : "D117",
      "display" : "D117 Neoplasia benigna de otras glándulas salivales mayores"
    },
    {
      "code" : "D119",
      "display" : "D119 Neoplasia benigna de glándula salival mayor no especificada"
    },
    {
      "code" : "D12",
      "display" : "D12 Neoplasia benigna de colon recto ano y canal anal"
    },
    {
      "code" : "D120",
      "display" : "D120 Neoplasia benigna de ciego"
    },
    {
      "code" : "D122",
      "display" : "D122 Neoplasia benigna de colon ascendente"
    },
    {
      "code" : "D123",
      "display" : "D123 Neoplasia benigna de colon transverso"
    },
    {
      "code" : "D125",
      "display" : "D125 Neoplasia benigna de colon sigmoide"
    },
    {
      "code" : "D126",
      "display" : "D126 Neoplasia benigna de colon no especificada"
    },
    {
      "code" : "D127",
      "display" : "D127 Neoplasia benigna de unión rectosigmoidea"
    },
    {
      "code" : "D129",
      "display" : "D129 Neoplasia benigna de ano y canal anal"
    },
    {
      "code" : "D13",
      "display" : "D13 Neoplasia benigna de otras partes de aparato digestivo y las mal definidas"
    },
    {
      "code" : "D131",
      "display" : "D131 Neoplasia benigna de estómago"
    },
    {
      "code" : "D132",
      "display" : "D132 Neoplasia benigna de duodeno"
    },
    {
      "code" : "D133",
      "display" : "D133 Neoplasia benigna de otras partes de intestino delgado y las no especificadas"
    },
    {
      "code" : "D1339",
      "display" : "D1339 Neoplasia benigna de otras partes de intestino delgado"
    },
    {
      "code" : "D134",
      "display" : "D134 Neoplasia benigna de hígado"
    },
    {
      "code" : "D135",
      "display" : "D135 Neoplasia benigna de conductos biliares extrahepáticos"
    },
    {
      "code" : "D137",
      "display" : "D137 Neoplasia benigna de páncreas endocrino"
    },
    {
      "code" : "D139",
      "display" : "D139 Neoplasia benigna de sitios mal definidos dentro de aparato digestivo"
    },
    {
      "code" : "D14",
      "display" : "D14 Neoplasia benigna de oído medio y de aparato respiratorio"
    },
    {
      "code" : "D141",
      "display" : "D141 Neoplasia benigna de laringe"
    },
    {
      "code" : "D142",
      "display" : "D142 Neoplasia benigna de tráquea"
    },
    {
      "code" : "D143",
      "display" : "D143 Neoplasia benigna de bronquio y pulmón"
    },
    {
      "code" : "D1431",
      "display" : "D1431 Neoplasia benigna de bronquio y pulmón derecho"
    },
    {
      "code" : "D1432",
      "display" : "D1432 Neoplasia benigna de bronquio y pulmón izquierdo"
    },
    {
      "code" : "D144",
      "display" : "D144 Neoplasia benigna de aparato respiratorio no especificada"
    },
    {
      "code" : "D15",
      "display" : "D15 Neoplasia benigna de otros órganos intratorácicos y los no especificados"
    },
    {
      "code" : "D151",
      "display" : "D151 Neoplasia benigna de corazón"
    },
    {
      "code" : "D152",
      "display" : "D152 Neoplasia benigna de mediastino"
    },
    {
      "code" : "D159",
      "display" : "D159 Neoplasia benigna de órgano intratorácico no especificado"
    },
    {
      "code" : "D16",
      "display" : "D16 Neoplasia benigna de hueso y cartílago articular"
    },
    {
      "code" : "D160",
      "display" : "D160 Neoplasia benigna de escápula y huesos largos de extremidad superior"
    },
    {
      "code" : "A000",
      "display" : "A000 Cólera debido a Vibrio cholerae 01 biotipo cholerae"
    },
    {
      "code" : "A001",
      "display" : "A001 Cólera debido a Vibrio cholerae 01 biotipo El Tor"
    },
    {
      "code" : "A009",
      "display" : "A009 Cólera no especificado"
    },
    {
      "code" : "A01",
      "display" : "A01 Fiebres tifoidea y paratifoidea"
    },
    {
      "code" : "A010",
      "display" : "A010 Fiebre tifoidea"
    },
    {
      "code" : "A0100",
      "display" : "A0100 Fiebre tifoidea no especificada"
    },
    {
      "code" : "A0101",
      "display" : "A0101 Meningitis tifoidea"
    },
    {
      "code" : "A0102",
      "display" : "A0102 Fiebre tifoidea con afectación cardiaca"
    },
    {
      "code" : "A0103",
      "display" : "A0103 Neumonía tifoidea"
    },
    {
      "code" : "A0104",
      "display" : "A0104 Artritis tifoidea"
    },
    {
      "code" : "A0105",
      "display" : "A0105 Osteomielitis tifoidea"
    },
    {
      "code" : "A0109",
      "display" : "A0109 Fiebre tifoidea con otras complicaciones"
    },
    {
      "code" : "A011",
      "display" : "A011 Fiebre paratifoidea A"
    },
    {
      "code" : "A012",
      "display" : "A012 Fiebre paratifoidea B"
    },
    {
      "code" : "A013",
      "display" : "A013 Fiebre paratifoidea C"
    },
    {
      "code" : "A014",
      "display" : "A014 Fiebre paratifoidea no especificada"
    },
    {
      "code" : "A02",
      "display" : "A02 Otras infecciones debidas a Salmonella"
    },
    {
      "code" : "A020",
      "display" : "A020 Enteritis debida a Salmonella"
    },
    {
      "code" : "A021",
      "display" : "A021 Sepsis debida a Salmonella"
    },
    {
      "code" : "A022",
      "display" : "A022 Infecciones localizadas debidas a Salmonella"
    },
    {
      "code" : "A0220",
      "display" : "A0220 Infecciones localizadas debidas a Salmonella no especificadas"
    },
    {
      "code" : "A0221",
      "display" : "A0221 Meningitis por Salmonella"
    },
    {
      "code" : "A0222",
      "display" : "A0222 Neumonía por Salmonella"
    },
    {
      "code" : "A0223",
      "display" : "A0223 Artritis por Salmonella"
    },
    {
      "code" : "A0225",
      "display" : "A0225 Pielonefritis por Salmonella"
    },
    {
      "code" : "A0229",
      "display" : "A0229 Salmonella con otra infección localizada"
    },
    {
      "code" : "A028",
      "display" : "A028 Otras infecciones especificadas debidas a Salmonella"
    },
    {
      "code" : "A03",
      "display" : "A03 Shigelosis"
    },
    {
      "code" : "A030",
      "display" : "A030 Shigelosis debida a Shigella dysenteriae"
    },
    {
      "code" : "A031",
      "display" : "A031 Shigelosis debida a Shigella flexneri"
    },
    {
      "code" : "A033",
      "display" : "A033 Shigelosis debida a Shigella sonnei"
    },
    {
      "code" : "A038",
      "display" : "A038 Otras shigelosis"
    },
    {
      "code" : "A04",
      "display" : "A04 Otras infecciones intestinales bacterianas"
    },
    {
      "code" : "A040",
      "display" : "A040 Infección debida a Escherichia coli enteropatógena"
    },
    {
      "code" : "A041",
      "display" : "A041 Infección debida a Escherichia coli enterotoxígena"
    },
    {
      "code" : "A043",
      "display" : "A043 Infección debida a Escherichia coli enterohemorrágica"
    },
    {
      "code" : "A044",
      "display" : "A044 Otras infecciones intestinales debidas a Escherichia coli"
    },
    {
      "code" : "A045",
      "display" : "A045 Enteritis debida a Campylobacter"
    },
    {
      "code" : "A047",
      "display" : "A047 Enterocolitis debida a Clostridium difficile"
    },
    {
      "code" : "A0471",
      "display" : "A0471 Enterocolitis debida a Clostridium difficile recurrente"
    },
    {
      "code" : "A0472",
      "display" : "A0472 Enterocolitis debida a Clostridium difficile no especificada como recurrente"
    },
    {
      "code" : "A00",
      "display" : "A00 Cólera"
    },
    {
      "code" : "A049",
      "display" : "A049 Infección intestinal bacteriana no especificada"
    },
    {
      "code" : "A05",
      "display" : "A05 Otras intoxicaciones alimentarias bacterianas no clasificadas bajo otro concepto"
    },
    {
      "code" : "A051",
      "display" : "A051 Intoxicación alimentaria debida a botulismo"
    },
    {
      "code" : "A052",
      "display" : "A052 Intoxicación alimentaria debida a Clostridium perfringens [Clostridium welchii]"
    },
    {
      "code" : "A053",
      "display" : "A053 Intoxicación alimentaria debida a Vibrio parahaemolyticus"
    },
    {
      "code" : "A055",
      "display" : "A055 Intoxicación alimentaria debida a Vibrio vulnificus"
    },
    {
      "code" : "A058",
      "display" : "A058 Otras intoxicaciones alimentarias debidas a bacterias especificadas"
    },
    {
      "code" : "A059",
      "display" : "A059 Intoxicación alimentaria bacteriana no especificada"
    },
    {
      "code" : "A060",
      "display" : "A060 Disentería amebiana aguda"
    },
    {
      "code" : "A061",
      "display" : "A061 Amebiasis intestinal crónica"
    },
    {
      "code" : "A063",
      "display" : "A063 Ameboma intestinal"
    },
    {
      "code" : "A064",
      "display" : "A064 Absceso amebiano del hígado"
    },
    {
      "code" : "A065",
      "display" : "A065 Absceso amebiano del pulmón"
    },
    {
      "code" : "A067",
      "display" : "A067 Amebiasis cutánea"
    },
    {
      "code" : "A068",
      "display" : "A068 Infección amebiana de otras localizaciones"
    },
    {
      "code" : "A0682",
      "display" : "A0682 Otras infecciones genitourinarias amebianas"
    },
    {
      "code" : "A0689",
      "display" : "A0689 Otras infecciones amebianas"
    },
    {
      "code" : "B748",
      "display" : "B748 Otras filariasis"
    },
    {
      "code" : "B749",
      "display" : "B749 Filariasis no especificada"
    },
    {
      "code" : "B75",
      "display" : "B75 Triquinosis"
    },
    {
      "code" : "B76",
      "display" : "B76 Anquilostomiasis"
    },
    {
      "code" : "B760",
      "display" : "B760 Anquilostomiasis"
    },
    {
      "code" : "B761",
      "display" : "B761 Necatoriasis"
    },
    {
      "code" : "B768",
      "display" : "B768 Otras enfermedades anquilostomiasis"
    },
    {
      "code" : "B769",
      "display" : "B769 Anquilostomiasis no especificada"
    },
    {
      "code" : "B77",
      "display" : "B77 Ascariasis"
    },
    {
      "code" : "B770",
      "display" : "B770 Ascariasis con complicaciones intestinales"
    },
    {
      "code" : "B778",
      "display" : "B778 Ascariasis con otras complicaciones"
    },
    {
      "code" : "B7781",
      "display" : "B7781 Neumonía por ascariasis"
    },
    {
      "code" : "B7789",
      "display" : "B7789 Ascariasis con otras complicaciones"
    },
    {
      "code" : "B779",
      "display" : "B779 Ascariasis no especificada"
    },
    {
      "code" : "B78",
      "display" : "B78 Estrongiloidiasis"
    },
    {
      "code" : "B780",
      "display" : "B780 Estrongiloidiasis intestinal"
    },
    {
      "code" : "B781",
      "display" : "B781 Estrongiloidiasis cutánea"
    },
    {
      "code" : "B787",
      "display" : "B787 Estrongiloidiasis diseminada"
    },
    {
      "code" : "B789",
      "display" : "B789 Estrongiloidiasis no especificada"
    },
    {
      "code" : "B79",
      "display" : "B79 Tricuriasis"
    },
    {
      "code" : "B80",
      "display" : "B80 Enterobiasis"
    },
    {
      "code" : "B81",
      "display" : "B81 Otras helmintiasis intestinales no clasificadas bajo otro concepto"
    },
    {
      "code" : "B810",
      "display" : "B810 Anisaquiasis"
    },
    {
      "code" : "B811",
      "display" : "B811 Capilariasis intestinal"
    },
    {
      "code" : "B812",
      "display" : "B812 Tricoestrongiliasis"
    },
    {
      "code" : "B813",
      "display" : "B813 Angiostrongiliasis intestinal"
    },
    {
      "code" : "B814",
      "display" : "B814 Helmintiasis intestinal mixta"
    },
    {
      "code" : "B818",
      "display" : "B818 Otras helmintiasis intestinales especificadas"
    },
    {
      "code" : "B820",
      "display" : "B820 Helmintiasis intestinal no especificada"
    },
    {
      "code" : "B829",
      "display" : "B829 Parasitosis intestinal no especificada"
    },
    {
      "code" : "B830",
      "display" : "B830 Larva migrans visceral"
    },
    {
      "code" : "B831",
      "display" : "B831 Gnatostomiasis"
    },
    {
      "code" : "B833",
      "display" : "B833 Singamiasis"
    },
    {
      "code" : "B834",
      "display" : "B834 Hirudiniasis interna"
    },
    {
      "code" : "B838",
      "display" : "B838 Otras helmintiasis especificadas"
    },
    {
      "code" : "B839",
      "display" : "B839 Helmintiasis no especificada"
    },
    {
      "code" : "B850",
      "display" : "B850 Pediculosis debida a Pediculus humanus capitis"
    },
    {
      "code" : "B851",
      "display" : "B851 Pediculosis debida a Pediculus humanus corporis"
    },
    {
      "code" : "B853",
      "display" : "B853 Ftiriasis"
    },
    {
      "code" : "B854",
      "display" : "B854 Pediculosis y ftiriasis mixtas"
    },
    {
      "code" : "B86",
      "display" : "B86 Escabiosis"
    },
    {
      "code" : "B870",
      "display" : "B870 Miasis cutánea"
    },
    {
      "code" : "B872",
      "display" : "B872 Miasis ocular"
    },
    {
      "code" : "B873",
      "display" : "B873 Miasis nasofaríngea"
    },
    {
      "code" : "B878",
      "display" : "B878 Miasis de otras localizaciones"
    },
    {
      "code" : "B8781",
      "display" : "B8781 Miasis genitourinaria"
    },
    {
      "code" : "B8789",
      "display" : "B8789 Miasis de otras localizaciones"
    },
    {
      "code" : "B879",
      "display" : "B879 Miasis no especificada"
    },
    {
      "code" : "B88",
      "display" : "B88 Otras infestaciones"
    },
    {
      "code" : "B881",
      "display" : "B881 Tungiasis [infestación debida a pulga de arena]"
    },
    {
      "code" : "B882",
      "display" : "B882 Otras infestaciones debidas a artrópodos"
    },
    {
      "code" : "B888",
      "display" : "B888 Otras infestaciones especificadas"
    },
    {
      "code" : "B889",
      "display" : "B889 Infestación no especificada"
    },
    {
      "code" : "B90",
      "display" : "B90 Secuelas de tuberculosis"
    },
    {
      "code" : "B900",
      "display" : "B900 Secuelas de tuberculosis del sistema nervioso central"
    },
    {
      "code" : "B902",
      "display" : "B902 Secuelas de tuberculosis de huesos y articulaciones"
    },
    {
      "code" : "B908",
      "display" : "B908 Secuelas de tuberculosis de otros órganos"
    },
    {
      "code" : "B909",
      "display" : "B909 Secuelas de tuberculosis respiratoria y de tuberculosis no especificada"
    },
    {
      "code" : "B92",
      "display" : "B92 Secuelas de lepra"
    },
    {
      "code" : "B94",
      "display" : "B94 Secuelas de otras enfermedades infecciosas y parasitarias y de las no especificadas"
    },
    {
      "code" : "B941",
      "display" : "B941 Secuelas de encefalitis viral"
    },
    {
      "code" : "B942",
      "display" : "B942 Secuelas de hepatitis viral"
    },
    {
      "code" : "B948",
      "display" : "B948 Secuelas de otras enfermedades infecciosas y parasitarias especificadas"
    },
    {
      "code" : "C7A1",
      "display" : "C7A1 Tumores neuroendocrinos malignos mal diferenciados"
    },
    {
      "code" : "C7A8",
      "display" : "C7A8 Otros tumores neuroendocrinos malignos"
    },
    {
      "code" : "C7B",
      "display" : "C7B Tumores neuroendocrinos secundarios"
    },
    {
      "code" : "C7B0",
      "display" : "C7B0 Tumores carcinoides secundarios"
    },
    {
      "code" : "C7B00",
      "display" : "C7B00 Tumores carcinoides secundarios localización no especificada"
    },
    {
      "code" : "C7B01",
      "display" : "C7B01 Tumores carcinoides secundarios de ganglios linfáticos a distancia"
    },
    {
      "code" : "C7B02",
      "display" : "C7B02 Tumores carcinoides secundarios de hígado"
    },
    {
      "code" : "C7B03",
      "display" : "C7B03 Tumores carcinoides secundarios de hueso"
    },
    {
      "code" : "C7B04",
      "display" : "C7B04 Tumores carcinoides secundarios de peritoneo"
    },
    {
      "code" : "C7B09",
      "display" : "C7B09 Tumores carcinoides secundarios de otras localizaciones"
    },
    {
      "code" : "C7B1",
      "display" : "C7B1 Carcinoma secundario de células de Merkel"
    },
    {
      "code" : "C7B8",
      "display" : "C7B8 Otros tumores neuroendocrinos secundarios"
    },
    {
      "code" : "C76",
      "display" : "C76 Neoplasia maligna de otras localizaciones y las mal definidas"
    },
    {
      "code" : "C760",
      "display" : "C760 Neoplasia maligna de cabeza cara y cuello"
    },
    {
      "code" : "C761",
      "display" : "C761 Neoplasia maligna de tórax"
    },
    {
      "code" : "C762",
      "display" : "C762 Neoplasia maligna de abdomen"
    },
    {
      "code" : "C763",
      "display" : "C763 Neoplasia maligna de pelvis"
    },
    {
      "code" : "C764",
      "display" : "C764 Neoplasia maligna de extremidad superior"
    },
    {
      "code" : "C7640",
      "display" : "C7640 Neoplasia maligna de extremidad superior no especificada"
    },
    {
      "code" : "C7641",
      "display" : "C7641 Neoplasia maligna de extremidad superior derecha"
    },
    {
      "code" : "C7642",
      "display" : "C7642 Neoplasia maligna de extremidad superior izquierda"
    },
    {
      "code" : "C765",
      "display" : "C765 Neoplasia maligna de extremidad inferior"
    },
    {
      "code" : "C7650",
      "display" : "C7650 Neoplasia maligna de extremidad inferior no especificada"
    },
    {
      "code" : "C7651",
      "display" : "C7651 Neoplasia maligna de extremidad inferior derecha"
    },
    {
      "code" : "C7652",
      "display" : "C7652 Neoplasia maligna de extremidad inferior izquierda"
    },
    {
      "code" : "C77",
      "display" : "C77 Neoplasia maligna secundaria y no especificada de ganglios linfáticos"
    },
    {
      "code" : "C770",
      "display" : "C770 Neoplasia maligna secundaria y no especificada de ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C771",
      "display" : "C771 Neoplasia maligna secundaria y no especificada de ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C773",
      "display" : "C773 Neoplasia maligna secundaria y no especificada de ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C774",
      "display" : "C774 Neoplasia maligna secundaria y no especificada de ganglios linfáticos inguinales y de extremidad inferior"
    },
    {
      "code" : "C775",
      "display" : "C775 Neoplasia maligna secundaria y no especificada de ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C778",
      "display" : "C778 Neoplasia maligna secundaria y no especificada de ganglios linfáticos de regiones múltiples"
    },
    {
      "code" : "C779",
      "display" : "C779 Neoplasia maligna secundaria y no especificada de ganglios linfáticos no especificados"
    },
    {
      "code" : "C780",
      "display" : "C780 Neoplasia maligna secundaria de pulmón"
    },
    {
      "code" : "C7800",
      "display" : "C7800 Neoplasia maligna secundaria de pulmón no especificado"
    },
    {
      "code" : "C7801",
      "display" : "C7801 Neoplasia maligna secundaria de pulmón derecho"
    },
    {
      "code" : "C781",
      "display" : "C781 Neoplasia maligna secundaria de mediastino"
    },
    {
      "code" : "C782",
      "display" : "C782 Neoplasia maligna secundaria de pleura"
    },
    {
      "code" : "C783",
      "display" : "C783 Neoplasia maligna secundaria de otros órganos respiratorios y los no especificados"
    },
    {
      "code" : "C7A098",
      "display" : "C7A098 Tumores carcinoides malignos de otras localizaciones"
    },
    {
      "code" : "C7839",
      "display" : "C7839 Neoplasia maligna secundaria de otros órganos respiratorios"
    },
    {
      "code" : "C784",
      "display" : "C784 Neoplasia maligna secundaria de intestino delgado"
    },
    {
      "code" : "C785",
      "display" : "C785 Neoplasia maligna secundaria de intestino grueso y recto"
    },
    {
      "code" : "C787",
      "display" : "C787 Neoplasia maligna secundaria de hígado y vías biliares intrahepáticas"
    },
    {
      "code" : "C788",
      "display" : "C788 Neoplasia maligna secundaria de otros órganos digestivos y los no especificados"
    },
    {
      "code" : "C7880",
      "display" : "C7880 Neoplasia maligna secundaria de órganos digestivos no especificados"
    },
    {
      "code" : "C79",
      "display" : "C79 Neoplasia maligna secundaria de otras localizaciones y las no especificadas"
    },
    {
      "code" : "C790",
      "display" : "C790 Neoplasia maligna secundaria de riñón y pelvis renal"
    },
    {
      "code" : "C7900",
      "display" : "C7900 Neoplasia maligna secundaria de riñón y pelvis renal no especificados"
    },
    {
      "code" : "C7901",
      "display" : "C7901 Neoplasia maligna secundaria de riñón y pelvis renal derechos"
    },
    {
      "code" : "C791",
      "display" : "C791 Neoplasia maligna secundaria de vejiga otros órganos urinarios y los no especificados"
    },
    {
      "code" : "D1600",
      "display" : "D1600 Neoplasia benigna de escápula y huesos largos de extremidad superior no especificada"
    },
    {
      "code" : "D1601",
      "display" : "D1601 Neoplasia benigna de escápula y huesos largos de extremidad superior derecha"
    },
    {
      "code" : "D1602",
      "display" : "D1602 Neoplasia benigna de escápula y huesos largos de extremidad superior izquierda"
    },
    {
      "code" : "D161",
      "display" : "D161 Neoplasia benigna de huesos cortos de extremidad superior"
    },
    {
      "code" : "D1610",
      "display" : "D1610 Neoplasia benigna de huesos cortos de extremidad superior no especificada"
    },
    {
      "code" : "D1611",
      "display" : "D1611 Neoplasia benigna de huesos cortos de extremidad superior derecha"
    },
    {
      "code" : "D1612",
      "display" : "D1612 Neoplasia benigna de huesos cortos de extremidad superior izquierda"
    },
    {
      "code" : "D162",
      "display" : "D162 Neoplasia benigna de huesos largos de extremidad inferior"
    },
    {
      "code" : "D1620",
      "display" : "D1620 Neoplasia benigna de huesos largos de extremidad inferior no especificada"
    },
    {
      "code" : "D1621",
      "display" : "D1621 Neoplasia benigna de huesos largos de extremidad inferior derecha"
    },
    {
      "code" : "D1622",
      "display" : "D1622 Neoplasia benigna de huesos largos de extremidad inferior izquierda"
    },
    {
      "code" : "D163",
      "display" : "D163 Neoplasia benigna de huesos cortos de extremidad inferior"
    },
    {
      "code" : "D1630",
      "display" : "D1630 Neoplasia benigna de huesos cortos de extremidad inferior no especificada"
    },
    {
      "code" : "D1631",
      "display" : "D1631 Neoplasia benigna de huesos cortos de extremidad inferior derecha"
    },
    {
      "code" : "D1632",
      "display" : "D1632 Neoplasia benigna de huesos cortos de extremidad inferior izquierda"
    },
    {
      "code" : "D164",
      "display" : "D164 Neoplasia benigna de huesos de cráneo y cara"
    },
    {
      "code" : "D165",
      "display" : "D165 Neoplasia benigna de hueso maxilar inferior"
    },
    {
      "code" : "D166",
      "display" : "D166 Neoplasia benigna de columna vertebral"
    },
    {
      "code" : "D167",
      "display" : "D167 Neoplasia benigna de costillas esternón y clavícula"
    },
    {
      "code" : "D168",
      "display" : "D168 Neoplasia benigna de huesos de pelvis sacro y cóccix"
    },
    {
      "code" : "D169",
      "display" : "D169 Neoplasia benigna de hueso y de cartílago articular no especificado"
    },
    {
      "code" : "D17",
      "display" : "D17 Neoplasia lipomatosa benigna"
    },
    {
      "code" : "D170",
      "display" : "D170 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de cabeza cara y cuello"
    },
    {
      "code" : "D171",
      "display" : "D171 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de tronco"
    },
    {
      "code" : "D172",
      "display" : "D172 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de extremidad"
    },
    {
      "code" : "D1720",
      "display" : "D1720 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de extremidad no especificada"
    },
    {
      "code" : "D1721",
      "display" : "D1721 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de brazo derecho"
    },
    {
      "code" : "D1723",
      "display" : "D1723 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de pierna derecha"
    },
    {
      "code" : "D1724",
      "display" : "D1724 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de pierna izquierda"
    },
    {
      "code" : "D173",
      "display" : "D173 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de otras localizaciones y las no especificadas"
    },
    {
      "code" : "D1730",
      "display" : "D1730 Neoplasia lipomatosa benigna de piel y tejido subcutáneo de localizaciones no especificadas"
    },
    {
      "code" : "D174",
      "display" : "D174 Neoplasia lipomatosa benigna de órganos intratorácicos"
    },
    {
      "code" : "D175",
      "display" : "D175 Neoplasia lipomatosa benigna de órganos intraabdominales"
    },
    {
      "code" : "D176",
      "display" : "D176 Neoplasia lipomatosa benigna de cordón espermático"
    },
    {
      "code" : "D177",
      "display" : "D177 Neoplasia lipomatosa benigna de otras localizaciones"
    },
    {
      "code" : "D1772",
      "display" : "D1772 Neoplasia lipomatosa benigna de otro órgano genitourinario"
    },
    {
      "code" : "D1779",
      "display" : "D1779 Neoplasia lipomatosa benigna de otros sitios"
    },
    {
      "code" : "D179",
      "display" : "D179 Neoplasia lipomatosa benigna no especificada"
    },
    {
      "code" : "D180",
      "display" : "D180 Hemangioma"
    },
    {
      "code" : "D1800",
      "display" : "D1800 Hemangioma de localización no especificada"
    },
    {
      "code" : "D1801",
      "display" : "D1801 Hemangioma de piel y de tejido subcutáneo"
    },
    {
      "code" : "D1803",
      "display" : "D1803 Hemangioma de estructuras intraabdominales"
    },
    {
      "code" : "D1809",
      "display" : "D1809 Hemangioma de otras localizaciones"
    },
    {
      "code" : "D181",
      "display" : "D181 Linfangioma de cualquier localización"
    },
    {
      "code" : "D190",
      "display" : "D190 Neoplasia benigna de tejido mesotelial de pleura"
    },
    {
      "code" : "D191",
      "display" : "D191 Neoplasia benigna de tejido mesotelial de peritoneo"
    },
    {
      "code" : "D197",
      "display" : "D197 Neoplasia benigna de tejido mesotelial de otras localizaciones"
    },
    {
      "code" : "D20",
      "display" : "D20 Neoplasia benigna de tejidos blandos de retroperitoneo y peritoneo"
    },
    {
      "code" : "D200",
      "display" : "D200 Neoplasia benigna de tejidos blandos de retroperitoneo"
    },
    {
      "code" : "D201",
      "display" : "D201 Neoplasia benigna de tejidos blandos de peritoneo"
    },
    {
      "code" : "A07",
      "display" : "A07 Otras enfermedades intestinales debidas a protozoos"
    },
    {
      "code" : "A070",
      "display" : "A070 Balantidiasis"
    },
    {
      "code" : "A071",
      "display" : "A071 Giardiasis [lambliasis]"
    },
    {
      "code" : "A072",
      "display" : "A072 Criptosporidiosis"
    },
    {
      "code" : "A073",
      "display" : "A073 Isosporiasis"
    },
    {
      "code" : "A074",
      "display" : "A074 Ciclosporosis"
    },
    {
      "code" : "A078",
      "display" : "A078 Otras enfermedades intestinales especificadas debidas a protozoos"
    },
    {
      "code" : "A079",
      "display" : "A079 Enfermedad intestinal debida a protozoos no especificada"
    },
    {
      "code" : "A08",
      "display" : "A08 Infecciones intestinales debidas a virus y otros organismos especificados"
    },
    {
      "code" : "A080",
      "display" : "A080 Enteritis debida a rotavirus"
    },
    {
      "code" : "A081",
      "display" : "A081 Gastroenteropatía aguda debida al agente de Norwalk y a otros virus redondos pequeños"
    },
    {
      "code" : "A0811",
      "display" : "A0811 Gastroenteropatía aguda debida al agente de Norwalk"
    },
    {
      "code" : "A0819",
      "display" : "A0819 Gastroenteropatía aguda por otros virus pequeños redondos"
    },
    {
      "code" : "A082",
      "display" : "A082 Enteritis debida a adenovirus"
    },
    {
      "code" : "A083",
      "display" : "A083 Otras enteritis virales"
    },
    {
      "code" : "A0831",
      "display" : "A0831 Enteritis por calicivirus"
    },
    {
      "code" : "A0832",
      "display" : "A0832 Enteritis por astrovirus"
    },
    {
      "code" : "A0839",
      "display" : "A0839 Otras enteritis virales"
    },
    {
      "code" : "A084",
      "display" : "A084 Infección intestinal viral no especificada"
    },
    {
      "code" : "A088",
      "display" : "A088 Otras infecciones intestinales especificadas"
    },
    {
      "code" : "A09",
      "display" : "A09 Gastroenteritis y colitis infecciosas no especificadas"
    },
    {
      "code" : "A15",
      "display" : "A15 Tuberculosis respiratoria"
    },
    {
      "code" : "A150",
      "display" : "A150 Tuberculosis del pulmón"
    },
    {
      "code" : "A154",
      "display" : "A154 Tuberculosis de ganglios linfáticos intratorácicos"
    },
    {
      "code" : "A155",
      "display" : "A155 Tuberculosis de laringe tráquea y bronquios"
    },
    {
      "code" : "A156",
      "display" : "A156 Pleuritis tuberculosa"
    },
    {
      "code" : "A157",
      "display" : "A157 Tuberculosis respiratoria primaria"
    },
    {
      "code" : "A159",
      "display" : "A159 Tuberculosis respiratoria no especificada"
    },
    {
      "code" : "A17",
      "display" : "A17 Tuberculosis del sistema nervioso"
    },
    {
      "code" : "A171",
      "display" : "A171 Tuberculoma meníngeo"
    },
    {
      "code" : "A178",
      "display" : "A178 Otras tuberculosis del sistema nervioso"
    },
    {
      "code" : "A1782",
      "display" : "A1782 Meningoencefalitis tuberculosa"
    },
    {
      "code" : "A1783",
      "display" : "A1783 Neuritis tuberculosa"
    },
    {
      "code" : "A1789",
      "display" : "A1789 Otras tuberculosis del sistema nervioso"
    },
    {
      "code" : "A18",
      "display" : "A18 Tuberculosis de otros órganos"
    },
    {
      "code" : "A180",
      "display" : "A180 Tuberculosis de huesos y articulaciones"
    },
    {
      "code" : "A1801",
      "display" : "A1801 Tuberculosis de columna"
    },
    {
      "code" : "A1803",
      "display" : "A1803 Tuberculosis de otros huesos"
    },
    {
      "code" : "A1809",
      "display" : "A1809 Otras tuberculosis musculoesqueléticas"
    },
    {
      "code" : "A181",
      "display" : "A181 Tuberculosis del aparato genitourinario"
    },
    {
      "code" : "A1811",
      "display" : "A1811 Tuberculosis del riñón y del uréter"
    },
    {
      "code" : "A1812",
      "display" : "A1812 Tuberculosis de vejiga"
    },
    {
      "code" : "A1813",
      "display" : "A1813 Tuberculosis de otros órganos urinarios"
    },
    {
      "code" : "A069",
      "display" : "A069 Amebiasis no especificada"
    },
    {
      "code" : "A1815",
      "display" : "A1815 Tuberculosis de otros órganos genitales masculinos"
    },
    {
      "code" : "A1816",
      "display" : "A1816 Tuberculosis del cuello uterino"
    },
    {
      "code" : "A1818",
      "display" : "A1818 Tuberculosis de otros órganos genitales femeninos"
    },
    {
      "code" : "A182",
      "display" : "A182 Linfadenopatía periférica tuberculosa"
    },
    {
      "code" : "A183",
      "display" : "A183 Tuberculosis de intestino peritoneo y ganglios mesentéricos"
    },
    {
      "code" : "A1832",
      "display" : "A1832 Enteritis tuberculosa"
    },
    {
      "code" : "A1839",
      "display" : "A1839 Tuberculosis retroperitoneal"
    },
    {
      "code" : "A185",
      "display" : "A185 Tuberculosis del ojo"
    },
    {
      "code" : "A1850",
      "display" : "A1850 Tuberculosis del ojo no especificada"
    },
    {
      "code" : "A1851",
      "display" : "A1851 Epiescleritis tuberculosa"
    },
    {
      "code" : "A1853",
      "display" : "A1853 Coriorretinitis tuberculosa"
    },
    {
      "code" : "A1854",
      "display" : "A1854 Iridociclitis tuberculosa"
    },
    {
      "code" : "A1859",
      "display" : "A1859 Otras tuberculosis del ojo"
    },
    {
      "code" : "A187",
      "display" : "A187 Tuberculosis de las glándulas suprarrenales"
    },
    {
      "code" : "A188",
      "display" : "A188 Tuberculosis de otros órganos especificados"
    },
    {
      "code" : "B949",
      "display" : "B949 Secuelas de enfermedades infecciosas y parasitarias no especificadas"
    },
    {
      "code" : "B95",
      "display" : "B95 Streptococcus Staphylococcus y Enterococos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B950",
      "display" : "B950 Estreptococo grupo A como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B951",
      "display" : "B951 Estreptococo grupo B como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B952",
      "display" : "B952 Enterococos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B953",
      "display" : "B953 Streptococcus pneumoniae como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B954",
      "display" : "B954 Otros estreptococos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B955",
      "display" : "B955 Estreptococo no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B956",
      "display" : "B956 Staphylococcus aureus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9561",
      "display" : "B9561 Infección por Staphylococcus aureus sensible a meticilina como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9562",
      "display" : "B9562 Infección por Staphylococcus aureus resistente a meticilina como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B957",
      "display" : "B957 Otros estafilococos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B958",
      "display" : "B958 Estafilococo no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B96",
      "display" : "B96 Otros agentes bacterianos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B960",
      "display" : "B960 Mycoplasma pneumoniae [M. pneumoniae] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B961",
      "display" : "B961 Klebsiella pneumoniae [K. pneumoniae] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B962",
      "display" : "B962 Escherichia coli [E. coli] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9620",
      "display" : "B9620 Escherichia coli [E. coli] no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9621",
      "display" : "B9621 Escherichia coli [E. coli] [STEC] O157 productor de toxina Shiga como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9622",
      "display" : "B9622 Otro Escherichia coli [E. coli] [STEC] productor de toxina Shiga especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9623",
      "display" : "B9623 Escherichia coli [E. coli] [STEC] productor de toxina Shiga no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9629",
      "display" : "B9629 Otro Escherichia coli [E. coli] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B963",
      "display" : "B963 Haemophilus influenzae [H. influenzae] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B964",
      "display" : "B964 Proteus (mirabilis) (morganii) como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B965",
      "display" : "B965 Pseudomonas (aeruginosa) (mallei) (pseudomallei) como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B966",
      "display" : "B966 Bacteroides fragilis [B. fragilis] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B968",
      "display" : "B968 Otros agentes bacterianos especificados como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9681",
      "display" : "B9681 Helicobacter pylori [H. pylori] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9682",
      "display" : "B9682 Vibrio vulnificus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9689",
      "display" : "B9689 Otros agentes bacterianos como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B970",
      "display" : "B970 Adenovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B971",
      "display" : "B971 Enterovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9710",
      "display" : "B9710 Enterovirus no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9711",
      "display" : "B9711 Coxsackievirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9719",
      "display" : "B9719 Otros enterovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B972",
      "display" : "B972 Coronavirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9721",
      "display" : "B9721 Coronavirus asociado al SARS como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9729",
      "display" : "B9729 Otros coronavirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9730",
      "display" : "B9730 Retrovirus no especificado como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9731",
      "display" : "B9731 Lentivirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9732",
      "display" : "B9732 Oncovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9733",
      "display" : "B9733 Virus linfotrópico humano de células T de tipo I [HTLV-I] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "C7910",
      "display" : "C7910 Neoplasia maligna secundaria de órganos urinarios no especificados"
    },
    {
      "code" : "C7911",
      "display" : "C7911 Neoplasia maligna secundaria de vejiga"
    },
    {
      "code" : "C7919",
      "display" : "C7919 Neoplasia maligna secundaria de otros órganos urinarios"
    },
    {
      "code" : "C792",
      "display" : "C792 Neoplasia maligna secundaria de piel"
    },
    {
      "code" : "C793",
      "display" : "C793 Neoplasia maligna secundaria de cerebro y meninges cerebrales"
    },
    {
      "code" : "C7931",
      "display" : "C7931 Neoplasia maligna secundaria de cerebro"
    },
    {
      "code" : "C7932",
      "display" : "C7932 Neoplasia maligna secundaria de meninges cerebrales"
    },
    {
      "code" : "C794",
      "display" : "C794 Neoplasia maligna secundaria de otras partes del sistema nervioso y las no especificadas"
    },
    {
      "code" : "C7940",
      "display" : "C7940 Neoplasia maligna secundaria de parte no especificada del sistema nervioso"
    },
    {
      "code" : "C7949",
      "display" : "C7949 Neoplasia maligna secundaria de otras partes del sistema nervioso"
    },
    {
      "code" : "C795",
      "display" : "C795 Neoplasia maligna secundaria de hueso y médula ósea"
    },
    {
      "code" : "C7951",
      "display" : "C7951 Neoplasia maligna secundaria de hueso"
    },
    {
      "code" : "C7952",
      "display" : "C7952 Neoplasia maligna secundaria de médula ósea"
    },
    {
      "code" : "C796",
      "display" : "C796 Neoplasia maligna secundaria de ovario"
    },
    {
      "code" : "C7960",
      "display" : "C7960 Neoplasia maligna secundaria de ovario no especificado"
    },
    {
      "code" : "C7961",
      "display" : "C7961 Neoplasia maligna secundaria de ovario derecho"
    },
    {
      "code" : "C7962",
      "display" : "C7962 Neoplasia maligna secundaria de ovario izquierdo"
    },
    {
      "code" : "C7963",
      "display" : "C7963 Neoplasia maligna secundaria bilateral de ovarios"
    },
    {
      "code" : "C797",
      "display" : "C797 Neoplasia maligna secundaria de glándula suprarrenal"
    },
    {
      "code" : "C7970",
      "display" : "C7970 Neoplasia maligna secundaria de glándula suprarrenal no especificada"
    },
    {
      "code" : "C7971",
      "display" : "C7971 Neoplasia maligna secundaria de glándula suprarrenal derecha"
    },
    {
      "code" : "C7972",
      "display" : "C7972 Neoplasia maligna secundaria de glándula suprarrenal izquierda"
    },
    {
      "code" : "C798",
      "display" : "C798 Neoplasia maligna secundaria de otras localizaciones especificadas"
    },
    {
      "code" : "C7981",
      "display" : "C7981 Neoplasia maligna secundaria de mama"
    },
    {
      "code" : "C7982",
      "display" : "C7982 Neoplasia maligna secundaria de órganos genitales"
    },
    {
      "code" : "C7989",
      "display" : "C7989 Neoplasia maligna secundaria de otras localizaciones especificadas"
    },
    {
      "code" : "C799",
      "display" : "C799 Neoplasia maligna secundaria de localización no especificada"
    },
    {
      "code" : "C80",
      "display" : "C80 Neoplasia maligna de localización no especificada"
    },
    {
      "code" : "C801",
      "display" : "C801 Neoplasia maligna (primaria) no especificada"
    },
    {
      "code" : "C802",
      "display" : "C802 Neoplasia maligna asociada a órgano trasplantado"
    },
    {
      "code" : "C810",
      "display" : "C810 Linfoma de Hodgkin de predominio linfocítico nodular"
    },
    {
      "code" : "C8100",
      "display" : "C8100 Linfoma de Hodgkin de predominio linfocítico nodular localización no especificada"
    },
    {
      "code" : "C8101",
      "display" : "C8101 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8103",
      "display" : "C8103 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8104",
      "display" : "C8104 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8105",
      "display" : "C8105 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8106",
      "display" : "C8106 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8108",
      "display" : "C8108 Linfoma de Hodgkin de predominio linfocítico nodular ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8109",
      "display" : "C8109 Linfoma de Hodgkin de predominio linfocítico nodular localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C811",
      "display" : "C811 Linfoma de Hodgkin tipo esclerosis nodular"
    },
    {
      "code" : "C8111",
      "display" : "C8111 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8112",
      "display" : "C8112 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8113",
      "display" : "C8113 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8114",
      "display" : "C8114 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8116",
      "display" : "C8116 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8117",
      "display" : "C8117 Linfoma de Hodgkin tipo esclerosis nodular bazo"
    },
    {
      "code" : "C8118",
      "display" : "C8118 Linfoma de Hodgkin tipo esclerosis nodular ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8119",
      "display" : "C8119 Linfoma de Hodgkin tipo esclerosis nodular localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C812",
      "display" : "C812 Linfoma de Hodgkin de celularidad mixta"
    },
    {
      "code" : "D210",
      "display" : "D210 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de cabeza cara y cuello"
    },
    {
      "code" : "D211",
      "display" : "D211 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad superior incluyendo hombro"
    },
    {
      "code" : "D2110",
      "display" : "D2110 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "D2111",
      "display" : "D2111 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "D2112",
      "display" : "D2112 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "D212",
      "display" : "D212 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "D2120",
      "display" : "D2120 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "D2121",
      "display" : "D2121 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "D2122",
      "display" : "D2122 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "D213",
      "display" : "D213 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de tórax"
    },
    {
      "code" : "D214",
      "display" : "D214 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de abdomen"
    },
    {
      "code" : "D215",
      "display" : "D215 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de pelvis"
    },
    {
      "code" : "D216",
      "display" : "D216 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos de tronco no especificados"
    },
    {
      "code" : "D219",
      "display" : "D219 Neoplasia benigna de tejido conjuntivo y otros tejidos blandos no especificados"
    },
    {
      "code" : "D22",
      "display" : "D22 Nevus melanocítico"
    },
    {
      "code" : "D220",
      "display" : "D220 Nevus melanocítico de labio"
    },
    {
      "code" : "D221",
      "display" : "D221 Nevus melanocítico de párpado incluyendo canto"
    },
    {
      "code" : "D2210",
      "display" : "D2210 Nevus melanocítico de párpado no especificado incluyendo canto"
    },
    {
      "code" : "D2211",
      "display" : "D2211 Nevus melanocítico de párpado derecho incluyendo canto"
    },
    {
      "code" : "D22111",
      "display" : "D22111 Nevus melanocítico de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "D22112",
      "display" : "D22112 Nevus melanocítico de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "D2212",
      "display" : "D2212 Nevus melanocítico de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "D22121",
      "display" : "D22121 Nevus melanocítico de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "D22122",
      "display" : "D22122 Nevus melanocítico de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "D222",
      "display" : "D222 Nevus melanocítico de oído y conducto auditivo externo"
    },
    {
      "code" : "D2220",
      "display" : "D2220 Nevus melanocítico de oído y conducto auditivo externo no especificado"
    },
    {
      "code" : "D2221",
      "display" : "D2221 Nevus melanocítico de oído y conducto auditivo externo derecho"
    },
    {
      "code" : "D223",
      "display" : "D223 Nevus melanocítico de otras partes de la cara y las no especificadas"
    },
    {
      "code" : "D2230",
      "display" : "D2230 Nevus melanocítico de parte no especificada de la cara"
    },
    {
      "code" : "D2239",
      "display" : "D2239 Nevus melanocítico de otras partes de la cara"
    },
    {
      "code" : "D225",
      "display" : "D225 Nevus melanocítico de tronco"
    },
    {
      "code" : "D226",
      "display" : "D226 Nevus melanocítico de extremidad superior incluyendo hombro"
    },
    {
      "code" : "D2260",
      "display" : "D2260 Nevus melanocítico de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "D2262",
      "display" : "D2262 Nevus melanocítico de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "D227",
      "display" : "D227 Nevus melanocítico de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "D2270",
      "display" : "D2270 Nevus melanocítico de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "D2271",
      "display" : "D2271 Nevus melanocítico de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "D229",
      "display" : "D229 Nevus melanocítico no especificado"
    },
    {
      "code" : "D23",
      "display" : "D23 Otras neoplasias benignas de piel"
    },
    {
      "code" : "D230",
      "display" : "D230 Otras neoplasias benignas de piel de labio"
    },
    {
      "code" : "D231",
      "display" : "D231 Otras neoplasias benignas de piel de párpado incluyendo canto"
    },
    {
      "code" : "D2311",
      "display" : "D2311 Otras neoplasias benignas de piel de párpado derecho incluyendo canto"
    },
    {
      "code" : "D23111",
      "display" : "D23111 Otras neoplasias benignas de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "D23112",
      "display" : "D23112 Otras neoplasias benignas de piel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "D2312",
      "display" : "D2312 Otras neoplasias benignas de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "D23122",
      "display" : "D23122 Otras neoplasias benignas de piel de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "D232",
      "display" : "D232 Otras neoplasias benignas de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "A1882",
      "display" : "A1882 Tuberculosis de otras glándulas endocrinas"
    },
    {
      "code" : "A1883",
      "display" : "A1883 Tuberculosis de órganos del tracto digestivo no clasificadas bajo otro concepto"
    },
    {
      "code" : "A1884",
      "display" : "A1884 Tuberculosis cardíaca"
    },
    {
      "code" : "A1885",
      "display" : "A1885 Tuberculosis esplénica"
    },
    {
      "code" : "A1889",
      "display" : "A1889 Tuberculosis de otras localizaciones"
    },
    {
      "code" : "A19",
      "display" : "A19 Tuberculosis miliar"
    },
    {
      "code" : "A190",
      "display" : "A190 Tuberculosis miliar aguda de un solo sitio especificado"
    },
    {
      "code" : "A191",
      "display" : "A191 Tuberculosis miliar aguda de sitios múltiples"
    },
    {
      "code" : "A192",
      "display" : "A192 Tuberculosis miliar aguda no especificada"
    },
    {
      "code" : "A198",
      "display" : "A198 Otras tuberculosis miliares"
    },
    {
      "code" : "A199",
      "display" : "A199 Tuberculosis miliar no especificada"
    },
    {
      "code" : "A20",
      "display" : "A20 Peste"
    },
    {
      "code" : "A200",
      "display" : "A200 Peste bubónica"
    },
    {
      "code" : "A201",
      "display" : "A201 Peste celulocutánea"
    },
    {
      "code" : "A202",
      "display" : "A202 Peste neumónica"
    },
    {
      "code" : "A203",
      "display" : "A203 Meningitis por peste"
    },
    {
      "code" : "A207",
      "display" : "A207 Peste septicémica"
    },
    {
      "code" : "A208",
      "display" : "A208 Otras formas de peste"
    },
    {
      "code" : "A209",
      "display" : "A209 Peste no especificada"
    },
    {
      "code" : "A21",
      "display" : "A21 Tularemia"
    },
    {
      "code" : "A210",
      "display" : "A210 Tularemia ulceroglandular"
    },
    {
      "code" : "A211",
      "display" : "A211 Tularemia oculoglandular"
    },
    {
      "code" : "A212",
      "display" : "A212 Tularemia pulmonar"
    },
    {
      "code" : "A213",
      "display" : "A213 Tularemia gastrointestinal"
    },
    {
      "code" : "A218",
      "display" : "A218 Otras formas de tularemia"
    },
    {
      "code" : "A219",
      "display" : "A219 Tularemia no especificada"
    },
    {
      "code" : "A22",
      "display" : "A22 Carbunco [ántrax]"
    },
    {
      "code" : "A221",
      "display" : "A221 Carbunco pulmonar"
    },
    {
      "code" : "A222",
      "display" : "A222 Carbunco gastrointestinal"
    },
    {
      "code" : "A228",
      "display" : "A228 Otras formas de carbunco"
    },
    {
      "code" : "A229",
      "display" : "A229 Carbunco no especificado"
    },
    {
      "code" : "A230",
      "display" : "A230 Brucelosis debida a Brucella melitensis"
    },
    {
      "code" : "A231",
      "display" : "A231 Brucelosis debida a Brucella abortus"
    },
    {
      "code" : "A233",
      "display" : "A233 Brucelosis debida a Brucella canis"
    },
    {
      "code" : "A238",
      "display" : "A238 Otras brucelosis"
    },
    {
      "code" : "A24",
      "display" : "A24 Muermo y melioidosis"
    },
    {
      "code" : "A240",
      "display" : "A240 Muermo"
    },
    {
      "code" : "A241",
      "display" : "A241 Melioidosis aguda y fulminante"
    },
    {
      "code" : "A243",
      "display" : "A243 Otras melioidosis"
    },
    {
      "code" : "A249",
      "display" : "A249 Melioidosis no especificada"
    },
    {
      "code" : "A250",
      "display" : "A250 Espirilosis"
    },
    {
      "code" : "A251",
      "display" : "A251 Estreptobacilosis"
    },
    {
      "code" : "A259",
      "display" : "A259 Fiebre por mordedura de rata no especificada"
    },
    {
      "code" : "A260",
      "display" : "A260 Erisipeloide cutáneo"
    },
    {
      "code" : "A267",
      "display" : "A267 Sepsis por Erysipelothrix"
    },
    {
      "code" : "A269",
      "display" : "A269 Erisipeloide no especificada"
    },
    {
      "code" : "A27",
      "display" : "A27 Leptospirosis"
    },
    {
      "code" : "A278",
      "display" : "A278 Otras formas de leptospirosis"
    },
    {
      "code" : "A2781",
      "display" : "A2781 Meningitis aséptica en leptospirosis"
    },
    {
      "code" : "A2789",
      "display" : "A2789 Otras formas de leptospirosis"
    },
    {
      "code" : "A28",
      "display" : "A28 Otras enfermedades bacterianas zoonóticas no clasificadas bajo otro concepto"
    },
    {
      "code" : "A280",
      "display" : "A280 Pasteurelosis"
    },
    {
      "code" : "A282",
      "display" : "A282 Yersiniosis extraintestinal"
    },
    {
      "code" : "A288",
      "display" : "A288 Otras enfermedades bacterianas zoonóticas especificadas no clasificadas bajo otro concepto"
    },
    {
      "code" : "A289",
      "display" : "A289 Enfermedad bacteriana zoonótica no especificada"
    },
    {
      "code" : "A300",
      "display" : "A300 Lepra indeterminada"
    },
    {
      "code" : "A301",
      "display" : "A301 Lepra tuberculoide"
    },
    {
      "code" : "A303",
      "display" : "A303 Lepra limítrofe"
    },
    {
      "code" : "A304",
      "display" : "A304 Lepra lepromatosa limítrofe"
    },
    {
      "code" : "A308",
      "display" : "A308 Otras formas de lepra"
    },
    {
      "code" : "A309",
      "display" : "A309 Lepra no especificada"
    },
    {
      "code" : "A310",
      "display" : "A310 Infección por micobacterias pulmonares"
    },
    {
      "code" : "A311",
      "display" : "A311 Infección cutánea por micobacterias"
    },
    {
      "code" : "B9735",
      "display" : "B9735 Virus de inmunodeficiencia humana tipo 2 [VIH-2] como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9739",
      "display" : "B9739 Otros retrovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B974",
      "display" : "B974 Virus sincitial respiratorio como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B975",
      "display" : "B975 Reovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B976",
      "display" : "B976 Parvovirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B977",
      "display" : "B977 Papilomavirus como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B978",
      "display" : "B978 Otros agentes virales como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9781",
      "display" : "B9781 Metaneumovirus humano como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B9789",
      "display" : "B9789 Otros agentes virales como causa de enfermedades clasificadas bajo otro concepto"
    },
    {
      "code" : "B99",
      "display" : "B99 Otras enfermedades infecciosas y las no especificadas"
    },
    {
      "code" : "B998",
      "display" : "B998 Otras enfermedades infecciosas"
    },
    {
      "code" : "B999",
      "display" : "B999 Enfermedad infecciosa no especificada"
    },
    {
      "code" : "C00",
      "display" : "C00 Neoplasia maligna de labio"
    },
    {
      "code" : "C000",
      "display" : "C000 Neoplasia maligna de labio superior cara externa"
    },
    {
      "code" : "C001",
      "display" : "C001 Neoplasia maligna de labio inferior cara externa"
    },
    {
      "code" : "C002",
      "display" : "C002 Neoplasia maligna de labio no especificado cara externa"
    },
    {
      "code" : "C003",
      "display" : "C003 Neoplasia maligna de labio superior cara interna"
    },
    {
      "code" : "C004",
      "display" : "C004 Neoplasia maligna de labio inferior cara interna"
    },
    {
      "code" : "C005",
      "display" : "C005 Neoplasia maligna de labio no especificado cara interior"
    },
    {
      "code" : "C006",
      "display" : "C006 Neoplasia maligna de comisura de labio no especificada"
    },
    {
      "code" : "C008",
      "display" : "C008 Neoplasia maligna de localizaciones contiguas de labio"
    },
    {
      "code" : "C009",
      "display" : "C009 Neoplasia maligna de labio no especificada"
    },
    {
      "code" : "C01",
      "display" : "C01 Neoplasia maligna de base de la lengua"
    },
    {
      "code" : "C02",
      "display" : "C02 Neoplasia maligna de otras partes de la lengua y de las no especificadas"
    },
    {
      "code" : "C020",
      "display" : "C020 Neoplasia maligna de superficie dorsal de la lengua"
    },
    {
      "code" : "C021",
      "display" : "C021 Neoplasia maligna de borde de la lengua"
    },
    {
      "code" : "C023",
      "display" : "C023 Neoplasia maligna de dos tercios anteriores de la lengua parte no especificada"
    },
    {
      "code" : "C024",
      "display" : "C024 Neoplasia maligna de amígdala lingual"
    },
    {
      "code" : "C028",
      "display" : "C028 Neoplasia maligna de localizaciones contiguas de la lengua"
    },
    {
      "code" : "C03",
      "display" : "C03 Neoplasia maligna de encía"
    },
    {
      "code" : "C030",
      "display" : "C030 Neoplasia maligna de encía superior"
    },
    {
      "code" : "C031",
      "display" : "C031 Neoplasia maligna de encía inferior"
    },
    {
      "code" : "C04",
      "display" : "C04 Neoplasia maligna de suelo de la boca"
    },
    {
      "code" : "C040",
      "display" : "C040 Neoplasia maligna de suelo de la boca parte anterior"
    },
    {
      "code" : "C041",
      "display" : "C041 Neoplasia maligna de suelo de la boca parte lateral"
    },
    {
      "code" : "C049",
      "display" : "C049 Neoplasia maligna de suelo de la boca no especificada"
    },
    {
      "code" : "C05",
      "display" : "C05 Neoplasia maligna del paladar"
    },
    {
      "code" : "C050",
      "display" : "C050 Neoplasia maligna de paladar duro"
    },
    {
      "code" : "C052",
      "display" : "C052 Neoplasia maligna de úvula"
    },
    {
      "code" : "C058",
      "display" : "C058 Neoplasia maligna de localizaciones contiguas de paladar"
    },
    {
      "code" : "C059",
      "display" : "C059 Neoplasia maligna de paladar no especificada"
    },
    {
      "code" : "C060",
      "display" : "C060 Neoplasia maligna de mucosa de la mejilla"
    },
    {
      "code" : "C061",
      "display" : "C061 Neoplasia maligna de vestíbulo de la boca"
    },
    {
      "code" : "C062",
      "display" : "C062 Neoplasia maligna de área retromolar"
    },
    {
      "code" : "C068",
      "display" : "C068 Neoplasia maligna de localizaciones contiguas de otras partes de la boca y de las no especificadas"
    },
    {
      "code" : "C0689",
      "display" : "C0689 Neoplasia maligna de localizaciones contiguas de otras partes de la boca"
    },
    {
      "code" : "C069",
      "display" : "C069 Neoplasia maligna de boca no especificada"
    },
    {
      "code" : "C07",
      "display" : "C07 Neoplasia maligna de glándula parótida"
    },
    {
      "code" : "C08",
      "display" : "C08 Neoplasia maligna de otras glándulas salivales mayores y las no especificadas"
    },
    {
      "code" : "C081",
      "display" : "C081 Neoplasia maligna de glándula sublingual"
    },
    {
      "code" : "C089",
      "display" : "C089 Neoplasia maligna de glándula salival mayor no especificada"
    },
    {
      "code" : "C09",
      "display" : "C09 Neoplasia maligna de amígdala"
    },
    {
      "code" : "C091",
      "display" : "C091 Neoplasia maligna de pilar amigdalino (anterior) (posterior)"
    },
    {
      "code" : "C8120",
      "display" : "C8120 Linfoma de Hodgkin de celularidad mixta localización no especificada"
    },
    {
      "code" : "C8121",
      "display" : "C8121 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8122",
      "display" : "C8122 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8123",
      "display" : "C8123 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8124",
      "display" : "C8124 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8125",
      "display" : "C8125 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8126",
      "display" : "C8126 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8127",
      "display" : "C8127 Linfoma de Hodgkin de celularidad mixta bazo"
    },
    {
      "code" : "C8128",
      "display" : "C8128 Linfoma de Hodgkin de celularidad mixta ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8129",
      "display" : "C8129 Linfoma de Hodgkin de celularidad mixta localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C813",
      "display" : "C813 Linfoma de Hodgkin con depleción linfocítica"
    },
    {
      "code" : "C8130",
      "display" : "C8130 Linfoma de Hodgkin con depleción linfocítica localización no especificada"
    },
    {
      "code" : "C8131",
      "display" : "C8131 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8132",
      "display" : "C8132 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8133",
      "display" : "C8133 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8134",
      "display" : "C8134 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8135",
      "display" : "C8135 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8136",
      "display" : "C8136 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8137",
      "display" : "C8137 Linfoma de Hodgkin con depleción linfocítica bazo"
    },
    {
      "code" : "C8138",
      "display" : "C8138 Linfoma de Hodgkin con depleción linfocítica ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8139",
      "display" : "C8139 Linfoma de Hodgkin con depleción linfocítica localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C814",
      "display" : "C814 Linfoma de Hodgkin rico en linfocitos"
    },
    {
      "code" : "C8140",
      "display" : "C8140 Linfoma de Hodgkin rico en linfocitos no especificado"
    },
    {
      "code" : "C8141",
      "display" : "C8141 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8142",
      "display" : "C8142 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8143",
      "display" : "C8143 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8145",
      "display" : "C8145 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8146",
      "display" : "C8146 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8147",
      "display" : "C8147 Linfoma de Hodgkin rico en linfocitos bazo"
    },
    {
      "code" : "C8148",
      "display" : "C8148 Linfoma de Hodgkin rico en linfocitos ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C817",
      "display" : "C817 Otros tipos de linfoma de Hodgkin"
    },
    {
      "code" : "C8170",
      "display" : "C8170 Otros tipos de linfoma de Hodgkin localización no especificada"
    },
    {
      "code" : "C8171",
      "display" : "C8171 Otros tipos de linfoma de Hodgkin ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8172",
      "display" : "C8172 Otros tipos de linfoma de Hodgkin ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8173",
      "display" : "C8173 Otros tipos de linfoma de Hodgkin ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8175",
      "display" : "C8175 Otros tipos de linfoma de Hodgkin ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8176",
      "display" : "C8176 Otros tipos de linfoma de Hodgkin ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8177",
      "display" : "C8177 Otros tipos de linfoma de Hodgkin bazo"
    },
    {
      "code" : "C8178",
      "display" : "C8178 Otros tipos de linfoma de Hodgkin ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C819",
      "display" : "C819 Linfoma de Hodgkin no especificado"
    },
    {
      "code" : "C8190",
      "display" : "C8190 Linfoma de Hodgkin no especificado localización no especificada"
    },
    {
      "code" : "C8191",
      "display" : "C8191 Linfoma de Hodgkin no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8192",
      "display" : "C8192 Linfoma de Hodgkin no especificado ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8194",
      "display" : "C8194 Linfoma de Hodgkin no especificado ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8195",
      "display" : "C8195 Linfoma de Hodgkin no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8196",
      "display" : "C8196 Linfoma de Hodgkin no especificado ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "D2320",
      "display" : "D2320 Otras neoplasias benignas de piel de oído y conducto auditivo externo no especificados"
    },
    {
      "code" : "D2321",
      "display" : "D2321 Otras neoplasias benignas de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "D2322",
      "display" : "D2322 Otras neoplasias benignas de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "D233",
      "display" : "D233 Otras neoplasias benignas de piel de otras partes de la cara y las no especificadas"
    },
    {
      "code" : "D2330",
      "display" : "D2330 Otras neoplasias benignas de piel de parte no especificada de la cara"
    },
    {
      "code" : "D2339",
      "display" : "D2339 Otras neoplasias benignas de piel de otras partes de la cara"
    },
    {
      "code" : "D234",
      "display" : "D234 Otras neoplasias benignas de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "D235",
      "display" : "D235 Otras neoplasias benignas de piel de tronco"
    },
    {
      "code" : "D236",
      "display" : "D236 Otras neoplasias benignas de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "D2360",
      "display" : "D2360 Otras neoplasias benignas de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "D2361",
      "display" : "D2361 Otras neoplasias benignas de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "D2362",
      "display" : "D2362 Otras neoplasias benignas de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "D237",
      "display" : "D237 Otras neoplasias benignas de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "D2370",
      "display" : "D2370 Otras neoplasias benignas de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "D2371",
      "display" : "D2371 Otras neoplasias benignas de piel de extremidad inferior derechaincluyendo cadera"
    },
    {
      "code" : "D2372",
      "display" : "D2372 Otras neoplasias benignas de piel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "D239",
      "display" : "D239 Otros tipos de neoplasia benigna de piel localización no especificada"
    },
    {
      "code" : "D24",
      "display" : "D24 Neoplasia benigna de mama"
    },
    {
      "code" : "D241",
      "display" : "D241 Neoplasia benigna de mama derecha"
    },
    {
      "code" : "D242",
      "display" : "D242 Neoplasia benigna de mama izquierda"
    },
    {
      "code" : "D249",
      "display" : "D249 Neoplasia benigna de mama no especificada"
    },
    {
      "code" : "D25",
      "display" : "D25 Leiomioma de útero"
    },
    {
      "code" : "D250",
      "display" : "D250 Leiomioma submucoso de útero"
    },
    {
      "code" : "D251",
      "display" : "D251 Leiomioma intramural de útero"
    },
    {
      "code" : "D252",
      "display" : "D252 Leiomioma subseroso de útero"
    },
    {
      "code" : "D259",
      "display" : "D259 Leiomioma de útero no especificado"
    },
    {
      "code" : "D26",
      "display" : "D26 Otros tumores benignos de útero"
    },
    {
      "code" : "D261",
      "display" : "D261 Otras neoplasias benignas de cuerpo de útero"
    },
    {
      "code" : "D267",
      "display" : "D267 Otras neoplasias benignas de otras partes de útero"
    },
    {
      "code" : "D269",
      "display" : "D269 Otras neoplasias benignas de útero localización no especificada"
    },
    {
      "code" : "D270",
      "display" : "D270 Neoplasia benigna de ovario derecho"
    },
    {
      "code" : "D271",
      "display" : "D271 Neoplasia benigna de ovario izquierdo"
    },
    {
      "code" : "D28",
      "display" : "D28 Neoplasia benigna de otros órganos genitales femeninos y los no especificados"
    },
    {
      "code" : "D280",
      "display" : "D280 Neoplasia benigna de vulva"
    },
    {
      "code" : "D281",
      "display" : "D281 Neoplasia benigna de vagina"
    },
    {
      "code" : "D287",
      "display" : "D287 Neoplasia benigna de otros órganos genitales femeninos especificados"
    },
    {
      "code" : "D289",
      "display" : "D289 Neoplasia benigna de órgano genital femenino no especificado"
    },
    {
      "code" : "D29",
      "display" : "D29 Neoplasia benigna de órganos genitales masculinos"
    },
    {
      "code" : "D291",
      "display" : "D291 Neoplasia benigna de próstata"
    },
    {
      "code" : "D292",
      "display" : "D292 Neoplasia benigna de testículo"
    },
    {
      "code" : "D2921",
      "display" : "D2921 Neoplasia benigna de testículo derecho"
    },
    {
      "code" : "D2922",
      "display" : "D2922 Neoplasia benigna de testículo izquierdo"
    },
    {
      "code" : "D293",
      "display" : "D293 Neoplasia benigna de epidídimo"
    },
    {
      "code" : "D2931",
      "display" : "D2931 Neoplasia benigna de epidídimo derecho"
    },
    {
      "code" : "D2932",
      "display" : "D2932 Neoplasia benigna de epidídimo izquierdo"
    },
    {
      "code" : "D294",
      "display" : "D294 Neoplasia benigna de escroto"
    },
    {
      "code" : "D299",
      "display" : "D299 Neoplasia benigna de órgano genital masculino no especificado"
    },
    {
      "code" : "D30",
      "display" : "D30 Neoplasia benigna de órganos urinarios"
    },
    {
      "code" : "D300",
      "display" : "D300 Neoplasia benigna de riñón"
    },
    {
      "code" : "D3000",
      "display" : "D3000 Neoplasia benigna de riñón no especificado"
    },
    {
      "code" : "D3002",
      "display" : "D3002 Neoplasia benigna de riñón izquierdo"
    },
    {
      "code" : "D301",
      "display" : "D301 Neoplasia benigna de pelvis renal"
    },
    {
      "code" : "D3010",
      "display" : "D3010 Neoplasia benigna de pelvis renal no especificada"
    },
    {
      "code" : "A312",
      "display" : "A312 Infección diseminada por Mycobacterium avium-intracellulare complex (IDMAC)"
    },
    {
      "code" : "A318",
      "display" : "A318 Otras infecciones por micobacterias"
    },
    {
      "code" : "A319",
      "display" : "A319 Infección por micobacteria no especificada"
    },
    {
      "code" : "A32",
      "display" : "A32 Listeriosis"
    },
    {
      "code" : "A320",
      "display" : "A320 Listeriosis cutánea"
    },
    {
      "code" : "A321",
      "display" : "A321 Meningitis y meningoencefalitis por Listeria"
    },
    {
      "code" : "A3211",
      "display" : "A3211 Meningitis por Listeria"
    },
    {
      "code" : "A3212",
      "display" : "A3212 Meningoencefalitis por Listeria"
    },
    {
      "code" : "A327",
      "display" : "A327 Sepsis por Listeria"
    },
    {
      "code" : "A328",
      "display" : "A328 Otras formas de listeriosis"
    },
    {
      "code" : "A3281",
      "display" : "A3281 Listeriosis oculoglandular"
    },
    {
      "code" : "A3282",
      "display" : "A3282 Endocarditis por Listeria"
    },
    {
      "code" : "A3289",
      "display" : "A3289 Otras formas de listeriosis"
    },
    {
      "code" : "A329",
      "display" : "A329 Listeriosis no especificada"
    },
    {
      "code" : "A33",
      "display" : "A33 Tétanos neonatal"
    },
    {
      "code" : "A34",
      "display" : "A34 Tétanos obstétrico"
    },
    {
      "code" : "A35",
      "display" : "A35 Otros tétanos"
    },
    {
      "code" : "A36",
      "display" : "A36 Difteria"
    },
    {
      "code" : "A360",
      "display" : "A360 Difteria faríngea"
    },
    {
      "code" : "A361",
      "display" : "A361 Difteria nasofaríngea"
    },
    {
      "code" : "A362",
      "display" : "A362 Difteria laríngea"
    },
    {
      "code" : "A363",
      "display" : "A363 Difteria cutánea"
    },
    {
      "code" : "A368",
      "display" : "A368 Otras difterias"
    },
    {
      "code" : "A3681",
      "display" : "A3681 Cardiomiopatía diftérica"
    },
    {
      "code" : "A3683",
      "display" : "A3683 Polineuritis diftérica"
    },
    {
      "code" : "A3684",
      "display" : "A3684 Nefropatía túbulo-intersticial diftérica"
    },
    {
      "code" : "A3685",
      "display" : "A3685 Cistitis diftérica"
    },
    {
      "code" : "A3689",
      "display" : "A3689 Otras complicaciones de la difteria"
    },
    {
      "code" : "A369",
      "display" : "A369 Difteria no especificada"
    },
    {
      "code" : "A370",
      "display" : "A370 Tos ferina debida a Bordetella pertussis"
    },
    {
      "code" : "A3700",
      "display" : "A3700 Tos ferina debida a Bordetella pertussis sin neumonía"
    },
    {
      "code" : "A371",
      "display" : "A371 Tos ferina debida a Bordetella parapertussis"
    },
    {
      "code" : "A3710",
      "display" : "A3710 Tos ferina debida a Bordetella parapertussis sin neumonía"
    },
    {
      "code" : "A3711",
      "display" : "A3711 Tos ferina debida a Bordetella parapertussis con neumonía"
    },
    {
      "code" : "A3780",
      "display" : "A3780 Tos ferina debida a otras especies de Bordetella sin neumonía"
    },
    {
      "code" : "A3781",
      "display" : "A3781 Tos ferina debida a otras especies de Bordetella con neumonía"
    },
    {
      "code" : "A379",
      "display" : "A379 Tos ferina especie no especificada"
    },
    {
      "code" : "A3791",
      "display" : "A3791 Tos ferina especie no especificada con neumonía"
    },
    {
      "code" : "A38",
      "display" : "A38 Escarlatina"
    },
    {
      "code" : "A380",
      "display" : "A380 Escarlatina con otitis media"
    },
    {
      "code" : "A388",
      "display" : "A388 Escarlatina con otras complicaciones"
    },
    {
      "code" : "A389",
      "display" : "A389 Escarlatina no complicada"
    },
    {
      "code" : "A39",
      "display" : "A39 Infección meningocócica"
    },
    {
      "code" : "A391",
      "display" : "A391 Síndrome de Waterhouse-Friderichsen"
    },
    {
      "code" : "A392",
      "display" : "A392 Meningococemia aguda"
    },
    {
      "code" : "A394",
      "display" : "A394 Meningococemia no especificada"
    },
    {
      "code" : "A395",
      "display" : "A395 Enfermedad cardiaca debida a meningococo"
    },
    {
      "code" : "A3951",
      "display" : "A3951 Endocarditis meningocócica"
    },
    {
      "code" : "A3952",
      "display" : "A3952 Miocarditis meningocócica"
    },
    {
      "code" : "A3953",
      "display" : "A3953 Pericarditis meningocócica"
    },
    {
      "code" : "A3981",
      "display" : "A3981 Encefalitis meningocócicas"
    },
    {
      "code" : "A3982",
      "display" : "A3982 Neuritis retrobulbar meningocócica"
    },
    {
      "code" : "A3983",
      "display" : "A3983 Artritis meningocócica"
    },
    {
      "code" : "A3989",
      "display" : "A3989 Otras infecciones meningocócicas"
    },
    {
      "code" : "A399",
      "display" : "A399 Infección meningocócica no especificada"
    },
    {
      "code" : "A400",
      "display" : "A400 Sepsis debida a estreptococo grupo A"
    },
    {
      "code" : "A401",
      "display" : "A401 Sepsis debida a estreptococo grupo B"
    },
    {
      "code" : "A408",
      "display" : "A408 Otras sepsis estreptocócicas"
    },
    {
      "code" : "A409",
      "display" : "A409 Sepsis estreptocócica no especificada"
    },
    {
      "code" : "A41",
      "display" : "A41 Otras sepsis"
    },
    {
      "code" : "A4101",
      "display" : "A4101 Sepsis debida a Staphylococcus aureus sensible a meticilina"
    },
    {
      "code" : "C098",
      "display" : "C098 Neoplasia maligna de localizaciones contiguas de amígdala"
    },
    {
      "code" : "C099",
      "display" : "C099 Neoplasia maligna de amígdala no especificada"
    },
    {
      "code" : "C10",
      "display" : "C10 Neoplasia maligna de orofaringe"
    },
    {
      "code" : "C100",
      "display" : "C100 Neoplasia maligna de valécula"
    },
    {
      "code" : "C101",
      "display" : "C101 Neoplasia maligna de superficie anterior de epiglotis"
    },
    {
      "code" : "C102",
      "display" : "C102 Neoplasia maligna de pared lateral de orofaringe"
    },
    {
      "code" : "C103",
      "display" : "C103 Neoplasia maligna de pared posterior de orofaringe"
    },
    {
      "code" : "C104",
      "display" : "C104 Neoplasia maligna de hendidura branquial"
    },
    {
      "code" : "C108",
      "display" : "C108 Neoplasia maligna de localizaciones contiguas de orofaringe"
    },
    {
      "code" : "C109",
      "display" : "C109 Neoplasia maligna de orofaringe no especificada"
    },
    {
      "code" : "C11",
      "display" : "C11 Neoplasia maligna de nasofaringe"
    },
    {
      "code" : "C110",
      "display" : "C110 Neoplasia maligna de pared superior de nasofaringe"
    },
    {
      "code" : "C111",
      "display" : "C111 Neoplasia maligna de pared posterior de nasofaringe"
    },
    {
      "code" : "C112",
      "display" : "C112 Neoplasia maligna de pared lateral de nasofaringe"
    },
    {
      "code" : "C113",
      "display" : "C113 Neoplasia maligna de pared anterior de nasofaringe"
    },
    {
      "code" : "C118",
      "display" : "C118 Neoplasia maligna de localizaciones contiguas de nasofaringe"
    },
    {
      "code" : "C119",
      "display" : "C119 Neoplasia maligna de nasofaringe no especificada"
    },
    {
      "code" : "C12",
      "display" : "C12 Neoplasia maligna de seno piriforme"
    },
    {
      "code" : "C13",
      "display" : "C13 Neoplasia maligna de hipofaringe"
    },
    {
      "code" : "C130",
      "display" : "C130 Neoplasia maligna de región poscricoidea"
    },
    {
      "code" : "C131",
      "display" : "C131 Neoplasia maligna de pliegue aritenoepiglótico cara hipofaríngea"
    },
    {
      "code" : "C132",
      "display" : "C132 Neoplasia maligna de pared posterior de hipofaringe"
    },
    {
      "code" : "C138",
      "display" : "C138 Neoplasia maligna de localizaciones contiguas de hipofaringe"
    },
    {
      "code" : "C139",
      "display" : "C139 Neoplasia maligna de hipofaringe no especificada"
    },
    {
      "code" : "C14",
      "display" : "C14 Neoplasia maligna de otras localizaciones y las mal definidas en labio cavidad oral y faringe"
    },
    {
      "code" : "C140",
      "display" : "C140 Neoplasia maligna de faringe no especificada"
    },
    {
      "code" : "C142",
      "display" : "C142 Neoplasia maligna de anillo de Waldeyer"
    },
    {
      "code" : "C15",
      "display" : "C15 Neoplasia maligna de esófago"
    },
    {
      "code" : "C153",
      "display" : "C153 Neoplasia maligna de tercio superior de esófago"
    },
    {
      "code" : "C154",
      "display" : "C154 Neoplasia maligna de tercio medio de esófago"
    },
    {
      "code" : "C158",
      "display" : "C158 Neoplasia maligna de localizaciones contiguas de esófago"
    },
    {
      "code" : "C159",
      "display" : "C159 Neoplasia maligna de esófago no especificada"
    },
    {
      "code" : "C16",
      "display" : "C16 Neoplasia maligna de estómago"
    },
    {
      "code" : "C160",
      "display" : "C160 Neoplasia maligna de cardias"
    },
    {
      "code" : "C162",
      "display" : "C162 Neoplasia maligna de cuerpo de estómago"
    },
    {
      "code" : "C163",
      "display" : "C163 Neoplasia maligna de antro pilórico"
    },
    {
      "code" : "C165",
      "display" : "C165 Neoplasia maligna de curvatura menor de estómago no especificada"
    },
    {
      "code" : "C166",
      "display" : "C166 Neoplasia maligna de curvatura mayor de estómago no especificada"
    },
    {
      "code" : "C168",
      "display" : "C168 Neoplasia maligna de localizaciones contiguas de estómago"
    },
    {
      "code" : "C17",
      "display" : "C17 Neoplasia maligna de intestino delgado"
    },
    {
      "code" : "C170",
      "display" : "C170 Neoplasia maligna de duodeno"
    },
    {
      "code" : "C171",
      "display" : "C171 Neoplasia maligna de yeyuno"
    },
    {
      "code" : "C173",
      "display" : "C173 Divertículo de Meckel maligno"
    },
    {
      "code" : "C178",
      "display" : "C178 Neoplasia maligna de localizaciones contiguas de intestino delgado"
    },
    {
      "code" : "C18",
      "display" : "C18 Neoplasia maligna de colon"
    },
    {
      "code" : "C180",
      "display" : "C180 Neoplasia maligna de ciego"
    },
    {
      "code" : "C181",
      "display" : "C181 Neoplasia maligna de apéndice"
    },
    {
      "code" : "C183",
      "display" : "C183 Neoplasia maligna de ángulo hepático"
    },
    {
      "code" : "C184",
      "display" : "C184 Neoplasia maligna de colon transverso"
    },
    {
      "code" : "C185",
      "display" : "C185 Neoplasia maligna de ángulo esplénico"
    },
    {
      "code" : "C187",
      "display" : "C187 Neoplasia maligna de colon sigmoide"
    },
    {
      "code" : "C188",
      "display" : "C188 Neoplasia maligna de localizaciones contiguas de colon"
    },
    {
      "code" : "C189",
      "display" : "C189 Neoplasia maligna de colon no especificada"
    },
    {
      "code" : "C20",
      "display" : "C20 Neoplasia maligna de recto"
    },
    {
      "code" : "C21",
      "display" : "C21 Neoplasia maligna de ano y canal anal"
    },
    {
      "code" : "C210",
      "display" : "C210 Neoplasia maligna de ano no especificada"
    },
    {
      "code" : "C8197",
      "display" : "C8197 Linfoma de Hodgkin no especificado bazo"
    },
    {
      "code" : "C8198",
      "display" : "C8198 Linfoma de Hodgkin no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8199",
      "display" : "C8199 Linfoma de Hodgkin no especificado localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C82",
      "display" : "C82 Linfoma folicular"
    },
    {
      "code" : "C820",
      "display" : "C820 Linfoma folicular grado I"
    },
    {
      "code" : "C8200",
      "display" : "C8200 Linfoma folicular grado I localización no especificada"
    },
    {
      "code" : "C8201",
      "display" : "C8201 Linfoma folicular grado I ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8202",
      "display" : "C8202 Linfoma folicular grado I ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8203",
      "display" : "C8203 Linfoma folicular grado I ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8204",
      "display" : "C8204 Linfoma folicular grado I ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8205",
      "display" : "C8205 Linfoma folicular grado I ganglios linfáticos de región inguinal y miembro inferior"
    },
    {
      "code" : "C8206",
      "display" : "C8206 Linfoma folicular grado I ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8207",
      "display" : "C8207 Linfoma folicular grado I bazo"
    },
    {
      "code" : "C8208",
      "display" : "C8208 Linfoma folicular grado I ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8209",
      "display" : "C8209 Linfoma folicular grado I localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C821",
      "display" : "C821 Linfoma folicular grado II"
    },
    {
      "code" : "C8210",
      "display" : "C8210 Linfoma folicular grado II localización no especificada"
    },
    {
      "code" : "C8211",
      "display" : "C8211 Linfoma folicular grado II ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8212",
      "display" : "C8212 Linfoma folicular grado II ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8213",
      "display" : "C8213 Linfoma folicular grado II ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8214",
      "display" : "C8214 Linfoma folicular grado II ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8215",
      "display" : "C8215 Linfoma folicular grado II ganglios linfáticos de región inguinal y miembro inferior"
    },
    {
      "code" : "C8216",
      "display" : "C8216 Linfoma folicular grado II ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8217",
      "display" : "C8217 Linfoma folicular grado II bazo"
    },
    {
      "code" : "C8219",
      "display" : "C8219 Linfoma folicular grado II localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C822",
      "display" : "C822 Linfoma folicular grado III no especificado"
    },
    {
      "code" : "C8220",
      "display" : "C8220 Linfoma folicular grado III no especificado localización no especificada"
    },
    {
      "code" : "C8221",
      "display" : "C8221 Linfoma folicular grado III no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8223",
      "display" : "C8223 Linfoma folicular grado III no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8224",
      "display" : "C8224 Linfoma folicular grado III no especificado ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8225",
      "display" : "C8225 Linfoma folicular grado III no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8226",
      "display" : "C8226 Linfoma folicular grado III no especificado ganglios intrapélvicos"
    },
    {
      "code" : "C8228",
      "display" : "C8228 Linfoma folicular grado III no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8229",
      "display" : "C8229 Linfoma folicular grado III no especificado localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C823",
      "display" : "C823 Linfoma folicular grado IIIa"
    },
    {
      "code" : "C8230",
      "display" : "C8230 Linfoma folicular grado IIIa localización no especificada"
    },
    {
      "code" : "C8232",
      "display" : "C8232 Linfoma folicular grado IIIa ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8233",
      "display" : "C8233 Linfoma folicular grado IIIa ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8234",
      "display" : "C8234 Linfoma folicular grado IIIa ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8236",
      "display" : "C8236 Linfoma folicular grado IIIa ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8237",
      "display" : "C8237 Linfoma folicular grado IIIa bazo"
    },
    {
      "code" : "C8238",
      "display" : "C8238 Linfoma folicular grado IIIa ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8239",
      "display" : "C8239 Linfoma folicular grado IIIa localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C824",
      "display" : "C824 Linfoma folicular grado IIIb"
    },
    {
      "code" : "C8241",
      "display" : "C8241 Linfoma folicular grado IIIb ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8242",
      "display" : "C8242 Linfoma folicular grado IIIb ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8243",
      "display" : "C8243 Linfoma folicular grado IIIb ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8245",
      "display" : "C8245 Linfoma folicular grado IIIb ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "D3012",
      "display" : "D3012 Neoplasia benigna de pelvis renal izquierda"
    },
    {
      "code" : "D302",
      "display" : "D302 Neoplasia benigna de uréter"
    },
    {
      "code" : "D3020",
      "display" : "D3020 Neoplasia benigna de uréter no especificado"
    },
    {
      "code" : "D3021",
      "display" : "D3021 Neoplasia benigna de uréter derecho"
    },
    {
      "code" : "D3022",
      "display" : "D3022 Neoplasia benigna de uréter izquierdo"
    },
    {
      "code" : "D303",
      "display" : "D303 Neoplasia benigna de vejiga"
    },
    {
      "code" : "D304",
      "display" : "D304 Neoplasia benigna de uretra"
    },
    {
      "code" : "D308",
      "display" : "D308 Neoplasia benigna de otros órganos urinarios especificados"
    },
    {
      "code" : "D309",
      "display" : "D309 Neoplasia benigna de órgano urinario no especificado"
    },
    {
      "code" : "D31",
      "display" : "D31 Neoplasia benigna de ojo y sus anexos"
    },
    {
      "code" : "D310",
      "display" : "D310 Neoplasia benigna de conjuntiva"
    },
    {
      "code" : "D3100",
      "display" : "D3100 Neoplasia benigna de conjuntiva no especificada"
    },
    {
      "code" : "D3101",
      "display" : "D3101 Neoplasia benigna de conjuntiva derecha"
    },
    {
      "code" : "D3102",
      "display" : "D3102 Neoplasia benigna de conjuntiva izquierda"
    },
    {
      "code" : "D311",
      "display" : "D311 Neoplasia benigna de córnea"
    },
    {
      "code" : "D3110",
      "display" : "D3110 Neoplasia benigna de córnea no especificada"
    },
    {
      "code" : "D3111",
      "display" : "D3111 Neoplasia benigna de córnea derecha"
    },
    {
      "code" : "D3112",
      "display" : "D3112 Neoplasia benigna de córnea izquierda"
    },
    {
      "code" : "D312",
      "display" : "D312 Neoplasia benigna de retina"
    },
    {
      "code" : "D3120",
      "display" : "D3120 Neoplasia benigna de retina no especificada"
    },
    {
      "code" : "D3121",
      "display" : "D3121 Neoplasia benigna de retina derecha"
    },
    {
      "code" : "D3122",
      "display" : "D3122 Neoplasia benigna de retina izquierda"
    },
    {
      "code" : "D313",
      "display" : "D313 Neoplasia benigna de coroides"
    },
    {
      "code" : "D3130",
      "display" : "D3130 Neoplasia benigna de coroides no especificada"
    },
    {
      "code" : "D3131",
      "display" : "D3131 Neoplasia benigna de coroides derecha"
    },
    {
      "code" : "D3132",
      "display" : "D3132 Neoplasia benigna de coroides izquierda"
    },
    {
      "code" : "D314",
      "display" : "D314 Neoplasia benigna de cuerpo ciliar"
    },
    {
      "code" : "D3141",
      "display" : "D3141 Neoplasia benigna de cuerpo ciliar derecho"
    },
    {
      "code" : "D3142",
      "display" : "D3142 Neoplasia benigna de cuerpo ciliar izquierdo"
    },
    {
      "code" : "D315",
      "display" : "D315 Neoplasia benigna de glándula y conducto lacrimal"
    },
    {
      "code" : "D3151",
      "display" : "D3151 Neoplasia benigna de glándula y conducto lacrimal derechos"
    },
    {
      "code" : "D3152",
      "display" : "D3152 Neoplasia benigna de glándula y conducto lacrimal izquierdos"
    },
    {
      "code" : "D316",
      "display" : "D316 Neoplasia benigna de órbita en localización no especificada"
    },
    {
      "code" : "D3160",
      "display" : "D3160 Neoplasia benigna de órbita no especificada en localización no especificada"
    },
    {
      "code" : "D3162",
      "display" : "D3162 Neoplasia benigna de órbita izquierda en localización no especificada"
    },
    {
      "code" : "D319",
      "display" : "D319 Neoplasia benigna de parte del ojo no especificada"
    },
    {
      "code" : "D3190",
      "display" : "D3190 Neoplasia benigna de parte no especificada de ojo no especificado"
    },
    {
      "code" : "D3191",
      "display" : "D3191 Neoplasia benigna de parte no especificada de ojo derecho"
    },
    {
      "code" : "D32",
      "display" : "D32 Neoplasia benigna de meninges"
    },
    {
      "code" : "D320",
      "display" : "D320 Neoplasia benigna de meninges cerebrales"
    },
    {
      "code" : "D321",
      "display" : "D321 Neoplasia benigna de meninges espinales"
    },
    {
      "code" : "D33",
      "display" : "D33 Neoplasia benigna de cerebro y otras partes de sistema nervioso central"
    },
    {
      "code" : "D330",
      "display" : "D330 Neoplasia benigna de cerebro supratentorial"
    },
    {
      "code" : "D331",
      "display" : "D331 Neoplasia benigna de cerebro infratentorial"
    },
    {
      "code" : "D333",
      "display" : "D333 Neoplasia benigna de nervios craneales"
    },
    {
      "code" : "D334",
      "display" : "D334 Neoplasia benigna de médula espinal"
    },
    {
      "code" : "D337",
      "display" : "D337 Neoplasia benigna de otras localizaciones especificadas de sistema nervioso central"
    },
    {
      "code" : "D34",
      "display" : "D34 Neoplasia benigna de glándula tiroides"
    },
    {
      "code" : "D35",
      "display" : "D35 Neoplasia benigna de otras glándulas endocrinas y las no especificadas"
    },
    {
      "code" : "D350",
      "display" : "D350 Neoplasia benigna de glándula suprarrenal"
    },
    {
      "code" : "D3500",
      "display" : "D3500 Neoplasia benigna de glándula suprarrenal no especificada"
    },
    {
      "code" : "D3502",
      "display" : "D3502 Neoplasia benigna de glándula suprarrenal izquierda"
    },
    {
      "code" : "D351",
      "display" : "D351 Neoplasia benigna de glándula paratiroides"
    },
    {
      "code" : "D352",
      "display" : "D352 Neoplasia benigna de hipófisis"
    },
    {
      "code" : "D354",
      "display" : "D354 Neoplasia benigna de glándula pineal"
    },
    {
      "code" : "D355",
      "display" : "D355 Neoplasia benigna de cuerpo carotídeo"
    },
    {
      "code" : "A4102",
      "display" : "A4102 Sepsis debida a Staphylococcus aureus resistente a meticilina"
    },
    {
      "code" : "A411",
      "display" : "A411 Sepsis debida a otro estafilococo especificado"
    },
    {
      "code" : "A412",
      "display" : "A412 Sepsis debida a estafilococo no especificado"
    },
    {
      "code" : "A413",
      "display" : "A413 Sepsis debida a Haemophilus influenzae"
    },
    {
      "code" : "A414",
      "display" : "A414 Sepsis debida a anaerobios"
    },
    {
      "code" : "A415",
      "display" : "A415 Sepsis debida a otros organismos gram negativos"
    },
    {
      "code" : "A4150",
      "display" : "A4150 Sepsis por gram negativos no especificados"
    },
    {
      "code" : "A4151",
      "display" : "A4151 Sepsis por Escherichia coli [E. coli]"
    },
    {
      "code" : "A4152",
      "display" : "A4152 Sepsis por Pseudomonas"
    },
    {
      "code" : "A4153",
      "display" : "A4153 Sepsis por Serratia"
    },
    {
      "code" : "A4159",
      "display" : "A4159 Sepsis por otros gram negativos"
    },
    {
      "code" : "A418",
      "display" : "A418 Otras sepsis especificadas"
    },
    {
      "code" : "A4181",
      "display" : "A4181 Sepsis por Enterococcus"
    },
    {
      "code" : "A4189",
      "display" : "A4189 Otras sepsis especificadas"
    },
    {
      "code" : "A419",
      "display" : "A419 Sepsis microorganismo no especificado"
    },
    {
      "code" : "A42",
      "display" : "A42 Actinomicosis"
    },
    {
      "code" : "A420",
      "display" : "A420 Actinomicosis pulmonar"
    },
    {
      "code" : "A421",
      "display" : "A421 Actinomicosis abdominal"
    },
    {
      "code" : "A422",
      "display" : "A422 Actinomicosis cervicofacial"
    },
    {
      "code" : "A427",
      "display" : "A427 Sepsis actinomicótica"
    },
    {
      "code" : "A428",
      "display" : "A428 Otras formas de actinomicosis"
    },
    {
      "code" : "A4281",
      "display" : "A4281 Meningitis actinomicótica"
    },
    {
      "code" : "A4282",
      "display" : "A4282 Encefalitis actinomicótica"
    },
    {
      "code" : "A4289",
      "display" : "A4289 Otras formas de actinomicosis"
    },
    {
      "code" : "A429",
      "display" : "A429 Actinomicosis no especificada"
    },
    {
      "code" : "A43",
      "display" : "A43 Nocardiosis"
    },
    {
      "code" : "A431",
      "display" : "A431 Nocardiosis cutánea"
    },
    {
      "code" : "A438",
      "display" : "A438 Otras formas de nocardiosis"
    },
    {
      "code" : "A44",
      "display" : "A44 Bartonelosis"
    },
    {
      "code" : "A440",
      "display" : "A440 Bartonelosis sistémica"
    },
    {
      "code" : "A441",
      "display" : "A441 Bartonelosis cutánea y mucocutánea"
    },
    {
      "code" : "A449",
      "display" : "A449 Bartonelosis no especificada"
    },
    {
      "code" : "A46",
      "display" : "A46 Erisipela"
    },
    {
      "code" : "A480",
      "display" : "A480 Gangrena gaseosa"
    },
    {
      "code" : "A481",
      "display" : "A481 Enfermedad de los legionarios"
    },
    {
      "code" : "A482",
      "display" : "A482 Enfermedad de los legionarios no neumónica [fiebre de Pontiac]"
    },
    {
      "code" : "A483",
      "display" : "A483 Síndrome de shock tóxico"
    },
    {
      "code" : "A485",
      "display" : "A485 Otros botulismos especificados"
    },
    {
      "code" : "A4851",
      "display" : "A4851 Botulismo infantil"
    },
    {
      "code" : "A488",
      "display" : "A488 Otras enfermedades bacterianas especificadas"
    },
    {
      "code" : "A49",
      "display" : "A49 Infección bacteriana de localización no especificada"
    },
    {
      "code" : "A4901",
      "display" : "A4901 Infección por Staphylococcus aureus sensible a meticilina localización no especificada"
    },
    {
      "code" : "A4902",
      "display" : "A4902 Infección por Staphylococcus aureus resistente a meticilina localización no especificada"
    },
    {
      "code" : "A491",
      "display" : "A491 Infección estreptocócica localización no especificada"
    },
    {
      "code" : "A492",
      "display" : "A492 Infección por Haemophilus influenzae localización no especificada"
    },
    {
      "code" : "A498",
      "display" : "A498 Otras infecciones bacterianas de localización no especificada"
    },
    {
      "code" : "A499",
      "display" : "A499 Infección bacteriana no especificada"
    },
    {
      "code" : "A50",
      "display" : "A50 Sífilis congénita"
    },
    {
      "code" : "A5001",
      "display" : "A5001 Sífilis ocular congénita precoz"
    },
    {
      "code" : "A5002",
      "display" : "A5002 Osteocondropatía sifilítica congénita precoz"
    },
    {
      "code" : "A5003",
      "display" : "A5003 Faringitis sifilítica congénita precoz"
    },
    {
      "code" : "A5005",
      "display" : "A5005 Rinitis sifilítica congénita precoz"
    },
    {
      "code" : "A5006",
      "display" : "A5006 Sífilis cutánea congénita precoz"
    },
    {
      "code" : "A5008",
      "display" : "A5008 Sífilis visceral congénita precoz"
    },
    {
      "code" : "A5009",
      "display" : "A5009 Otras sífilis congénitas precoces sintomáticas"
    },
    {
      "code" : "A501",
      "display" : "A501 Sífilis congénita precoz latente"
    },
    {
      "code" : "A503",
      "display" : "A503 Oculopatía sifilítica congénita tardía"
    },
    {
      "code" : "A5030",
      "display" : "A5030 Sífilis ocular congénita no especificada"
    },
    {
      "code" : "A5031",
      "display" : "A5031 Queratitis intersticial sifilítica congénita tardía"
    },
    {
      "code" : "C212",
      "display" : "C212 Neoplasia maligna de zona cloacogénica"
    },
    {
      "code" : "C218",
      "display" : "C218 Neoplasia maligna de localizaciones contiguas de recto ano y canal anal"
    },
    {
      "code" : "C22",
      "display" : "C22 Neoplasia maligna de hígado y vías biliares intrahepáticas"
    },
    {
      "code" : "C220",
      "display" : "C220 Carcinoma de células hepáticas"
    },
    {
      "code" : "C221",
      "display" : "C221 Carcinoma de conducto biliar intrahepático"
    },
    {
      "code" : "C222",
      "display" : "C222 Hepatoblastoma"
    },
    {
      "code" : "C223",
      "display" : "C223 Angiosarcoma de hígado"
    },
    {
      "code" : "C224",
      "display" : "C224 Otros sarcomas de hígado"
    },
    {
      "code" : "C227",
      "display" : "C227 Otros carcinomas especificados de hígado"
    },
    {
      "code" : "C228",
      "display" : "C228 Neoplasia maligna de hígado primario no especificada en cuanto a tipo"
    },
    {
      "code" : "C229",
      "display" : "C229 Neoplasia maligna de hígado no especificada como primaria ni secundaria"
    },
    {
      "code" : "C23",
      "display" : "C23 Neoplasia maligna de vesícula biliar"
    },
    {
      "code" : "C24",
      "display" : "C24 Neoplasia maligna de otras partes de tracto biliar y las no especificadas"
    },
    {
      "code" : "C240",
      "display" : "C240 Neoplasia maligna de vía biliar extrahepática"
    },
    {
      "code" : "C241",
      "display" : "C241 Neoplasia maligna de ampolla de Vater"
    },
    {
      "code" : "C248",
      "display" : "C248 Neoplasia maligna de localizaciones contiguas de vías biliares"
    },
    {
      "code" : "C249",
      "display" : "C249 Neoplasia maligna de tracto biliar no especificada"
    },
    {
      "code" : "C25",
      "display" : "C25 Neoplasia maligna de páncreas"
    },
    {
      "code" : "C250",
      "display" : "C250 Neoplasia maligna de cabeza de páncreas"
    },
    {
      "code" : "C251",
      "display" : "C251 Neoplasia maligna de cuerpo de páncreas"
    },
    {
      "code" : "C252",
      "display" : "C252 Neoplasia maligna de cola de páncreas"
    },
    {
      "code" : "C253",
      "display" : "C253 Neoplasia maligna de conducto pancreático"
    },
    {
      "code" : "C254",
      "display" : "C254 Neoplasia maligna de páncreas endocrino"
    },
    {
      "code" : "C257",
      "display" : "C257 Neoplasia maligna de otras partes de páncreas"
    },
    {
      "code" : "C258",
      "display" : "C258 Neoplasia maligna de localizaciones contiguas de páncreas"
    },
    {
      "code" : "C26",
      "display" : "C26 Neoplasia maligna de otros órganos digestivos y de los mal definidos"
    },
    {
      "code" : "C260",
      "display" : "C260 Neoplasia maligna de tracto intestinal parte no especificada"
    },
    {
      "code" : "C261",
      "display" : "C261 Neoplasia maligna de bazo"
    },
    {
      "code" : "C30",
      "display" : "C30 Neoplasia maligna de cavidad nasal y de oído medio"
    },
    {
      "code" : "C300",
      "display" : "C300 Neoplasia maligna de cavidad nasal"
    },
    {
      "code" : "C301",
      "display" : "C301 Neoplasia maligna de oído medio"
    },
    {
      "code" : "C310",
      "display" : "C310 Neoplasia maligna de seno maxilar"
    },
    {
      "code" : "C311",
      "display" : "C311 Neoplasia maligna de seno etmoidal"
    },
    {
      "code" : "C312",
      "display" : "C312 Neoplasia maligna de seno frontal"
    },
    {
      "code" : "C318",
      "display" : "C318 Neoplasia maligna de localizaciones contiguas de senos accesorios"
    },
    {
      "code" : "C319",
      "display" : "C319 Neoplasia maligna de seno accesorio no especificada"
    },
    {
      "code" : "C32",
      "display" : "C32 Neoplasia maligna de laringe"
    },
    {
      "code" : "C321",
      "display" : "C321 Neoplasia maligna de supraglotis"
    },
    {
      "code" : "C322",
      "display" : "C322 Neoplasia maligna de subglotis"
    },
    {
      "code" : "C328",
      "display" : "C328 Neoplasia maligna de localizaciones contiguas de laringe"
    },
    {
      "code" : "C329",
      "display" : "C329 Neoplasia maligna de laringe no especificada"
    },
    {
      "code" : "C33",
      "display" : "C33 Neoplasia maligna de tráquea"
    },
    {
      "code" : "C340",
      "display" : "C340 Neoplasia maligna de bronquio principal"
    },
    {
      "code" : "C3400",
      "display" : "C3400 Neoplasia maligna de bronquio principal no especificado"
    },
    {
      "code" : "C3401",
      "display" : "C3401 Neoplasia maligna de bronquio principal derecho"
    },
    {
      "code" : "C341",
      "display" : "C341 Neoplasia maligna de lóbulo superior bronquio o pulmón"
    },
    {
      "code" : "C3410",
      "display" : "C3410 Neoplasia maligna de lóbulo superior bronquio y pulmón no especificados"
    },
    {
      "code" : "C3411",
      "display" : "C3411 Neoplasia maligna de lóbulo superior bronquio o pulmón derecho"
    },
    {
      "code" : "C342",
      "display" : "C342 Neoplasia maligna de lóbulo medio bronquio o pulmón"
    },
    {
      "code" : "C343",
      "display" : "C343 Neoplasia maligna de lóbulo inferior bronquio o pulmón"
    },
    {
      "code" : "C3430",
      "display" : "C3430 Neoplasia maligna de lóbulo inferior bronquio o pulmón no especificados"
    },
    {
      "code" : "C3432",
      "display" : "C3432 Neoplasia maligna de lóbulo inferior bronquio o pulmón izquierdo"
    },
    {
      "code" : "C348",
      "display" : "C348 Neoplasia maligna de localizaciones contiguas de bronquio y pulmón"
    },
    {
      "code" : "C3480",
      "display" : "C3480 Neoplasia maligna de localizaciones contiguas de bronquio y pulmón no especificados"
    },
    {
      "code" : "C3481",
      "display" : "C3481 Neoplasia maligna de localizaciones contiguas de bronquio y pulmón derecho"
    },
    {
      "code" : "C8246",
      "display" : "C8246 Linfoma folicular grado IIIb ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8247",
      "display" : "C8247 Linfoma folicular grado IIIb bazo"
    },
    {
      "code" : "C8248",
      "display" : "C8248 Linfoma folicular grado IIIb ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8249",
      "display" : "C8249 Linfoma folicular grado IIIb localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C825",
      "display" : "C825 Linfoma difuso centrofolicular"
    },
    {
      "code" : "C8250",
      "display" : "C8250 Linfoma difuso centrofolicular localización no especificada"
    },
    {
      "code" : "C8251",
      "display" : "C8251 Linfoma difuso centrofolicular ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8252",
      "display" : "C8252 Linfoma difuso centrofolicular ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8253",
      "display" : "C8253 Linfoma difuso centrofolicular ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8254",
      "display" : "C8254 Linfoma difuso centrofolicular ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8255",
      "display" : "C8255 Linfoma difuso centrofolicular ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8256",
      "display" : "C8256 Linfoma difuso centrofolicular ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8257",
      "display" : "C8257 Linfoma difuso centrofolicular bazo"
    },
    {
      "code" : "C8258",
      "display" : "C8258 Linfoma difuso centrofolicular ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8259",
      "display" : "C8259 Linfoma difuso centrofolicular localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C826",
      "display" : "C826 Linfoma centrofolicular cutáneo"
    },
    {
      "code" : "C8260",
      "display" : "C8260 Linfoma centrofolicular cutáneo localización no especificada"
    },
    {
      "code" : "C8261",
      "display" : "C8261 Linfoma centrofolicular cutáneo ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8262",
      "display" : "C8262 Linfoma centrofolicular cutáneo ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8263",
      "display" : "C8263 Linfoma centrofolicular cutáneo ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8264",
      "display" : "C8264 Linfoma centrofolicular cutáneo ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8265",
      "display" : "C8265 Linfoma centrofolicular cutáneo ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8266",
      "display" : "C8266 Linfoma centrofolicular cutáneo ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8267",
      "display" : "C8267 Linfoma centrofolicular cutáneo bazo"
    },
    {
      "code" : "C8268",
      "display" : "C8268 Linfoma centrofolicular cutáneo ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8269",
      "display" : "C8269 Linfoma centrofolicular cutáneo localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C8280",
      "display" : "C8280 Otros tipos de linfoma folicular localización no especificada"
    },
    {
      "code" : "C8281",
      "display" : "C8281 Otros tipos de linfoma folicular ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8283",
      "display" : "C8283 Otros tipos de linfoma folicular ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8284",
      "display" : "C8284 Otros tipos de linfoma folicular ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8285",
      "display" : "C8285 Otros tipos de linfoma folicular ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8286",
      "display" : "C8286 Otros tipos de linfoma folicular ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8288",
      "display" : "C8288 Otros tipos de linfoma folicular ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8289",
      "display" : "C8289 Otros tipos de linfoma folicular localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C829",
      "display" : "C829 Linfoma folicular no especificado"
    },
    {
      "code" : "C8291",
      "display" : "C8291 Linfoma folicular no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8292",
      "display" : "C8292 Linfoma folicular no especificado ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8293",
      "display" : "C8293 Linfoma folicular no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8295",
      "display" : "C8295 Linfoma folicular no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8296",
      "display" : "C8296 Linfoma folicular no especificado ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8297",
      "display" : "C8297 Linfoma folicular no especificado bazo"
    },
    {
      "code" : "C8298",
      "display" : "C8298 Linfoma folicular no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C83",
      "display" : "C83 Linfoma no folicular"
    },
    {
      "code" : "C830",
      "display" : "C830 Linfoma de células B de células pequeñas"
    },
    {
      "code" : "C8300",
      "display" : "C8300 Linfoma de células B de células pequeñas localización no especificada"
    },
    {
      "code" : "C8301",
      "display" : "C8301 Linfoma de células B de células pequeñas ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8302",
      "display" : "C8302 Linfoma de células B de células pequeñas ganglios linfáticos intratorácicos"
    },
    {
      "code" : "D357",
      "display" : "D357 Neoplasia benigna de otras glándulas endocrinas especificadas"
    },
    {
      "code" : "D359",
      "display" : "D359 Neoplasia benigna de glándula endocrina no especificada"
    },
    {
      "code" : "D36",
      "display" : "D36 Neoplasia benigna de otras localizaciones y las no especificadas"
    },
    {
      "code" : "D360",
      "display" : "D360 Neoplasia benigna de ganglios linfáticos"
    },
    {
      "code" : "D361",
      "display" : "D361 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo"
    },
    {
      "code" : "D3610",
      "display" : "D3610 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo no especificados"
    },
    {
      "code" : "D3611",
      "display" : "D3611 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de cara cabeza y cuello"
    },
    {
      "code" : "D3612",
      "display" : "D3612 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo extremidad superior incluyendo hombro"
    },
    {
      "code" : "D3613",
      "display" : "D3613 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de extemidad inferior incluyendo cadera"
    },
    {
      "code" : "D3614",
      "display" : "D3614 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de tórax"
    },
    {
      "code" : "D3615",
      "display" : "D3615 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de abdomen"
    },
    {
      "code" : "D3616",
      "display" : "D3616 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de pelvis"
    },
    {
      "code" : "D3617",
      "display" : "D3617 Neoplasia benigna de nervios periféricos y sistema nervioso autónomo de tronco no especificada"
    },
    {
      "code" : "D367",
      "display" : "D367 Neoplasia benigna de otras localizaciones especificadas"
    },
    {
      "code" : "D369",
      "display" : "D369 Neoplasia benigna localización no especificada"
    },
    {
      "code" : "D3A",
      "display" : "D3A Tumores neuroendocrinos benignos"
    },
    {
      "code" : "D3A0",
      "display" : "D3A0 Tumores carcinoides benignos"
    },
    {
      "code" : "D3A00",
      "display" : "D3A00 Tumor carcinoide benigno de localización no especificada"
    },
    {
      "code" : "D3A01",
      "display" : "D3A01 Tumores carcinoides benignos de intestino delgado"
    },
    {
      "code" : "D3A010",
      "display" : "D3A010 Tumor carcinoide benigno de duodeno"
    },
    {
      "code" : "D3A011",
      "display" : "D3A011 Tumor carcinoide benigno de yeyuno"
    },
    {
      "code" : "D3A012",
      "display" : "D3A012 Tumor carcinoide benigno de íleon"
    },
    {
      "code" : "D3A019",
      "display" : "D3A019 Tumor carcinoide benigno de intestino delgado porción no especificada"
    },
    {
      "code" : "D3A02",
      "display" : "D3A02 Tumores carcinoides benignos de apéndice intestino grueso y recto"
    },
    {
      "code" : "D3A020",
      "display" : "D3A020 Tumor carcinoide benigno de apéndice"
    },
    {
      "code" : "D3A021",
      "display" : "D3A021 Tumor carcinoide benigno de ciego"
    },
    {
      "code" : "D3A023",
      "display" : "D3A023 Tumor carcinoide benigno de colon transverso"
    },
    {
      "code" : "D3A024",
      "display" : "D3A024 Tumor carcinoide benigno de colon descendente"
    },
    {
      "code" : "D3A025",
      "display" : "D3A025 Tumor carcinoide benigno de colon sigmoide"
    },
    {
      "code" : "D3A029",
      "display" : "D3A029 Tumor carcinoide benigno de intestino grueso porción no especificada"
    },
    {
      "code" : "D3A09",
      "display" : "D3A09 Tumores carcinoides benignos de otras localizaciones"
    },
    {
      "code" : "D3A090",
      "display" : "D3A090 Tumor carcinoide benigno de bronquio y pulmón"
    },
    {
      "code" : "D3A092",
      "display" : "D3A092 Tumor carcinoide benigno de estómago"
    },
    {
      "code" : "D3A093",
      "display" : "D3A093 Tumor carcinoide benigno de riñón"
    },
    {
      "code" : "D3A095",
      "display" : "D3A095 Tumor carcinoide benigno de intestino medio no especificado"
    },
    {
      "code" : "D3A096",
      "display" : "D3A096 Tumor carcinoide benigno de intestino posterior no especificado"
    },
    {
      "code" : "D3A098",
      "display" : "D3A098 Tumores carcinoides benignos de otras localizaciones"
    },
    {
      "code" : "D3A8",
      "display" : "D3A8 Otros tumores neuroendocrinos benignos"
    },
    {
      "code" : "D370",
      "display" : "D370 Neoplasia de comportamiento incierto de labio cavidad oral y faringe"
    },
    {
      "code" : "D3701",
      "display" : "D3701 Neoplasia de comportamiento incierto de labio"
    },
    {
      "code" : "D356",
      "display" : "D356 Neoplasia benigna de cuerpo aórtico y otros paraganglios"
    },
    {
      "code" : "D3702",
      "display" : "D3702 Neoplasia de comportamiento incierto de la lengua"
    },
    {
      "code" : "D37030",
      "display" : "D37030 Neoplasia de comportamiento incierto de glándulas salivales parótidas"
    },
    {
      "code" : "D37031",
      "display" : "D37031 Neoplasia de comportamiento incierto de glándulas salivales sublinguales"
    },
    {
      "code" : "D37032",
      "display" : "D37032 Neoplasia de comportamiento incierto de glándulas salivales submandibulares"
    },
    {
      "code" : "D3704",
      "display" : "D3704 Neoplasia de comportamiento incierto de glándulas salivales menores"
    },
    {
      "code" : "D3705",
      "display" : "D3705 Neoplasia de comportamiento incierto de faringe"
    },
    {
      "code" : "D3709",
      "display" : "D3709 Neoplasia de comportamiento incierto de otras localizaciones especificadas de cavidad oral"
    },
    {
      "code" : "D371",
      "display" : "D371 Neoplasia de comportamiento incierto de estómago"
    },
    {
      "code" : "D372",
      "display" : "D372 Neoplasia de comportamiento incierto de intestino delgado"
    },
    {
      "code" : "A504",
      "display" : "A504 Neurosífilis congénita tardía [neurosífilis juvenil]"
    },
    {
      "code" : "A5040",
      "display" : "A5040 Neurosífilis congénita tardía no especificada"
    },
    {
      "code" : "A5041",
      "display" : "A5041 Meningitis sifilítica congénita tardía"
    },
    {
      "code" : "A5042",
      "display" : "A5042 Encefalitis sifilítica congénita tardía"
    },
    {
      "code" : "A5043",
      "display" : "A5043 Polineuropatía sifilítica congénita tardía"
    },
    {
      "code" : "A5044",
      "display" : "A5044 Atrofia sifilítica congénita tardía del nervio óptico"
    },
    {
      "code" : "A5045",
      "display" : "A5045 Paresia general juvenil"
    },
    {
      "code" : "A5049",
      "display" : "A5049 Otras neurosífilis congénitas tardías"
    },
    {
      "code" : "A505",
      "display" : "A505 Otras formas de sífilis congénita tardía sintomática"
    },
    {
      "code" : "A5051",
      "display" : "A5051 Articulaciones de Clutton"
    },
    {
      "code" : "A5052",
      "display" : "A5052 Dientes de Hutchinson"
    },
    {
      "code" : "A5053",
      "display" : "A5053 Tríada de Hutchinson"
    },
    {
      "code" : "A5054",
      "display" : "A5054 Sífilis cardiovascular congénita tardía"
    },
    {
      "code" : "A5055",
      "display" : "A5055 Artropatía sifilítica congénita tardía"
    },
    {
      "code" : "A5056",
      "display" : "A5056 Osteocondropatía sifilítica congénita tardía"
    },
    {
      "code" : "A5057",
      "display" : "A5057 Nariz en silla de montar sifilítica"
    },
    {
      "code" : "A5059",
      "display" : "A5059 Otras sífilis congénitas tardías sintomáticas"
    },
    {
      "code" : "A506",
      "display" : "A506 Sífilis congénita tardía latente"
    },
    {
      "code" : "A507",
      "display" : "A507 Sífilis congénita tardía no especificada"
    },
    {
      "code" : "A509",
      "display" : "A509 Sífilis congénita no especificada"
    },
    {
      "code" : "A51",
      "display" : "A51 Sífilis precoz"
    },
    {
      "code" : "A510",
      "display" : "A510 Sífilis genital primaria"
    },
    {
      "code" : "A511",
      "display" : "A511 Sífilis primaria anal"
    },
    {
      "code" : "A512",
      "display" : "A512 Sífilis primaria de otra localización"
    },
    {
      "code" : "A5131",
      "display" : "A5131 Condiloma latum"
    },
    {
      "code" : "A5132",
      "display" : "A5132 Alopecia sifilítica"
    },
    {
      "code" : "A5139",
      "display" : "A5139 Otras sífilis secundarias de piel"
    },
    {
      "code" : "A5141",
      "display" : "A5141 Meningitis sifilítica secundaria"
    },
    {
      "code" : "A5142",
      "display" : "A5142 Enfermedad pélvica femenina sifilítica secundaria"
    },
    {
      "code" : "A5143",
      "display" : "A5143 Oculopatía sifilítica secundaria"
    },
    {
      "code" : "A5144",
      "display" : "A5144 Nefritis sifilíticas secundarias"
    },
    {
      "code" : "A5145",
      "display" : "A5145 Hepatitis sifilítica secundaria"
    },
    {
      "code" : "A5146",
      "display" : "A5146 Osteopatía sifilítica secundaria"
    },
    {
      "code" : "A515",
      "display" : "A515 Sífilis precoz latente"
    },
    {
      "code" : "A519",
      "display" : "A519 Sífilis precoz no especificada"
    },
    {
      "code" : "A52",
      "display" : "A52 Sífilis tardía"
    },
    {
      "code" : "A5200",
      "display" : "A5200 Sífilis cardiovascular no especificada"
    },
    {
      "code" : "A5201",
      "display" : "A5201 Aneurisma sifilítico de aorta"
    },
    {
      "code" : "A5202",
      "display" : "A5202 Aortitis sifilítica"
    },
    {
      "code" : "A5204",
      "display" : "A5204 Arteritis cerebral sifilítica"
    },
    {
      "code" : "A5205",
      "display" : "A5205 Otras sífilis cerebrovasculares"
    },
    {
      "code" : "A5209",
      "display" : "A5209 Otras sífilis cardiovascular"
    },
    {
      "code" : "A521",
      "display" : "A521 Neurosífilis sintomática"
    },
    {
      "code" : "A5210",
      "display" : "A5210 Neurosífilis sintomática no especificada"
    },
    {
      "code" : "A5212",
      "display" : "A5212 Otras sífilis cefalorraquídeas"
    },
    {
      "code" : "A5213",
      "display" : "A5213 Meningitis sifilítica tardía"
    },
    {
      "code" : "A5215",
      "display" : "A5215 Neuropatía sifilítica tardía"
    },
    {
      "code" : "A5216",
      "display" : "A5216 Artropatía de Charcôt (tabética)"
    },
    {
      "code" : "A5217",
      "display" : "A5217 Parálisis general"
    },
    {
      "code" : "A522",
      "display" : "A522 Neurosífilis asintomática"
    },
    {
      "code" : "A523",
      "display" : "A523 Neurosífilis no especificada"
    },
    {
      "code" : "A5271",
      "display" : "A5271 Oculopatía sifilítica tardía"
    },
    {
      "code" : "A5272",
      "display" : "A5272 Sífilis de pulmón y bronquios"
    },
    {
      "code" : "A5273",
      "display" : "A5273 Sífilis sintomática tardía de otros órganos respiratorios"
    },
    {
      "code" : "A5275",
      "display" : "A5275 Sífilis de riñón y de uréter"
    },
    {
      "code" : "A5276",
      "display" : "A5276 Otros tipos de sífilis tardía sintomática genitourinaria"
    },
    {
      "code" : "A5277",
      "display" : "A5277 Sífilis de huesos y articulaciones"
    },
    {
      "code" : "A5279",
      "display" : "A5279 Otras sífilis sintomática tardía"
    },
    {
      "code" : "A528",
      "display" : "A528 Sífilis tardía latente"
    },
    {
      "code" : "A529",
      "display" : "A529 Sífilis tardía no especificada"
    },
    {
      "code" : "C3482",
      "display" : "C3482 Neoplasia maligna de localizaciones contiguas de bronquio y pulmón izquierdo"
    },
    {
      "code" : "C349",
      "display" : "C349 Neoplasia maligna de parte no especificada de bronquio o pulmón"
    },
    {
      "code" : "C3490",
      "display" : "C3490 Neoplasia maligna de parte no especificada bronquio o pulmón no especificados"
    },
    {
      "code" : "C3491",
      "display" : "C3491 Neoplasia maligna de parte no especificada de pulmón o bronquio derecho"
    },
    {
      "code" : "C3492",
      "display" : "C3492 Neoplasia maligna de parte no especificada de pulmón o bronquio izquierdo"
    },
    {
      "code" : "C37",
      "display" : "C37 Neoplasia maligna de timo"
    },
    {
      "code" : "C38",
      "display" : "C38 Neoplasia maligna de corazón mediastino y pleura"
    },
    {
      "code" : "C380",
      "display" : "C380 Neoplasia maligna de corazón"
    },
    {
      "code" : "C381",
      "display" : "C381 Neoplasia maligna de mediastino anterior"
    },
    {
      "code" : "C382",
      "display" : "C382 Neoplasia maligna de mediastino posterior"
    },
    {
      "code" : "C383",
      "display" : "C383 Neoplasia maligna de mediastino parte no especificada"
    },
    {
      "code" : "C384",
      "display" : "C384 Neoplasia maligna de pleura"
    },
    {
      "code" : "C388",
      "display" : "C388 Neoplasia maligna de localizaciones contiguas de corazón mediastino y pleura"
    },
    {
      "code" : "C39",
      "display" : "C39 Neoplasia maligna de otras localizaciones y las mal definidas en aparato respiratorio y órganos intratorácicos"
    },
    {
      "code" : "C390",
      "display" : "C390 Neoplasia maligna de tracto respiratorio superior parte no especificada"
    },
    {
      "code" : "C399",
      "display" : "C399 Neoplasia maligna de tracto respiratorio inferior parte no especificada"
    },
    {
      "code" : "C40",
      "display" : "C40 Neoplasia maligna de hueso y de cartílago articular de extremidades"
    },
    {
      "code" : "C400",
      "display" : "C400 Neoplasia maligna de escápula y huesos largos de extremidad superior"
    },
    {
      "code" : "C4000",
      "display" : "C4000 Neoplasia maligna de escápula y huesos largos de extremidad superior no especificada"
    },
    {
      "code" : "C4001",
      "display" : "C4001 Neoplasia maligna de escápula y huesos largos de extremidad superior derecha"
    },
    {
      "code" : "C4002",
      "display" : "C4002 Neoplasia maligna de escápula y huesos largos de extremidad superior izquierda"
    },
    {
      "code" : "C401",
      "display" : "C401 Neoplasia maligna de huesos cortos de extremidad superior"
    },
    {
      "code" : "C4010",
      "display" : "C4010 Neoplasia maligna de huesos cortos de extremidad superior no especificada"
    },
    {
      "code" : "C4011",
      "display" : "C4011 Neoplasia maligna de huesos cortos de extremidad superior derecha"
    },
    {
      "code" : "C402",
      "display" : "C402 Neoplasia maligna de huesos largos de extremidad inferior"
    },
    {
      "code" : "C4020",
      "display" : "C4020 Neoplasia maligna de huesos largos de extremidad inferior no especificada"
    },
    {
      "code" : "C4021",
      "display" : "C4021 Neoplasia maligna de huesos largos de extremidad inferior derecha"
    },
    {
      "code" : "C4022",
      "display" : "C4022 Neoplasia maligna de huesos largos de extremidad inferior izquierda"
    },
    {
      "code" : "C4030",
      "display" : "C4030 Neoplasia maligna de huesos cortos de extremidad inferior no especificada"
    },
    {
      "code" : "C4031",
      "display" : "C4031 Neoplasia maligna de huesos cortos de extremidad inferior derecha"
    },
    {
      "code" : "C4032",
      "display" : "C4032 Neoplasia maligna de huesos cortos de extremidad inferior izquierda"
    },
    {
      "code" : "C4080",
      "display" : "C4080 Neoplasia maligna de localizaciones contiguas de hueso y cartílago articular de extremidad no especificada"
    },
    {
      "code" : "C4081",
      "display" : "C4081 Neoplasia maligna de localizaciones contiguas de hueso y cartílago articular de extremidad derecha"
    },
    {
      "code" : "C4082",
      "display" : "C4082 Neoplasia maligna de localizaciones contiguas de hueso y cartílago articular de extremidad izquierda"
    },
    {
      "code" : "C409",
      "display" : "C409 Neoplasia maligna de huesos y cartílago articular no especificados de extremidad"
    },
    {
      "code" : "C4090",
      "display" : "C4090 Neoplasia maligna de huesos y cartílago articular no especificados de extremidad no especificada"
    },
    {
      "code" : "C4092",
      "display" : "C4092 Neoplasia maligna de huesos y cartílago articular no especificados de extremidad izquierda"
    },
    {
      "code" : "C41",
      "display" : "C41 Neoplasia maligna de hueso y de cartílago articular de otras localizaciones y las no especificadas"
    },
    {
      "code" : "C410",
      "display" : "C410 Neoplasia maligna de huesos de cráneo y cara"
    },
    {
      "code" : "C411",
      "display" : "C411 Neoplasia maligna de mandíbula"
    },
    {
      "code" : "C413",
      "display" : "C413 Neoplasia maligna de costillas esternón y clavícula"
    },
    {
      "code" : "C414",
      "display" : "C414 Neoplasia maligna de huesos de pelvis sacro y cóccix"
    },
    {
      "code" : "C419",
      "display" : "C419 Neoplasia maligna de hueso y cartílago articular no especificada"
    },
    {
      "code" : "C430",
      "display" : "C430 Melanoma maligno de labio"
    },
    {
      "code" : "C431",
      "display" : "C431 Melanoma maligno de párpado incluyendo canto"
    },
    {
      "code" : "C4311",
      "display" : "C4311 Melanoma maligno de párpado derecho incluyendo canto"
    },
    {
      "code" : "C43111",
      "display" : "C43111 Melanoma maligno de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C43112",
      "display" : "C43112 Melanoma maligno de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C8304",
      "display" : "C8304 Linfoma de células B de células pequeñas ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8305",
      "display" : "C8305 Linfoma de células B de células pequeñas ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8306",
      "display" : "C8306 Linfoma de células B de células pequeñas ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8307",
      "display" : "C8307 Linfoma de células B de células pequeñas bazo"
    },
    {
      "code" : "C8308",
      "display" : "C8308 Linfoma de células B de células pequeñas ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8309",
      "display" : "C8309 Linfoma de células B de células pequeñas localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C831",
      "display" : "C831 Linfoma de células del manto"
    },
    {
      "code" : "C8310",
      "display" : "C8310 Linfoma de células del manto localización no especificada"
    },
    {
      "code" : "C8311",
      "display" : "C8311 Linfoma de células del manto ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8312",
      "display" : "C8312 Linfoma de células del manto ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8313",
      "display" : "C8313 Linfoma de células del manto ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8314",
      "display" : "C8314 Linfoma de manto ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8315",
      "display" : "C8315 Linfoma de células del manto ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8316",
      "display" : "C8316 Linfoma de células del manto ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8317",
      "display" : "C8317 Linfoma de células del manto bazo"
    },
    {
      "code" : "C8318",
      "display" : "C8318 Linfoma de células del manto ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8319",
      "display" : "C8319 Linfoma de células del manto localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C833",
      "display" : "C833 Linfoma difuso de células B grandes"
    },
    {
      "code" : "C8330",
      "display" : "C8330 Linfoma difuso de células B grandes localización no especificada"
    },
    {
      "code" : "C8331",
      "display" : "C8331 Linfoma difuso de células B grandes ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8332",
      "display" : "C8332 Linfoma difuso de células B grandes ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8333",
      "display" : "C8333 Linfoma difuso de células B grandes ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8334",
      "display" : "C8334 Linfoma difuso de células B grandes ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8335",
      "display" : "C8335 Linfoma difuso de células B grandes ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8336",
      "display" : "C8336 Linfoma difuso de células B grandes ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8337",
      "display" : "C8337 Linfoma difuso de células B grandes bazo"
    },
    {
      "code" : "C8339",
      "display" : "C8339 Linfoma difuso de células B grandes localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C835",
      "display" : "C835 Linfoma linfoblástico (difuso)"
    },
    {
      "code" : "C8350",
      "display" : "C8350 Linfoma linfoblástico (difuso) localización no especificada"
    },
    {
      "code" : "C8351",
      "display" : "C8351 Linfoma linfoblástico (difuso) ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8352",
      "display" : "C8352 Linfoma linfoblástico (difuso) ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8354",
      "display" : "C8354 Linfoma linfoblástico (difuso) ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8355",
      "display" : "C8355 Linfoma linfoblástico (difuso) ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8356",
      "display" : "C8356 Linfoma linfoblástico (difuso) ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8358",
      "display" : "C8358 Linfoma linfoblástico (difuso) ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8359",
      "display" : "C8359 Linfoma linfoblástico (difuso) localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C837",
      "display" : "C837 Linfoma de Burkitt"
    },
    {
      "code" : "C8371",
      "display" : "C8371 Linfoma de Burkitt ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8372",
      "display" : "C8372 Linfoma de Burkitt ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8373",
      "display" : "C8373 Linfoma de Burkitt ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8375",
      "display" : "C8375 Linfoma de Burkitt ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8376",
      "display" : "C8376 Linfoma de Burkitt ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8377",
      "display" : "C8377 Linfoma de Burkitt bazo"
    },
    {
      "code" : "C8378",
      "display" : "C8378 Linfoma de Burkitt ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C838",
      "display" : "C838 Otros tipos de linfoma no folicular"
    },
    {
      "code" : "C8380",
      "display" : "C8380 Otros tipos de linfoma no folicular localización no especificada"
    },
    {
      "code" : "C8381",
      "display" : "C8381 Otros tipos de linfoma no folicular ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8382",
      "display" : "C8382 Otros tipos de linfoma no folicular ganglios linfáticos intratorácicos"
    },
    {
      "code" : "D375",
      "display" : "D375 Neoplasia de comportamiento incierto de recto"
    },
    {
      "code" : "D376",
      "display" : "D376 Neoplasia de comportamiento incierto de hígado vesícula y conductos biliares"
    },
    {
      "code" : "D378",
      "display" : "D378 Neoplasia de comportamiento incierto de otros órganos especificados de aparato digestivo"
    },
    {
      "code" : "D379",
      "display" : "D379 Neoplasia de comportamiento incierto de órganos digestivos localización no especificada"
    },
    {
      "code" : "D38",
      "display" : "D38 Neoplasia de comportamiento incierto de oído medio y órganos respiratorios e intratorácicos"
    },
    {
      "code" : "D380",
      "display" : "D380 Neoplasia de comportamiento incierto de laringe"
    },
    {
      "code" : "D381",
      "display" : "D381 Neoplasia de comportamiento incierto de tráquea bronquios y pulmón"
    },
    {
      "code" : "D382",
      "display" : "D382 Neoplasia de comportamiento incierto de pleura"
    },
    {
      "code" : "D383",
      "display" : "D383 Neoplasia de comportamiento incierto de mediastino"
    },
    {
      "code" : "D384",
      "display" : "D384 Neoplasia de comportamiento incierto de timo"
    },
    {
      "code" : "D385",
      "display" : "D385 Neoplasia de comportamiento incierto de otros órganos respiratorios"
    },
    {
      "code" : "D386",
      "display" : "D386 Neoplasia de comportamiento incierto de órgano respiratorio localización no especificada"
    },
    {
      "code" : "D39",
      "display" : "D39 Neoplasia de comportamiento incierto de órganos genitales femeninos"
    },
    {
      "code" : "D390",
      "display" : "D390 Neoplasia de comportamiento incierto de útero"
    },
    {
      "code" : "D391",
      "display" : "D391 Neoplasia de comportamiento incierto de ovario"
    },
    {
      "code" : "D3910",
      "display" : "D3910 Neoplasia de comportamiento incierto de ovario no especificado"
    },
    {
      "code" : "D3911",
      "display" : "D3911 Neoplasia de comportamiento incierto de ovario derecho"
    },
    {
      "code" : "D3912",
      "display" : "D3912 Neoplasia de comportamiento incierto de ovario izquierdo"
    },
    {
      "code" : "D392",
      "display" : "D392 Neoplasia de comportamiento incierto de placenta"
    },
    {
      "code" : "D398",
      "display" : "D398 Neoplasia de comportamiento incierto de otros órganos genitales femeninos especificados"
    },
    {
      "code" : "D399",
      "display" : "D399 Neoplasia de comportamiento incierto de órgano genital femenino localización no especificada"
    },
    {
      "code" : "D40",
      "display" : "D40 Neoplasia de comportamiento incierto de órganos genitales masculinos"
    },
    {
      "code" : "D400",
      "display" : "D400 Neoplasia de comportamiento incierto de próstata"
    },
    {
      "code" : "D401",
      "display" : "D401 Neoplasia de comportamiento incierto de testículo"
    },
    {
      "code" : "D4010",
      "display" : "D4010 Neoplasia de comportamiento incierto de testículo no especificado"
    },
    {
      "code" : "D4012",
      "display" : "D4012 Neoplasia de comportamiento incierto de testículo izquierdo"
    },
    {
      "code" : "D408",
      "display" : "D408 Neoplasia de comportamiento incierto de otros órganos genitales masculinos especificados"
    },
    {
      "code" : "D409",
      "display" : "D409 Neoplasia de comportamiento incierto de órganos genitales masculinos localización no especificada"
    },
    {
      "code" : "D41",
      "display" : "D41 Neoplasia de comportamiento incierto de órganos urinarios"
    },
    {
      "code" : "D4100",
      "display" : "D4100 Neoplasia de comportamiento incierto de riñón no especificado"
    },
    {
      "code" : "D4101",
      "display" : "D4101 Neoplasia de comportamiento incierto de riñón derecho"
    },
    {
      "code" : "D4102",
      "display" : "D4102 Neoplasia de comportamiento incierto de riñón izquierdo"
    },
    {
      "code" : "D4110",
      "display" : "D4110 Neoplasia de comportamiento incierto de pelvis renal no especificada"
    },
    {
      "code" : "D4111",
      "display" : "D4111 Neoplasia de comportamiento incierto de pelvis renal derecha"
    },
    {
      "code" : "D4112",
      "display" : "D4112 Neoplasia de comportamiento incierto de pelvis renal izquierda"
    },
    {
      "code" : "D4120",
      "display" : "D4120 Neoplasia de comportamiento incierto de uréter no especificado"
    },
    {
      "code" : "D4121",
      "display" : "D4121 Neoplasia de comportamiento incierto de uréter derecho"
    },
    {
      "code" : "D4122",
      "display" : "D4122 Neoplasia de comportamiento incierto de uréter izquierdo"
    },
    {
      "code" : "D414",
      "display" : "D414 Neoplasia de comportamiento incierto de vejiga"
    },
    {
      "code" : "D418",
      "display" : "D418 Neoplasia de comportamiento incierto de otros órganos urinarios especificados"
    },
    {
      "code" : "D374",
      "display" : "D374 Neoplasia de comportamiento incierto de colon"
    },
    {
      "code" : "D42",
      "display" : "D42 Neoplasia de comportamiento incierto de meninges"
    },
    {
      "code" : "D420",
      "display" : "D420 Neoplasia de comportamiento incierto de meninges cerebrales"
    },
    {
      "code" : "D421",
      "display" : "D421 Neoplasia de comportamiento incierto de meninges espinales"
    },
    {
      "code" : "D429",
      "display" : "D429 Neoplasia de comportamiento incierto de meninges localización no especificada"
    },
    {
      "code" : "D430",
      "display" : "D430 Neoplasia de comportamiento incierto de encéfalo supratentorial"
    },
    {
      "code" : "D431",
      "display" : "D431 Neoplasia de comportamiento incierto de encéfalo infratentorial"
    },
    {
      "code" : "D432",
      "display" : "D432 Neoplasia de comportamiento incierto de encéfalo localización no especificada"
    },
    {
      "code" : "D433",
      "display" : "D433 Neoplasia de comportamiento incierto de nervios craneales"
    },
    {
      "code" : "A53",
      "display" : "A53 Otras sífilis y las no especificadas"
    },
    {
      "code" : "A530",
      "display" : "A530 Sífilis latente no especificada como precoz o tardía"
    },
    {
      "code" : "A539",
      "display" : "A539 Sífilis no especificada"
    },
    {
      "code" : "A54",
      "display" : "A54 Infección gonocócica"
    },
    {
      "code" : "A540",
      "display" : "A540 Infección gonocócica del tracto genitourinario inferior sin absceso periuretral o de glándula accesoria"
    },
    {
      "code" : "A5400",
      "display" : "A5400 Infección gonocócica de tracto genitourinario no especificada"
    },
    {
      "code" : "A5401",
      "display" : "A5401 Cistitis y uretritis gonocócica no especificadas"
    },
    {
      "code" : "A5402",
      "display" : "A5402 Vulvovaginitis gonocócica no especificada"
    },
    {
      "code" : "A5403",
      "display" : "A5403 Cervicitis gonocócica no especificada"
    },
    {
      "code" : "A5409",
      "display" : "A5409 Otras infecciones gonocócicas de tracto genitourinario inferior"
    },
    {
      "code" : "A541",
      "display" : "A541 Infección gonocócica del tracto genitourinario inferior con absceso periuretral y de glándulas accesorias"
    },
    {
      "code" : "A542",
      "display" : "A542 Pelviperitonitis gonocócica y otras infecciones gonocócicas genitourinarias"
    },
    {
      "code" : "A5421",
      "display" : "A5421 Infección gonocócica de riñón y uréter"
    },
    {
      "code" : "A5422",
      "display" : "A5422 Prostatitis gonocócica"
    },
    {
      "code" : "A5423",
      "display" : "A5423 Infección gonocócica de otros órganos genitales masculinos"
    },
    {
      "code" : "A5424",
      "display" : "A5424 Enfermedad pélvica inflamatoria femenina gonocócica"
    },
    {
      "code" : "A5429",
      "display" : "A5429 Otras infecciones genitourinarias gonocócicas"
    },
    {
      "code" : "A543",
      "display" : "A543 Infección gonocócica ocular"
    },
    {
      "code" : "A5430",
      "display" : "A5430 Infección gonocócica ocular no especificada"
    },
    {
      "code" : "A5431",
      "display" : "A5431 Conjuntivitis gonocócica"
    },
    {
      "code" : "A5432",
      "display" : "A5432 Iridociclitis gonocócica"
    },
    {
      "code" : "A5433",
      "display" : "A5433 Queratitis gonocócica"
    },
    {
      "code" : "A5439",
      "display" : "A5439 Otra infección gonocócica ocular"
    },
    {
      "code" : "A544",
      "display" : "A544 Infección gonocócica del sistema osteomuscular"
    },
    {
      "code" : "A5440",
      "display" : "A5440 Infección gonocócica del sistema osteomuscular no especificada"
    },
    {
      "code" : "A5441",
      "display" : "A5441 Espondilopatía gonocócica"
    },
    {
      "code" : "A5442",
      "display" : "A5442 Artritis gonocócica"
    },
    {
      "code" : "A5449",
      "display" : "A5449 Infección gonocócica de otros tejidos osteomusculares"
    },
    {
      "code" : "A545",
      "display" : "A545 Faringitis gonocócica"
    },
    {
      "code" : "A546",
      "display" : "A546 Infección gonocócica del ano y del recto"
    },
    {
      "code" : "A5481",
      "display" : "A5481 Meningitis gonocócica"
    },
    {
      "code" : "A5482",
      "display" : "A5482 Absceso cerebral gonocócico"
    },
    {
      "code" : "A5484",
      "display" : "A5484 Neumonía gonocócica"
    },
    {
      "code" : "A5485",
      "display" : "A5485 Peritonitis gonocócica"
    },
    {
      "code" : "A5486",
      "display" : "A5486 Sepsis gonocócica"
    },
    {
      "code" : "A549",
      "display" : "A549 Infección gonocócica no especificada"
    },
    {
      "code" : "A55",
      "display" : "A55 Linfogranuloma (venéreo) por clamidias"
    },
    {
      "code" : "A560",
      "display" : "A560 Infección del tracto genitourinario inferior debida a clamidias"
    },
    {
      "code" : "A5600",
      "display" : "A5600 Infección del tracto genitourinario inferior debida a clamidias no especificada"
    },
    {
      "code" : "A5601",
      "display" : "A5601 Cistitis y uretritis por clamidias"
    },
    {
      "code" : "A5609",
      "display" : "A5609 Otra infección por clamidias de tracto genitourinario inferior"
    },
    {
      "code" : "A561",
      "display" : "A561 Infección del pelviperitoneo y otros órganos genitourinarios debida a clamidias"
    },
    {
      "code" : "A5611",
      "display" : "A5611 Enfermedad pélvica inflamatoria femenina por clamidias"
    },
    {
      "code" : "A562",
      "display" : "A562 Infecciones del tracto genitourinario debidas a clamidias no especificada"
    },
    {
      "code" : "A563",
      "display" : "A563 Infección del ano y del recto debida a clamidias"
    },
    {
      "code" : "A564",
      "display" : "A564 Infección de faringe debida a clamidias"
    },
    {
      "code" : "A57",
      "display" : "A57 Chancro blando"
    },
    {
      "code" : "A58",
      "display" : "A58 Granuloma inguinal"
    },
    {
      "code" : "A59",
      "display" : "A59 Tricomoniasis"
    },
    {
      "code" : "A590",
      "display" : "A590 Tricomoniasis urogenital"
    },
    {
      "code" : "A5901",
      "display" : "A5901 Vulvovaginitis por tricomonas"
    },
    {
      "code" : "A5902",
      "display" : "A5902 Prostatitis por tricomonas"
    },
    {
      "code" : "A5903",
      "display" : "A5903 Cistitis y uretritis por tricomonas"
    },
    {
      "code" : "A598",
      "display" : "A598 Tricomoniasis de otras localizaciones"
    },
    {
      "code" : "A599",
      "display" : "A599 Tricomoniasis no especificada"
    },
    {
      "code" : "A600",
      "display" : "A600 Infección por herpesvirus de los órganos genitales y del tracto urogenital"
    },
    {
      "code" : "C43122",
      "display" : "C43122 Melanoma maligno de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "C432",
      "display" : "C432 Melanoma maligno de oído y de conducto auditivo externo"
    },
    {
      "code" : "C4320",
      "display" : "C4320 Melanoma maligno de oído y conducto auditivo externo no especificado"
    },
    {
      "code" : "C4321",
      "display" : "C4321 Melanoma maligno de oído y conducto auditivo externo lado derecho"
    },
    {
      "code" : "C4322",
      "display" : "C4322 Melanoma maligno de oído y conducto auditivo externo lado izquierdo"
    },
    {
      "code" : "C433",
      "display" : "C433 Melanoma maligno de otras partes de la cara y las no especificadas"
    },
    {
      "code" : "C4330",
      "display" : "C4330 Melanoma maligno de parte no especificada de la cara"
    },
    {
      "code" : "C4331",
      "display" : "C4331 Melanoma maligno de nariz"
    },
    {
      "code" : "C4339",
      "display" : "C4339 Melanoma maligno de otras partes de la cara"
    },
    {
      "code" : "C434",
      "display" : "C434 Melanoma maligno de cuero cabelludo y cuello"
    },
    {
      "code" : "C435",
      "display" : "C435 Melanoma maligno de tronco"
    },
    {
      "code" : "C4351",
      "display" : "C4351 Melanoma maligno de piel de ano"
    },
    {
      "code" : "C4352",
      "display" : "C4352 Melanoma maligno de piel de mama"
    },
    {
      "code" : "C4359",
      "display" : "C4359 Melanoma maligno de otra parte de tronco"
    },
    {
      "code" : "C436",
      "display" : "C436 Melanoma maligno de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C4360",
      "display" : "C4360 Melanoma maligno de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C4361",
      "display" : "C4361 Melanoma maligno de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C4362",
      "display" : "C4362 Melanoma maligno de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C437",
      "display" : "C437 Melanoma maligno de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "C4370",
      "display" : "C4370 Melanoma maligno de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C4371",
      "display" : "C4371 Melanoma maligno de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C4372",
      "display" : "C4372 Melanoma maligno de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "C438",
      "display" : "C438 Melanoma maligno de localizaciones contiguas de piel"
    },
    {
      "code" : "C439",
      "display" : "C439 Melanoma maligno de piel no especificado"
    },
    {
      "code" : "C4A",
      "display" : "C4A Carcinoma de células de Merkel"
    },
    {
      "code" : "C4A1",
      "display" : "C4A1 Carcinoma de células de Merkel de párpado incluyendo canto"
    },
    {
      "code" : "C4A10",
      "display" : "C4A10 Carcinoma de células de Merkel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C4A11",
      "display" : "C4A11 Carcinoma de células de Merkel de párpado derecho incluyendo canto"
    },
    {
      "code" : "C4A112",
      "display" : "C4A112 Carcinoma de células de Merkel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C4A12",
      "display" : "C4A12 Carcinoma de células de Merkel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C4A121",
      "display" : "C4A121 Carcinoma de células de Merkel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C4A122",
      "display" : "C4A122 Carcinoma de células de Merkel de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "C4A20",
      "display" : "C4A20 Carcinoma de células de Merkel de oído y conducto auditivo externo no especificado"
    },
    {
      "code" : "C4A21",
      "display" : "C4A21 Carcinoma de células de Merkel de oído y conducto auditivo externo derecho"
    },
    {
      "code" : "C43121",
      "display" : "C43121 Melanoma maligno de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C4A22",
      "display" : "C4A22 Carcinoma de células de Merkel de oído y conducto auditivo externo izquierdo"
    },
    {
      "code" : "C4A30",
      "display" : "C4A30 Carcinoma de células de Merkel de parte no especificada de cara"
    },
    {
      "code" : "C4A31",
      "display" : "C4A31 Carcinoma de células de Merkel de nariz"
    },
    {
      "code" : "C4A39",
      "display" : "C4A39 Carcinoma de células de Merkel de otras partes de cara"
    },
    {
      "code" : "C4A4",
      "display" : "C4A4 Carcinoma de células de Merkel de cuero cabelludo y cuello"
    },
    {
      "code" : "C4A51",
      "display" : "C4A51 Carcinoma de células de Merkel de piel de ano"
    },
    {
      "code" : "C4A52",
      "display" : "C4A52 Carcinoma de células de Merkel de piel de mama"
    },
    {
      "code" : "C4A59",
      "display" : "C4A59 Carcinoma de células de Merkel de otra parte de tronco"
    },
    {
      "code" : "C4A60",
      "display" : "C4A60 Carcinoma de células de Merkel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C4A61",
      "display" : "C4A61 Carcinoma de células de Merkel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C4A62",
      "display" : "C4A62 Carcinoma de células de Merkel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C4A70",
      "display" : "C4A70 Carcinoma de células de Merkel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C4A71",
      "display" : "C4A71 Carcinoma de células de Merkel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C4A72",
      "display" : "C4A72 Carcinoma de células de Merkel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "C4A8",
      "display" : "C4A8 Carcinoma de células de Merkel de localizaciones contiguas"
    },
    {
      "code" : "C8383",
      "display" : "C8383 Otros tipos de linfoma no folicular ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8384",
      "display" : "C8384 Otros tipos de linfoma no folicular ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8385",
      "display" : "C8385 Otros tipos de linfoma no folicular ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8386",
      "display" : "C8386 Otros tipos de linfoma no folicular ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8387",
      "display" : "C8387 Otros tipos de linfoma no folicular bazo"
    },
    {
      "code" : "C8388",
      "display" : "C8388 Otros tipos de linfoma no folicular ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8389",
      "display" : "C8389 Otros tipos de linfoma no folicular localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C839",
      "display" : "C839 Linfoma (difuso) no folicular no especificado"
    },
    {
      "code" : "C8390",
      "display" : "C8390 Linfoma (difuso) no folicular no especificado localización no especificada"
    },
    {
      "code" : "C8391",
      "display" : "C8391 Linfoma (difuso) no folicular no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8392",
      "display" : "C8392 Linfoma (difuso) no folicular no especificado ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8393",
      "display" : "C8393 Linfoma (difuso) no folicular no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8394",
      "display" : "C8394 Linfoma (difuso) no folicular no especificado ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8395",
      "display" : "C8395 Linfoma (difuso) no folicular no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8396",
      "display" : "C8396 Linfoma (difuso) no folicular no especificado ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8397",
      "display" : "C8397 Linfoma (difuso) no folicular no especificado bazo"
    },
    {
      "code" : "C8398",
      "display" : "C8398 Linfoma (difuso) no folicular no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8399",
      "display" : "C8399 Linfoma (difuso) no folicular no especificado localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C84",
      "display" : "C84 Linfomas de células T/NK maduras"
    },
    {
      "code" : "C840",
      "display" : "C840 Micosis fungoide"
    },
    {
      "code" : "C8400",
      "display" : "C8400 Micosis fungoide localización no especificada"
    },
    {
      "code" : "C8401",
      "display" : "C8401 Micosis fungoide ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8402",
      "display" : "C8402 Micosis fungoide ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8403",
      "display" : "C8403 Micosis fungoide ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8405",
      "display" : "C8405 Micosis fungoide ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8406",
      "display" : "C8406 Micosis fungoide ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8407",
      "display" : "C8407 Micosis fungoide bazo"
    },
    {
      "code" : "C8408",
      "display" : "C8408 Micosis fungoide ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C841",
      "display" : "C841 Enfermedad de Sézary"
    },
    {
      "code" : "C8410",
      "display" : "C8410 Síndrome de Sézary localización no especificada"
    },
    {
      "code" : "C8411",
      "display" : "C8411 Síndrome de Sézary ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8412",
      "display" : "C8412 Síndrome de Sézary ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8414",
      "display" : "C8414 Síndrome de Sézary ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8415",
      "display" : "C8415 Síndrome de Sézary ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8416",
      "display" : "C8416 Síndrome de Sézary ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8418",
      "display" : "C8418 Síndrome de Sézary ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8419",
      "display" : "C8419 Síndrome de Sézary localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C844",
      "display" : "C844 Linfoma periférico de células T no clasificado bajo otro concepto"
    },
    {
      "code" : "C8441",
      "display" : "C8441 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8442",
      "display" : "C8442 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8443",
      "display" : "C8443 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8444",
      "display" : "C8444 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8446",
      "display" : "C8446 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8447",
      "display" : "C8447 Linfoma periférico de células T no clasificado bajo otro concepto bazo"
    },
    {
      "code" : "C8448",
      "display" : "C8448 Linfoma periférico de células T no clasificado bajo otro concepto ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8449",
      "display" : "C8449 Linfoma periférico de células T no clasificado bajo otro concepto localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "D438",
      "display" : "D438 Neoplasia de comportamiento incierto de otras partes especificadas de sistema nervioso central"
    },
    {
      "code" : "D439",
      "display" : "D439 Neoplasia de comportamiento incierto del sistema nervioso central localización no especificada"
    },
    {
      "code" : "D44",
      "display" : "D44 Neoplasia de comportamiento incierto de glándulas endocrinas"
    },
    {
      "code" : "D440",
      "display" : "D440 Neoplasia de comportamiento incierto de glándula tiroides"
    },
    {
      "code" : "D441",
      "display" : "D441 Neoplasia de comportamiento incierto de glándula suprarrenal"
    },
    {
      "code" : "D4410",
      "display" : "D4410 Neoplasia de comportamiento incierto de glándula suprarrenal no especificada"
    },
    {
      "code" : "D4411",
      "display" : "D4411 Neoplasia de comportamiento incierto de glándula suprarrenal derecha"
    },
    {
      "code" : "D4412",
      "display" : "D4412 Neoplasia de comportamiento incierto de glándula suprarrenal izquierda"
    },
    {
      "code" : "D442",
      "display" : "D442 Neoplasia de comportamiento incierto de glándula paratiroides"
    },
    {
      "code" : "D443",
      "display" : "D443 Neoplasia de comportamiento incierto de hipófisis"
    },
    {
      "code" : "D444",
      "display" : "D444 Neoplasia de comportamiento incierto de conducto craneofaríngeo"
    },
    {
      "code" : "D445",
      "display" : "D445 Neoplasia de comportamiento incierto de glándula pineal"
    },
    {
      "code" : "D446",
      "display" : "D446 Neoplasia de comportamiento incierto de cuerpo carotídeo"
    },
    {
      "code" : "D447",
      "display" : "D447 Neoplasia de comportamiento incierto de cuerpo aórtico y otros paraganglios"
    },
    {
      "code" : "D449",
      "display" : "D449 Neoplasia de comportamiento incierto de glándula endocrina no especificada"
    },
    {
      "code" : "D45",
      "display" : "D45 Policitemia vera"
    },
    {
      "code" : "D46",
      "display" : "D46 Síndromes mielodisplásicos"
    },
    {
      "code" : "D460",
      "display" : "D460 Anemia refractaria sin sideroblastos en anillo descrita como tal"
    },
    {
      "code" : "D461",
      "display" : "D461 Anemia refractaria con sideroblastos en anillo"
    },
    {
      "code" : "D462",
      "display" : "D462 Anemia refractaria con exceso de blastos [AREB]"
    },
    {
      "code" : "D4620",
      "display" : "D4620 Anemia refractaria con exceso de blastos no especificada"
    },
    {
      "code" : "D4621",
      "display" : "D4621 Anemia refractaria con exceso de blastos 1"
    },
    {
      "code" : "D4622",
      "display" : "D4622 Anemia refractaria con exceso de blastos 2"
    },
    {
      "code" : "D46A",
      "display" : "D46A Citopenia refractaria con displasia multilineal"
    },
    {
      "code" : "D46B",
      "display" : "D46B Citopenia refractaria con displasia multilineal y sideroblastos en anillo"
    },
    {
      "code" : "D46C",
      "display" : "D46C Síndrome mielodisplásico con anomalía cromosómica con supresión (5q) aislada"
    },
    {
      "code" : "D464",
      "display" : "D464 Anemia refractaria no especificada"
    },
    {
      "code" : "D469",
      "display" : "D469 Síndrome mielodisplásico no especificado"
    },
    {
      "code" : "D47",
      "display" : "D47 Otras neoplasias de comportamiento incierto de tejido linfático hemopoyético y relacionados"
    },
    {
      "code" : "D470",
      "display" : "D470 Neoplasias de mastocitos de comportamiento incierto"
    },
    {
      "code" : "D4702",
      "display" : "D4702 Mastocitosis sistémica"
    },
    {
      "code" : "D4709",
      "display" : "D4709 Otras neoplasias de mastocitos de comportamiento incierto"
    },
    {
      "code" : "D472",
      "display" : "D472 Gammapatía monoclonal"
    },
    {
      "code" : "D473",
      "display" : "D473 Trombocitemia esencial (hemorrágica)"
    },
    {
      "code" : "D474",
      "display" : "D474 Osteomielofibrosis"
    },
    {
      "code" : "D47Z1",
      "display" : "D47Z1 Trastorno linfoproliferativo postrasplante (TLPT)"
    },
    {
      "code" : "D47Z2",
      "display" : "D47Z2 Enfermedad de Castleman"
    },
    {
      "code" : "D47Z9",
      "display" : "D47Z9 Otros tumores especificados de comportamiento incierto de tejido linfático hemopoyético y relacionados"
    },
    {
      "code" : "D479",
      "display" : "D479 Neoplasia de comportamiento incierto de tejido linfático hemopoyético y relacionados no especificada"
    },
    {
      "code" : "D48",
      "display" : "D48 Neoplasia de comportamiento incierto de otras localizaciones y las no especificadas"
    },
    {
      "code" : "D481",
      "display" : "D481 Neoplasia de comportamiento incierto de tejido conjuntivo y otros tejidos blandos"
    },
    {
      "code" : "D482",
      "display" : "D482 Neoplasia de comportamiento incierto de nervios periféricos y sistema nervioso autónomo"
    },
    {
      "code" : "D483",
      "display" : "D483 Neoplasia de comportamiento incierto de retroperitoneo"
    },
    {
      "code" : "D485",
      "display" : "D485 Neoplasia de comportamiento incierto de piel"
    },
    {
      "code" : "D486",
      "display" : "D486 Neoplasia de comportamiento incierto de mama"
    },
    {
      "code" : "D4860",
      "display" : "D4860 Neoplasia de comportamiento incierto de mama no especificada"
    },
    {
      "code" : "D4862",
      "display" : "D4862 Neoplasia de comportamiento incierto de mama izquierda"
    },
    {
      "code" : "D487",
      "display" : "D487 Neoplasia de comportamiento incierto de otras localizaciones especificadas"
    },
    {
      "code" : "D489",
      "display" : "D489 Neoplasia de comportamiento incierto no especificada"
    },
    {
      "code" : "D490",
      "display" : "D490 Neoplasia de comportamiento no especificado de aparato digestivo"
    },
    {
      "code" : "D491",
      "display" : "D491 Neoplasia de comportamiento no especificado de aparato respiratorio"
    },
    {
      "code" : "A6000",
      "display" : "A6000 Infección por herpesvirus del sistema urogenital no especificada"
    },
    {
      "code" : "A6001",
      "display" : "A6001 Infección por herpesvirus del pene"
    },
    {
      "code" : "A6002",
      "display" : "A6002 Infección por herpesvirus de otros órganos genitales masculinos"
    },
    {
      "code" : "A6003",
      "display" : "A6003 Cervicitis por herpesvirus"
    },
    {
      "code" : "A6004",
      "display" : "A6004 Vulvovaginitis por herpesvirus"
    },
    {
      "code" : "A6009",
      "display" : "A6009 Otras infecciones por herpesvirus del tracto urogenital"
    },
    {
      "code" : "A601",
      "display" : "A601 Infección de la piel perianal y recto por virus del herpes simple"
    },
    {
      "code" : "A609",
      "display" : "A609 Infección anogenital por virus del herpes simple no especificada"
    },
    {
      "code" : "A63",
      "display" : "A63 Otras enfermedades de transmisión predominantemente sexual no clasificadas bajo otro concepto"
    },
    {
      "code" : "A630",
      "display" : "A630 Verrugas (venéreas) anogenitales"
    },
    {
      "code" : "A638",
      "display" : "A638 Otras enfermedades de transmisión predominantemente sexual especificadas"
    },
    {
      "code" : "A64",
      "display" : "A64 Enfermedad de transmisión sexual no especificada"
    },
    {
      "code" : "A65",
      "display" : "A65 Sífilis no venérea"
    },
    {
      "code" : "A66",
      "display" : "A66 Pian"
    },
    {
      "code" : "A660",
      "display" : "A660 Lesiones iniciales por pian"
    },
    {
      "code" : "A661",
      "display" : "A661 Papilomas múltiples y pian de ladilla"
    },
    {
      "code" : "A662",
      "display" : "A662 Otras lesiones tempranas de piel por pian"
    },
    {
      "code" : "A663",
      "display" : "A663 Hiperqueratosis del pian"
    },
    {
      "code" : "A664",
      "display" : "A664 Gomas y úlceras por pian"
    },
    {
      "code" : "A665",
      "display" : "A665 Gangosa"
    },
    {
      "code" : "A666",
      "display" : "A666 Lesiones óseas y de articulaciones por pian"
    },
    {
      "code" : "A667",
      "display" : "A667 Otras manifestaciones del pian"
    },
    {
      "code" : "A668",
      "display" : "A668 Pian latente"
    },
    {
      "code" : "A669",
      "display" : "A669 Pian no especificado"
    },
    {
      "code" : "A67",
      "display" : "A67 Pinta [carate]"
    },
    {
      "code" : "A670",
      "display" : "A670 Lesiones primarias de pinta"
    },
    {
      "code" : "A672",
      "display" : "A672 Lesiones tardías de pinta"
    },
    {
      "code" : "A673",
      "display" : "A673 Lesiones mixtas de pinta"
    },
    {
      "code" : "A68",
      "display" : "A68 Fiebre recidivante"
    },
    {
      "code" : "A680",
      "display" : "A680 Fiebre recurrente transmitida por piojos"
    },
    {
      "code" : "A689",
      "display" : "A689 Fiebre recurrente no especificada"
    },
    {
      "code" : "A69",
      "display" : "A69 Otras infecciones por espiroquetas"
    },
    {
      "code" : "A690",
      "display" : "A690 Estomatitis ulcerativa necrotizante"
    },
    {
      "code" : "A692",
      "display" : "A692 Enfermedad de Lyme"
    },
    {
      "code" : "A6920",
      "display" : "A6920 Enfermedad de Lyme no especificada"
    },
    {
      "code" : "A6921",
      "display" : "A6921 Meningitis por enfermedad de Lyme"
    },
    {
      "code" : "A6923",
      "display" : "A6923 Artritis debida a enfermedad de Lyme"
    },
    {
      "code" : "A6929",
      "display" : "A6929 Otras afecciones asociadas con enfermedad de Lyme"
    },
    {
      "code" : "A698",
      "display" : "A698 Otras infecciones por espiroquetas especificadas"
    },
    {
      "code" : "A70",
      "display" : "A70 Clamidia psittaci infecciones"
    },
    {
      "code" : "A71",
      "display" : "A71 Tracoma"
    },
    {
      "code" : "A710",
      "display" : "A710 Etapa inicial de tracoma"
    },
    {
      "code" : "A719",
      "display" : "A719 Tracoma no especificado"
    },
    {
      "code" : "A74",
      "display" : "A74 Otras enfermedades causadas por clamidias"
    },
    {
      "code" : "A748",
      "display" : "A748 Otras enfermedades por clamidias"
    },
    {
      "code" : "A7481",
      "display" : "A7481 Peritonitis por clamidias"
    },
    {
      "code" : "A749",
      "display" : "A749 Infección por clamidias no especificada"
    },
    {
      "code" : "A75",
      "display" : "A75 Fiebre tifoidea"
    },
    {
      "code" : "A750",
      "display" : "A750 Tifus epidémico transmitido por piojos debido a Rickettsia prowazekii"
    },
    {
      "code" : "A752",
      "display" : "A752 Tifus debido a Rickettsia typhi"
    },
    {
      "code" : "A753",
      "display" : "A753 Tifus por Rickettsia tsutsugamushi"
    },
    {
      "code" : "A759",
      "display" : "A759 Tifus no especificado"
    },
    {
      "code" : "A770",
      "display" : "A770 Fiebre maculosa por Rickettsia rickettsii"
    },
    {
      "code" : "A771",
      "display" : "A771 Fiebre maculosa por Rickettsia conorii"
    },
    {
      "code" : "A772",
      "display" : "A772 Fiebre maculosa por Rickettsia siberica"
    },
    {
      "code" : "A774",
      "display" : "A774 Erliquiosis"
    },
    {
      "code" : "A7740",
      "display" : "A7740 Erliquiosis no especificada"
    },
    {
      "code" : "A7741",
      "display" : "A7741 Erliquiosis chafeensis [E. Chafeensis]"
    },
    {
      "code" : "A778",
      "display" : "A778 Otras fiebres maculosas"
    },
    {
      "code" : "A779",
      "display" : "A779 Fiebre maculosa no especificada"
    },
    {
      "code" : "C4A9",
      "display" : "C4A9 Carcinoma de células de Merkel no especificado"
    },
    {
      "code" : "C44",
      "display" : "C44 Otras neoplasias malignas y las no especificadas de piel"
    },
    {
      "code" : "C440",
      "display" : "C440 Otra neoplasia maligna y las no especificadas de piel de labio"
    },
    {
      "code" : "C4400",
      "display" : "C4400 Neoplasia maligna no especificada de piel de labio"
    },
    {
      "code" : "C4401",
      "display" : "C4401 Carcinoma basocelular de piel de labio"
    },
    {
      "code" : "C4402",
      "display" : "C4402 Carcinoma de células escamosas de piel de labio"
    },
    {
      "code" : "C4409",
      "display" : "C4409 Otra neoplasia maligna especificada de piel de labio"
    },
    {
      "code" : "C441",
      "display" : "C441 Otra neoplasia maligna y las no especificadas de piel de párpado incluyendo canto"
    },
    {
      "code" : "C4410",
      "display" : "C4410 Neoplasia maligna no especificada de piel de párpado incluyendo canto"
    },
    {
      "code" : "C44101",
      "display" : "C44101 Neoplasia maligna no especificada de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C44102",
      "display" : "C44102 Neoplasia maligna no especificada de piel de párpado derecho incluyendo canto"
    },
    {
      "code" : "C441021",
      "display" : "C441021 Neoplasia maligna no especificada de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C441022",
      "display" : "C441022 Neoplasia maligna no especificada de piel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C44109",
      "display" : "C44109 Neoplasia maligna no especificada de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C441091",
      "display" : "C441091 Neoplasia maligna no especificada de piel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C441092",
      "display" : "C441092 Neoplasia maligna no especificada de piel de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "C4411",
      "display" : "C4411 Carcinoma basocelular de piel de párpado incluyendo canto"
    },
    {
      "code" : "C44111",
      "display" : "C44111 Carcinoma basocelular de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C44112",
      "display" : "C44112 Carcinoma basocelular de piel de párpado derecho incluyendo canto"
    },
    {
      "code" : "C441121",
      "display" : "C441121 Carcinoma basocelular de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C441122",
      "display" : "C441122 Carcinoma basocelular de piel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C44119",
      "display" : "C44119 Carcinoma basocelular de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C441191",
      "display" : "C441191 Carcinoma basocelular de piel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C441192",
      "display" : "C441192 Carcinoma basocelular de piel de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "C4412",
      "display" : "C4412 Carcinoma de células escamosas de piel de párpado incluyendo canto"
    },
    {
      "code" : "C44121",
      "display" : "C44121 Carcinoma de células escamosas de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C441221",
      "display" : "C441221 Carcinoma de células escamosas de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C441222",
      "display" : "C441222 Carcinoma de células escamosas de piel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C44129",
      "display" : "C44129 Carcinoma de células escamosas de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C441291",
      "display" : "C441291 Carcinoma de células escamosas de piel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C4413",
      "display" : "C4413 Carcinoma de células sebáceas de piel de párpado incluyendo canto"
    },
    {
      "code" : "C44131",
      "display" : "C44131 Carcinoma de células sebáceas de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C44132",
      "display" : "C44132 Carcinoma de células sebáceas de piel de párpado derecho incluyendo canto"
    },
    {
      "code" : "C441321",
      "display" : "C441321 Carcinoma de células sebáceas de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C44139",
      "display" : "C44139 Carcinoma de células sebáceas de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C441391",
      "display" : "C441391 Carcinoma de células sebáceas de piel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C441392",
      "display" : "C441392 Carcinoma de células sebáceas de piel de párpado inferior izquierdo incluyendo canto"
    },
    {
      "code" : "C4419",
      "display" : "C4419 Otra neoplasia maligna especificada de piel de párpado incluyendo canto"
    },
    {
      "code" : "C44191",
      "display" : "C44191 Otra neoplasia maligna especificada de piel de párpado no especificado incluyendo canto"
    },
    {
      "code" : "C441921",
      "display" : "C441921 Otra neoplasia maligna especificada de piel de párpado superior derecho incluyendo canto"
    },
    {
      "code" : "C441922",
      "display" : "C441922 Otra neoplasia maligna especificada de piel de párpado inferior derecho incluyendo canto"
    },
    {
      "code" : "C44199",
      "display" : "C44199 Otra neoplasia maligna especificada de piel de párpado izquierdo incluyendo canto"
    },
    {
      "code" : "C441991",
      "display" : "C441991 Otra neoplasia maligna especificada de piel de párpado superior izquierdo incluyendo canto"
    },
    {
      "code" : "C442",
      "display" : "C442 Otra neoplasia maligna y las no especificadas de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "C4420",
      "display" : "C4420 Neoplasia maligna no especificada de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "C846",
      "display" : "C846 Linfoma anaplásico de células grandes ALK positivo"
    },
    {
      "code" : "C8460",
      "display" : "C8460 Linfoma anaplásico de células grandes ALK positivo localización no especificada"
    },
    {
      "code" : "C8461",
      "display" : "C8461 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8462",
      "display" : "C8462 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8463",
      "display" : "C8463 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8464",
      "display" : "C8464 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8465",
      "display" : "C8465 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8466",
      "display" : "C8466 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8467",
      "display" : "C8467 Linfoma anaplásico de células grandes ALK positivo bazo"
    },
    {
      "code" : "C8468",
      "display" : "C8468 Linfoma anaplásico de células grandes ALK positivo ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8469",
      "display" : "C8469 Linfoma anaplásico de células grandes ALK positivo localización extraganglionar y de órganos sólidos"
    },
    {
      "code" : "C847",
      "display" : "C847 Linfoma anaplásico de células grandes ALK negativo"
    },
    {
      "code" : "C8470",
      "display" : "C8470 Linfoma anaplásico de células grandes ALK negativo localización no especificada"
    },
    {
      "code" : "C8471",
      "display" : "C8471 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8472",
      "display" : "C8472 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8473",
      "display" : "C8473 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8474",
      "display" : "C8474 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8475",
      "display" : "C8475 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8476",
      "display" : "C8476 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8477",
      "display" : "C8477 Linfoma anaplásico de células grandes ALK negativo bazo"
    },
    {
      "code" : "C8478",
      "display" : "C8478 Linfoma anaplásico de células grandes ALK negativo ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8479",
      "display" : "C8479 Linfoma anaplásico de células grandes ALK negativo localización extraganglionar y de órganos sólidos"
    },
    {
      "code" : "C847A",
      "display" : "C847A Linfoma anaplásico de células grandes ALK negativo mama"
    },
    {
      "code" : "C84A",
      "display" : "C84A Linfoma cutáneo de células T no especificado"
    },
    {
      "code" : "C84A0",
      "display" : "C84A0 Linfoma cutáneo de células T no especificado localización no especificada"
    },
    {
      "code" : "C84A1",
      "display" : "C84A1 Linfoma cutáneo de células T no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C84A2",
      "display" : "C84A2 Linfoma cutáneo de células T no especificado ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C84A3",
      "display" : "C84A3 Linfoma cutáneo de células T no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C84A5",
      "display" : "C84A5 Linfoma cutáneo de células T no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C84A6",
      "display" : "C84A6 Linfoma cutáneo de células T no especificado ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C84A7",
      "display" : "C84A7 Linfoma cutáneo de células T no especificado bazo"
    },
    {
      "code" : "C84A8",
      "display" : "C84A8 Linfoma cutáneo de células T no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C84Z",
      "display" : "C84Z Otros linfomas de células T/NK maduras"
    },
    {
      "code" : "C84Z0",
      "display" : "C84Z0 Otros linfomas de células T/NK maduras localización no especificada"
    },
    {
      "code" : "C84Z1",
      "display" : "C84Z1 Otros linfomas de células T/NK maduras ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C84Z2",
      "display" : "C84Z2 Otros linfomas de células T/NK maduras ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C84Z3",
      "display" : "C84Z3 Otros linfomas de células T/NK maduras ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C84Z5",
      "display" : "C84Z5 Otros linfomas de células T/NK maduras ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C84Z6",
      "display" : "C84Z6 Otros linfomas de células T/NK maduras ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C84Z7",
      "display" : "C84Z7 Otros linfomas de células T/NK maduras bazo"
    },
    {
      "code" : "C84Z8",
      "display" : "C84Z8 Otros linfomas de células T/NK maduras ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C84Z9",
      "display" : "C84Z9 Otros linfomas de células T/NK maduras localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C8490",
      "display" : "C8490 Linfomas de células T/NK maduras no especificados localización no especificada"
    },
    {
      "code" : "C8491",
      "display" : "C8491 Linfomas de células T/NK maduras no especificados ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "D492",
      "display" : "D492 Neoplasia de comportamiento no especificado de hueso tejidos blandos y piel"
    },
    {
      "code" : "D493",
      "display" : "D493 Neoplasia de comportamiento no especificado de mama"
    },
    {
      "code" : "D494",
      "display" : "D494 Neoplasia de comportamiento no especificado de vejiga"
    },
    {
      "code" : "D495",
      "display" : "D495 Neoplasia de comportamiento no especificado de otros órganos genitourinarios"
    },
    {
      "code" : "D4951",
      "display" : "D4951 Neoplasia de comportamiento no especificado de riñón"
    },
    {
      "code" : "D49511",
      "display" : "D49511 Neoplasia de comportamiento no especificado de riñón derecho"
    },
    {
      "code" : "D49512",
      "display" : "D49512 Neoplasia de comportamiento no especificado de riñón izquierdo"
    },
    {
      "code" : "D49519",
      "display" : "D49519 Neoplasia de comportamiento no especificado de riñón no especificado"
    },
    {
      "code" : "D4959",
      "display" : "D4959 Neoplasia de comportamiento no especificado de otros órganos genitourinarios"
    },
    {
      "code" : "D496",
      "display" : "D496 Neoplasia de comportamiento no especificado de cerebro"
    },
    {
      "code" : "D497",
      "display" : "D497 Neoplasia de comportamiento no especificado de glándulas endocrinas y otras partes de sistema nervioso"
    },
    {
      "code" : "D498",
      "display" : "D498 Neoplasia de comportamiento no especificado de otras localizaciones especificadas"
    },
    {
      "code" : "D4981",
      "display" : "D4981 Neoplasia de comportamiento no especificado de retina y coroides"
    },
    {
      "code" : "D4989",
      "display" : "D4989 Neoplasia de comportamiento no especificado de otras localizaciones especificadas"
    },
    {
      "code" : "D499",
      "display" : "D499 Neoplasia de comportamiento no especificado de localización no especificada"
    },
    {
      "code" : "D50",
      "display" : "D50 Anemia por carencia de hierro"
    },
    {
      "code" : "D500",
      "display" : "D500 Anemia ferropénica secundaria a pérdida de sangre (crónica)"
    },
    {
      "code" : "D501",
      "display" : "D501 Disfagia sideropénica"
    },
    {
      "code" : "D508",
      "display" : "D508 Otras anemias por carencia de hierro"
    },
    {
      "code" : "D509",
      "display" : "D509 Anemia ferropénica no especificada"
    },
    {
      "code" : "D51",
      "display" : "D51 Anemia por carencia de vitamina B12"
    },
    {
      "code" : "D510",
      "display" : "D510 Anemia por carencia de vitamina B12 debida a carencia de factor intrínseco"
    },
    {
      "code" : "D511",
      "display" : "D511 Anemia por carencia de vitamina B12 debida a malabsorción selectiva de vitamina B12 con proteinuria"
    },
    {
      "code" : "D512",
      "display" : "D512 Carencia de transcobalamina II"
    },
    {
      "code" : "D513",
      "display" : "D513 Otras anemias por carencia dietética de vitamina B12"
    },
    {
      "code" : "D519",
      "display" : "D519 Anemia por carencia de vitamina B12 no especificada"
    },
    {
      "code" : "D52",
      "display" : "D52 Anemia por carencia de ácido fólico"
    },
    {
      "code" : "D520",
      "display" : "D520 Anemia por carencia dietética de ácido fólico"
    },
    {
      "code" : "D528",
      "display" : "D528 Otras anemias por carencia de ácido fólico"
    },
    {
      "code" : "D529",
      "display" : "D529 Anemia por carencia de ácido fólico no especificada"
    },
    {
      "code" : "D53",
      "display" : "D53 Otras anemias carenciales"
    },
    {
      "code" : "D531",
      "display" : "D531 Otras anemias megaloblásticas no clasificadas bajo otro concepto"
    },
    {
      "code" : "D532",
      "display" : "D532 Anemia por escorbuto"
    },
    {
      "code" : "D538",
      "display" : "D538 Otras anemias carenciales especificadas"
    },
    {
      "code" : "D55",
      "display" : "D55 Anemia debida a trastornos enzimáticos"
    },
    {
      "code" : "D550",
      "display" : "D550 Anemia debida a deficiencia de glucosa-6-fosfato deshidrogenasa [G6PD]"
    },
    {
      "code" : "D552",
      "display" : "D552 Anemia debida a trastornos de enzimas glucolíticas"
    },
    {
      "code" : "D5521",
      "display" : "D5521 Anemia por déficit de piruvato quinasa"
    },
    {
      "code" : "D5529",
      "display" : "D5529 Anemia debida a otros trastornos de enzimas glucolíticas"
    },
    {
      "code" : "D553",
      "display" : "D553 Anemia debida a trastornos del metabolismo de nucleótidos"
    },
    {
      "code" : "D559",
      "display" : "D559 Anemia por trastorno enzimático no especificada"
    },
    {
      "code" : "D56",
      "display" : "D56 Talasemia"
    },
    {
      "code" : "D560",
      "display" : "D560 Alfa talasemia"
    },
    {
      "code" : "D562",
      "display" : "D562 Talasemia delta-beta"
    },
    {
      "code" : "D563",
      "display" : "D563 Talasemia menor"
    },
    {
      "code" : "D565",
      "display" : "D565 Hemoglobina E-beta talasemia"
    },
    {
      "code" : "D568",
      "display" : "D568 Otras talasemias"
    },
    {
      "code" : "D569",
      "display" : "D569 Talasemia no especificada"
    },
    {
      "code" : "D570",
      "display" : "D570 Enfermedad por Hb-SS con crisis"
    },
    {
      "code" : "D5700",
      "display" : "D5700 Enfermedad por Hb-SS con crisis no especificada"
    },
    {
      "code" : "D5702",
      "display" : "D5702 Enfermedad por Hb-SS con secuestro esplénico"
    },
    {
      "code" : "D5703",
      "display" : "D5703 Enfermedad por Hb-SS con afectación vascular cerebral"
    },
    {
      "code" : "D5709",
      "display" : "D5709 Enfermedad por Hb-SS con crisis con otra complicación especificada"
    },
    {
      "code" : "D572",
      "display" : "D572 Drepanocitosis/Hb-C"
    },
    {
      "code" : "A790",
      "display" : "A790 Fiebre de las trincheras"
    },
    {
      "code" : "A791",
      "display" : "A791 Rickettsiosis debida a Rickettsia akari"
    },
    {
      "code" : "A798",
      "display" : "A798 Otras rickettsiosis especificadas"
    },
    {
      "code" : "A7981",
      "display" : "A7981 Rickettsiosis debida a Ehrlichia sennetsu"
    },
    {
      "code" : "A7982",
      "display" : "A7982 Anaplasmosis [A. phagocytophilum]"
    },
    {
      "code" : "A7989",
      "display" : "A7989 Otras rickettsiosis especificadas"
    },
    {
      "code" : "A799",
      "display" : "A799 Rickettsiosis no especificada"
    },
    {
      "code" : "A80",
      "display" : "A80 Poliomielitis aguda"
    },
    {
      "code" : "A800",
      "display" : "A800 Poliomielitis paralítica aguda asociada a vacuna"
    },
    {
      "code" : "A801",
      "display" : "A801 Poliomielitis paralítica aguda virus natural importado"
    },
    {
      "code" : "A802",
      "display" : "A802 Poliomielitis paralítica aguda virus natural autóctono"
    },
    {
      "code" : "A803",
      "display" : "A803 Otra poliomielitis paralítica aguda y las no especificadas"
    },
    {
      "code" : "A8030",
      "display" : "A8030 Poliomielitis paralítica aguda no especificada"
    },
    {
      "code" : "A8039",
      "display" : "A8039 Otros tipos de poliomielitis paralítica aguda"
    },
    {
      "code" : "A804",
      "display" : "A804 Poliomielitis no paralítica aguda"
    },
    {
      "code" : "A809",
      "display" : "A809 Poliomielitis aguda no especificada"
    },
    {
      "code" : "A81",
      "display" : "A81 Infecciones por virus atípico del sistema nervioso central"
    },
    {
      "code" : "A810",
      "display" : "A810 Enfermedad de Creutzfeldt-Jakob"
    },
    {
      "code" : "A8100",
      "display" : "A8100 Enfermedad de Creutzfeldt-Jakob no especificada"
    },
    {
      "code" : "A8101",
      "display" : "A8101 Variante de enfermedad de Creutzfeldt-Jakob"
    },
    {
      "code" : "A8109",
      "display" : "A8109 Otra enfermedad de Creutzfeldt-Jakob"
    },
    {
      "code" : "A811",
      "display" : "A811 Panencefalitis esclerosante subaguda"
    },
    {
      "code" : "A812",
      "display" : "A812 Leucoencefalopatía multifocal progresiva"
    },
    {
      "code" : "A818",
      "display" : "A818 Otras infecciones por virus atípicos del sistema nervioso central"
    },
    {
      "code" : "A8182",
      "display" : "A8182 Síndrome de Gerstmann-Sträussler-Scheinker"
    },
    {
      "code" : "A8183",
      "display" : "A8183 Insomnio familiar fatal"
    },
    {
      "code" : "A819",
      "display" : "A819 Infección viral atípica del sistema nervioso central"
    },
    {
      "code" : "A82",
      "display" : "A82 Rabia"
    },
    {
      "code" : "A820",
      "display" : "A820 Rabia silvestre"
    },
    {
      "code" : "A829",
      "display" : "A829 Rabia no especificada"
    },
    {
      "code" : "A83",
      "display" : "A83 Encefalitis viral transmitida por mosquitos"
    },
    {
      "code" : "A831",
      "display" : "A831 Encefalitis equina occidental"
    },
    {
      "code" : "A832",
      "display" : "A832 Encefalitis equina oriental"
    },
    {
      "code" : "A833",
      "display" : "A833 Encefalitis de San Luis"
    },
    {
      "code" : "A835",
      "display" : "A835 Encefalitis de California"
    },
    {
      "code" : "A836",
      "display" : "A836 Enfermedad por virus Rocío"
    },
    {
      "code" : "A838",
      "display" : "A838 Otras encefalitis virales transmitidas por mosquitos"
    },
    {
      "code" : "A839",
      "display" : "A839 Encefalitis viral transmitida por mosquitos no especificada"
    },
    {
      "code" : "A840",
      "display" : "A840 Encefalitis del Lejano Oriente transmitida por garrapatas [encefalitis primaveroestival rusa]"
    },
    {
      "code" : "A841",
      "display" : "A841 Encefalitis centroeuropea transmitida por garrapatas"
    },
    {
      "code" : "A848",
      "display" : "A848 Otras encefalitis virales transmitidas por garrapatas"
    },
    {
      "code" : "A8489",
      "display" : "A8489 Otras encefalitis virales transmitidas por garrapatas"
    },
    {
      "code" : "A849",
      "display" : "A849 Encefalitis viral transmitida por garrapatas no especificada"
    },
    {
      "code" : "A850",
      "display" : "A850 Encefalitis enteroviral"
    },
    {
      "code" : "A851",
      "display" : "A851 Encefalitis por adenovirus"
    },
    {
      "code" : "A852",
      "display" : "A852 Encefalitis viral transmitida por artrópodos no especificada"
    },
    {
      "code" : "A858",
      "display" : "A858 Otras encefalitis virales especificadas"
    },
    {
      "code" : "A87",
      "display" : "A87 Meningitis viral"
    },
    {
      "code" : "A870",
      "display" : "A870 Meningitis por enterovirus"
    },
    {
      "code" : "A872",
      "display" : "A872 Coriomeningitis linfocitaria"
    },
    {
      "code" : "A878",
      "display" : "A878 Otras meningitis virales"
    },
    {
      "code" : "A879",
      "display" : "A879 Meningitis viral no especificada"
    },
    {
      "code" : "A880",
      "display" : "A880 Fiebre exantemática enteroviral [exantema de Boston]"
    },
    {
      "code" : "A881",
      "display" : "A881 Vértigo epidémico"
    },
    {
      "code" : "A888",
      "display" : "A888 Otras infecciones virales especificadas del sistema nervioso central"
    },
    {
      "code" : "A89",
      "display" : "A89 Infección viral del sistema nervioso central no especificada"
    },
    {
      "code" : "A91",
      "display" : "A91 Fiebre del dengue hemorrágico"
    },
    {
      "code" : "A92",
      "display" : "A92 Otras fiebres virales transmitidas por mosquitos"
    },
    {
      "code" : "C44201",
      "display" : "C44201 Neoplasia maligna no especificada de piel de oído y conducto auditivo externo no especificados"
    },
    {
      "code" : "C44202",
      "display" : "C44202 Neoplasia maligna no especificada de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "C44209",
      "display" : "C44209 Neoplasia maligna no especificada de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "C4421",
      "display" : "C4421 Carcinoma basocelular de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "C44211",
      "display" : "C44211 Carcinoma basocelular de piel de oído y conducto auditivo externo no especificados"
    },
    {
      "code" : "C44212",
      "display" : "C44212 Carcinoma basocelular de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "C44219",
      "display" : "C44219 Carcinoma basocelular de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "C4422",
      "display" : "C4422 Carcinoma de células escamosas de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "C44221",
      "display" : "C44221 Carcinoma de células escamosas de piel de oído y conducto auditivo externo no especificados"
    },
    {
      "code" : "C44222",
      "display" : "C44222 Carcinoma de células escamosas de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "C44229",
      "display" : "C44229 Carcinoma de células escamosas de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "C4429",
      "display" : "C4429 Otra neoplasia maligna especificada de piel de oído y conducto auditivo externo"
    },
    {
      "code" : "C44291",
      "display" : "C44291 Otra neoplasia maligna especificada de piel de oído y conducto auditivo externo no especificados"
    },
    {
      "code" : "C44292",
      "display" : "C44292 Otra neoplasia maligna especificada de piel de oído y conducto auditivo externo derechos"
    },
    {
      "code" : "C44299",
      "display" : "C44299 Otra neoplasia maligna especificada de piel de oído y conducto auditivo externo izquierdos"
    },
    {
      "code" : "C443",
      "display" : "C443 Otra neoplasia maligna y las no especificadas de piel de otras partes y las no especificadas de cara"
    },
    {
      "code" : "C4430",
      "display" : "C4430 Neoplasia maligna no especificada de piel de otras partes y las no especificadas de cara"
    },
    {
      "code" : "C44300",
      "display" : "C44300 Neoplasia maligna no especificada de piel de parte no especificada de la cara"
    },
    {
      "code" : "C44301",
      "display" : "C44301 Neoplasia maligna no especificada de piel de nariz"
    },
    {
      "code" : "C44309",
      "display" : "C44309 Neoplasia maligna no especificada de piel de otras partes de cara"
    },
    {
      "code" : "C4431",
      "display" : "C4431 Carcinoma basocelular de piel de otras partes y las no especificadas de cara"
    },
    {
      "code" : "C44310",
      "display" : "C44310 Carcinoma basocelular de piel de parte no especificada de la cara"
    },
    {
      "code" : "C44311",
      "display" : "C44311 Carcinoma basocelular de piel de nariz"
    },
    {
      "code" : "C44319",
      "display" : "C44319 Carcinoma basocelular de piel de otras partes de la cara"
    },
    {
      "code" : "C44320",
      "display" : "C44320 Carcinoma de células escamosas de piel de parte no especificada de la cara"
    },
    {
      "code" : "C44321",
      "display" : "C44321 Carcinoma de células escamosas de piel de nariz"
    },
    {
      "code" : "C44329",
      "display" : "C44329 Carcinoma de células escamosas de piel de otras partes de la cara"
    },
    {
      "code" : "C4439",
      "display" : "C4439 Otra neoplasia maligna especificada de piel de otras partes y las no especificadas de cara"
    },
    {
      "code" : "C44391",
      "display" : "C44391 Otra neoplasia maligna especificada de piel de nariz"
    },
    {
      "code" : "C44399",
      "display" : "C44399 Otra neoplasia maligna especificada de piel de otras partes de la cara"
    },
    {
      "code" : "C444",
      "display" : "C444 Otra neoplasia maligna y las no especificadas de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "C4440",
      "display" : "C4440 Neoplasia maligna no especificada de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "C4442",
      "display" : "C4442 Carcinoma de células escamosas de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "C4449",
      "display" : "C4449 Otra neoplasia maligna especificada de piel de cuero cabelludo y cuello"
    },
    {
      "code" : "C445",
      "display" : "C445 Otra neoplasia maligna y las no especificadas de piel de tronco"
    },
    {
      "code" : "C4450",
      "display" : "C4450 Neoplasia maligna no especificada de piel de tronco"
    },
    {
      "code" : "C44501",
      "display" : "C44501 Neoplasia maligna no especificada de piel de mama"
    },
    {
      "code" : "C44509",
      "display" : "C44509 Neoplasia maligna no especificada de piel de otra parte del tronco"
    },
    {
      "code" : "C4451",
      "display" : "C4451 Carcinoma basocelular de piel del tronco"
    },
    {
      "code" : "C44511",
      "display" : "C44511 Carcinoma basocelular de piel de mama"
    },
    {
      "code" : "C44519",
      "display" : "C44519 Carcinoma basocelular de piel de otra parte del tronco"
    },
    {
      "code" : "C4452",
      "display" : "C4452 Carcinoma de células escamosas de piel del tronco"
    },
    {
      "code" : "C44521",
      "display" : "C44521 Carcinoma de células escamosas de piel de mama"
    },
    {
      "code" : "C44529",
      "display" : "C44529 Carcinoma de células escamosas de piel de otra parte del tronco"
    },
    {
      "code" : "C4459",
      "display" : "C4459 Otra neoplasia maligna especificada de piel del tronco"
    },
    {
      "code" : "C44591",
      "display" : "C44591 Otra neoplasia maligna especificada de piel de mama"
    },
    {
      "code" : "C44599",
      "display" : "C44599 Otra neoplasia maligna especificada de piel de otra parte del tronco"
    },
    {
      "code" : "C8492",
      "display" : "C8492 Linfomas de células T/NK maduras no especificados ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8493",
      "display" : "C8493 Linfomas de células T/NK maduras no especificados ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8494",
      "display" : "C8494 Linfomas de células T/NK maduras no especificados ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8495",
      "display" : "C8495 Linfomas de células T/NK maduras no especificados ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8496",
      "display" : "C8496 Linfomas de células T/NK maduras no especificados ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8497",
      "display" : "C8497 Linfomas de células T/NK maduras no especificados bazo"
    },
    {
      "code" : "C8498",
      "display" : "C8498 Linfomas de células T/NK maduras no especificados ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8499",
      "display" : "C8499 Linfomas de células T/NK maduras no especificados localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C85",
      "display" : "C85 Otros tipos de linfoma no Hodgkin y los no especificados"
    },
    {
      "code" : "C851",
      "display" : "C851 Linfoma de células B no especificado"
    },
    {
      "code" : "C8510",
      "display" : "C8510 Linfoma de células B no especificado localización no especificada"
    },
    {
      "code" : "C8511",
      "display" : "C8511 Linfoma de células B no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8512",
      "display" : "C8512 Linfoma de células B no especificado ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8513",
      "display" : "C8513 Linfoma de células B no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8514",
      "display" : "C8514 Linfoma de células B no especificado ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8515",
      "display" : "C8515 Linfoma de células B no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8516",
      "display" : "C8516 Linfoma de células B no especificador ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8517",
      "display" : "C8517 Linfoma de células B no especificado bazo"
    },
    {
      "code" : "C8518",
      "display" : "C8518 Linfoma de células B no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8519",
      "display" : "C8519 Linfoma de células B no especificado localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C852",
      "display" : "C852 Linfoma de células B grandes mediastínico (tímico)"
    },
    {
      "code" : "C8520",
      "display" : "C8520 Linfoma de células B grandes mediastínico (tímico) localización no especificada"
    },
    {
      "code" : "C8521",
      "display" : "C8521 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8522",
      "display" : "C8522 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8523",
      "display" : "C8523 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8525",
      "display" : "C8525 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8526",
      "display" : "C8526 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8527",
      "display" : "C8527 Linfoma de células B grandes mediastínico (tímico) bazo"
    },
    {
      "code" : "C8528",
      "display" : "C8528 Linfoma de células B grandes mediastínico (tímico) ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8529",
      "display" : "C8529 Linfoma de células B grandes mediastínico (tímico) localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C8580",
      "display" : "C8580 Otros tipos especificados de linfoma no Hodgkin localización no especificada"
    },
    {
      "code" : "C8581",
      "display" : "C8581 Otros tipos especificados de linfoma no Hodgkin ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8582",
      "display" : "C8582 Otros tipos especificados de linfoma no Hodgkin ganglios linfáticos intratorácicos"
    },
    {
      "code" : "C8584",
      "display" : "C8584 Otros tipos especificados de linfoma no Hodgkin ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8585",
      "display" : "C8585 Otros tipos especificados de linfoma no Hodgkin ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "C8586",
      "display" : "C8586 Otros tipos especificados de linfoma no Hodgkin ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8587",
      "display" : "C8587 Otros tipos especificados de linfoma no Hodgkin bazo"
    },
    {
      "code" : "C8589",
      "display" : "C8589 Otros tipos especificados de linfoma no Hodgkin localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C859",
      "display" : "C859 Linfoma no Hodgkin no especificado"
    },
    {
      "code" : "C8590",
      "display" : "C8590 Linfoma no Hodgkin no especificado localización no especificada"
    },
    {
      "code" : "C8591",
      "display" : "C8591 Linfoma no Hodgkin no especificado ganglios linfáticos de cabeza cara y cuello"
    },
    {
      "code" : "C8593",
      "display" : "C8593 Linfoma no Hodgkin no especificado ganglios linfáticos intraabdominales"
    },
    {
      "code" : "C8594",
      "display" : "C8594 Linfoma no Hodgkin no especificado ganglios linfáticos de axila y extremidad superior"
    },
    {
      "code" : "C8595",
      "display" : "C8595 Linfoma no Hodgkin no especificado ganglios linfáticos de región inguinal y extremidad inferior"
    },
    {
      "code" : "D5720",
      "display" : "D5720 Drepanocitosis /Hb-C sin crisis"
    },
    {
      "code" : "D5721",
      "display" : "D5721 Drepanocitosis/Hb-C con crisis"
    },
    {
      "code" : "D57211",
      "display" : "D57211 Drepanocitosis/Hb-C con síndrome torácico agudo"
    },
    {
      "code" : "D57212",
      "display" : "D57212 Drepanocitosis/Hb-C con secuestro esplénico"
    },
    {
      "code" : "D57213",
      "display" : "D57213 Drepanocitosis/Hb-C con afectación vascular cerebral"
    },
    {
      "code" : "D57218",
      "display" : "D57218 Drepanocitosis/Hb-C con crisis con otra complicación especificada"
    },
    {
      "code" : "D57219",
      "display" : "D57219 Drepanocitosis/Hb-C con crisis no especificada"
    },
    {
      "code" : "D573",
      "display" : "D573 Rasgo falciforme"
    },
    {
      "code" : "D574",
      "display" : "D574 Talasemia falciforme"
    },
    {
      "code" : "D5740",
      "display" : "D5740 Talasemia falciforme sin crisis"
    },
    {
      "code" : "D5741",
      "display" : "D5741 Talasemia falciforme no especificada con crisis"
    },
    {
      "code" : "D57411",
      "display" : "D57411 Talasemia falciforme no especificada con síndrome torácico agudo"
    },
    {
      "code" : "D57412",
      "display" : "D57412 Talasemia falciforme no especificada con secuestro esplénico"
    },
    {
      "code" : "D57413",
      "display" : "D57413 Talasemia falciforme no especificada con afectación vascular cerebral"
    },
    {
      "code" : "D57418",
      "display" : "D57418 Talasemia falciforme no especificada con crisis con otra complicación especificada"
    },
    {
      "code" : "D57419",
      "display" : "D57419 Talasemia falciforme no especificada con crisis"
    },
    {
      "code" : "D5742",
      "display" : "D5742 Talasemia falciforme beta cero sin crisis"
    },
    {
      "code" : "D5743",
      "display" : "D5743 Talasemia falciforme beta cero con crisis"
    },
    {
      "code" : "D57431",
      "display" : "D57431 Talasemia falciforme beta cero con síndrome torácico agudo"
    },
    {
      "code" : "D57432",
      "display" : "D57432 Talasemia falciforme beta cero con secuestro esplénico"
    },
    {
      "code" : "D57433",
      "display" : "D57433 Talasemia falciforme beta cero con afectación vascular cerebral"
    },
    {
      "code" : "D57438",
      "display" : "D57438 Talasemia falciforme beta cero con crisis con otra complicación especificada"
    },
    {
      "code" : "D57439",
      "display" : "D57439 Talasemia falciforme beta cero con crisis no especificada"
    },
    {
      "code" : "D5744",
      "display" : "D5744 Talasemia falciforme beta plus sin crisis"
    },
    {
      "code" : "D5745",
      "display" : "D5745 Talasemia falciforme beta plus con crisis"
    },
    {
      "code" : "D57452",
      "display" : "D57452 Talasemia falciforme beta plus con secuestro esplénico"
    },
    {
      "code" : "D57453",
      "display" : "D57453 Talasemia falciforme beta plus con afectación vascular cerebral"
    },
    {
      "code" : "D57458",
      "display" : "D57458 Talasemia falciforme beta plus con crisis con otra complicación especificada"
    },
    {
      "code" : "D578",
      "display" : "D578 Otros trastornos de células falciformes"
    },
    {
      "code" : "D5780",
      "display" : "D5780 Otros trastornos de células falciformes sin crisis"
    },
    {
      "code" : "D5781",
      "display" : "D5781 Otros trastornos de células falciformes con crisis"
    },
    {
      "code" : "D57811",
      "display" : "D57811 Otros trastornos de células falciformes con síndrome torácico agudo"
    },
    {
      "code" : "D57813",
      "display" : "D57813 Otros trastornos de células falciformes con afectación cerebral vascular"
    },
    {
      "code" : "D57818",
      "display" : "D57818 Otros trastornos de células falciformes con crisis con otra complicación especificada"
    },
    {
      "code" : "D57819",
      "display" : "D57819 Otros trastornos de células falciformes con crisis no especificada"
    },
    {
      "code" : "D580",
      "display" : "D580 Esferocitosis hereditaria"
    },
    {
      "code" : "D581",
      "display" : "D581 Eliptocitosis hereditaria"
    },
    {
      "code" : "D582",
      "display" : "D582 Otras hemoglobinopatías"
    },
    {
      "code" : "D589",
      "display" : "D589 Anemia hemolítica hereditaria no especificada"
    },
    {
      "code" : "D59",
      "display" : "D59 Anemia hemolítica adquirida"
    },
    {
      "code" : "D590",
      "display" : "D590 Anemia hemolítica autoinmune inducida por fármacos"
    },
    {
      "code" : "D5910",
      "display" : "D5910 Anemia hemolítica autoinmune no especificada"
    },
    {
      "code" : "D5911",
      "display" : "D5911 Anemia hemolítica autoinmune por anticuerpos calientes"
    },
    {
      "code" : "D5912",
      "display" : "D5912 Anemia hemolítica autoinmune por anticuerpos fríos"
    },
    {
      "code" : "D5919",
      "display" : "D5919 Otras anemias hemolíticas autoinmunes"
    },
    {
      "code" : "D592",
      "display" : "D592 Anemia hemolítica no autoimmune inducida por fármacos"
    },
    {
      "code" : "D593",
      "display" : "D593 Síndrome hemolítico-urémico"
    },
    {
      "code" : "D5931",
      "display" : "D5931 Síndrome hemolítico-urémico asociado a infección"
    },
    {
      "code" : "D5932",
      "display" : "D5932 Síndrome hemolítico-urémico hereditario"
    },
    {
      "code" : "D5939",
      "display" : "D5939 Otro síndrome hemolítico-urémico"
    },
    {
      "code" : "D595",
      "display" : "D595 Hemoglobinuria paroxística nocturna [Marchiafava-Micheli]"
    },
    {
      "code" : "D596",
      "display" : "D596 Hemoglobinuria debida a hemolisis por otras causas externas"
    },
    {
      "code" : "D598",
      "display" : "D598 Otras anemias hemolíticas adquiridas"
    },
    {
      "code" : "A920",
      "display" : "A920 Enfermedad por virus Chikungunya"
    },
    {
      "code" : "A921",
      "display" : "A921 Fiebre de Onyong-nyong"
    },
    {
      "code" : "A922",
      "display" : "A922 Fiebre equina venezolana"
    },
    {
      "code" : "A923",
      "display" : "A923 Infección por virus del Nilo occidental"
    },
    {
      "code" : "A9230",
      "display" : "A9230 Infección por virus del Nilo occidental no especificada"
    },
    {
      "code" : "A9231",
      "display" : "A9231 Infección por virus del Nilo occidental con encefalitis"
    },
    {
      "code" : "A9232",
      "display" : "A9232 Infección por virus del Nilo occidental con otras manifestaciones neurológicas"
    },
    {
      "code" : "A9239",
      "display" : "A9239 Infección por virus del Nilo occidental con otras complicaciones"
    },
    {
      "code" : "A924",
      "display" : "A924 Fiebre del valle del Rift"
    },
    {
      "code" : "A925",
      "display" : "A925 Enfermedad por virus del Zika"
    },
    {
      "code" : "A928",
      "display" : "A928 Otras fiebres virales especificadas transmitidas por mosquitos"
    },
    {
      "code" : "A929",
      "display" : "A929 Fiebre viral transmitida por mosquito no especificada"
    },
    {
      "code" : "A93",
      "display" : "A93 Otras fiebres virales transmitidas por artrópodos no clasificadas bajo otro concepto"
    },
    {
      "code" : "A930",
      "display" : "A930 Enfermedad por virus de Oropouche"
    },
    {
      "code" : "A931",
      "display" : "A931 Fiebre transmitida por flebotomos"
    },
    {
      "code" : "A932",
      "display" : "A932 Fiebre de Colorado transmitida por garrapatas"
    },
    {
      "code" : "A938",
      "display" : "A938 Otras fiebres virales especificadas transmitidas por artrópodos"
    },
    {
      "code" : "A94",
      "display" : "A94 Fiebre viral transmitida por artrópodos no especificada"
    },
    {
      "code" : "A95",
      "display" : "A95 Fiebre amarilla"
    },
    {
      "code" : "A950",
      "display" : "A950 Fiebre amarilla selvática"
    },
    {
      "code" : "A951",
      "display" : "A951 Fiebre amarilla urbana"
    },
    {
      "code" : "A959",
      "display" : "A959 Fiebre amarilla no especificada"
    },
    {
      "code" : "A96",
      "display" : "A96 Fiebre hemorrágica por arenavirus"
    },
    {
      "code" : "A960",
      "display" : "A960 Fiebre hemorrágica de Junín"
    },
    {
      "code" : "A962",
      "display" : "A962 Fiebre de Lassa"
    },
    {
      "code" : "A968",
      "display" : "A968 Otras fiebres hemorrágicas por arenavirus"
    },
    {
      "code" : "A969",
      "display" : "A969 Fiebre hemorrágica por arenavirus no especificada"
    },
    {
      "code" : "A980",
      "display" : "A980 Fiebre hemorrágica de Crimea-Congo"
    },
    {
      "code" : "A981",
      "display" : "A981 Fiebre hemorrágica de Omsk"
    },
    {
      "code" : "A982",
      "display" : "A982 Enfermedad de la selva de Kyasanur"
    },
    {
      "code" : "A984",
      "display" : "A984 Enfermedad por el virus de Ébola"
    },
    {
      "code" : "A985",
      "display" : "A985 Fiebres hemorrágicas con síndrome renal"
    },
    {
      "code" : "A988",
      "display" : "A988 Otras fiebres hemorrágicas virales especificadas"
    },
    {
      "code" : "B00",
      "display" : "B00 Infecciones por herpesvirus [herpes simple]"
    },
    {
      "code" : "B000",
      "display" : "B000 Eccema herpético"
    },
    {
      "code" : "B001",
      "display" : "B001 Dermatitis vesicular herpética"
    },
    {
      "code" : "B003",
      "display" : "B003 Meningitis herpética"
    },
    {
      "code" : "B004",
      "display" : "B004 Encefalitis herpética"
    },
    {
      "code" : "B005",
      "display" : "B005 Afectación ocular por herpesvirus"
    },
    {
      "code" : "B0051",
      "display" : "B0051 Iridociclitis por herpesvirus"
    },
    {
      "code" : "B0052",
      "display" : "B0052 Queratitis por herpesvirus"
    },
    {
      "code" : "B0053",
      "display" : "B0053 Conjuntivitis por herpesvirus"
    },
    {
      "code" : "B007",
      "display" : "B007 Enfermedad herpética diseminada"
    },
    {
      "code" : "B008",
      "display" : "B008 Otras formas de infecciones herpéticas"
    },
    {
      "code" : "B0081",
      "display" : "B0081 Hepatitis por herpesvirus"
    },
    {
      "code" : "B0089",
      "display" : "B0089 Otras infecciones por herpesvirus"
    },
    {
      "code" : "B009",
      "display" : "B009 Infección debida a herpesvirus no especificada"
    },
    {
      "code" : "B010",
      "display" : "B010 Meningitis debida a varicela"
    },
    {
      "code" : "B011",
      "display" : "B011 Encefalitis mielitis y encefalomielitis debidas a varicela"
    },
    {
      "code" : "B0112",
      "display" : "B0112 Mielitis por varicela"
    },
    {
      "code" : "B012",
      "display" : "B012 Neumonía debida a varicela"
    },
    {
      "code" : "B018",
      "display" : "B018 Varicela con otras complicaciones"
    },
    {
      "code" : "B0189",
      "display" : "B0189 Otras complicaciones de varicela"
    },
    {
      "code" : "B019",
      "display" : "B019 Varicela sin complicaciones"
    },
    {
      "code" : "B02",
      "display" : "B02 Herpes zóster"
    },
    {
      "code" : "B021",
      "display" : "B021 Meningitis debida a herpes zóster"
    },
    {
      "code" : "B022",
      "display" : "B022 Herpes zóster con otro tipo de afectación del sistema nervioso"
    },
    {
      "code" : "B0222",
      "display" : "B0222 Neuralgia del trigémino posherpética"
    },
    {
      "code" : "B0223",
      "display" : "B0223 Polineuropatía posherpética"
    },
    {
      "code" : "C446",
      "display" : "C446 Otra neoplasia maligna y las no especificadas de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C4460",
      "display" : "C4460 Neoplasia maligna no especificada de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C44601",
      "display" : "C44601 Neoplasia maligna no especificada de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C44602",
      "display" : "C44602 Neoplasia maligna no especificada de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C44609",
      "display" : "C44609 Neoplasia maligna no especificada de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C4461",
      "display" : "C4461 Carcinoma basocelular de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C44611",
      "display" : "C44611 Carcinoma basocelular de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C44612",
      "display" : "C44612 Carcinoma basocelular de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C44619",
      "display" : "C44619 Carcinoma basocelular de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C4462",
      "display" : "C4462 Carcinoma de células escamosas de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C44621",
      "display" : "C44621 Carcinoma de células escamosas de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C44622",
      "display" : "C44622 Carcinoma de células escamosas de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C44629",
      "display" : "C44629 Carcinoma de células escamosas de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C4469",
      "display" : "C4469 Otra neoplasia maligna especificada de piel de extremidad superior incluyendo hombro"
    },
    {
      "code" : "C44691",
      "display" : "C44691 Otra neoplasia maligna especificada de piel de extremidad superior no especificada incluyendo hombro"
    },
    {
      "code" : "C44692",
      "display" : "C44692 Otra neoplasia maligna especificada de piel de extremidad superior derecha incluyendo hombro"
    },
    {
      "code" : "C44699",
      "display" : "C44699 Otra neoplasia maligna especificada de piel de extremidad superior izquierda incluyendo hombro"
    },
    {
      "code" : "C447",
      "display" : "C447 Otra neoplasia maligna y las no especificadas de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "C4470",
      "display" : "C4470 Neoplasia maligna no especificada de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "C44701",
      "display" : "C44701 Neoplasia maligna no especificada de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C44702",
      "display" : "C44702 Neoplasia maligna no especificada de piel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C44709",
      "display" : "C44709 Neoplasia maligna no especificada de piel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "C4471",
      "display" : "C4471 Carcinoma basocelular de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "C44711",
      "display" : "C44711 Carcinoma basocelular de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C44712",
      "display" : "C44712 Carcinoma basocelular de piel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C4472",
      "display" : "C4472 Carcinoma de células escamosas de piel de extremidad inferior incluyendo cadera"
    },
    {
      "code" : "C44721",
      "display" : "C44721 Carcinoma de células escamosas de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C44722",
      "display" : "C44722 Carcinoma de células escamosas de piel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C44729",
      "display" : "C44729 Carcinoma de células escamosas de piel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "C44791",
      "display" : "C44791 Otra neoplasia maligna especificada de piel de extremidad inferior no especificada incluyendo cadera"
    },
    {
      "code" : "C44792",
      "display" : "C44792 Otra neoplasia maligna especificada de piel de extremidad inferior derecha incluyendo cadera"
    },
    {
      "code" : "C44799",
      "display" : "C44799 Otra neoplasia maligna especificada de piel de extremidad inferior izquierda incluyendo cadera"
    },
    {
      "code" : "C448",
      "display" : "C448 Otra neoplasia maligna y las no especificadas de localizaciones contiguas de piel"
    },
    {
      "code" : "C4481",
      "display" : "C4481 Carcinoma basocelular de localizaciones contiguas de piel"
    },
    {
      "code" : "C4482",
      "display" : "C4482 Carcinoma de células escamosas de localizaciones contiguas de piel"
    },
    {
      "code" : "C4489",
      "display" : "C4489 Otra neoplasia maligna especificada de localizaciones contiguas de piel"
    },
    {
      "code" : "C449",
      "display" : "C449 Otra neoplasia maligna y las no especificadas de piel localización no especificada"
    },
    {
      "code" : "C4491",
      "display" : "C4491 Carcinoma basocelular de piel localización no especificada"
    },
    {
      "code" : "C4492",
      "display" : "C4492 Carcinoma de células escamosas de piel localización no especificada"
    },
    {
      "code" : "C4499",
      "display" : "C4499 Otra neoplasia maligna especificada de piel localización no especificada"
    },
    {
      "code" : "C450",
      "display" : "C450 Mesotelioma de pleura"
    },
    {
      "code" : "C451",
      "display" : "C451 Mesotelioma de peritoneo"
    },
    {
      "code" : "C457",
      "display" : "C457 Mesotelioma de otras localizaciones especificadas"
    },
    {
      "code" : "C459",
      "display" : "C459 Mesotelioma de localización no especificada"
    },
    {
      "code" : "C46",
      "display" : "C46 Sarcoma de Kaposi"
    },
    {
      "code" : "C8596",
      "display" : "C8596 Linfoma no Hodgkin no especificado ganglios linfáticos intrapélvicos"
    },
    {
      "code" : "C8597",
      "display" : "C8597 Linfoma no Hodgkin no especificado bazo"
    },
    {
      "code" : "C8598",
      "display" : "C8598 Linfoma no Hodgkin no especificado ganglios linfáticos de localizaciones múltiples"
    },
    {
      "code" : "C8599",
      "display" : "C8599 Linfoma no Hodgkin no especificado localizaciones extraganglionares y de órganos sólidos"
    },
    {
      "code" : "C86",
      "display" : "C86 Otros tipos especificados de linfoma de células T/NK"
    },
    {
      "code" : "C860",
      "display" : "C860 Linfoma extraganglionar de células NK/T tipo nasal"
    },
    {
      "code" : "C861",
      "display" : "C861 Linfoma de células T hepatoesplénico"
    },
    {
      "code" : "C862",
      "display" : "C862 Linfoma de células T tipo enteropatía (intestinal)"
    },
    {
      "code" : "C863",
      "display" : "C863 Linfoma de células T subcutáneo tipo paniculitis"
    },
    {
      "code" : "C864",
      "display" : "C864 Linfoma de células NK blásticas"
    },
    {
      "code" : "C865",
      "display" : "C865 Linfoma angioinmunoblástico de células T"
    },
    {
      "code" : "C866",
      "display" : "C866 Proliferaciones cutáneas primarias de células T CD30 positivas"
    },
    {
      "code" : "C88",
      "display" : "C88 Enfermedades inmunoproliferativas malignas y ciertos linfomas de células B de otros tipos"
    },
    {
      "code" : "C880",
      "display" : "C880 Macroglobulinemia de Waldenström"
    },
    {
      "code" : "C882",
      "display" : "C882 Enfermedad de cadenas pesadas"
    },
    {
      "code" : "C883",
      "display" : "C883 Enfermedad inmunoproliferativa de intestino delgado"
    },
    {
      "code" : "C884",
      "display" : "C884 Linfoma de células B extraganglionar de zona marginal de tejido linfoide asociado a mucosas [linfoma MALT]"
    },
    {
      "code" : "C888",
      "display" : "C888 Otras enfermedades inmunoproliferativas malignas"
    },
    {
      "code" : "C889",
      "display" : "C889 Enfermedad inmunoproliferativa maligna no especificada"
    },
    {
      "code" : "C90",
      "display" : "C90 Mieloma múltiple y tumores malignos de células plasmáticas"
    },
    {
      "code" : "C900",
      "display" : "C900 Mieloma múltiple"
    },
    {
      "code" : "C9000",
      "display" : "C9000 Mieloma múltiple sin haber alcanzado remisión"
    },
    {
      "code" : "C9001",
      "display" : "C9001 Mieloma múltiple en remisión"
    },
    {
      "code" : "C9002",
      "display" : "C9002 Mieloma múltiple en recidiva"
    },
    {
      "code" : "C901",
      "display" : "C901 Leucemia de células plasmáticas"
    },
    {
      "code" : "C9011",
      "display" : "C9011 Leucemia de células plasmáticas en remisión"
    },
    {
      "code" : "C9012",
      "display" : "C9012 Leucemia de células plasmáticas en recidiva"
    },
    {
      "code" : "C902",
      "display" : "C902 Plasmocitoma extramedular"
    },
    {
      "code" : "C9021",
      "display" : "C9021 Plasmocitoma extramedular en remisión"
    },
    {
      "code" : "C9022",
      "display" : "C9022 Plasmocitoma extramedular en recidiva"
    },
    {
      "code" : "C903",
      "display" : "C903 Plasmocitoma solitario"
    },
    {
      "code" : "C9030",
      "display" : "C9030 Plasmocitoma solitario sin haber alcanzado remisión"
    },
    {
      "code" : "C9032",
      "display" : "C9032 Plasmocitoma solitario en recidiva"
    },
    {
      "code" : "C91",
      "display" : "C91 Leucemia linfoide"
    },
    {
      "code" : "C9100",
      "display" : "C9100 Leucemia linfoblástica aguda sin haber alcanzado remisión"
    },
    {
      "code" : "C9101",
      "display" : "C9101 Leucemia linfoblástica aguda en remisión"
    },
    {
      "code" : "C9102",
      "display" : "C9102 Leucemia linfoblástica aguda en recidiva"
    },
    {
      "code" : "C9110",
      "display" : "C9110 Leucemia linfocítica crónica de células B sin haber alcanzado remisión"
    },
    {
      "code" : "C9111",
      "display" : "C9111 Leucemia linfocítica crónica de células B en remisión"
    },
    {
      "code" : "C9112",
      "display" : "C9112 Leucemia linfocítica crónica de células B en recidiva"
    },
    {
      "code" : "C9130",
      "display" : "C9130 Leucemia prolinfocítica de células B sin haber alcanzado remisión"
    },
    {
      "code" : "C9131",
      "display" : "C9131 Leucemia prolinfocítica de células B en remisión"
    },
    {
      "code" : "C9132",
      "display" : "C9132 Leucemia prolinfocítica de células B en recidiva"
    },
    {
      "code" : "C9140",
      "display" : "C9140 Leucemia de células peludas sin haber alcanzado remisión"
    },
    {
      "code" : "C9141",
      "display" : "C9141 Leucemia de células peludas en remisión"
    },
    {
      "code" : "C915",
      "display" : "C915 Linfoma/leucemia de células T del adulto (asociado a HTLV-1)"
    },
    {
      "code" : "C9150",
      "display" : "C9150 Linfoma/leucemia de células T del adulto (asociado a HTLV-1) sin haber alcanzado remisión"
    },
    {
      "code" : "C9151",
      "display" : "C9151 Linfoma/leucemia de células T del adulto (asociado a HTLV-1) en remisión"
    },
    {
      "code" : "C916",
      "display" : "C916 Leucemia prolinfocítica tipo células T"
    },
    {
      "code" : "C9160",
      "display" : "C9160 Leucemia prolinfocítica tipo células T sin haber alcanzado remisión"
    },
    {
      "code" : "C9161",
      "display" : "C9161 Leucemia prolinfocítica tipo células T en remisión"
    },
    {
      "code" : "C9162",
      "display" : "C9162 Leucemia prolinfocítica tipo células T en recidiva"
    },
    {
      "code" : "C91A0",
      "display" : "C91A0 Leucemia de células B maduras tipo Burkitt sin haber alcanzado remisión"
    },
    {
      "code" : "D60",
      "display" : "D60 Aplasia pura adquirida de glóbulos rojos [eritroblastopenia]"
    },
    {
      "code" : "D600",
      "display" : "D600 Aplasia pura de glóbulos rojos adquirida crónica"
    },
    {
      "code" : "D601",
      "display" : "D601 Aplasia pura de glóbulos rojos adquirida transitoria"
    },
    {
      "code" : "D608",
      "display" : "D608 Otros tipos de aplasia pura de glóbulos rojos adquirida"
    },
    {
      "code" : "D609",
      "display" : "D609 Aplasia pura de glóbulos rojos adquirida no especificada"
    },
    {
      "code" : "D61",
      "display" : "D61 Otras anemias aplásicas y síndromes de insuficiencia medular"
    },
    {
      "code" : "D610",
      "display" : "D610 Anemia aplásica constitucional"
    },
    {
      "code" : "D6101",
      "display" : "D6101 Aplasia (pura) de glóbulos rojos constitucional"
    },
    {
      "code" : "D6109",
      "display" : "D6109 Otras aplasias constitucionales"
    },
    {
      "code" : "D611",
      "display" : "D611 Anemia aplásica inducida por fármacos"
    },
    {
      "code" : "D612",
      "display" : "D612 Anemia aplásica debida a otros agentes externos"
    },
    {
      "code" : "D613",
      "display" : "D613 Anemia aplásica idiopática"
    },
    {
      "code" : "D618",
      "display" : "D618 Otras anemias aplásicas y síndromes de insuficiencia medular especificados"
    },
    {
      "code" : "D6181",
      "display" : "D6181 Pancitopenia"
    },
    {
      "code" : "D61810",
      "display" : "D61810 Pancitopenia debida a quimioterapia antineoplásica"
    },
    {
      "code" : "D61811",
      "display" : "D61811 Pancitopenia debida a otros fármacos"
    },
    {
      "code" : "D61818",
      "display" : "D61818 Otra pancitopenia"
    },
    {
      "code" : "D6182",
      "display" : "D6182 Mieloptisis"
    },
    {
      "code" : "D6189",
      "display" : "D6189 Otras anemias aplásicas y síndromes de insuficiencia medular especificados"
    },
    {
      "code" : "D619",
      "display" : "D619 Anemia aplásica no especificada"
    },
    {
      "code" : "D62",
      "display" : "D62 Anemia poshemorrágica aguda"
    },
    {
      "code" : "D63",
      "display" : "D63 Anemia en enfermedades crónicas clasificadas bajo otro concepto"
    },
    {
      "code" : "D630",
      "display" : "D630 Anemia en enfermedad neoplásica"
    },
    {
      "code" : "D631",
      "display" : "D631 Anemia en enfermedad renal crónica"
    },
    {
      "code" : "D638",
      "display" : "D638 Anemia en otras enfermedades crónicas clasificadas bajo otro concepto"
    },
    {
      "code" : "D640",
      "display" : "D640 Anemia sideroblástica hereditaria"
    },
    {
      "code" : "D641",
      "display" : "D641 Anemia sideroblástica secundaria debida a enfermedad"
    },
    {
      "code" : "D643",
      "display" : "D643 Otras anemias sideroblásticas"
    },
    {
      "code" : "D644",
      "display" : "D644 Anemia diseritropoyética congénita"
    },
    {
      "code" : "D648",
      "display" : "D648 Otras anemias especificadas"
    },
    {
      "code" : "D6489",
      "display" : "D6489 Otras anemias especificadas"
    },
    {
      "code" : "D649",
      "display" : "D649 Anemia no especificada"
    },
    {
      "code" : "D65",
      "display" : "D65 Coagulación intravascular diseminada [síndrome de desfibrinación]"
    },
    {
      "code" : "D67",
      "display" : "D67 Déficit hereditario del factor IX"
    },
    {
      "code" : "D68",
      "display" : "D68 Otros defectos de la coagulación"
    },
    {
      "code" : "D680",
      "display" : "D680 Enfermedad de von Willebrand"
    },
    {
      "code" : "D6801",
      "display" : "D6801 Enfermedad de von Willebrand tipo 1"
    },
    {
      "code" : "D6802",
      "display" : "D6802 Enfermedad de von Willebrand tipo 2"
    },
    {
      "code" : "D68020",
      "display" : "D68020 Enfermedad de von Willebrand tipo 2A"
    },
    {
      "code" : "D68022",
      "display" : "D68022 Enfermedad de von Willebrand tipo 2M"
    },
    {
      "code" : "D68023",
      "display" : "D68023 Enfermedad de von Willebrand tipo 2N"
    },
    {
      "code" : "D68029",
      "display" : "D68029 Enfermedad de von Willebrand tipo 2 no especificada"
    },
    {
      "code" : "D6804",
      "display" : "D6804 Enfermedad de von Willebrand adquirida"
    },
    {
      "code" : "D6809",
      "display" : "D6809 Otro tipo de enfermedad de von Willebrand"
    },
    {
      "code" : "D682",
      "display" : "D682 Déficits hereditarios de otros factores de la coagulación"
    },
    {
      "code" : "D683",
      "display" : "D683 Trastorno hemorrágico debido a anticoagulantes circulantes"
    },
    {
      "code" : "D6831",
      "display" : "D6831 Trastorno hemorrágico debido a anticoagulantes anticuerpos o inhibidores circulantes intrínsecos"
    },
    {
      "code" : "D68312",
      "display" : "D68312 Anticuerpo antifosfolípido con trastorno hemorrágico"
    },
    {
      "code" : "D68318",
      "display" : "D68318 Otro trastorno hemorrágico debido a anticoagulantes anticuerpos o inhibidores circulantes intrínsecos"
    },
    {
      "code" : "D684",
      "display" : "D684 Déficit adquirido de factores de coagulación"
    },
    {
      "code" : "D685",
      "display" : "D685 Trombofilia primaria"
    },
    {
      "code" : "D6851",
      "display" : "D6851 Resistencia a la proteína C activada"
    },
    {
      "code" : "D6852",
      "display" : "D6852 Mutación del gen de la protrombina"
    },
    {
      "code" : "D686",
      "display" : "D686 Otros tipos de trombofilia"
    },
    {
      "code" : "D6861",
      "display" : "D6861 Síndrome antifosfolípido"
    },
    {
      "code" : "D6862",
      "display" : "D6862 Síndrome de anticoagulante lúpico"
    },
    {
      "code" : "B0229",
      "display" : "B0229 Otro tipo de afectación posherpética del sistema nervioso"
    },
    {
      "code" : "B023",
      "display" : "B023 Herpes zóster ocular"
    },
    {
      "code" : "B0230",
      "display" : "B0230 Herpes zóster ocular no especificado"
    },
    {
      "code" : "B0231",
      "display" : "B0231 Conjuntivitis por herpes zóster"
    },
    {
      "code" : "B0232",
      "display" : "B0232 Iridociclitis por herpes zóster"
    },
    {
      "code" : "B0233",
      "display" : "B0233 Queratitis por herpes zóster"
    },
    {
      "code" : "B0234",
      "display" : "B0234 Escleritis por herpes zóster"
    },
    {
      "code" : "B0239",
      "display" : "B0239 Otras enfermedades oculares por herpes zóster"
    },
    {
      "code" : "B027",
      "display" : "B027 Herpes zóster diseminado"
    },
    {
      "code" : "B028",
      "display" : "B028 Herpes zóster con otras complicaciones"
    },
    {
      "code" : "B029",
      "display" : "B029 Herpes zóster sin complicaciones"
    },
    {
      "code" : "B03",
      "display" : "B03 Viruela"
    },
    {
      "code" : "B04",
      "display" : "B04 Viruela de los monos"
    },
    {
      "code" : "B05",
      "display" : "B05 Sarampión"
    },
    {
      "code" : "B050",
      "display" : "B050 Sarampión complicado por encefalitis"
    },
    {
      "code" : "B051",
      "display" : "B051 Sarampión complicado por meningitis"
    },
    {
      "code" : "B052",
      "display" : "B052 Sarampión complicado por una neumonía"
    },
    {
      "code" : "B053",
      "display" : "B053 Sarampión complicado por otitis media"
    },
    {
      "code" : "B054",
      "display" : "B054 Sarampión con complicaciones intestinales"
    },
    {
      "code" : "B058",
      "display" : "B058 Sarampión con otras complicaciones"
    },
    {
      "code" : "B0581",
      "display" : "B0581 Queratitis y queratoconjuntivitis por sarampión"
    },
    {
      "code" : "B0589",
      "display" : "B0589 Otras complicaciones del sarampión"
    },
    {
      "code" : "B059",
      "display" : "B059 Sarampión sin complicaciones"
    },
    {
      "code" : "B06",
      "display" : "B06 Rubeola [sarampión alemán]"
    },
    {
      "code" : "B060",
      "display" : "B060 Rubeola con complicaciones neurológicas"
    },
    {
      "code" : "B0601",
      "display" : "B0601 Encefalitis por rubeola"
    },
    {
      "code" : "B0602",
      "display" : "B0602 Meningitis por rubeola"
    },
    {
      "code" : "B0609",
      "display" : "B0609 Otras complicaciones neurológicas de la rubeola"
    },
    {
      "code" : "B0681",
      "display" : "B0681 Neumonía por rubeola"
    },
    {
      "code" : "B0682",
      "display" :