# Catálogo de unidades de administración de despacho - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de unidades de administración de despacho**

## CodeSystem: Catálogo de unidades de administración de despacho 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/despatch-administration-unit-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:DespatchAdministrationUnitCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de unidades de administración de despacho en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DespatchAdministrationUnit](ValueSet-DespatchAdministrationUnit.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "despatch-administration-unit-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/despatch-administration-unit-code",
  "version" : "1.1.0-ballot",
  "name" : "DespatchAdministrationUnitCode",
  "title" : "Catálogo de unidades de administración de despacho",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de unidades de administración de despacho en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 1567,
  "concept" : [
    {
      "code" : "DES98",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES99",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES100",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES101",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES102",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES103",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES104",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES105",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES106",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES107",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES108",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES109",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES110",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES111",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES112",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES113",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES114",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES115",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES116",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES117",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES118",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES119",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES120",
      "display" : "ampolla(s) 10ml"
    },
    {
      "code" : "DES121",
      "display" : "ampolla(s) 5ml"
    },
    {
      "code" : "DES122",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES123",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES124",
      "display" : "ampolla(s) 5ml"
    },
    {
      "code" : "DES125",
      "display" : "ampolla(s) 10ml"
    },
    {
      "code" : "DES126",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES127",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES128",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES129",
      "display" : "ampolla(s) 5ml"
    },
    {
      "code" : "DES130",
      "display" : "ampolla(s) 5ml"
    },
    {
      "code" : "DES131",
      "display" : "ampolla(s) 3ml"
    },
    {
      "code" : "DES132",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES133",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES134",
      "display" : "frasco 100ml"
    },
    {
      "code" : "DES135",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES136",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES137",
      "display" : "ampolla(s) 1ml"
    },
    {
      "code" : "DES138",
      "display" : "ampolla(s) 1ml"
    },
    {
      "code" : "DES139",
      "display" : "ampolla(s) 1ml"
    },
    {
      "code" : "DES140",
      "display" : "frasco 20ml"
    },
    {
      "code" : "DES141",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES142",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES143",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES144",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES145",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES146",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES147",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES148",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES149",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES150",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES151",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES152",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES153",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES154",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES155",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES156",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES157",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES159",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES161",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES163",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES164",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES166",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES168",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES158",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES160",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES162",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES165",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES167",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES20",
      "display" : "caja 2 uds."
    },
    {
      "code" : "DES22",
      "display" : "caja 2 uds."
    },
    {
      "code" : "DES24",
      "display" : "caja 2 uds."
    },
    {
      "code" : "DES27",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES29",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES32",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES34",
      "display" : "frasco(s) 10 ml"
    },
    {
      "code" : "DES37",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES39",
      "display" : "frasco(s) 10 ml"
    },
    {
      "code" : "DES42",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES44",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES47",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES49",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES52",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES54",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES56",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES59",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES61",
      "display" : "ampolla(s) 1ml"
    },
    {
      "code" : "DES64",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES66",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES69",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES71",
      "display" : "ampolla(s) 10ml"
    },
    {
      "code" : "DES74",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES76",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES79",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES81",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES83",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES86",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES88",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES91",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES93",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES96",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES1",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES2",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES3",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES4",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES5",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES6",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES7",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES8",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES9",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES10",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES11",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES12",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES13",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES14",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES15",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES16",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES17",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES18",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES19",
      "display" : "parche individual"
    },
    {
      "code" : "DES21",
      "display" : "parche individual"
    },
    {
      "code" : "DES23",
      "display" : "parche individual"
    },
    {
      "code" : "DES25",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES26",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES28",
      "display" : "frasco(s) 10 ml"
    },
    {
      "code" : "DES30",
      "display" : "frasco(s) 30 comp."
    },
    {
      "code" : "DES31",
      "display" : "frasco(s) 10 ml"
    },
    {
      "code" : "DES33",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES35",
      "display" : "frasco(s) 20 ml"
    },
    {
      "code" : "DES36",
      "display" : "frasco(s) 30 ml"
    },
    {
      "code" : "DES38",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES40",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES41",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES43",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES45",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES46",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES48",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES50",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES51",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES53",
      "display" : "vial 0,23 ml"
    },
    {
      "code" : "DES55",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES57",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES58",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES60",
      "display" : "ampolla(s) 1ml"
    },
    {
      "code" : "DES62",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES63",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES65",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES67",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES68",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES70",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES72",
      "display" : "bolsa 1 ud."
    },
    {
      "code" : "DES73",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES75",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES77",
      "display" : "caja 5 uds."
    },
    {
      "code" : "DES78",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES80",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES82",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES84",
      "display" : "frasco 20ml"
    },
    {
      "code" : "DES85",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES87",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES89",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES90",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES92",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES94",
      "display" : "ampolla(s) 2ml"
    },
    {
      "code" : "DES95",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES97",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES183",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES184",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES203",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES204",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES310",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES311",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES312",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES313",
      "display" : "frasco(s) 30 gr"
    },
    {
      "code" : "DES314",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES315",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES316",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES317",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES318",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES319",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES320",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES321",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES322",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES323",
      "display" : "vial(es) 2g/0.5g"
    },
    {
      "code" : "DES324",
      "display" : "vial(es) 1.5g"
    },
    {
      "code" : "DES325",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES326",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES327",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES328",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES329",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES330",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES331",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES332",
      "display" : "frasco(s) 200ml"
    },
    {
      "code" : "DES333",
      "display" : "frasco(s) 5ml"
    },
    {
      "code" : "DES334",
      "display" : "frasco(s) 10ml"
    },
    {
      "code" : "DES335",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES336",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES337",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES338",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES339",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES340",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES341",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES342",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES343",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES344",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES345",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES346",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES347",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES348",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES349",
      "display" : "frasco(s) 200ml"
    },
    {
      "code" : "DES350",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES351",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES352",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES353",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES354",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES355",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES356",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES357",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES358",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES359",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES360",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES361",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES362",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES363",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES364",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES365",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES366",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES367",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES368",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES369",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES370",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES371",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES372",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES373",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES374",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES375",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES376",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES377",
      "display" : "sobre 3g"
    },
    {
      "code" : "DES378",
      "display" : "vial 500mg"
    },
    {
      "code" : "DES379",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES380",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES381",
      "display" : "vial 500mg+500mg"
    },
    {
      "code" : "DES382",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES383",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES384",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES385",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES386",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES387",
      "display" : "vial(es) 12ml-480mg"
    },
    {
      "code" : "DES388",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES389",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES390",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES391",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES392",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES393",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES394",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES223",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES224",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES225",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES226",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES227",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES228",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES229",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES230",
      "display" : "frasco(s) 125mL"
    },
    {
      "code" : "DES231",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES232",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES233",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES234",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES235",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES236",
      "display" : "frasco(s) 15mL"
    },
    {
      "code" : "DES237",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES238",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES239",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES240",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES241",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES242",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES243",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES244",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES245",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES246",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES247",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES248",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES249",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES250",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES251",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES252",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES253",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES254",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES255",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES256",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES257",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES258",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES259",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES260",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES261",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES262",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES263",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES264",
      "display" : "frasco(s) 75mL"
    },
    {
      "code" : "DES265",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES266",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES267",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES268",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES269",
      "display" : "frasco(s) 40mL"
    },
    {
      "code" : "DES270",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES271",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES272",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES273",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES274",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES275",
      "display" : "vial(es) 20g/5g"
    },
    {
      "code" : "DES276",
      "display" : "vial(es) 1.5g"
    },
    {
      "code" : "DES277",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES278",
      "display" : "vial(es) 100mg"
    },
    {
      "code" : "DES279",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES280",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES281",
      "display" : "vial(es) 600mg/15mL"
    },
    {
      "code" : "DES282",
      "display" : "vial(es) 900mg/22.5mL"
    },
    {
      "code" : "DES283",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES284",
      "display" : "frasco(s) 15ml"
    },
    {
      "code" : "DES285",
      "display" : "vial(es) 600mg/15ml"
    },
    {
      "code" : "DES286",
      "display" : "vial(es) 1200mg/30ml"
    },
    {
      "code" : "DES287",
      "display" : "frasco(s) 15ml (600mg)"
    },
    {
      "code" : "DES288",
      "display" : "frasco(s) 22,5ml (900mg)"
    },
    {
      "code" : "DES289",
      "display" : "frasco(s) 30ml (1200mg)"
    },
    {
      "code" : "DES290",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES291",
      "display" : "frasco(s) 15ml (1g)"
    },
    {
      "code" : "DES292",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES293",
      "display" : "vial(es) 1.2M UI"
    },
    {
      "code" : "DES294",
      "display" : "vial(es) 1.200.000 UI"
    },
    {
      "code" : "DES295",
      "display" : "vial(es) 1.000.000 UI"
    },
    {
      "code" : "DES296",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES297",
      "display" : "vial(es) 7ml (600mg)"
    },
    {
      "code" : "DES298",
      "display" : "vial(es) 1M UI"
    },
    {
      "code" : "DES299",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES300",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES301",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES302",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES303",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES304",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES305",
      "display" : "frasco(s) 80ml"
    },
    {
      "code" : "DES306",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES307",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES308",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES309",
      "display" : "frasco(s) 45ml"
    },
    {
      "code" : "DES1021",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1022",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1023",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1024",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1025",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1026",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1027",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1028",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1029",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1030",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1031",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1032",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1033",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1034",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1035",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1036",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1037",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1038",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES1039",
      "display" : "botella(s) 300ml"
    },
    {
      "code" : "DES1040",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1041",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1042",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1043",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1044",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1045",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES1046",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1047",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES1048",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1049",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1050",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1051",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES1052",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1053",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES1054",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1055",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1056",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES1057",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1058",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1059",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1060",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1061",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1062",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1063",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1064",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1065",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES1066",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1067",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1068",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1069",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1070",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1071",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1072",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1073",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1074",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1075",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1076",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1077",
      "display" : "tubo(s)  30g"
    },
    {
      "code" : "DES1078",
      "display" : "bolsa(s) 100ml"
    },
    {
      "code" : "DES1079",
      "display" : "bolsa(s) 100ml"
    },
    {
      "code" : "DES1080",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1081",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES1082",
      "display" : "vial(es) 100ml"
    },
    {
      "code" : "DES1083",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1084",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1085",
      "display" : "vial(es) 100ml"
    },
    {
      "code" : "DES1086",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1087",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1088",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1089",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1090",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1091",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1092",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1093",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1094",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1095",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1096",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1097",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1098",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1099",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1100",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1101",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1102",
      "display" : "frasco(s) 240ml"
    },
    {
      "code" : "DES1103",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1104",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES1105",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1106",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1107",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1108",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1109",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES395",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES396",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES397",
      "display" : "botella(s) 300ml"
    },
    {
      "code" : "DES398",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES399",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES400",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES401",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES402",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES403",
      "display" : "frasco(s) 1g"
    },
    {
      "code" : "DES404",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES405",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES406",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES407",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES408",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES409",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES410",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES411",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES412",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES413",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES414",
      "display" : "tubo(s)  30g"
    },
    {
      "code" : "DES415",
      "display" : "bolsa(s) 100ml"
    },
    {
      "code" : "DES416",
      "display" : "bolsa(s) 100ml"
    },
    {
      "code" : "DES417",
      "display" : "frasco(s) 500mg"
    },
    {
      "code" : "DES418",
      "display" : "vial(es) 100ml"
    },
    {
      "code" : "DES419",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES420",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES421",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES422",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES423",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES424",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES425",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES426",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES427",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES428",
      "display" : "frasco(s) 240ml"
    },
    {
      "code" : "DES429",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES430",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES431",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES432",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES433",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES434",
      "display" : "vial 500.000 UI"
    },
    {
      "code" : "DES435",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES436",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES437",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES438",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES439",
      "display" : "frasco(s) 15ml"
    },
    {
      "code" : "DES440",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES441",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES442",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES443",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES444",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES445",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES446",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES447",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES448",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES449",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES450",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES451",
      "display" : "vial(es) 500mg-2ml"
    },
    {
      "code" : "DES452",
      "display" : "vial(es) 100mg-2ml"
    },
    {
      "code" : "DES453",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES454",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES455",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES456",
      "display" : "vial(es) 5ml"
    },
    {
      "code" : "DES457",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES458",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES459",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES460",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES461",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES462",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES463",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES464",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES465",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES466",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES467",
      "display" : "dosis"
    },
    {
      "code" : "DES468",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES469",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES470",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES471",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES472",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES473",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES474",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES475",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES476",
      "display" : "frasco 120mL"
    },
    {
      "code" : "DES477",
      "display" : "frasco 240mL"
    },
    {
      "code" : "DES478",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES479",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES480",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES481",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES482",
      "display" : "frasco(s) 200mL"
    },
    {
      "code" : "DES483",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES484",
      "display" : "vial(es) 20mL"
    },
    {
      "code" : "DES485",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES486",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES487",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES488",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES489",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES490",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES491",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES492",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES493",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES494",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES495",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES496",
      "display" : "frasco(s) 125mL"
    },
    {
      "code" : "DES497",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES498",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES499",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES500",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES501",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES502",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES503",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES504",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES505",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES506",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES507",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES508",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES509",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES510",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES511",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES512",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES513",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES514",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES515",
      "display" : "frasco(s) 15mL"
    },
    {
      "code" : "DES516",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES517",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES518",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES519",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES520",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES521",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES522",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES523",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES524",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES525",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES526",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES527",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES528",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES529",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES530",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES531",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES532",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES533",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES534",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES535",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES536",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES537",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES538",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES539",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES540",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES541",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES542",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES543",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES544",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES545",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES546",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES547",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES548",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES549",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES550",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES551",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES552",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES553",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES554",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES555",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES556",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES557",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES558",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES559",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES560",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES561",
      "display" : "frasco(s) 40mL"
    },
    {
      "code" : "DES562",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES563",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES564",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES565",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES566",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES567",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES568",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES569",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES570",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES571",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES572",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES573",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES574",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES575",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES576",
      "display" : "frasco(s) 75mL"
    },
    {
      "code" : "DES577",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES578",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES579",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES580",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES581",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES582",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES583",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES584",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES585",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES586",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES587",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES588",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES589",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES590",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES591",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES592",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES593",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES594",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES595",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES596",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES597",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES598",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES599",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES600",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES601",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES602",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES603",
      "display" : "cápsulas(s)"
    },
    {
      "code" : "DES604",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES605",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES606",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES607",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES608",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES609",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES610",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES611",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES612",
      "display" : "vial(es) 20g/5g"
    },
    {
      "code" : "DES613",
      "display" : "vial(es) 1.5g"
    },
    {
      "code" : "DES614",
      "display" : "vial(es) 1.5g"
    },
    {
      "code" : "DES615",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES616",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES617",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES618",
      "display" : "vial(es) 100mg"
    },
    {
      "code" : "DES619",
      "display" : "vial(es) 100mg"
    },
    {
      "code" : "DES620",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES621",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES622",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES623",
      "display" : "vial(es) 600mg/15mL"
    },
    {
      "code" : "DES624",
      "display" : "vial(es) 900mg/22.5mL"
    },
    {
      "code" : "DES625",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES626",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES627",
      "display" : "frasco(s) 50mL"
    },
    {
      "code" : "DES628",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES629",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES630",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES631",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES632",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES633",
      "display" : "frasco(s) 15ml"
    },
    {
      "code" : "DES634",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES635",
      "display" : "vial(es) 600mg/15ml"
    },
    {
      "code" : "DES636",
      "display" : "vial(es) 1200mg/30ml"
    },
    {
      "code" : "DES637",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES638",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES639",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES640",
      "display" : "vial(es) 1200mg/30ml"
    },
    {
      "code" : "DES641",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES642",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES643",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES644",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES645",
      "display" : "vial(es) 900mg/22.5mL"
    },
    {
      "code" : "DES646",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES647",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES648",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES649",
      "display" : "frasco(s) 15ml (600mg)"
    },
    {
      "code" : "DES650",
      "display" : "frasco(s) 22,5ml (900mg)"
    },
    {
      "code" : "DES651",
      "display" : "frasco(s) 30ml (1200mg)"
    },
    {
      "code" : "DES652",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES653",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES654",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES655",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES656",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES657",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES658",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES659",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES660",
      "display" : "frasco(s) 15ml (1g)"
    },
    {
      "code" : "DES661",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES662",
      "display" : "frasco(s) 15ml (1g)"
    },
    {
      "code" : "DES663",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES664",
      "display" : "vial(es) 1.2M UI"
    },
    {
      "code" : "DES665",
      "display" : "vial(es) 1.200.000 UI"
    },
    {
      "code" : "DES666",
      "display" : "vial(es) 1.200.000 UI"
    },
    {
      "code" : "DES667",
      "display" : "vial(es) 1.2M UI"
    },
    {
      "code" : "DES668",
      "display" : "vial(es) 1.000.000 UI"
    },
    {
      "code" : "DES669",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES670",
      "display" : "vial(es) 7ml (600mg)"
    },
    {
      "code" : "DES671",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES672",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES673",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES674",
      "display" : "vial(es) 5.000.000 UI"
    },
    {
      "code" : "DES675",
      "display" : "vial(es) 1M UI"
    },
    {
      "code" : "DES676",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES677",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES678",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES679",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES680",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES681",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES682",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES683",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES684",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES685",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES686",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES687",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES688",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES689",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES690",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES691",
      "display" : "vial(es) 50mg"
    },
    {
      "code" : "DES692",
      "display" : "vial(es) 70mg"
    },
    {
      "code" : "DES693",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES694",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES695",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES696",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES697",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES698",
      "display" : "frasco(s) 80ml"
    },
    {
      "code" : "DES699",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES700",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES701",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES702",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES703",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES704",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES705",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES706",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES707",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES708",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES709",
      "display" : "frasco(s) 45ml"
    },
    {
      "code" : "DES710",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES711",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES712",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES713",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES714",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES715",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES716",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES717",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES718",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES719",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES720",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES721",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES722",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES723",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES724",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES725",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES726",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES727",
      "display" : "frasco(s) 30 gr"
    },
    {
      "code" : "DES728",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES729",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES730",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES731",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES732",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES733",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES734",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES735",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES736",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES737",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES738",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES739",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES740",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES741",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES742",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES743",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES744",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES745",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES746",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES747",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES748",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES749",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES750",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES751",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES752",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES753",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES754",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES755",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES756",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES757",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES758",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES759",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES760",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES761",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES762",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES763",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES764",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES765",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES766",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES767",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES768",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES769",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES770",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES771",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES772",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES773",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES774",
      "display" : "vial(es) 2g/0.5g"
    },
    {
      "code" : "DES775",
      "display" : "vial(es) 1.5g"
    },
    {
      "code" : "DES776",
      "display" : "vial(es) 250mg"
    },
    {
      "code" : "DES777",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES778",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES779",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES780",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES781",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES782",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES783",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES784",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES785",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES786",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES787",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES788",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES789",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES790",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES791",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES792",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES793",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES794",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES795",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES796",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES797",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES798",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES799",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES800",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES801",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES802",
      "display" : "frasco(s) 200ml"
    },
    {
      "code" : "DES803",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES804",
      "display" : "frasco(s) 5ml"
    },
    {
      "code" : "DES805",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES806",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES807",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES808",
      "display" : "frasco(s) 5ml"
    },
    {
      "code" : "DES809",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES810",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES811",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES812",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES813",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES814",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES815",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES816",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES817",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES818",
      "display" : "frasco(s) 5ml"
    },
    {
      "code" : "DES819",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES820",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES821",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES822",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES823",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES824",
      "display" : "frasco(s) 10ml"
    },
    {
      "code" : "DES825",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES826",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES827",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES828",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES829",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES830",
      "display" : "frasco(s) 5ml"
    },
    {
      "code" : "DES831",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES832",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES833",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES834",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES835",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES836",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES837",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES838",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES839",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES840",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES841",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES842",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES843",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES844",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES845",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES846",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES847",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES848",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES849",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES850",
      "display" : "frasco(s) 50ml"
    },
    {
      "code" : "DES851",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES852",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES853",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES854",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES855",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES856",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES857",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES858",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES859",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES860",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES861",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES862",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES863",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES864",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES865",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES866",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES867",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES868",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES869",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES870",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES871",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES872",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES873",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES874",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES875",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES876",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES877",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES878",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES879",
      "display" : "ampolla(s) 6ml"
    },
    {
      "code" : "DES880",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES881",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES882",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES883",
      "display" : "frasco(s) 200ml"
    },
    {
      "code" : "DES884",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES885",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES886",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES887",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES888",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES889",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES890",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES891",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES892",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES893",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES894",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES895",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES896",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES897",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES898",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES899",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES900",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES901",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES902",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES903",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES904",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES905",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES906",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES907",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES908",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES909",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES910",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES911",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES912",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES913",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES914",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES915",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES916",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES917",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES918",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES919",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES920",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES921",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES922",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES923",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES924",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES925",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES926",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES927",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES928",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES929",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES930",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES931",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES932",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES933",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES934",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES935",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES936",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES937",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES938",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES939",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES940",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES941",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES942",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES943",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES944",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES945",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES946",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES947",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES948",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES949",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES950",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES951",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES952",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES953",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES954",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES955",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES956",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES957",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES958",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES959",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES960",
      "display" : "sobre 3g"
    },
    {
      "code" : "DES961",
      "display" : "sobre 3g"
    },
    {
      "code" : "DES962",
      "display" : "sobre 3g"
    },
    {
      "code" : "DES963",
      "display" : "sobre 3g"
    },
    {
      "code" : "DES964",
      "display" : "vial 500mg"
    },
    {
      "code" : "DES965",
      "display" : "vial 500mg"
    },
    {
      "code" : "DES966",
      "display" : "vial 500mg"
    },
    {
      "code" : "DES967",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES968",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES969",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES970",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES971",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES972",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES973",
      "display" : "vial(es) 2ml"
    },
    {
      "code" : "DES974",
      "display" : "vial 500mg+500mg"
    },
    {
      "code" : "DES975",
      "display" : "vial 500mg+500mg"
    },
    {
      "code" : "DES976",
      "display" : "vial 500mg+500mg"
    },
    {
      "code" : "DES977",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES978",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES979",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES980",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES981",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES982",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES983",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES984",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES985",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES986",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES987",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES988",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES989",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES990",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES991",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES992",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES993",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES994",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES995",
      "display" : "vial(es) 12ml-480mg"
    },
    {
      "code" : "DES996",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES997",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES998",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES999",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1000",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1001",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1002",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1003",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1004",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1005",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1006",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1007",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1008",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1009",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1010",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1011",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1012",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1013",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1014",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1015",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1016",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1017",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1018",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1019",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1020",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1379",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1380",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1381",
      "display" : "ampolla 5mL"
    },
    {
      "code" : "DES1382",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1383",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1384",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1385",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1386",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1387",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1388",
      "display" : "tubo 5g en 100g"
    },
    {
      "code" : "DES1389",
      "display" : "tubo 3g en 60g"
    },
    {
      "code" : "DES1390",
      "display" : "sobre(s) 10mL"
    },
    {
      "code" : "DES1391",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1392",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1393",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1394",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1395",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1396",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1397",
      "display" : "vial(es) 50 mL"
    },
    {
      "code" : "DES1398",
      "display" : "vial(es) 50 mL"
    },
    {
      "code" : "DES1399",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1400",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1401",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1402",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1403",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1404",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1405",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1406",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1407",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1408",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1409",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1410",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1411",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1412",
      "display" : "tubo 20g"
    },
    {
      "code" : "DES1413",
      "display" : "tubo  30g"
    },
    {
      "code" : "DES1414",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1415",
      "display" : "tubo 20g"
    },
    {
      "code" : "DES1416",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1417",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1418",
      "display" : "tubo 20g"
    },
    {
      "code" : "DES1419",
      "display" : "tubo  30g"
    },
    {
      "code" : "DES1420",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1421",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1422",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1423",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1424",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1425",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1426",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1427",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1428",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1429",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1430",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1431",
      "display" : "frasco(s) 75mL"
    },
    {
      "code" : "DES1432",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1433",
      "display" : "frasco(s) 125mL"
    },
    {
      "code" : "DES1434",
      "display" : "bolsa(s) 125mL"
    },
    {
      "code" : "DES1435",
      "display" : "bolsa(s) 150mL"
    },
    {
      "code" : "DES1436",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES1437",
      "display" : "frasco(s) 175mL"
    },
    {
      "code" : "DES1438",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1439",
      "display" : "frasco(s) 15mL"
    },
    {
      "code" : "DES1440",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1441",
      "display" : "frasco(s) 40mL"
    },
    {
      "code" : "DES1442",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1443",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1444",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1445",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1446",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1447",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1448",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1449",
      "display" : "tubo(s) 15g"
    },
    {
      "code" : "DES1450",
      "display" : "tubo(s) 15g"
    },
    {
      "code" : "DES1451",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1452",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1453",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1454",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1455",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1456",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1459",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1460",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1461",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1462",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1463",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1464",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1465",
      "display" : "tubo 40g"
    },
    {
      "code" : "DES1466",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1467",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1468",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1469",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES1470",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1471",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1472",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1473",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1474",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1475",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1476",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1477",
      "display" : "frasco(s) 130mL"
    },
    {
      "code" : "DES1478",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES1572",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1573",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1574",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1575",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1576",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1577",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1578",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1579",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1580",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1581",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1582",
      "display" : "vial 60mg"
    },
    {
      "code" : "DES1583",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1584",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1585",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1586",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1587",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1588",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES1619",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1620",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1621",
      "display" : "frasco(s) 180ml"
    },
    {
      "code" : "DES1622",
      "display" : "frasco(s) 240ml"
    },
    {
      "code" : "DES1623",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES1624",
      "display" : "frasco(s) 75ml"
    },
    {
      "code" : "DES1625",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1626",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1627",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1628",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1629",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1630",
      "display" : "vial 500.000 UI"
    },
    {
      "code" : "DES1631",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1632",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1633",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1634",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1635",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1636",
      "display" : "frasco(s) 180ml"
    },
    {
      "code" : "DES1637",
      "display" : "frasco(s) 240ml"
    },
    {
      "code" : "DES1638",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES1639",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1640",
      "display" : "frasco(s) 75ml"
    },
    {
      "code" : "DES1641",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1642",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1643",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1644",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1645",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1646",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1647",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1648",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1649",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1650",
      "display" : "vial 500.000 UI"
    },
    {
      "code" : "DES1651",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1481",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1482",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1483",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1484",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1485",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1486",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1487",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1488",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1489",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1490",
      "display" : "tubo(s) 30g"
    },
    {
      "code" : "DES1491",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1492",
      "display" : "tubo(s) 30g"
    },
    {
      "code" : "DES1493",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1494",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1495",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1496",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1497",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1498",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1499",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1500",
      "display" : "tubo(s) 30g"
    },
    {
      "code" : "DES1501",
      "display" : "tubo(s) 40g"
    },
    {
      "code" : "DES1502",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1503",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1504",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1505",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1506",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1507",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1508",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1509",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1510",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1511",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1512",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1513",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1514",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1515",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1516",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1517",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1518",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1519",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1520",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1521",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1522",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1523",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1524",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1525",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1526",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1527",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1528",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1529",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1530",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1531",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1532",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1533",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1534",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1535",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1536",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1537",
      "display" : "vial 60mg"
    },
    {
      "code" : "DES1538",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1539",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1540",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1541",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1542",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1543",
      "display" : "frasco(s) 70mL"
    },
    {
      "code" : "DES1544",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1545",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1546",
      "display" : "vial 4g+0,5g"
    },
    {
      "code" : "DES1547",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1548",
      "display" : "tubo(s) 30g"
    },
    {
      "code" : "DES1549",
      "display" : "ampolla(s) 4ml"
    },
    {
      "code" : "DES1550",
      "display" : "tubo(s) 30g"
    },
    {
      "code" : "DES1551",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1552",
      "display" : "tubo(s) 40g"
    },
    {
      "code" : "DES1553",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1554",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1555",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1556",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1557",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1558",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1559",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1560",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1561",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1562",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1563",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1564",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1565",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1566",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1567",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1568",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1569",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1570",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1571",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1110",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1111",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1112",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1113",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1114",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1115",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1116",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1117",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1118",
      "display" : "vial(es) 1gr"
    },
    {
      "code" : "DES1119",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1120",
      "display" : "vial 500.000 UI"
    },
    {
      "code" : "DES1121",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1122",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1123",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1124",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1125",
      "display" : "frasco(s) 15ml"
    },
    {
      "code" : "DES1126",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1127",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1128",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1129",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1130",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1131",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1132",
      "display" : "frasco(s) 30ml"
    },
    {
      "code" : "DES1133",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1134",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1135",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1136",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1137",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1138",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1139",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1140",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1141",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1142",
      "display" : "frasco(s) 60ml"
    },
    {
      "code" : "DES1143",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1144",
      "display" : "frasco(s) 120ml"
    },
    {
      "code" : "DES1145",
      "display" : "frasco(s) 100ml"
    },
    {
      "code" : "DES1146",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1147",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1148",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1149",
      "display" : "vial(es) 500mg-2ml"
    },
    {
      "code" : "DES1150",
      "display" : "vial(es) 100mg-2ml"
    },
    {
      "code" : "DES1151",
      "display" : "vial(es) 500mg-2ml"
    },
    {
      "code" : "DES1152",
      "display" : "vial(es) 100mg-2ml"
    },
    {
      "code" : "DES1153",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1154",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1155",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1156",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES1157",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES1158",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES1159",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES1160",
      "display" : "vial 50mg"
    },
    {
      "code" : "DES1161",
      "display" : "vial(es) 5ml"
    },
    {
      "code" : "DES1162",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1163",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1164",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1165",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1166",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1167",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1168",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1169",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1170",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1171",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1172",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1173",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1174",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1175",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1176",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1177",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1178",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1179",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1180",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1181",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1182",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1183",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1184",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1185",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1186",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1187",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1188",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1189",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1190",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1191",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1192",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1193",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1194",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1195",
      "display" : "vial(es) 1g"
    },
    {
      "code" : "DES1196",
      "display" : "vial(es) 500mg"
    },
    {
      "code" : "DES1197",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1198",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1199",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1200",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1201",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1202",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1203",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1204",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1205",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1206",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1207",
      "display" : "vial(es) 200mg"
    },
    {
      "code" : "DES1208",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1209",
      "display" : "dosis"
    },
    {
      "code" : "DES1210",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1211",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1212",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1213",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1214",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1215",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1216",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1217",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1218",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1219",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1220",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1221",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES1222",
      "display" : "frasco 120mL"
    },
    {
      "code" : "DES1223",
      "display" : "frasco 240mL"
    },
    {
      "code" : "DES1224",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1225",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1226",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1227",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES1228",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1229",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES1230",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1231",
      "display" : "frasco(s) 200mL"
    },
    {
      "code" : "DES1232",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES1233",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1234",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1235",
      "display" : "frasco(s) 240mL"
    },
    {
      "code" : "DES1236",
      "display" : "vial(es) 20mL"
    },
    {
      "code" : "DES1237",
      "display" : "tubo(s) 15 g"
    },
    {
      "code" : "DES1238",
      "display" : "tubo(s) 30 g"
    },
    {
      "code" : "DES1239",
      "display" : "tubo(s) 40 g"
    },
    {
      "code" : "DES1240",
      "display" : "tubo(s) 50 g"
    },
    {
      "code" : "DES1241",
      "display" : "tubo(s) 100 g"
    },
    {
      "code" : "DES1242",
      "display" : "tubo(s) 120 g"
    },
    {
      "code" : "DES1243",
      "display" : "tubo(s) 130 g"
    },
    {
      "code" : "DES1244",
      "display" : "tubo(s) 60 g"
    },
    {
      "code" : "DES1245",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1246",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1247",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1248",
      "display" : "frasco 10mL"
    },
    {
      "code" : "DES1249",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1250",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1251",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1252",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1253",
      "display" : "sobre(s) 0.75g gel"
    },
    {
      "code" : "DES1254",
      "display" : "sobre(s) 2.25g gel"
    },
    {
      "code" : "DES1255",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1256",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1257",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1258",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1259",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1260",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1261",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1262",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES1263",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1264",
      "display" : "frasco 5mL"
    },
    {
      "code" : "DES1265",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1266",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1267",
      "display" : "ampolla 5mL"
    },
    {
      "code" : "DES1268",
      "display" : "tubo 5g en 100g"
    },
    {
      "code" : "DES1269",
      "display" : "tubo 3g en 60g"
    },
    {
      "code" : "DES1270",
      "display" : "sobre(s) 10mL"
    },
    {
      "code" : "DES1271",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1272",
      "display" : "vial(es) 50 mL"
    },
    {
      "code" : "DES1273",
      "display" : "vial(es) 10 mL"
    },
    {
      "code" : "DES1274",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1275",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1276",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1277",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1278",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1279",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1280",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1281",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1282",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1283",
      "display" : "tubo 20g"
    },
    {
      "code" : "DES1284",
      "display" : "tubo  30g"
    },
    {
      "code" : "DES1285",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1286",
      "display" : "tableta(s)"
    },
    {
      "code" : "DES1287",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1288",
      "display" : "frasco(s) 75mL"
    },
    {
      "code" : "DES1289",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1290",
      "display" : "frasco(s) 125mL"
    },
    {
      "code" : "DES1291",
      "display" : "bolsa(s) 125mL"
    },
    {
      "code" : "DES1292",
      "display" : "bolsa(s) 150mL"
    },
    {
      "code" : "DES1293",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES1294",
      "display" : "frasco(s) 175mL"
    },
    {
      "code" : "DES1295",
      "display" : "frasco(s) 15mL"
    },
    {
      "code" : "DES1296",
      "display" : "frasco(s) 40mL"
    },
    {
      "code" : "DES1297",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1298",
      "display" : "frasco(s) 30mL"
    },
    {
      "code" : "DES1299",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1300",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1301",
      "display" : "tubo(s) 15g"
    },
    {
      "code" : "DES1302",
      "display" : "tubo(s) 15g"
    },
    {
      "code" : "DES1303",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1304",
      "display" : "cápsula(s)"
    },
    {
      "code" : "DES1305",
      "display" : "óvulo(s)"
    },
    {
      "code" : "DES1306",
      "display" : "tubo 30g"
    },
    {
      "code" : "DES1307",
      "display" : "tubo 40g"
    },
    {
      "code" : "DES1308",
      "display" : "tubo 15g"
    },
    {
      "code" : "DES1309",
      "display" : "frasco(s) 100mL"
    },
    {
      "code" : "DES1310",
      "display" : "frasco(s) 60mL"
    },
    {
      "code" : "DES1311",
      "display" : "frasco(s) 150mL"
    },
    {
      "code" : "DES1312",
      "display" : "frasco(s) 120mL"
    },
    {
      "code" : "DES1313",
      "display" : "frasco(s) 130mL"
    },
    {
      "code" : "DES1314",
      "display" : "tubo(s) 15 g"
    },
    {
      "code" : "DES1315",
      "display" : "tubo(s) 30 g"
    },
    {
      "code" : "DES1316",
      "display" : "tubo(s) 40 g"
    },
    {
      "code" : "DES1317",
      "display" : "tubo(s) 50 g"
    },
    {
      "code" : "DES1318",
      "display" : "tubo(s) 100 g"
    },
    {
      "code" : "DES1319",
      "display" : "tubo(s) 120 g"
    },
    {
      "code" : "DES1320",
      "display" : "tubo(s) 130 g"
    },
    {
      "code" : "DES1321",
      "display" : "tubo(s) 30 g"
    },
    {
      "code" : "DES1322",
      "display" : "tubo(s) 60 g"
    },
    {
      "code" : "DES1323",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1324",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1325",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1326",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1327",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1328",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1329",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1330",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1331",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1332",
      "display" : "sobre(s) 0.75g gel"
    },
    {
      "code" : "DES1333",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1334",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1335",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1336",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1337",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1338",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1339",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1340",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1341",
      "display" : "frasco 10mL"
    },
    {
      "code" : "DES1342",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1343",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1344",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1345",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1346",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1347",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES1348",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1349",
      "display" : "comprimido(s)"
    },
    {
      "code" : "DES1350",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1351",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES1352",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1353",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1354",
      "display" : "frasco 5mL"
    },
    {
      "code" : "DES1355",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1356",
      "display" : "frasco(s) 20mL"
    },
    {
      "code" : "DES1357",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1358",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1359",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1360",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1361",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1362",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1363",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1364",
      "display" : "sobre(s) 2.25g gel"
    },
    {
      "code" : "DES1365",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1366",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1367",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1368",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1369",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1370",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1371",
      "display" : "frasco(s) 10mL"
    },
    {
      "code" : "DES1372",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1373",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1374",
      "display" : "frasco 60mL"
    },
    {
      "code" : "DES1375",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1376",
      "display" : "tabletas(s)"
    },
    {
      "code" : "DES1377",
      "display" : "frasco 30mL"
    },
    {
      "code" : "DES1378",
      "display" : "frasco 60mL"
    }
  ]
}

```
