# Catálogo de unidades de medida de un medicamento - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de unidades de medida de un medicamento**

## CodeSystem: Catálogo de unidades de medida de un medicamento 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/medication-units-of-measure-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicationUnitsOfMeasureCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de unidades de medida de un medicamento en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationUnitsOfMeasure](ValueSet-MedicationUnitsOfMeasure.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-units-of-measure-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/medication-units-of-measure-code",
  "version" : "1.1.0-ballot",
  "name" : "MedicationUnitsOfMeasureCode",
  "title" : "Catálogo de unidades de medida de un medicamento",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de unidades de medida de un medicamento en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 18,
  "concept" : [
    {
      "code" : "6",
      "display" : "Tonelada"
    },
    {
      "code" : "7",
      "display" : "Libra"
    },
    {
      "code" : "8",
      "display" : "Onzas"
    },
    {
      "code" : "11",
      "display" : "mg/10ml"
    },
    {
      "code" : "9",
      "display" : "mg/2ml"
    },
    {
      "code" : "12",
      "display" : "mg/5ml"
    },
    {
      "code" : "10",
      "display" : "mg/3ml"
    },
    {
      "code" : "258684004",
      "display" : "Miligramos"
    },
    {
      "code" : "258685003",
      "display" : "Microgramo"
    },
    {
      "code" : "258798001",
      "display" : "mg/ml"
    },
    {
      "code" : "4",
      "display" : "Gramo"
    },
    {
      "code" : "5",
      "display" : "Kilogramo"
    },
    {
      "code" : "258838007",
      "display" : "microgramo/hora"
    },
    {
      "code" : "258997004",
      "display" : "ui"
    },
    {
      "code" : "408168009",
      "display" : "mg/g"
    },
    {
      "code" : "259002007",
      "display" : "ui/ml"
    },
    {
      "code" : "408163000",
      "display" : "ui/g"
    },
    {
      "code" : "408164006",
      "display" : "ui/mg"
    }
  ]
}

```
