# Catálogo de estados de las prescripciones - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de estados de las prescripciones**

## CodeSystem: Catálogo de estados de las prescripciones 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/prescription-statuses-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PrescriptionStatusesCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de estados de las prescripciones en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PrescriptionStatuses](ValueSet-prescriptionStatuses.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "prescription-statuses-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/prescription-statuses-code",
  "version" : "1.1.0-ballot",
  "name" : "PrescriptionStatusesCode",
  "title" : "Catálogo de estados de las prescripciones",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de estados de las prescripciones en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "draft",
      "display" : "En Proceso"
    },
    {
      "code" : "completed",
      "display" : "Creada"
    },
    {
      "code" : "active",
      "display" : "Preparada"
    },
    {
      "code" : "on-hold",
      "display" : "Preparada Parcial"
    },
    {
      "code" : "cancelled",
      "display" : "Anulada"
    },
    {
      "code" : "entered-in-error",
      "display" : "Expirada"
    },
    {
      "code" : "stopped",
      "display" : "Cerrada"
    }
  ]
}

```
