# Catálogo de substancias - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Catálogo de substancias**

## CodeSystem: Catálogo de substancias 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/substances-code | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:SubstancesCode |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Catálogo de substancias en Receta Digital 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Substances](ValueSet-Substances.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "substances-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/CodeSystem/substances-code",
  "version" : "1.1.0-ballot",
  "name" : "SubstancesCode",
  "title" : "Catálogo de substancias",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Catálogo de substancias en Receta Digital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "caseSensitive" : false,
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 6264,
  "concept" : [
    {
      "code" : "294851004",
      "display" : "agente perfluoroquímico"
    },
    {
      "code" : "294282009",
      "display" : "agente quelante"
    },
    {
      "code" : "294831003",
      "display" : "agente regulador del calcio"
    },
    {
      "code" : "2481000122108",
      "display" : "agente saborizante alimentario"
    },
    {
      "code" : "294802002",
      "display" : "agente tiroideo"
    },
    {
      "code" : "419666006",
      "display" : "agente tópico"
    },
    {
      "code" : "294216002",
      "display" : "agente uricosúrico"
    },
    {
      "code" : "294187009",
      "display" : "agentes esfacelantes"
    },
    {
      "code" : "294842007",
      "display" : "agentes hematológicos"
    },
    {
      "code" : "294033001",
      "display" : "agonista de receptor adrenérgico beta 2"
    },
    {
      "code" : "294024003",
      "display" : "agonista de receptor alfa-adrenérgico"
    },
    {
      "code" : "1156733008",
      "display" : "agonista de receptor de eritropoyetina"
    },
    {
      "code" : "294166004",
      "display" : "agregados emolientes para el bańo"
    },
    {
      "code" : "17831000122105",
      "display" : "aguacate"
    },
    {
      "code" : "23291000122108",
      "display" : "ajo"
    },
    {
      "code" : "22921000122109",
      "display" : "albahaca"
    },
    {
      "code" : "24191000122104",
      "display" : "albaricoque"
    },
    {
      "code" : "294459009",
      "display" : "albendazol"
    },
    {
      "code" : "24521000122107",
      "display" : "albúmina sérica"
    },
    {
      "code" : "15881000122101",
      "display" : "alcachofa"
    },
    {
      "code" : "23601000122100",
      "display" : "alcalasa"
    },
    {
      "code" : "294067006",
      "display" : "alcaloide de la belladona"
    },
    {
      "code" : "293792005",
      "display" : "alcaloide de la vinca"
    },
    {
      "code" : "294214004",
      "display" : "alcaloide del cólquico"
    },
    {
      "code" : "295066007",
      "display" : "alcaloide del cornezuelo"
    },
    {
      "code" : "293602008",
      "display" : "alcaloide del opio"
    },
    {
      "code" : "294691003",
      "display" : "alclometasona"
    },
    {
      "code" : "21761000122107",
      "display" : "alcohol bencílico"
    },
    {
      "code" : "294330005",
      "display" : "alcohol de lanolina"
    },
    {
      "code" : "420140004",
      "display" : "alcohol etílico"
    },
    {
      "code" : "294332002",
      "display" : "alcohol polivinílico"
    },
    {
      "code" : "294227000",
      "display" : "alcuronio"
    },
    {
      "code" : "293733002",
      "display" : "aldesleukina"
    },
    {
      "code" : "32501000122106",
      "display" : "alectinib"
    },
    {
      "code" : "293604009",
      "display" : "alfentanilo"
    },
    {
      "code" : "293986006",
      "display" : "alfuzosina"
    },
    {
      "code" : "1025011000122100",
      "display" : "algodón"
    },
    {
      "code" : "294140002",
      "display" : "alimemazina"
    },
    {
      "code" : "294904000",
      "display" : "alimentación por vía intravenosa"
    },
    {
      "code" : "294909005",
      "display" : "alimentación por vía intravenosa (carbohidratos)"
    },
    {
      "code" : "294906003",
      "display" : "alimentación por vía intravenosa (electrólitos/oligoelementos)"
    },
    {
      "code" : "294910000",
      "display" : "alimentación por vía intravenosa (grasas)"
    },
    {
      "code" : "414285001",
      "display" : "alimentaria"
    },
    {
      "code" : "414314005",
      "display" : "alimentaria intestinal"
    },
    {
      "code" : "91937001",
      "display" : "alimento de origen marino"
    },
    {
      "code" : "703911000",
      "display" : "almeja"
    },
    {
      "code" : "712839001",
      "display" : "almendra"
    },
    {
      "code" : "24751000122107",
      "display" : "almorta"
    },
    {
      "code" : "18051000122105",
      "display" : "alogliptina"
    },
    {
      "code" : "294220003",
      "display" : "alopurinol"
    },
    {
      "code" : "294255001",
      "display" : "alprostadil"
    },
    {
      "code" : "294169006",
      "display" : "alquitrán mineral"
    },
    {
      "code" : "712845009",
      "display" : "altramuz"
    },
    {
      "code" : "703925004",
      "display" : "alubia"
    },
    {
      "code" : "293691009",
      "display" : "alverina"
    },
    {
      "code" : "426232007",
      "display" : "ambiental"
    },
    {
      "code" : "13631000122100",
      "display" : "ambroxol"
    },
    {
      "code" : "23991000122103",
      "display" : "amidotrizoato"
    },
    {
      "code" : "293732007",
      "display" : "amifostina"
    },
    {
      "code" : "23611000122102",
      "display" : "amilasa"
    },
    {
      "code" : "293883002",
      "display" : "amilobarbital sódico"
    },
    {
      "code" : "295010007",
      "display" : "amilorida"
    },
    {
      "code" : "295013009",
      "display" : "amilorida y a diurético tiazídico"
    },
    {
      "code" : "294158008",
      "display" : "aminofilina"
    },
    {
      "code" : "294462007",
      "display" : "aminoglucósido"
    },
    {
      "code" : "35361000122107",
      "display" : "aminopenicilina"
    },
    {
      "code" : "860902005",
      "display" : "aminoquinolina"
    },
    {
      "code" : "294988000",
      "display" : "amiodarona"
    },
    {
      "code" : "293829000",
      "display" : "amitriptilina"
    },
    {
      "code" : "294390007",
      "display" : "amodiaquina"
    },
    {
      "code" : "293828008",
      "display" : "amoxapina"
    },
    {
      "code" : "294505008",
      "display" : "amoxicilina"
    },
    {
      "code" : "294506009",
      "display" : "ampicilina"
    },
    {
      "code" : "294522005",
      "display" : "ampicilina y cloxacilina"
    },
    {
      "code" : "871506009",
      "display" : "ampicilina y/o cloxacilina"
    },
    {
      "code" : "18601000122104",
      "display" : "amprenavir y derivados"
    },
    {
      "code" : "293778004",
      "display" : "amsacrina"
    },
    {
      "code" : "293582004",
      "display" : "analgésicos"
    },
    {
      "code" : "293583009",
      "display" : "analgésicos no opiáceos"
    },
    {
      "code" : "293603003",
      "display" : "análogo de la petidina"
    },
    {
      "code" : "293590004",
      "display" : "análogo de metadona"
    },
    {
      "code" : "294871008",
      "display" : "Ancrod"
    },
    {
      "code" : "21881000122107",
      "display" : "azúcar invertido"
    },
    {
      "code" : "23721000122102",
      "display" : "azul patente"
    },
    {
      "code" : "23681000122107",
      "display" : "bacalao"
    },
    {
      "code" : "294511006",
      "display" : "bacampicilina"
    },
    {
      "code" : "20051000122104",
      "display" : "bacitracina"
    },
    {
      "code" : "294234003",
      "display" : "baclofeno"
    },
    {
      "code" : "830212002",
      "display" : "bálsamo de Perú"
    },
    {
      "code" : "294038005",
      "display" : "bambuterol"
    },
    {
      "code" : "860900002",
      "display" : "barbiturato"
    },
    {
      "code" : "23691000122105",
      "display" : "barbo"
    },
    {
      "code" : "18181000122103",
      "display" : "barnidipino"
    },
    {
      "code" : "294322009",
      "display" : "base química"
    },
    {
      "code" : "23781000122103",
      "display" : "batata"
    },
    {
      "code" : "23751000122109",
      "display" : "bayas de Goji"
    },
    {
      "code" : "293858002",
      "display" : "beclamida"
    },
    {
      "code" : "294692005",
      "display" : "beclometasona"
    },
    {
      "code" : "19681000122102",
      "display" : "bedaquilina"
    },
    {
      "code" : "294455003",
      "display" : "befenio"
    },
    {
      "code" : "18491000122106",
      "display" : "befunolol"
    },
    {
      "code" : "1025231000122100",
      "display" : "bemiparina"
    },
    {
      "code" : "35151000122107",
      "display" : "benazepril"
    },
    {
      "code" : "20351000122102",
      "display" : "bencidamina"
    },
    {
      "code" : "294499007",
      "display" : "bencilpenicilina"
    },
    {
      "code" : "15961000122103",
      "display" : "bendamustina"
    },
    {
      "code" : "294992007",
      "display" : "bendrofluazida"
    },
    {
      "code" : "293920002",
      "display" : "benperidol"
    },
    {
      "code" : "871503001",
      "display" : "benserazida y/o levodopa"
    },
    {
      "code" : "294281002",
      "display" : "bentonita"
    },
    {
      "code" : "294438002",
      "display" : "benzalconio"
    },
    {
      "code" : "860903000",
      "display" : "benzimidazol"
    },
    {
      "code" : "293724004",
      "display" : "benzocaína"
    },
    {
      "code" : "767642003",
      "display" : "benzodiacepina"
    },
    {
      "code" : "294103005",
      "display" : "beractant"
    },
    {
      "code" : "23091000122102",
      "display" : "berenjena"
    },
    {
      "code" : "295103004",
      "display" : "betahistina"
    },
    {
      "code" : "20391000122106",
      "display" : "betaína"
    },
    {
      "code" : "294678004",
      "display" : "betametasona"
    },
    {
      "code" : "294018009",
      "display" : "betanecol"
    },
    {
      "code" : "293966007",
      "display" : "betaxolol"
    },
    {
      "code" : "294964002",
      "display" : "bezafibrato"
    },
    {
      "code" : "294833000",
      "display" : "bifosfonato"
    },
    {
      "code" : "294739009",
      "display" : "biguanida"
    },
    {
      "code" : "293678008",
      "display" : "bisacodilo"
    },
    {
      "code" : "293967003",
      "display" : "bisoprolol"
    },
    {
      "code" : "295047007",
      "display" : "bloqueante ganglionar"
    },
    {
      "code" : "24451000122101",
      "display" : "boniato"
    },
    {
      "code" : "23651000122101",
      "display" : "bonito"
    },
    {
      "code" : "294433006",
      "display" : "borato"
    },
    {
      "code" : "35271000122109",
      "display" : "borraja"
    },
    {
      "code" : "32441000122107",
      "display" : "bosutinib"
    },
    {
      "code" : "294986001",
      "display" : "bretilio"
    },
    {
      "code" : "23331000122103",
      "display" : "brócoli"
    },
    {
      "code" : "295112002",
      "display" : "bromelinas"
    },
    {
      "code" : "294128002",
      "display" : "bromfeniramina"
    },
    {
      "code" : "294151002",
      "display" : "bromhidrato de dextrometorfano"
    },
    {
      "code" : "294075000",
      "display" : "bromhidrato de hioscina"
    },
    {
      "code" : "19961000122100",
      "display" : "bromperidol y sus derivados"
    },
    {
      "code" : "20081000122105",
      "display" : "bromuro"
    },
    {
      "code" : "294712001",
      "display" : "budesonida"
    },
    {
      "code" : "294713006",
      "display" : "budesonida tópica"
    },
    {
      "code" : "295001004",
      "display" : "bumetanida"
    },
    {
      "code" : "293719002",
      "display" : "bupivacaína"
    },
    {
      "code" : "294817003",
      "display" : "buserelina"
    },
    {
      "code" : "293742009",
      "display" : "busulfano"
    },
    {
      "code" : "293689001",
      "display" : "butilbromuro de hioscina"
    },
    {
      "code" : "293881000",
      "display" : "butobarbital"
    },
    {
      "code" : "293822009",
      "display" : "butriptilina"
    },
    {
      "code" : "294800005",
      "display" : "cabergolina"
    },
    {
      "code" : "91935009",
      "display" : "cacahuete"
    },
    {
      "code" : "35241000122103",
      "display" : "cadmio"
    },
    {
      "code" : "418344001",
      "display" : "cafeína"
    },
    {
      "code" : "24241000122104",
      "display" : "calabacín"
    },
    {
      "code" : "23711000122108",
      "display" : "calamar"
    },
    {
      "code" : "294168003",
      "display" : "calamina"
    },
    {
      "code" : "294839001",
      "display" : "calcitonina"
    },
    {
      "code" : "419972009",
      "display" : "camarones"
    },
    {
      "code" : "35041000122106",
      "display" : "candesartán"
    },
    {
      "code" : "418397007",
      "display" : "canela"
    },
    {
      "code" : "24321000122104",
      "display" : "cangrejo de río"
    },
    {
      "code" : "24651000122104",
      "display" : "cannabis"
    },
    {
      "code" : "24661000122102",
      "display" : "cantárida"
    },
    {
      "code" : "293669002",
      "display" : "caolín"
    },
    {
      "code" : "35091000122104",
      "display" : "captopril"
    },
    {
      "code" : "24251000122102",
      "display" : "caqui"
    },
    {
      "code" : "23791000122100",
      "display" : "carambola"
    },
    {
      "code" : "294019001",
      "display" : "carbacol"
    },
    {
      "code" : "860901003",
      "display" : "carbamato"
    },
    {
      "code" : "293867002",
      "display" : "carbamazepina"
    },
    {
      "code" : "294531005",
      "display" : "carbapenem"
    },
    {
      "code" : "294623005",
      "display" : "carbarilo"
    },
    {
      "code" : "20071000122107",
      "display" : "carbazocromo"
    },
    {
      "code" : "294510007",
      "display" : "carbenicilina"
    },
    {
      "code" : "293657005",
      "display" : "carbenoxolona"
    },
    {
      "code" : "870731003",
      "display" : "carbidopa y/o levodopa"
    },
    {
      "code" : "294674002",
      "display" : "carbimazol"
    },
    {
      "code" : "294095006",
      "display" : "carbocisteína"
    },
    {
      "code" : "294333007",
      "display" : "carbómero 940"
    },
    {
      "code" : "294265007",
      "display" : "carbón activado"
    },
    {
      "code" : "293818004",
      "display" : "carbonato de litio"
    },
    {
      "code" : "293779007",
      "display" : "carboplatino"
    },
    {
      "code" : "294258004",
      "display" : "carboprost"
    },
    {
      "code" : "24261000122100",
      "display" : "cardamomo"
    },
    {
      "code" : "24271000122105",
      "display" : "cardo"
    },
    {
      "code" : "294518000",
      "display" : "carfecilina"
    },
    {
      "code" : "294235002",
      "display" : "carisoprodol"
    },
    {
      "code" : "294339006",
      "display" : "carmelosa"
    },
    {
      "code" : "293755005",
      "display" : "carmustina"
    },
    {
      "code" : "703931001",
      "display" : "carne"
    },
    {
      "code" : "17801000122104",
      "display" : "carne de bovino"
    },
    {
      "code" : "22941000122104",
      "display" : "carne de caballo"
    },
    {
      "code" : "417918006",
      "display" : "carne de cerdo"
    },
    {
      "code" : "17791000122100",
      "display" : "carne de conejo"
    },
    {
      "code" : "15861000122109",
      "display" : "carne de cordero"
    },
    {
      "code" : "23001000122107",
      "display" : "carne de pavo"
    },
    {
      "code" : "23411000122104",
      "display" : "carne de ternera"
    },
    {
      "code" : "703930000",
      "display" : "carne vacuna"
    },
    {
      "code" : "23771000122101",
      "display" : "carpa"
    },
    {
      "code" : "293974008",
      "display" : "carvedilol"
    },
    {
      "code" : "293685007",
      "display" : "cáscara sagrada"
    },
    {
      "code" : "232347008",
      "display" : "caspa de animal"
    },
    {
      "code" : "188336009",
      "display" : "caspa de animales de laboratorio"
    },
    {
      "code" : "703928002",
      "display" : "caspa de cobayo"
    },
    {
      "code" : "419271008",
      "display" : "caspa de perro"
    },
    {
      "code" : "703935005",
      "display" : "caspa de vaca"
    },
    {
      "code" : "2541000122103",
      "display" : "castańas"
    },
    {
      "code" : "419412007",
      "display" : "caucho"
    },
    {
      "code" : "25061000122107",
      "display" : "cebo de pesca"
    },
    {
      "code" : "23101000122106",
      "display" : "cebolla"
    },
    {
      "code" : "294534002",
      "display" : "cefadroxilo"
    },
    {
      "code" : "294532003",
      "display" : "cefalosporina"
    },
    {
      "code" : "294540009",
      "display" : "cefalosporina de segunda generación"
    },
    {
      "code" : "294555000",
      "display" : "cefalosporinas de cuarta generación"
    },
    {
      "code" : "294533008",
      "display" : "cefalosporinas de primera generación"
    },
    {
      "code" : "294536000",
      "display" : "cefalotina"
    },
    {
      "code" : "294557008",
      "display" : "cefamicina"
    },
    {
      "code" : "294537009",
      "display" : "cefazolina"
    },
    {
      "code" : "19511000122106",
      "display" : "cefepima"
    },
    {
      "code" : "294549005",
      "display" : "cefodizima"
    },
    {
      "code" : "294545004",
      "display" : "cefotaxima"
    },
    {
      "code" : "294558003",
      "display" : "cefoxitina"
    },
    {
      "code" : "294556004",
      "display" : "cefpiroma"
    },
    {
      "code" : "294538004",
      "display" : "cefradina"
    },
    {
      "code" : "294554001",
      "display" : "cefsulodina"
    },
    {
      "code" : "294552002",
      "display" : "ceftibuteno"
    },
    {
      "code" : "294551009",
      "display" : "ceftriaxona"
    },
    {
      "code" : "294542001",
      "display" : "cefuroxima"
    },
    {
      "code" : "860931009",
      "display" : "celulosa y derivado de celulosa"
    },
    {
      "code" : "418184004",
      "display" : "centeno"
    },
    {
      "code" : "21121000122104",
      "display" : "cereal con gluten"
    },
    {
      "code" : "418051002",
      "display" : "cereza"
    },
    {
      "code" : "718534009",
      "display" : "cerivastatina"
    },
    {
      "code" : "24721000122100",
      "display" : "cerveza"
    },
    {
      "code" : "294116005",
      "display" : "cetirizina"
    },
    {
      "code" : "788802000",
      "display" : "cetuximab"
    },
    {
      "code" : "1306844002",
      "display" : "cetuximab debida a síndrome de alfa-galactosidasa"
    },
    {
      "code" : "25091000122101",
      "display" : "chinche del grano"
    },
    {
      "code" : "23221000122106",
      "display" : "chirimoya"
    },
    {
      "code" : "300912001",
      "display" : "chocolate"
    },
    {
      "code" : "23071000122103",
      "display" : "chufa"
    },
    {
      "code" : "294507000",
      "display" : "ciclacilina"
    },
    {
      "code" : "295095003",
      "display" : "ciclandelato"
    },
    {
      "code" : "294122001",
      "display" : "ciclizina"
    },
    {
      "code" : "293882007",
      "display" : "ciclobarbital"
    },
    {
      "code" : "293748008",
      "display" : "ciclofosfamida"
    },
    {
      "code" : "294079006",
      "display" : "ciclopentolato"
    },
    {
      "code" : "294610003",
      "display" : "cicloserina"
    },
    {
      "code" : "24281000122108",
      "display" : "cilantro"
    },
    {
      "code" : "35161000122109",
      "display" : "cilazapril"
    },
    {
      "code" : "294773004",
      "display" : "andrógeno"
    },
    {
      "code" : "24971000122102",
      "display" : "anémona del mejillón"
    },
    {
      "code" : "418434002",
      "display" : "anestésico"
    },
    {
      "code" : "293713001",
      "display" : "anestésico: éter"
    },
    {
      "code" : "293711004",
      "display" : "anestésicos inhalatorios"
    },
    {
      "code" : "293705002",
      "display" : "anestésicos intravenosos"
    },
    {
      "code" : "293805007",
      "display" : "anfepramona"
    },
    {
      "code" : "293957008",
      "display" : "anfetamina y derivado de anfetamina"
    },
    {
      "code" : "24531000122105",
      "display" : "anguila"
    },
    {
      "code" : "24441000122103",
      "display" : "anís"
    },
    {
      "code" : "23431000122108",
      "display" : "anisakis"
    },
    {
      "code" : "295111009",
      "display" : "anistreplasa"
    },
    {
      "code" : "293985005",
      "display" : "antagonista de receptor adrenérgico alfa"
    },
    {
      "code" : "293963004",
      "display" : "antagonista de receptor adrenérgico beta-1"
    },
    {
      "code" : "293962009",
      "display" : "antagonista de receptor beta adrenérgico"
    },
    {
      "code" : "293676007",
      "display" : "antagonista de receptor de 5-hidroxitriptamina-3"
    },
    {
      "code" : "295007000",
      "display" : "antagonista de receptor de aldosterona"
    },
    {
      "code" : "35021000122101",
      "display" : "antagonista de receptor de angiotensina II"
    },
    {
      "code" : "294270000",
      "display" : "antagonista de receptor de benzodiazepina"
    },
    {
      "code" : "294109009",
      "display" : "antagonista de receptor de histamina H1"
    },
    {
      "code" : "293649007",
      "display" : "antagonista de receptor de histamina H2"
    },
    {
      "code" : "293788003",
      "display" : "antagonista de receptor estrogénico"
    },
    {
      "code" : "294275005",
      "display" : "antagonista de receptor opioide"
    },
    {
      "code" : "294125004",
      "display" : "antazolina"
    },
    {
      "code" : "294766009",
      "display" : "antiandrógenos"
    },
    {
      "code" : "109991000119100",
      "display" : "antibiótico"
    },
    {
      "code" : "294608000",
      "display" : "antibiótico antituberculoso"
    },
    {
      "code" : "293759004",
      "display" : "antibiótico citotóxico"
    },
    {
      "code" : "429239002",
      "display" : "antibiótico sulfonamídico"
    },
    {
      "code" : "91933002",
      "display" : "antibióticos macrólidos"
    },
    {
      "code" : "294879005",
      "display" : "anticoagulante cumarínico"
    },
    {
      "code" : "294870009",
      "display" : "anticoagulante de acción directa"
    },
    {
      "code" : "294882000",
      "display" : "anticoagulante derivado de la indanodiona"
    },
    {
      "code" : "294772009",
      "display" : "anticonceptivo oral combinado"
    },
    {
      "code" : "294636005",
      "display" : "anticuerpo de grupo sanguíneo D"
    },
    {
      "code" : "293852001",
      "display" : "antidepresivo tetracíclico"
    },
    {
      "code" : "293821002",
      "display" : "antidepresivo tricíclico"
    },
    {
      "code" : "293841007",
      "display" : "antidepresivos compuestos"
    },
    {
      "code" : "294274009",
      "display" : "antídoto de quemadura de ácido fluorhídrico"
    },
    {
      "code" : "294279004",
      "display" : "antídotos contra plaguicidas"
    },
    {
      "code" : "293863003",
      "display" : "antiepiléptico barbitúrico"
    },
    {
      "code" : "294457006",
      "display" : "antihelmíntico con benzimidazol"
    },
    {
      "code" : "294352001",
      "display" : "antimicótico del grupo azol"
    },
    {
      "code" : "294355004",
      "display" : "antimicótico del grupo imidazol"
    },
    {
      "code" : "293757002",
      "display" : "antineoplásico a base de triazeno"
    },
    {
      "code" : "294599009",
      "display" : "antiprotozoario de diamidina"
    },
    {
      "code" : "294603009",
      "display" : "antiprotozoario de hidroxiquinolina"
    },
    {
      "code" : "294666003",
      "display" : "antisuero"
    },
    {
      "code" : "294668002",
      "display" : "antitoxina botulínica"
    },
    {
      "code" : "294669005",
      "display" : "antitoxina diftérica"
    },
    {
      "code" : "22461000122108",
      "display" : "antitoxina tetánica"
    },
    {
      "code" : "21921000122101",
      "display" : "antitripsina alfa 1"
    },
    {
      "code" : "294149001",
      "display" : "antitusígeno morfínico"
    },
    {
      "code" : "294146008",
      "display" : "antitusivo/descongestivo"
    },
    {
      "code" : "712843002",
      "display" : "apio"
    },
    {
      "code" : "76471000122103",
      "display" : "apixabán"
    },
    {
      "code" : "294057001",
      "display" : "apraclonidina"
    },
    {
      "code" : "17821000122107",
      "display" : "aprepitant"
    },
    {
      "code" : "24201000122101",
      "display" : "arándano"
    },
    {
      "code" : "23631000122106",
      "display" : "arenque"
    },
    {
      "code" : "6601000122100",
      "display" : "arroz"
    },
    {
      "code" : "294188004",
      "display" : "aserbina"
    },
    {
      "code" : "294111000",
      "display" : "astemizol"
    },
    {
      "code" : "293965006",
      "display" : "atenolol"
    },
    {
      "code" : "13221000122100",
      "display" : "atorvastatina"
    },
    {
      "code" : "294228005",
      "display" : "atracurio"
    },
    {
      "code" : "294076004",
      "display" : "atropina"
    },
    {
      "code" : "294240005",
      "display" : "auranofina"
    },
    {
      "code" : "712840004",
      "display" : "avellana"
    },
    {
      "code" : "419342009",
      "display" : "avena"
    },
    {
      "code" : "293612001",
      "display" : "azapropazona"
    },
    {
      "code" : "294127007",
      "display" : "azatadina"
    },
    {
      "code" : "294115009",
      "display" : "azelastina"
    },
    {
      "code" : "35071000122100",
      "display" : "azilsartán medoxomilo"
    },
    {
      "code" : "294516001",
      "display" : "azlocilina"
    },
    {
      "code" : "294445002",
      "display" : "azo desinfectante colorante acridina"
    },
    {
      "code" : "76201000122106",
      "display" : "azorrubina S"
    },
    {
      "code" : "21891000122105",
      "display" : "3,4-diaminopiridina"
    },
    {
      "code" : "294483001",
      "display" : "4-quinolonas"
    },
    {
      "code" : "713707006",
      "display" : "abacavir"
    },
    {
      "code" : "20091000122108",
      "display" : "acamprosato"
    },
    {
      "code" : "294742003",
      "display" : "acarbosa"
    },
    {
      "code" : "24841000122100",
      "display" : "ácaro Acarus siro"
    },
    {
      "code" : "24511000122101",
      "display" : "ácaro Blomia tropicalis"
    },
    {
      "code" : "24861000122101",
      "display" : "ácaro Chortoglyphus"
    },
    {
      "code" : "24871000122106",
      "display" : "ácaro Gohieria fusca"
    },
    {
      "code" : "24881000122109",
      "display" : "ácaro Lepidoglyphus"
    },
    {
      "code" : "24891000122107",
      "display" : "ácaro Tyrophagus putrescentiae"
    },
    {
      "code" : "23521000122109",
      "display" : "ácaros de almacenamiento"
    },
    {
      "code" : "232350006",
      "display" : "ácaros del polvo doméstico"
    },
    {
      "code" : "293964005",
      "display" : "acebutolol"
    },
    {
      "code" : "22881000122103",
      "display" : "aceclofenaco"
    },
    {
      "code" : "418606003",
      "display" : "aceite de almendras"
    },
    {
      "code" : "294317009",
      "display" : "aceite de cacahuete"
    },
    {
      "code" : "419814004",
      "display" : "aceite de coco"
    },
    {
      "code" : "293690005",
      "display" : "aceite de menta"
    },
    {
      "code" : "294316000",
      "display" : "aceite de oliva"
    },
    {
      "code" : "294968004",
      "display" : "aceite de pescado"
    },
    {
      "code" : "294318004",
      "display" : "aceite de ricino"
    },
    {
      "code" : "294315001",
      "display" : "aceite fijo"
    },
    {
      "code" : "23081000122100",
      "display" : "acelga"
    },
    {
      "code" : "293611008",
      "display" : "acemetacina"
    },
    {
      "code" : "294880008",
      "display" : "acenocumarol"
    },
    {
      "code" : "294770001",
      "display" : "acetato de ciproterona y a etinilestradiol"
    },
    {
      "code" : "295030006",
      "display" : "acetazolamida"
    },
    {
      "code" : "294097003",
      "display" : "acetilcisteína"
    },
    {
      "code" : "294729003",
      "display" : "acetohexamida"
    },
    {
      "code" : "294404005",
      "display" : "ácido acético"
    },
    {
      "code" : "293586001",
      "display" : "ácido acetilsalicílico"
    },
    {
      "code" : "20221000122104",
      "display" : "ácido aminolevulínico"
    },
    {
      "code" : "35321000122103",
      "display" : "ácido arilacético"
    },
    {
      "code" : "294940003",
      "display" : "ácido ascórbico"
    },
    {
      "code" : "294180006",
      "display" : "ácido azelaico"
    },
    {
      "code" : "294434000",
      "display" : "ácido bórico"
    },
    {
      "code" : "17631000122106",
      "display" : "ácido clavulánico"
    },
    {
      "code" : "767203005",
      "display" : "ácido cromoglícico"
    },
    {
      "code" : "293700007",
      "display" : "ácido dehidrocólico"
    },
    {
      "code" : "20461000122109",
      "display" : "ácido espaglúmico"
    },
    {
      "code" : "773499003",
      "display" : "ácido etidrónico"
    },
    {
      "code" : "860927003",
      "display" : "ácido fíbrico y derivado de ácido fíbrico"
    },
    {
      "code" : "294931002",
      "display" : "ácido folínico"
    },
    {
      "code" : "294482006",
      "display" : "ácido fusídico"
    },
    {
      "code" : "294969007",
      "display" : "ácido graso omega 3 derivado de pescado"
    },
    {
      "code" : "17621000122108",
      "display" : "ácido ibandrónico"
    },
    {
      "code" : "293623002",
      "display" : "ácido mefenámico"
    },
    {
      "code" : "19721000122107",
      "display" : "ácido micofenólico"
    },
    {
      "code" : "294929006",
      "display" : "ácido nicotínico"
    },
    {
      "code" : "773491000",
      "display" : "ácido pamidrónico"
    },
    {
      "code" : "20481000122101",
      "display" : "ácido paraaminosalicílico"
    },
    {
      "code" : "830176003",
      "display" : "ácido permangánico"
    },
    {
      "code" : "293699006",
      "display" : "ácido quenodeoxicólico"
    },
    {
      "code" : "767474001",
      "display" : "ácido salicílico"
    },
    {
      "code" : "294201000",
      "display" : "ácido salicílico tópico"
    },
    {
      "code" : "293632000",
      "display" : "ácido tiaprofénico"
    },
    {
      "code" : "294887006",
      "display" : "ácido tranexámico"
    },
    {
      "code" : "293701006",
      "display" : "ácido ursodeoxicólico"
    },
    {
      "code" : "737144005",
      "display" : "ácido zoledrónico"
    },
    {
      "code" : "293702004",
      "display" : "ácidos quenodesoxicólico y ursodesoxicólico"
    },
    {
      "code" : "294209003",
      "display" : "acitretina"
    },
    {
      "code" : "293764000",
      "display" : "aclarubicina"
    },
    {
      "code" : "1025251000122100",
      "display" : "adalimumab"
    },
    {
      "code" : "417930000",
      "display" : "adhesivo"
    },
    {
      "code" : "294189007",
      "display" : "adhesivo tisular de uso quirúrgico"
    },
    {
      "code" : "16067171000119100",
      "display" : "aditivo alimentario"
    },
    {
      "code" : "295084009",
      "display" : "aerosol de trinitrato de glicerilo"
    },
    {
      "code" : "294202007",
      "display" : "agente abrasivo tópico"
    },
    {
      "code" : "293740001",
      "display" : "agente alquilante"
    },
    {
      "code" : "294605002",
      "display" : "agente antimicobacteriano"
    },
    {
      "code" : "18211000122104",
      "display" : "agente antimigrańoso"
    },
    {
      "code" : "294673008",
      "display" : "agente antitiroideo derivado de la tiourea"
    },
    {
      "code" : "294675001",
      "display" : "agente antitiroideo derivado de tiouracilo"
    },
    {
      "code" : "293698003",
      "display" : "agente biliar"
    },
    {
      "code" : "402591008",
      "display" : "agente biocida"
    },
    {
      "code" : "295032003",
      "display" : "agente bloqueante adrenérgico de los receptores neuronales"
    },
    {
      "code" : "293634004",
      "display" : "agente diagnóstico"
    },
    {
      "code" : "36071000122108",
      "display" : "agente hipolipemiante"
    },
    {
      "code" : "293961002",
      "display" : "grupos de fármacos que afectan principalmente al sistema nervioso autónomo"
    },
    {
      "code" : "295035001",
      "display" : "guanetidina"
    },
    {
      "code" : "23811000122101",
      "display" : "guayaba"
    },
    {
      "code" : "23621000122108",
      "display" : "guisante"
    },
    {
      "code" : "24741000122105",
      "display" : "gusano de la harina"
    },
    {
      "code" : "24351000122106",
      "display" : "haba"
    },
    {
      "code" : "294690002",
      "display" : "halcinonida"
    },
    {
      "code" : "294399008",
      "display" : "halofantrina"
    },
    {
      "code" : "293924006",
      "display" : "haloperidol"
    },
    {
      "code" : "293714007",
      "display" : "halotano"
    },
    {
      "code" : "18131000122104",
      "display" : "hamamelis"
    },
    {
      "code" : "33261000122100",
      "display" : "harina de almorta"
    },
    {
      "code" : "6621000122108",
      "display" : "harina de centeno"
    },
    {
      "code" : "6581000122108",
      "display" : "harina de trigo"
    },
    {
      "code" : "20411000122106",
      "display" : "harpagofito"
    },
    {
      "code" : "294853001",
      "display" : "hemoderivado"
    },
    {
      "code" : "294872001",
      "display" : "heparina"
    },
    {
      "code" : "294876003",
      "display" : "heparinoide"
    },
    {
      "code" : "19951000122102",
      "display" : "heptaminol y sus derivados"
    },
    {
      "code" : "23021000122104",
      "display" : "heroína"
    },
    {
      "code" : "294416004",
      "display" : "hexaclorofeno"
    },
    {
      "code" : "294407003",
      "display" : "hexetidina"
    },
    {
      "code" : "294297007",
      "display" : "hialuronato de sodio"
    },
    {
      "code" : "295114001",
      "display" : "hialuronidasa"
    },
    {
      "code" : "19921000122109",
      "display" : "hidantoína y sus derivados"
    },
    {
      "code" : "295075009",
      "display" : "hidralazina"
    },
    {
      "code" : "294405006",
      "display" : "hidrargafeno"
    },
    {
      "code" : "293908005",
      "display" : "hidrato de cloral"
    },
    {
      "code" : "294995009",
      "display" : "hidroclorotiazida"
    },
    {
      "code" : "294680005",
      "display" : "hidrocortisona tópica"
    },
    {
      "code" : "294996005",
      "display" : "hidroflumetiazida"
    },
    {
      "code" : "21871000122109",
      "display" : "hidroxianisol butilado"
    },
    {
      "code" : "294393009",
      "display" : "hidroxicloroquina"
    },
    {
      "code" : "17811000122101",
      "display" : "hidroxietilalmidón"
    },
    {
      "code" : "294337008",
      "display" : "hidroxietilcelulosa"
    },
    {
      "code" : "293781009",
      "display" : "hidroxiurea"
    },
    {
      "code" : "294135005",
      "display" : "hidroxizina"
    },
    {
      "code" : "294295004",
      "display" : "hierbas medicinales"
    },
    {
      "code" : "294891001",
      "display" : "hierro"
    },
    {
      "code" : "294892008",
      "display" : "hierro y a ácido fólico"
    },
    {
      "code" : "23321000122101",
      "display" : "higo"
    },
    {
      "code" : "294074001",
      "display" : "hioscina"
    },
    {
      "code" : "21626009",
      "display" : "hipersensibilidad cutánea"
    },
    {
      "code" : "294335000",
      "display" : "hipromelosa"
    },
    {
      "code" : "294479001",
      "display" : "hipurato de hexamina"
    },
    {
      "code" : "16811000122104",
      "display" : "hirudina"
    },
    {
      "code" : "703934009",
      "display" : "hongo"
    },
    {
      "code" : "447961002",
      "display" : "hongo alimenticio"
    },
    {
      "code" : "294806004",
      "display" : "hormona antidiurética"
    },
    {
      "code" : "767015000",
      "display" : "hormona hipofisaria"
    },
    {
      "code" : "767014001",
      "display" : "hormona hipotalámica"
    },
    {
      "code" : "294805000",
      "display" : "hormona hipotalámica/hipofisaria"
    },
    {
      "code" : "294814005",
      "display" : "hormona reguladora de las gónadas"
    },
    {
      "code" : "294828004",
      "display" : "hormona tirotrófica"
    },
    {
      "code" : "294744002",
      "display" : "hormonas sexuales"
    },
    {
      "code" : "294670006",
      "display" : "hormonas, sustitutos sintéticos y antagonistas"
    },
    {
      "code" : "21841000122103",
      "display" : "humo"
    },
    {
      "code" : "18441000122104",
      "display" : "icatibant"
    },
    {
      "code" : "294177005",
      "display" : "ictamol"
    },
    {
      "code" : "294385009",
      "display" : "idoxuridina"
    },
    {
      "code" : "294386005",
      "display" : "idoxuridina en dimetilsulfóxido"
    },
    {
      "code" : "35231000122106",
      "display" : "imidapril"
    },
    {
      "code" : "442408006",
      "display" : "imipenem"
    },
    {
      "code" : "293833007",
      "display" : "imipramina"
    },
    {
      "code" : "294777003",
      "display" : "implante de testosterona"
    },
    {
      "code" : "295024006",
      "display" : "indapamida"
    },
    {
      "code" : "293988007",
      "display" : "indoramina"
    },
    {
      "code" : "294970008",
      "display" : "inhibidor de 3-hidroxi-3-metilglutaril coenzima A reductasa"
    },
    {
      "code" : "830277004",
      "display" : "inhibidor de aldehído deshidrogenasa"
    },
    {
      "code" : "762453008",
      "display" : "inhibidor de alfa glucosidasa"
    },
    {
      "code" : "293654003",
      "display" : "inhibidor de ATPasa de intercambio de H+/K+"
    },
    {
      "code" : "35081000122102",
      "display" : "inhibidor de enzima convertidora de angiotensina"
    },
    {
      "code" : "448690007",
      "display" : "inhibidor de fosfodiesterasa 5"
    },
    {
      "code" : "295028009",
      "display" : "inhibidor de la anhidrasa carbónica"
    },
    {
      "code" : "293951009",
      "display" : "inhibidor de la descarboxilasa"
    },
    {
      "code" : "18031000122100",
      "display" : "inhibidor de la dipeptidil peptidasa IV"
    },
    {
      "code" : "293835000",
      "display" : "inhibidor de monoaminooxidasa"
    },
    {
      "code" : "713296005",
      "display" : "inhibidor de proteasa retroviral"
    },
    {
      "code" : "713276002",
      "display" : "inhibidor de transcriptasa inversa"
    },
    {
      "code" : "294219009",
      "display" : "inhibidor de xantina oxidasa"
    },
    {
      "code" : "37371000122109",
      "display" : "inhibidor enzimático"
    },
    {
      "code" : "293844004",
      "display" : "inhibidor selectivo de la recaptación de serotonina"
    },
    {
      "code" : "293730004",
      "display" : "inmunoestimulante"
    },
    {
      "code" : "830260004",
      "display" : "inmunoglobulina"
    },
    {
      "code" : "22411000122105",
      "display" : "inmunoglobulina anti-citomegalovirus"
    },
    {
      "code" : "22361000122104",
      "display" : "inmunoglobulina antilinfocítica"
    },
    {
      "code" : "782558006",
      "display" : "inmunoglobulina contra antígeno de superficie de hepatitis B"
    },
    {
      "code" : "294638006",
      "display" : "inmunoglobulina contra el tétanos"
    },
    {
      "code" : "294637001",
      "display" : "inmunoglobulina contra la hepatitis B"
    },
    {
      "code" : "294639003",
      "display" : "inmunoglobulina contra virus varicela zóster"
    },
    {
      "code" : "22201000122106",
      "display" : "inmunoglobulina frente a la hepatitis A"
    },
    {
      "code" : "22291000122101",
      "display" : "inmunoglobulina frente a la parotiditis urliana"
    },
    {
      "code" : "22221000122103",
      "display" : "inmunoglobulina frente a la rubéola"
    },
    {
      "code" : "22171000122107",
      "display" : "inmunoglobulina frente a la tos ferina"
    },
    {
      "code" : "22451000122106",
      "display" : "inmunoglobulina frente a virus respiratorio sincitial"
    },
    {
      "code" : "22441000122109",
      "display" : "inmunoglobulina frente al virus del sarampión"
    },
    {
      "code" : "294633002",
      "display" : "inmunoglobulina humana"
    },
    {
      "code" : "1222889008",
      "display" : "inmunoglobulina humana anti-D"
    },
    {
      "code" : "22331000122106",
      "display" : "inmunoglobulina humana anti-vaccinia"
    },
    {
      "code" : "22301000122100",
      "display" : "inmunoglobulina humana frente a la encefalitis por virus transmitido por garrapatas"
    },
    {
      "code" : "22311000122102",
      "display" : "inmunoglobulina humana frente a la rabia"
    },
    {
      "code" : "294634008",
      "display" : "inmunoglobulina intramuscular"
    },
    {
      "code" : "294635009",
      "display" : "inmunoglobulina intravenosa"
    },
    {
      "code" : "13601000122106",
      "display" : "inmunosupresor macrólido"
    },
    {
      "code" : "294368007",
      "display" : "inosina pranobex"
    },
    {
      "code" : "294937003",
      "display" : "inositol"
    },
    {
      "code" : "294714000",
      "display" : "insulina"
    },
    {
      "code" : "294716003",
      "display" : "insulina bifásica"
    },
    {
      "code" : "294717007",
      "display" : "insulina en suspensión de cinc"
    },
    {
      "code" : "294723002",
      "display" : "insulina humana"
    },
    {
      "code" : "294720004",
      "display" : "insulina isófana"
    },
    {
      "code" : "294715004",
      "display" : "insulina neutra soluble"
    },
    {
      "code" : "294375008",
      "display" : "interferón"
    },
    {
      "code" : "294378005",
      "display" : "interferón alfa-2b"
    },
    {
      "code" : "294379002",
      "display" : "interferón alfa-n1"
    },
    {
      "code" : "267425008",
      "display" : "intolerancia a la lactosa"
    },
    {
      "code" : "1025081000122100",
      "display" : "ioflupano"
    },
    {
      "code" : "294264006",
      "display" : "ipecacuana"
    },
    {
      "code" : "294082001",
      "display" : "ipratropio"
    },
    {
      "code" : "293837008",
      "display" : "iproniazida"
    },
    {
      "code" : "19911000122103",
      "display" : "irinotecán"
    },
    {
      "code" : "294428007",
      "display" : "isetionato de propamidina"
    },
    {
      "code" : "294148009",
      "display" : "isoaminilo"
    },
    {
      "code" : "294360000",
      "display" : "isoconazol"
    },
    {
      "code" : "830169008",
      "display" : "isoetarina"
    },
    {
      "code" : "294614007",
      "display" : "isoniazida"
    },
    {
      "code" : "294050004",
      "display" : "isoprenalina"
    },
    {
      "code" : "294051000",
      "display" : "isoprenalina administrada por vía oral"
    },
    {
      "code" : "294053002",
      "display" : "isoprenalina administrada por vía parenteral"
    },
    {
      "code" : "20151000122100",
      "display" : "isotipendilo"
    },
    {
      "code" : "295098001",
      "display" : "isoxsuprina"
    },
    {
      "code" : "293998001",
      "display" : "isradipino"
    },
    {
      "code" : "76441000122109",
      "display" : "ivabradina"
    },
    {
      "code" : "24071000122101",
      "display" : "jengibre"
    },
    {
      "code" : "18471000122105",
      "display" : "josamicina"
    },
    {
      "code" : "294464008",
      "display" : "kanamicina"
    },
    {
      "code" : "293707005",
      "display" : "ketamina"
    },
    {
      "code" : "294362008",
      "display" : "ketoconazol"
    },
    {
      "code" : "293621000",
      "display" : "ketoprofeno"
    },
    {
      "code" : "294144006",
      "display" : "ketotifeno"
    },
    {
      "code" : "294912008",
      "display" : "l-carnitina"
    },
    {
      "code" : "293977001",
      "display" : "labetalol"
    },
    {
      "code" : "830170009",
      "display" : "lachesina"
    },
    {
      "code" : "76381000122107",
      "display" : "lacosamida"
    },
    {
      "code" : "5621000122101",
      "display" : "lactosa"
    },
    {
      "code" : "293859005",
      "display" : "lamotrigina"
    },
    {
      "code" : "425605001",
      "display" : "lana"
    },
    {
      "code" : "418626004",
      "display" : "langosta"
    },
    {
      "code" : "293656001",
      "display" : "lansoprazol"
    },
    {
      "code" : "32451000122109",
      "display" : "lapatinib"
    },
    {
      "code" : "300916003",
      "display" : "látex"
    },
    {
      "code" : "24051000122109",
      "display" : "laurel"
    },
    {
      "code" : "293683000",
      "display" : "laxante formador de masa"
    },
    {
      "code" : "21171000122103",
      "display" : "leche de cabra"
    },
    {
      "code" : "25868003",
      "display" : "leche de soja"
    },
    {
      "code" : "15911003",
      "display" : "leche de vaca"
    },
    {
      "code" : "76351000122101",
      "display" : "cinacalcet"
    },
    {
      "code" : "294130000",
      "display" : "cinarizina"
    },
    {
      "code" : "294950002",
      "display" : "cinc"
    },
    {
      "code" : "830080006",
      "display" : "cinc y compuesto de cinc"
    },
    {
      "code" : "293720008",
      "display" : "cincocaína"
    },
    {
      "code" : "76371000122109",
      "display" : "cinitaprida"
    },
    {
      "code" : "294485008",
      "display" : "cinoxacino"
    },
    {
      "code" : "294967009",
      "display" : "ciprofibrato"
    },
    {
      "code" : "294487000",
      "display" : "ciprofloxacino"
    },
    {
      "code" : "294131001",
      "display" : "ciproheptadina"
    },
    {
      "code" : "294771002",
      "display" : "ciproterona"
    },
    {
      "code" : "871500003",
      "display" : "ciproterona y/o etinilestradiol"
    },
    {
      "code" : "23231000122109",
      "display" : "ciruela"
    },
    {
      "code" : "293671002",
      "display" : "cisaprida"
    },
    {
      "code" : "448438007",
      "display" : "cisatracurio"
    },
    {
      "code" : "293780005",
      "display" : "cisplatino"
    },
    {
      "code" : "293849009",
      "display" : "citalopram"
    },
    {
      "code" : "293775001",
      "display" : "citarabina"
    },
    {
      "code" : "76301000122100",
      "display" : "citicolina"
    },
    {
      "code" : "293819007",
      "display" : "citrato de litio"
    },
    {
      "code" : "294086003",
      "display" : "citrato de orfenadrina"
    },
    {
      "code" : "12871000122105",
      "display" : "clara de huevo"
    },
    {
      "code" : "294471003",
      "display" : "claritromicina"
    },
    {
      "code" : "24301000122107",
      "display" : "clavo"
    },
    {
      "code" : "1025191000122100",
      "display" : "cleboprida"
    },
    {
      "code" : "294118006",
      "display" : "clemastina"
    },
    {
      "code" : "36981000122105",
      "display" : "clevidipino"
    },
    {
      "code" : "294561002",
      "display" : "clindamicina"
    },
    {
      "code" : "294604003",
      "display" : "clioquinol"
    },
    {
      "code" : "294693000",
      "display" : "clobetasol"
    },
    {
      "code" : "294694006",
      "display" : "clobetasona"
    },
    {
      "code" : "294618005",
      "display" : "clofazimina"
    },
    {
      "code" : "294965001",
      "display" : "clofibrato"
    },
    {
      "code" : "293830005",
      "display" : "clomipramina"
    },
    {
      "code" : "294584009",
      "display" : "clomociclina"
    },
    {
      "code" : "294058006",
      "display" : "clonidina"
    },
    {
      "code" : "13671000122102",
      "display" : "clopidogrel"
    },
    {
      "code" : "293747003",
      "display" : "clorambucilo"
    },
    {
      "code" : "830167005",
      "display" : "clorazepato"
    },
    {
      "code" : "293896001",
      "display" : "clorazepato de potasio"
    },
    {
      "code" : "294129005",
      "display" : "clorfenamina"
    },
    {
      "code" : "294431008",
      "display" : "clorhexidina"
    },
    {
      "code" : "294094005",
      "display" : "clorhidrato de bromhexina"
    },
    {
      "code" : "294432001",
      "display" : "clorhidrato de clorhexidina y a sulfato de neomicina"
    },
    {
      "code" : "294022004",
      "display" : "clorhidrato de fenilpropanolamina"
    },
    {
      "code" : "294124000",
      "display" : "clorhidrato de meclozina"
    },
    {
      "code" : "294085004",
      "display" : "clorhidrato de orfenadrina"
    },
    {
      "code" : "36821000122104",
      "display" : "clorhidrato de procaína"
    },
    {
      "code" : "294071009",
      "display" : "clorhidrato de terodilina"
    },
    {
      "code" : "293912004",
      "display" : "clormetiazol"
    },
    {
      "code" : "293876009",
      "display" : "clormezanona"
    },
    {
      "code" : "21771000122102",
      "display" : "clorobutanol"
    },
    {
      "code" : "294394003",
      "display" : "cloroquina"
    },
    {
      "code" : "294415000",
      "display" : "cloroxilenol"
    },
    {
      "code" : "293935001",
      "display" : "clorpromazina"
    },
    {
      "code" : "293943006",
      "display" : "clorprotixeno"
    },
    {
      "code" : "295023000",
      "display" : "clortalidona"
    },
    {
      "code" : "294008004",
      "display" : "cloruro de acetilcolina"
    },
    {
      "code" : "294072002",
      "display" : "cloruro de laquesina"
    },
    {
      "code" : "294356003",
      "display" : "clotrimazol"
    },
    {
      "code" : "294501004",
      "display" : "cloxacilina"
    },
    {
      "code" : "293809001",
      "display" : "co-beneldopa"
    },
    {
      "code" : "293810006",
      "display" : "co-careldopa"
    },
    {
      "code" : "16771000122104",
      "display" : "cobalaminas"
    },
    {
      "code" : "19541000122105",
      "display" : "cobalto"
    },
    {
      "code" : "293723005",
      "display" : "cocaína"
    },
    {
      "code" : "23301000122109",
      "display" : "coco"
    },
    {
      "code" : "293597001",
      "display" : "codeína"
    },
    {
      "code" : "294888001",
      "display" : "colágeno"
    },
    {
      "code" : "294215003",
      "display" : "colchicina"
    },
    {
      "code" : "294962003",
      "display" : "colestiramina"
    },
    {
      "code" : "294106002",
      "display" : "colfoscerilo"
    },
    {
      "code" : "294336004",
      "display" : "colirios con hipromelosa"
    },
    {
      "code" : "294191004",
      "display" : "colodión"
    },
    {
      "code" : "293641005",
      "display" : "colorante de uso diagnóstico"
    },
    {
      "code" : "294523000",
      "display" : "combinación amoxicilina + clavulanato de potasio"
    },
    {
      "code" : "24211000122103",
      "display" : "comino"
    },
    {
      "code" : "294865002",
      "display" : "complejo anti-inhibidor de la coagulación"
    },
    {
      "code" : "294181005",
      "display" : "complejos con bromo"
    },
    {
      "code" : "294641002",
      "display" : "componente de vacuna que contiene antígeno de Bacillus anthracis"
    },
    {
      "code" : "294658007",
      "display" : "componente de vacuna que contiene antígeno de Clostridium tetani"
    },
    {
      "code" : "294642009",
      "display" : "componente de vacuna que contiene antígeno de Corynebacterium diphtheriae"
    },
    {
      "code" : "294664000",
      "display" : "componente de vacuna que contiene antígeno de Haemophilus influenzae tipo B"
    },
    {
      "code" : "294655005",
      "display" : "componente de vacuna que contiene antígeno de Lyssavirus de la rabia"
    },
    {
      "code" : "860695004",
      "display" : "componente de vacuna que contiene antígeno de Neisseria meninigitidis"
    },
    {
      "code" : "294654009",
      "display" : "componente de vacuna que contiene antígeno de Poliovirus humano"
    },
    {
      "code" : "700468006",
      "display" : "componente de vacuna que contiene antígeno de Rotavirus"
    },
    {
      "code" : "294659004",
      "display" : "componente de vacuna que contiene antígeno de Salmonella enterica subespecie enterica serovariedad Typhi"
    },
    {
      "code" : "294652008",
      "display" : "componente de vacuna que contiene antígeno de Streptococcus pneumoniae"
    },
    {
      "code" : "294656006",
      "display" : "componente de vacuna que contiene antígeno de virus de la rubéola"
    },
    {
      "code" : "294663006",
      "display" : "componente de vacuna que contiene antígeno de virus Hepatitis A"
    },
    {
      "code" : "294646007",
      "display" : "componente de vacuna que contiene antígeno de virus Hepatitis B"
    },
    {
      "code" : "294647003",
      "display" : "componente de vacuna que contiene antígeno de virus Influenza"
    },
    {
      "code" : "294657002",
      "display" : "componente de vacuna que contiene antígeno de virus Vaccinia"
    },
    {
      "code" : "294645006",
      "display" : "componente de vacuna que contiene antígenos de Bordetella pertussis, Clostridium tetani y Corynebacterium diphtheriae"
    },
    {
      "code" : "294644005",
      "display" : "componente de vacuna que contiene antígenos de Clostridium tetani y Corynebacterium diphtheriae"
    },
    {
      "code" : "1025031000122100",
      "display" : "compuesto de dibenzoxazepina"
    },
    {
      "code" : "294913003",
      "display" : "compuesto de yodo"
    },
    {
      "code" : "782563005",
      "display" : "compuesto que contiene litio"
    },
    {
      "code" : "294412002",
      "display" : "compuestos fenólicos"
    },
    {
      "code" : "24911000122109",
      "display" : "conalbúmina"
    },
    {
      "code" : "294863009",
      "display" : "concentrados de factor V"
    },
    {
      "code" : "294864003",
      "display" : "concentrados de factor VII"
    },
    {
      "code" : "21191000122102",
      "display" : "condimento de mostaza"
    },
    {
      "code" : "24311000122105",
      "display" : "congrio"
    },
    {
      "code" : "609547000",
      "display" : "conservante alimentario a base de sulfito"
    },
    {
      "code" : "12841000122104",
      "display" : "conservante alimenticio"
    },
    {
      "code" : "294677009",
      "display" : "corticosteroide y derivado de corticosteroide"
    },
    {
      "code" : "294162002",
      "display" : "corticosteroides administrados por inhalación"
    },
    {
      "code" : "294811002",
      "display" : "corticotrofina"
    },
    {
      "code" : "294695007",
      "display" : "cortisona"
    },
    {
      "code" : "294165000",
      "display" : "cremas con urea"
    },
    {
      "code" : "293784001",
      "display" : "crisantaspasa"
    },
    {
      "code" : "294141003",
      "display" : "cromoglicato y fármacos antialérgicos relacionados"
    },
    {
      "code" : "294200004",
      "display" : "crotamitón"
    },
    {
      "code" : "24931000122100",
      "display" : "cucaracha Blatella germanica"
    },
    {
      "code" : "24941000122108",
      "display" : "cucaracha Blatella orientalis"
    },
    {
      "code" : "24921000122103",
      "display" : "cucarachas"
    },
    {
      "code" : "37441000122109",
      "display" : "curares"
    },
    {
      "code" : "24221000122109",
      "display" : "curry"
    },
    {
      "code" : "293758007",
      "display" : "dacarbazina"
    },
    {
      "code" : "293760009",
      "display" : "dactinomicina"
    },
    {
      "code" : "294874000",
      "display" : "dalteparina"
    },
    {
      "code" : "294764007",
      "display" : "danazol"
    },
    {
      "code" : "294237005",
      "display" : "dantroleno"
    },
    {
      "code" : "1208353007",
      "display" : "dapagliflozina"
    },
    {
      "code" : "294617000",
      "display" : "dapsona"
    },
    {
      "code" : "18001000122106",
      "display" : "dasabuvir"
    },
    {
      "code" : "23161000122107",
      "display" : "dátil"
    },
    {
      "code" : "295034002",
      "display" : "debrisoquina"
    },
    {
      "code" : "293944000",
      "display" : "decanoato de flupentixol"
    },
    {
      "code" : "293922005",
      "display" : "decanoato de haloperidol"
    },
    {
      "code" : "293945004",
      "display" : "decanoato de zuclopentixol"
    },
    {
      "code" : "294284005",
      "display" : "deferoxamina"
    },
    {
      "code" : "294012005",
      "display" : "demecario"
    },
    {
      "code" : "294591007",
      "display" : "demeclociclina"
    },
    {
      "code" : "36061000122103",
      "display" : "derivado de acetidina"
    },
    {
      "code" : "418737008",
      "display" : "derivado de la fenotiazina"
    },
    {
      "code" : "17641000122103",
      "display" : "derivado del nitrofurano"
    },
    {
      "code" : "36951000122104",
      "display" : "derivado fluoresceínico"
    },
    {
      "code" : "200843008",
      "display" : "dermatitis alérgica de contacto causada por cosmético"
    },
    {
      "code" : "860924005",
      "display" : "dermatitis alérgica por contacto causada por jabón metálico alcalino"
    },
    {
      "code" : "238573006",
      "display" : "dermatitis por contacto con perfume"
    },
    {
      "code" : "293717000",
      "display" : "desflurano"
    },
    {
      "code" : "294419006",
      "display" : "desinfectante alcohólico"
    },
    {
      "code" : "294427002",
      "display" : "desinfectante con amidina"
    },
    {
      "code" : "294430009",
      "display" : "desinfectante con biguanida"
    },
    {
      "code" : "293831009",
      "display" : "desipramina"
    },
    {
      "code" : "294807008",
      "display" : "desmopresina"
    },
    {
      "code" : "294685000",
      "display" : "desonida"
    },
    {
      "code" : "295113007",
      "display" : "desoxirribonucleasa"
    },
    {
      "code" : "294702008",
      "display" : "dexametasona"
    },
    {
      "code" : "294703003",
      "display" : "dexametasona tópica"
    },
    {
      "code" : "293958003",
      "display" : "dexanfetamina"
    },
    {
      "code" : "293804006",
      "display" : "dexfenfluramina"
    },
    {
      "code" : "1025181000122100",
      "display" : "dexibuprofeno"
    },
    {
      "code" : "21251000122100",
      "display" : "dexketoprofeno"
    },
    {
      "code" : "20271000122103",
      "display" : "dexrazoxano"
    },
    {
      "code" : "773486001",
      "display" : "dextrometorfano"
    },
    {
      "code" : "293591000",
      "display" : "dextromoramida"
    },
    {
      "code" : "293592007",
      "display" : "dextropropoxifeno"
    },
    {
      "code" : "871509002",
      "display" : "dextropropoxifeno y/o paracetamol"
    },
    {
      "code" : "294955007",
      "display" : "dextrotiroxina sódica"
    },
    {
      "code" : "294753009",
      "display" : "diacetato de etinodiol"
    },
    {
      "code" : "860778003",
      "display" : "diamidina"
    },
    {
      "code" : "293598006",
      "display" : "diamorfina"
    },
    {
      "code" : "293902006",
      "display" : "diazepam"
    },
    {
      "code" : "295074008",
      "display" : "diazóxido"
    },
    {
      "code" : "293693007",
      "display" : "diciclomina"
    },
    {
      "code" : "293645001",
      "display" : "dicitrato de bismuto tripotásico"
    },
    {
      "code" : "293613006",
      "display" : "diclofenaco"
    },
    {
      "code" : "293909002",
      "display" : "dicloralfenazona"
    },
    {
      "code" : "295029001",
      "display" : "diclorfenamida"
    },
    {
      "code" : "860777008",
      "display" : "dicloroacetamida"
    },
    {
      "code" : "76221000122103",
      "display" : "dicromato de potasio"
    },
    {
      "code" : "294372006",
      "display" : "didanosina"
    },
    {
      "code" : "294747009",
      "display" : "didrogesterona"
    },
    {
      "code" : "294789001",
      "display" : "dienestrol"
    },
    {
      "code" : "767198002",
      "display" : "dietil éter"
    },
    {
      "code" : "294456002",
      "display" : "dietilcarbamazina"
    },
    {
      "code" : "294796004",
      "display" : "dietilestilbestrol"
    },
    {
      "code" : "20491000122103",
      "display" : "difenidol"
    },
    {
      "code" : "293925007",
      "display" : "difenilbutilpiperidina"
    },
    {
      "code" : "294696008",
      "display" : "diflucortolona"
    },
    {
      "code" : "295055000",
      "display" : "digitoxina"
    },
    {
      "code" : "293599003",
      "display" : "dihidrocodeína"
    },
    {
      "code" : "36971000122107",
      "display" : "dihidropiridinas"
    },
    {
      "code" : "294003008",
      "display" : "diltiazem"
    },
    {
      "code" : "76341000122103",
      "display" : "dimemorfano"
    },
    {
      "code" : "294283004",
      "display" : "dimercaprol"
    },
    {
      "code" : "294329000",
      "display" : "dimeticona"
    },
    {
      "code" : "293796008",
      "display" : "dimetilsulfóxido"
    },
    {
      "code" : "294132008",
      "display" : "dimetindeno"
    },
    {
      "code" : "295088007",
      "display" : "dinitrato de isosorbida de liberación modificada"
    },
    {
      "code" : "295087002",
      "display" : "dinitrato de isosorbida oral"
    },
    {
      "code" : "294257009",
      "display" : "dinoprost"
    },
    {
      "code" : "294253008",
      "display" : "dinoprostona"
    },
    {
      "code" : "31691000122109",
      "display" : "dióxido de azufre y sulfitos en concentraciones superiores a 10 mg/kg o 10 mg/l"
    },
    {
      "code" : "295077001",
      "display" : "dipiridamol"
    },
    {
      "code" : "294977006",
      "display" : "disopiramida"
    },
    {
      "code" : "294013000",
      "display" : "distigmina"
    },
    {
      "code" : "294173009",
      "display" : "ditranol"
    },
    {
      "code" : "295005008",
      "display" : "diurético ahorrador de potasio"
    },
    {
      "code" : "294999003",
      "display" : "diurético de asa"
    },
    {
      "code" : "295020002",
      "display" : "diurético mercurial"
    },
    {
      "code" : "295018000",
      "display" : "diurético osmótico"
    },
    {
      "code" : "294047002",
      "display" : "dobutamina"
    },
    {
      "code" : "293687004",
      "display" : "docusato"
    },
    {
      "code" : "294439005",
      "display" : "domifeno"
    },
    {
      "code" : "293674005",
      "display" : "domperidona"
    },
    {
      "code" : "294048007",
      "display" : "dopexamina"
    },
    {
      "code" : "24331000122101",
      "display" : "dorada"
    },
    {
      "code" : "19481000122100",
      "display" : "dorzolamida"
    },
    {
      "code" : "293832002",
      "display" : "dotiepina"
    },
    {
      "code" : "294101007",
      "display" : "doxapram"
    },
    {
      "code" : "293823004",
      "display" : "doxepina"
    },
    {
      "code" : "294585005",
      "display" : "doxiciclina"
    },
    {
      "code" : "293766003",
      "display" : "doxorubicina"
    },
    {
      "code" : "76281000122104",
      "display" : "dronedarona"
    },
    {
      "code" : "20131000122105",
      "display" : "duloxetina"
    },
    {
      "code" : "1025201000122100",
      "display" : "dutasterida"
    },
    {
      "code" : "294014006",
      "display" : "ecotiopato"
    },
    {
      "code" : "294287003",
      "display" : "edetato de calcio sódico"
    },
    {
      "code" : "294286007",
      "display" : "edetato de dicobalto"
    },
    {
      "code" : "294288008",
      "display" : "edetato trisódico"
    },
    {
      "code" : "76481000122100",
      "display" : "edoxabán"
    },
    {
      "code" : "2511000122102",
      "display" : "edulcorante"
    },
    {
      "code" : "294062000",
      "display" : "efedrina"
    },
    {
      "code" : "294949002",
      "display" : "electrólito aniónico"
    },
    {
      "code" : "19461000122108",
      "display" : "eliglustat"
    },
    {
      "code" : "294194007",
      "display" : "emplastos"
    },
    {
      "code" : "35101000122108",
      "display" : "enalapril"
    },
    {
      "code" : "294190003",
      "display" : "enbucrilato"
    },
    {
      "code" : "23451000122103",
      "display" : "endibia"
    },
    {
      "code" : "293712006",
      "display" : "enflurano"
    },
    {
      "code" : "294488005",
      "display" : "enoxacino"
    },
    {
      "code" : "294873006",
      "display" : "enoxaparina"
    },
    {
      "code" : "295060001",
      "display" : "enoximona"
    },
    {
      "code" : "76491000122102",
      "display" : "entecavir"
    },
    {
      "code" : "25101000122105",
      "display" : "Entomophagus del pimentón"
    },
    {
      "code" : "295107003",
      "display" : "enzima medicinal"
    },
    {
      "code" : "36961000122102",
      "display" : "eosina disodio"
    },
    {
      "code" : "19471000122103",
      "display" : "epinastina"
    },
    {
      "code" : "19941000122104",
      "display" : "epinefrina"
    },
    {
      "code" : "293767007",
      "display" : "epirubicina"
    },
    {
      "code" : "12931000122104",
      "display" : "epitelio de animal"
    },
    {
      "code" : "12951000122109",
      "display" : "epitelio de caballo"
    },
    {
      "code" : "12961000122106",
      "display" : "epitelio de conejo"
    },
    {
      "code" : "12941000122107",
      "display" : "epitelio de gato"
    },
    {
      "code" : "16051000122109",
      "display" : "epitelio de hámster"
    },
    {
      "code" : "12971000122101",
      "display" : "epitelio de perro"
    },
    {
      "code" : "294844008",
      "display" : "epoetina alfa"
    },
    {
      "code" : "294845009",
      "display" : "epoetina beta"
    },
    {
      "code" : "294260002",
      "display" : "epoprostenol"
    },
    {
      "code" : "19871000122101",
      "display" : "eprosartán"
    },
    {
      "code" : "17771000122101",
      "display" : "equinocandinas"
    },
    {
      "code" : "294799006",
      "display" : "ergolina"
    },
    {
      "code" : "295068008",
      "display" : "ergometrina"
    },
    {
      "code" : "870746005",
      "display" : "ergometrina y/u oxitocina"
    },
    {
      "code" : "91931000",
      "display" : "eritromicina"
    },
    {
      "code" : "294843002",
      "display" : "eritropoyetina"
    },
    {
      "code" : "441725009",
      "display" : "ertapenem"
    },
    {
      "code" : "23421000122105",
      "display" : "escarola"
    },
    {
      "code" : "24481000122107",
      "display" : "escualeno"
    },
    {
      "code" : "1025271000122100",
      "display" : "eslicarbazepina"
    },
    {
      "code" : "19501000122108",
      "display" : "esomeprazol"
    },
    {
      "code" : "294474006",
      "display" : "espectinomicina"
    },
    {
      "code" : "23801000122104",
      "display" : "espelta"
    },
    {
      "code" : "1025051000122100",
      "display" : "espiramicina"
    },
    {
      "code" : "35191000122103",
      "display" : "espirapril"
    },
    {
      "code" : "295014003",
      "display" : "espironolactona y a diurético de asa"
    },
    {
      "code" : "295015002",
      "display" : "espironolactona y a diurético tiazídico"
    },
    {
      "code" : "294762006",
      "display" : "estanozolol"
    },
    {
      "code" : "21911000122107",
      "display" : "éster de p-hidroxibenzoato"
    },
    {
      "code" : "294598001",
      "display" : "estibogluconato de sodio"
    },
    {
      "code" : "294782005",
      "display" : "estradiol"
    },
    {
      "code" : "294785007",
      "display" : "estradiol tópico"
    },
    {
      "code" : "293752008",
      "display" : "estramustina"
    },
    {
      "code" : "295108008",
      "display" : "estreptoquinasa"
    },
    {
      "code" : "295115000",
      "display" : "estreptoquinasa estreptodornasa"
    },
    {
      "code" : "294781003",
      "display" : "estrógeno"
    },
    {
      "code" : "294795000",
      "display" : "estrógeno conjugado"
    },
    {
      "code" : "294100008",
      "display" : "etamiván"
    },
    {
      "code" : "294885003",
      "display" : "etamsilato"
    },
    {
      "code" : "295106007",
      "display" : "etanolamina"
    },
    {
      "code" : "294834006",
      "display" : "etidronato disódico"
    },
    {
      "code" : "294837004",
      "display" : "etidronato disódico y a carbonato de calcio"
    },
    {
      "code" : "294793007",
      "display" : "etinilestradiol"
    },
    {
      "code" : "293614000",
      "display" : "etodolaco"
    },
    {
      "code" : "293749000",
      "display" : "etoglúcido"
    },
    {
      "code" : "293706001",
      "display" : "etomidato"
    },
    {
      "code" : "1025161000122100",
      "display" : "etoricoxib"
    },
    {
      "code" : "293870003",
      "display" : "etosuximida"
    },
    {
      "code" : "18481000122108",
      "display" : "eucalipto"
    },
    {
      "code" : "402593006",
      "display" : "excipiente"
    },
    {
      "code" : "294856009",
      "display" : "factor de coagulación sanguínea"
    },
    {
      "code" : "294371004",
      "display" : "famciclovir"
    },
    {
      "code" : "293651006",
      "display" : "famotidina"
    },
    {
      "code" : "294054008",
      "display" : "fármaco agonista de receptor alfa-adrenérgico de acción central"
    },
    {
      "code" : "293718005",
      "display" : "fármaco anestésico local"
    },
    {
      "code" : "293801003",
      "display" : "fármaco anorexígeno de acción central"
    },
    {
      "code" : "293664007",
      "display" : "fármaco antiácido"
    },
    {
      "code" : "294974004",
      "display" : "fármaco antiarrítmico"
    },
    {
      "code" : "294976002",
      "display" : "fármaco antiarrítmico clase I"
    },
    {
      "code" : "294987005",
      "display" : "fármaco antiarrítmico de clase III"
    },
    {
      "code" : "294989008",
      "display" : "fármaco antiarrítmico de clase IV"
    },
    {
      "code" : "294065003",
      "display" : "fármaco anticolinérgico"
    },
    {
      "code" : "293667000",
      "display" : "fármaco antidiarreico"
    },
    {
      "code" : "293672009",
      "display" : "fármaco antiemético"
    },
    {
      "code" : "293688009",
      "display" : "fármaco antiespasmódico"
    },
    {
      "code" : "295031005",
      "display" : "fármaco antihipertensivo"
    },
    {
      "code" : "17671000122109",
      "display" : "fármaco antihistamínico H2"
    },
    {
      "code" : "294110004",
      "display" : "fármaco antihistamínico no sedante"
    },
    {
      "code" : "294117001",
      "display" : "fármaco antihistamínico sedante"
    },
    {
      "code" : "294108001",
      "display" : "fármaco antihistamínico tópico"
    },
    {
      "code" : "293610009",
      "display" : "fármaco antiinflamatorio no esteroide"
    },
    {
      "code" : "294340008",
      "display" : "fármaco antimicótico"
    },
    {
      "code" : "294066002",
      "display" : "fármaco antimuscarínico"
    },
    {
      "code" : "293739003",
      "display" : "fármaco antineoplásico"
    },
    {
      "code" : "294387001",
      "display" : "fármaco antipalúdico"
    },
    {
      "code" : "294389003",
      "display" : "fármaco antipalúdico con aminoquinolina"
    },
    {
      "code" : "294395002",
      "display" : "fármaco antipalúdico con biguanida"
    },
    {
      "code" : "294397005",
      "display" : "fármaco antipalúdico con quina"
    },
    {
      "code" : "294595003",
      "display" : "fármaco antiprotozoario"
    },
    {
      "code" : "294597006",
      "display" : "fármaco antiprotozoario con antimonio"
    },
    {
      "code" : "713690006",
      "display" : "fármaco antirretroviral"
    },
    {
      "code" : "294672003",
      "display" : "fármaco antitiroideo"
    },
    {
      "code" : "294606001",
      "display" : "fármaco antituberculoso"
    },
    {
      "code" : "294613001",
      "display" : "fármaco antituberculoso hidrazida"
    },
    {
      "code" : "294147004",
      "display" : "fármaco antitusígeno"
    },
    {
      "code" : "294154005",
      "display" : "fármaco antitusígeno compuesto"
    },
    {
      "code" : "293644002",
      "display" : "fármaco antiulceroso"
    },
    {
      "code" : "294367002",
      "display" : "fármaco antiviral"
    },
    {
      "code" : "293971000",
      "display" : "fármaco betabloqueante no cardioselectivo"
    },
    {
      "code" : "293994004",
      "display" : "fármaco bloqueante de los canales del calcio"
    },
    {
      "code" : "294616009",
      "display" : "fármaco contra la lepra"
    },
    {
      "code" : "294155006",
      "display" : "fármaco descongestivo de marca comercial"
    },
    {
      "code" : "294990004",
      "display" : "fármaco diurético"
    },
    {
      "code" : "294991000",
      "display" : "fármaco diurético tiazídico"
    },
    {
      "code" : "293807004",
      "display" : "fármaco dopaminérgico empleado en la enfermedad de Parkinson"
    },
    {
      "code" : "402592001",
      "display" : "fármaco en contacto con la piel"
    },
    {
      "code" : "293953007",
      "display" : "fármaco estimulante de acción central"
    },
    {
      "code" : "293670001",
      "display" : "fármaco estimulante de la motilidad"
    },
    {
      "code" : "294046006",
      "display" : "fármaco estimulante selectivo de receptor beta-1 adrenérgico"
    },
    {
      "code" : "294156007",
      "display" : "fármaco expectorante"
    },
    {
      "code" : "294884004",
      "display" : "fármaco hemostático"
    },
    {
      "code" : "294954006",
      "display" : "fármaco hipolipemiante"
    },
    {
      "code" : "293797004",
      "display" : "fármaco inmunosupresor"
    },
    {
      "code" : "293959006",
      "display" : "fármaco modificador del metabolismo del alcohol"
    },
    {
      "code" : "293913009",
      "display" : "fármaco neuroléptico"
    },
    {
      "code" : "294006000",
      "display" : "fármaco parasimpaticomimético"
    },
    {
      "code" : "294010002",
      "display" : "fármaco parasimpaticomimético anticolinesterasa"
    },
    {
      "code" : "294222006",
      "display" : "fármaco que actúa sobre la transmisión neuromuscular"
    },
    {
      "code" : "294020007",
      "display" : "fármaco simpaticomimético"
    },
    {
      "code" : "293704003",
      "display" : "fármaco utilizado para anestesia general"
    },
    {
      "code" : "295069000",
      "display" : "fármaco vasodilatador"
    },
    {
      "code" : "294461000",
      "display" : "fármacos antibacterianos"
    },
    {
      "code" : "294092009",
      "display" : "fármacos mucolíticos"
    },
    {
      "code" : "293615004",
      "display" : "felbinaco"
    },
    {
      "code" : "293999009",
      "display" : "felodipino"
    },
    {
      "code" : "293616003",
      "display" : "fenbufén"
    },
    {
      "code" : "294496000",
      "display" : "feneticilina"
    },
    {
      "code" : "293806008",
      "display" : "fenfluramina"
    },
    {
      "code" : "18261000122101",
      "display" : "fenilalanina"
    },
    {
      "code" : "293628006",
      "display" : "fenilbutazona"
    },
    {
      "code" : "294030003",
      "display" : "fenilefrina"
    },
    {
      "code" : "294137002",
      "display" : "fenindamina"
    },
    {
      "code" : "294138007",
      "display" : "feniramina"
    },
    {
      "code" : "293869004",
      "display" : "fenitoína"
    },
    {
      "code" : "294966000",
      "display" : "fenofibrato"
    },
    {
      "code" : "767470005",
      "display" : "fenogreco"
    },
    {
      "code" : "764442003",
      "display" : "fenol clorado"
    },
    {
      "code" : "293617007",
      "display" : "fenoprofeno"
    },
    {
      "code" : "294039002",
      "display" : "fenoterol"
    },
    {
      "code" : "294629009",
      "display" : "fenotrina"
    },
    {
      "code" : "293989004",
      "display" : "fenoxibenzamina"
    },
    {
      "code" : "293605005",
      "display" : "fentanilo"
    },
    {
      "code" : "293803000",
      "display" : "fentermina"
    },
    {
      "code" : "293990008",
      "display" : "fentolamina"
    },
    {
      "code" : "294894009",
      "display" : "feredetato de sodio"
    },
    {
      "code" : "703926003",
      "display" : "fibra vegetal"
    },
    {
      "code" : "417960005",
      "display" : "fibrato hipolipemiante"
    },
    {
      "code" : "294767000",
      "display" : "finasterida"
    },
    {
      "code" : "16041000122107",
      "display" : "fingolimod"
    },
    {
      "code" : "294243007",
      "display" : "flavoxato"
    },
    {
      "code" : "294979009",
      "display" : "flecainida"
    },
    {
      "code" : "295073002",
      "display" : "flosequinán"
    },
    {
      "code" : "294697004",
      "display" : "fluclorolona"
    },
    {
      "code" : "294502006",
      "display" : "flucloxacilina"
    },
    {
      "code" : "294365005",
      "display" : "fluconazol"
    },
    {
      "code" : "293786004",
      "display" : "fludarabina"
    },
    {
      "code" : "294698009",
      "display" : "fludrocortisona"
    },
    {
      "code" : "293934002",
      "display" : "flufenazina"
    },
    {
      "code" : "294271001",
      "display" : "flumazenil"
    },
    {
      "code" : "1025171000122100",
      "display" : "flunarizina"
    },
    {
      "code" : "294684001",
      "display" : "flunisolida"
    },
    {
      "code" : "293886005",
      "display" : "flunitrazepam"
    },
    {
      "code" : "294699001",
      "display" : "fluocinolona"
    },
    {
      "code" : "294687008",
      "display" : "fluocinonida"
    },
    {
      "code" : "294688003",
      "display" : "fluocortolona"
    },
    {
      "code" : "294683007",
      "display" : "fluorometolona"
    },
    {
      "code" : "1025041000122100",
      "display" : "fluoropirimidina"
    },
    {
      "code" : "830259009",
      "display" : "fluoroquinolona"
    },
    {
      "code" : "293776000",
      "display" : "fluorouracilo"
    },
    {
      "code" : "294951003",
      "display" : "fluoruro"
    },
    {
      "code" : "294952005",
      "display" : "fluoruro de sodio"
    },
    {
      "code" : "293850009",
      "display" : "fluoxetina"
    },
    {
      "code" : "293948002",
      "display" : "flupentixol"
    },
    {
      "code" : "294689006",
      "display" : "flurandrenolona"
    },
    {
      "code" : "293887001",
      "display" : "flurazepam"
    },
    {
      "code" : "293618002",
      "display" : "flurbiprofeno"
    },
    {
      "code" : "293927004",
      "display" : "fluspirileno"
    },
    {
      "code" : "294768005",
      "display" : "flutamida"
    },
    {
      "code" : "294700000",
      "display" : "fluticasona"
    },
    {
      "code" : "294972000",
      "display" : "fluvastatina"
    },
    {
      "code" : "293851008",
      "display" : "fluvoxamina"
    },
    {
      "code" : "294153004",
      "display" : "folcodina"
    },
    {
      "code" : "293791003",
      "display" : "formestano"
    },
    {
      "code" : "17591000122106",
      "display" : "formoterol"
    },
    {
      "code" : "294382007",
      "display" : "foscarnet"
    },
    {
      "code" : "294943001",
      "display" : "fosfato de celulosa sódica"
    },
    {
      "code" : "294790005",
      "display" : "fosfato de poliestradiol"
    },
    {
      "code" : "294903006",
      "display" : "fosfato ferroso"
    },
    {
      "code" : "294559006",
      "display" : "fosfomicina"
    },
    {
      "code" : "35171000122104",
      "display" : "fosinopril"
    },
    {
      "code" : "294268009",
      "display" : "fragmento fab inmunitario antidigoxina"
    },
    {
      "code" : "23131000122100",
      "display" : "frambuesa"
    },
    {
      "code" : "91938006",
      "display" : "fresa"
    },
    {
      "code" : "18611000122101",
      "display" : "frovatriptán"
    },
    {
      "code" : "418085001",
      "display" : "fruta cítrica"
    },
    {
      "code" : "48821000119104",
      "display" : "frutas secas"
    },
    {
      "code" : "23171000122102",
      "display" : "fruto del kiwi"
    },
    {
      "code" : "91934008",
      "display" : "frutos secos"
    },
    {
      "code" : "294898007",
      "display" : "fumarato ferroso"
    },
    {
      "code" : "295000003",
      "display" : "furosemida"
    },
    {
      "code" : "293861001",
      "display" : "gabapentina"
    },
    {
      "code" : "19981000122108",
      "display" : "gadolinio y sus derivados"
    },
    {
      "code" : "20431000122102",
      "display" : "galantamina"
    },
    {
      "code" : "294370003",
      "display" : "ganciclovir"
    },
    {
      "code" : "23011000122105",
      "display" : "garbanzo"
    },
    {
      "code" : "294411009",
      "display" : "gasa impregnada con pasta de subnitrato de bismuto y yodoformo"
    },
    {
      "code" : "293703009",
      "display" : "gases de uso médico y anestésicos"
    },
    {
      "code" : "20291000122102",
      "display" : "gemcitabina"
    },
    {
      "code" : "294956008",
      "display" : "gemfibrozilo"
    },
    {
      "code" : "18431000122107",
      "display" : "gemifloxacino"
    },
    {
      "code" : "294469003",
      "display" : "gentamicina"
    },
    {
      "code" : "294749007",
      "display" : "gestonorona"
    },
    {
      "code" : "13701000122101",
      "display" : "ginseng"
    },
    {
      "code" : "20421000122100",
      "display" : "glatirámero"
    },
    {
      "code" : "294732000",
      "display" : "glibornurida"
    },
    {
      "code" : "294320001",
      "display" : "glicerol"
    },
    {
      "code" : "294298002",
      "display" : "glicina"
    },
    {
      "code" : "294733005",
      "display" : "gliclazida"
    },
    {
      "code" : "294736002",
      "display" : "glimidina"
    },
    {
      "code" : "294734004",
      "display" : "glipizida"
    },
    {
      "code" : "294671005",
      "display" : "glucagón"
    },
    {
      "code" : "294899004",
      "display" : "gluconato ferroso"
    },
    {
      "code" : "295053007",
      "display" : "glucósido cardíaco"
    },
    {
      "code" : "2491000122106",
      "display" : "glutamato monosódico"
    },
    {
      "code" : "294423003",
      "display" : "glutaraldehído"
    },
    {
      "code" : "1269425007",
      "display" : "gluten"
    },
    {
      "code" : "294741005",
      "display" : "goma guar"
    },
    {
      "code" : "294815006",
      "display" : "gonadorelina"
    },
    {
      "code" : "24681000122105",
      "display" : "gorgojo de la harina"
    },
    {
      "code" : "25041000122108",
      "display" : "gorgojo de las lentejas"
    },
    {
      "code" : "294709004",
      "display" : "gotas de prednisolona"
    },
    {
      "code" : "17001000122107",
      "display" : "grindelia"
    },
    {
      "code" : "294348001",
      "display" : "griseofulvina"
    },
    {
      "code" : "293800002",
      "display" : "grupo de fármacos que afectan principalmente al sistema nervioso central"
    },
    {
      "code" : "294953000",
      "display" : "grupos de fármacos que afectan principalmente al aparato cardiovascular"
    },
    {
      "code" : "294090001",
      "display" : "grupos de fármacos que afectan principalmente al aparato respiratorio"
    },
    {
      "code" : "294212000",
      "display" : "grupos de fármacos que afectan principalmente al sistema musculoesquelético"
    },
    {
      "code" : "294513009",
      "display" : "penicilinas antipseudomonas"
    },
    {
      "code" : "294504007",
      "display" : "penicilinas de amplio espectro"
    },
    {
      "code" : "294500003",
      "display" : "penicilinas resistentes a la penicilinasa"
    },
    {
      "code" : "294492003",
      "display" : "penicilinas sensibles a la penicilinasa"
    },
    {
      "code" : "294600007",
      "display" : "pentamidina"
    },
    {
      "code" : "293588000",
      "display" : "pentazocina"
    },
    {
      "code" : "293774002",
      "display" : "pentostatina"
    },
    {
      "code" : "295094004",
      "display" : "pentoxifilina"
    },
    {
      "code" : "23031000122101",
      "display" : "pepino"
    },
    {
      "code" : "12851000122102",
      "display" : "pepsina"
    },
    {
      "code" : "23251000122104",
      "display" : "pera"
    },
    {
      "code" : "294408008",
      "display" : "perborato de sodio"
    },
    {
      "code" : "23931000122102",
      "display" : "percebe"
    },
    {
      "code" : "23941000122105",
      "display" : "perejil"
    },
    {
      "code" : "293939007",
      "display" : "perfenazina"
    },
    {
      "code" : "300908007",
      "display" : "perfumes"
    },
    {
      "code" : "293814002",
      "display" : "pergolida"
    },
    {
      "code" : "293930006",
      "display" : "periciazina"
    },
    {
      "code" : "35121000122100",
      "display" : "perindopril"
    },
    {
      "code" : "294410005",
      "display" : "permanganato de potasio"
    },
    {
      "code" : "294630004",
      "display" : "permetrina"
    },
    {
      "code" : "294203002",
      "display" : "peróxido de benzoilo"
    },
    {
      "code" : "294449008",
      "display" : "peróxido de hidrógeno"
    },
    {
      "code" : "417532002",
      "display" : "pescado"
    },
    {
      "code" : "293606006",
      "display" : "petidina"
    },
    {
      "code" : "23961000122109",
      "display" : "pez espada"
    },
    {
      "code" : "24731000122102",
      "display" : "picadura de garrapata"
    },
    {
      "code" : "24831000122108",
      "display" : "picadura de hormiga roja de fuego"
    },
    {
      "code" : "24601000122103",
      "display" : "picadura de mosquito"
    },
    {
      "code" : "24621000122106",
      "display" : "picadura de mosquito Culex pipiens"
    },
    {
      "code" : "24781000122101",
      "display" : "picadura de piojo"
    },
    {
      "code" : "24691000122108",
      "display" : "picadura de tábano"
    },
    {
      "code" : "294007009",
      "display" : "pilocarpina"
    },
    {
      "code" : "24411000122102",
      "display" : "pimentón"
    },
    {
      "code" : "24431000122106",
      "display" : "pimienta negra"
    },
    {
      "code" : "23391000122104",
      "display" : "pimiento"
    },
    {
      "code" : "293973002",
      "display" : "pindolol"
    },
    {
      "code" : "23501000122101",
      "display" : "pińón"
    },
    {
      "code" : "23361000122105",
      "display" : "pipa de calabaza"
    },
    {
      "code" : "293695000",
      "display" : "pipenzolato"
    },
    {
      "code" : "294515002",
      "display" : "piperacilina"
    },
    {
      "code" : "870712009",
      "display" : "piperacilina y/o tazobactam"
    },
    {
      "code" : "294451007",
      "display" : "piperazina"
    },
    {
      "code" : "830175004",
      "display" : "piperidolato"
    },
    {
      "code" : "293936000",
      "display" : "pipotiazina"
    },
    {
      "code" : "294452000",
      "display" : "pirantel"
    },
    {
      "code" : "294607005",
      "display" : "pirazinamida"
    },
    {
      "code" : "24791000122103",
      "display" : "pirazolonas"
    },
    {
      "code" : "294035008",
      "display" : "pirbuterol"
    },
    {
      "code" : "293658000",
      "display" : "pirenzepina"
    },
    {
      "code" : "20021000122106",
      "display" : "piribedil"
    },
    {
      "code" : "767479006",
      "display" : "piridoxina"
    },
    {
      "code" : "294388006",
      "display" : "pirimetamina"
    },
    {
      "code" : "23351000122108",
      "display" : "pistacho"
    },
    {
      "code" : "718535005",
      "display" : "pitavastatina"
    },
    {
      "code" : "294526008",
      "display" : "pivampicilina y pivmecilinam"
    },
    {
      "code" : "870730002",
      "display" : "pivampicilina y/o pivmecilinam"
    },
    {
      "code" : "19791000122109",
      "display" : "pizotifeno"
    },
    {
      "code" : "294619002",
      "display" : "plaguicida"
    },
    {
      "code" : "294624004",
      "display" : "plaguicida clorado"
    },
    {
      "code" : "294626002",
      "display" : "plaguicida organofosforado"
    },
    {
      "code" : "402594000",
      "display" : "planta"
    },
    {
      "code" : "18141000122107",
      "display" : "plantas de la familia Asteraceae"
    },
    {
      "code" : "24851000122103",
      "display" : "platija"
    },
    {
      "code" : "17721000122102",
      "display" : "platino y derivados"
    },
    {
      "code" : "232348003",
      "display" : "pluma"
    },
    {
      "code" : "293696004",
      "display" : "poldina"
    },
    {
      "code" : "300910009",
      "display" : "polen"
    },
    {
      "code" : "32231000122103",
      "display" : "polen de acedera"
    },
    {
      "code" : "31801000122103",
      "display" : "polen de agracejo"
    },
    {
      "code" : "31701000122109",
      "display" : "polen de álamo"
    },
    {
      "code" : "31821000122106",
      "display" : "polen de aligustre"
    },
    {
      "code" : "31911000122105",
      "display" : "polen de almez"
    },
    {
      "code" : "21711000122109",
      "display" : "polen de alpiste"
    },
    {
      "code" : "419263009",
      "display" : "polen de árbol"
    },
    {
      "code" : "31871000122107",
      "display" : "polen de arce"
    },
    {
      "code" : "31721000122101",
      "display" : "polen de avellano"
    },
    {
      "code" : "13061000122103",
      "display" : "polen de avena"
    },
    {
      "code" : "24811000122104",
      "display" : "polen de ballica"
    },
    {
      "code" : "31761000122105",
      "display" : "polen de castańo"
    },
    {
      "code" : "31941000122109",
      "display" : "polen de casuarina"
    },
    {
      "code" : "24801000122102",
      "display" : "polen de cenizo"
    },
    {
      "code" : "32181000122108",
      "display" : "polen de céńigo"
    },
    {
      "code" : "24081000122103",
      "display" : "polen de césped"
    },
    {
      "code" : "294859002",
      "display" : "productos del factor IX"
    },
    {
      "code" : "294857000",
      "display" : "productos del factor VIII"
    },
    {
      "code" : "294862004",
      "display" : "productos intermedios de factor IX"
    },
    {
      "code" : "294920005",
      "display" : "productos vitamínicos"
    },
    {
      "code" : "294745001",
      "display" : "progestágeno"
    },
    {
      "code" : "294748004",
      "display" : "progesterona"
    },
    {
      "code" : "294396001",
      "display" : "proguanil"
    },
    {
      "code" : "293956004",
      "display" : "prolintano"
    },
    {
      "code" : "293937009",
      "display" : "promazina"
    },
    {
      "code" : "5361000122104",
      "display" : "promestrieno"
    },
    {
      "code" : "294126003",
      "display" : "prometazina"
    },
    {
      "code" : "294983009",
      "display" : "propafenona"
    },
    {
      "code" : "293697008",
      "display" : "propantelina"
    },
    {
      "code" : "17241000122101",
      "display" : "propifenazona"
    },
    {
      "code" : "294676000",
      "display" : "propiltiouracilo"
    },
    {
      "code" : "294759008",
      "display" : "propionato de drostanolona"
    },
    {
      "code" : "293708000",
      "display" : "propofol"
    },
    {
      "code" : "293982008",
      "display" : "propranolol"
    },
    {
      "code" : "294249006",
      "display" : "prostaglandina"
    },
    {
      "code" : "294250006",
      "display" : "prostaglandina, serie A"
    },
    {
      "code" : "294252003",
      "display" : "prostaglandina, serie E"
    },
    {
      "code" : "294256000",
      "display" : "prostaglandina, serie F"
    },
    {
      "code" : "294259007",
      "display" : "prostaglandina, serie I"
    },
    {
      "code" : "294278007",
      "display" : "protamina"
    },
    {
      "code" : "717234006",
      "display" : "proteína animal"
    },
    {
      "code" : "703902000",
      "display" : "proteína de Dermatophagoides farinae"
    },
    {
      "code" : "703933003",
      "display" : "proteína de Dermatophagoides pteronyssinus"
    },
    {
      "code" : "706887003",
      "display" : "proteína de fumagina"
    },
    {
      "code" : "782555009",
      "display" : "proteína de la leche de vaca"
    },
    {
      "code" : "706888008",
      "display" : "proteína de roya"
    },
    {
      "code" : "213020009",
      "display" : "proteína del huevo"
    },
    {
      "code" : "1003755004",
      "display" : "proteína del látex de Hevea brasiliensis"
    },
    {
      "code" : "293635003",
      "display" : "proteína purificada de tuberculina"
    },
    {
      "code" : "294829007",
      "display" : "protirelina"
    },
    {
      "code" : "293834001",
      "display" : "protriptilina"
    },
    {
      "code" : "293728001",
      "display" : "proximetacaína"
    },
    {
      "code" : "35341000122108",
      "display" : "prunáceas [familia Prunus]"
    },
    {
      "code" : "294023009",
      "display" : "pseudoefedrina"
    },
    {
      "code" : "23051000122106",
      "display" : "puerro"
    },
    {
      "code" : "294105003",
      "display" : "pumactant"
    },
    {
      "code" : "1025021000122100",
      "display" : "quetiapina"
    },
    {
      "code" : "295116004",
      "display" : "quimotripsina"
    },
    {
      "code" : "294801009",
      "display" : "quinagolida"
    },
    {
      "code" : "35141000122105",
      "display" : "quinapril"
    },
    {
      "code" : "37041000122100",
      "display" : "quinazolina"
    },
    {
      "code" : "294787004",
      "display" : "quinestradol"
    },
    {
      "code" : "294978001",
      "display" : "quinidina"
    },
    {
      "code" : "23061000122108",
      "display" : "rábano"
    },
    {
      "code" : "15851000122107",
      "display" : "rabeprazol"
    },
    {
      "code" : "710158004",
      "display" : "raíz de lirio"
    },
    {
      "code" : "473078001",
      "display" : "raloxifeno"
    },
    {
      "code" : "35131000122102",
      "display" : "ramipril"
    },
    {
      "code" : "25021000122103",
      "display" : "rana"
    },
    {
      "code" : "449414003",
      "display" : "rapacuronio"
    },
    {
      "code" : "24101000122109",
      "display" : "rape"
    },
    {
      "code" : "293783007",
      "display" : "razoxano"
    },
    {
      "code" : "609409007",
      "display" : "reacción pseudoalérgica causada por sulfito"
    },
    {
      "code" : "293647009",
      "display" : "regaliz"
    },
    {
      "code" : "294241009",
      "display" : "relajante del músculo liso"
    },
    {
      "code" : "23281000122105",
      "display" : "remolacha"
    },
    {
      "code" : "293950005",
      "display" : "remoxiprida"
    },
    {
      "code" : "294041001",
      "display" : "reproterol"
    },
    {
      "code" : "294960006",
      "display" : "resina de intercambio aniónico"
    },
    {
      "code" : "294942006",
      "display" : "resina de intercambio catiónico"
    },
    {
      "code" : "294182003",
      "display" : "resina de podófilo"
    },
    {
      "code" : "294207001",
      "display" : "retinoide"
    },
    {
      "code" : "294380004",
      "display" : "ribavirina"
    },
    {
      "code" : "294612006",
      "display" : "rifabutina"
    },
    {
      "code" : "294611004",
      "display" : "rifampicina"
    },
    {
      "code" : "19891000122100",
      "display" : "rilpivirina"
    },
    {
      "code" : "294042008",
      "display" : "rimiterol"
    },
    {
      "code" : "293917005",
      "display" : "risperidona"
    },
    {
      "code" : "294043003",
      "display" : "ritodrina"
    },
    {
      "code" : "76391000122105",
      "display" : "rivaroxabán"
    },
    {
      "code" : "1025221000122100",
      "display" : "rivastigmina"
    },
    {
      "code" : "294233009",
      "display" : "rocuronio"
    },
    {
      "code" : "24111000122107",
      "display" : "rodaballo"
    },
    {
      "code" : "24121000122101",
      "display" : "romero"
    },
    {
      "code" : "19811000122108",
      "display" : "ropivacaína"
    },
    {
      "code" : "35331000122100",
      "display" : "rosáceas [familia Rosaceae]"
    },
    {
      "code" : "17901000122108",
      "display" : "rosuvastatina"
    },
    {
      "code" : "718537002",
      "display" : "rosuvastatina"
    },
    {
      "code" : "76331000122106",
      "display" : "rotigotina"
    },
    {
      "code" : "294192006",
      "display" : "rubefacientes"
    },
    {
      "code" : "37551000122107",
      "display" : "rucaparib"
    },
    {
      "code" : "18451000122102",
      "display" : "rufloxacino"
    },
    {
      "code" : "18071000122102",
      "display" : "ruxolitinib"
    },
    {
      "code" : "294897002",
      "display" : "sal ferrosa"
    },
    {
      "code" : "294037000",
      "display" : "salbutamol"
    },
    {
      "code" : "294840004",
      "display" : "salcatonina"
    },
    {
      "code" : "293585002",
      "display" : "salicilato"
    },
    {
      "code" : "294313008",
      "display" : "saliva artificial"
    },
    {
      "code" : "294036009",
      "display" : "salmeterol"
    },
    {
      "code" : "24131000122103",
      "display" : "salmón"
    },
    {
      "code" : "24141000122106",
      "display" : "salmonete"
    },
    {
      "code" : "17251000122104",
      "display" : "salvia"
    },
    {
      "code" : "419298007",
      "display" : "sandía"
    },
    {
      "code" : "17951000122107",
      "display" : "saquinavir"
    },
    {
      "code" : "24151000122108",
      "display" : "sardina"
    },
    {
      "code" : "24711000122106",
      "display" : "savinasa"
    },
    {
      "code" : "18061000122107",
      "display" : "saxagliptina"
    },
    {
      "code" : "293884008",
      "display" : "secobarbital"
    },
    {
      "code" : "293905008",
      "display" : "sedante a base de carbamato"
    },
    {
      "code" : "293879002",
      "display" : "sedante barbitúrico"
    },
    {
      "code" : "293885009",
      "display" : "sedante benzodiazepínico"
    },
    {
      "code" : "293907000",
      "display" : "sedante de cloral"
    },
    {
      "code" : "293952002",
      "display" : "selegilina"
    },
    {
      "code" : "294199002",
      "display" : "selenio tópico"
    },
    {
      "code" : "419101002",
      "display" : "semilla"
    },
    {
      "code" : "25001000122106",
      "display" : "semilla de adormidera"
    },
    {
      "code" : "767469009",
      "display" : "semilla de amapola"
    },
    {
      "code" : "24981000122104",
      "display" : "semilla de lino"
    },
    {
      "code" : "293686008",
      "display" : "sen"
    },
    {
      "code" : "441831003",
      "display" : "sensibilidad al gluten"
    },
    {
      "code" : "24161000122105",
      "display" : "sepia"
    },
    {
      "code" : "20011000122100",
      "display" : "sevelámero y sus derivados"
    },
    {
      "code" : "20251000122106",
      "display" : "sildenafilo"
    },
    {
      "code" : "294328008",
      "display" : "silicona"
    },
    {
      "code" : "294971007",
      "display" : "simvastatina"
    },
    {
      "code" : "716186003",
      "display" : "sin alergia conocida"
    },
    {
      "code" : "432807008",
      "display" : "síndrome de alergia oral"
    },
    {
      "code" : "37561000122109",
      "display" : "siponimod"
    },
    {
      "code" : "18041000122108",
      "display" : "sitagliptina"
    },
    {
      "code" : "37571000122104",
      "display" : "sitaxentán"
    },
    {
      "code" : "19781000122106",
      "display" : "solifenacina"
    },
    {
      "code" : "37581000122101",
      "display" : "solriamfetol"
    },
    {
      "code" : "294304006",
      "display" : "solución de cardioplejía"
    },
    {
      "code" : "294302005",
      "display" : "solución de hemofiltración"
    },
    {
      "code" : "294300002",
      "display" : "solución para diálisis peritoneal"
    },
    {
      "code" : "294409000",
      "display" : "soluciones cloradas"
    },
    {
      "code" : "19991000122106",
      "display" : "somatostatina y sus análogos"
    },
    {
      "code" : "293983003",
      "display" : "sotalol"
    },
    {
      "code" : "294901008",
      "display" : "succinato ferroso"
    },
    {
      "code" : "293646000",
      "display" : "sucralfato"
    },
    {
      "code" : "705097000",
      "display" : "suero"
    },
    {
      "code" : "441955007",
      "display" : "sufentanilo"
    },
    {
      "code" : "37591000122103",
      "display" : "sulbactam"
    },
    {
      "code" : "294578006",
      "display" : "sulfacarbamida"
    },
    {
      "code" : "294582008",
      "display" : "sulfacetamida"
    },
    {
      "code" : "294580000",
      "display" : "sulfadiazina argéntica"
    },
    {
      "code" : "294574008",
      "display" : "sulfadimetoxina"
    },
    {
      "code" : "294576005",
      "display" : "sulfafurazol"
    },
    {
      "code" : "294577001",
      "display" : "sulfaguanidina"
    },
    {
      "code" : "294570004",
      "display" : "sulfaloxato de calcio"
    },
    {
      "code" : "294594004",
      "display" : "sulfametoxazol + trimetoprima"
    },
    {
      "code" : "870714005",
      "display" : "sulfametoxazol y/o trimetoprima"
    },
    {
      "code" : "295093005",
      "display" : "sulfato de bametán"
    },
    {
      "code" : "409638006",
      "display" : "sulfato de estreptomicina"
    },
    {
      "code" : "294900009",
      "display" : "sulfato de glicina ferroso"
    },
    {
      "code" : "293682005",
      "display" : "sulfato de magnesio"
    },
    {
      "code" : "409640001",
      "display" : "sulfato de neomicina"
    },
    {
      "code" : "294902001",
      "display" : "sulfato ferroso"
    },
    {
      "code" : "294218001",
      "display" : "sulfinpirazona"
    },
    {
      "code" : "294581001",
      "display" : "sulfonamidas combinadas"
    },
    {
      "code" : "294728006",
      "display" : "sulfonilurea"
    },
    {
      "code" : "293630008",
      "display" : "sulindaco"
    },
    {
      "code" : "293914003",
      "display" : "sulpirida"
    },
    {
      "code" : "32481000122103",
      "display" : "sunitinib"
    },
    {
      "code" : "294195008",
      "display" : "surfactante aniónico"
    },
    {
      "code" : "294436003",
      "display" : "surfactante de amonio cuaternario"
    },
    {
      "code" : "294440007",
      "display" : "surfactante de piridinio cuaternario"
    },
    {
      "code" : "294246004",
      "display" : "surfactante no iónico"
    },
    {
      "code" : "294102000",
      "display" : "surfactante respiratorio"
    },
    {
      "code" : "13071000122108",
      "display" : "polen de ciprés"
    },
    {
      "code" : "11541000122106",
      "display" : "polen de dáctilo"
    },
    {
      "code" : "23511000122103",
      "display" : "polen de diente de león"
    },
    {
      "code" : "31891000122108",
      "display" : "polen de encina"
    },
    {
      "code" : "16001000122105",
      "display" : "polen de enebro"
    },
    {
      "code" : "32211000122107",
      "display" : "polen de enebro rojo"
    },
    {
      "code" : "32121000122109",
      "display" : "polen de euforbio"
    },
    {
      "code" : "31841000122101",
      "display" : "polen de fresno"
    },
    {
      "code" : "32141000122104",
      "display" : "polen de grama común"
    },
    {
      "code" : "418689008",
      "display" : "polen de gramínea"
    },
    {
      "code" : "31781000122102",
      "display" : "polen de haya"
    },
    {
      "code" : "419210001",
      "display" : "polen de hierba"
    },
    {
      "code" : "31861000122102",
      "display" : "polen de lila"
    },
    {
      "code" : "24091000122100",
      "display" : "polen de maleza"
    },
    {
      "code" : "32201000122109",
      "display" : "polen de mercurial"
    },
    {
      "code" : "32221000122101",
      "display" : "polen de morera"
    },
    {
      "code" : "31851000122104",
      "display" : "polen de nogal"
    },
    {
      "code" : "10691000122106",
      "display" : "polen de olivo"
    },
    {
      "code" : "31731000122103",
      "display" : "polen de olmo"
    },
    {
      "code" : "22641000122106",
      "display" : "polen de ortiga"
    },
    {
      "code" : "6671000122109",
      "display" : "polen de parietaria"
    },
    {
      "code" : "22961000122100",
      "display" : "polen de pino"
    },
    {
      "code" : "11551000122108",
      "display" : "polen de plantago"
    },
    {
      "code" : "13081000122106",
      "display" : "polen de plátano de sombra"
    },
    {
      "code" : "31741000122106",
      "display" : "polen de roble"
    },
    {
      "code" : "72941000122100",
      "display" : "polen de sabina"
    },
    {
      "code" : "24821000122105",
      "display" : "polen de salsola"
    },
    {
      "code" : "32251000122108",
      "display" : "polen de salvia"
    },
    {
      "code" : "31751000122108",
      "display" : "polen de sauce"
    },
    {
      "code" : "31771000122100",
      "display" : "polen de sicomoro"
    },
    {
      "code" : "25031000122100",
      "display" : "polilla de la harina"
    },
    {
      "code" : "17731000122104",
      "display" : "polímeros del almidón"
    },
    {
      "code" : "294530006",
      "display" : "polimixina B"
    },
    {
      "code" : "294944007",
      "display" : "polistireno sulfonato cálcico"
    },
    {
      "code" : "294945008",
      "display" : "polistireno sulfonato sódico"
    },
    {
      "code" : "390952000",
      "display" : "polvo"
    },
    {
      "code" : "232349006",
      "display" : "polvo doméstico"
    },
    {
      "code" : "23191000122101",
      "display" : "pomelo"
    },
    {
      "code" : "294946009",
      "display" : "potasio"
    },
    {
      "code" : "294947000",
      "display" : "potasio administrado por vía oral"
    },
    {
      "code" : "294310006",
      "display" : "potasio tópico"
    },
    {
      "code" : "19931000122107",
      "display" : "povidona y sus derivados"
    },
    {
      "code" : "293981001",
      "display" : "practolol"
    },
    {
      "code" : "13661000122107",
      "display" : "prasugrel"
    },
    {
      "code" : "294973005",
      "display" : "pravastatina"
    },
    {
      "code" : "293991007",
      "display" : "prazosina"
    },
    {
      "code" : "294707002",
      "display" : "prednisolona"
    },
    {
      "code" : "294708007",
      "display" : "prednisolona tópica"
    },
    {
      "code" : "294682002",
      "display" : "prednisona"
    },
    {
      "code" : "293997006",
      "display" : "prenilamina"
    },
    {
      "code" : "294309001",
      "display" : "preparación para la remoción de cera auditiva"
    },
    {
      "code" : "294681009",
      "display" : "preparación tópica con hidrocortisona"
    },
    {
      "code" : "294402009",
      "display" : "preparaciones antiinfecciosas nasales"
    },
    {
      "code" : "294895005",
      "display" : "preparaciones con compuestos de hierro"
    },
    {
      "code" : "294185001",
      "display" : "preparaciones para camuflaje"
    },
    {
      "code" : "294710009",
      "display" : "preparaciones rectales con prednisolona"
    },
    {
      "code" : "294905004",
      "display" : "preparaciones suplementarias para alimentación parental"
    },
    {
      "code" : "294797008",
      "display" : "preparado de estrógeno y progestágeno"
    },
    {
      "code" : "294938008",
      "display" : "preparado de piridoxina"
    },
    {
      "code" : "294932009",
      "display" : "preparado de vitamina B12"
    },
    {
      "code" : "294164001",
      "display" : "preparado dermatológico tópico"
    },
    {
      "code" : "294161009",
      "display" : "preparados broncodilatadores"
    },
    {
      "code" : "294171006",
      "display" : "preparados de alquitrán mineral para el bańo"
    },
    {
      "code" : "294170007",
      "display" : "preparados de alquitrán mineral para el cuero cabelludo"
    },
    {
      "code" : "294921009",
      "display" : "preparados minerales y multivitamínicos"
    },
    {
      "code" : "294312003",
      "display" : "preparados orofaríngeos"
    },
    {
      "code" : "294391006",
      "display" : "primaquina"
    },
    {
      "code" : "293866006",
      "display" : "primidona"
    },
    {
      "code" : "294957004",
      "display" : "probucol"
    },
    {
      "code" : "293727006",
      "display" : "procaína"
    },
    {
      "code" : "293782002",
      "display" : "procarbazina"
    },
    {
      "code" : "22971000122105",
      "display" : "procesionaria del pino"
    },
    {
      "code" : "293940009",
      "display" : "proclorperazina"
    },
    {
      "code" : "32131000122107",
      "display" : "producida por insecto"
    },
    {
      "code" : "425525006",
      "display" : "producto lácteo"
    },
    {
      "code" : "294860007",
      "display" : "productos de factor VII activado"
    },
    {
      "code" : "294866001",
      "display" : "productos de factor XI"
    },
    {
      "code" : "294867005",
      "display" : "productos de factor XIII"
    },
    {
      "code" : "20381000122108",
      "display" : "leflunomida"
    },
    {
      "code" : "409136006",
      "display" : "legumbres"
    },
    {
      "code" : "23831000122105",
      "display" : "lenguado"
    },
    {
      "code" : "293736005",
      "display" : "lenograstim"
    },
    {
      "code" : "23871000122108",
      "display" : "lenteja"
    },
    {
      "code" : "18191000122100",
      "display" : "lercanidipino"
    },
    {
      "code" : "294821005",
      "display" : "leuprorelina"
    },
    {
      "code" : "860956003",
      "display" : "levadura"
    },
    {
      "code" : "293738006",
      "display" : "levamisol"
    },
    {
      "code" : "76161000122102",
      "display" : "levetiracetam"
    },
    {
      "code" : "293978006",
      "display" : "levobunolol"
    },
    {
      "code" : "19841000122107",
      "display" : "levobupivacaína"
    },
    {
      "code" : "293808009",
      "display" : "levodopa"
    },
    {
      "code" : "13181000122107",
      "display" : "levofloxacino"
    },
    {
      "code" : "293929001",
      "display" : "levomepromazina"
    },
    {
      "code" : "294754003",
      "display" : "levonorgestrel"
    },
    {
      "code" : "293609004",
      "display" : "levorfanol"
    },
    {
      "code" : "24061000122106",
      "display" : "lichi"
    },
    {
      "code" : "293722000",
      "display" : "lidocaína"
    },
    {
      "code" : "293995003",
      "display" : "lidoflazina"
    },
    {
      "code" : "23241000122101",
      "display" : "lima"
    },
    {
      "code" : "294586006",
      "display" : "limeciclina"
    },
    {
      "code" : "12901000122105",
      "display" : "limón"
    },
    {
      "code" : "294403004",
      "display" : "limpiadores y desinfectantes"
    },
    {
      "code" : "76461000122108",
      "display" : "linagliptina"
    },
    {
      "code" : "294562009",
      "display" : "lincomicina"
    },
    {
      "code" : "294560001",
      "display" : "lincomicina y sus derivados"
    },
    {
      "code" : "37031000122108",
      "display" : "lincosamidas"
    },
    {
      "code" : "294625003",
      "display" : "lindano"
    },
    {
      "code" : "1025071000122100",
      "display" : "linezolid"
    },
    {
      "code" : "294803007",
      "display" : "liotironina"
    },
    {
      "code" : "402596003",
      "display" : "liquen"
    },
    {
      "code" : "294301003",
      "display" : "líquido de hemodiálisis"
    },
    {
      "code" : "419081001",
      "display" : "líquido o solución farmacéutica"
    },
    {
      "code" : "19861000122106",
      "display" : "lisozima"
    },
    {
      "code" : "293813008",
      "display" : "lisurida"
    },
    {
      "code" : "294145007",
      "display" : "lodoxamida"
    },
    {
      "code" : "293825006",
      "display" : "lofepramina"
    },
    {
      "code" : "18381000122101",
      "display" : "lomefloxacino"
    },
    {
      "code" : "293756006",
      "display" : "lomustina"
    },
    {
      "code" : "293888006",
      "display" : "loprazolam"
    },
    {
      "code" : "293903001",
      "display" : "lorazepam"
    },
    {
      "code" : "293889003",
      "display" : "lormetazepam"
    },
    {
      "code" : "718536006",
      "display" : "lovastatina"
    },
    {
      "code" : "293915002",
      "display" : "loxapina"
    },
    {
      "code" : "294321002",
      "display" : "lubricantes"
    },
    {
      "code" : "24361000122108",
      "display" : "lúpulo"
    },
    {
      "code" : "402595004",
      "display" : "madera"
    },
    {
      "code" : "294579003",
      "display" : "mafenida"
    },
    {
      "code" : "294627006",
      "display" : "malatión"
    },
    {
      "code" : "23261000122102",
      "display" : "mandarina"
    },
    {
      "code" : "23881000122106",
      "display" : "mandioca"
    },
    {
      "code" : "36991000122108",
      "display" : "manidipino"
    },
    {
      "code" : "860604008",
      "display" : "manzana"
    },
    {
      "code" : "24381000122100",
      "display" : "manzanilla"
    },
    {
      "code" : "300913006",
      "display" : "marisco"
    },
    {
      "code" : "1082641000119100",
      "display" : "material de restauración dental existente"
    },
    {
      "code" : "293802005",
      "display" : "mazindol"
    },
    {
      "code" : "294458001",
      "display" : "mebendazol"
    },
    {
      "code" : "294119003",
      "display" : "mebhidrolina"
    },
    {
      "code" : "293898000",
      "display" : "medazepam"
    },
    {
      "code" : "294293006",
      "display" : "medicamentos homeopáticos"
    },
    {
      "code" : "293637006",
      "display" : "medio de contraste"
    },
    {
      "code" : "293639009",
      "display" : "medio de contraste para resonancia magnética"
    },
    {
      "code" : "17751000122109",
      "display" : "medios de contraste yodados"
    },
    {
      "code" : "294755002",
      "display" : "medroxiprogesterona"
    },
    {
      "code" : "295025007",
      "display" : "mefrusida"
    },
    {
      "code" : "294751006",
      "display" : "megestrol"
    },
    {
      "code" : "12921000122102",
      "display" : "mejillón"
    },
    {
      "code" : "293751001",
      "display" : "melfalán"
    },
    {
      "code" : "6631000122106",
      "display" : "melón"
    },
    {
      "code" : "76181000122105",
      "display" : "meloxicam"
    },
    {
      "code" : "294136006",
      "display" : "mepiramina"
    },
    {
      "code" : "293906009",
      "display" : "meprobamato"
    },
    {
      "code" : "294120009",
      "display" : "mequitazina"
    },
    {
      "code" : "36941000122101",
      "display" : "mercaptamina"
    },
    {
      "code" : "293772003",
      "display" : "mercaptopurina"
    },
    {
      "code" : "23911000122106",
      "display" : "merluza"
    },
    {
      "code" : "442022002",
      "display" : "meropenem"
    },
    {
      "code" : "295021003",
      "display" : "mersalil"
    },
    {
      "code" : "295067003",
      "display" : "mesilato de dihidroergotamina"
    },
    {
      "code" : "294774005",
      "display" : "mesterolona"
    },
    {
      "code" : "294792002",
      "display" : "mestranol"
    },
    {
      "code" : "20521000122101",
      "display" : "metacresol"
    },
    {
      "code" : "293594008",
      "display" : "metadona"
    },
    {
      "code" : "1155942004",
      "display" : "metal y compuesto metálico"
    },
    {
      "code" : "300915004",
      "display" : "metales"
    },
    {
      "code" : "702602008",
      "display" : "metamizol"
    },
    {
      "code" : "830172001",
      "display" : "metamizol"
    },
    {
      "code" : "294026001",
      "display" : "metaraminol"
    },
    {
      "code" : "830173006",
      "display" : "metenamina"
    },
    {
      "code" : "294740006",
      "display" : "metformina"
    },
    {
      "code" : "294503001",
      "display" : "meticilina"
    },
    {
      "code" : "294997001",
      "display" : "meticlotiazida"
    },
    {
      "code" : "294096007",
      "display" : "metilcisteína"
    },
    {
      "code" : "295057008",
      "display" : "metildigoxina"
    },
    {
      "code" : "294055009",
      "display" : "metildopa"
    },
    {
      "code" : "294056005",
      "display" : "metildopa y a los diuréticos"
    },
    {
      "code" : "293955000",
      "display" : "metilfenidato"
    },
    {
      "code" : "293864009",
      "display" : "metilfenobarbital"
    },
    {
      "code" : "294706006",
      "display" : "metilprednisolona"
    },
    {
      "code" : "294775006",
      "display" : "metiltestosterona"
    },
    {
      "code" : "293975009",
      "display" : "metipranolol"
    },
    {
      "code" : "293877000",
      "display" : "metiprilón"
    },
    {
      "code" : "295049005",
      "display" : "metirosina"
    },
    {
      "code" : "294083006",
      "display" : "metixeno"
    },
    {
      "code" : "294236001",
      "display" : "metocarbamol"
    },
    {
      "code" : "293675006",
      "display" : "metoclopramida"
    },
    {
      "code" : "293710003",
      "display" : "metohexital"
    },
    {
      "code" : "295026008",
      "display" : "metolazona"
    },
    {
      "code" : "293970004",
      "display" : "metoprolol"
    },
    {
      "code" : "293771005",
      "display" : "metotrexato"
    },
    {
      "code" : "294027005",
      "display" : "metoxamina"
    },
    {
      "code" : "294980007",
      "display" : "mexiletina"
    },
    {
      "code" : "294508005",
      "display" : "mezlocilina"
    },
    {
      "code" : "19831000122104",
      "display" : "micafungina"
    },
    {
      "code" : "294363003",
      "display" : "miconazol"
    },
    {
      "code" : "12911000122108",
      "display" : "miel"
    },
    {
      "code" : "294245000",
      "display" : "mifepristona"
    },
    {
      "code" : "295062009",
      "display" : "milrinona"
    },
    {
      "code" : "295071000",
      "display" : "minoxidil"
    },
    {
      "code" : "294221004",
      "display" : "miorrelajante"
    },
    {
      "code" : "294225008",
      "display" : "miorrelajante no despolarizante"
    },
    {
      "code" : "76321000122108",
      "display" : "mirabegrón"
    },
    {
      "code" : "76261000122107",
      "display" : "mirtazapina"
    },
    {
      "code" : "293648004",
      "display" : "misoprostol"
    },
    {
      "code" : "293741002",
      "display" : "mitobronitol"
    },
    {
      "code" : "293765004",
      "display" : "mitoxantrona"
    },
    {
      "code" : "1025261000122100",
      "display" : "mizolastina"
    },
    {
      "code" : "293840008",
      "display" : "moclobemida"
    },
    {
      "code" : "294334001",
      "display" : "modificador de la viscosidad derivado de la celulosa"
    },
    {
      "code" : "18361000122109",
      "display" : "moexipril"
    },
    {
      "code" : "419474003",
      "display" : "moho"
    },
    {
      "code" : "293735009",
      "display" : "molgramostim"
    },
    {
      "code" : "712842007",
      "display" : "molusco"
    },
    {
      "code" : "294701001",
      "display" : "mometasona"
    },
    {
      "code" : "295089004",
      "display" : "mononitrato de isosorbida"
    },
    {
      "code" : "295090008",
      "display" : "mononitrato de isosorbida de liberación modificada"
    },
    {
      "code" : "20141000122102",
      "display" : "montelukast"
    },
    {
      "code" : "23821000122107",
      "display" : "mora"
    },
    {
      "code" : "293601001",
      "display" : "morfina"
    },
    {
      "code" : "18411000122103",
      "display" : "moxifloxacino"
    },
    {
      "code" : "295102009",
      "display" : "moxisilita"
    },
    {
      "code" : "293753003",
      "display" : "mustina"
    },
    {
      "code" : "445395006",
      "display" : "Myroxylon pereirae"
    },
    {
      "code" : "23201000122103",
      "display" : "nabo"
    },
    {
      "code" : "293624008",
      "display" : "nabumetona"
    },
    {
      "code" : "76251000122105",
      "display" : "nadroparina"
    },
    {
      "code" : "294816007",
      "display" : "nafarelina"
    },
    {
      "code" : "295099009",
      "display" : "naftidrofurilo"
    },
    {
      "code" : "18171000122101",
      "display" : "nalmefeno"
    },
    {
      "code" : "294277002",
      "display" : "naloxona"
    },
    {
      "code" : "294761004",
      "display" : "nandrolona"
    },
    {
      "code" : "293625009",
      "display" : "naproxeno"
    },
    {
      "code" : "18221000122105",
      "display" : "naratriptán"
    },
    {
      "code" : "772021008",
      "display" : "nebivolol"
    },
    {
      "code" : "23841000122102",
      "display" : "nectarina"
    },
    {
      "code" : "293848001",
      "display" : "nefazodona"
    },
    {
      "code" : "293626005",
      "display" : "nefopam"
    },
    {
      "code" : "294017004",
      "display" : "neostigmina"
    },
    {
      "code" : "294465009",
      "display" : "netilmicina"
    },
    {
      "code" : "294935006",
      "display" : "niacinamida"
    },
    {
      "code" : "294453005",
      "display" : "niclosamida"
    },
    {
      "code" : "295096002",
      "display" : "nicofuranosa"
    },
    {
      "code" : "293993005",
      "display" : "nicotina"
    },
    {
      "code" : "295097006",
      "display" : "nicotinato de inositol"
    },
    {
      "code" : "18111000122108",
      "display" : "nilotinib"
    },
    {
      "code" : "37001000122102",
      "display" : "nilvadipino"
    },
    {
      "code" : "294569000",
      "display" : "nimorazol"
    },
    {
      "code" : "419788000",
      "display" : "níquel"
    },
    {
      "code" : "294099000",
      "display" : "niquetamida"
    },
    {
      "code" : "37011000122104",
      "display" : "nisoldipino"
    },
    {
      "code" : "23891000122109",
      "display" : "níspero"
    },
    {
      "code" : "294351008",
      "display" : "nistatina"
    },
    {
      "code" : "294204008",
      "display" : "nitrato de plata"
    },
    {
      "code" : "293890007",
      "display" : "nitrazepam"
    },
    {
      "code" : "37021000122105",
      "display" : "nitrendipino"
    },
    {
      "code" : "294266008",
      "display" : "nitrito de sodio"
    },
    {
      "code" : "294343005",
      "display" : "nitrofenol"
    },
    {
      "code" : "294481004",
      "display" : "nitrofural"
    },
    {
      "code" : "294478009",
      "display" : "nitrofurantoína"
    },
    {
      "code" : "294566007",
      "display" : "nitroimidazol"
    },
    {
      "code" : "773483009",
      "display" : "nitroprusiato"
    },
    {
      "code" : "295072007",
      "display" : "nitroprusiato de sodio"
    },
    {
      "code" : "293754009",
      "display" : "nitrosourea"
    },
    {
      "code" : "293652004",
      "display" : "nizatidina"
    },
    {
      "code" : "294247008",
      "display" : "nonoxinol"
    },
    {
      "code" : "294029008",
      "display" : "norepinefrina"
    },
    {
      "code" : "294752004",
      "display" : "noretisterona"
    },
    {
      "code" : "294490006",
      "display" : "norfloxacino"
    },
    {
      "code" : "293826007",
      "display" : "nortriptilina"
    },
    {
      "code" : "294152009",
      "display" : "noscapina"
    },
    {
      "code" : "294425005",
      "display" : "noxitiolina"
    },
    {
      "code" : "91940001",
      "display" : "nuez"
    },
    {
      "code" : "712844008",
      "display" : "nuez de macadamia"
    },
    {
      "code" : "20971000122106",
      "display" : "nuez de pacana"
    },
    {
      "code" : "23371000122100",
      "display" : "nuez de pecán"
    },
    {
      "code" : "23381000122102",
      "display" : "nuez del Brasil"
    },
    {
      "code" : "24391000122102",
      "display" : "nuez moscada"
    },
    {
      "code" : "294911001",
      "display" : "nutrición parenteral (ya mezclada)"
    },
    {
      "code" : "294826000",
      "display" : "octreotida"
    },
    {
      "code" : "294489002",
      "display" : "ofloxacino"
    },
    {
      "code" : "35061000122105",
      "display" : "olmesartán medoxomilo"
    },
    {
      "code" : "20441000122105",
      "display" : "olopatadina"
    },
    {
      "code" : "293655002",
      "display" : "omeprazol"
    },
    {
      "code" : "32371000122107",
      "display" : "opicapona"
    },
    {
      "code" : "294040000",
      "display" : "orciprenalina"
    },
    {
      "code" : "23921000122100",
      "display" : "orégano"
    },
    {
      "code" : "294084000",
      "display" : "orfenadrina"
    },
    {
      "code" : "21831000122106",
      "display" : "orlistat"
    },
    {
      "code" : "18621000122107",
      "display" : "ortiga"
    },
    {
      "code" : "295058003",
      "display" : "ouabaína"
    },
    {
      "code" : "24991000122101",
      "display" : "ovoalbúmina"
    },
    {
      "code" : "19801000122105",
      "display" : "oxacilina"
    },
    {
      "code" : "293899008",
      "display" : "oxazepam"
    },
    {
      "code" : "830174000",
      "display" : "oxedrina"
    },
    {
      "code" : "294088002",
      "display" : "oxibutinina"
    },
    {
      "code" : "18151000122109",
      "display" : "oxicodona"
    },
    {
      "code" : "24641000122101",
      "display" : "óxido de etileno"
    },
    {
      "code" : "293770006",
      "display" : "óxido mercúrico"
    },
    {
      "code" : "294063005",
      "display" : "oximetazolina"
    },
    {
      "code" : "294426006",
      "display" : "oximetileno"
    },
    {
      "code" : "293949005",
      "display" : "oxipertina"
    },
    {
      "code" : "860776004",
      "display" : "oxiquinolina"
    },
    {
      "code" : "294823008",
      "display" : "oxitocina"
    },
    {
      "code" : "294824002",
      "display" : "oxitocina y a la ergometrina"
    },
    {
      "code" : "20531000122103",
      "display" : "oxolamina"
    },
    {
      "code" : "293785000",
      "display" : "paclitaxel"
    },
    {
      "code" : "24171000122100",
      "display" : "palitos de sucedáneo de cangrejo"
    },
    {
      "code" : "294835007",
      "display" : "pamidronato disódico"
    },
    {
      "code" : "293659008",
      "display" : "pancreatina"
    },
    {
      "code" : "11861000122107",
      "display" : "pantoprazol"
    },
    {
      "code" : "419619007",
      "display" : "papa"
    },
    {
      "code" : "294242002",
      "display" : "papaverina"
    },
    {
      "code" : "23151000122105",
      "display" : "papaya"
    },
    {
      "code" : "293584003",
      "display" : "paracetamol"
    },
    {
      "code" : "297938000",
      "display" : "paracetamol y dextropropoxifeno"
    },
    {
      "code" : "294325006",
      "display" : "parafina blanda amarilla"
    },
    {
      "code" : "294327003",
      "display" : "parafina líquida"
    },
    {
      "code" : "23851000122100",
      "display" : "paraguaya"
    },
    {
      "code" : "294780002",
      "display" : "parche de testosterona"
    },
    {
      "code" : "295082008",
      "display" : "parental al trinitrato de glicerina"
    },
    {
      "code" : "24401000122100",
      "display" : "pargo"
    },
    {
      "code" : "293847006",
      "display" : "paroxetina"
    },
    {
      "code" : "18421000122109",
      "display" : "pefloxacino"
    },
    {
      "code" : "32521000122103",
      "display" : "pegaspargasa"
    },
    {
      "code" : "25071000122102",
      "display" : "pelo de cobaya"
    },
    {
      "code" : "22981000122108",
      "display" : "pelo de gato"
    },
    {
      "code" : "293954001",
      "display" : "pemolina"
    },
    {
      "code" : "293980000",
      "display" : "penbutolol"
    },
    {
      "code" : "91936005",
      "display" : "penicilina"
    },
    {
      "code" : "294494002",
      "display" : "penicilina benetamina"
    },
    {
      "code" : "294521003",
      "display" : "penicilina combinada"
    },
    {
      "code" : "294498004",
      "display" : "penicilina procaína"
    },
    {
      "code" : "56381000122105",
      "display" : "bromuro de emepronio"
    },
    {
      "code" : "56271000122100",
      "display" : "budesonida"
    },
    {
      "code" : "57151000122100",
      "display" : "budesonida tópica"
    },
    {
      "code" : "46341000122104",
      "display" : "bufexamaco"
    },
    {
      "code" : "52261000122106",
      "display" : "bumetanida"
    },
    {
      "code" : "41061000122106",
      "display" : "bupivacaína"
    },
    {
      "code" : "59311000122108",
      "display" : "buprenorfina"
    },
    {
      "code" : "44951000122107",
      "display" : "buserelina"
    },
    {
      "code" : "58941000122101",
      "display" : "buspirona"
    },
    {
      "code" : "43371000122102",
      "display" : "busulfano"
    },
    {
      "code" : "49801000122103",
      "display" : "butilbromuro de hioscina"
    },
    {
      "code" : "43491000122109",
      "display" : "butirofenona"
    },
    {
      "code" : "48911000122103",
      "display" : "butobarbital"
    },
    {
      "code" : "57011000122100",
      "display" : "butriptilina"
    },
    {
      "code" : "58301000122102",
      "display" : "caballa"
    },
    {
      "code" : "59161000122108",
      "display" : "cabergolina"
    },
    {
      "code" : "54851000122102",
      "display" : "cacahuete"
    },
    {
      "code" : "55661000122102",
      "display" : "cacao"
    },
    {
      "code" : "61521000122100",
      "display" : "café"
    },
    {
      "code" : "47501000122107",
      "display" : "cafeína"
    },
    {
      "code" : "61671000122100",
      "display" : "calabacín"
    },
    {
      "code" : "59591000122107",
      "display" : "calabaza"
    },
    {
      "code" : "40821000122100",
      "display" : "calamar"
    },
    {
      "code" : "56651000122106",
      "display" : "calamina"
    },
    {
      "code" : "41661000122102",
      "display" : "calcipotriol"
    },
    {
      "code" : "40611000122105",
      "display" : "calcitonina porcina"
    },
    {
      "code" : "69215007",
      "display" : "calor"
    },
    {
      "code" : "56961000122103",
      "display" : "camarones"
    },
    {
      "code" : "54351000122105",
      "display" : "canela"
    },
    {
      "code" : "54841000122104",
      "display" : "cangrejo de mar"
    },
    {
      "code" : "52291000122100",
      "display" : "cannabis"
    },
    {
      "code" : "54371000122102",
      "display" : "canrenoato de potasio"
    },
    {
      "code" : "61831000122104",
      "display" : "cantárida"
    },
    {
      "code" : "51261000122102",
      "display" : "capreomicina"
    },
    {
      "code" : "54341000122108",
      "display" : "caqui"
    },
    {
      "code" : "48401000122107",
      "display" : "carambola"
    },
    {
      "code" : "49941000122109",
      "display" : "carbamazepina"
    },
    {
      "code" : "43041000122106",
      "display" : "carbapenem"
    },
    {
      "code" : "60981000122101",
      "display" : "carbazocromo"
    },
    {
      "code" : "55401000122100",
      "display" : "carbenicilina"
    },
    {
      "code" : "46251000122106",
      "display" : "carbimazol"
    },
    {
      "code" : "48241000122108",
      "display" : "carbocisteína"
    },
    {
      "code" : "55961000122107",
      "display" : "carbómero 940"
    },
    {
      "code" : "55771000122104",
      "display" : "carbonato de litio"
    },
    {
      "code" : "56681000122100",
      "display" : "carboplatino"
    },
    {
      "code" : "53101000122105",
      "display" : "cardamomo"
    },
    {
      "code" : "61681000122102",
      "display" : "cardo"
    },
    {
      "code" : "49921000122104",
      "display" : "carisoprodol"
    },
    {
      "code" : "44011000122105",
      "display" : "carmelosa"
    },
    {
      "code" : "59991000122104",
      "display" : "carne"
    },
    {
      "code" : "59131000122101",
      "display" : "carne de bovino"
    },
    {
      "code" : "43861000122100",
      "display" : "carne de cerdo"
    },
    {
      "code" : "42081000122106",
      "display" : "carne de conejo"
    },
    {
      "code" : "52951000122101",
      "display" : "carne de pavo"
    },
    {
      "code" : "50091000122107",
      "display" : "carne de pollo"
    },
    {
      "code" : "57601000122105",
      "display" : "carne roja"
    },
    {
      "code" : "50441000122109",
      "display" : "carne vacuna"
    },
    {
      "code" : "50871000122101",
      "display" : "carpa"
    },
    {
      "code" : "44631000122106",
      "display" : "carvedilol"
    },
    {
      "code" : "53691000122109",
      "display" : "cáscara sagrada"
    },
    {
      "code" : "53971000122103",
      "display" : "caspa de animal"
    },
    {
      "code" : "52651000122107",
      "display" : "caspa de animales de laboratorio"
    },
    {
      "code" : "59981000122102",
      "display" : "caspa de cobayo"
    },
    {
      "code" : "58341000122100",
      "display" : "caspa de gato"
    },
    {
      "code" : "60011000122105",
      "display" : "caspa de vaca"
    },
    {
      "code" : "59371000122101",
      "display" : "castańas"
    },
    {
      "code" : "58011000122101",
      "display" : "cebada"
    },
    {
      "code" : "62101000122107",
      "display" : "cebo de pesca"
    },
    {
      "code" : "52201000122105",
      "display" : "cefaclor"
    },
    {
      "code" : "40541000122108",
      "display" : "cefadroxilo"
    },
    {
      "code" : "40101000122101",
      "display" : "cefalosporina de segunda generación"
    },
    {
      "code" : "47111000122104",
      "display" : "cefalosporina de tercera generación"
    },
    {
      "code" : "48051000122103",
      "display" : "cefalosporinas de cuarta generación"
    },
    {
      "code" : "53361000122109",
      "display" : "cefalosporinas de primera generación"
    },
    {
      "code" : "51791000122100",
      "display" : "cefamandol"
    },
    {
      "code" : "40231000122103",
      "display" : "cefamicina"
    },
    {
      "code" : "47351000122100",
      "display" : "cefazolina"
    },
    {
      "code" : "60781000122103",
      "display" : "cefepima"
    },
    {
      "code" : "59611000122103",
      "display" : "cefodizima"
    },
    {
      "code" : "51481000122109",
      "display" : "cefotaxima"
    },
    {
      "code" : "52351000122100",
      "display" : "cefotiam"
    },
    {
      "code" : "57811000122109",
      "display" : "cefoxitina"
    },
    {
      "code" : "40011000122102",
      "display" : "cefpiroma"
    },
    {
      "code" : "58501000122105",
      "display" : "cefpodoxima"
    },
    {
      "code" : "47861000122105",
      "display" : "cefradina"
    },
    {
      "code" : "45101000122107",
      "display" : "cefsulodina"
    },
    {
      "code" : "46581000122102",
      "display" : "ceftazidima"
    },
    {
      "code" : "56521000122103",
      "display" : "ceftibuteno"
    },
    {
      "code" : "54241000122103",
      "display" : "ceftizoxima"
    },
    {
      "code" : "47361000122103",
      "display" : "ceftriaxona"
    },
    {
      "code" : "52411000122109",
      "display" : "cefuroxima"
    },
    {
      "code" : "44221000122106",
      "display" : "celiprolol"
    },
    {
      "code" : "52511000122105",
      "display" : "centeno"
    },
    {
      "code" : "56571000122102",
      "display" : "cereal"
    },
    {
      "code" : "54251000122101",
      "display" : "cereal con gluten"
    },
    {
      "code" : "46211000122105",
      "display" : "cereza"
    },
    {
      "code" : "53711000122107",
      "display" : "ceritinib"
    },
    {
      "code" : "60121000122103",
      "display" : "cerivastatina"
    },
    {
      "code" : "61861000122106",
      "display" : "cerveza"
    },
    {
      "code" : "55711000122106",
      "display" : "cetilpiridinio"
    },
    {
      "code" : "53621000122107",
      "display" : "cetirizina"
    },
    {
      "code" : "46461000122109",
      "display" : "cetrimida"
    },
    {
      "code" : "62111000122105",
      "display" : "chinche del grano"
    },
    {
      "code" : "48771000122108",
      "display" : "chirimoya"
    },
    {
      "code" : "50701000122104",
      "display" : "chirivía"
    },
    {
      "code" : "49291000122107",
      "display" : "chocolate"
    },
    {
      "code" : "49441000122104",
      "display" : "chufa"
    },
    {
      "code" : "44981000122101",
      "display" : "cianocobalamina"
    },
    {
      "code" : "42121000122108",
      "display" : "ciclacilina"
    },
    {
      "code" : "61081000122109",
      "display" : "cicletanina"
    },
    {
      "code" : "42771000122105",
      "display" : "ciclizina"
    },
    {
      "code" : "42451000122108",
      "display" : "ciclofenilo"
    },
    {
      "code" : "45411000122100",
      "display" : "ciclofosfamida"
    },
    {
      "code" : "53171000122101",
      "display" : "ciclopentolato"
    },
    {
      "code" : "53481000122108",
      "display" : "cicloserina"
    },
    {
      "code" : "52471000122102",
      "display" : "ciclosporina"
    },
    {
      "code" : "42791000122106",
      "display" : "cimetidina"
    },
    {
      "code" : "40761000122101",
      "display" : "cinarizina"
    },
    {
      "code" : "57491000122103",
      "display" : "cincocaína"
    },
    {
      "code" : "56721000122105",
      "display" : "ciprofibrato"
    },
    {
      "code" : "47911000122102",
      "display" : "ciprofloxacino"
    },
    {
      "code" : "42651000122105",
      "display" : "ciproterona"
    },
    {
      "code" : "53421000122109",
      "display" : "ciruela"
    },
    {
      "code" : "44621000122108",
      "display" : "cisaprida"
    },
    {
      "code" : "42581000122103",
      "display" : "cisplatino"
    },
    {
      "code" : "45181000122100",
      "display" : "citalopram"
    },
    {
      "code" : "59811000122102",
      "display" : "citrato"
    },
    {
      "code" : "40041000122103",
      "display" : "citrato de litio"
    },
    {
      "code" : "45581000122109",
      "display" : "clara de huevo"
    },
    {
      "code" : "52841000122106",
      "display" : "claritromicina"
    },
    {
      "code" : "55121000122101",
      "display" : "clemastina"
    },
    {
      "code" : "47421000122103",
      "display" : "clindamicina"
    },
    {
      "code" : "45231000122105",
      "display" : "clobazam"
    },
    {
      "code" : "47011000122103",
      "display" : "clobetasol"
    },
    {
      "code" : "43241000122103",
      "display" : "clodronato de sodio"
    },
    {
      "code" : "40941000122102",
      "display" : "clofazimina"
    },
    {
      "code" : "58431000122103",
      "display" : "clomifeno"
    },
    {
      "code" : "40251000122108",
      "display" : "clomipramina"
    },
    {
      "code" : "41501000122104",
      "display" : "clonazepam"
    },
    {
      "code" : "42941000122101",
      "display" : "clonidina"
    },
    {
      "code" : "60951000122107",
      "display" : "cloperastina"
    },
    {
      "code" : "42621000122103",
      "display" : "clorambucilo"
    },
    {
      "code" : "57401000122108",
      "display" : "cloranfenicol"
    },
    {
      "code" : "44341000122106",
      "display" : "clordiazepóxido"
    },
    {
      "code" : "47451000122105",
      "display" : "clorfenamina"
    },
    {
      "code" : "57001000122103",
      "display" : "clorhidrato de bromhexina"
    },
    {
      "code" : "56351000122104",
      "display" : "clorhidrato de clorhexidina y a sulfato de neomicina"
    },
    {
      "code" : "46741000122103",
      "display" : "clorhidrato de fenilpropanolamina"
    },
    {
      "code" : "54611000122104",
      "display" : "clorhidrato de meclozina"
    },
    {
      "code" : "41391000122102",
      "display" : "clorhidrato de orfenadrina"
    },
    {
      "code" : "54421000122107",
      "display" : "clorhidrato de terodilina"
    },
    {
      "code" : "41461000122104",
      "display" : "clorhidrato de tetraciclina"
    },
    {
      "code" : "46971000122106",
      "display" : "clormetiazol"
    },
    {
      "code" : "55071000122101",
      "display" : "clorobutanol"
    },
    {
      "code" : "54401000122104",
      "display" : "cloroprocaína"
    },
    {
      "code" : "49641000122102",
      "display" : "clorotiazida"
    },
    {
      "code" : "52921000122108",
      "display" : "cloroxilenol"
    },
    {
      "code" : "294718002",
      "display" : "suspensión de insulina cinc (amorfa)"
    },
    {
      "code" : "294719005",
      "display" : "suspensión de insulina cinc (cristalina)"
    },
    {
      "code" : "419199007",
      "display" : "sustancia"
    },
    {
      "code" : "294197000",
      "display" : "sustancia astringente"
    },
    {
      "code" : "294198005",
      "display" : "sustancia astringente de aluminio"
    },
    {
      "code" : "8041000122105",
      "display" : "sustancia de origen animal no alimentaria"
    },
    {
      "code" : "21801000122100",
      "display" : "sustancia plástica"
    },
    {
      "code" : "294193001",
      "display" : "sustancias emolientes"
    },
    {
      "code" : "294846005",
      "display" : "sustitutos plasmáticos"
    },
    {
      "code" : "294224007",
      "display" : "suxametonio"
    },
    {
      "code" : "17781000122103",
      "display" : "suximidas"
    },
    {
      "code" : "22891000122100",
      "display" : "tadalafilo"
    },
    {
      "code" : "37601000122109",
      "display" : "tafamidis"
    },
    {
      "code" : "294512004",
      "display" : "talampicilina"
    },
    {
      "code" : "293790002",
      "display" : "tamoxifeno"
    },
    {
      "code" : "1025211000122100",
      "display" : "tamsulosina"
    },
    {
      "code" : "1025151000122100",
      "display" : "tapentadol"
    },
    {
      "code" : "294025002",
      "display" : "tartrato de oxedrina"
    },
    {
      "code" : "76241000122108",
      "display" : "tartrazina"
    },
    {
      "code" : "17861000122103",
      "display" : "tazobactam"
    },
    {
      "code" : "24181000122102",
      "display" : "té"
    },
    {
      "code" : "37611000122107",
      "display" : "tedizolida"
    },
    {
      "code" : "21821000122108",
      "display" : "tegaserod"
    },
    {
      "code" : "294476008",
      "display" : "teicoplanina"
    },
    {
      "code" : "35051000122108",
      "display" : "telmisartán"
    },
    {
      "code" : "37621000122101",
      "display" : "telotristat"
    },
    {
      "code" : "294491005",
      "display" : "temafloxacino"
    },
    {
      "code" : "293904007",
      "display" : "temazepam"
    },
    {
      "code" : "294514003",
      "display" : "temocilina"
    },
    {
      "code" : "293631007",
      "display" : "tenoxicam"
    },
    {
      "code" : "294160005",
      "display" : "teofilina"
    },
    {
      "code" : "293992000",
      "display" : "terazosina"
    },
    {
      "code" : "294342000",
      "display" : "terbinafina"
    },
    {
      "code" : "294112007",
      "display" : "terfenadina"
    },
    {
      "code" : "473077006",
      "display" : "teriparatida"
    },
    {
      "code" : "830178002",
      "display" : "terodilina"
    },
    {
      "code" : "19701000122104",
      "display" : "tertatolol"
    },
    {
      "code" : "294776007",
      "display" : "testosterona"
    },
    {
      "code" : "294778008",
      "display" : "testosterona intramuscular"
    },
    {
      "code" : "293918000",
      "display" : "tetrabenazina"
    },
    {
      "code" : "293725003",
      "display" : "tetracaína"
    },
    {
      "code" : "294583003",
      "display" : "tetraciclinas"
    },
    {
      "code" : "294813004",
      "display" : "tetracosactrina"
    },
    {
      "code" : "295091007",
      "display" : "tetranitrato de pentaeritritilo"
    },
    {
      "code" : "19741000122102",
      "display" : "tetrizolina"
    },
    {
      "code" : "19611000122107",
      "display" : "tiagabina"
    },
    {
      "code" : "76291000122101",
      "display" : "tiamazol"
    },
    {
      "code" : "37631000122103",
      "display" : "tianfenicol"
    },
    {
      "code" : "439954005",
      "display" : "tiazolidinadiona"
    },
    {
      "code" : "294758000",
      "display" : "tibolona"
    },
    {
      "code" : "294527004",
      "display" : "ticarcilina y ácido clavulánico"
    },
    {
      "code" : "37641000122106",
      "display" : "tiemonio"
    },
    {
      "code" : "17891000122109",
      "display" : "tilo"
    },
    {
      "code" : "294093004",
      "display" : "tiloxapol"
    },
    {
      "code" : "294413007",
      "display" : "timol"
    },
    {
      "code" : "293984009",
      "display" : "timolol"
    },
    {
      "code" : "294444003",
      "display" : "tintura desinfectante"
    },
    {
      "code" : "294358002",
      "display" : "tioconazol"
    },
    {
      "code" : "293773008",
      "display" : "tioguanina"
    },
    {
      "code" : "293709008",
      "display" : "tiopental"
    },
    {
      "code" : "293938004",
      "display" : "tioridazina"
    },
    {
      "code" : "19851000122109",
      "display" : "tiotropio"
    },
    {
      "code" : "293942001",
      "display" : "tioxanteno"
    },
    {
      "code" : "20111000122101",
      "display" : "tirofibán"
    },
    {
      "code" : "294804001",
      "display" : "tiroxina"
    },
    {
      "code" : "76171000122107",
      "display" : "tizanidina"
    },
    {
      "code" : "294984003",
      "display" : "tocainida"
    },
    {
      "code" : "18101000122105",
      "display" : "tofacitinib"
    },
    {
      "code" : "294738001",
      "display" : "tolbutamida"
    },
    {
      "code" : "294344004",
      "display" : "tolnaftato"
    },
    {
      "code" : "418779002",
      "display" : "tomate"
    },
    {
      "code" : "76271000122102",
      "display" : "topiramato"
    },
    {
      "code" : "15951000122100",
      "display" : "topotecán"
    },
    {
      "code" : "37651000122108",
      "display" : "toremifeno"
    },
    {
      "code" : "294667007",
      "display" : "toxina de Clostridium botulinum"
    },
    {
      "code" : "18081000122104",
      "display" : "trametinib"
    },
    {
      "code" : "293839006",
      "display" : "tranilcipromina"
    },
    {
      "code" : "295083003",
      "display" : "transdérmica a la nitroglicerina"
    },
    {
      "code" : "15931000122105",
      "display" : "trastuzumab"
    },
    {
      "code" : "293855004",
      "display" : "trazodona"
    },
    {
      "code" : "293743004",
      "display" : "treosulfano"
    },
    {
      "code" : "19821000122102",
      "display" : "treprostinilo"
    },
    {
      "code" : "294711008",
      "display" : "triamcinolona"
    },
    {
      "code" : "295006009",
      "display" : "triamtereno"
    },
    {
      "code" : "295016001",
      "display" : "triamtereno y a diurético de asa"
    },
    {
      "code" : "295017005",
      "display" : "triamtereno y a diurético tiazídico"
    },
    {
      "code" : "860773007",
      "display" : "triazeno"
    },
    {
      "code" : "860764004",
      "display" : "triazol"
    },
    {
      "code" : "293891006",
      "display" : "triazolam"
    },
    {
      "code" : "293910007",
      "display" : "triclofós sódico"
    },
    {
      "code" : "293716009",
      "display" : "tricloroetileno"
    },
    {
      "code" : "294417008",
      "display" : "triclosán"
    },
    {
      "code" : "294290009",
      "display" : "trientina"
    },
    {
      "code" : "293941008",
      "display" : "trifluoperazina"
    },
    {
      "code" : "294381000",
      "display" : "trifluorotimidina"
    },
    {
      "code" : "293921003",
      "display" : "trifluperidol"
    },
    {
      "code" : "420174000",
      "display" : "trigo"
    },
    {
      "code" : "294077008",
      "display" : "trihexifenidilo"
    },
    {
      "code" : "293789006",
      "display" : "trilostano"
    },
    {
      "code" : "20001000122103",
      "display" : "trimebutina"
    },
    {
      "code" : "295048002",
      "display" : "trimetafán"
    },
    {
      "code" : "294477004",
      "display" : "trimetoprima"
    },
    {
      "code" : "37051000122103",
      "display" : "trimetrexato glucuronato"
    },
    {
      "code" : "293827003",
      "display" : "trimipramina"
    },
    {
      "code" : "295079003",
      "display" : "trinitrato de glicerilo"
    },
    {
      "code" : "295081001",
      "display" : "trinitrato de glicerilo de liberación modificada"
    },
    {
      "code" : "295080000",
      "display" : "trinitrato de glicerilo oral"
    },
    {
      "code" : "294139004",
      "display" : "triprolidina"
    },
    {
      "code" : "293842000",
      "display" : "triptófano"
    },
    {
      "code" : "294819000",
      "display" : "triptorelina"
    },
    {
      "code" : "293665008",
      "display" : "trisilicato de magnesio"
    },
    {
      "code" : "19971000122105",
      "display" : "trolamina"
    },
    {
      "code" : "294073007",
      "display" : "tropicamida"
    },
    {
      "code" : "23971000122104",
      "display" : "trucha"
    },
    {
      "code" : "294045005",
      "display" : "tulobuterol"
    },
    {
      "code" : "294354000",
      "display" : "undecenoato"
    },
    {
      "code" : "18301000122108",
      "display" : "urapidil"
    },
    {
      "code" : "767473007",
      "display" : "urea"
    },
    {
      "code" : "23901000122108",
      "display" : "uva"
    },
    {
      "code" : "293640006",
      "display" : "vacuna antialérgica"
    },
    {
      "code" : "294661008",
      "display" : "vacuna antitifoidea de célula entera"
    },
    {
      "code" : "294662001",
      "display" : "vacuna contra sarampión, paperas y rubéola"
    },
    {
      "code" : "294643004",
      "display" : "vacuna de antígeno diftérico aislado"
    },
    {
      "code" : "294401002",
      "display" : "vacuna de lactobacilo acidófilo"
    },
    {
      "code" : "294660009",
      "display" : "vacuna de polisacárido de Salmonella typhi"
    },
    {
      "code" : "294665004",
      "display" : "vacuna de polisacárido meningocócico"
    },
    {
      "code" : "22231000122100",
      "display" : "vacuna frente a la encefalitis por virus transmitido por garrapatas"
    },
    {
      "code" : "22091000122107",
      "display" : "vacuna frente a la fiebre amarilla"
    },
    {
      "code" : "22181000122105",
      "display" : "vacuna frente a la hepatitis A y B"
    },
    {
      "code" : "22131000122109",
      "display" : "vacuna frente a la tuberculosis"
    },
    {
      "code" : "22081000122109",
      "display" : "vacuna frente al cólera"
    },
    {
      "code" : "22161000122102",
      "display" : "vacuna frente al meningococo B"
    },
    {
      "code" : "22101000122103",
      "display" : "vacuna frente al sarampión"
    },
    {
      "code" : "22071000122106",
      "display" : "vacuna frente al virus de la encefalitis japonesa"
    },
    {
      "code" : "22251000122105",
      "display" : "vacuna frente al virus del papiloma humano"
    },
    {
      "code" : "22271000122102",
      "display" : "vacuna frente al virus del papiloma humano del tipo 16, 18"
    },
    {
      "code" : "22261000122107",
      "display" : "vacuna frente al virus del papiloma humano del tipo 6, 11, 16, 18"
    },
    {
      "code" : "294640001",
      "display" : "vacunas"
    },
    {
      "code" : "294631000",
      "display" : "vacunas, inmunoglobulinas y antisueros"
    },
    {
      "code" : "23981000122101",
      "display" : "vainilla"
    },
    {
      "code" : "293862008",
      "display" : "valproato sódico"
    },
    {
      "code" : "294475007",
      "display" : "vancomicina"
    },
    {
      "code" : "294421001",
      "display" : "vapor industrial metilado"
    },
    {
      "code" : "13711000122103",
      "display" : "vardenafilo"
    },
    {
      "code" : "295092000",
      "display" : "vasodilatador cerebral/periférico"
    },
    {
      "code" : "295078006",
      "display" : "vasodilatador de nitrato"
    },
    {
      "code" : "21161000122108",
      "display" : "vegetal"
    },
    {
      "code" : "419238009",
      "display" : "vendaje adhesivo"
    },
    {
      "code" : "424213003",
      "display" : "veneno de abeja"
    },
    {
      "code" : "427487000",
      "display" : "veneno de arácnido"
    },
    {
      "code" : "423058007",
      "display" : "veneno de avispa"
    },
    {
      "code" : "23341000122106",
      "display" : "veneno de avispón"
    },
    {
      "code" : "422921000",
      "display" : "veneno de escorpión"
    },
    {
      "code" : "16067291000119100",
      "display" : "veneno de himenóptero"
    },
    {
      "code" : "151201000119107",
      "display" : "veneno de insecto"
    },
    {
      "code" : "294005001",
      "display" : "verapamilo"
    },
    {
      "code" : "21791000122101",
      "display" : "verteporfina"
    },
    {
      "code" : "294383002",
      "display" : "vidarabina"
    },
    {
      "code" : "293856003",
      "display" : "viloxazina"
    },
    {
      "code" : "293793000",
      "display" : "vinblastina"
    },
    {
      "code" : "293795007",
      "display" : "vindesina"
    },
    {
      "code" : "24021000122102",
      "display" : "vino"
    },
    {
      "code" : "19631000122103",
      "display" : "vinorelbina"
    },
    {
      "code" : "294447005",
      "display" : "violeta cristal"
    },
    {
      "code" : "294923007",
      "display" : "vitamina A"
    },
    {
      "code" : "767475000",
      "display" : "vitamina B12 y derivado de vitamina B12"
    },
    {
      "code" : "294924001",
      "display" : "vitamina D y derivado de vitamina D"
    },
    {
      "code" : "294928003",
      "display" : "vitamina del grupo B"
    },
    {
      "code" : "294927008",
      "display" : "vitamina hidrosoluble"
    },
    {
      "code" : "294925000",
      "display" : "vitamina K y derivado de vitamina K"
    },
    {
      "code" : "294922002",
      "display" : "vitamina liposoluble"
    },
    {
      "code" : "76401000122107",
      "display" : "vortioxetina"
    },
    {
      "code" : "294881007",
      "display" : "warfarina"
    },
    {
      "code" : "294064004",
      "display" : "xamoterol"
    },
    {
      "code" : "294157003",
      "display" : "xantina"
    },
    {
      "code" : "294031004",
      "display" : "xilometazolina"
    },
    {
      "code" : "295027004",
      "display" : "xipamida"
    },
    {
      "code" : "12881000122108",
      "display" : "yema de huevo"
    },
    {
      "code" : "294915005",
      "display" : "yodóforo"
    },
    {
      "code" : "294916006",
      "display" : "yodopovidona"
    },
    {
      "code" : "294373001",
      "display" : "zalcitabina"
    },
    {
      "code" : "420080006",
      "display" : "zanahoria"
    },
    {
      "code" : "24571000122108",
      "display" : "zarzamora"
    },
    {
      "code" : "18501000122100",
      "display" : "ziconotida"
    },
    {
      "code" : "294369004",
      "display" : "zidovudina"
    },
    {
      "code" : "294311005",
      "display" : "zinc tópico"
    },
    {
      "code" : "20041000122101",
      "display" : "ziprasidona"
    },
    {
      "code" : "35221000122108",
      "display" : "zofenopril"
    },
    {
      "code" : "76131000122109",
      "display" : "zolmitriptán"
    },
    {
      "code" : "293875008",
      "display" : "zolpidem"
    },
    {
      "code" : "76191000122108",
      "display" : "zonisamida"
    },
    {
      "code" : "293874007",
      "display" : "zopiclona"
    },
    {
      "code" : "418314004",
      "display" : "zumo de manzana"
    },
    {
      "code" : "49591000122105",
      "display" : "4-quinolonas"
    },
    {
      "code" : "61001000122102",
      "display" : "acamprosato"
    },
    {
      "code" : "48171000122107",
      "display" : "acarbosa"
    },
    {
      "code" : "61761000122103",
      "display" : "ácaro Blomia tropicalis"
    },
    {
      "code" : "61931000122107",
      "display" : "ácaro Chortoglyphus"
    },
    {
      "code" : "61951000122102",
      "display" : "ácaro Lepidoglyphus"
    },
    {
      "code" : "61961000122100",
      "display" : "ácaro Tyrophagus putrescentiae"
    },
    {
      "code" : "53401000122101",
      "display" : "ácaros del polvo"
    },
    {
      "code" : "42461000122105",
      "display" : "acebutolol"
    },
    {
      "code" : "41761000122109",
      "display" : "aceclofenaco"
    },
    {
      "code" : "58611000122109",
      "display" : "aceite de cacahuete"
    },
    {
      "code" : "40651000122106",
      "display" : "aceite de coco"
    },
    {
      "code" : "51581000122108",
      "display" : "aceite de oliva"
    },
    {
      "code" : "42831000122101",
      "display" : "aceite de ricino"
    },
    {
      "code" : "57281000122100",
      "display" : "aceites de pescado"
    },
    {
      "code" : "49421000122109",
      "display" : "acelga"
    },
    {
      "code" : "51031000122101",
      "display" : "acetato de ciproterona y a etinilestradiol"
    },
    {
      "code" : "42231000122102",
      "display" : "acetazolamida"
    },
    {
      "code" : "45201000122104",
      "display" : "acetohexamida"
    },
    {
      "code" : "59691000122106",
      "display" : "aciclovir"
    },
    {
      "code" : "61101000122103",
      "display" : "ácido alendrónico"
    },
    {
      "code" : "61031000122108",
      "display" : "ácido aminolevulínico"
    },
    {
      "code" : "48811000122108",
      "display" : "ácido ascórbico"
    },
    {
      "code" : "45831000122106",
      "display" : "ácido biliar"
    },
    {
      "code" : "43981000122103",
      "display" : "ácido bórico"
    },
    {
      "code" : "52551000122106",
      "display" : "ácido cromoglícico"
    },
    {
      "code" : "53991000122102",
      "display" : "ácido dehidrocólico"
    },
    {
      "code" : "49681000122106",
      "display" : "ácido etacrínico"
    },
    {
      "code" : "61131000122109",
      "display" : "ácido etidrónico"
    },
    {
      "code" : "40371000122107",
      "display" : "ácido fólico"
    },
    {
      "code" : "56741000122100",
      "display" : "ácido fusídico"
    },
    {
      "code" : "54591000122108",
      "display" : "ácido gamolénico"
    },
    {
      "code" : "52671000122104",
      "display" : "ácido mandélico"
    },
    {
      "code" : "41231000122107",
      "display" : "ácido mefenámico"
    },
    {
      "code" : "53111000122108",
      "display" : "ácido nalidíxico"
    },
    {
      "code" : "46861000122107",
      "display" : "ácido nicotínico"
    },
    {
      "code" : "60471000122106",
      "display" : "ácido pamidrónico"
    },
    {
      "code" : "53331000122102",
      "display" : "ácido paraminobenzoico y sus derivados"
    },
    {
      "code" : "46521000122101",
      "display" : "ácido quenodesoxicólico"
    },
    {
      "code" : "41901000122106",
      "display" : "ácido salicílico tópico"
    },
    {
      "code" : "40711000122104",
      "display" : "ácido tiaprofénico"
    },
    {
      "code" : "61121000122106",
      "display" : "ácido tiludrónico"
    },
    {
      "code" : "46691000122100",
      "display" : "ácido ursodesoxicólico"
    },
    {
      "code" : "60461000122101",
      "display" : "ácido valproico y derivados"
    },
    {
      "code" : "40781000122109",
      "display" : "ácidos quenodesoxicólico y ursodesoxicólico"
    },
    {
      "code" : "55441000122103",
      "display" : "acipimox"
    },
    {
      "code" : "47811000122107",
      "display" : "acitretina"
    },
    {
      "code" : "48871000122101",
      "display" : "aclarubicina"
    },
    {
      "code" : "47121000122105",
      "display" : "acrivastina"
    },
    {
      "code" : "42061000122103",
      "display" : "acrosoxacina"
    },
    {
      "code" : "77427003",
      "display" : "actividad"
    },
    {
      "code" : "52381000122106",
      "display" : "adenosina"
    },
    {
      "code" : "59911000122107",
      "display" : "adhesivo"
    },
    {
      "code" : "51311000122107",
      "display" : "adhesivo tisular de uso quirúrgico"
    },
    {
      "code" : "60821000122107",
      "display" : "adifenina"
    },
    {
      "code" : "54331000122100",
      "display" : "aditivo alimentario"
    },
    {
      "code" : "413427002",
      "display" : "adquirida a la fructosa"
    },
    {
      "code" : "60414003",
      "display" : "adquirida a la lactosa"
    },
    {
      "code" : "58891000122102",
      "display" : "aerosol de trinitrato de glicerilo"
    },
    {
      "code" : "44511000122103",
      "display" : "afatinib"
    },
    {
      "code" : "44681000122107",
      "display" : "agente abrasivo tópico"
    },
    {
      "code" : "41271000122105",
      "display" : "agente antiinfeccioso"
    },
    {
      "code" : "46751000122101",
      "display" : "agente antimicobacteriano"
    },
    {
      "code" : "56951000122100",
      "display" : "agente antimigrańoso"
    },
    {
      "code" : "23561000122100",
      "display" : "agente antinflamatorio no esteroideo"
    },
    {
      "code" : "60351000122108",
      "display" : "agente antiplaquetario"
    },
    {
      "code" : "58021000122107",
      "display" : "agente antitiroideo derivado de la tiourea"
    },
    {
      "code" : "54301000122106",
      "display" : "agente antitiroideo derivado de tiouracilo"
    },
    {
      "code" : "48711000122101",
      "display" : "agente antivaricoso"
    },
    {
      "code" : "45781000122104",
      "display" : "agente biliar"
    },
    {
      "code" : "41171000122100",
      "display" : "agente biocida"
    },
    {
      "code" : "59881000122107",
      "display" : "agente biocida en productos cosméticos"
    },
    {
      "code" : "59071000122104",
      "display" : "agente bloqueante adrenérgico de los receptores neuronales"
    },
    {
      "code" : "55861000122101",
      "display" : "agente diagnóstico"
    },
    {
      "code" : "40771000122106",
      "display" : "agente inotrópico cardíaco"
    },
    {
      "code" : "50621000122101",
      "display" : "agente regulador del calcio"
    },
    {
      "code" : "58931000122109",
      "display" : "agente saborizante alimentario"
    },
    {
      "code" : "54191000122103",
      "display" : "agente tiroideo"
    },
    {
      "code" : "52271000122101",
      "display" : "agente uricosúrico"
    },
    {
      "code" : "56531000122100",
      "display" : "agentes esfacelantes"
    },
    {
      "code" : "53881000122105",
      "display" : "agregados emolientes para el bańo"
    },
    {
      "code" : "41691000122108",
      "display" : "aguacate"
    },
    {
      "code" : "51041000122109",
      "display" : "albahaca"
    },
    {
      "code" : "61661000122105",
      "display" : "albaricoque"
    },
    {
      "code" : "61771000122108",
      "display" : "albúmina sérica"
    },
    {
      "code" : "43881000122108",
      "display" : "alcachofa"
    },
    {
      "code" : "40841000122105",
      "display" : "alcaloide de la vinca"
    },
    {
      "code" : "42421000122101",
      "display" : "alcaloide del cólquico"
    },
    {
      "code" : "46361000122100",
      "display" : "alcaloides de la belladona"
    },
    {
      "code" : "53161000122106",
      "display" : "alcaloides del opio"
    },
    {
      "code" : "46811000122109",
      "display" : "alclometasona"
    },
    {
      "code" : "61251000122105",
      "display" : "alcohol bencílico"
    },
    {
      "code" : "50401000122107",
      "display" : "alcohol etílico"
    },
    {
      "code" : "46161000122103",
      "display" : "alcohol nicotinílico"
    },
    {
      "code" : "59821000122108",
      "display" : "alcohol polivinílico"
    },
    {
      "code" : "41201000122101",
      "display" : "aldehído"
    },
    {
      "code" : "43941000122107",
      "display" : "aldesleukina"
    },
    {
      "code" : "60101000122106",
      "display" : "alérgeno de insecto"
    },
    {
      "code" : "50841000122107",
      "display" : "alfa dornasa"
    },
    {
      "code" : "55651000122104",
      "display" : "alfentanilo"
    },
    {
      "code" : "61601000122109",
      "display" : "alforfón"
    },
    {
      "code" : "43121000122100",
      "display" : "alilestrenol"
    },
    {
      "code" : "43021000122101",
      "display" : "alimentación por vía intravenosa"
    },
    {
      "code" : "55171000122100",
      "display" : "alimentación por vía intravenosa [carbohidratos]"
    },
    {
      "code" : "50811000122108",
      "display" : "alimentación por vía intravenosa [electrólitos/oligoelementos]"
    },
    {
      "code" : "41471000122109",
      "display" : "alimentación por vía intravenosa [grasas]"
    },
    {
      "code" : "56451000122109",
      "display" : "alimentación por vía intravenosa [vitaminas]"
    },
    {
      "code" : "50971000122105",
      "display" : "alimentaria inducida por pólenes"
    },
    {
      "code" : "50381000122107",
      "display" : "alimentos de origen marino"
    },
    {
      "code" : "47281000122103",
      "display" : "almejas"
    },
    {
      "code" : "54501000122103",
      "display" : "almendra"
    },
    {
      "code" : "47061000122100",
      "display" : "almotriptán"
    },
    {
      "code" : "60631000122106",
      "display" : "alogliptina"
    },
    {
      "code" : "58551000122109",
      "display" : "alprazolam"
    },
    {
      "code" : "44331000122103",
      "display" : "alprostadil"
    },
    {
      "code" : "40311000122100",
      "display" : "alteplasa"
    },
    {
      "code" : "46911000122104",
      "display" : "altramuz"
    },
    {
      "code" : "53031000122100",
      "display" : "aluminio"
    },
    {
      "code" : "54521000122106",
      "display" : "alverina"
    },
    {
      "code" : "59941000122106",
      "display" : "ambiental"
    },
    {
      "code" : "702772003",
      "display" : "ambiental idiopática"
    },
    {
      "code" : "59521000122105",
      "display" : "ambroxol"
    },
    {
      "code" : "58521000122102",
      "display" : "amfotericina"
    },
    {
      "code" : "61591000122103",
      "display" : "amidotrizoato"
    },
    {
      "code" : "55261000122100",
      "display" : "amifostina"
    },
    {
      "code" : "58631000122100",
      "display" : "amikacina"
    },
    {
      "code" : "56901000122104",
      "display" : "amilasa"
    },
    {
      "code" : "54141000122105",
      "display" : "amilobarbital"
    },
    {
      "code" : "40481000122103",
      "display" : "amilobarbital sódico"
    },
    {
      "code" : "55011000122108",
      "display" : "amilorida"
    },
    {
      "code" : "42401000122109",
      "display" : "amilorida y a diurético de asa"
    },
    {
      "code" : "59101000122107",
      "display" : "amilorida y a diurético tiazídico"
    },
    {
      "code" : "58661000122107",
      "display" : "aminofilina"
    },
    {
      "code" : "55411000122102",
      "display" : "aminoglucósidos"
    },
    {
      "code" : "40621000122104",
      "display" : "aminoglutetimida"
    },
    {
      "code" : "51871000122108",
      "display" : "amiodarona"
    },
    {
      "code" : "49001000122106",
      "display" : "amitriptilina"
    },
    {
      "code" : "55041000122107",
      "display" : "amlodipino"
    },
    {
      "code" : "46541000122106",
      "display" : "amodiaquina"
    },
    {
      "code" : "59001000122108",
      "display" : "amorolfina"
    },
    {
      "code" : "44211000122100",
      "display" : "amoxapina"
    },
    {
      "code" : "57981000122109",
      "display" : "amoxicilina"
    },
    {
      "code" : "55251000122102",
      "display" : "ampicilina"
    },
    {
      "code" : "46511000122107",
      "display" : "ampicilina y cloxacilina"
    },
    {
      "code" : "58161000122104",
      "display" : "amprenavir y derivados"
    },
    {
      "code" : "40221000122101",
      "display" : "amsacrina"
    },
    {
      "code" : "48971000122105",
      "display" : "anacardo"
    },
    {
      "code" : "60701000122105",
      "display" : "anagrelida"
    },
    {
      "code" : "51631000122106",
      "display" : "analgésicos no opiáceos"
    },
    {
      "code" : "48031000122108",
      "display" : "analgésicos opiáceos"
    },
    {
      "code" : "57511000122107",
      "display" : "Ancrod"
    },
    {
      "code" : "40501000122106",
      "display" : "andrógenos"
    },
    {
      "code" : "62031000122102",
      "display" : "anémona del mejillón"
    },
    {
      "code" : "52601000122108",
      "display" : "anestésico: éter"
    },
    {
      "code" : "55421000122108",
      "display" : "anestésicos inhalatorios"
    },
    {
      "code" : "41571000122108",
      "display" : "anfepramona"
    },
    {
      "code" : "42331000122108",
      "display" : "anfetaminas"
    },
    {
      "code" : "43311000122109",
      "display" : "anís"
    },
    {
      "code" : "41891000122107",
      "display" : "anisakis"
    },
    {
      "code" : "48371000122109",
      "display" : "antagonista de benzodiazepinas"
    },
    {
      "code" : "47611000122106",
      "display" : "antagonista del receptor H2"
    },
    {
      "code" : "44381000122102",
      "display" : "antagonista opioide"
    },
    {
      "code" : "55831000122108",
      "display" : "antagonista receptor de 5-HT3"
    },
    {
      "code" : "45551000122103",
      "display" : "antagonistas de la aldosterona"
    },
    {
      "code" : "58641000122108",
      "display" : "antiandrógenos"
    },
    {
      "code" : "62201000122104",
      "display" : "antibiótico"
    },
    {
      "code" : "49571000122109",
      "display" : "antibiótico citotóxico"
    },
    {
      "code" : "52821000122101",
      "display" : "antibiótico sulfonamídico"
    },
    {
      "code" : "31581000122107",
      "display" : "antibióticos"
    },
    {
      "code" : "41741000122105",
      "display" : "anticoagulante"
    },
    {
      "code" : "44141000122108",
      "display" : "anticoagulante cumarínico"
    },
    {
      "code" : "40751000122103",
      "display" : "anticoagulante de acción indirecta"
    },
    {
      "code" : "56051000122101",
      "display" : "anticoagulante derivado de la indanodiona"
    },
    {
      "code" : "72354005",
      "display" : "anticonceptivo oral"
    },
    {
      "code" : "48571000122104",
      "display" : "anticuerpo específico de digoxina"
    },
    {
      "code" : "61441000122109",
      "display" : "anticuerpo monoclonal humano HA - 1A"
    },
    {
      "code" : "51461000122101",
      "display" : "antidepresivo tetracíclico"
    },
    {
      "code" : "56811000122106",
      "display" : "antidepresivos compuestos"
    },
    {
      "code" : "57521000122101",
      "display" : "antídoto"
    },
    {
      "code" : "50411000122105",
      "display" : "antídoto de quemadura de ácido fluorhídrico"
    },
    {
      "code" : "47651000122107",
      "display" : "antídotos y agentes quelantes"
    },
    {
      "code" : "50431000122101",
      "display" : "antiepiléptico barbitúrico"
    },
    {
      "code" : "55691000122108",
      "display" : "antimetabolito"
    },
    {
      "code" : "52611000122106",
      "display" : "antimicótico del grupo azol"
    },
    {
      "code" : "40061000122104",
      "display" : "antimicótico del grupo imidazol"
    },
    {
      "code" : "49131000122104",
      "display" : "antineoplásico a base de triazeno"
    },
    {
      "code" : "58081000122106",
      "display" : "antiprotozoario de diamidina"
    },
    {
      "code" : "56061000122104",
      "display" : "antiprotozoario de dicloroacetamida"
    },
    {
      "code" : "43561000122102",
      "display" : "antisuero"
    },
    {
      "code" : "53731000122103",
      "display" : "antitoxina botulínica"
    },
    {
      "code" : "50011000122104",
      "display" : "antitoxina de la gangrena gaseosa"
    },
    {
      "code" : "58621000122103",
      "display" : "antitoxina tetánica"
    },
    {
      "code" : "40701000122102",
      "display" : "antitripsina alfa 1"
    },
    {
      "code" : "42101000122100",
      "display" : "antitrombina III"
    },
    {
      "code" : "57311000122103",
      "display" : "antitusígeno morfínico"
    },
    {
      "code" : "50551000122107",
      "display" : "antitusivo/descongestivo"
    },
    {
      "code" : "48881000122103",
      "display" : "antraciclina"
    },
    {
      "code" : "55701000122108",
      "display" : "apio"
    },
    {
      "code" : "57351000122102",
      "display" : "apomorfina"
    },
    {
      "code" : "52771000122107",
      "display" : "apraclonidina"
    },
    {
      "code" : "43321000122103",
      "display" : "aprepitant"
    },
    {
      "code" : "44181000122104",
      "display" : "aprotinina"
    },
    {
      "code" : "48661000122105",
      "display" : "arándano"
    },
    {
      "code" : "49231000122108",
      "display" : "arcilla de batán"
    },
    {
      "code" : "61541000122105",
      "display" : "arenque"
    },
    {
      "code" : "47301000122104",
      "display" : "arroz"
    },
    {
      "code" : "48361000122104",
      "display" : "Artemisia vulgaris"
    },
    {
      "code" : "60251000122104",
      "display" : "arveja"
    },
    {
      "code" : "52361000122103",
      "display" : "aserbina"
    },
    {
      "code" : "54561000122102",
      "display" : "aspirina"
    },
    {
      "code" : "44281000122105",
      "display" : "astemizol"
    },
    {
      "code" : "52761000122102",
      "display" : "atazanavir"
    },
    {
      "code" : "49991000122102",
      "display" : "atenolol"
    },
    {
      "code" : "44911000122106",
      "display" : "atorvastatina"
    },
    {
      "code" : "47311000122101",
      "display" : "atovacuona"
    },
    {
      "code" : "42521000122102",
      "display" : "atracurio"
    },
    {
      "code" : "51331000122103",
      "display" : "atropina"
    },
    {
      "code" : "61551000122107",
      "display" : "atún"
    },
    {
      "code" : "102461004",
      "display" : "aumentada"
    },
    {
      "code" : "53941000122109",
      "display" : "auranofina"
    },
    {
      "code" : "54731000122101",
      "display" : "aurotiomalato de sodio"
    },
    {
      "code" : "49241000122100",
      "display" : "avellana"
    },
    {
      "code" : "57571000122100",
      "display" : "avena"
    },
    {
      "code" : "43811000122103",
      "display" : "azapropazona"
    },
    {
      "code" : "45481000122105",
      "display" : "azatadina"
    },
    {
      "code" : "50181000122105",
      "display" : "azelastina"
    },
    {
      "code" : "44761000122106",
      "display" : "azitromicina"
    },
    {
      "code" : "52241000122107",
      "display" : "azo desinfectante colorante acridina"
    },
    {
      "code" : "54801000122101",
      "display" : "aztreonam"
    },
    {
      "code" : "61561000122109",
      "display" : "azul patente"
    },
    {
      "code" : "44461000122101",
      "display" : "bacalao"
    },
    {
      "code" : "60971000122104",
      "display" : "bacitracina"
    },
    {
      "code" : "49211000122104",
      "display" : "baclofeno"
    },
    {
      "code" : "56261000122105",
      "display" : "barbo"
    },
    {
      "code" : "50511000122106",
      "display" : "barnidipino"
    },
    {
      "code" : "45331000122104",
      "display" : "batata"
    },
    {
      "code" : "52751000122104",
      "display" : "bayas de Goji"
    },
    {
      "code" : "47781000122105",
      "display" : "beclometasona"
    },
    {
      "code" : "60791000122100",
      "display" : "bedaquilina"
    },
    {
      "code" : "43621000122105",
      "display" : "befenio"
    },
    {
      "code" : "57551000122108",
      "display" : "benazepril"
    },
    {
      "code" : "61111000122100",
      "display" : "bencidamina"
    },
    {
      "code" : "60411000122104",
      "display" : "bendamustina"
    },
    {
      "code" : "44821000122107",
      "display" : "bendrofluazida"
    },
    {
      "code" : "42551000122109",
      "display" : "benzalconio"
    },
    {
      "code" : "59601000122101",
      "display" : "benzoato de bencilo"
    },
    {
      "code" : "52571000122103",
      "display" : "benzodiazepina"
    },
    {
      "code" : "57781000122107",
      "display" : "benztropina"
    },
    {
      "code" : "45511000122104",
      "display" : "berberechos"
    },
    {
      "code" : "51541000122104",
      "display" : "berenjena"
    },
    {
      "code" : "55681000122105",
      "display" : "betahistina"
    },
    {
      "code" : "61151000122104",
      "display" : "betaína"
    },
    {
      "code" : "55461000122104",
      "display" : "betametasona"
    },
    {
      "code" : "40021000122108",
      "display" : "betanecol"
    },
    {
      "code" : "47641000122105",
      "display" : "betaxolol"
    },
    {
      "code" : "59221000122107",
      "display" : "bezafibrato"
    },
    {
      "code" : "47581000122100",
      "display" : "bifosfonatos"
    },
    {
      "code" : "54911000122108",
      "display" : "biguanida"
    },
    {
      "code" : "58311000122104",
      "display" : "bisacodilo"
    },
    {
      "code" : "45681000122108",
      "display" : "bisoprolol"
    },
    {
      "code" : "54131000122102",
      "display" : "bloqueante ganglionar"
    },
    {
      "code" : "54221000122108",
      "display" : "bogavante"
    },
    {
      "code" : "40461000122106",
      "display" : "bonito"
    },
    {
      "code" : "48681000122102",
      "display" : "boquerón"
    },
    {
      "code" : "59111000122105",
      "display" : "bosutinib"
    },
    {
      "code" : "50521000122100",
      "display" : "bretilio"
    },
    {
      "code" : "45861000122104",
      "display" : "brócoli"
    },
    {
      "code" : "46771000122109",
      "display" : "bromazepam"
    },
    {
      "code" : "50221000122103",
      "display" : "bromfeniramina"
    },
    {
      "code" : "48271000122102",
      "display" : "bromhidrato de dextrometorfano"
    },
    {
      "code" : "57701000122100",
      "display" : "bromocriptina"
    },
    {
      "code" : "46031000122109",
      "display" : "bromperidol y sus derivados"
    },
    {
      "code" : "60991000122103",
      "display" : "bromuro"
    },
    {
      "code" : "45791000122101",
      "display" : "fármaco antiarrítmico de clase III"
    },
    {
      "code" : "57171000122108",
      "display" : "fármaco antiarrítmico de clase IV"
    },
    {
      "code" : "42391000122107",
      "display" : "fármaco anticolinérgico"
    },
    {
      "code" : "41931000122100",
      "display" : "fármaco antidepresivo"
    },
    {
      "code" : "54651000122103",
      "display" : "fármaco antidiarreico"
    },
    {
      "code" : "43441000122102",
      "display" : "fármaco antiemético"
    },
    {
      "code" : "59191000122102",
      "display" : "fármaco antiepiléptico"
    },
    {
      "code" : "48501000122108",
      "display" : "fármaco antiespasmódico"
    },
    {
      "code" : "47901000122100",
      "display" : "fármaco antihipertensivo"
    },
    {
      "code" : "57581000122102",
      "display" : "fármaco antihipertensivo de rauwolfia"
    },
    {
      "code" : "42011000122101",
      "display" : "fármaco antihistamínico H1"
    },
    {
      "code" : "60501000122101",
      "display" : "fármaco antihistamínico H2"
    },
    {
      "code" : "47561000122108",
      "display" : "fármaco antihistamínico no sedante"
    },
    {
      "code" : "58761000122100",
      "display" : "fármaco antihistamínico sedante"
    },
    {
      "code" : "53581000122107",
      "display" : "fármaco antihistamínico tópico"
    },
    {
      "code" : "46171000122108",
      "display" : "fármaco antiinflamatorio no esteroide"
    },
    {
      "code" : "41371000122103",
      "display" : "fármaco antimicótico"
    },
    {
      "code" : "54691000122107",
      "display" : "fármaco antimuscarínico"
    },
    {
      "code" : "58151000122101",
      "display" : "fármaco antineoplásico"
    },
    {
      "code" : "58041000122102",
      "display" : "fármaco antipalúdico"
    },
    {
      "code" : "56601000122107",
      "display" : "fármaco antipalúdico con aminoquinolina"
    },
    {
      "code" : "44481000122109",
      "display" : "fármaco antipalúdico con biguanida"
    },
    {
      "code" : "43161000122109",
      "display" : "fármaco antipalúdico con quina"
    },
    {
      "code" : "59831000122106",
      "display" : "fármaco antiprotozoario"
    },
    {
      "code" : "49841000122101",
      "display" : "fármaco antiprotozoario con antimonio"
    },
    {
      "code" : "60081000122100",
      "display" : "fármaco antirretroviral"
    },
    {
      "code" : "41221000122109",
      "display" : "fármaco antitiroideo"
    },
    {
      "code" : "51691000122105",
      "display" : "fármaco antituberculoso"
    },
    {
      "code" : "56561000122107",
      "display" : "fármaco antituberculoso hidrazida"
    },
    {
      "code" : "48701000122104",
      "display" : "fármaco antitusígeno"
    },
    {
      "code" : "40131000122107",
      "display" : "fármaco antitusígeno compuesto"
    },
    {
      "code" : "43281000122107",
      "display" : "fármaco antiviral"
    },
    {
      "code" : "59761000122107",
      "display" : "fármaco betabloqueante cardioselectivo"
    },
    {
      "code" : "49181000122103",
      "display" : "fármaco bloqueante de los canales del calcio"
    },
    {
      "code" : "59721000122103",
      "display" : "fármaco bloqueante del receptor alfa-adrenérgico"
    },
    {
      "code" : "51681000122107",
      "display" : "fármaco bloqueante del receptor beta-adrenérgico"
    },
    {
      "code" : "45561000122101",
      "display" : "fármaco de anestesia local"
    },
    {
      "code" : "47201000122105",
      "display" : "fármaco descongestivo de marca comercial"
    },
    {
      "code" : "44451000122103",
      "display" : "fármaco diurético"
    },
    {
      "code" : "54441000122102",
      "display" : "fármaco dopaminérgico empleado en la enfermedad de Parkinson"
    },
    {
      "code" : "47161000122101",
      "display" : "fármaco en contacto con la piel"
    },
    {
      "code" : "49451000122102",
      "display" : "fármaco estimulante de acción central"
    },
    {
      "code" : "58291000122103",
      "display" : "fármaco estimulante respiratorio"
    },
    {
      "code" : "52071000122105",
      "display" : "fármaco estimulante selectivo de receptor beta-1 adrenérgico"
    },
    {
      "code" : "43971000122101",
      "display" : "fármaco estimulante selectivo de receptor beta-2 adrenérgico"
    },
    {
      "code" : "44671000122109",
      "display" : "fármaco hemostático"
    },
    {
      "code" : "42931000122109",
      "display" : "fármaco hipoglucemiante oral"
    },
    {
      "code" : "46351000122102",
      "display" : "fármaco inhibidor de la bomba de protones"
    },
    {
      "code" : "44961000122109",
      "display" : "fármaco inhibidor de la monoaminooxidasa"
    },
    {
      "code" : "41621000122106",
      "display" : "fármaco inhibidor selectivo de la recaptación de serotonina"
    },
    {
      "code" : "41541000122102",
      "display" : "fármaco laxante"
    },
    {
      "code" : "49091000122101",
      "display" : "fármaco modificador del metabolismo del alcohol"
    },
    {
      "code" : "42221000122100",
      "display" : "fármaco para tratamiento de la gota"
    },
    {
      "code" : "43641000122100",
      "display" : "fármaco parasimpaticomimético"
    },
    {
      "code" : "45261000122103",
      "display" : "fármaco parasimpaticomimético anticolinesterasa"
    },
    {
      "code" : "51991000122103",
      "display" : "fármaco sedante"
    },
    {
      "code" : "58361000122101",
      "display" : "fármaco simpaticomimético"
    },
    {
      "code" : "57241000122109",
      "display" : "fármaco utilizado para anestesia general"
    },
    {
      "code" : "46371000122105",
      "display" : "fármaco vasodilatador"
    },
    {
      "code" : "42431000122103",
      "display" : "fármacos antibacterianos"
    },
    {
      "code" : "42561000122106",
      "display" : "fármacos antihelmínticos"
    },
    {
      "code" : "57911000122104",
      "display" : "felbinaco"
    },
    {
      "code" : "53241000122100",
      "display" : "felodipino"
    },
    {
      "code" : "56671000122103",
      "display" : "fenbufén"
    },
    {
      "code" : "44731000122104",
      "display" : "fenelzina"
    },
    {
      "code" : "49711000122107",
      "display" : "fenfluramina"
    },
    {
      "code" : "60691000122105",
      "display" : "fenicoles"
    },
    {
      "code" : "60681000122107",
      "display" : "fenilalanina"
    },
    {
      "code" : "56161000122100",
      "display" : "gemeprost"
    },
    {
      "code" : "59041000122105",
      "display" : "gemfibrozilo"
    },
    {
      "code" : "44781000122103",
      "display" : "gemifloxacino"
    },
    {
      "code" : "53921000122104",
      "display" : "gemtuzumab"
    },
    {
      "code" : "50891000122100",
      "display" : "gentamicina"
    },
    {
      "code" : "43001000122109",
      "display" : "gestrinona"
    },
    {
      "code" : "52141000122100",
      "display" : "gestronol"
    },
    {
      "code" : "48301000122100",
      "display" : "ginseng"
    },
    {
      "code" : "50321000122108",
      "display" : "glatiramero"
    },
    {
      "code" : "45841000122103",
      "display" : "glibenclamida"
    },
    {
      "code" : "57611000122108",
      "display" : "glibornurida"
    },
    {
      "code" : "782414008",
      "display" : "glicerol"
    },
    {
      "code" : "50491000122102",
      "display" : "glicerol / glicol / macrogol"
    },
    {
      "code" : "42971000122107",
      "display" : "glicina"
    },
    {
      "code" : "52321000122107",
      "display" : "gliclazida"
    },
    {
      "code" : "55341000122109",
      "display" : "glicopirronio"
    },
    {
      "code" : "54481000122106",
      "display" : "glimidina"
    },
    {
      "code" : "50861000122106",
      "display" : "glipizida"
    },
    {
      "code" : "45341000122107",
      "display" : "gliquidona"
    },
    {
      "code" : "43131000122102",
      "display" : "glucagón"
    },
    {
      "code" : "56371000122107",
      "display" : "gluconato ferroso"
    },
    {
      "code" : "9414007",
      "display" : "glucosa"
    },
    {
      "code" : "51071000122103",
      "display" : "glucósido cardíaco"
    },
    {
      "code" : "61051000122103",
      "display" : "glucosilceramidasa y derivados"
    },
    {
      "code" : "49781000122102",
      "display" : "glutamato monosódico"
    },
    {
      "code" : "51111000122109",
      "display" : "glutaraldehído"
    },
    {
      "code" : "8031000122102",
      "display" : "gluten"
    },
    {
      "code" : "54361000122107",
      "display" : "goma guar"
    },
    {
      "code" : "40431000122104",
      "display" : "gonadotrofina"
    },
    {
      "code" : "61851000122109",
      "display" : "gorgojo de la harina"
    },
    {
      "code" : "43871000122105",
      "display" : "goserelina"
    },
    {
      "code" : "58201000122108",
      "display" : "gotas de prednisolona"
    },
    {
      "code" : "45391000122100",
      "display" : "granada"
    },
    {
      "code" : "55481000122107",
      "display" : "griseofulvina"
    },
    {
      "code" : "58111000122102",
      "display" : "grosella"
    },
    {
      "code" : "53841000122101",
      "display" : "grupos de fármacos que afectan principalmente al aparato cardiovascular"
    },
    {
      "code" : "51301000122109",
      "display" : "grupos de fármacos que afectan principalmente al aparato digestivo"
    },
    {
      "code" : "42531000122104",
      "display" : "grupos de fármacos que afectan principalmente al aparato respiratorio"
    },
    {
      "code" : "52281000122103",
      "display" : "grupos de fármacos que afectan principalmente al sistema musculoesquelético"
    },
    {
      "code" : "50291000122101",
      "display" : "guanetidina"
    },
    {
      "code" : "54831000122107",
      "display" : "guayaba"
    },
    {
      "code" : "56511000122109",
      "display" : "guisante"
    },
    {
      "code" : "61871000122101",
      "display" : "gusano de la harina"
    },
    {
      "code" : "61701000122104",
      "display" : "haba"
    },
    {
      "code" : "43251000122101",
      "display" : "halofantrina"
    },
    {
      "code" : "57921000122105",
      "display" : "haloperidol"
    },
    {
      "code" : "60661000122104",
      "display" : "hamamelis"
    },
    {
      "code" : "62181000122100",
      "display" : "harina de almorta"
    },
    {
      "code" : "40551000122105",
      "display" : "harina de trigo"
    },
    {
      "code" : "54461000122103",
      "display" : "harpagofito"
    },
    {
      "code" : "49141000122107",
      "display" : "heparina"
    },
    {
      "code" : "40201000122109",
      "display" : "heparinoide"
    },
    {
      "code" : "20052008",
      "display" : "hereditaria a la fructosa"
    },
    {
      "code" : "52311000122101",
      "display" : "heroína"
    },
    {
      "code" : "60041000122109",
      "display" : "herrumbre"
    },
    {
      "code" : "51341000122106",
      "display" : "hexetidina"
    },
    {
      "code" : "47891000122104",
      "display" : "hialuronato de sodio"
    },
    {
      "code" : "60891000122109",
      "display" : "hidantoína y sus derivados"
    },
    {
      "code" : "56291000122104",
      "display" : "hidragafeno"
    },
    {
      "code" : "51101000122106",
      "display" : "hidrato de cloral"
    },
    {
      "code" : "46991000122107",
      "display" : "hidroclorotiazida"
    },
    {
      "code" : "43821000122109",
      "display" : "hidrocortisona tópica"
    },
    {
      "code" : "53901000122107",
      "display" : "hidroflumetiazida"
    },
    {
      "code" : "61321000122108",
      "display" : "hidroxianisol butilado"
    },
    {
      "code" : "55871000122106",
      "display" : "hidroxicloroquina"
    },
    {
      "code" : "49081000122104",
      "display" : "hidróxido de aluminio"
    },
    {
      "code" : "42981000122105",
      "display" : "hidroxietilcelulosa"
    },
    {
      "code" : "45301000122105",
      "display" : "hidroxiprogesterona"
    },
    {
      "code" : "59661000122100",
      "display" : "hidroxizina"
    },
    {
      "code" : "52391000122109",
      "display" : "hidroxocobalamina"
    },
    {
      "code" : "47551000122106",
      "display" : "hierro"
    },
    {
      "code" : "56491000122100",
      "display" : "hierro sorbitol"
    },
    {
      "code" : "59391000122100",
      "display" : "higo"
    },
    {
      "code" : "53461000122100",
      "display" : "hinojo"
    },
    {
      "code" : "43381000122104",
      "display" : "hioscina"
    },
    {
      "code" : "42091000122109",
      "display" : "hipurato de hexamina"
    },
    {
      "code" : "52371000122108",
      "display" : "hirudina"
    },
    {
      "code" : "42991000122108",
      "display" : "homatropina"
    },
    {
      "code" : "60001000122107",
      "display" : "hongo"
    },
    {
      "code" : "54101000122108",
      "display" : "hongo alimenticio"
    },
    {
      "code" : "62021000122100",
      "display" : "hormiga culona"
    },
    {
      "code" : "56991000122109",
      "display" : "hormona antidiurética"
    },
    {
      "code" : "60201000122103",
      "display" : "hormona hipofisaria"
    },
    {
      "code" : "61041000122100",
      "display" : "hormona hipofisaria foliculoestimulante"
    },
    {
      "code" : "60191000122101",
      "display" : "hormona hipotalámica"
    },
    {
      "code" : "59731000122100",
      "display" : "hormona hipotalámica/hipofisaria"
    },
    {
      "code" : "44311000122107",
      "display" : "hormona reguladora de las gónadas"
    },
    {
      "code" : "43741000122109",
      "display" : "hormona reguladora del calcio"
    },
    {
      "code" : "43501000122103",
      "display" : "hormona tirotrófica"
    },
    {
      "code" : "46301000122101",
      "display" : "hormonas sexuales"
    },
    {
      "code" : "49471000122105",
      "display" : "hormonas, sustitutos sintéticos y antagonistas"
    },
    {
      "code" : "55221000122109",
      "display" : "huevos"
    },
    {
      "code" : "61311000122102",
      "display" : "humo"
    },
    {
      "code" : "51811000122101",
      "display" : "ibuprofeno"
    },
    {
      "code" : "60721000122102",
      "display" : "icatibant"
    },
    {
      "code" : "41561000122103",
      "display" : "ictamol"
    },
    {
      "code" : "49031000122100",
      "display" : "idarubicina"
    },
    {
      "code" : "46901000122102",
      "display" : "idoxuridina"
    },
    {
      "code" : "55431000122106",
      "display" : "idoxuridina en dimetilsulfóxido"
    },
    {
      "code" : "56101000122101",
      "display" : "ifosfamida"
    },
    {
      "code" : "56541000122108",
      "display" : "imidapril"
    },
    {
      "code" : "42631000122100",
      "display" : "imipenem"
    },
    {
      "code" : "48251000122105",
      "display" : "imipramina"
    },
    {
      "code" : "53961000122108",
      "display" : "implante de estradiol"
    },
    {
      "code" : "48461000122108",
      "display" : "indapamida"
    },
    {
      "code" : "43421000122107",
      "display" : "indometacina"
    },
    {
      "code" : "55321000122104",
      "display" : "indoramina"
    },
    {
      "code" : "50161000122102",
      "display" : "inhibidor de 3-hidroxi-3-metilglutaril coenzima A [HMG CoA] reductasa"
    },
    {
      "code" : "57841000122108",
      "display" : "inhibidor de alfa glucosidasa"
    },
    {
      "code" : "58141000122103",
      "display" : "inhibidor de alfa glucósido"
    },
    {
      "code" : "60511000122103",
      "display" : "inhibidor de la 5-alfa reductasa"
    },
    {
      "code" : "44581000122108",
      "display" : "inhibidor de la anhidrasa carbónica"
    },
    {
      "code" : "60611000122102",
      "display" : "inhibidor de la dipeptidil peptidasa IV"
    },
    {
      "code" : "41211000122103",
      "display" : "inhibidor de la fosfodiesterasa"
    },
    {
      "code" : "45401000122103",
      "display" : "inhibidor de la proteína tirosina quinasa"
    },
    {
      "code" : "60061000122108",
      "display" : "inhibidor de transcriptasa inversa"
    },
    {
      "code" : "43611000122104",
      "display" : "inhibidor de xantina oxidasa"
    },
    {
      "code" : "48821000122102",
      "display" : "inhibidor enzimático"
    },
    {
      "code" : "61481000122100",
      "display" : "inmunoglobulina anti-citomegalovirus"
    },
    {
      "code" : "54451000122100",
      "display" : "inmunoglobulina anti-D [Rh]"
    },
    {
      "code" : "59241000122102",
      "display" : "inmunoglobulina contra el tétanos"
    },
    {
      "code" : "59421000122106",
      "display" : "inmunoglobulina contra la hepatitis B"
    },
    {
      "code" : "54071000122100",
      "display" : "inmunoglobulina contra varicela zóster"
    },
    {
      "code" : "59701000122106",
      "display" : "inmunoglobulina frente a la parotiditis urliana"
    },
    {
      "code" : "61421000122104",
      "display" : "inmunoglobulina frente a la rubéola"
    },
    {
      "code" : "61401000122107",
      "display" : "inmunoglobulina frente a la tos ferina"
    },
    {
      "code" : "61491000122102",
      "display" : "inmunoglobulina frente al virus del sarampión"
    },
    {
      "code" : "42301000122102",
      "display" : "inmunoglobulina humana"
    },
    {
      "code" : "61471000122103",
      "display" : "inmunoglobulina humana anti-vaccinia"
    },
    {
      "code" : "61451000122106",
      "display" : "inmunoglobulina humana frente a la encefalitis por virus transmitido por garrapatas"
    },
    {
      "code" : "57881000122104",
      "display" : "inmunoglobulina intramuscular"
    },
    {
      "code" : "50131000122109",
      "display" : "inmunoglobulina intravenosa"
    },
    {
      "code" : "50781000122106",
      "display" : "inmunosupresor macrólido"
    },
    {
      "code" : "51911000122106",
      "display" : "inositol"
    },
    {
      "code" : "49041000122108",
      "display" : "insulina"
    },
    {
      "code" : "48511000122106",
      "display" : "insulina cinc protamina"
    },
    {
      "code" : "41911000122109",
      "display" : "insulina en suspensión de cinc"
    },
    {
      "code" : "47841000122106",
      "display" : "insulina Humulin"
    },
    {
      "code" : "40321000122106",
      "display" : "insulina isófana bifásica"
    },
    {
      "code" : "50041000122100",
      "display" : "insulina neutra soluble"
    },
    {
      "code" : "51221000122106",
      "display" : "interferón humano gamma-1b"
    },
    {
      "code" : "45291000122109",
      "display" : "interferón-A-2b"
    },
    {
      "code" : "40891000122103",
      "display" : "interferones"
    },
    {
      "code" : "29544009",
      "display" : "intolerancia"
    },
    {
      "code" : "55051000122109",
      "display" : "iohexol"
    },
    {
      "code" : "53771000122100",
      "display" : "ipratropio"
    },
    {
      "code" : "55271000122105",
      "display" : "fenilbutazona"
    },
    {
      "code" : "40471000122101",
      "display" : "fenilbutirato de sodio"
    },
    {
      "code" : "50881000122103",
      "display" : "fenilefrina"
    },
    {
      "code" : "59751000122105",
      "display" : "fenindamina"
    },
    {
      "code" : "56881000122101",
      "display" : "fenindiona"
    },
    {
      "code" : "57271000122103",
      "display" : "feniramina"
    },
    {
      "code" : "54631000122108",
      "display" : "fenitoína"
    },
    {
      "code" : "48731000122105",
      "display" : "fenobarbital"
    },
    {
      "code" : "50281000122104",
      "display" : "fenofibrato"
    },
    {
      "code" : "50981000122108",
      "display" : "fenogreco"
    },
    {
      "code" : "42491000122104",
      "display" : "fenol"
    },
    {
      "code" : "54161000122109",
      "display" : "fenol clorado"
    },
    {
      "code" : "52661000122109",
      "display" : "fenoperidina"
    },
    {
      "code" : "58481000122102",
      "display" : "fenoprofeno"
    },
    {
      "code" : "45711000122109",
      "display" : "fenoterol"
    },
    {
      "code" : "44931000122102",
      "display" : "fenotiazina"
    },
    {
      "code" : "49111000122108",
      "display" : "fenotrina"
    },
    {
      "code" : "47191000122107",
      "display" : "fenoxibenzamina"
    },
    {
      "code" : "47211000122108",
      "display" : "fenoximetilpenicilina"
    },
    {
      "code" : "45991000122104",
      "display" : "fentanilo"
    },
    {
      "code" : "50201000122106",
      "display" : "fentermina"
    },
    {
      "code" : "41701000122108",
      "display" : "fenticonazol"
    },
    {
      "code" : "48721000122107",
      "display" : "fentolamina"
    },
    {
      "code" : "43391000122101",
      "display" : "feredetato de sodio"
    },
    {
      "code" : "46471000122104",
      "display" : "fibra vegetal"
    },
    {
      "code" : "42241000122105",
      "display" : "fibrato hipolipemiante"
    },
    {
      "code" : "47671000122104",
      "display" : "filgrastim"
    },
    {
      "code" : "53441000122104",
      "display" : "finasterida"
    },
    {
      "code" : "59451000122104",
      "display" : "fingolimod"
    },
    {
      "code" : "48281000122104",
      "display" : "fisostigmina"
    },
    {
      "code" : "43221000122108",
      "display" : "flecainida"
    },
    {
      "code" : "56431000122104",
      "display" : "fletán"
    },
    {
      "code" : "55951000122105",
      "display" : "flucitosina"
    },
    {
      "code" : "57751000122101",
      "display" : "fluclorolona"
    },
    {
      "code" : "43571000122107",
      "display" : "flucloxacilina+ampicilina"
    },
    {
      "code" : "58781000122108",
      "display" : "fluconazol"
    },
    {
      "code" : "52131000122108",
      "display" : "fludrocortisona"
    },
    {
      "code" : "47881000122102",
      "display" : "flufenazina"
    },
    {
      "code" : "45801000122100",
      "display" : "flunisolida"
    },
    {
      "code" : "56471000122101",
      "display" : "flunitrazepam"
    },
    {
      "code" : "58681000122104",
      "display" : "fluocinonida"
    },
    {
      "code" : "44051000122106",
      "display" : "fluocortolona"
    },
    {
      "code" : "41351000122106",
      "display" : "fluorouracilo"
    },
    {
      "code" : "53911000122105",
      "display" : "fluoruro"
    },
    {
      "code" : "46931000122108",
      "display" : "fluoruro de sodio"
    },
    {
      "code" : "43661000122101",
      "display" : "flupentixol"
    },
    {
      "code" : "50831000122104",
      "display" : "flurandrenolona"
    },
    {
      "code" : "43151000122107",
      "display" : "flurbiprofeno"
    },
    {
      "code" : "53121000122102",
      "display" : "fluspirileno"
    },
    {
      "code" : "52541000122109",
      "display" : "fluticasona"
    },
    {
      "code" : "56111000122103",
      "display" : "fluvastatina"
    },
    {
      "code" : "54171000122104",
      "display" : "folcodina"
    },
    {
      "code" : "47731000122109",
      "display" : "formestano"
    },
    {
      "code" : "81781000119107",
      "display" : "fórmula para lactantes"
    },
    {
      "code" : "40071000122109",
      "display" : "foscarnet"
    },
    {
      "code" : "51771000122101",
      "display" : "fosfato de poliestradiol"
    },
    {
      "code" : "46331000122107",
      "display" : "fosfato ferroso"
    },
    {
      "code" : "43781000122100",
      "display" : "fosfestrol"
    },
    {
      "code" : "57041000122101",
      "display" : "fracción fosfolipídica"
    },
    {
      "code" : "41001000122105",
      "display" : "frambuesa"
    },
    {
      "code" : "50311000122102",
      "display" : "fresas"
    },
    {
      "code" : "80585000",
      "display" : "frío"
    },
    {
      "code" : "54471000122108",
      "display" : "fruta cítrica"
    },
    {
      "code" : "48741000122102",
      "display" : "fruta de la pasión"
    },
    {
      "code" : "62191000122102",
      "display" : "frutas secas"
    },
    {
      "code" : "41721000122100",
      "display" : "fruto del kiwi"
    },
    {
      "code" : "52691000122103",
      "display" : "ftalilsulfatiazol"
    },
    {
      "code" : "52581000122100",
      "display" : "fumarato ferroso"
    },
    {
      "code" : "48291000122101",
      "display" : "fusidato de sodio"
    },
    {
      "code" : "52701000122103",
      "display" : "gabapentina"
    },
    {
      "code" : "190749000",
      "display" : "galactosa"
    },
    {
      "code" : "40681000122100",
      "display" : "galamina"
    },
    {
      "code" : "53091000122101",
      "display" : "galantamina"
    },
    {
      "code" : "42921000122106",
      "display" : "ganciclovir"
    },
    {
      "code" : "53151000122109",
      "display" : "gas medicamentoso"
    },
    {
      "code" : "52711000122100",
      "display" : "gasa impregnada con pasta de subnitrato de bismuto y yodoformo"
    },
    {
      "code" : "45611000122103",
      "display" : "gelatina"
    },
    {
      "code" : "54031000122103",
      "display" : "gemcitabina"
    },
    {
      "code" : "49061000122107",
      "display" : "clorpropamida"
    },
    {
      "code" : "46961000122101",
      "display" : "clorprotixeno"
    },
    {
      "code" : "42591000122100",
      "display" : "clortalidona"
    },
    {
      "code" : "44201000122103",
      "display" : "clortetraciclina"
    },
    {
      "code" : "48671000122100",
      "display" : "cloruro de acetilcolina"
    },
    {
      "code" : "51271000122107",
      "display" : "cloruro de laquesina"
    },
    {
      "code" : "58091000122109",
      "display" : "clotrimazol"
    },
    {
      "code" : "55211000122103",
      "display" : "cloxacilina"
    },
    {
      "code" : "54311000122109",
      "display" : "clozapina"
    },
    {
      "code" : "53791000122104",
      "display" : "co-beneldopa"
    },
    {
      "code" : "58871000122103",
      "display" : "co-careldopa"
    },
    {
      "code" : "50721000122107",
      "display" : "co-dergocrina"
    },
    {
      "code" : "60421000122105",
      "display" : "cobalaminas"
    },
    {
      "code" : "49881000122105",
      "display" : "cobalto"
    },
    {
      "code" : "54771000122103",
      "display" : "cocaína"
    },
    {
      "code" : "44831000122105",
      "display" : "coco"
    },
    {
      "code" : "48111000122100",
      "display" : "codeína"
    },
    {
      "code" : "57141000122102",
      "display" : "col verde"
    },
    {
      "code" : "59021000122100",
      "display" : "colágeno"
    },
    {
      "code" : "56941000122102",
      "display" : "colchicina"
    },
    {
      "code" : "50501000122108",
      "display" : "colestipol"
    },
    {
      "code" : "59861000122104",
      "display" : "colestiramina"
    },
    {
      "code" : "41881000122109",
      "display" : "colfoscerilo"
    },
    {
      "code" : "58281000122101",
      "display" : "coliflor"
    },
    {
      "code" : "53251000122103",
      "display" : "colirios con hipromelosa"
    },
    {
      "code" : "43411000122101",
      "display" : "colistina"
    },
    {
      "code" : "49861000122102",
      "display" : "colodión"
    },
    {
      "code" : "57331000122107",
      "display" : "colorante de uso diagnóstico"
    },
    {
      "code" : "47631000122102",
      "display" : "colorante desinfectante azo trifenilmetano"
    },
    {
      "code" : "43301000122106",
      "display" : "combinación amoxicilina + clavulanato de potasio"
    },
    {
      "code" : "40921000122107",
      "display" : "complejo de hierro polisacárido"
    },
    {
      "code" : "47381000122106",
      "display" : "compuestos de yodo"
    },
    {
      "code" : "52861000122105",
      "display" : "compuestos fenólicos"
    },
    {
      "code" : "58571000122101",
      "display" : "conalbúmina"
    },
    {
      "code" : "40411000122108",
      "display" : "concentrados de factor VII"
    },
    {
      "code" : "27943000",
      "display" : "congénita a glucosa - galactosa"
    },
    {
      "code" : "61691000122104",
      "display" : "congrio"
    },
    {
      "code" : "48921000122109",
      "display" : "conservante alimentario a base de sulfito"
    },
    {
      "code" : "42571000122101",
      "display" : "conservante alimenticio"
    },
    {
      "code" : "53871000122107",
      "display" : "corticosteroides administrados por inhalación"
    },
    {
      "code" : "45351000122109",
      "display" : "corticotrofina"
    },
    {
      "code" : "42711000122103",
      "display" : "crema con ditranol"
    },
    {
      "code" : "44431000122108",
      "display" : "cremas con urea"
    },
    {
      "code" : "52431000122100",
      "display" : "cromo"
    },
    {
      "code" : "42261000122109",
      "display" : "cromoglicato y fármacos antialérgicos relacionados"
    },
    {
      "code" : "42671000122102",
      "display" : "crustáceos"
    },
    {
      "code" : "61991000122106",
      "display" : "cucaracha Blatella germanica"
    },
    {
      "code" : "62011000122106",
      "display" : "cucaracha Periplaneta americana"
    },
    {
      "code" : "61981000122108",
      "display" : "cucarachas"
    },
    {
      "code" : "53671000122108",
      "display" : "cúrcuma"
    },
    {
      "code" : "55851000122103",
      "display" : "cutánea"
    },
    {
      "code" : "251401005",
      "display" : "D-Xilosa"
    },
    {
      "code" : "41771000122104",
      "display" : "daclatasvir"
    },
    {
      "code" : "56121000122109",
      "display" : "dactinomicina"
    },
    {
      "code" : "57531000122103",
      "display" : "danaparoide de sodio"
    },
    {
      "code" : "54181000122101",
      "display" : "danazol"
    },
    {
      "code" : "44871000122108",
      "display" : "dantrón"
    },
    {
      "code" : "44881000122106",
      "display" : "dapsona"
    },
    {
      "code" : "58251000122107",
      "display" : "dasabuvir"
    },
    {
      "code" : "53471000122105",
      "display" : "dasatinib"
    },
    {
      "code" : "41251000122102",
      "display" : "debrisoquina"
    },
    {
      "code" : "52731000122109",
      "display" : "decanoato de flufenazina"
    },
    {
      "code" : "50731000122105",
      "display" : "decanoato de haloperidol"
    },
    {
      "code" : "41321000122104",
      "display" : "decanoato de zuclopentixol"
    },
    {
      "code" : "251403008",
      "display" : "del intestino delgado a la glucosa"
    },
    {
      "code" : "41241000122104",
      "display" : "demecario"
    },
    {
      "code" : "53641000122102",
      "display" : "demeclociclina"
    },
    {
      "code" : "48601000122109",
      "display" : "derivado de la fenotiazina"
    },
    {
      "code" : "60481000122109",
      "display" : "derivado del nitrofurano"
    },
    {
      "code" : "42181000122107",
      "display" : "derivados del factor de von Willebrand"
    },
    {
      "code" : "44371000122100",
      "display" : "dermatophagoides farinae"
    },
    {
      "code" : "46071000122107",
      "display" : "dermatophagoides pteronyssinus"
    },
    {
      "code" : "50001000122102",
      "display" : "desferrioxamina"
    },
    {
      "code" : "50151000122104",
      "display" : "desflurano"
    },
    {
      "code" : "40351000122104",
      "display" : "desinfectante con aldehído"
    },
    {
      "code" : "58861000122108",
      "display" : "desinfectante con amidina"
    },
    {
      "code" : "45821000122108",
      "display" : "desinfectante con biguanida"
    },
    {
      "code" : "52091000122106",
      "display" : "desinfectante fenólico clorado"
    },
    {
      "code" : "45221000122107",
      "display" : "desipramina"
    },
    {
      "code" : "45941000122106",
      "display" : "desmopresina"
    },
    {
      "code" : "42731000122107",
      "display" : "desonida"
    },
    {
      "code" : "46621000122102",
      "display" : "desoximetasona"
    },
    {
      "code" : "49161000122106",
      "display" : "desoxirribonucleasa"
    },
    {
      "code" : "53511000122102",
      "display" : "dexametasona"
    },
    {
      "code" : "53741000122106",
      "display" : "dexametasona tópica"
    },
    {
      "code" : "52331000122105",
      "display" : "dexfenfluramina"
    },
    {
      "code" : "45371000122101",
      "display" : "dexketoprofeno"
    },
    {
      "code" : "61061000122101",
      "display" : "dexrazoxano"
    },
    {
      "code" : "49631000122105",
      "display" : "dextroanfetamina"
    },
    {
      "code" : "48541000122105",
      "display" : "dextromoramida"
    },
    {
      "code" : "43831000122107",
      "display" : "dextropropoxifeno"
    },
    {
      "code" : "41511000122101",
      "display" : "dextrotiroxina sódica"
    },
    {
      "code" : "52811000122107",
      "display" : "diacetato de etinodiol"
    },
    {
      "code" : "52461000122107",
      "display" : "diaminopiridina"
    },
    {
      "code" : "41871000122106",
      "display" : "diamorfina"
    },
    {
      "code" : "45771000122102",
      "display" : "diazepam"
    },
    {
      "code" : "57541000122106",
      "display" : "diazóxido"
    },
    {
      "code" : "40301000122103",
      "display" : "diciclomina"
    },
    {
      "code" : "48151000122104",
      "display" : "diclofenaco"
    },
    {
      "code" : "44641000122103",
      "display" : "dicloralfenazona"
    },
    {
      "code" : "45751000122105",
      "display" : "diclorfenamida"
    },
    {
      "code" : "42201000122108",
      "display" : "didanosina"
    },
    {
      "code" : "48451000122106",
      "display" : "didrogesterona"
    },
    {
      "code" : "51411000122104",
      "display" : "dienestrol"
    },
    {
      "code" : "60231000122109",
      "display" : "dietil éter"
    },
    {
      "code" : "46021000122106",
      "display" : "dietilcarbamazina"
    },
    {
      "code" : "44501000122101",
      "display" : "difenhidramina"
    },
    {
      "code" : "61191000122108",
      "display" : "difenidol"
    },
    {
      "code" : "50191000122108",
      "display" : "difenilpiralina"
    },
    {
      "code" : "48761000122103",
      "display" : "diflucortolona"
    },
    {
      "code" : "55351000122106",
      "display" : "digitoxina"
    },
    {
      "code" : "52591000122102",
      "display" : "dihidrocodeína"
    },
    {
      "code" : "42511000122108",
      "display" : "diloxanida"
    },
    {
      "code" : "40811000122106",
      "display" : "dimenhidrinato"
    },
    {
      "code" : "51391000122104",
      "display" : "dimercaprol"
    },
    {
      "code" : "51021000122104",
      "display" : "dimetil-éter propano"
    },
    {
      "code" : "51761000122106",
      "display" : "dimetilsulfóxido"
    },
    {
      "code" : "54121000122100",
      "display" : "dinitrato de isosorbida"
    },
    {
      "code" : "51011000122105",
      "display" : "dinitrato de isosorbida de liberación modificada"
    },
    {
      "code" : "50481000122100",
      "display" : "dinitrato de isosorbida parenteral"
    },
    {
      "code" : "59711000122109",
      "display" : "dinoprost"
    },
    {
      "code" : "46131000122105",
      "display" : "dióxido de azufre y sulfitos en concentraciones superiores a 10 mg/kg o 10 mg/l"
    },
    {
      "code" : "56091000122105",
      "display" : "dipipanona"
    },
    {
      "code" : "49871000122107",
      "display" : "dipiridamol"
    },
    {
      "code" : "38032004",
      "display" : "disacáridos de tipo III"
    },
    {
      "code" : "78373000",
      "display" : "disacáridos I"
    },
    {
      "code" : "40451000122109",
      "display" : "disopiramida"
    },
    {
      "code" : "46441000122105",
      "display" : "distigmina"
    },
    {
      "code" : "57991000122107",
      "display" : "ditranol"
    },
    {
      "code" : "44801000122104",
      "display" : "diurético ahorrador de potasio"
    },
    {
      "code" : "42411000122107",
      "display" : "diurético de asa"
    },
    {
      "code" : "56151000122102",
      "display" : "diurético mercurial"
    },
    {
      "code" : "42041000122102",
      "display" : "diurético osmótico"
    },
    {
      "code" : "49071000122102",
      "display" : "dobutamina"
    },
    {
      "code" : "47271000122101",
      "display" : "docusato"
    },
    {
      "code" : "53661000122103",
      "display" : "domifeno"
    },
    {
      "code" : "57461000122109",
      "display" : "domperidona"
    },
    {
      "code" : "47151000122103",
      "display" : "dopamina"
    },
    {
      "code" : "53551000122101",
      "display" : "dorada"
    },
    {
      "code" : "60761000122106",
      "display" : "dorzolamida"
    },
    {
      "code" : "47321000122107",
      "display" : "doxacurio"
    },
    {
      "code" : "57201000122107",
      "display" : "doxapram"
    },
    {
      "code" : "49611000122101",
      "display" : "doxepina"
    },
    {
      "code" : "46101000122104",
      "display" : "doxiciclina"
    },
    {
      "code" : "40191000122106",
      "display" : "doxorubicina"
    },
    {
      "code" : "47521000122104",
      "display" : "droperidol"
    },
    {
      "code" : "58671000122102",
      "display" : "econazol"
    },
    {
      "code" : "44751000122109",
      "display" : "ecotiopato"
    },
    {
      "code" : "51471000122106",
      "display" : "edetato de calcio sódico"
    },
    {
      "code" : "55531000122105",
      "display" : "edetato de dicobalto"
    },
    {
      "code" : "54511000122100",
      "display" : "edetato trisódico"
    },
    {
      "code" : "45851000122101",
      "display" : "edrofonio"
    },
    {
      "code" : "45161000122108",
      "display" : "edulcorante"
    },
    {
      "code" : "57121000122107",
      "display" : "efedrina"
    },
    {
      "code" : "61071000122106",
      "display" : "eflornitina"
    },
    {
      "code" : "50341000122103",
      "display" : "electrólito aniónico"
    },
    {
      "code" : "60751000122109",
      "display" : "eliglustat"
    },
    {
      "code" : "44241000122101",
      "display" : "emplastos"
    },
    {
      "code" : "45651000122102",
      "display" : "enantato de flufenazina"
    },
    {
      "code" : "50541000122105",
      "display" : "enbucrilato"
    },
    {
      "code" : "40281000122102",
      "display" : "endibia"
    },
    {
      "code" : "46781000122107",
      "display" : "eneldo"
    },
    {
      "code" : "47751000122104",
      "display" : "enflurano"
    },
    {
      "code" : "50561000122109",
      "display" : "enoxacino"
    },
    {
      "code" : "48981000122108",
      "display" : "enoxaparina"
    },
    {
      "code" : "48651000122108",
      "display" : "enoximona"
    },
    {
      "code" : "62121000122104",
      "display" : "Entomophagus del pimentón"
    },
    {
      "code" : "53011000122109",
      "display" : "enzima medicinal"
    },
    {
      "code" : "53981000122100",
      "display" : "epinastina"
    },
    {
      "code" : "42751000122102",
      "display" : "epinefrina"
    },
    {
      "code" : "56421000122102",
      "display" : "epirubicina"
    },
    {
      "code" : "58441000122106",
      "display" : "epitelio de animal"
    },
    {
      "code" : "54551000122104",
      "display" : "epitelio de caballo"
    },
    {
      "code" : "59081000122101",
      "display" : "epitelio de conejo"
    },
    {
      "code" : "43761000122108",
      "display" : "epitelio de gato"
    },
    {
      "code" : "40581000122104",
      "display" : "epitelio de hámster"
    },
    {
      "code" : "46411000122106",
      "display" : "epitelio de perro"
    },
    {
      "code" : "59291000122109",
      "display" : "epoetina alfa"
    },
    {
      "code" : "51971000122104",
      "display" : "epoetina beta"
    },
    {
      "code" : "58711000122103",
      "display" : "epoprostenol"
    },
    {
      "code" : "42911000122100",
      "display" : "eprosartán"
    },
    {
      "code" : "52891000122104",
      "display" : "ergolina"
    },
    {
      "code" : "48901000122101",
      "display" : "ergometrina"
    },
    {
      "code" : "49311000122106",
      "display" : "eritropoyetina"
    },
    {
      "code" : "47691000122103",
      "display" : "ertapenem"
    },
    {
      "code" : "61161000122102",
      "display" : "escopolamina"
    },
    {
      "code" : "61751000122100",
      "display" : "escualeno"
    },
    {
      "code" : "54081000122102",
      "display" : "esomeprazol"
    },
    {
      "code" : "61741000122102",
      "display" : "espárrago verde"
    },
    {
      "code" : "50211000122109",
      "display" : "espelta"
    },
    {
      "code" : "59621000122109",
      "display" : "espinaca"
    },
    {
      "code" : "40241000122106",
      "display" : "espironolactona y a diurético de asa"
    },
    {
      "code" : "47721000122106",
      "display" : "espironolactona y a diurético tiazídico"
    },
    {
      "code" : "50931000122107",
      "display" : "estanozolol"
    },
    {
      "code" : "61351000122101",
      "display" : "éster de p-hidroxibenzoato"
    },
    {
      "code" : "45141000122109",
      "display" : "estibogluconato de sodio"
    },
    {
      "code" : "46821000122103",
      "display" : "estradiol"
    },
    {
      "code" : "43481000122106",
      "display" : "estradiol administrado por vía oral"
    },
    {
      "code" : "59361000122106",
      "display" : "estramustina"
    },
    {
      "code" : "54671000122106",
      "display" : "estreptomicina"
    },
    {
      "code" : "56861000122109",
      "display" : "estreptoquinasa estreptodornasa"
    },
    {
      "code" : "56251000122108",
      "display" : "estriol"
    },
    {
      "code" : "46611000122108",
      "display" : "estrógenos conjugados"
    },
    {
      "code" : "50961000122100",
      "display" : "etambutol"
    },
    {
      "code" : "44861000122103",
      "display" : "etamiván"
    },
    {
      "code" : "59871000122109",
      "display" : "etanolamina"
    },
    {
      "code" : "57671000122101",
      "display" : "éter"
    },
    {
      "code" : "52231000122104",
      "display" : "etidronato disódico y a carbonato de calcio"
    },
    {
      "code" : "56641000122109",
      "display" : "etilefrina"
    },
    {
      "code" : "59511000122104",
      "display" : "etodolaco"
    },
    {
      "code" : "53891000122108",
      "display" : "etoglúcido"
    },
    {
      "code" : "40291000122104",
      "display" : "etopósido"
    },
    {
      "code" : "45621000122109",
      "display" : "etosuximida"
    },
    {
      "code" : "56031000122106",
      "display" : "eucalipto"
    },
    {
      "code" : "58851000122106",
      "display" : "excipiente"
    },
    {
      "code" : "54271000122109",
      "display" : "factores estimulantes de colonias"
    },
    {
      "code" : "44891000122109",
      "display" : "famciclovir"
    },
    {
      "code" : "25744000",
      "display" : "familiar a la lactosa grave"
    },
    {
      "code" : "41851000122103",
      "display" : "fármaco agonista de receptor alfa-adrenérgico"
    },
    {
      "code" : "47131000122108",
      "display" : "fármaco agonista de receptor alfa-adrenérgico de acción central"
    },
    {
      "code" : "47241000122107",
      "display" : "fármaco alquilante"
    },
    {
      "code" : "49301000122108",
      "display" : "fármaco análogo de la petidina"
    },
    {
      "code" : "53311000122106",
      "display" : "fármaco anorexígeno de acción central"
    },
    {
      "code" : "48211000122109",
      "display" : "fármaco antiácido"
    },
    {
      "code" : "50071000122106",
      "display" : "fármaco antiarrítmico"
    },
    {
      "code" : "57031000122109",
      "display" : "fármaco antiarrítmico clase I"
    },
    {
      "code" : "54891000122106",
      "display" : "productos vitamínicos"
    },
    {
      "code" : "59461000122102",
      "display" : "progestágeno"
    },
    {
      "code" : "50631000122103",
      "display" : "progesterona"
    },
    {
      "code" : "42311000122104",
      "display" : "proguanil"
    },
    {
      "code" : "41021000122102",
      "display" : "prolintano"
    },
    {
      "code" : "55191000122104",
      "display" : "promazina"
    },
    {
      "code" : "58261000122109",
      "display" : "promestrieno"
    },
    {
      "code" : "53221000122105",
      "display" : "prometazina"
    },
    {
      "code" : "47081000122108",
      "display" : "propafenona"
    },
    {
      "code" : "58061000122103",
      "display" : "propantelina"
    },
    {
      "code" : "60451000122103",
      "display" : "propifenazona"
    },
    {
      "code" : "55981000122104",
      "display" : "propiltiouracilo"
    },
    {
      "code" : "46231000122101",
      "display" : "propionato de drostanolona"
    },
    {
      "code" : "43011000122107",
      "display" : "propofol"
    },
    {
      "code" : "44361000122105",
      "display" : "propranolol"
    },
    {
      "code" : "42171000122109",
      "display" : "prostaglandina"
    },
    {
      "code" : "43471000122108",
      "display" : "prostaglandina, serie A"
    },
    {
      "code" : "43701000122107",
      "display" : "prostaglandina, serie E"
    },
    {
      "code" : "43171000122104",
      "display" : "prostaglandina, serie F"
    },
    {
      "code" : "47771000122107",
      "display" : "prostaglandina, serie I"
    },
    {
      "code" : "41441000122103",
      "display" : "protamina"
    },
    {
      "code" : "303852004",
      "display" : "proteica lisinúrica"
    },
    {
      "code" : "60111000122109",
      "display" : "proteína animal"
    },
    {
      "code" : "58381000122109",
      "display" : "proteína del huevo"
    },
    {
      "code" : "50056009",
      "display" : "proteína lisinúrica, tipo 1"
    },
    {
      "code" : "71751002",
      "display" : "proteína lisinúrica, tipo 2"
    },
    {
      "code" : "45151000122106",
      "display" : "proteínas de leche de vaca [APLV] no mediada por IgE"
    },
    {
      "code" : "40661000122108",
      "display" : "protirelina"
    },
    {
      "code" : "47971000122109",
      "display" : "proximetacaína"
    },
    {
      "code" : "50671000122100",
      "display" : "pseudoefedrina"
    },
    {
      "code" : "40521000122103",
      "display" : "puerro"
    },
    {
      "code" : "45171000122103",
      "display" : "pumactant"
    },
    {
      "code" : "56871000122104",
      "display" : "queso"
    },
    {
      "code" : "48351000122101",
      "display" : "quimotripsina"
    },
    {
      "code" : "52961000122104",
      "display" : "quinacrina"
    },
    {
      "code" : "60491000122107",
      "display" : "quinazolina"
    },
    {
      "code" : "49151000122109",
      "display" : "quinestradol"
    },
    {
      "code" : "41591000122109",
      "display" : "quinidina"
    },
    {
      "code" : "59181000122100",
      "display" : "quinina"
    },
    {
      "code" : "55591000122109",
      "display" : "rabeprazol"
    },
    {
      "code" : "48061000122101",
      "display" : "radiofármaco"
    },
    {
      "code" : "41081000122103",
      "display" : "raloxifeno"
    },
    {
      "code" : "48101000122103",
      "display" : "raltegravir"
    },
    {
      "code" : "58351000122103",
      "display" : "ranitidina"
    },
    {
      "code" : "49281000122109",
      "display" : "rapacuronio"
    },
    {
      "code" : "44191000122101",
      "display" : "rasagilina"
    },
    {
      "code" : "45631000122107",
      "display" : "reactivador de colinesterasa"
    },
    {
      "code" : "52251000122109",
      "display" : "regaliz"
    },
    {
      "code" : "40331000122109",
      "display" : "remifentanilo"
    },
    {
      "code" : "58731000122107",
      "display" : "remolacha"
    },
    {
      "code" : "59571000122106",
      "display" : "remoxiprida"
    },
    {
      "code" : "53231000122108",
      "display" : "reproterol"
    },
    {
      "code" : "52441000122108",
      "display" : "resina de árbol"
    },
    {
      "code" : "55631000122109",
      "display" : "resina de intercambio catiónico"
    },
    {
      "code" : "58191000122105",
      "display" : "resina de intercambio iónico"
    },
    {
      "code" : "59671000122105",
      "display" : "resina de podófilo"
    },
    {
      "code" : "61201000122106",
      "display" : "riboflavina"
    },
    {
      "code" : "47741000122101",
      "display" : "rifabutina"
    },
    {
      "code" : "58811000122105",
      "display" : "rilpivirina"
    },
    {
      "code" : "57931000122108",
      "display" : "rimiterol"
    },
    {
      "code" : "41191000122104",
      "display" : "risperidona"
    },
    {
      "code" : "54531000122109",
      "display" : "ritodrina"
    },
    {
      "code" : "41731000122102",
      "display" : "rocuronio"
    },
    {
      "code" : "45311000122108",
      "display" : "rodaballo"
    },
    {
      "code" : "60841000122102",
      "display" : "ropivacaína"
    },
    {
      "code" : "60151000122105",
      "display" : "rosuvastatina"
    },
    {
      "code" : "47701000122103",
      "display" : "rufloxacino"
    },
    {
      "code" : "247994001",
      "display" : "ruido"
    },
    {
      "code" : "44441000122100",
      "display" : "sal ferrosa"
    },
    {
      "code" : "41711000122106",
      "display" : "salbutamol"
    },
    {
      "code" : "48041000122100",
      "display" : "salicilatos"
    },
    {
      "code" : "50471000122103",
      "display" : "saliva artificial"
    },
    {
      "code" : "52121000122105",
      "display" : "salmón"
    },
    {
      "code" : "55721000122100",
      "display" : "salmonete"
    },
    {
      "code" : "41341000122109",
      "display" : "sandía"
    },
    {
      "code" : "50531000122102",
      "display" : "saquinavir"
    },
    {
      "code" : "54961000122106",
      "display" : "savinasa"
    },
    {
      "code" : "60641000122103",
      "display" : "saxagliptina"
    },
    {
      "code" : "59441000122101",
      "display" : "secobarbital"
    },
    {
      "code" : "54001000122109",
      "display" : "sedante a base de carbamato"
    },
    {
      "code" : "47471000122102",
      "display" : "sedante barbitúrico"
    },
    {
      "code" : "59551000122103",
      "display" : "sedante benzodiazepínico"
    },
    {
      "code" : "40591000122101",
      "display" : "sedante de cloral"
    },
    {
      "code" : "43791000122102",
      "display" : "selegilina"
    },
    {
      "code" : "46181000122106",
      "display" : "selenio tópico"
    },
    {
      "code" : "62051000122107",
      "display" : "semilla de adormidera"
    },
    {
      "code" : "60261000122102",
      "display" : "semilla de amapola"
    },
    {
      "code" : "60271000122107",
      "display" : "semilla de fenureco"
    },
    {
      "code" : "62041000122105",
      "display" : "semilla de lino"
    },
    {
      "code" : "57391000122106",
      "display" : "semillas"
    },
    {
      "code" : "49791000122104",
      "display" : "semillas de sésamo"
    },
    {
      "code" : "44421000122105",
      "display" : "sen"
    },
    {
      "code" : "277841004",
      "display" : "sensitiva"
    },
    {
      "code" : "61641000122106",
      "display" : "sepia"
    },
    {
      "code" : "54411000122101",
      "display" : "sertralina"
    },
    {
      "code" : "52631000122102",
      "display" : "seta"
    },
    {
      "code" : "60931000122102",
      "display" : "sevelámero y sus derivados"
    },
    {
      "code" : "43681000122109",
      "display" : "sevoflurano"
    },
    {
      "code" : "46871000122102",
      "display" : "sildenafilo"
    },
    {
      "code" : "45951000122108",
      "display" : "silicona"
    },
    {
      "code" : "48071000122106",
      "display" : "siluro"
    },
    {
      "code" : "41671000122107",
      "display" : "simvastatina"
    },
    {
      "code" : "55001000122105",
      "display" : "sin intolerancias conocidas"
    },
    {
      "code" : "237978005",
      "display" : "síndrome de intolerancia al glicerol"
    },
    {
      "code" : "785696007",
      "display" : "síndrome de malabsorción debido a intolerancia a la lactosa"
    },
    {
      "code" : "785704008",
      "display" : "sindrome de malabsorción debido a intolerancia adquirida a la fructosa"
    },
    {
      "code" : "58721000122109",
      "display" : "sirolimús y sus derivados"
    },
    {
      "code" : "42351000122103",
      "display" : "soja"
    },
    {
      "code" : "54921000122102",
      "display" : "solifenacina"
    },
    {
      "code" : "47051000122102",
      "display" : "solución de cardioplejía"
    },
    {
      "code" : "48831000122104",
      "display" : "solución de hemofiltración"
    },
    {
      "code" : "48991000122106",
      "display" : "solución de proteína plasmática"
    },
    {
      "code" : "56361000122102",
      "display" : "soluciones cloradas"
    },
    {
      "code" : "60921000122100",
      "display" : "somatostatina y sus análogos"
    },
    {
      "code" : "47571000122103",
      "display" : "somatotrofina"
    },
    {
      "code" : "44601000122100",
      "display" : "succinato ferroso"
    },
    {
      "code" : "54291000122105",
      "display" : "sucralfato"
    },
    {
      "code" : "61501000122108",
      "display" : "suero antiofídico"
    },
    {
      "code" : "56771000122106",
      "display" : "sulconazol"
    },
    {
      "code" : "48121000122106",
      "display" : "sulfacetamida"
    },
    {
      "code" : "40971000122108",
      "display" : "sulfadiazina"
    },
    {
      "code" : "55731000122102",
      "display" : "sulfadimetoxina"
    },
    {
      "code" : "59231000122105",
      "display" : "sulfadimidina"
    },
    {
      "code" : "52021000122109",
      "display" : "sulfaguanidina"
    },
    {
      "code" : "52901000122100",
      "display" : "sulfaloxato de calcio"
    },
    {
      "code" : "41791000122103",
      "display" : "sulfametoxazol"
    },
    {
      "code" : "55551000122100",
      "display" : "sulfametoxazol + trimetoprima"
    },
    {
      "code" : "57641000122107",
      "display" : "sulfasalazina"
    },
    {
      "code" : "54871000122105",
      "display" : "sulfato de estreptomicina"
    },
    {
      "code" : "50111000122100",
      "display" : "sulfato de estrona piperacina"
    },
    {
      "code" : "43361000122107",
      "display" : "sulfato de magnesio"
    },
    {
      "code" : "51951000122107",
      "display" : "sulfato de neomicina"
    },
    {
      "code" : "40741000122100",
      "display" : "sulfato ferroso"
    },
    {
      "code" : "48801000122105",
      "display" : "sulfinpirazona"
    },
    {
      "code" : "50681000122102",
      "display" : "sulfonamidas"
    },
    {
      "code" : "59381000122103",
      "display" : "sulfonilurea"
    },
    {
      "code" : "45601000122101",
      "display" : "sulindaco"
    },
    {
      "code" : "57711000122102",
      "display" : "sumatriptán"
    },
    {
      "code" : "43341000122108",
      "display" : "sunitinib"
    },
    {
      "code" : "57851000122105",
      "display" : "surfactante catiónico"
    },
    {
      "code" : "45921000122101",
      "display" : "surfactante de amonio cuaternario"
    },
    {
      "code" : "46051000122104",
      "display" : "surfactante de piridinio cuaternario"
    },
    {
      "code" : "55131000122103",
      "display" : "surfactante no iónico"
    },
    {
      "code" : "51291000122108",
      "display" : "surfactante respiratorio"
    },
    {
      "code" : "48441000122109",
      "display" : "suspensión de insulina cinc [amorfa]"
    },
    {
      "code" : "782197009",
      "display" : "sustancia"
    },
    {
      "code" : "58691000122101",
      "display" : "sustancia astringente"
    },
    {
      "code" : "43801000122101",
      "display" : "sustancia astringente de aluminio"
    },
    {
      "code" : "61281000122104",
      "display" : "sustancia plástica"
    },
    {
      "code" : "53451000122102",
      "display" : "sustancias emolientes"
    },
    {
      "code" : "54111000122106",
      "display" : "suxametonio"
    },
    {
      "code" : "60551000122102",
      "display" : "suximidas"
    },
    {
      "code" : "53081000122104",
      "display" : "tadalafilo"
    },
    {
      "code" : "58511000122108",
      "display" : "iprindol"
    },
    {
      "code" : "46491000122103",
      "display" : "iproniazida"
    },
    {
      "code" : "49661000122103",
      "display" : "irinotecán"
    },
    {
      "code" : "54211000122102",
      "display" : "isetionato de dibrompropamidina"
    },
    {
      "code" : "54621000122105",
      "display" : "isetionato de propamidina"
    },
    {
      "code" : "48891000122100",
      "display" : "isoaminilo"
    },
    {
      "code" : "42801000122107",
      "display" : "isocarboxazida"
    },
    {
      "code" : "43191000122103",
      "display" : "isoconazol"
    },
    {
      "code" : "51751000122109",
      "display" : "isoflurano"
    },
    {
      "code" : "44351000122108",
      "display" : "isoniazida"
    },
    {
      "code" : "48261000122107",
      "display" : "isoprenalina"
    },
    {
      "code" : "51841000122102",
      "display" : "isoprenalina administrada por inhalación"
    },
    {
      "code" : "41921000122103",
      "display" : "isoprenalina administrada por vía oral"
    },
    {
      "code" : "47991000122105",
      "display" : "isoprenalina administrada por vía parenteral"
    },
    {
      "code" : "61021000122105",
      "display" : "isotipendilo"
    },
    {
      "code" : "56211000122107",
      "display" : "isotretinoína"
    },
    {
      "code" : "57411000122106",
      "display" : "isoxsuprina"
    },
    {
      "code" : "42371000122106",
      "display" : "isradipino"
    },
    {
      "code" : "44721000122102",
      "display" : "itraconazol"
    },
    {
      "code" : "57731000122106",
      "display" : "jabón con metal alcalino"
    },
    {
      "code" : "43551000122104",
      "display" : "jengibre"
    },
    {
      "code" : "54791000122102",
      "display" : "josamicina"
    },
    {
      "code" : "61791000122109",
      "display" : "judía verde"
    },
    {
      "code" : "41821000122105",
      "display" : "kanamicina"
    },
    {
      "code" : "46651000122109",
      "display" : "ketamina"
    },
    {
      "code" : "44741000122107",
      "display" : "ketazolam"
    },
    {
      "code" : "40091000122105",
      "display" : "ketoconazol"
    },
    {
      "code" : "45501000122102",
      "display" : "ketoprofeno"
    },
    {
      "code" : "56171000122105",
      "display" : "ketorolaco"
    },
    {
      "code" : "56551000122105",
      "display" : "ketotifeno"
    },
    {
      "code" : "58751000122102",
      "display" : "l-carnitina"
    },
    {
      "code" : "61341000122103",
      "display" : "L-iditol deshidrogenasa"
    },
    {
      "code" : "46631000122104",
      "display" : "lacidipino"
    },
    {
      "code" : "782415009",
      "display" : "lactosa"
    },
    {
      "code" : "54581000122105",
      "display" : "lactulosa"
    },
    {
      "code" : "50051000122103",
      "display" : "lamotrigina"
    },
    {
      "code" : "49321000122100",
      "display" : "lana"
    },
    {
      "code" : "49981000122100",
      "display" : "langosta"
    },
    {
      "code" : "58321000122105",
      "display" : "lansoprazol"
    },
    {
      "code" : "50991000122106",
      "display" : "lapatinib"
    },
    {
      "code" : "59351000122109",
      "display" : "latamoxef"
    },
    {
      "code" : "58771000122105",
      "display" : "laurel"
    },
    {
      "code" : "58531000122104",
      "display" : "laxante a base de antraquinona"
    },
    {
      "code" : "700094005",
      "display" : "leche"
    },
    {
      "code" : "56341000122101",
      "display" : "leche de cabra"
    },
    {
      "code" : "52031000122107",
      "display" : "leche de soja"
    },
    {
      "code" : "738069006",
      "display" : "leche de vaca"
    },
    {
      "code" : "61141000122101",
      "display" : "leflunomida"
    },
    {
      "code" : "50301000122100",
      "display" : "legumbres"
    },
    {
      "code" : "48021000122105",
      "display" : "lenograstim"
    },
    {
      "code" : "41611000122100",
      "display" : "lenteja"
    },
    {
      "code" : "54041000122106",
      "display" : "lercanidipino"
    },
    {
      "code" : "49011000122109",
      "display" : "leuprorelina"
    },
    {
      "code" : "42361000122101",
      "display" : "levamisol"
    },
    {
      "code" : "51941000122105",
      "display" : "levobunolol"
    },
    {
      "code" : "40361000122102",
      "display" : "levodopa"
    },
    {
      "code" : "47801000122109",
      "display" : "levofloxacino"
    },
    {
      "code" : "55571000122108",
      "display" : "levorfanol"
    },
    {
      "code" : "57471000122104",
      "display" : "lichi"
    },
    {
      "code" : "46661000122106",
      "display" : "lidoflazina"
    },
    {
      "code" : "57481000122101",
      "display" : "lima"
    },
    {
      "code" : "43671000122106",
      "display" : "limón"
    },
    {
      "code" : "56761000122101",
      "display" : "limpiadores y desinfectantes"
    },
    {
      "code" : "49541000122103",
      "display" : "lincomicina"
    },
    {
      "code" : "60381000122102",
      "display" : "lincosamidas"
    },
    {
      "code" : "49521000122108",
      "display" : "lindano"
    },
    {
      "code" : "54281000122107",
      "display" : "lipresina"
    },
    {
      "code" : "53041000122108",
      "display" : "liquen"
    },
    {
      "code" : "56241000122106",
      "display" : "líquido de hemodiálisis"
    },
    {
      "code" : "58451000122108",
      "display" : "líquido o solución farmacéutica"
    },
    {
      "code" : "340519003",
      "display" : "lisina"
    },
    {
      "code" : "42901000122103",
      "display" : "lisurida"
    },
    {
      "code" : "49251000122103",
      "display" : "litio"
    },
    {
      "code" : "48411000122105",
      "display" : "lofepramina"
    },
    {
      "code" : "41381000122100",
      "display" : "lofexidina"
    },
    {
      "code" : "52621000122100",
      "display" : "lomustina"
    },
    {
      "code" : "42811000122105",
      "display" : "loperamida"
    },
    {
      "code" : "56391000122108",
      "display" : "loratadina"
    },
    {
      "code" : "41751000122107",
      "display" : "lorazepam"
    },
    {
      "code" : "57831000122100",
      "display" : "lormetazepam"
    },
    {
      "code" : "57131000122105",
      "display" : "losartán"
    },
    {
      "code" : "60141000122108",
      "display" : "lovastatina"
    },
    {
      "code" : "43351000122105",
      "display" : "loxapina"
    },
    {
      "code" : "46111000122101",
      "display" : "lubina"
    },
    {
      "code" : "53811000122100",
      "display" : "lubricantes"
    },
    {
      "code" : "52991000122105",
      "display" : "lúpulo"
    },
    {
      "code" : "40421000122102",
      "display" : "madera"
    },
    {
      "code" : "57081000122105",
      "display" : "mafenida"
    },
    {
      "code" : "45721000122103",
      "display" : "maíz"
    },
    {
      "code" : "42191000122105",
      "display" : "malatión"
    },
    {
      "code" : "43591000122108",
      "display" : "malta"
    },
    {
      "code" : "17561000122100",
      "display" : "maltosa"
    },
    {
      "code" : "55181000122102",
      "display" : "mandarina"
    },
    {
      "code" : "53531000122106",
      "display" : "mandioca"
    },
    {
      "code" : "46191000122109",
      "display" : "mango"
    },
    {
      "code" : "43261000122104",
      "display" : "mango"
    },
    {
      "code" : "48631000122103",
      "display" : "manidipino"
    },
    {
      "code" : "53831000122109",
      "display" : "manitol"
    },
    {
      "code" : "46221000122104",
      "display" : "manzana"
    },
    {
      "code" : "61711000122101",
      "display" : "manzanilla"
    },
    {
      "code" : "42001000122104",
      "display" : "maprotilina"
    },
    {
      "code" : "56231000122103",
      "display" : "marisco"
    },
    {
      "code" : "40031000122106",
      "display" : "material de restauración dental"
    },
    {
      "code" : "54601000122102",
      "display" : "maxatasa"
    },
    {
      "code" : "59471000122107",
      "display" : "mazindol"
    },
    {
      "code" : "56001000122100",
      "display" : "mebendazol"
    },
    {
      "code" : "52051000122102",
      "display" : "mebeverina"
    },
    {
      "code" : "59501000122102",
      "display" : "mebhidrolina"
    },
    {
      "code" : "41521000122107",
      "display" : "medazepam"
    },
    {
      "code" : "51091000122102",
      "display" : "medicamentos homeopáticos"
    },
    {
      "code" : "53851000122104",
      "display" : "medigoxina"
    },
    {
      "code" : "45421000122106",
      "display" : "medio de contraste"
    },
    {
      "code" : "49961000122108",
      "display" : "medio de contraste radiográfico"
    },
    {
      "code" : "60531000122107",
      "display" : "medios de contraste yodados"
    },
    {
      "code" : "51921000122100",
      "display" : "medroxiprogesterona"
    },
    {
      "code" : "46941000122100",
      "display" : "mefrusida"
    },
    {
      "code" : "44101000122106",
      "display" : "megestrol"
    },
    {
      "code" : "58831000122101",
      "display" : "mejillón"
    },
    {
      "code" : "44651000122101",
      "display" : "mejillones"
    },
    {
      "code" : "46981000122109",
      "display" : "melocotón"
    },
    {
      "code" : "41131000122103",
      "display" : "melón"
    },
    {
      "code" : "51511000122103",
      "display" : "mepiramina"
    },
    {
      "code" : "45441000122101",
      "display" : "meprobamato"
    },
    {
      "code" : "50641000122106",
      "display" : "mequitazina"
    },
    {
      "code" : "47461000122107",
      "display" : "mercaptopurina"
    },
    {
      "code" : "54711000122105",
      "display" : "merluza"
    },
    {
      "code" : "59541000122100",
      "display" : "meropenem"
    },
    {
      "code" : "51381000122102",
      "display" : "mersalil"
    },
    {
      "code" : "40671000122103",
      "display" : "mesilato de dihidroergotamina"
    },
    {
      "code" : "43331000122100",
      "display" : "mesna"
    },
    {
      "code" : "56751000122103",
      "display" : "mestranol"
    },
    {
      "code" : "41101000122109",
      "display" : "metacolina"
    },
    {
      "code" : "57801000122106",
      "display" : "metadona"
    },
    {
      "code" : "59261000122103",
      "display" : "metales"
    },
    {
      "code" : "51741000122107",
      "display" : "metaraminol"
    },
    {
      "code" : "61181000122105",
      "display" : "metenamina"
    },
    {
      "code" : "54931000122104",
      "display" : "meticilina"
    },
    {
      "code" : "53721000122101",
      "display" : "meticlotiazida"
    },
    {
      "code" : "47331000122105",
      "display" : "metildopa"
    },
    {
      "code" : "43711000122105",
      "display" : "metildopa y a los diuréticos"
    },
    {
      "code" : "49331000122102",
      "display" : "metilfenobarbital"
    },
    {
      "code" : "51731000122104",
      "display" : "metilprednisolona"
    },
    {
      "code" : "59341000122107",
      "display" : "metiltestosterona"
    },
    {
      "code" : "58791000122106",
      "display" : "metiprilona"
    },
    {
      "code" : "43531000122109",
      "display" : "metirosina"
    },
    {
      "code" : "56711000122104",
      "display" : "metocarbamol"
    },
    {
      "code" : "50691000122104",
      "display" : "metoclopramida"
    },
    {
      "code" : "56481000122103",
      "display" : "metolazona"
    },
    {
      "code" : "58231000122102",
      "display" : "metoprolol"
    },
    {
      "code" : "51281000122105",
      "display" : "metotrimeprazina"
    },
    {
      "code" : "48581000122101",
      "display" : "metoxamina"
    },
    {
      "code" : "47821000122101",
      "display" : "mexiletina"
    },
    {
      "code" : "47981000122107",
      "display" : "mezlocilina"
    },
    {
      "code" : "60861000122103",
      "display" : "micafungina"
    },
    {
      "code" : "51931000122102",
      "display" : "miconazol"
    },
    {
      "code" : "42151000122101",
      "display" : "miel"
    },
    {
      "code" : "47411000122109",
      "display" : "mifepristona"
    },
    {
      "code" : "59681000122108",
      "display" : "milrinona"
    },
    {
      "code" : "46201000122107",
      "display" : "minociclina"
    },
    {
      "code" : "58911000122100",
      "display" : "minoxidil"
    },
    {
      "code" : "46681000122103",
      "display" : "miorrelajante"
    },
    {
      "code" : "57181000122106",
      "display" : "miorrelajante no despolarizante"
    },
    {
      "code" : "52831000122103",
      "display" : "miorrelajantes no despolarizantes"
    },
    {
      "code" : "41031000122104",
      "display" : "mirtecaína"
    },
    {
      "code" : "49021000122103",
      "display" : "misoprostol"
    },
    {
      "code" : "49391000122103",
      "display" : "mitobronitol"
    },
    {
      "code" : "48951000122102",
      "display" : "mitomicina"
    },
    {
      "code" : "55491000122105",
      "display" : "mitoxantrona"
    },
    {
      "code" : "46671000122101",
      "display" : "mivacurio"
    },
    {
      "code" : "43451000122100",
      "display" : "moclobemida"
    },
    {
      "code" : "56311000122100",
      "display" : "modificador de la viscosidad"
    },
    {
      "code" : "49051000122105",
      "display" : "modificador de la viscosidad derivado de la celulosa"
    },
    {
      "code" : "53601000122104",
      "display" : "moexipril"
    },
    {
      "code" : "51831000122105",
      "display" : "moho"
    },
    {
      "code" : "45281000122106",
      "display" : "molgramostim"
    },
    {
      "code" : "40861000122109",
      "display" : "molusco"
    },
    {
      "code" : "54391000122101",
      "display" : "mometasona"
    },
    {
      "code" : "43511000122100",
      "display" : "monobactam"
    },
    {
      "code" : "47101000122102",
      "display" : "mononitrato de isosorbida"
    },
    {
      "code" : "53281000122109",
      "display" : "mononitrato de isosorbida de liberación modificada"
    },
    {
      "code" : "54261000122104",
      "display" : "monosulfiram"
    },
    {
      "code" : "61011000122104",
      "display" : "montelukast"
    },
    {
      "code" : "43541000122101",
      "display" : "mora"
    },
    {
      "code" : "43091000122104",
      "display" : "moracizina"
    },
    {
      "code" : "43721000122104",
      "display" : "morfina"
    },
    {
      "code" : "62061000122109",
      "display" : "mosca doméstica"
    },
    {
      "code" : "57941000122100",
      "display" : "mostaza"
    },
    {
      "code" : "53681000122106",
      "display" : "mostaza alimentaria"
    },
    {
      "code" : "41431000122106",
      "display" : "mupirocina"
    },
    {
      "code" : "50171000122107",
      "display" : "mustina"
    },
    {
      "code" : "48161000122102",
      "display" : "Myroxylon pereirae"
    },
    {
      "code" : "54941000122107",
      "display" : "nabo"
    },
    {
      "code" : "56401000122105",
      "display" : "nabumetona"
    },
    {
      "code" : "56971000122108",
      "display" : "nafarelina"
    },
    {
      "code" : "43521000122106",
      "display" : "naftidrofurilo"
    },
    {
      "code" : "47591000122102",
      "display" : "nalbufina"
    },
    {
      "code" : "57441000122105",
      "display" : "nalmefeno"
    },
    {
      "code" : "42141000122103",
      "display" : "naltrexona"
    },
    {
      "code" : "52001000122101",
      "display" : "nandrolona"
    },
    {
      "code" : "48561000122109",
      "display" : "naranja"
    },
    {
      "code" : "52181000122109",
      "display" : "naratriptán"
    },
    {
      "code" : "60801000122104",
      "display" : "nebivolol"
    },
    {
      "code" : "52481000122104",
      "display" : "nectarina"
    },
    {
      "code" : "51321000122101",
      "display" : "nefazodona"
    },
    {
      "code" : "57871000122102",
      "display" : "nefopam"
    },
    {
      "code" : "41811000122104",
      "display" : "neostigmina"
    },
    {
      "code" : "43211000122102",
      "display" : "netilmicina"
    },
    {
      "code" : "49191000122100",
      "display" : "niacinamida"
    },
    {
      "code" : "41401000122100",
      "display" : "nicardipino"
    },
    {
      "code" : "52681000122101",
      "display" : "nicofuranosa"
    },
    {
      "code" : "41361000122108",
      "display" : "nicorandil"
    },
    {
      "code" : "42721000122109",
      "display" : "nicotinato de inositol"
    },
    {
      "code" : "58121000122108",
      "display" : "nicumalona"
    },
    {
      "code" : "44251000122104",
      "display" : "nilotinib"
    },
    {
      "code" : "57971000122106",
      "display" : "nimodipino"
    },
    {
      "code" : "56021000122108",
      "display" : "níquel"
    },
    {
      "code" : "55331000122101",
      "display" : "niquetamida"
    },
    {
      "code" : "48551000122107",
      "display" : "nistatina"
    },
    {
      "code" : "52171000122106",
      "display" : "nitrato de plata"
    },
    {
      "code" : "44841000122102",
      "display" : "nitrito de sodio"
    },
    {
      "code" : "58471000122100",
      "display" : "nitrofenol"
    },
    {
      "code" : "51821000122107",
      "display" : "nitrofurazona"
    },
    {
      "code" : "50231000122100",
      "display" : "nitroimidazol"
    },
    {
      "code" : "45901000122109",
      "display" : "nitrosourea"
    },
    {
      "code" : "47951000122101",
      "display" : "nizatidina"
    },
    {
      "code" : "49201000122102",
      "display" : "nonoxinol"
    },
    {
      "code" : "57341000122104",
      "display" : "noretisterona"
    },
    {
      "code" : "42051000122100",
      "display" : "norfloxacino"
    },
    {
      "code" : "56921000122107",
      "display" : "noscapina"
    },
    {
      "code" : "59411000122100",
      "display" : "noxitiolina"
    },
    {
      "code" : "53631000122105",
      "display" : "nuez de Brasil"
    },
    {
      "code" : "50711000122101",
      "display" : "nuez de macadamia"
    },
    {
      "code" : "59561000122101",
      "display" : "nuez de pecán"
    },
    {
      "code" : "61721000122107",
      "display" : "nuez moscada"
    },
    {
      "code" : "51661000122104",
      "display" : "octoxinol"
    },
    {
      "code" : "42861000122108",
      "display" : "octreotida"
    },
    {
      "code" : "46431000122102",
      "display" : "ofloxacino"
    },
    {
      "code" : "58391000122107",
      "display" : "olsalazina"
    },
    {
      "code" : "47941000122103",
      "display" : "omeprazol"
    },
    {
      "code" : "53181000122103",
      "display" : "opicapona"
    },
    {
      "code" : "47761000122102",
      "display" : "opioide morfeico"
    },
    {
      "code" : "50261000122107",
      "display" : "orciprenalina"
    },
    {
      "code" : "43071000122100",
      "display" : "orégano"
    },
    {
      "code" : "61821000122102",
      "display" : "oreja de mar"
    },
    {
      "code" : "46731000122106",
      "display" : "orfenadrina"
    },
    {
      "code" : "61301000122100",
      "display" : "orlistat"
    },
    {
      "code" : "50801000122105",
      "display" : "oro"
    },
    {
      "code" : "43201000122100",
      "display" : "ortiga"
    },
    {
      "code" : "57301000122101",
      "display" : "ostras"
    },
    {
      "code" : "40271000122100",
      "display" : "ouabaína"
    },
    {
      "code" : "42951000122104",
      "display" : "ovoalbúmina"
    },
    {
      "code" : "61891000122100",
      "display" : "ovomucoide"
    },
    {
      "code" : "60831000122105",
      "display" : "oxacilina"
    },
    {
      "code" : "57651000122109",
      "display" : "oxatomida"
    },
    {
      "code" : "47831000122103",
      "display" : "oxazepam"
    },
    {
      "code" : "41151000122108",
      "display" : "oxibuprocaína"
    },
    {
      "code" : "50601000122109",
      "display" : "oxibutinina"
    },
    {
      "code" : "44031000122101",
      "display" : "oxicodona"
    },
    {
      "code" : "60771000122101",
      "display" : "oxiconazol"
    },
    {
      "code" : "45211000122101",
      "display" : "óxido de etileno"
    },
    {
      "code" : "43921000122102",
      "display" : "óxido mercúrico"
    },
    {
      "code" : "40691000122102",
      "display" : "oxifenbutazona"
    },
    {
      "code" : "54761000122108",
      "display" : "oximetazolina"
    },
    {
      "code" : "44811000122101",
      "display" : "oximetileno"
    },
    {
      "code" : "58991000122108",
      "display" : "oximetolona"
    },
    {
      "code" : "41331000122101",
      "display" : "oxipertina"
    },
    {
      "code" : "45971000122100",
      "display" : "oxitocina"
    },
    {
      "code" : "54541000122101",
      "display" : "oxitocina y a la ergometrina"
    },
    {
      "code" : "61221000122103",
      "display" : "oxolamina"
    },
    {
      "code" : "43401000122104",
      "display" : "oxprenolol"
    },
    {
      "code" : "57821000122103",
      "display" : "palitos de sucedáneo de cangrejo"
    },
    {
      "code" : "61381000122107",
      "display" : "palivizumab"
    },
    {
      "code" : "48191000122108",
      "display" : "pancreatina"
    },
    {
      "code" : "41631000122109",
      "display" : "pancuronio"
    },
    {
      "code" : "42071000122108",
      "display" : "pantoprazol"
    },
    {
      "code" : "47871000122100",
      "display" : "papaverina"
    },
    {
      "code" : "44131000122100",
      "display" : "papaya"
    },
    {
      "code" : "45701000122106",
      "display" : "paracetamol"
    },
    {
      "code" : "54491000122109",
      "display" : "paracetamol y dextropropoxifeno"
    },
    {
      "code" : "54201000122100",
      "display" : "parafina blanda amarilla"
    },
    {
      "code" : "53611000122101",
      "display" : "parafina blanda blanca"
    },
    {
      "code" : "46641000122107",
      "display" : "paraguaya"
    },
    {
      "code" : "51781000122103",
      "display" : "paraldehído"
    },
    {
      "code" : "42471000122100",
      "display" : "parental al trinitrato de glicerina"
    },
    {
      "code" : "58131000122106",
      "display" : "pargeverina"
    },
    {
      "code" : "49101000122105",
      "display" : "pargo"
    },
    {
      "code" : "49911000122105",
      "display" : "pasta con ditranol"
    },
    {
      "code" : "57071000122107",
      "display" : "patata"
    },
    {
      "code" : "45081000122101",
      "display" : "pegaspargasa"
    },
    {
      "code" : "51651000122101",
      "display" : "pelo de animal"
    },
    {
      "code" : "41281000122108",
      "display" : "pelo de gato"
    },
    {
      "code" : "43691000122107",
      "display" : "pemetrexed"
    },
    {
      "code" : "43841000122104",
      "display" : "penbutolol"
    },
    {
      "code" : "58241000122105",
      "display" : "penicilamina"
    },
    {
      "code" : "58981000122105",
      "display" : "penicilina benetamina"
    },
    {
      "code" : "49901000122107",
      "display" : "penicilina benzatínica"
    },
    {
      "code" : "53261000122101",
      "display" : "penicilina procaína"
    },
    {
      "code" : "48091000122107",
      "display" : "penicilinas antipseudomonas"
    },
    {
      "code" : "45321000122102",
      "display" : "penicilinas resistentes a la penicilinasa"
    },
    {
      "code" : "54901000122105",
      "display" : "penicilinas sensibles a la penicilinasa"
    },
    {
      "code" : "57221000122104",
      "display" : "pentamidina"
    },
    {
      "code" : "44171000122102",
      "display" : "pentostatina"
    },
    {
      "code" : "46481000122101",
      "display" : "pentoxifilina"
    },
    {
      "code" : "42291000122103",
      "display" : "pepsina"
    },
    {
      "code" : "45761000122107",
      "display" : "pera"
    },
    {
      "code" : "61571000122104",
      "display" : "percebe"
    },
    {
      "code" : "48861000122106",
      "display" : "perejil"
    },
    {
      "code" : "46841000122108",
      "display" : "perfluoroquímico"
    },
    {
      "code" : "43291000122105",
      "display" : "perfumes"
    },
    {
      "code" : "50821000122102",
      "display" : "periciazina"
    },
    {
      "code" : "40911000122101",
      "display" : "permanganato de potasio"
    },
    {
      "code" : "59211000122101",
      "display" : "permetrina"
    },
    {
      "code" : "54431000122105",
      "display" : "peróxido de hidrógeno"
    },
    {
      "code" : "41971000122102",
      "display" : "pescado"
    },
    {
      "code" : "57591000122104",
      "display" : "pez espada"
    },
    {
      "code" : "48521000122100",
      "display" : "picadura de garrapata"
    },
    {
      "code" : "61911000122103",
      "display" : "picadura de hormiga roja de fuego"
    },
    {
      "code" : "52081000122108",
      "display" : "picadura de mosquito"
    },
    {
      "code" : "61801000122105",
      "display" : "picadura de mosquito Aedes comunis"
    },
    {
      "code" : "61811000122108",
      "display" : "picadura de mosquito Culex pipiens"
    },
    {
      "code" : "50771000122108",
      "display" : "picadura de piojo"
    },
    {
      "code" : "51001000122107",
      "display" : "picadura de tábano"
    },
    {
      "code" : "45121000122104",
      "display" : "picosulfato sódico"
    },
    {
      "code" : "52721000122106",
      "display" : "pilocarpina"
    },
    {
      "code" : "40831000122102",
      "display" : "pimentón"
    },
    {
      "code" : "55641000122101",
      "display" : "pimienta blanca"
    },
    {
      "code" : "50921000122109",
      "display" : "pimienta negra"
    },
    {
      "code" : "47681000122101",
      "display" : "pimiento"
    },
    {
      "code" : "59431000122109",
      "display" : "pimozida"
    },
    {
      "code" : "47931000122106",
      "display" : "pindolol"
    },
    {
      "code" : "55031000122104",
      "display" : "pińa"
    },
    {
      "code" : "58601000122106",
      "display" : "pińón"
    },
    {
      "code" : "55501000122104",
      "display" : "pipas de calabaza"
    },
    {
      "code" : "45251000122100",
      "display" : "pipas de girasol"
    },
    {
      "code" : "45731000122100",
      "display" : "pipenzolato"
    },
    {
      "code" : "56581000122104",
      "display" : "piperacilina"
    },
    {
      "code" : "51861000122103",
      "display" : "piperacilina y tazobactam"
    },
    {
      "code" : "54741000122109",
      "display" : "piperazina"
    },
    {
      "code" : "58701000122101",
      "display" : "piperidina y derivados"
    },
    {
      "code" : "55581000122106",
      "display" : "pipotiazina"
    },
    {
      "code" : "59271000122108",
      "display" : "piracetam"
    },
    {
      "code" : "57371000122105",
      "display" : "pirantel"
    },
    {
      "code" : "49651000122100",
      "display" : "pirazinamida"
    },
    {
      "code" : "49371000122104",
      "display" : "pirazolas y sus derivados"
    },
    {
      "code" : "61901000122101",
      "display" : "pirazolonas"
    },
    {
      "code" : "49761000122105",
      "display" : "pirenzepina"
    },
    {
      "code" : "51191000122101",
      "display" : "piretanida"
    },
    {
      "code" : "44401000122102",
      "display" : "piridostigmina"
    },
    {
      "code" : "57101000122104",
      "display" : "piridoxina"
    },
    {
      "code" : "40341000122101",
      "display" : "piroxicam"
    },
    {
      "code" : "48751000122100",
      "display" : "pistacho"
    },
    {
      "code" : "54151000122107",
      "display" : "pivampicilina"
    },
    {
      "code" : "47711000122100",
      "display" : "pivampicilina y pivmecilinam"
    },
    {
      "code" : "55911000122109",
      "display" : "pivmecilinam"
    },
    {
      "code" : "53781000122102",
      "display" : "plaguicida"
    },
    {
      "code" : "55841000122100",
      "display" : "plaguicida a base de carbamato"
    },
    {
      "code" : "51621000122108",
      "display" : "plaguicida organofosforado"
    },
    {
      "code" : "56841000122105",
      "display" : "plaguicida piretroide"
    },
    {
      "code" : "60671000122109",
      "display" : "plantas de la familia Asteraceae"
    },
    {
      "code" : "58901000122103",
      "display" : "plátano"
    },
    {
      "code" : "58971000122107",
      "display" : "platino y derivados"
    },
    {
      "code" : "58951000122104",
      "display" : "plicamicina"
    },
    {
      "code" : "57791000122105",
      "display" : "podofilotoxina"
    },
    {
      "code" : "58051000122100",
      "display" : "polen"
    },
    {
      "code" : "40171000122105",
      "display" : "polen de abedul"
    },
    {
      "code" : "52871000122100",
      "display" : "polen de agracejo"
    },
    {
      "code" : "58331000122108",
      "display" : "polen de ajenjo"
    },
    {
      "code" : "51851000122100",
      "display" : "polen de álamo"
    },
    {
      "code" : "46151000122100",
      "display" : "polen de aliso"
    },
    {
      "code" : "41531000122105",
      "display" : "polen de almez"
    },
    {
      "code" : "55471000122109",
      "display" : "polen de ambrosía"
    },
    {
      "code" : "40981000122106",
      "display" : "polen de árbol"
    },
    {
      "code" : "57891000122101",
      "display" : "polen de artemisa"
    },
    {
      "code" : "54661000122101",
      "display" : "polen de avellano"
    },
    {
      "code" : "51981000122101",
      "display" : "polen de ballica"
    },
    {
      "code" : "62151000122106",
      "display" : "polen de barrilla"
    },
    {
      "code" : "52741000122101",
      "display" : "polen de casuarina"
    },
    {
      "code" : "46141000122102",
      "display" : "polen de cedro"
    },
    {
      "code" : "59321000122102",
      "display" : "polen de céńigo"
    },
    {
      "code" : "46091000122108",
      "display" : "polen de césped"
    },
    {
      "code" : "42701000122101",
      "display" : "polen de dáctilo"
    },
    {
      "code" : "54981000122103",
      "display" : "polen de diente de león"
    },
    {
      "code" : "56221000122101",
      "display" : "polen de encina"
    },
    {
      "code" : "62161000122108",
      "display" : "polen de enebro rojo"
    },
    {
      "code" : "57721000122108",
      "display" : "polen de euforbio"
    },
    {
      "code" : "59631000122107",
      "display" : "polen de grama común"
    },
    {
      "code" : "55451000122101",
      "display" : "polen de gramíneas"
    },
    {
      "code" : "55921000122103",
      "display" : "polen de hierbas"
    },
    {
      "code" : "47371000122108",
      "display" : "polen de lila"
    },
    {
      "code" : "41831000122108",
      "display" : "polen de mercurial"
    },
    {
      "code" : "44491000122107",
      "display" : "polen de morera"
    },
    {
      "code" : "59251000122100",
      "display" : "polen de olivo"
    },
    {
      "code" : "47071000122105",
      "display" : "polen de olmo"
    },
    {
      "code" : "61511000122106",
      "display" : "polen de ortiga"
    },
    {
      "code" : "40391000122108",
      "display" : "polen de parietaria"
    },
    {
      "code" : "52161000122101",
      "display" : "polen de pino"
    },
    {
      "code" : "47031000122107",
      "display" : "polen de plantago"
    },
    {
      "code" : "40161000122100",
      "display" : "polen de plátano de sombra"
    },
    {
      "code" : "59171000122103",
      "display" : "polen de roble"
    },
    {
      "code" : "52801000122109",
      "display" : "polen de salsola"
    },
    {
      "code" : "62171000122103",
      "display" : "polen de salvia"
    },
    {
      "code" : "58371000122106",
      "display" : "polen de sauce"
    },
    {
      "code" : "43181000122101",
      "display" : "polen de sicomoro"
    },
    {
      "code" : "60341000122106",
      "display" : "polen de trigo"
    },
    {
      "code" : "49381000122101",
      "display" : "poliestireno sulfonato cálcico"
    },
    {
      "code" : "48621000122101",
      "display" : "poliestireno sulfonato sódico"
    },
    {
      "code" : "62081000122101",
      "display" : "polilla de la harina"
    },
    {
      "code" : "60521000122109",
      "display" : "polímeros del almidón"
    },
    {
      "code" : "46571000122100",
      "display" : "polimixina B"
    },
    {
      "code" : "48531000122102",
      "display" : "polimixinas"
    },
    {
      "code" : "49171000122101",
      "display" : "polinoxilina"
    },
    {
      "code" : "53271000122106",
      "display" : "politiazida"
    },
    {
      "code" : "44411000122104",
      "display" : "polvo"
    },
    {
      "code" : "57901000122102",
      "display" : "polvo de bentonita"
    },
    {
      "code" : "42031000122105",
      "display" : "polvo doméstico"
    },
    {
      "code" : "57631000122104",
      "display" : "polvos"
    },
    {
      "code" : "44071000122103",
      "display" : "pomelo"
    },
    {
      "code" : "46891000122101",
      "display" : "ponatinib"
    },
    {
      "code" : "49891000122108",
      "display" : "potasio"
    },
    {
      "code" : "40801000122108",
      "display" : "potasio administrado por vía oral"
    },
    {
      "code" : "52491000122101",
      "display" : "potasio administrado por vía parenteral"
    },
    {
      "code" : "58461000122105",
      "display" : "potasio tópico"
    },
    {
      "code" : "60901000122108",
      "display" : "povidona y sus derivados"
    },
    {
      "code" : "45451000122104",
      "display" : "practolol"
    },
    {
      "code" : "43911000122108",
      "display" : "pralidoxima"
    },
    {
      "code" : "50591000122103",
      "display" : "pravastatina"
    },
    {
      "code" : "55891000122107",
      "display" : "prazepam"
    },
    {
      "code" : "41941000122108",
      "display" : "prednisolona"
    },
    {
      "code" : "42871000122103",
      "display" : "prednisolona para uso oftálmico"
    },
    {
      "code" : "44701000122105",
      "display" : "prednisona"
    },
    {
      "code" : "59531000122108",
      "display" : "prenilamina"
    },
    {
      "code" : "40871000122104",
      "display" : "preparación tópica con dexametasona"
    },
    {
      "code" : "49411000122103",
      "display" : "preparación tópica con hidrocortisona"
    },
    {
      "code" : "59301000122105",
      "display" : "preparaciones antiinfecciosas nasales"
    },
    {
      "code" : "41641000122101",
      "display" : "preparaciones con compuestos de hierro"
    },
    {
      "code" : "46551000122108",
      "display" : "preparaciones para camuflaje"
    },
    {
      "code" : "47661000122109",
      "display" : "preparaciones rectales con prednisolona"
    },
    {
      "code" : "46591000122104",
      "display" : "preparaciones suplementarias para alimentación parenteral"
    },
    {
      "code" : "60021000122104",
      "display" : "preparado combinado de calcio y vitamina D3"
    },
    {
      "code" : "51491000122107",
      "display" : "preparado de estrógeno y progestágeno"
    },
    {
      "code" : "59741000122108",
      "display" : "preparado de piridoxina"
    },
    {
      "code" : "54881000122108",
      "display" : "preparado de vitamina B12"
    },
    {
      "code" : "46921000122105",
      "display" : "preparado dermatológico tópico"
    },
    {
      "code" : "42321000122105",
      "display" : "preparados broncodilatadores"
    },
    {
      "code" : "53191000122100",
      "display" : "preparados de alquitrán mineral para el bańo"
    },
    {
      "code" : "42251000122107",
      "display" : "preparados de alquitrán mineral para el cuero cabelludo"
    },
    {
      "code" : "52011000122103",
      "display" : "preparados minerales y multivitamínicos"
    },
    {
      "code" : "48181000122105",
      "display" : "preparados orofaríngeos"
    },
    {
      "code" : "41041000122107",
      "display" : "prilocaína"
    },
    {
      "code" : "190751001",
      "display" : "primaria a la lactosa"
    },
    {
      "code" : "47511000122105",
      "display" : "primidona"
    },
    {
      "code" : "44151000122105",
      "display" : "probucol"
    },
    {
      "code" : "41581000122106",
      "display" : "procaína"
    },
    {
      "code" : "53071000122102",
      "display" : "procarbazina"
    },
    {
      "code" : "56081000122107",
      "display" : "procesionaria del pino"
    },
    {
      "code" : "54821000122109",
      "display" : "procloroperazina"
    },
    {
      "code" : "62141000122109",
      "display" : "producida por insecto"
    },
    {
      "code" : "58221000122100",
      "display" : "producto lácteo"
    },
    {
      "code" : "58581000122103",
      "display" : "productos alcohólicos"
    },
    {
      "code" : "50651000122108",
      "display" : "productos de factor VII activado"
    },
    {
      "code" : "42961000122102",
      "display" : "productos de factor XIII"
    },
    {
      "code" : "49581000122107",
      "display" : "productos de inmunoglobulina"
    },
    {
      "code" : "42881000122100",
      "display" : "productos del factor VIII"
    },
    {
      "code" : "55311000122105",
      "display" : "productos intermedios de factor IX"
    },
    {
      "code" : "57861000122107",
      "display" : "productos que saltean el factor VIII"
    },
    {
      "code" : "292799005",
      "display" : "agente antiinfeccioso"
    },
    {
      "code" : "293069003",
      "display" : "agente antimicobacteriano"
    },
    {
      "code" : "871776007",
      "display" : "agente antitiroideo derivado de la tiourea"
    },
    {
      "code" : "293139008",
      "display" : "agente antitiroideo derivado de tiouracilo"
    },
    {
      "code" : "293567009",
      "display" : "agente antivaricoso"
    },
    {
      "code" : "293496007",
      "display" : "agente bloqueante adrenérgico de los receptores neuronales"
    },
    {
      "code" : "871551009",
      "display" : "agente bloqueante neuromuscular"
    },
    {
      "code" : "218950001",
      "display" : "agente digestivo"
    },
    {
      "code" : "870715006",
      "display" : "agente hipoglucemiante oral biguanida"
    },
    {
      "code" : "293515005",
      "display" : "agente inotrópico cardíaco"
    },
    {
      "code" : "10851141000119100",
      "display" : "agente psicotrópico"
    },
    {
      "code" : "292743007",
      "display" : "agente quelante"
    },
    {
      "code" : "293294007",
      "display" : "agente regulador del calcio"
    },
    {
      "code" : "439591006",
      "display" : "agente salurético"
    },
    {
      "code" : "417895009",
      "display" : "agente tópico"
    },
    {
      "code" : "292675000",
      "display" : "agente uricosúrico"
    },
    {
      "code" : "292872000",
      "display" : "agentes fenólicos"
    },
    {
      "code" : "219009004",
      "display" : "agentes oxitócicos"
    },
    {
      "code" : "870376001",
      "display" : "agonista de receptor de dopamina"
    },
    {
      "code" : "1156734002",
      "display" : "agonista de receptor de eritropoyetina"
    },
    {
      "code" : "292623009",
      "display" : "agregados emolientes para el bańo"
    },
    {
      "code" : "292918006",
      "display" : "albendazol"
    },
    {
      "code" : "870367008",
      "display" : "alcaloide de Cinchona"
    },
    {
      "code" : "782593004",
      "display" : "alcaloide de la rauwolfia"
    },
    {
      "code" : "292250005",
      "display" : "alcaloide de la vinca"
    },
    {
      "code" : "293528003",
      "display" : "alcaloide del cornezuelo"
    },
    {
      "code" : "292525006",
      "display" : "alcaloides de la belladona"
    },
    {
      "code" : "292060007",
      "display" : "alcaloides del opio"
    },
    {
      "code" : "293155001",
      "display" : "alclometasona"
    },
    {
      "code" : "292789000",
      "display" : "alcohol de lanolina"
    },
    {
      "code" : "292791008",
      "display" : "alcohol polivinílico"
    },
    {
      "code" : "871782005",
      "display" : "aldehído"
    },
    {
      "code" : "218924000",
      "display" : "alexitol sódico"
    },
    {
      "code" : "292549009",
      "display" : "alfadornasa"
    },
    {
      "code" : "292062004",
      "display" : "alfentanilo"
    },
    {
      "code" : "293208001",
      "display" : "alilestrenol"
    },
    {
      "code" : "293381007",
      "display" : "alimentación enteral y suplementaria"
    },
    {
      "code" : "6821000122107",
      "display" : "almasilato"
    },
    {
      "code" : "292350008",
      "display" : "alprazolam"
    },
    {
      "code" : "292714004",
      "display" : "alprostadil"
    },
    {
      "code" : "293573005",
      "display" : "alteplasa"
    },
    {
      "code" : "871524006",
      "display" : "aluminio y/o compuesto de aluminio"
    },
    {
      "code" : "292149000",
      "display" : "alverina"
    },
    {
      "code" : "6831000122105",
      "display" : "ambroxol"
    },
    {
      "code" : "292809005",
      "display" : "amfotericina"
    },
    {
      "code" : "292922001",
      "display" : "amikacina"
    },
    {
      "code" : "293473007",
      "display" : "amilorida"
    },
    {
      "code" : "218610002",
      "display" : "aminofenazona"
    },
    {
      "code" : "292921008",
      "display" : "aminoglucósidos"
    },
    {
      "code" : "293451000",
      "display" : "amiodarona"
    },
    {
      "code" : "292287002",
      "display" : "amitriptilina"
    },
    {
      "code" : "292850002",
      "display" : "amodiaquina"
    },
    {
      "code" : "292286006",
      "display" : "amoxapina"
    },
    {
      "code" : "292967008",
      "display" : "amoxicilina"
    },
    {
      "code" : "292968003",
      "display" : "ampicilina"
    },
    {
      "code" : "871504007",
      "display" : "ampicilina y cloxacilina"
    },
    {
      "code" : "292040004",
      "display" : "analgésicos"
    },
    {
      "code" : "292041000",
      "display" : "analgésicos no opiáceos"
    },
    {
      "code" : "292048006",
      "display" : "análogo de la metadona"
    },
    {
      "code" : "293333000",
      "display" : "Ancrod"
    },
    {
      "code" : "419914000",
      "display" : "anestésico"
    },
    {
      "code" : "1156013003",
      "display" : "anestésico inhalatorio con estructura éter"
    },
    {
      "code" : "218727000",
      "display" : "anestésico raquídeo"
    },
    {
      "code" : "218718001",
      "display" : "anestésico superficial y para infiltración"
    },
    {
      "code" : "292163006",
      "display" : "anestésicos intravenosos"
    },
    {
      "code" : "292263004",
      "display" : "anfepramona"
    },
    {
      "code" : "293574004",
      "display" : "anistreplasa"
    },
    {
      "code" : "292731006",
      "display" : "antagonista benzodiazepínico"
    },
    {
      "code" : "407590002",
      "display" : "antagonista del receptor de angiotensina II"
    },
    {
      "code" : "292106001",
      "display" : "antagonista del receptor H2"
    },
    {
      "code" : "292246003",
      "display" : "antagonista estrogénico"
    },
    {
      "code" : "218572006",
      "display" : "antagonistas de anticoagulantes"
    },
    {
      "code" : "292583002",
      "display" : "antazolina"
    },
    {
      "code" : "292122000",
      "display" : "antiácido"
    },
    {
      "code" : "293227007",
      "display" : "antiandrógenos"
    },
    {
      "code" : "419007000",
      "display" : "antibiótico sulfonamida"
    },
    {
      "code" : "218326006",
      "display" : "antibióticos antineoplásicos"
    },
    {
      "code" : "293331003",
      "display" : "anticoagulante"
    },
    {
      "code" : "293332005",
      "display" : "anticoagulante de acción directa"
    },
    {
      "code" : "866260004",
      "display" : "anticonceptivo oral"
    },
    {
      "code" : "292729002",
      "display" : "anticuerpos específicos antidigoxina"
    },
    {
      "code" : "292279003",
      "display" : "antidepresivo tricíclico"
    },
    {
      "code" : "292723001",
      "display" : "antídoto"
    },
    {
      "code" : "292740005",
      "display" : "antídotos contra plaguicidas"
    },
    {
      "code" : "871516001",
      "display" : "carbonato de calcio y/o ácido etidrónico"
    },
    {
      "code" : "292277001",
      "display" : "carbonato de litio"
    },
    {
      "code" : "218925004",
      "display" : "carbonato de magnesio"
    },
    {
      "code" : "292237009",
      "display" : "carboplatino"
    },
    {
      "code" : "292718001",
      "display" : "carboprost"
    },
    {
      "code" : "1163013005",
      "display" : "carbromal"
    },
    {
      "code" : "292980006",
      "display" : "carfecilina"
    },
    {
      "code" : "292694005",
      "display" : "carisoprodol"
    },
    {
      "code" : "292798002",
      "display" : "carmelosa"
    },
    {
      "code" : "292212004",
      "display" : "carmustina"
    },
    {
      "code" : "292434004",
      "display" : "carteolol"
    },
    {
      "code" : "292432000",
      "display" : "carvedilol"
    },
    {
      "code" : "292143004",
      "display" : "cáscara sagrada"
    },
    {
      "code" : "1179730008",
      "display" : "casirivimab"
    },
    {
      "code" : "1179732000",
      "display" : "casirivimab y/o imdevimab"
    },
    {
      "code" : "218943000",
      "display" : "catártico emoliente"
    },
    {
      "code" : "218933003",
      "display" : "catártico irritante"
    },
    {
      "code" : "293003004",
      "display" : "cefaclor"
    },
    {
      "code" : "292996009",
      "display" : "cefadroxilo"
    },
    {
      "code" : "292997000",
      "display" : "cefalexina"
    },
    {
      "code" : "293002009",
      "display" : "cefalosporina de segunda generación"
    },
    {
      "code" : "293006007",
      "display" : "cefalosporina de tercera generación"
    },
    {
      "code" : "292994007",
      "display" : "cefalosporinas"
    },
    {
      "code" : "293016004",
      "display" : "cefalosporinas de cuarta generación"
    },
    {
      "code" : "292995008",
      "display" : "cefalosporinas de primera generación"
    },
    {
      "code" : "292998005",
      "display" : "cefalotina"
    },
    {
      "code" : "293005006",
      "display" : "cefamandol"
    },
    {
      "code" : "293019006",
      "display" : "cefamicina"
    },
    {
      "code" : "293010005",
      "display" : "cefixima"
    },
    {
      "code" : "293011009",
      "display" : "cefodizima"
    },
    {
      "code" : "293020000",
      "display" : "cefoxitina"
    },
    {
      "code" : "293012002",
      "display" : "cefpodoxima"
    },
    {
      "code" : "293015000",
      "display" : "cefsulodina"
    },
    {
      "code" : "293008008",
      "display" : "ceftazidima"
    },
    {
      "code" : "293009000",
      "display" : "ceftizoxima"
    },
    {
      "code" : "293004005",
      "display" : "cefuroxima"
    },
    {
      "code" : "292426005",
      "display" : "celiprolol"
    },
    {
      "code" : "292901007",
      "display" : "cetilpiridinio"
    },
    {
      "code" : "292574007",
      "display" : "cetirizina"
    },
    {
      "code" : "293397002",
      "display" : "cianocobalamina"
    },
    {
      "code" : "293558009",
      "display" : "ciclandelato"
    },
    {
      "code" : "292580004",
      "display" : "ciclizina"
    },
    {
      "code" : "293224000",
      "display" : "ciclofenilo"
    },
    {
      "code" : "218379001",
      "display" : "cicloguanil"
    },
    {
      "code" : "293457001",
      "display" : "ciclopentiazida"
    },
    {
      "code" : "293074006",
      "display" : "cicloserina"
    },
    {
      "code" : "292256004",
      "display" : "ciclosporina"
    },
    {
      "code" : "292107005",
      "display" : "cimetidina"
    },
    {
      "code" : "292772008",
      "display" : "cinc tópico"
    },
    {
      "code" : "292178004",
      "display" : "cincocaína"
    },
    {
      "code" : "293429008",
      "display" : "ciprofibrato"
    },
    {
      "code" : "292589003",
      "display" : "ciproheptadina"
    },
    {
      "code" : "293232008",
      "display" : "ciproterona"
    },
    {
      "code" : "292129009",
      "display" : "cisaprida"
    },
    {
      "code" : "292238004",
      "display" : "cisplatino"
    },
    {
      "code" : "292233008",
      "display" : "citarabina"
    },
    {
      "code" : "292278006",
      "display" : "citrato de litio"
    },
    {
      "code" : "292544004",
      "display" : "citrato de orfenadrina"
    },
    {
      "code" : "292576009",
      "display" : "clemastina"
    },
    {
      "code" : "293068006",
      "display" : "clioquinol"
    },
    {
      "code" : "292353005",
      "display" : "clobazam"
    },
    {
      "code" : "293158004",
      "display" : "clobetasona"
    },
    {
      "code" : "293427005",
      "display" : "clofibrato"
    },
    {
      "code" : "293260005",
      "display" : "clomifeno"
    },
    {
      "code" : "871574008",
      "display" : "clomociclina"
    },
    {
      "code" : "292329004",
      "display" : "clonazepam"
    },
    {
      "code" : "419253001",
      "display" : "clopidogrel"
    },
    {
      "code" : "292203001",
      "display" : "clorambucilo"
    },
    {
      "code" : "293057006",
      "display" : "cloranfenicol"
    },
    {
      "code" : "292352000",
      "display" : "clordiazepóxido"
    },
    {
      "code" : "292587001",
      "display" : "clorfenamina"
    },
    {
      "code" : "292891000",
      "display" : "clorhexidina"
    },
    {
      "code" : "292480002",
      "display" : "clorhidrato de isoetarina"
    },
    {
      "code" : "292543005",
      "display" : "clorhidrato de orfenadrina"
    },
    {
      "code" : "292370002",
      "display" : "clormetiazol"
    },
    {
      "code" : "292334000",
      "display" : "clormezanona"
    },
    {
      "code" : "293456005",
      "display" : "clorotiazida"
    },
    {
      "code" : "292393008",
      "display" : "clorpromazina"
    },
    {
      "code" : "293193006",
      "display" : "clorpropamida"
    },
    {
      "code" : "293487007",
      "display" : "clortalidona"
    },
    {
      "code" : "293054004",
      "display" : "clortetraciclina"
    },
    {
      "code" : "292815005",
      "display" : "clotrimazol"
    },
    {
      "code" : "292374006",
      "display" : "clozapina"
    },
    {
      "code" : "10977721000119100",
      "display" : "coagulante"
    },
    {
      "code" : "292055008",
      "display" : "codeína"
    },
    {
      "code" : "293423009",
      "display" : "colestipol"
    },
    {
      "code" : "293424003",
      "display" : "colestiramina"
    },
    {
      "code" : "292795004",
      "display" : "colirios con hipromelosa"
    },
    {
      "code" : "292649004",
      "display" : "colodión"
    },
    {
      "code" : "292099004",
      "display" : "colorante de uso diagnóstico"
    },
    {
      "code" : "715181000",
      "display" : "colutorio"
    },
    {
      "code" : "293356009",
      "display" : "complejo de hierro polisacárido"
    },
    {
      "code" : "293104008",
      "display" : "componente de vacuna"
    },
    {
      "code" : "219079000",
      "display" : "componente de vacuna antiparatifoidea"
    },
    {
      "code" : "219094001",
      "display" : "componente de vacuna contra el tifus"
    },
    {
      "code" : "219075006",
      "display" : "componente de vacuna que contiene antígeno bacteriano"
    },
    {
      "code" : "1303852006",
      "display" : "componente de vacuna que contiene antígeno de alfaherpesvirus 3 humano"
    },
    {
      "code" : "1303851004",
      "display" : "componente de vacuna que contiene antígeno de papilomavirus humano"
    },
    {
      "code" : "1303850003",
      "display" : "componente de vacuna que contiene antígeno de virus de encefalitis transmitida por garrapatas"
    },
    {
      "code" : "408672009",
      "display" : "componente de vacuna que contiene antígeno viral"
    },
    {
      "code" : "293376003",
      "display" : "compuestos yodados"
    },
    {
      "code" : "788162000",
      "display" : "constituyente de antisuero"
    },
    {
      "code" : "788161007",
      "display" : "constituyente de inmunoglobulina"
    },
    {
      "code" : "293141009",
      "display" : "corticosteroides"
    },
    {
      "code" : "292619001",
      "display" : "corticosteroides administrados por inhalación"
    },
    {
      "code" : "293274003",
      "display" : "corticotrofina"
    },
    {
      "code" : "293159007",
      "display" : "cortisona"
    },
    {
      "code" : "292633001",
      "display" : "crema con ditranol"
    },
    {
      "code" : "292622004",
      "display" : "cremas con urea"
    },
    {
      "code" : "292242001",
      "display" : "crisantaspasa"
    },
    {
      "code" : "292658006",
      "display" : "crotamitón"
    },
    {
      "code" : "871777003",
      "display" : "cumarina"
    },
    {
      "code" : "838459007",
      "display" : "cutánea a aceite base"
    },
    {
      "code" : "838426009",
      "display" : "cutánea a aceite volátil"
    },
    {
      "code" : "403752005",
      "display" : "cutánea a medicina homeopática"
    },
    {
      "code" : "402763002",
      "display" : "cutánea a procedimiento diagnóstico"
    },
    {
      "code" : "403750002",
      "display" : "cutánea causada por medicamento a base de hierbas"
    },
    {
      "code" : "292215002",
      "display" : "dacarbazina"
    },
    {
      "code" : "292217005",
      "display" : "dactinomicina"
    },
    {
      "code" : "1187103009",
      "display" : "danaparoide"
    },
    {
      "code" : "292696007",
      "display" : "dantroleno"
    },
    {
      "code" : "292137001",
      "display" : "dantrón"
    },
    {
      "code" : "293498008",
      "display" : "debrisoquina"
    },
    {
      "code" : "292402008",
      "display" : "decanoato de flupentixol"
    },
    {
      "code" : "292380003",
      "display" : "decanoato de haloperidol"
    },
    {
      "code" : "292903005",
      "display" : "decualinio"
    },
    {
      "code" : "292471002",
      "display" : "demecario"
    },
    {
      "code" : "218634007",
      "display" : "derivado de oxazolidina"
    },
    {
      "code" : "419989001",
      "display" : "derivado del ácido propiónico"
    },
    {
      "code" : "218608004",
      "display" : "derivado pirazólico"
    },
    {
      "code" : "292202006",
      "display" : "derivados de la mostaza nitrogenada"
    },
    {
      "code" : "292745000",
      "display" : "desferrioxamina"
    },
    {
      "code" : "292879009",
      "display" : "desinfectante alcohólico"
    },
    {
      "code" : "292906002",
      "display" : "desinfectante azoico a base de trifenilmetano"
    },
    {
      "code" : "292890004",
      "display" : "desinfectante con biguanida"
    },
    {
      "code" : "292289004",
      "display" : "desipramina"
    },
    {
      "code" : "293149006",
      "display" : "desonida"
    },
    {
      "code" : "293576002",
      "display" : "desoxirribonucleasa"
    },
    {
      "code" : "10860871000119100",
      "display" : "detergente"
    },
    {
      "code" : "293167004",
      "display" : "dexametasona tópica"
    },
    {
      "code" : "292415004",
      "display" : "dexanfetamina"
    },
    {
      "code" : "293312009",
      "display" : "dextran"
    },
    {
      "code" : "293418009",
      "display" : "dextrotiroxina sódica"
    },
    {
      "code" : "293215009",
      "display" : "diacetato de etinodiol"
    },
    {
      "code" : "292056009",
      "display" : "diamorfina"
    },
    {
      "code" : "292360004",
      "display" : "diazepam"
    },
    {
      "code" : "292151001",
      "display" : "diciclomina"
    },
    {
      "code" : "218614006",
      "display" : "diclofenaco sódico"
    },
    {
      "code" : "292367001",
      "display" : "dicloralfenazona"
    },
    {
      "code" : "871773004",
      "display" : "dicloroacetamida"
    },
    {
      "code" : "293209009",
      "display" : "didrogesterona"
    },
    {
      "code" : "293251002",
      "display" : "dienestrol"
    },
    {
      "code" : "293258008",
      "display" : "dietilestilbestrol"
    },
    {
      "code" : "292591006",
      "display" : "difenhidramina"
    },
    {
      "code" : "292592004",
      "display" : "difenilpiralina"
    },
    {
      "code" : "293160002",
      "display" : "diflucortolona"
    },
    {
      "code" : "293518007",
      "display" : "digitoxina"
    },
    {
      "code" : "292057000",
      "display" : "dihidrocodeína"
    },
    {
      "code" : "293066005",
      "display" : "diloxanida"
    },
    {
      "code" : "292461004",
      "display" : "diltiazem"
    },
    {
      "code" : "292581000",
      "display" : "dimenhidrinato"
    },
    {
      "code" : "292744001",
      "display" : "dimercaprol"
    },
    {
      "code" : "292766008",
      "display" : "dimetil-éter propano"
    },
    {
      "code" : "292590007",
      "display" : "dimetindeno"
    },
    {
      "code" : "293548005",
      "display" : "dinitrato de isosorbida"
    },
    {
      "code" : "293550002",
      "display" : "dinitrato de isosorbida oral"
    },
    {
      "code" : "293549002",
      "display" : "dinitrato de isosorbida parenteral"
    },
    {
      "code" : "292717006",
      "display" : "dinoprost"
    },
    {
      "code" : "292051004",
      "display" : "dipipanona"
    },
    {
      "code" : "293539000",
      "display" : "dipiridamol"
    },
    {
      "code" : "292320000",
      "display" : "antiepiléptico barbitúrico"
    },
    {
      "code" : "292812008",
      "display" : "antifúngico a base de azol"
    },
    {
      "code" : "292814009",
      "display" : "antifúngico a base de imidazol"
    },
    {
      "code" : "292823007",
      "display" : "antifúngicos triazólicos"
    },
    {
      "code" : "218498003",
      "display" : "antihistamínicos"
    },
    {
      "code" : "870678006",
      "display" : "antimonio y/o compuesto de antimonio"
    },
    {
      "code" : "242060008",
      "display" : "antipirético"
    },
    {
      "code" : "219050007",
      "display" : "antipruriginoso"
    },
    {
      "code" : "269723006",
      "display" : "antirreumático"
    },
    {
      "code" : "293129002",
      "display" : "antisuero"
    },
    {
      "code" : "293131006",
      "display" : "antitoxina botulínica"
    },
    {
      "code" : "293132004",
      "display" : "antitoxina diftérica"
    },
    {
      "code" : "158058005",
      "display" : "antitoxina tetánica"
    },
    {
      "code" : "293317003",
      "display" : "antitrombina III"
    },
    {
      "code" : "292605001",
      "display" : "antitusígeno"
    },
    {
      "code" : "292270004",
      "display" : "apomorfina"
    },
    {
      "code" : "292514002",
      "display" : "apraclonidina"
    },
    {
      "code" : "293352006",
      "display" : "aprotinina"
    },
    {
      "code" : "871783000",
      "display" : "arsénico y/o compuesto de arsénico"
    },
    {
      "code" : "292044008",
      "display" : "aspirina"
    },
    {
      "code" : "292569004",
      "display" : "astemizol"
    },
    {
      "code" : "418370000",
      "display" : "atenolol"
    },
    {
      "code" : "720683004",
      "display" : "atorvastatina"
    },
    {
      "code" : "293060004",
      "display" : "atovacuona"
    },
    {
      "code" : "292687007",
      "display" : "atracurio"
    },
    {
      "code" : "292534001",
      "display" : "atropina"
    },
    {
      "code" : "292699000",
      "display" : "auranofina"
    },
    {
      "code" : "218622004",
      "display" : "aurotiomalato de sodio"
    },
    {
      "code" : "292070009",
      "display" : "azapropazona"
    },
    {
      "code" : "292585009",
      "display" : "azatadina"
    },
    {
      "code" : "292573001",
      "display" : "azelastina"
    },
    {
      "code" : "292934009",
      "display" : "azitromicina"
    },
    {
      "code" : "292978000",
      "display" : "azlocilina"
    },
    {
      "code" : "293027002",
      "display" : "aztreonam"
    },
    {
      "code" : "292637000",
      "display" : "azufre"
    },
    {
      "code" : "292693004",
      "display" : "baclofeno"
    },
    {
      "code" : "871572007",
      "display" : "bametán"
    },
    {
      "code" : "218663005",
      "display" : "barbital"
    },
    {
      "code" : "6841000122102",
      "display" : "barnidipino"
    },
    {
      "code" : "1208465005",
      "display" : "bebtelovimab"
    },
    {
      "code" : "292315000",
      "display" : "beclamida"
    },
    {
      "code" : "292914008",
      "display" : "befenio"
    },
    {
      "code" : "292961009",
      "display" : "bencilpenicilina"
    },
    {
      "code" : "292378009",
      "display" : "benperidol"
    },
    {
      "code" : "292898006",
      "display" : "benzalconio"
    },
    {
      "code" : "292536004",
      "display" : "benzatropina"
    },
    {
      "code" : "293084007",
      "display" : "benzoato de bencilo"
    },
    {
      "code" : "292182002",
      "display" : "benzocaína"
    },
    {
      "code" : "292561001",
      "display" : "beractant"
    },
    {
      "code" : "292419005",
      "display" : "betabloqueante"
    },
    {
      "code" : "293142002",
      "display" : "betametasona"
    },
    {
      "code" : "293497003",
      "display" : "betanidina"
    },
    {
      "code" : "292424008",
      "display" : "betaxolol"
    },
    {
      "code" : "293230000",
      "display" : "bicalutamida"
    },
    {
      "code" : "293295008",
      "display" : "bifosfonatos"
    },
    {
      "code" : "293202000",
      "display" : "biguanida"
    },
    {
      "code" : "292136005",
      "display" : "bisacodilo"
    },
    {
      "code" : "870675009",
      "display" : "bismuto y/o compuesto de bismuto"
    },
    {
      "code" : "292218000",
      "display" : "bleomicina"
    },
    {
      "code" : "292893002",
      "display" : "borato"
    },
    {
      "code" : "293449004",
      "display" : "bretilio"
    },
    {
      "code" : "293575003",
      "display" : "bromelinas"
    },
    {
      "code" : "871570004",
      "display" : "bromhexina"
    },
    {
      "code" : "292608004",
      "display" : "bromhidrato de dextrometorfano"
    },
    {
      "code" : "836488001",
      "display" : "bromo y/o compuesto de bromo"
    },
    {
      "code" : "292274008",
      "display" : "bromocriptina"
    },
    {
      "code" : "218869007",
      "display" : "bromuro de pentametonio"
    },
    {
      "code" : "293175005",
      "display" : "budesonida"
    },
    {
      "code" : "292630003",
      "display" : "bufexamaco"
    },
    {
      "code" : "293464004",
      "display" : "bumetanida"
    },
    {
      "code" : "292054007",
      "display" : "buprenorfina"
    },
    {
      "code" : "293279008",
      "display" : "buserelina"
    },
    {
      "code" : "292369003",
      "display" : "buspirona"
    },
    {
      "code" : "292147003",
      "display" : "butilbromuro de hioscina"
    },
    {
      "code" : "292339005",
      "display" : "butobarbital"
    },
    {
      "code" : "292280000",
      "display" : "butriptilina"
    },
    {
      "code" : "218799005",
      "display" : "cafeína"
    },
    {
      "code" : "292636009",
      "display" : "calcipotriol"
    },
    {
      "code" : "293301009",
      "display" : "calcitonina"
    },
    {
      "code" : "720677002",
      "display" : "candesartán"
    },
    {
      "code" : "320906871000119000",
      "display" : "cannabinoide sintético"
    },
    {
      "code" : "293471009",
      "display" : "canrenoato de potasio"
    },
    {
      "code" : "293073000",
      "display" : "capreomicina"
    },
    {
      "code" : "292478008",
      "display" : "carbacol"
    },
    {
      "code" : "292325005",
      "display" : "carbamazepina"
    },
    {
      "code" : "292972004",
      "display" : "carbenicilina"
    },
    {
      "code" : "876800006",
      "display" : "carbidopa y/o levodopa"
    },
    {
      "code" : "293138000",
      "display" : "carbimazol"
    },
    {
      "code" : "292792001",
      "display" : "carbómero 940"
    },
    {
      "code" : "292725008",
      "display" : "carbón activado"
    },
    {
      "code" : "52061000122100",
      "display" : "talampicilina"
    },
    {
      "code" : "57621000122102",
      "display" : "tamoxifeno"
    },
    {
      "code" : "45031000122102",
      "display" : "tartrato de oxedrina"
    },
    {
      "code" : "60561000122100",
      "display" : "tazobactam"
    },
    {
      "code" : "61651000122108",
      "display" : "té"
    },
    {
      "code" : "61291000122101",
      "display" : "tegaserod"
    },
    {
      "code" : "42661000122107",
      "display" : "teicoplanina"
    },
    {
      "code" : "59331000122104",
      "display" : "temafloxacino"
    },
    {
      "code" : "53541000122103",
      "display" : "temazepam"
    },
    {
      "code" : "42851000122106",
      "display" : "temocilina"
    },
    {
      "code" : "248467005",
      "display" : "temperatura ambiente"
    },
    {
      "code" : "60591000122106",
      "display" : "tenofovir"
    },
    {
      "code" : "53211000122104",
      "display" : "tenoxicam"
    },
    {
      "code" : "50121000122106",
      "display" : "teofilina"
    },
    {
      "code" : "44321000122101",
      "display" : "teofilinato de colina"
    },
    {
      "code" : "40491000122100",
      "display" : "terazosina"
    },
    {
      "code" : "53051000122105",
      "display" : "terbinafina"
    },
    {
      "code" : "58561000122106",
      "display" : "terbutalina"
    },
    {
      "code" : "41841000122100",
      "display" : "terfenadina"
    },
    {
      "code" : "52971000122109",
      "display" : "teriparatida"
    },
    {
      "code" : "56181000122108",
      "display" : "terlipresina"
    },
    {
      "code" : "59801000122100",
      "display" : "terpenos"
    },
    {
      "code" : "43891000122106",
      "display" : "tertatolol"
    },
    {
      "code" : "41311000122105",
      "display" : "testosterona"
    },
    {
      "code" : "48841000122107",
      "display" : "testosterona administrada por vía oral"
    },
    {
      "code" : "49431000122107",
      "display" : "testosterona intramuscular"
    },
    {
      "code" : "42381000122109",
      "display" : "tetrabenazina"
    },
    {
      "code" : "52781000122105",
      "display" : "tetracaína"
    },
    {
      "code" : "45381000122103",
      "display" : "tetraciclina"
    },
    {
      "code" : "51501000122101",
      "display" : "tetracosactrina"
    },
    {
      "code" : "51801000122104",
      "display" : "tetradecil sulfato de sodio"
    },
    {
      "code" : "43141000122105",
      "display" : "tetrizolina"
    },
    {
      "code" : "44941000122105",
      "display" : "tiabendazol"
    },
    {
      "code" : "50371000122109",
      "display" : "tiagabina"
    },
    {
      "code" : "59951000122108",
      "display" : "tiazolidinadiona"
    },
    {
      "code" : "54571000122107",
      "display" : "tibolona"
    },
    {
      "code" : "41991000122101",
      "display" : "ticarcilina y ácido clavulánico"
    },
    {
      "code" : "44661000122104",
      "display" : "tietilperazina"
    },
    {
      "code" : "51121000122103",
      "display" : "tiloxapol"
    },
    {
      "code" : "60811000122101",
      "display" : "timerosal"
    },
    {
      "code" : "49221000122105",
      "display" : "timolol"
    },
    {
      "code" : "48691000122104",
      "display" : "timoxamina"
    },
    {
      "code" : "56331000122109",
      "display" : "tintura desinfectante"
    },
    {
      "code" : "48081000122109",
      "display" : "tinzaparina"
    },
    {
      "code" : "54021000122101",
      "display" : "tioguanina"
    },
    {
      "code" : "57761000122104",
      "display" : "tiopentona"
    },
    {
      "code" : "48341000122103",
      "display" : "tiotepa"
    },
    {
      "code" : "60881000122106",
      "display" : "tiotropio"
    },
    {
      "code" : "40991000122109",
      "display" : "tirocalcitonina"
    },
    {
      "code" : "45571000122106",
      "display" : "tirofibán"
    },
    {
      "code" : "41601000122103",
      "display" : "tiroxina"
    },
    {
      "code" : "43731000122101",
      "display" : "tobramicina"
    },
    {
      "code" : "56981000122106",
      "display" : "tofacitinib"
    },
    {
      "code" : "52221000122102",
      "display" : "tolazamida"
    },
    {
      "code" : "56851000122107",
      "display" : "tolmetina"
    },
    {
      "code" : "48131000122109",
      "display" : "tolnaftato"
    },
    {
      "code" : "50911000122103",
      "display" : "tomillo"
    },
    {
      "code" : "60401000122102",
      "display" : "topotecán"
    },
    {
      "code" : "59841000122103",
      "display" : "toxina de Clostridium botulinum"
    },
    {
      "code" : "44771000122101",
      "display" : "tramadol"
    },
    {
      "code" : "45531000122108",
      "display" : "tranilcipromina"
    },
    {
      "code" : "56631000122101",
      "display" : "transdérmica a la nitroglicerina"
    },
    {
      "code" : "41181000122102",
      "display" : "trazodona"
    },
    {
      "code" : "84193000",
      "display" : "trehalosa"
    },
    {
      "code" : "60851000122100",
      "display" : "treprostinilo"
    },
    {
      "code" : "41091000122100",
      "display" : "tretinoína"
    },
    {
      "code" : "57161000122103",
      "display" : "triamtereno"
    },
    {
      "code" : "52791000122108",
      "display" : "triamtereno y a diurético de asa"
    },
    {
      "code" : "48321000122108",
      "display" : "triamtereno y a diurético tiazídico"
    },
    {
      "code" : "49351000122107",
      "display" : "tribavirina"
    },
    {
      "code" : "56301000122103",
      "display" : "triclofós sódico"
    },
    {
      "code" : "45011000122106",
      "display" : "triclosán"
    },
    {
      "code" : "57661000122106",
      "display" : "trientina"
    },
    {
      "code" : "45061000122109",
      "display" : "trifluorotimidina"
    },
    {
      "code" : "52421000122103",
      "display" : "trifluperidol"
    },
    {
      "code" : "700095006",
      "display" : "trigo"
    },
    {
      "code" : "51061000122108",
      "display" : "trihexifenidilo"
    },
    {
      "code" : "53561000122104",
      "display" : "trilostano"
    },
    {
      "code" : "44271000122107",
      "display" : "trimebutina"
    },
    {
      "code" : "44061000122108",
      "display" : "trimeprazina"
    },
    {
      "code" : "45521000122105",
      "display" : "trimetafán"
    },
    {
      "code" : "41491000122105",
      "display" : "trimetoprima"
    },
    {
      "code" : "43771000122103",
      "display" : "trimipramina"
    },
    {
      "code" : "41681000122105",
      "display" : "trinitrato de glicerilo"
    },
    {
      "code" : "58031000122105",
      "display" : "trinitrato de glicerilo de liberación modificada"
    },
    {
      "code" : "50421000122104",
      "display" : "trinitrato de glicerilo oral"
    },
    {
      "code" : "40791000122107",
      "display" : "triprolidina"
    },
    {
      "code" : "42021000122107",
      "display" : "triptófano"
    },
    {
      "code" : "47431000122100",
      "display" : "triptorelina"
    },
    {
      "code" : "42841000122109",
      "display" : "trisilicato de magnesio"
    },
    {
      "code" : "55811000122104",
      "display" : "trolamina"
    },
    {
      "code" : "42441000122106",
      "display" : "tromboplastina"
    },
    {
      "code" : "41111000122107",
      "display" : "tropicamida"
    },
    {
      "code" : "44611000122102",
      "display" : "trucha"
    },
    {
      "code" : "47531000122101",
      "display" : "tuberculina"
    },
    {
      "code" : "50451000122106",
      "display" : "tubocurarina"
    },
    {
      "code" : "44001000122107",
      "display" : "tulobuterol"
    },
    {
      "code" : "51421000122105",
      "display" : "undecenoatos"
    },
    {
      "code" : "57251000122106",
      "display" : "ungüento con ditranol"
    },
    {
      "code" : "49501000122100",
      "display" : "urapidil"
    },
    {
      "code" : "42501000122105",
      "display" : "urea"
    },
    {
      "code" : "42691000122101",
      "display" : "urocinasa"
    },
    {
      "code" : "44711000122108",
      "display" : "uva"
    },
    {
      "code" : "42611000122109",
      "display" : "vacuna anti - Haemophilus influenzae tipo B"
    },
    {
      "code" : "50101000122103",
      "display" : "vacuna antialérgica"
    },
    {
      "code" : "53501000122100",
      "display" : "vacuna anticarbunco"
    },
    {
      "code" : "51701000122105",
      "display" : "vacuna antidiftérica y antitetánica"
    },
    {
      "code" : "50581000122101",
      "display" : "vacuna antidiftérica, antitetánica y antitosferínica"
    },
    {
      "code" : "50021000122105",
      "display" : "vacuna antigripal de virión fragmentado"
    },
    {
      "code" : "58881000122100",
      "display" : "vacuna antineumocócica"
    },
    {
      "code" : "46501000122109",
      "display" : "vacuna antipoliomielítica"
    },
    {
      "code" : "45661000122100",
      "display" : "vacuna antirrábica"
    },
    {
      "code" : "51231000122109",
      "display" : "vacuna antirrubeólica"
    },
    {
      "code" : "54701000122107",
      "display" : "vacuna antitetánica"
    },
    {
      "code" : "40531000122100",
      "display" : "vacuna antitifoidea"
    },
    {
      "code" : "52301000122104",
      "display" : "vacuna antitifoidea de célula entera"
    },
    {
      "code" : "55301000122107",
      "display" : "vacuna antitosferínica"
    },
    {
      "code" : "46601000122105",
      "display" : "vacuna contra el virus del papiloma humano del tipo 6, 11, 16, 18"
    },
    {
      "code" : "51891000122109",
      "display" : "vacuna contra la fiebre amarilla"
    },
    {
      "code" : "55061000122106",
      "display" : "vacuna contra la hepatitis B"
    },
    {
      "code" : "59971000122100",
      "display" : "vacuna contra rotavirus"
    },
    {
      "code" : "49751000122108",
      "display" : "vacuna de antígeno de superficie del virus de la gripe"
    },
    {
      "code" : "44571000122105",
      "display" : "vacuna de lactobacilo acidófilo"
    },
    {
      "code" : "45911000122107",
      "display" : "vacuna de polisacárido de Salmonella typhi"
    },
    {
      "code" : "52981000122107",
      "display" : "vacuna de polisacárido meningocócico"
    },
    {
      "code" : "61431000122101",
      "display" : "vacuna frente a la encefalitis por virus transmitido por garrapatas"
    },
    {
      "code" : "51561000122100",
      "display" : "vacuna frente a la hepatitis A y B"
    },
    {
      "code" : "58071000122108",
      "display" : "vacuna frente a la tuberculosis"
    },
    {
      "code" : "53301000122108",
      "display" : "vacuna frente al meningococo A"
    },
    {
      "code" : "40111000122103",
      "display" : "vacuna frente al meningococo B"
    },
    {
      "code" : "53521000122108",
      "display" : "vacuna frente al sarampión"
    },
    {
      "code" : "51571000122105",
      "display" : "vacuna frente al virus de la varicela"
    },
    {
      "code" : "45741000122108",
      "display" : "vacuna frente al virus del papiloma humano"
    },
    {
      "code" : "55111000122107",
      "display" : "vacuna frente al virus del papiloma humano del tipo 16, 18"
    },
    {
      "code" : "57321000122109",
      "display" : "vacunas"
    },
    {
      "code" : "42681000122104",
      "display" : "vacunas antidiftéricas"
    },
    {
      "code" : "46261000122108",
      "display" : "vacunas, inmunoglobulinas y antisueros"
    },
    {
      "code" : "50751000122100",
      "display" : "valaciclovir"
    },
    {
      "code" : "40141000122104",
      "display" : "valproato sódico"
    },
    {
      "code" : "43931000122104",
      "display" : "vandetanib"
    },
    {
      "code" : "45241000122102",
      "display" : "vapores industriales metilados"
    },
    {
      "code" : "46381000122108",
      "display" : "vareniclina"
    },
    {
      "code" : "46121000122107",
      "display" : "vasodilatador cerebral/periférico"
    },
    {
      "code" : "42761000122100",
      "display" : "vecuronio"
    },
    {
      "code" : "42161000122104",
      "display" : "vegetal"
    },
    {
      "code" : "42891000122102",
      "display" : "velpatasvir"
    },
    {
      "code" : "48231000122100",
      "display" : "veneno de abeja"
    },
    {
      "code" : "62251000122100",
      "display" : "veneno de abeja melífera"
    },
    {
      "code" : "40631000122101",
      "display" : "veneno de avispa"
    },
    {
      "code" : "54321000122103",
      "display" : "veneno de avispón"
    },
    {
      "code" : "62241000122102",
      "display" : "veneno de avispón chaqueta amarilla"
    },
    {
      "code" : "55971000122102",
      "display" : "veneno de escorpión"
    },
    {
      "code" : "62231000122105",
      "display" : "veneno de himenóptero"
    },
    {
      "code" : "62211000122101",
      "display" : "veneno de insecto"
    },
    {
      "code" : "52211000122108",
      "display" : "venlafaxina"
    },
    {
      "code" : "50791000122109",
      "display" : "verapamilo"
    },
    {
      "code" : "56791000122107",
      "display" : "verde brillante"
    },
    {
      "code" : "61271000122102",
      "display" : "verteporfina"
    },
    {
      "code" : "44231000122109",
      "display" : "vidarabina"
    },
    {
      "code" : "53411000122103",
      "display" : "vigabatrina"
    },
    {
      "code" : "47181000122109",
      "display" : "viloxazina"
    },
    {
      "code" : "58271000122104",
      "display" : "vinblastina"
    },
    {
      "code" : "56071000122109",
      "display" : "vincristina"
    },
    {
      "code" : "45981000122102",
      "display" : "vindesina"
    },
    {
      "code" : "61611000122107",
      "display" : "vino"
    },
    {
      "code" : "59051000122107",
      "display" : "vinorelbina"
    },
    {
      "code" : "52501000122107",
      "display" : "violeta cristal"
    },
    {
      "code" : "44971000122104",
      "display" : "vitamina A"
    },
    {
      "code" : "52451000122105",
      "display" : "vitamina B12"
    },
    {
      "code" : "40731000122108",
      "display" : "vitamina D"
    },
    {
      "code" : "56441000122107",
      "display" : "vitamina del grupo B"
    },
    {
      "code" : "45871000122109",
      "display" : "vitamina hidrosoluble"
    },
    {
      "code" : "52401000122106",
      "display" : "vitamina K"
    },
    {
      "code" : "53431000122107",
      "display" : "vitamina liposoluble"
    },
    {
      "code" : "40571000122102",
      "display" : "warfarina"
    },
    {
      "code" : "49461000122100",
      "display" : "xamoterol"
    },
    {
      "code" : "55741000122105",
      "display" : "xantina"
    },
    {
      "code" : "40401000122105",
      "display" : "xilometazolina"
    },
    {
      "code" : "49621000122107",
      "display" : "xipamida"
    },
    {
      "code" : "54011000122107",
      "display" : "yodóforo"
    },
    {
      "code" : "58401000122109",
      "display" : "yodopovidona"
    },
    {
      "code" : "44021000122104",
      "display" : "zanahoria"
    },
    {
      "code" : "48481000122100",
      "display" : "zarzamora"
    },
    {
      "code" : "58171000122109",
      "display" : "ziconotida"
    },
    {
      "code" : "44081000122100",
      "display" : "zinc tópico"
    },
    {
      "code" : "60961000122109",
      "display" : "ziprasidona"
    },
    {
      "code" : "51711000122108",
      "display" : "zoplicona"
    },
    {
      "code" : "59031000122102",
      "display" : "zuclopentixol"
    },
    {
      "code" : "292708006",
      "display" : "p-di-isobutilfenoxipolietoxietanol"
    },
    {
      "code" : "292945007",
      "display" : "4-quinolonas"
    },
    {
      "code" : "293205003",
      "display" : "acarbosa"
    },
    {
      "code" : "419082008",
      "display" : "aceite"
    },
    {
      "code" : "292776006",
      "display" : "aceite de maní"
    },
    {
      "code" : "292775005",
      "display" : "aceite de oliva"
    },
    {
      "code" : "292777002",
      "display" : "aceite de ricino"
    },
    {
      "code" : "293430003",
      "display" : "aceites de pescado"
    },
    {
      "code" : "218606000",
      "display" : "acetanilida"
    },
    {
      "code" : "293494005",
      "display" : "acetazolamida"
    },
    {
      "code" : "871573002",
      "display" : "acetilcolina"
    },
    {
      "code" : "292844007",
      "display" : "aciclovir"
    },
    {
      "code" : "292864002",
      "display" : "ácido acético"
    },
    {
      "code" : "292638005",
      "display" : "ácido azelaico"
    },
    {
      "code" : "292644009",
      "display" : "ácido benzoico"
    },
    {
      "code" : "1163009003",
      "display" : "ácido biliar y/o derivado de ácido biliar"
    },
    {
      "code" : "292894008",
      "display" : "ácido bórico"
    },
    {
      "code" : "871629009",
      "display" : "ácido clodrónico"
    },
    {
      "code" : "292158007",
      "display" : "ácido dehidrocólico"
    },
    {
      "code" : "293465003",
      "display" : "ácido etacrínico"
    },
    {
      "code" : "860941007",
      "display" : "ácido fíbrico y/o derivado de ácido fíbrico"
    },
    {
      "code" : "293393003",
      "display" : "ácido fólico"
    },
    {
      "code" : "292944006",
      "display" : "ácido fusídico"
    },
    {
      "code" : "420179005",
      "display" : "ácido graso"
    },
    {
      "code" : "871678004",
      "display" : "ácido hialurónico"
    },
    {
      "code" : "218630003",
      "display" : "ácido mefenámico"
    },
    {
      "code" : "418328005",
      "display" : "ácido nalidíxico"
    },
    {
      "code" : "871674002",
      "display" : "ácido pamidrónico"
    },
    {
      "code" : "218408007",
      "display" : "ácido paraaminosalicílico"
    },
    {
      "code" : "292659003",
      "display" : "ácido salicílico tópico"
    },
    {
      "code" : "292090000",
      "display" : "ácido tiaprofénico"
    },
    {
      "code" : "292159004",
      "display" : "ácido ursodesoxicólico"
    },
    {
      "code" : "10847541000119100",
      "display" : "ácido valproico"
    },
    {
      "code" : "293421006",
      "display" : "acipimox"
    },
    {
      "code" : "292667006",
      "display" : "acitretina"
    },
    {
      "code" : "6851000122100",
      "display" : "aclidinio"
    },
    {
      "code" : "292571004",
      "display" : "acrivastina"
    },
    {
      "code" : "10860791000119100",
      "display" : "activador de plasminógeno tisular"
    },
    {
      "code" : "403753000",
      "display" : "acupuntura"
    },
    {
      "code" : "292647002",
      "display" : "adhesivo tisular de uso quirúrgico"
    },
    {
      "code" : "714139000",
      "display" : "aditivo alimentario"
    },
    {
      "code" : "713228003",
      "display" : "aditivo de la goma de mascar"
    },
    {
      "code" : "293547000",
      "display" : "aerosol de trinitrato de glicerilo"
    },
    {
      "code" : "293408004",
      "display" : "poliestireno sulfonato sódico"
    },
    {
      "code" : "890232004",
      "display" : "poliestradiol"
    },
    {
      "code" : "292992006",
      "display" : "polimixina B"
    },
    {
      "code" : "292990003",
      "display" : "polimixinas"
    },
    {
      "code" : "292866000",
      "display" : "polinoxilina"
    },
    {
      "code" : "293461007",
      "display" : "politiazida"
    },
    {
      "code" : "292742002",
      "display" : "polvo de bentonita"
    },
    {
      "code" : "292624003",
      "display" : "polvos faciales"
    },
    {
      "code" : "871569000",
      "display" : "poractant alfa"
    },
    {
      "code" : "293409007",
      "display" : "potasio"
    },
    {
      "code" : "293410002",
      "display" : "potasio por vía oral"
    },
    {
      "code" : "293411003",
      "display" : "potasio por vía parenteral"
    },
    {
      "code" : "292439009",
      "display" : "practolol"
    },
    {
      "code" : "292734003",
      "display" : "pralidoxima"
    },
    {
      "code" : "22721000122107",
      "display" : "prasugrel"
    },
    {
      "code" : "293435008",
      "display" : "pravastatina"
    },
    {
      "code" : "292358001",
      "display" : "prazepam"
    },
    {
      "code" : "292449007",
      "display" : "prazosina"
    },
    {
      "code" : "293170000",
      "display" : "prednisolona"
    },
    {
      "code" : "293171001",
      "display" : "prednisolona tópica"
    },
    {
      "code" : "293146004",
      "display" : "prednisona"
    },
    {
      "code" : "292455002",
      "display" : "prenilamina"
    },
    {
      "code" : "293173003",
      "display" : "preparaciones rectales con prednisolona"
    },
    {
      "code" : "292769001",
      "display" : "preparado antihemorroidal"
    },
    {
      "code" : "293401005",
      "display" : "preparado de piridoxina"
    },
    {
      "code" : "293402003",
      "display" : "preparado de tiamina"
    },
    {
      "code" : "293395005",
      "display" : "preparado de vitamina B12"
    },
    {
      "code" : "292771001",
      "display" : "preparado para remoción de cerumen"
    },
    {
      "code" : "292618009",
      "display" : "preparados broncodilatadores"
    },
    {
      "code" : "292629008",
      "display" : "preparados de alquitrán mineral para el bańo"
    },
    {
      "code" : "293384004",
      "display" : "preparados minerales y multivitamínicos"
    },
    {
      "code" : "292767004",
      "display" : "preparados tópicos circulatorios"
    },
    {
      "code" : "292179007",
      "display" : "prilocaína"
    },
    {
      "code" : "292324009",
      "display" : "primidona"
    },
    {
      "code" : "293420007",
      "display" : "probucol"
    },
    {
      "code" : "292185000",
      "display" : "procaína"
    },
    {
      "code" : "292240009",
      "display" : "procarbazina"
    },
    {
      "code" : "292398004",
      "display" : "procloroperazina"
    },
    {
      "code" : "293096000",
      "display" : "productos de inmunoglobulinas"
    },
    {
      "code" : "293313004",
      "display" : "productos perfluorocarbonados"
    },
    {
      "code" : "293383005",
      "display" : "productos vitamínicos"
    },
    {
      "code" : "293210004",
      "display" : "progesterona"
    },
    {
      "code" : "292856008",
      "display" : "proguanil"
    },
    {
      "code" : "292395001",
      "display" : "promazina"
    },
    {
      "code" : "293446006",
      "display" : "propafenona"
    },
    {
      "code" : "292155005",
      "display" : "propantelina"
    },
    {
      "code" : "293220009",
      "display" : "propionato de drostanolona"
    },
    {
      "code" : "292166003",
      "display" : "propofol"
    },
    {
      "code" : "292709003",
      "display" : "prostaglandina"
    },
    {
      "code" : "292711007",
      "display" : "prostaglandina, serie E"
    },
    {
      "code" : "292716002",
      "display" : "prostaglandina, serie F"
    },
    {
      "code" : "292739008",
      "display" : "protamina"
    },
    {
      "code" : "770890009",
      "display" : "proteína de la coagulación"
    },
    {
      "code" : "292292000",
      "display" : "protriptilina"
    },
    {
      "code" : "292186004",
      "display" : "proximetacaína"
    },
    {
      "code" : "218796003",
      "display" : "psilocibina"
    },
    {
      "code" : "292563003",
      "display" : "pumactant"
    },
    {
      "code" : "292102004",
      "display" : "quelato de bismuto"
    },
    {
      "code" : "293263007",
      "display" : "quinagolida"
    },
    {
      "code" : "22731000122105",
      "display" : "quinazolina"
    },
    {
      "code" : "293249001",
      "display" : "quinestradol"
    },
    {
      "code" : "293441001",
      "display" : "quinidina"
    },
    {
      "code" : "218369003",
      "display" : "quiniofón"
    },
    {
      "code" : "292094009",
      "display" : "radiofármaco"
    },
    {
      "code" : "292110003",
      "display" : "ranitidina"
    },
    {
      "code" : "789255009",
      "display" : "reactivador de acetilcolinesterasa"
    },
    {
      "code" : "292700004",
      "display" : "relajante del músculo liso"
    },
    {
      "code" : "1179728006",
      "display" : "remdesevir"
    },
    {
      "code" : "292407002",
      "display" : "remoxiprida"
    },
    {
      "code" : "218903005",
      "display" : "reserpina"
    },
    {
      "code" : "293405001",
      "display" : "resina de intercambio catiónico"
    },
    {
      "code" : "293404002",
      "display" : "resina de intercambio iónico"
    },
    {
      "code" : "1300134005",
      "display" : "reteplasa"
    },
    {
      "code" : "293076008",
      "display" : "rifabutina"
    },
    {
      "code" : "292500002",
      "display" : "rimiterol"
    },
    {
      "code" : "292375007",
      "display" : "risperidona"
    },
    {
      "code" : "442108004",
      "display" : "rituximab administrado por infusión"
    },
    {
      "code" : "720682009",
      "display" : "rosuvastatina"
    },
    {
      "code" : "292770000",
      "display" : "sacarosa"
    },
    {
      "code" : "292495000",
      "display" : "salbutamol"
    },
    {
      "code" : "293382000",
      "display" : "sales de rehidratación oral"
    },
    {
      "code" : "269722001",
      "display" : "salicilatos"
    },
    {
      "code" : "419887003",
      "display" : "sangre o hemoderivado"
    },
    {
      "code" : "1179727001",
      "display" : "sarilumab"
    },
    {
      "code" : "292342004",
      "display" : "secobarbital"
    },
    {
      "code" : "292409004",
      "display" : "selegilina"
    },
    {
      "code" : "292657001",
      "display" : "selenio tópico"
    },
    {
      "code" : "292303004",
      "display" : "sertralina"
    },
    {
      "code" : "292787003",
      "display" : "silicona"
    },
    {
      "code" : "293433001",
      "display" : "simvastatina"
    },
    {
      "code" : "293316007",
      "display" : "solución de albúmina"
    },
    {
      "code" : "292764006",
      "display" : "solución de cardioplejía"
    },
    {
      "code" : "292763000",
      "display" : "solución de hemofiltración"
    },
    {
      "code" : "293314005",
      "display" : "solución de proteína plasmática"
    },
    {
      "code" : "292761003",
      "display" : "solución para diálisis peritoneal"
    },
    {
      "code" : "292869007",
      "display" : "soluciones cloradas"
    },
    {
      "code" : "293288004",
      "display" : "somatotrofina"
    },
    {
      "code" : "292441005",
      "display" : "sotalol"
    },
    {
      "code" : "1179725009",
      "display" : "sotrovimab"
    },
    {
      "code" : "871514003",
      "display" : "subnitrato de bismuto y yodoformo"
    },
    {
      "code" : "720665007",
      "display" : "succinato de metroprolol"
    },
    {
      "code" : "293364003",
      "display" : "succinato ferroso"
    },
    {
      "code" : "218641001",
      "display" : "succinimida"
    },
    {
      "code" : "292103009",
      "display" : "sucralfato"
    },
    {
      "code" : "292820005",
      "display" : "sulconazol"
    },
    {
      "code" : "293046001",
      "display" : "sulfacetamida"
    },
    {
      "code" : "293037007",
      "display" : "sulfadiazina"
    },
    {
      "code" : "293038002",
      "display" : "sulfadimetoxina"
    },
    {
      "code" : "293039005",
      "display" : "sulfadimidina"
    },
    {
      "code" : "293040007",
      "display" : "sulfafurazol"
    },
    {
      "code" : "293041006",
      "display" : "sulfaguanidina"
    },
    {
      "code" : "293034000",
      "display" : "sulfaloxato de calcio"
    },
    {
      "code" : "293036003",
      "display" : "sulfametopirazina"
    },
    {
      "code" : "218356002",
      "display" : "sulfametoxazol"
    },
    {
      "code" : "876798004",
      "display" : "sulfametoxazol y/o trimetoprima"
    },
    {
      "code" : "292121007",
      "display" : "sulfasalazina"
    },
    {
      "code" : "293248009",
      "display" : "sulfato de estrona piperacina"
    },
    {
      "code" : "293365002",
      "display" : "sulfato ferroso"
    },
    {
      "code" : "292677008",
      "display" : "sulfinpirazona"
    },
    {
      "code" : "293032001",
      "display" : "sulfonamidas"
    },
    {
      "code" : "293042004",
      "display" : "sulfourea"
    },
    {
      "code" : "292088001",
      "display" : "sulindaco"
    },
    {
      "code" : "292653002",
      "display" : "surfactante aniónico"
    },
    {
      "code" : "292896005",
      "display" : "surfactante de amonio cuaternario"
    },
    {
      "code" : "292900008",
      "display" : "surfactante de piridinio cuaternario"
    },
    {
      "code" : "292705009",
      "display" : "surfactante no iónico"
    },
    {
      "code" : "292560000",
      "display" : "surfactante respiratorio"
    },
    {
      "code" : "838369002",
      "display" : "sustancia aplicada a la piel de recién nacido"
    },
    {
      "code" : "292092008",
      "display" : "sustancia de uso diagnóstico"
    },
    {
      "code" : "417902000",
      "display" : "sustancia química inorgánica"
    },
    {
      "code" : "218586005",
      "display" : "sustitutos macromoleculares de la sangre"
    },
    {
      "code" : "293308003",
      "display" : "sustitutos plasmáticos"
    },
    {
      "code" : "292974003",
      "display" : "talampicilina"
    },
    {
      "code" : "720666008",
      "display" : "tartrato de metoprolol"
    },
    {
      "code" : "292484006",
      "display" : "tartrato de oxedrina"
    },
    {
      "code" : "720672008",
      "display" : "telmisartán"
    },
    {
      "code" : "292362007",
      "display" : "temazepam"
    },
    {
      "code" : "292976001",
      "display" : "temocilina"
    },
    {
      "code" : "292089009",
      "display" : "tenoxicam"
    },
    {
      "code" : "292617004",
      "display" : "teofilina"
    },
    {
      "code" : "292616008",
      "display" : "teofilinato de colina"
    },
    {
      "code" : "292802001",
      "display" : "terbinafina"
    },
    {
      "code" : "292570003",
      "display" : "terfenadina"
    },
    {
      "code" : "293271006",
      "display" : "terlipresina"
    },
    {
      "code" : "292721004",
      "display" : "terpenos"
    },
    {
      "code" : "293240002",
      "display" : "testosterona intramuscular"
    },
    {
      "code" : "293241003",
      "display" : "testosterona oral"
    },
    {
      "code" : "218724007",
      "display" : "tetracaína"
    },
    {
      "code" : "293056002",
      "display" : "tetraciclina"
    },
    {
      "code" : "293568004",
      "display" : "tetradecil sulfato de sodio"
    },
    {
      "code" : "292919003",
      "display" : "tiabendazol"
    },
    {
      "code" : "406434004",
      "display" : "tianfenicol"
    },
    {
      "code" : "293219003",
      "display" : "tibolona"
    },
    {
      "code" : "871510007",
      "display" : "ticarcilina y ácido clavulánico"
    },
    {
      "code" : "292391005",
      "display" : "tietilperazina"
    },
    {
      "code" : "292551008",
      "display" : "tiloxapol"
    },
    {
      "code" : "292442003",
      "display" : "timolol"
    },
    {
      "code" : "293030009",
      "display" : "tinidazol"
    },
    {
      "code" : "292904004",
      "display" : "tintura desinfectante"
    },
    {
      "code" : "292817002",
      "display" : "tioconazol"
    },
    {
      "code" : "292167007",
      "display" : "tiopentona"
    },
    {
      "code" : "292396000",
      "display" : "tioridazina"
    },
    {
      "code" : "292201004",
      "display" : "tiotepa"
    },
    {
      "code" : "218488009",
      "display" : "tiroglobulina"
    },
    {
      "code" : "293293001",
      "display" : "tirotrofina"
    },
    {
      "code" : "292929005",
      "display" : "tobramicina"
    },
    {
      "code" : "1179724008",
      "display" : "tocilizumab"
    },
    {
      "code" : "293200008",
      "display" : "tolazamida"
    },
    {
      "code" : "293201007",
      "display" : "tolbutamida"
    },
    {
      "code" : "292805004",
      "display" : "tolnaftato"
    },
    {
      "code" : "293467006",
      "display" : "torasemida"
    },
    {
      "code" : "815121161000119000",
      "display" : "tramadol"
    },
    {
      "code" : "293506003",
      "display" : "trandolapril"
    },
    {
      "code" : "441858005",
      "display" : "trastuzumab administrado por infusión"
    },
    {
      "code" : "292517009",
      "display" : "dipivefrina"
    },
    {
      "code" : "293440000",
      "display" : "disopiramida"
    },
    {
      "code" : "292472009",
      "display" : "distigmina"
    },
    {
      "code" : "292417007",
      "display" : "disulfiram"
    },
    {
      "code" : "292631004",
      "display" : "ditranol"
    },
    {
      "code" : "293453002",
      "display" : "diurético"
    },
    {
      "code" : "293468001",
      "display" : "diurético ahorrador de potasio"
    },
    {
      "code" : "293462000",
      "display" : "diurético de asa"
    },
    {
      "code" : "218972004",
      "display" : "diurético derivado de purina"
    },
    {
      "code" : "293484000",
      "display" : "diurético mercurial"
    },
    {
      "code" : "293482001",
      "display" : "diurético osmótico"
    },
    {
      "code" : "419055000",
      "display" : "diurético tipo sulfonamida"
    },
    {
      "code" : "218370002",
      "display" : "diyodohidroxiquina"
    },
    {
      "code" : "292505007",
      "display" : "dobutamina"
    },
    {
      "code" : "292145006",
      "display" : "docusato"
    },
    {
      "code" : "292899003",
      "display" : "domifeno"
    },
    {
      "code" : "292132007",
      "display" : "domperidona"
    },
    {
      "code" : "292518004",
      "display" : "dopamina"
    },
    {
      "code" : "292506008",
      "display" : "dopexamina"
    },
    {
      "code" : "292290008",
      "display" : "dotiepina"
    },
    {
      "code" : "292559005",
      "display" : "doxapram"
    },
    {
      "code" : "292445001",
      "display" : "doxazosina"
    },
    {
      "code" : "292281001",
      "display" : "doxepina"
    },
    {
      "code" : "293049008",
      "display" : "doxiciclina"
    },
    {
      "code" : "292224006",
      "display" : "doxorubicina"
    },
    {
      "code" : "292381004",
      "display" : "droperidol"
    },
    {
      "code" : "6901000122108",
      "display" : "ebastina"
    },
    {
      "code" : "6911000122106",
      "display" : "eberconazol"
    },
    {
      "code" : "292818007",
      "display" : "econazol"
    },
    {
      "code" : "292746004",
      "display" : "edetato"
    },
    {
      "code" : "292747008",
      "display" : "edetato de dicobalto"
    },
    {
      "code" : "292750006",
      "display" : "edetato disódico"
    },
    {
      "code" : "292749006",
      "display" : "edetato trisódico"
    },
    {
      "code" : "292474005",
      "display" : "edrofonio"
    },
    {
      "code" : "293412005",
      "display" : "electrólito aniónico"
    },
    {
      "code" : "218382006",
      "display" : "emetina"
    },
    {
      "code" : "293507007",
      "display" : "enalapril"
    },
    {
      "code" : "292390006",
      "display" : "enantato de flufenazina"
    },
    {
      "code" : "292170006",
      "display" : "enflurano"
    },
    {
      "code" : "292950001",
      "display" : "enoxacino"
    },
    {
      "code" : "293523007",
      "display" : "enoximona"
    },
    {
      "code" : "421530001",
      "display" : "epinefrina"
    },
    {
      "code" : "292225007",
      "display" : "epirubicina"
    },
    {
      "code" : "293307008",
      "display" : "epoetina beta"
    },
    {
      "code" : "292720003",
      "display" : "epoprostenol"
    },
    {
      "code" : "293261009",
      "display" : "ergolina"
    },
    {
      "code" : "419056004",
      "display" : "eritromicina"
    },
    {
      "code" : "292427001",
      "display" : "esmolol"
    },
    {
      "code" : "218764006",
      "display" : "espiperona"
    },
    {
      "code" : "293472002",
      "display" : "espironolactona"
    },
    {
      "code" : "866258001",
      "display" : "estabilizante de mastocitos"
    },
    {
      "code" : "293218006",
      "display" : "esteroides anabólicos"
    },
    {
      "code" : "293062007",
      "display" : "estibogluconato de sodio"
    },
    {
      "code" : "293245007",
      "display" : "estradiol administrado por vía oral"
    },
    {
      "code" : "292208005",
      "display" : "estramustina"
    },
    {
      "code" : "292925004",
      "display" : "estreptomicina"
    },
    {
      "code" : "293578001",
      "display" : "estreptoquinasa estreptodornasa"
    },
    {
      "code" : "293243000",
      "display" : "estrógeno"
    },
    {
      "code" : "871521003",
      "display" : "estrógeno y/o progesterona"
    },
    {
      "code" : "293079001",
      "display" : "etambutol"
    },
    {
      "code" : "292558002",
      "display" : "etamiván"
    },
    {
      "code" : "1255408003",
      "display" : "etanol"
    },
    {
      "code" : "293255006",
      "display" : "etinilestradiol"
    },
    {
      "code" : "218406006",
      "display" : "etionamida"
    },
    {
      "code" : "292205008",
      "display" : "etoglúcido"
    },
    {
      "code" : "292235001",
      "display" : "etopósido"
    },
    {
      "code" : "292328007",
      "display" : "etosuximida"
    },
    {
      "code" : "438784000",
      "display" : "excipiente farmacéutico"
    },
    {
      "code" : "770710000",
      "display" : "factor de von Willebrand"
    },
    {
      "code" : "770704000",
      "display" : "factor IX"
    },
    {
      "code" : "770705004",
      "display" : "factor V"
    },
    {
      "code" : "770707007",
      "display" : "factor VII"
    },
    {
      "code" : "770708002",
      "display" : "factor XI"
    },
    {
      "code" : "770709005",
      "display" : "factor XIII"
    },
    {
      "code" : "292831002",
      "display" : "famciclovir"
    },
    {
      "code" : "292108000",
      "display" : "famotidina"
    },
    {
      "code" : "789273007",
      "display" : "fármaco agonista de receptor adrenérgico alfa 2 central"
    },
    {
      "code" : "292483000",
      "display" : "fármaco agonista de receptor alfa-adrenérgico"
    },
    {
      "code" : "292491009",
      "display" : "fármaco agonista de receptor beta-adrenérgico"
    },
    {
      "code" : "292061006",
      "display" : "fármaco análogo de la petidina"
    },
    {
      "code" : "292176000",
      "display" : "fármaco anestésico de acción local"
    },
    {
      "code" : "292259006",
      "display" : "fármaco anorexígeno de acción central"
    },
    {
      "code" : "293436009",
      "display" : "fármaco antiarrítmico"
    },
    {
      "code" : "293448007",
      "display" : "fármaco antiarrítmico de clase II"
    },
    {
      "code" : "293450004",
      "display" : "fármaco antiarrítmico de clase III"
    },
    {
      "code" : "219036002",
      "display" : "fármaco antiasmático"
    },
    {
      "code" : "292522009",
      "display" : "fármaco anticolinérgico"
    },
    {
      "code" : "430400006",
      "display" : "fármaco antidiabético"
    },
    {
      "code" : "292125003",
      "display" : "fármaco antidiarreico"
    },
    {
      "code" : "292130004",
      "display" : "fármaco antiemético"
    },
    {
      "code" : "292314001",
      "display" : "fármaco antiepiléptico"
    },
    {
      "code" : "292146007",
      "display" : "fármaco antiespasmódico"
    },
    {
      "code" : "293495006",
      "display" : "fármaco antihipertensivo"
    },
    {
      "code" : "292567002",
      "display" : "fármaco antihistamínico H1"
    },
    {
      "code" : "419901001",
      "display" : "fármaco antiinflamatorio no esteroide"
    },
    {
      "code" : "293080003",
      "display" : "fármaco antileproso"
    },
    {
      "code" : "292800009",
      "display" : "fármaco antimicótico"
    },
    {
      "code" : "292523004",
      "display" : "fármaco antimuscarínico"
    },
    {
      "code" : "292196008",
      "display" : "fármaco antineoplásico"
    },
    {
      "code" : "292847000",
      "display" : "fármaco antipalúdico"
    },
    {
      "code" : "292849002",
      "display" : "fármaco antipalúdico con aminoquinolina"
    },
    {
      "code" : "292855007",
      "display" : "fármaco antipalúdico con biguanida"
    },
    {
      "code" : "430136001",
      "display" : "fármaco antiparkinsoniano"
    },
    {
      "code" : "293059009",
      "display" : "fármaco antiprotozoario"
    },
    {
      "code" : "293136001",
      "display" : "fármaco antitiroideo"
    },
    {
      "code" : "293070002",
      "display" : "fármaco antituberculoso"
    },
    {
      "code" : "292826004",
      "display" : "fármaco antiviral"
    },
    {
      "code" : "292420004",
      "display" : "fármaco betabloqueante cardioselectivo"
    },
    {
      "code" : "292452004",
      "display" : "fármaco bloqueante de los canales del calcio"
    },
    {
      "code" : "292443008",
      "display" : "fármaco bloqueante del receptor alfa-adrenérgico"
    },
    {
      "code" : "293454008",
      "display" : "fármaco diurético tiazídico"
    },
    {
      "code" : "292410009",
      "display" : "fármaco estimulante de acción central"
    },
    {
      "code" : "292128001",
      "display" : "fármaco estimulante de la motilidad"
    },
    {
      "code" : "292556003",
      "display" : "fármaco estimulante respiratorio"
    },
    {
      "code" : "292504006",
      "display" : "fármaco estimulante selectivo de receptor beta-1 adrenérgico"
    },
    {
      "code" : "292492002",
      "display" : "fármaco estimulante selectivo de receptor beta-2 adrenérgico"
    },
    {
      "code" : "293417004",
      "display" : "fármaco hipolipemiante"
    },
    {
      "code" : "292111004",
      "display" : "fármaco inhibidor de la bomba de protones"
    },
    {
      "code" : "292302009",
      "display" : "fármaco inhibidor selectivo de la recaptación de serotonina"
    },
    {
      "code" : "292188003",
      "display" : "fármaco inmunoestimulante"
    },
    {
      "code" : "292255000",
      "display" : "fármaco inmunosupresor"
    },
    {
      "code" : "292465008",
      "display" : "fármaco parasimpaticomimético"
    },
    {
      "code" : "292469002",
      "display" : "fármaco parasimpaticomimético anticolinesterasa"
    },
    {
      "code" : "292331008",
      "display" : "fármaco sedante"
    },
    {
      "code" : "292479000",
      "display" : "fármaco simpaticomimético"
    },
    {
      "code" : "218916005",
      "display" : "fármaco vasoactivo a nivel capilar"
    },
    {
      "code" : "870411001",
      "display" : "fármaco vasopresor"
    },
    {
      "code" : "292920009",
      "display" : "fármacos antibacterianos"
    },
    {
      "code" : "218568007",
      "display" : "fármacos fibrinolíticos"
    },
    {
      "code" : "219063001",
      "display" : "fármacos lipotrópicos"
    },
    {
      "code" : "292457005",
      "display" : "felodipino"
    },
    {
      "code" : "292047001",
      "display" : "fenazocina"
    },
    {
      "code" : "218615007",
      "display" : "fenbufén"
    },
    {
      "code" : "292958008",
      "display" : "feneticilina"
    },
    {
      "code" : "292086002",
      "display" : "fenilbutazona"
    },
    {
      "code" : "292489001",
      "display" : "fenilefrina"
    },
    {
      "code" : "292595002",
      "display" : "fenindamina"
    },
    {
      "code" : "292596001",
      "display" : "feniramina"
    },
    {
      "code" : "292327002",
      "display" : "fenitoína"
    },
    {
      "code" : "293428000",
      "display" : "fenofibrato"
    },
    {
      "code" : "292878001",
      "display" : "fenol"
    },
    {
      "code" : "218941003",
      "display" : "fenolftaleína"
    },
    {
      "code" : "292075004",
      "display" : "fenoprofeno"
    },
    {
      "code" : "218643003",
      "display" : "fenosuximida"
    },
    {
      "code" : "292386009",
      "display" : "fenotiazina"
    },
    {
      "code" : "292447009",
      "display" : "fenoxibenzamina"
    },
    {
      "code" : "292959000",
      "display" : "fenoximetilpenicilina"
    },
    {
      "code" : "292261002",
      "display" : "fentermina"
    },
    {
      "code" : "292448004",
      "display" : "fentolamina"
    },
    {
      "code" : "218581000",
      "display" : "fibrinógeno humano"
    },
    {
      "code" : "293228002",
      "display" : "finasterida"
    },
    {
      "code" : "218566006",
      "display" : "fitomenadiona"
    },
    {
      "code" : "292702007",
      "display" : "flavoxato"
    },
    {
      "code" : "293535006",
      "display" : "flosequinán"
    },
    {
      "code" : "293161003",
      "display" : "fluclorolona"
    },
    {
      "code" : "292964001",
      "display" : "flucloxacilina"
    },
    {
      "code" : "292824001",
      "display" : "fluconazol"
    },
    {
      "code" : "292244000",
      "display" : "fludarabina"
    },
    {
      "code" : "292392003",
      "display" : "flufenazina"
    },
    {
      "code" : "292732004",
      "display" : "flumazenil"
    },
    {
      "code" : "292344003",
      "display" : "flunitrazepam"
    },
    {
      "code" : "293151005",
      "display" : "fluocinonida"
    },
    {
      "code" : "293414006",
      "display" : "flúor"
    },
    {
      "code" : "293147008",
      "display" : "fluorometolona"
    },
    {
      "code" : "293415007",
      "display" : "fluoruro de sodio"
    },
    {
      "code" : "292405005",
      "display" : "flupentixol"
    },
    {
      "code" : "292345002",
      "display" : "flurazepam"
    },
    {
      "code" : "292076003",
      "display" : "flurbiprofeno"
    },
    {
      "code" : "293229005",
      "display" : "flutamida"
    },
    {
      "code" : "293434007",
      "display" : "fluvastatina"
    },
    {
      "code" : "292308008",
      "display" : "fluvoxamina"
    },
    {
      "code" : "292610002",
      "display" : "folcodina"
    },
    {
      "code" : "292886001",
      "display" : "formaldehído"
    },
    {
      "code" : "292249005",
      "display" : "formestano"
    },
    {
      "code" : "292842006",
      "display" : "foscarnet"
    },
    {
      "code" : "293366001",
      "display" : "fosfato ferroso"
    },
    {
      "code" : "293406000",
      "display" : "fosfato sódico celulósico"
    },
    {
      "code" : "293253004",
      "display" : "fosfestrol"
    },
    {
      "code" : "293021001",
      "display" : "fosfomicina"
    },
    {
      "code" : "293508002",
      "display" : "fosinopril"
    },
    {
      "code" : "403721009",
      "display" : "fototerapia por radiación ultravioleta B"
    },
    {
      "code" : "293035004",
      "display" : "ftalilsulfatiazol"
    },
    {
      "code" : "293361006",
      "display" : "fumarato ferroso"
    },
    {
      "code" : "293463005",
      "display" : "furosemida"
    },
    {
      "code" : "292318003",
      "display" : "gabapentina"
    },
    {
      "code" : "292688002",
      "display" : "galamina"
    },
    {
      "code" : "788160008",
      "display" : "gammaglobulina"
    },
    {
      "code" : "292829006",
      "display" : "ganciclovir"
    },
    {
      "code" : "293309006",
      "display" : "gelatina"
    },
    {
      "code" : "292713005",
      "display" : "gemeprost"
    },
    {
      "code" : "293419001",
      "display" : "gemfibrozilo"
    },
    {
      "code" : "420094007",
      "display" : "gentamicina"
    },
    {
      "code" : "293226003",
      "display" : "gestrinona"
    },
    {
      "code" : "293211000",
      "display" : "gestronol"
    },
    {
      "code" : "293194000",
      "display" : "glibenclamida"
    },
    {
      "code" : "293195004",
      "display" : "glibornurida"
    },
    {
      "code" : "292779004",
      "display" : "glicerol"
    },
    {
      "code" : "292759007",
      "display" : "glicina"
    },
    {
      "code" : "293196003",
      "display" : "gliclazida"
    },
    {
      "code" : "870516009",
      "display" : "glicol"
    },
    {
      "code" : "293199005",
      "display" : "glimidina"
    },
    {
      "code" : "293197007",
      "display" : "glipizida"
    },
    {
      "code" : "218582007",
      "display" : "glóbulos rojos concentrados"
    },
    {
      "code" : "293362004",
      "display" : "gluconato ferroso"
    },
    {
      "code" : "1163008006",
      "display" : "glucósido digitálico"
    },
    {
      "code" : "292883009",
      "display" : "glutaraldehído"
    },
    {
      "code" : "712950002",
      "display" : "glutetimida"
    },
    {
      "code" : "293277005",
      "display" : "gonadorelina"
    },
    {
      "code" : "293280006",
      "display" : "goserelina"
    },
    {
      "code" : "293172008",
      "display" : "gotas de prednisolona"
    },
    {
      "code" : "293047005",
      "display" : "grupo de tetraciclinas"
    },
    {
      "code" : "293499000",
      "display" : "guanetidina"
    },
    {
      "code" : "292859001",
      "display" : "halofantrina"
    },
    {
      "code" : "292172003",
      "display" : "halotano"
    },
    {
      "code" : "293315006",
      "display" : "hemoderivado"
    },
    {
      "code" : "293339001",
      "display" : "heparinoide"
    },
    {
      "code" : "292876002",
      "display" : "hexaclorofano"
    },
    {
      "code" : "218416003",
      "display" : "hexamina"
    },
    {
      "code" : "218394002",
      "display" : "hexilresorcinol"
    },
    {
      "code" : "871702008",
      "display" : "hidantoína y sus derivados"
    },
    {
      "code" : "293537003",
      "display" : "hidralazina"
    },
    {
      "code" : "292366005",
      "display" : "hidrato de cloral"
    },
    {
      "code" : "417906002",
      "display" : "hidrocortisona"
    },
    {
      "code" : "293144001",
      "display" : "hidrocortisona tópica"
    },
    {
      "code" : "218927007",
      "display" : "hidrotalcita"
    },
    {
      "code" : "292853000",
      "display" : "hidroxicloroquina"
    },
    {
      "code" : "292796003",
      "display" : "hidroxietilcelulosa"
    },
    {
      "code" : "293212007",
      "display" : "hidroxiprogesterona"
    },
    {
      "code" : "292593009",
      "display" : "hidroxizina"
    },
    {
      "code" : "293354007",
      "display" : "hierro"
    },
    {
      "code" : "293359002",
      "display" : "hierro sorbitol"
    },
    {
      "code" : "1163012000",
      "display" : "hierro y/o compuesto de hierro"
    },
    {
      "code" : "218938007",
      "display" : "higo"
    },
    {
      "code" : "870750003",
      "display" : "hipoglucemiante sulfonilureico"
    },
    {
      "code" : "292794000",
      "display" : "hipromelosa"
    },
    {
      "code" : "292539006",
      "display" : "homatropina"
    },
    {
      "code" : "871529001",
      "display" : "hormona"
    },
    {
      "code" : "293268003",
      "display" : "hormona antidiurética"
    },
    {
      "code" : "218471002",
      "display" : "hormona foliculoestimulante"
    },
    {
      "code" : "218481003",
      "display" : "hormona paratiroidea y/o derivado de hormona paratiroidea"
    },
    {
      "code" : "293276001",
      "display" : "hormona reguladora de las gonadotrofinas"
    },
    {
      "code" : "871684001",
      "display" : "hormona tiroidea"
    },
    {
      "code" : "218475006",
      "display" : "hormonas de la neurohipófisis"
    },
    {
      "code" : "218613000",
      "display" : "ibuprofeno"
    },
    {
      "code" : "6861000122103",
      "display" : "ibuprofeno arginato"
    },
    {
      "code" : "292226008",
      "display" : "idarubicina"
    },
    {
      "code" : "876801005",
      "display" : "idoxuridina en dimetilsulfóxido"
    },
    {
      "code" : "1179731007",
      "display" : "imdemivab"
    },
    {
      "code" : "292291007",
      "display" : "imipramina"
    },
    {
      "code" : "293239004",
      "display" : "implante de testosterona"
    },
    {
      "code" : "870674008",
      "display" : "indanodiona"
    },
    {
      "code" : "292078002",
      "display" : "indometacina"
    },
    {
      "code" : "293380008",
      "display" : "infusión de múltiples electrólitos"
    },
    {
      "code" : "293432006",
      "display" : "inhibidor de 3-hidroxi-3-metilglutaril coenzima A [HMG CoA] reductasa"
    },
    {
      "code" : "293522002",
      "display" : "inhibidor de fosfodiesterasa"
    },
    {
      "code" : "840589003",
      "display" : "inhibidor de la agregación plaquetaria"
    },
    {
      "code" : "292408007",
      "display" : "inhibidor de la descarboxilasa"
    },
    {
      "code" : "293500009",
      "display" : "inhibidor de la enzima convertidora de angiotensina"
    },
    {
      "code" : "448691006",
      "display" : "inhibidor de la fosfodiesterasa 5"
    },
    {
      "code" : "1288001008",
      "display" : "inhibidor de la recaptación de norepinefrina"
    },
    {
      "code" : "10851101000119100",
      "display" : "inhibidor de la recaptación de norepinefrina e inhibidor de la recaptación de serotonina"
    },
    {
      "code" : "420059000",
      "display" : "inhibidor de la resorción ósea"
    },
    {
      "code" : "292678003",
      "display" : "inhibidor de xantina oxidasa"
    },
    {
      "code" : "1222891000",
      "display" : "inmunoglobulina anti-D [Rh]"
    },
    {
      "code" : "293102007",
      "display" : "inmunoglobulina antitetánica"
    },
    {
      "code" : "293101000",
      "display" : "inmunoglobulina contra la hepatitis B"
    },
    {
      "code" : "293103002",
      "display" : "inmunoglobulina contra varicela zóster"
    },
    {
      "code" : "293097009",
      "display" : "inmunoglobulina humana"
    },
    {
      "code" : "293098004",
      "display" : "inmunoglobulina intramuscular"
    },
    {
      "code" : "293099007",
      "display" : "inmunoglobulina intravenosa"
    },
    {
      "code" : "292827008",
      "display" : "inosina pranobex"
    },
    {
      "code" : "293400006",
      "display" : "inositol"
    },
    {
      "code" : "293177002",
      "display" : "insulina"
    },
    {
      "code" : "870691007",
      "display" : "insulina cinc"
    },
    {
      "code" : "293184005",
      "display" : "insulina cinc protamina"
    },
    {
      "code" : "840300001",
      "display" : "insulina humana"
    },
    {
      "code" : "293183004",
      "display" : "insulina isófana"
    },
    {
      "code" : "833317005",
      "display" : "insulina regular"
    },
    {
      "code" : "292837003",
      "display" : "interferón -A-2a"
    },
    {
      "code" : "871681009",
      "display" : "interferón humano gamma-1b"
    },
    {
      "code" : "292838008",
      "display" : "interferón-A-2b"
    },
    {
      "code" : "292839000",
      "display" : "interferón-A-N1"
    },
    {
      "code" : "292835006",
      "display" : "interferones"
    },
    {
      "code" : "1155807002",
      "display" : "inyección de sustancia"
    },
    {
      "code" : "292724007",
      "display" : "ipecacuana"
    },
    {
      "code" : "292540008",
      "display" : "ipratropio"
    },
    {
      "code" : "292282008",
      "display" : "iprindol"
    },
    {
      "code" : "720675005",
      "display" : "irbesartán"
    },
    {
      "code" : "292888000",
      "display" : "isetionato de dibrompropamidina"
    },
    {
      "code" : "292296002",
      "display" : "isocarboxazida"
    },
    {
      "code" : "292173008",
      "display" : "isoflurano"
    },
    {
      "code" : "293078009",
      "display" : "isoniazida"
    },
    {
      "code" : "292509001",
      "display" : "isoprenalina administrada por inhalación"
    },
    {
      "code" : "292510006",
      "display" : "isoprenalina administrada por vía parenteral"
    },
    {
      "code" : "292669009",
      "display" : "isotretinoína"
    },
    {
      "code" : "293561005",
      "display" : "isoxsuprina"
    },
    {
      "code" : "292825000",
      "display" : "itraconazol"
    },
    {
      "code" : "292654008",
      "display" : "jabón alcalino"
    },
    {
      "code" : "292165004",
      "display" : "ketamina"
    },
    {
      "code" : "292821009",
      "display" : "ketoconazol"
    },
    {
      "code" : "292080008",
      "display" : "ketorolaco"
    },
    {
      "code" : "292602003",
      "display" : "ketotifeno"
    },
    {
      "code" : "292435003",
      "display" : "labetalol"
    },
    {
      "code" : "292458000",
      "display" : "lacidipino"
    },
    {
      "code" : "292316004",
      "display" : "lamotrigina"
    },
    {
      "code" : "292113001",
      "display" : "lansoprazol"
    },
    {
      "code" : "293001002",
      "display" : "latamoxef"
    },
    {
      "code" : "292142009",
      "display" : "laxante a base de antraquinona"
    },
    {
      "code" : "292193000",
      "display" : "lenograstim"
    },
    {
      "code" : "293283008",
      "display" : "leuprorelina"
    },
    {
      "code" : "292195007",
      "display" : "levamisol"
    },
    {
      "code" : "292436002",
      "display" : "levobunolol"
    },
    {
      "code" : "292387000",
      "display" : "levomepromazina"
    },
    {
      "code" : "292067005",
      "display" : "levorfanol"
    },
    {
      "code" : "292180005",
      "display" : "lidocaína"
    },
    {
      "code" : "293050008",
      "display" : "limeciclina"
    },
    {
      "code" : "293024009",
      "display" : "lincomicina"
    },
    {
      "code" : "293089002",
      "display" : "lindano"
    },
    {
      "code" : "293270007",
      "display" : "lipresina"
    },
    {
      "code" : "292760002",
      "display" : "líquido de diálisis"
    },
    {
      "code" : "419406002",
      "display" : "líquido o solución farmacéutica"
    },
    {
      "code" : "218792001",
      "display" : "lisergida"
    },
    {
      "code" : "292272007",
      "display" : "lisurida"
    },
    {
      "code" : "218808002",
      "display" : "lobelina"
    },
    {
      "code" : "74081000122104",
      "display" : "local a vacuna"
    },
    {
      "code" : "292283003",
      "display" : "lofepramina"
    },
    {
      "code" : "292213009",
      "display" : "lomustina"
    },
    {
      "code" : "292126002",
      "display" : "loperamida"
    },
    {
      "code" : "292572006",
      "display" : "loratadina"
    },
    {
      "code" : "292347005",
      "display" : "lormetazepam"
    },
    {
      "code" : "293513003",
      "display" : "losartán"
    },
    {
      "code" : "292373000",
      "display" : "loxapina"
    },
    {
      "code" : "6931000122102",
      "display" : "mabuprofeno"
    },
    {
      "code" : "870515008",
      "display" : "macrogol"
    },
    {
      "code" : "293043009",
      "display" : "mafenida"
    },
    {
      "code" : "293091005",
      "display" : "malatión"
    },
    {
      "code" : "293483006",
      "display" : "manitol"
    },
    {
      "code" : "292260001",
      "display" : "mazindol"
    },
    {
      "code" : "292150000",
      "display" : "mebeverina"
    },
    {
      "code" : "292577000",
      "display" : "mebhidrolina"
    },
    {
      "code" : "292356002",
      "display" : "medazepam"
    },
    {
      "code" : "292754002",
      "display" : "medicamentos homeopáticos"
    },
    {
      "code" : "293520005",
      "display" : "medigoxina"
    },
    {
      "code" : "429188006",
      "display" : "medio de contraste oral"
    },
    {
      "code" : "292097002",
      "display" : "medio de contraste para resonancia magnética"
    },
    {
      "code" : "292096006",
      "display" : "medio de contraste radiográfico"
    },
    {
      "code" : "293217001",
      "display" : "medroxiprogesterona"
    },
    {
      "code" : "218698008",
      "display" : "mefenesina"
    },
    {
      "code" : "292852005",
      "display" : "mefloquina"
    },
    {
      "code" : "293489005",
      "display" : "mefrusida"
    },
    {
      "code" : "293213002",
      "display" : "megestrol"
    },
    {
      "code" : "292207000",
      "display" : "melfalán"
    },
    {
      "code" : "6921000122100",
      "display" : "melitraceno"
    },
    {
      "code" : "292860006",
      "display" : "mepacrina"
    },
    {
      "code" : "292152008",
      "display" : "mepenzolato"
    },
    {
      "code" : "292594003",
      "display" : "mepiramina"
    },
    {
      "code" : "292364008",
      "display" : "meprobamato"
    },
    {
      "code" : "292066001",
      "display" : "meptazinol"
    },
    {
      "code" : "292578005",
      "display" : "mequitazina"
    },
    {
      "code" : "218969006",
      "display" : "mercaptomerina"
    },
    {
      "code" : "292230006",
      "display" : "mercaptopurina"
    },
    {
      "code" : "218970007",
      "display" : "mercurofilina"
    },
    {
      "code" : "293485004",
      "display" : "mersalilo"
    },
    {
      "code" : "292118005",
      "display" : "mesalazina"
    },
    {
      "code" : "218794000",
      "display" : "mescalina"
    },
    {
      "code" : "293529006",
      "display" : "mesilato de dihidroergotamina"
    },
    {
      "code" : "292730007",
      "display" : "mesna"
    },
    {
      "code" : "293236006",
      "display" : "mesterolona"
    },
    {
      "code" : "293254005",
      "display" : "mestranol"
    },
    {
      "code" : "292468005",
      "display" : "metacolina"
    },
    {
      "code" : "766220004",
      "display" : "metacualona"
    },
    {
      "code" : "292052006",
      "display" : "metadona"
    },
    {
      "code" : "10851061000119100",
      "display" : "metanfetamina"
    },
    {
      "code" : "293203005",
      "display" : "metformina"
    },
    {
      "code" : "293460008",
      "display" : "meticlotiazida"
    },
    {
      "code" : "292554000",
      "display" : "metilcisteína"
    },
    {
      "code" : "292412001",
      "display" : "metilfenidato"
    },
    {
      "code" : "293169001",
      "display" : "metilprednisolona"
    },
    {
      "code" : "293237002",
      "display" : "metiltestosterona"
    },
    {
      "code" : "292335004",
      "display" : "metiprilón"
    },
    {
      "code" : "293512008",
      "display" : "metirosina"
    },
    {
      "code" : "292695006",
      "display" : "metocarbamol"
    },
    {
      "code" : "292168002",
      "display" : "metohexital"
    },
    {
      "code" : "293490001",
      "display" : "metolazona"
    },
    {
      "code" : "292229001",
      "display" : "metotrexato"
    },
    {
      "code" : "293029004",
      "display" : "metronidazol"
    },
    {
      "code" : "293443003",
      "display" : "mexiletina"
    },
    {
      "code" : "292311009",
      "display" : "mianserina"
    },
    {
      "code" : "292359009",
      "display" : "midazolam"
    },
    {
      "code" : "292704008",
      "display" : "mifepristona"
    },
    {
      "code" : "418505005",
      "display" : "mineralocorticoide"
    },
    {
      "code" : "293533004",
      "display" : "minoxidil"
    },
    {
      "code" : "292684000",
      "display" : "miorrelajante no despolarizante"
    },
    {
      "code" : "292682001",
      "display" : "miorrelajantes despolarizantes"
    },
    {
      "code" : "449845006",
      "display" : "mirtazapina"
    },
    {
      "code" : "292198009",
      "display" : "mitobronitol"
    },
    {
      "code" : "292223000",
      "display" : "mitoxantrona"
    },
    {
      "code" : "292685004",
      "display" : "mivacurio"
    },
    {
      "code" : "292790009",
      "display" : "modificador de la viscosidad"
    },
    {
      "code" : "292192005",
      "display" : "molgramostim"
    },
    {
      "code" : "15920321000119100",
      "display" : "molusco"
    },
    {
      "code" : "293165007",
      "display" : "mometasona"
    },
    {
      "code" : "293552005",
      "display" : "mononitrato de isosorbida"
    },
    {
      "code" : "293444009",
      "display" : "moracizina"
    },
    {
      "code" : "292059002",
      "display" : "morfina"
    },
    {
      "code" : "292209002",
      "display" : "mustina"
    },
    {
      "code" : "292082000",
      "display" : "nabumetona"
    },
    {
      "code" : "293278000",
      "display" : "nafarelina"
    },
    {
      "code" : "292487004",
      "display" : "nafazolina"
    },
    {
      "code" : "292058005",
      "display" : "nalbufina"
    },
    {
      "code" : "218814009",
      "display" : "nalorfina"
    },
    {
      "code" : "292737005",
      "display" : "naltrexona"
    },
    {
      "code" : "218620007",
      "display" : "naproxeno"
    },
    {
      "code" : "772020009",
      "display" : "nebivolol"
    },
    {
      "code" : "292600006",
      "display" : "nedocromilo"
    },
    {
      "code" : "292084004",
      "display" : "nefopam"
    },
    {
      "code" : "292476007",
      "display" : "neostigmina"
    },
    {
      "code" : "292924000",
      "display" : "netilmicina"
    },
    {
      "code" : "292462006",
      "display" : "nicardipino"
    },
    {
      "code" : "293559001",
      "display" : "nicofuranosa"
    },
    {
      "code" : "293538008",
      "display" : "nicorandil"
    },
    {
      "code" : "293560006",
      "display" : "nicotinato de inositol"
    },
    {
      "code" : "292454003",
      "display" : "nifedipino"
    },
    {
      "code" : "292459008",
      "display" : "nimodipino"
    },
    {
      "code" : "292557007",
      "display" : "niquetamida"
    },
    {
      "code" : "292662000",
      "display" : "nitrato de plata"
    },
    {
      "code" : "292348000",
      "display" : "nitrazepam"
    },
    {
      "code" : "292803006",
      "display" : "nitrofenol"
    },
    {
      "code" : "292940002",
      "display" : "nitrofurantoína"
    },
    {
      "code" : "293028007",
      "display" : "nitroimidazol"
    },
    {
      "code" : "292210007",
      "display" : "nitrosourea"
    },
    {
      "code" : "292109008",
      "display" : "nizatidina"
    },
    {
      "code" : "292488009",
      "display" : "noradrenalina"
    },
    {
      "code" : "293214008",
      "display" : "noretisterona"
    },
    {
      "code" : "292952009",
      "display" : "norfloxacino"
    },
    {
      "code" : "292284009",
      "display" : "nortriptilina"
    },
    {
      "code" : "292609007",
      "display" : "noscapina"
    },
    {
      "code" : "292885002",
      "display" : "noxitiolina"
    },
    {
      "code" : "293367005",
      "display" : "nutrición parenteral"
    },
    {
      "code" : "293371008",
      "display" : "nutrición parenteral (aminoácidos)"
    },
    {
      "code" : "293372001",
      "display" : "nutrición parenteral (carbohidratos)"
    },
    {
      "code" : "293373006",
      "display" : "nutrición parenteral (grasas)"
    },
    {
      "code" : "293374000",
      "display" : "nutrición parenteral (mezclada)"
    },
    {
      "code" : "293370009",
      "display" : "nutrición parenteral (vitaminas)"
    },
    {
      "code" : "292707001",
      "display" : "octoxinol"
    },
    {
      "code" : "293289007",
      "display" : "octreotida"
    },
    {
      "code" : "292951002",
      "display" : "ofloxacino"
    },
    {
      "code" : "406447009",
      "display" : "oleandomicina"
    },
    {
      "code" : "218395001",
      "display" : "oleorresina de helecho macho"
    },
    {
      "code" : "720674009",
      "display" : "olmesartán"
    },
    {
      "code" : "292120008",
      "display" : "olsalazina"
    },
    {
      "code" : "292112006",
      "display" : "omeprazol"
    },
    {
      "code" : "292053001",
      "display" : "opioide"
    },
    {
      "code" : "292498003",
      "display" : "orciprenalina"
    },
    {
      "code" : "292542000",
      "display" : "orfenadrina"
    },
    {
      "code" : "292697003",
      "display" : "oro"
    },
    {
      "code" : "863969000",
      "display" : "oro y/o compuesto de oro"
    },
    {
      "code" : "292104003",
      "display" : "orozuz"
    },
    {
      "code" : "293521009",
      "display" : "ouabaína"
    },
    {
      "code" : "292579002",
      "display" : "oxatomida"
    },
    {
      "code" : "292357006",
      "display" : "oxazepam"
    },
    {
      "code" : "292546002",
      "display" : "oxibutinina"
    },
    {
      "code" : "292228009",
      "display" : "óxido mercúrico"
    },
    {
      "code" : "292085003",
      "display" : "oxifenbutazona"
    },
    {
      "code" : "292520001",
      "display" : "oximetazolina"
    },
    {
      "code" : "292406006",
      "display" : "oxipertina"
    },
    {
      "code" : "293052000",
      "display" : "oxitetraciclina"
    },
    {
      "code" : "293285001",
      "display" : "oxitocina"
    },
    {
      "code" : "292545003",
      "display" : "oxitropio"
    },
    {
      "code" : "292437006",
      "display" : "oxprenolol"
    },
    {
      "code" : "218951002",
      "display" : "pancreatina"
    },
    {
      "code" : "292642008",
      "display" : "pantallas solares"
    },
    {
      "code" : "218952009",
      "display" : "papaína"
    },
    {
      "code" : "292042007",
      "display" : "paracetamol"
    },
    {
      "code" : "292784005",
      "display" : "parafina blanda amarilla"
    },
    {
      "code" : "292785006",
      "display" : "parafina blanda blanca"
    },
    {
      "code" : "292336003",
      "display" : "paraldehído"
    },
    {
      "code" : "218635008",
      "display" : "parametadiona"
    },
    {
      "code" : "292304005",
      "display" : "paroxetina"
    },
    {
      "code" : "292634007",
      "display" : "pasta con ditranol"
    },
    {
      "code" : "218959000",
      "display" : "pectina"
    },
    {
      "code" : "292438001",
      "display" : "penbutolol"
    },
    {
      "code" : "292752003",
      "display" : "penicilamina"
    },
    {
      "code" : "292957003",
      "display" : "penicilina benzatínica"
    },
    {
      "code" : "292975002",
      "display" : "penicilinas antipseudomonas"
    },
    {
      "code" : "292966004",
      "display" : "penicilinas de amplio espectro"
    },
    {
      "code" : "292955006",
      "display" : "penicilinas sensibles a la penicilinasa"
    },
    {
      "code" : "293311002",
      "display" : "pentalmidón"
    },
    {
      "code" : "293064008",
      "display" : "pentamidina"
    },
    {
      "code" : "218665003",
      "display" : "pentobarbital"
    },
    {
      "code" : "293557004",
      "display" : "pentoxifilina"
    },
    {
      "code" : "218953004",
      "display" : "pepsina"
    },
    {
      "code" : "292397009",
      "display" : "perfenazina"
    },
    {
      "code" : "292273002",
      "display" : "pergolida"
    },
    {
      "code" : "293509005",
      "display" : "perindopril"
    },
    {
      "code" : "293094002",
      "display" : "permetrina"
    },
    {
      "code" : "292661007",
      "display" : "peróxido de benzoilo"
    },
    {
      "code" : "292064003",
      "display" : "petidina"
    },
    {
      "code" : "292138006",
      "display" : "picosulfato sódico"
    },
    {
      "code" : "292384007",
      "display" : "pimozida"
    },
    {
      "code" : "292431007",
      "display" : "pindolol"
    },
    {
      "code" : "292153003",
      "display" : "pipenzolato"
    },
    {
      "code" : "871507000",
      "display" : "piperacilina y/o tazobactam"
    },
    {
      "code" : "292911000",
      "display" : "piperazina"
    },
    {
      "code" : "292394002",
      "display" : "pipotiazina"
    },
    {
      "code" : "292317008",
      "display" : "piracetam"
    },
    {
      "code" : "292912007",
      "display" : "pirantel"
    },
    {
      "code" : "292493007",
      "display" : "pirbuterol"
    },
    {
      "code" : "293466002",
      "display" : "piretanida"
    },
    {
      "code" : "870679003",
      "display" : "piretroide"
    },
    {
      "code" : "292848005",
      "display" : "pirimetamina"
    },
    {
      "code" : "720680001",
      "display" : "pitavastatina"
    },
    {
      "code" : "292971006",
      "display" : "pivampicilina"
    },
    {
      "code" : "292982003",
      "display" : "pivmecilinam"
    },
    {
      "code" : "293083001",
      "display" : "plaguicida"
    },
    {
      "code" : "293088005",
      "display" : "plaguicida clorado"
    },
    {
      "code" : "293090006",
      "display" : "plaguicida organofosforado"
    },
    {
      "code" : "218580004",
      "display" : "plasma sanguíneo"
    },
    {
      "code" : "292221003",
      "display" : "plicamicina"
    },
    {
      "code" : "292641001",
      "display" : "podofilotoxina"
    },
    {
      "code" : "292154009",
      "display" : "poldina"
    },
    {
      "code" : "294930001",
      "display" : "ácido fólico"
    },
    {
      "code" : "294206005",
      "display" : "ácido gamolénico"
    },
    {
      "code" : "294563004",
      "display" : "ácido mandélico"
    },
    {
      "code" : "294486009",
      "display" : "ácido nalidíxico"
    },
    {
      "code" : "21981000122102",
      "display" : "ácido paraaminobenzoico y sus derivados"
    },
    {
      "code" : "871501004",
      "display" : "ácido quenodeoxicólico y/o ácido ursodeoxicólico"
    },
    {
      "code" : "20361000122100",
      "display" : "ácido tiludrónico"
    },
    {
      "code" : "773485002",
      "display" : "ácido valproico"
    },
    {
      "code" : "294958009",
      "display" : "acipimox"
    },
    {
      "code" : "294113002",
      "display" : "acrivastina"
    },
    {
      "code" : "294975003",
      "display" : "adenosina"
    },
    {
      "code" : "19771000122108",
      "display" : "adifenina"
    },
    {
      "code" : "13691000122101",
      "display" : "afatinib"
    },
    {
      "code" : "91929009",
      "display" : "agente antiinfeccioso"
    },
    {
      "code" : "13651000122105",
      "display" : "agente antiplaquetario"
    },
    {
      "code" : "295104005",
      "display" : "agente antivaricoso"
    },
    {
      "code" : "402590009",
      "display" : "agente biocida en productos cosméticos"
    },
    {
      "code" : "295052002",
      "display" : "agente inotrópico cardíaco"
    },
    {
      "code" : "294679007",
      "display" : "hidrocortisona"
    },
    {
      "code" : "18161000122106",
      "display" : "hidromorfona"
    },
    {
      "code" : "293666009",
      "display" : "hidróxido de aluminio"
    },
    {
      "code" : "294750007",
      "display" : "hidroxiprogesterona"
    },
    {
      "code" : "294933004",
      "display" : "hidroxocobalamina"
    },
    {
      "code" : "294896006",
      "display" : "hierro sorbitol"
    },
    {
      "code" : "24041000122107",
      "display" : "hinojo"
    },
    {
      "code" : "860936004",
      "display" : "hipersensibilidad no alérgica a gadolinio y compuesto con gadolinio"
    },
    {
      "code" : "294081008",
      "display" : "homatropina"
    },
    {
      "code" : "24961000122107",
      "display" : "hormiga culona"
    },
    {
      "code" : "20241000122109",
      "display" : "hormona hipofisaria foliculoestimulante"
    },
    {
      "code" : "294838009",
      "display" : "hormona reguladora del calcio"
    },
    {
      "code" : "91930004",
      "display" : "huevos"
    },
    {
      "code" : "293619005",
      "display" : "ibuprofeno"
    },
    {
      "code" : "293768002",
      "display" : "idarubicina"
    },
    {
      "code" : "293750000",
      "display" : "ifosfamida"
    },
    {
      "code" : "860775000",
      "display" : "imidazol"
    },
    {
      "code" : "294784006",
      "display" : "implante de estradiol"
    },
    {
      "code" : "293620004",
      "display" : "indometacina"
    },
    {
      "code" : "789251000",
      "display" : "inhibidor de acetilcolinesterasa"
    },
    {
      "code" : "439109008",
      "display" : "inhibidor de alfa glucósido"
    },
    {
      "code" : "17681000122107",
      "display" : "inhibidor de la 5-alfa reductasa"
    },
    {
      "code" : "295059006",
      "display" : "inhibidor de la fosfodiesterasa"
    },
    {
      "code" : "13681000122104",
      "display" : "inhibidor de proteína quinasa"
    },
    {
      "code" : "294721000",
      "display" : "insulina cinc protamina"
    },
    {
      "code" : "294722007",
      "display" : "insulina isófana bifásica"
    },
    {
      "code" : "294377000",
      "display" : "interferón alfa-2a"
    },
    {
      "code" : "294376009",
      "display" : "interferón gamma-1b"
    },
    {
      "code" : "23311000122107",
      "display" : "iohexol"
    },
    {
      "code" : "293824005",
      "display" : "iprindol"
    },
    {
      "code" : "294429004",
      "display" : "isetionato de dibrompropamidina"
    },
    {
      "code" : "293838003",
      "display" : "isocarboxazida"
    },
    {
      "code" : "293715008",
      "display" : "isoflurano"
    },
    {
      "code" : "294052007",
      "display" : "isoprenalina administrada por inhalación"
    },
    {
      "code" : "294211007",
      "display" : "isotretinoína"
    },
    {
      "code" : "294366006",
      "display" : "itraconazol"
    },
    {
      "code" : "294196009",
      "display" : "jabón con metal alcalino"
    },
    {
      "code" : "24561000122103",
      "display" : "judía verde"
    },
    {
      "code" : "293897005",
      "display" : "ketazolam"
    },
    {
      "code" : "294134009",
      "display" : "difenilpiralina"
    },
    {
      "code" : "295054001",
      "display" : "digoxina"
    },
    {
      "code" : "294602004",
      "display" : "diloxanida"
    },
    {
      "code" : "294123006",
      "display" : "dimenhidrinato"
    },
    {
      "code" : "294306008",
      "display" : "dimetil-éter propano"
    },
    {
      "code" : "295085005",
      "display" : "dinitrato de isosorbida"
    },
    {
      "code" : "295086006",
      "display" : "dinitrato de isosorbida parenteral"
    },
    {
      "code" : "293593002",
      "display" : "dipipanona"
    },
    {
      "code" : "294060008",
      "display" : "dipivefrina"
    },
    {
      "code" : "293960001",
      "display" : "disulfiram"
    },
    {
      "code" : "295011006",
      "display" : "diurético compuesto ahorrador de potasio"
    },
    {
      "code" : "419930008",
      "display" : "diurético tipo sulfonamida"
    },
    {
      "code" : "17581000122108",
      "display" : "dolutegravir"
    },
    {
      "code" : "294061007",
      "display" : "dopamina"
    },
    {
      "code" : "294091002",
      "display" : "dornasa alfa"
    },
    {
      "code" : "449324007",
      "display" : "doxacurio"
    },
    {
      "code" : "293987002",
      "display" : "doxazosina"
    },
    {
      "code" : "18311000122106",
      "display" : "doxilamina"
    },
    {
      "code" : "293923000",
      "display" : "droperidol"
    },
    {
      "code" : "294359005",
      "display" : "econazol"
    },
    {
      "code" : "294285006",
      "display" : "edetato"
    },
    {
      "code" : "294289000",
      "display" : "edetato disódico"
    },
    {
      "code" : "294015007",
      "display" : "edrofonio"
    },
    {
      "code" : "20281000122100",
      "display" : "eflornitina"
    },
    {
      "code" : "76451000122106",
      "display" : "empagliflozina"
    },
    {
      "code" : "293932003",
      "display" : "enantato de flufenazina"
    },
    {
      "code" : "24231000122107",
      "display" : "eneldo"
    },
    {
      "code" : "20451000122107",
      "display" : "escopolamina"
    },
    {
      "code" : "293969000",
      "display" : "esmolol"
    },
    {
      "code" : "24461000122104",
      "display" : "espárrago verde"
    },
    {
      "code" : "23121000122103",
      "display" : "espinaca"
    },
    {
      "code" : "295009002",
      "display" : "espironolactona"
    },
    {
      "code" : "444316004",
      "display" : "estacional"
    },
    {
      "code" : "294757005",
      "display" : "esteroide anabólico"
    },
    {
      "code" : "294783000",
      "display" : "estradiol administrado por vía oral"
    },
    {
      "code" : "294466005",
      "display" : "estreptomicina"
    },
    {
      "code" : "294794001",
      "display" : "estriol"
    },
    {
      "code" : "294615008",
      "display" : "etambutol"
    },
    {
      "code" : "76151000122104",
      "display" : "etanercept"
    },
    {
      "code" : "767116002",
      "display" : "éter"
    },
    {
      "code" : "21811000122102",
      "display" : "etilefrina"
    },
    {
      "code" : "1025241000122100",
      "display" : "etofenamato"
    },
    {
      "code" : "293777009",
      "display" : "etopósido"
    },
    {
      "code" : "294208006",
      "display" : "etretinato"
    },
    {
      "code" : "36081000122106",
      "display" : "ezetimiba"
    },
    {
      "code" : "293734008",
      "display" : "factores estimulantes de colonias"
    },
    {
      "code" : "294032006",
      "display" : "fármaco agonista de receptor beta-adrenérgico"
    },
    {
      "code" : "294107006",
      "display" : "fármaco antialérgico"
    },
    {
      "code" : "294985002",
      "display" : "fármaco antiarrítmico de clase II"
    },
    {
      "code" : "293816000",
      "display" : "fármaco antidepresivo"
    },
    {
      "code" : "293857007",
      "display" : "fármaco antiepiléptico"
    },
    {
      "code" : "295051009",
      "display" : "fármaco antihipertensivo de rauwolfia"
    },
    {
      "code" : "294098008",
      "display" : "fármaco estimulante respiratorio"
    },
    {
      "code" : "294727001",
      "display" : "fármaco hipoglucemiante oral"
    },
    {
      "code" : "293677003",
      "display" : "fármaco laxante"
    },
    {
      "code" : "294213005",
      "display" : "fármaco para tratamiento de la gota"
    },
    {
      "code" : "293873001",
      "display" : "fármaco sedante"
    },
    {
      "code" : "295063004",
      "display" : "fármaco vasoconstrictor"
    },
    {
      "code" : "294450008",
      "display" : "fármacos antihelmínticos"
    },
    {
      "code" : "293589008",
      "display" : "fenazocina"
    },
    {
      "code" : "293836004",
      "display" : "fenelzina"
    },
    {
      "code" : "18291000122107",
      "display" : "fenicoles"
    },
    {
      "code" : "21851000122101",
      "display" : "fenilbutirato de sodio"
    },
    {
      "code" : "294883005",
      "display" : "fenindiona"
    },
    {
      "code" : "293865005",
      "display" : "fenobarbital"
    },
    {
      "code" : "294418003",
      "display" : "fenol"
    },
    {
      "code" : "293607002",
      "display" : "fenoperidina"
    },
    {
      "code" : "293928009",
      "display" : "fenotiazina"
    },
    {
      "code" : "294497009",
      "display" : "fenoximetilpenicilina"
    },
    {
      "code" : "294357007",
      "display" : "fenticonazol"
    },
    {
      "code" : "76361000122104",
      "display" : "fesoterodina"
    },
    {
      "code" : "293737001",
      "display" : "filgrastim"
    },
    {
      "code" : "294011003",
      "display" : "fisostigmina"
    },
    {
      "code" : "24491000122105",
      "display" : "fletán"
    },
    {
      "code" : "294341007",
      "display" : "flucitosina"
    },
    {
      "code" : "294524006",
      "display" : "flucloxacilina+ampicilina"
    },
    {
      "code" : "294791009",
      "display" : "fosfestrol"
    },
    {
      "code" : "294104004",
      "display" : "fracción fosfolipídica"
    },
    {
      "code" : "294467001",
      "display" : "framicetina"
    },
    {
      "code" : "91932007",
      "display" : "fruta"
    },
    {
      "code" : "23861000122103",
      "display" : "fruta de la pasión"
    },
    {
      "code" : "294571000",
      "display" : "ftalilsulfatiazol"
    },
    {
      "code" : "294473000",
      "display" : "fusidato de sodio"
    },
    {
      "code" : "294229002",
      "display" : "galamina"
    },
    {
      "code" : "24341000122109",
      "display" : "gallo"
    },
    {
      "code" : "429819005",
      "display" : "gas medicamentoso"
    },
    {
      "code" : "294847001",
      "display" : "gelatina"
    },
    {
      "code" : "294254002",
      "display" : "gemeprost"
    },
    {
      "code" : "19881000122103",
      "display" : "gemtuzumab"
    },
    {
      "code" : "294765008",
      "display" : "gestrinona"
    },
    {
      "code" : "294731007",
      "display" : "glibenclamida"
    },
    {
      "code" : "294319007",
      "display" : "glicerol/glicol/macrogol"
    },
    {
      "code" : "294080009",
      "display" : "glicopirronio"
    },
    {
      "code" : "294735003",
      "display" : "gliquidona"
    },
    {
      "code" : "21781000122104",
      "display" : "glucosa"
    },
    {
      "code" : "20261000122108",
      "display" : "glucosilceramidasa y derivados"
    },
    {
      "code" : "24671000122107",
      "display" : "gluten"
    },
    {
      "code" : "294820006",
      "display" : "gonadotrofina"
    },
    {
      "code" : "294818008",
      "display" : "goserelina"
    },
    {
      "code" : "23471000122106",
      "display" : "granada"
    },
    {
      "code" : "24501000122104",
      "display" : "grosella"
    },
    {
      "code" : "293643008",
      "display" : "grupos de fármacos que afectan principalmente al aparato digestivo"
    },
    {
      "code" : "24611000122100",
      "display" : "picadura de mosquito Aedes comunis"
    },
    {
      "code" : "293680002",
      "display" : "picosulfato de sodio"
    },
    {
      "code" : "24421000122108",
      "display" : "pimienta blanca"
    },
    {
      "code" : "293926008",
      "display" : "pimozida"
    },
    {
      "code" : "13511000122108",
      "display" : "pińa"
    },
    {
      "code" : "2551000122101",
      "display" : "pipas de girasol"
    },
    {
      "code" : "294525007",
      "display" : "piperacilina y tazobactam"
    },
    {
      "code" : "22911000122103",
      "display" : "piperidina y derivados"
    },
    {
      "code" : "293860000",
      "display" : "piracetam"
    },
    {
      "code" : "16851000122103",
      "display" : "pirazolas y sus derivados"
    },
    {
      "code" : "295003001",
      "display" : "piretanida"
    },
    {
      "code" : "294016008",
      "display" : "piridostigmina"
    },
    {
      "code" : "293622007",
      "display" : "ketorolaco"
    },
    {
      "code" : "21901000122109",
      "display" : "L-iditol deshidrogenasa"
    },
    {
      "code" : "294000006",
      "display" : "lacidipino"
    },
    {
      "code" : "293681003",
      "display" : "lactulosa"
    },
    {
      "code" : "295056004",
      "display" : "lanatósido C"
    },
    {
      "code" : "24761000122109",
      "display" : "lapa"
    },
    {
      "code" : "294539007",
      "display" : "latamoxef"
    },
    {
      "code" : "293684006",
      "display" : "laxante a base de antraquinona"
    },
    {
      "code" : "21181000122100",
      "display" : "leche de oveja"
    },
    {
      "code" : "23141000122108",
      "display" : "lechuga"
    },
    {
      "code" : "293895002",
      "display" : "clobazam"
    },
    {
      "code" : "294836008",
      "display" : "clodronato de sodio"
    },
    {
      "code" : "294798003",
      "display" : "clomifeno"
    },
    {
      "code" : "293871004",
      "display" : "clonazepam"
    },
    {
      "code" : "20031000122109",
      "display" : "cloperastina"
    },
    {
      "code" : "294593005",
      "display" : "cloranfenicol"
    },
    {
      "code" : "293894003",
      "display" : "clordiazepóxido"
    },
    {
      "code" : "870747001",
      "display" : "clorhexidina y/o neomicina"
    },
    {
      "code" : "294021006",
      "display" : "clorhidrato de isoetarina"
    },
    {
      "code" : "294068001",
      "display" : "clorhidrato de piperidolato"
    },
    {
      "code" : "409639003",
      "display" : "clorhidrato de tetraciclina"
    },
    {
      "code" : "441931002",
      "display" : "cloroprocaína"
    },
    {
      "code" : "294993002",
      "display" : "clorotiazida"
    },
    {
      "code" : "294730008",
      "display" : "clorpropamida"
    },
    {
      "code" : "294590008",
      "display" : "clortetraciclina"
    },
    {
      "code" : "76421000122104",
      "display" : "clotiapina"
    },
    {
      "code" : "293916001",
      "display" : "clozapina"
    },
    {
      "code" : "295065006",
      "display" : "co-dergocrina"
    },
    {
      "code" : "35251000122101",
      "display" : "cobre"
    },
    {
      "code" : "76211000122109",
      "display" : "cochinilla"
    },
    {
      "code" : "24541000122102",
      "display" : "col verde"
    },
    {
      "code" : "294961005",
      "display" : "colestipol"
    },
    {
      "code" : "23111000122109",
      "display" : "coliflor"
    },
    {
      "code" : "294529001",
      "display" : "colistina"
    },
    {
      "code" : "294446001",
      "display" : "colorante desinfectante azo trifenilmetano"
    },
    {
      "code" : "294893003",
      "display" : "complejo de hierro polisacárido"
    },
    {
      "code" : "294651001",
      "display" : "componente de vacuna que contiene antígeno de Bordetella pertussis"
    },
    {
      "code" : "294175002",
      "display" : "crema con ditranol"
    },
    {
      "code" : "19531000122102",
      "display" : "cromo"
    },
    {
      "code" : "714205005",
      "display" : "crustáceos"
    },
    {
      "code" : "24951000122105",
      "display" : "cucaracha Periplaneta americana"
    },
    {
      "code" : "24551000122100",
      "display" : "cúrcuma"
    },
    {
      "code" : "17931000122102",
      "display" : "daclatasvir"
    },
    {
      "code" : "294877007",
      "display" : "danaparoide de sodio"
    },
    {
      "code" : "293679000",
      "display" : "dantrón"
    },
    {
      "code" : "713018004",
      "display" : "darunavir"
    },
    {
      "code" : "32471000122101",
      "display" : "dasatinib"
    },
    {
      "code" : "293931005",
      "display" : "decanoato de flufenazina"
    },
    {
      "code" : "294443009",
      "display" : "decualinio"
    },
    {
      "code" : "35201000122100",
      "display" : "delapril"
    },
    {
      "code" : "737493007",
      "display" : "denosumab"
    },
    {
      "code" : "293746007",
      "display" : "derivado de mostaza nitrogenada"
    },
    {
      "code" : "294868000",
      "display" : "derivados del factor de von Willebrand"
    },
    {
      "code" : "723654003",
      "display" : "descongestivo"
    },
    {
      "code" : "294422008",
      "display" : "desinfectante con aldehído"
    },
    {
      "code" : "294414001",
      "display" : "desinfectante fenólico clorado"
    },
    {
      "code" : "294686004",
      "display" : "desoximetasona"
    },
    {
      "code" : "294133003",
      "display" : "difenhidramina"
    },
    {
      "code" : "292312002",
      "display" : "trazodona"
    },
    {
      "code" : "292200003",
      "display" : "treosulfano"
    },
    {
      "code" : "292668001",
      "display" : "tretinoína"
    },
    {
      "code" : "293174009",
      "display" : "triamcinolona"
    },
    {
      "code" : "293469009",
      "display" : "triamtereno"
    },
    {
      "code" : "871775006",
      "display" : "triazeno"
    },
    {
      "code" : "292349008",
      "display" : "triazolam"
    },
    {
      "code" : "292840003",
      "display" : "tribavirina"
    },
    {
      "code" : "292368006",
      "display" : "triclofós sódico"
    },
    {
      "code" : "292174002",
      "display" : "tricloroetileno"
    },
    {
      "code" : "292877006",
      "display" : "triclosán"
    },
    {
      "code" : "292751005",
      "display" : "trientina"
    },
    {
      "code" : "292399007",
      "display" : "trifluoperazina"
    },
    {
      "code" : "292841004",
      "display" : "trifluorotimidina"
    },
    {
      "code" : "292379001",
      "display" : "trifluperidol"
    },
    {
      "code" : "5371000122109",
      "display" : "trifusal"
    },
    {
      "code" : "293431004",
      "display" : "triglicéridos omega 3 de origen marino"
    },
    {
      "code" : "292535000",
      "display" : "trihexifenidilo"
    },
    {
      "code" : "292247007",
      "display" : "trilostano"
    },
    {
      "code" : "292598000",
      "display" : "trimeprazina"
    },
    {
      "code" : "218636009",
      "display" : "trimetadiona"
    },
    {
      "code" : "293511001",
      "display" : "trimetafán"
    },
    {
      "code" : "292939004",
      "display" : "trimetoprima"
    },
    {
      "code" : "292285005",
      "display" : "trimipramina"
    },
    {
      "code" : "293544007",
      "display" : "trinitrato de glicerilo de liberación modificada"
    },
    {
      "code" : "293545008",
      "display" : "trinitrato de glicerilo parenteral"
    },
    {
      "code" : "293543001",
      "display" : "trinitrato de glicerilo por vía oral"
    },
    {
      "code" : "293546009",
      "display" : "trinitrato de glicerilo por vía transdérmica"
    },
    {
      "code" : "293542006",
      "display" : "trinitrato de glicerina"
    },
    {
      "code" : "292300001",
      "display" : "triptófano"
    },
    {
      "code" : "293281005",
      "display" : "triptorelina"
    },
    {
      "code" : "293349003",
      "display" : "tromboplastina"
    },
    {
      "code" : "292531009",
      "display" : "tropicamida"
    },
    {
      "code" : "292690001",
      "display" : "tubocurarina"
    },
    {
      "code" : "292813003",
      "display" : "undecenoatos"
    },
    {
      "code" : "292632006",
      "display" : "ungüento con ditranol"
    },
    {
      "code" : "293127000",
      "display" : "vacuna anti - Haemophilus influenzae tipo B"
    },
    {
      "code" : "219085007",
      "display" : "vacuna antidiftérica"
    },
    {
      "code" : "293108006",
      "display" : "vacuna antidiftérica y antitetánica"
    },
    {
      "code" : "219088009",
      "display" : "vacuna antimeningocócica"
    },
    {
      "code" : "293116002",
      "display" : "vacuna antineumocócica"
    },
    {
      "code" : "293118001",
      "display" : "vacuna antirrábica"
    },
    {
      "code" : "293119009",
      "display" : "vacuna antirrubeólica"
    },
    {
      "code" : "293122006",
      "display" : "vacuna antitifoidea"
    },
    {
      "code" : "293120003",
      "display" : "vacuna antivariólica"
    },
    {
      "code" : "1142182006",
      "display" : "vacuna con antígeno de COVID-19"
    },
    {
      "code" : "1156256003",
      "display" : "vacuna contra COVID-19"
    },
    {
      "code" : "293109003",
      "display" : "vacuna contra la difteria, el tétanos y la tos ferina"
    },
    {
      "code" : "219095000",
      "display" : "vacuna contra la fiebre amarilla"
    },
    {
      "code" : "293126009",
      "display" : "vacuna contra la hepatitis A"
    },
    {
      "code" : "293110008",
      "display" : "vacuna contra la hepatitis B"
    },
    {
      "code" : "219083000",
      "display" : "vacuna contra la peste"
    },
    {
      "code" : "293115003",
      "display" : "vacuna contra tos ferina"
    },
    {
      "code" : "1193581003",
      "display" : "vacuna de plásmido de ADN de COVID-19 que codifica proteína de espiga"
    },
    {
      "code" : "219082005",
      "display" : "vacuna frente al cólera"
    },
    {
      "code" : "219096004",
      "display" : "vacuna frente al sarampión"
    },
    {
      "code" : "1162644007",
      "display" : "vacuna proteína de espiga recombinante contra COVID-19"
    },
    {
      "code" : "293125008",
      "display" : "vacuna vacuna triple vírica (sarampión, parotiditis, rubéola)"
    },
    {
      "code" : "1157106007",
      "display" : "vacuna vector viral no replicante contra COVID-19"
    },
    {
      "code" : "1157195001",
      "display" : "vacuna virus entero inactivado contra COVID-19"
    },
    {
      "code" : "292834005",
      "display" : "valaciclovir"
    },
    {
      "code" : "720673003",
      "display" : "valsartán"
    },
    {
      "code" : "292937002",
      "display" : "vancomicina"
    },
    {
      "code" : "698707001",
      "display" : "vasodilatador coronario"
    },
    {
      "code" : "293540003",
      "display" : "vasodilatador de nitrato"
    },
    {
      "code" : "292301002",
      "display" : "venlafaxina"
    },
    {
      "code" : "292908001",
      "display" : "verde brillante"
    },
    {
      "code" : "292843001",
      "display" : "vidarabina"
    },
    {
      "code" : "292313007",
      "display" : "viloxazina"
    },
    {
      "code" : "292252002",
      "display" : "vincristina"
    },
    {
      "code" : "292253007",
      "display" : "vindesina"
    },
    {
      "code" : "6891000122109",
      "display" : "vismodegib"
    },
    {
      "code" : "870414009",
      "display" : "vitamina B y/o derivado de vitamina B"
    },
    {
      "code" : "870412008",
      "display" : "vitamina D y/o derivado de vitamina D"
    },
    {
      "code" : "870413003",
      "display" : "vitamina K y/o derivado de vitamina K"
    },
    {
      "code" : "293385003",
      "display" : "vitamina liposoluble"
    },
    {
      "code" : "292521002",
      "display" : "xamoterol"
    },
    {
      "code" : "1163010008",
      "display" : "xantina y/o derivado de xantina"
    },
    {
      "code" : "292490005",
      "display" : "xilometazolina"
    },
    {
      "code" : "293378002",
      "display" : "yodóforo"
    },
    {
      "code" : "292833004",
      "display" : "zalcitabina"
    },
    {
      "code" : "292828003",
      "display" : "zidovudina"
    },
    {
      "code" : "292333006",
      "display" : "zolpidem"
    },
    {
      "code" : "292404009",
      "display" : "zuclopentixol"
    },
    {
      "code" : "295100001",
      "display" : "alcohol nicotinílico"
    },
    {
      "code" : "767099007",
      "display" : "aldehído"
    },
    {
      "code" : "294926004",
      "display" : "alfa-tocoferol"
    },
    {
      "code" : "24001000122105",
      "display" : "alforfón"
    },
    {
      "code" : "294746000",
      "display" : "alilestrenol"
    },
    {
      "code" : "294908002",
      "display" : "alimentación por vía intravenosa (aminoácidos)"
    },
    {
      "code" : "294907007",
      "display" : "alimentación por vía intravenosa (vitaminas)"
    },
    {
      "code" : "76231000122100",
      "display" : "alimento en base a leche de mamífero"
    },
    {
      "code" : "18251000122103",
      "display" : "almotriptán"
    },
    {
      "code" : "293892004",
      "display" : "alprazolam"
    },
    {
      "code" : "295110005",
      "display" : "alteplasa"
    },
    {
      "code" : "402306009",
      "display" : "aluminio"
    },
    {
      "code" : "293811005",
      "display" : "amantadina"
    },
    {
      "code" : "294349009",
      "display" : "amfotericina"
    },
    {
      "code" : "294463002",
      "display" : "amikacina"
    },
    {
      "code" : "293880004",
      "display" : "amilobarbital"
    },
    {
      "code" : "295012004",
      "display" : "amilorida y a diurético de asa"
    },
    {
      "code" : "293787008",
      "display" : "aminoglutetimida"
    },
    {
      "code" : "36931000122109",
      "display" : "aminotioles"
    },
    {
      "code" : "294002003",
      "display" : "amlodipino"
    },
    {
      "code" : "294346002",
      "display" : "amorolfina"
    },
    {
      "code" : "871508005",
      "display" : "amoxicilina y/o ácido clavulánico"
    },
    {
      "code" : "871505008",
      "display" : "ampicilina y/o flucloxacilina"
    },
    {
      "code" : "18371000122104",
      "display" : "anagrelida"
    },
    {
      "code" : "293587005",
      "display" : "analgésicos opiáceos"
    },
    {
      "code" : "294078003",
      "display" : "benzatropina"
    },
    {
      "code" : "294620008",
      "display" : "benzoato de bencilo"
    },
    {
      "code" : "22991000122106",
      "display" : "berberechos"
    },
    {
      "code" : "23761000122106",
      "display" : "besugo"
    },
    {
      "code" : "24011000122108",
      "display" : "betalactámicos"
    },
    {
      "code" : "295033008",
      "display" : "betanidina"
    },
    {
      "code" : "294769002",
      "display" : "bicalutamida"
    },
    {
      "code" : "294069009",
      "display" : "biperideno"
    },
    {
      "code" : "293761008",
      "display" : "bleomicina"
    },
    {
      "code" : "21151000122106",
      "display" : "bogavante"
    },
    {
      "code" : "23661000122104",
      "display" : "boquerón"
    },
    {
      "code" : "76431000122101",
      "display" : "bosentán"
    },
    {
      "code" : "18121000122102",
      "display" : "brezo"
    },
    {
      "code" : "293893009",
      "display" : "bromazepam"
    },
    {
      "code" : "830081005",
      "display" : "bromhexina"
    },
    {
      "code" : "293815001",
      "display" : "bromocriptina"
    },
    {
      "code" : "294070005",
      "display" : "bromuro de emepronio"
    },
    {
      "code" : "294172004",
      "display" : "bufexamaco"
    },
    {
      "code" : "293596005",
      "display" : "buprenorfina"
    },
    {
      "code" : "293911006",
      "display" : "buspirona"
    },
    {
      "code" : "293919008",
      "display" : "butirofenona"
    },
    {
      "code" : "23671000122109",
      "display" : "caballa"
    },
    {
      "code" : "23701000122105",
      "display" : "cacao"
    },
    {
      "code" : "23461000122101",
      "display" : "café"
    },
    {
      "code" : "23401000122102",
      "display" : "calabaza"
    },
    {
      "code" : "294178000",
      "display" : "calcipotriol"
    },
    {
      "code" : "294841000",
      "display" : "calcitonina porcina"
    },
    {
      "code" : "24291000122106",
      "display" : "cangrejo de mar"
    },
    {
      "code" : "295008005",
      "display" : "canrenoato de potasio"
    },
    {
      "code" : "294609008",
      "display" : "capreomicina"
    },
    {
      "code" : "24901000122106",
      "display" : "caracol"
    },
    {
      "code" : "703932008",
      "display" : "carne de pollo"
    },
    {
      "code" : "418815008",
      "display" : "carne roja"
    },
    {
      "code" : "293976005",
      "display" : "carteolol"
    },
    {
      "code" : "5611000122107",
      "display" : "caseína"
    },
    {
      "code" : "419063004",
      "display" : "caspa de caballo"
    },
    {
      "code" : "232346004",
      "display" : "caspa de gato"
    },
    {
      "code" : "712838009",
      "display" : "castańa de cajú"
    },
    {
      "code" : "712841000",
      "display" : "cebada"
    },
    {
      "code" : "294541008",
      "display" : "cefaclor"
    },
    {
      "code" : "294535001",
      "display" : "cefalexina"
    },
    {
      "code" : "294544000",
      "display" : "cefalosporina de tercera generación"
    },
    {
      "code" : "294543006",
      "display" : "cefamandol"
    },
    {
      "code" : "13641000122108",
      "display" : "cefatrizina"
    },
    {
      "code" : "294548002",
      "display" : "cefixima"
    },
    {
      "code" : "19521000122100",
      "display" : "cefotiam"
    },
    {
      "code" : "294550005",
      "display" : "cefpodoxima"
    },
    {
      "code" : "294546003",
      "display" : "ceftazidima"
    },
    {
      "code" : "294547007",
      "display" : "ceftizoxima"
    },
    {
      "code" : "293968008",
      "display" : "celiprolol"
    },
    {
      "code" : "6591000122106",
      "display" : "cereal"
    },
    {
      "code" : "32461000122106",
      "display" : "ceritinib"
    },
    {
      "code" : "294441006",
      "display" : "cetilpiridinio"
    },
    {
      "code" : "294437007",
      "display" : "cetrimida"
    },
    {
      "code" : "35291000122105",
      "display" : "champińón"
    },
    {
      "code" : "23441000122100",
      "display" : "chirivía"
    },
    {
      "code" : "294934005",
      "display" : "cianocobalamina"
    },
    {
      "code" : "20321000122109",
      "display" : "cicletanina"
    },
    {
      "code" : "294763001",
      "display" : "ciclofenilo"
    },
    {
      "code" : "294994008",
      "display" : "ciclopentiazida"
    },
    {
      "code" : "293798009",
      "display" : "ciclosporina"
    },
    {
      "code" : "293650007",
      "display" : "cimetidina"
    },
    {
      "code" : "294869008",
      "display" : "anticoagulante"
    },
    {
      "code" : "294878002",
      "display" : "anticoagulante de acción indirecta"
    },
    {
      "code" : "22241000122108",
      "display" : "anticuerpo monoclonal humano HA - 1A"
    },
    {
      "code" : "294263000",
      "display" : "antídoto"
    },
    {
      "code" : "294262005",
      "display" : "antídotos y agentes quelantes"
    },
    {
      "code" : "293769005",
      "display" : "antimetabolito"
    },
    {
      "code" : "294364009",
      "display" : "antimicótico del grupo triazol"
    },
    {
      "code" : "294601006",
      "display" : "antiprotozoario de dicloroacetamida"
    },
    {
      "code" : "22491000122102",
      "display" : "antitoxina de la gangrena gaseosa"
    },
    {
      "code" : "294855008",
      "display" : "antitrombina III"
    },
    {
      "code" : "17691000122105",
      "display" : "antraciclina"
    },
    {
      "code" : "293812003",
      "display" : "apomorfina"
    },
    {
      "code" : "294889009",
      "display" : "aprotinina"
    },
    {
      "code" : "294280001",
      "display" : "arcilla de batán"
    },
    {
      "code" : "767468001",
      "display" : "arvejas"
    },
    {
      "code" : "17961000122109",
      "display" : "atazanavir"
    },
    {
      "code" : "294596002",
      "display" : "atovacuona"
    },
    {
      "code" : "23641000122103",
      "display" : "atún"
    },
    {
      "code" : "294239008",
      "display" : "aurotiomalato de sodio"
    },
    {
      "code" : "23731000122104",
      "display" : "azafrán"
    },
    {
      "code" : "293799001",
      "display" : "azatioprina"
    },
    {
      "code" : "294472005",
      "display" : "azitromicina"
    },
    {
      "code" : "860904006",
      "display" : "azol"
    },
    {
      "code" : "294565006",
      "display" : "aztreonam"
    },
    {
      "code" : "294384008",
      "display" : "aciclovir"
    },
    {
      "code" : "20341000122104",
      "display" : "ácido alendrónico"
    },
    {
      "code" : "35311000122109",
      "display" : "ácido arilpropiónico"
    },
    {
      "code" : "720691008",
      "display" : "ácido biliar"
    },
    {
      "code" : "871511006",
      "display" : "ácido clavulánico y/o ticarcilina"
    },
    {
      "code" : "295002006",
      "display" : "ácido etacrínico"
    },
    {
      "code" : "61331000122106",
      "display" : "azúcar invertido"
    },
    {
      "code" : "57771000122109",
      "display" : "bacampicilina"
    },
    {
      "code" : "49601000122104",
      "display" : "bambuterol"
    },
    {
      "code" : "56831000122102",
      "display" : "base química"
    },
    {
      "code" : "57431000122102",
      "display" : "beclamida"
    },
    {
      "code" : "60731000122104",
      "display" : "befunolol"
    },
    {
      "code" : "40901000122104",
      "display" : "bencilpenicilina"
    },
    {
      "code" : "44531000122107",
      "display" : "benperidol"
    },
    {
      "code" : "58591000122100",
      "display" : "benzocaína"
    },
    {
      "code" : "41051000122109",
      "display" : "beractant"
    },
    {
      "code" : "49971000122103",
      "display" : "besugo"
    },
    {
      "code" : "55161000122105",
      "display" : "betalactámicos"
    },
    {
      "code" : "46241000122109",
      "display" : "betanidina"
    },
    {
      "code" : "52151000122103",
      "display" : "bicalutamida"
    },
    {
      "code" : "44301000122109",
      "display" : "biperideno"
    },
    {
      "code" : "57691000122100",
      "display" : "bleomicina"
    },
    {
      "code" : "61731000122105",
      "display" : "boniato"
    },
    {
      "code" : "47791000122108",
      "display" : "borato"
    },
    {
      "code" : "60651000122101",
      "display" : "brezo"
    },
    {
      "code" : "59401000122103",
      "display" : "bromelinas"
    },
    {
      "code" : "43751000122106",
      "display" : "bromhidrato de hioscina"
    },
    {
      "code" : "50761000122103",
      "display" : "fármaco antiulceroso"
    },
    {
      "code" : "52851000122108",
      "display" : "fármaco betabloqueante no cardioselectivo"
    },
    {
      "code" : "40641000122109",
      "display" : "fármaco contra la lepra"
    },
    {
      "code" : "48961000122100",
      "display" : "fármaco diurético tiazídico"
    },
    {
      "code" : "43631000122108",
      "display" : "fármaco estimulante de la motilidad"
    },
    {
      "code" : "44521000122109",
      "display" : "fármaco expectorante"
    },
    {
      "code" : "49851000122104",
      "display" : "fármaco hipolipemiante"
    },
    {
      "code" : "51211000122100",
      "display" : "fármaco inmunosupresor"
    },
    {
      "code" : "54751000122106",
      "display" : "fármaco neuroléptico"
    },
    {
      "code" : "44391000122104",
      "display" : "fármaco que actúa sobre la transmisión neuromuscular"
    },
    {
      "code" : "51241000122101",
      "display" : "fármaco vasoconstrictor"
    },
    {
      "code" : "55801000122102",
      "display" : "fármacos mucolíticos"
    },
    {
      "code" : "58181000122107",
      "display" : "fenazocina"
    },
    {
      "code" : "55101000122109",
      "display" : "feneticilina"
    },
    {
      "code" : "57681000122103",
      "display" : "gonadorelina"
    },
    {
      "code" : "62091000122103",
      "display" : "gorgojo de las lentejas"
    },
    {
      "code" : "60441000122100",
      "display" : "grindelia"
    },
    {
      "code" : "45191000122102",
      "display" : "grupo de fármacos que afectan principalmente al sistema nervioso central"
    },
    {
      "code" : "47091000122106",
      "display" : "grupos de fármacos que afectan principalmente al sistema nervioso autónomo"
    },
    {
      "code" : "40081000122107",
      "display" : "halcinonida"
    },
    {
      "code" : "40441000122107",
      "display" : "halotano"
    },
    {
      "code" : "49271000122106",
      "display" : "harina de centeno"
    },
    {
      "code" : "40511000122109",
      "display" : "hemoderivado"
    },
    {
      "code" : "60911000122106",
      "display" : "heptaminol y sus derivados"
    },
    {
      "code" : "41421000122108",
      "display" : "hexaclorofano"
    },
    {
      "code" : "41451000122101",
      "display" : "hialuronidasa"
    },
    {
      "code" : "46291000122102",
      "display" : "hidralazina"
    },
    {
      "code" : "55781000122101",
      "display" : "hidrocortisona"
    },
    {
      "code" : "56281000122102",
      "display" : "hidromorfona"
    },
    {
      "code" : "51551000122102",
      "display" : "hidroxietilalmidón"
    },
    {
      "code" : "57451000122107",
      "display" : "hidroxiurea"
    },
    {
      "code" : "46561000122105",
      "display" : "hierbas medicinales"
    },
    {
      "code" : "50271000122102",
      "display" : "hierro y a ácido fólico"
    },
    {
      "code" : "48331000122106",
      "display" : "hipromelosa"
    },
    {
      "code" : "42481000122102",
      "display" : "implante de testosterona"
    },
    {
      "code" : "59851000122101",
      "display" : "infusión multielectrolítica"
    },
    {
      "code" : "50941000122104",
      "display" : "inhibidor de fosfodiesterasa 5"
    },
    {
      "code" : "44901000122108",
      "display" : "inhibidor de la descarboxilasa"
    },
    {
      "code" : "60071000122103",
      "display" : "inhibidor de proteasa retroviral"
    },
    {
      "code" : "41981000122104",
      "display" : "inmunoestimulante"
    },
    {
      "code" : "52041000122104",
      "display" : "inmunoglobulina antilinfocítica"
    },
    {
      "code" : "61411000122105",
      "display" : "inmunoglobulina frente a la hepatitis A"
    },
    {
      "code" : "52881000122102",
      "display" : "inmunoglobulina frente a virus respiratorio sincitial"
    },
    {
      "code" : "61461000122108",
      "display" : "inmunoglobulina humana frente a la rabia"
    },
    {
      "code" : "53371000122104",
      "display" : "inosina pranobex"
    },
    {
      "code" : "45051000122107",
      "display" : "insulina bifásica"
    },
    {
      "code" : "49551000122101",
      "display" : "insulina isófana"
    },
    {
      "code" : "41651000122104",
      "display" : "interferón -A-2a"
    },
    {
      "code" : "51081000122100",
      "display" : "interferón-A-N1"
    },
    {
      "code" : "43431000122105",
      "display" : "ipecacuana"
    },
    {
      "code" : "45591000122107",
      "display" : "flavoxato"
    },
    {
      "code" : "57111000122101",
      "display" : "flosequinán"
    },
    {
      "code" : "50251000122105",
      "display" : "flucloxacilina"
    },
    {
      "code" : "51441000122100",
      "display" : "fludarabina"
    },
    {
      "code" : "46311000122103",
      "display" : "flumazenil"
    },
    {
      "code" : "47961000122104",
      "display" : "fluocinolona"
    },
    {
      "code" : "53491000122106",
      "display" : "fluorometolona"
    },
    {
      "code" : "47221000122102",
      "display" : "fluoxetina"
    },
    {
      "code" : "58411000122107",
      "display" : "flurazepam"
    },
    {
      "code" : "51531000122107",
      "display" : "flutamida"
    },
    {
      "code" : "57561000122105",
      "display" : "fluvoxamina"
    },
    {
      "code" : "48201000122106",
      "display" : "formoterol"
    },
    {
      "code" : "56821000122100",
      "display" : "fosfato de celulosa sódica"
    },
    {
      "code" : "49731000122103",
      "display" : "fosfomicina"
    },
    {
      "code" : "59481000122105",
      "display" : "framicetina"
    },
    {
      "code" : "60741000122107",
      "display" : "frovatriptán"
    },
    {
      "code" : "40051000122101",
      "display" : "frutas"
    },
    {
      "code" : "52101000122102",
      "display" : "frutos secos"
    },
    {
      "code" : "51151000122105",
      "display" : "furosemida"
    },
    {
      "code" : "53001000122106",
      "display" : "gadolinio y sus derivados"
    },
    {
      "code" : "58841000122109",
      "display" : "gallo"
    },
    {
      "code" : "54991000122100",
      "display" : "garbanzo"
    },
    {
      "code" : "57741000122103",
      "display" : "gases de uso médico y anestésicos"
    },
    {
      "code" : "47541000122109",
      "display" : "comino"
    },
    {
      "code" : "51611000122102",
      "display" : "complejos con bromo"
    },
    {
      "code" : "41011000122108",
      "display" : "concentrados de factor V"
    },
    {
      "code" : "5388008",
      "display" : "congénita a la lactosa"
    },
    {
      "code" : "51451000122103",
      "display" : "corticosteroides"
    },
    {
      "code" : "50241000122108",
      "display" : "cortisona"
    },
    {
      "code" : "50851000122109",
      "display" : "crisantaspasa"
    },
    {
      "code" : "48931000122107",
      "display" : "crotamitón"
    },
    {
      "code" : "62001000122108",
      "display" : "cucaracha Blatella orientalis"
    },
    {
      "code" : "45071000122104",
      "display" : "curry"
    },
    {
      "code" : "57261000122108",
      "display" : "dacarbazina"
    },
    {
      "code" : "46791000122105",
      "display" : "dalteparina"
    },
    {
      "code" : "43051000122108",
      "display" : "dantroleno"
    },
    {
      "code" : "293629003",
      "display" : "piroxicam"
    },
    {
      "code" : "294509002",
      "display" : "pivampicilina"
    },
    {
      "code" : "294520002",
      "display" : "pivmecilinam"
    },
    {
      "code" : "294622000",
      "display" : "plaguicida a base de carbamato"
    },
    {
      "code" : "294628001",
      "display" : "plaguicida piretroide"
    },
    {
      "code" : "714332003",
      "display" : "plátano"
    },
    {
      "code" : "293763006",
      "display" : "plicamicina"
    },
    {
      "code" : "294183008",
      "display" : "podofilotoxina"
    },
    {
      "code" : "11561000122105",
      "display" : "polen de abedul"
    },
    {
      "code" : "32261000122105",
      "display" : "polen de ajenjo"
    },
    {
      "code" : "31711000122107",
      "display" : "polen de aliso"
    },
    {
      "code" : "418561004",
      "display" : "polen de ambrosía"
    },
    {
      "code" : "22481000122100",
      "display" : "polen de Artemisa vulgaris"
    },
    {
      "code" : "32161000122100",
      "display" : "polen de barrilla"
    },
    {
      "code" : "31831000122109",
      "display" : "polen de cedro"
    },
    {
      "code" : "716187007",
      "display" : "proteína de insecto"
    },
    {
      "code" : "35351000122105",
      "display" : "proteína de transferencia de lípidos"
    },
    {
      "code" : "33471000122109",
      "display" : "proteínas de leche de vaca [APLV] no mediada por IgE"
    },
    {
      "code" : "609534005",
      "display" : "pseudoalergia a losartán"
    },
    {
      "code" : "23951000122107",
      "display" : "pulpo"
    },
    {
      "code" : "300914000",
      "display" : "queso"
    },
    {
      "code" : "294400001",
      "display" : "quinacrina"
    },
    {
      "code" : "17661000122104",
      "display" : "quinazolina"
    },
    {
      "code" : "294788009",
      "display" : "quinestrol"
    },
    {
      "code" : "294398000",
      "display" : "quinina"
    },
    {
      "code" : "293636002",
      "display" : "radiofármaco"
    },
    {
      "code" : "17921000122100",
      "display" : "raltegravir"
    },
    {
      "code" : "293653009",
      "display" : "ranitidina"
    },
    {
      "code" : "20311000122103",
      "display" : "rasagilina"
    },
    {
      "code" : "294272008",
      "display" : "reactivador de colinesterasa"
    },
    {
      "code" : "441992007",
      "display" : "remifentanilo"
    },
    {
      "code" : "23041000122109",
      "display" : "repollo"
    },
    {
      "code" : "402597007",
      "display" : "resina de árbol"
    },
    {
      "code" : "294941004",
      "display" : "resina de intercambio iónico"
    },
    {
      "code" : "20511000122107",
      "display" : "riboflavina"
    },
    {
      "code" : "76411000122105",
      "display" : "rifaximina"
    },
    {
      "code" : "20331000122107",
      "display" : "risedronato"
    },
    {
      "code" : "76121000122106",
      "display" : "rituximab"
    },
    {
      "code" : "18241000122100",
      "display" : "rizatriptán"
    },
    {
      "code" : "37531000122102",
      "display" : "rolapitant"
    },
    {
      "code" : "37541000122105",
      "display" : "ropinirol"
    },
    {
      "code" : "294484007",
      "display" : "rosoxacino"
    },
    {
      "code" : "782575000",
      "display" : "semilla de altramuz"
    },
    {
      "code" : "2561000122104",
      "display" : "semillas de sésamo"
    },
    {
      "code" : "293845003",
      "display" : "sertralina"
    },
    {
      "code" : "441954006",
      "display" : "sevoflurano"
    },
    {
      "code" : "24701000122108",
      "display" : "siluro"
    },
    {
      "code" : "160244002",
      "display" : "sin alergias conocidas"
    },
    {
      "code" : "13611000122109",
      "display" : "sirolimus y sus derivados"
    },
    {
      "code" : "714035009",
      "display" : "soja"
    },
    {
      "code" : "294854007",
      "display" : "solución de albúmina"
    },
    {
      "code" : "294852006",
      "display" : "solución de proteína plasmática"
    },
    {
      "code" : "294825001",
      "display" : "somatotrofina"
    },
    {
      "code" : "865878007",
      "display" : "subnitrato de bismuto y/o yodoformo"
    },
    {
      "code" : "22471000122103",
      "display" : "suero antiofídico"
    },
    {
      "code" : "294361001",
      "display" : "sulconazol"
    },
    {
      "code" : "294573002",
      "display" : "sulfadiazina"
    },
    {
      "code" : "294575009",
      "display" : "sulfadimidina"
    },
    {
      "code" : "294572007",
      "display" : "sulfaleno"
    },
    {
      "code" : "12831000122107",
      "display" : "sulfametoxazol"
    },
    {
      "code" : "293663001",
      "display" : "sulfasalazina"
    },
    {
      "code" : "294786008",
      "display" : "sulfato de estrona piperacina"
    },
    {
      "code" : "830177007",
      "display" : "sulfato de sodio"
    },
    {
      "code" : "91939003",
      "display" : "sulfonamida"
    },
    {
      "code" : "830165002",
      "display" : "sulfonato de polistireno"
    },
    {
      "code" : "18231000122108",
      "display" : "sumatriptán"
    },
    {
      "code" : "294435004",
      "display" : "surfactante catiónico"
    },
    {
      "code" : "294442004",
      "display" : "surfactante de quinolinio cuaternario"
    },
    {
      "code" : "13131000122106",
      "display" : "polen de trigo"
    },
    {
      "code" : "294528009",
      "display" : "polimixina"
    },
    {
      "code" : "294406007",
      "display" : "polinoxilina"
    },
    {
      "code" : "294998006",
      "display" : "politiazida"
    },
    {
      "code" : "294167008",
      "display" : "polvos"
    },
    {
      "code" : "18091000122101",
      "display" : "ponatinib"
    },
    {
      "code" : "294948005",
      "display" : "potasio administrado por vía parenteral"
    },
    {
      "code" : "294273003",
      "display" : "pralidoxima"
    },
    {
      "code" : "293900003",
      "display" : "prazepam"
    },
    {
      "code" : "721134005",
      "display" : "prednisolona para uso oftálmico"
    },
    {
      "code" : "76141000122101",
      "display" : "pregabalina"
    },
    {
      "code" : "294704009",
      "display" : "preparación tópica con dexametasona"
    },
    {
      "code" : "294589004",
      "display" : "preparaciones con compuestos de tetraciclina"
    },
    {
      "code" : "294308009",
      "display" : "preparado antihemorroidal"
    },
    {
      "code" : "294939000",
      "display" : "preparado de tiamina"
    },
    {
      "code" : "294184002",
      "display" : "preparado para protección solar"
    },
    {
      "code" : "294936007",
      "display" : "preparados del complejo vitamínico B"
    },
    {
      "code" : "293721007",
      "display" : "prilocaína"
    },
    {
      "code" : "294217006",
      "display" : "probenecid"
    },
    {
      "code" : "294982004",
      "display" : "procainamida"
    },
    {
      "code" : "294089005",
      "display" : "prociclidina"
    },
    {
      "code" : "417982003",
      "display" : "producto cosmético"
    },
    {
      "code" : "294420000",
      "display" : "productos alcohólicos"
    },
    {
      "code" : "294632007",
      "display" : "productos de inmunoglobulina"
    },
    {
      "code" : "294808003",
      "display" : "lipresina"
    },
    {
      "code" : "294299005",
      "display" : "líquido de diálisis"
    },
    {
      "code" : "35111000122106",
      "display" : "lisinopril"
    },
    {
      "code" : "293817009",
      "display" : "litio"
    },
    {
      "code" : "294059003",
      "display" : "lofexidina"
    },
    {
      "code" : "293668005",
      "display" : "loperamida"
    },
    {
      "code" : "294114008",
      "display" : "loratadina"
    },
    {
      "code" : "35031000122103",
      "display" : "losartán"
    },
    {
      "code" : "24581000122106",
      "display" : "lubina"
    },
    {
      "code" : "860907004",
      "display" : "macrólido"
    },
    {
      "code" : "419573007",
      "display" : "maíz"
    },
    {
      "code" : "24371000122103",
      "display" : "malta"
    },
    {
      "code" : "23181000122104",
      "display" : "mango"
    },
    {
      "code" : "295019008",
      "display" : "manitol"
    },
    {
      "code" : "293853006",
      "display" : "maprotilina"
    },
    {
      "code" : "24591000122109",
      "display" : "maxatasa"
    },
    {
      "code" : "293692002",
      "display" : "mebeverina"
    },
    {
      "code" : "294519008",
      "display" : "mecilinam"
    },
    {
      "code" : "416098002",
      "display" : "medicamentosa"
    },
    {
      "code" : "293638001",
      "display" : "medio de contraste radiográfico"
    },
    {
      "code" : "294392004",
      "display" : "mefloquina"
    },
    {
      "code" : "439406006",
      "display" : "meglitinida"
    },
    {
      "code" : "1131000122107",
      "display" : "melocotón"
    },
    {
      "code" : "293694001",
      "display" : "mepenzolato"
    },
    {
      "code" : "293608007",
      "display" : "meptazinol"
    },
    {
      "code" : "32691000122102",
      "display" : "merbromina"
    },
    {
      "code" : "18281000122109",
      "display" : "mercurio y derivados"
    },
    {
      "code" : "293660003",
      "display" : "mesalazina"
    },
    {
      "code" : "294269001",
      "display" : "mesna"
    },
    {
      "code" : "294009007",
      "display" : "metacolina"
    },
    {
      "code" : "294567003",
      "display" : "metronidazol"
    },
    {
      "code" : "293854000",
      "display" : "mianserina"
    },
    {
      "code" : "293901004",
      "display" : "midazolam"
    },
    {
      "code" : "24031000122104",
      "display" : "mijo"
    },
    {
      "code" : "294587002",
      "display" : "minociclina"
    },
    {
      "code" : "294223001",
      "display" : "miorrelajante no despolarizante"
    },
    {
      "code" : "20061000122102",
      "display" : "mirtecaína"
    },
    {
      "code" : "293762001",
      "display" : "mitomicina"
    },
    {
      "code" : "294226009",
      "display" : "mivacurio"
    },
    {
      "code" : "294331009",
      "display" : "modificador de la viscosidad"
    },
    {
      "code" : "35211000122102",
      "display" : "moexipril"
    },
    {
      "code" : "76311000122102",
      "display" : "molsidomina"
    },
    {
      "code" : "294564005",
      "display" : "monobactam"
    },
    {
      "code" : "294621007",
      "display" : "monosulfiram"
    },
    {
      "code" : "294981006",
      "display" : "moracizina"
    },
    {
      "code" : "25011000122109",
      "display" : "mosca doméstica"
    },
    {
      "code" : "294480003",
      "display" : "mupirocina"
    },
    {
      "code" : "293673004",
      "display" : "nabilona"
    },
    {
      "code" : "293972007",
      "display" : "nadolol"
    },
    {
      "code" : "294028000",
      "display" : "nafazolina"
    },
    {
      "code" : "293600000",
      "display" : "nalbufina"
    },
    {
      "code" : "294276006",
      "display" : "naltrexona"
    },
    {
      "code" : "23271000122107",
      "display" : "naranja"
    },
    {
      "code" : "294350009",
      "display" : "natamicina"
    },
    {
      "code" : "294142005",
      "display" : "nedocromilo"
    },
    {
      "code" : "294468006",
      "display" : "neomicina"
    },
    {
      "code" : "713725004",
      "display" : "nevirapina"
    },
    {
      "code" : "294004002",
      "display" : "nicardipino"
    },
    {
      "code" : "295076005",
      "display" : "nicorandil"
    },
    {
      "code" : "293996002",
      "display" : "nifedipino"
    },
    {
      "code" : "294001005",
      "display" : "nimodipino"
    },
    {
      "code" : "294248003",
      "display" : "octoxinol"
    },
    {
      "code" : "1025061000122100",
      "display" : "olanzapina"
    },
    {
      "code" : "293662006",
      "display" : "olsalazina"
    },
    {
      "code" : "293595009",
      "display" : "opioide morfinano"
    },
    {
      "code" : "24631000122109",
      "display" : "oreja de mar"
    },
    {
      "code" : "294238000",
      "display" : "oro"
    },
    {
      "code" : "419967000",
      "display" : "ostra"
    },
    {
      "code" : "24771000122104",
      "display" : "ovomucoide"
    },
    {
      "code" : "294121008",
      "display" : "oxatomida"
    },
    {
      "code" : "293726002",
      "display" : "oxibuprocaína"
    },
    {
      "code" : "19491000122102",
      "display" : "oxiconazol"
    },
    {
      "code" : "293627001",
      "display" : "oxifenbutazona"
    },
    {
      "code" : "294760003",
      "display" : "oximetolona"
    },
    {
      "code" : "294588007",
      "display" : "oxitetraciclina"
    },
    {
      "code" : "294087007",
      "display" : "oxitropio"
    },
    {
      "code" : "293979003",
      "display" : "oxprenolol"
    },
    {
      "code" : "22111000122100",
      "display" : "palivizumab"
    },
    {
      "code" : "294230007",
      "display" : "pancuronio"
    },
    {
      "code" : "12861000122100",
      "display" : "papaína"
    },
    {
      "code" : "16801000122102",
      "display" : "parabenos"
    },
    {
      "code" : "294324005",
      "display" : "parafina"
    },
    {
      "code" : "294326007",
      "display" : "parafina blanda blanca"
    },
    {
      "code" : "293878005",
      "display" : "paraldehído"
    },
    {
      "code" : "20101000122104",
      "display" : "pargeverina"
    },
    {
      "code" : "294176001",
      "display" : "pasta con ditranol"
    },
    {
      "code" : "300911008",
      "display" : "pelo de animal"
    },
    {
      "code" : "19691000122104",
      "display" : "pemetrexed"
    },
    {
      "code" : "294291008",
      "display" : "penicilamina"
    },
    {
      "code" : "294495001",
      "display" : "penicilina benzatínica"
    },
    {
      "code" : "55991000122101",
      "display" : "cangrejo de río"
    },
    {
      "code" : "49491000122106",
      "display" : "caolín"
    },
    {
      "code" : "61971000122105",
      "display" : "caracol"
    },
    {
      "code" : "56131000122107",
      "display" : "carbacol"
    },
    {
      "code" : "50351000122101",
      "display" : "carbarilo"
    },
    {
      "code" : "40151000122102",
      "display" : "carbenoxolona"
    },
    {
      "code" : "55671000122107",
      "display" : "carbón activado"
    },
    {
      "code" : "40261000122105",
      "display" : "carboprost"
    },
    {
      "code" : "51401000122102",
      "display" : "carfecilina"
    },
    {
      "code" : "41951000122105",
      "display" : "carmustina"
    },
    {
      "code" : "50061000122101",
      "display" : "carne de caballo"
    },
    {
      "code" : "53821000122106",
      "display" : "carne de cordero"
    },
    {
      "code" : "47231000122104",
      "display" : "carne de ternera"
    },
    {
      "code" : "55931000122100",
      "display" : "carteolol"
    },
    {
      "code" : "55621000122106",
      "display" : "caseína"
    },
    {
      "code" : "44691000122105",
      "display" : "caspa de caballo"
    },
    {
      "code" : "49741000122106",
      "display" : "caspa de perro"
    },
    {
      "code" : "59931000122103",
      "display" : "caucho"
    },
    {
      "code" : "48941000122104",
      "display" : "cebolla"
    },
    {
      "code" : "45111000122105",
      "display" : "cefalexina"
    },
    {
      "code" : "51521000122109",
      "display" : "cefalosporinas"
    },
    {
      "code" : "56661000122108",
      "display" : "cefalotina"
    },
    {
      "code" : "54091000122104",
      "display" : "cefatrizina"
    },
    {
      "code" : "55201000122101",
      "display" : "cefixima"
    },
    {
      "code" : "56801000122108",
      "display" : "ciclandelato"
    },
    {
      "code" : "46951000122103",
      "display" : "ciclobarbital"
    },
    {
      "code" : "48611000122107",
      "display" : "ciclopentiazida"
    },
    {
      "code" : "56781000122109",
      "display" : "cilantro"
    },
    {
      "code" : "48221000122103",
      "display" : "cinc"
    },
    {
      "code" : "53861000122102",
      "display" : "cinoxacino"
    },
    {
      "code" : "55381000122100",
      "display" : "ciproheptadina"
    },
    {
      "code" : "41551000122100",
      "display" : "cisatracurio"
    },
    {
      "code" : "49531000122106",
      "display" : "citarabina"
    },
    {
      "code" : "55231000122107",
      "display" : "citrato de orfenadrina"
    },
    {
      "code" : "48391000122105",
      "display" : "clavo"
    },
    {
      "code" : "57501000122109",
      "display" : "clioquinol"
    },
    {
      "code" : "45461000122102",
      "display" : "clobetasona"
    },
    {
      "code" : "50361000122104",
      "display" : "clofibrato"
    },
    {
      "code" : "49821000122106",
      "display" : "clomociclina sódica"
    },
    {
      "code" : "60371000122100",
      "display" : "clopidogrel"
    },
    {
      "code" : "51161000122107",
      "display" : "clorazepato de potasio"
    },
    {
      "code" : "51051000122106",
      "display" : "clorhexidina"
    },
    {
      "code" : "55091000122100",
      "display" : "clorhidrato de isoetarina"
    },
    {
      "code" : "56911000122101",
      "display" : "clorhidrato de piperidolato"
    },
    {
      "code" : "58801000122107",
      "display" : "clormezanona"
    },
    {
      "code" : "51641000122103",
      "display" : "cloroquina"
    },
    {
      "code" : "45361000122106",
      "display" : "clorpromazina"
    },
    {
      "code" : "17971000122104",
      "display" : "tenofovir"
    },
    {
      "code" : "294159000",
      "display" : "teofilinato de colina"
    },
    {
      "code" : "294044009",
      "display" : "terbutalina"
    },
    {
      "code" : "294809006",
      "display" : "terlipresina"
    },
    {
      "code" : "294261003",
      "display" : "terpeno"
    },
    {
      "code" : "294779000",
      "display" : "testosterona administrada por vía oral"
    },
    {
      "code" : "294592000",
      "display" : "tetraciclina"
    },
    {
      "code" : "295105006",
      "display" : "tetradecil sulfato de sodio"
    },
    {
      "code" : "294460004",
      "display" : "tiabendazol"
    },
    {
      "code" : "767478003",
      "display" : "tiamina"
    },
    {
      "code" : "860765003",
      "display" : "tiazida"
    },
    {
      "code" : "294517005",
      "display" : "ticarcilina"
    },
    {
      "code" : "293933008",
      "display" : "tietilperazina"
    },
    {
      "code" : "19761000122103",
      "display" : "timerosal"
    },
    {
      "code" : "294568008",
      "display" : "tinidazol"
    },
    {
      "code" : "294875004",
      "display" : "tinzaparina"
    },
    {
      "code" : "870608005",
      "display" : "tiomersal"
    },
    {
      "code" : "293745006",
      "display" : "tiotepa"
    },
    {
      "code" : "782596007",
      "display" : "tiourea"
    },
    {
      "code" : "294830002",
      "display" : "tirotrofina"
    },
    {
      "code" : "294470002",
      "display" : "tobramicina"
    },
    {
      "code" : "294737006",
      "display" : "tolazamida"
    },
    {
      "code" : "293633005",
      "display" : "tolmetina"
    },
    {
      "code" : "17841000122102",
      "display" : "tomillo"
    },
    {
      "code" : "295004007",
      "display" : "torasemida"
    },
    {
      "code" : "450767000",
      "display" : "tramadol"
    },
    {
      "code" : "35181000122101",
      "display" : "trandolapril"
    },
    {
      "code" : "416389007",
      "display" : "trastorno gastrointestinal causado por alergia alimentaria"
    },
    {
      "code" : "294210008",
      "display" : "tretinoína"
    },
    {
      "code" : "294886002",
      "display" : "tromboplastina"
    },
    {
      "code" : "294231006",
      "display" : "tubocurarina"
    },
    {
      "code" : "294174003",
      "display" : "ungüento con ditranol"
    },
    {
      "code" : "295109000",
      "display" : "uroquinasa"
    },
    {
      "code" : "294648008",
      "display" : "vacuna antigripal de virión fragmentado"
    },
    {
      "code" : "294649000",
      "display" : "vacuna de antígeno de superficie del virus de la gripe"
    },
    {
      "code" : "22191000122108",
      "display" : "vacuna del meningococo C conjugado"
    },
    {
      "code" : "294650000",
      "display" : "vacuna frente a la parotiditis urliana"
    },
    {
      "code" : "22151000122104",
      "display" : "vacuna frente al meningococo A"
    },
    {
      "code" : "22061000122101",
      "display" : "vacuna frente al virus de la varicela"
    },
    {
      "code" : "22121000122106",
      "display" : "vacuna frente al virus varicela-zóster"
    },
    {
      "code" : "294374007",
      "display" : "valaciclovir"
    },
    {
      "code" : "32491000122100",
      "display" : "vandetanib"
    },
    {
      "code" : "20301000122101",
      "display" : "vareniclina"
    },
    {
      "code" : "294232004",
      "display" : "vecuronio"
    },
    {
      "code" : "32511000122109",
      "display" : "velpatasvir"
    },
    {
      "code" : "16224591000119100",
      "display" : "veneno de abeja melífera"
    },
    {
      "code" : "16224471000119100",
      "display" : "veneno de avispón chaqueta amarilla"
    },
    {
      "code" : "293843005",
      "display" : "venlafaxina"
    },
    {
      "code" : "294448000",
      "display" : "verde brillante"
    },
    {
      "code" : "293868007",
      "display" : "vigabatrina"
    },
    {
      "code" : "293794006",
      "display" : "vincristina"
    },
    {
      "code" : "293946003",
      "display" : "zuclopentixol"
    },
    {
      "code" : "56321000122106",
      "display" : "abacavir"
    },
    {
      "code" : "61921000122109",
      "display" : "ácaro Acarus siro"
    },
    {
      "code" : "61941000122104",
      "display" : "ácaro Gohieria fusca"
    },
    {
      "code" : "61531000122102",
      "display" : "ácaros de almacenamiento"
    },
    {
      "code" : "47341000122102",
      "display" : "aceite de almendras"
    },
    {
      "code" : "45811000122102",
      "display" : "aceite de menta"
    },
    {
      "code" : "49831000122109",
      "display" : "aceite fijo"
    },
    {
      "code" : "52941000122103",
      "display" : "acemetacina"
    },
    {
      "code" : "51591000122106",
      "display" : "acetilcisteína"
    },
    {
      "code" : "45541000122100",
      "display" : "ácido acético"
    },
    {
      "code" : "58821000122104",
      "display" : "ácido azelaico"
    },
    {
      "code" : "57051000122104",
      "display" : "ácido clavulánico"
    },
    {
      "code" : "61171000122107",
      "display" : "ácido espaglúmico"
    },
    {
      "code" : "53351000122107",
      "display" : "ácido folínico"
    },
    {
      "code" : "41961000122107",
      "display" : "ácido ibandrónico"
    },
    {
      "code" : "53651000122100",
      "display" : "ácido micofenólico"
    },
    {
      "code" : "47001000122101",
      "display" : "ácido paraaminosalicílico"
    },
    {
      "code" : "57951000122103",
      "display" : "ácido salicílico"
    },
    {
      "code" : "53931000122101",
      "display" : "ácido tranexámico"
    },
    {
      "code" : "60161000122107",
      "display" : "ácido zoledrónico"
    },
    {
      "code" : "57961000122101",
      "display" : "agente quelante"
    },
    {
      "code" : "55241000122104",
      "display" : "agente tópico"
    },
    {
      "code" : "43601000122102",
      "display" : "agentes hematológicos"
    },
    {
      "code" : "40561000122107",
      "display" : "ajo"
    },
    {
      "code" : "54681000122109",
      "display" : "albendazol"
    },
    {
      "code" : "42601000122106",
      "display" : "alcalasa"
    },
    {
      "code" : "47491000122101",
      "display" : "alcaloide del cornezuelo"
    },
    {
      "code" : "102612005",
      "display" : "alcohol"
    },
    {
      "code" : "52341000122102",
      "display" : "alcohol de lanolina"
    },
    {
      "code" : "51141000122108",
      "display" : "alcuronio"
    },
    {
      "code" : "44791000122100",
      "display" : "alectinib"
    },
    {
      "code" : "52931000122106",
      "display" : "alfatocoferilo"
    },
    {
      "code" : "41141000122106",
      "display" : "alfuzosina"
    },
    {
      "code" : "55601000122103",
      "display" : "alimentación por vía intravenosa [aminoácidos]"
    },
    {
      "code" : "235719002",
      "display" : "alimentaria"
    },
    {
      "code" : "41071000122101",
      "display" : "alimentaria intestinal"
    },
    {
      "code" : "46271000122103",
      "display" : "almorta"
    },
    {
      "code" : "45891000122105",
      "display" : "alopurinol"
    },
    {
      "code" : "54061000122105",
      "display" : "alquitrán mineral"
    },
    {
      "code" : "44541000122104",
      "display" : "alubia"
    },
    {
      "code" : "56201000122109",
      "display" : "amantadina"
    },
    {
      "code" : "46001000122103",
      "display" : "analgésicos"
    },
    {
      "code" : "55821000122105",
      "display" : "análogo de la metadona"
    },
    {
      "code" : "55021000122102",
      "display" : "anestésico"
    },
    {
      "code" : "59581000122109",
      "display" : "anestésicos intravenosos"
    },
    {
      "code" : "61781000122106",
      "display" : "anguila"
    },
    {
      "code" : "51361000122105",
      "display" : "anistreplasa"
    },
    {
      "code" : "43951000122109",
      "display" : "antagonista estrogénico"
    },
    {
      "code" : "47481000122104",
      "display" : "antazolina"
    },
    {
      "code" : "46421000122100",
      "display" : "antibiótico antituberculoso"
    },
    {
      "code" : "45041000122105",
      "display" : "antibióticos macrólidos"
    },
    {
      "code" : "58741000122104",
      "display" : "anticoagulante de acción directa"
    },
    {
      "code" : "46801000122106",
      "display" : "anticonceptivo oral combinado"
    },
    {
      "code" : "48001000122102",
      "display" : "antidepresivo tricíclico"
    },
    {
      "code" : "56591000122101",
      "display" : "antídotos contra plaguicidas"
    },
    {
      "code" : "59771000122102",
      "display" : "antihelmíntico con benzimidazol"
    },
    {
      "code" : "53341000122105",
      "display" : "antimicótico del grupo triazol"
    },
    {
      "code" : "50391000122105",
      "display" : "antiprotozoario de hidroxiquinolina"
    },
    {
      "code" : "50661000122105",
      "display" : "antitoxina diftérica"
    },
    {
      "code" : "56501000122106",
      "display" : "azafrán"
    },
    {
      "code" : "43081000122102",
      "display" : "azatioprina"
    },
    {
      "code" : "55391000122102",
      "display" : "azlocilina"
    },
    {
      "code" : "51881000122106",
      "display" : "oxitropio"
    },
    {
      "code" : "43111000122106",
      "display" : "paclitaxel"
    },
    {
      "code" : "53801000122103",
      "display" : "pamidronato disódico"
    },
    {
      "code" : "47401000122106",
      "display" : "papaína"
    },
    {
      "code" : "60431000122108",
      "display" : "parabenos"
    },
    {
      "code" : "49361000122109",
      "display" : "parafina"
    },
    {
      "code" : "49691000122109",
      "display" : "parafina líquida"
    },
    {
      "code" : "55611000122100",
      "display" : "parche de testosterona"
    },
    {
      "code" : "50331000122106",
      "display" : "paroxetina"
    },
    {
      "code" : "48851000122109",
      "display" : "pefloxacino"
    },
    {
      "code" : "52561000122108",
      "display" : "pelo de cobaya"
    },
    {
      "code" : "58421000122101",
      "display" : "pemolina"
    },
    {
      "code" : "45271000122108",
      "display" : "penicilina"
    },
    {
      "code" : "44471000122106",
      "display" : "penicilina combinada"
    },
    {
      "code" : "49121000122102",
      "display" : "penicilinas de amplio espectro"
    },
    {
      "code" : "40601000122107",
      "display" : "pentazocina"
    },
    {
      "code" : "51351000122108",
      "display" : "pepino"
    },
    {
      "code" : "55541000122102",
      "display" : "perborato sódico"
    },
    {
      "code" : "49771000122100",
      "display" : "perfenazina"
    },
    {
      "code" : "56191000122106",
      "display" : "pergolida"
    },
    {
      "code" : "58491000122104",
      "display" : "peróxido de benzoilo"
    },
    {
      "code" : "49811000122100",
      "display" : "petidina"
    },
    {
      "code" : "42211000122106",
      "display" : "pirbuterol"
    },
    {
      "code" : "60941000122105",
      "display" : "piribedil"
    },
    {
      "code" : "55761000122109",
      "display" : "pirimetamina"
    },
    {
      "code" : "60131000122100",
      "display" : "pitavastatina"
    },
    {
      "code" : "57191000122109",
      "display" : "pizotifeno"
    },
    {
      "code" : "49671000122108",
      "display" : "plaguicida clorado"
    },
    {
      "code" : "41801000122102",
      "display" : "planta"
    },
    {
      "code" : "40381000122105",
      "display" : "platija"
    },
    {
      "code" : "44041000122109",
      "display" : "plumas"
    },
    {
      "code" : "43901000122105",
      "display" : "poldina"
    },
    {
      "code" : "55941000122108",
      "display" : "polen de acedera"
    },
    {
      "code" : "49401000122101",
      "display" : "polen de aligustre"
    },
    {
      "code" : "47291000122100",
      "display" : "polen de alpiste"
    },
    {
      "code" : "62131000122101",
      "display" : "polen de arce"
    },
    {
      "code" : "54231000122106",
      "display" : "polen de avena"
    },
    {
      "code" : "46061000122102",
      "display" : "polen de castańo"
    },
    {
      "code" : "56931000122105",
      "display" : "polen de cenizo"
    },
    {
      "code" : "47261000122106",
      "display" : "polen de ciprés"
    },
    {
      "code" : "46391000122106",
      "display" : "polen de enebro"
    },
    {
      "code" : "57381000122108",
      "display" : "polen de fresno"
    },
    {
      "code" : "44161000122107",
      "display" : "polen de haya"
    },
    {
      "code" : "61621000122101",
      "display" : "polen de maleza"
    },
    {
      "code" : "46531000122103",
      "display" : "polen de nogal"
    },
    {
      "code" : "80601004",
      "display" : "potencial a la actividad"
    },
    {
      "code" : "60361000122105",
      "display" : "prasugrel"
    },
    {
      "code" : "41161000122105",
      "display" : "prazosina"
    },
    {
      "code" : "55291000122106",
      "display" : "prednisolona tópica"
    },
    {
      "code" : "45641000122104",
      "display" : "preparación para la remoción de cera auditiva"
    },
    {
      "code" : "46881000122104",
      "display" : "preparaciones con compuestos de tetraciclina"
    },
    {
      "code" : "59121000122104",
      "display" : "preparado antihemorroidal"
    },
    {
      "code" : "57091000122108",
      "display" : "preparado de tiamina"
    },
    {
      "code" : "50031000122108",
      "display" : "preparado para protección solar"
    },
    {
      "code" : "49511000122102",
      "display" : "preparados del complejo vitamínico B"
    },
    {
      "code" : "49931000122101",
      "display" : "primaquina"
    },
    {
      "code" : "292515001",
      "display" : "clonidina"
    },
    {
      "code" : "871683007",
      "display" : "cloral y/o derivado de cloral"
    },
    {
      "code" : "871673008",
      "display" : "clorazepato"
    },
    {
      "code" : "218697003",
      "display" : "clorfenesina"
    },
    {
      "code" : "871517005",
      "display" : "clorhexidina y neomicina"
    },
    {
      "code" : "218968003",
      "display" : "clormerodrina"
    },
    {
      "code" : "292854006",
      "display" : "cloroquina"
    },
    {
      "code" : "292875003",
      "display" : "cloroxilenol"
    },
    {
      "code" : "292401001",
      "display" : "clorprotixeno"
    },
    {
      "code" : "292530005",
      "display" : "cloruro de laquesina"
    },
    {
      "code" : "292963007",
      "display" : "cloxacilina"
    },
    {
      "code" : "292181009",
      "display" : "cocaína"
    },
    {
      "code" : "293351004",
      "display" : "colágeno"
    },
    {
      "code" : "292564009",
      "display" : "colfoscerilo"
    },
    {
      "code" : "292991004",
      "display" : "colistina"
    },
    {
      "code" : "403755007",
      "display" : "cutánea a tratamiento de medicina alternativa"
    },
    {
      "code" : "293336008",
      "display" : "dalteparina"
    },
    {
      "code" : "293225004",
      "display" : "danazol"
    },
    {
      "code" : "293081004",
      "display" : "dapsona"
    },
    {
      "code" : "292389002",
      "display" : "decanoato de flufenazina"
    },
    {
      "code" : "292403003",
      "display" : "decanoato de zuclopentixol"
    },
    {
      "code" : "293055003",
      "display" : "demeclociclina"
    },
    {
      "code" : "419287006",
      "display" : "derivado del para-aminofenol"
    },
    {
      "code" : "723653009",
      "display" : "descongestivo"
    },
    {
      "code" : "292175001",
      "display" : "desflurano"
    },
    {
      "code" : "292887005",
      "display" : "desinfectante con amidina"
    },
    {
      "code" : "293269006",
      "display" : "desmopresina"
    },
    {
      "code" : "293150006",
      "display" : "desoximetasona"
    },
    {
      "code" : "293166008",
      "display" : "dexametasona"
    },
    {
      "code" : "292262009",
      "display" : "dexfenfluramina"
    },
    {
      "code" : "292050003",
      "display" : "dextropropoxifeno"
    },
    {
      "code" : "871779000",
      "display" : "diamidina"
    },
    {
      "code" : "293536007",
      "display" : "diazóxido"
    },
    {
      "code" : "292071008",
      "display" : "diclofenaco"
    },
    {
      "code" : "293493004",
      "display" : "diclorfenamida"
    },
    {
      "code" : "292832009",
      "display" : "didanosina"
    },
    {
      "code" : "292915009",
      "display" : "dietilcarbamazina"
    },
    {
      "code" : "292383001",
      "display" : "difenilbutilpiperidina"
    },
    {
      "code" : "218957003",
      "display" : "difenoxilato"
    },
    {
      "code" : "293517002",
      "display" : "digoxina"
    },
    {
      "code" : "871522005",
      "display" : "dihidroergocornina, dihidroergocristina y/o dihidroergocriptina"
    },
    {
      "code" : "292788008",
      "display" : "dimeticona"
    },
    {
      "code" : "292254001",
      "display" : "dimetilsulfóxido"
    },
    {
      "code" : "293551003",
      "display" : "dinitrato de isosorbida de liberación modificada"
    },
    {
      "code" : "292712000",
      "display" : "dinoprostona"
    },
    {
      "code" : "698088001",
      "display" : "dipirona"
    },
    {
      "code" : "292257008",
      "display" : "azatioprina"
    },
    {
      "code" : "720678007",
      "display" : "azilsartán"
    },
    {
      "code" : "782579006",
      "display" : "azo-derivado de acridina"
    },
    {
      "code" : "292973009",
      "display" : "bacampicilina"
    },
    {
      "code" : "292496004",
      "display" : "bambuterol"
    },
    {
      "code" : "430398007",
      "display" : "barbitúrico"
    },
    {
      "code" : "1255409006",
      "display" : "bebida alcohólica"
    },
    {
      "code" : "293156000",
      "display" : "beclometasona"
    },
    {
      "code" : "293455009",
      "display" : "bendrofluazida"
    },
    {
      "code" : "876799007",
      "display" : "benserazida y/o levodopa"
    },
    {
      "code" : "871780002",
      "display" : "benzimidazol"
    },
    {
      "code" : "870677001",
      "display" : "benzodiazepina"
    },
    {
      "code" : "293566000",
      "display" : "betahistina"
    },
    {
      "code" : "292477003",
      "display" : "betanecol"
    },
    {
      "code" : "293426001",
      "display" : "bezafibrato"
    },
    {
      "code" : "218929005",
      "display" : "bicarbonato de sodio"
    },
    {
      "code" : "292527003",
      "display" : "biperideno"
    },
    {
      "code" : "292425009",
      "display" : "bisoprolol"
    },
    {
      "code" : "218868004",
      "display" : "bloqueante ganglionar"
    },
    {
      "code" : "292351007",
      "display" : "bromazepam"
    },
    {
      "code" : "292586005",
      "display" : "bromfeniramina"
    },
    {
      "code" : "292533007",
      "display" : "bromhidrato de hioscina"
    },
    {
      "code" : "292528008",
      "display" : "bromuro de emepronio"
    },
    {
      "code" : "293176006",
      "display" : "budesonida tópica"
    },
    {
      "code" : "292177009",
      "display" : "bupivacaína"
    },
    {
      "code" : "395215005",
      "display" : "bupropión"
    },
    {
      "code" : "292199001",
      "display" : "busulfano"
    },
    {
      "code" : "292377004",
      "display" : "butirofenona"
    },
    {
      "code" : "293262002",
      "display" : "cabergolina"
    },
    {
      "code" : "292626001",
      "display" : "calamina"
    },
    {
      "code" : "293303007",
      "display" : "calcitonina (cerdo)"
    },
    {
      "code" : "218791008",
      "display" : "cannabis"
    },
    {
      "code" : "292127006",
      "display" : "caolín"
    },
    {
      "code" : "293501008",
      "display" : "captopril"
    },
    {
      "code" : "293087000",
      "display" : "carbarilo"
    },
    {
      "code" : "292114007",
      "display" : "carbenoxolona"
    },
    {
      "code" : "292553006",
      "display" : "carbocisteína"
    },
    {
      "code" : "44851000122100",
      "display" : "tetraciclinas"
    },
    {
      "code" : "55561000122103",
      "display" : "tetranitrato de pentaeritritilo"
    },
    {
      "code" : "53761000122105",
      "display" : "tiamina"
    },
    {
      "code" : "51181000122104",
      "display" : "ticarcilina"
    },
    {
      "code" : "60581000122108",
      "display" : "tilo"
    },
    {
      "code" : "40851000122107",
      "display" : "timol"
    },
    {
      "code" : "53201000122102",
      "display" : "tinidazol"
    },
    {
      "code" : "57291000122102",
      "display" : "tioconazol"
    },
    {
      "code" : "54861000122100",
      "display" : "tioridazina"
    },
    {
      "code" : "40181000122108",
      "display" : "tioxanteno"
    },
    {
      "code" : "46321000122109",
      "display" : "tirotrofina"
    },
    {
      "code" : "55751000122107",
      "display" : "tocainida"
    },
    {
      "code" : "41301000122107",
      "display" : "tolbutamida"
    },
    {
      "code" : "54811000122103",
      "display" : "tomate"
    },
    {
      "code" : "49481000122108",
      "display" : "torasemida"
    },
    {
      "code" : "52111000122104",
      "display" : "trametinib"
    },
    {
      "code" : "60391000122104",
      "display" : "trastuzumab"
    },
    {
      "code" : "51961000122109",
      "display" : "treosulfano"
    },
    {
      "code" : "55791000122103",
      "display" : "triamcinolona"
    },
    {
      "code" : "45431000122109",
      "display" : "triazolam"
    },
    {
      "code" : "55881000122109",
      "display" : "tricloroetileno"
    },
    {
      "code" : "50081000122109",
      "display" : "trifluoperazina"
    },
    {
      "code" : "53701000122109",
      "display" : "triglicéridos omega 3 de origen marino"
    },
    {
      "code" : "51131000122100",
      "display" : "vacuna antigripal"
    },
    {
      "code" : "46081000122105",
      "display" : "vacuna antiparotidítica"
    },
    {
      "code" : "56461000122106",
      "display" : "vacuna antisarampionosa/antiparotidítica/antirrubeólica"
    },
    {
      "code" : "42281000122101",
      "display" : "vacuna antivariólica"
    },
    {
      "code" : "41121000122101",
      "display" : "vacuna contra la hepatitis A"
    },
    {
      "code" : "41261000122100",
      "display" : "vacuna de antígeno diftérico aislado"
    },
    {
      "code" : "47251000122109",
      "display" : "vacuna del meningococo C conjugado"
    },
    {
      "code" : "61371000122109",
      "display" : "vacuna frente al cólera"
    },
    {
      "code" : "61361000122104",
      "display" : "vacuna frente al virus de la encefalitis japonesa"
    },
    {
      "code" : "61391000122105",
      "display" : "vacuna frente al virus varicela-zóster"
    },
    {
      "code" : "50611000122107",
      "display" : "vainilla"
    },
    {
      "code" : "55151000122108",
      "display" : "vancomicina"
    },
    {
      "code" : "45691000122106",
      "display" : "probenecid"
    },
    {
      "code" : "42131000122106",
      "display" : "procainamida"
    },
    {
      "code" : "59151000122106",
      "display" : "prociclidina"
    },
    {
      "code" : "51171000122102",
      "display" : "producto cosmético"
    },
    {
      "code" : "53591000122105",
      "display" : "productos de factor XI"
    },
    {
      "code" : "50901000122101",
      "display" : "productos del factor IX"
    },
    {
      "code" : "1255410001",
      "display" : "alcohol"
    },
    {
      "code" : "292686003",
      "display" : "alcuronio"
    },
    {
      "code" : "292190002",
      "display" : "aldesleukina"
    },
    {
      "code" : "293389009",
      "display" : "alfatocoferilo"
    },
    {
      "code" : "292444002",
      "display" : "alfuzosina"
    },
    {
      "code" : "370540009",
      "display" : "alimento"
    },
    {
      "code" : "292679006",
      "display" : "alopurinol"
    },
    {
      "code" : "292627005",
      "display" : "alquitrán mineral"
    },
    {
      "code" : "218790009",
      "display" : "alucinógeno"
    },
    {
      "code" : "292269000",
      "display" : "amantadina"
    },
    {
      "code" : "292189006",
      "display" : "amifostina"
    },
    {
      "code" : "292338002",
      "display" : "amilobarbital"
    },
    {
      "code" : "292615007",
      "display" : "aminofilina"
    },
    {
      "code" : "292245004",
      "display" : "aminoglutetimida"
    },
    {
      "code" : "292460003",
      "display" : "amlodipino"
    },
    {
      "code" : "292806003",
      "display" : "amorolfina"
    },
    {
      "code" : "876792003",
      "display" : "amoxicilina y/o ácido clavulánico"
    },
    {
      "code" : "292236000",
      "display" : "amsacrina"
    },
    {
      "code" : "292045009",
      "display" : "analgésicos opiáceos"
    },
    {
      "code" : "293234009",
      "display" : "andrógenos"
    },
    {
      "code" : "218726009",
      "display" : "anestésico bloqueante de plexo y nervio periférico"
    },
    {
      "code" : "292169005",
      "display" : "anestésicos inhalatorios"
    },
    {
      "code" : "292414000",
      "display" : "anfetaminas"
    },
    {
      "code" : "292134008",
      "display" : "antagonista de receptor de 5-hidroxitriptamina"
    },
    {
      "code" : "292736001",
      "display" : "antagonista opioide"
    },
    {
      "code" : "293470005",
      "display" : "antagonistas de la aldosterona"
    },
    {
      "code" : "292216001",
      "display" : "antibiótico citotóxico"
    },
    {
      "code" : "419885006",
      "display" : "antibióticos betalactámicos"
    },
    {
      "code" : "293341000",
      "display" : "anticoagulante de acción indirecta"
    },
    {
      "code" : "292309000",
      "display" : "antidepresivo tetracíclico"
    },
    {
      "code" : "292735002",
      "display" : "antídoto de quemadura de ácido fluorhídrico"
    },
    {
      "code" : "292999002",
      "display" : "cefazolina"
    },
    {
      "code" : "293007003",
      "display" : "cefotaxima"
    },
    {
      "code" : "293017008",
      "display" : "cefpiroma"
    },
    {
      "code" : "293000001",
      "display" : "cefradina"
    },
    {
      "code" : "293014001",
      "display" : "ceftibuteno"
    },
    {
      "code" : "293013007",
      "display" : "ceftriaxona"
    },
    {
      "code" : "720679004",
      "display" : "cerivastatina"
    },
    {
      "code" : "292897001",
      "display" : "cetrimida"
    },
    {
      "code" : "292969006",
      "display" : "ciclacilina"
    },
    {
      "code" : "292340007",
      "display" : "ciclobarbital"
    },
    {
      "code" : "292204007",
      "display" : "ciclofosfamida"
    },
    {
      "code" : "292537008",
      "display" : "ciclopentolato"
    },
    {
      "code" : "293505004",
      "display" : "cilazapril"
    },
    {
      "code" : "292588006",
      "display" : "cinarizina"
    },
    {
      "code" : "292947004",
      "display" : "cinoxacino"
    },
    {
      "code" : "292949001",
      "display" : "ciprofloxacino"
    },
    {
      "code" : "871515002",
      "display" : "ciproterona y/o etinilestradiol"
    },
    {
      "code" : "292306007",
      "display" : "citalopram"
    },
    {
      "code" : "292768009",
      "display" : "citrato"
    },
    {
      "code" : "292933003",
      "display" : "claritromicina"
    },
    {
      "code" : "293023003",
      "display" : "clindamicina"
    },
    {
      "code" : "293157009",
      "display" : "clobetasol"
    },
    {
      "code" : "293082006",
      "display" : "clofazimina"
    },
    {
      "code" : "292288007",
      "display" : "clomipramina"
    },
    {
      "code" : "43031000122103",
      "display" : "darunavir"
    },
    {
      "code" : "47601000122108",
      "display" : "dátil"
    },
    {
      "code" : "46761000122104",
      "display" : "decanoato de flupentixol"
    },
    {
      "code" : "47441000122108",
      "display" : "decualinio"
    },
    {
      "code" : "60171000122102",
      "display" : "denosumab"
    },
    {
      "code" : "46011000122100",
      "display" : "derivados de la mostaza nitrogenada"
    },
    {
      "code" : "43851000122102",
      "display" : "descongestivo"
    },
    {
      "code" : "48431000122101",
      "display" : "desinfectante alcohólico"
    },
    {
      "code" : "40721000122105",
      "display" : "dietilestilbestrol"
    },
    {
      "code" : "51251000122104",
      "display" : "difenilbutilpiperidina"
    },
    {
      "code" : "57061000122102",
      "display" : "digoxina"
    },
    {
      "code" : "40931000122105",
      "display" : "diltiazem"
    },
    {
      "code" : "56691000122102",
      "display" : "dimeticona"
    },
    {
      "code" : "40951000122100",
      "display" : "dimetindeno"
    },
    {
      "code" : "43651000122103",
      "display" : "dinitrato de isosorbida oral"
    },
    {
      "code" : "46851000122105",
      "display" : "dinoprostona"
    },
    {
      "code" : "45491000122108",
      "display" : "dipivefrina"
    },
    {
      "code" : "102462006",
      "display" : "disminuida"
    },
    {
      "code" : "54051000122108",
      "display" : "disulfiram"
    },
    {
      "code" : "58211000122106",
      "display" : "diurético compuesto ahorrador de potasio"
    },
    {
      "code" : "59011000122106",
      "display" : "diurético tipo sulfonamida"
    },
    {
      "code" : "48011000122104",
      "display" : "dolutegravir"
    },
    {
      "code" : "47851000122108",
      "display" : "dopexamina"
    },
    {
      "code" : "51201000122103",
      "display" : "dotiepina"
    },
    {
      "code" : "45091000122103",
      "display" : "doxazosina"
    },
    {
      "code" : "54951000122109",
      "display" : "doxilamina"
    },
    {
      "code" : "55371000122103",
      "display" : "duloxetina"
    },
    {
      "code" : "40881000122101",
      "display" : "edetato"
    },
    {
      "code" : "55361000122108",
      "display" : "edetato disódico"
    },
    {
      "code" : "60541000122104",
      "display" : "equinocandinas"
    },
    {
      "code" : "51371000122100",
      "display" : "eritromicina"
    },
    {
      "code" : "50741000122102",
      "display" : "escarola"
    },
    {
      "code" : "49561000122104",
      "display" : "esmolol"
    },
    {
      "code" : "43991000122100",
      "display" : "espectinomicina"
    },
    {
      "code" : "57361000122100",
      "display" : "espironolactona"
    },
    {
      "code" : "59961000122105",
      "display" : "estacional"
    },
    {
      "code" : "57021000122106",
      "display" : "esteroides anabólicos"
    },
    {
      "code" : "43231000122106",
      "display" : "estradiol tópico"
    },
    {
      "code" : "42781000122108",
      "display" : "estreptoquinasa"
    },
    {
      "code" : "59641000122104",
      "display" : "estrógenos"
    },
    {
      "code" : "42821000122104",
      "display" : "etamsilato"
    },
    {
      "code" : "48781000122106",
      "display" : "etidronato disódico"
    },
    {
      "code" : "44921000122100",
      "display" : "etinilestradiol"
    },
    {
      "code" : "43961000122106",
      "display" : "etomidato"
    },
    {
      "code" : "55511000122101",
      "display" : "etretinato"
    },
    {
      "code" : "46711000122102",
      "display" : "factor de coagulación sanguínea"
    },
    {
      "code" : "51721000122102",
      "display" : "famotidina"
    },
    {
      "code" : "59651000122102",
      "display" : "fármaco agonista de receptor beta-adrenérgico"
    },
    {
      "code" : "48421000122104",
      "display" : "fármaco antialérgico"
    },
    {
      "code" : "55901000122106",
      "display" : "fármaco antiarrítmico de clase II"
    },
    {
      "code" : "46451000122107",
      "display" : "protriptilina"
    },
    {
      "code" : "61581000122101",
      "display" : "pulpo"
    },
    {
      "code" : "44291000122108",
      "display" : "quelato de bismuto"
    },
    {
      "code" : "43581000122105",
      "display" : "quinagolida"
    },
    {
      "code" : "45961000122105",
      "display" : "quinestrol"
    },
    {
      "code" : "59201000122104",
      "display" : "rábano"
    },
    {
      "code" : "60051000122106",
      "display" : "raíz de lirio"
    },
    {
      "code" : "62071000122104",
      "display" : "rana"
    },
    {
      "code" : "44591000122106",
      "display" : "rape"
    },
    {
      "code" : "42271000122104",
      "display" : "razoxano"
    },
    {
      "code" : "57421000122100",
      "display" : "relajante del músculo liso"
    },
    {
      "code" : "54641000122100",
      "display" : "repollo"
    },
    {
      "code" : "51671000122109",
      "display" : "resina de intercambio aniónico"
    },
    {
      "code" : "43101000122108",
      "display" : "retinoide"
    },
    {
      "code" : "42541000122107",
      "display" : "rifampicina"
    },
    {
      "code" : "61091000122107",
      "display" : "risedronato"
    },
    {
      "code" : "47391000122109",
      "display" : "rizatriptán"
    },
    {
      "code" : "61631000122103",
      "display" : "romero"
    },
    {
      "code" : "44991000122103",
      "display" : "rubefacientes"
    },
    {
      "code" : "58651000122105",
      "display" : "ruxolitinib"
    },
    {
      "code" : "40121000122109",
      "display" : "salcatonina"
    },
    {
      "code" : "56611000122105",
      "display" : "salmeterol"
    },
    {
      "code" : "56731000122108",
      "display" : "salvia"
    },
    {
      "code" : "41781000122101",
      "display" : "sardina"
    },
    {
      "code" : "60621000122108",
      "display" : "sitagliptina"
    },
    {
      "code" : "44121000122103",
      "display" : "solución de albúmina"
    },
    {
      "code" : "58541000122107",
      "display" : "solución para diálisis peritoneal"
    },
    {
      "code" : "55141000122106",
      "display" : "sotalol"
    },
    {
      "code" : "60031000122101",
      "display" : "suero"
    },
    {
      "code" : "48641000122106",
      "display" : "sufentanilo"
    },
    {
      "code" : "53141000122107",
      "display" : "sulfadiazina argéntica"
    },
    {
      "code" : "48491000122102",
      "display" : "sulfafurazol"
    },
    {
      "code" : "46041000122101",
      "display" : "sulfametopirazina"
    },
    {
      "code" : "48381000122107",
      "display" : "sulfato de bametán"
    },
    {
      "code" : "45131000122101",
      "display" : "sulfato de glicina ferroso"
    },
    {
      "code" : "58101000122100",
      "display" : "sulfaurea"
    },
    {
      "code" : "50951000122102",
      "display" : "sulfonamidas combinadas"
    },
    {
      "code" : "53951000122106",
      "display" : "sulpirida"
    },
    {
      "code" : "46831000122100",
      "display" : "surfactante aniónico"
    },
    {
      "code" : "48791000122109",
      "display" : "surfactante de quinolinio cuaternario"
    },
    {
      "code" : "40961000122103",
      "display" : "suspensión de insulina cinc [cristalina]"
    },
    {
      "code" : "53391000122103",
      "display" : "sustancia de origen animal"
    },
    {
      "code" : "44261000122102",
      "display" : "sustitutos plasmáticos"
    },
    {
      "code" : "52531000122101",
      "display" : "kiwi"
    },
    {
      "code" : "47171000122106",
      "display" : "labetalol"
    },
    {
      "code" : "54250004",
      "display" : "lactosa en nińos sin deficiencia de lactasa"
    },
    {
      "code" : "53291000122107",
      "display" : "lanatósido C"
    },
    {
      "code" : "61881000122103",
      "display" : "lapa"
    },
    {
      "code" : "56041000122103",
      "display" : "látex"
    },
    {
      "code" : "45931000122103",
      "display" : "laxante formador de masa"
    },
    {
      "code" : "61241000122108",
      "display" : "leche de oveja"
    },
    {
      "code" : "53571000122109",
      "display" : "lechuga"
    },
    {
      "code" : "56141000122104",
      "display" : "lenguado"
    },
    {
      "code" : "103269006",
      "display" : "lentes de contacto"
    },
    {
      "code" : "45021000122100",
      "display" : "levadura"
    },
    {
      "code" : "60871000122108",
      "display" : "levobupivacaína"
    },
    {
      "code" : "48311000122102",
      "display" : "levonorgestrel"
    },
    {
      "code" : "41861000122101",
      "display" : "lidocaína"
    },
    {
      "code" : "48591000122103",
      "display" : "limeciclina"
    },
    {
      "code" : "53321000122100",
      "display" : "lincomicina y sus derivados"
    },
    {
      "code" : "50571000122104",
      "display" : "liotironina"
    },
    {
      "code" : "51601000122100",
      "display" : "líquido de diálisis"
    },
    {
      "code" : "42741000122104",
      "display" : "lisozima"
    },
    {
      "code" : "47921000122108",
      "display" : "lodoxamida"
    },
    {
      "code" : "60711000122108",
      "display" : "lomefloxacino"
    },
    {
      "code" : "43461000122103",
      "display" : "loprazolam"
    },
    {
      "code" : "49341000122105",
      "display" : "mecilinam"
    },
    {
      "code" : "59037007",
      "display" : "medicamentosa"
    },
    {
      "code" : "51901000122108",
      "display" : "medio de contraste para resonancia magnética"
    },
    {
      "code" : "54721000122104",
      "display" : "mefloquina"
    },
    {
      "code" : "52191000122107",
      "display" : "meglitinida"
    },
    {
      "code" : "48471000122103",
      "display" : "melfalán"
    },
    {
      "code" : "56891000122103",
      "display" : "mepenzolato"
    },
    {
      "code" : "55521000122107",
      "display" : "meptazinol"
    },
    {
      "code" : "55081000122103",
      "display" : "mercurio y derivados"
    },
    {
      "code" : "45881000122107",
      "display" : "mesalazina"
    },
    {
      "code" : "46281000122100",
      "display" : "mesterolona"
    },
    {
      "code" : "61211000122109",
      "display" : "metacresol"
    },
    {
      "code" : "52911000122102",
      "display" : "metamizol"
    },
    {
      "code" : "41481000122107",
      "display" : "metformina"
    },
    {
      "code" : "44561000122100",
      "display" : "metilcisteína"
    },
    {
      "code" : "43061000122105",
      "display" : "metilfenidato"
    },
    {
      "code" : "42111000122102",
      "display" : "metipranolol"
    },
    {
      "code" : "54781000122100",
      "display" : "metixeno"
    },
    {
      "code" : "58961000122102",
      "display" : "metohexital"
    },
    {
      "code" : "41411000122102",
      "display" : "metotrexato"
    },
    {
      "code" : "58921000122106",
      "display" : "metronidazol"
    },
    {
      "code" : "59061000122109",
      "display" : "mianserina"
    },
    {
      "code" : "45671000122105",
      "display" : "midazolam"
    },
    {
      "code" : "54381000122104",
      "display" : "mijo"
    },
    {
      "code" : "53381000122101",
      "display" : "moxifloxacino"
    },
    {
      "code" : "53021000122103",
      "display" : "nabilona"
    },
    {
      "code" : "59141000122109",
      "display" : "nadolol"
    },
    {
      "code" : "59281000122106",
      "display" : "nafazolina"
    },
    {
      "code" : "56621000122104",
      "display" : "naloxona"
    },
    {
      "code" : "59091000122103",
      "display" : "naproxeno"
    },
    {
      "code" : "53061000122107",
      "display" : "natamicina"
    },
    {
      "code" : "47141000122100",
      "display" : "nedocromilo"
    },
    {
      "code" : "55281000122108",
      "display" : "neomicina"
    },
    {
      "code" : "60091000122102",
      "display" : "nevirapina"
    },
    {
      "code" : "49951000122106",
      "display" : "niclosamida"
    },
    {
      "code" : "46701000122100",
      "display" : "nicotina"
    },
    {
      "code" : "52521000122104",
      "display" : "nifedipino"
    },
    {
      "code" : "58001000122104",
      "display" : "nimorazol"
    },
    {
      "code" : "40211000122107",
      "display" : "níspero"
    },
    {
      "code" : "45471000122107",
      "display" : "nitrazepam"
    },
    {
      "code" : "47021000122109",
      "display" : "nitrofurantoína"
    },
    {
      "code" : "42641000122108",
      "display" : "nitroprusiato de sodio"
    },
    {
      "code" : "57231000122101",
      "display" : "noradrenalina"
    },
    {
      "code" : "49701000122109",
      "display" : "nortriptilina"
    },
    {
      "code" : "47041000122104",
      "display" : "nueces"
    },
    {
      "code" : "61231000122100",
      "display" : "nuez de pacana"
    },
    {
      "code" : "46401000122108",
      "display" : "nutrición parenteral [ya mezclada]"
    },
    {
      "code" : "42341000122100",
      "display" : "olopatadina"
    },
    {
      "code" : "48141000122101",
      "display" : "oxitetraciclina"
    },
    {
      "code" : "56411000122108",
      "display" : "vardenafilo"
    },
    {
      "code" : "59781000122104",
      "display" : "vasodilatador de nitrato"
    },
    {
      "code" : "59491000122108",
      "display" : "vendaje adhesivo"
    },
    {
      "code" : "44091000122102",
      "display" : "veneno de arácnido"
    },
    {
      "code" : "45001000122108",
      "display" : "yema de huevo"
    },
    {
      "code" : "41291000122106",
      "display" : "zalcitabina"
    },
    {
      "code" : "52641000122105",
      "display" : "zidovudina"
    },
    {
      "code" : "49261000122101",
      "display" : "zolpidem"
    },
    {
      "code" : "44111000122109",
      "display" : "zumo de manzana"
    },
    {
      "code" : "62014003",
      "display" : "a medicamento"
    },
    {
      "code" : "292421000",
      "display" : "acebutolol"
    },
    {
      "code" : "292148008",
      "display" : "aceite de menta"
    },
    {
      "code" : "292774009",
      "display" : "aceite fijo"
    },
    {
      "code" : "292069008",
      "display" : "acemetacina"
    },
    {
      "code" : "292555004",
      "display" : "acetilcisteína"
    },
    {
      "code" : "293192001",
      "display" : "acetohexamida"
    },
    {
      "code" : "293403008",
      "display" : "ácido ascórbico"
    },
    {
      "code" : "871567003",
      "display" : "ácido benzoico, ácido málico y/o éster de ácido salicílico"
    },
    {
      "code" : "871676000",
      "display" : "ácido cromoglícico"
    },
    {
      "code" : "871675001",
      "display" : "ácido etidrónico"
    },
    {
      "code" : "293394009",
      "display" : "ácido folínico"
    },
    {
      "code" : "292664004",
      "display" : "ácido gamolénico"
    },
    {
      "code" : "293025005",
      "display" : "ácido mandélico"
    },
    {
      "code" : "293392008",
      "display" : "ácido nicotínico"
    },
    {
      "code" : "292157002",
      "display" : "ácido quenodesoxicólico"
    },
    {
      "code" : "293350003",
      "display" : "ácido tranexámico"
    },
    {
      "code" : "871513009",
      "display" : "ácidos quenodesoxicólico y/o ursodesoxicólico"
    },
    {
      "code" : "292222005",
      "display" : "aclarubicina"
    },
    {
      "code" : "292946008",
      "display" : "acrosoxacina"
    },
    {
      "code" : "293437000",
      "display" : "adenosina"
    },
    {
      "code" : "219015004",
      "display" : "adifenina"
    },
    {
      "code" : "766054009",
      "display" : "adrenocromo"
    },
    {
      "code" : "292628000",
      "display" : "preparados de alquitrán mineral para el cuero cabelludo"
    },
    {
      "code" : "292851003",
      "display" : "primaquina"
    },
    {
      "code" : "292676004",
      "display" : "probenecid"
    },
    {
      "code" : "293445005",
      "display" : "procainamida"
    },
    {
      "code" : "292547006",
      "display" : "prociclidina"
    },
    {
      "code" : "770702001",
      "display" : "productos del Factor VII activado"
    },
    {
      "code" : "293207006",
      "display" : "progestágeno"
    },
    {
      "code" : "292413006",
      "display" : "prolintano"
    },
    {
      "code" : "292584008",
      "display" : "prometazina"
    },
    {
      "code" : "293140005",
      "display" : "propiltiouracilo"
    },
    {
      "code" : "292440006",
      "display" : "propranolol"
    },
    {
      "code" : "292710008",
      "display" : "prostaglandina, serie A"
    },
    {
      "code" : "292719009",
      "display" : "prostaglandina, serie I"
    },
    {
      "code" : "293292006",
      "display" : "protirelina"
    },
    {
      "code" : "292482005",
      "display" : "pseudoefedrina"
    },
    {
      "code" : "218795004",
      "display" : "psilocina"
    },
    {
      "code" : "293579009",
      "display" : "quimotripsina"
    },
    {
      "code" : "293503006",
      "display" : "quinapril"
    },
    {
      "code" : "293250001",
      "display" : "quinestrol"
    },
    {
      "code" : "292858009",
      "display" : "quinina"
    },
    {
      "code" : "293504000",
      "display" : "ramipril"
    },
    {
      "code" : "292241008",
      "display" : "razoxano"
    },
    {
      "code" : "219019005",
      "display" : "relajantes de músculo esquelético"
    },
    {
      "code" : "292499006",
      "display" : "reproterol"
    },
    {
      "code" : "293422004",
      "display" : "resina de intercambio aniónico"
    },
    {
      "code" : "292665003",
      "display" : "retinoide"
    },
    {
      "code" : "293075007",
      "display" : "rifampicina"
    },
    {
      "code" : "292501003",
      "display" : "ritodrina"
    },
    {
      "code" : "292692009",
      "display" : "rocuronio"
    },
    {
      "code" : "293360007",
      "display" : "sal ferrosa"
    },
    {
      "code" : "293302002",
      "display" : "salcatonina"
    },
    {
      "code" : "292494001",
      "display" : "salmeterol"
    },
    {
      "code" : "218583002",
      "display" : "sangre total"
    },
    {
      "code" : "292363002",
      "display" : "sedante a base de carbamato"
    },
    {
      "code" : "292144005",
      "display" : "sen"
    },
    {
      "code" : "292140001",
      "display" : "sulfato de magnesio"
    },
    {
      "code" : "293363009",
      "display" : "sulfato ferroso de glicina"
    },
    {
      "code" : "293191008",
      "display" : "sulfonilurea"
    },
    {
      "code" : "292372005",
      "display" : "sulpirida"
    },
    {
      "code" : "292895009",
      "display" : "surfactante catiónico"
    },
    {
      "code" : "292902000",
      "display" : "surfactante de quinolinio cuaternario"
    },
    {
      "code" : "446994009",
      "display" : "sustancia biológica"
    },
    {
      "code" : "292651000",
      "display" : "sustancias emolientes"
    },
    {
      "code" : "418949004",
      "display" : "suxametonio"
    },
    {
      "code" : "292248002",
      "display" : "tamoxifeno"
    },
    {
      "code" : "292938007",
      "display" : "teicoplanina"
    },
    {
      "code" : "292953004",
      "display" : "temafloxacino"
    },
    {
      "code" : "1300137003",
      "display" : "tenecteplasa"
    },
    {
      "code" : "218973009",
      "display" : "teobromina"
    },
    {
      "code" : "292450007",
      "display" : "terazosina"
    },
    {
      "code" : "292502005",
      "display" : "terbutalina"
    },
    {
      "code" : "871525007",
      "display" : "terodilina"
    },
    {
      "code" : "293238007",
      "display" : "testosterona"
    },
    {
      "code" : "292376008",
      "display" : "tetrabenazina"
    },
    {
      "code" : "293275002",
      "display" : "tetracosactrina"
    },
    {
      "code" : "293554006",
      "display" : "tetranitrato de pentaeritritilo"
    },
    {
      "code" : "292979008",
      "display" : "ticarcilina"
    },
    {
      "code" : "871685000",
      "display" : "tierra de Fuller"
    },
    {
      "code" : "292873005",
      "display" : "timol"
    },
    {
      "code" : "293565001",
      "display" : "timoxamina"
    },
    {
      "code" : "293337004",
      "display" : "tinzaparina"
    },
    {
      "code" : "292231005",
      "display" : "tioguanina"
    },
    {
      "code" : "292727000",
      "display" : "tiosulfato de sodio"
    },
    {
      "code" : "292400000",
      "display" : "tioxanteno"
    },
    {
      "code" : "293266004",
      "display" : "tiroxina"
    },
    {
      "code" : "293447002",
      "display" : "tocainida"
    },
    {
      "code" : "218845008",
      "display" : "tolazolina"
    },
    {
      "code" : "292091001",
      "display" : "tolmetina"
    },
    {
      "code" : "418211009",
      "display" : "toxina de Clostridium botulinum"
    },
    {
      "code" : "292297006",
      "display" : "tranilcipromina"
    },
    {
      "code" : "292473004",
      "display" : "ecotiopato"
    },
    {
      "code" : "292748003",
      "display" : "edetato de calcio sódico"
    },
    {
      "code" : "293357000",
      "display" : "edetato sódico de hierro"
    },
    {
      "code" : "292519007",
      "display" : "efedrina"
    },
    {
      "code" : "219052004",
      "display" : "emolientes, lenitivos y protectores"
    },
    {
      "code" : "292648007",
      "display" : "enbucrilato"
    },
    {
      "code" : "293335007",
      "display" : "enoxaparina"
    },
    {
      "code" : "302982001",
      "display" : "enzima medicinal"
    },
    {
      "code" : "293306004",
      "display" : "epoetina alfa"
    },
    {
      "code" : "720676006",
      "display" : "eprosartán"
    },
    {
      "code" : "293530001",
      "display" : "ergometrina"
    },
    {
      "code" : "292936006",
      "display" : "espectinomicina"
    },
    {
      "code" : "406448004",
      "display" : "espiramicina"
    },
    {
      "code" : "293223006",
      "display" : "estanozolol"
    },
    {
      "code" : "293244006",
      "display" : "estradiol"
    },
    {
      "code" : "293247004",
      "display" : "estradiol tópico"
    },
    {
      "code" : "293571007",
      "display" : "estreptoquinasa"
    },
    {
      "code" : "293256007",
      "display" : "estriol"
    },
    {
      "code" : "293257003",
      "display" : "estrógenos conjugados"
    },
    {
      "code" : "293348006",
      "display" : "etamsilato"
    },
    {
      "code" : "293569007",
      "display" : "etanolamina"
    },
    {
      "code" : "292072001",
      "display" : "etodolaco"
    },
    {
      "code" : "292164000",
      "display" : "etomidato"
    },
    {
      "code" : "292666002",
      "display" : "etretinato"
    },
    {
      "code" : "871922002",
      "display" : "extracto alergénico"
    },
    {
      "code" : "419330004",
      "display" : "factor liberador de tirotrofina"
    },
    {
      "code" : "770711001",
      "display" : "factor VIII"
    },
    {
      "code" : "292191003",
      "display" : "factores estimulantes de colonias"
    },
    {
      "code" : "871566007",
      "display" : "fármaco agonista de receptor adrenérgico"
    },
    {
      "code" : "292197004",
      "display" : "fármaco alquilante"
    },
    {
      "code" : "292162001",
      "display" : "fármaco anestésico general"
    },
    {
      "code" : "293438005",
      "display" : "fármaco antiarrítmico clase I"
    },
    {
      "code" : "293452007",
      "display" : "fármaco antiarrítmico de clase IV"
    },
    {
      "code" : "292275009",
      "display" : "fármaco antidepresivo"
    },
    {
      "code" : "219031007",
      "display" : "fármaco expectorante"
    },
    {
      "code" : "292293005",
      "display" : "fármaco inhibidor de la monoaminooxidasa"
    },
    {
      "code" : "292371003",
      "display" : "fármaco neuroléptico"
    },
    {
      "code" : "417229001",
      "display" : "fármaco que actúa principalmente sobre la nutrición"
    },
    {
      "code" : "293531002",
      "display" : "fármaco vasodilatador"
    },
    {
      "code" : "292910004",
      "display" : "fármacos antihelmínticos"
    },
    {
      "code" : "292073006",
      "display" : "felbinaco"
    },
    {
      "code" : "218605001",
      "display" : "fenacetina"
    },
    {
      "code" : "292294004",
      "display" : "fenelzina"
    },
    {
      "code" : "292264005",
      "display" : "fenfluramina"
    },
    {
      "code" : "871577001",
      "display" : "fenilpropanolamina"
    },
    {
      "code" : "293346005",
      "display" : "fenindiona"
    },
    {
      "code" : "292323003",
      "display" : "fenobarbital"
    },
    {
      "code" : "764443008",
      "display" : "fenol clorado"
    },
    {
      "code" : "292065002",
      "display" : "fenoperidina"
    },
    {
      "code" : "292497008",
      "display" : "fenoterol"
    },
    {
      "code" : "293093008",
      "display" : "fenotrina"
    },
    {
      "code" : "292063009",
      "display" : "fentanilo"
    },
    {
      "code" : "292816006",
      "display" : "fenticonazol"
    },
    {
      "code" : "292194006",
      "display" : "filgrastim"
    },
    {
      "code" : "292470001",
      "display" : "fisostigmina"
    },
    {
      "code" : "293442008",
      "display" : "flecainida"
    },
    {
      "code" : "292801008",
      "display" : "flucitosina"
    },
    {
      "code" : "876793008",
      "display" : "flucloxacilina+ampicilina"
    },
    {
      "code" : "293162005",
      "display" : "fludrocortisona"
    },
    {
      "code" : "293148003",
      "display" : "flunisolida"
    },
    {
      "code" : "293163000",
      "display" : "fluocinolona"
    },
    {
      "code" : "293152003",
      "display" : "fluorcotolona"
    },
    {
      "code" : "292234002",
      "display" : "fluorouracilo"
    },
    {
      "code" : "293153008",
      "display" : "flurandrenolona"
    },
    {
      "code" : "292385008",
      "display" : "fluspirileno"
    },
    {
      "code" : "293164006",
      "display" : "fluticasona"
    },
    {
      "code" : "292538003",
      "display" : "glicopirronio"
    },
    {
      "code" : "293198002",
      "display" : "gliquidona"
    },
    {
      "code" : "293135002",
      "display" : "glucagón"
    },
    {
      "code" : "135451000119105",
      "display" : "glutamato monosódico"
    },
    {
      "code" : "293204004",
      "display" : "goma guar"
    },
    {
      "code" : "293282003",
      "display" : "gonadotrofina"
    },
    {
      "code" : "292808002",
      "display" : "griseofulvina"
    },
    {
      "code" : "293154002",
      "display" : "halcinonida"
    },
    {
      "code" : "292382006",
      "display" : "haloperidol"
    },
    {
      "code" : "293334006",
      "display" : "heparina"
    },
    {
      "code" : "293310001",
      "display" : "hetalmidón"
    },
    {
      "code" : "292867009",
      "display" : "hexetidina"
    },
    {
      "code" : "293577006",
      "display" : "hialuronidasa"
    },
    {
      "code" : "292865001",
      "display" : "hidrargafeno"
    },
    {
      "code" : "293458006",
      "display" : "hidroclorotiazida"
    },
    {
      "code" : "293459003",
      "display" : "hidroflumetiazida"
    },
    {
      "code" : "292124004",
      "display" : "hidróxido de aluminio"
    },
    {
      "code" : "292239007",
      "display" : "hidroxiurea"
    },
    {
      "code" : "293396006",
      "display" : "hidroxocobalamina"
    },
    {
      "code" : "871499007",
      "display" : "hierro y a ácido fólico"
    },
    {
      "code" : "292532002",
      "display" : "hioscina"
    },
    {
      "code" : "292941003",
      "display" : "hipurato de hexametilenamina"
    },
    {
      "code" : "408673004",
      "display" : "hormona adenohipofisaria"
    },
    {
      "code" : "767013007",
      "display" : "hormona hipotalámica"
    },
    {
      "code" : "293300005",
      "display" : "hormona reguladora del calcio"
    },
    {
      "code" : "293206002",
      "display" : "hormonas sexuales"
    },
    {
      "code" : "292635008",
      "display" : "ictamol"
    },
    {
      "code" : "292845008",
      "display" : "idoxuridina"
    },
    {
      "code" : "292206009",
      "display" : "ifosfamida"
    },
    {
      "code" : "293246008",
      "display" : "implante de estradiol"
    },
    {
      "code" : "293488002",
      "display" : "indapamida"
    },
    {
      "code" : "292446000",
      "display" : "indoramina"
    },
    {
      "code" : "830281004",
      "display" : "inhibidor de aldehído deshidrogenasa"
    },
    {
      "code" : "293492009",
      "display" : "inhibidor de la anhidrasa carbónica"
    },
    {
      "code" : "292295003",
      "display" : "iproniazida"
    },
    {
      "code" : "292606000",
      "display" : "isoaminilo"
    },
    {
      "code" : "292819004",
      "display" : "isoconazol"
    },
    {
      "code" : "292507004",
      "display" : "isoprenalina"
    },
    {
      "code" : "292508009",
      "display" : "isoprenalina administrada por vía oral"
    },
    {
      "code" : "292456001",
      "display" : "isradipino"
    },
    {
      "code" : "292923006",
      "display" : "kanamicina"
    },
    {
      "code" : "292355003",
      "display" : "ketazolam"
    },
    {
      "code" : "218619001",
      "display" : "ketoprofeno"
    },
    {
      "code" : "293375004",
      "display" : "l-carnitina"
    },
    {
      "code" : "292139003",
      "display" : "lactulosa"
    },
    {
      "code" : "293519004",
      "display" : "lanatósido C"
    },
    {
      "code" : "292135009",
      "display" : "laxante"
    },
    {
      "code" : "292141002",
      "display" : "laxante formador de masa"
    },
    {
      "code" : "218813003",
      "display" : "levalorfano"
    },
    {
      "code" : "292266007",
      "display" : "levodopa"
    },
    {
      "code" : "293216005",
      "display" : "levonorgestrel"
    },
    {
      "code" : "292453009",
      "display" : "lidoflazina"
    },
    {
      "code" : "292863008",
      "display" : "limpiadores y desinfectantes"
    },
    {
      "code" : "293265000",
      "display" : "liotironina"
    },
    {
      "code" : "292762005",
      "display" : "líquido de hemodiálisis"
    },
    {
      "code" : "293502001",
      "display" : "lisinopril"
    },
    {
      "code" : "292276005",
      "display" : "litio"
    },
    {
      "code" : "292603008",
      "display" : "lodoxamida"
    },
    {
      "code" : "292516000",
      "display" : "lofexidina"
    },
    {
      "code" : "292346001",
      "display" : "loprazolam"
    },
    {
      "code" : "292361000",
      "display" : "lorazepam"
    },
    {
      "code" : "720681002",
      "display" : "lovastatina"
    },
    {
      "code" : "292780001",
      "display" : "lubricantes"
    },
    {
      "code" : "292930000",
      "display" : "macrólido"
    },
    {
      "code" : "218928002",
      "display" : "magaldrato"
    },
    {
      "code" : "292310005",
      "display" : "maprotilina"
    },
    {
      "code" : "292917001",
      "display" : "mebendazol"
    },
    {
      "code" : "871575009",
      "display" : "meclozina"
    },
    {
      "code" : "292756000",
      "display" : "medicamentos a base de hierbas"
    },
    {
      "code" : "292095005",
      "display" : "medio de contraste"
    },
    {
      "code" : "292485007",
      "display" : "metaraminol"
    },
    {
      "code" : "292965000",
      "display" : "meticilina"
    },
    {
      "code" : "292512003",
      "display" : "metildopa"
    },
    {
      "code" : "292322008",
      "display" : "metilfenobarbital"
    },
    {
      "code" : "292433005",
      "display" : "metipranolol"
    },
    {
      "code" : "292541007",
      "display" : "metixeno"
    },
    {
      "code" : "292133002",
      "display" : "metoclopramida"
    },
    {
      "code" : "292428006",
      "display" : "metoprolol"
    },
    {
      "code" : "292486008",
      "display" : "metoxamina"
    },
    {
      "code" : "292970007",
      "display" : "mezlocilina"
    },
    {
      "code" : "292822002",
      "display" : "miconazol"
    },
    {
      "code" : "293524001",
      "display" : "milrinona"
    },
    {
      "code" : "418603006",
      "display" : "minociclina"
    },
    {
      "code" : "218696007",
      "display" : "miorrelajantes de acción central"
    },
    {
      "code" : "292105002",
      "display" : "misoprostol"
    },
    {
      "code" : "292220002",
      "display" : "mitomicina"
    },
    {
      "code" : "292298001",
      "display" : "moclobemida"
    },
    {
      "code" : "292793006",
      "display" : "modificador de la viscosidad derivado de la celulosa"
    },
    {
      "code" : "293026006",
      "display" : "monobactam"
    },
    {
      "code" : "293085008",
      "display" : "monosulfiram"
    },
    {
      "code" : "292942005",
      "display" : "mupirocina"
    },
    {
      "code" : "292131000",
      "display" : "nabilona"
    },
    {
      "code" : "292430008",
      "display" : "nadolol"
    },
    {
      "code" : "293562003",
      "display" : "naftidrofurilo"
    },
    {
      "code" : "292738000",
      "display" : "naloxona"
    },
    {
      "code" : "293222001",
      "display" : "nandrolona"
    },
    {
      "code" : "292810000",
      "display" : "natamicina"
    },
    {
      "code" : "292305006",
      "display" : "nefazodona"
    },
    {
      "code" : "292927007",
      "display" : "neomicina"
    },
    {
      "code" : "293398007",
      "display" : "niacinamida"
    },
    {
      "code" : "292913002",
      "display" : "niclosamida"
    },
    {
      "code" : "292451006",
      "display" : "nicotina"
    },
    {
      "code" : "293343002",
      "display" : "nicumalona"
    },
    {
      "code" : "293031008",
      "display" : "nimorazol"
    },
    {
      "code" : "292811001",
      "display" : "nistatina"
    },
    {
      "code" : "292726009",
      "display" : "nitrito de sodio"
    },
    {
      "code" : "292943000",
      "display" : "nitrofurazona"
    },
    {
      "code" : "871679007",
      "display" : "nitroprusiato"
    },
    {
      "code" : "292706005",
      "display" : "nonoxinol"
    },
    {
      "code" : "292184001",
      "display" : "oxibuprocaína"
    },
    {
      "code" : "218704008",
      "display" : "óxido nitroso"
    },
    {
      "code" : "293221008",
      "display" : "oximetolona"
    },
    {
      "code" : "871774005",
      "display" : "oxiquinolina"
    },
    {
      "code" : "871502006",
      "display" : "oxitocina y a la ergometrina"
    },
    {
      "code" : "292243006",
      "display" : "paclitaxel"
    },
    {
      "code" : "292689005",
      "display" : "pancuronio"
    },
    {
      "code" : "292701000",
      "display" : "papaverina"
    },
    {
      "code" : "292783004",
      "display" : "parafina"
    },
    {
      "code" : "292786007",
      "display" : "parafina líquida"
    },
    {
      "code" : "293242005",
      "display" : "parche de testosterona"
    },
    {
      "code" : "714137003",
      "display" : "pasta de dientes"
    },
    {
      "code" : "292411008",
      "display" : "pemolina"
    },
    {
      "code" : "292954005",
      "display" : "penicilina"
    },
    {
      "code" : "292960005",
      "display" : "penicilina procaína"
    },
    {
      "code" : "292962002",
      "display" : "penicilinas resistentes a la penicilinasa"
    },
    {
      "code" : "292046005",
      "display" : "pentazocina"
    },
    {
      "code" : "292232003",
      "display" : "pentostatina"
    },
    {
      "code" : "292868004",
      "display" : "perborato sódico"
    },
    {
      "code" : "292388005",
      "display" : "periciazina"
    },
    {
      "code" : "292870008",
      "display" : "permanganato de potasio"
    },
    {
      "code" : "292909009",
      "display" : "peróxido de hidrógeno"
    },
    {
      "code" : "292466009",
      "display" : "pilocarpina"
    },
    {
      "code" : "871565006",
      "display" : "pipacetato"
    },
    {
      "code" : "292977005",
      "display" : "piperacilina"
    },
    {
      "code" : "871576005",
      "display" : "piperidolato"
    },
    {
      "code" : "218626001",
      "display" : "pirabital"
    },
    {
      "code" : "293071003",
      "display" : "pirazinamida"
    },
    {
      "code" : "292115008",
      "display" : "pirenzepina"
    },
    {
      "code" : "292475006",
      "display" : "piridostigmina"
    },
    {
      "code" : "218621006",
      "display" : "piroxicam"
    },
    {
      "code" : "871512004",
      "display" : "pivampicilina y/o pivmecilinam"
    },
    {
      "code" : "293086009",
      "display" : "plaguicida a base de carbamato"
    },
    {
      "code" : "1184613006",
      "display" : "plasma convaleciente"
    },
    {
      "code" : "870676005",
      "display" : "plomo y/o compuesto de plomo"
    },
    {
      "code" : "293407009",
      "display" : "poliestireno sulfonato cálcico"
    },
    {
      "code" : "292597005",
      "display" : "triprolidina"
    },
    {
      "code" : "292123005",
      "display" : "trisilicato de magnesio"
    },
    {
      "code" : "292093003",
      "display" : "tuberculina"
    },
    {
      "code" : "292503000",
      "display" : "tulobuterol"
    },
    {
      "code" : "293572000",
      "display" : "urocinasa"
    },
    {
      "code" : "293105009",
      "display" : "vacuna anticarbunco"
    },
    {
      "code" : "420113004",
      "display" : "vacuna antigripal"
    },
    {
      "code" : "293117006",
      "display" : "vacuna antipoliomielítica"
    },
    {
      "code" : "219084006",
      "display" : "vacuna antitetánica"
    },
    {
      "code" : "1142181004",
      "display" : "vacuna ARNm contra COVID-19"
    },
    {
      "code" : "1162639000",
      "display" : "vacuna contra difteria, tos ferina acelular, Haemophilus influenzae tipo b, Hepatitis B, poliomielitis inactivada y tétanos"
    },
    {
      "code" : "293114004",
      "display" : "vacuna contra las paperas"
    },
    {
      "code" : "219076007",
      "display" : "vacuna frente a la tuberculosis"
    },
    {
      "code" : "1179495001",
      "display" : "vacuna que contiene antígeno de partículas pseudovirales del virus de la COVID-19"
    },
    {
      "code" : "292319006",
      "display" : "valproato sódico"
    },
    {
      "code" : "292881006",
      "display" : "vapores industriales metilados"
    },
    {
      "code" : "292691002",
      "display" : "vecuronio"
    },
    {
      "code" : "292463001",
      "display" : "verapamilo"
    },
    {
      "code" : "292326006",
      "display" : "vigabatrina"
    },
    {
      "code" : "292251009",
      "display" : "vinblastina"
    },
    {
      "code" : "292907006",
      "display" : "violeta cristal"
    },
    {
      "code" : "293386002",
      "display" : "vitamina A"
    },
    {
      "code" : "293390000",
      "display" : "vitamina hidrosoluble"
    },
    {
      "code" : "293344008",
      "display" : "warfarina"
    },
    {
      "code" : "292614006",
      "display" : "xantina"
    },
    {
      "code" : "293491002",
      "display" : "xipamida"
    },
    {
      "code" : "293379005",
      "display" : "yodopovidona"
    },
    {
      "code" : "293413000",
      "display" : "zinc tópico"
    },
    {
      "code" : "292332001",
      "display" : "zopiclona"
    }
  ]
}

```
