# Contacto para Receta Digital Costa Rica - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contacto para Receta Digital Costa Rica**

## Data Type Profile: Contacto para Receta Digital Costa Rica 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:ContactRD |
| **Copyright/Legal**: Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons | | |

 
Perfil de contacto (teléfono o email) utilizado en el contexto de la Receta Digital en Costa Rica. 

**Usages:**

* Use this DataType Profile: [Organization](StructureDefinition-organization.md), [Patient](StructureDefinition-patient.md), [Practitioner](StructureDefinition-practitioner.md) and [RelatedPerson](StructureDefinition-related-person.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/contact-rd)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-contact-rd.csv), [Excel](StructureDefinition-contact-rd.xlsx), [Schematron](StructureDefinition-contact-rd.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "contact-rd",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd",
  "version" : "1.1.0-ballot",
  "name" : "ContactRD",
  "title" : "Contacto para Receta Digital Costa Rica",
  "status" : "draft",
  "date" : "2025-10-22T15:53:28-06:00",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil de contacto (teléfono o email) utilizado en el contexto de la Receta Digital en Costa Rica.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "ContactPoint",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ContactPoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ContactPoint",
        "path" : "ContactPoint"
      },
      {
        "id" : "ContactPoint.system",
        "path" : "ContactPoint.system",
        "short" : "Tipo de contacto: phone | email.",
        "definition" : "Especifica si el contacto corresponde a un número telefónico o a una dirección de correo electrónico.",
        "comment" : "Campo obligatorio. Solo se permiten valores como 'phone' o 'email'.",
        "min" : 1
      },
      {
        "id" : "ContactPoint.value",
        "path" : "ContactPoint.value",
        "short" : "Número de teléfono o correo electrónico del paciente.",
        "definition" : "Dato de contacto que representa un número de teléfono o una dirección de correo electrónico.",
        "comment" : "Debe ser un valor válido dependiendo del tipo indicado en 'system'.",
        "min" : 1
      },
      {
        "id" : "ContactPoint.use",
        "path" : "ContactPoint.use",
        "max" : "0"
      }
    ]
  }
}

```
