# Encounter - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter**

## Resource Profile: Encounter 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:EncounterRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Encuentro Clínico (Encounter) 

**Usages:**

* Refer to this Profile: [Condition](StructureDefinition-condition.md), [MedicationStatement](StructureDefinition-medication-statement.md) and [MedicationRequest](StructureDefinition-medicationRequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-encounter.csv), [Excel](StructureDefinition-encounter.xlsx), [Schematron](StructureDefinition-encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "encounter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter",
  "version" : "1.1.0-ballot",
  "name" : "EncounterRD",
  "title" : "Encounter",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Encuentro Clínico (Encounter)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.id",
        "path" : "Encounter.id",
        "short" : "Identificador único del Encuentro dentro del sistema.",
        "definition" : "Identificador único del Encuentro dentro del sistema.",
        "comment" : "Este es el identificador único del Encuentro dentro del sistema. Se espera que el Encuentro tenga un identificador único dentro del sistema."
      },
      {
        "id" : "Encounter.meta",
        "path" : "Encounter.meta",
        "max" : "0"
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "planned | arrived | in-progress | onleave | finished | cancelled | entered-in-error | unknown",
        "definition" : "Determina el estado del encuentro remoto conforme a los códigos definidos por el estándar",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos requeridos por FHIR",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/encounterStatus"
        }
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "short" : "Clasificación del encuentro con el paciente",
        "definition" : "Clasificación del encuentro con el paciente",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/encounterClass"
        }
      },
      {
        "id" : "Encounter.class.system",
        "path" : "Encounter.class.system",
        "short" : "Sistema de clasificación del encuentro",
        "definition" : "Sistema utilizado para clasificar el tipo de encuentro clínico"
      },
      {
        "id" : "Encounter.class.code",
        "path" : "Encounter.class.code",
        "short" : "Código de clasificación del encuentro",
        "definition" : "Código que representa la clasificación del tipo de encuentro clínico",
        "min" : 1
      },
      {
        "id" : "Encounter.class.display",
        "path" : "Encounter.class.display",
        "short" : "Descripción de la clasificación del encuentro",
        "definition" : "Descripción textual que representa la clasificación del tipo de encuentro clínico"
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "Referencia al paciente del encuentro",
        "definition" : "La referencia al paciente que está presente en el encuentro clínico sobre un paciente.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.subject.reference",
        "path" : "Encounter.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente que está presente en el encuentro clínico.",
        "min" : 1
      },
      {
        "id" : "Encounter.subject.display",
        "path" : "Encounter.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente que está presente en el encuentro clínico sobre un paciente."
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "short" : "Participantes involucrados en el encuentro sin considerar al paciente",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "short" : "Referencia al individuo",
        "definition" : "Referencia al individuo que participa en el encuentro",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant.individual.reference",
        "path" : "Encounter.participant.individual.reference",
        "short" : "Referencia al participante",
        "definition" : "Referencia al recurso del participante involucrado en el encuentro clínico.",
        "min" : 1
      },
      {
        "id" : "Encounter.participant.individual.display",
        "path" : "Encounter.participant.individual.display",
        "short" : "Nombre del participante",
        "definition" : "Nombre del participante involucrado en el encuentro clínico."
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "Período de tiempo en el que se realizó el encuentro",
        "definition" : "Período de tiempo en el que se realizó el encuentro",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.period.start",
        "path" : "Encounter.period.start",
        "short" : "Fecha y hora de inicio del encuentro",
        "definition" : "Fecha y hora de inicio del encuentro",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "short" : "La organización (instalación) responsable de este encuentro",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.serviceProvider.reference",
        "path" : "Encounter.serviceProvider.reference",
        "short" : "Referencia a la organización",
        "definition" : "Referencia al recurso de la organización responsable del encuentro clínico.",
        "min" : 1
      },
      {
        "id" : "Encounter.serviceProvider.display",
        "path" : "Encounter.serviceProvider.display",
        "short" : "Nombre de la organización",
        "definition" : "Nombre de la organización responsable del encuentro clínico."
      }
    ]
  }
}

```
