# Medication - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication**

## Resource Profile: Medication 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicationRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Medicamentos (Medication) 

**Usages:**

* Refer to this Profile: [MedicationStatement](StructureDefinition-medication-statement.md), [MedicationDispense](StructureDefinition-medicationDispense.md) and [MedicationRequest](StructureDefinition-medicationRequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/medication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication.csv), [Excel](StructureDefinition-medication.xlsx), [Schematron](StructureDefinition-medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication",
  "version" : "1.1.0-ballot",
  "name" : "MedicationRD",
  "title" : "Medication",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Medicamentos (Medication)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.id",
        "path" : "Medication.id",
        "short" : "Identificador único del Medicamento dentro del sistema.",
        "definition" : "Identificador único del Medicamento dentro del sistema.",
        "comment" : "Este es el identificador único del Medicamento dentro del sistema. Se espera que el Medicamento tenga un identificador único dentro del sistema.",
        "min" : 1
      },
      {
        "id" : "Medication.meta",
        "path" : "Medication.meta",
        "max" : "0"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "short" : "Código que identifica el Medicamento",
        "definition" : "Código que representa el Medicamento",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationFormalRepresentation"
            }
          ],
          "strength" : "example",
          "description" : "Códigos estándar que identifican el Medicamento",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "Medication.code.coding",
        "path" : "Medication.code.coding",
        "short" : "Codificación del Medicamento",
        "definition" : "Codificación que describe el Medicamento",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Medication.code.coding.system",
        "path" : "Medication.code.coding.system",
        "short" : "Sistema de codificación del Medicamento",
        "definition" : "Sistema utilizado para codificar el Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.code.coding.code",
        "path" : "Medication.code.coding.code",
        "short" : "Código del Medicamento",
        "definition" : "Código que representa el Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.code.coding.display",
        "path" : "Medication.code.coding.display",
        "short" : "Descripción del Medicamento",
        "definition" : "Descripción textual del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.code.text",
        "path" : "Medication.code.text",
        "short" : "Texto del Medicamento",
        "definition" : "Representación textual del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "max" : "0"
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "short" : "Forma farmacéutica del Medicamento",
        "definition" : "Forma farmacéutica que representa el Medicamento",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/MedicationPharmaceuticalForm"
        }
      },
      {
        "id" : "Medication.form.coding",
        "path" : "Medication.form.coding",
        "short" : "Codificación de la forma farmacéutica del Medicamento",
        "definition" : "Codificación que describe la forma farmacéutica del Medicamento",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Medication.form.coding.system",
        "path" : "Medication.form.coding.system",
        "short" : "Sistema de codificación de la forma farmacéutica del Medicamento",
        "definition" : "Sistema utilizado para codificar la forma farmacéutica del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.form.coding.code",
        "path" : "Medication.form.coding.code",
        "short" : "Código de la forma farmacéutica del Medicamento",
        "definition" : "Código que representa la forma farmacéutica del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.form.coding.display",
        "path" : "Medication.form.coding.display",
        "short" : "Descripción de la forma farmacéutica del Medicamento",
        "definition" : "Descripción textual de la forma farmacéutica del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.form.text",
        "path" : "Medication.form.text",
        "short" : "Texto de la forma farmacéutica del Medicamento",
        "definition" : "Representación textual de la forma farmacéutica del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount",
        "path" : "Medication.amount",
        "short" : "Cantidad del Medicamento",
        "definition" : "Cantidad que representa el Medicamento",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Medication.amount.numerator",
        "path" : "Medication.amount.numerator",
        "short" : "Numerador de la cantidad del Medicamento",
        "definition" : "Valor numérico que representa la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount.numerator.value",
        "path" : "Medication.amount.numerator.value",
        "short" : "Valor del numerador",
        "definition" : "Valor numérico del numerador que representa la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount.numerator.comparator",
        "path" : "Medication.amount.numerator.comparator",
        "max" : "0"
      },
      {
        "id" : "Medication.amount.numerator.unit",
        "path" : "Medication.amount.numerator.unit",
        "short" : "Unidad del numerador",
        "definition" : "Unidad de medida asociada al numerador de la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount.denominator",
        "path" : "Medication.amount.denominator",
        "short" : "Denominador de la cantidad del Medicamento",
        "definition" : "Valor numérico que representa la base de la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount.denominator.value",
        "path" : "Medication.amount.denominator.value",
        "short" : "Valor del denominador",
        "definition" : "Valor numérico del denominador que representa la base de la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.amount.denominator.comparator",
        "path" : "Medication.amount.denominator.comparator",
        "max" : "0"
      },
      {
        "id" : "Medication.amount.denominator.unit",
        "path" : "Medication.amount.denominator.unit",
        "short" : "Unidad del denominador",
        "definition" : "Unidad de medida asociada al denominador de la cantidad del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "short" : "Ingredientes del Medicamento",
        "definition" : "Ingredientes que componen el Medicamento",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Medication.ingredient.item[x]",
        "path" : "Medication.ingredient.item[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept",
        "path" : "Medication.ingredient.item[x]",
        "sliceName" : "itemCodeableConcept",
        "short" : "Codificación del ingrediente del Medicamento",
        "definition" : "Codificación que describe el ingrediente del Medicamento",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/MedicationIngredient"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept.coding",
        "path" : "Medication.ingredient.item[x].coding",
        "short" : "Codificación del ingrediente del Medicamento",
        "definition" : "Codificación que describe el ingrediente del Medicamento",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept.coding.system",
        "path" : "Medication.ingredient.item[x].coding.system",
        "short" : "Sistema de codificación del ingrediente del Medicamento",
        "definition" : "Sistema utilizado para codificar el ingrediente del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept.coding.code",
        "path" : "Medication.ingredient.item[x].coding.code",
        "short" : "Código del ingrediente del Medicamento",
        "definition" : "Código que representa el ingrediente del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept.coding.display",
        "path" : "Medication.ingredient.item[x].coding.display",
        "short" : "Descripción del ingrediente del Medicamento",
        "definition" : "Descripción textual del ingrediente del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept.text",
        "path" : "Medication.ingredient.item[x].text",
        "short" : "Texto del ingrediente del Medicamento",
        "definition" : "Representación textual del ingrediente del Medicamento",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "short" : "Estado del ingrediente del Medicamento",
        "definition" : "Indica si el ingrediente del Medicamento está activo",
        "min" : 1
      }
    ]
  }
}

```
