# MedicationDispense - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationDispense**

## Resource Profile: MedicationDispense 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationDispense | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicationDispenseRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Despacho para un Medicamento (MedicationDispense) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/medicationDispense)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medicationDispense.csv), [Excel](StructureDefinition-medicationDispense.xlsx), [Schematron](StructureDefinition-medicationDispense.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medicationDispense",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationDispense",
  "version" : "1.1.0-ballot",
  "name" : "MedicationDispenseRD",
  "title" : "MedicationDispense",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Despacho para un Medicamento (MedicationDispense)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.id",
        "path" : "MedicationDispense.id",
        "short" : "Identificador único del Despacho dentro del sistema.",
        "definition" : "Identificador único del Despacho dentro del sistema.",
        "comment" : "Este es el identificador único del Despacho dentro del sistema. Se espera que el Despacho tenga un identificador único dentro del sistema."
      },
      {
        "id" : "MedicationDispense.meta",
        "path" : "MedicationDispense.meta",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.extension",
        "path" : "MedicationDispense.extension",
        "short" : "Lote de medicamento entregado",
        "definition" : "Extensión utilizada para registrar los lotes del medicamento entregado. Puede haber múltiples extensiones si se usaron varios lotes en el despacho.",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.extension.extension",
        "path" : "MedicationDispense.extension.extension",
        "short" : "Número y cantidad del lote",
        "definition" : "Contiene dos subextensiones: una para el número de lote y otra para la cantidad entregada de ese lote.",
        "min" : 2,
        "max" : "2"
      },
      {
        "id" : "MedicationDispense.extension.extension.extension",
        "path" : "MedicationDispense.extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.extension.extension.url",
        "path" : "MedicationDispense.extension.extension.url",
        "short" : "Tipo de valor registrado",
        "definition" : "Indica si la subextensión corresponde al número de lote o a la cantidad entregada del lote."
      },
      {
        "id" : "MedicationDispense.extension.extension.value[x]",
        "path" : "MedicationDispense.extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.extension.extension.value[x]:valueString",
        "path" : "MedicationDispense.extension.extension.value[x]",
        "sliceName" : "valueString",
        "short" : "Número de lote",
        "definition" : "Código o identificador del lote del medicamento entregado.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension.extension.value[x]:valueInteger",
        "path" : "MedicationDispense.extension.extension.value[x]",
        "sliceName" : "valueInteger",
        "short" : "Cantidad del lote",
        "definition" : "Cantidad del medicamento entregado correspondiente al lote identificado.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension.value[x]",
        "path" : "MedicationDispense.extension.value[x]",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "short" : "Entregada | Entregada Parcial | Rechazada",
        "definition" : "Determina el estado del despacho conforme a los códigos definidos por el estándar",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispenseStatus"
            }
          ],
          "strength" : "required",
          "description" : "Códigos requeridos por FHIR",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-status|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "short" : "Referencia al medicamento despachado",
        "definition" : "La referencia al medicamento que está asociado con el despacho.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.medication[x].reference",
        "path" : "MedicationDispense.medication[x].reference",
        "short" : "Referencia al medicamento",
        "definition" : "Referencia al recurso del medicamento asociado con el despacho.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.medication[x].display",
        "path" : "MedicationDispense.medication[x].display",
        "short" : "Nombre del medicamento",
        "definition" : "Nombre del medicamento asociado con el despacho."
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "short" : "Referencia al paciente asociado",
        "definition" : "La referencia al paciente que está asociado con el despacho.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.subject.reference",
        "path" : "MedicationDispense.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente asociado con el despacho.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.subject.display",
        "path" : "MedicationDispense.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente asociado con el despacho."
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "short" : "Referencia al profesional, institución o persona relacionada asociado",
        "definition" : "La referencia al profesional, institución o persona relacionada que se realizó el despacho.",
        "min" : 3,
        "max" : "3",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "short" : "Referencia al profesional, institución o persona relacionada asociado",
        "definition" : "La referencia al profesional, institución o persona relacionada que está asociado con el despacho.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/related-person"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.performer.actor.reference",
        "path" : "MedicationDispense.performer.actor.reference",
        "short" : "Referencia al profesional, institución o persona relacionada",
        "definition" : "Referencia al recurso del profesional, institución o persona relacionada asociado con el despacho.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.performer.actor.display",
        "path" : "MedicationDispense.performer.actor.display",
        "short" : "Nombre del profesional, institución o persona relacionada",
        "definition" : "Nombre del profesional, institución o persona relacionada asociado con el despacho.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "short" : "Referencia a la prescripción",
        "definition" : "Referencia al recurso de la prescripción (MedicationRequest) que autoriza este despacho.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.authorizingPrescription.reference",
        "path" : "MedicationDispense.authorizingPrescription.reference",
        "short" : "Referencia a la prescripción",
        "definition" : "Referencia al recurso MedicationRequest relacionado con este despacho.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.authorizingPrescription.display",
        "path" : "MedicationDispense.authorizingPrescription.display",
        "short" : "Resumen de la prescripción",
        "definition" : "Resumen o nombre descriptivo de la prescripción asociada al despacho."
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "short" : "Cantidad despachada",
        "definition" : "Cantidad total del medicamento que fue entregado al paciente en esta dispensación.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.quantity.value",
        "path" : "MedicationDispense.quantity.value",
        "short" : "Valor numérico de la cantidad",
        "definition" : "Número que representa la cantidad del medicamento despachado",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.quantity.unit",
        "path" : "MedicationDispense.quantity.unit",
        "short" : "Unidad de medida",
        "definition" : "Unidad en la que se expresa la cantidad del medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.daysSupply",
        "path" : "MedicationDispense.daysSupply",
        "short" : "Duración del tratamiento",
        "definition" : "Número estimado de días para los que alcanza el medicamento al paciente.",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.daysSupply.value",
        "path" : "MedicationDispense.daysSupply.value",
        "short" : "Número de días",
        "definition" : "Cantidad de días que cubre el tratamiento con la dosis.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.daysSupply.unit",
        "path" : "MedicationDispense.daysSupply.unit",
        "short" : "Unidad de tiempo",
        "definition" : "Unidad de medida de tiempo utilizada",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "path" : "MedicationDispense.whenHandedOver",
        "short" : "Fecha de entrega",
        "definition" : "Fecha en la que se entregó el medicamento al paciente durante esta dispensación.",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "short" : "Instrucciones de administración entregadas",
        "definition" : "Instrucciones detalladas sobre cómo debe administrarse el medicamento entregado al paciente",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.text",
        "path" : "MedicationDispense.dosageInstruction.text",
        "short" : "Descripción libre de las instrucciones entregadas",
        "definition" : "Texto en lenguaje natural que describe cómo debe administrarse el medicamento según lo entregado"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing",
        "path" : "MedicationDispense.dosageInstruction.timing",
        "short" : "Frecuencia y momento de administración entregada",
        "definition" : "Define con qué frecuencia y en qué momento del día debe administrarse el medicamento entregado",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat",
        "short" : "Patrón de administración indicado",
        "definition" : "Especificación del intervalo de administración del medicamento tal como fue indicado en el despacho",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.duration",
        "short" : "Duración de cada toma",
        "definition" : "Tiempo estimado de duración de cada administración del medicamento entregado",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.durationUnit",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.durationUnit",
        "short" : "Unidad de duración",
        "definition" : "Unidad de medida para la duración de cada toma del medicamento entregado",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.frequency",
        "short" : "Frecuencia de administración",
        "definition" : "Número de veces que se espera que el medicamento entregado sea administrado en un período",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.period",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.period",
        "short" : "Período entre tomas",
        "definition" : "Intervalo de tiempo entre cada administración del medicamento entregado"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.periodUnit",
        "short" : "Unidad de período",
        "definition" : "Unidad de tiempo que define el intervalo entre tomas del medicamento entregado",
        "fixedCode" : "d"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route",
        "path" : "MedicationDispense.dosageInstruction.route",
        "short" : "Vía de administración",
        "definition" : "Ruta por la cual debe administrarse el medicamento que fue entregado al paciente",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que representan la vía de administración del medicamento entregado",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/MedicationAdministrationLine"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.coding",
        "path" : "MedicationDispense.dosageInstruction.route.coding",
        "short" : "Codificación de la vía de administración",
        "definition" : "Código estándar que representa la vía por la cual se debe administrar el medicamento entregado",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.coding.system",
        "path" : "MedicationDispense.dosageInstruction.route.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema que define los códigos para la vía de administración (ej. SNOMED CT)"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.coding.code",
        "path" : "MedicationDispense.dosageInstruction.route.coding.code",
        "short" : "Código de la vía",
        "definition" : "Código que representa una vía de administración específica para el medicamento entregado",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.coding.display",
        "path" : "MedicationDispense.dosageInstruction.route.coding.display",
        "short" : "Descripción de la vía",
        "definition" : "Nombre o descripción legible de la vía de administración del medicamento entregado"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.text",
        "path" : "MedicationDispense.dosageInstruction.route.text",
        "short" : "Texto de la vía",
        "definition" : "Representación textual de la vía de administración del medicamento entregado"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate",
        "short" : "Dosis y velocidad administradas",
        "definition" : "Información sobre la dosis que debe administrarse del medicamento entregado y la velocidad si aplica",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]:doseQuantity",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "short" : "Cantidad por toma",
        "definition" : "Cantidad específica de medicamento entregado que debe administrarse en cada toma",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]:doseQuantity.value",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x].value",
        "short" : "Valor numérico de la dosis",
        "definition" : "Cantidad numérica de medicamento que fue entregado por toma",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]:doseQuantity.unit",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x].unit",
        "short" : "Unidad de dosis",
        "definition" : "Unidad de medida en la que se expresa la dosis del medicamento entregado (ej. comprimido(s), cápsula(s))",
        "min" : 1
      }
    ]
  }
}

```
