# MedicationRequest - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest**

## Resource Profile: MedicationRequest 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationRequest | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:MedicationRequestRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Prescripción para un Medicamento (MedicationRequest) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/medicationRequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medicationRequest.csv), [Excel](StructureDefinition-medicationRequest.xlsx), [Schematron](StructureDefinition-medicationRequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medicationRequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationRequest",
  "version" : "1.1.0-ballot",
  "name" : "MedicationRequestRD",
  "title" : "MedicationRequest",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Prescripción para un Medicamento (MedicationRequest)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.id",
        "path" : "MedicationRequest.id",
        "short" : "Identificador único de la Prescripción dentro del sistema.",
        "definition" : "Identificador único de la Prescripción dentro del sistema.",
        "comment" : "Este es el identificador único de la Prescripción dentro del sistema. Se espera que la Prescripción tenga un identificador único dentro del sistema."
      },
      {
        "id" : "MedicationRequest.meta",
        "path" : "MedicationRequest.meta",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "short" : "En Proceso | Creada | Consultada en Farmacia | Validada | Validada Parcial | Preparada | Preparada Parcial | Anulada | Expirada | Temporal sin firmar | Cerrada",
        "definition" : "Determina el estado de la prescripción conforme a los códigos definidos por el estándar",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestStatus"
            }
          ],
          "strength" : "required",
          "description" : "Códigos requeridos por FHIR",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-status|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "short" : "order",
        "definition" : "Indica la intención que tiene el autor clínico al emitir esta prescripción",
        "fixedCode" : "order",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestIntent"
            }
          ],
          "strength" : "required",
          "description" : "Códigos requeridos por FHIR",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-intent|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.category",
        "path" : "MedicationRequest.category",
        "short" : "Categoría de la prescripción: empirica | por_cultivo | profilaxis_quiru | profilaxis_medic",
        "definition" : "Clasificación de la prescripción médica según el entorno en el que se genera.",
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que describen la categoría o entorno clínico en el que se realiza la prescripción.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/PrescriptionCategory"
        }
      },
      {
        "id" : "MedicationRequest.category.coding",
        "path" : "MedicationRequest.category.coding",
        "short" : "Codificación de la categoría de la prescripción",
        "definition" : "Codificación que indica el entorno clínico en el que se realiza la prescripción",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.category.coding.system",
        "path" : "MedicationRequest.category.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema utilizado para codificar la categoría de la prescripción"
      },
      {
        "id" : "MedicationRequest.category.coding.code",
        "path" : "MedicationRequest.category.coding.code",
        "short" : "Código de la categoría",
        "definition" : "Código que representa la categoría de la prescripción médica",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.category.coding.display",
        "path" : "MedicationRequest.category.coding.display",
        "short" : "Descripción de la categoría",
        "definition" : "Texto legible que describe la categoría de la prescripción"
      },
      {
        "id" : "MedicationRequest.category.text",
        "path" : "MedicationRequest.category.text",
        "short" : "Texto de la categoría",
        "definition" : "Descripción textual del entorno clínico de la prescripción"
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "path" : "MedicationRequest.doNotPerform",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "short" : "Referencia al medicamento asociado",
        "definition" : "La referencia al medicamento que está asociado con la prescripción.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x].reference",
        "path" : "MedicationRequest.medication[x].reference",
        "short" : "Referencia al medicamento",
        "definition" : "Referencia al recurso del medicamento asociado con la prescripción.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.medication[x].display",
        "path" : "MedicationRequest.medication[x].display",
        "short" : "Nombre del medicamento",
        "definition" : "Nombre del medicamento asociado con la prescripción."
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "short" : "Referencia al paciente asociado",
        "definition" : "La referencia al paciente que está asociado con la prescripción.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.subject.reference",
        "path" : "MedicationRequest.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Referencia al recurso del paciente asociado con la prescripción.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.subject.display",
        "path" : "MedicationRequest.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente asociado con la prescripción."
      },
      {
        "id" : "MedicationRequest.encounter",
        "path" : "MedicationRequest.encounter",
        "short" : "Referencia al encuentro asociado",
        "definition" : "La referencia al encuentro asociado la prescripción.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.encounter.reference",
        "path" : "MedicationRequest.encounter.reference",
        "short" : "Referencia al encuentro",
        "definition" : "Referencia al recurso del encuentro asociado a la prescripción.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.encounter.display",
        "path" : "MedicationRequest.encounter.display",
        "short" : "Descripción del encuentro",
        "definition" : "Descripción del encuentro asociado a la prescripción."
      },
      {
        "id" : "MedicationRequest.supportingInformation",
        "path" : "MedicationRequest.supportingInformation",
        "short" : "Información clínica de respaldo",
        "definition" : "Información relevante que respalda la decisión clínica de prescribir el medicamento",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/allergy-intolerance",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-cultive",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-frotis",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-gram-negative",
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-gram-positive"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.supportingInformation.reference",
        "path" : "MedicationRequest.supportingInformation.reference",
        "short" : "Referencia al recurso clínico",
        "definition" : "Referencia directa a un recurso clínico relacionado con la prescripción, como una alergia o un cultivo",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.supportingInformation.display",
        "path" : "MedicationRequest.supportingInformation.display",
        "short" : "Descripción del recurso",
        "definition" : "Texto legible que describe el recurso de información clínica de respaldo"
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "short" : "Fecha y hora que se realizó",
        "definition" : "Fecha y hora que representa cuándo se hizo la prescripción",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "short" : "Referencia al profesional asociado",
        "definition" : "La referencia al profesional que realizó la prescripción.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester.reference",
        "path" : "MedicationRequest.requester.reference",
        "short" : "Referencia al profesional",
        "definition" : "Referencia al recurso del profesional que realizó la prescripción.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.requester.display",
        "path" : "MedicationRequest.requester.display",
        "short" : "Nombre del profesional",
        "definition" : "Nombre del profesional que realizó la prescripción."
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "path" : "MedicationRequest.reasonReference",
        "short" : "Referencia a la condición asociado",
        "definition" : "La referencia a la condición asociada la prescripción.",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/condition"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.reasonReference.reference",
        "path" : "MedicationRequest.reasonReference.reference",
        "short" : "Referencia a la condición",
        "definition" : "Referencia al recurso de la condición asociada a la prescripción.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.reasonReference.display",
        "path" : "MedicationRequest.reasonReference.display",
        "short" : "Descripción de la condición",
        "definition" : "Descripción de la condición asociada a la prescripción."
      },
      {
        "id" : "MedicationRequest.groupIdentifier",
        "path" : "MedicationRequest.groupIdentifier",
        "short" : "Identificador único del grupo de prescripciones",
        "definition" : "Identificador utilizado para agrupar un conjunto de prescripciones relacionadas entre sí"
      },
      {
        "id" : "MedicationRequest.groupIdentifier.use",
        "path" : "MedicationRequest.groupIdentifier.use",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.groupIdentifier.value",
        "path" : "MedicationRequest.groupIdentifier.value",
        "short" : "Valor del identificador de grupo",
        "definition" : "Valor único que identifica el grupo al que pertenece esta prescripción",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.note",
        "path" : "MedicationRequest.note",
        "short" : "Indicaciones adicionales",
        "definition" : "Indicaciones adicionales para la prescripción",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.note.text",
        "path" : "MedicationRequest.note.text",
        "short" : "Indicaciones adicionales",
        "definition" : "Texto donde se encuentra las indicaciones adicionales de una prescripción puestas por el medico."
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "Instrucciones de dosificación",
        "definition" : "Instrucciones detalladas sobre cómo debe administrarse el medicamento al paciente",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "short" : "Descripción libre de las instrucciones",
        "definition" : "Texto que describe en lenguaje natural cómo se debe administrar el medicamento"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "short" : "Frecuencia y momento de la administración",
        "definition" : "Define con qué frecuencia y en qué momento del día debe administrarse el medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat",
        "short" : "Patrón repetitivo de administración",
        "definition" : "Especificación detallada del intervalo de administración del medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "short" : "Duración de cada toma",
        "definition" : "Tiempo que debe durar cada administración del medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.durationUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.durationUnit",
        "short" : "Unidad de duración",
        "definition" : "Unidad de medida para la duración de la toma (ej. d, wk)",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "Frecuencia de administración",
        "definition" : "Número de veces que el medicamento debe ser administrado en un período definido",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "short" : "Período entre tomas",
        "definition" : "Cantidad de tiempo que debe transcurrir entre cada toma del medicamento"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "Unidad del período entre tomas",
        "definition" : "Unidad de tiempo que define el intervalo entre tomas, como días (#d)",
        "fixedCode" : "d"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "short" : "Vía de administración",
        "definition" : "Ruta por la cual se administra el medicamento, como ET, ID, IS, etc.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "Códigos estándar que representan la vía de administración del medicamento",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/MedicationAdministrationLine"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding",
        "path" : "MedicationRequest.dosageInstruction.route.coding",
        "short" : "Codificación de la vía de administración",
        "definition" : "Codificación estándar que representa la ruta de administración del medicamento",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding.system",
        "path" : "MedicationRequest.dosageInstruction.route.coding.system",
        "short" : "Sistema de codificación",
        "definition" : "Sistema que define los códigos de la vía de administración (ej. SNOMED CT)"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding.code",
        "path" : "MedicationRequest.dosageInstruction.route.coding.code",
        "short" : "Código de la vía",
        "definition" : "Código que representa una vía de administración específica",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.coding.display",
        "path" : "MedicationRequest.dosageInstruction.route.coding.display",
        "short" : "Descripción de la vía",
        "definition" : "Nombre legible o descripción de la vía de administración"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.text",
        "path" : "MedicationRequest.dosageInstruction.route.text",
        "short" : "Texto de la vía",
        "definition" : "Representación textual de la vía de administración"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "short" : "Dosis y velocidad",
        "definition" : "Información sobre la dosis que debe administrarse y la velocidad si aplica",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseQuantity",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "short" : "Cantidad de medicamento por dosis",
        "definition" : "Cantidad específica de medicamento que debe administrarse en cada toma",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseQuantity.value",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].value",
        "short" : "Valor numérico de la dosis",
        "definition" : "Cantidad numérica que representa la dosis del medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseQuantity.unit",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].unit",
        "short" : "Unidad de medida de la dosis",
        "definition" : "Unidad de medida en la que se expresa la dosis (ej. comprimido(s), cápsula(s))",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "short" : "Instrucciones de dispensación",
        "definition" : "Información sobre cómo debe dispensarse el medicamento al paciente",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod",
        "path" : "MedicationRequest.dispenseRequest.validityPeriod",
        "short" : "Periodo de validez de la receta",
        "definition" : "Rango de fechas durante el cual se puede dispensar el medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod.start",
        "path" : "MedicationRequest.dispenseRequest.validityPeriod.start",
        "short" : "Fecha de inicio de validez",
        "definition" : "Fecha a partir de la cual la receta es válida para ser dispensada",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod.end",
        "path" : "MedicationRequest.dispenseRequest.validityPeriod.end",
        "short" : "Fecha de fin de validez",
        "definition" : "Última fecha en la que la receta puede ser usada para la dispensación del medicamento"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "path" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "short" : "Número de repeticiones permitidas",
        "definition" : "Número de veces que se puede repetir la dispensación del medicamento, excluyendo la dispensación original",
        "patternUnsignedInt" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "short" : "Cantidad total a dispensar",
        "definition" : "Cantidad total del medicamento que debe ser dispensada durante la validez de la receta",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.value",
        "path" : "MedicationRequest.dispenseRequest.quantity.value",
        "short" : "Cantidad numérica del medicamento",
        "definition" : "Valor numérico que representa la cantidad del medicamento a dispensar"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.unit",
        "path" : "MedicationRequest.dispenseRequest.quantity.unit",
        "short" : "Unidad de la cantidad",
        "definition" : "Unidad de medida correspondiente a la cantidad de medicamento a dispensar (por ejemplo, tabletas, ml)",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "short" : "Duración esperada del suministro",
        "definition" : "Tiempo estimado que debe durar el suministro dispensado"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "short" : "Duración numérica del suministro",
        "definition" : "Valor numérico que representa cuántos días debe durar el suministro del medicamento",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.comparator",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.comparator",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.unit",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.unit",
        "short" : "Unidad de duración",
        "definition" : "Unidad de tiempo esperada para el suministro (por ejemplo, días)",
        "min" : 1,
        "fixedString" : "days"
      }
    ]
  }
}

```
