# Observation (Talla) - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation (Talla)**

## Resource Profile: Observation (Talla) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-height | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:ObservationHeightRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Observaciones de Talla (Observation) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/observation-height)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-observation-height.csv), [Excel](StructureDefinition-observation-height.xlsx), [Schematron](StructureDefinition-observation-height.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "observation-height",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-height",
  "version" : "1.1.0-ballot",
  "name" : "ObservationHeightRD",
  "title" : "Observation (Talla)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Observaciones de Talla (Observation)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "short" : "Identificador único del recurso Observation.",
        "definition" : "Identificador único que representa esta instancia de observación en el sistema.",
        "comment" : "Este campo identifica de forma única la observación dentro del sistema, permitiendo su rastreo o referencia.",
        "min" : 1
      },
      {
        "id" : "Observation.meta",
        "path" : "Observation.meta",
        "max" : "0"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "Estado de la observación. Solo se permite 'final'.",
        "definition" : "Define el estado clínico de la observación. En este perfil, el único valor permitido es 'final'.",
        "comment" : "El valor 'final' indica que la observación está completa, revisada y no será modificada.",
        "fixedCode" : "final"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "short" : "Categoría: signos vitales.",
        "definition" : "Clasificación de la observación como parte de los signos vitales del paciente (por ejemplo, peso, altura, presión arterial).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Conjunto de códigos que representan categorías válidas para observaciones clínicas, como signos vitales o laboratorio.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/snomed"
        }
      },
      {
        "id" : "Observation.category.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.category.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "Sistema de codificación de la categoría.",
        "definition" : "URI del sistema que define las categorías válidas para observaciones clínicas."
      },
      {
        "id" : "Observation.category.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "Código de la categoría de observación.",
        "definition" : "Código que representa la categoría 'signos vitales' dentro de las observaciones clínicas.",
        "min" : 1,
        "fixedCode" : "61746007"
      },
      {
        "id" : "Observation.category.coding.display",
        "path" : "Observation.category.coding.display",
        "short" : "Descripción de la categoría.",
        "definition" : "Nombre o descripción legible de la categoría, como 'Signos vitales'."
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Tipo de observación: talla del paciente.",
        "definition" : "Código que indica que la observación corresponde a la talla (altura) del paciente.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/snomed"
        }
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.code.coding.system",
        "path" : "Observation.code.coding.system",
        "short" : "Sistema de codificación utilizado.",
        "definition" : "URI del sistema de codificación, como SNOMED CT."
      },
      {
        "id" : "Observation.code.coding.code",
        "path" : "Observation.code.coding.code",
        "short" : "Código del tipo de observación.",
        "definition" : "Código que representa la observación de talla del paciente.",
        "min" : 1,
        "fixedCode" : "1153637007"
      },
      {
        "id" : "Observation.code.coding.display",
        "path" : "Observation.code.coding.display",
        "short" : "Nombre del tipo de observación.",
        "definition" : "Nombre legible asociado al código, como 'Body height'."
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "short" : "Descripción textual del tipo de observación.",
        "definition" : "Nombre o descripción textual de la observación, útil para mostrar al usuario."
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "Paciente al que corresponde la observación.",
        "definition" : "Referencia al paciente del cual se obtuvo la muestra para esta observación.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject.reference",
        "path" : "Observation.subject.reference",
        "short" : "Referencia al paciente",
        "definition" : "Enlace al recurso del paciente relacionado con la observación.",
        "min" : 1
      },
      {
        "id" : "Observation.subject.display",
        "path" : "Observation.subject.display",
        "short" : "Nombre del paciente",
        "definition" : "Nombre del paciente al que se asocia la observación."
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "short" : "Fecha y hora de efectividad",
        "definition" : "Fecha y hora que representa cuándo la observación es efectiva",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "Talla en centímetros",
        "definition" : "Altura del paciente registrada durante la observación clínica. La unidad debe ser una unidad válida como 'cm'.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity.value",
        "path" : "Observation.value[x].value",
        "short" : "Valor numérico de la talla",
        "definition" : "Número que representa la altura del paciente.",
        "min" : 1
      },
      {
        "id" : "Observation.value[x]:valueQuantity.unit",
        "path" : "Observation.value[x].unit",
        "short" : "Unidad de altura (ej. cm)",
        "definition" : "Unidad de medida de la talla, como 'cm' para centímetros, según el sistema UCUM.",
        "min" : 1,
        "fixedString" : "cm"
      }
    ]
  }
}

```
