# Practitioner - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner**

## Resource Profile: Practitioner 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PractitionerRD |
| **Copyright/Legal**: Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional. | | |

 
Perfil Receta Digital de Profesional de Salud (Practitioner) 

**Usages:**

* Refer to this Profile: [AllergyIntolerance](StructureDefinition-allergy-intolerance.md), [Condition](StructureDefinition-condition.md), [Encounter](StructureDefinition-encounter.md), [MedicationDispense](StructureDefinition-medicationDispense.md)...Show 2 more,[MedicationRequest](StructureDefinition-medicationRequest.md)and[Patient](StructureDefinition-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitioner.csv), [Excel](StructureDefinition-practitioner.xlsx), [Schematron](StructureDefinition-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner",
  "version" : "1.1.0-ballot",
  "name" : "PractitionerRD",
  "title" : "Practitioner",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-03-03",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Perfil Receta Digital de Profesional de Salud (Practitioner)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.id",
        "path" : "Practitioner.id",
        "short" : "Identificador único del Profesional dentro del sistema.",
        "definition" : "Identificador único del Profesional de Salud dentro del sistema.",
        "comment" : "Este es el identificador único del Profesional dentro del sistema. Se espera que el Profesional de Salud tenga un identificador único en el sistema."
      },
      {
        "id" : "Practitioner.meta",
        "path" : "Practitioner.meta",
        "max" : "0"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "short" : "Lista de los identificadores del Profesional de Salud.",
        "definition" : "Este es el listado de identificaciones del Profesional de Salud.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier.use",
        "path" : "Practitioner.identifier.use",
        "fixedCode" : "official"
      },
      {
        "id" : "Practitioner.identifier.type",
        "path" : "Practitioner.identifier.type",
        "short" : "Tipo de documento de identificación (Extensible)",
        "definition" : "Tipo de documento de identificación aplicable a profesionales de salud según el sistema nacional.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "ValueSet de tipos de identificación permitidos para profesionales de salud en Costa Rica.",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/idTypes"
        }
      },
      {
        "id" : "Practitioner.identifier.type.coding",
        "path" : "Practitioner.identifier.type.coding",
        "short" : "Código del tipo de identificación del Profesional.",
        "definition" : "Código del tipo de identificación del Profesional de Salud.",
        "comment" : "Código del tipo de identificación del Profesional.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Practitioner.identifier.type.coding.system",
        "path" : "Practitioner.identifier.type.coding.system",
        "short" : "Sistema de identificación del Profesional.",
        "definition" : "Sistema de identificación del Profesional.",
        "comment" : "Sistema de identificación del Profesional."
      },
      {
        "id" : "Practitioner.identifier.type.coding.code",
        "path" : "Practitioner.identifier.type.coding.code",
        "short" : "Código del tipo de identificación del Profesional.",
        "definition" : "Código del tipo de identificación del Profesional.",
        "comment" : "Código del tipo de identificación del Profesional.",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier.type.coding.display",
        "path" : "Practitioner.identifier.type.coding.display",
        "short" : "Descripción del código de tipo de identificación del Profesional.",
        "definition" : "Descripción del código de tipo de identificación del Profesional.",
        "comment" : "Descripción del código de tipo de identificación del Profesional."
      },
      {
        "id" : "Practitioner.identifier.type.text",
        "path" : "Practitioner.identifier.type.text",
        "short" : "Nombre del valor de tipo de identificación del Profesional.",
        "definition" : "Nombre del valor de tipo de identificación del Profesional.",
        "comment" : "Nombre del valor de tipo de identificación del Profesional."
      },
      {
        "id" : "Practitioner.identifier.system",
        "path" : "Practitioner.identifier.system",
        "short" : "Sistema de identificación del Profesional.",
        "definition" : "Sistema de identificación del Profesional.",
        "comment" : "Sistema de identificación del Profesional."
      },
      {
        "id" : "Practitioner.identifier.value",
        "path" : "Practitioner.identifier.value",
        "short" : "Número de identificación del Profesional o número de documento.",
        "definition" : "Número de identificación del Profesional o número de documento.",
        "comment" : "Número de identificación del Profesional o número de documento.",
        "min" : 1
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "Nombre del Profesional de Salud.",
        "definition" : "Nombre del Profesional de Salud.",
        "comment" : "Es un elemento clave para la identificación inicial. En Costa Rica, los nombres tienen alta especificidad (dos apellidos), lo que aumenta la precisión del matching.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.use",
        "path" : "Practitioner.name.use",
        "max" : "0"
      },
      {
        "id" : "Practitioner.name.text",
        "path" : "Practitioner.name.text",
        "short" : "Nombre completo del Profesional.",
        "definition" : "Nombre completo del Profesional.",
        "comment" : "Se espera que el Profesional tenga al menos un nombre y un apellido.",
        "min" : 1
      },
      {
        "id" : "Practitioner.name.family",
        "path" : "Practitioner.name.family",
        "short" : "Apellidos del Profesional.",
        "definition" : "Apellidos del Profesional.",
        "min" : 1
      },
      {
        "id" : "Practitioner.name.given",
        "path" : "Practitioner.name.given",
        "short" : "Nombres del Profesional.",
        "definition" : "Nombres del Profesional.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "short" : "Medios de contacto del Profesional (teléfono, email, etc.).",
        "definition" : "Detalles de contacto del Profesional, como teléfono o correo electrónico.",
        "min" : 1,
        "max" : "2",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/contact-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "short" : "Dirección física del Profesional de Salud.",
        "definition" : "Dirección física donde se encuentra o reside el Profesional.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/address-rd"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.gender",
        "path" : "Practitioner.gender",
        "short" : "Género con el que el Profesional se identifica. (male | female)",
        "definition" : "Género del Profesional para fines administrativos, puede ser distinto al sexo biológico.",
        "min" : 1
      },
      {
        "id" : "Practitioner.birthDate",
        "path" : "Practitioner.birthDate",
        "short" : "Fecha de nacimiento del Profesional.",
        "definition" : "Fecha de nacimiento del Profesional de Salud.",
        "comment" : "Dato relevante para procesos de autenticación o para evitar colisiones entre registros similares.",
        "min" : 1
      }
    ]
  }
}

```
