# Tipo de receta - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Tipo de receta**

## Extension: Tipo de receta 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type | *Version*:1.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PrescriptionTypeExtension |
| **Copyright/Legal**: Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons | | |

Clasificación de la receta según el régimen correspondiente (por ejemplo, r-a, r-v, r-b, r-am, ATM)

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md), [Bundle/BundleRD03](Bundle-BundleRD03.md), [MedicationRequest/2360448](MedicationRequest-2360448.md)...Show 2 more,[MedicationRequest/2369982](MedicationRequest-2369982.md)and[MedicationRequest/2377815](MedicationRequest-2377815.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cr.minsa.sard|current/StructureDefinition/prescription-type)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-prescription-type.csv), [Excel](StructureDefinition-prescription-type.xlsx), [Schematron](StructureDefinition-prescription-type.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "prescription-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard"
          }
        ]
      }
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type",
  "version" : "1.1.0-ballot",
  "name" : "PrescriptionTypeExtension",
  "title" : "Tipo de receta",
  "status" : "draft",
  "date" : "2025-10-22T15:53:28-06:00",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "description" : "Clasificación de la receta según el régimen correspondiente (por ejemplo, r-a, r-v, r-b, r-am, ATM)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Tipo de receta",
        "definition" : "Clasificación de la receta según el régimen correspondiente (por ejemplo, r-a, r-v, r-b, r-am, ATM)"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/prescription-type"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Código del tipo de receta",
        "definition" : "Código que identifica el tipo de receta emitida según su categoría (r-a, r-v, r-b, r-am, ATM)",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ministeriodesalud.go.cr/fhir/receta/ValueSet/PrescriptionType"
        }
      }
    ]
  }
}

```
