# Inicio - Guías de Implementación FHIR Receta Digital | Ministerio de Salud v1.1.0-ballot

* [**Table of Contents**](toc.md)
* **Inicio**

## Inicio

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard | *Version*:1.1.0-ballot | |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:RecetaDigitalCR |
| **Copyright/Legal**: Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons | | |

### Descargo de Responsabilidad

Las guías de implementación que se presentan a continuación **son un diseño inicial y no constituyen una versión definitiva**. Se han elaborado con la mayor diligencia posible, pero es posible que contengan errores o inexactitudes. Se advierte a los usuarios que no deben basarse únicamente en estas guías para tomar decisiones. Es importante consultar con un profesional calificado para obtener asesoramiento específico sobre la implementación de las guías. Los autores de las guías no asume ninguna responsabilidad por cualquier pérdida o daño que pueda surgir del uso de las guías.

Estas guías de implementación siguen el formato indicado para la **versión FHIR R4** y se presenta en varias secciones que proporciona información general y la explicación técnica de los **Artefactos**.

### Como leer estas Guías

Algunos perfiles podrían ser la fundación para futuras guías de implementación nacionales (registro de pacientes, establecimientos y profesionales), y fueron producidos en colaboración entre el Ministerio de Salud de Costa Rica y RACSA. 

### Perfiles de la Guía

* [Alergias e Intolerancias](StructureDefinition-allergy-intolerance.md)
* [Condiciones o Diagnósticos](StructureDefinition-condition.md)
* [Encuentro Clínico](StructureDefinition-encounter.md)
* [Medicamentos](StructureDefinition-medication.md)
* [Despacho para un Medicamento](StructureDefinition-medicationDispense.md)
* [Prescripción para un Medicamento](StructureDefinition-medicationRequest.md)
* [Declaración de Medicación](StructureDefinition-medication-statement.md)
* [Observaciones de análisis microbiológico tipo cultivo](StructureDefinition-observation-cultive.md)
* [Observaciones de análisis microbiológico tipo frotis](StructureDefinition-observation-frotis.md)
* [Observaciones de análisis microbiológico tipo gram negativo](StructureDefinition-observation-gram-negative.md)
* [Observaciones de análisis microbiológico tipo gram positivo](StructureDefinition-observation-gram-positive.md)
* [Observaciones de Peso](StructureDefinition-observation-weight.md)
* [Observaciones de Talla](StructureDefinition-observation-height.md)
* [Organizaciones](StructureDefinition-organization.md)
* [Paquete de Recursos](StructureDefinition-bundle.md)
* [Paciente](StructureDefinition-patient.md)
* [Profesional de Salud](StructureDefinition-practitioner.md)
* [Persona Relacionada](StructureDefinition-related-person.md)

### Requerimientos de Conformidad

Los requerimientos de conformidad describen las expectativas sobre la funcionalidad de las aplicaciones servidor/cliente, identificando los perfiles específicos y las interacciones que deben implementar. Los perfiles individuales identifican los requerimientos estructurales y terminológicos. Las definiciones de parámetros de búsqueda y operaciones especifican cómo son implementados por los servidores.

### Análisis de Versiones Cruzadas

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cr.minsa.sard.r4)](package.r4.tgz) and [R4B (hl7.fhir.cr.minsa.sard.r4b)](package.r4b.tgz) are available.

### Tabla de Dependencia



### Tabla de Globales

*There are no Global profiles defined*

### Declaraciones de Propiedad Intelectual

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AddressRD](StructureDefinition-address-rd.md), [AdministrationLinesCode](CodeSystem-administration-lines-code.md)...Show 101 more,[AllergyCategoriesCode](CodeSystem-allergy-categories-code.md),[AllergyCategory](ValueSet-allergyCategory.md),[AllergyCriticalitiesCode](CodeSystem-allergy-criticalities-code.md),[AllergyCriticality](ValueSet-AllergyCriticality.md),[AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md),[AllergyStatus](ValueSet-AllergyStatus.md),[AllergyStatusesCode](CodeSystem-allergy-statuses-code.md),[AllergyType](ValueSet-AllergyType.md),[AllergyTypesCode](CodeSystem-allergy-types-code.md),[AllergyVerification](ValueSet-AllergyVerification.md),[AllergyVerificationsCode](CodeSystem-allergy-verifications-code.md),[AnalysisFamilyCode](CodeSystem-analysis-family-code.md),[AnalysisTypesCode](CodeSystem-analysis-types-code.md),[AntibioticSensitivityGramNegative](ValueSet-AntibioticSensitivityGramNegative.md),[AntibioticSensitivityGramNegativesCode](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md),[AntibioticSensitivityGramPositive](ValueSet-AntibioticSensitivityGramPositive.md),[AntibioticSensitivityGramPositivesCode](CodeSystem-antibiotic-sensitivity-gram-positives-code.md),[BundleRD](StructureDefinition-bundle.md),[CitiesCode](CodeSystem-cities-code.md),[City](ValueSet-City.md),[ConditionCategoriesCode](CodeSystem-condition-categories-code.md),[ConditionCategory](ValueSet-conditionCategory.md),[ConditionDiagnostic](ValueSet-conditionDiagnostic.md),[ConditionDiagnosticsCode](CodeSystem-condition-diagnostics-code.md),[ConditionRD](StructureDefinition-condition.md),[ConditionStatus](ValueSet-conditionStatus.md),[ConditionStatusesCode](CodeSystem-condition-statuses-code.md),[ContactRD](StructureDefinition-contact-rd.md),[DespatchAdministrationUnit](ValueSet-DespatchAdministrationUnit.md),[DespatchAdministrationUnitCode](CodeSystem-despatch-administration-unit-code.md),[DispenseStatus](ValueSet-DispenseStatus.md),[DispenseStatusCode](CodeSystem-dispense-status-code.md),[District](ValueSet-District.md),[DistrictsCode](CodeSystem-districts-code.md),[DoseSuggestion](ValueSet-DoseSuggestion.md),[DoseSuggestionsCode](CodeSystem-dose-suggestions-code.md),[DrugsCompoundCode](CodeSystem-drugs-compound-code.md),[DrugsPresentationCode](CodeSystem-drugs-presentation-code.md),[EncounterClass](ValueSet-encounterClass.md),[EncounterClassCode](CodeSystem-encounter-class-code.md),[EncounterRD](StructureDefinition-encounter.md),[EncounterStatus](ValueSet-encounterStatus.md),[EncounterStatusCode](CodeSystem-encounter-status-code.md),[Frequency](ValueSet-Frequency.md),[FrequencyCode](CodeSystem-frequency-code.md),[FrequencyDuration](ValueSet-FrequencyDuration.md),[FrequencyDurationCode](CodeSystem-frequency-duration-code.md),[FrequencyType](ValueSet-FrequencyType.md),[FrequencyTypeCode](CodeSystem-frequency-type-code.md),[IdTypes](ValueSet-idTypes.md),[IdTypesDomain](CodeSystem-id-types-domain.md),[InstitutionIdType](ValueSet-InstitutionIdType.md),[InstitutionIdTypeCode](CodeSystem-institution-id-type-code.md),[InstitutionType](ValueSet-InstitutionType.md),[InstitutionTypeCode](CodeSystem-institution-type-code.md),[LotNumber](StructureDefinition-lot-number.md),[Manifestation](ValueSet-Manifestation.md),[ManifestationSeverities](ValueSet-ManifestationSeverity.md),[ManifestationSeveritiesCode](CodeSystem-manifestation-severities-code.md),[ManifestationsCode](CodeSystem-manifestations-code.md),[MedicalSpecialities](ValueSet-medicalSpecialities.md),[MedicalSpecialitiesCode](CodeSystem-medical-specialities-code.md),[MedicationAdministrationLine](ValueSet-MedicationAdministrationLine.md),[MedicationDispenseRD](StructureDefinition-medicationDispense.md),[MedicationIngredient](ValueSet-MedicationIngredient.md),[MedicationPharmaceuticalForm](ValueSet-MedicationPharmaceuticalForm.md),[MedicationRD](StructureDefinition-medication.md),[MedicationRequestRD](StructureDefinition-medicationRequest.md),[MedicationStatementRD](StructureDefinition-medication-statement.md),[MedicationUnitsOfMeasure](ValueSet-MedicationUnitsOfMeasure.md),[MedicationUnitsOfMeasureCode](CodeSystem-medication-units-of-measure-code.md),[MicrobiologyAnalysisFamily](ValueSet-MicrobiologyAnalysisFamily.md),[MicrobiologyAnalysisType](ValueSet-microbiologyAnalysisType.md),[Microorganism](ValueSet-Microorganism.md),[MicroorganismCode](CodeSystem-microorganism-code.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md),[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md),[ObservationHeightRD](StructureDefinition-observation-height.md),[ObservationWeightRD](StructureDefinition-observation-weight.md),[OrganizationRD](StructureDefinition-organization.md),[PatientRD](StructureDefinition-patient.md),[PractitionerRD](StructureDefinition-practitioner.md),[PrescriptionCategoriesCode](CodeSystem-prescription-categories-code.md),[PrescriptionCategory](ValueSet-PrescriptionCategory.md),[PrescriptionStatuses](ValueSet-prescriptionStatuses.md),[PrescriptionStatusesCode](CodeSystem-prescription-statuses-code.md),[PrescriptionType](ValueSet-PrescriptionType.md),[PrescriptionTypeCode](CodeSystem-prescription-type-code.md),[PrescriptionTypeExtension](StructureDefinition-prescription-type.md),[ProfessionalType](ValueSet-ProfessionalType.md),[ProfessionalTypeCode](CodeSystem-professional-type-code.md),[Province](ValueSet-Province.md),[ProvincesCode](CodeSystem-provinces-code.md),[RecetaDigitalCR](index.md),[RelatedPersonRD](StructureDefinition-related-person.md),[Snomed](ValueSet-snomed.md),[SnomedCode](CodeSystem-snomed-code.md),[Substances](ValueSet-Substances.md)and[SubstancesCode](CodeSystem-substances-code.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [MedicationRD](StructureDefinition-medication.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[AllergyStatus](ValueSet-AllergyStatus.md),[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md)and[Bundle/BundleRD03](Bundle-BundleRD03.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[AllergyVerification](ValueSet-AllergyVerification.md),[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md)and[Bundle/BundleRD03](Bundle-BundleRD03.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Condition/6283](Condition-6283.md), [ConditionRD](StructureDefinition-condition.md) and [ConditionStatus](ValueSet-conditionStatus.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 4 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Encounter/111766](Encounter-111766.md),[EncounterClass](ValueSet-encounterClass.md)and[EncounterRD](StructureDefinition-encounter.md)


* Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.

* [Catálogo de vías de administración](CodeSystem-administration-lines-code.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 13 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Bundle/BundleRD04](Bundle-BundleRD04.md),[Bundle/BundleRD05](Bundle-BundleRD05.md),[Bundle/BundleRD06](Bundle-BundleRD06.md),[MedicationAdministrationLine](ValueSet-MedicationAdministrationLine.md),[MedicationDispense/2360448](MedicationDispense-2360448.md),[MedicationDispense/2377917](MedicationDispense-2377917.md),[MedicationDispense/2377940](MedicationDispense-2377940.md),[MedicationDispenseRD](StructureDefinition-medicationDispense.md),[MedicationRequest/2360448](MedicationRequest-2360448.md),[MedicationRequest/2369982](MedicationRequest-2369982.md),[MedicationRequest/2377815](MedicationRequest-2377815.md)and[MedicationRequestRD](StructureDefinition-medicationRequest.md)
* [Catálogo de criticidades de alergias](CodeSystem-allergy-criticalities-code.md): [AllergyCriticality](ValueSet-AllergyCriticality.md)
* [Catálogo de tipos de alergias](CodeSystem-allergy-types-code.md): [AllergyType](ValueSet-AllergyType.md)
* [Catálogo de familias de análisis microbiológico](CodeSystem-analysis-family-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MicrobiologyAnalysisFamily](ValueSet-MicrobiologyAnalysisFamily.md), [Observation/268](Observation-268.md) and [ObservationFrotisRD](StructureDefinition-observation-frotis.md)
* [Catálogo de tipos de análisis microbiológico](CodeSystem-analysis-types-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MicrobiologyAnalysisType](ValueSet-microbiologyAnalysisType.md)...Show 8 more,[Observation/125](Observation-125.md),[Observation/268](Observation-268.md),[Observation/271](Observation-271.md),[Observation/521](Observation-521.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md)and[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md)
* [Catálogo de sensibilidades a los antibióticos gram negativas](CodeSystem-antibiotic-sensitivity-gram-negatives-code.md): [AntibioticSensitivityGramNegative](ValueSet-AntibioticSensitivityGramNegative.md), [Bundle/BundleRD03](Bundle-BundleRD03.md), [Observation/125](Observation-125.md) and [ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md)
* [Catálogo de sensibilidades a los antibióticos gram positivos](CodeSystem-antibiotic-sensitivity-gram-positives-code.md): [AntibioticSensitivityGramPositive](ValueSet-AntibioticSensitivityGramPositive.md), [Bundle/BundleRD03](Bundle-BundleRD03.md), [Observation/521](Observation-521.md) and [ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md)
* [Cátalogo nacional de cantones](CodeSystem-cities-code.md): [City](ValueSet-City.md)
* [Catálogo de categorias de condiciones](CodeSystem-condition-categories-code.md): [ConditionCategory](ValueSet-conditionCategory.md) and [ConditionRD](StructureDefinition-condition.md)
* [Catálogo de diagnósticos de condiciones](CodeSystem-condition-diagnostics-code.md): [Condition/6283](Condition-6283.md), [ConditionDiagnostic](ValueSet-conditionDiagnostic.md) and [ConditionRD](StructureDefinition-condition.md)
* [Catálogo de unidades de administración de despacho](CodeSystem-despatch-administration-unit-code.md): [DespatchAdministrationUnit](ValueSet-DespatchAdministrationUnit.md)
* [Catálogo de estados de dispensación](CodeSystem-dispense-status-code.md): [DispenseStatus](ValueSet-DispenseStatus.md)
* [Cátalogo nacional de distritos](CodeSystem-districts-code.md): [District](ValueSet-District.md)
* [Catálogo de sugerencias de una dosis](CodeSystem-dose-suggestions-code.md): [DoseSuggestion](ValueSet-DoseSuggestion.md)
* [Catálogo de ingredientes de un medicamento](CodeSystem-drugs-compound-code.md): [MedicationIngredient](ValueSet-MedicationIngredient.md) and [MedicationRD](StructureDefinition-medication.md)
* [Catálogo de formas farmacéuticas de medicamento](CodeSystem-drugs-presentation-code.md): [MedicationPharmaceuticalForm](ValueSet-MedicationPharmaceuticalForm.md) and [MedicationRD](StructureDefinition-medication.md)
* [Catálogo de frecuencias](CodeSystem-frequency-code.md): [Frequency](ValueSet-Frequency.md)
* [Catálogo de duración de las frecuencias](CodeSystem-frequency-duration-code.md): [FrequencyDuration](ValueSet-FrequencyDuration.md)
* [Catálogo de tipos de frecuencias](CodeSystem-frequency-type-code.md): [FrequencyType](ValueSet-FrequencyType.md)
* [Dominio de Identificación](CodeSystem-id-types-domain.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 11 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Bundle/BundleRD04](Bundle-BundleRD04.md),[Bundle/BundleRD05](Bundle-BundleRD05.md),[Bundle/BundleRD06](Bundle-BundleRD06.md),[IdTypes](ValueSet-idTypes.md),[Patient/98015](Patient-98015.md),[PatientRD](StructureDefinition-patient.md),[Practitioner/3092](Practitioner-3092.md),[PractitionerRD](StructureDefinition-practitioner.md),[RelatedPerson/65198](RelatedPerson-65198.md)and[RelatedPersonRD](StructureDefinition-related-person.md)
* [Catálogo de tipos de identificación para instituciones](CodeSystem-institution-id-type-code.md): [CENTRO MEDICO CCSS](Organization-12102.md), [Consultorio Particular de MARIA JOSE ARRIETA](Organization-3092.md), [InstitutionIdType](ValueSet-InstitutionIdType.md) and [OrganizationRD](StructureDefinition-organization.md)
* [Catálogo de tipos de instituciones](CodeSystem-institution-type-code.md): [CENTRO MEDICO CCSS](Organization-12102.md), [Consultorio Particular de MARIA JOSE ARRIETA](Organization-3092.md), [InstitutionType](ValueSet-InstitutionType.md) and [OrganizationRD](StructureDefinition-organization.md)
* [Catálogo de severidad de manifestación de alergias](CodeSystem-manifestation-severities-code.md): [ManifestationSeverities](ValueSet-ManifestationSeverity.md)
* [Catálogo de manifestación de alergias](CodeSystem-manifestations-code.md): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md),[Bundle/BundleRD03](Bundle-BundleRD03.md)and[Manifestation](ValueSet-Manifestation.md)
* [Catálogo de especialidades médicas](CodeSystem-medical-specialities-code.md): [MedicalSpecialities](ValueSet-medicalSpecialities.md)
* [Catálogo de unidades de medida de un medicamento](CodeSystem-medication-units-of-measure-code.md): [MedicationUnitsOfMeasure](ValueSet-MedicationUnitsOfMeasure.md)
* [Catálogo de microorganismos](CodeSystem-microorganism-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [Microorganism](ValueSet-Microorganism.md), [Observation/271](Observation-271.md) and [ObservationCultiveRD](StructureDefinition-observation-cultive.md)
* [Catálogo de categorías de receta](CodeSystem-prescription-categories-code.md): [Bundle/BundleRD03](Bundle-BundleRD03.md), [MedicationRequest/2377815](MedicationRequest-2377815.md), [MedicationRequestRD](StructureDefinition-medicationRequest.md) and [PrescriptionCategory](ValueSet-PrescriptionCategory.md)
* [Catálogo de estados de las prescripciones](CodeSystem-prescription-statuses-code.md): [PrescriptionStatuses](ValueSet-prescriptionStatuses.md)
* [Catálogo de tipos de recetas](CodeSystem-prescription-type-code.md): [PrescriptionType](ValueSet-PrescriptionType.md) and [PrescriptionTypeExtension](StructureDefinition-prescription-type.md)
* [Catálogo de tipos de profesional](CodeSystem-professional-type-code.md): [ProfessionalType](ValueSet-ProfessionalType.md)
* [Cátalogo nacional de provincias](CodeSystem-provinces-code.md): [Province](ValueSet-Province.md)
* [Catálogo de codigos snomed](CodeSystem-snomed-code.md): [Bundle/BundleRD01](Bundle-BundleRD01.md), [Bundle/BundleRD02](Bundle-BundleRD02.md)...Show 14 more,[Bundle/BundleRD03](Bundle-BundleRD03.md),[Observation/125](Observation-125.md),[Observation/268](Observation-268.md),[Observation/271](Observation-271.md),[Observation/2721](Observation-2721.md),[Observation/2722](Observation-2722.md),[Observation/521](Observation-521.md),[ObservationCultiveRD](StructureDefinition-observation-cultive.md),[ObservationFrotisRD](StructureDefinition-observation-frotis.md),[ObservationGramNegativeRD](StructureDefinition-observation-gram-negative.md),[ObservationGramPositiveRD](StructureDefinition-observation-gram-positive.md),[ObservationHeightRD](StructureDefinition-observation-height.md),[ObservationWeightRD](StructureDefinition-observation-weight.md)and[Snomed](ValueSet-snomed.md)
* [Catálogo de substancias](CodeSystem-substances-code.md): [AllergyIntolerance/4070](AllergyIntolerance-4070.md), [AllergyIntoleranceRD](StructureDefinition-allergy-intolerance.md)...Show 4 more,[Bundle/BundleRD01](Bundle-BundleRD01.md),[Bundle/BundleRD02](Bundle-BundleRD02.md),[Bundle/BundleRD03](Bundle-BundleRD03.md)and[Substances](ValueSet-Substances.md)


### Consideraciones sobre Propiedad Intelectual

 Si bien esta guía de implementación y el FHIR subyacente tienen licencia de dominio público, esta guía puede incluir ejemplos que utilicen terminologías como LOINC, SNOMED CT y otras que tienen requisitos de licencia más restrictivos. Los implementadores deben familiarizarse con las licencias y cualquier otra restricción de las terminologías, cuestionarios y otros componentes utilizados como parte de su proceso de implementación. En algunos casos, los requisitos de licencia pueden limitar los sistemas con los que se pueden compartir los datos capturados mediante ciertos cuestionarios. 

-------

### Autores:

* [Ministerio de Salud Costa Rica](https://www.ministeriodesalud.go.cr/)
* [RACSA](https://www.racsa.go.cr/)



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cr.minsa.sard",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "https://ministeriodesalud.go.cr/fhir/receta/ImplementationGuide/hl7.fhir.cr.minsa.sard",
  "version" : "1.1.0-ballot",
  "name" : "RecetaDigitalCR",
  "title" : "Guías de Implementación FHIR Receta Digital | Ministerio de Salud",
  "status" : "draft",
  "date" : "2025-10-22T15:53:28-06:00",
  "publisher" : "Ministerio de Salud de Costa Rica",
  "contact" : [
    {
      "name" : "Ministerio de Salud de Costa Rica",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ministeriodesalud.go.cr/fhir"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CR",
          "display" : "Costa Rica"
        }
      ]
    }
  ],
  "copyright" : "Utilizado con permiso de HL7 International, todos los derechos reservados Licencia Creative Commons",
  "packageId" : "hl7.fhir.cr.minsa.sard",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://ministeriodesalud.go.cr/fhir/receta/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://ministeriodesalud.go.cr/fhir/receta/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/4070"
        },
        "name" : "Alergia - Paciente Nacional",
        "description" : "Alergia de Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/allergy-intolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/allergy-intolerance"
        },
        "name" : "AllergyIntolerance",
        "description" : "Perfil Receta Digital de Alergias e Intolerancias (AllergyIntolerance)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD06"
        },
        "name" : "Bundle - Despacho Antimicrobianos",
        "description" : "Bundle de Despacho de Tipo Antimicrobianos",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD04"
        },
        "name" : "Bundle - Despacho Estupefacientes",
        "description" : "Bundle de Despacho de Tipo Estupefacientes",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD05"
        },
        "name" : "Bundle - Despacho Psicotrópicos",
        "description" : "Bundle de Despacho de Tipo Psicotrópicos",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD03"
        },
        "name" : "Bundle - Prescripción Antimicrobianos",
        "description" : "Bundle de Prescripción de Tipo Antimicrobianos",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD01"
        },
        "name" : "Bundle - Prescripción Estupefacientes",
        "description" : "Bundle de Prescripción de Tipo Estupefacientes",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleRD02"
        },
        "name" : "Bundle - Prescripción Psicotrópicos",
        "description" : "Bundle de Prescripción de Tipo Psicotrópicos",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergy-categories-code"
        },
        "name" : "Catálogo de categorias de alergias",
        "description" : "Catálogo de categorias de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-categories-code"
        },
        "name" : "Catálogo de categorias de condiciones",
        "description" : "Catálogo de categorias de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/prescription-categories-code"
        },
        "name" : "Catálogo de categorías de receta",
        "description" : "Catálogo de categorías de receta en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encounter-class-code"
        },
        "name" : "Catálogo de clases de encuentros",
        "description" : "Catálogo de clases de encuentros en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/snomed-code"
        },
        "name" : "Catálogo de codigos snomed",
        "description" : "Catálogo de codigos snomed",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergy-criticalities-code"
        },
        "name" : "Catálogo de criticidades de alergias",
        "description" : "Catálogo de criticidades de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-diagnostics-code"
        },
        "name" : "Catálogo de diagnósticos de condiciones",
        "description" : "Catálogo de diagnósticos de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/frequency-duration-code"
        },
        "name" : "Catálogo de duración de las frecuencias",
        "description" : "Catálogo de duración de las frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medical-specialities-code"
        },
        "name" : "Catálogo de especialidades médicas",
        "description" : "Catálogo de especialidades médicas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergy-statuses-code"
        },
        "name" : "Catálogo de estados de alergias",
        "description" : "Catálogo de estados de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-statuses-code"
        },
        "name" : "Catálogo de estados de condiciones",
        "description" : "Catálogo de estados de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dispense-status-code"
        },
        "name" : "Catálogo de estados de dispensación",
        "description" : "Catálogo de estados de dispensación en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encounter-status-code"
        },
        "name" : "Catálogo de estados de encuentros",
        "description" : "Catálogo de estados de encuentros en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/prescription-statuses-code"
        },
        "name" : "Catálogo de estados de las prescripciones",
        "description" : "Catálogo de estados de las prescripciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/analysis-family-code"
        },
        "name" : "Catálogo de familias de análisis microbiológico",
        "description" : "Catálogo de familias de análisis microbiológico en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drugs-presentation-code"
        },
        "name" : "Catálogo de formas farmacéuticas de medicamento",
        "description" : "Catálogo de formas farmacéuticas de medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/frequency-code"
        },
        "name" : "Catálogo de frecuencias",
        "description" : "Catálogo de frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drugs-compound-code"
        },
        "name" : "Catálogo de ingredientes de un medicamento",
        "description" : "Catálogo de ingredientes de un medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/manifestations-code"
        },
        "name" : "Catálogo de manifestación de alergias",
        "description" : "Catálogo de manifestación de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/microorganism-code"
        },
        "name" : "Catálogo de microorganismos",
        "description" : "Catálogo de microorganismos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/antibiotic-sensitivity-gram-negatives-code"
        },
        "name" : "Catálogo de sensibilidades a los antibióticos gram negativas",
        "description" : "Catálogo de sensibilidades a los antibióticos gram negativas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/antibiotic-sensitivity-gram-positives-code"
        },
        "name" : "Catálogo de sensibilidades a los antibióticos gram positivos",
        "description" : "Catálogo de sensibilidades a los antibióticos gram positivos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/manifestation-severities-code"
        },
        "name" : "Catálogo de severidad de manifestación de alergias",
        "description" : "Catálogo de severidad de manifestación de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/substances-code"
        },
        "name" : "Catálogo de substancias",
        "description" : "Catálogo de substancias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dose-suggestions-code"
        },
        "name" : "Catálogo de sugerencias de una dosis",
        "description" : "Catálogo de sugerencias de una dosis en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergy-types-code"
        },
        "name" : "Catálogo de tipos de alergias",
        "description" : "Catálogo de tipos de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/analysis-types-code"
        },
        "name" : "Catálogo de tipos de análisis microbiológico",
        "description" : "Catálogo de tipos de análisis microbiológico en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/frequency-type-code"
        },
        "name" : "Catálogo de tipos de frecuencias",
        "description" : "Catálogo de tipos de frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/institution-id-type-code"
        },
        "name" : "Catálogo de tipos de identificación para instituciones",
        "description" : "Catálogo de tipos de identificación para instituciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/institution-type-code"
        },
        "name" : "Catálogo de tipos de instituciones",
        "description" : "Catálogo de tipos de instituciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/professional-type-code"
        },
        "name" : "Catálogo de tipos de profesional",
        "description" : "Catálogo de tipos de profesional en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/prescription-type-code"
        },
        "name" : "Catálogo de tipos de recetas",
        "description" : "Catálogo de tipos de recetas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/despatch-administration-unit-code"
        },
        "name" : "Catálogo de unidades de administración de despacho",
        "description" : "Catálogo de unidades de administración de despacho en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-units-of-measure-code"
        },
        "name" : "Catálogo de unidades de medida de un medicamento",
        "description" : "Catálogo de unidades de medida de un medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergy-verifications-code"
        },
        "name" : "Catálogo de verificación de alergias",
        "description" : "Catálogo de verificación de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/administration-lines-code"
        },
        "name" : "Catálogo de vías de administración",
        "description" : "Catálogo de vías de administración en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/6283"
        },
        "name" : "Condición - Paciente Nacional",
        "description" : "Condición de Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition"
        },
        "name" : "Condition",
        "description" : "Perfil Receta Digital de Condiciones o Diagnósticos (Condition)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/contact-rd"
        },
        "name" : "Contacto para Receta Digital Costa Rica",
        "description" : "Perfil de contacto (teléfono o email) utilizado en el contexto de la Receta Digital en Costa Rica.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cities-code"
        },
        "name" : "Cátalogo nacional de cantones",
        "description" : "Cátalogo nacional de cantones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/districts-code"
        },
        "name" : "Cátalogo nacional de distritos",
        "description" : "Cátalogo nacional de distritos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/provinces-code"
        },
        "name" : "Cátalogo nacional de provincias",
        "description" : "Cátalogo nacional de provincias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/104221"
        },
        "name" : "Declaración - Alprazolam",
        "description" : "Declaración de Toma de Medicamento con Alprazolam",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/108729"
        },
        "name" : "Declaración - Amoxicilina",
        "description" : "Declaración de Toma de Medicamento con Amoxicilina",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/106740"
        },
        "name" : "Declaración - Metilfenidato",
        "description" : "Declaración de Toma de Medicamento con Metilfenidato",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/2360448"
        },
        "name" : "Despacho - Alprazolam",
        "description" : "Despacho con Alprazolam",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/2377940"
        },
        "name" : "Despacho - Amoxicilina",
        "description" : "Despacho con Amoxicilina",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/2377917"
        },
        "name" : "Despacho - Metilfenidato",
        "description" : "Despacho con Metilfenidato",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/address-rd"
        },
        "name" : "Dirección para Receta Digital Costa Rica",
        "description" : "Perfil de Dirección utilizado en el contexto de la Receta Digital en Costa Rica.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/id-types-domain"
        },
        "name" : "Dominio de Identificación",
        "description" : "Dominio de identificación posibles y existentes en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/encounter"
        },
        "name" : "Encounter",
        "description" : "Perfil Receta Digital de Encuentro Clínico (Encounter)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/111766"
        },
        "name" : "Encuentro - Paciente Nacional",
        "description" : "Encuentro de Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/lot-number"
        },
        "name" : "Información del lote del medicamento",
        "description" : "Extensión compuesta que incluye número de lote y cantidad.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/City"
        },
        "name" : "Listado de cantones",
        "description" : "Listado de cantones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allergyCategory"
        },
        "name" : "Listado de categorias de alergias",
        "description" : "Listado de categorias de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/conditionCategory"
        },
        "name" : "Listado de categorias de condiciones",
        "description" : "Listado de categorias de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PrescriptionCategory"
        },
        "name" : "Listado de categorías de receta",
        "description" : "Listado de categorías de receta en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounterClass"
        },
        "name" : "Listado de clases de encuentros",
        "description" : "Listado de clases de encuentros en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/snomed"
        },
        "name" : "Listado de codigos snomed",
        "description" : "Listado de codigos snomed",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AllergyCriticality"
        },
        "name" : "Listado de criticidades de alergias",
        "description" : "Listado de criticidades de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/conditionDiagnostic"
        },
        "name" : "Listado de diagnósticos de condiciones",
        "description" : "Listado de diagnósticos de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/District"
        },
        "name" : "Listado de distritos",
        "description" : "Listado de distritos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/FrequencyDuration"
        },
        "name" : "Listado de duración de las frecuencias",
        "description" : "Listado de duración de las frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicalSpecialities"
        },
        "name" : "Listado de especialidades médicas",
        "description" : "Listado de especialidades médicas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AllergyStatus"
        },
        "name" : "Listado de estados de alergias",
        "description" : "Listado de estados de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/conditionStatus"
        },
        "name" : "Listado de estados de condiciones",
        "description" : "Listado de estados de condiciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DispenseStatus"
        },
        "name" : "Listado de estados de dispensación",
        "description" : "Listado de estados de dispensación en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounterStatus"
        },
        "name" : "Listado de estados de encuentros",
        "description" : "Listado de estados de encuentros en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/prescriptionStatuses"
        },
        "name" : "Listado de estados de las prescripciones",
        "description" : "Listado de estados de las prescripciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/MicrobiologyAnalysisFamily"
        },
        "name" : "Listado de familias de análisis microbiológico",
        "description" : "Listado de familias de análisis microbiológico en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/MedicationPharmaceuticalForm"
        },
        "name" : "Listado de formas farmacéuticas de medicamento",
        "description" : "Listado de formas farmacéuticas de medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Frequency"
        },
        "name" : "Listado de frecuencias",
        "description" : "Listado de frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/MedicationIngredient"
        },
        "name" : "Listado de ingredientes de un medicamento",
        "description" : "Listado de ingredientes de un medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Manifestation"
        },
        "name" : "Listado de manifestaciones de alergias",
        "description" : "Listado de manifestaciones de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Microorganism"
        },
        "name" : "Listado de microorganismos",
        "description" : "Listado de microorganismos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Province"
        },
        "name" : "Listado de provincias",
        "description" : "Listado de provincias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AntibioticSensitivityGramNegative"
        },
        "name" : "Listado de sensibilidades a los antibióticos gram negativas",
        "description" : "Listado de sensibilidades a los antibióticos gram negativas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AntibioticSensitivityGramPositive"
        },
        "name" : "Listado de sensibilidades a los antibióticos gram positivos",
        "description" : "Listado de sensibilidades a los antibióticos gram positivos en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ManifestationSeverity"
        },
        "name" : "Listado de severidades de manifestación de alergias",
        "description" : "Listado de severidades de manifestación de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Substances"
        },
        "name" : "Listado de substancias",
        "description" : "Listado de substancias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DoseSuggestion"
        },
        "name" : "Listado de sugerencias de una dosis",
        "description" : "Listado de sugerencias de una dosis en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AllergyType"
        },
        "name" : "Listado de tipos de alergias",
        "description" : "Listado de tipos de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/microbiologyAnalysisType"
        },
        "name" : "Listado de tipos de análisis microbiológico",
        "description" : "Listado de tipos de análisis microbiológico en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/FrequencyType"
        },
        "name" : "Listado de tipos de frecuencias",
        "description" : "Listado de tipos de frecuencias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/InstitutionIdType"
        },
        "name" : "Listado de tipos de identificación para instituciones",
        "description" : "Listado de tipos de identificación para instituciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/InstitutionType"
        },
        "name" : "Listado de tipos de instituciones",
        "description" : "Listado de tipos de instituciones en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ProfessionalType"
        },
        "name" : "Listado de tipos de profesional",
        "description" : "Listado de tipos de profesional en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PrescriptionType"
        },
        "name" : "Listado de tipos de recetas",
        "description" : "Listado de tipos de recetas en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DespatchAdministrationUnit"
        },
        "name" : "Listado de unidades de administración de despacho",
        "description" : "Listado de unidades de administración de despacho en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/MedicationUnitsOfMeasure"
        },
        "name" : "Listado de unidades de medida de un medicamento",
        "description" : "Listado de unidades de medida de un medicamento en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AllergyVerification"
        },
        "name" : "Listado de verificaciones de alergias",
        "description" : "Listado de verificaciones de alergias en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/MedicationAdministrationLine"
        },
        "name" : "Listado de vías de administración",
        "description" : "Listado de vías de administración en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/539"
        },
        "name" : "Medicamento - Alprazolam",
        "description" : "Medicamento con Alprazolam",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/1053"
        },
        "name" : "Medicamento - Amoxicilina",
        "description" : "Medicamento con Amoxicilina",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/513"
        },
        "name" : "Medicamento - Metilfenidato",
        "description" : "Medicamento con Metilfenidato",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication"
        },
        "name" : "Medication",
        "description" : "Perfil Receta Digital de Medicamentos (Medication)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationDispense"
        },
        "name" : "MedicationDispense",
        "description" : "Perfil Receta Digital de Despacho para un Medicamento (MedicationDispense)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationRequest"
        },
        "name" : "MedicationRequest",
        "description" : "Perfil Receta Digital de Prescripción para un Medicamento (MedicationRequest)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-statement"
        },
        "name" : "MedicationStatement",
        "description" : "Perfil Receta Digital de Declaración de Medicación (MedicationStatement)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/271"
        },
        "name" : "Observación - Análisis Microbiológico Cultivo",
        "description" : "Observación de Análisis Microbiológico Tipo Cultivo",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-cultive"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/268"
        },
        "name" : "Observación - Análisis Microbiológico Frotis",
        "description" : "Observación de Análisis Microbiológico Tipo Frotis",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-frotis"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/125"
        },
        "name" : "Observación - Análisis Microbiológico Gram Negativo",
        "description" : "Observación de Análisis Microbiológico Tipo Gram Negativo",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-gram-negative"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/521"
        },
        "name" : "Observación - Análisis Microbiológico Gram Positivo",
        "description" : "Observación de Análisis Microbiológico Tipo Gram Positivo",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-gram-positive"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/2722"
        },
        "name" : "Observación - Peso Paciente Nacional",
        "description" : "Observación del Peso de Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-weight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/2721"
        },
        "name" : "Observación - Talla Paciente Nacional",
        "description" : "Observación de la Talla de Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/observation-height"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-cultive"
        },
        "name" : "Observation (Análisis microbiológico de tipo cultivo)",
        "description" : "Perfil Receta Digital de Observaciones de análisis microbiológico tipo cultivo (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-frotis"
        },
        "name" : "Observation (Análisis microbiológico de tipo frotis)",
        "description" : "Perfil Receta Digital de Observaciones de análisis microbiológico tipo frotis (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-gram-negative"
        },
        "name" : "Observation (Análisis microbiológico de tipo gram negativo)",
        "description" : "Perfil Receta Digital de Observaciones de análisis microbiológico tipo gram negativo (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-gram-positive"
        },
        "name" : "Observation (Análisis microbiológico de tipo gram positivo)",
        "description" : "Perfil Receta Digital de Observaciones de análisis microbiológico tipo gram positivo (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-weight"
        },
        "name" : "Observation (Peso)",
        "description" : "Perfil Receta Digital de Observaciones de Peso (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-height"
        },
        "name" : "Observation (Talla)",
        "description" : "Perfil Receta Digital de Observaciones de Talla (Observation)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/12102"
        },
        "name" : "Organización - CENTRO MEDICO CCSS",
        "description" : "CENTRO MEDICO CCSS",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/3092"
        },
        "name" : "Organización - Consultorio Particular",
        "description" : "Consultorio Particular",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization"
        },
        "name" : "Organization",
        "description" : "Perfil Receta Digital de Organizaciones (Organization)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/98015"
        },
        "name" : "Paciente - Nacional",
        "description" : "Paciente Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bundle"
        },
        "name" : "Paquete de Recursos",
        "description" : "Perfil Receta Digital de Paquete de Recursos (Bundle)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient"
        },
        "name" : "Patient",
        "description" : "Perfil Receta Digital de Paciente (Patient)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/65198"
        },
        "name" : "Personal Relacionada - Nacional",
        "description" : "Personal Relacionada Nacional",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/related-person"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner"
        },
        "name" : "Practitioner",
        "description" : "Perfil Receta Digital de Profesional de Salud (Practitioner)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/2360448"
        },
        "name" : "Prescripción - Alprazolam",
        "description" : "Prescripción con Alprazolam",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/2377815"
        },
        "name" : "Prescripción - Amoxicilina",
        "description" : "Prescripción con Amoxicilina",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/2369982"
        },
        "name" : "Prescripción - Metilfenidato",
        "description" : "Prescripción con Metilfenidato",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/medicationRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/3092"
        },
        "name" : "Profesional - Consultorio Particular",
        "description" : "Profesional con Consultorio Particular",
        "exampleCanonical" : "https://ministeriodesalud.go.cr/fhir/receta/StructureDefinition/practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/related-person"
        },
        "name" : "RelatedPerson",
        "description" : "Perfil Receta Digital de Persona Relacionada (RelatedPerson)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/idTypes"
        },
        "name" : "Tipo de identificación",
        "description" : "Tipo de identificación posibles y existentes en Receta Digital",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/prescription-type"
        },
        "name" : "Tipo de receta",
        "description" : "Clasificación de la receta según el régimen correspondiente (por ejemplo, r-a, r-v, r-b, r-am, ATM)",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Inicio",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "objetivos.html"
            }
          ],
          "nameUrl" : "objetivos.html",
          "title" : "Objetivos",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "generalidades.html"
            }
          ],
          "nameUrl" : "generalidades.html",
          "title" : "Generalidades",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "descargas.html"
            }
          ],
          "nameUrl" : "descargas.html",
          "title" : "Descargas",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
